#!/bin/bash

SCRIPT_PATH=$(dirname $0)

cd $SCRIPT_PATH
source _components_to_package.sh

# Build debian/control file
echo "# -- This file was generated automatically by the debian/scripts/$(basename $0) script --" > ../control
echo "# -- Update control.in & *.control.in files instead --" >> ../control
cat ../control.in >> ../control

for version in ${PLATFORMS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f2)
    VERBIS=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | cut -d "-" -f2 | tr '[:upper:]' '[:lower:]')
    if [ "$VERBIS" != "$VER" ]; then VER="$VER-$VERBIS"; fi
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../platform.control.in >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${BUILD_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    VER_MAJOR=$(echo $VER | cut -d . -f 1)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    if [ $VER_MAJOR -le 23 ]; then
        sed "s/%VER%/$VER/g" ../build-tools.control-32bits.in >> $TMPFILE
    else
        sed "s/%VER%/$VER/g" ../build-tools.control.in >> $TMPFILE
    fi
    # Remove from "Provides:" the binaries that are not in this version
    MISSING_BIN=$(sed -n "/$VER/{n;p}" ../build-tools.alternatives.in | cut -d ' ' -f 2)
    for bin in $MISSING_BIN; do
      sed -i "/Provides:/ s/$bin,\s*//g" $TMPFILE
    done
    sed -i "s/%VER_MAJOR%/$VER_MAJOR/g" $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${PATCHER_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | tr -d 'v')
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../patcher.control.in >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${CMDLINE_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../cmdline-tools.control.in >> $TMPFILE
    # Remove from "Provides:" the binaries that are not in this version
    MISSING_BIN=$(sed -n "/$VER/{n;p}" ../cmdline-tools.alternatives.in | cut -d ' ' -f 2)
    for bin in $MISSING_BIN; do
      sed -i "/Provides:/ s/$bin,\s*//g" $TMPFILE
    done
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${PLATFORM_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../platform-tools.control.in >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${NDK_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER_LONG=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    VER_MAJOR=$(echo $VER_LONG | cut -d . -f 1)
    VER=r$(echo $VER_LONG | cut -d . -f 1)$(echo $VER_LONG | cut -d . -f 2 | tr '[1-9]' '[b-z]' | tr -d '0')
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    if [ $VER_MAJOR -eq 10 ]; then
        # NDK r10 Depends on "file"
        CONTROL_IN="../ndk-r10.control.in"
    else
        CONTROL_IN="../ndk.control.in"
    fi
    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" $CONTROL_IN >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${SOURCES_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | cut -d '-' -f2)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../sources.control.in >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${EMULATOR_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    sed "s/%VER%/$VER/g" ../emulator.control.in >> $TMPFILE
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done

for version in ${EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PACKAGE_DISPLAY_NAME=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f4)
    ZIPSIZE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f6)
    ZIPFILE=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f7)

    TMPFILE=$(mktemp)
    if [ "$VER" = "1.1" ]; then
        sed "s/%VER%/$VER/g" ../extras-google-auto.control-v1.1.in >> $TMPFILE
    else
        sed "s/%VER%/$VER/g" ../extras-google-auto.control.in >> $TMPFILE
    fi
    sed -i "s/%PACKAGE_DISPLAY_NAME%/$PACKAGE_DISPLAY_NAME/g" $TMPFILE
    sed -i "s/%ZIPFILE%/$ZIPFILE/g" $TMPFILE
    sed -i "s/%MB_SIZE%/$(expr $ZIPSIZE / 1000000)/g" $TMPFILE
    echo "" >> ../control
    cat $TMPFILE >> ../control
    rm $TMPFILE ;\
done
