/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.util.ClassUtil;
import java.io.Serializable;

public class SerializationContext
implements Serializable {
    static final long serialVersionUID = -8260273707611027509L;
    public boolean legacyXMLDocument;
    public boolean legacyXMLNamespaces;
    public boolean legacyCollection;
    public boolean legacyMap;
    public boolean legacyThrowable;
    public boolean legacyBigNumbers;
    public boolean restoreReferences;
    public boolean supportRemoteClass;
    public boolean supportDatesByReference;
    public boolean enableSmallMessages = true;
    public boolean instantiateTypes = true;
    public boolean ignorePropertyErrors = true;
    public boolean logPropertyErrors = false;
    private Class deserializer;
    private Class serializer;
    private static ThreadLocal contexts = new ThreadLocal();

    public Class getDeserializerClass() {
        return this.deserializer;
    }

    public void setDeserializerClass(Class c) {
        this.deserializer = c;
    }

    public Class getSerializerClass() {
        return this.serializer;
    }

    public void setSerializerClass(Class c) {
        this.serializer = c;
    }

    public MessageDeserializer newMessageDeserializer() {
        MessageDeserializer deserializer = (MessageDeserializer)ClassUtil.createDefaultInstance(this.getDeserializerClass(), MessageDeserializer.class);
        return deserializer;
    }

    public MessageSerializer newMessageSerializer() {
        MessageSerializer serializer = (MessageSerializer)ClassUtil.createDefaultInstance(this.getSerializerClass(), MessageSerializer.class);
        return serializer;
    }

    public Object clone() {
        SerializationContext context = new SerializationContext();
        context.legacyXMLDocument = this.legacyXMLDocument;
        context.legacyXMLNamespaces = this.legacyXMLNamespaces;
        context.legacyCollection = this.legacyCollection;
        context.legacyMap = this.legacyMap;
        context.legacyThrowable = this.legacyThrowable;
        context.legacyBigNumbers = this.legacyBigNumbers;
        context.restoreReferences = this.restoreReferences;
        context.supportRemoteClass = this.supportRemoteClass;
        context.supportDatesByReference = this.supportDatesByReference;
        context.instantiateTypes = this.instantiateTypes;
        context.ignorePropertyErrors = this.ignorePropertyErrors;
        context.logPropertyErrors = this.logPropertyErrors;
        context.deserializer = this.deserializer;
        context.serializer = this.serializer;
        return context;
    }

    public static void setSerializationContext(SerializationContext context) {
        contexts.set(context);
    }

    public static SerializationContext getSerializationContext() {
        SerializationContext sc = (SerializationContext)contexts.get();
        if (sc == null) {
            sc = new SerializationContext();
            SerializationContext.setSerializationContext(sc);
        }
        return sc;
    }
}

