/*----- PROTECTED REGION ID(AccessControlStateMachine.cpp) ENABLED START -----*/
static const char *RcsId = "$Id$";
//=============================================================================
//
// file :        AccessControlStateMachine.cpp
//
// description : C++ source for the name and its alowed
//               methods for commands and attributes
//
// project :     Access Control abstract class.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// $Author$
//
// $Revision$
// $Date$
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source$
// $Log$
// Revision 1.4  2011/02/11 14:20:27  pascal_verdier
// GetAccessForMutiIP  command added.
//
// Revision 1.3  2011/02/11 13:43:12  pascal_verdier
// Pogo-7 compatibility.
//
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================



#include <AccessControl.h>
#include <AccessControlClass.h>

/*----- PROTECTED REGION END -----*/	//	AccessControl::AccessControlStateMachine.cpp

//================================================================
//  States  |  Description
//================================================================
//  ON      |  The MySql database handle is OK.
//  FAULT   |  The MySql database handle is not OK.


namespace AccessControl_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================


//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_AddAddressForUser_allowed()
 *	Description : Execution allowed for AddAddressForUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_AddAddressForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::AddAddressForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::AddAddressForUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_AddDeviceForUser_allowed()
 *	Description : Execution allowed for AddDeviceForUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_AddDeviceForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::AddDeviceForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::AddDeviceForUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_CloneUser_allowed()
 *	Description : Execution allowed for CloneUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_CloneUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::CloneUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::CloneUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAccess_allowed()
 *	Description : Execution allowed for GetAccess attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetAccess_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for GetAccess command.
	/*----- PROTECTED REGION ID(AccessControl::GetAccessStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAccessStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAccessForMultiIP_allowed()
 *	Description : Execution allowed for GetAccessForMultiIP attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetAccessForMultiIP_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for GetAccessForMultiIP command.
	/*----- PROTECTED REGION ID(AccessControl::GetAccessForMultiIPStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAccessForMultiIPStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAddressByUser_allowed()
 *	Description : Execution allowed for GetAddressByUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetAddressByUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::GetAddressByUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAddressByUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetAllowedCommands_allowed()
 *	Description : Execution allowed for GetAllowedCommands attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetAllowedCommands_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::GetAllowedCommandsStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetAllowedCommandsStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetDeviceByUser_allowed()
 *	Description : Execution allowed for GetDeviceByUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetDeviceByUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::GetDeviceByUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetDeviceByUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetDeviceClass_allowed()
 *	Description : Execution allowed for GetDeviceClass attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetDeviceClass_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::GetDeviceClassStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetDeviceClassStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_GetUsers_allowed()
 *	Description : Execution allowed for GetUsers attribute
 */
//--------------------------------------------------------
bool AccessControl::is_GetUsers_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::GetUsersStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::GetUsersStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RegisterService_allowed()
 *	Description : Execution allowed for RegisterService attribute
 */
//--------------------------------------------------------
bool AccessControl::is_RegisterService_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for RegisterService command.
	/*----- PROTECTED REGION ID(AccessControl::RegisterServiceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RegisterServiceStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveAddressForUser_allowed()
 *	Description : Execution allowed for RemoveAddressForUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_RemoveAddressForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::RemoveAddressForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveAddressForUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveDeviceForUser_allowed()
 *	Description : Execution allowed for RemoveDeviceForUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_RemoveDeviceForUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::RemoveDeviceForUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveDeviceForUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_RemoveUser_allowed()
 *	Description : Execution allowed for RemoveUser attribute
 */
//--------------------------------------------------------
bool AccessControl::is_RemoveUser_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(AccessControl::RemoveUserStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::RemoveUserStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : AccessControl::is_UnregisterService_allowed()
 *	Description : Execution allowed for UnregisterService attribute
 */
//--------------------------------------------------------
bool AccessControl::is_UnregisterService_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for UnregisterService command.
	/*----- PROTECTED REGION ID(AccessControl::UnregisterServiceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	AccessControl::UnregisterServiceStateAllowed
	return true;
}

}	//	End of namespace
