/*
 * SPDX-License-Identifier: CC0-1.0
 * SPDX-FileCopyrightText: Wikidata contributors
 *
 * This code is auto-generated from Wikidata, do not edit!
 */

#include "knowledgedb.h"
#include "trainstationdb.h"

namespace KItinerary {
namespace KnowledgeDb {
static const TrainStation trainstation_table[] = {
    {Coordinate{19.0886, 47.4686}, CountryId{"HU"}}, // Ferencváros railway station
    {Coordinate{12.2609, 47.4494}, CountryId{"AT"}}, // Q100196045
    {Coordinate{9.95913, 48.825}, CountryId{"DE"}}, // Mögglingen (Gmünd)
    {Coordinate{8.33423, 49.74}, CountryId{"DE"}}, // Mettenheim
    {Coordinate{14.7376, 47.6078}, CountryId{"AT"}}, // Bahnhof Hieflau
    {Coordinate{11.9424, 48.2426}, CountryId{"DE"}}, // Hörlkofen station
    {Coordinate{12.2499, 48.2732}, CountryId{"DE"}}, // Schwindegg station
    {Coordinate{12.5953, 48.2589}, CountryId{"DE"}}, // Töging (Inn) station
    {Coordinate{12.8525, 48.2566}, CountryId{"DE"}}, // Marktl station
    {Coordinate{39.0956, 47.2921}, CountryId{"RU"}}, // Q100324331
    {Coordinate{10.9367, 47.793}, CountryId{"DE"}}, // Peiting Ost station
    {Coordinate{10.9267, 47.8016}, CountryId{"DE"}}, // Peiting Nord station
    {Coordinate{10.9993, 47.7888}, CountryId{"DE"}}, // Hohenpeißenberg station
    {Coordinate{11.0773, 47.8157}, CountryId{"DE"}}, // Peißenberg Nord station
    {Coordinate{}, CountryId{"AT"}}, // Bahnhof St. Andrä am Zicksee
    {Coordinate{75.8931, 19.8308}, CountryId{"IN"}}, // Jalna railway station
    {Coordinate{12.2223, 51.4024}, CountryId{"DE"}}, // Schkeuditz station
    {Coordinate{39.7555, 47.1528}, CountryId{"RU"}}, // Q100522582
    {Coordinate{73.2208, 19.1812}, CountryId{"IN"}}, // Chikhloli Halt railway station
    {Coordinate{88.3952, 22.9724}, CountryId{"IN"}}, // Islampara Halt railway station
    {Coordinate{16.0649, 48.3941}, CountryId{"AT"}}, // Gaisruck halt
    {Coordinate{16.1073, 48.3913}, CountryId{"AT"}}, // Hausleiten halt
    {Coordinate{16.5878, 47.6778}, CountryId{"HU"}}, // Sopron railway station
    {Coordinate{16.3473, 48.3164}, CountryId{"AT"}}, // Bisamberg halt
    {Coordinate{16.0748, 48.5149}, CountryId{"AT"}}, // Breitenwaida halt
    {Coordinate{16.1262, 48.4925}, CountryId{"AT"}}, // Göllersdorf station
    {Coordinate{16.0541, 48.6422}, CountryId{"AT"}}, // Guntersdorf station
    {Coordinate{16.0917, 48.6171}, CountryId{"AT"}}, // Hetzmannsdorf-Wullersdorf station
    {Coordinate{16.1731, 48.4484}, CountryId{"AT"}}, // Höbersdorf halt
    {Coordinate{16.0723, 48.563}, CountryId{"AT"}}, // Hollabrunn station
    {Coordinate{16.3287, 48.3438}, CountryId{"AT"}}, // Korneuburg station
    {Coordinate{16.3559, 48.3066}, CountryId{"AT"}}, // Langenzersdorf halt
    {Coordinate{16.3021, 48.3645}, CountryId{"AT"}}, // Leobendorf-Burg Kreuzenstein halt
    {Coordinate{16.174, 48.4137}, CountryId{"AT"}}, // Ober Olberndorf halt
    {Coordinate{16.1591, 48.4686}, CountryId{"AT"}}, // Schönborn-Mallebarn halt
    {Coordinate{16.1748, 48.4286}, CountryId{"AT"}}, // Sierndorf station
    {Coordinate{16.2571, 48.3757}, CountryId{"AT"}}, // Spillern halt
    {Coordinate{16.3959, 48.274}, CountryId{"AT"}}, // Wien Jedlersdorf station
    {Coordinate{16.3816, 48.2856}, CountryId{"AT"}}, // Wien Strebersdorf station
    {Coordinate{15.9684, 48.6955}, CountryId{"AT"}}, // Zellerndorf station
    {Coordinate{37.6269, 55.171}, CountryId{"RU"}}, // 298 km
    {Coordinate{16.599, 62.4197}, CountryId{"SE"}}, // Stöde
    {Coordinate{37.745, 55.1789}, CountryId{"RU"}}, // Povadino
    {Coordinate{37.7926, 55.1787}, CountryId{"RU"}}, // 309 km
    {Coordinate{10.6838, 43.6573}, CountryId{"IT"}}, // La Rotta railway halt
    {Coordinate{37.841, 55.1725}, CountryId{"RU"}}, // 312 km
    {Coordinate{16.3358, 62.4724}, CountryId{"SE"}}, // Torpshammar
    {Coordinate{16.1686, 62.4958}, CountryId{"SE"}}, // Fränsta
    {Coordinate{16.0678, 62.4956}, CountryId{"SE"}}, // Ljungaverk
    {Coordinate{15.9237, 62.5283}, CountryId{"SE"}}, // Erikslund
    {Coordinate{8.18173, 48.285}, CountryId{"DE"}}, // Hausach station
    {Coordinate{8.48647, 55.4744}, CountryId{"DK"}}, // Jerne Station
    {Coordinate{12.3478, 48.4473}, CountryId{"DE"}}, // Bahnhof Vilsbiburg
    {Coordinate{18.3282, 49.844}, CountryId{"CZ"}}, // Josefova jáma
    {Coordinate{19.1154, 45.7862}, CountryId{"RS"}}, // Sombor railway station
    {Coordinate{19.0938, 47.5166}, CountryId{"HU"}}, // Q102069721
    {Coordinate{37.6432, 55.7175}, CountryId{"RU"}}, // Derbenevskaya
    {Coordinate{18.8323, 46.8327}, CountryId{"HU"}}, // Q102108190
    {Coordinate{18.9126, 46.7931}, CountryId{"HU"}}, // Q102108352
    {Coordinate{18.9266, 46.7296}, CountryId{"HU"}}, // Q102108483
    {Coordinate{18.8806, 46.6686}, CountryId{"HU"}}, // Dunakömlőd railway station
    {Coordinate{19.1143, 47.3745}, CountryId{"HU"}}, // Q102109017
    {Coordinate{16.603, 46.9665}, CountryId{"HU"}}, // Q102109229
    {Coordinate{16.6027, 46.9094}, CountryId{"HU"}}, // Q102109242
    {Coordinate{17.3629, 46.7059}, CountryId{"HU"}}, // Q102139714
    {Coordinate{18.3811, 47.2009}, CountryId{"HU"}}, // Q102143778
    {Coordinate{18.2919, 47.2859}, CountryId{"HU"}}, // Q102144277
    {Coordinate{18.0066, 47.5182}, CountryId{"HU"}}, // Q102144646
    {Coordinate{18.0411, 47.5947}, CountryId{"HU"}}, // Q102145036
    {Coordinate{20.4801, 44.8195}, CountryId{"RS"}}, // Belgrade Dunav station
    {Coordinate{20.2393, 47.1799}, CountryId{"HU"}}, // Q102221162
    {Coordinate{19.2974, 46.8043}, CountryId{"HU"}}, // Q102242726
    {Coordinate{19.3412, 46.8116}, CountryId{"HU"}}, // Q102242921
    {Coordinate{19.3856, 46.8194}, CountryId{"HU"}}, // Q102243074
    {Coordinate{19.4183, 46.837}, CountryId{"HU"}}, // Q102243135
    {Coordinate{19.4563, 46.8442}, CountryId{"HU"}}, // Q102243173
    {Coordinate{19.5203, 46.8527}, CountryId{"HU"}}, // Q102243233
    {Coordinate{19.0239, 46.9709}, CountryId{"HU"}}, // Q102243278
    {Coordinate{19.6161, 46.8559}, CountryId{"HU"}}, // Q102243321
    {Coordinate{18.9803, 46.9203}, CountryId{"HU"}}, // Q102243583
    {Coordinate{18.9778, 46.8864}, CountryId{"HU"}}, // Q102243671
    {Coordinate{19.0044, 46.8449}, CountryId{"HU"}}, // Q102243729
    {Coordinate{19.011, 46.8017}, CountryId{"HU"}}, // Q102243801
    {Coordinate{19.0591, 46.7179}, CountryId{"HU"}}, // Állampuszta railway stop
    {Coordinate{19.0412, 46.6955}, CountryId{"HU"}}, // Q102244174
    {Coordinate{19.0088, 46.6466}, CountryId{"HU"}}, // Q102244336
    {Coordinate{20.2307, 47.7745}, CountryId{"HU"}}, // Q102245229
    {Coordinate{20.3934, 47.8788}, CountryId{"HU"}}, // Q102245359
    {Coordinate{20.3983, 48.1655}, CountryId{"HU"}}, // Q102245605
    {Coordinate{20.3826, 48.1854}, CountryId{"HU"}}, // Q102245654
    {Coordinate{20.3463, 48.217}, CountryId{"HU"}}, // Q102245724
    {Coordinate{20.38, 48.2443}, CountryId{"HU"}}, // Q102245797
    {Coordinate{20.8932, 47.9371}, CountryId{"HU"}}, // Q102246120
    {Coordinate{20.9164, 47.9095}, CountryId{"HU"}}, // Q102246189
    {Coordinate{20.9221, 47.8639}, CountryId{"HU"}}, // Q102246289
    {Coordinate{19.2497, 47.4872}, CountryId{"HU"}}, // Q102246710
    {Coordinate{-0.204444, 48.4578}, CountryId{"FR"}}, // Gare de Pré-en-Pail
    {Coordinate{20.6329, 45.3861}, CountryId{"RS"}}, // Banatski Despotovac railway halt
    {Coordinate{22.2728, 43.905}, CountryId{"RS"}}, // Zaječar railway station
    {Coordinate{38.0316, 55.1181}, CountryId{"RU"}}, // 328 km
    {Coordinate{38.0939, 55.1163}, CountryId{"RU"}}, // 332 km
    {Coordinate{38.2122, 55.1099}, CountryId{"RU"}}, // 341 km
    {Coordinate{38.0922, 55.0278}, CountryId{"RU"}}, // Kolychevo
    {Coordinate{38.0533, 55.0044}, CountryId{"RU"}}, // Shmatovo
    {Coordinate{38.528, 55.188}, CountryId{"RU"}}, // Osyonka
    {Coordinate{0.772811, 45.1721}, CountryId{"FR"}}, // Boulazac Isle Manoire railway station
    {Coordinate{15.1236, 50.1494}, CountryId{"CZ"}}, // Poděbrady (train station)
    {Coordinate{17.1507, 49.4828}, CountryId{"CZ"}}, // Vrahovice
    {Coordinate{-9.09953, 38.7777}, CountryId{"PT"}}, // Moscavide station
    {Coordinate{-8.3124, 41.3791}, CountryId{"PT"}}, // Q10275806
    {Coordinate{141.962, 46.8694}, CountryId{"RU"}}, // Q1032032
    {Coordinate{-0.0209, 51.5051}, CountryId{"GB"}}, // Canary Wharf
    {Coordinate{0.00838889, 51.5139}, CountryId{"GB"}}, // Canning Town
    {Coordinate{12.5325, 57.9269}, CountryId{"SE"}}, // Alingsås railway station
    {Coordinate{-79.3983, 43.7058}, CountryId{"CA"}}, // Eglinton
    {Coordinate{9.88177, 47.7936}, CountryId{"DE"}}, // Kißlegg station
    {Coordinate{12.8451, 50.2223}, CountryId{"CZ"}}, // Karlovy Vary-Aréna
    {Coordinate{12.1164, 55.8102}, CountryId{"DK"}}, // Vinge station
    {Coordinate{10.7782, 50.337}, CountryId{"DE"}}, // Bad Rodach
    {Coordinate{-79.5356, 43.6376}, CountryId{"CA"}}, // Kipling
    {Coordinate{12.8424, 50.8808}, CountryId{"DE"}}, // Wittgensdorf Oberer Bahnhof
    {Coordinate{15.0618, 37.4757}, CountryId{"IT"}}, // Catania Aeroporto Fontanarossa railway halt
    {Coordinate{77.1188, 13.0552}, CountryId{"IN"}}, // Tippasandra railway station
    {Coordinate{77.2587, 13.0698}, CountryId{"IN"}}, // Solur railway station
    {Coordinate{77.3925, 13.1122}, CountryId{"IN"}}, // Nelamangala railway station
    {Coordinate{16.2164, 60.1294}, CountryId{"SE"}}, // Avesta Krylbo railway station
    {Coordinate{77.5163, 15.0134}, CountryId{"IN"}}, // Imampuram railway station
    {Coordinate{77.1948, 14.4149}, CountryId{"IN"}}, // Kadiridevarapalli railway station
    {Coordinate{77.1195, 14.5692}, CountryId{"IN"}}, // Kalyanadurga railway station
    {Coordinate{76.974, 14.6898}, CountryId{"IN"}}, // Avuladatla railway station
    {Coordinate{76.6089, 14.9762}, CountryId{"IN"}}, // Swamihalli railway station
    {Coordinate{76.5996, 15.0561}, CountryId{"IN"}}, // Ranjitpura railway station
    {Coordinate{76.5027, 15.0393}, CountryId{"IN"}}, // Yeshwanthnagar railway station
    {Coordinate{76.4492, 15.1171}, CountryId{"IN"}}, // Ramgad railway station
    {Coordinate{76.3826, 15.1642}, CountryId{"IN"}}, // Gunda Road railway station
    {Coordinate{76.3835, 15.1869}, CountryId{"IN"}}, // Vyasa Colony Junction railway station
    {Coordinate{76.3644, 15.2312}, CountryId{"IN"}}, // Vyasanakeri railway station
    {Coordinate{76.3542, 15.263}, CountryId{"IN"}}, // Tunga Bhadra Dam railway station
    {Coordinate{76.2972, 15.3957}, CountryId{"IN"}}, // Budagumpa railway station
    {Coordinate{76.3686, 15.4245}, CountryId{"IN"}}, // Jabbalguda railway station
    {Coordinate{76.4428, 15.4286}, CountryId{"IN"}}, // Chikkabenakal railway station
    {Coordinate{76.2087, 15.05}, CountryId{"IN"}}, // Hagari Bommanahalli railway station
    {Coordinate{76.119, 14.7876}, CountryId{"IN"}}, // Bennihalli railway station
    {Coordinate{75.9852, 14.7738}, CountryId{"IN"}}, // Harapanahalli railway station
    {Coordinate{75.8977, 14.6594}, CountryId{"IN"}}, // Telgi railway station
    {Coordinate{78.2507, 15.3223}, CountryId{"IN"}}, // Banaganapalli railway station
    {Coordinate{78.3072, 15.2212}, CountryId{"IN"}}, // Koilakuntla railway station
    {Coordinate{78.3157, 15.1575}, CountryId{"IN"}}, // Sanjamala railway station
    {Coordinate{78.3965, 14.9795}, CountryId{"IN"}}, // Nossam railway station
    {Coordinate{78.3872, 14.9066}, CountryId{"IN"}}, // S. Uppalapadu railway station
    {Coordinate{78.3792, 15.443}, CountryId{"IN"}}, // Madduru railway station
    {Coordinate{25.6481, 60.3964}, CountryId{"FI"}}, // Porvoo railway station
    {Coordinate{24.4895, 64.6837}, CountryId{"FI"}}, // Raahe railway station
    {Coordinate{14.4814, 56.0672}, CountryId{"SE"}}, // Bromölla railway station
    {Coordinate{38.4187, 54.7215}, CountryId{"RU"}}, // 131 km
    {Coordinate{38.4736, 54.7072}, CountryId{"RU"}}, // Topkanovo
    {Coordinate{38.4889, 54.6972}, CountryId{"RU"}}, // 137 km
    {Coordinate{31.4444, 52.1444}, CountryId{"BY"}}, // Kutok
    {Coordinate{38.5806, 54.6325}, CountryId{"RU"}}, // 146 km
    {Coordinate{38.5977, 54.6188}, CountryId{"RU"}}, // Korovino
    {Coordinate{38.6104, 54.5859}, CountryId{"RU"}}, // 152 km
    {Coordinate{38.647, 54.4961}, CountryId{"RU"}}, // Q104364001
    {Coordinate{38.6647, 54.4783}, CountryId{"RU"}}, // Q104364046
    {Coordinate{38.7677, 54.3957}, CountryId{"RU"}}, // Q104364349
    {Coordinate{38.8989, 54.2942}, CountryId{"RU"}}, // Q104364772
    {Coordinate{38.9467, 54.2599}, CountryId{"RU"}}, // Q104364941
    {Coordinate{39.0151, 54.2226}, CountryId{"RU"}}, // Q104365265
    {Coordinate{39.057, 54.1722}, CountryId{"RU"}}, // Q104365611
    {Coordinate{39.0771, 54.1009}, CountryId{"RU"}}, // Q104365807
    {Coordinate{39.1085, 54.0394}, CountryId{"RU"}}, // Q104365913
    {Coordinate{39.1403, 53.9711}, CountryId{"RU"}}, // Q104365980
    {Coordinate{39.1512, 53.9366}, CountryId{"RU"}}, // Q104366125
    {Coordinate{39.1865, 53.8545}, CountryId{"RU"}}, // Q104366278
    {Coordinate{31.6903, 52.1733}, CountryId{"BY"}}, // Kruhavyets
    {Coordinate{82.2029, 17.0065}, CountryId{"IN"}}, // Sarpavaram railway station
    {Coordinate{34.5181, 55.3808}, CountryId{"RU"}}, // 218 km
    {Coordinate{34.4521, 55.3474}, CountryId{"RU"}}, // Meshchyorskaya
    {Coordinate{34.4077, 55.3159}, CountryId{"RU"}}, // Podyolki
    {Coordinate{34.3761, 55.2727}, CountryId{"RU"}}, // Komyagino
    {Coordinate{34.362, 55.2443}, CountryId{"RU"}}, // Zubaryovka
    {Coordinate{34.2807, 55.1785}, CountryId{"RU"}}, // Staraya Derevnya
    {Coordinate{}, CountryId{"IN"}}, // Kakinada New Port railway station
    {Coordinate{9.21736, 48.2505}, CountryId{"DE"}}, // Gammertingen station
    {Coordinate{9.2926, 48.3925}, CountryId{"DE"}}, // Kleinengstingen Landesbahn station
    {Coordinate{28.4693, 56.3054}, CountryId{"RU"}}, // Sebezh
    {Coordinate{84.5073, 26.1082}, CountryId{"IN"}}, // Maharajganj railway station
    {Coordinate{84.1707, 26.5669}, CountryId{"IN"}}, // Panchdeori Halt railway station
    {Coordinate{83.5135, 26.2684}, CountryId{"IN"}}, // Dohrighat railway station
    {Coordinate{83.2662, 27.0252}, CountryId{"IN"}}, // Campierganj railway station
    {Coordinate{12.9048, 56.4308}, CountryId{"SE"}}, // Båstad railway station
    {Coordinate{82.3893, 23.2403}, CountryId{"IN"}}, // Tiger Hill railway station
    {Coordinate{69.0215, 22.1977}, CountryId{"IN"}}, // Baradiya railway station
    {Coordinate{85.9081, 21.1144}, CountryId{"IN"}}, // Daitari railway station
    {Coordinate{40.0492, 57.511}, CountryId{"RU"}}, // 296 km
    {Coordinate{3.2987, 46.3012}, CountryId{"FR"}}, // Gare De Saint Pourçain-sur-Sioule
    {Coordinate{72.5421, 23.7026}, CountryId{"IN"}}, // Visnagar railway station
    {Coordinate{71.7192, 23.1702}, CountryId{"IN"}}, // Kharaghoda railway station
    {Coordinate{69.8391, 22.4349}, CountryId{"IN"}}, // Sikka railway station
    {Coordinate{72.9169, 22.533}, CountryId{"IN"}}, // Karamsad railway station
    {Coordinate{72.9311, 22.5423}, CountryId{"IN"}}, // Vallabh Vidynagar railway station
    {Coordinate{72.9088, 22.4011}, CountryId{"IN"}}, // Borsad railway station
    {Coordinate{72.8915, 22.3568}, CountryId{"IN"}}, // Bhadran railway station
    {Coordinate{73.0635, 22.219}, CountryId{"IN"}}, // Latipura railway station
    {Coordinate{73.1535, 22.2752}, CountryId{"IN"}}, // Atladara railway station
    {Coordinate{24.9414, 60.171}, CountryId{"FI"}}, // Helsinki Central Railway Station
    {Coordinate{73.1916, 22.0673}, CountryId{"IN"}}, // Ganpatpura railway station
    {Coordinate{73.1682, 21.9913}, CountryId{"IN"}}, // Choranda Junction railway station
    {Coordinate{73.2908, 21.9856}, CountryId{"IN"}}, // Sadhli railway station
    {Coordinate{73.3363, 21.9114}, CountryId{"IN"}}, // Sinor railway station
    {Coordinate{73.2011, 21.8722}, CountryId{"IN"}}, // Nareshwar Road railway station
    {Coordinate{73.2045, 21.8352}, CountryId{"IN"}}, // Moti Koral railway station
    {Coordinate{73.1493, 21.7268}, CountryId{"IN"}}, // Jhagadiya railway station
    {Coordinate{9.26173, 48.3612}, CountryId{"DE"}}, // Haidkapelle station
    {Coordinate{9.24601, 48.3288}, CountryId{"DE"}}, // Trochtelfingen ALB-GOLD railway stop
    {Coordinate{73.1537, 21.4615}, CountryId{"IN"}}, // Mota Miya Mangrol railway station
    {Coordinate{72.8144, 22.0463}, CountryId{"IN"}}, // Jambusar Junction railway station
    {Coordinate{72.8082, 22.056}, CountryId{"IN"}}, // Jambusar Road railway station
    {Coordinate{73.2272, 22.5559}, CountryId{"IN"}}, // Savli railway station
    {Coordinate{73.0749, 20.8063}, CountryId{"IN"}}, // Chikhli Road railway station
    {Coordinate{75.5163, 20.6279}, CountryId{"IN"}}, // Pimpalgaon railway station
    {Coordinate{75.4439, 20.6575}, CountryId{"IN"}}, // Varkhedi railway station
    {Coordinate{75.5975, 20.6574}, CountryId{"IN"}}, // Shendurni railway station
    {Coordinate{75.6837, 20.7154}, CountryId{"IN"}}, // Pahur railway station
    {Coordinate{75.7506, 20.7367}, CountryId{"IN"}}, // Bhagdara railway station
    {Coordinate{9.22203, 48.2878}, CountryId{"DE"}}, // Maegerkingen station
    {Coordinate{9.24625, 48.3076}, CountryId{"DE"}}, // Trochtelfingen (Hohenz) station
    {Coordinate{76.5709, 20.7081}, CountryId{"IN"}}, // Khamgaon railway station
    {Coordinate{80.0576, 21.7713}, CountryId{"IN"}}, // Waraseoni railway station
    {Coordinate{80.1093, 21.7953}, CountryId{"IN"}}, // Kaydi Halt railway station
    {Coordinate{80.1688, 22.424}, CountryId{"IN"}}, // Dhatura Alipur railway station
    {Coordinate{87.3966, 25.821}, CountryId{"IN"}}, // Kirtyanand Nagar railway station
    {Coordinate{87.5298, 25.8602}, CountryId{"IN"}}, // Kasba railway station
    {Coordinate{86.7379, 26.2934}, CountryId{"IN"}}, // Saraygarh railway station
    {Coordinate{85.409, 24.3031}, CountryId{"IN"}}, // Barhi railway station
    {Coordinate{85.3329, 22.1066}, CountryId{"IN"}}, // Bolanikhadan railway station
    {Coordinate{85.5933, 20.1581}, CountryId{"IN"}}, // Khurda Town railway station
    {Coordinate{85.4319, 20.1872}, CountryId{"IN"}}, // Begunia railway station
    {Coordinate{83.2521, 18.5436}, CountryId{"IN"}}, // Rompalle railway station
    {Coordinate{83.2066, 18.5273}, CountryId{"IN"}}, // Salur railway station
    {Coordinate{80.1139, 16.8919}, CountryId{"IN"}}, // Jaggayyapet Town railway station
    {Coordinate{81.2341, 16.5595}, CountryId{"IN"}}, // Vadarlapadu railway station
    {Coordinate{81.3218, 16.5782}, CountryId{"IN"}}, // Alapadu railway station
    {Coordinate{82.0412, 16.8365}, CountryId{"IN"}}, // Ramachandrapuram railway station
    {Coordinate{82.1793, 16.9276}, CountryId{"IN"}}, // Aratlakatta railway station
    {Coordinate{79.2792, 19.7574}, CountryId{"IN"}}, // Pandhar Pavani railway station
    {Coordinate{78.6382, 18.8544}, CountryId{"IN"}}, // Metpalli railway station
    {Coordinate{78.8875, 18.7825}, CountryId{"IN"}}, // Lingampet Jagityal railway station
    {Coordinate{78.9202, 18.7059}, CountryId{"IN"}}, // Nukanpalli Mallial railway station
    {Coordinate{82.5218, 27.6441}, CountryId{"IN"}}, // Jarwa railway station
    {Coordinate{79.8856, 28.0208}, CountryId{"IN"}}, // Areli railway station
    {Coordinate{79.8862, 27.9845}, CountryId{"IN"}}, // Khiria Khurd railway station
    {Coordinate{79.904, 27.8944}, CountryId{"IN"}}, // Shahjahanpur (Metre Gauge) railway station
    {Coordinate{80.7397, 27.5221}, CountryId{"IN"}}, // Khairabad Awadh railway station
    {Coordinate{78.9511, 26.7289}, CountryId{"IN"}}, // Udi More Junction railway station
    {Coordinate{78.6176, 26.866}, CountryId{"IN"}}, // Bah railway station
    {Coordinate{78.2997, 27.0193}, CountryId{"IN"}}, // Fatehabad railway station
    {Coordinate{78.1269, 27.025}, CountryId{"IN"}}, // Shamshabad Town railway station
    {Coordinate{77.7583, 27.3186}, CountryId{"IN"}}, // Deen Dayal Dham railway station
    {Coordinate{75.4098, 28.7648}, CountryId{"IN"}}, // Narwasi railway station
    {Coordinate{76.992, 30.8821}, CountryId{"IN"}}, // Jabli railway station
    {Coordinate{75.388, 31.8263}, CountryId{"IN"}}, // Qadian railway station
    {Coordinate{75.0142, 32.0249}, CountryId{"IN"}}, // Dera Baba Nanak railway station
    {Coordinate{74.9853, 31.9971}, CountryId{"IN"}}, // Ratar Chattar railway station
    {Coordinate{74.9269, 31.9632}, CountryId{"IN"}}, // Ramdas railway station
    {Coordinate{74.926, 31.9145}, CountryId{"IN"}}, // Hardorawal railway station
    {Coordinate{74.9415, 31.8636}, CountryId{"IN"}}, // Fatehgarh Churian railway station
    {Coordinate{74.9434, 31.8112}, CountryId{"IN"}}, // Kotla Gujran railway station
    {Coordinate{74.9491, 31.7585}, CountryId{"IN"}}, // Majitha railway station
    {Coordinate{74.8643, 31.6089}, CountryId{"IN"}}, // Bhagtanwala railway station
    {Coordinate{74.8555, 31.2878}, CountryId{"IN"}}, // Patti railway station
    {Coordinate{74.5535, 31.1398}, CountryId{"IN"}}, // Khem Karan railway station
    {Coordinate{75.6072, 31.2428}, CountryId{"IN"}}, // Jamsher Khas railway station
    {Coordinate{75.1921, 33.5675}, CountryId{"IN"}}, // Hiller Shahabad railway station
    {Coordinate{75.0386, 33.8464}, CountryId{"IN"}}, // Panzgom railway station
    {Coordinate{74.5122, 34.2226}, CountryId{"IN"}}, // Hamre railway station
    {Coordinate{74.5468, 28.1538}, CountryId{"IN"}}, // Golsar railway station
    {Coordinate{74.5346, 28.21}, CountryId{"IN"}}, // Melusar railway station
    {Coordinate{74.7037, 26.9809}, CountryId{"IN"}}, // Bidiyad railway station
    {Coordinate{73.617, 26.2255}, CountryId{"IN"}}, // Bhawi railway station
    {Coordinate{78.4841, 26.4984}, CountryId{"IN"}}, // Sondha Road railway station
    {Coordinate{74.4154, 18.0086}, CountryId{"IN"}}, // Phaltan railway station
    {Coordinate{7.0656, 49.3562}, CountryId{"DE"}}, // Merchweiler
    {Coordinate{74.6174, 15.2729}, CountryId{"IN"}}, // Ambewadi railway station
    {Coordinate{76.6224, 15.1445}, CountryId{"IN"}}, // Bannihatti railway station
    {Coordinate{77.5778, 16.2479}, CountryId{"IN"}}, // Panduranga Swamy Road railway station
    {Coordinate{77.6073, 16.5783}, CountryId{"IN"}}, // Jaklair railway station
    {Coordinate{77.7286, 16.5952}, CountryId{"IN"}}, // Marikal railway station
    {Coordinate{78.6402, 14.4314}, CountryId{"IN"}}, // Pendlimarri railway station
    {Coordinate{78.7041, 14.4522}, CountryId{"IN"}}, // Ganganapalli railway station
    {Coordinate{79.9334, 14.294}, CountryId{"IN"}}, // Venkatachalam Road Junction railway station
    {Coordinate{79.6289, 10.6901}, CountryId{"IN"}}, // Mavur Road railway station
    {Coordinate{79.6365, 10.6531}, CountryId{"IN"}}, // Tirunellikaval railway station
    {Coordinate{79.7381, 10.4527}, CountryId{"IN"}}, // Kariyappattinam railway station
    {Coordinate{79.8554, 10.3776}, CountryId{"IN"}}, // Vedaranniyam railway station
    {Coordinate{79.8502, 10.355}, CountryId{"IN"}}, // Agastiyampalli railway station
    {Coordinate{79.4989, 10.4027}, CountryId{"IN"}}, // Mutupet railway station
    {Coordinate{79.0921, 10.2171}, CountryId{"IN"}}, // Ayingudi railway station
    {Coordinate{7.17141, 49.2636}, CountryId{"DE"}}, // Hassel (Saar)
    {Coordinate{78.8384, 10.1058}, CountryId{"IN"}}, // Kandanur Puduvayal railway station
    {Coordinate{77.935, 9.94065}, CountryId{"IN"}}, // Karumattur railway station
    {Coordinate{77.1327, 10.6099}, CountryId{"IN"}}, // Gomangalam railway station
    {Coordinate{77.2504, 10.5793}, CountryId{"IN"}}, // Udumalaippettai railway station
    {Coordinate{77.3346, 10.5639}, CountryId{"IN"}}, // Maivadi Road railway station
    {Coordinate{77.4226, 10.5249}, CountryId{"IN"}}, // Pushpattur railway station
    {Coordinate{77.6253, 9.9956}, CountryId{"IN"}}, // Andipatti railway station
    {Coordinate{77.473, 10.0143}, CountryId{"IN"}}, // Teni railway station
    {Coordinate{76.4657, 12.8714}, CountryId{"IN"}}, // Shravanabelagola railway station
    {Coordinate{76.394, 12.8927}, CountryId{"IN"}}, // Channarayapatna railway station
    {Coordinate{76.2055, 12.9846}, CountryId{"IN"}}, // Shantigrama railway station
    {Coordinate{76.5745, 12.9472}, CountryId{"IN"}}, // Hirisave railway station
    {Coordinate{}, CountryId{"IN"}}, // B.G. Nagar railway station
    {Coordinate{76.8639, 12.979}, CountryId{"IN"}}, // Yediyur railway station
    {Coordinate{77.0111, 13.0166}, CountryId{"IN"}}, // Kunigal railway station
    {Coordinate{74.8536, 12.9596}, CountryId{"IN"}}, // Jokatte railway station
    {Coordinate{73.7741, 21.9708}, CountryId{"IN"}}, // Tankhala railway station
    {Coordinate{92.9232, 26.7916}, CountryId{"IN"}}, // Dhalai Beel railway station
    {Coordinate{93.1637, 26.7693}, CountryId{"IN"}}, // Nizchatia railway station
    {Coordinate{93.3023, 26.846}, CountryId{"IN"}}, // Nizbargang railway station
    {Coordinate{93.4528, 26.873}, CountryId{"IN"}}, // Helem railway station
    {Coordinate{93.6219, 26.897}, CountryId{"IN"}}, // Gohpur railway station
    {Coordinate{93.7202, 26.9196}, CountryId{"IN"}}, // Dubia railway station
    {Coordinate{93.8605, 27.119}, CountryId{"IN"}}, // Harmuti Junction railway station
    {Coordinate{93.9711, 27.1766}, CountryId{"IN"}}, // Kathalpukhari railway station
    {Coordinate{94.0312, 27.201}, CountryId{"IN"}}, // Silanibari railway station
    {Coordinate{94.075, 27.2983}, CountryId{"IN"}}, // Lilabari railway station
    {Coordinate{94.1825, 27.3992}, CountryId{"IN"}}, // Baginadi railway station
    {Coordinate{94.3196, 27.4416}, CountryId{"IN"}}, // Gogamukh railway station
    {Coordinate{94.4379, 27.4234}, CountryId{"IN"}}, // Bordoloni railway station
    {Coordinate{94.6326, 27.5587}, CountryId{"IN"}}, // Sripani railway station
    {Coordinate{94.6848, 27.5358}, CountryId{"IN"}}, // New Sisibargaon railway station
    {Coordinate{94.718, 27.5928}, CountryId{"IN"}}, // Silapathar railway station
    {Coordinate{94.7798, 27.6557}, CountryId{"IN"}}, // Archipathar railway station
    {Coordinate{94.8869, 27.7237}, CountryId{"IN"}}, // Simen Chapori railway station
    {Coordinate{95.0039, 27.766}, CountryId{"IN"}}, // Telem Railway Station railway station
    {Coordinate{95.0761, 27.7508}, CountryId{"IN"}}, // Laimekuri railway station
    {Coordinate{94.7149, 27.4523}, CountryId{"IN"}}, // Tangni railway station
    {Coordinate{94.6131, 26.7365}, CountryId{"IN"}}, // Tuli railway station
    {Coordinate{95.5396, 27.5543}, CountryId{"IN"}}, // Hansara railway station
    {Coordinate{95.557, 27.5998}, CountryId{"IN"}}, // Rupai railway station
    {Coordinate{95.5632, 27.6732}, CountryId{"IN"}}, // Talap railway station
    {Coordinate{95.568, 27.7093}, CountryId{"IN"}}, // Dangari railway station
    {Coordinate{13.7661, 47.9332}, CountryId{"AT"}}, // Pinsdorf
    {Coordinate{13.7454, 47.9681}, CountryId{"AT"}}, // Aurachkirchen railway station
    {Coordinate{13.7583, 47.8912}, CountryId{"AT"}}, // Altmünster railway station
    {Coordinate{85.2233, 20.1693}, CountryId{"IN"}}, // Bolagarh Road railway station
    {Coordinate{85.344, 20.1646}, CountryId{"IN"}}, // Rajsunakhala railway station
    {Coordinate{13.7771, 47.8552}, CountryId{"AT"}}, // Bahnhof Traunkirchen
    {Coordinate{13.787, 47.8428}, CountryId{"AT"}}, // Traunkirchen Ort
    {Coordinate{24.8639, 60.2467}, CountryId{"FI"}}, // Malminkartano railway station
    {Coordinate{86.1543, 22.5027}, CountryId{"IN"}}, // Sidhirsai railway station
    {Coordinate{86.3653, 26.4415}, CountryId{"IN"}}, // Barhara railway station
    {Coordinate{81.8806, 25.4444}, CountryId{"IN"}}, // Prayag Ghat Terminal railway station
    {Coordinate{81.6503, 25.1846}, CountryId{"IN"}}, // Bevara railway station
    {Coordinate{78.8817, 26.6558}, CountryId{"IN"}}, // Phoop railway station
    {Coordinate{13.7745, 47.8127}, CountryId{"AT"}}, // Ebensee Landungsplatz
    {Coordinate{13.7715, 47.8043}, CountryId{"AT"}}, // Ebensee railway staiton
    {Coordinate{13.7414, 47.7872}, CountryId{"AT"}}, // Steinkogel
    {Coordinate{13.7311, 47.7745}, CountryId{"AT"}}, // Lahnstein
    {Coordinate{13.7053, 47.7568}, CountryId{"AT"}}, // Langwies railway station
    {Coordinate{14.1065, 47.5295}, CountryId{"AT"}}, // Stainach-Irdning railway station
    {Coordinate{13.6164, 47.6744}, CountryId{"AT"}}, // Lauffen
    {Coordinate{13.6088, 47.6585}, CountryId{"AT"}}, // Bad Goisern Jodschwefelbad
    {Coordinate{13.613, 47.6397}, CountryId{"AT"}}, // Bad Goisern railway station
    {Coordinate{78.8884, 26.7493}, CountryId{"IN"}}, // Jaitpura railway station
    {Coordinate{78.7773, 26.809}, CountryId{"IN"}}, // Man Singh Ka Pura railway station
    {Coordinate{78.7105, 26.8349}, CountryId{"IN"}}, // Jaitpur Kalan railway station
    {Coordinate{78.4821, 26.8942}, CountryId{"IN"}}, // Bhadrauli railway station
    {Coordinate{78.3904, 26.9366}, CountryId{"IN"}}, // Manikpura railway station
    {Coordinate{78.2003, 27.0295}, CountryId{"IN"}}, // Dhimsiri railway station
    {Coordinate{78.0246, 27.0408}, CountryId{"IN"}}, // Karaundhana railway station
    {Coordinate{76.7947, 25.845}, CountryId{"IN"}}, // Durgapuri railway station
    {Coordinate{74.1785, 26.2995}, CountryId{"IN"}}, // Ras railway station
    {Coordinate{73.5649, 26.3023}, CountryId{"IN"}}, // Silari railway station
    {Coordinate{75.0513, 23.3394}, CountryId{"IN"}}, // Ratlam New railway station
    {Coordinate{73.3856, 22.7728}, CountryId{"IN"}}, // Tulsigam railway station
    {Coordinate{73.3534, 22.7426}, CountryId{"IN"}}, // Wejpur railway station
    {Coordinate{73.3284, 22.712}, CountryId{"IN"}}, // Desar Road railway station
    {Coordinate{73.3639, 22.669}, CountryId{"IN"}}, // Pandu Mewas railway station
    {Coordinate{73.3599, 22.6392}, CountryId{"IN"}}, // Sandasal railway station
    {Coordinate{73.3239, 22.6119}, CountryId{"IN"}}, // Mevli railway station
    {Coordinate{73.2549, 22.5725}, CountryId{"IN"}}, // Muval Tank railway station
    {Coordinate{73.2488, 22.518}, CountryId{"IN"}}, // Karchiya railway station
    {Coordinate{73.3381, 22.4413}, CountryId{"IN"}}, // Jarod railway station
    {Coordinate{73.3704, 22.4106}, CountryId{"IN"}}, // Vyankatpura railway station
    {Coordinate{73.3849, 22.3588}, CountryId{"IN"}}, // Ajwa railway station
    {Coordinate{73.4376, 22.2279}, CountryId{"IN"}}, // Karmaliyapura railway station
    {Coordinate{73.4242, 22.1877}, CountryId{"IN"}}, // Prayagpura railway station
    {Coordinate{73.3183, 22.0952}, CountryId{"IN"}}, // Baripur Mandala railway station
    {Coordinate{73.2497, 22.0779}, CountryId{"IN"}}, // Kayavarohan railway station
    {Coordinate{73.6092, 22.1411}, CountryId{"IN"}}, // Khunvad railway station
    {Coordinate{73.6474, 22.1383}, CountryId{"IN"}}, // Bhatpur railway station
    {Coordinate{74.0737, 22.3741}, CountryId{"IN"}}, // Padaliya Road railway station
    {Coordinate{74.1842, 22.3826}, CountryId{"IN"}}, // Moti Sadhli railway station
    {Coordinate{74.2722, 22.3195}, CountryId{"IN"}}, // Ambari Richhavi railway station
    {Coordinate{9.12814, 48.136}, CountryId{"DE"}}, // Bahnhof Storzingen
    {Coordinate{71.1626, 21.4823}, CountryId{"IN"}}, // Sajiyavadar railway station
    {Coordinate{72.275, 23.3359}, CountryId{"IN"}}, // Devsana railway station
    {Coordinate{72.3865, 23.2814}, CountryId{"IN"}}, // Karan Nagar railway station
    {Coordinate{72.4101, 23.2765}, CountryId{"IN"}}, // Anakhol railway station
    {Coordinate{72.4934, 23.4574}, CountryId{"IN"}}, // Langhnaj railway station
    {Coordinate{72.5565, 23.4829}, CountryId{"IN"}}, // Gojhariya railway station
    {Coordinate{72.5755, 23.5304}, CountryId{"IN"}}, // Vasai Dabhla railway station
    {Coordinate{72.62, 23.5533}, CountryId{"IN"}}, // Kukarvada railway station
    {Coordinate{72.669, 23.5763}, CountryId{"IN"}}, // Gerita Kolvada railway station
    {Coordinate{72.6995, 23.5785}, CountryId{"IN"}}, // Gawada Malosan railway station
    {Coordinate{72.7314, 23.5166}, CountryId{"IN"}}, // Pilwai Road railway station
    {Coordinate{72.714, 23.4604}, CountryId{"IN"}}, // Lodra railway station
    {Coordinate{72.6975, 23.4175}, CountryId{"IN"}}, // Makakhad railway station
    {Coordinate{72.6786, 23.3748}, CountryId{"IN"}}, // Limbodra railway station
    {Coordinate{72.6589, 23.33}, CountryId{"IN"}}, // Unava Vasan railway station
    {Coordinate{72.6338, 23.2971}, CountryId{"IN"}}, // Randheja railway station
    {Coordinate{72.5475, 23.2478}, CountryId{"IN"}}, // Tintoda railway station
    {Coordinate{10.0703, 54.31}, CountryId{"DE"}}, // Kiel-Russee
    {Coordinate{70.2847, 21.1053}, CountryId{"IN"}}, // Bhanduri railway station
    {Coordinate{71.4703, 21.0874}, CountryId{"IN"}}, // Charodia railway station
    {Coordinate{72.7288, 21.7988}, CountryId{"IN"}}, // Pakhajan railway station
    {Coordinate{72.8447, 21.8495}, CountryId{"IN"}}, // Vagara railway station
    {Coordinate{72.9415, 21.7397}, CountryId{"IN"}}, // Tham railway station
    {Coordinate{73.0644, 21.4589}, CountryId{"IN"}}, // Asarma railway station
    {Coordinate{73.0913, 21.4597}, CountryId{"IN"}}, // Simodara railway station
    {Coordinate{73.0386, 21.4395}, CountryId{"IN"}}, // Limbara railway station
    {Coordinate{73.0124, 21.4332}, CountryId{"IN"}}, // Velachha railway station
    {Coordinate{73.4751, 21.4584}, CountryId{"IN"}}, // Umarpada railway station
    {Coordinate{73.4562, 21.4912}, CountryId{"IN"}}, // Kevedi railway station
    {Coordinate{73.398, 21.4741}, CountryId{"IN"}}, // Chitalda railway station
    {Coordinate{73.3394, 20.8524}, CountryId{"IN"}}, // Unai and Vansda Road railway station
    {Coordinate{72.8074, 22.2994}, CountryId{"IN"}}, // Kathana railway station
    {Coordinate{72.6441, 22.3571}, CountryId{"IN"}}, // Kalitalavadi railway station
    {Coordinate{72.7441, 22.4717}, CountryId{"IN"}}, // Pandori railway station
    {Coordinate{72.7325, 22.5814}, CountryId{"IN"}}, // Dabhou railway station
    {Coordinate{72.4704, 22.9645}, CountryId{"IN"}}, // Sanathal railway station
    {Coordinate{72.3977, 22.7848}, CountryId{"IN"}}, // Saljida railway station
    {Coordinate{72.4381, 23.6467}, CountryId{"IN"}}, // Piludra railway station
    {Coordinate{72.6592, 23.9209}, CountryId{"IN"}}, // Kadarpur railway station
    {Coordinate{72.6283, 23.827}, CountryId{"IN"}}, // Kesimpa railway station
    {Coordinate{72.9629, 23.7903}, CountryId{"IN"}}, // Sur Road railway station
    {Coordinate{76.4207, 29.8006}, CountryId{"IN"}}, // New Kaithal Halt railway station
    {Coordinate{9.3387, 49.441}, CountryId{"DE"}}, // Q104714091
    {Coordinate{75.7704, 31.1674}, CountryId{"IN"}}, // Mauli Block Hut railway station
    {Coordinate{11.5794, 58.5292}, CountryId{"SE"}}, // Dingle railway station
    {Coordinate{9.2354, 48.0997}, CountryId{"DE"}}, // Hanfertal station
    {Coordinate{18.1489, 49.6112}, CountryId{"CZ"}}, // Q104776000
    {Coordinate{14.704, 49.4045}, CountryId{"CZ"}}, // Q104808828
    {Coordinate{15.9813, 48.1734}, CountryId{"AT"}}, // Eichgraben-Altlengbach railway station
    {Coordinate{16.0619, 48.1785}, CountryId{"AT"}}, // Dürrwien railway station
    {Coordinate{16.0777, 48.1813}, CountryId{"AT"}}, // Pressbaum railway station
    {Coordinate{8.01711, 46.6255}, CountryId{"CH"}}, // Grindelwald Terminal railway station
    {Coordinate{77.3669, 20.7271}, CountryId{"IN"}}, // Murtajapur Town railway station
    {Coordinate{77.4087, 20.6528}, CountryId{"IN"}}, // Kinkhed railway station
    {Coordinate{77.4362, 20.592}, CountryId{"IN"}}, // Vilegaon railway station
    {Coordinate{77.4527, 20.551}, CountryId{"IN"}}, // Bhadsivni railway station
    {Coordinate{77.4695, 20.5295}, CountryId{"IN"}}, // Pohe railway station
    {Coordinate{}, CountryId{"IN"}}, // Ranippet railway station
    {Coordinate{37.6056, 47.1369}, CountryId{"UA"}}, // Azovstal railway station
    {Coordinate{54.6061, 53.9166}, CountryId{"RU"}}, // Aksyonovo railway station
    {Coordinate{-0.41392, 48.5583}, CountryId{"FR"}}, // Gare de Bagnoles-de-l'Orne
    {Coordinate{15.9341, 48.188}, CountryId{"AT"}}, // Maria Anzbach railway station
    {Coordinate{15.9064, 48.1963}, CountryId{"AT"}}, // Neulengbach Stadt railway station
    {Coordinate{15.892, 48.1997}, CountryId{"AT"}}, // Neulengbach railway station
    {Coordinate{12.256, 53.4604}, CountryId{"DE"}}, // Plau am See railway station
    {Coordinate{12.2653, 53.3413}, CountryId{"DE"}}, // Wendisch Priborn railway station
    {Coordinate{12.2473, 53.3112}, CountryId{"DE"}}, // Meyenburg railway station
    {Coordinate{-119.386, 35.864}, CountryId{"US"}}, // Allensworth station
    {Coordinate{24.1858, 56.9189}, CountryId{"LV"}}, // Jāņavārti Station
    {Coordinate{6.95482, 46.0637}, CountryId{"CH"}}, // Giétroz railway station
    {Coordinate{6.95828, 46.0618}, CountryId{"CH"}}, // Le Châtelard VS Funiculaire railway station
    {Coordinate{76.9333, 24.0494}, CountryId{"IN"}}, // Pench railway station
    {Coordinate{}, CountryId{"AT"}}, // Bahnhof Hallein
    {Coordinate{13.239, 47.9668}, CountryId{"AT"}}, // Bahnhof Steindorf bei Straßwalchen
    {Coordinate{91.9463, 26.0907}, CountryId{"IN"}}, // Kamalajari railway station
    {Coordinate{90.2352, 26.2425}, CountryId{"IN"}}, // Bilasipara railway station
    {Coordinate{90.1206, 26.2045}, CountryId{"IN"}}, // Bagribari railway station
    {Coordinate{90.0256, 26.119}, CountryId{"IN"}}, // Alamganj railway station
    {Coordinate{89.9556, 26.0772}, CountryId{"IN"}}, // Gauripur railway station
    {Coordinate{15.1633, 50.9397}, CountryId{"CZ"}}, // Řasnice zastávka
    {Coordinate{25.4064, 65.1961}, CountryId{"FI"}}, // Haukipudas railway station
    {Coordinate{25.5547, 60.4081}, CountryId{"FI"}}, // Q10518700
    {Coordinate{9.96278, 53.4656}, CountryId{"DE"}}, // Heimfeld station
    {Coordinate{10.6142, 47.779}, CountryId{"DE"}}, // Marktoberdorf station
    {Coordinate{79.286, 24.8358}, CountryId{"IN"}}, // Tila railway station
    {Coordinate{79.3515, 24.8446}, CountryId{"IN"}}, // Rampura railway station
    {Coordinate{37.4914, 53.8482}, CountryId{"RU"}}, // Lazarevo
    {Coordinate{78.3387, 20.7693}, CountryId{"IN"}}, // Sorta railway station
    {Coordinate{78.3387, 20.8036}, CountryId{"IN"}}, // Virul railway station
    {Coordinate{78.3292, 20.849}, CountryId{"IN"}}, // Rohna railway station
    {Coordinate{78.324, 20.8543}, CountryId{"IN"}}, // Rohna Town railway station
    {Coordinate{78.2909, 20.8793}, CountryId{"IN"}}, // Dhanori railway station
    {Coordinate{78.2878, 20.9041}, CountryId{"IN"}}, // Pargothan railway station
    {Coordinate{78.2518, 20.9417}, CountryId{"IN"}}, // Pachegaon railway station
    {Coordinate{78.2393, 20.963}, CountryId{"IN"}}, // Khubagaon railway station
    {Coordinate{78.0158, 20.4}, CountryId{"IN"}}, // Lasina railway station
    {Coordinate{77.9202, 20.3414}, CountryId{"IN"}}, // Ladkhed railway station
    {Coordinate{77.8645, 20.342}, CountryId{"IN"}}, // Tapona railway station
    {Coordinate{77.6981, 20.3416}, CountryId{"IN"}}, // Bhandegaon railway station
    {Coordinate{77.6197, 20.3884}, CountryId{"IN"}}, // Warudkhed railway station
    {Coordinate{77.6019, 20.419}, CountryId{"IN"}}, // Sangvi railway station
    {Coordinate{77.5768, 20.4388}, CountryId{"IN"}}, // Somthan railway station
    {Coordinate{77.5327, 20.452}, CountryId{"IN"}}, // Dadgaon railway station
    {Coordinate{77.4917, 20.4863}, CountryId{"IN"}}, // Karanja Town railway station
    {Coordinate{77.3562, 20.8408}, CountryId{"IN"}}, // Lakhpuri railway station
    {Coordinate{77.3546, 20.8599}, CountryId{"IN"}}, // Bhujvad railway station
    {Coordinate{77.3294, 20.9826}, CountryId{"IN"}}, // Lehgaon railway station
    {Coordinate{77.3355, 21.0354}, CountryId{"IN"}}, // Kokalda railway station
    {Coordinate{77.3421, 21.0936}, CountryId{"IN"}}, // Kapustalni railway station
    {Coordinate{77.398, 21.1857}, CountryId{"IN"}}, // Pathrot railway station
    {Coordinate{77.4497, 21.1997}, CountryId{"IN"}}, // Khusta Buxarg railway station
    {Coordinate{77.4715, 21.2188}, CountryId{"IN"}}, // Chamak railway station
    {Coordinate{77.4935, 21.2524}, CountryId{"IN"}}, // Nowbagh railway station
    {Coordinate{78.0678, 21.4056}, CountryId{"IN"}}, // Hiwarkhed railway station
    {Coordinate{78.9098, 20.1061}, CountryId{"IN"}}, // Rajur railway station
    {Coordinate{25.4411, 65.3186}, CountryId{"FI"}}, // Ii railway station
    {Coordinate{79.1752, 19.7397}, CountryId{"IN"}}, // Gadchandur railway station
    {Coordinate{4.84807, 45.7281}, CountryId{"FR"}}, // Q105384286
    {Coordinate{79.3022, 19.7597}, CountryId{"IN"}}, // New Pandarpawani railway station
    {Coordinate{22.7147, 63.6744}, CountryId{"FI"}}, // Pietarsaari railway station
    {Coordinate{79.3696, 19.7712}, CountryId{"IN"}}, // Rajura railway station
    {Coordinate{79.3316, 18.5204}, CountryId{"IN"}}, // Sultanabad railway station
    {Coordinate{78.9894, 18.5821}, CountryId{"IN"}}, // Gangadhara railway station
    {Coordinate{78.9522, 18.6186}, CountryId{"IN"}}, // Poduru railway station
    {Coordinate{78.8237, 18.8175}, CountryId{"IN"}}, // Katlakunta Medipally railway station
    {Coordinate{78.4531, 18.8206}, CountryId{"IN"}}, // Mortad railway station
    {Coordinate{78.3112, 18.7808}, CountryId{"IN"}}, // Armur railway station
    {Coordinate{78.2824, 17.5102}, CountryId{"IN"}}, // Ramachandrapuram TS railway station
    {Coordinate{79.7038, 16.7248}, CountryId{"IN"}}, // Janpahad railway station
    {Coordinate{79.8563, 16.7827}, CountryId{"IN"}}, // Mattampally railway station
    {Coordinate{14.1625, 57.7847}, CountryId{"SE"}}, // Jönköping central station
    {Coordinate{4.91083, 45.6958}, CountryId{"FR"}}, // Q105422211
    {Coordinate{75.9863, 24.6026}, CountryId{"IN"}}, // Julmi railway station
    {Coordinate{76.1966, 24.5334}, CountryId{"IN"}}, // Jhalarapatan railway station
    {Coordinate{75.8594, 25.249}, CountryId{"IN"}}, // Tirath railway station
    {Coordinate{75.4792, 25.3094}, CountryId{"IN"}}, // Nim-ka-Khera railway station
    {Coordinate{16.36, 56.6615}, CountryId{"SE"}}, // Kalmar central station
    {Coordinate{18.5132, 49.8386}, CountryId{"CZ"}}, // Karviná-Doly
    {Coordinate{11.1921, 48.1474}, CountryId{"DE"}}, // Schöngeising railway station
    {Coordinate{78.9245, 24.7903}, CountryId{"IN"}}, // Mawai railway station
    {Coordinate{79.064, 24.8232}, CountryId{"IN"}}, // Sarkanpur railway station
    {Coordinate{79.3937, 24.854}, CountryId{"IN"}}, // Ishanagar railway station
    {Coordinate{25.6136, 60.4067}, CountryId{"FI"}}, // Kiiala train stop
    {Coordinate{41.9636, 44.6306}, CountryId{"RU"}}, // Q105464669
    {Coordinate{12.0189, 57.6557}, CountryId{"SE"}}, // Mölndal railway station
    {Coordinate{6.59336, 50.4418}, CountryId{"DE"}}, // Blankenheim (Wald) railway station
    {Coordinate{12.1753, 47.6526}, CountryId{"DE"}}, // Oberaudorf railway station
    {Coordinate{11.3065, 47.962}, CountryId{"DE"}}, // Possenhofen station
    {Coordinate{11.3719, 47.7492}, CountryId{"DE"}}, // Penzberg railway station
    {Coordinate{77.6711, 27.5183}, CountryId{"IN"}}, // Masani railway station
    {Coordinate{22.6919, 63.5214}, CountryId{"FI"}}, // Kovjoki railway station
    {Coordinate{17.7783, 62.9289}, CountryId{"SE"}}, // Kramfors
    {Coordinate{76.6177, 28.2468}, CountryId{"IN"}}, // Gokulgarh railway station
    {Coordinate{76.6434, 28.4864}, CountryId{"IN"}}, // Machhrauli railway station
    {Coordinate{29.2917, 46.8917}, CountryId{"MD"}}, // Bulboaca railway station
    {Coordinate{76.6297, 28.3596}, CountryId{"IN"}}, // Palhawas railway station
    {Coordinate{76.8553, 29.043}, CountryId{"IN"}}, // Mohana railway station
    {Coordinate{76.5507, 29.2391}, CountryId{"IN"}}, // Bhambewa railway station
    {Coordinate{75.0229, 30.2003}, CountryId{"IN"}}, // Bhatinda Cantt. Jn. Cabin railway station
    {Coordinate{73.6476, 29.3078}, CountryId{"IN"}}, // Raghunathgarh railway station
    {Coordinate{74.5871, 29.5118}, CountryId{"IN"}}, // Talwara Jhil railway station
    {Coordinate{12.0798, 57.4905}, CountryId{"SE"}}, // Kungsbacka railway station
    {Coordinate{25.1016, 60.457}, CountryId{"FI"}}, // Ainola railway station
    {Coordinate{13.1114, 55.7944}, CountryId{"SE"}}, // Kävlinge railway station
    {Coordinate{12.8569, 55.8789}, CountryId{"SE"}}, // Landskrona railway station
    {Coordinate{5.35917, 43.3265}, CountryId{"FR"}}, // Gare de Marseille-Arenc
    {Coordinate{23.2369, 59.9041}, CountryId{"FI"}}, // Lappohja railway station
    {Coordinate{12.4601, 51.3694}, CountryId{"DE"}}, // Leipzig-Heiterblick railway station
    {Coordinate{14.6164, 58.9892}, CountryId{"SE"}}, // Laxå railway station
    {Coordinate{71.8167, 23.9667}, CountryId{"IN"}}, // Shihori Railway Station
    {Coordinate{72.0341, 24.0237}, CountryId{"IN"}}, // Wayad railway station
    {Coordinate{72.065, 23.93}, CountryId{"IN"}}, // Kansa railway station
    {Coordinate{72.1449, 23.7285}, CountryId{"IN"}}, // Jitoda railway station
    {Coordinate{72.2383, 23.7316}, CountryId{"IN"}}, // Manund railway station
    {Coordinate{72.0804, 23.6575}, CountryId{"IN"}}, // Brahmanvada railway station
    {Coordinate{72.0293, 23.5161}, CountryId{"IN"}}, // Sankhalpur railway station
    {Coordinate{70.5423, 22.9481}, CountryId{"IN"}}, // Lavanpur railway station
    {Coordinate{70.4497, 22.9583}, CountryId{"IN"}}, // Navlakhi railway station
    {Coordinate{69.9808, 23.1583}, CountryId{"IN"}}, // Sapda railway station
    {Coordinate{69.3282, 23.2241}, CountryId{"IN"}}, // Sukhpur Roha railway station
    {Coordinate{69.2066, 23.2139}, CountryId{"IN"}}, // Sanosara railway station
    {Coordinate{69.1099, 23.19}, CountryId{"IN"}}, // Mothala railway station
    {Coordinate{69.0283, 23.154}, CountryId{"IN"}}, // Dhanvala Vada railway station
    {Coordinate{68.944, 23.1264}, CountryId{"IN"}}, // Kothara railway station
    {Coordinate{69.5576, 22.7638}, CountryId{"IN"}}, // West Port railway station
    {Coordinate{69.6024, 22.8089}, CountryId{"IN"}}, // Navinal railway station
    {Coordinate{69.6724, 22.7968}, CountryId{"IN"}}, // Dhrub railway station
    {Coordinate{69.7591, 22.8353}, CountryId{"IN"}}, // Mundra Airport Road railway station
    {Coordinate{69.8343, 22.8825}, CountryId{"IN"}}, // Bhadreshwar Road railway station
    {Coordinate{69.9173, 22.9623}, CountryId{"IN"}}, // Vasai Third Road railway station
    {Coordinate{70.0419, 22.5045}, CountryId{"IN"}}, // Bedeshwar Windmill railway station
    {Coordinate{69.8636, 22.3848}, CountryId{"IN"}}, // Moti Khawdi railway station
    {Coordinate{75.2395, 31.4866}, CountryId{"IN"}}, // Bhalojala railway station
    {Coordinate{75.1868, 31.4559}, CountryId{"IN"}}, // Saidpur Jalalabad railway station
    {Coordinate{75.1166, 31.4158}, CountryId{"IN"}}, // Khadur Sahib railway station
    {Coordinate{75.1101, 31.3707}, CountryId{"IN"}}, // Govindwal Sahib railway station
    {Coordinate{12.2728, 57.7694}, CountryId{"SE"}}, // Lerum railway station
    {Coordinate{76.0107, 27.9665}, CountryId{"IN"}}, // Nizampur railway station
    {Coordinate{75.6018, 28.1862}, CountryId{"IN"}}, // Nari Khetri railway station
    {Coordinate{75.7973, 28.3835}, CountryId{"IN"}}, // Bhavdhari railway station
    {Coordinate{74.5545, 30.9879}, CountryId{"IN"}}, // Husainiwala railway station
    {Coordinate{74.6118, 31.1677}, CountryId{"IN"}}, // Rattoke Gurdwara railway station
    {Coordinate{74.6677, 31.1973}, CountryId{"IN"}}, // Valtoha railway station
    {Coordinate{74.733, 31.2233}, CountryId{"IN"}}, // Gharyala railway station
    {Coordinate{74.7822, 31.2431}, CountryId{"IN"}}, // Boparai railway station
    {Coordinate{74.8687, 31.336}, CountryId{"IN"}}, // Kairon railway station
    {Coordinate{74.885, 31.3783}, CountryId{"IN"}}, // Jandoke railway station
    {Coordinate{74.9112, 31.4114}, CountryId{"IN"}}, // Rure Asal railway station
    {Coordinate{74.909, 31.4998}, CountryId{"IN"}}, // Dukhnawaran railway station
    {Coordinate{74.8994, 31.5327}, CountryId{"IN"}}, // Gohlwar Varpal railway station
    {Coordinate{75.2892, 31.83}, CountryId{"IN"}}, // Vadala Granthian railway station
    {Coordinate{75.5871, 31.1821}, CountryId{"IN"}}, // Thabalke railway station
    {Coordinate{76.1277, 31.1678}, CountryId{"IN"}}, // Alachor railway station
    {Coordinate{6.90844, 49.4082}, CountryId{"DE"}}, // Signal box
    {Coordinate{8.9388, 49.8945}, CountryId{"DE"}}, // Groß-Umstadt Klein-Umstadt railway station
    {Coordinate{8.9243, 49.8648}, CountryId{"DE"}}, // Groß-Umstadt Mitte railway station
    {Coordinate{8.6876, 49.8608}, CountryId{"DE"}}, // Darmstadt TU-Lichtwiese railway station
    {Coordinate{79.8647, 23.1414}, CountryId{"IN"}}, // Garha railway station
    {Coordinate{11.56, 48.1413}, CountryId{"DE"}}, // München Hbf (tief) station
    {Coordinate{94.752, 26.917}, CountryId{"IN"}}, // Simaluguri Junction railway station
    {Coordinate{76.8307, 17.3821}, CountryId{"IN"}}, // Taj Sultanpur railway station
    {Coordinate{76.8954, 17.476}, CountryId{"IN"}}, // Kurukotta railway station
    {Coordinate{76.9797, 17.5868}, CountryId{"IN"}}, // Kamalapur railway station
    {Coordinate{77.0686, 17.6711}, CountryId{"IN"}}, // Hallikhed K. railway station
    {Coordinate{10.7324, 48.3337}, CountryId{"DE"}}, // Gessertshausen station
    {Coordinate{76.0084, 31.7711}, CountryId{"IN"}}, // Daulatpur Chauk railway station
    {Coordinate{78.2781, 30.11}, CountryId{"IN"}}, // Yog Nagari Rishikesh railway station
    {Coordinate{77.1144, 30.9292}, CountryId{"IN"}}, // Solan Brewery railway station
    {Coordinate{7.37835, 49.252}, CountryId{"DE"}}, // Zweibrücken Rosengarten
    {Coordinate{7.81086, 48.0288}, CountryId{"DE"}}, // Freiburg-Landwasser station
    {Coordinate{11.3943, 50.95}, CountryId{"DE"}}, // Mellingen
    {Coordinate{45.4103, 50.0928}, CountryId{"RU"}}, // Q105708044
    {Coordinate{79.3027, 14.055}, CountryId{"IN"}}, // Mangampet Road railway station
    {Coordinate{79.3993, 14.1421}, CountryId{"IN"}}, // Cherlopalli railway station
    {Coordinate{79.559, 14.2299}, CountryId{"IN"}}, // Rapuru railway station
    {Coordinate{79.6134, 14.2759}, CountryId{"IN"}}, // Adurupalli railway station
    {Coordinate{79.8438, 14.3193}, CountryId{"IN"}}, // Kasumuru railway station
    {Coordinate{79.9365, 16.8126}, CountryId{"IN"}}, // Mellacheruvu railway station
    {Coordinate{80.0068, 16.852}, CountryId{"IN"}}, // Revur Ramapuram railway station
    {Coordinate{80.1894, 16.9128}, CountryId{"IN"}}, // Makkapeta railway station
    {Coordinate{83.6163, 20.7355}, CountryId{"IN"}}, // Bichhupali railway station
    {Coordinate{75.1719, 29.0067}, CountryId{"IN"}}, // Kalana railway station
    {Coordinate{18.9611, 47.5358}, CountryId{"HU"}}, // Hárshegy
    {Coordinate{74.564, 28.0606}, CountryId{"IN"}}, // Payli railway station
    {Coordinate{71.9749, 24.176}, CountryId{"IN"}}, // Khemana railway station
    {Coordinate{7.8333, 47.6539}, CountryId{"DE"}}, // Schopfheim-Schlattholz station
    {Coordinate{71.7906, 23.1826}, CountryId{"IN"}}, // Patdi railway station
    {Coordinate{76.6406, 18.9296}, CountryId{"IN"}}, // Vadgaon Nila railway station
    {Coordinate{76.3174, 12.9428}, CountryId{"IN"}}, // Samudhravalli railway station
    {Coordinate{74.7694, 30.6706}, CountryId{"IN"}}, // Faridnagar railway station
    {Coordinate{74.6841, 31.606}, CountryId{"IN"}}, // Gurusar Sutlani railway station
    {Coordinate{17.1675, 59.2486}, CountryId{"SE"}}, // Läggesta railway station
    {Coordinate{61.365, 54.4442}, CountryId{"RU"}}, // Q105751765
    {Coordinate{10.0058, 57.4549}, CountryId{"DK"}}, // Hjørring East station
    {Coordinate{72.6301, 22.3235}, CountryId{"IN"}}, // Khambhat railway station
    {Coordinate{92.772, 26.8192}, CountryId{"IN"}}, // Balipara railway station
    {Coordinate{72.711, 23.9591}, CountryId{"IN"}}, // Taranga Hill railway station
    {Coordinate{75.7341, 22.6192}, CountryId{"IN"}}, // Tihi railway station
    {Coordinate{76.6401, 28.7415}, CountryId{"IN"}}, // Dighal railway station
    {Coordinate{79.5605, 10.4434}, CountryId{"IN"}}, // Tillaivilagam railway station
    {Coordinate{78.8731, 10.1216}, CountryId{"IN"}}, // Periyakottai railway station
    {Coordinate{71.4742, 20.9318}, CountryId{"IN"}}, // Pipavav railway station
    {Coordinate{71.3919, 23.1356}, CountryId{"IN"}}, // Kuda railway station
    {Coordinate{75.6509, 16.1228}, CountryId{"IN"}}, // Sulikeri railway station
    {Coordinate{80.006, 14.2644}, CountryId{"IN"}}, // Nidiguntapalem railway station
    {Coordinate{77.582, 27.5114}, CountryId{"IN"}}, // Mora railway station
    {Coordinate{79.6402, 10.6052}, CountryId{"IN"}}, // Alattambadi railway station
    {Coordinate{79.6154, 10.4771}, CountryId{"IN"}}, // Pandi railway station
    {Coordinate{75.468, 16.1643}, CountryId{"IN"}}, // Kajjidoni railway station
    {Coordinate{12.223, 47.4414}, CountryId{"AT"}}, // Q105771112
    {Coordinate{7.61168, 47.6128}, CountryId{"DE"}}, // Haltingen station
    {Coordinate{11.4136, 48.1053}, CountryId{"DE"}}, // Planegg station
    {Coordinate{11.3761, 48.0707}, CountryId{"DE"}}, // Gauting station
    {Coordinate{11.4008, 48.0933}, CountryId{"DE"}}, // Stockdorf station
    {Coordinate{11.4256, 48.1198}, CountryId{"DE"}}, // Gräfelfing station
    {Coordinate{11.4309, 48.1282}, CountryId{"DE"}}, // Lochham station
    {Coordinate{28.7883, 61.1702}, CountryId{"FI"}}, // Imatrankoski railway station
    {Coordinate{12.7793, 50.1585}, CountryId{"CZ"}}, // Horní Slavkov zastávka
    {Coordinate{12.7722, 50.1718}, CountryId{"CZ"}}, // Q105853472
    {Coordinate{27.5792, 64.0647}, CountryId{"FI"}}, // Murtomäki railway station
    {Coordinate{12.6492, 55.6308}, CountryId{"DK"}}, // Lufthavnen Station
    {Coordinate{126.624, 45.7585}, CountryId{"CN"}}, // Harbin railway station
    {Coordinate{38.6851, 55.0701}, CountryId{"RU"}}, // Lystsovskaya
    {Coordinate{38.6565, 55.0619}, CountryId{"RU"}}, // Semyonovsky
    {Coordinate{38.6224, 55.0313}, CountryId{"RU"}}, // 18 km
    {Coordinate{38.606, 54.9868}, CountryId{"RU"}}, // Kudryavtsevo
    {Coordinate{38.582, 54.9464}, CountryId{"RU"}}, // Danilovskaya
    {Coordinate{38.5561, 54.9244}, CountryId{"RU"}}, // 30 km
    {Coordinate{13.7649, 51.374}, CountryId{"DE"}}, // Bahnhof Ortrand
    {Coordinate{12.7944, 52.9266}, CountryId{"DE"}}, // Neuruppin West railway station
    {Coordinate{34.7086, 48.4853}, CountryId{"UA"}}, // 11 km
    {Coordinate{15.3047, 62.8299}, CountryId{"SE"}}, // Stavre
    {Coordinate{15.2287, 62.9113}, CountryId{"SE"}}, // Gällö
    {Coordinate{13.3766, 52.5094}, CountryId{"DE"}}, // Potsdamer Platz S-Bahn station
    {Coordinate{15.0408, 62.9548}, CountryId{"SE"}}, // Pilgrimstad
    {Coordinate{7.14385, 50.5474}, CountryId{"DE"}}, // Bahnhof Bad Neuenahr
    {Coordinate{11.1796, 48.8934}, CountryId{"DE"}}, // Eichstätt Stadt
    {Coordinate{11.1679, 48.8753}, CountryId{"DE"}}, // Wasserzell (b Eichstätt)
    {Coordinate{11.1694, 48.8923}, CountryId{"DE"}}, // Rebdorf-Hofmühle
    {Coordinate{16.4575, 57.2631}, CountryId{"SE"}}, // Oskarshamn railway station
    {Coordinate{7.66268, 46.5574}, CountryId{"CH"}}, // Kandergrund railway station
    {Coordinate{8.62248, 46.7294}, CountryId{"CH"}}, // Gurtnellen railway station
    {Coordinate{8.67211, 46.781}, CountryId{"CH"}}, // Amsteg-Silenen railway station
    {Coordinate{8.74056, 46.4902}, CountryId{"CH"}}, // Rodi-Fiesso railway station
    {Coordinate{7.05695, 49.2436}, CountryId{"DE"}}, // Scheidt (Saar)
    {Coordinate{3.46114, 46.0618}, CountryId{"FR"}}, // Gare de Saint-Yorre
    {Coordinate{18.6274, 46.2361}, CountryId{"HU"}}, // Q106303576
    {Coordinate{33.1243, 57.1341}, CountryId{"RU"}}, // Ostashkov
    {Coordinate{9.01696, 46.2532}, CountryId{"CH"}}, // Claro railway station
    {Coordinate{8.9944, 46.2992}, CountryId{"CH"}}, // Osogna-Cresciano railway station
    {Coordinate{13.6577, 63.3086}, CountryId{"SE"}}, // Mörsil
    {Coordinate{24.147, 41.1404}, CountryId{"GR"}}, // Drama railway station
    {Coordinate{8.65052, 46.7601}, CountryId{"CH"}}, // Intschi railway station
    {Coordinate{34.1121, 57.8569}, CountryId{"RU"}}, // Bologoe-Polotskoye
    {Coordinate{-1.56606, 48.5298}, CountryId{"FR"}}, // Pleine-Fougères railway station
    {Coordinate{9.52691, 49.202}, CountryId{"DE"}}, // Öhringen-Cappel
    {Coordinate{8.77518, 49.1362}, CountryId{"DE"}}, // Menzingen (Baden)
    {Coordinate{8.10606, 47.9063}, CountryId{"DE"}}, // Hinterzarten
    {Coordinate{9.28621, 49.1482}, CountryId{"DE"}}, // Bahnhof Weinsberg
    {Coordinate{8.55052, 48.7486}, CountryId{"DE"}}, // Bad Wildbad Kurpark
    {Coordinate{28.2942, 53.0803}, CountryId{"BY"}}, // Alyaksandrawka
    {Coordinate{10.0899, 46.6977}, CountryId{"CH"}}, // Zernez railway station
    {Coordinate{9.90568, 46.4856}, CountryId{"CH"}}, // Surovas railway station
    {Coordinate{10.0543, 46.3248}, CountryId{"CH"}}, // Poschiavo railway station
    {Coordinate{10.0996, 46.2731}, CountryId{"CH"}}, // Miralago railway station
    {Coordinate{8.40432, 46.5672}, CountryId{"CH"}}, // Muttbach-Belvédère railway station
    {Coordinate{8.76977, 46.6811}, CountryId{"CH"}}, // Sedrun railway station
    {Coordinate{8.508, 47.3647}, CountryId{"CH"}}, // Zürich Friesenberg railway station
    {Coordinate{8.62075, 46.9493}, CountryId{"CH"}}, // Sisikon railway station
    {Coordinate{7.95892, 46.7366}, CountryId{"CH"}}, // Oberried am Brienzersee railway station
    {Coordinate{7.99002, 46.7526}, CountryId{"CH"}}, // Ebligen railway station
    {Coordinate{8.31016, 46.9826}, CountryId{"CH"}}, // Hergiswil railway station
    {Coordinate{8.3033, 47.0351}, CountryId{"CH"}}, // Lucerne Allmend/Messe railway station
    {Coordinate{8.54448, 47.2867}, CountryId{"CH"}}, // Langnau-Gattikon railway station
    {Coordinate{8.53508, 47.2967}, CountryId{"CH"}}, // Wildpark-Höfli railway station
    {Coordinate{8.52522, 47.3032}, CountryId{"CH"}}, // Sihlau railway station
    {Coordinate{8.5215, 47.3197}, CountryId{"CH"}}, // Sood-Oberleimbach railway station
    {Coordinate{8.87823, 47.3688}, CountryId{"CH"}}, // Bauma railway station
    {Coordinate{8.75207, 47.2359}, CountryId{"CH"}}, // Uerikon railway station
    {Coordinate{9.3103, 46.8074}, CountryId{"CH"}}, // Versam-Safien railway station
    {Coordinate{9.70333, 46.7978}, CountryId{"CH"}}, // Litzirüti railway station
    {Coordinate{3.71896, 45.2763}, CountryId{"FR"}}, // Gare de Sembadel
    {Coordinate{29.9498, 56.039}, CountryId{"RU"}}, // Nevel I
    {Coordinate{11.0611, 50.561}, CountryId{"DE"}}, // Katzhütte
    {Coordinate{8.59615, 47.3973}, CountryId{"CH"}}, // Stettbach, Bahnhof
    {Coordinate{9.11748, 51.4079}, CountryId{"DE"}}, // Volkmarsen
    {Coordinate{5.36634, 43.305}, CountryId{"FR"}}, // Q106452859
    {Coordinate{10.8696, 48.0542}, CountryId{"DE"}}, // Landsberg (Lech) Schule station
    {Coordinate{10.1036, 48.8586}, CountryId{"DE"}}, // Wasseralfingen station
    {Coordinate{12.7275, 56.0236}, CountryId{"SE"}}, // Ramlösa railway station
    {Coordinate{39.3626, 54.7159}, CountryId{"RU"}}, // Zhitovo
    {Coordinate{39.7372, 47.1065}, CountryId{"RU"}}, // Q106498321
    {Coordinate{33.9465, 54.0121}, CountryId{"RU"}}, // Betlitsa
    {Coordinate{11.043, 47.481}, CountryId{"DE"}}, // Untergrainau train station
    {Coordinate{11.2801, 50.9004}, CountryId{"DE"}}, // Bad Berka Zeughausplatz
    {Coordinate{9.96922, 53.5644}, CountryId{"DE"}}, // Sternschanze
    {Coordinate{9.38083, 50.0226}, CountryId{"DE"}}, // Heigenbrücken railway station
    {Coordinate{9.33798, 47.3214}, CountryId{"CH"}}, // Gonten Alpsteinblick railway station
    {Coordinate{23.3211, 41.0425}, CountryId{"GR"}}, // Rodopoli railway station
    {Coordinate{39.6114, 47.2484}, CountryId{"RU"}}, // Rostov-Zapadnyi
    {Coordinate{39.2436, 54.7111}, CountryId{"RU"}}, // Kostyonkovo
    {Coordinate{16.4602, 47.834}, CountryId{"AT"}}, // Bahnhof Müllendorf
    {Coordinate{10.8326, 48.1554}, CountryId{"DE"}}, // Klosterlechfeld station
    {Coordinate{10.8442, 48.1829}, CountryId{"DE"}}, // Lagerlechfeld station
    {Coordinate{10.8518, 48.2359}, CountryId{"DE"}}, // Oberottmarshausen station
    {Coordinate{10.8524, 48.1991}, CountryId{"DE"}}, // Graben (Lechfeld) Gewerbepark station
    {Coordinate{-0.94483, 43.3915}, CountryId{"FR"}}, // Q106660716
    {Coordinate{39.2305, 54.7087}, CountryId{"RU"}}, // Latygory
    {Coordinate{6.89185, 49.4073}, CountryId{"DE"}}, // Lebach-Jabach station
    {Coordinate{4.78328, 44.8059}, CountryId{"FR"}}, // Q106686055
    {Coordinate{13.755, 50.636}, CountryId{"CZ"}}, // Jeníkov-Oldřichov
    {Coordinate{14.1521, 49.3021}, CountryId{"CZ"}}, // Písek jih
    {Coordinate{14.0011, 49.6741}, CountryId{"CZ"}}, // Q106712975
    {Coordinate{13.8522, 58.3894}, CountryId{"SE"}}, // Skövde Central Station
    {Coordinate{36.0409, 54.467}, CountryId{"RU"}}, // Vorotynsk
    {Coordinate{39.0499, 54.6438}, CountryId{"RU"}}, // 35 km
    {Coordinate{0.747761, 47.8302}, CountryId{"FR"}}, // Q106764524
    {Coordinate{16.9397, 48.7839}, CountryId{"CZ"}}, // Q106766889
    {Coordinate{39.0051, 54.6269}, CountryId{"RU"}}, // Vereykino
    {Coordinate{38.9643, 54.6025}, CountryId{"RU"}}, // Zhokovo
    {Coordinate{35.7391, 54.3881}, CountryId{"RU"}}, // Babynino
    {Coordinate{15.5408, 48.7484}, CountryId{"AT"}}, // Bahnhof Irnfritz
    {Coordinate{17.0281, 59.3703}, CountryId{"SE"}}, // Strängnäs railway station
    {Coordinate{38.9126, 54.5835}, CountryId{"RU"}}, // 24 km
    {Coordinate{13.8007, 48.0789}, CountryId{"AT"}}, // Bahnhof Breitenschützing
    {Coordinate{14.1554, 47.833}, CountryId{"AT"}}, // Bahnhof Klaus
    {Coordinate{14.7244, 50.9523}, CountryId{"DE"}}, // railway stop Niederoderwitz
    {Coordinate{38.8788, 54.5705}, CountryId{"RU"}}, // 22 km
    {Coordinate{14.6787, 50.9739}, CountryId{"DE"}}, // railway stop Oberoderwitz Oberdorf
    {Coordinate{38.8339, 54.5747}, CountryId{"RU"}}, // 18 km
    {Coordinate{7.12088, 49.9516}, CountryId{"DE"}}, // Traben-Trarbach
    {Coordinate{38.7767, 54.5411}, CountryId{"RU"}}, // 12 km
    {Coordinate{13.8383, 46.6087}, CountryId{"AT"}}, // Villach Westbahnhof
    {Coordinate{17.3156, 62.3863}, CountryId{"SE"}}, // Sundsvall central station
    {Coordinate{17.2923, 62.3896}, CountryId{"SE"}}, // Sundsvall West
    {Coordinate{2.94991, 50.5332}, CountryId{"FR"}}, // Q106855089
    {Coordinate{11.0486, 51.8826}, CountryId{"DE"}}, // Bahnhof Halberstadt-Spiegelsberge
    {Coordinate{35.5432, 54.2504}, CountryId{"RU"}}, // Kudrinskaya
    {Coordinate{9.23206, 48.8037}, CountryId{"DE"}}, // Ebitzweg
    {Coordinate{15.2025, 59.2697}, CountryId{"SE"}}, // Örebro southern station
    {Coordinate{14.5834, 56.0495}, CountryId{"SE"}}, // Sölvesborgs station
    {Coordinate{2.88274, 47.5187}, CountryId{"FR"}}, // Neuvy-sur-Loire Train Station
    {Coordinate{34.7892, 53.6089}, CountryId{"RU"}}, // Sudimir
    {Coordinate{10.376, 48.4818}, CountryId{"DE"}}, // Offingen station
    {Coordinate{10.4079, 48.456}, CountryId{"DE"}}, // Mindelaltheim station
    {Coordinate{10.427, 48.4248}, CountryId{"DE"}}, // Burgau (Schwab) station
    {Coordinate{10.4455, 48.3991}, CountryId{"DE"}}, // Jettingen station
    {Coordinate{10.5022, 48.3847}, CountryId{"DE"}}, // Freihalden station
    {Coordinate{10.6963, 48.3348}, CountryId{"DE"}}, // Kutzenhausen station
    {Coordinate{10.0479, 48.433}, CountryId{"DE"}}, // Thalfingen (b Ulm) station
    {Coordinate{10.7768, 48.3561}, CountryId{"DE"}}, // Diedorf (Schwab) station
    {Coordinate{10.8182, 48.386}, CountryId{"DE"}}, // Westheim (Schwab) station
    {Coordinate{10.8335, 48.3944}, CountryId{"DE"}}, // Neusäß station
    {Coordinate{34.7201, 53.4997}, CountryId{"RU"}}, // Berezovsky
    {Coordinate{-0.3958, 51.6635}, CountryId{"GB"}}, // Watford Junction railway station
    {Coordinate{11.2004, 49.4715}, CountryId{"DE"}}, // Schwaig station
    {Coordinate{11.2311, 49.4794}, CountryId{"DE"}}, // Röthenbach (Pegnitz) station
    {Coordinate{11.2462, 49.4834}, CountryId{"DE"}}, // Röthenbach-Steinberg station
    {Coordinate{11.2615, 49.4915}, CountryId{"DE"}}, // Röthenbach-Seespitze station
    {Coordinate{11.278, 49.5011}, CountryId{"DE"}}, // Lauf West station
    {Coordinate{11.286, 49.5071}, CountryId{"DE"}}, // Lauf (links Pegnitz) station
    {Coordinate{11.3397, 49.5078}, CountryId{"DE"}}, // Ottensoos station
    {Coordinate{2.30889, 48.8911}, CountryId{"FR"}}, // Gare de Paris-Batignolles
    {Coordinate{13.6836, 47.5575}, CountryId{"AT"}}, // Obertraun-Dachsteinhöhlen railway station
    {Coordinate{11.0446, 49.3382}, CountryId{"DE"}}, // Schwabach-Limbach station
    {Coordinate{9.07148, 48.8705}, CountryId{"DE"}}, // Schwieberdingen
    {Coordinate{12.0599, 48.0829}, CountryId{"DE"}}, // Tulling
    {Coordinate{13.1604, 49.0211}, CountryId{"DE"}}, // Langdorf railway station
    {Coordinate{11.0637, 49.3039}, CountryId{"DE"}}, // Rednitzhembach station
    {Coordinate{11.0742, 49.2678}, CountryId{"DE"}}, // Büchenbach station
    {Coordinate{11.4137, 49.2883}, CountryId{"DE"}}, // Pölling station
    {Coordinate{17.9036, 59.2053}, CountryId{"SE"}}, // Tullinge railway station
    {Coordinate{39.7453, 47.1005}, CountryId{"RU"}}, // Tehnikum railway station
    {Coordinate{39.6351, 47.1904}, CountryId{"RU"}}, // Gnilovskaya railway station
    {Coordinate{11.923, 58.354}, CountryId{"SE"}}, // Uddevalla central station
    {Coordinate{10.4129, 49.5065}, CountryId{"DE"}}, // Bad Windsheim railway station
    {Coordinate{10.5878, 49.5769}, CountryId{"DE"}}, // Neustadt (Aisch) Bahnhof
    {Coordinate{10.6096, 49.5743}, CountryId{"DE"}}, // Neustadt (Aisch) Mitte
    {Coordinate{10.8855, 49.9296}, CountryId{"DE"}}, // Hallstadt (b Bamberg) station
    {Coordinate{12.1643, 53.1446}, CountryId{"DE"}}, // Pritzwalk West
    {Coordinate{12.3175, 58.3775}, CountryId{"SE"}}, // Vänersborg railway station
    {Coordinate{4.54806, 47.8736}, CountryId{"FR"}}, // Gare de Sainte-Colombe-sur-Seine
    {Coordinate{12.8537, 56.246}, CountryId{"SE"}}, // Ängelholm station
    {Coordinate{18.7052, 63.2879}, CountryId{"SE"}}, // Örnsköldsvik Central station
    {Coordinate{14.0928, 51.4471}, CountryId{"DE"}}, // Lauta (Niederlausitz)
    {Coordinate{16.3194, 57.99}, CountryId{"SE"}}, // Överums Bruk railway station
    {Coordinate{9.00614, 47.85}, CountryId{"DE"}}, // Stockach station
    {Coordinate{39.6593, 55.474}, CountryId{"RU"}}, // Osanovo
    {Coordinate{9.75221, 47.925}, CountryId{"DE"}}, // Bad Waldsee station
    {Coordinate{9.3441, 47.9228}, CountryId{"DE"}}, // Burgweiler station
    {Coordinate{33.8454, 61.877}, CountryId{"RU"}}, // 509 km railway halt, Pryazhinsky District
    {Coordinate{17.561, 46.6821}, CountryId{"HU"}}, // Q107392219
    {Coordinate{52.0089, 55.3127}, CountryId{"RU"}}, // Q107392564
    {Coordinate{9.3789, 47.9465}, CountryId{"DE"}}, // Ostrach station
    {Coordinate{9.25573, 47.9229}, CountryId{"DE"}}, // Pfullendorf railway stop
    {Coordinate{39.6734, 55.4006}, CountryId{"RU"}}, // Pozhoga
    {Coordinate{8.86091, 48.4491}, CountryId{"DE"}}, // Bieringen (b Horb) station
    {Coordinate{8.89668, 48.4606}, CountryId{"DE"}}, // Bad Niedernau station
    {Coordinate{39.645, 55.3333}, CountryId{"RU"}}, // 29 km
    {Coordinate{8.97405, 48.4795}, CountryId{"DE"}}, // Kiebingen railway stop
    {Coordinate{9.03034, 48.3956}, CountryId{"DE"}}, // Bad Sebastiansweiler-Belsen railway stop
    {Coordinate{6.55706, 49.6061}, CountryId{"DE"}}, // Saarburg train station
    {Coordinate{7.18825, 43.7207}, CountryId{"FR"}}, // Gare de Lingostière
    {Coordinate{6.8912, 43.9547}, CountryId{"FR"}}, // Category:Gare de Puget-Théniers
    {Coordinate{7.19667, 43.8575}, CountryId{"FR"}}, // Gare de Plan-du-Var
    {Coordinate{0.869225, 47.758}, CountryId{"FR"}}, // railway station of Montoire-sur-le-Loir
    {Coordinate{8.98236, 48.6792}, CountryId{"DE"}}, // Haltepunkt Böblingen-Hulb
    {Coordinate{4.70585, 49.3895}, CountryId{"FR"}}, // Gare ferroviaire de Vouziers
    {Coordinate{39.6496, 55.2634}, CountryId{"RU"}}, // Barmino
    {Coordinate{9.62132, 47.8307}, CountryId{"DE"}}, // Niederbiegen station
    {Coordinate{9.59462, 47.7659}, CountryId{"DE"}}, // Weißenau railway stop
    {Coordinate{39.6632, 55.2243}, CountryId{"RU"}}, // Sazonovo
    {Coordinate{}, CountryId{"AT"}}, // Zeltweg railway station
    {Coordinate{39.753, 47.1113}, CountryId{"RU"}}, // VCD railway station
    {Coordinate{14.309, 47.7243}, CountryId{"AT"}}, // Bahnhof Roßleithen
    {Coordinate{12.5942, 51.2771}, CountryId{"DE"}}, // Naunhof
    {Coordinate{60.4565, 55.9122}, CountryId{"RU"}}, // Category:Mauk railway station
    {Coordinate{2.63222, 48.0425}, CountryId{"FR"}}, // Gare de Mignères - Gondreville
    {Coordinate{2.55139, 48.0661}, CountryId{"FR"}}, // Gare de Lorcy-Corbeilles
    {Coordinate{2.23778, 48.2364}, CountryId{"FR"}}, // Gare d'Engenville
    {Coordinate{9.61697, 47.817}, CountryId{"DE"}}, // Weingarten/Berg railway stop
    {Coordinate{7.45997, 51.4967}, CountryId{"DE"}}, // Westfalenhallen station
    {Coordinate{12.0614, 49.6314}, CountryId{"DE"}}, // Weiherhammer station
    {Coordinate{39.6207, 55.1898}, CountryId{"RU"}}, // 47 km
    {Coordinate{7.96325, 51.1535}, CountryId{"DE"}}, // Heggen station
    {Coordinate{9.63811, 47.8728}, CountryId{"DE"}}, // Mochenwangen station
    {Coordinate{11.9942, 57.6975}, CountryId{"SE"}}, // Liseberg station
    {Coordinate{15.986, 47.3903}, CountryId{"AT"}}, // Bahnhof Rohrbach-Vorau
    {Coordinate{35.2174, 54.0231}, CountryId{"RU"}}, // Zhivodovka
    {Coordinate{1.515, 48.4258}, CountryId{"FR"}}, // Q108112580
    {Coordinate{1.6687, 48.3223}, CountryId{"FR"}}, // Q108112779
    {Coordinate{7.19321, 49.2442}, CountryId{"DE"}}, // Würzbach (Saar)
    {Coordinate{1.27528, 48.6019}, CountryId{"FR"}}, // Gare de Saint-Sauveur-Châteauneuf
    {Coordinate{34.8833, 53.7352}, CountryId{"RU"}}, // Zykeyevo
    {Coordinate{34.8256, 53.6606}, CountryId{"RU"}}, // Ozerskaya
    {Coordinate{34.9289, 53.7913}, CountryId{"RU"}}, // Solonovka
    {Coordinate{12.2148, 48.896}, CountryId{"DE"}}, // Hagelstadt
    {Coordinate{12.2086, 48.9319}, CountryId{"DE"}}, // Köfering
    {Coordinate{12.1694, 48.9679}, CountryId{"DE"}}, // Obertraubling
    {Coordinate{12.1468, 48.9902}, CountryId{"DE"}}, // Regensburg-Burgweinting
    {Coordinate{12.0378, 48.9907}, CountryId{"DE"}}, // Sinzing
    {Coordinate{7.01467, 50.6272}, CountryId{"DE"}}, // Meckenheim train station
    {Coordinate{10.0602, 53.5694}, CountryId{"DE"}}, // Wandsbeker Chaussee
    {Coordinate{14.0358, 57.1863}, CountryId{"SE"}}, // Värnamo station
    {Coordinate{13.7353, 57.3584}, CountryId{"SE"}}, // Gnosjö station
    {Coordinate{11.1958, 47.6787}, CountryId{"DE"}}, // Murnau Ort station
    {Coordinate{8.895, 52.0225}, CountryId{"DE"}}, // Lemgo railway station
    {Coordinate{8.84524, 52.0126}, CountryId{"DE"}}, // Hörstmar (Lippe) railway station
    {Coordinate{8.87788, 50.0528}, CountryId{"DE"}}, // Rodgau-Weiskirchen
    {Coordinate{8.74078, 51.981}, CountryId{"DE"}}, // Ehlenbruch railway station
    {Coordinate{8.71466, 51.9773}, CountryId{"DE"}}, // Helpup railway station
    {Coordinate{8.6661, 51.9788}, CountryId{"DE"}}, // Oerlinghausen railway station
    {Coordinate{8.63753, 51.9884}, CountryId{"DE"}}, // Ubbedissen railway station
    {Coordinate{8.5909, 52.0103}, CountryId{"DE"}}, // Oldentrup railway station
    {Coordinate{8.76543, 52.0272}, CountryId{"DE"}}, // Bad Salzuflen-Sylbach railway station
    {Coordinate{12.5636, 55.6713}, CountryId{"DK"}}, // Københavns Hovedbanegård
    {Coordinate{12.9355, 50.7951}, CountryId{"DE"}}, // Chemnitz-Reichenhain
    {Coordinate{12.5712, 55.6838}, CountryId{"DK"}}, // Nørreport Station
    {Coordinate{12.538, 55.7001}, CountryId{"DK"}}, // Nørrebro Station
    {Coordinate{3.13966, 43.3191}, CountryId{"FR"}}, // Gare de Colombiers
    {Coordinate{}, CountryId{"FR"}}, // Q108337741
    {Coordinate{16.3314, 56.9809}, CountryId{"SE"}}, // Blomstermåla station
    {Coordinate{8.74045, 52.0816}, CountryId{"DE"}}, // Bad Salzuflen railway station
    {Coordinate{15.8581, 57.6632}, CountryId{"SE"}}, // Vimmerby station
    {Coordinate{5.73543, 44.962}, CountryId{"FR"}}, // La Motte-d'Aveillans railway station
    {Coordinate{10.7337, 51.0898}, CountryId{"DE"}}, // Gräfentonna railway halt
    {Coordinate{15.6819, 58.1356}, CountryId{"SE"}}, // Rimforsa station
    {Coordinate{16.0274, 57.1659}, CountryId{"SE"}}, // Högsby station
    {Coordinate{12.1807, 49.4473}, CountryId{"DE"}}, // Nabburg
    {Coordinate{13.0515, 49.1915}, CountryId{"DE"}}, // Lam
    {Coordinate{35.1401, 53.8961}, CountryId{"RU"}}, // Duminichi
    {Coordinate{12.8519, 49.1729}, CountryId{"DE"}}, // Bad Kötzting
    {Coordinate{12.7432, 48.7405}, CountryId{"DE"}}, // Wallersdorf
    {Coordinate{11.9866, 47.6878}, CountryId{"DE"}}, // Osterhofen (Oberbay)
    {Coordinate{13.0184, 48.6956}, CountryId{"DE"}}, // Osterhofen (Niederbay)
    {Coordinate{12.0112, 47.6756}, CountryId{"DE"}}, // Bayrischzell
    {Coordinate{8.41571, 49.1295}, CountryId{"DE"}}, // Hochstetten Grenzstraße
    {Coordinate{7.27604, 50.5693}, CountryId{"DE"}}, // Linz (Rhein) train station
    {Coordinate{8.94454, 50.2833}, CountryId{"DE"}}, // Altenstadt (Hess) railway station
    {Coordinate{8.78945, 50.3526}, CountryId{"DE"}}, // Dorheim (Wetterau) railway station
    {Coordinate{8.8114, 50.3793}, CountryId{"DE"}}, // Melbach railway station
    {Coordinate{7.87303, 51.1087}, CountryId{"DE"}}, // Kraghammer railway halt
    {Coordinate{0.248972, 44.0593}, CountryId{"FR"}}, // Gare de Mézin, Lot-et-Garonne
    {Coordinate{6.56976, 51.067}, CountryId{"DE"}}, // Gustorf train station
    {Coordinate{6.62217, 51.1303}, CountryId{"DE"}}, // Kapellen-Wevelinghoven train stop
    {Coordinate{6.56655, 51.0461}, CountryId{"DE"}}, // Frimmersdorf train stop
    {Coordinate{9.78776, 48.6611}, CountryId{"DE"}}, // Gingen (Fils) station
    {Coordinate{9.73683, 48.6895}, CountryId{"DE"}}, // Salach Stop
    {Coordinate{8.49039, 47.9294}, CountryId{"DE"}}, // Hüfingen Mitte railway station
    {Coordinate{10.6096, 54.1355}, CountryId{"DE"}}, // Eutin railway station
    {Coordinate{7.03476, 49.3991}, CountryId{"DE"}}, // Wustweiler railway station
    {Coordinate{7.01254, 49.4153}, CountryId{"DE"}}, // Dirmingen railway station
    {Coordinate{6.96729, 49.4084}, CountryId{"DE"}}, // Eppelborn railway station
    {Coordinate{6.94881, 49.4107}, CountryId{"DE"}}, // Bubach railway halt
    {Coordinate{7.14308, 49.5812}, CountryId{"DE"}}, // Nohfelden Süd railway halt
    {Coordinate{13.4739, 52.7561}, CountryId{"DE"}}, // Wandlitzsee railway halt
    {Coordinate{13.4882, 52.7913}, CountryId{"DE"}}, // Klosterfelde railway station
    {Coordinate{13.5416, 52.8432}, CountryId{"DE"}}, // Ruhlsdorf-Zerpenschleuse railway station
    {Coordinate{13.5559, 52.8779}, CountryId{"DE"}}, // Klandorf railway station
    {Coordinate{33.7542, 48.104}, CountryId{"UA"}}, // Devladove railway station
    {Coordinate{12.1952, 51.403}, CountryId{"DE"}}, // Schkeuditz West railway stop
    {Coordinate{14.7536, 50.8622}, CountryId{"DE"}}, // Kurort Oybin-Niederdorf railway station
    {Coordinate{14.7517, 50.8531}, CountryId{"DE"}}, // Teufelsmühle railway halt
    {Coordinate{14.7456, 50.8434}, CountryId{"DE"}}, // Kurort Oybin railway station
    {Coordinate{14.7254, 50.862}, CountryId{"DE"}}, // Kurort Jonsdorf Hst railway halt
    {Coordinate{12.0256, 53.4668}, CountryId{"DE"}}, // Lübz
    {Coordinate{12.7824, 50.7281}, CountryId{"DE"}}, // Niederdorf (Erzgeb)
    {Coordinate{8.88975, 48.62}, CountryId{"DE"}}, // Haltepunkt Nufringen
    {Coordinate{21.2179, 55.6636}, CountryId{"LT"}}, // Rimkai railway station
    {Coordinate{21.4078, 55.519}, CountryId{"LT"}}, // Vilkyčiai railway station
    {Coordinate{21.8521, 55.9193}, CountryId{"LT"}}, // Plungė railway station
    {Coordinate{22.9358, 55.9791}, CountryId{"LT"}}, // Pavenčiai railway station
    {Coordinate{12.2059, 53.1701}, CountryId{"DE"}}, // Pritzwalk Hainholz
    {Coordinate{34.2374, 48.4825}, CountryId{"UA"}}, // Verkhivtseve Railway Station
    {Coordinate{12.4216, 51.8379}, CountryId{"DE"}}, // Wörlitz
    {Coordinate{8.9794, 48.7275}, CountryId{"DE"}}, // Maichingen Nord
    {Coordinate{14.1728, 50.6696}, CountryId{"CZ"}}, // Q108639367
    {Coordinate{14.1976, 50.6588}, CountryId{"CZ"}}, // Q108639368
    {Coordinate{23.6643, 55.7256}, CountryId{"LT"}}, // Gimbogala railway station
    {Coordinate{13.0489, 51.9316}, CountryId{"DE"}}, // Oehna
    {Coordinate{13.0851, 51.853}, CountryId{"DE"}}, // Linda (Elster)
    {Coordinate{13.1142, 51.7804}, CountryId{"DE"}}, // Holzdorf (Elster)
    {Coordinate{10.2361, 53.6694}, CountryId{"DE"}}, // Ahrensburg
    {Coordinate{12.4694, 51.2838}, CountryId{"DE"}}, // Leipzig-Liebertwolkwitz station
    {Coordinate{12.5065, 51.2578}, CountryId{"DE"}}, // Oberholz halt
    {Coordinate{12.5428, 51.2339}, CountryId{"DE"}}, // Belgershain station
    {Coordinate{12.6195, 51.175}, CountryId{"DE"}}, // Lauterbach-Steinbach halt
    {Coordinate{12.6626, 51.1057}, CountryId{"DE"}}, // Hopfgarten (Sachs) halt
    {Coordinate{12.6794, 51.0899}, CountryId{"DE"}}, // Tautenhain halt
    {Coordinate{12.5593, 51.0691}, CountryId{"DE"}}, // Frohburg station
    {Coordinate{12.5336, 51.0877}, CountryId{"DE"}}, // Neukirchen-Wyhra halt
    {Coordinate{12.503, 51.0986}, CountryId{"DE"}}, // Petergrube halt
    {Coordinate{12.4195, 51.1146}, CountryId{"DE"}}, // Deutzen halt
    {Coordinate{14.4241, 51.8186}, CountryId{"DE"}}, // Teichland railway halt
    {Coordinate{14.2233, 51.6552}, CountryId{"DE"}}, // Drebkau station
    {Coordinate{10.4889, 48.5812}, CountryId{"DE"}}, // Dillingen (Donau) railway station
    {Coordinate{10.4247, 48.5744}, CountryId{"DE"}}, // Lauingen railway station
    {Coordinate{10.2159, 48.4504}, CountryId{"DE"}}, // Leipheim railway halt
    {Coordinate{74.5535, 18.4671}, CountryId{"IN"}}, // Daund Chord Line railway station
    {Coordinate{10.0373, 48.3513}, CountryId{"DE"}}, // Gerlenhofen railway station
    {Coordinate{10.0503, 48.3239}, CountryId{"DE"}}, // Senden railway station
    {Coordinate{7.77135, 50.4863}, CountryId{"DE"}}, // Siershahn railway station
    {Coordinate{8.95515, 51.8816}, CountryId{"DE"}}, // Horn-Bad Meinberg station
    {Coordinate{10.0904, 48.2547}, CountryId{"DE"}}, // Bellenberg railway halt
    {Coordinate{10.1, 48.2227}, CountryId{"DE"}}, // Illertissen railway station
    {Coordinate{10.11, 48.1612}, CountryId{"DE"}}, // Altenstadt (Iller) railway station
    {Coordinate{8.9711, 51.8445}, CountryId{"DE"}}, // Leopoldstal station
    {Coordinate{10.0834, 48.4477}, CountryId{"DE"}}, // Oberelchingen railway halt
    {Coordinate{9.82911, 48.1894}, CountryId{"DE"}}, // Schemmerberg railway halt
    {Coordinate{9.80156, 48.1298}, CountryId{"DE"}}, // Warthausen railway station
    {Coordinate{9.08733, 45.5198}, CountryId{"IT"}}, // Rho Fiera metro station
    {Coordinate{9.80388, 48.6402}, CountryId{"DE"}}, // Kuchen (Fils) railway halt
    {Coordinate{9.82163, 48.6309}, CountryId{"DE"}}, // Geislingen West railway station
    {Coordinate{9.89479, 48.55}, CountryId{"DE"}}, // Urspring railway halt
    {Coordinate{9.91728, 48.5451}, CountryId{"DE"}}, // Lonsee railway station
    {Coordinate{9.94942, 48.5199}, CountryId{"DE"}}, // Westerstetten railway station
    {Coordinate{9.97681, 48.4813}, CountryId{"DE"}}, // Beimerstetten railway station
    {Coordinate{9.80571, 48.3998}, CountryId{"DE"}}, // Gerhausen railway stop
    {Coordinate{9.8977, 48.4178}, CountryId{"DE"}}, // Herrlingen railway station
    {Coordinate{9.91906, 48.4147}, CountryId{"DE"}}, // Blaustein railway stop
    {Coordinate{16.5438, 49.1651}, CountryId{"CZ"}}, // Q108705132
    {Coordinate{9.79301, 47.8413}, CountryId{"DE"}}, // Alttann railway halt
    {Coordinate{9.80867, 47.8242}, CountryId{"DE"}}, // Wolfegg railway halt
    {Coordinate{10.0751, 47.8879}, CountryId{"DE"}}, // Aichstetten station
    {Coordinate{10.0802, 47.9436}, CountryId{"DE"}}, // Marstetten-Aitrach railway halt
    {Coordinate{10.2906, 47.8129}, CountryId{"DE"}}, // Dietmannsried station
    {Coordinate{9.90202, 47.6289}, CountryId{"DE"}}, // Heimenkirch station
    {Coordinate{9.5745, 47.7517}, CountryId{"DE"}}, // Oberzell railway halt
    {Coordinate{11.2595, 48.5654}, CountryId{"DE"}}, // Schrobenhausen station
    {Coordinate{11.1622, 48.5146}, CountryId{"DE"}}, // Radersdorf station
    {Coordinate{}, CountryId{"FR"}}, // Gare de Maubourguet
    {Coordinate{10.8612, 48.4232}, CountryId{"DE"}}, // Gersthofen station
    {Coordinate{}, CountryId{"FR"}}, // Sorcy-gare
    {Coordinate{10.98, 47.2818}, CountryId{"AT"}}, // Bahnhof Stams
    {Coordinate{11.159, 47.7201}, CountryId{"DE"}}, // Uffing am Staffelsee station
    {Coordinate{11.1406, 47.7767}, CountryId{"DE"}}, // Huglfing station
    {Coordinate{11.1393, 47.5593}, CountryId{"DE"}}, // Oberau station
    {Coordinate{11.1149, 47.531}, CountryId{"DE"}}, // Farchant station
    {Coordinate{10.9461, 47.4782}, CountryId{"DE"}}, // Griesen (Oberbay) station
    {Coordinate{11.0392, 47.6702}, CountryId{"DE"}}, // Bad Kohlgrub Kurhaus station
    {Coordinate{11.1374, 47.667}, CountryId{"DE"}}, // Grafenaschau station
    {Coordinate{11.0582, 47.668}, CountryId{"DE"}}, // Bad Kohlgrub station
    {Coordinate{10.6185, 47.8148}, CountryId{"DE"}}, // Ebenhofen railway halt
    {Coordinate{10.6098, 47.7741}, CountryId{"DE"}}, // Marktoberdorf Schule railway halt
    {Coordinate{10.5812, 47.7457}, CountryId{"DE"}}, // Leuterschach railway halt
    {Coordinate{10.6013, 47.6972}, CountryId{"DE"}}, // Lengenwang station
    {Coordinate{10.6137, 47.6559}, CountryId{"DE"}}, // Seeg railway halt
    {Coordinate{10.6205, 47.6146}, CountryId{"DE"}}, // Weizern-Hopferau station
    {Coordinate{10.5894, 48.0525}, CountryId{"DE"}}, // Rammingen (Bay) railway halt
    {Coordinate{10.4376, 48.0281}, CountryId{"DE"}}, // Stetten (Schwab) station
    {Coordinate{10.3462, 48.012}, CountryId{"DE"}}, // Sontheim (Schwab) station
    {Coordinate{10.5038, 48.0782}, CountryId{"DE"}}, // Nassenbeuren railway halt
    {Coordinate{10.483, 48.1008}, CountryId{"DE"}}, // Hausen (Schwab) railway halt
    {Coordinate{10.452, 48.1177}, CountryId{"DE"}}, // Pfaffenhausen station
    {Coordinate{10.2981, 48.389}, CountryId{"DE"}}, // Hochwang railway halt
    {Coordinate{10.3021, 48.3701}, CountryId{"DE"}}, // Ichenhausen station
    {Coordinate{10.8248, 48.6609}, CountryId{"DE"}}, // Mertingen station
    {Coordinate{9.17333, 45.4617}, CountryId{"IT"}}, // Sant’Ambrogio metro station
    {Coordinate{}, CountryId{"FR"}}, // Gare de Gensac-la-Pallue
    {Coordinate{10.848, 48.491}, CountryId{"DE"}}, // Langweid (Lech) halt
    {Coordinate{10.8481, 48.5299}, CountryId{"DE"}}, // Herbertshofen railway stop
    {Coordinate{12.421, 51.4993}, CountryId{"DE"}}, // Hohenroda halt
    {Coordinate{12.4611, 51.4906}, CountryId{"DE"}}, // Krensitz halt
    {Coordinate{12.8195, 51.5056}, CountryId{"DE"}}, // Mockrehna station
    {Coordinate{13.1539, 51.5797}, CountryId{"DE"}}, // Rehfeld (Falkenberg/Elster) station
    {Coordinate{13.3606, 51.5902}, CountryId{"DE"}}, // Beutersitz station
    {Coordinate{13.8869, 51.7047}, CountryId{"DE"}}, // Gollmitz (Niederlausitz) station
    {Coordinate{12.3719, 51.8945}, CountryId{"DE"}}, // Klieken station
    {Coordinate{12.9718, 50.4212}, CountryId{"DE"}}, // Oberwiesenthal station
    {Coordinate{13.0299, 50.5078}, CountryId{"DE"}}, // Bärenstein (Kr Annaberg) railway stop
    {Coordinate{8.98704, 51.8184}, CountryId{"DE"}}, // Sandebeck station
    {Coordinate{12.5876, 51.3539}, CountryId{"DE"}}, // Gerichshain railway stop
    {Coordinate{13.0905, 50.7625}, CountryId{"DE"}}, // Waldkirchen (Erzgeb)
    {Coordinate{13.1761, 50.8573}, CountryId{"DE"}}, // Oederan railway station
    {Coordinate{13.2285, 50.9029}, CountryId{"DE"}}, // Frankenstein (Sachs) railway stop
    {Coordinate{13.2817, 50.9027}, CountryId{"DE"}}, // Kleinschirma railway stop
    {Coordinate{13.3798, 50.8682}, CountryId{"DE"}}, // Berthelsdorf (Erzgeb) Ort railway stop
    {Coordinate{13.4036, 50.84}, CountryId{"DE"}}, // Lichtenberg (Erzgeb) railway stop
    {Coordinate{33.187, 67.4596}, CountryId{"RU"}}, // Pitkul
    {Coordinate{12.6824, 51.3559}, CountryId{"DE"}}, // Altenbach railway stop
    {Coordinate{12.7086, 51.3559}, CountryId{"DE"}}, // Bennewitz railway stop
    {Coordinate{12.8337, 51.3494}, CountryId{"DE"}}, // Kühren railway stop
    {Coordinate{12.9838, 51.351}, CountryId{"DE"}}, // Dahlen (Sachs) railway station
    {Coordinate{12.0509, 51.4506}, CountryId{"DE"}}, // Dieskau railway stop
    {Coordinate{12.0992, 51.5511}, CountryId{"DE"}}, // Niemberg railway station
    {Coordinate{13.215, 50.6785}, CountryId{"DE"}}, // Strobelmühle railway halt
    {Coordinate{14.0322, 50.9537}, CountryId{"DE"}}, // Stadt Wehlen (Sachs) railway stop
    {Coordinate{6.3289, 51.1481}, CountryId{"DE"}}, // Mönchengladbach-Genhausen
    {Coordinate{7.74172, 48.1245}, CountryId{"DE"}}, // Bahlingen am Kaiserstuhl station
    {Coordinate{7.76014, 48.1058}, CountryId{"DE"}}, // Nimburg (Baden) railway station
    {Coordinate{7.74804, 48.0929}, CountryId{"DE"}}, // Eichstetten am Kaiserstuhl station
    {Coordinate{7.7282, 48.0758}, CountryId{"DE"}}, // Bötzingen Mühle station
    {Coordinate{7.72151, 48.0701}, CountryId{"DE"}}, // Bötzingen station
    {Coordinate{7.69993, 48.1443}, CountryId{"DE"}}, // Endingen am Kaiserstuhl station
    {Coordinate{7.65816, 48.1373}, CountryId{"DE"}}, // Königschaffhausen station
    {Coordinate{7.62035, 48.1387}, CountryId{"DE"}}, // Sasbach am Kaiserstuhl railway station
    {Coordinate{7.61069, 48.1197}, CountryId{"DE"}}, // Jechtingen station
    {Coordinate{7.61193, 48.104}, CountryId{"DE"}}, // Burkheim-Bischoffingen station
    {Coordinate{7.62104, 48.09}, CountryId{"DE"}}, // Oberrotweil station
    {Coordinate{7.60801, 48.0596}, CountryId{"DE"}}, // Achkarren station
    {Coordinate{}, CountryId{"IN"}}, // Molvom Railway Station
    {Coordinate{93.7125, 25.7604}, CountryId{"IN"}}, // Shokhuvi Railway Station
    {Coordinate{10.0307, 54.3128}, CountryId{"DE"}}, // Melsdorf station
    {Coordinate{88.4561, 27.0906}, CountryId{"IN"}}, // Melli Railway Station
    {Coordinate{88.4138, 26.9926}, CountryId{"IN"}}, // Riyang Railway Station
    {Coordinate{88.43, 27.06}, CountryId{"IN"}}, // Tista Bazaar Railway Station
    {Coordinate{9.19556, 45.4561}, CountryId{"IT"}}, // Crocetta metro station
    {Coordinate{9.0309, 51.7303}, CountryId{"DE"}}, // Bad Driburg (Westf)
    {Coordinate{9.18286, 51.712}, CountryId{"DE"}}, // Brakel (Höxter)
    {Coordinate{41.0752, 56.3627}, CountryId{"RU"}}, // Q108915834
    {Coordinate{40.5816, 56.2085}, CountryId{"RU"}}, // Q108915877
    {Coordinate{40.6416, 56.2344}, CountryId{"RU"}}, // Q108915957
    {Coordinate{40.6773, 56.2445}, CountryId{"RU"}}, // Q108916204
    {Coordinate{40.7866, 56.269}, CountryId{"RU"}}, // Q108916239
    {Coordinate{40.8694, 56.2857}, CountryId{"RU"}}, // Q108916266
    {Coordinate{40.9309, 56.3148}, CountryId{"RU"}}, // Q108916288
    {Coordinate{40.9899, 56.3432}, CountryId{"RU"}}, // Q108916309
    {Coordinate{41.1172, 56.3721}, CountryId{"RU"}}, // Q108916376
    {Coordinate{41.1131, 56.3854}, CountryId{"RU"}}, // Q108916381
    {Coordinate{41.1822, 56.3784}, CountryId{"RU"}}, // Q108916420
    {Coordinate{41.2238, 56.3752}, CountryId{"RU"}}, // Q108916431
    {Coordinate{41.275, 56.3674}, CountryId{"RU"}}, // Q108916438
    {Coordinate{89.97, 26.08}, CountryId{"IN"}}, // Gauripur railway station
    {Coordinate{41.363, 56.3842}, CountryId{"RU"}}, // Q108920213
    {Coordinate{41.4036, 56.3925}, CountryId{"RU"}}, // Q108920219
    {Coordinate{41.5146, 56.3662}, CountryId{"RU"}}, // Q108920396
    {Coordinate{41.5529, 56.3448}, CountryId{"RU"}}, // Q108920441
    {Coordinate{41.6327, 56.3138}, CountryId{"RU"}}, // Q108920469
    {Coordinate{8.25284, 51.0206}, CountryId{"DE"}}, // Birkelbach railway station
    {Coordinate{8.08684, 51.0879}, CountryId{"DE"}}, // Kirchhundem-Flape railway station
    {Coordinate{8.07171, 51.1045}, CountryId{"DE"}}, // Lennestadt-Altenhundem railway station
    {Coordinate{18.3004, 49.8261}, CountryId{"CZ"}}, // Zárubek
    {Coordinate{9.51271, 46.8499}, CountryId{"CH"}}, // Chur West railway station
    {Coordinate{41.7087, 56.2985}, CountryId{"RU"}}, // Q108982622
    {Coordinate{41.7631, 56.2854}, CountryId{"RU"}}, // Q108983110
    {Coordinate{42.2689, 56.142}, CountryId{"RU"}}, // Q108986255
    {Coordinate{42.337, 56.1064}, CountryId{"RU"}}, // Q108986647
    {Coordinate{42.4158, 56.1069}, CountryId{"RU"}}, // Q108986829
    {Coordinate{42.5195, 56.1094}, CountryId{"RU"}}, // Q108987208
    {Coordinate{42.6534, 56.1173}, CountryId{"RU"}}, // Q108987457
    {Coordinate{42.814, 56.1593}, CountryId{"RU"}}, // Q109025639
    {Coordinate{42.8457, 56.18}, CountryId{"RU"}}, // Q109026075
    {Coordinate{42.9165, 56.2307}, CountryId{"RU"}}, // Q109026780
    {Coordinate{}, CountryId{"FR"}}, // Q109037573
    {Coordinate{42.9655, 56.2234}, CountryId{"RU"}}, // Q109087366
    {Coordinate{43.0646, 56.2141}, CountryId{"RU"}}, // Q109087825
    {Coordinate{43.174, 56.2249}, CountryId{"RU"}}, // Q109092135
    {Coordinate{13.0334, 51.7264}, CountryId{"DE"}}, // Annaburg West railway station
    {Coordinate{43.2053, 56.2251}, CountryId{"RU"}}, // Q109100392
    {Coordinate{43.2899, 56.2233}, CountryId{"RU"}}, // Q109100858
    {Coordinate{43.3208, 56.2227}, CountryId{"RU"}}, // Q109101291
    {Coordinate{43.5234, 56.2416}, CountryId{"RU"}}, // Q109101867
    {Coordinate{}, CountryId{"RU"}}, // Q109104543
    {Coordinate{43.7995, 56.2521}, CountryId{"RU"}}, // Q109104825
    {Coordinate{43.8289, 56.3669}, CountryId{"RU"}}, // Q109123386
    {Coordinate{43.8739, 56.3521}, CountryId{"RU"}}, // Q109124538
    {Coordinate{43.8114, 56.3737}, CountryId{"RU"}}, // Q109126316
    {Coordinate{43.7859, 56.3787}, CountryId{"RU"}}, // Q109126547
    {Coordinate{43.7614, 56.3827}, CountryId{"RU"}}, // Q109126882
    {Coordinate{43.7379, 56.3898}, CountryId{"RU"}}, // Q109127146
    {Coordinate{43.7113, 56.4041}, CountryId{"RU"}}, // Q109133518
    {Coordinate{-73.2489, 44.1809}, CountryId{"US"}}, // Ferrisburgh–Vergennes station
    {Coordinate{43.6483, 56.4216}, CountryId{"RU"}}, // Q109136669
    {Coordinate{43.6229, 56.4368}, CountryId{"RU"}}, // Q109136671
    {Coordinate{43.5772, 56.4843}, CountryId{"RU"}}, // Q109136673
    {Coordinate{43.5426, 56.5203}, CountryId{"RU"}}, // Q109136675
    {Coordinate{43.5317, 56.5309}, CountryId{"RU"}}, // Q109136677
    {Coordinate{43.5116, 56.544}, CountryId{"RU"}}, // Q109136678
    {Coordinate{43.4653, 56.5785}, CountryId{"RU"}}, // Q109136682
    {Coordinate{43.4268, 56.6089}, CountryId{"RU"}}, // Q109136684
    {Coordinate{43.4022, 56.6416}, CountryId{"RU"}}, // Q109136687
    {Coordinate{43.9821, 56.4063}, CountryId{"RU"}}, // Q109140784
    {Coordinate{10.6726, 47.5316}, CountryId{"AT"}}, // Q109141804
    {Coordinate{44.0503, 56.5213}, CountryId{"RU"}}, // Q109191707
    {Coordinate{44.5704, 56.8575}, CountryId{"RU"}}, // Q109191720
    {Coordinate{44.061, 56.5459}, CountryId{"RU"}}, // Q109192046
    {Coordinate{44.3458, 56.7332}, CountryId{"RU"}}, // Q109196485
    {Coordinate{44.4511, 56.781}, CountryId{"RU"}}, // Q109196488
    {Coordinate{44.6211, 56.9163}, CountryId{"RU"}}, // Q109196492
    {Coordinate{44.6914, 56.9625}, CountryId{"RU"}}, // Q109196495
    {Coordinate{44.7525, 56.9831}, CountryId{"RU"}}, // Q109196499
    {Coordinate{44.8894, 57.0449}, CountryId{"RU"}}, // Q109196502
    {Coordinate{44.8627, 57.1427}, CountryId{"RU"}}, // Q109208996
    {Coordinate{44.7904, 57.2041}, CountryId{"RU"}}, // Q109209000
    {Coordinate{44.7395, 57.2517}, CountryId{"RU"}}, // Q109209003
    {Coordinate{44.7309, 57.2728}, CountryId{"RU"}}, // Q109209006
    {Coordinate{44.6531, 57.3659}, CountryId{"RU"}}, // Q109209016
    {Coordinate{44.5936, 57.4763}, CountryId{"RU"}}, // Q109209019
    {Coordinate{44.578, 57.4855}, CountryId{"RU"}}, // Q109209022
    {Coordinate{45.0318, 57.1068}, CountryId{"RU"}}, // Q109218239
    {Coordinate{45.2508, 57.2387}, CountryId{"RU"}}, // Q109218241
    {Coordinate{45.3847, 57.3026}, CountryId{"RU"}}, // Q109218242
    {Coordinate{45.5288, 57.3635}, CountryId{"RU"}}, // Q109218243
    {Coordinate{45.6646, 57.4287}, CountryId{"RU"}}, // Q109218244
    {Coordinate{45.7938, 57.4634}, CountryId{"RU"}}, // Q109218245
    {Coordinate{45.9619, 57.4929}, CountryId{"RU"}}, // Q109218246
    {Coordinate{46.0743, 57.5255}, CountryId{"RU"}}, // Q109218247
    {Coordinate{46.3439, 57.5978}, CountryId{"RU"}}, // Q109218248
    {Coordinate{46.4816, 57.6438}, CountryId{"RU"}}, // Q109218249
    {Coordinate{46.7545, 57.7151}, CountryId{"RU"}}, // Q109225147
    {Coordinate{46.8583, 57.773}, CountryId{"RU"}}, // Q109225148
    {Coordinate{47.102, 57.8625}, CountryId{"RU"}}, // Q109225150
    {Coordinate{47.356, 57.9448}, CountryId{"RU"}}, // Q109225151
    {Coordinate{47.4458, 57.9747}, CountryId{"RU"}}, // Q109225152
    {Coordinate{47.5256, 58.0095}, CountryId{"RU"}}, // Q109225153
    {Coordinate{47.6088, 58.0406}, CountryId{"RU"}}, // Q109225154
    {Coordinate{47.6958, 58.0775}, CountryId{"RU"}}, // Q109225155
    {Coordinate{47.8626, 58.1399}, CountryId{"RU"}}, // Q109225158
    {Coordinate{47.9688, 58.1749}, CountryId{"RU"}}, // Q109225159
    {Coordinate{47.9985, 58.1847}, CountryId{"RU"}}, // Q109225160
    {Coordinate{48.034, 58.1964}, CountryId{"RU"}}, // Q109225161
    {Coordinate{48.1079, 58.2206}, CountryId{"RU"}}, // Q109225162
    {Coordinate{48.1548, 58.2339}, CountryId{"RU"}}, // Q109225163
    {Coordinate{48.2011, 58.2479}, CountryId{"RU"}}, // Q109225164
    {Coordinate{48.2862, 58.304}, CountryId{"RU"}}, // Q109225165
    {Coordinate{22.2516, 55.9929}, CountryId{"LT"}}, // Telšiai train station
    {Coordinate{48.2501, 58.3273}, CountryId{"RU"}}, // Q109247975
    {Coordinate{48.2237, 58.3244}, CountryId{"RU"}}, // Q109247976
    {Coordinate{48.17, 58.3058}, CountryId{"RU"}}, // Q109247977
    {Coordinate{48.1261, 58.2956}, CountryId{"RU"}}, // Q109247978
    {Coordinate{47.9885, 58.2787}, CountryId{"RU"}}, // Q109247979
    {Coordinate{47.927, 58.2798}, CountryId{"RU"}}, // Q109247980
    {Coordinate{47.8674, 58.2817}, CountryId{"RU"}}, // Q109247982
    {Coordinate{47.7795, 58.2767}, CountryId{"RU"}}, // Q109247983
    {Coordinate{47.6391, 58.2792}, CountryId{"RU"}}, // Q109247984
    {Coordinate{47.5793, 58.2809}, CountryId{"RU"}}, // Q109247985
    {Coordinate{48.3937, 58.292}, CountryId{"RU"}}, // Q109251699
    {Coordinate{48.4368, 58.2953}, CountryId{"RU"}}, // Q109251700
    {Coordinate{48.4976, 58.3001}, CountryId{"RU"}}, // Q109251702
    {Coordinate{48.6379, 58.3116}, CountryId{"RU"}}, // Q109251703
    {Coordinate{48.7017, 58.324}, CountryId{"RU"}}, // Q109251705
    {Coordinate{48.8423, 58.3489}, CountryId{"RU"}}, // Q109251707
    {Coordinate{48.8798, 58.3579}, CountryId{"RU"}}, // Q109251708
    {Coordinate{48.9396, 58.3741}, CountryId{"RU"}}, // Q109251710
    {Coordinate{49.1455, 58.4291}, CountryId{"RU"}}, // Q109251711
    {Coordinate{49.2525, 58.4626}, CountryId{"RU"}}, // Q109251713
    {Coordinate{49.2835, 58.4672}, CountryId{"RU"}}, // Q109251714
    {Coordinate{49.3095, 58.4708}, CountryId{"RU"}}, // Q109251715
    {Coordinate{49.3614, 58.4879}, CountryId{"RU"}}, // Q109251717
    {Coordinate{49.4211, 58.5048}, CountryId{"RU"}}, // Q109251719
    {Coordinate{11.939, 49.7641}, CountryId{"DE"}}, // Pressath railway station
    {Coordinate{11.9928, 49.7247}, CountryId{"DE"}}, // Schwarzenbach (b Pressath) railway station
    {Coordinate{11.8946, 49.8014}, CountryId{"DE"}}, // Trabitz railway station
    {Coordinate{11.862, 49.844}, CountryId{"DE"}}, // Kemnath-Neustadt railway station
    {Coordinate{11.7053, 49.8944}, CountryId{"DE"}}, // Seybothenreuth railway station
    {Coordinate{11.6653, 49.9214}, CountryId{"DE"}}, // Stockau railway station
    {Coordinate{11.9721, 49.9338}, CountryId{"DE"}}, // Neusorg railway station
    {Coordinate{12.5858, 55.6929}, CountryId{"DK"}}, // Østerport Station
    {Coordinate{12.5917, 55.7076}, CountryId{"DK"}}, // Nordhavn Station
    {Coordinate{49.4894, 58.5307}, CountryId{"RU"}}, // Q109274576
    {Coordinate{49.5862, 58.558}, CountryId{"RU"}}, // Q109274577
    {Coordinate{41.1527, 55.5007}, CountryId{"RU"}}, // Q109290552
    {Coordinate{41.2172, 55.506}, CountryId{"RU"}}, // Q109290553
    {Coordinate{41.3232, 55.505}, CountryId{"RU"}}, // Q109290554
    {Coordinate{41.4132, 55.5026}, CountryId{"RU"}}, // Q109290556
    {Coordinate{41.5067, 55.5063}, CountryId{"RU"}}, // Q109290557
    {Coordinate{41.59, 55.5245}, CountryId{"RU"}}, // Q109290559
    {Coordinate{41.6329, 55.5339}, CountryId{"RU"}}, // Q109290561
    {Coordinate{41.6925, 55.5469}, CountryId{"RU"}}, // Q109290562
    {Coordinate{41.741, 55.5488}, CountryId{"RU"}}, // Q109290563
    {Coordinate{41.7813, 55.5496}, CountryId{"RU"}}, // Q109290564
    {Coordinate{41.8163, 55.5498}, CountryId{"RU"}}, // Q109290565
    {Coordinate{41.8874, 55.5522}, CountryId{"RU"}}, // Q109290566
    {Coordinate{41.9267, 55.5626}, CountryId{"RU"}}, // Q109290567
    {Coordinate{41.9459, 55.5645}, CountryId{"RU"}}, // Q109290568
    {Coordinate{41.996, 55.6}, CountryId{"RU"}}, // Q109302989
    {Coordinate{41.9545, 55.629}, CountryId{"RU"}}, // Q109302990
    {Coordinate{41.8794, 55.6499}, CountryId{"RU"}}, // Q109302991
    {Coordinate{41.8509, 55.6642}, CountryId{"RU"}}, // Q109302992
    {Coordinate{41.7984, 55.704}, CountryId{"RU"}}, // Q109302993
    {Coordinate{41.7681, 55.7468}, CountryId{"RU"}}, // Q109302994
    {Coordinate{41.7362, 55.771}, CountryId{"RU"}}, // Q109302996
    {Coordinate{41.7312, 55.7956}, CountryId{"RU"}}, // Q109302997
    {Coordinate{41.7588, 55.8379}, CountryId{"RU"}}, // Q109302998
    {Coordinate{41.7367, 55.8904}, CountryId{"RU"}}, // Q109302999
    {Coordinate{41.6211, 55.9743}, CountryId{"RU"}}, // Q109303001
    {Coordinate{41.5862, 56.024}, CountryId{"RU"}}, // Q109303002
    {Coordinate{41.5398, 56.089}, CountryId{"RU"}}, // Q109303003
    {Coordinate{41.5016, 56.1426}, CountryId{"RU"}}, // Q109303004
    {Coordinate{41.4744, 56.1805}, CountryId{"RU"}}, // Q109303005
    {Coordinate{41.4483, 56.217}, CountryId{"RU"}}, // Q109303006
    {Coordinate{41.4299, 56.2425}, CountryId{"RU"}}, // Q109303007
    {Coordinate{41.3846, 56.3048}, CountryId{"RU"}}, // Q109303008
    {Coordinate{}, CountryId{"FR"}}, // Q109316031
    {Coordinate{11.8651, 51.4676}, CountryId{"DE"}}, // Zscherben train station
    {Coordinate{11.763, 51.7237}, CountryId{"DE"}}, // Bebitz railway station
    {Coordinate{8.52066, 51.9649}, CountryId{"DE"}}, // Bielefeld-Senne station
    {Coordinate{42.0592, 55.5637}, CountryId{"RU"}}, // Q109332440
    {Coordinate{42.2831, 55.5373}, CountryId{"RU"}}, // Q109332442
    {Coordinate{42.3531, 55.5368}, CountryId{"RU"}}, // Q109332443
    {Coordinate{42.438, 55.5354}, CountryId{"RU"}}, // Q109332444
    {Coordinate{42.5225, 55.5354}, CountryId{"RU"}}, // Q109332445
    {Coordinate{42.543, 55.5269}, CountryId{"RU"}}, // Q109332446
    {Coordinate{42.5779, 55.5182}, CountryId{"RU"}}, // Q109332447
    {Coordinate{42.6716, 55.5128}, CountryId{"RU"}}, // Q109332448
    {Coordinate{42.8157, 55.5129}, CountryId{"RU"}}, // Q109332449
    {Coordinate{42.9844, 55.4991}, CountryId{"RU"}}, // Q109332450
    {Coordinate{43.0979, 55.4806}, CountryId{"RU"}}, // Q109332451
    {Coordinate{43.2011, 55.4642}, CountryId{"RU"}}, // Q109332452
    {Coordinate{43.2695, 55.4654}, CountryId{"RU"}}, // Q109332453
    {Coordinate{43.365, 55.4791}, CountryId{"RU"}}, // Q109332454
    {Coordinate{43.4479, 55.4756}, CountryId{"RU"}}, // Q109332455
    {Coordinate{43.4952, 55.4761}, CountryId{"RU"}}, // Q109332456
    {Coordinate{43.5572, 55.4764}, CountryId{"RU"}}, // Q109332457
    {Coordinate{43.6516, 55.4697}, CountryId{"RU"}}, // Q109332460
    {Coordinate{43.7255, 55.4638}, CountryId{"RU"}}, // Q109332461
    {Coordinate{43.7753, 55.4477}, CountryId{"RU"}}, // Q109332462
    {Coordinate{43.8142, 55.4294}, CountryId{"RU"}}, // Q109332463
    {Coordinate{43.8236, 55.4215}, CountryId{"RU"}}, // Q109332465
    {Coordinate{42.1299, 55.5616}, CountryId{"RU"}}, // Q109332468
    {Coordinate{43.8135, 56.1566}, CountryId{"RU"}}, // Q109336495
    {Coordinate{43.8352, 56.1173}, CountryId{"RU"}}, // Q109336496
    {Coordinate{43.8374, 56.0744}, CountryId{"RU"}}, // Q109336497
    {Coordinate{43.8366, 56.0207}, CountryId{"RU"}}, // Q109336498
    {Coordinate{43.8453, 55.9739}, CountryId{"RU"}}, // Q109336500
    {Coordinate{43.8183, 55.9578}, CountryId{"RU"}}, // Q109336501
    {Coordinate{43.7771, 55.9169}, CountryId{"RU"}}, // Q109336503
    {Coordinate{43.8479, 55.8244}, CountryId{"RU"}}, // Q109336504
    {Coordinate{43.8646, 55.7984}, CountryId{"RU"}}, // Q109336505
    {Coordinate{43.8991, 55.7634}, CountryId{"RU"}}, // Q109336506
    {Coordinate{43.8715, 55.7284}, CountryId{"RU"}}, // Q109336507
    {Coordinate{43.8222, 55.6699}, CountryId{"RU"}}, // Q109336508
    {Coordinate{43.7912, 55.6009}, CountryId{"RU"}}, // Q109336509
    {Coordinate{43.8095, 55.5277}, CountryId{"RU"}}, // Q109336511
    {Coordinate{43.8165, 55.4992}, CountryId{"RU"}}, // Q109336512
    {Coordinate{43.806, 55.4465}, CountryId{"RU"}}, // Q109336513
    {Coordinate{43.8719, 56.1658}, CountryId{"RU"}}, // Q109348985
    {Coordinate{44.0821, 56.2223}, CountryId{"RU"}}, // Q109348987
    {Coordinate{44.0403, 56.2377}, CountryId{"RU"}}, // Q109348988
    {Coordinate{43.7926, 56.1397}, CountryId{"RU"}}, // Q109349544
    {Coordinate{43.7561, 56.1228}, CountryId{"RU"}}, // Q109349545
    {Coordinate{43.6853, 56.1006}, CountryId{"RU"}}, // Q109349546
    {Coordinate{43.6406, 56.1013}, CountryId{"RU"}}, // Q109349547
    {Coordinate{43.5231, 56.1146}, CountryId{"RU"}}, // Q109349548
    {Coordinate{43.4379, 56.1037}, CountryId{"RU"}}, // Q109349549
    {Coordinate{43.2313, 56.0487}, CountryId{"RU"}}, // Q109349552
    {Coordinate{43.1565, 56.0342}, CountryId{"RU"}}, // Q109349553
    {Coordinate{43.37, 56.0899}, CountryId{"RU"}}, // Q109349557
    {Coordinate{43.8054, 56.1717}, CountryId{"RU"}}, // Q109350158
    {Coordinate{13.1672, 53.0011}, CountryId{"DE"}}, // Gransee railway station
    {Coordinate{40.3846, 56.028}, CountryId{"RU"}}, // Q109352473
    {Coordinate{40.4185, 55.9987}, CountryId{"RU"}}, // Q109352474
    {Coordinate{40.4434, 55.9503}, CountryId{"RU"}}, // Q109352475
    {Coordinate{40.4865, 55.9044}, CountryId{"RU"}}, // Q109352476
    {Coordinate{40.5199, 55.8425}, CountryId{"RU"}}, // Q109352477
    {Coordinate{40.5547, 55.7995}, CountryId{"RU"}}, // Q109352478
    {Coordinate{40.575, 55.7686}, CountryId{"RU"}}, // Q109352479
    {Coordinate{40.6159, 55.7075}, CountryId{"RU"}}, // Q109352480
    {Coordinate{40.6325, 55.6823}, CountryId{"RU"}}, // Q109352481
    {Coordinate{40.6101, 55.49}, CountryId{"RU"}}, // Q109352482
    {Coordinate{40.6196, 55.4482}, CountryId{"RU"}}, // Q109352483
    {Coordinate{40.6139, 55.3314}, CountryId{"RU"}}, // Q109352484
    {Coordinate{40.6564, 55.2403}, CountryId{"RU"}}, // Q109352486
    {Coordinate{40.6206, 55.2024}, CountryId{"RU"}}, // Q109352487
    {Coordinate{40.3686, 56.058}, CountryId{"RU"}}, // Q109352488
    {Coordinate{10.6716, 51.9}, CountryId{"DE"}}, // Stapelburg train station
    {Coordinate{43.823, 55.0232}, CountryId{"RU"}}, // Q109368049
    {Coordinate{43.8016, 54.8773}, CountryId{"RU"}}, // Q109368050
    {Coordinate{44.4592, 55.03}, CountryId{"RU"}}, // Q109368051
    {Coordinate{44.9092, 54.7926}, CountryId{"RU"}}, // Q109368052
    {Coordinate{45.1231, 54.7632}, CountryId{"RU"}}, // Q109368053
    {Coordinate{45.1903, 54.7163}, CountryId{"RU"}}, // Q109368054
    {Coordinate{45.2466, 54.6988}, CountryId{"RU"}}, // Q109368055
    {Coordinate{45.278, 54.6891}, CountryId{"RU"}}, // Q109368056
    {Coordinate{45.3206, 54.6724}, CountryId{"RU"}}, // Q109368057
    {Coordinate{45.3598, 54.6351}, CountryId{"RU"}}, // Q109368058
    {Coordinate{45.383, 54.5854}, CountryId{"RU"}}, // Q109368059
    {Coordinate{45.3607, 54.5029}, CountryId{"RU"}}, // Q109368060
    {Coordinate{45.3618, 54.4693}, CountryId{"RU"}}, // Q109368061
    {Coordinate{44.111, 55.1896}, CountryId{"RU"}}, // Q109368063
    {Coordinate{15.1, 37.5067}, CountryId{"IT"}}, // Catania Centrale railway station
    {Coordinate{45.3201, 54.3829}, CountryId{"RU"}}, // Q109371160
    {Coordinate{45.2979, 54.2965}, CountryId{"RU"}}, // Q109371161
    {Coordinate{45.2351, 54.2155}, CountryId{"RU"}}, // Q109371162
    {Coordinate{45.1164, 54.0964}, CountryId{"RU"}}, // Q109371163
    {Coordinate{45.087, 54.0796}, CountryId{"RU"}}, // Q109371164
    {Coordinate{45.0608, 54.0622}, CountryId{"RU"}}, // Q109371165
    {Coordinate{45.0225, 54.0553}, CountryId{"RU"}}, // Q109371166
    {Coordinate{44.9959, 54.0539}, CountryId{"RU"}}, // Q109371167
    {Coordinate{45.0152, 53.9246}, CountryId{"RU"}}, // Q109375547
    {Coordinate{44.9896, 53.8553}, CountryId{"RU"}}, // Q109375548
    {Coordinate{45.013, 53.8243}, CountryId{"RU"}}, // Q109375549
    {Coordinate{45.1332, 53.6043}, CountryId{"RU"}}, // Q109375550
    {Coordinate{45.2137, 53.602}, CountryId{"RU"}}, // Q109375552
    {Coordinate{45.2123, 53.5738}, CountryId{"RU"}}, // Q109375553
    {Coordinate{45.199, 53.5582}, CountryId{"RU"}}, // Q109375554
    {Coordinate{45.1435, 53.5112}, CountryId{"RU"}}, // Q109375555
    {Coordinate{45.134, 53.4916}, CountryId{"RU"}}, // Q109375556
    {Coordinate{45.0828, 53.4312}, CountryId{"RU"}}, // Q109375558
    {Coordinate{45.0759, 53.4075}, CountryId{"RU"}}, // Q109375559
    {Coordinate{45.0604, 53.3346}, CountryId{"RU"}}, // Q109375560
    {Coordinate{45.021, 53.2363}, CountryId{"RU"}}, // Q109375561
    {Coordinate{10.8904, 54.2193}, CountryId{"DE"}}, // Lensahn station
    {Coordinate{10.7458, 54.0188}, CountryId{"DE"}}, // Scharbeutz station
    {Coordinate{10.7347, 53.9111}, CountryId{"DE"}}, // Lübeck-Dänischburg IKEA station
    {Coordinate{10.7034, 53.9808}, CountryId{"DE"}}, // Pansdorf station
    {Coordinate{10.2759, 54.2336}, CountryId{"DE"}}, // Preetz railway station
    {Coordinate{10.2437, 54.2809}, CountryId{"DE"}}, // Raisdorf railway station
    {Coordinate{8.53391, 51.9556}, CountryId{"DE"}}, // Bielefeld-Windelsbleiche station
    {Coordinate{8.43377, 54.8721}, CountryId{"DE"}}, // Morsum station
    {Coordinate{8.94637, 54.686}, CountryId{"DE"}}, // Langenhorn (Schleswig) railway stop
    {Coordinate{8.97038, 54.6211}, CountryId{"DE"}}, // Bredstedt station
    {Coordinate{43.994, 55.4486}, CountryId{"RU"}}, // Q109380182
    {Coordinate{44.0932, 55.4924}, CountryId{"RU"}}, // Q109380183
    {Coordinate{44.2102, 55.5151}, CountryId{"RU"}}, // Q109380184
    {Coordinate{44.2859, 55.5177}, CountryId{"RU"}}, // Q109380185
    {Coordinate{44.3711, 55.5459}, CountryId{"RU"}}, // Q109380186
    {Coordinate{44.5203, 55.5927}, CountryId{"RU"}}, // Q109380188
    {Coordinate{44.716, 55.5918}, CountryId{"RU"}}, // Q109380189
    {Coordinate{44.8582, 55.57}, CountryId{"RU"}}, // Q109380191
    {Coordinate{45.0075, 55.5563}, CountryId{"RU"}}, // Q109380192
    {Coordinate{45.0705, 55.5554}, CountryId{"RU"}}, // Q109380193
    {Coordinate{45.1985, 55.5239}, CountryId{"RU"}}, // Q109380194
    {Coordinate{45.2816, 55.5123}, CountryId{"RU"}}, // Q109380195
    {Coordinate{46.5396, 55.477}, CountryId{"RU"}}, // Q109380196
    {Coordinate{46.5752, 55.4748}, CountryId{"RU"}}, // Q109380197
    {Coordinate{46.6134, 55.4837}, CountryId{"RU"}}, // Q109380198
    {Coordinate{46.6708, 55.4975}, CountryId{"RU"}}, // Q109380199
    {Coordinate{46.7402, 55.4837}, CountryId{"RU"}}, // Q109380200
    {Coordinate{46.825, 55.4798}, CountryId{"RU"}}, // Q109380201
    {Coordinate{46.872, 55.4878}, CountryId{"RU"}}, // Q109380202
    {Coordinate{46.9487, 55.4879}, CountryId{"RU"}}, // Q109380203
    {Coordinate{47.0015, 55.4752}, CountryId{"RU"}}, // Q109380204
    {Coordinate{47.0967, 55.4705}, CountryId{"RU"}}, // Q109380205
    {Coordinate{47.1374, 55.4798}, CountryId{"RU"}}, // Q109380206
    {Coordinate{47.1836, 55.4914}, CountryId{"RU"}}, // Q109380207
    {Coordinate{47.2274, 55.4992}, CountryId{"RU"}}, // Q109380208
    {Coordinate{47.2967, 55.5078}, CountryId{"RU"}}, // Q109380209
    {Coordinate{47.349, 55.5032}, CountryId{"RU"}}, // Q109380210
    {Coordinate{47.3944, 55.492}, CountryId{"RU"}}, // Q109380211
    {Coordinate{9.03084, 54.3305}, CountryId{"DE"}}, // Lunden railway stop
    {Coordinate{8.99832, 54.3858}, CountryId{"DE"}}, // Witzwort railway stop
    {Coordinate{8.75874, 54.3257}, CountryId{"DE"}}, // Sandwehle railway stop
    {Coordinate{47.3804, 55.4667}, CountryId{"RU"}}, // Q109380774
    {Coordinate{47.3239, 55.4235}, CountryId{"RU"}}, // Q109380775
    {Coordinate{47.1119, 55.3481}, CountryId{"RU"}}, // Q109380776
    {Coordinate{46.9915, 55.2555}, CountryId{"RU"}}, // Q109380777
    {Coordinate{47.0551, 55.1973}, CountryId{"RU"}}, // Q109380778
    {Coordinate{46.9885, 55.1544}, CountryId{"RU"}}, // Q109380779
    {Coordinate{46.8602, 55.0817}, CountryId{"RU"}}, // Q109380780
    {Coordinate{46.7047, 55.0031}, CountryId{"RU"}}, // Q109380781
    {Coordinate{46.6919, 54.9092}, CountryId{"RU"}}, // Q109380782
    {Coordinate{46.3886, 54.8171}, CountryId{"RU"}}, // Q109380783
    {Coordinate{46.3386, 54.7841}, CountryId{"RU"}}, // Q109380784
    {Coordinate{46.268, 54.7595}, CountryId{"RU"}}, // Q109380785
    {Coordinate{46.1713, 54.7399}, CountryId{"RU"}}, // Q109380786
    {Coordinate{46.1095, 54.6991}, CountryId{"RU"}}, // Q109380787
    {Coordinate{46.0609, 54.6658}, CountryId{"RU"}}, // Q109380788
    {Coordinate{46.0839, 54.5842}, CountryId{"RU"}}, // Q109380789
    {Coordinate{45.9953, 54.5507}, CountryId{"RU"}}, // Q109380790
    {Coordinate{45.905, 54.4805}, CountryId{"RU"}}, // Q109380791
    {Coordinate{45.8531, 54.4497}, CountryId{"RU"}}, // Q109380792
    {Coordinate{45.834, 54.4367}, CountryId{"RU"}}, // Q109380793
    {Coordinate{45.7821, 54.4037}, CountryId{"RU"}}, // Q109380794
    {Coordinate{45.6158, 54.381}, CountryId{"RU"}}, // Q109380795
    {Coordinate{45.5508, 54.3714}, CountryId{"RU"}}, // Q109380796
    {Coordinate{45.4658, 54.3839}, CountryId{"RU"}}, // Q109380797
    {Coordinate{45.4488, 54.4082}, CountryId{"RU"}}, // Q109380798
    {Coordinate{45.4141, 54.4189}, CountryId{"RU"}}, // Q109380799
    {Coordinate{45.3731, 54.4261}, CountryId{"RU"}}, // Q109380800
    {Coordinate{9.08011, 54.0879}, CountryId{"DE"}}, // Meldorf railway stop
    {Coordinate{9.48218, 53.8351}, CountryId{"DE"}}, // Krempe railway stop
    {Coordinate{9.48413, 53.7836}, CountryId{"DE"}}, // Herzhorn railway stop
    {Coordinate{9.18029, 54.1689}, CountryId{"DE"}}, // Nordhastedt railway stop
    {Coordinate{9.29247, 54.1462}, CountryId{"DE"}}, // Albersdorf railway stop
    {Coordinate{9.35637, 54.1253}, CountryId{"DE"}}, // Beldorf railway stop
    {Coordinate{9.41513, 54.1228}, CountryId{"DE"}}, // Hademarschen railway stop
    {Coordinate{9.01921, 54.2194}, CountryId{"DE"}}, // Tiebensee railway stop
    {Coordinate{8.96311, 54.2121}, CountryId{"DE"}}, // Jarrenwisch railway stop
    {Coordinate{8.93281, 54.2072}, CountryId{"DE"}}, // Wesselburen railway stop
    {Coordinate{11.1555, 52.1768}, CountryId{"DE"}}, // Wefensleben railway station
    {Coordinate{11.3426, 52.1439}, CountryId{"DE"}}, // Dreileben-Drackenstedt railway station
    {Coordinate{11.382, 52.1445}, CountryId{"DE"}}, // Ochtmersleben railway stop
    {Coordinate{11.5023, 52.13}, CountryId{"DE"}}, // Niederndodeleben railway station
    {Coordinate{47.5443, 55.5577}, CountryId{"RU"}}, // Q109386853
    {Coordinate{47.5999, 55.5995}, CountryId{"RU"}}, // Q109386854
    {Coordinate{47.6426, 55.6138}, CountryId{"RU"}}, // Q109386855
    {Coordinate{47.8227, 55.658}, CountryId{"RU"}}, // Q109386856
    {Coordinate{47.8663, 55.6645}, CountryId{"RU"}}, // Q109386858
    {Coordinate{47.9441, 55.6865}, CountryId{"RU"}}, // Q109386859
    {Coordinate{48.081, 55.7485}, CountryId{"RU"}}, // Q109386860
    {Coordinate{48.143, 55.7575}, CountryId{"RU"}}, // Q109386862
    {Coordinate{48.3348, 55.7959}, CountryId{"RU"}}, // Q109386863
    {Coordinate{48.3687, 55.7687}, CountryId{"RU"}}, // Q109386864
    {Coordinate{11.6382, 52.0976}, CountryId{"DE"}}, // Magdeburg SKET Industriepark railway stop
    {Coordinate{11.6309, 52.0608}, CountryId{"DE"}}, // Beyendorf railway stop
    {Coordinate{11.6565, 52.0807}, CountryId{"DE"}}, // Magdeburg-Salbke railway stop
    {Coordinate{11.6128, 52.049}, CountryId{"DE"}}, // Dodendorf railway station
    {Coordinate{48.5215, 55.8106}, CountryId{"RU"}}, // Q109388403
    {Coordinate{48.5026, 55.8423}, CountryId{"RU"}}, // Q109389087
    {Coordinate{48.6468, 55.8484}, CountryId{"RU"}}, // Q109394180
    {Coordinate{48.7402, 55.8426}, CountryId{"RU"}}, // Q109394182
    {Coordinate{48.809, 55.8291}, CountryId{"RU"}}, // Q109394183
    {Coordinate{48.8621, 55.8229}, CountryId{"RU"}}, // Q109394184
    {Coordinate{48.9792, 55.8327}, CountryId{"RU"}}, // Q109395529
    {Coordinate{11.8561, 51.7569}, CountryId{"DE"}}, // Biendorf railway stop
    {Coordinate{11.6335, 51.6736}, CountryId{"DE"}}, // Belleben railway stop
    {Coordinate{11.544, 51.7024}, CountryId{"DE"}}, // Freckleben railway stop
    {Coordinate{11.5158, 51.7218}, CountryId{"DE"}}, // Drohndorf-Mehringen railway station
    {Coordinate{48.9714, 55.8018}, CountryId{"RU"}}, // Q109398239
    {Coordinate{49.0116, 55.8013}, CountryId{"RU"}}, // Q109398241
    {Coordinate{49.0656, 55.8021}, CountryId{"RU"}}, // Q109398244
    {Coordinate{11.5213, 51.7515}, CountryId{"DE"}}, // Schierstedt railway stop
    {Coordinate{11.5676, 51.7639}, CountryId{"DE"}}, // Giersleben railway stop
    {Coordinate{11.8993, 51.7491}, CountryId{"DE"}}, // Frenz railway stop
    {Coordinate{11.5937, 51.8249}, CountryId{"DE"}}, // Neundorf (Anhalt) railway stop
    {Coordinate{11.677, 51.9468}, CountryId{"DE"}}, // Eickendorf railway station
    {Coordinate{11.696, 51.9751}, CountryId{"DE"}}, // Eggersdorf railway stop
    {Coordinate{11.8842, 51.6087}, CountryId{"DE"}}, // Nauendorf (Saalkr) railway stop
    {Coordinate{11.9215, 51.5816}, CountryId{"DE"}}, // Wallwitz (Saalkr) railway station
    {Coordinate{11.9594, 51.5553}, CountryId{"DE"}}, // Teicha railway stop
    {Coordinate{11.9648, 51.5173}, CountryId{"DE"}}, // Halle Wohnstadt Nord railway stop
    {Coordinate{36.0802, 54.4886}, CountryId{"RU"}}, // Q109412325
    {Coordinate{35.997, 54.4479}, CountryId{"RU"}}, // Q109412326
    {Coordinate{35.9345, 54.444}, CountryId{"RU"}}, // Q109412327
    {Coordinate{35.8661, 54.4313}, CountryId{"RU"}}, // Q109412328
    {Coordinate{35.7185, 54.3694}, CountryId{"RU"}}, // Q109412329
    {Coordinate{35.6371, 54.3402}, CountryId{"RU"}}, // Q109412330
    {Coordinate{35.6204, 54.309}, CountryId{"RU"}}, // Lipitsy
    {Coordinate{35.4693, 54.1859}, CountryId{"RU"}}, // Q109412333
    {Coordinate{35.4394, 54.164}, CountryId{"RU"}}, // Q109412334
    {Coordinate{35.1754, 53.9501}, CountryId{"RU"}}, // Q109415541
    {Coordinate{35.0634, 53.8714}, CountryId{"RU"}}, // Q109415542
    {Coordinate{34.8093, 53.6382}, CountryId{"RU"}}, // Q109415543
    {Coordinate{34.7672, 53.5623}, CountryId{"RU"}}, // Q109415544
    {Coordinate{34.7006, 53.4788}, CountryId{"RU"}}, // Q109415545
    {Coordinate{34.6677, 53.4447}, CountryId{"RU"}}, // Q109415546
    {Coordinate{34.6236, 53.3987}, CountryId{"RU"}}, // Q109415547
    {Coordinate{34.5837, 53.3613}, CountryId{"RU"}}, // Q109415548
    {Coordinate{34.393, 53.1987}, CountryId{"RU"}}, // Q109418412
    {Coordinate{34.4254, 53.1385}, CountryId{"RU"}}, // Q109418413
    {Coordinate{34.4281, 53.1135}, CountryId{"RU"}}, // Q109418414
    {Coordinate{34.4395, 53.0234}, CountryId{"RU"}}, // Q109418415
    {Coordinate{34.4628, 52.9828}, CountryId{"RU"}}, // Q109418416
    {Coordinate{34.4576, 52.9282}, CountryId{"RU"}}, // Q109418417
    {Coordinate{34.4653, 52.8701}, CountryId{"RU"}}, // Q109418418
    {Coordinate{11.3329, 51.803}, CountryId{"DE"}}, // Nachterstedt-Hoym railway station
    {Coordinate{11.2913, 51.8281}, CountryId{"DE"}}, // Gatersleben railway stop
    {Coordinate{11.1686, 51.8715}, CountryId{"DE"}}, // Wegeleben railway station
    {Coordinate{11.1867, 51.8334}, CountryId{"DE"}}, // Ditfurt railway stop
    {Coordinate{11.0852, 51.7524}, CountryId{"DE"}}, // Neinstedt railway stop
    {Coordinate{11.3246, 52.0073}, CountryId{"DE"}}, // Hadmersleben railway stop
    {Coordinate{11.5757, 52.0491}, CountryId{"DE"}}, // Osterweddingen railway stop
    {Coordinate{34.4523, 52.7584}, CountryId{"RU"}}, // Q109418912
    {Coordinate{34.3653, 52.6756}, CountryId{"RU"}}, // Q109418913
    {Coordinate{34.3307, 52.6372}, CountryId{"RU"}}, // Q109418914
    {Coordinate{34.2869, 52.5885}, CountryId{"RU"}}, // Q109418915
    {Coordinate{34.2445, 52.541}, CountryId{"RU"}}, // Q109418916
    {Coordinate{34.2112, 52.5035}, CountryId{"RU"}}, // Q109418917
    {Coordinate{34.1006, 52.3555}, CountryId{"RU"}}, // Q109418918
    {Coordinate{10.7698, 51.8388}, CountryId{"DE"}}, // Wernigerode Elmowerk railway stop
    {Coordinate{10.7328, 51.8491}, CountryId{"DE"}}, // Darlingerode railway stop
    {Coordinate{11.2642, 52.8366}, CountryId{"DE"}}, // Pretzier railway stop
    {Coordinate{11.3781, 52.791}, CountryId{"DE"}}, // Fleetmark railway stop
    {Coordinate{11.4838, 52.7515}, CountryId{"DE"}}, // Brunau-Packebusch railway station
    {Coordinate{11.7292, 52.6147}, CountryId{"DE"}}, // Steinfeld railway stop
    {Coordinate{11.7892, 52.3945}, CountryId{"DE"}}, // Mahlwinkel railway stop
    {Coordinate{11.6803, 52.2964}, CountryId{"DE"}}, // Zielitz railway station
    {Coordinate{11.6763, 52.2883}, CountryId{"DE"}}, // Zielitz Ort railway stop
    {Coordinate{11.6409, 52.2142}, CountryId{"DE"}}, // Barleber See railway stop
    {Coordinate{11.6479, 52.1866}, CountryId{"DE"}}, // Magdeburg-Rothensee railway stop
    {Coordinate{12.3426, 53.1501}, CountryId{"DE"}}, // Heiligengrabe railway stop
    {Coordinate{12.3924, 53.1512}, CountryId{"DE"}}, // Liebenthal (Prignitz) railway stop
    {Coordinate{10.6092, 51.4533}, CountryId{"DE"}}, // Bleicherode Ost railway station
    {Coordinate{36.3074, 54.5552}, CountryId{"RU"}}, // Q109444456
    {Coordinate{36.3338, 54.5847}, CountryId{"RU"}}, // Q109444459
    {Coordinate{36.389, 54.6008}, CountryId{"RU"}}, // Q109444461
    {Coordinate{36.4593, 54.6058}, CountryId{"RU"}}, // Q109444463
    {Coordinate{36.4951, 54.6074}, CountryId{"RU"}}, // Q109444466
    {Coordinate{36.5243, 54.5961}, CountryId{"RU"}}, // Q109444468
    {Coordinate{36.5864, 54.5685}, CountryId{"RU"}}, // Q109444469
    {Coordinate{36.6279, 54.5295}, CountryId{"RU"}}, // Q109444471
    {Coordinate{36.8443, 54.4928}, CountryId{"RU"}}, // Q109444474
    {Coordinate{36.886, 54.5014}, CountryId{"RU"}}, // Q109444476
    {Coordinate{36.9662, 54.5097}, CountryId{"RU"}}, // Q109444478
    {Coordinate{36.9923, 54.5029}, CountryId{"RU"}}, // Q109444480
    {Coordinate{37.0246, 54.4915}, CountryId{"RU"}}, // Q109444482
    {Coordinate{37.0597, 54.5009}, CountryId{"RU"}}, // Q109444484
    {Coordinate{37.1007, 54.4841}, CountryId{"RU"}}, // Q109444486
    {Coordinate{37.1794, 54.4552}, CountryId{"RU"}}, // Q109444488
    {Coordinate{37.3539, 54.4385}, CountryId{"RU"}}, // Q109444489
    {Coordinate{37.4563, 54.4009}, CountryId{"RU"}}, // Q109444491
    {Coordinate{37.4953, 54.36}, CountryId{"RU"}}, // Q109444493
    {Coordinate{37.4743, 54.3312}, CountryId{"RU"}}, // Q109444495
    {Coordinate{37.4677, 54.2871}, CountryId{"RU"}}, // Q109444497
    {Coordinate{37.4874, 54.255}, CountryId{"RU"}}, // Q109444499
    {Coordinate{10.7091, 50.9976}, CountryId{"DE"}}, // Bufleben railway station
    {Coordinate{34.4295, 55.1702}, CountryId{"RU"}}, // Q109462192
    {Coordinate{34.487, 55.1696}, CountryId{"RU"}}, // Q109462193
    {Coordinate{34.5343, 55.1696}, CountryId{"RU"}}, // Q109462195
    {Coordinate{34.6017, 55.1773}, CountryId{"RU"}}, // Q109462197
    {Coordinate{34.6634, 55.1819}, CountryId{"RU"}}, // Q109462200
    {Coordinate{34.7308, 55.1638}, CountryId{"RU"}}, // Q109462202
    {Coordinate{34.7893, 55.1492}, CountryId{"RU"}}, // Q109462203
    {Coordinate{34.8452, 55.1399}, CountryId{"RU"}}, // Q109462205
    {Coordinate{34.9024, 55.1352}, CountryId{"RU"}}, // Q109462207
    {Coordinate{35.0639, 55.0583}, CountryId{"RU"}}, // Q109462209
    {Coordinate{35.1419, 55.0189}, CountryId{"RU"}}, // Q109462211
    {Coordinate{35.2213, 55.0054}, CountryId{"RU"}}, // Q109462212
    {Coordinate{35.3347, 54.9822}, CountryId{"RU"}}, // Q109462215
    {Coordinate{35.399, 54.9677}, CountryId{"RU"}}, // Q109462218
    {Coordinate{35.4338, 54.9504}, CountryId{"RU"}}, // Q109462221
    {Coordinate{35.5952, 54.9304}, CountryId{"RU"}}, // Q109462222
    {Coordinate{35.738, 54.846}, CountryId{"RU"}}, // Q109462223
    {Coordinate{35.7898, 54.8184}, CountryId{"RU"}}, // Q109462225
    {Coordinate{35.9721, 54.7289}, CountryId{"RU"}}, // Q109462227
    {Coordinate{35.975, 54.6951}, CountryId{"RU"}}, // Shanya railway station
    {Coordinate{36.0207, 54.69}, CountryId{"RU"}}, // Q109462229
    {Coordinate{36.0725, 54.6906}, CountryId{"RU"}}, // Q109462230
    {Coordinate{36.0998, 54.6772}, CountryId{"RU"}}, // Q109462231
    {Coordinate{36.1384, 54.6341}, CountryId{"RU"}}, // Q109462233
    {Coordinate{34.3167, 55.1732}, CountryId{"RU"}}, // Q109463349
    {Coordinate{34.344, 55.1723}, CountryId{"RU"}}, // Q109463350
    {Coordinate{10.9829, 50.4055}, CountryId{"DE"}}, // Bachfeld railway halt
    {Coordinate{11.0015, 50.4006}, CountryId{"DE"}}, // Schalkau railway station
    {Coordinate{11.064, 50.3871}, CountryId{"DE"}}, // Seltendorf railway halt
    {Coordinate{11.2822, 50.3068}, CountryId{"DE"}}, // Stockheim (Oberfr) railway station
    {Coordinate{34.407, 55.1448}, CountryId{"RU"}}, // Q109468939
    {Coordinate{34.3841, 55.1119}, CountryId{"RU"}}, // Q109468940
    {Coordinate{34.3563, 55.0585}, CountryId{"RU"}}, // Q109468941
    {Coordinate{34.3416, 54.9891}, CountryId{"RU"}}, // Q109468943
    {Coordinate{34.3312, 54.9125}, CountryId{"RU"}}, // Q109468944
    {Coordinate{34.3273, 54.8366}, CountryId{"RU"}}, // Q109468945
    {Coordinate{34.3422, 54.7783}, CountryId{"RU"}}, // Q109468946
    {Coordinate{34.3438, 54.6919}, CountryId{"RU"}}, // Q109468947
    {Coordinate{34.3424, 54.6108}, CountryId{"RU"}}, // Q109468948
    {Coordinate{34.3414, 54.5725}, CountryId{"RU"}}, // Q109468949
    {Coordinate{34.3294, 54.5278}, CountryId{"RU"}}, // Q109468951
    {Coordinate{34.2993, 54.4842}, CountryId{"RU"}}, // Q109468952
    {Coordinate{34.2951, 54.4384}, CountryId{"RU"}}, // Q109468953
    {Coordinate{34.3406, 55.0017}, CountryId{"RU"}}, // Q109469013
    {Coordinate{34.3404, 54.3108}, CountryId{"RU"}}, // Q109471476
    {Coordinate{34.3401, 54.292}, CountryId{"RU"}}, // Q109471478
    {Coordinate{34.3617, 54.2321}, CountryId{"RU"}}, // Q109471482
    {Coordinate{34.3462, 54.1913}, CountryId{"RU"}}, // Q109471483
    {Coordinate{34.3515, 54.1332}, CountryId{"RU"}}, // Q109471484
    {Coordinate{34.3649, 54.0993}, CountryId{"RU"}}, // Q109471485
    {Coordinate{34.4152, 53.3175}, CountryId{"RU"}}, // Q109472584
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Agullent
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Albaida
    {Coordinate{6.39971, 46.4757}, CountryId{"CH"}}, // Allaman railway station
    {Coordinate{34.4171, 54.0199}, CountryId{"RU"}}, // Q109474150
    {Coordinate{34.3993, 53.9693}, CountryId{"RU"}}, // Ivanovo-Sergiyevsky railway station
    {Coordinate{34.3996, 53.9301}, CountryId{"RU"}}, // Kosyaki railway station
    {Coordinate{34.4096, 53.7868}, CountryId{"RU"}}, // Kosichino railway station
    {Coordinate{34.4081, 53.7506}, CountryId{"RU"}}, // Kuyava railway station
    {Coordinate{34.3951, 53.6985}, CountryId{"RU"}}, // Q109474157
    {Coordinate{34.3232, 53.5892}, CountryId{"RU"}}, // Q109474160
    {Coordinate{34.3817, 53.5025}, CountryId{"RU"}}, // Q109474162
    {Coordinate{34.3931, 53.4895}, CountryId{"RU"}}, // Q109474163
    {Coordinate{34.4036, 53.4545}, CountryId{"RU"}}, // Q109474165
    {Coordinate{34.4021, 53.4426}, CountryId{"RU"}}, // Q109474166
    {Coordinate{34.4473, 53.4018}, CountryId{"RU"}}, // Q109474167
    {Coordinate{34.4797, 53.3717}, CountryId{"RU"}}, // Q109474168
    {Coordinate{34.4971, 53.3382}, CountryId{"RU"}}, // Q109476039
    {Coordinate{-0.510475, 38.8674}, CountryId{"ES"}}, // Bufali railway station
    {Coordinate{6.87711, 46.4479}, CountryId{"CH"}}, // Burier railway station
    {Coordinate{32.3544, 54.7717}, CountryId{"RU"}}, // Q109479847
    {Coordinate{32.5947, 54.7264}, CountryId{"RU"}}, // Q109479848
    {Coordinate{32.8758, 54.6401}, CountryId{"RU"}}, // Q109479851
    {Coordinate{32.9761, 54.6181}, CountryId{"RU"}}, // Q109479852
    {Coordinate{33.6697, 54.4921}, CountryId{"RU"}}, // Q109479854
    {Coordinate{33.8139, 54.4668}, CountryId{"RU"}}, // Q109479855
    {Coordinate{33.9181, 54.4485}, CountryId{"RU"}}, // Q109479856
    {Coordinate{34.1974, 54.3879}, CountryId{"RU"}}, // Q109479857
    {Coordinate{34.2599, 54.3659}, CountryId{"RU"}}, // Q109479858
    {Coordinate{34.4335, 54.3341}, CountryId{"RU"}}, // Q109480228
    {Coordinate{34.6786, 54.2637}, CountryId{"RU"}}, // Q109480229
    {Coordinate{34.8162, 54.2216}, CountryId{"RU"}}, // Q109480232
    {Coordinate{34.913, 54.2034}, CountryId{"RU"}}, // Q109480233
    {Coordinate{35.0357, 54.1844}, CountryId{"RU"}}, // Q109480234
    {Coordinate{35.1137, 54.1677}, CountryId{"RU"}}, // Q109480235
    {Coordinate{35.195, 54.1525}, CountryId{"RU"}}, // Q109480236
    {Coordinate{34.7605, 54.2367}, CountryId{"RU"}}, // Q109480247
    {Coordinate{6.89577, 46.4427}, CountryId{"CH"}}, // Clarens railway station
    {Coordinate{6.82477, 46.4704}, CountryId{"CH"}}, // Corseaux-Cornalles railway station
    {Coordinate{6.72715, 46.4886}, CountryId{"CH"}}, // Cully railway station
    {Coordinate{6.74517, 46.4893}, CountryId{"CH"}}, // Épesses railway station
    {Coordinate{7.02552, 46.1693}, CountryId{"CH"}}, // Evionnaz railway station
    {Coordinate{34.4695, 54.0779}, CountryId{"RU"}}, // Q109486246
    {Coordinate{34.5384, 54.0957}, CountryId{"RU"}}, // Q109486248
    {Coordinate{34.6215, 54.0993}, CountryId{"RU"}}, // Q109486250
    {Coordinate{34.6742, 54.1022}, CountryId{"RU"}}, // Q109486253
    {Coordinate{34.7131, 54.0996}, CountryId{"RU"}}, // Q109486255
    {Coordinate{34.7631, 54.096}, CountryId{"RU"}}, // Q109486257
    {Coordinate{34.8099, 54.0861}, CountryId{"RU"}}, // Q109486259
    {Coordinate{34.9119, 54.0674}, CountryId{"RU"}}, // Q109486261
    {Coordinate{34.9539, 54.0448}, CountryId{"RU"}}, // Voymirovo railway station
    {Coordinate{34.9609, 54.037}, CountryId{"RU"}}, // Q109486266
    {Coordinate{35.0369, 54.0434}, CountryId{"RU"}}, // Q109486268
    {Coordinate{35.0794, 54.0571}, CountryId{"RU"}}, // Q109486270
    {Coordinate{35.116, 54.0678}, CountryId{"RU"}}, // Q109486272
    {Coordinate{35.1597, 54.0908}, CountryId{"RU"}}, // Q109486274
    {Coordinate{35.2093, 54.0821}, CountryId{"RU"}}, // Q109486276
    {Coordinate{35.2555, 54.0722}, CountryId{"RU"}}, // Q109486278
    {Coordinate{35.3037, 54.0736}, CountryId{"RU"}}, // Q109486280
    {Coordinate{34.4382, 54.0653}, CountryId{"RU"}}, // Q109486411
    {Coordinate{6.85952, 46.4554}, CountryId{"CH"}}, // La Tour-de-Peilz railway station
    {Coordinate{6.69062, 46.5038}, CountryId{"CH"}}, // Lutry railway station
    {Coordinate{-0.491567, 38.8841}, CountryId{"ES"}}, // Montaverner
    {Coordinate{-0.602522, 38.8095}, CountryId{"ES"}}, // Ontinyent
    {Coordinate{35.4074, 54.1117}, CountryId{"RU"}}, // Q109496965
    {Coordinate{35.5399, 54.0871}, CountryId{"RU"}}, // Q109496966
    {Coordinate{35.6894, 54.0481}, CountryId{"RU"}}, // Q109496969
    {Coordinate{36.3797, 54.1144}, CountryId{"RU"}}, // Q109496970
    {Coordinate{36.429, 54.1186}, CountryId{"RU"}}, // Q109496971
    {Coordinate{36.4793, 54.1275}, CountryId{"RU"}}, // Q109496972
    {Coordinate{36.809, 54.2105}, CountryId{"RU"}}, // Q109496974
    {Coordinate{36.8571, 54.2103}, CountryId{"RU"}}, // Q109496975
    {Coordinate{36.925, 54.2104}, CountryId{"RU"}}, // Q109496976
    {Coordinate{37.0497, 54.2073}, CountryId{"RU"}}, // Q109496977
    {Coordinate{37.1228, 54.2263}, CountryId{"RU"}}, // Q109496978
    {Coordinate{37.1978, 54.2582}, CountryId{"RU"}}, // Q109496980
    {Coordinate{32.9535, 53.9089}, CountryId{"RU"}}, // Q109502382
    {Coordinate{33.0577, 53.8531}, CountryId{"RU"}}, // Q109502383
    {Coordinate{33.1467, 53.815}, CountryId{"RU"}}, // Q109502384
    {Coordinate{33.226, 53.7797}, CountryId{"RU"}}, // Q109502385
    {Coordinate{33.3347, 53.7367}, CountryId{"RU"}}, // Q109502386
    {Coordinate{33.4015, 53.7078}, CountryId{"RU"}}, // Q109502388
    {Coordinate{33.6681, 53.6215}, CountryId{"RU"}}, // Q109502389
    {Coordinate{33.7127, 53.5598}, CountryId{"RU"}}, // Q109502390
    {Coordinate{33.7714, 53.4849}, CountryId{"RU"}}, // Q109502391
    {Coordinate{33.7929, 53.4768}, CountryId{"RU"}}, // Q109502392
    {Coordinate{33.8631, 53.4501}, CountryId{"RU"}}, // Q109502394
    {Coordinate{34.0436, 53.3819}, CountryId{"RU"}}, // Q109502395
    {Coordinate{34.1496, 53.3549}, CountryId{"RU"}}, // Q109502397
    {Coordinate{6.65947, 46.5109}, CountryId{"CH"}}, // Pully railway station
    {Coordinate{6.78458, 46.4742}, CountryId{"CH"}}, // Rivaz railway station
    {Coordinate{6.79703, 46.4726}, CountryId{"CH"}}, // St-Saphorin railway station
    {Coordinate{7.00204, 46.2164}, CountryId{"CH"}}, // St-Maurice railway station
    {Coordinate{132.988, 42.8606}, CountryId{"RU"}}, // Radiostantsiya
    {Coordinate{36.0285, 52.9262}, CountryId{"RU"}}, // Q109521591
    {Coordinate{6.92269, 46.4264}, CountryId{"CH"}}, // Territet railway station
    {Coordinate{34.9175, 53.1377}, CountryId{"RU"}}, // Q109526580
    {Coordinate{35.1049, 53.1373}, CountryId{"RU"}}, // Q109526583
    {Coordinate{35.2352, 53.1424}, CountryId{"RU"}}, // Q109526584
    {Coordinate{35.4608, 53.0729}, CountryId{"RU"}}, // Q109526585
    {Coordinate{35.547, 53.0259}, CountryId{"RU"}}, // Q109526586
    {Coordinate{35.7233, 52.9634}, CountryId{"RU"}}, // Q109526589
    {Coordinate{35.8162, 52.9485}, CountryId{"RU"}}, // Q109526590
    {Coordinate{35.6139, 52.9817}, CountryId{"RU"}}, // Q109526610
    {Coordinate{7.03836, 46.1385}, CountryId{"CH"}}, // Vernayaz railway station
    {Coordinate{6.83543, 46.4683}, CountryId{"CH"}}, // Vevey-Funi railway station
    {Coordinate{6.92786, 46.4176}, CountryId{"CH"}}, // Veytaux-Chillon railway station
    {Coordinate{6.70728, 46.4953}, CountryId{"CH"}}, // Villette railway station
    {Coordinate{34.4006, 53.1791}, CountryId{"RU"}}, // Q109536132
    {Coordinate{34.312, 53.1514}, CountryId{"RU"}}, // Q109540444
    {Coordinate{34.075, 53.0969}, CountryId{"RU"}}, // Q109540447
    {Coordinate{34.0548, 53.0763}, CountryId{"RU"}}, // Q109540448
    {Coordinate{34.0012, 53.0775}, CountryId{"RU"}}, // Q109540449
    {Coordinate{33.9455, 53.0705}, CountryId{"RU"}}, // Q109540450
    {Coordinate{33.9156, 53.0607}, CountryId{"RU"}}, // Q109540451
    {Coordinate{33.8536, 53.0386}, CountryId{"RU"}}, // Q109540452
    {Coordinate{33.7456, 53.0035}, CountryId{"RU"}}, // Q109540453
    {Coordinate{33.6088, 52.9605}, CountryId{"RU"}}, // Q109540454
    {Coordinate{33.5648, 52.947}, CountryId{"RU"}}, // Q109540455
    {Coordinate{33.3923, 52.8882}, CountryId{"RU"}}, // Q109540456
    {Coordinate{33.3174, 52.8842}, CountryId{"RU"}}, // Q109540457
    {Coordinate{33.2062, 52.8831}, CountryId{"RU"}}, // Q109540459
    {Coordinate{33.0487, 52.8769}, CountryId{"RU"}}, // Q109540461
    {Coordinate{32.9742, 52.8628}, CountryId{"RU"}}, // Q109540462
    {Coordinate{32.9155, 52.8527}, CountryId{"RU"}}, // Q109540463
    {Coordinate{32.8382, 52.8556}, CountryId{"RU"}}, // Q109540464
    {Coordinate{33.2615, 52.8879}, CountryId{"RU"}}, // Q109540474
    {Coordinate{34.4979, 52.7957}, CountryId{"RU"}}, // Q109544958
    {Coordinate{34.4829, 52.7346}, CountryId{"RU"}}, // Q109544959
    {Coordinate{34.5109, 52.6952}, CountryId{"RU"}}, // Q109544960
    {Coordinate{34.5173, 52.6631}, CountryId{"RU"}}, // Q109544961
    {Coordinate{34.5779, 52.5876}, CountryId{"RU"}}, // Q109544962
    {Coordinate{34.665, 52.5459}, CountryId{"RU"}}, // Q109544963
    {Coordinate{34.6819, 52.5181}, CountryId{"RU"}}, // Q109544964
    {Coordinate{34.7017, 52.4913}, CountryId{"RU"}}, // Q109544965
    {Coordinate{34.7844, 52.4156}, CountryId{"RU"}}, // Q109544966
    {Coordinate{34.833, 52.3763}, CountryId{"RU"}}, // Q109544967
    {Coordinate{34.837, 52.3386}, CountryId{"RU"}}, // Q109544968
    {Coordinate{34.8519, 52.2732}, CountryId{"RU"}}, // Q109544969
    {Coordinate{34.9072, 52.2489}, CountryId{"RU"}}, // Q109544970
    {Coordinate{35.0032, 52.1734}, CountryId{"RU"}}, // Q109544971
    {Coordinate{35.0624, 52.1241}, CountryId{"RU"}}, // Q109544972
    {Coordinate{35.0616, 52.077}, CountryId{"RU"}}, // Q109544974
    {Coordinate{35.0832, 52.0561}, CountryId{"RU"}}, // Q109544975
    {Coordinate{32.2251, 54.7305}, CountryId{"RU"}}, // Q109551177
    {Coordinate{32.3632, 54.6148}, CountryId{"RU"}}, // Q109551189
    {Coordinate{32.6183, 52.8296}, CountryId{"RU"}}, // 143 km
    {Coordinate{32.5507, 52.8095}, CountryId{"RU"}}, // Peschaniki
    {Coordinate{32.4957, 52.7866}, CountryId{"RU"}}, // 153 km
    {Coordinate{32.4015, 52.7674}, CountryId{"RU"}}, // Robchik
    {Coordinate{32.3463, 52.76}, CountryId{"RU"}}, // Q109555967
    {Coordinate{32.1748, 52.657}, CountryId{"RU"}}, // Q109555968
    {Coordinate{32.1267, 52.6086}, CountryId{"RU"}}, // Q109555969
    {Coordinate{32.0936, 52.5551}, CountryId{"RU"}}, // Q109555970
    {Coordinate{31.6652, 52.4747}, CountryId{"RU"}}, // Zlynka
    {Coordinate{32.1903, 52.3703}, CountryId{"RU"}}, // Q109555973
    {Coordinate{32.0137, 52.5306}, CountryId{"RU"}}, // Q109555975
    {Coordinate{133, 42.8744}, CountryId{"RU"}}, // Golubovka
    {Coordinate{}, CountryId{"FR"}}, // Gare de Lézignan-la-Cèbe
    {Coordinate{38.1159, 54.0083}, CountryId{"RU"}}, // Q109562464
    {Coordinate{37.5568, 54.1693}, CountryId{"RU"}}, // Q109562785
    {Coordinate{37.5632, 54.1268}, CountryId{"RU"}}, // Q109562786
    {Coordinate{37.5457, 54.0527}, CountryId{"RU"}}, // Q109562788
    {Coordinate{37.501, 54.0097}, CountryId{"RU"}}, // Q109562789
    {Coordinate{37.4991, 53.9256}, CountryId{"RU"}}, // Q109562790
    {Coordinate{37.5053, 53.8873}, CountryId{"RU"}}, // Q109562791
    {Coordinate{37.4367, 53.8042}, CountryId{"RU"}}, // Q109562792
    {Coordinate{37.3471, 53.7518}, CountryId{"RU"}}, // Q109562794
    {Coordinate{37.3138, 53.7071}, CountryId{"RU"}}, // Q109562795
    {Coordinate{37.2277, 53.652}, CountryId{"RU"}}, // Q109562796
    {Coordinate{37.2093, 53.6272}, CountryId{"RU"}}, // Q109562797
    {Coordinate{37.6938, 54.1829}, CountryId{"RU"}}, // Q109563004
    {Coordinate{37.7434, 54.1557}, CountryId{"RU"}}, // Q109563005
    {Coordinate{37.784, 54.1262}, CountryId{"RU"}}, // Q109563006
    {Coordinate{37.8119, 54.1197}, CountryId{"RU"}}, // Q109563007
    {Coordinate{37.8527, 54.1139}, CountryId{"RU"}}, // Q109563008
    {Coordinate{37.9066, 54.11}, CountryId{"RU"}}, // Q109563009
    {Coordinate{37.9852, 54.0717}, CountryId{"RU"}}, // Q109563011
    {Coordinate{38.046, 54.0221}, CountryId{"RU"}}, // Q109563012
    {Coordinate{38.1424, 54.0712}, CountryId{"RU"}}, // Q109563087
    {Coordinate{36.8821, 53.51}, CountryId{"RU"}}, // Q109564661
    {Coordinate{36.7891, 53.4337}, CountryId{"RU"}}, // Q109564665
    {Coordinate{36.6959, 53.3693}, CountryId{"RU"}}, // Q109564668
    {Coordinate{36.6654, 53.3497}, CountryId{"RU"}}, // Q109564670
    {Coordinate{36.6233, 53.3215}, CountryId{"RU"}}, // Q109564671
    {Coordinate{36.5749, 53.3195}, CountryId{"RU"}}, // Q109564674
    {Coordinate{36.3824, 53.202}, CountryId{"RU"}}, // Q109564676
    {Coordinate{36.2906, 53.114}, CountryId{"RU"}}, // Q109564678
    {Coordinate{36.1901, 53.058}, CountryId{"RU"}}, // Q109564680
    {Coordinate{36.164, 53.0489}, CountryId{"RU"}}, // Q109564682
    {Coordinate{36.134, 53.0377}, CountryId{"RU"}}, // Q109564684
    {Coordinate{36.9555, 53.5391}, CountryId{"RU"}}, // Q109564698
    {Coordinate{36.7274, 53.3957}, CountryId{"RU"}}, // Q109564718
    {Coordinate{36.1548, 52.9179}, CountryId{"RU"}}, // Q109574970
    {Coordinate{36.1727, 52.8763}, CountryId{"RU"}}, // Q109574972
    {Coordinate{36.1998, 52.8575}, CountryId{"RU"}}, // Q109574973
    {Coordinate{36.2615, 52.8242}, CountryId{"RU"}}, // Q109574974
    {Coordinate{36.3031, 52.7863}, CountryId{"RU"}}, // Q109574976
    {Coordinate{36.3103, 52.7409}, CountryId{"RU"}}, // Q109574977
    {Coordinate{36.3198, 52.7079}, CountryId{"RU"}}, // Q109574978
    {Coordinate{36.3713, 52.6656}, CountryId{"RU"}}, // Q109574980
    {Coordinate{36.376, 52.6204}, CountryId{"RU"}}, // Q109574981
    {Coordinate{36.3661, 52.5571}, CountryId{"RU"}}, // Q109574982
    {Coordinate{36.3302, 52.4978}, CountryId{"RU"}}, // Q109574983
    {Coordinate{36.2584, 52.4304}, CountryId{"RU"}}, // Q109574984
    {Coordinate{36.3072, 52.3881}, CountryId{"RU"}}, // Q109574986
    {Coordinate{36.2704, 52.2555}, CountryId{"RU"}}, // Q109574987
    {Coordinate{36.2966, 52.1494}, CountryId{"RU"}}, // Q109574988
    {Coordinate{36.3252, 52.1177}, CountryId{"RU"}}, // Q109574989
    {Coordinate{36.3744, 52.0831}, CountryId{"RU"}}, // Q109574990
    {Coordinate{36.3743, 52.0542}, CountryId{"RU"}}, // Q109574992
    {Coordinate{36.376, 52.0229}, CountryId{"RU"}}, // Q109574993
    {Coordinate{36.3813, 51.9858}, CountryId{"RU"}}, // Q109574994
    {Coordinate{36.3648, 51.9466}, CountryId{"RU"}}, // Q109574996
    {Coordinate{36.3253, 51.9052}, CountryId{"RU"}}, // Q109574997
    {Coordinate{36.2978, 51.876}, CountryId{"RU"}}, // Q109574999
    {Coordinate{36.2723, 51.8492}, CountryId{"RU"}}, // Q109575000
    {Coordinate{36.2527, 51.8007}, CountryId{"RU"}}, // Q109575002
    {Coordinate{}, CountryId{"FR"}}, // Gare de Bacouel-sur-Selle
    {Coordinate{36.1109, 52.9549}, CountryId{"RU"}}, // Q109581526
    {Coordinate{36.1234, 52.9694}, CountryId{"RU"}}, // Q109581527
    {Coordinate{36.2705, 52.9287}, CountryId{"RU"}}, // Q109581528
    {Coordinate{36.2985, 52.9482}, CountryId{"RU"}}, // Q109581529
    {Coordinate{36.3358, 52.9494}, CountryId{"RU"}}, // Q109581530
    {Coordinate{36.3926, 52.9452}, CountryId{"RU"}}, // Q109581531
    {Coordinate{36.4799, 52.9483}, CountryId{"RU"}}, // Q109581532
    {Coordinate{36.5706, 52.949}, CountryId{"RU"}}, // Q109581533
    {Coordinate{36.7294, 52.9191}, CountryId{"RU"}}, // Q109581535
    {Coordinate{36.9916, 52.8773}, CountryId{"RU"}}, // Q109581536
    {Coordinate{37.0932, 52.8264}, CountryId{"RU"}}, // Q109581537
    {Coordinate{}, CountryId{"FR"}}, // Gare de Saleux
    {Coordinate{35.1256, 52.0428}, CountryId{"RU"}}, // Q109583998
    {Coordinate{35.1594, 52.0647}, CountryId{"RU"}}, // Q109583999
    {Coordinate{35.2741, 52.1421}, CountryId{"RU"}}, // Q109584002
    {Coordinate{35.3185, 52.162}, CountryId{"RU"}}, // Q109584003
    {Coordinate{35.3499, 52.1802}, CountryId{"RU"}}, // Q109584004
    {Coordinate{35.3974, 52.2078}, CountryId{"RU"}}, // Q109584005
    {Coordinate{35.4433, 52.254}, CountryId{"RU"}}, // Q109584006
    {Coordinate{35.4253, 52.2727}, CountryId{"RU"}}, // Q109584007
    {Coordinate{35.398, 52.2924}, CountryId{"RU"}}, // Q109584008
    {Coordinate{35.3958, 52.3445}, CountryId{"RU"}}, // Q109584009
    {Coordinate{35.4243, 52.3658}, CountryId{"RU"}}, // Q109584010
    {Coordinate{35.4734, 52.382}, CountryId{"RU"}}, // Q109584011
    {Coordinate{35.497, 52.3966}, CountryId{"RU"}}, // Q109584014
    {Coordinate{35.6231, 52.4926}, CountryId{"RU"}}, // Q109584017
    {Coordinate{35.6546, 52.529}, CountryId{"RU"}}, // Q109584018
    {Coordinate{35.6751, 52.5568}, CountryId{"RU"}}, // Q109584019
    {Coordinate{35.8121, 52.6647}, CountryId{"RU"}}, // Q109584020
    {Coordinate{35.8627, 52.7027}, CountryId{"RU"}}, // Q109584021
    {Coordinate{35.8954, 52.7267}, CountryId{"RU"}}, // Q109584022
    {Coordinate{35.9237, 52.7552}, CountryId{"RU"}}, // Q109584023
    {Coordinate{35.95, 52.7975}, CountryId{"RU"}}, // Q109584024
    {Coordinate{35.9601, 52.8419}, CountryId{"RU"}}, // Q109584025
    {Coordinate{35.2087, 52.1112}, CountryId{"RU"}}, // Q109584398
    {Coordinate{35.1436, 51.9957}, CountryId{"RU"}}, // Q109587204
    {Coordinate{35.1854, 51.9772}, CountryId{"RU"}}, // Q109587205
    {Coordinate{35.2336, 51.9558}, CountryId{"RU"}}, // Q109587206
    {Coordinate{35.2722, 51.9356}, CountryId{"RU"}}, // Q109587207
    {Coordinate{35.3118, 51.897}, CountryId{"RU"}}, // Q109587208
    {Coordinate{35.2916, 51.8405}, CountryId{"RU"}}, // Q109587209
    {Coordinate{35.3011, 51.7938}, CountryId{"RU"}}, // Q109587210
    {Coordinate{35.2563, 51.7627}, CountryId{"RU"}}, // Q109587211
    {Coordinate{35.2469, 51.6914}, CountryId{"RU"}}, // Q109587212
    {Coordinate{35.246, 51.6474}, CountryId{"RU"}}, // Q109587213
    {Coordinate{34.7313, 51.2884}, CountryId{"RU"}}, // Q109588384
    {Coordinate{34.8021, 51.3103}, CountryId{"RU"}}, // Q109588386
    {Coordinate{34.8317, 51.3254}, CountryId{"RU"}}, // Q109588387
    {Coordinate{34.8648, 51.3422}, CountryId{"RU"}}, // Q109588388
    {Coordinate{34.8951, 51.3759}, CountryId{"RU"}}, // Q109588389
    {Coordinate{34.9094, 51.4375}, CountryId{"RU"}}, // Q109588390
    {Coordinate{35.0181, 51.4543}, CountryId{"RU"}}, // Q109588391
    {Coordinate{35.0806, 51.5004}, CountryId{"RU"}}, // Q109588392
    {Coordinate{35.1166, 51.5319}, CountryId{"RU"}}, // Q109588393
    {Coordinate{35.1225, 51.5625}, CountryId{"RU"}}, // Q109588394
    {Coordinate{35.1576, 51.6116}, CountryId{"RU"}}, // Q109588395
    {Coordinate{35.1967, 51.6342}, CountryId{"RU"}}, // Q109588396
    {Coordinate{16.5057, 59.3692}, CountryId{"SE"}}, // Eskilstuna Central Station
    {Coordinate{35.327, 51.6316}, CountryId{"RU"}}, // Q109593157
    {Coordinate{35.3591, 51.6119}, CountryId{"RU"}}, // Q109593158
    {Coordinate{35.409, 51.5978}, CountryId{"RU"}}, // Q109593159
    {Coordinate{35.4644, 51.6108}, CountryId{"RU"}}, // Q109593160
    {Coordinate{35.4987, 51.6214}, CountryId{"RU"}}, // Q109593161
    {Coordinate{35.5843, 51.6487}, CountryId{"RU"}}, // Q109593162
    {Coordinate{35.7337, 51.6537}, CountryId{"RU"}}, // Q109593164
    {Coordinate{35.8406, 51.6366}, CountryId{"RU"}}, // Q109593165
    {Coordinate{35.9568, 51.6482}, CountryId{"RU"}}, // Q109593166
    {Coordinate{36.0458, 51.6466}, CountryId{"RU"}}, // Q109593167
    {Coordinate{36.0877, 51.6482}, CountryId{"RU"}}, // Q109593168
    {Coordinate{36.1969, 51.6699}, CountryId{"RU"}}, // Q109593169
    {Coordinate{36.219, 51.7043}, CountryId{"RU"}}, // Q109593170
    {Coordinate{36.2255, 51.7295}, CountryId{"RU"}}, // Q109593171
    {Coordinate{36.2447, 51.7738}, CountryId{"RU"}}, // Q109607399
    {Coordinate{36.3708, 51.7837}, CountryId{"RU"}}, // Q109607400
    {Coordinate{36.5687, 51.8152}, CountryId{"RU"}}, // Q109607403
    {Coordinate{36.6093, 51.8593}, CountryId{"RU"}}, // Q109607404
    {Coordinate{36.8139, 51.8828}, CountryId{"RU"}}, // Q109607405
    {Coordinate{37.103, 51.8857}, CountryId{"RU"}}, // Q109607406
    {Coordinate{37.4169, 51.8897}, CountryId{"RU"}}, // Q109607409
    {Coordinate{37.4791, 51.8785}, CountryId{"RU"}}, // Q109607410
    {Coordinate{36.434, 51.7926}, CountryId{"RU"}}, // Q109607419
    {Coordinate{36.7493, 51.9404}, CountryId{"RU"}}, // Q109607609
    {Coordinate{36.7716, 52.0077}, CountryId{"RU"}}, // Q109607610
    {Coordinate{36.7458, 52.0981}, CountryId{"RU"}}, // Q109607611
    {Coordinate{36.7935, 52.1831}, CountryId{"RU"}}, // Q109607612
    {Coordinate{36.8678, 52.2}, CountryId{"RU"}}, // Q109607613
    {Coordinate{36.9066, 52.2074}, CountryId{"RU"}}, // Q109607614
    {Coordinate{37.806, 51.8241}, CountryId{"RU"}}, // Q109610719
    {Coordinate{37.924, 51.8022}, CountryId{"RU"}}, // Q109610720
    {Coordinate{38.0229, 51.8086}, CountryId{"RU"}}, // Q109610721
    {Coordinate{37.3276, 52.764}, CountryId{"RU"}}, // Q109614979
    {Coordinate{37.3186, 52.7184}, CountryId{"RU"}}, // Q109614980
    {Coordinate{37.3222, 52.6645}, CountryId{"RU"}}, // Q109614981
    {Coordinate{37.3629, 52.6027}, CountryId{"RU"}}, // Q109614984
    {Coordinate{37.4092, 52.612}, CountryId{"RU"}}, // Q109614985
    {Coordinate{37.4804, 52.5403}, CountryId{"RU"}}, // Q109614987
    {Coordinate{37.5274, 52.4864}, CountryId{"RU"}}, // Q109614989
    {Coordinate{37.5988, 52.4278}, CountryId{"RU"}}, // Q109614990
    {Coordinate{37.5463, 52.4085}, CountryId{"RU"}}, // Q109614992
    {Coordinate{37.5436, 52.395}, CountryId{"RU"}}, // Q109614993
    {Coordinate{37.5193, 52.3398}, CountryId{"RU"}}, // Q109614994
    {Coordinate{37.5401, 52.263}, CountryId{"RU"}}, // Q109614996
    {Coordinate{37.5669, 52.1783}, CountryId{"RU"}}, // Q109614997
    {Coordinate{37.5677, 52.1213}, CountryId{"RU"}}, // Q109614998
    {Coordinate{37.5374, 52.0564}, CountryId{"RU"}}, // Q109614999
    {Coordinate{37.5062, 51.958}, CountryId{"RU"}}, // Q109615000
    {Coordinate{37.522, 51.913}, CountryId{"RU"}}, // Q109615001
    {Coordinate{37.5322, 52.293}, CountryId{"RU"}}, // Q109615571
    {Coordinate{36.2843, 51.6988}, CountryId{"RU"}}, // Q109617011
    {Coordinate{36.3497, 51.671}, CountryId{"RU"}}, // Q109617012
    {Coordinate{36.3832, 51.6516}, CountryId{"RU"}}, // Q109617013
    {Coordinate{36.4215, 51.6364}, CountryId{"RU"}}, // Q109617014
    {Coordinate{36.5057, 51.6064}, CountryId{"RU"}}, // Q109617015
    {Coordinate{36.5675, 51.5821}, CountryId{"RU"}}, // Q109617016
    {Coordinate{36.5902, 51.5685}, CountryId{"RU"}}, // Q109617017
    {Coordinate{36.6063, 51.5457}, CountryId{"RU"}}, // Q109617018
    {Coordinate{36.7014, 51.4561}, CountryId{"RU"}}, // Q109617020
    {Coordinate{36.7442, 51.414}, CountryId{"RU"}}, // Q109617021
    {Coordinate{36.7771, 51.3712}, CountryId{"RU"}}, // Q109617022
    {Coordinate{36.7917, 51.3456}, CountryId{"RU"}}, // Q109617024
    {Coordinate{36.6555, 51.5012}, CountryId{"RU"}}, // Q109617027
    {Coordinate{38.5901, 52.6065}, CountryId{"RU"}}, // Q109628332
    {Coordinate{38.6595, 52.578}, CountryId{"RU"}}, // Q109628333
    {Coordinate{38.6822, 52.5437}, CountryId{"RU"}}, // Q109628334
    {Coordinate{38.655, 52.5146}, CountryId{"RU"}}, // Q109628335
    {Coordinate{38.5992, 52.4587}, CountryId{"RU"}}, // Q109628336
    {Coordinate{38.5457, 52.3981}, CountryId{"RU"}}, // Q109628337
    {Coordinate{38.5038, 52.3714}, CountryId{"RU"}}, // Q109628338
    {Coordinate{38.4042, 52.3369}, CountryId{"RU"}}, // Q109628339
    {Coordinate{38.3446, 52.2821}, CountryId{"RU"}}, // Q109628340
    {Coordinate{38.1717, 52.0464}, CountryId{"RU"}}, // Q109628341
    {Coordinate{38.1331, 52.0212}, CountryId{"RU"}}, // Q109628342
    {Coordinate{38.1336, 51.9352}, CountryId{"RU"}}, // Q109628344
    {Coordinate{38.1368, 51.9148}, CountryId{"RU"}}, // Q109628345
    {Coordinate{38.1468, 51.9015}, CountryId{"RU"}}, // Q109628346
    {Coordinate{38.1202, 51.8288}, CountryId{"RU"}}, // Q109628349
    {Coordinate{38.2312, 54.0772}, CountryId{"RU"}}, // Q109631680
    {Coordinate{38.2247, 54.7465}, CountryId{"RU"}}, // Q109638339
    {Coordinate{38.2097, 54.7118}, CountryId{"RU"}}, // Q109638340
    {Coordinate{38.2121, 54.6604}, CountryId{"RU"}}, // Q109638341
    {Coordinate{38.223, 54.6246}, CountryId{"RU"}}, // Q109638342
    {Coordinate{38.2229, 54.5749}, CountryId{"RU"}}, // Q109638343
    {Coordinate{38.2218, 54.5026}, CountryId{"RU"}}, // Q109638344
    {Coordinate{38.2282, 54.4693}, CountryId{"RU"}}, // Q109638345
    {Coordinate{38.2134, 54.4464}, CountryId{"RU"}}, // Q109638346
    {Coordinate{38.2312, 54.4214}, CountryId{"RU"}}, // Q109638347
    {Coordinate{38.2336, 54.3995}, CountryId{"RU"}}, // Q109638348
    {Coordinate{38.2486, 54.3004}, CountryId{"RU"}}, // Q109638349
    {Coordinate{38.2402, 54.2577}, CountryId{"RU"}}, // Q109638350
    {Coordinate{38.2286, 54.1887}, CountryId{"RU"}}, // Q109638351
    {Coordinate{38.179, 54.1318}, CountryId{"RU"}}, // Q109638352
    {Coordinate{38.2314, 54.0852}, CountryId{"RU"}}, // Q109639320
    {Coordinate{38.1685, 54.0784}, CountryId{"RU"}}, // Q109639351
    {Coordinate{38.2161, 54.0412}, CountryId{"RU"}}, // Q109642939
    {Coordinate{38.2705, 54.0108}, CountryId{"RU"}}, // Q109642940
    {Coordinate{38.2959, 53.9912}, CountryId{"RU"}}, // Q109642942
    {Coordinate{38.3161, 53.9701}, CountryId{"RU"}}, // Q109642944
    {Coordinate{38.312, 53.9631}, CountryId{"RU"}}, // Q109642946
    {Coordinate{38.2244, 53.9647}, CountryId{"RU"}}, // Q109646568
    {Coordinate{38.402, 53.9563}, CountryId{"RU"}}, // Q109646569
    {Coordinate{38.5364, 53.9652}, CountryId{"RU"}}, // Q109646571
    {Coordinate{38.6212, 53.9598}, CountryId{"RU"}}, // Q109646572
    {Coordinate{38.7096, 53.9307}, CountryId{"RU"}}, // Q109646573
    {Coordinate{38.7787, 53.9133}, CountryId{"RU"}}, // Q109646575
    {Coordinate{38.8806, 53.892}, CountryId{"RU"}}, // Q109646577
    {Coordinate{39.0371, 53.8418}, CountryId{"RU"}}, // Q109646579
    {Coordinate{38.112, 53.7793}, CountryId{"RU"}}, // Q109646610
    {Coordinate{38.1657, 53.9473}, CountryId{"RU"}}, // Q109647098
    {Coordinate{38.1606, 53.8804}, CountryId{"RU"}}, // Q109647100
    {Coordinate{38.1296, 53.8431}, CountryId{"RU"}}, // Q109647101
    {Coordinate{38.1208, 53.7411}, CountryId{"RU"}}, // Q109647103
    {Coordinate{38.1717, 53.689}, CountryId{"RU"}}, // Q109647105
    {Coordinate{38.1556, 53.6485}, CountryId{"RU"}}, // Q109647106
    {Coordinate{38.1224, 53.6112}, CountryId{"RU"}}, // Q109647108
    {Coordinate{38.0572, 53.5979}, CountryId{"RU"}}, // Q109647109
    {Coordinate{37.9939, 53.5584}, CountryId{"RU"}}, // Q109647111
    {Coordinate{37.9656, 53.5277}, CountryId{"RU"}}, // Q109647112
    {Coordinate{37.9993, 53.5046}, CountryId{"RU"}}, // Q109647114
    {Coordinate{38.0334, 53.4801}, CountryId{"RU"}}, // Q109647116
    {Coordinate{38.0441, 53.4119}, CountryId{"RU"}}, // Q109647117
    {Coordinate{38.0759, 53.3651}, CountryId{"RU"}}, // Q109647119
    {Coordinate{38.1045, 53.3521}, CountryId{"RU"}}, // Q109647120
    {Coordinate{38.0987, 53.3195}, CountryId{"RU"}}, // Q109647122
    {Coordinate{38.0949, 53.2797}, CountryId{"RU"}}, // Q109647123
    {Coordinate{38.075, 53.2552}, CountryId{"RU"}}, // Q109647125
    {Coordinate{38.0498, 53.235}, CountryId{"RU"}}, // Q109647126
    {Coordinate{38.0656, 53.2105}, CountryId{"RU"}}, // Q109647128
    {Coordinate{38.0954, 53.1972}, CountryId{"RU"}}, // Q109647129
    {Coordinate{}, CountryId{"FR"}}, // Gare de Vic-sur-Aisne - Ressons
    {Coordinate{8.71378, 51.7704}, CountryId{"DE"}}, // Paderborn-Sennelager station
    {Coordinate{}, CountryId{"FR"}}, // Q109661138
    {Coordinate{39.313, 53.8497}, CountryId{"RU"}}, // Q109663927
    {Coordinate{39.3912, 53.8662}, CountryId{"RU"}}, // Q109663930
    {Coordinate{39.4966, 53.8496}, CountryId{"RU"}}, // Q109663932
    {Coordinate{39.576, 53.8251}, CountryId{"RU"}}, // Q109663935
    {Coordinate{39.6092, 53.7921}, CountryId{"RU"}}, // Q109663938
    {Coordinate{39.7094, 53.7822}, CountryId{"RU"}}, // Q109663940
    {Coordinate{39.8088, 53.7691}, CountryId{"RU"}}, // Q109663943
    {Coordinate{39.9407, 53.7437}, CountryId{"RU"}}, // Q109663945
    {Coordinate{40.0058, 54.4831}, CountryId{"RU"}}, // Q109673554
    {Coordinate{40.0327, 54.4505}, CountryId{"RU"}}, // Q109673556
    {Coordinate{40.0604, 54.4202}, CountryId{"RU"}}, // Q109673557
    {Coordinate{40.1175, 54.3671}, CountryId{"RU"}}, // Q109673558
    {Coordinate{40.1872, 54.3402}, CountryId{"RU"}}, // Q109673559
    {Coordinate{40.2208, 54.3106}, CountryId{"RU"}}, // Q109673560
    {Coordinate{40.2435, 54.2981}, CountryId{"RU"}}, // Q109673561
    {Coordinate{40.3482, 54.2654}, CountryId{"RU"}}, // Q109673562
    {Coordinate{40.4654, 54.2558}, CountryId{"RU"}}, // Q109673563
    {Coordinate{40.5471, 54.2814}, CountryId{"RU"}}, // Q109673564
    {Coordinate{40.6728, 54.2906}, CountryId{"RU"}}, // Q109673567
    {Coordinate{40.795, 54.2937}, CountryId{"RU"}}, // Q109673569
    {Coordinate{40.9628, 54.3255}, CountryId{"RU"}}, // Q109673571
    {Coordinate{40.991, 54.3229}, CountryId{"RU"}}, // Q109673572
    {Coordinate{41.0506, 54.3328}, CountryId{"RU"}}, // Q109673573
    {Coordinate{41.2961, 54.3015}, CountryId{"RU"}}, // Q109673575
    {Coordinate{41.4323, 54.2823}, CountryId{"RU"}}, // Q109673576
    {Coordinate{41.688, 54.2742}, CountryId{"RU"}}, // Q109673578
    {Coordinate{41.7341, 54.2822}, CountryId{"RU"}}, // Q109673579
    {Coordinate{41.7965, 54.2945}, CountryId{"RU"}}, // Q109673580
    {Coordinate{41.8523, 54.3118}, CountryId{"RU"}}, // 376 km
    {Coordinate{41.9619, 54.3505}, CountryId{"RU"}}, // 383 km
    {Coordinate{41.9835, 54.3377}, CountryId{"RU"}}, // 385 km
    {Coordinate{42.046, 54.323}, CountryId{"RU"}}, // 390 km
    {Coordinate{42.0971, 54.3029}, CountryId{"RU"}}, // 395 km
    {Coordinate{42.1619, 54.2861}, CountryId{"RU"}}, // Tairovka
    {Coordinate{42.2265, 54.273}, CountryId{"RU"}}, // 404 km
    {Coordinate{40.0371, 54.512}, CountryId{"RU"}}, // Q109676312
    {Coordinate{40.0764, 54.5178}, CountryId{"RU"}}, // Q109676314
    {Coordinate{40.1317, 54.5068}, CountryId{"RU"}}, // Q109676315
    {Coordinate{40.195, 54.3673}, CountryId{"RU"}}, // Q109676383
    {Coordinate{40.2241, 54.3934}, CountryId{"RU"}}, // Q109676384
    {Coordinate{41.2083, 54.3567}, CountryId{"RU"}}, // Q109676551
    {Coordinate{41.248, 54.4183}, CountryId{"RU"}}, // Q109676552
    {Coordinate{41.2744, 54.4374}, CountryId{"RU"}}, // Q109676553
    {Coordinate{41.2945, 54.484}, CountryId{"RU"}}, // Q109676555
    {Coordinate{41.3033, 54.522}, CountryId{"RU"}}, // Q109676556
    {Coordinate{41.2882, 54.6017}, CountryId{"RU"}}, // Q109676557
    {Coordinate{41.2986, 54.6469}, CountryId{"RU"}}, // Q109676558
    {Coordinate{41.3043, 54.6783}, CountryId{"RU"}}, // Q109676559
    {Coordinate{41.3137, 54.7305}, CountryId{"RU"}}, // Q109676560
    {Coordinate{41.3194, 54.8121}, CountryId{"RU"}}, // Q109676561
    {Coordinate{41.3217, 54.8548}, CountryId{"RU"}}, // Q109676562
    {Coordinate{15.0955, 60.6742}, CountryId{"SE"}}, // Insjön station
    {Coordinate{16.1721, 61.7158}, CountryId{"SE"}}, // Järvsö station
    {Coordinate{16.3628, 58.6738}, CountryId{"SE"}}, // Kolmården station
    {Coordinate{16.1029, 59.4278}, CountryId{"SE"}}, // Kungsör station
    {Coordinate{16.0044, 59.507}, CountryId{"SE"}}, // Köping station
    {Coordinate{15.0029, 60.7342}, CountryId{"SE"}}, // Leksand station
    {Coordinate{17.4336, 59.1822}, CountryId{"SE"}}, // Nykvarn station
    {Coordinate{16.721, 60.8915}, CountryId{"SE"}}, // Ockelbo station
    {Coordinate{16.6055, 59.9253}, CountryId{"SE"}}, // Sala station
    {Coordinate{15.66, 58.4005}, CountryId{"SE"}}, // Tannefors station
    {Coordinate{17.5142, 60.3452}, CountryId{"SE"}}, // Tierp station
    {Coordinate{16.6307, 57.7528}, CountryId{"SE"}}, // Tjustskolan station
    {Coordinate{16.0021, 58.2037}, CountryId{"SE"}}, // Åtvidaberg station
    {Coordinate{14.0292, 56.0608}, CountryId{"SE"}}, // Önnestad station
    {Coordinate{39.7095, 54.56}, CountryId{"RU"}}, // 208 km
    {Coordinate{39.7374, 54.5343}, CountryId{"RU"}}, // Q109688671
    {Coordinate{39.7459, 54.4941}, CountryId{"RU"}}, // Q109688673
    {Coordinate{39.7921, 54.4727}, CountryId{"RU"}}, // Q109688674
    {Coordinate{39.8599, 54.4417}, CountryId{"RU"}}, // Q109688676
    {Coordinate{39.8674, 54.3748}, CountryId{"RU"}}, // Q109688678
    {Coordinate{39.9297, 54.2808}, CountryId{"RU"}}, // Q109688683
    {Coordinate{39.9918, 54.1745}, CountryId{"RU"}}, // Q109688686
    {Coordinate{39.9852, 54.0869}, CountryId{"RU"}}, // Q109688687
    {Coordinate{39.9967, 53.958}, CountryId{"RU"}}, // Q109688691
    {Coordinate{40.0181, 53.9211}, CountryId{"RU"}}, // Q109688694
    {Coordinate{40.0256, 53.8718}, CountryId{"RU"}}, // Q109688696
    {Coordinate{40.0657, 53.8292}, CountryId{"RU"}}, // Q109688697
    {Coordinate{40.0993, 53.7971}, CountryId{"RU"}}, // Q109688699
    {Coordinate{40.1203, 53.7487}, CountryId{"RU"}}, // Q109688700
    {Coordinate{39.9977, 54.0153}, CountryId{"RU"}}, // Q109688771
    {Coordinate{40.1361, 53.7054}, CountryId{"RU"}}, // Q109689634
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof
    {Coordinate{42.3333, 54.2007}, CountryId{"RU"}}, // Q109717293
    {Coordinate{42.373, 54.1586}, CountryId{"RU"}}, // Q109717294
    {Coordinate{42.4166, 54.0706}, CountryId{"RU"}}, // Q109717295
    {Coordinate{42.4303, 54.0073}, CountryId{"RU"}}, // Q109717296
    {Coordinate{42.377, 53.8523}, CountryId{"RU"}}, // Q109717297
    {Coordinate{42.3188, 53.7352}, CountryId{"RU"}}, // Q109717298
    {Coordinate{42.4145, 53.6523}, CountryId{"RU"}}, // Q109717299
    {Coordinate{42.4799, 53.6005}, CountryId{"RU"}}, // Q109717300
    {Coordinate{42.5362, 53.5604}, CountryId{"RU"}}, // Q109717301
    {Coordinate{42.534, 53.4402}, CountryId{"RU"}}, // Q109717302
    {Coordinate{42.4764, 53.4085}, CountryId{"RU"}}, // Q109717303
    {Coordinate{42.4424, 53.3609}, CountryId{"RU"}}, // Q109717304
    {Coordinate{8.53621, 47.5239}, CountryId{"CH"}}, // Bülach railway station
    {Coordinate{33.6207, 55.1412}, CountryId{"RU"}}, // Q109730845
    {Coordinate{32.4096, 54.8353}, CountryId{"RU"}}, // Q109730861
    {Coordinate{33.7014, 55.1453}, CountryId{"RU"}}, // Q109734918
    {Coordinate{33.5327, 55.1461}, CountryId{"RU"}}, // Q109734919
    {Coordinate{32.9101, 55.0786}, CountryId{"RU"}}, // Q109734921
    {Coordinate{32.7873, 55.0683}, CountryId{"RU"}}, // Q109734923
    {Coordinate{32.5741, 55.0405}, CountryId{"RU"}}, // Q109734925
    {Coordinate{32.4538, 54.9586}, CountryId{"RU"}}, // Q109734926
    {Coordinate{32.447, 54.8891}, CountryId{"RU"}}, // Q109734927
    {Coordinate{32.351, 54.8124}, CountryId{"RU"}}, // Q109734928
    {Coordinate{34.2921, 55.8434}, CountryId{"RU"}}, // Sychyovka
    {Coordinate{34.3219, 56.031}, CountryId{"RU"}}, // Osuga
    {Coordinate{34.3203, 55.2264}, CountryId{"RU"}}, // Vyazma-Novotorzhskaya
    {Coordinate{34.326, 55.2631}, CountryId{"RU"}}, // Q109735434
    {Coordinate{34.3257, 55.2946}, CountryId{"RU"}}, // Q109735435
    {Coordinate{34.3448, 55.3225}, CountryId{"RU"}}, // Q109735436
    {Coordinate{34.3591, 55.3678}, CountryId{"RU"}}, // Q109735437
    {Coordinate{34.3288, 55.3936}, CountryId{"RU"}}, // Q109735438
    {Coordinate{34.3262, 55.4288}, CountryId{"RU"}}, // Q109735439
    {Coordinate{34.3236, 55.5034}, CountryId{"RU"}}, // Q109735440
    {Coordinate{34.3118, 55.546}, CountryId{"RU"}}, // Q109735441
    {Coordinate{34.3066, 55.5845}, CountryId{"RU"}}, // Q109735442
    {Coordinate{34.296, 55.6319}, CountryId{"RU"}}, // Q109735443
    {Coordinate{34.2966, 55.7118}, CountryId{"RU"}}, // Q109735445
    {Coordinate{34.2909, 55.8109}, CountryId{"RU"}}, // Q109735446
    {Coordinate{34.3204, 55.938}, CountryId{"RU"}}, // Pomelnitsa
    {Coordinate{34.3196, 55.9964}, CountryId{"RU"}}, // 168 km
    {Coordinate{31.6609, 54.7616}, CountryId{"RU"}}, // Q109736693
    {Coordinate{31.539, 54.7517}, CountryId{"RU"}}, // Q109736698
    {Coordinate{31.8681, 54.7963}, CountryId{"RU"}}, // Q109743493
    {Coordinate{31.3304, 54.7195}, CountryId{"RU"}}, // Q109743495
    {Coordinate{31.276, 54.7128}, CountryId{"RU"}}, // Q109743497
    {Coordinate{31.1885, 54.6925}, CountryId{"RU"}}, // Q109743498
    {Coordinate{31.9322, 54.7852}, CountryId{"RU"}}, // Q109744091
    {Coordinate{31.912, 54.7838}, CountryId{"RU"}}, // Q109744092
    {Coordinate{31.8361, 54.7817}, CountryId{"RU"}}, // Q109744093
    {Coordinate{31.7649, 54.7913}, CountryId{"RU"}}, // Q109744094
    {Coordinate{31.6376, 54.8329}, CountryId{"RU"}}, // Q109744097
    {Coordinate{31.4463, 54.8538}, CountryId{"RU"}}, // Q109744098
    {Coordinate{31.3878, 54.8682}, CountryId{"RU"}}, // Q109744099
    {Coordinate{31.3034, 54.8837}, CountryId{"RU"}}, // Q109744100
    {Coordinate{31.2569, 54.8847}, CountryId{"RU"}}, // Q109744101
    {Coordinate{31.1444, 54.9156}, CountryId{"RU"}}, // 450 km
    {Coordinate{47.4568, 55.5997}, CountryId{"RU"}}, // Q109757446
    {Coordinate{47.3358, 55.6228}, CountryId{"RU"}}, // Q109757447
    {Coordinate{47.3064, 55.6614}, CountryId{"RU"}}, // Q109757449
    {Coordinate{47.2926, 55.7286}, CountryId{"RU"}}, // Q109757450
    {Coordinate{47.387, 55.8271}, CountryId{"RU"}}, // Q109757451
    {Coordinate{47.3416, 55.8601}, CountryId{"RU"}}, // Q109757453
    {Coordinate{47.3139, 55.8786}, CountryId{"RU"}}, // Q109757454
    {Coordinate{47.2492, 55.8938}, CountryId{"RU"}}, // Q109757456
    {Coordinate{47.2212, 55.9063}, CountryId{"RU"}}, // Q109757458
    {Coordinate{47.2122, 55.9372}, CountryId{"RU"}}, // Q109757460
    {Coordinate{47.2028, 55.968}, CountryId{"RU"}}, // Q109757461
    {Coordinate{47.1534, 55.9849}, CountryId{"RU"}}, // Q109757463
    {Coordinate{47.1136, 56.0072}, CountryId{"RU"}}, // Q109757464
    {Coordinate{47.0952, 56.0503}, CountryId{"RU"}}, // Q109757466
    {Coordinate{133.046, 42.9117}, CountryId{"RU"}}, // Yekaterinovka
    {Coordinate{48.4482, 55.6956}, CountryId{"RU"}}, // Q109771934
    {Coordinate{48.3803, 55.6774}, CountryId{"RU"}}, // Q109771936
    {Coordinate{48.3471, 55.5753}, CountryId{"RU"}}, // Q109771937
    {Coordinate{48.3714, 55.4948}, CountryId{"RU"}}, // Q109771938
    {Coordinate{48.4711, 55.4037}, CountryId{"RU"}}, // Q109771939
    {Coordinate{48.2632, 55.1069}, CountryId{"RU"}}, // Q109771943
    {Coordinate{47.6492, 56.7069}, CountryId{"RU"}}, // Q109772862
    {Coordinate{47.6497, 56.7518}, CountryId{"RU"}}, // Q109772863
    {Coordinate{47.6294, 56.8035}, CountryId{"RU"}}, // Q109772864
    {Coordinate{47.6613, 56.9188}, CountryId{"RU"}}, // Q109772865
    {Coordinate{47.6938, 57.03}, CountryId{"RU"}}, // Q109772866
    {Coordinate{47.7082, 57.0746}, CountryId{"RU"}}, // Q109772867
    {Coordinate{53.1135, 56.555}, CountryId{"RU"}}, // Q109796196
    {Coordinate{53.21, 56.5125}, CountryId{"RU"}}, // Q109796197
    {Coordinate{53.3064, 56.5165}, CountryId{"RU"}}, // Q109796198
    {Coordinate{53.383, 56.5001}, CountryId{"RU"}}, // Q109796199
    {Coordinate{53.4369, 56.4923}, CountryId{"RU"}}, // Q109796200
    {Coordinate{53.527, 56.488}, CountryId{"RU"}}, // Q109796201
    {Coordinate{53.5669, 56.4762}, CountryId{"RU"}}, // Q109796202
    {Coordinate{53.621, 56.468}, CountryId{"RU"}}, // Q109796203
    {Coordinate{53.6678, 56.459}, CountryId{"RU"}}, // Q109796204
    {Coordinate{53.9316, 56.4108}, CountryId{"RU"}}, // Q109796205
    {Coordinate{53.957, 56.5769}, CountryId{"RU"}}, // Q109796210
    {Coordinate{54.1392, 56.7725}, CountryId{"RU"}}, // Q109796211
    {Coordinate{54.3818, 56.2391}, CountryId{"RU"}}, // Q109796410
    {Coordinate{7.35007, 47.362}, CountryId{"CH"}}, // Delémont railway station
    {Coordinate{54.5522, 56.2405}, CountryId{"RU"}}, // Q109818114
    {Coordinate{54.7223, 56.2538}, CountryId{"RU"}}, // Q109818116
    {Coordinate{54.8171, 56.2603}, CountryId{"RU"}}, // Q109818117
    {Coordinate{55.0161, 56.2942}, CountryId{"RU"}}, // Q109818119
    {Coordinate{55.0747, 56.3074}, CountryId{"RU"}}, // Q109818120
    {Coordinate{55.2563, 56.3471}, CountryId{"RU"}}, // Q109818123
    {Coordinate{55.3202, 56.3619}, CountryId{"RU"}}, // Q109818124
    {Coordinate{55.3801, 56.3747}, CountryId{"RU"}}, // Q109818126
    {Coordinate{55.4334, 56.387}, CountryId{"RU"}}, // Q109818127
    {Coordinate{55.5967, 56.4283}, CountryId{"RU"}}, // Q109818129
    {Coordinate{55.7097, 56.4442}, CountryId{"RU"}}, // Q109818130
    {Coordinate{55.7434, 56.4538}, CountryId{"RU"}}, // Q109818132
    {Coordinate{55.7694, 56.4633}, CountryId{"RU"}}, // Q109818133
    {Coordinate{55.879, 56.4959}, CountryId{"RU"}}, // Q109818134
    {Coordinate{55.9794, 56.5016}, CountryId{"RU"}}, // Q109818137
    {Coordinate{56.079, 56.498}, CountryId{"RU"}}, // Q109818139
    {Coordinate{56.2472, 56.4677}, CountryId{"RU"}}, // Q109818142
    {Coordinate{56.3276, 56.4531}, CountryId{"RU"}}, // Q109818143
    {Coordinate{56.4138, 56.4586}, CountryId{"RU"}}, // Q109818144
    {Coordinate{56.5046, 56.4561}, CountryId{"RU"}}, // Q109818146
    {Coordinate{56.6378, 56.4716}, CountryId{"RU"}}, // Q109818147
    {Coordinate{56.7638, 56.4782}, CountryId{"RU"}}, // Q109818149
    {Coordinate{56.7939, 56.4735}, CountryId{"RU"}}, // Q109818150
    {Coordinate{56.8878, 56.4712}, CountryId{"RU"}}, // Q109818152
    {Coordinate{56.9453, 56.4586}, CountryId{"RU"}}, // Q109818153
    {Coordinate{57.013, 56.4781}, CountryId{"RU"}}, // Q109818154
    {Coordinate{57.0602, 56.4702}, CountryId{"RU"}}, // Q109818156
    {Coordinate{57.1109, 56.4784}, CountryId{"RU"}}, // Q109818157
    {Coordinate{57.2051, 56.5088}, CountryId{"RU"}}, // Q109818158
    {Coordinate{57.3071, 56.5247}, CountryId{"RU"}}, // Q109818160
    {Coordinate{57.4341, 56.5425}, CountryId{"RU"}}, // Q109818161
    {Coordinate{57.4882, 56.5376}, CountryId{"RU"}}, // Q109818163
    {Coordinate{57.4971, 56.5202}, CountryId{"RU"}}, // Q109818164
    {Coordinate{57.5424, 56.4999}, CountryId{"RU"}}, // Q109818166
    {Coordinate{57.6204, 56.5023}, CountryId{"RU"}}, // Q109818167
    {Coordinate{57.6657, 56.5063}, CountryId{"RU"}}, // Q109818168
    {Coordinate{57.6925, 56.5285}, CountryId{"RU"}}, // Q109818170
    {Coordinate{57.7233, 56.5536}, CountryId{"RU"}}, // Q109818171
    {Coordinate{57.7521, 56.6231}, CountryId{"RU"}}, // Q109829717
    {Coordinate{57.7852, 56.6438}, CountryId{"RU"}}, // Q109829718
    {Coordinate{57.8516, 56.6638}, CountryId{"RU"}}, // Q109829719
    {Coordinate{57.8747, 56.6708}, CountryId{"RU"}}, // Q109829720
    {Coordinate{57.9742, 56.6906}, CountryId{"RU"}}, // Q109829721
    {Coordinate{58.038, 56.7035}, CountryId{"RU"}}, // Q109829722
    {Coordinate{58.1465, 56.7654}, CountryId{"RU"}}, // Q109829723
    {Coordinate{58.1894, 56.7878}, CountryId{"RU"}}, // Q109829724
    {Coordinate{58.2367, 56.7938}, CountryId{"RU"}}, // Q109829725
    {Coordinate{58.2791, 56.8223}, CountryId{"RU"}}, // Q109829726
    {Coordinate{58.3025, 56.8464}, CountryId{"RU"}}, // Q109829728
    {Coordinate{58.3393, 56.8481}, CountryId{"RU"}}, // Q109829729
    {Coordinate{58.406, 56.8481}, CountryId{"RU"}}, // Q109829730
    {Coordinate{58.4947, 56.8296}, CountryId{"RU"}}, // Q109829731
    {Coordinate{58.6935, 56.8331}, CountryId{"RU"}}, // Q109829733
    {Coordinate{58.7465, 56.8432}, CountryId{"RU"}}, // Q109829734
    {Coordinate{58.7707, 56.8456}, CountryId{"RU"}}, // Q109829735
    {Coordinate{58.8117, 56.8589}, CountryId{"RU"}}, // Q109829736
    {Coordinate{59.0665, 56.8448}, CountryId{"RU"}}, // Q109829739
    {Coordinate{59.1369, 56.8532}, CountryId{"RU"}}, // Q109829740
    {Coordinate{59.152, 56.8426}, CountryId{"RU"}}, // Q109829741
    {Coordinate{59.2431, 56.8834}, CountryId{"RU"}}, // Q109829742
    {Coordinate{59.283, 56.865}, CountryId{"RU"}}, // Q109829743
    {Coordinate{59.2996, 56.8479}, CountryId{"RU"}}, // Q109829744
    {Coordinate{59.3883, 56.8139}, CountryId{"RU"}}, // Q109829745
    {Coordinate{52.5639, 56.1145}, CountryId{"RU"}}, // Q109833714
    {Coordinate{52.9725, 56.484}, CountryId{"RU"}}, // Q109836594
    {Coordinate{52.9732, 56.4585}, CountryId{"RU"}}, // Q109836595
    {Coordinate{52.9186, 56.3814}, CountryId{"RU"}}, // Q109836598
    {Coordinate{52.8778, 56.3329}, CountryId{"RU"}}, // Q109836599
    {Coordinate{52.6905, 56.236}, CountryId{"RU"}}, // Q109836603
    {Coordinate{133.071, 42.9572}, CountryId{"RU"}}, // Kuznetsovo
    {Coordinate{53.2735, 57.8728}, CountryId{"RU"}}, // Q109837620
    {Coordinate{53.0375, 56.55}, CountryId{"RU"}}, // Q109849645
    {Coordinate{53.0651, 56.5982}, CountryId{"RU"}}, // Q109849647
    {Coordinate{53.1272, 56.6923}, CountryId{"RU"}}, // Q109849648
    {Coordinate{52.9722, 57.0037}, CountryId{"RU"}}, // Q109849649
    {Coordinate{53.0194, 57.2957}, CountryId{"RU"}}, // Q109849652
    {Coordinate{24.9378, 58.7569}, CountryId{"EE"}}, // Eidapere railway station
    {Coordinate{49.8132, 58.4704}, CountryId{"RU"}}, // Q109877922
    {Coordinate{49.9111, 58.4714}, CountryId{"RU"}}, // Q109877923
    {Coordinate{50.353, 58.4165}, CountryId{"RU"}}, // Q109877924
    {Coordinate{50.4766, 58.4454}, CountryId{"RU"}}, // Q109877925
    {Coordinate{50.5187, 58.4511}, CountryId{"RU"}}, // Q109877926
    {Coordinate{50.5837, 58.4485}, CountryId{"RU"}}, // Q109877927
    {Coordinate{50.6369, 58.4629}, CountryId{"RU"}}, // Q109877928
    {Coordinate{50.7077, 58.4801}, CountryId{"RU"}}, // Q109877929
    {Coordinate{50.8323, 58.4569}, CountryId{"RU"}}, // Q109877931
    {Coordinate{50.9912, 58.4343}, CountryId{"RU"}}, // Q109877933
    {Coordinate{51.0265, 58.4209}, CountryId{"RU"}}, // Q109877934
    {Coordinate{51.1342, 58.4039}, CountryId{"RU"}}, // Q109877935
    {Coordinate{51.2835, 58.4165}, CountryId{"RU"}}, // Q109877936
    {Coordinate{51.3952, 58.404}, CountryId{"RU"}}, // Q109877937
    {Coordinate{51.5116, 58.3978}, CountryId{"RU"}}, // Q109877938
    {Coordinate{51.6466, 58.3361}, CountryId{"RU"}}, // Q109877939
    {Coordinate{51.7041, 58.3306}, CountryId{"RU"}}, // Q109877940
    {Coordinate{51.7347, 58.3195}, CountryId{"RU"}}, // Q109877941
    {Coordinate{51.8386, 58.2963}, CountryId{"RU"}}, // Q109886074
    {Coordinate{51.9207, 58.2888}, CountryId{"RU"}}, // Q109886077
    {Coordinate{51.9592, 58.2872}, CountryId{"RU"}}, // Q109886078
    {Coordinate{52.1284, 58.2375}, CountryId{"RU"}}, // Q109886081
    {Coordinate{52.1552, 58.22}, CountryId{"RU"}}, // Q109886083
    {Coordinate{52.2518, 58.1975}, CountryId{"RU"}}, // Q109886084
    {Coordinate{52.4228, 58.1593}, CountryId{"RU"}}, // Q109886087
    {Coordinate{52.4617, 58.1524}, CountryId{"RU"}}, // Q109886088
    {Coordinate{52.5082, 58.1564}, CountryId{"RU"}}, // Q109886091
    {Coordinate{52.8376, 58.1027}, CountryId{"RU"}}, // Q109886093
    {Coordinate{52.8924, 58.0844}, CountryId{"RU"}}, // Q109886096
    {Coordinate{52.9296, 58.0559}, CountryId{"RU"}}, // Q109886097
    {Coordinate{52.964, 58.0202}, CountryId{"RU"}}, // Q109886100
    {Coordinate{52.997, 57.9989}, CountryId{"RU"}}, // Q109886101
    {Coordinate{52.7689, 58.1133}, CountryId{"RU"}}, // Q109886214
    {Coordinate{52.1995, 58.3606}, CountryId{"RU"}}, // Q109891884
    {Coordinate{52.127, 58.3988}, CountryId{"RU"}}, // Q109891887
    {Coordinate{52.179, 58.4443}, CountryId{"RU"}}, // Q109891889
    {Coordinate{52.2092, 58.5604}, CountryId{"RU"}}, // Q109891893
    {Coordinate{52.2951, 58.7741}, CountryId{"RU"}}, // Q109891896
    {Coordinate{52.3444, 58.8709}, CountryId{"RU"}}, // Q109891898
    {Coordinate{52.3679, 58.9288}, CountryId{"RU"}}, // Q109891900
    {Coordinate{52.404, 58.9974}, CountryId{"RU"}}, // Q109891903
    {Coordinate{52.1708, 58.3047}, CountryId{"RU"}}, // Q109891987
    {Coordinate{49.5189, 58.6459}, CountryId{"RU"}}, // Q109894303
    {Coordinate{49.6322, 58.6217}, CountryId{"RU"}}, // Q109899974
    {Coordinate{47.061, 60.8176}, CountryId{"RU"}}, // Q109900274
    {Coordinate{25.5467, 58.5453}, CountryId{"EE"}}, // Olustvere railway station
    {Coordinate{49.5621, 58.7313}, CountryId{"RU"}}, // Q109907497
    {Coordinate{49.5109, 58.8389}, CountryId{"RU"}}, // Q109907499
    {Coordinate{49.5033, 58.8557}, CountryId{"RU"}}, // Q109907500
    {Coordinate{49.4897, 58.8718}, CountryId{"RU"}}, // Q109907501
    {Coordinate{49.4262, 58.9216}, CountryId{"RU"}}, // Q109907502
    {Coordinate{49.3918, 58.9483}, CountryId{"RU"}}, // Q109907503
    {Coordinate{49.3504, 58.976}, CountryId{"RU"}}, // Q109907504
    {Coordinate{49.3107, 58.997}, CountryId{"RU"}}, // Q109907505
    {Coordinate{49.188, 59.1063}, CountryId{"RU"}}, // Q109907506
    {Coordinate{49.1108, 59.3077}, CountryId{"RU"}}, // Q109907507
    {Coordinate{49.0467, 59.3633}, CountryId{"RU"}}, // Q109907508
    {Coordinate{48.9049, 59.4445}, CountryId{"RU"}}, // Q109907509
    {Coordinate{48.6752, 59.5818}, CountryId{"RU"}}, // Q109907510
    {Coordinate{48.6198, 59.6282}, CountryId{"RU"}}, // Q109907511
    {Coordinate{48.5051, 59.6832}, CountryId{"RU"}}, // Q109907512
    {Coordinate{48.417, 59.7273}, CountryId{"RU"}}, // Q109907513
    {Coordinate{48.3754, 59.7605}, CountryId{"RU"}}, // Q109907515
    {Coordinate{48.172, 59.9481}, CountryId{"RU"}}, // Q109910080
    {Coordinate{48.0429, 60.0523}, CountryId{"RU"}}, // Q109910081
    {Coordinate{47.8945, 60.1319}, CountryId{"RU"}}, // Q109910082
    {Coordinate{47.8866, 60.1929}, CountryId{"RU"}}, // Q109910083
    {Coordinate{47.7858, 60.2515}, CountryId{"RU"}}, // Q109910084
    {Coordinate{47.6997, 60.331}, CountryId{"RU"}}, // Q109910085
    {Coordinate{47.616, 60.3805}, CountryId{"RU"}}, // Q109910086
    {Coordinate{47.5333, 60.4047}, CountryId{"RU"}}, // Q109910087
    {Coordinate{47.4876, 60.4691}, CountryId{"RU"}}, // Q109910088
    {Coordinate{47.3341, 60.5568}, CountryId{"RU"}}, // Q109910089
    {Coordinate{47.2257, 60.7037}, CountryId{"RU"}}, // Q109910090
    {Coordinate{47.1786, 60.7477}, CountryId{"RU"}}, // Q109910091
    {Coordinate{47.0781, 60.3567}, CountryId{"RU"}}, // Q109910093
    {Coordinate{47.2563, 60.895}, CountryId{"RU"}}, // Q109910094
    {Coordinate{18.3445, 48.1028}, CountryId{"SK"}}, // Q109911980
    {Coordinate{53.3276, 57.8631}, CountryId{"RU"}}, // Q109912287
    {Coordinate{18.7709, 48.5397}, CountryId{"SK"}}, // Railway station Hliník nad Hronom
    {Coordinate{59.8557, 58.3576}, CountryId{"RU"}}, // Q109919887
    {Coordinate{40.2073, 53.7393}, CountryId{"RU"}}, // Q109923426
    {Coordinate{40.2557, 53.7484}, CountryId{"RU"}}, // Q109923427
    {Coordinate{40.3524, 53.7545}, CountryId{"RU"}}, // Q109923428
    {Coordinate{40.4271, 53.7448}, CountryId{"RU"}}, // Q109923429
    {Coordinate{40.5834, 53.7105}, CountryId{"RU"}}, // Q109923430
    {Coordinate{40.7281, 53.6888}, CountryId{"RU"}}, // Q109923431
    {Coordinate{40.8671, 53.6998}, CountryId{"RU"}}, // Q109923433
    {Coordinate{40.9891, 53.7086}, CountryId{"RU"}}, // Q109923434
    {Coordinate{41.1207, 53.6418}, CountryId{"RU"}}, // Q109923436
    {Coordinate{41.2236, 53.6039}, CountryId{"RU"}}, // Q109923437
    {Coordinate{41.2974, 53.5563}, CountryId{"RU"}}, // Q109923438
    {Coordinate{41.4293, 53.5057}, CountryId{"RU"}}, // Q109923439
    {Coordinate{41.6608, 53.4686}, CountryId{"RU"}}, // Q109923441
    {Coordinate{41.723, 53.4514}, CountryId{"RU"}}, // Q109923442
    {Coordinate{41.7808, 53.4402}, CountryId{"RU"}}, // Q109923443
    {Coordinate{41.8046, 53.4581}, CountryId{"RU"}}, // Q109923444
    {Coordinate{41.8251, 53.4623}, CountryId{"RU"}}, // Q109923445
    {Coordinate{41.8479, 53.4591}, CountryId{"RU"}}, // Q109923446
    {Coordinate{41.9462, 53.4257}, CountryId{"RU"}}, // Q109923447
    {Coordinate{42.0495, 53.4099}, CountryId{"RU"}}, // Q109923448
    {Coordinate{40.8164, 53.6945}, CountryId{"RU"}}, // Q109923456
    {Coordinate{43.5538, 53.2961}, CountryId{"RU"}}, // Q109923764
    {Coordinate{8.76145, 51.7162}, CountryId{"DE"}}, // Paderborn Kasseler Tor station
    {Coordinate{133.114, 43.0188}, CountryId{"RU"}}, // Novaya Sila
    {Coordinate{42.4823, 53.2398}, CountryId{"RU"}}, // Q109924127
    {Coordinate{42.6623, 53.2316}, CountryId{"RU"}}, // Q109924128
    {Coordinate{42.7988, 53.224}, CountryId{"RU"}}, // Q109924129
    {Coordinate{42.908, 53.2026}, CountryId{"RU"}}, // Q109924130
    {Coordinate{43.1667, 53.2451}, CountryId{"RU"}}, // Q109924131
    {Coordinate{43.2604, 53.2917}, CountryId{"RU"}}, // Q109924132
    {Coordinate{43.394, 53.3303}, CountryId{"RU"}}, // Q109924133
    {Coordinate{43.669, 53.274}, CountryId{"RU"}}, // Q109924134
    {Coordinate{43.7554, 53.2727}, CountryId{"RU"}}, // Q109924135
    {Coordinate{43.849, 53.2365}, CountryId{"RU"}}, // Q109924136
    {Coordinate{43.9517, 53.2258}, CountryId{"RU"}}, // Q109924137
    {Coordinate{44.1595, 53.1308}, CountryId{"RU"}}, // Q109924138
    {Coordinate{44.2775, 53.1534}, CountryId{"RU"}}, // Q109924139
    {Coordinate{44.3957, 53.2005}, CountryId{"RU"}}, // Q109924140
    {Coordinate{88.8685, 23.0368}, CountryId{"IN"}}, // Petrapole railway station
    {Coordinate{45.1532, 53.21}, CountryId{"RU"}}, // Q109930250
    {Coordinate{45.197, 53.2044}, CountryId{"RU"}}, // Q109930251
    {Coordinate{45.2085, 53.1747}, CountryId{"RU"}}, // Q109930252
    {Coordinate{45.236, 53.1293}, CountryId{"RU"}}, // Q109930253
    {Coordinate{45.3216, 53.1373}, CountryId{"RU"}}, // Q109930254
    {Coordinate{45.3517, 53.1339}, CountryId{"RU"}}, // Q109930256
    {Coordinate{45.4832, 53.1116}, CountryId{"RU"}}, // Q109930257
    {Coordinate{45.5494, 53.1045}, CountryId{"RU"}}, // Q109930258
    {Coordinate{45.5818, 53.1056}, CountryId{"RU"}}, // Q109930259
    {Coordinate{45.6892, 53.1085}, CountryId{"RU"}}, // Q109930260
    {Coordinate{45.8152, 53.1067}, CountryId{"RU"}}, // Q109930261
    {Coordinate{45.9193, 53.1404}, CountryId{"RU"}}, // Q109930262
    {Coordinate{45.984, 53.1431}, CountryId{"RU"}}, // Q109930263
    {Coordinate{46.0093, 53.1504}, CountryId{"RU"}}, // Q109930264
    {Coordinate{46.1223, 53.1488}, CountryId{"RU"}}, // Q109930265
    {Coordinate{46.1868, 53.1459}, CountryId{"RU"}}, // Q109930266
    {Coordinate{46.3804, 53.1036}, CountryId{"RU"}}, // Q109930267
    {Coordinate{46.4872, 53.1109}, CountryId{"RU"}}, // Q109930268
    {Coordinate{46.5695, 53.1172}, CountryId{"RU"}}, // Q109930269
    {Coordinate{46.7488, 53.0981}, CountryId{"RU"}}, // Q109930270
    {Coordinate{46.8897, 53.1167}, CountryId{"RU"}}, // Q109930271
    {Coordinate{46.9691, 53.1295}, CountryId{"RU"}}, // Q109930273
    {Coordinate{47.0205, 53.1442}, CountryId{"RU"}}, // Q109930274
    {Coordinate{47.1166, 53.1189}, CountryId{"RU"}}, // Q109930275
    {Coordinate{47.3002, 53.1362}, CountryId{"RU"}}, // Q109930276
    {Coordinate{47.5427, 53.1528}, CountryId{"RU"}}, // Q109930277
    {Coordinate{47.5987, 53.1515}, CountryId{"RU"}}, // Q109930278
    {Coordinate{47.6539, 53.1452}, CountryId{"RU"}}, // Q109930279
    {Coordinate{47.8727, 53.1669}, CountryId{"RU"}}, // Q109930280
    {Coordinate{47.9138, 53.1714}, CountryId{"RU"}}, // Q109930281
    {Coordinate{47.9543, 53.1724}, CountryId{"RU"}}, // Q109930282
    {Coordinate{47.9997, 53.1745}, CountryId{"RU"}}, // Q109930283
    {Coordinate{48.0957, 53.171}, CountryId{"RU"}}, // Q109930284
    {Coordinate{48.1909, 53.169}, CountryId{"RU"}}, // Q109930285
    {Coordinate{48.2392, 53.1676}, CountryId{"RU"}}, // Q109930286
    {Coordinate{48.269, 53.1663}, CountryId{"RU"}}, // Q109930287
    {Coordinate{48.3006, 53.1637}, CountryId{"RU"}}, // Q109930289
    {Coordinate{-130.176, 54.178}, CountryId{"CA"}}, // Cassiar Cannery
    {Coordinate{133.145, 43.0619}, CountryId{"RU"}}, // Lozovy
    {Coordinate{23.7544, 55.6309}, CountryId{"LT"}}, // Baisogala railway station
    {Coordinate{43.0295, 54.0942}, CountryId{"RU"}}, // Q109936605
    {Coordinate{43.7435, 54.0112}, CountryId{"RU"}}, // Q109936606
    {Coordinate{43.97, 54.0513}, CountryId{"RU"}}, // Q109936607
    {Coordinate{44.0504, 54.075}, CountryId{"RU"}}, // Q109936608
    {Coordinate{44.1528, 54.1047}, CountryId{"RU"}}, // Q109936609
    {Coordinate{44.2036, 54.0969}, CountryId{"RU"}}, // Q109936610
    {Coordinate{44.2503, 54.0893}, CountryId{"RU"}}, // Q109936611
    {Coordinate{44.6533, 54.0971}, CountryId{"RU"}}, // Q109936612
    {Coordinate{44.7529, 54.0794}, CountryId{"RU"}}, // Q109936613
    {Coordinate{44.7931, 54.0735}, CountryId{"RU"}}, // Q109936614
    {Coordinate{44.8983, 54.0589}, CountryId{"RU"}}, // Q109936615
    {Coordinate{8.64557, 51.7122}, CountryId{"DE"}}, // Scharmede station
    {Coordinate{45.169, 54.0447}, CountryId{"RU"}}, // Q109944210
    {Coordinate{45.23, 53.9905}, CountryId{"RU"}}, // Q109944211
    {Coordinate{45.2632, 53.9802}, CountryId{"RU"}}, // Q109944212
    {Coordinate{45.3451, 53.9526}, CountryId{"RU"}}, // Q109944213
    {Coordinate{45.478, 53.9328}, CountryId{"RU"}}, // Q109944214
    {Coordinate{45.5536, 53.9267}, CountryId{"RU"}}, // Q109944215
    {Coordinate{45.6156, 53.9405}, CountryId{"RU"}}, // Q109944216
    {Coordinate{45.6461, 53.9323}, CountryId{"RU"}}, // Q109944217
    {Coordinate{45.6732, 53.932}, CountryId{"RU"}}, // Q109944218
    {Coordinate{45.6843, 53.9003}, CountryId{"RU"}}, // Q109944219
    {Coordinate{45.811, 53.8865}, CountryId{"RU"}}, // Q109944220
    {Coordinate{45.9541, 53.8709}, CountryId{"RU"}}, // Q109944222
    {Coordinate{46.0235, 53.879}, CountryId{"RU"}}, // Q109944223
    {Coordinate{}, CountryId{"FR"}}, // Gare de Mortagne-au-Perche
    {Coordinate{46.4269, 53.8349}, CountryId{"RU"}}, // Q109947634
    {Coordinate{46.4521, 53.8196}, CountryId{"RU"}}, // Q109947636
    {Coordinate{46.5005, 53.799}, CountryId{"RU"}}, // Q109947637
    {Coordinate{46.591, 53.7553}, CountryId{"RU"}}, // Q109947639
    {Coordinate{46.7162, 53.7482}, CountryId{"RU"}}, // Q109947640
    {Coordinate{46.7564, 53.7448}, CountryId{"RU"}}, // Q109947641
    {Coordinate{46.8305, 53.6752}, CountryId{"RU"}}, // Q109947642
    {Coordinate{46.9227, 53.6762}, CountryId{"RU"}}, // Q109947643
    {Coordinate{46.9641, 53.6734}, CountryId{"RU"}}, // Q109947645
    {Coordinate{47.0294, 53.6917}, CountryId{"RU"}}, // Q109947646
    {Coordinate{47.0648, 53.6892}, CountryId{"RU"}}, // Q109947647
    {Coordinate{47.0737, 53.6717}, CountryId{"RU"}}, // Q109947648
    {Coordinate{47.1061, 53.6552}, CountryId{"RU"}}, // Q109947650
    {Coordinate{47.1456, 53.6292}, CountryId{"RU"}}, // Q109947651
    {Coordinate{47.1943, 53.6233}, CountryId{"RU"}}, // Q109947652
    {Coordinate{47.3684, 53.6109}, CountryId{"RU"}}, // Q109947653
    {Coordinate{47.6049, 53.5471}, CountryId{"RU"}}, // Q109947654
    {Coordinate{47.686, 53.5481}, CountryId{"RU"}}, // Q109947655
    {Coordinate{47.816, 53.5506}, CountryId{"RU"}}, // Q109947656
    {Coordinate{47.9322, 53.4978}, CountryId{"RU"}}, // Q109947658
    {Coordinate{47.9877, 53.4094}, CountryId{"RU"}}, // Q109947659
    {Coordinate{48.0176, 53.3859}, CountryId{"RU"}}, // Q109947660
    {Coordinate{48.0211, 53.327}, CountryId{"RU"}}, // Q109947661
    {Coordinate{48.0913, 53.2836}, CountryId{"RU"}}, // Q109947662
    {Coordinate{48.137, 53.2238}, CountryId{"RU"}}, // Q109947663
    {Coordinate{48.1971, 53.1934}, CountryId{"RU"}}, // Q109947664
    {Coordinate{48.2781, 53.1755}, CountryId{"RU"}}, // Q109947665
    {Coordinate{48.4381, 53.1673}, CountryId{"RU"}}, // Q109949983
    {Coordinate{133.074, 43.1984}, CountryId{"RU"}}, // Narechnoye
    {Coordinate{8.60091, 51.6731}, CountryId{"DE"}}, // Salzkotten station
    {Coordinate{46.4624, 53.9056}, CountryId{"RU"}}, // Q110004889
    {Coordinate{46.6115, 53.891}, CountryId{"RU"}}, // Q110004891
    {Coordinate{46.6655, 53.902}, CountryId{"RU"}}, // Q110004893
    {Coordinate{46.696, 53.9527}, CountryId{"RU"}}, // Q110004895
    {Coordinate{46.8584, 53.9712}, CountryId{"RU"}}, // Q110004896
    {Coordinate{47.1254, 54.0474}, CountryId{"RU"}}, // Q110004898
    {Coordinate{47.3502, 54.0974}, CountryId{"RU"}}, // Q110004900
    {Coordinate{47.3976, 54.102}, CountryId{"RU"}}, // Q110004902
    {Coordinate{47.4529, 54.096}, CountryId{"RU"}}, // Q110004904
    {Coordinate{47.6222, 54.1171}, CountryId{"RU"}}, // Q110004906
    {Coordinate{47.7509, 54.1246}, CountryId{"RU"}}, // Q110004908
    {Coordinate{47.7898, 54.1289}, CountryId{"RU"}}, // Q110004910
    {Coordinate{47.866, 54.1709}, CountryId{"RU"}}, // Q110004912
    {Coordinate{47.9254, 54.1755}, CountryId{"RU"}}, // Q110004914
    {Coordinate{48.014, 54.1932}, CountryId{"RU"}}, // Q110004916
    {Coordinate{48.0815, 54.2128}, CountryId{"RU"}}, // Q110004917
    {Coordinate{48.1249, 54.2172}, CountryId{"RU"}}, // Q110004919
    {Coordinate{48.1541, 54.2175}, CountryId{"RU"}}, // Q110004921
    {Coordinate{48.1919, 54.2282}, CountryId{"RU"}}, // Q110004923
    {Coordinate{48.2691, 54.2536}, CountryId{"RU"}}, // Studencheskaya
    {Coordinate{50.8038, 54.424}, CountryId{"RU"}}, // Nurlat railway station
    {Coordinate{48.5368, 54.3353}, CountryId{"RU"}}, // Verkhnyaya Terrasa
    {Coordinate{48.7046, 54.3454}, CountryId{"RU"}}, // Sovkhozny
    {Coordinate{48.8525, 54.3415}, CountryId{"RU"}}, // Cherdakly railway station
    {Coordinate{49.067, 54.3485}, CountryId{"RU"}}, // Urenbash
    {Coordinate{49.2213, 54.3342}, CountryId{"RU"}}, // Putevoy
    {Coordinate{49.3527, 54.339}, CountryId{"RU"}}, // Bryandino railway station
    {Coordinate{49.482, 54.3029}, CountryId{"RU"}}, // Tiinsk
    {Coordinate{50.4418, 54.2309}, CountryId{"RU"}}, // Pogruznaya
    {Coordinate{51.0963, 54.4064}, CountryId{"RU"}}, // Q110008152
    {Coordinate{51.4665, 54.4355}, CountryId{"RU"}}, // Q110008153
    {Coordinate{52.0225, 54.2591}, CountryId{"RU"}}, // Q110008154
    {Coordinate{53.4477, 54.599}, CountryId{"RU"}}, // Q110013661
    {Coordinate{53.7093, 54.6076}, CountryId{"RU"}}, // Q110013662
    {Coordinate{54.0993, 54.5532}, CountryId{"RU"}}, // Q110013663
    {Coordinate{54.1672, 54.5868}, CountryId{"RU"}}, // Q110013664
    {Coordinate{54.202, 54.5982}, CountryId{"RU"}}, // Q110013666
    {Coordinate{54.3508, 54.5868}, CountryId{"RU"}}, // Q110013667
    {Coordinate{54.3943, 54.5768}, CountryId{"RU"}}, // Q110013668
    {Coordinate{54.444, 54.5951}, CountryId{"RU"}}, // Q110013669
    {Coordinate{54.5199, 54.5697}, CountryId{"RU"}}, // Q110013670
    {Coordinate{54.7201, 54.5645}, CountryId{"RU"}}, // Q110013671
    {Coordinate{54.7988, 54.5595}, CountryId{"RU"}}, // Q110013672
    {Coordinate{54.9259, 54.5797}, CountryId{"RU"}}, // Q110013673
    {Coordinate{55.0085, 54.5998}, CountryId{"RU"}}, // Q110013674
    {Coordinate{55.0807, 54.5822}, CountryId{"RU"}}, // Q110013675
    {Coordinate{55.1467, 54.5609}, CountryId{"RU"}}, // Q110013676
    {Coordinate{55.2072, 54.5637}, CountryId{"RU"}}, // Q110013677
    {Coordinate{55.3457, 54.5811}, CountryId{"RU"}}, // Q110013678
    {Coordinate{12.1897, 56.0329}, CountryId{"DK"}}, // Troldebakkerne railway station
    {Coordinate{-72.9218, 41.3058}, CountryId{"US"}}, // New Haven State Street station
    {Coordinate{52.447, 54.5712}, CountryId{"RU"}}, // Q110020274
    {Coordinate{52.1388, 54.9194}, CountryId{"RU"}}, // Q110020275
    {Coordinate{52.1114, 54.9941}, CountryId{"RU"}}, // Q110020276
    {Coordinate{52.0697, 55.0813}, CountryId{"RU"}}, // Q110020277
    {Coordinate{52.0055, 55.1831}, CountryId{"RU"}}, // Q110020278
    {Coordinate{51.9744, 55.3893}, CountryId{"RU"}}, // Q110020280
    {Coordinate{51.9796, 55.4115}, CountryId{"RU"}}, // Q110020281
    {Coordinate{52.0209, 55.4454}, CountryId{"RU"}}, // Q110020282
    {Coordinate{51.9892, 55.5043}, CountryId{"RU"}}, // Q110020283
    {Coordinate{52.0084, 55.5398}, CountryId{"RU"}}, // Q110020284
    {Coordinate{52.0718, 55.5637}, CountryId{"RU"}}, // Q110020285
    {Coordinate{52.1732, 55.6194}, CountryId{"RU"}}, // Q110020286
    {Coordinate{52.3127, 55.8859}, CountryId{"RU"}}, // Q110020288
    {Coordinate{52.3424, 55.9111}, CountryId{"RU"}}, // Q110020289
    {Coordinate{52.363, 55.9524}, CountryId{"RU"}}, // Q110020290
    {Coordinate{52.4091, 55.9846}, CountryId{"RU"}}, // Q110020292
    {Coordinate{52.5206, 56.0239}, CountryId{"RU"}}, // Q110020293
    {Coordinate{52.5595, 56.0747}, CountryId{"RU"}}, // Q110020294
    {Coordinate{51.9704, 55.5914}, CountryId{"RU"}}, // Q110020295
    {Coordinate{51.8105, 55.6176}, CountryId{"RU"}}, // Q110020296
    {Coordinate{7.4788, 51.3511}, CountryId{"DE"}}, // Bahnhof Hagen-Oberhagen
    {Coordinate{49.5145, 53.3974}, CountryId{"RU"}}, // Q110038266
    {Coordinate{49.4926, 53.4058}, CountryId{"RU"}}, // Q110038267
    {Coordinate{49.778, 53.4843}, CountryId{"RU"}}, // Q110038268
    {Coordinate{50.0006, 53.4787}, CountryId{"RU"}}, // Q110038269
    {Coordinate{50.1204, 53.4327}, CountryId{"RU"}}, // Q110038270
    {Coordinate{50.1634, 53.4384}, CountryId{"RU"}}, // Q110038271
    {Coordinate{50.196, 53.4199}, CountryId{"RU"}}, // Q110038272
    {Coordinate{50.2971, 53.4036}, CountryId{"RU"}}, // Q110038273
    {Coordinate{50.327, 53.3859}, CountryId{"RU"}}, // Q110038274
    {Coordinate{50.341, 53.3718}, CountryId{"RU"}}, // Q110038275
    {Coordinate{50.3575, 53.3629}, CountryId{"RU"}}, // Q110038276
    {Coordinate{50.3163, 53.3163}, CountryId{"RU"}}, // Q110038279
    {Coordinate{50.3017, 53.3021}, CountryId{"RU"}}, // Q110038281
    {Coordinate{50.3086, 53.2879}, CountryId{"RU"}}, // Q110038283
    {Coordinate{50.3172, 53.2705}, CountryId{"RU"}}, // Q110038285
    {Coordinate{50.3058, 53.2564}, CountryId{"RU"}}, // Q110038286
    {Coordinate{50.2886, 53.2339}, CountryId{"RU"}}, // Q110038287
    {Coordinate{50.238, 53.1995}, CountryId{"RU"}}, // Q110038289
    {Coordinate{50.2155, 53.185}, CountryId{"RU"}}, // Q110038290
    {Coordinate{50.1875, 53.174}, CountryId{"RU"}}, // Q110038291
    {Coordinate{50.1551, 53.1752}, CountryId{"RU"}}, // Q110038292
    {Coordinate{50.1364, 53.182}, CountryId{"RU"}}, // Q110038294
    {Coordinate{48.5219, 53.1749}, CountryId{"RU"}}, // Q110042404
    {Coordinate{48.537, 53.1748}, CountryId{"RU"}}, // Q110042405
    {Coordinate{48.6041, 53.1568}, CountryId{"RU"}}, // Q110042406
    {Coordinate{48.6278, 53.1549}, CountryId{"RU"}}, // Q110042407
    {Coordinate{48.6517, 53.1582}, CountryId{"RU"}}, // Q110042408
    {Coordinate{48.6694, 53.1611}, CountryId{"RU"}}, // Q110042409
    {Coordinate{48.6869, 53.1649}, CountryId{"RU"}}, // Q110042410
    {Coordinate{48.7113, 53.1689}, CountryId{"RU"}}, // Q110042411
    {Coordinate{48.7342, 53.1748}, CountryId{"RU"}}, // Q110042412
    {Coordinate{48.7854, 53.1838}, CountryId{"RU"}}, // Q110042413
    {Coordinate{48.839, 53.1385}, CountryId{"RU"}}, // Q110042414
    {Coordinate{48.8762, 53.1142}, CountryId{"RU"}}, // Q110042415
    {Coordinate{49.0003, 53.0677}, CountryId{"RU"}}, // Q110042416
    {Coordinate{49.0825, 53.0488}, CountryId{"RU"}}, // Q110042417
    {Coordinate{49.1838, 53.0233}, CountryId{"RU"}}, // Q110042419
    {Coordinate{49.3114, 52.9911}, CountryId{"RU"}}, // Maytuga
    {Coordinate{49.4317, 52.9787}, CountryId{"RU"}}, // Bezenchuk
    {Coordinate{49.519, 52.9687}, CountryId{"RU"}}, // Vostok
    {Coordinate{49.6844, 52.9626}, CountryId{"RU"}}, // Q110043363
    {Coordinate{49.7028, 52.9773}, CountryId{"RU"}}, // Q110043364
    {Coordinate{49.7135, 52.9878}, CountryId{"RU"}}, // Q110043365
    {Coordinate{49.7743, 53.036}, CountryId{"RU"}}, // Q110043366
    {Coordinate{49.8159, 53.0544}, CountryId{"RU"}}, // Q110043367
    {Coordinate{49.8424, 53.0701}, CountryId{"RU"}}, // Q110043368
    {Coordinate{49.8646, 53.0882}, CountryId{"RU"}}, // Q110043369
    {Coordinate{49.9299, 53.1208}, CountryId{"RU"}}, // Q110043371
    {Coordinate{49.985, 53.1015}, CountryId{"RU"}}, // Q110043372
    {Coordinate{50.0091, 53.0928}, CountryId{"RU"}}, // Q110043373
    {Coordinate{50.0387, 53.1032}, CountryId{"RU"}}, // Q110043375
    {Coordinate{50.0604, 53.1149}, CountryId{"RU"}}, // Q110043376
    {Coordinate{50.0912, 53.133}, CountryId{"RU"}}, // Q110043377
    {Coordinate{12.5039, 52.4277}, CountryId{"DE"}}, // Q110043966
    {Coordinate{133.027, 43.1875}, CountryId{"RU"}}, // Krasnoarmeysky
    {Coordinate{8.5103, 51.6452}, CountryId{"DE"}}, // Geseke station
    {Coordinate{50.2854, 53.2193}, CountryId{"RU"}}, // Q110061973
    {Coordinate{50.3383, 53.2412}, CountryId{"RU"}}, // Q110061974
    {Coordinate{50.3841, 53.2599}, CountryId{"RU"}}, // Q110061975
    {Coordinate{50.4193, 53.25}, CountryId{"RU"}}, // Q110061976
    {Coordinate{50.4874, 53.2358}, CountryId{"RU"}}, // Q110061977
    {Coordinate{50.5352, 53.2493}, CountryId{"RU"}}, // Sovety
    {Coordinate{132.979, 43.2201}, CountryId{"RU"}}, // Fridman
    {Coordinate{9.37156, 49.4306}, CountryId{"DE"}}, // Q110068611
    {Coordinate{132.884, 43.1792}, CountryId{"RU"}}, // Tigrovy
    {Coordinate{50.7093, 53.2325}, CountryId{"RU"}}, // 1144 km
    {Coordinate{50.7399, 53.2388}, CountryId{"RU"}}, // Q110072060
    {Coordinate{50.837, 53.2519}, CountryId{"RU"}}, // Q110072063
    {Coordinate{50.9529, 53.2589}, CountryId{"RU"}}, // Q110072064
    {Coordinate{51.0017, 53.264}, CountryId{"RU"}}, // Q110072065
    {Coordinate{51.0681, 53.2709}, CountryId{"RU"}}, // Q110072066
    {Coordinate{51.1742, 53.2804}, CountryId{"RU"}}, // Q110072067
    {Coordinate{51.3474, 53.3591}, CountryId{"RU"}}, // Q110072068
    {Coordinate{51.431, 53.4052}, CountryId{"RU"}}, // Q110072069
    {Coordinate{51.5289, 53.4583}, CountryId{"RU"}}, // Q110072071
    {Coordinate{51.6354, 53.5325}, CountryId{"RU"}}, // Q110072073
    {Coordinate{51.7263, 53.5627}, CountryId{"RU"}}, // Q110072074
    {Coordinate{51.8818, 53.6168}, CountryId{"RU"}}, // Q110072076
    {Coordinate{51.9276, 53.6315}, CountryId{"RU"}}, // Q110072077
    {Coordinate{52.013, 53.6394}, CountryId{"RU"}}, // Q110072078
    {Coordinate{52.2249, 53.6385}, CountryId{"RU"}}, // Q110072079
    {Coordinate{52.2888, 53.6395}, CountryId{"RU"}}, // Q110072080
    {Coordinate{52.501, 53.608}, CountryId{"RU"}}, // Q110072081
    {Coordinate{52.577, 53.5896}, CountryId{"RU"}}, // Q110072082
    {Coordinate{52.6247, 53.5785}, CountryId{"RU"}}, // Q110072083
    {Coordinate{52.7325, 53.5539}, CountryId{"RU"}}, // Q110072084
    {Coordinate{52.8126, 53.5733}, CountryId{"RU"}}, // Q110072085
    {Coordinate{52.8737, 53.5843}, CountryId{"RU"}}, // Q110072087
    {Coordinate{52.9351, 53.5904}, CountryId{"RU"}}, // Q110072088
    {Coordinate{52.999, 53.5799}, CountryId{"RU"}}, // Q110072089
    {Coordinate{53.0366, 53.5761}, CountryId{"RU"}}, // Q110072090
    {Coordinate{53.0956, 53.587}, CountryId{"RU"}}, // Q110072091
    {Coordinate{53.1446, 53.6068}, CountryId{"RU"}}, // Q110072094
    {Coordinate{53.1791, 53.5822}, CountryId{"RU"}}, // Q110072095
    {Coordinate{53.2006, 53.5755}, CountryId{"RU"}}, // Q110072096
    {Coordinate{53.2448, 53.5864}, CountryId{"RU"}}, // Q110072097
    {Coordinate{53.2879, 53.5864}, CountryId{"RU"}}, // Q110072098
    {Coordinate{53.3292, 53.5802}, CountryId{"RU"}}, // Q110072099
    {Coordinate{53.3773, 53.6025}, CountryId{"RU"}}, // Q110072100
    {Coordinate{53.4328, 53.6093}, CountryId{"RU"}}, // Q110072101
    {Coordinate{53.5087, 53.6108}, CountryId{"RU"}}, // Q110072102
    {Coordinate{53.5611, 53.6353}, CountryId{"RU"}}, // Q110072103
    {Coordinate{53.584, 53.6567}, CountryId{"RU"}}, // Q110072104
    {Coordinate{53.7328, 53.7448}, CountryId{"RU"}}, // Q110072105
    {Coordinate{53.8147, 53.7387}, CountryId{"RU"}}, // Q110072106
    {Coordinate{53.8149, 53.7718}, CountryId{"RU"}}, // Q110072108
    {Coordinate{53.8232, 53.8058}, CountryId{"RU"}}, // Q110072110
    {Coordinate{53.8491, 53.8353}, CountryId{"RU"}}, // Q110072111
    {Coordinate{53.8682, 53.8529}, CountryId{"RU"}}, // Q110072112
    {Coordinate{53.8881, 53.8714}, CountryId{"RU"}}, // Q110072113
    {Coordinate{54.036, 53.9489}, CountryId{"RU"}}, // Q110072114
    {Coordinate{54.1066, 53.9821}, CountryId{"RU"}}, // Q110072116
    {Coordinate{54.3126, 54.0334}, CountryId{"RU"}}, // Q110072117
    {Coordinate{54.3643, 54.0129}, CountryId{"RU"}}, // Q110072118
    {Coordinate{54.3797, 53.9972}, CountryId{"RU"}}, // Q110072119
    {Coordinate{54.3847, 53.9634}, CountryId{"RU"}}, // Q110072120
    {Coordinate{54.442, 53.9285}, CountryId{"RU"}}, // Q110072121
    {Coordinate{54.507, 53.9113}, CountryId{"RU"}}, // Q110072122
    {Coordinate{54.5465, 53.9207}, CountryId{"RU"}}, // Q110072123
    {Coordinate{54.7775, 53.9849}, CountryId{"RU"}}, // Q110072126
    {Coordinate{54.823, 53.9969}, CountryId{"RU"}}, // Q110072127
    {Coordinate{54.9065, 53.991}, CountryId{"RU"}}, // Q110072128
    {Coordinate{54.9886, 54.1532}, CountryId{"RU"}}, // Q110072129
    {Coordinate{54.9855, 54.1756}, CountryId{"RU"}}, // Q110072131
    {Coordinate{55.0664, 54.2337}, CountryId{"RU"}}, // Q110072133
    {Coordinate{55.0984, 54.2679}, CountryId{"RU"}}, // Q110072134
    {Coordinate{55.1274, 54.2947}, CountryId{"RU"}}, // Q110072135
    {Coordinate{55.1507, 54.3146}, CountryId{"RU"}}, // Q110072136
    {Coordinate{55.2014, 54.3647}, CountryId{"RU"}}, // Q110072137
    {Coordinate{55.2123, 54.3864}, CountryId{"RU"}}, // Q110072138
    {Coordinate{55.2503, 54.4508}, CountryId{"RU"}}, // Q110072139
    {Coordinate{55.269, 54.4785}, CountryId{"RU"}}, // Q110072140
    {Coordinate{55.3019, 54.5229}, CountryId{"RU"}}, // Q110072141
    {Coordinate{55.3324, 54.5474}, CountryId{"RU"}}, // Q110072142
    {Coordinate{8.44964, 51.6626}, CountryId{"DE"}}, // Ehringhausen (Kr Lippst)
    {Coordinate{6.82358, 49.9074}, CountryId{"DE"}}, // Sehlem (Kr. Wittlich) railway station
    {Coordinate{2.40472, 41.6379}, CountryId{"ES"}}, // Llinars del Vallès station
    {Coordinate{55.4672, 54.6142}, CountryId{"RU"}}, // Q110085450
    {Coordinate{55.5013, 54.6251}, CountryId{"RU"}}, // Q110085451
    {Coordinate{55.5274, 54.6346}, CountryId{"RU"}}, // Q110085452
    {Coordinate{55.5933, 54.6258}, CountryId{"RU"}}, // Q110085453
    {Coordinate{55.6913, 54.6238}, CountryId{"RU"}}, // Q110085454
    {Coordinate{55.7322, 54.6403}, CountryId{"RU"}}, // Q110085455
    {Coordinate{55.7917, 54.6567}, CountryId{"RU"}}, // Q110085456
    {Coordinate{49.7518, 54.1969}, CountryId{"RU"}}, // Obamza
    {Coordinate{2.24549, 41.5497}, CountryId{"ES"}}, // Montmeló station
    {Coordinate{55.8326, 54.6511}, CountryId{"RU"}}, // Q110088628
    {Coordinate{55.8634, 54.6252}, CountryId{"RU"}}, // Q110088630
    {Coordinate{55.9636, 54.5577}, CountryId{"RU"}}, // Q110088631
    {Coordinate{56.0098, 54.5454}, CountryId{"RU"}}, // Q110088635
    {Coordinate{56.1404, 54.4977}, CountryId{"RU"}}, // Q110088636
    {Coordinate{56.1942, 54.4738}, CountryId{"RU"}}, // Q110088637
    {Coordinate{132.775, 43.1716}, CountryId{"RU"}}, // Anisimovka
    {Coordinate{1.45532, 41.1864}, CountryId{"ES"}}, // Roda de Mar
    {Coordinate{10.4839, 59.875}, CountryId{"NO"}}, // Billingstad Station
    {Coordinate{132.607, 43.218}, CountryId{"RU"}}, // Novonezhino
    {Coordinate{11.3195, 48.8159}, CountryId{"DE"}}, // Eitensheim
    {Coordinate{11.2753, 48.8193}, CountryId{"DE"}}, // Tauberfeld railway station
    {Coordinate{132.523, 43.2322}, CountryId{"RU"}}, // Romanovka
    {Coordinate{11.2115, 48.8407}, CountryId{"DE"}}, // Adelschlag
    {Coordinate{10.9641, 48.9263}, CountryId{"DE"}}, // Pappenheim railway stop
    {Coordinate{10.6534, 48.8037}, CountryId{"DE"}}, // Q110125717
    {Coordinate{56.8777, 54.8756}, CountryId{"RU"}}, // Q110140212
    {Coordinate{56.9185, 54.8783}, CountryId{"RU"}}, // Q110140214
    {Coordinate{56.9513, 54.8877}, CountryId{"RU"}}, // Q110140216
    {Coordinate{57.02, 54.9247}, CountryId{"RU"}}, // Q110140218
    {Coordinate{57.0714, 54.9324}, CountryId{"RU"}}, // Q110140221
    {Coordinate{57.0904, 54.9482}, CountryId{"RU"}}, // Q110140223
    {Coordinate{57.1024, 54.9573}, CountryId{"RU"}}, // Q110140225
    {Coordinate{57.1352, 54.9747}, CountryId{"RU"}}, // Q110140227
    {Coordinate{57.2108, 54.9986}, CountryId{"RU"}}, // Q110140228
    {Coordinate{57.3071, 55.0154}, CountryId{"RU"}}, // Q110140230
    {Coordinate{57.3489, 55.0206}, CountryId{"RU"}}, // Q110140232
    {Coordinate{57.4184, 55.0477}, CountryId{"RU"}}, // Q110140234
    {Coordinate{57.4519, 55.0509}, CountryId{"RU"}}, // Q110140237
    {Coordinate{57.5851, 55.066}, CountryId{"RU"}}, // Q110140240
    {Coordinate{57.623, 55.0724}, CountryId{"RU"}}, // Q110140241
    {Coordinate{57.6679, 55.0665}, CountryId{"RU"}}, // Q110140244
    {Coordinate{57.7528, 55.0482}, CountryId{"RU"}}, // Q110140246
    {Coordinate{57.8047, 55.0397}, CountryId{"RU"}}, // Q110140248
    {Coordinate{57.9168, 55.0354}, CountryId{"RU"}}, // Q110140250
    {Coordinate{57.9819, 55.0303}, CountryId{"RU"}}, // Q110140254
    {Coordinate{10.9595, 49.066}, CountryId{"DE"}}, // Ellingen (Bay) station
    {Coordinate{10.7203, 49.1544}, CountryId{"DE"}}, // Muhr am See railway stop
    {Coordinate{10.2427, 49.5513}, CountryId{"DE"}}, // Uffenheim station
    {Coordinate{10.146, 49.6638}, CountryId{"DE"}}, // Marktbreit station
    {Coordinate{8.39818, 51.6723}, CountryId{"DE"}}, // Dedinghausen station
    {Coordinate{10.0122, 49.7081}, CountryId{"DE"}}, // Winterhausen station
    {Coordinate{11.0561, 49.2135}, CountryId{"DE"}}, // Unterheckenhofen railway stop
    {Coordinate{44.9828, 53.1424}, CountryId{"RU"}}, // Q110142824
    {Coordinate{44.9617, 53.1261}, CountryId{"RU"}}, // Q110142825
    {Coordinate{56.4629, 54.4204}, CountryId{"RU"}}, // Q110147368
    {Coordinate{56.5443, 54.4212}, CountryId{"RU"}}, // Q110147369
    {Coordinate{56.6555, 54.4323}, CountryId{"RU"}}, // Q110147370
    {Coordinate{56.7473, 54.4492}, CountryId{"RU"}}, // Q110147371
    {Coordinate{56.8488, 54.4697}, CountryId{"RU"}}, // Q110147372
    {Coordinate{56.919, 54.4866}, CountryId{"RU"}}, // Q110147373
    {Coordinate{56.9679, 54.502}, CountryId{"RU"}}, // Q110147374
    {Coordinate{57.0432, 54.482}, CountryId{"RU"}}, // Q110147375
    {Coordinate{57.0897, 54.4621}, CountryId{"RU"}}, // Q110147376
    {Coordinate{57.1744, 54.4537}, CountryId{"RU"}}, // Q110147377
    {Coordinate{57.275, 54.4853}, CountryId{"RU"}}, // Q110147378
    {Coordinate{57.2779, 54.4617}, CountryId{"RU"}}, // Q110147379
    {Coordinate{57.3749, 54.4084}, CountryId{"RU"}}, // Q110147380
    {Coordinate{57.4949, 54.3826}, CountryId{"RU"}}, // Q110147381
    {Coordinate{57.5532, 54.3709}, CountryId{"RU"}}, // Q110147382
    {Coordinate{57.5907, 54.3043}, CountryId{"RU"}}, // Q110147383
    {Coordinate{57.5929, 54.2712}, CountryId{"RU"}}, // Q110147384
    {Coordinate{57.5845, 54.2235}, CountryId{"RU"}}, // Q110147385
    {Coordinate{57.6217, 54.181}, CountryId{"RU"}}, // Q110147386
    {Coordinate{57.6957, 54.1257}, CountryId{"RU"}}, // Q110147387
    {Coordinate{57.7485, 54.0687}, CountryId{"RU"}}, // Q110147389
    {Coordinate{57.7776, 54.0258}, CountryId{"RU"}}, // Q110147390
    {Coordinate{57.8684, 53.9558}, CountryId{"RU"}}, // Q110147391
    {Coordinate{55.9129, 53.314}, CountryId{"RU"}}, // Q110152573
    {Coordinate{132.395, 43.1544}, CountryId{"RU"}}, // Petrovka
    {Coordinate{55.9225, 53.449}, CountryId{"RU"}}, // Q110155574
    {Coordinate{55.9093, 53.2442}, CountryId{"RU"}}, // Q110155575
    {Coordinate{55.9081, 53.2195}, CountryId{"RU"}}, // Q110155576
    {Coordinate{55.9293, 53.001}, CountryId{"RU"}}, // Q110155579
    {Coordinate{55.8996, 52.9223}, CountryId{"RU"}}, // Q110155580
    {Coordinate{55.7669, 52.8385}, CountryId{"RU"}}, // Q110155581
    {Coordinate{55.9056, 53.1698}, CountryId{"RU"}}, // Q110155596
    {Coordinate{35.3884, 57.1684}, CountryId{"RU"}}, // Lokotsy (station)
    {Coordinate{35.3346, 57.2033}, CountryId{"RU"}}, // Baranovka (station)
    {Coordinate{35.2759, 57.2413}, CountryId{"RU"}}, // Mutashelikha (station)
    {Coordinate{132.343, 42.8761}, CountryId{"RU"}}, // Dunay
    {Coordinate{132.332, 42.9293}, CountryId{"RU"}}, // Yuzhnorechensk
    {Coordinate{8.16246, 51.5872}, CountryId{"DE"}}, // Bad Sassendorf station
    {Coordinate{132.335, 43.0022}, CountryId{"RU"}}, // Strelkovaya
    {Coordinate{35.1606, 57.3155}, CountryId{"RU"}}, // Bukhalovsky Pereezd railway station
    {Coordinate{35.103, 57.3527}, CountryId{"RU"}}, // Levoshinka railway station
    {Coordinate{7.99147, 47.9586}, CountryId{"DE"}}, // Himmelreich
    {Coordinate{34.915, 57.4723}, CountryId{"RU"}}, // Lubinka station
    {Coordinate{34.8337, 57.5243}, CountryId{"RU"}}, // Industriya station
    {Coordinate{10.8756, 49.5063}, CountryId{"DE"}}, // Siegelsdorf
    {Coordinate{10.9569, 49.475}, CountryId{"DE"}}, // Fürth-Unterfürberg
    {Coordinate{12.7271, 47.9315}, CountryId{"DE"}}, // Waging
    {Coordinate{34.7307, 57.5651}, CountryId{"RU"}}, // Terelesovskaya station
    {Coordinate{34.6606, 57.5793}, CountryId{"RU"}}, // Yelizarovka station
    {Coordinate{34.497, 57.6197}, CountryId{"RU"}}, // Q110189657
    {Coordinate{34.4544, 57.6478}, CountryId{"RU"}}, // Q110189658
    {Coordinate{34.3956, 57.6866}, CountryId{"RU"}}, // Q110189659
    {Coordinate{34.3445, 57.7174}, CountryId{"RU"}}, // Q110189660
    {Coordinate{34.3142, 57.7355}, CountryId{"RU"}}, // Q110189661
    {Coordinate{34.2912, 57.7638}, CountryId{"RU"}}, // Q110189662
    {Coordinate{34.2328, 57.8054}, CountryId{"RU"}}, // Q110189663
    {Coordinate{34.2027, 57.8234}, CountryId{"RU"}}, // Q110189664
    {Coordinate{34.1519, 57.8539}, CountryId{"RU"}}, // Q110189665
    {Coordinate{8.03179, 51.5983}, CountryId{"DE"}}, // Borgeln station
    {Coordinate{33.9532, 57.9551}, CountryId{"RU"}}, // Q110200975
    {Coordinate{33.8521, 58.0197}, CountryId{"RU"}}, // Q110200976
    {Coordinate{33.756, 58.0771}, CountryId{"RU"}}, // Q110200977
    {Coordinate{33.6691, 58.1282}, CountryId{"RU"}}, // Q110200979
    {Coordinate{33.6225, 58.1514}, CountryId{"RU"}}, // Q110200981
    {Coordinate{33.5916, 58.1716}, CountryId{"RU"}}, // Q110200982
    {Coordinate{33.5517, 58.2014}, CountryId{"RU"}}, // Q110200984
    {Coordinate{33.4238, 58.2947}, CountryId{"RU"}}, // Q110200989
    {Coordinate{33.3769, 58.3267}, CountryId{"RU"}}, // Q110200990
    {Coordinate{33.7303, 58.3224}, CountryId{"RU"}}, // Q110200991
    {Coordinate{61.4655, 55.1516}, CountryId{"RU"}}, // Q110209414
    {Coordinate{11.0655, 50.2229}, CountryId{"DE"}}, // Ebersdorf (b Coburg) station
    {Coordinate{11.0256, 50.2275}, CountryId{"DE"}}, // Grub am Forst railway stop
    {Coordinate{10.9944, 50.1084}, CountryId{"DE"}}, // Bad Staffelstein station
    {Coordinate{11.1161, 50.155}, CountryId{"DE"}}, // Michelau (Oberfr) railway stop
    {Coordinate{32.8806, 58.582}, CountryId{"RU"}}, // Q110213408
    {Coordinate{33.1698, 58.4317}, CountryId{"RU"}}, // Q110218588
    {Coordinate{32.9703, 58.5385}, CountryId{"RU"}}, // Q110218591
    {Coordinate{32.8162, 58.6108}, CountryId{"RU"}}, // Q110218596
    {Coordinate{32.5919, 58.6858}, CountryId{"RU"}}, // Q110218602
    {Coordinate{32.3697, 58.7743}, CountryId{"RU"}}, // Q110218606
    {Coordinate{35.0782, 57.0669}, CountryId{"RU"}}, // Kolodezi railway station
    {Coordinate{35.2004, 57.0819}, CountryId{"RU"}}, // Tereshkino (station)
    {Coordinate{35.3218, 57.0868}, CountryId{"RU"}}, // Lazari (station)
    {Coordinate{35.4163, 57.1253}, CountryId{"RU"}}, // Vinokoly
    {Coordinate{11.6758, 51.0087}, CountryId{"DE"}}, // Dornburg (Saale) station
    {Coordinate{11.5797, 51.0645}, CountryId{"DE"}}, // Niedertrebra station
    {Coordinate{11.2211, 50.9843}, CountryId{"DE"}}, // Hopfgarten (Kr Weimar) station
    {Coordinate{11.1387, 50.9928}, CountryId{"DE"}}, // Vieselbach station
    {Coordinate{12.4261, 51.0835}, CountryId{"DE"}}, // Regis-Breitingen station
    {Coordinate{8.0651, 51.1229}, CountryId{"DE"}}, // Lennestadt-Meggen station
    {Coordinate{7.79043, 48.2741}, CountryId{"DE"}}, // Orschweier station
    {Coordinate{10.2364, 48.5325}, CountryId{"DE"}}, // Niederstotzingen train station
    {Coordinate{10.2848, 48.5593}, CountryId{"DE"}}, // Sontheim-Brenz train station
    {Coordinate{10.2729, 48.5761}, CountryId{"DE"}}, // Bergenweiler railway stop
    {Coordinate{10.2582, 48.5947}, CountryId{"DE"}}, // Hermaringen train station
    {Coordinate{10.1701, 48.6257}, CountryId{"DE"}}, // Herbrechtingen train station
    {Coordinate{10.1609, 48.6532}, CountryId{"DE"}}, // Heidenheim-Mergelstetten train station
    {Coordinate{10.156, 48.6695}, CountryId{"DE"}}, // Heidenheim Voithwerk railway stop
    {Coordinate{10.1588, 48.7083}, CountryId{"DE"}}, // Heidenheim-Schnaitheim train station
    {Coordinate{10.1363, 48.7307}, CountryId{"DE"}}, // Itzelberg railway stop
    {Coordinate{10.1265, 48.815}, CountryId{"DE"}}, // Unterkochen train station
    {Coordinate{38.1508, 51.7886}, CountryId{"RU"}}, // Q110243407
    {Coordinate{38.165, 51.7773}, CountryId{"RU"}}, // Q110243408
    {Coordinate{38.1818, 51.7262}, CountryId{"RU"}}, // Q110243409
    {Coordinate{38.3745, 51.6845}, CountryId{"RU"}}, // Q110243410
    {Coordinate{38.414, 51.6812}, CountryId{"RU"}}, // Q110243411
    {Coordinate{38.4416, 51.6669}, CountryId{"RU"}}, // Q110243412
    {Coordinate{38.4724, 51.649}, CountryId{"RU"}}, // Q110243413
    {Coordinate{38.5554, 51.6527}, CountryId{"RU"}}, // Q110243414
    {Coordinate{38.5839, 51.6467}, CountryId{"RU"}}, // Q110243415
    {Coordinate{38.6075, 51.6503}, CountryId{"RU"}}, // Q110243416
    {Coordinate{38.6948, 51.6599}, CountryId{"RU"}}, // Q110243417
    {Coordinate{38.7279, 51.6744}, CountryId{"RU"}}, // Q110243418
    {Coordinate{38.7564, 51.669}, CountryId{"RU"}}, // Q110243419
    {Coordinate{38.8132, 51.6514}, CountryId{"RU"}}, // Q110243420
    {Coordinate{38.9541, 51.6843}, CountryId{"RU"}}, // Q110243421
    {Coordinate{39.0342, 51.6814}, CountryId{"RU"}}, // Q110243422
    {Coordinate{39.0598, 51.6854}, CountryId{"RU"}}, // Q110243423
    {Coordinate{39.0856, 51.667}, CountryId{"RU"}}, // Q110243424
    {Coordinate{39.116, 51.6627}, CountryId{"RU"}}, // Q110243425
    {Coordinate{39.1865, 51.6768}, CountryId{"RU"}}, // Q110243426
    {Coordinate{39.2335, 51.6997}, CountryId{"RU"}}, // Q110243427
    {Coordinate{38.1168, 51.7663}, CountryId{"RU"}}, // Q110245436
    {Coordinate{38.1079, 51.7067}, CountryId{"RU"}}, // Q110245437
    {Coordinate{38.1292, 51.6728}, CountryId{"RU"}}, // Q110245438
    {Coordinate{38.1341, 51.6368}, CountryId{"RU"}}, // Q110245439
    {Coordinate{38.1122, 51.5946}, CountryId{"RU"}}, // Q110245440
    {Coordinate{38.0748, 51.5758}, CountryId{"RU"}}, // Q110245441
    {Coordinate{38.0167, 51.4691}, CountryId{"RU"}}, // Q110245442
    {Coordinate{37.9652, 51.4389}, CountryId{"RU"}}, // Q110245443
    {Coordinate{37.9281, 51.4281}, CountryId{"RU"}}, // Q110245444
    {Coordinate{37.9044, 51.4021}, CountryId{"RU"}}, // Q110245445
    {Coordinate{37.8745, 51.3841}, CountryId{"RU"}}, // Q110245446
    {Coordinate{37.8655, 51.3601}, CountryId{"RU"}}, // Q110245447
    {Coordinate{36.8642, 51.3331}, CountryId{"RU"}}, // Q110247778
    {Coordinate{36.9402, 51.3338}, CountryId{"RU"}}, // Q110247779
    {Coordinate{37.0716, 51.3437}, CountryId{"RU"}}, // Q110247780
    {Coordinate{37.1009, 51.3436}, CountryId{"RU"}}, // Q110247781
    {Coordinate{37.3094, 51.3089}, CountryId{"RU"}}, // Q110247782
    {Coordinate{37.5447, 51.2751}, CountryId{"RU"}}, // Q110247783
    {Coordinate{37.5739, 51.2794}, CountryId{"RU"}}, // Q110247784
    {Coordinate{36.8243, 51.3322}, CountryId{"RU"}}, // Q110247795
    {Coordinate{34.4463, 61.3208}, CountryId{"RU"}}, // 342 km
    {Coordinate{36.7246, 51.2729}, CountryId{"RU"}}, // Q110250194
    {Coordinate{36.677, 51.1951}, CountryId{"RU"}}, // Q110250195
    {Coordinate{36.7075, 51.1616}, CountryId{"RU"}}, // Q110250196
    {Coordinate{36.7597, 51.1258}, CountryId{"RU"}}, // Q110250197
    {Coordinate{36.7671, 51.0861}, CountryId{"RU"}}, // Q110250198
    {Coordinate{36.7528, 51.0645}, CountryId{"RU"}}, // Q110250199
    {Coordinate{36.6291, 50.9889}, CountryId{"RU"}}, // Q110250201
    {Coordinate{36.6223, 50.9405}, CountryId{"RU"}}, // Q110250202
    {Coordinate{36.6218, 50.869}, CountryId{"RU"}}, // Q110250203
    {Coordinate{36.6313, 50.8323}, CountryId{"RU"}}, // Q110250204
    {Coordinate{36.6575, 50.8028}, CountryId{"RU"}}, // Q110250205
    {Coordinate{36.6577, 50.7766}, CountryId{"RU"}}, // Q110250207
    {Coordinate{36.6403, 50.7615}, CountryId{"RU"}}, // Q110250208
    {Coordinate{36.6229, 50.7528}, CountryId{"RU"}}, // Q110250210
    {Coordinate{36.6158, 50.7286}, CountryId{"RU"}}, // Q110250211
    {Coordinate{36.6228, 50.7069}, CountryId{"RU"}}, // Q110250212
    {Coordinate{36.6295, 50.6774}, CountryId{"RU"}}, // Q110250213
    {Coordinate{36.6332, 50.6529}, CountryId{"RU"}}, // Q110250214
    {Coordinate{36.6297, 50.6346}, CountryId{"RU"}}, // Q110250215
    {Coordinate{36.6193, 50.6146}, CountryId{"RU"}}, // Q110250216
    {Coordinate{34.4434, 61.2682}, CountryId{"RU"}}, // Tarzhepol
    {Coordinate{36.3183, 50.4014}, CountryId{"RU"}}, // Q110252624
    {Coordinate{36.5854, 50.586}, CountryId{"RU"}}, // Q110252714
    {Coordinate{36.5412, 50.5761}, CountryId{"RU"}}, // Q110252715
    {Coordinate{36.5194, 50.5677}, CountryId{"RU"}}, // Q110252716
    {Coordinate{36.4021, 50.5159}, CountryId{"RU"}}, // Q110252717
    {Coordinate{36.3913, 50.4976}, CountryId{"RU"}}, // Q110252718
    {Coordinate{36.3422, 50.4266}, CountryId{"RU"}}, // Q110252720
    {Coordinate{36.3582, 50.4487}, CountryId{"RU"}}, // Q110252722
    {Coordinate{34.4471, 61.2036}, CountryId{"RU"}}, // Pay
    {Coordinate{12.4416, 50.6785}, CountryId{"DE"}}, // Stenn railway stop
    {Coordinate{12.4202, 50.6994}, CountryId{"DE"}}, // Lichtentanne (Sachs) railway station
    {Coordinate{12.3941, 50.709}, CountryId{"DE"}}, // Steinpleis railway stop
    {Coordinate{-3.52259, 50.731}, CountryId{"GB"}}, // St James Park railway station
    {Coordinate{31.1056, 69.3997}, CountryId{"RU"}}, // Loustary
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q110259500
    {Coordinate{42.2781, 51.1392}, CountryId{"RU"}}, // Q110259501
    {Coordinate{63.745, 57.0622}, CountryId{"RU"}}, // Q110259514
    {Coordinate{28.8956, 56.327}, CountryId{"RU"}}, // Idritsa
    {Coordinate{28.7345, 56.3505}, CountryId{"RU"}}, // Zavaruyka
    {Coordinate{29.0695, 56.3188}, CountryId{"RU"}}, // Nashchyokino
    {Coordinate{28.357, 56.3308}, CountryId{"RU"}}, // Garneya
    {Coordinate{59.4414, 57.0217}, CountryId{"RU"}}, // Q110259526
    {Coordinate{59.1445, 58.4468}, CountryId{"RU"}}, // Q110259531
    {Coordinate{59.0674, 58.5292}, CountryId{"RU"}}, // Q110259532
    {Coordinate{59.5289, 58.3532}, CountryId{"RU"}}, // Q110259533
    {Coordinate{59.7209, 58.1837}, CountryId{"RU"}}, // Baranchinskaya
    {Coordinate{59.8623, 58.0513}, CountryId{"RU"}}, // Q110259535
    {Coordinate{60.2002, 57.4142}, CountryId{"RU"}}, // Shurala
    {Coordinate{60.2222, 57.0385}, CountryId{"RU"}}, // Ayat
    {Coordinate{32.9649, 66.2662}, CountryId{"RU"}}, // Chupa
    {Coordinate{39.4944, 59.2453}, CountryId{"RU"}}, // Q110259545
    {Coordinate{60.4818, 56.9204}, CountryId{"RU"}}, // Shuvakish
    {Coordinate{38.9415, 46.0869}, CountryId{"RU"}}, // Q110259554
    {Coordinate{35.08, 59.1356}, CountryId{"RU"}}, // Q110259557
    {Coordinate{40.2133, 58.5423}, CountryId{"RU"}}, // Q110259558
    {Coordinate{40.151, 59.1162}, CountryId{"RU"}}, // Q110259560
    {Coordinate{48.5358, 50.1338}, CountryId{"RU"}}, // Q110259567
    {Coordinate{33.2587, 67.8524}, CountryId{"RU"}}, // Imandra
    {Coordinate{92.2222, 56.1006}, CountryId{"RU"}}, // Kacha railway station
    {Coordinate{44.4039, 64.0417}, CountryId{"RU"}}, // Q110259578
    {Coordinate{93.1139, 56.02}, CountryId{"RU"}}, // Q110259583
    {Coordinate{60.759, 58.0877}, CountryId{"RU"}}, // Nizhnyaya Salda
    {Coordinate{59.8557, 58.3576}, CountryId{"RU"}}, // Q110259587
    {Coordinate{59.7228, 58.2837}, CountryId{"RU"}}, // Kushva
    {Coordinate{59.9729, 58.5795}, CountryId{"RU"}}, // Q110259592
    {Coordinate{60.1887, 58.6433}, CountryId{"RU"}}, // Q110259593
    {Coordinate{36.5754, 50.588}, CountryId{"RU"}}, // Q110259970
    {Coordinate{36.5388, 50.6016}, CountryId{"RU"}}, // Q110259973
    {Coordinate{36.5015, 50.6179}, CountryId{"RU"}}, // Q110259974
    {Coordinate{36.4717, 50.628}, CountryId{"RU"}}, // Q110259975
    {Coordinate{36.447, 50.6274}, CountryId{"RU"}}, // Q110259976
    {Coordinate{36.417, 50.6232}, CountryId{"RU"}}, // Q110259977
    {Coordinate{36.3709, 50.6196}, CountryId{"RU"}}, // Q110259978
    {Coordinate{36.3267, 50.6254}, CountryId{"RU"}}, // Q110259981
    {Coordinate{36.2382, 50.6716}, CountryId{"RU"}}, // Q110259984
    {Coordinate{36.1744, 50.6973}, CountryId{"RU"}}, // Q110259985
    {Coordinate{36.0728, 50.7513}, CountryId{"RU"}}, // Q110259986
    {Coordinate{36.0176, 50.7517}, CountryId{"RU"}}, // Q110259987
    {Coordinate{35.9023, 50.7889}, CountryId{"RU"}}, // Q110259988
    {Coordinate{36.852, 50.3722}, CountryId{"RU"}}, // Q110260118
    {Coordinate{36.6402, 50.5935}, CountryId{"RU"}}, // Q110260376
    {Coordinate{36.6517, 50.5808}, CountryId{"RU"}}, // Q110260377
    {Coordinate{36.6554, 50.566}, CountryId{"RU"}}, // Q110260378
    {Coordinate{36.6619, 50.5399}, CountryId{"RU"}}, // Q110260379
    {Coordinate{36.6813, 50.5177}, CountryId{"RU"}}, // Q110260380
    {Coordinate{36.7024, 50.4974}, CountryId{"RU"}}, // Q110260381
    {Coordinate{36.7405, 50.4623}, CountryId{"RU"}}, // Q110260382
    {Coordinate{36.7612, 50.4423}, CountryId{"RU"}}, // Q110260383
    {Coordinate{36.7957, 50.4068}, CountryId{"RU"}}, // Q110260384
    {Coordinate{36.8306, 50.3889}, CountryId{"RU"}}, // Q110260385
    {Coordinate{39.4677, 52.6236}, CountryId{"RU"}}, // Q110263348
    {Coordinate{34.9437, 56.9011}, CountryId{"RU"}}, // L'nyanaya
    {Coordinate{34.9539, 56.8247}, CountryId{"RU"}}, // Pozhitovo
    {Coordinate{34.838, 56.6349}, CountryId{"RU"}}, // 83 km
    {Coordinate{39.2766, 53.7446}, CountryId{"RU"}}, // Q110265040
    {Coordinate{39.3059, 53.7116}, CountryId{"RU"}}, // Q110265041
    {Coordinate{39.3701, 53.6213}, CountryId{"RU"}}, // Q110265042
    {Coordinate{39.4415, 53.5742}, CountryId{"RU"}}, // Q110265043
    {Coordinate{39.5272, 53.5333}, CountryId{"RU"}}, // Q110265046
    {Coordinate{39.5894, 53.5094}, CountryId{"RU"}}, // Q110265047
    {Coordinate{39.667, 53.4528}, CountryId{"RU"}}, // Q110265048
    {Coordinate{40.0348, 53.2527}, CountryId{"RU"}}, // Q110265168
    {Coordinate{12.4756, 50.7636}, CountryId{"DE"}}, // Oberrothenbach station
    {Coordinate{12.4167, 50.8581}, CountryId{"DE"}}, // Ponitz station
    {Coordinate{12.3696, 50.7872}, CountryId{"DE"}}, // Schweinsburg-Culten station
    {Coordinate{12.4409, 51.0469}, CountryId{"DE"}}, // Treben-Lehma station
    {Coordinate{40.146, 53.641}, CountryId{"RU"}}, // Q110268288
    {Coordinate{40.1745, 53.5825}, CountryId{"RU"}}, // Q110268289
    {Coordinate{40.1945, 53.5403}, CountryId{"RU"}}, // Q110268290
    {Coordinate{40.2127, 53.4757}, CountryId{"RU"}}, // Q110268291
    {Coordinate{40.2268, 53.4385}, CountryId{"RU"}}, // Q110268292
    {Coordinate{40.2433, 53.3925}, CountryId{"RU"}}, // Q110268293
    {Coordinate{40.2498, 53.3722}, CountryId{"RU"}}, // Q110268294
    {Coordinate{40.2561, 53.3524}, CountryId{"RU"}}, // Q110268295
    {Coordinate{40.2757, 53.291}, CountryId{"RU"}}, // Q110268296
    {Coordinate{12.062, 50.7856}, CountryId{"DE"}}, // Weida station
    {Coordinate{11.872, 50.7406}, CountryId{"DE"}}, // Triptis station
    {Coordinate{11.7576, 50.7348}, CountryId{"DE"}}, // Neustadt an der Orla station
    {Coordinate{40.3185, 53.1963}, CountryId{"RU"}}, // Q110268396
    {Coordinate{-0.377125, 39.467}, CountryId{"ES"}}, // Estació del Nord, Valencia
    {Coordinate{40.3369, 53.1589}, CountryId{"RU"}}, // Q110268534
    {Coordinate{40.3478, 53.1367}, CountryId{"RU"}}, // Q110268535
    {Coordinate{40.3612, 53.112}, CountryId{"RU"}}, // Q110268536
    {Coordinate{40.3839, 53.0727}, CountryId{"RU"}}, // Q110268537
    {Coordinate{40.394, 53.0562}, CountryId{"RU"}}, // Q110268538
    {Coordinate{40.4145, 53.0436}, CountryId{"RU"}}, // Q110268539
    {Coordinate{40.4336, 53.0332}, CountryId{"RU"}}, // Q110268540
    {Coordinate{40.451, 53.021}, CountryId{"RU"}}, // Q110268541
    {Coordinate{40.4819, 52.9908}, CountryId{"RU"}}, // Q110268542
    {Coordinate{40.4825, 52.9805}, CountryId{"RU"}}, // Q110268543
    {Coordinate{40.4822, 52.9672}, CountryId{"RU"}}, // Q110268544
    {Coordinate{40.4817, 52.9489}, CountryId{"RU"}}, // Q110268725
    {Coordinate{40.4813, 52.9313}, CountryId{"RU"}}, // Q110268726
    {Coordinate{40.4811, 52.9207}, CountryId{"RU"}}, // Q110268728
    {Coordinate{40.4821, 52.9085}, CountryId{"RU"}}, // Q110268729
    {Coordinate{40.4644, 52.9067}, CountryId{"RU"}}, // Q110268963
    {Coordinate{40.4139, 52.8765}, CountryId{"RU"}}, // Q110268964
    {Coordinate{40.4065, 52.8566}, CountryId{"RU"}}, // Q110268966
    {Coordinate{40.4103, 52.8401}, CountryId{"RU"}}, // Q110268967
    {Coordinate{40.3781, 52.7697}, CountryId{"RU"}}, // Q110268968
    {Coordinate{40.3567, 52.7397}, CountryId{"RU"}}, // Q110268969
    {Coordinate{40.3213, 52.7028}, CountryId{"RU"}}, // Q110268970
    {Coordinate{40.2826, 52.6641}, CountryId{"RU"}}, // Q110268971
    {Coordinate{40.216, 52.6144}, CountryId{"RU"}}, // Q110268972
    {Coordinate{40.1759, 52.5958}, CountryId{"RU"}}, // Q110268973
    {Coordinate{40.064, 52.5444}, CountryId{"RU"}}, // Q110268974
    {Coordinate{40.0302, 52.5289}, CountryId{"RU"}}, // Q110268975
    {Coordinate{40.52, 52.9152}, CountryId{"RU"}}, // Q110270577
    {Coordinate{40.6426, 52.9147}, CountryId{"RU"}}, // Q110270578
    {Coordinate{41.1684, 52.8186}, CountryId{"RU"}}, // Q110270579
    {Coordinate{41.2321, 52.7946}, CountryId{"RU"}}, // Q110270580
    {Coordinate{41.3033, 52.7722}, CountryId{"RU"}}, // Q110270581
    {Coordinate{39.913, 52.4711}, CountryId{"RU"}}, // Q110271351
    {Coordinate{39.7983, 52.3613}, CountryId{"RU"}}, // Q110271353
    {Coordinate{39.7873, 52.3304}, CountryId{"RU"}}, // Q110271354
    {Coordinate{39.7845, 52.2314}, CountryId{"RU"}}, // Q110271355
    {Coordinate{39.7689, 52.1809}, CountryId{"RU"}}, // Q110271356
    {Coordinate{39.7013, 52.0416}, CountryId{"RU"}}, // Q110271358
    {Coordinate{39.6782, 51.9658}, CountryId{"RU"}}, // Q110271360
    {Coordinate{39.5731, 51.8128}, CountryId{"RU"}}, // Q110271361
    {Coordinate{39.5599, 51.7905}, CountryId{"RU"}}, // Q110271362
    {Coordinate{39.5224, 51.7634}, CountryId{"RU"}}, // Q110271363
    {Coordinate{39.4864, 51.756}, CountryId{"RU"}}, // Q110271364
    {Coordinate{39.4233, 51.757}, CountryId{"RU"}}, // Q110271365
    {Coordinate{39.373, 51.7444}, CountryId{"RU"}}, // Q110271366
    {Coordinate{39.3487, 51.7368}, CountryId{"RU"}}, // Q110271367
    {Coordinate{39.3154, 51.7357}, CountryId{"RU"}}, // Q110271368
    {Coordinate{39.8724, 52.4352}, CountryId{"RU"}}, // Q110271378
    {Coordinate{39.7434, 52.1082}, CountryId{"RU"}}, // Q110271379
    {Coordinate{39.6956, 52.0229}, CountryId{"RU"}}, // Q110271380
    {Coordinate{39.3724, 51.9072}, CountryId{"RU"}}, // Q110271622
    {Coordinate{39.5692, 51.8951}, CountryId{"RU"}}, // Q110271693
    {Coordinate{39.4799, 51.9034}, CountryId{"RU"}}, // Q110271694
    {Coordinate{39.4567, 51.9061}, CountryId{"RU"}}, // Q110271695
    {Coordinate{39.4062, 51.9092}, CountryId{"RU"}}, // Q110271696
    {Coordinate{39.277, 51.7016}, CountryId{"RU"}}, // Q110272080
    {Coordinate{39.2698, 51.6686}, CountryId{"RU"}}, // Q110272081
    {Coordinate{39.2508, 51.5976}, CountryId{"RU"}}, // Q110272082
    {Coordinate{39.2461, 51.5612}, CountryId{"RU"}}, // Q110272083
    {Coordinate{39.2438, 51.5422}, CountryId{"RU"}}, // Q110272084
    {Coordinate{39.2408, 51.5055}, CountryId{"RU"}}, // Q110272085
    {Coordinate{39.241, 51.4809}, CountryId{"RU"}}, // Q110272087
    {Coordinate{39.2334, 51.4506}, CountryId{"RU"}}, // Q110272088
    {Coordinate{39.2368, 51.426}, CountryId{"RU"}}, // Q110272090
    {Coordinate{39.2639, 51.3926}, CountryId{"RU"}}, // Q110272091
    {Coordinate{39.3174, 51.3274}, CountryId{"RU"}}, // Q110272092
    {Coordinate{39.3366, 51.2825}, CountryId{"RU"}}, // Q110272093
    {Coordinate{39.3522, 51.2462}, CountryId{"RU"}}, // Q110272094
    {Coordinate{39.422, 51.1565}, CountryId{"RU"}}, // Q110272095
    {Coordinate{39.4864, 51.0575}, CountryId{"RU"}}, // Q110272096
    {Coordinate{39.5066, 51.0203}, CountryId{"RU"}}, // Q110272097
    {Coordinate{39.5091, 50.9921}, CountryId{"RU"}}, // Q110272098
    {Coordinate{15.6117, 48.0399}, CountryId{"AT"}}, // Traisen Markt railway station
    {Coordinate{12.2931, 50.2597}, CountryId{"DE"}}, // Raun railway stop
    {Coordinate{12.2827, 50.2752}, CountryId{"DE"}}, // Sohl railway stop
    {Coordinate{12.0761, 50.4276}, CountryId{"DE"}}, // Pirk railway stop
    {Coordinate{12.0921, 50.4801}, CountryId{"DE"}}, // Plauen (Vogtl)-Straßberg railway stop
    {Coordinate{12.0854, 50.5446}, CountryId{"DE"}}, // Syrau railway stop
    {Coordinate{12.17, 50.5552}, CountryId{"DE"}}, // Jocketa railway stop
    {Coordinate{12.2532, 50.587}, CountryId{"DE"}}, // Limbach (Vogtl) railway stop
    {Coordinate{12.3793, 50.507}, CountryId{"DE"}}, // Auerbach(Vogtl) Hp
    {Coordinate{12.3846, 50.4881}, CountryId{"DE"}}, // Ellefeld railway stop
    {Coordinate{12.1599, 50.6051}, CountryId{"DE"}}, // Elsterberg Kunstseidenwerk railway stop
    {Coordinate{12.1589, 50.7473}, CountryId{"DE"}}, // Berga (Elster) station
    {Coordinate{40.5854, 52.1118}, CountryId{"RU"}}, // Q110280003
    {Coordinate{41.5811, 51.6843}, CountryId{"RU"}}, // Q110280007
    {Coordinate{41.6455, 51.6076}, CountryId{"RU"}}, // Q110280009
    {Coordinate{41.7885, 51.5836}, CountryId{"RU"}}, // Q110280010
    {Coordinate{41.8061, 51.5695}, CountryId{"RU"}}, // Q110280011
    {Coordinate{41.9288, 51.4483}, CountryId{"RU"}}, // Q110280012
    {Coordinate{42.0403, 51.3544}, CountryId{"RU"}}, // Q110280013
    {Coordinate{42.0915, 51.3569}, CountryId{"RU"}}, // Q110280014
    {Coordinate{42.1244, 51.3585}, CountryId{"RU"}}, // Q110280015
    {Coordinate{42.1991, 51.3528}, CountryId{"RU"}}, // Q110280017
    {Coordinate{42.2281, 51.3317}, CountryId{"RU"}}, // Q110280018
    {Coordinate{42.2389, 51.2686}, CountryId{"RU"}}, // Q110280019
    {Coordinate{42.2384, 51.2415}, CountryId{"RU"}}, // Q110280020
    {Coordinate{42.2458, 51.2246}, CountryId{"RU"}}, // Q110280022
    {Coordinate{10.689, 53.8305}, CountryId{"DE"}}, // Q110281823
    {Coordinate{34.6909, 56.4867}, CountryId{"RU"}}, // Zarubino
    {Coordinate{34.5671, 56.4191}, CountryId{"RU"}}, // Panino
    {Coordinate{12.3953, 50.5287}, CountryId{"DE"}}, // Rodewisch railway stop
    {Coordinate{19.0911, 47.4903}, CountryId{"HU"}}, // Józsefváros railway station
    {Coordinate{41.7634, 51.0792}, CountryId{"RU"}}, // Q110288688
    {Coordinate{42.2111, 51.2021}, CountryId{"RU"}}, // Q110289794
    {Coordinate{42.1766, 51.1923}, CountryId{"RU"}}, // Q110289795
    {Coordinate{42.0681, 51.1631}, CountryId{"RU"}}, // Q110289796
    {Coordinate{41.6862, 51.0606}, CountryId{"RU"}}, // Q110289798
    {Coordinate{41.6642, 51.0616}, CountryId{"RU"}}, // Q110289799
    {Coordinate{41.631, 51.0613}, CountryId{"RU"}}, // Q110289801
    {Coordinate{41.4751, 51.1379}, CountryId{"RU"}}, // Q110289802
    {Coordinate{41.3797, 51.1312}, CountryId{"RU"}}, // Q110289803
    {Coordinate{41.3329, 51.129}, CountryId{"RU"}}, // Q110289804
    {Coordinate{41.2672, 51.1497}, CountryId{"RU"}}, // Q110289805
    {Coordinate{41.2311, 51.1598}, CountryId{"RU"}}, // Q110289806
    {Coordinate{41.1673, 51.1722}, CountryId{"RU"}}, // Q110289807
    {Coordinate{41.1157, 51.1843}, CountryId{"RU"}}, // Q110289808
    {Coordinate{41.069, 51.1748}, CountryId{"RU"}}, // Q110289809
    {Coordinate{41.0133, 51.1845}, CountryId{"RU"}}, // Q110289810
    {Coordinate{40.9317, 51.1747}, CountryId{"RU"}}, // Q110289811
    {Coordinate{40.8861, 51.1622}, CountryId{"RU"}}, // Q110289812
    {Coordinate{40.68, 51.1129}, CountryId{"RU"}}, // Q110289813
    {Coordinate{40.6083, 51.1092}, CountryId{"RU"}}, // Q110289814
    {Coordinate{40.5662, 51.1086}, CountryId{"RU"}}, // Q110289815
    {Coordinate{40.5357, 51.1094}, CountryId{"RU"}}, // Q110289817
    {Coordinate{40.4812, 51.1149}, CountryId{"RU"}}, // Q110289818
    {Coordinate{40.4445, 51.1209}, CountryId{"RU"}}, // Q110289819
    {Coordinate{40.3795, 51.1184}, CountryId{"RU"}}, // Q110289820
    {Coordinate{40.2619, 51.1179}, CountryId{"RU"}}, // Q110289821
    {Coordinate{40.0977, 51.1179}, CountryId{"RU"}}, // Q110289822
    {Coordinate{39.7925, 51.0569}, CountryId{"RU"}}, // Q110289823
    {Coordinate{39.5612, 51.0374}, CountryId{"RU"}}, // Q110289824
    {Coordinate{39.5285, 51.0256}, CountryId{"RU"}}, // Q110289825
    {Coordinate{39.5102, 50.9899}, CountryId{"RU"}}, // Q110289826
    {Coordinate{34.4488, 56.3404}, CountryId{"RU"}}, // Yesipovskaya
    {Coordinate{43.7892, 52.2397}, CountryId{"RU"}}, // Q110295056
    {Coordinate{43.7737, 52.229}, CountryId{"RU"}}, // Q110295057
    {Coordinate{43.756, 52.223}, CountryId{"RU"}}, // Q110295058
    {Coordinate{43.6641, 52.1028}, CountryId{"RU"}}, // Q110295059
    {Coordinate{43.5948, 52.0618}, CountryId{"RU"}}, // Q110295060
    {Coordinate{43.5666, 52.044}, CountryId{"RU"}}, // Q110295061
    {Coordinate{43.5241, 52.0221}, CountryId{"RU"}}, // Q110295062
    {Coordinate{43.5105, 51.9848}, CountryId{"RU"}}, // Q110295063
    {Coordinate{43.4375, 51.9183}, CountryId{"RU"}}, // Q110295064
    {Coordinate{43.4009, 51.9193}, CountryId{"RU"}}, // Q110295065
    {Coordinate{43.2729, 51.8238}, CountryId{"RU"}}, // Q110295066
    {Coordinate{43.2168, 51.7865}, CountryId{"RU"}}, // Q110295067
    {Coordinate{43.1492, 51.7489}, CountryId{"RU"}}, // Q110295068
    {Coordinate{43.1114, 51.6743}, CountryId{"RU"}}, // Q110295069
    {Coordinate{43.111, 51.6448}, CountryId{"RU"}}, // Q110295070
    {Coordinate{43.1159, 51.5997}, CountryId{"RU"}}, // Q110295071
    {Coordinate{44.9259, 53.1027}, CountryId{"RU"}}, // Q110306215
    {Coordinate{44.8914, 53.0744}, CountryId{"RU"}}, // Q110306216
    {Coordinate{44.8652, 53.0466}, CountryId{"RU"}}, // Q110306217
    {Coordinate{44.8407, 52.9726}, CountryId{"RU"}}, // Q110306218
    {Coordinate{44.8054, 52.9065}, CountryId{"RU"}}, // Q110306219
    {Coordinate{44.7569, 52.8754}, CountryId{"RU"}}, // Q110306220
    {Coordinate{44.7288, 52.8214}, CountryId{"RU"}}, // Q110306221
    {Coordinate{44.6802, 52.7877}, CountryId{"RU"}}, // Q110306222
    {Coordinate{44.6382, 52.7714}, CountryId{"RU"}}, // Q110306223
    {Coordinate{44.6088, 52.7601}, CountryId{"RU"}}, // Q110306224
    {Coordinate{44.5711, 52.7406}, CountryId{"RU"}}, // Q110306225
    {Coordinate{44.4867, 52.6835}, CountryId{"RU"}}, // Q110306226
    {Coordinate{44.4882, 52.6659}, CountryId{"RU"}}, // Q110306227
    {Coordinate{44.371, 52.5587}, CountryId{"RU"}}, // Q110306228
    {Coordinate{44.3195, 52.5117}, CountryId{"RU"}}, // Q110306229
    {Coordinate{44.3043, 52.5016}, CountryId{"RU"}}, // Q110306230
    {Coordinate{44.2785, 52.4845}, CountryId{"RU"}}, // Q110306231
    {Coordinate{44.2486, 52.4739}, CountryId{"RU"}}, // Q110306232
    {Coordinate{44.2102, 52.4884}, CountryId{"RU"}}, // Q110306234
    {Coordinate{44.1732, 52.442}, CountryId{"RU"}}, // Q110306235
    {Coordinate{44.0314, 52.3251}, CountryId{"RU"}}, // Q110306236
    {Coordinate{43.9669, 52.2671}, CountryId{"RU"}}, // Q110306237
    {Coordinate{43.9176, 52.2605}, CountryId{"RU"}}, // Q110306238
    {Coordinate{43.8525, 52.2321}, CountryId{"RU"}}, // Q110306239
    {Coordinate{34.308, 56.1832}, CountryId{"RU"}}, // 147 km
    {Coordinate{34.3149, 56.1461}, CountryId{"RU"}}, // Rozhdestveno
    {Coordinate{35.3702, 56.05}, CountryId{"RU"}}, // 165 km
    {Coordinate{35.3237, 56.0561}, CountryId{"RU"}}, // 167 km
    {Coordinate{44.8164, 51.9801}, CountryId{"RU"}}, // Q110319182
    {Coordinate{28.5486, 56.3146}, CountryId{"RU"}}, // Kuznetsovka
    {Coordinate{28.2484, 56.3418}, CountryId{"RU"}}, // Posin'
    {Coordinate{60.0917, 57.6384}, CountryId{"RU"}}, // Tavolgi
    {Coordinate{59.9266, 58.4731}, CountryId{"RU"}}, // Q110319556
    {Coordinate{12.4432, 50.6514}, CountryId{"DE"}}, // Ebersbrunn railway stop
    {Coordinate{11.7141, 50.7242}, CountryId{"DE"}}, // Neunhofen railway stop
    {Coordinate{11.6507, 50.7059}, CountryId{"DE"}}, // Oppurg station
    {Coordinate{11.5924, 50.7308}, CountryId{"DE"}}, // Langenorla Ost railway stop
    {Coordinate{11.5798, 50.7419}, CountryId{"DE"}}, // Langenorla West railway stop
    {Coordinate{11.5401, 50.7714}, CountryId{"DE"}}, // Freienorla railway stop
    {Coordinate{11.6094, 50.8515}, CountryId{"DE"}}, // Rothenstein (Saale) station
    {Coordinate{12.2411, 51.1659}, CountryId{"DE"}}, // Pegau station
    {Coordinate{12.3094, 51.2781}, CountryId{"DE"}}, // Leipzig-Knauthain station
    {Coordinate{13.2401, 51.2703}, CountryId{"DE"}}, // Seerhausen railway stop
    {Coordinate{13.2119, 51.2429}, CountryId{"DE"}}, // Stauchitz station
    {Coordinate{13.1665, 51.2006}, CountryId{"DE"}}, // Ostrau station
    {Coordinate{13.1567, 51.1688}, CountryId{"DE"}}, // Zschaitz railway stop
    {Coordinate{13.4075, 49.7349}, CountryId{"CZ"}}, // Q110335606
    {Coordinate{13.023, 51.1038}, CountryId{"DE"}}, // Steina station
    {Coordinate{12.943, 51.0089}, CountryId{"DE"}}, // Erlau station
    {Coordinate{12.9597, 50.969}, CountryId{"DE"}}, // Altmittweida railway stop
    {Coordinate{12.953, 50.9347}, CountryId{"DE"}}, // Ottendorf (b Mittweida) station
    {Coordinate{12.9592, 50.9081}, CountryId{"DE"}}, // Oberlichtenau railway stop
    {Coordinate{12.848, 51.1616}, CountryId{"DE"}}, // Tanndorf railway stop
    {Coordinate{12.9382, 51.1602}, CountryId{"DE"}}, // Leisnig railway station
    {Coordinate{13.0039, 51.1577}, CountryId{"DE"}}, // Klosterbuch railway stop
    {Coordinate{13.028, 51.1376}, CountryId{"DE"}}, // Westewitz-Hochweitzschen railway stop
    {Coordinate{-80.0381, 45.3459}, CountryId{"CA"}}, // Parry Sound South
    {Coordinate{11.9544, 50.4759}, CountryId{"DE"}}, // Reuth (bei Plauen/Vogtland) station
    {Coordinate{11.9439, 50.4323}, CountryId{"DE"}}, // Grobau railway stop
    {Coordinate{11.624, 50.4697}, CountryId{"DE"}}, // Unterlemnitz station
    {Coordinate{11.4478, 50.5649}, CountryId{"DE"}}, // Leutenberg station
    {Coordinate{11.434, 50.5974}, CountryId{"DE"}}, // Hockeroda railway stop
    {Coordinate{11.4335, 50.6114}, CountryId{"DE"}}, // Kaulsdorf (Saale) railway stop
    {Coordinate{11.3913, 50.5804}, CountryId{"DE"}}, // Unterloquitz railway stop
    {Coordinate{11.4065, 50.6168}, CountryId{"DE"}}, // Breternitz railway stop
    {Coordinate{11.4348, 50.6592}, CountryId{"DE"}}, // Unterwellenborn station
    {Coordinate{12.0127, 51.0084}, CountryId{"DE"}}, // Wetterzeube station
    {Coordinate{12.0475, 50.9167}, CountryId{"DE"}}, // Gera-Langenberg railway stop
    {Coordinate{35.0679, 56.1083}, CountryId{"RU"}}, // Obovrazhiye
    {Coordinate{24.8142, 59.065}, CountryId{"EE"}}, // Q11039999
    {Coordinate{9.47092, 49.4573}, CountryId{"DE"}}, // Q110401045
    {Coordinate{34.7952, 56.1372}, CountryId{"RU"}}, // Kurkovo
    {Coordinate{34.6644, 56.1493}, CountryId{"RU"}}, // Bartenevo
    {Coordinate{11.1707, 50.6895}, CountryId{"DE"}}, // Rottenbach station
    {Coordinate{11.106, 50.7011}, CountryId{"DE"}}, // Paulinzella railway stop
    {Coordinate{11.0709, 50.767}, CountryId{"DE"}}, // Stadtilm station
    {Coordinate{11.0386, 50.7755}, CountryId{"DE"}}, // Niederwillingen railway stop
    {Coordinate{11.0101, 50.8193}, CountryId{"DE"}}, // Marlishausen railway stop
    {Coordinate{34.4603, 56.1926}, CountryId{"RU"}}, // Aristovo
    {Coordinate{12.4, 50.3511}, CountryId{"DE"}}, // Zwota-Zechenbach railway stop
    {Coordinate{12.4278, 50.3526}, CountryId{"DE"}}, // Zwota railway stop
    {Coordinate{24.7011, 59.3381}, CountryId{"EE"}}, // Q11041241
    {Coordinate{24.6767, 59.2736}, CountryId{"EE"}}, // Kasemetsa railway station
    {Coordinate{14.1612, 51.6063}, CountryId{"DE"}}, // Q110438087
    {Coordinate{9.13711, 49.3169}, CountryId{"DE"}}, // Q110440796
    {Coordinate{10.9135, 47.4102}, CountryId{"AT"}}, // Ehrwald Zugspitzbahn train station
    {Coordinate{25.1444, 58.8341}, CountryId{"EE"}}, // Käru railway station
    {Coordinate{24.6961, 59.2205}, CountryId{"EE"}}, // Q11048360
    {Coordinate{24.744, 59.1705}, CountryId{"EE"}}, // Kohila railway station
    {Coordinate{25.5185, 58.7247}, CountryId{"EE"}}, // Q11049439
    {Coordinate{34.2286, 56.2329}, CountryId{"RU"}}, // Muravyovo
    {Coordinate{34.1137, 56.2242}, CountryId{"RU"}}, // Mohchalovo
    {Coordinate{33.7955, 56.1958}, CountryId{"RU"}}, // Loshaki
    {Coordinate{24.8988, 58.9427}, CountryId{"EE"}}, // Keava railway station
    {Coordinate{37.9055, 51.2246}, CountryId{"RU"}}, // Q110523166
    {Coordinate{37.9095, 51.2068}, CountryId{"RU"}}, // Q110523169
    {Coordinate{37.9109, 51.1835}, CountryId{"RU"}}, // Q110523172
    {Coordinate{37.9086, 51.1521}, CountryId{"RU"}}, // Q110523175
    {Coordinate{37.8986, 51.1141}, CountryId{"RU"}}, // Q110523177
    {Coordinate{37.8881, 51.0684}, CountryId{"RU"}}, // Q110523180
    {Coordinate{37.8733, 51.033}, CountryId{"RU"}}, // Q110523182
    {Coordinate{37.8232, 50.9749}, CountryId{"RU"}}, // Q110523185
    {Coordinate{37.815, 50.9424}, CountryId{"RU"}}, // Q110523186
    {Coordinate{37.8236, 50.8488}, CountryId{"RU"}}, // Q110523187
    {Coordinate{37.8546, 50.8217}, CountryId{"RU"}}, // Q110523188
    {Coordinate{37.87, 50.7608}, CountryId{"RU"}}, // Q110523189
    {Coordinate{37.829, 50.7037}, CountryId{"RU"}}, // Q110523192
    {Coordinate{37.794, 50.6677}, CountryId{"RU"}}, // Q110523193
    {Coordinate{37.81, 50.6424}, CountryId{"RU"}}, // Q110523194
    {Coordinate{37.8081, 50.6173}, CountryId{"RU"}}, // Q110523195
    {Coordinate{37.8043, 50.5645}, CountryId{"RU"}}, // Q110523196
    {Coordinate{37.8173, 50.5447}, CountryId{"RU"}}, // Q110523198
    {Coordinate{37.8247, 50.5095}, CountryId{"RU"}}, // Q110523199
    {Coordinate{37.8535, 50.4915}, CountryId{"RU"}}, // Q110523200
    {Coordinate{37.8451, 50.4243}, CountryId{"RU"}}, // Q110523201
    {Coordinate{37.861, 50.3852}, CountryId{"RU"}}, // Q110523202
    {Coordinate{37.908, 50.3454}, CountryId{"RU"}}, // Q110523204
    {Coordinate{37.9528, 50.3115}, CountryId{"RU"}}, // Q110523205
    {Coordinate{37.9834, 50.2887}, CountryId{"RU"}}, // Q110523207
    {Coordinate{38.0154, 50.2627}, CountryId{"RU"}}, // Q110523208
    {Coordinate{38.0689, 50.2247}, CountryId{"RU"}}, // Q110523209
    {Coordinate{38.0831, 50.2029}, CountryId{"RU"}}, // Q110523210
    {Coordinate{12.7869, 50.5197}, CountryId{"DE"}}, // Erla railway stop
    {Coordinate{33.668, 56.1931}, CountryId{"RU"}}, // Makherovo
    {Coordinate{33.4879, 56.2045}, CountryId{"RU"}}, // Olenino
    {Coordinate{33.2866, 56.2207}, CountryId{"RU"}}, // Ilmanovka
    {Coordinate{38.1135, 50.172}, CountryId{"RU"}}, // Q110529504
    {Coordinate{0.0236111, 45.2206}, CountryId{"FR"}}, // Q110532619
    {Coordinate{7.63381, 48.9524}, CountryId{"FR"}}, // Gare de Niederbronn
    {Coordinate{39.5125, 50.9546}, CountryId{"RU"}}, // Q110539524
    {Coordinate{39.5001, 50.9621}, CountryId{"RU"}}, // Q110539526
    {Coordinate{39.46, 50.9653}, CountryId{"RU"}}, // Q110539527
    {Coordinate{39.425, 50.9685}, CountryId{"RU"}}, // Q110539529
    {Coordinate{39.4063, 50.976}, CountryId{"RU"}}, // Q110539531
    {Coordinate{39.3656, 50.9892}, CountryId{"RU"}}, // Q110539532
    {Coordinate{39.3144, 50.9795}, CountryId{"RU"}}, // Q110539533
    {Coordinate{39.2924, 50.966}, CountryId{"RU"}}, // Q110539535
    {Coordinate{39.2501, 50.9449}, CountryId{"RU"}}, // Q110539536
    {Coordinate{39.2179, 50.9143}, CountryId{"RU"}}, // Q110539537
    {Coordinate{39.1762, 50.8817}, CountryId{"RU"}}, // Q110539538
    {Coordinate{39.1543, 50.8592}, CountryId{"RU"}}, // Q110539540
    {Coordinate{39.1018, 50.8498}, CountryId{"RU"}}, // Q110539541
    {Coordinate{39.0575, 50.8121}, CountryId{"RU"}}, // Q110539542
    {Coordinate{38.9805, 50.7657}, CountryId{"RU"}}, // Q110539544
    {Coordinate{38.9232, 50.7473}, CountryId{"RU"}}, // Q110539545
    {Coordinate{38.8982, 50.7103}, CountryId{"RU"}}, // Q110539546
    {Coordinate{38.8704, 50.6707}, CountryId{"RU"}}, // Q110539548
    {Coordinate{38.8314, 50.6434}, CountryId{"RU"}}, // Q110539549
    {Coordinate{38.6338, 50.6245}, CountryId{"RU"}}, // Q110539550
    {Coordinate{38.5865, 50.63}, CountryId{"RU"}}, // Q110539552
    {Coordinate{38.5557, 50.6078}, CountryId{"RU"}}, // Q110539554
    {Coordinate{38.5353, 50.5605}, CountryId{"RU"}}, // Q110539555
    {Coordinate{38.473, 50.5565}, CountryId{"RU"}}, // Q110539556
    {Coordinate{38.4218, 50.5296}, CountryId{"RU"}}, // Q110539558
    {Coordinate{38.3919, 50.5106}, CountryId{"RU"}}, // Q110539559
    {Coordinate{38.3572, 50.4928}, CountryId{"RU"}}, // Q110539560
    {Coordinate{38.2993, 50.4416}, CountryId{"RU"}}, // Q110539562
    {Coordinate{38.2678, 50.3839}, CountryId{"RU"}}, // Q110539563
    {Coordinate{38.256, 50.3033}, CountryId{"RU"}}, // Q110539565
    {Coordinate{38.2352, 50.2595}, CountryId{"RU"}}, // Q110539566
    {Coordinate{38.2219, 50.2462}, CountryId{"RU"}}, // Q110539568
    {Coordinate{38.1883, 50.2223}, CountryId{"RU"}}, // Q110539569
    {Coordinate{38.1518, 50.2102}, CountryId{"RU"}}, // Q110539570
    {Coordinate{38.1068, 50.1795}, CountryId{"RU"}}, // Q110539572
    {Coordinate{33.1431, 56.2195}, CountryId{"RU"}}, // Mostovaya
    {Coordinate{32.9535, 56.2285}, CountryId{"RU"}}, // Paniklya
    {Coordinate{-0.53357, 44.8772}, CountryId{"FR"}}, // Q110549900
    {Coordinate{32.5828, 56.2299}, CountryId{"RU"}}, // Podsosenka
    {Coordinate{32.3788, 56.2455}, CountryId{"RU"}}, // Zemtsy
    {Coordinate{32.2363, 56.2674}, CountryId{"RU"}}, // Zamoshye
    {Coordinate{32.0738, 56.2624}, CountryId{"RU"}}, // Zapadnaya Dvina station
    {Coordinate{39.9731, 49.6061}, CountryId{"RU"}}, // Q110561171
    {Coordinate{8.06476, 48.345}, CountryId{"DE"}}, // Zell am Harmersbach railway station
    {Coordinate{8.07975, 48.3494}, CountryId{"DE"}}, // Birach station
    {Coordinate{8.08995, 48.3541}, CountryId{"DE"}}, // Unterharmersbach station
    {Coordinate{8.10563, 48.3619}, CountryId{"DE"}}, // Kirnbach-Grün station
    {Coordinate{16.8265, 48.3847}, CountryId{"AT"}}, // Angern an der March railway station
    {Coordinate{31.9477, 56.2847}, CountryId{"RU"}}, // Ulin
    {Coordinate{39.5017, 50.95}, CountryId{"RU"}}, // Q110577158
    {Coordinate{39.4871, 50.9466}, CountryId{"RU"}}, // Q110577159
    {Coordinate{39.445, 50.9474}, CountryId{"RU"}}, // Q110577160
    {Coordinate{39.3915, 50.8814}, CountryId{"RU"}}, // Q110577161
    {Coordinate{39.4181, 50.8551}, CountryId{"RU"}}, // Q110577162
    {Coordinate{39.47, 50.7975}, CountryId{"RU"}}, // Q110577164
    {Coordinate{39.4348, 50.7737}, CountryId{"RU"}}, // Q110577165
    {Coordinate{39.3888, 50.7508}, CountryId{"RU"}}, // Q110577166
    {Coordinate{39.4883, 50.6783}, CountryId{"RU"}}, // Q110577167
    {Coordinate{39.5539, 50.6745}, CountryId{"RU"}}, // Q110577168
    {Coordinate{39.6262, 50.6584}, CountryId{"RU"}}, // Q110577170
    {Coordinate{39.6141, 50.6023}, CountryId{"RU"}}, // Q110577171
    {Coordinate{39.6163, 50.5716}, CountryId{"RU"}}, // Q110577172
    {Coordinate{39.6543, 50.5089}, CountryId{"RU"}}, // Q110577173
    {Coordinate{39.6484, 50.4823}, CountryId{"RU"}}, // Q110577174
    {Coordinate{39.6431, 50.45}, CountryId{"RU"}}, // Q110577175
    {Coordinate{39.6298, 50.3404}, CountryId{"RU"}}, // Q110577176
    {Coordinate{39.6277, 50.3157}, CountryId{"RU"}}, // Q110577177
    {Coordinate{39.6167, 50.2823}, CountryId{"RU"}}, // Q110577178
    {Coordinate{39.5927, 50.2567}, CountryId{"RU"}}, // Q110577179
    {Coordinate{39.5877, 50.2336}, CountryId{"RU"}}, // Q110577180
    {Coordinate{39.5887, 50.2092}, CountryId{"RU"}}, // Q110577181
    {Coordinate{39.6123, 50.152}, CountryId{"RU"}}, // Q110577182
    {Coordinate{39.6176, 50.1362}, CountryId{"RU"}}, // Q110577183
    {Coordinate{39.6208, 50.1193}, CountryId{"RU"}}, // Q110577184
    {Coordinate{39.6274, 50.0997}, CountryId{"RU"}}, // Q110577185
    {Coordinate{39.6249, 50.0841}, CountryId{"RU"}}, // Q110577186
    {Coordinate{39.6627, 50.0536}, CountryId{"RU"}}, // Q110577187
    {Coordinate{39.6924, 49.9849}, CountryId{"RU"}}, // Q110577188
    {Coordinate{39.7232, 49.9285}, CountryId{"RU"}}, // Q110577190
    {Coordinate{39.7399, 49.8973}, CountryId{"RU"}}, // Q110577191
    {Coordinate{39.7301, 49.8617}, CountryId{"RU"}}, // Q110577192
    {Coordinate{39.7735, 49.8046}, CountryId{"RU"}}, // Q110577193
    {Coordinate{39.839, 49.7673}, CountryId{"RU"}}, // Q110577194
    {Coordinate{39.8544, 49.7293}, CountryId{"RU"}}, // Q110577195
    {Coordinate{8.23682, 51.8801}, CountryId{"DE"}}, // Herzebrock station
    {Coordinate{41.5967, 52.7051}, CountryId{"RU"}}, // Q110602368
    {Coordinate{31.7776, 56.2894}, CountryId{"RU"}}, // Barsovo
    {Coordinate{31.6666, 56.2797}, CountryId{"RU"}}, // Staraya Toropa
    {Coordinate{31.5103, 56.2879}, CountryId{"RU"}}, // Rusanovo
    {Coordinate{41.4693, 52.6871}, CountryId{"RU"}}, // Q110623416
    {Coordinate{41.6803, 52.7045}, CountryId{"RU"}}, // Q110623417
    {Coordinate{41.7535, 52.706}, CountryId{"RU"}}, // Q110623418
    {Coordinate{41.855, 52.7083}, CountryId{"RU"}}, // Q110623420
    {Coordinate{42.0068, 52.7197}, CountryId{"RU"}}, // Q110623421
    {Coordinate{42.1265, 52.7063}, CountryId{"RU"}}, // Q110623422
    {Coordinate{42.1952, 52.6849}, CountryId{"RU"}}, // Q110623423
    {Coordinate{42.2761, 52.6665}, CountryId{"RU"}}, // Q110623424
    {Coordinate{42.4598, 52.6388}, CountryId{"RU"}}, // Q110623425
    {Coordinate{42.5333, 52.6568}, CountryId{"RU"}}, // Q110623426
    {Coordinate{42.5743, 52.646}, CountryId{"RU"}}, // Q110623427
    {Coordinate{42.6608, 52.6365}, CountryId{"RU"}}, // Q110623429
    {Coordinate{42.8778, 52.6036}, CountryId{"RU"}}, // Q110623430
    {Coordinate{43.0143, 52.5512}, CountryId{"RU"}}, // Q110623431
    {Coordinate{43.5435, 52.389}, CountryId{"RU"}}, // Q110623432
    {Coordinate{43.8519, 52.23}, CountryId{"RU"}}, // Q110623433
    {Coordinate{42.6288, 52.6357}, CountryId{"RU"}}, // Q110623453
    {Coordinate{31.3494, 56.2815}, CountryId{"RU"}}, // Zhizhitsa
    {Coordinate{41.4408, 52.6473}, CountryId{"RU"}}, // Q110629574
    {Coordinate{41.4464, 52.5878}, CountryId{"RU"}}, // Q110629575
    {Coordinate{41.4527, 52.5748}, CountryId{"RU"}}, // Q110629577
    {Coordinate{41.4692, 52.5365}, CountryId{"RU"}}, // Q110629578
    {Coordinate{41.4952, 52.5124}, CountryId{"RU"}}, // Q110629579
    {Coordinate{41.4915, 52.4641}, CountryId{"RU"}}, // Q110629580
    {Coordinate{41.5129, 52.4306}, CountryId{"RU"}}, // Q110629581
    {Coordinate{41.6744, 52.3779}, CountryId{"RU"}}, // Q110629582
    {Coordinate{41.7722, 52.3303}, CountryId{"RU"}}, // Q110629583
    {Coordinate{41.8217, 52.3114}, CountryId{"RU"}}, // Q110629584
    {Coordinate{41.9527, 52.237}, CountryId{"RU"}}, // Q110629585
    {Coordinate{41.9742, 52.2006}, CountryId{"RU"}}, // Q110629586
    {Coordinate{42.0206, 52.1366}, CountryId{"RU"}}, // Q110629587
    {Coordinate{42.0678, 52.0748}, CountryId{"RU"}}, // Q110629589
    {Coordinate{42.2523, 51.9655}, CountryId{"RU"}}, // Q110629590
    {Coordinate{42.3368, 51.8627}, CountryId{"RU"}}, // Q110629591
    {Coordinate{42.432, 51.8567}, CountryId{"RU"}}, // Q110629592
    {Coordinate{42.48, 51.8477}, CountryId{"RU"}}, // Q110629593
    {Coordinate{42.7425, 51.7483}, CountryId{"RU"}}, // Q110629594
    {Coordinate{44.558, 50.8276}, CountryId{"RU"}}, // Q110629678
    {Coordinate{31.2199, 56.2909}, CountryId{"RU"}}, // 434 km
    {Coordinate{31.1581, 56.2836}, CountryId{"RU"}}, // Artyomovo
    {Coordinate{15.9658, 48.6747}, CountryId{"AT"}}, // Platt station
    {Coordinate{43.2188, 51.5289}, CountryId{"RU"}}, // Q110638035
    {Coordinate{43.356, 51.4378}, CountryId{"RU"}}, // Q110638036
    {Coordinate{43.3745, 51.408}, CountryId{"RU"}}, // Q110638037
    {Coordinate{43.4245, 51.3224}, CountryId{"RU"}}, // Q110638038
    {Coordinate{43.4647, 51.3154}, CountryId{"RU"}}, // Q110638039
    {Coordinate{43.4647, 51.3154}, CountryId{"RU"}}, // Q110638040
    {Coordinate{43.6978, 51.1604}, CountryId{"RU"}}, // Q110638041
    {Coordinate{43.7278, 51.0536}, CountryId{"RU"}}, // Q110638042
    {Coordinate{43.7885, 50.9585}, CountryId{"RU"}}, // Q110638043
    {Coordinate{43.9764, 50.8981}, CountryId{"RU"}}, // Q110638044
    {Coordinate{44.2084, 52.0709}, CountryId{"RU"}}, // Q110640310
    {Coordinate{30.9829, 56.2948}, CountryId{"RU"}}, // Kunya
    {Coordinate{30.8709, 56.3237}, CountryId{"RU"}}, // Tabory
    {Coordinate{45.0985, 51.8392}, CountryId{"RU"}}, // Q110641961
    {Coordinate{45.3338, 51.7359}, CountryId{"RU"}}, // Q110641964
    {Coordinate{45.3933, 51.7174}, CountryId{"RU"}}, // Q110641965
    {Coordinate{45.4088, 51.7115}, CountryId{"RU"}}, // Q110641967
    {Coordinate{45.4335, 51.6993}, CountryId{"RU"}}, // Q110641969
    {Coordinate{45.5179, 51.6779}, CountryId{"RU"}}, // Q110641971
    {Coordinate{45.6134, 51.6693}, CountryId{"RU"}}, // Q110641973
    {Coordinate{45.65, 51.6722}, CountryId{"RU"}}, // Q110641974
    {Coordinate{45.6856, 51.6744}, CountryId{"RU"}}, // Q110641976
    {Coordinate{45.7007, 51.6614}, CountryId{"RU"}}, // Q110641978
    {Coordinate{45.8065, 51.6341}, CountryId{"RU"}}, // Q110641979
    {Coordinate{45.8308, 51.5948}, CountryId{"RU"}}, // Q110641981
    {Coordinate{45.8462, 51.5894}, CountryId{"RU"}}, // Q110641983
    {Coordinate{45.8747, 51.5974}, CountryId{"RU"}}, // Q110641984
    {Coordinate{45.8934, 51.5918}, CountryId{"RU"}}, // Q110641986
    {Coordinate{45.9176, 51.5938}, CountryId{"RU"}}, // Q110641987
    {Coordinate{44.4565, 51.499}, CountryId{"RU"}}, // Q110642463
    {Coordinate{44.9852, 51.7894}, CountryId{"RU"}}, // Q110646796
    {Coordinate{44.9468, 51.7516}, CountryId{"RU"}}, // Q110646797
    {Coordinate{44.8646, 51.6139}, CountryId{"RU"}}, // Q110646798
    {Coordinate{44.8314, 51.5506}, CountryId{"RU"}}, // Q110646800
    {Coordinate{45.9912, 51.5267}, CountryId{"RU"}}, // Q110647038
    {Coordinate{45.9584, 51.5899}, CountryId{"RU"}}, // Q110647114
    {Coordinate{45.9747, 51.5807}, CountryId{"RU"}}, // Q110647115
    {Coordinate{45.9924, 51.5717}, CountryId{"RU"}}, // Q110647116
    {Coordinate{45.9992, 51.5659}, CountryId{"RU"}}, // Q110647117
    {Coordinate{45.9849, 51.5129}, CountryId{"RU"}}, // Q110647190
    {Coordinate{45.9626, 51.5105}, CountryId{"RU"}}, // Q110647191
    {Coordinate{46.8836, 51.2634}, CountryId{"RU"}}, // Q110647493
    {Coordinate{45.9607, 51.5004}, CountryId{"RU"}}, // Q110647716
    {Coordinate{45.9546, 51.4728}, CountryId{"RU"}}, // Q110647717
    {Coordinate{45.9695, 51.4351}, CountryId{"RU"}}, // Q110647718
    {Coordinate{45.9702, 51.4249}, CountryId{"RU"}}, // Q110647719
    {Coordinate{45.9626, 51.4179}, CountryId{"RU"}}, // Q110647720
    {Coordinate{46.0151, 51.4085}, CountryId{"RU"}}, // Q110647726
    {Coordinate{45.9359, 51.5029}, CountryId{"RU"}}, // Q110648128
    {Coordinate{45.9384, 51.4887}, CountryId{"RU"}}, // Q110648130
    {Coordinate{47.5097, 51.2409}, CountryId{"RU"}}, // Q110648171
    {Coordinate{48.526, 51.3173}, CountryId{"RU"}}, // Q110648284
    {Coordinate{48.7568, 51.2414}, CountryId{"RU"}}, // Q110648285
    {Coordinate{49.1232, 51.2018}, CountryId{"RU"}}, // Q110648286
    {Coordinate{49.4534, 51.2047}, CountryId{"RU"}}, // Q110648287
    {Coordinate{30.7183, 56.3277}, CountryId{"RU"}}, // Serdtse
    {Coordinate{}, CountryId{"FR"}}, // Q110655300
    {Coordinate{47.0602, 52.1579}, CountryId{"RU"}}, // Q110656837
    {Coordinate{47.2269, 52.1277}, CountryId{"RU"}}, // Q110656838
    {Coordinate{47.3071, 52.087}, CountryId{"RU"}}, // Q110656839
    {Coordinate{47.5272, 52.0819}, CountryId{"RU"}}, // Q110656840
    {Coordinate{47.8066, 51.989}, CountryId{"RU"}}, // Q110656842
    {Coordinate{47.9286, 51.9334}, CountryId{"RU"}}, // Q110656843
    {Coordinate{48.5002, 51.9411}, CountryId{"RU"}}, // Q110656844
    {Coordinate{49.9564, 51.9724}, CountryId{"RU"}}, // Q110657086
    {Coordinate{49.0752, 52.3007}, CountryId{"RU"}}, // Q110657507
    {Coordinate{48.7209, 51.8135}, CountryId{"RU"}}, // Q110657672
    {Coordinate{48.6484, 51.663}, CountryId{"RU"}}, // Q110657674
    {Coordinate{48.5351, 51.5776}, CountryId{"RU"}}, // Q110657675
    {Coordinate{48.7854, 51.9094}, CountryId{"RU"}}, // Q110657685
    {Coordinate{48.4382, 51.5127}, CountryId{"RU"}}, // Q110657686
    {Coordinate{48.3596, 51.4154}, CountryId{"RU"}}, // Q110657687
    {Coordinate{1.73113, 48.3917}, CountryId{"FR"}}, // Category:Gare de Santeuil
    {Coordinate{34.0682, 57.7895}, CountryId{"RU"}}, // 14 km
    {Coordinate{33.9758, 57.7272}, CountryId{"RU"}}, // Kuzhenkino
    {Coordinate{33.8978, 57.6628}, CountryId{"RU"}}, // Shlina
    {Coordinate{33.8556, 57.5967}, CountryId{"RU"}}, // Batalino
    {Coordinate{33.7828, 57.5323}, CountryId{"RU"}}, // 48 km
    {Coordinate{33.699, 57.4832}, CountryId{"RU"}}, // Firovo
    {Coordinate{12.2525, 53.4203}, CountryId{"DE"}}, // Silbermühle railway station
    {Coordinate{12.2589, 53.5063}, CountryId{"DE"}}, // Plau-Quetzin railway station
    {Coordinate{12.3554, 53.5121}, CountryId{"DE"}}, // Alt Schwerin railway station
    {Coordinate{46.9288, 52.1329}, CountryId{"RU"}}, // Q110728118
    {Coordinate{46.7524, 52.0206}, CountryId{"RU"}}, // Q110728119
    {Coordinate{46.6803, 52.0077}, CountryId{"RU"}}, // Q110728120
    {Coordinate{46.5459, 52.0278}, CountryId{"RU"}}, // Q110728121
    {Coordinate{46.4037, 52.0068}, CountryId{"RU"}}, // Q110728122
    {Coordinate{46.3425, 51.9629}, CountryId{"RU"}}, // Q110728123
    {Coordinate{46.281, 51.9557}, CountryId{"RU"}}, // Q110728125
    {Coordinate{46.2185, 51.8435}, CountryId{"RU"}}, // Q110728126
    {Coordinate{46.1929, 51.8182}, CountryId{"RU"}}, // Q110728127
    {Coordinate{46.1933, 51.7956}, CountryId{"RU"}}, // Q110728128
    {Coordinate{46.2112, 51.778}, CountryId{"RU"}}, // Q110728129
    {Coordinate{46.2128, 51.7515}, CountryId{"RU"}}, // Q110728132
    {Coordinate{46.2126, 51.7433}, CountryId{"RU"}}, // Q110728133
    {Coordinate{46.2061, 51.7316}, CountryId{"RU"}}, // Q110728134
    {Coordinate{46.1899, 51.7225}, CountryId{"RU"}}, // Q110728135
    {Coordinate{46.1467, 51.7196}, CountryId{"RU"}}, // Q110728137
    {Coordinate{46.1182, 51.716}, CountryId{"RU"}}, // Q110728138
    {Coordinate{46.0719, 51.7113}, CountryId{"RU"}}, // Q110728139
    {Coordinate{46.0508, 51.7031}, CountryId{"RU"}}, // Q110728140
    {Coordinate{46.0299, 51.6848}, CountryId{"RU"}}, // Q110728142
    {Coordinate{45.9595, 51.6142}, CountryId{"RU"}}, // Q110728143
    {Coordinate{45.9587, 51.6052}, CountryId{"RU"}}, // Q110728144
    {Coordinate{45.9341, 51.598}, CountryId{"RU"}}, // Q110728145
    {Coordinate{33.5158, 57.3725}, CountryId{"RU"}}, // Gorovastitsa
    {Coordinate{45.9233, 51.4986}, CountryId{"RU"}}, // Q110737989
    {Coordinate{45.9146, 51.4819}, CountryId{"RU"}}, // Q110737991
    {Coordinate{45.9099, 51.4739}, CountryId{"RU"}}, // Q110737993
    {Coordinate{45.88, 51.4616}, CountryId{"RU"}}, // Q110737994
    {Coordinate{45.8433, 51.4487}, CountryId{"RU"}}, // Q110737995
    {Coordinate{45.8253, 51.4494}, CountryId{"RU"}}, // Q110737996
    {Coordinate{45.7964, 51.4415}, CountryId{"RU"}}, // Q110737997
    {Coordinate{45.7165, 51.4228}, CountryId{"RU"}}, // Q110737998
    {Coordinate{45.6894, 51.3934}, CountryId{"RU"}}, // Q110737999
    {Coordinate{45.6797, 51.3626}, CountryId{"RU"}}, // Q110738001
    {Coordinate{45.6778, 51.3444}, CountryId{"RU"}}, // Q110738002
    {Coordinate{45.6504, 51.2932}, CountryId{"RU"}}, // Q110738003
    {Coordinate{45.5753, 51.2509}, CountryId{"RU"}}, // Q110738004
    {Coordinate{45.5355, 51.23}, CountryId{"RU"}}, // Q110738008
    {Coordinate{45.5285, 51.0738}, CountryId{"RU"}}, // Q110738009
    {Coordinate{45.5311, 51.0345}, CountryId{"RU"}}, // Q110738012
    {Coordinate{45.4455, 50.8993}, CountryId{"RU"}}, // Q110738014
    {Coordinate{45.4771, 50.7921}, CountryId{"RU"}}, // Q110738015
    {Coordinate{45.4492, 50.7376}, CountryId{"RU"}}, // Q110738018
    {Coordinate{45.4292, 50.7015}, CountryId{"RU"}}, // Q110738020
    {Coordinate{45.5537, 51.2406}, CountryId{"RU"}}, // Q110738100
    {Coordinate{42.564, 50.7634}, CountryId{"RU"}}, // Q110754809
    {Coordinate{42.6065, 50.6122}, CountryId{"RU"}}, // Q110754811
    {Coordinate{43.6415, 49.7909}, CountryId{"RU"}}, // Q110754813
    {Coordinate{44.71, 50.7823}, CountryId{"RU"}}, // Q110755260
    {Coordinate{44.7476, 50.681}, CountryId{"RU"}}, // Q110755261
    {Coordinate{45.1329, 50.1813}, CountryId{"RU"}}, // Q110755263
    {Coordinate{45.1437, 50.1722}, CountryId{"RU"}}, // Q110755266
    {Coordinate{33.317, 57.2488}, CountryId{"RU"}}, // Chyornyi Dor
    {Coordinate{33.1938, 57.1675}, CountryId{"RU"}}, // 104 km
    {Coordinate{46.9926, 51.1632}, CountryId{"RU"}}, // Q110755455
    {Coordinate{46.9758, 50.9566}, CountryId{"RU"}}, // Q110755459
    {Coordinate{47.0864, 50.8029}, CountryId{"RU"}}, // Q110756092
    {Coordinate{47.4308, 50.6161}, CountryId{"RU"}}, // Q110756093
    {Coordinate{47.6715, 50.5183}, CountryId{"RU"}}, // Q110756094
    {Coordinate{48.1326, 50.4234}, CountryId{"RU"}}, // Q110756095
    {Coordinate{46.9038, 50.3758}, CountryId{"RU"}}, // Q110763012
    {Coordinate{46.8722, 50.0474}, CountryId{"RU"}}, // Q110763014
    {Coordinate{46.845, 49.7439}, CountryId{"RU"}}, // Q110763016
    {Coordinate{46.8378, 49.1302}, CountryId{"RU"}}, // Q110763017
    {Coordinate{35.3124, 59.1599}, CountryId{"RU"}}, // Chagoda railway station
    {Coordinate{35.2064, 59.0931}, CountryId{"RU"}}, // Ogaryovo railway station
    {Coordinate{33.0198, 57.0821}, CountryId{"RU"}}, // 122 km
    {Coordinate{9.41143, 49.7841}, CountryId{"DE"}}, // Q110770692
    {Coordinate{48.0264, 46.7319}, CountryId{"RU"}}, // Q110785744
    {Coordinate{48.0228, 46.6995}, CountryId{"RU"}}, // Q110785745
    {Coordinate{48.0753, 46.547}, CountryId{"RU"}}, // Q110785747
    {Coordinate{48.0781, 46.5255}, CountryId{"RU"}}, // Q110785749
    {Coordinate{48.0756, 46.5148}, CountryId{"RU"}}, // Q110785750
    {Coordinate{48.0681, 46.4652}, CountryId{"RU"}}, // Q110785752
    {Coordinate{48.0716, 46.4431}, CountryId{"RU"}}, // Q110785753
    {Coordinate{48.0723, 46.3343}, CountryId{"RU"}}, // Q110796767
    {Coordinate{48.0095, 46.3276}, CountryId{"RU"}}, // Q110796768
    {Coordinate{47.988, 46.3385}, CountryId{"RU"}}, // Q110796769
    {Coordinate{47.5916, 46.2992}, CountryId{"RU"}}, // Q110796770
    {Coordinate{47.4148, 46.2585}, CountryId{"RU"}}, // Q110796771
    {Coordinate{47.2976, 46.1989}, CountryId{"RU"}}, // Q110796773
    {Coordinate{47.1764, 46.1356}, CountryId{"RU"}}, // Q110796774
    {Coordinate{47.1128, 46.0491}, CountryId{"RU"}}, // Q110796775
    {Coordinate{47.0485, 45.9341}, CountryId{"RU"}}, // Q110796777
    {Coordinate{46.95, 45.6908}, CountryId{"RU"}}, // Q110796778
    {Coordinate{-0.998217, 44.6233}, CountryId{"FR"}}, // Q110797376
    {Coordinate{44.0533, 49.1847}, CountryId{"RU"}}, // Q110800719
    {Coordinate{44.0891, 49.0538}, CountryId{"RU"}}, // Q110800720
    {Coordinate{44.0986, 49.0446}, CountryId{"RU"}}, // Q110800721
    {Coordinate{44.5111, 48.7683}, CountryId{"RU"}}, // Q110807351
    {Coordinate{32.4412, 56.7691}, CountryId{"RU"}}, // Okhvat
    {Coordinate{44.5766, 48.7764}, CountryId{"RU"}}, // Q110808514
    {Coordinate{32.3572, 56.6991}, CountryId{"RU"}}, // 183 km
    {Coordinate{32.2634, 56.6463}, CountryId{"RU"}}, // Andreapol
    {Coordinate{44.5269, 48.7701}, CountryId{"RU"}}, // Q110808779
    {Coordinate{44.4232, 48.6954}, CountryId{"RU"}}, // Q110811479
    {Coordinate{44.4046, 48.6952}, CountryId{"RU"}}, // Q110811482
    {Coordinate{44.4517, 48.6555}, CountryId{"RU"}}, // Q110815148
    {Coordinate{44.4442, 48.6434}, CountryId{"RU"}}, // Q110815149
    {Coordinate{44.4354, 48.6252}, CountryId{"RU"}}, // Q110815150
    {Coordinate{44.4337, 48.6112}, CountryId{"RU"}}, // Q110815151
    {Coordinate{44.434, 48.5986}, CountryId{"RU"}}, // Q110815152
    {Coordinate{44.4485, 48.5713}, CountryId{"RU"}}, // Q110815153
    {Coordinate{44.4599, 48.5574}, CountryId{"RU"}}, // Q110815154
    {Coordinate{44.4756, 48.539}, CountryId{"RU"}}, // Q110815156
    {Coordinate{44.4934, 48.529}, CountryId{"RU"}}, // Q110815157
    {Coordinate{44.5299, 48.5084}, CountryId{"RU"}}, // Q110815158
    {Coordinate{44.5182, 48.475}, CountryId{"RU"}}, // Q110815159
    {Coordinate{44.5015, 48.4523}, CountryId{"RU"}}, // Q110815161
    {Coordinate{44.474, 48.4368}, CountryId{"RU"}}, // Q110815163
    {Coordinate{44.4359, 48.4437}, CountryId{"RU"}}, // Q110815164
    {Coordinate{44.4096, 48.4432}, CountryId{"RU"}}, // Q110815165
    {Coordinate{44.386, 48.4239}, CountryId{"RU"}}, // Q110815166
    {Coordinate{44.2722, 48.2867}, CountryId{"RU"}}, // Q110815167
    {Coordinate{43.6513, 47.9636}, CountryId{"RU"}}, // Q110815170
    {Coordinate{43.4955, 47.84}, CountryId{"RU"}}, // Q110815171
    {Coordinate{44.6707, 48.4808}, CountryId{"RU"}}, // Q110815476
    {Coordinate{44.5267, 48.5122}, CountryId{"RU"}}, // Q110815576
    {Coordinate{44.5371, 48.5088}, CountryId{"RU"}}, // Q110815577
    {Coordinate{44.5708, 48.5169}, CountryId{"RU"}}, // Q110815578
    {Coordinate{44.5844, 48.5245}, CountryId{"RU"}}, // Q110815579
    {Coordinate{44.6011, 48.5286}, CountryId{"RU"}}, // Q110815580
    {Coordinate{44.6432, 48.4999}, CountryId{"RU"}}, // Q110815583
    {Coordinate{44.6519, 48.4939}, CountryId{"RU"}}, // Q110815585
    {Coordinate{42.6612, 48.6064}, CountryId{"RU"}}, // Q110816390
    {Coordinate{42.8937, 48.6}, CountryId{"RU"}}, // Q110816393
    {Coordinate{42.9857, 48.5454}, CountryId{"RU"}}, // Q110816394
    {Coordinate{43.035, 48.5232}, CountryId{"RU"}}, // Q110816396
    {Coordinate{43.1924, 48.477}, CountryId{"RU"}}, // Q110816397
    {Coordinate{43.2739, 48.4678}, CountryId{"RU"}}, // Q110816398
    {Coordinate{43.3276, 48.4595}, CountryId{"RU"}}, // Q110816399
    {Coordinate{43.3798, 48.44}, CountryId{"RU"}}, // Q110816400
    {Coordinate{43.4977, 48.4937}, CountryId{"RU"}}, // Q110816401
    {Coordinate{43.5799, 48.5688}, CountryId{"RU"}}, // Q110816402
    {Coordinate{43.6106, 48.5982}, CountryId{"RU"}}, // Q110816403
    {Coordinate{43.6325, 48.6099}, CountryId{"RU"}}, // Q110816404
    {Coordinate{43.6524, 48.6163}, CountryId{"RU"}}, // Q110816405
    {Coordinate{43.7189, 48.6338}, CountryId{"RU"}}, // Q110816406
    {Coordinate{43.7828, 48.6595}, CountryId{"RU"}}, // Q110816407
    {Coordinate{43.8269, 48.6718}, CountryId{"RU"}}, // Q110816409
    {Coordinate{43.862, 48.6752}, CountryId{"RU"}}, // Q110816410
    {Coordinate{43.9067, 48.6811}, CountryId{"RU"}}, // Q110816411
    {Coordinate{43.9836, 48.6867}, CountryId{"RU"}}, // Q110816412
    {Coordinate{44.2463, 48.6719}, CountryId{"RU"}}, // Q110816413
    {Coordinate{44.2808, 48.6769}, CountryId{"RU"}}, // Q110816414
    {Coordinate{44.3191, 48.6818}, CountryId{"RU"}}, // Q110816417
    {Coordinate{43.4992, 48.6924}, CountryId{"RU"}}, // Q110816589
    {Coordinate{43.6243, 48.6502}, CountryId{"RU"}}, // Q110816627
    {Coordinate{43.5572, 48.672}, CountryId{"RU"}}, // Q110816628
    {Coordinate{43.5414, 48.6772}, CountryId{"RU"}}, // Q110816629
    {Coordinate{32.0731, 56.5869}, CountryId{"RU"}}, // Gladkiy Log
    {Coordinate{32.0033, 56.5772}, CountryId{"RU"}}, // 210 km
    {Coordinate{45.2127, 48.7237}, CountryId{"RU"}}, // Q110821458
    {Coordinate{45.7525, 48.5891}, CountryId{"RU"}}, // Q110821459
    {Coordinate{45.8123, 48.5604}, CountryId{"RU"}}, // Q110821460
    {Coordinate{46.0073, 48.4873}, CountryId{"RU"}}, // Q110821462
    {Coordinate{31.9094, 56.5741}, CountryId{"RU"}}, // Martisovo
    {Coordinate{31.6477, 56.5141}, CountryId{"RU"}}, // Toropets
    {Coordinate{40.2904, 49.1364}, CountryId{"RU"}}, // Q110830068
    {Coordinate{40.2786, 49.1549}, CountryId{"RU"}}, // Q110830070
    {Coordinate{40.3293, 48.6815}, CountryId{"RU"}}, // Q110831585
    {Coordinate{40.3396, 48.6357}, CountryId{"RU"}}, // Q110831586
    {Coordinate{40.3044, 48.4552}, CountryId{"RU"}}, // Q110831589
    {Coordinate{40.0933, 48.1396}, CountryId{"RU"}}, // Q110833331
    {Coordinate{40.1959, 47.8175}, CountryId{"RU"}}, // Q110844752
    {Coordinate{40.0622, 47.945}, CountryId{"RU"}}, // Q110845101
    {Coordinate{40.141, 47.8806}, CountryId{"RU"}}, // Q110845103
    {Coordinate{40.1861, 47.8667}, CountryId{"RU"}}, // Q110845105
    {Coordinate{40.2179, 47.8547}, CountryId{"RU"}}, // Q110845106
    {Coordinate{40.3114, 47.8605}, CountryId{"RU"}}, // Q110845952
    {Coordinate{40.4446, 47.8498}, CountryId{"RU"}}, // Q110845953
    {Coordinate{40.5761, 47.83}, CountryId{"RU"}}, // Q110845954
    {Coordinate{40.6402, 47.787}, CountryId{"RU"}}, // Q110845955
    {Coordinate{40.7089, 47.7097}, CountryId{"RU"}}, // Q110845956
    {Coordinate{40.7381, 47.6925}, CountryId{"RU"}}, // Q110845957
    {Coordinate{40.7818, 47.6756}, CountryId{"RU"}}, // Q110845958
    {Coordinate{40.8245, 47.6534}, CountryId{"RU"}}, // Q110845960
    {Coordinate{40.8492, 47.6384}, CountryId{"RU"}}, // Q110845961
    {Coordinate{31.5893, 56.507}, CountryId{"RU"}}, // 241 km
    {Coordinate{31.4468, 56.4776}, CountryId{"RU"}}, // 252 km
    {Coordinate{31.3503, 56.4559}, CountryId{"RU"}}, // Skvortsovo
    {Coordinate{31.2356, 56.4432}, CountryId{"RU"}}, // 265 km
    {Coordinate{40.2065, 47.7928}, CountryId{"RU"}}, // Q110847372
    {Coordinate{40.1944, 47.7832}, CountryId{"RU"}}, // Q110847432
    {Coordinate{40.2052, 47.7522}, CountryId{"RU"}}, // Q110847440
    {Coordinate{40.1762, 47.6979}, CountryId{"RU"}}, // Q110848428
    {Coordinate{7.8552, 51.09}, CountryId{"DE"}}, // Attendorn-Hohen Hagen railway station
    {Coordinate{40.1832, 47.6354}, CountryId{"RU"}}, // Q110853485
    {Coordinate{40.1617, 47.597}, CountryId{"RU"}}, // Q110853486
    {Coordinate{40.1253, 47.5551}, CountryId{"RU"}}, // Q110853488
    {Coordinate{40.0749, 47.3794}, CountryId{"RU"}}, // Q110853489
    {Coordinate{40.0543, 47.3611}, CountryId{"RU"}}, // Q110853490
    {Coordinate{40.0074, 47.3242}, CountryId{"RU"}}, // Q110853492
    {Coordinate{39.9552, 47.298}, CountryId{"RU"}}, // Q110853493
    {Coordinate{39.8981, 47.268}, CountryId{"RU"}}, // Q110853495
    {Coordinate{39.787, 47.2294}, CountryId{"RU"}}, // Q110859210
    {Coordinate{39.7643, 47.2549}, CountryId{"RU"}}, // Q110859211
    {Coordinate{39.7054, 47.2055}, CountryId{"RU"}}, // Q110859365
    {Coordinate{39.6584, 47.25}, CountryId{"RU"}}, // Q110859666
    {Coordinate{39.6481, 47.2539}, CountryId{"RU"}}, // Q110859667
    {Coordinate{39.5499, 47.2478}, CountryId{"RU"}}, // Q110859669
    {Coordinate{39.6933, 47.2054}, CountryId{"RU"}}, // Q110859827
    {Coordinate{39.6064, 47.1995}, CountryId{"RU"}}, // Q110859828
    {Coordinate{39.5797, 47.2128}, CountryId{"RU"}}, // Q110859829
    {Coordinate{39.5352, 47.2396}, CountryId{"RU"}}, // Q110859832
    {Coordinate{31.1307, 56.4026}, CountryId{"RU"}}, // Bubnovo
    {Coordinate{31.0471, 56.3977}, CountryId{"RU"}}, // Nazimovo
    {Coordinate{30.9887, 56.4059}, CountryId{"RU"}}, // 282 km
    {Coordinate{17.6852, 49.0328}, CountryId{"CZ"}}, // Újezdec u Luhačovic
    {Coordinate{40.3199, 48.1859}, CountryId{"RU"}}, // Q110864158
    {Coordinate{40.5601, 48.1772}, CountryId{"RU"}}, // Q110864159
    {Coordinate{40.643, 48.1578}, CountryId{"RU"}}, // Q110864160
    {Coordinate{40.7124, 48.1585}, CountryId{"RU"}}, // Q110864161
    {Coordinate{40.7636, 48.1663}, CountryId{"RU"}}, // Q110864162
    {Coordinate{40.8269, 48.1452}, CountryId{"RU"}}, // Q110864163
    {Coordinate{40.9202, 48.1423}, CountryId{"RU"}}, // Q110864164
    {Coordinate{41.0471, 48.2007}, CountryId{"RU"}}, // Q110864165
    {Coordinate{41.116, 48.1762}, CountryId{"RU"}}, // Q110864166
    {Coordinate{41.1494, 48.1974}, CountryId{"RU"}}, // Q110864167
    {Coordinate{41.1882, 48.1889}, CountryId{"RU"}}, // Q110864168
    {Coordinate{41.414, 48.2192}, CountryId{"RU"}}, // Q110864170
    {Coordinate{41.4785, 48.2413}, CountryId{"RU"}}, // Q110864171
    {Coordinate{41.5883, 48.3046}, CountryId{"RU"}}, // Q110864173
    {Coordinate{41.6473, 48.3483}, CountryId{"RU"}}, // Q110864174
    {Coordinate{41.7036, 48.3472}, CountryId{"RU"}}, // Q110864175
    {Coordinate{41.7754, 48.3495}, CountryId{"RU"}}, // Q110864176
    {Coordinate{18.4246, 47.1832}, CountryId{"HU"}}, // Székesfehérvár railway station
    {Coordinate{30.9498, 56.394}, CountryId{"RU"}}, // 285 km
    {Coordinate{30.8939, 56.3688}, CountryId{"RU"}}, // 290 km
    {Coordinate{30.8207, 56.3568}, CountryId{"RU"}}, // Velikopolye
    {Coordinate{39.9922, 45.8109}, CountryId{"RU"}}, // Q110883469
    {Coordinate{39.9922, 45.8109}, CountryId{"RU"}}, // Q110883470
    {Coordinate{39.8587, 45.701}, CountryId{"RU"}}, // Q110883471
    {Coordinate{39.7599, 45.647}, CountryId{"RU"}}, // Q110883472
    {Coordinate{39.5667, 45.5288}, CountryId{"RU"}}, // Q110883473
    {Coordinate{39.5476, 45.5044}, CountryId{"RU"}}, // Q110883474
    {Coordinate{39.4075, 45.3776}, CountryId{"RU"}}, // Q110883476
    {Coordinate{39.3049, 45.2884}, CountryId{"RU"}}, // Q110883477
    {Coordinate{39.1828, 45.1362}, CountryId{"RU"}}, // Q110883480
    {Coordinate{39.1653, 45.1209}, CountryId{"RU"}}, // Q110883481
    {Coordinate{39.1139, 45.0886}, CountryId{"RU"}}, // Q110883482
    {Coordinate{39.0999, 45.0797}, CountryId{"RU"}}, // Q110883483
    {Coordinate{30.775, 56.3566}, CountryId{"RU"}}, // 297 km
    {Coordinate{38.8338, 44.891}, CountryId{"RU"}}, // Q110886397
    {Coordinate{38.6914, 44.8714}, CountryId{"RU"}}, // Q110886400
    {Coordinate{38.5532, 44.8619}, CountryId{"RU"}}, // Q110886401
    {Coordinate{38.4895, 44.8672}, CountryId{"RU"}}, // Q110886402
    {Coordinate{38.4895, 44.8672}, CountryId{"RU"}}, // Q110886403
    {Coordinate{38.3395, 44.8705}, CountryId{"RU"}}, // Q110886404
    {Coordinate{38.2548, 44.8672}, CountryId{"RU"}}, // Q110886406
    {Coordinate{37.9606, 44.8941}, CountryId{"RU"}}, // Q110886729
    {Coordinate{37.8628, 44.8693}, CountryId{"RU"}}, // Q110886733
    {Coordinate{46.7641, 45.2125}, CountryId{"RU"}}, // Q110890566
    {Coordinate{46.6055, 44.674}, CountryId{"RU"}}, // Q110890567
    {Coordinate{46.5949, 44.3867}, CountryId{"RU"}}, // Q110890568
    {Coordinate{46.6648, 44.0978}, CountryId{"RU"}}, // Q110890569
    {Coordinate{46.7382, 43.5575}, CountryId{"RU"}}, // Q110891735
    {Coordinate{46.7668, 43.369}, CountryId{"RU"}}, // Q110891737
    {Coordinate{46.8959, 45.5528}, CountryId{"RU"}}, // Q110891887
    {Coordinate{46.6233, 44.8175}, CountryId{"RU"}}, // Q110891888
    {Coordinate{46.5878, 44.5305}, CountryId{"RU"}}, // Q110891889
    {Coordinate{46.6304, 44.2406}, CountryId{"RU"}}, // Q110891890
    {Coordinate{46.6963, 43.9673}, CountryId{"RU"}}, // Q110891891
    {Coordinate{7.5956, 47.6279}, CountryId{"DE"}}, // Eimeldingen station
    {Coordinate{45.8793, 43.4936}, CountryId{"RU"}}, // Q110892281
    {Coordinate{45.5767, 43.6015}, CountryId{"RU"}}, // Q110892282
    {Coordinate{45.3586, 43.674}, CountryId{"RU"}}, // Q110892283
    {Coordinate{45.2452, 43.6957}, CountryId{"RU"}}, // Q110892284
    {Coordinate{45.1223, 43.7243}, CountryId{"RU"}}, // Q110892285
    {Coordinate{7.56392, 47.6556}, CountryId{"DE"}}, // Efringen-Kirchen station
    {Coordinate{7.54294, 47.6609}, CountryId{"DE"}}, // Istein station
    {Coordinate{7.52466, 47.6861}, CountryId{"DE"}}, // Kleinkems station
    {Coordinate{38.7001, 47.6497}, CountryId{"RU"}}, // Q110892620
    {Coordinate{38.7401, 47.607}, CountryId{"RU"}}, // Q110892621
    {Coordinate{38.7732, 47.5723}, CountryId{"RU"}}, // Q110892622
    {Coordinate{38.8058, 47.5704}, CountryId{"RU"}}, // Q110892623
    {Coordinate{38.8834, 47.5372}, CountryId{"RU"}}, // Q110892624
    {Coordinate{38.8893, 47.5121}, CountryId{"RU"}}, // Q110892625
    {Coordinate{38.9121, 47.4799}, CountryId{"RU"}}, // Q110892626
    {Coordinate{38.9053, 47.429}, CountryId{"RU"}}, // Q110892627
    {Coordinate{38.9206, 47.4051}, CountryId{"RU"}}, // Q110892628
    {Coordinate{38.9536, 47.3619}, CountryId{"RU"}}, // Q110892629
    {Coordinate{38.9376, 47.329}, CountryId{"RU"}}, // Q110892630
    {Coordinate{7.53164, 47.7095}, CountryId{"DE"}}, // Rheinweiler station
    {Coordinate{39.0956, 47.2921}, CountryId{"RU"}}, // Q110894235
    {Coordinate{7.64619, 47.8799}, CountryId{"DE"}}, // Heitersheim station
    {Coordinate{30.6903, 56.3512}, CountryId{"RU"}}, // 303 km
    {Coordinate{30.6129, 56.3428}, CountryId{"RU"}}, // 308 km
    {Coordinate{38.9541, 47.2731}, CountryId{"RU"}}, // Q110898086
    {Coordinate{38.9892, 47.2786}, CountryId{"RU"}}, // Q110898088
    {Coordinate{39.02, 47.2807}, CountryId{"RU"}}, // Q110898089
    {Coordinate{39.0552, 47.2834}, CountryId{"RU"}}, // Q110898090
    {Coordinate{39.1819, 47.2893}, CountryId{"RU"}}, // Q110898092
    {Coordinate{39.2154, 47.2864}, CountryId{"RU"}}, // Q110898093
    {Coordinate{39.3362, 47.2666}, CountryId{"RU"}}, // Q110898094
    {Coordinate{39.3588, 47.2666}, CountryId{"RU"}}, // Q110898095
    {Coordinate{39.3799, 47.2658}, CountryId{"RU"}}, // Q110898096
    {Coordinate{39.4388, 47.2643}, CountryId{"RU"}}, // Q110898097
    {Coordinate{39.4642, 47.2622}, CountryId{"RU"}}, // Q110898099
    {Coordinate{-91.5506, 40.9713}, CountryId{"US"}}, // Mount Pleasant
    {Coordinate{40.1614, 46.9461}, CountryId{"RU"}}, // Q110899655
    {Coordinate{40.1705, 46.9325}, CountryId{"RU"}}, // Q110899656
    {Coordinate{7.7262, 47.9393}, CountryId{"DE"}}, // Norsingen station
    {Coordinate{7.75389, 47.9559}, CountryId{"DE"}}, // Schallstadt station
    {Coordinate{7.76818, 47.9604}, CountryId{"DE"}}, // Ebringen station
    {Coordinate{7.80301, 47.9755}, CountryId{"DE"}}, // Freiburg-St Georgen station
    {Coordinate{39.7192, 47.0783}, CountryId{"RU"}}, // Q110900550
    {Coordinate{39.6732, 47.0264}, CountryId{"RU"}}, // Q110900559
    {Coordinate{39.6631, 47.0087}, CountryId{"RU"}}, // Q110900560
    {Coordinate{39.6566, 46.9926}, CountryId{"RU"}}, // Q110900562
    {Coordinate{39.6569, 46.9749}, CountryId{"RU"}}, // Q110900563
    {Coordinate{39.6767, 46.9355}, CountryId{"RU"}}, // Q110900565
    {Coordinate{39.6546, 46.8979}, CountryId{"RU"}}, // Q110900566
    {Coordinate{39.5704, 46.8468}, CountryId{"RU"}}, // Q110900567
    {Coordinate{39.5648, 46.7848}, CountryId{"RU"}}, // Q110900568
    {Coordinate{39.5801, 46.6511}, CountryId{"RU"}}, // Q110900570
    {Coordinate{39.5956, 46.6047}, CountryId{"RU"}}, // Q110900572
    {Coordinate{39.5819, 46.4739}, CountryId{"RU"}}, // Q110900573
    {Coordinate{39.6043, 46.394}, CountryId{"RU"}}, // Q110900574
    {Coordinate{39.8065, 46.2833}, CountryId{"RU"}}, // Q110900575
    {Coordinate{39.8047, 46.2288}, CountryId{"RU"}}, // Q110900576
    {Coordinate{39.8104, 46.1562}, CountryId{"RU"}}, // Q110900577
    {Coordinate{39.8365, 46.1251}, CountryId{"RU"}}, // Q110900578
    {Coordinate{39.8752, 46.0723}, CountryId{"RU"}}, // Q110900579
    {Coordinate{39.9226, 46.0095}, CountryId{"RU"}}, // Q110900580
    {Coordinate{39.9483, 45.9989}, CountryId{"RU"}}, // Q110900581
    {Coordinate{39.9937, 45.9394}, CountryId{"RU"}}, // Q110900583
    {Coordinate{40.0291, 45.9139}, CountryId{"RU"}}, // Q110900584
    {Coordinate{40.0537, 45.896}, CountryId{"RU"}}, // Q110900585
    {Coordinate{40.0668, 45.8865}, CountryId{"RU"}}, // Q110900586
    {Coordinate{40.0985, 45.8633}, CountryId{"RU"}}, // Q110900587
    {Coordinate{40.144, 45.8193}, CountryId{"RU"}}, // Q110901263
    {Coordinate{40.1708, 45.7924}, CountryId{"RU"}}, // Q110901264
    {Coordinate{40.2003, 45.7792}, CountryId{"RU"}}, // Q110901266
    {Coordinate{40.2143, 45.7649}, CountryId{"RU"}}, // Q110901267
    {Coordinate{40.2391, 45.7442}, CountryId{"RU"}}, // Q110901269
    {Coordinate{40.2504, 45.7173}, CountryId{"RU"}}, // Q110901270
    {Coordinate{40.2869, 45.6898}, CountryId{"RU"}}, // Q110901271
    {Coordinate{40.328, 45.6187}, CountryId{"RU"}}, // Q110901273
    {Coordinate{40.4043, 45.5373}, CountryId{"RU"}}, // Q110901275
    {Coordinate{40.4578, 45.4752}, CountryId{"RU"}}, // Q110901277
    {Coordinate{40.4759, 45.4702}, CountryId{"RU"}}, // Q110901279
    {Coordinate{32.7726, 56.8939}, CountryId{"RU"}}, // Zhukopa
    {Coordinate{32.9022, 56.8787}, CountryId{"RU"}}, // Lokhovo
    {Coordinate{33.0472, 56.8486}, CountryId{"RU"}}, // Shuvayevo
    {Coordinate{33.1742, 56.864}, CountryId{"RU"}}, // Goritsy
    {Coordinate{33.3391, 56.8596}, CountryId{"RU"}}, // Skakulino
    {Coordinate{33.4647, 56.8573}, CountryId{"RU"}}, // Selizharovo
    {Coordinate{65.2588, 55.4253}, CountryId{"RU"}}, // Kurganka railway station
    {Coordinate{8.6291, 53.1695}, CountryId{"DE"}}, // Bremen-Vegesack station
    {Coordinate{33.6089, 56.8567}, CountryId{"RU"}}, // Slavotino
    {Coordinate{33.7602, 56.8632}, CountryId{"RU"}}, // Krasitsy
    {Coordinate{40.6517, 45.3985}, CountryId{"RU"}}, // Q110917523
    {Coordinate{40.6997, 45.3598}, CountryId{"RU"}}, // Q110917524
    {Coordinate{40.7772, 45.296}, CountryId{"RU"}}, // Q110917525
    {Coordinate{40.7995, 45.2768}, CountryId{"RU"}}, // Q110917526
    {Coordinate{40.836, 45.2457}, CountryId{"RU"}}, // Q110917527
    {Coordinate{40.8703, 45.2162}, CountryId{"RU"}}, // Q110917528
    {Coordinate{40.9225, 45.1711}, CountryId{"RU"}}, // Q110917529
    {Coordinate{40.9768, 45.1242}, CountryId{"RU"}}, // Q110917530
    {Coordinate{33.9383, 56.892}, CountryId{"RU"}}, // Brylyovo
    {Coordinate{41.9134, 44.6264}, CountryId{"RU"}}, // Q110917644
    {Coordinate{41.2268, 44.9226}, CountryId{"RU"}}, // Q110930341
    {Coordinate{41.2588, 44.8973}, CountryId{"RU"}}, // Q110930342
    {Coordinate{41.3304, 44.8427}, CountryId{"RU"}}, // Q110930343
    {Coordinate{41.379, 44.8217}, CountryId{"RU"}}, // Q110930344
    {Coordinate{41.4684, 44.791}, CountryId{"RU"}}, // Q110930345
    {Coordinate{41.4887, 44.7848}, CountryId{"RU"}}, // Q110930346
    {Coordinate{41.6037, 44.75}, CountryId{"RU"}}, // Q110930347
    {Coordinate{41.8821, 44.6491}, CountryId{"RU"}}, // Q110930348
    {Coordinate{34.0402, 56.9312}, CountryId{"RU"}}, // Rantsevo
    {Coordinate{41.9143, 44.6118}, CountryId{"RU"}}, // Q110933832
    {Coordinate{41.9256, 44.5771}, CountryId{"RU"}}, // Q110933833
    {Coordinate{41.9245, 44.5343}, CountryId{"RU"}}, // Q110933834
    {Coordinate{41.9203, 44.4891}, CountryId{"RU"}}, // Q110933835
    {Coordinate{41.9141, 44.4396}, CountryId{"RU"}}, // Q110933837
    {Coordinate{41.9364, 44.3964}, CountryId{"RU"}}, // Q110933838
    {Coordinate{41.9597, 44.3756}, CountryId{"RU"}}, // Q110933839
    {Coordinate{42.0246, 44.3144}, CountryId{"RU"}}, // Q110933840
    {Coordinate{42.0379, 44.3018}, CountryId{"RU"}}, // Q110933841
    {Coordinate{42.0154, 44.6278}, CountryId{"RU"}}, // Q110938969
    {Coordinate{42.1557, 44.5894}, CountryId{"RU"}}, // Q110938971
    {Coordinate{42.2114, 44.5754}, CountryId{"RU"}}, // Q110938972
    {Coordinate{42.2757, 44.5579}, CountryId{"RU"}}, // Q110938973
    {Coordinate{42.3617, 44.5096}, CountryId{"RU"}}, // Q110938975
    {Coordinate{42.4663, 44.4666}, CountryId{"RU"}}, // Q110938976
    {Coordinate{42.499, 44.4552}, CountryId{"RU"}}, // Q110938977
    {Coordinate{42.5385, 44.4478}, CountryId{"RU"}}, // Q110938978
    {Coordinate{42.5719, 44.4442}, CountryId{"RU"}}, // Q110938980
    {Coordinate{42.729, 44.4076}, CountryId{"RU"}}, // Q110938981
    {Coordinate{42.7904, 44.3819}, CountryId{"RU"}}, // Q110938982
    {Coordinate{42.9202, 44.3101}, CountryId{"RU"}}, // Q110938983
    {Coordinate{43.0134, 44.2557}, CountryId{"RU"}}, // Q110938986
    {Coordinate{43.0311, 44.2497}, CountryId{"RU"}}, // Q110938987
    {Coordinate{43.0592, 44.2439}, CountryId{"RU"}}, // Q110938988
    {Coordinate{43.0939, 44.231}, CountryId{"RU"}}, // Q110938989
    {Coordinate{34.3041, 57.0104}, CountryId{"RU"}}, // Puzakovo
    {Coordinate{34.6013, 57.0199}, CountryId{"RU"}}, // Shcherbovo
    {Coordinate{39.7002, 47.0996}, CountryId{"RU"}}, // Q110942163
    {Coordinate{39.6581, 47.0918}, CountryId{"RU"}}, // Q110942164
    {Coordinate{39.5544, 47.0737}, CountryId{"RU"}}, // Q110942165
    {Coordinate{39.5087, 47.0722}, CountryId{"RU"}}, // Q110942167
    {Coordinate{39.4644, 47.0872}, CountryId{"RU"}}, // Q110942168
    {Coordinate{39.0523, 46.5092}, CountryId{"RU"}}, // Q110944061
    {Coordinate{39.6404, 47.0352}, CountryId{"RU"}}, // Q110944408
    {Coordinate{39.5696, 46.9918}, CountryId{"RU"}}, // Q110944411
    {Coordinate{39.5453, 46.9691}, CountryId{"RU"}}, // Q110944412
    {Coordinate{39.4685, 46.9304}, CountryId{"RU"}}, // Q110944414
    {Coordinate{39.3134, 46.807}, CountryId{"RU"}}, // Q110944416
    {Coordinate{39.2704, 46.769}, CountryId{"RU"}}, // Q110944418
    {Coordinate{39.2361, 46.726}, CountryId{"RU"}}, // Q110944419
    {Coordinate{39.2271, 46.6784}, CountryId{"RU"}}, // Q110944420
    {Coordinate{39.2502, 46.618}, CountryId{"RU"}}, // Q110944422
    {Coordinate{39.2331, 46.5858}, CountryId{"RU"}}, // Q110944423
    {Coordinate{38.85, 46.574}, CountryId{"RU"}}, // Q110945265
    {Coordinate{38.6599, 46.6198}, CountryId{"RU"}}, // Q110945266
    {Coordinate{38.5071, 46.6375}, CountryId{"RU"}}, // Q110945268
    {Coordinate{38.4486, 46.6428}, CountryId{"RU"}}, // Q110945269
    {Coordinate{38.4074, 46.6512}, CountryId{"RU"}}, // Q110945270
    {Coordinate{38.3431, 46.6613}, CountryId{"RU"}}, // Q110945271
    {Coordinate{38.2996, 46.6886}, CountryId{"RU"}}, // Q110945272
    {Coordinate{38.9585, 46.1527}, CountryId{"RU"}}, // Q110946506
    {Coordinate{38.978, 45.9913}, CountryId{"RU"}}, // Q110946507
    {Coordinate{38.9992, 45.9304}, CountryId{"RU"}}, // Q110946508
    {Coordinate{38.978, 45.5543}, CountryId{"RU"}}, // Q110946745
    {Coordinate{39.0106, 45.2488}, CountryId{"RU"}}, // Q110946747
    {Coordinate{39.0035, 45.1519}, CountryId{"RU"}}, // Q110946749
    {Coordinate{38.9979, 45.1247}, CountryId{"RU"}}, // Q110946750
    {Coordinate{11.2473, 42.4514}, CountryId{"IT"}}, // Orbetello-Monte Argentario railway station
    {Coordinate{34.7422, 57.015}, CountryId{"RU"}}, // Tryasenka
    {Coordinate{34.872, 57.0057}, CountryId{"RU"}}, // Skripkovo
    {Coordinate{38.9073, 44.9103}, CountryId{"RU"}}, // Q110950779
    {Coordinate{38.9412, 44.8949}, CountryId{"RU"}}, // Q110950780
    {Coordinate{38.954, 44.8914}, CountryId{"RU"}}, // Q110950781
    {Coordinate{39.1727, 44.8362}, CountryId{"RU"}}, // Q110950783
    {Coordinate{39.2064, 44.7119}, CountryId{"RU"}}, // Q110950786
    {Coordinate{39.0911, 44.5988}, CountryId{"RU"}}, // Q110950787
    {Coordinate{39.1365, 44.5328}, CountryId{"RU"}}, // Q110950790
    {Coordinate{39.1455, 44.4379}, CountryId{"RU"}}, // Q110950792
    {Coordinate{39.1907, 44.385}, CountryId{"RU"}}, // Q110950794
    {Coordinate{39.2244, 44.2849}, CountryId{"RU"}}, // Q110950798
    {Coordinate{41.8995, 45.1953}, CountryId{"RU"}}, // Q110954211
    {Coordinate{41.8453, 45.2677}, CountryId{"RU"}}, // Q110954212
    {Coordinate{41.3272, 45.4609}, CountryId{"RU"}}, // Q110954213
    {Coordinate{41.0375, 45.4476}, CountryId{"RU"}}, // Q110954214
    {Coordinate{40.9413, 45.4452}, CountryId{"RU"}}, // Q110954215
    {Coordinate{40.8407, 45.4591}, CountryId{"RU"}}, // Q110954216
    {Coordinate{40.6801, 45.4558}, CountryId{"RU"}}, // Q110954217
    {Coordinate{41.9751, 45.1194}, CountryId{"RU"}}, // Q110954367
    {Coordinate{41.9718, 45.0923}, CountryId{"RU"}}, // Q110954368
    {Coordinate{41.9624, 45.0902}, CountryId{"RU"}}, // Q110954369
    {Coordinate{41.9654, 45.0841}, CountryId{"RU"}}, // Q110954370
    {Coordinate{41.9729, 45.0776}, CountryId{"RU"}}, // Q110954371
    {Coordinate{41.9702, 45.0638}, CountryId{"RU"}}, // Q110954372
    {Coordinate{40.4942, 45.4387}, CountryId{"RU"}}, // Q110954983
    {Coordinate{40.4346, 45.425}, CountryId{"RU"}}, // Q110954984
    {Coordinate{40.3027, 45.3961}, CountryId{"RU"}}, // Q110954985
    {Coordinate{40.0411, 45.3568}, CountryId{"RU"}}, // Q110954986
    {Coordinate{39.9192, 45.3115}, CountryId{"RU"}}, // Q110954987
    {Coordinate{39.7972, 45.2643}, CountryId{"RU"}}, // Q110954988
    {Coordinate{39.5584, 45.2124}, CountryId{"RU"}}, // Q110954990
    {Coordinate{39.4715, 45.1649}, CountryId{"RU"}}, // Q110954991
    {Coordinate{39.3794, 45.1143}, CountryId{"RU"}}, // Q110954992
    {Coordinate{39.2564, 45.0741}, CountryId{"RU"}}, // Q110954999
    {Coordinate{39.2171, 45.0618}, CountryId{"RU"}}, // Q110955002
    {Coordinate{39.1231, 45.0448}, CountryId{"RU"}}, // Q110955006
    {Coordinate{38.2194, 45.345}, CountryId{"RU"}}, // Q110963186
    {Coordinate{29.2178, 56.3301}, CountryId{"RU"}}, // Brykanovo
    {Coordinate{37.4355, 45.1206}, CountryId{"RU"}}, // Q110964278
    {Coordinate{37.2872, 45.1888}, CountryId{"RU"}}, // Q110964279
    {Coordinate{37.2872, 45.1888}, CountryId{"RU"}}, // Q110964280
    {Coordinate{37.3282, 45.0348}, CountryId{"RU"}}, // Q110964356
    {Coordinate{43.1409, 44.1944}, CountryId{"RU"}}, // Q110965558
    {Coordinate{43.1334, 44.1735}, CountryId{"RU"}}, // Q110965559
    {Coordinate{43.1256, 44.1391}, CountryId{"RU"}}, // Q110965560
    {Coordinate{43.0828, 44.101}, CountryId{"RU"}}, // Q110965562
    {Coordinate{43.0803, 44.0804}, CountryId{"RU"}}, // Q110965563
    {Coordinate{43.0157, 44.0449}, CountryId{"RU"}}, // Q110965564
    {Coordinate{42.9955, 44.0502}, CountryId{"RU"}}, // Q110965565
    {Coordinate{42.9103, 44.0559}, CountryId{"RU"}}, // Q110965566
    {Coordinate{42.8155, 44.0167}, CountryId{"RU"}}, // Q110965567
    {Coordinate{42.7246, 43.9227}, CountryId{"RU"}}, // Q110965570
    {Coordinate{43.1719, 44.2079}, CountryId{"RU"}}, // Q110965923
    {Coordinate{43.1964, 44.2103}, CountryId{"RU"}}, // Q110965924
    {Coordinate{43.2645, 44.2247}, CountryId{"RU"}}, // Q110965925
    {Coordinate{43.3164, 44.2152}, CountryId{"RU"}}, // Q110965926
    {Coordinate{43.3383, 44.2143}, CountryId{"RU"}}, // Q110965927
    {Coordinate{43.3613, 44.2057}, CountryId{"RU"}}, // Q110965928
    {Coordinate{43.3924, 44.1974}, CountryId{"RU"}}, // Q110965929
    {Coordinate{43.4158, 44.1896}, CountryId{"RU"}}, // Q110965930
    {Coordinate{43.5782, 44.1951}, CountryId{"RU"}}, // Q110966261
    {Coordinate{43.6615, 44.2325}, CountryId{"RU"}}, // Q110966263
    {Coordinate{43.7278, 44.2819}, CountryId{"RU"}}, // Q110966264
    {Coordinate{43.9382, 44.4945}, CountryId{"RU"}}, // Q110966265
    {Coordinate{44.011, 44.5709}, CountryId{"RU"}}, // Q110966266
    {Coordinate{44.0234, 44.6241}, CountryId{"RU"}}, // Q110966267
    {Coordinate{44.0539, 44.6861}, CountryId{"RU"}}, // Q110966269
    {Coordinate{43.5048, 44.136}, CountryId{"RU"}}, // Q110969046
    {Coordinate{43.5511, 44.0941}, CountryId{"RU"}}, // Q110969047
    {Coordinate{43.5783, 44.0241}, CountryId{"RU"}}, // Q110969048
    {Coordinate{43.8389, 43.8427}, CountryId{"RU"}}, // Q110969049
    {Coordinate{44.0821, 43.5908}, CountryId{"RU"}}, // Q110969853
    {Coordinate{44.2059, 43.3463}, CountryId{"RU"}}, // Q110969855
    {Coordinate{44.2173, 43.3267}, CountryId{"RU"}}, // Q110969856
    {Coordinate{44.2928, 43.2673}, CountryId{"RU"}}, // Q110969858
    {Coordinate{44.5486, 43.1771}, CountryId{"RU"}}, // Q110971818
    {Coordinate{44.5717, 43.159}, CountryId{"RU"}}, // Q110971819
    {Coordinate{44.5949, 43.141}, CountryId{"RU"}}, // Q110971820
    {Coordinate{44.6232, 43.1079}, CountryId{"RU"}}, // Q110971821
    {Coordinate{44.6353, 43.1015}, CountryId{"RU"}}, // Q110971822
    {Coordinate{44.6495, 43.0921}, CountryId{"RU"}}, // Q110971823
    {Coordinate{44.667, 43.073}, CountryId{"RU"}}, // Q110971824
    {Coordinate{44.6794, 43.0596}, CountryId{"RU"}}, // Q110971825
    {Coordinate{44.6822, 43.0441}, CountryId{"RU"}}, // Q110971826
    {Coordinate{45.883, 43.3016}, CountryId{"RU"}}, // Q110972857
    {Coordinate{45.9842, 43.3229}, CountryId{"RU"}}, // Q110972859
    {Coordinate{30.034, 56.3538}, CountryId{"RU"}}, // Vydumka
    {Coordinate{12.1043, 47.8663}, CountryId{"DE"}}, // Rosenheim Hochschule station
    {Coordinate{46.3049, 43.3138}, CountryId{"RU"}}, // Q110974944
    {Coordinate{46.6284, 43.2568}, CountryId{"RU"}}, // Q110974945
    {Coordinate{46.719, 43.2499}, CountryId{"RU"}}, // Q110974947
    {Coordinate{12.1267, 47.9269}, CountryId{"DE"}}, // Schechen station
    {Coordinate{12.1362, 47.9884}, CountryId{"DE"}}, // Rott (Inn) station
    {Coordinate{12.1467, 48.0196}, CountryId{"DE"}}, // Ramerberg station
    {Coordinate{13.2994, 52.5303}, CountryId{"DE"}}, // S-Bahnhof Jungfernheide
    {Coordinate{12.2087, 48.107}, CountryId{"DE"}}, // Soyen station
    {Coordinate{46.9025, 43.2023}, CountryId{"RU"}}, // Q110979265
    {Coordinate{46.9347, 43.198}, CountryId{"RU"}}, // Q110979266
    {Coordinate{46.967, 43.1899}, CountryId{"RU"}}, // Q110979267
    {Coordinate{46.9825, 43.1847}, CountryId{"RU"}}, // Q110979268
    {Coordinate{47.0172, 43.173}, CountryId{"RU"}}, // Q110979269
    {Coordinate{47.0553, 43.1602}, CountryId{"RU"}}, // Q110979270
    {Coordinate{47.2866, 43.075}, CountryId{"RU"}}, // Q110979272
    {Coordinate{47.4205, 43.0212}, CountryId{"RU"}}, // Q110979273
    {Coordinate{47.4491, 43.0111}, CountryId{"RU"}}, // Q110979274
    {Coordinate{47.5262, 42.9494}, CountryId{"RU"}}, // Q110979275
    {Coordinate{47.5754, 42.8677}, CountryId{"RU"}}, // Q110979276
    {Coordinate{47.596, 42.8448}, CountryId{"RU"}}, // Q110979277
    {Coordinate{47.7036, 42.6896}, CountryId{"RU"}}, // Q110979278
    {Coordinate{30.2252, 56.3177}, CountryId{"RU"}}, // 500 km
    {Coordinate{30.2925, 56.3177}, CountryId{"RU"}}, // Gushchino
    {Coordinate{30.3845, 56.3232}, CountryId{"RU"}}, // 489 km
    {Coordinate{30.5162, 56.3319}, CountryId{"RU"}}, // 481 km
    {Coordinate{47.9993, 42.3657}, CountryId{"RU"}}, // Q110980187
    {Coordinate{48.0525, 42.2492}, CountryId{"RU"}}, // Q110980188
    {Coordinate{48.0903, 42.1987}, CountryId{"RU"}}, // Q110980190
    {Coordinate{48.1497, 42.1396}, CountryId{"RU"}}, // Q110980191
    {Coordinate{48.2605, 42.1018}, CountryId{"RU"}}, // Q110980194
    {Coordinate{48.2869, 42.0845}, CountryId{"RU"}}, // Q110980195
    {Coordinate{48.298, 42.0717}, CountryId{"RU"}}, // Q110980196
    {Coordinate{48.3271, 42.0227}, CountryId{"RU"}}, // Q110980197
    {Coordinate{48.3308, 41.9988}, CountryId{"RU"}}, // Q110980199
    {Coordinate{48.3313, 41.9864}, CountryId{"RU"}}, // Q110980200
    {Coordinate{48.3481, 41.9363}, CountryId{"RU"}}, // Q110980201
    {Coordinate{48.3677, 41.9076}, CountryId{"RU"}}, // Q110980202
    {Coordinate{48.382, 41.8895}, CountryId{"RU"}}, // Q110980203
    {Coordinate{48.4068, 41.8619}, CountryId{"RU"}}, // Q110980205
    {Coordinate{48.4333, 41.8441}, CountryId{"RU"}}, // Q110980206
    {Coordinate{48.4452, 41.826}, CountryId{"RU"}}, // Q110980207
    {Coordinate{48.509, 41.8136}, CountryId{"RU"}}, // Q110980208
    {Coordinate{48.5186, 41.8057}, CountryId{"RU"}}, // Q110980209
    {Coordinate{12.2982, 48.1475}, CountryId{"DE"}}, // Gars (Inn) station
    {Coordinate{12.3332, 48.1504}, CountryId{"DE"}}, // Mittergars station
    {Coordinate{12.367, 48.1715}, CountryId{"DE"}}, // Jettenbach station
    {Coordinate{12.408, 48.2029}, CountryId{"DE"}}, // Waldkraiburg-Kraiburg station
    {Coordinate{9.57522, 45.1692}, CountryId{"IT"}}, // Ospedaletto Lodigiano railway station
    {Coordinate{40.9566, 44.9724}, CountryId{"RU"}}, // Q110989588
    {Coordinate{40.8465, 44.9518}, CountryId{"RU"}}, // Q110989590
    {Coordinate{40.7335, 44.9342}, CountryId{"RU"}}, // Q110989591
    {Coordinate{40.4204, 44.9004}, CountryId{"RU"}}, // Q110989592
    {Coordinate{40.2674, 44.8968}, CountryId{"RU"}}, // Q110989593
    {Coordinate{40.2272, 44.8885}, CountryId{"RU"}}, // Q110989594
    {Coordinate{40.1948, 44.8784}, CountryId{"RU"}}, // Q110989595
    {Coordinate{39.9583, 44.805}, CountryId{"RU"}}, // Q110989596
    {Coordinate{39.9443, 44.7237}, CountryId{"RU"}}, // Q110989822
    {Coordinate{39.9811, 44.6907}, CountryId{"RU"}}, // Q110989825
    {Coordinate{39.7816, 44.7183}, CountryId{"RU"}}, // Q110990397
    {Coordinate{39.6794, 44.6756}, CountryId{"RU"}}, // Q110990398
    {Coordinate{39.6222, 44.6107}, CountryId{"RU"}}, // Q110990399
    {Coordinate{39.5384, 44.5489}, CountryId{"RU"}}, // Q110990402
    {Coordinate{39.4771, 44.4366}, CountryId{"RU"}}, // Q110990405
    {Coordinate{39.4099, 44.4052}, CountryId{"RU"}}, // Q110990407
    {Coordinate{39.3362, 44.3199}, CountryId{"RU"}}, // Q110990411
    {Coordinate{39.2965, 44.3052}, CountryId{"RU"}}, // Q110990412
    {Coordinate{39.2496, 44.2539}, CountryId{"RU"}}, // Q110990414
    {Coordinate{59.5089, 58.7003}, CountryId{"RU"}}, // Q110991916
    {Coordinate{39.2015, 44.1658}, CountryId{"RU"}}, // Q110996277
    {Coordinate{39.1813, 44.1571}, CountryId{"RU"}}, // Q110996279
    {Coordinate{39.1764, 44.1427}, CountryId{"RU"}}, // Q110996280
    {Coordinate{13.4883, 48.2005}, CountryId{"AT"}}, // Q110997958
    {Coordinate{58.039, 54.9818}, CountryId{"RU"}}, // Q111011359
    {Coordinate{58.0811, 54.9611}, CountryId{"RU"}}, // Q111011360
    {Coordinate{58.1266, 54.9576}, CountryId{"RU"}}, // Q111011362
    {Coordinate{58.1252, 54.937}, CountryId{"RU"}}, // Q111011363
    {Coordinate{58.1561, 54.9374}, CountryId{"RU"}}, // Q111011364
    {Coordinate{58.2579, 54.9378}, CountryId{"RU"}}, // Q111011365
    {Coordinate{58.3888, 54.9087}, CountryId{"RU"}}, // Q111011366
    {Coordinate{58.4672, 54.9724}, CountryId{"RU"}}, // Q111011367
    {Coordinate{58.5596, 55.0373}, CountryId{"RU"}}, // Q111011368
    {Coordinate{58.6352, 55.0616}, CountryId{"RU"}}, // Q111011369
    {Coordinate{58.7198, 55.0926}, CountryId{"RU"}}, // Q111011370
    {Coordinate{58.7566, 55.1013}, CountryId{"RU"}}, // Q111011371
    {Coordinate{58.8593, 55.1259}, CountryId{"RU"}}, // Q111011372
    {Coordinate{59.0079, 55.1907}, CountryId{"RU"}}, // Q111011373
    {Coordinate{59.0527, 55.2065}, CountryId{"RU"}}, // Q111011374
    {Coordinate{59.1038, 55.1766}, CountryId{"RU"}}, // Q111011376
    {Coordinate{60.1338, 55.0238}, CountryId{"RU"}}, // Q111011765
    {Coordinate{59.2055, 55.1673}, CountryId{"RU"}}, // Q111015326
    {Coordinate{59.3105, 55.175}, CountryId{"RU"}}, // Q111015327
    {Coordinate{59.4006, 55.181}, CountryId{"RU"}}, // Q111015328
    {Coordinate{59.444, 55.2193}, CountryId{"RU"}}, // Q111015329
    {Coordinate{59.4964, 55.2243}, CountryId{"RU"}}, // Q111015330
    {Coordinate{59.5318, 55.2069}, CountryId{"RU"}}, // Q111015331
    {Coordinate{59.5801, 55.205}, CountryId{"RU"}}, // Q111015332
    {Coordinate{59.6028, 55.1927}, CountryId{"RU"}}, // Q111015333
    {Coordinate{59.6208, 55.1908}, CountryId{"RU"}}, // Q111015334
    {Coordinate{59.6582, 55.1967}, CountryId{"RU"}}, // Q111015335
    {Coordinate{59.7783, 55.1596}, CountryId{"RU"}}, // Q111015336
    {Coordinate{59.9719, 55.0801}, CountryId{"RU"}}, // Q111015337
    {Coordinate{60.665, 54.9979}, CountryId{"RU"}}, // Q111015338
    {Coordinate{60.7183, 54.9923}, CountryId{"RU"}}, // Q111015339
    {Coordinate{60.8888, 54.9974}, CountryId{"RU"}}, // Q111015340
    {Coordinate{60.9138, 55.0034}, CountryId{"RU"}}, // Q111015341
    {Coordinate{60.965, 55.0081}, CountryId{"RU"}}, // Q111015342
    {Coordinate{61.0123, 55.0153}, CountryId{"RU"}}, // Q111015343
    {Coordinate{61.0501, 55.0224}, CountryId{"RU"}}, // Q111015344
    {Coordinate{61.1358, 55.0076}, CountryId{"RU"}}, // Q111017245
    {Coordinate{61.1689, 54.9493}, CountryId{"RU"}}, // Q111017246
    {Coordinate{61.199, 54.884}, CountryId{"RU"}}, // Q111017248
    {Coordinate{61.1415, 55.0314}, CountryId{"RU"}}, // Q111017510
    {Coordinate{61.293, 55.0584}, CountryId{"RU"}}, // Q111017511
    {Coordinate{61.3349, 55.0869}, CountryId{"RU"}}, // Q111017512
    {Coordinate{61.3519, 55.0936}, CountryId{"RU"}}, // Q111017513
    {Coordinate{61.3666, 55.1035}, CountryId{"RU"}}, // Q111017514
    {Coordinate{61.388, 55.118}, CountryId{"RU"}}, // Q111017515
    {Coordinate{61.3969, 55.124}, CountryId{"RU"}}, // Q111017516
    {Coordinate{61.1239, 55.0264}, CountryId{"RU"}}, // Q111017619
    {Coordinate{61.5178, 55.1566}, CountryId{"RU"}}, // Q111017654
    {Coordinate{61.2752, 54.8628}, CountryId{"RU"}}, // Q111020095
    {Coordinate{61.4023, 55.1229}, CountryId{"RU"}}, // Q111020413
    {Coordinate{61.403, 55.1095}, CountryId{"RU"}}, // Q111020414
    {Coordinate{61.3979, 55.0997}, CountryId{"RU"}}, // Q111020415
    {Coordinate{61.389, 55.0834}, CountryId{"RU"}}, // Q111020416
    {Coordinate{61.3772, 55.0612}, CountryId{"RU"}}, // Q111020417
    {Coordinate{61.2628, 54.845}, CountryId{"RU"}}, // Q111020419
    {Coordinate{61.2467, 54.738}, CountryId{"RU"}}, // Q111021320
    {Coordinate{61.2459, 54.7024}, CountryId{"RU"}}, // Q111021321
    {Coordinate{61.245, 54.6725}, CountryId{"RU"}}, // Q111021322
    {Coordinate{61.2528, 54.6408}, CountryId{"RU"}}, // Q111021323
    {Coordinate{61.307, 54.5301}, CountryId{"RU"}}, // Q111021324
    {Coordinate{61.342, 54.4705}, CountryId{"RU"}}, // Q111021325
    {Coordinate{61.4078, 54.3785}, CountryId{"RU"}}, // Q111021327
    {Coordinate{61.4221, 54.3574}, CountryId{"RU"}}, // Q111021329
    {Coordinate{61.4694, 54.2876}, CountryId{"RU"}}, // Q111021330
    {Coordinate{61.4781, 54.2747}, CountryId{"RU"}}, // Q111021331
    {Coordinate{61.5377, 54.1864}, CountryId{"RU"}}, // Q111021332
    {Coordinate{61.5602, 54.1603}, CountryId{"RU"}}, // Q111021333
    {Coordinate{60.8846, 53.2741}, CountryId{"RU"}}, // Q111021774
    {Coordinate{60.8079, 53.21}, CountryId{"RU"}}, // Q111021775
    {Coordinate{58.5645, 51.2485}, CountryId{"RU"}}, // Q111022132
    {Coordinate{60.5038, 52.7106}, CountryId{"RU"}}, // Q111022278
    {Coordinate{60.3436, 52.4109}, CountryId{"RU"}}, // Q111022279
    {Coordinate{60.0321, 52.083}, CountryId{"RU"}}, // Q111022280
    {Coordinate{59.9046, 51.9671}, CountryId{"RU"}}, // Q111022281
    {Coordinate{59.7649, 51.8176}, CountryId{"RU"}}, // Q111022282
    {Coordinate{59.7649, 51.8176}, CountryId{"RU"}}, // Q111022283
    {Coordinate{59.5657, 51.6986}, CountryId{"RU"}}, // Q111022284
    {Coordinate{59.534, 51.6416}, CountryId{"RU"}}, // Q111022285
    {Coordinate{59.5053, 51.5994}, CountryId{"RU"}}, // Q111022286
    {Coordinate{59.1511, 51.4076}, CountryId{"RU"}}, // Q111022287
    {Coordinate{59.0307, 51.3632}, CountryId{"RU"}}, // Q111022288
    {Coordinate{58.8794, 51.3151}, CountryId{"RU"}}, // Q111022289
    {Coordinate{58.7934, 51.2692}, CountryId{"RU"}}, // Q111022290
    {Coordinate{13.2344, 47.9971}, CountryId{"AT"}}, // Q111022460
    {Coordinate{13.1288, 48.1917}, CountryId{"AT"}}, // Q111022559
    {Coordinate{13.1803, 48.0731}, CountryId{"AT"}}, // Q111022566
    {Coordinate{33.9892, 60.8377}, CountryId{"RU"}}, // Yandeba
    {Coordinate{55.0864, 51.8176}, CountryId{"RU"}}, // Q111023101
    {Coordinate{55.1098, 51.8337}, CountryId{"RU"}}, // Q111023102
    {Coordinate{55.1262, 51.845}, CountryId{"RU"}}, // Q111023103
    {Coordinate{55.215, 51.905}, CountryId{"RU"}}, // Q111023104
    {Coordinate{55.2821, 51.9365}, CountryId{"RU"}}, // Q111023105
    {Coordinate{55.2946, 51.9416}, CountryId{"RU"}}, // Q111023106
    {Coordinate{55.3189, 51.9407}, CountryId{"RU"}}, // Q111023107
    {Coordinate{55.3466, 51.9475}, CountryId{"RU"}}, // Q111023108
    {Coordinate{33.8302, 60.7674}, CountryId{"RU"}}, // Tenikonda
    {Coordinate{33.7132, 60.7497}, CountryId{"RU"}}, // Yanega
    {Coordinate{33.4362, 60.6895}, CountryId{"RU"}}, // Shamoksha
    {Coordinate{55.3797, 51.9612}, CountryId{"RU"}}, // Q111038694
    {Coordinate{55.4088, 51.9684}, CountryId{"RU"}}, // Q111038695
    {Coordinate{55.4504, 51.9673}, CountryId{"RU"}}, // Q111038697
    {Coordinate{55.5247, 51.9583}, CountryId{"RU"}}, // Q111038698
    {Coordinate{55.6992, 51.9408}, CountryId{"RU"}}, // Q111038699
    {Coordinate{55.7995, 51.9312}, CountryId{"RU"}}, // Q111038700
    {Coordinate{55.9978, 51.8796}, CountryId{"RU"}}, // Q111038701
    {Coordinate{56.0397, 51.8713}, CountryId{"RU"}}, // Q111038702
    {Coordinate{56.1087, 51.858}, CountryId{"RU"}}, // Q111038704
    {Coordinate{56.1445, 51.8474}, CountryId{"RU"}}, // Q111038705
    {Coordinate{56.173, 51.8412}, CountryId{"RU"}}, // Q111038706
    {Coordinate{56.2298, 51.8269}, CountryId{"RU"}}, // Q111038707
    {Coordinate{56.2912, 51.8049}, CountryId{"RU"}}, // Q111038708
    {Coordinate{56.356, 51.7775}, CountryId{"RU"}}, // Q111038709
    {Coordinate{56.4192, 51.747}, CountryId{"RU"}}, // Q111038710
    {Coordinate{56.5973, 51.6146}, CountryId{"RU"}}, // Q111038711
    {Coordinate{56.6896, 51.5192}, CountryId{"RU"}}, // Q111038712
    {Coordinate{56.8406, 51.5274}, CountryId{"RU"}}, // Q111038713
    {Coordinate{56.8923, 51.5338}, CountryId{"RU"}}, // Q111038715
    {Coordinate{56.9593, 51.5222}, CountryId{"RU"}}, // Q111038716
    {Coordinate{57.0485, 51.5215}, CountryId{"RU"}}, // Q111038717
    {Coordinate{57.0992, 51.522}, CountryId{"RU"}}, // Q111038719
    {Coordinate{57.1618, 51.4955}, CountryId{"RU"}}, // Q111038720
    {Coordinate{57.2244, 51.4811}, CountryId{"RU"}}, // Q111038721
    {Coordinate{57.3161, 51.4765}, CountryId{"RU"}}, // Q111038722
    {Coordinate{57.3499, 51.475}, CountryId{"RU"}}, // Q111038723
    {Coordinate{57.3707, 51.4682}, CountryId{"RU"}}, // Q111038724
    {Coordinate{57.4476, 51.3922}, CountryId{"RU"}}, // Q111038725
    {Coordinate{57.4627, 51.3866}, CountryId{"RU"}}, // Q111038726
    {Coordinate{57.5237, 51.3731}, CountryId{"RU"}}, // Q111038727
    {Coordinate{57.5859, 51.4063}, CountryId{"RU"}}, // Q111038728
    {Coordinate{57.6054, 51.3983}, CountryId{"RU"}}, // Q111038729
    {Coordinate{57.6292, 51.3919}, CountryId{"RU"}}, // Q111038730
    {Coordinate{57.6541, 51.3941}, CountryId{"RU"}}, // Q111038731
    {Coordinate{57.7161, 51.3966}, CountryId{"RU"}}, // Q111038732
    {Coordinate{57.8295, 51.4539}, CountryId{"RU"}}, // Q111038734
    {Coordinate{57.9084, 51.4676}, CountryId{"RU"}}, // Q111038735
    {Coordinate{58.1275, 51.3995}, CountryId{"RU"}}, // Q111038736
    {Coordinate{58.1803, 51.2858}, CountryId{"RU"}}, // Q111038737
    {Coordinate{58.2526, 51.2821}, CountryId{"RU"}}, // Q111038738
    {Coordinate{58.3403, 51.2023}, CountryId{"RU"}}, // Q111038739
    {Coordinate{58.4294, 51.2037}, CountryId{"RU"}}, // Q111038740
    {Coordinate{58.494, 51.2167}, CountryId{"RU"}}, // Q111038741
    {Coordinate{60.8836, 50.8308}, CountryId{"RU"}}, // Q111040908
    {Coordinate{14.0364, 48.5206}, CountryId{"AT"}}, // Q111044667
    {Coordinate{10.8176, 47.2158}, CountryId{"AT"}}, // Q111044668
    {Coordinate{10.7181, 47.514}, CountryId{"AT"}}, // Q111044669
    {Coordinate{33.0472, 60.3963}, CountryId{"RU"}}, // Pasha
    {Coordinate{11.0957, 47.302}, CountryId{"AT"}}, // Q111044830
    {Coordinate{11.1707, 47.2813}, CountryId{"AT"}}, // Q111044831
    {Coordinate{11.677, 47.3239}, CountryId{"AT"}}, // Q111044832
    {Coordinate{10.8904, 47.2534}, CountryId{"AT"}}, // Q111044833
    {Coordinate{11.7268, 47.3655}, CountryId{"AT"}}, // Q111044834
    {Coordinate{11.1431, 47.289}, CountryId{"AT"}}, // Q111044835
    {Coordinate{11.3531, 47.2691}, CountryId{"AT"}}, // Q111044837
    {Coordinate{11.2371, 47.3753}, CountryId{"AT"}}, // Q111044838
    {Coordinate{12.1093, 47.5458}, CountryId{"AT"}}, // Q111044839
    {Coordinate{11.5634, 47.2957}, CountryId{"AT"}}, // Q111044840
    {Coordinate{11.6345, 47.316}, CountryId{"AT"}}, // Q111044841
    {Coordinate{11.1987, 47.278}, CountryId{"AT"}}, // Q111044842
    {Coordinate{10.96, 47.2752}, CountryId{"AT"}}, // Q111044843
    {Coordinate{11.4744, 47.2771}, CountryId{"AT"}}, // Hall in Tirol-Thaur railway station
    {Coordinate{11.8519, 47.3627}, CountryId{"AT"}}, // Q111044845
    {Coordinate{12.1253, 47.5588}, CountryId{"AT"}}, // Q111044846
    {Coordinate{12.1077, 47.4873}, CountryId{"AT"}}, // Q111044852
    {Coordinate{12.4811, 47.2836}, CountryId{"AT"}}, // Q111044854
    {Coordinate{11.82, 47.4034}, CountryId{"AT"}}, // Q111044856
    {Coordinate{12.7931, 46.8271}, CountryId{"AT"}}, // Q111044940
    {Coordinate{10.7484, 47.4423}, CountryId{"AT"}}, // Q111044941
    {Coordinate{12.4658, 46.7468}, CountryId{"AT"}}, // Q111044942
    {Coordinate{10.7765, 47.4277}, CountryId{"AT"}}, // Q111044943
    {Coordinate{10.7249, 47.4897}, CountryId{"AT"}}, // Q111044944
    {Coordinate{12.3908, 47.4973}, CountryId{"AT"}}, // Q111044945
    {Coordinate{12.1867, 47.4389}, CountryId{"AT"}}, // Q111044946
    {Coordinate{12.5807, 47.4685}, CountryId{"AT"}}, // Q111044947
    {Coordinate{12.529, 47.4912}, CountryId{"AT"}}, // Q111044949
    {Coordinate{10.8335, 47.4197}, CountryId{"AT"}}, // Q111045645
    {Coordinate{12.895, 46.7792}, CountryId{"AT"}}, // Q111045646
    {Coordinate{12.8273, 47.3902}, CountryId{"AT"}}, // Q111045647
    {Coordinate{12.8906, 47.288}, CountryId{"AT"}}, // Q111045648
    {Coordinate{12.7685, 47.4449}, CountryId{"AT"}}, // Q111045649
    {Coordinate{12.8103, 47.3587}, CountryId{"AT"}}, // Q111045650
    {Coordinate{12.9474, 47.2928}, CountryId{"AT"}}, // Q111045651
    {Coordinate{12.8296, 47.4269}, CountryId{"AT"}}, // train station Saalfelden
    {Coordinate{12.8289, 47.2846}, CountryId{"AT"}}, // Q111045654
    {Coordinate{12.7965, 47.3205}, CountryId{"AT"}}, // Q111045655
    {Coordinate{13.0913, 47.8578}, CountryId{"AT"}}, // Q111045736
    {Coordinate{12.9441, 47.9415}, CountryId{"AT"}}, // Q111045737
    {Coordinate{13.1952, 47.4729}, CountryId{"AT"}}, // train station Werfen
    {Coordinate{13.0804, 47.7609}, CountryId{"AT"}}, // Q111045739
    {Coordinate{13.1593, 47.9192}, CountryId{"AT"}}, // Q111045741
    {Coordinate{13.1416, 47.6257}, CountryId{"AT"}}, // Q111045742
    {Coordinate{12.6707, 46.7841}, CountryId{"AT"}}, // train station Thal/Drau
    {Coordinate{13.0414, 47.8187}, CountryId{"AT"}}, // Q111045744
    {Coordinate{13.2596, 46.7526}, CountryId{"AT"}}, // Q111045745
    {Coordinate{13.1909, 46.7412}, CountryId{"AT"}}, // Q111045748
    {Coordinate{13.0368, 47.8266}, CountryId{"AT"}}, // Q111045749
    {Coordinate{13.2645, 47.9721}, CountryId{"AT"}}, // Q111045750
    {Coordinate{13.1302, 47.8995}, CountryId{"AT"}}, // Q111045751
    {Coordinate{13.0212, 47.8391}, CountryId{"AT"}}, // Q111045752
    {Coordinate{13.1761, 46.9816}, CountryId{"AT"}}, // train station Mallnitz-Obervellach
    {Coordinate{13.3218, 46.8783}, CountryId{"AT"}}, // Q111045755
    {Coordinate{13.367, 46.8514}, CountryId{"AT"}}, // Q111045756
    {Coordinate{13.1997, 47.4614}, CountryId{"AT"}}, // train station Pfarrwerfen
    {Coordinate{13.4368, 46.6317}, CountryId{"AT"}}, // Q111045841
    {Coordinate{13.4221, 48.37}, CountryId{"AT"}}, // Q111045842
    {Coordinate{13.4293, 47.3822}, CountryId{"AT"}}, // Q111045843
    {Coordinate{13.4326, 47.9831}, CountryId{"AT"}}, // Q111045844
    {Coordinate{13.4426, 48.4635}, CountryId{"AT"}}, // Q111045845
    {Coordinate{58.8294, 51.2115}, CountryId{"RU"}}, // Q111045859
    {Coordinate{59.1082, 51.0692}, CountryId{"RU"}}, // Q111045861
    {Coordinate{59.1137, 51.0525}, CountryId{"RU"}}, // Q111045862
    {Coordinate{59.345, 50.8715}, CountryId{"RU"}}, // Q111045865
    {Coordinate{59.5293, 50.7748}, CountryId{"RU"}}, // Q111045866
    {Coordinate{59.7269, 50.8252}, CountryId{"RU"}}, // Q111045867
    {Coordinate{59.7721, 50.8193}, CountryId{"RU"}}, // Q111045868
    {Coordinate{60.465, 50.8513}, CountryId{"RU"}}, // Q111045869
    {Coordinate{59.0757, 51.1559}, CountryId{"RU"}}, // Q111045892
    {Coordinate{60.7152, 50.8498}, CountryId{"RU"}}, // Q111045894
    {Coordinate{60.8518, 50.831}, CountryId{"RU"}}, // Q111045895
    {Coordinate{58.474, 53.9334}, CountryId{"RU"}}, // Q111062330
    {Coordinate{58.5682, 53.9762}, CountryId{"RU"}}, // Q111062332
    {Coordinate{58.6453, 53.8115}, CountryId{"RU"}}, // Q111062334
    {Coordinate{58.8006, 53.6411}, CountryId{"RU"}}, // Q111062337
    {Coordinate{58.9055, 53.5856}, CountryId{"RU"}}, // Q111062339
    {Coordinate{59.0042, 53.4823}, CountryId{"RU"}}, // Q111062341
    {Coordinate{59.0777, 53.4618}, CountryId{"RU"}}, // Q111062345
    {Coordinate{59.0991, 53.4732}, CountryId{"RU"}}, // Q111062348
    {Coordinate{59.1934, 53.45}, CountryId{"RU"}}, // Q111062349
    {Coordinate{59.2611, 53.4557}, CountryId{"RU"}}, // Q111062351
    {Coordinate{59.3026, 53.3971}, CountryId{"RU"}}, // Burannaya
    {Coordinate{59.4389, 53.3289}, CountryId{"RU"}}, // Gumbeyka
    {Coordinate{59.5178, 53.2977}, CountryId{"RU"}}, // Q111062357
    {Coordinate{59.5701, 53.2381}, CountryId{"RU"}}, // Q111062359
    {Coordinate{59.7498, 53.2003}, CountryId{"RU"}}, // Q111062363
    {Coordinate{59.8776, 53.1977}, CountryId{"RU"}}, // Q111062365
    {Coordinate{59.9647, 53.1639}, CountryId{"RU"}}, // Q111062367
    {Coordinate{60.0383, 53.1101}, CountryId{"RU"}}, // Q111062368
    {Coordinate{60.1426, 53.1264}, CountryId{"RU"}}, // Q111062371
    {Coordinate{60.2352, 53.1052}, CountryId{"RU"}}, // Q111062373
    {Coordinate{60.3735, 53.1151}, CountryId{"RU"}}, // Q111062375
    {Coordinate{60.5385, 53.0672}, CountryId{"RU"}}, // Q111062379
    {Coordinate{60.5814, 53.0526}, CountryId{"RU"}}, // Q111062381
    {Coordinate{58.9869, 53.475}, CountryId{"RU"}}, // Q111065580
    {Coordinate{58.9815, 53.4383}, CountryId{"RU"}}, // Q111065582
    {Coordinate{58.7664, 53.0135}, CountryId{"RU"}}, // Q111065589
    {Coordinate{52.3578, 52.6766}, CountryId{"RU"}}, // Q111067806
    {Coordinate{50.7732, 53.1947}, CountryId{"RU"}}, // Q111070358
    {Coordinate{50.8894, 53.1595}, CountryId{"RU"}}, // Q111070360
    {Coordinate{51.0843, 53.1207}, CountryId{"RU"}}, // Q111070362
    {Coordinate{51.1662, 53.1061}, CountryId{"RU"}}, // Q111070365
    {Coordinate{51.3255, 53.0668}, CountryId{"RU"}}, // Q111070367
    {Coordinate{51.3649, 53.0782}, CountryId{"RU"}}, // Q111070369
    {Coordinate{51.5443, 53.0631}, CountryId{"RU"}}, // Q111070373
    {Coordinate{51.5905, 53.06}, CountryId{"RU"}}, // Q111070375
    {Coordinate{51.7125, 53.041}, CountryId{"RU"}}, // Q111070376
    {Coordinate{51.8686, 53.0294}, CountryId{"RU"}}, // Q111070378
    {Coordinate{51.9539, 52.9854}, CountryId{"RU"}}, // Q111070381
    {Coordinate{52.0285, 52.9387}, CountryId{"RU"}}, // Q111070383
    {Coordinate{52.066, 52.8706}, CountryId{"RU"}}, // Q111070385
    {Coordinate{52.1287, 52.8365}, CountryId{"RU"}}, // Q111070387
    {Coordinate{52.2706, 52.7686}, CountryId{"RU"}}, // Q111070389
    {Coordinate{32.9508, 60.3241}, CountryId{"RU"}}, // Iyevkovo
    {Coordinate{32.8695, 60.2969}, CountryId{"RU"}}, // Sidorovo
    {Coordinate{52.4916, 52.6161}, CountryId{"RU"}}, // Q111082836
    {Coordinate{52.618, 52.568}, CountryId{"RU"}}, // Q111082838
    {Coordinate{52.8166, 52.5075}, CountryId{"RU"}}, // Q111082840
    {Coordinate{52.9818, 52.5013}, CountryId{"RU"}}, // Q111082842
    {Coordinate{53.0171, 52.4988}, CountryId{"RU"}}, // Q111082843
    {Coordinate{53.1486, 52.4284}, CountryId{"RU"}}, // Q111082844
    {Coordinate{53.2082, 52.3955}, CountryId{"RU"}}, // Q111082845
    {Coordinate{53.234, 52.3889}, CountryId{"RU"}}, // Q111082846
    {Coordinate{53.3274, 52.3292}, CountryId{"RU"}}, // Q111082847
    {Coordinate{53.3691, 52.3032}, CountryId{"RU"}}, // Q111082848
    {Coordinate{53.4231, 52.2665}, CountryId{"RU"}}, // Q111082849
    {Coordinate{53.4931, 52.1867}, CountryId{"RU"}}, // Q111082851
    {Coordinate{53.5178, 52.1677}, CountryId{"RU"}}, // Q111082852
    {Coordinate{53.6445, 52.0808}, CountryId{"RU"}}, // Q111082853
    {Coordinate{53.7221, 52.033}, CountryId{"RU"}}, // Q111082854
    {Coordinate{53.8034, 52.0063}, CountryId{"RU"}}, // Q111082855
    {Coordinate{53.867, 51.9881}, CountryId{"RU"}}, // Q111082856
    {Coordinate{53.9091, 51.9712}, CountryId{"RU"}}, // Q111082857
    {Coordinate{53.9808, 51.9389}, CountryId{"RU"}}, // Q111082859
    {Coordinate{54.0425, 51.9169}, CountryId{"RU"}}, // Q111082860
    {Coordinate{54.1827, 51.8753}, CountryId{"RU"}}, // Q111082862
    {Coordinate{54.2116, 51.8671}, CountryId{"RU"}}, // Q111082863
    {Coordinate{54.4136, 51.8572}, CountryId{"RU"}}, // Q111082864
    {Coordinate{54.5222, 51.8705}, CountryId{"RU"}}, // Q111082865
    {Coordinate{54.8628, 51.8881}, CountryId{"RU"}}, // Q111082866
    {Coordinate{54.9233, 51.8836}, CountryId{"RU"}}, // Q111082867
    {Coordinate{54.9559, 51.8722}, CountryId{"RU"}}, // Q111082868
    {Coordinate{55.0158, 51.8503}, CountryId{"RU"}}, // Q111082869
    {Coordinate{55.0609, 51.8237}, CountryId{"RU"}}, // Q111082870
    {Coordinate{52.742, 52.5179}, CountryId{"RU"}}, // Q111082905
    {Coordinate{52.8983, 52.5184}, CountryId{"RU"}}, // Q111082906
    {Coordinate{54.986, 51.1712}, CountryId{"RU"}}, // Q111083087
    {Coordinate{32.804, 60.2407}, CountryId{"RU"}}, // Yugi
    {Coordinate{32.6925, 60.1499}, CountryId{"RU"}}, // Telzhevo
    {Coordinate{55.0892, 51.7187}, CountryId{"RU"}}, // Q111083135
    {Coordinate{55.0352, 51.6586}, CountryId{"RU"}}, // Q111083136
    {Coordinate{55.0206, 51.5955}, CountryId{"RU"}}, // Q111083137
    {Coordinate{55.0084, 51.5342}, CountryId{"RU"}}, // Q111083138
    {Coordinate{54.9586, 51.3245}, CountryId{"RU"}}, // Q111083139
    {Coordinate{54.9064, 51.2788}, CountryId{"RU"}}, // Q111083140
    {Coordinate{54.9089, 51.214}, CountryId{"RU"}}, // Q111083141
    {Coordinate{51.5681, 52.1975}, CountryId{"RU"}}, // Q111095288
    {Coordinate{52.0552, 52.5097}, CountryId{"RU"}}, // Q111095290
    {Coordinate{61.8991, 56.1222}, CountryId{"RU"}}, // Q111095503
    {Coordinate{61.87, 56.0804}, CountryId{"RU"}}, // Q111108316
    {Coordinate{61.8399, 56.0367}, CountryId{"RU"}}, // Q111108317
    {Coordinate{61.8192, 56.0066}, CountryId{"RU"}}, // Q111108318
    {Coordinate{61.8057, 55.9867}, CountryId{"RU"}}, // Q111108319
    {Coordinate{61.7647, 55.9269}, CountryId{"RU"}}, // Q111108320
    {Coordinate{61.7398, 55.89}, CountryId{"RU"}}, // Q111108322
    {Coordinate{61.6947, 55.8253}, CountryId{"RU"}}, // Q111108323
    {Coordinate{61.6576, 55.7766}, CountryId{"RU"}}, // Q111108325
    {Coordinate{61.6237, 55.6761}, CountryId{"RU"}}, // Q111108327
    {Coordinate{61.5971, 55.5853}, CountryId{"RU"}}, // Q111108329
    {Coordinate{61.6002, 55.4817}, CountryId{"RU"}}, // Q111108331
    {Coordinate{61.6011, 55.4321}, CountryId{"RU"}}, // Q111108332
    {Coordinate{61.5846, 55.3979}, CountryId{"RU"}}, // Q111108334
    {Coordinate{61.5571, 55.336}, CountryId{"RU"}}, // Q111108336
    {Coordinate{61.5457, 55.3147}, CountryId{"RU"}}, // Q111108338
    {Coordinate{61.5492, 55.2976}, CountryId{"RU"}}, // Q111108339
    {Coordinate{61.5552, 55.2312}, CountryId{"RU"}}, // Q111108341
    {Coordinate{61.5557, 55.2186}, CountryId{"RU"}}, // Q111108343
    {Coordinate{11.1054, 47.9641}, CountryId{"DE"}}, // St. Alban station
    {Coordinate{61.6217, 55.184}, CountryId{"RU"}}, // Q111130868
    {Coordinate{61.7015, 55.193}, CountryId{"RU"}}, // Q111130869
    {Coordinate{61.7311, 55.1991}, CountryId{"RU"}}, // Q111130870
    {Coordinate{61.8005, 55.2113}, CountryId{"RU"}}, // Q111130872
    {Coordinate{61.8388, 55.2149}, CountryId{"RU"}}, // Q111130873
    {Coordinate{61.8768, 55.2184}, CountryId{"RU"}}, // Q111130874
    {Coordinate{61.9343, 55.2182}, CountryId{"RU"}}, // Q111130875
    {Coordinate{61.9818, 55.2132}, CountryId{"RU"}}, // Q111130876
    {Coordinate{62.0608, 55.2046}, CountryId{"RU"}}, // Q111130878
    {Coordinate{62.1002, 55.2021}, CountryId{"RU"}}, // Q111130879
    {Coordinate{62.2406, 55.2051}, CountryId{"RU"}}, // Q111130880
    {Coordinate{62.3874, 55.2054}, CountryId{"RU"}}, // Q111130882
    {Coordinate{62.5178, 55.2081}, CountryId{"RU"}}, // Q111130883
    {Coordinate{62.6356, 55.2019}, CountryId{"RU"}}, // Q111130884
    {Coordinate{62.8972, 55.2074}, CountryId{"RU"}}, // Q111130885
    {Coordinate{62.9632, 55.2095}, CountryId{"RU"}}, // Q111130886
    {Coordinate{63.0584, 55.2157}, CountryId{"RU"}}, // Q111130887
    {Coordinate{63.2233, 55.2138}, CountryId{"RU"}}, // Q111130888
    {Coordinate{63.4919, 55.2685}, CountryId{"RU"}}, // Q111130889
    {Coordinate{63.6065, 55.2938}, CountryId{"RU"}}, // Q111130890
    {Coordinate{63.9161, 55.3314}, CountryId{"RU"}}, // Q111130891
    {Coordinate{64.0764, 55.3463}, CountryId{"RU"}}, // Q111130892
    {Coordinate{64.1296, 55.3491}, CountryId{"RU"}}, // Q111130893
    {Coordinate{64.4575, 55.3697}, CountryId{"RU"}}, // Q111130895
    {Coordinate{64.6463, 55.3855}, CountryId{"RU"}}, // Q111130896
    {Coordinate{64.7518, 55.3926}, CountryId{"RU"}}, // Q111130897
    {Coordinate{64.9544, 55.4253}, CountryId{"RU"}}, // Q111130899
    {Coordinate{65.0232, 55.4312}, CountryId{"RU"}}, // Q111130901
    {Coordinate{65.1155, 55.4264}, CountryId{"RU"}}, // Q111130902
    {Coordinate{61.7716, 55.2076}, CountryId{"RU"}}, // Q111130908
    {Coordinate{62.0262, 55.2072}, CountryId{"RU"}}, // Q111130909
    {Coordinate{64.4204, 55.3669}, CountryId{"RU"}}, // Q111130910
    {Coordinate{65.1367, 55.4276}, CountryId{"RU"}}, // Q111130912
    {Coordinate{64.9142, 55.4111}, CountryId{"RU"}}, // Q111130914
    {Coordinate{65.3353, 55.4465}, CountryId{"RU"}}, // Q111145035
    {Coordinate{65.4202, 55.4355}, CountryId{"RU"}}, // Q111145036
    {Coordinate{65.4304, 55.4118}, CountryId{"RU"}}, // Q111145037
    {Coordinate{65.4443, 55.3967}, CountryId{"RU"}}, // Q111145038
    {Coordinate{65.5533, 55.4053}, CountryId{"RU"}}, // Q111145040
    {Coordinate{65.5765, 55.4075}, CountryId{"RU"}}, // Q111145041
    {Coordinate{65.6052, 55.415}, CountryId{"RU"}}, // Q111145042
    {Coordinate{65.641, 55.4}, CountryId{"RU"}}, // Q111145043
    {Coordinate{65.6721, 55.3895}, CountryId{"RU"}}, // Q111145044
    {Coordinate{65.7185, 55.3842}, CountryId{"RU"}}, // Q111145046
    {Coordinate{65.9672, 55.3573}, CountryId{"RU"}}, // Q111145047
    {Coordinate{66.1157, 55.3251}, CountryId{"RU"}}, // Q111145049
    {Coordinate{66.2215, 55.3009}, CountryId{"RU"}}, // Q111145050
    {Coordinate{66.2928, 55.2906}, CountryId{"RU"}}, // Q111145052
    {Coordinate{66.3435, 55.2806}, CountryId{"RU"}}, // Q111145053
    {Coordinate{66.4899, 55.2674}, CountryId{"RU"}}, // Q111145055
    {Coordinate{66.747, 55.2605}, CountryId{"RU"}}, // Q111145056
    {Coordinate{66.9589, 55.2587}, CountryId{"RU"}}, // Q111145059
    {Coordinate{67.2187, 55.2223}, CountryId{"RU"}}, // Q111145060
    {Coordinate{67.2609, 55.2164}, CountryId{"RU"}}, // Q111145061
    {Coordinate{67.4402, 55.1796}, CountryId{"RU"}}, // Q111145063
    {Coordinate{67.5686, 55.1359}, CountryId{"RU"}}, // Q111145064
    {Coordinate{67.5686, 55.1359}, CountryId{"RU"}}, // Q111145066
    {Coordinate{67.7985, 55.0894}, CountryId{"RU"}}, // Q111145067
    {Coordinate{67.9337, 55.0623}, CountryId{"RU"}}, // Q111145069
    {Coordinate{68.049, 55.039}, CountryId{"RU"}}, // Q111145070
    {Coordinate{68.1903, 55.0102}, CountryId{"RU"}}, // Q111145072
    {Coordinate{60.3119, 56.4397}, CountryId{"RU"}}, // Q111145475
    {Coordinate{32.6528, 60.1168}, CountryId{"RU"}}, // Lungachi
    {Coordinate{32.6008, 60.0444}, CountryId{"RU"}}, // Kolchanovo
    {Coordinate{32.561, 60.0128}, CountryId{"RU"}}, // Khamontovo
    {Coordinate{7.45468, 51.6934}, CountryId{"DE"}}, // Selm-Beifang railway station
    {Coordinate{60.2761, 56.2987}, CountryId{"RU"}}, // Q111154067
    {Coordinate{60.2386, 56.2282}, CountryId{"RU"}}, // Q111154068
    {Coordinate{60.1861, 56.1631}, CountryId{"RU"}}, // Q111154069
    {Coordinate{60.2286, 56.1313}, CountryId{"RU"}}, // Q111154070
    {Coordinate{60.2473, 56.1147}, CountryId{"RU"}}, // Q111154071
    {Coordinate{60.2447, 56.0639}, CountryId{"RU"}}, // Q111154072
    {Coordinate{60.3289, 56.0457}, CountryId{"RU"}}, // Q111154074
    {Coordinate{60.3908, 56.0173}, CountryId{"RU"}}, // Q111154075
    {Coordinate{60.4272, 55.9914}, CountryId{"RU"}}, // Q111154076
    {Coordinate{60.4667, 55.8485}, CountryId{"RU"}}, // Q111154077
    {Coordinate{60.4694, 55.8227}, CountryId{"RU"}}, // Q111154078
    {Coordinate{60.4867, 55.7615}, CountryId{"RU"}}, // Q111154079
    {Coordinate{60.6453, 55.6664}, CountryId{"RU"}}, // Q111154080
    {Coordinate{60.7285, 55.5941}, CountryId{"RU"}}, // Q111154081
    {Coordinate{60.7634, 55.5621}, CountryId{"RU"}}, // Q111154082
    {Coordinate{60.8036, 55.5282}, CountryId{"RU"}}, // Q111154083
    {Coordinate{60.8724, 55.4878}, CountryId{"RU"}}, // Q111154084
    {Coordinate{60.9211, 55.4575}, CountryId{"RU"}}, // Q111154085
    {Coordinate{60.9979, 55.4098}, CountryId{"RU"}}, // Q111154086
    {Coordinate{61.1089, 55.3393}, CountryId{"RU"}}, // Q111154088
    {Coordinate{61.2074, 55.2967}, CountryId{"RU"}}, // Q111154089
    {Coordinate{61.2398, 55.2741}, CountryId{"RU"}}, // Q111154090
    {Coordinate{61.2887, 55.2367}, CountryId{"RU"}}, // Q111154091
    {Coordinate{61.3306, 55.2064}, CountryId{"RU"}}, // Q111154092
    {Coordinate{61.373, 55.1974}, CountryId{"RU"}}, // Q111154093
    {Coordinate{61.4056, 55.199}, CountryId{"RU"}}, // Q111154094
    {Coordinate{61.4198, 55.1784}, CountryId{"RU"}}, // Q111154095
    {Coordinate{61.4281, 55.1675}, CountryId{"RU"}}, // Q111154096
    {Coordinate{62.2114, 56.3828}, CountryId{"RU"}}, // Q111154417
    {Coordinate{62.3147, 56.3806}, CountryId{"RU"}}, // Q111154633
    {Coordinate{62.4777, 56.3387}, CountryId{"RU"}}, // Q111154634
    {Coordinate{62.5961, 56.2886}, CountryId{"RU"}}, // Q111154635
    {Coordinate{62.6694, 56.2822}, CountryId{"RU"}}, // Q111154636
    {Coordinate{62.7961, 56.2773}, CountryId{"RU"}}, // Q111154637
    {Coordinate{62.9382, 56.2633}, CountryId{"RU"}}, // Q111154638
    {Coordinate{63.0691, 56.2394}, CountryId{"RU"}}, // Q111154639
    {Coordinate{63.129, 56.2222}, CountryId{"RU"}}, // Q111154640
    {Coordinate{63.2025, 56.203}, CountryId{"RU"}}, // Q111154641
    {Coordinate{63.2702, 56.1865}, CountryId{"RU"}}, // Q111154642
    {Coordinate{63.3499, 56.1624}, CountryId{"RU"}}, // Q111154643
    {Coordinate{63.4148, 56.1431}, CountryId{"RU"}}, // Q111154644
    {Coordinate{63.453, 56.1357}, CountryId{"RU"}}, // Q111154645
    {Coordinate{63.5374, 56.1139}, CountryId{"RU"}}, // Q111154646
    {Coordinate{63.6694, 56.0962}, CountryId{"RU"}}, // Q111154647
    {Coordinate{63.7273, 56.0726}, CountryId{"RU"}}, // Q111154649
    {Coordinate{63.7853, 56.0557}, CountryId{"RU"}}, // Q111154650
    {Coordinate{63.8222, 56.0463}, CountryId{"RU"}}, // Q111154651
    {Coordinate{63.8257, 56.0143}, CountryId{"RU"}}, // Q111154652
    {Coordinate{63.8262, 56}, CountryId{"RU"}}, // Q111154653
    {Coordinate{63.8614, 55.992}, CountryId{"RU"}}, // Q111154654
    {Coordinate{63.9564, 55.936}, CountryId{"RU"}}, // Q111154655
    {Coordinate{64.0177, 55.9094}, CountryId{"RU"}}, // Q111154656
    {Coordinate{64.0772, 55.885}, CountryId{"RU"}}, // Q111154657
    {Coordinate{64.2076, 55.8633}, CountryId{"RU"}}, // Q111154658
    {Coordinate{64.3027, 55.8352}, CountryId{"RU"}}, // Q111154659
    {Coordinate{64.3108, 55.8184}, CountryId{"RU"}}, // Q111154660
    {Coordinate{64.5011, 55.7478}, CountryId{"RU"}}, // Q111154661
    {Coordinate{64.6759, 55.7118}, CountryId{"RU"}}, // Q111154662
    {Coordinate{64.7629, 55.6826}, CountryId{"RU"}}, // Q111154663
    {Coordinate{64.813, 55.6603}, CountryId{"RU"}}, // Q111154664
    {Coordinate{64.9495, 55.6104}, CountryId{"RU"}}, // Q111154665
    {Coordinate{65.0714, 55.5703}, CountryId{"RU"}}, // Q111154666
    {Coordinate{65.1234, 55.561}, CountryId{"RU"}}, // Q111154667
    {Coordinate{65.1775, 55.5052}, CountryId{"RU"}}, // Q111154668
    {Coordinate{32.5263, 59.9938}, CountryId{"RU"}}, // Georgiyevskii
    {Coordinate{32.4865, 59.9763}, CountryId{"RU"}}, // 135 km
    {Coordinate{32.3552, 59.9178}, CountryId{"RU"}}, // Volkhovstroy-II
    {Coordinate{32.2496, 59.915}, CountryId{"RU"}}, // 119 km
    {Coordinate{32.177, 59.9099}, CountryId{"RU"}}, // 115 km
    {Coordinate{12.9423, 47.9378}, CountryId{"AT"}}, // Q111166212
    {Coordinate{13.0084, 47.3068}, CountryId{"AT"}}, // Q111166213
    {Coordinate{13.0554, 47.2975}, CountryId{"AT"}}, // Q111166214
    {Coordinate{13.0652, 47.8391}, CountryId{"AT"}}, // Q111166215
    {Coordinate{13.073, 47.7993}, CountryId{"AT"}}, // Q111166216
    {Coordinate{13.0932, 47.6998}, CountryId{"AT"}}, // Q111166217
    {Coordinate{13.1141, 47.676}, CountryId{"AT"}}, // Q111166218
    {Coordinate{13.1143, 48.2652}, CountryId{"AT"}}, // Q111166220
    {Coordinate{13.117, 47.8735}, CountryId{"AT"}}, // Q111166221
    {Coordinate{13.1754, 47.9368}, CountryId{"AT"}}, // Q111166223
    {Coordinate{13.1789, 47.4943}, CountryId{"AT"}}, // Q111166225
    {Coordinate{13.0882, 47.7242}, CountryId{"AT"}}, // Q111166261
    {Coordinate{13.1241, 47.6641}, CountryId{"AT"}}, // Q111166262
    {Coordinate{13.1278, 46.7424}, CountryId{"AT"}}, // Q111166263
    {Coordinate{13.1282, 47.6517}, CountryId{"AT"}}, // Q111166264
    {Coordinate{13.1713, 48.2713}, CountryId{"AT"}}, // Q111166265
    {Coordinate{13.2209, 48.2697}, CountryId{"AT"}}, // Q111166266
    {Coordinate{13.2224, 47.3954}, CountryId{"AT"}}, // Q111166267
    {Coordinate{13.2547, 47.4303}, CountryId{"AT"}}, // Q111166268
    {Coordinate{13.2583, 48.2704}, CountryId{"AT"}}, // Q111166269
    {Coordinate{13.2912, 48.2663}, CountryId{"AT"}}, // Q111166270
    {Coordinate{13.3015, 47.9589}, CountryId{"AT"}}, // Q111166271
    {Coordinate{13.3206, 47.4156}, CountryId{"AT"}}, // train station Hüttau
    {Coordinate{13.3483, 46.8256}, CountryId{"AT"}}, // Q111166273
    {Coordinate{13.3558, 47.9867}, CountryId{"AT"}}, // Q111166274
    {Coordinate{13.3681, 46.8308}, CountryId{"AT"}}, // Q111166275
    {Coordinate{13.4021, 48.3474}, CountryId{"AT"}}, // Q111166276
    {Coordinate{13.4046, 46.8352}, CountryId{"AT"}}, // Q111166277
    {Coordinate{13.4192, 46.8275}, CountryId{"AT"}}, // Q111166278
    {Coordinate{13.4331, 48.4028}, CountryId{"AT"}}, // Q111166279
    {Coordinate{13.4337, 48.2888}, CountryId{"AT"}}, // Q111166280
    {Coordinate{13.4554, 48.504}, CountryId{"AT"}}, // Q111166281
    {Coordinate{13.458, 48.2491}, CountryId{"AT"}}, // Q111166282
    {Coordinate{13.4686, 47.3844}, CountryId{"AT"}}, // Q111166283
    {Coordinate{13.4875, 46.7957}, CountryId{"AT"}}, // Q111166284
    {Coordinate{13.2576, 46.9121}, CountryId{"AT"}}, // Q111166792
    {Coordinate{13.3346, 48.2438}, CountryId{"AT"}}, // Q111166793
    {Coordinate{13.4776, 48.2123}, CountryId{"AT"}}, // Q111166794
    {Coordinate{13.5367, 48.1518}, CountryId{"AT"}}, // Q111166797
    {Coordinate{13.5657, 48.3696}, CountryId{"AT"}}, // Q111166798
    {Coordinate{13.6057, 47.9595}, CountryId{"AT"}}, // Q111166800
    {Coordinate{13.6066, 48.1135}, CountryId{"AT"}}, // Q111166803
    {Coordinate{13.6067, 47.9717}, CountryId{"AT"}}, // Q111166804
    {Coordinate{13.6136, 47.9832}, CountryId{"AT"}}, // Q111166805
    {Coordinate{13.6238, 48.0018}, CountryId{"AT"}}, // Q111166807
    {Coordinate{13.6241, 48.3173}, CountryId{"AT"}}, // Q111166809
    {Coordinate{13.6252, 46.5887}, CountryId{"AT"}}, // train station Nötsch im Gailtal
    {Coordinate{13.6266, 48.3041}, CountryId{"AT"}}, // Q111166811
    {Coordinate{13.632, 47.6162}, CountryId{"AT"}}, // Q111166812
    {Coordinate{13.6621, 47.5677}, CountryId{"AT"}}, // Q111166813
    {Coordinate{13.6649, 48.0921}, CountryId{"AT"}}, // Bahnhof Ottnang-Wolfsegg
    {Coordinate{13.6737, 46.7076}, CountryId{"AT"}}, // Q111166815
    {Coordinate{13.7077, 46.5515}, CountryId{"AT"}}, // train station Arnoldstein
    {Coordinate{13.7204, 47.5643}, CountryId{"AT"}}, // Q111166817
    {Coordinate{13.7465, 46.5519}, CountryId{"AT"}}, // Q111166820
    {Coordinate{13.7681, 48.0541}, CountryId{"AT"}}, // Q111166821
    {Coordinate{13.7801, 46.5551}, CountryId{"AT"}}, // Q111166823
    {Coordinate{13.8013, 47.417}, CountryId{"AT"}}, // Q111166824
    {Coordinate{13.808, 47.1299}, CountryId{"AT"}}, // Q111166826
    {Coordinate{13.8136, 46.5632}, CountryId{"AT"}}, // Q111166828
    {Coordinate{13.8698, 48.0944}, CountryId{"AT"}}, // Q111166829
    {Coordinate{13.3447, 47.4213}, CountryId{"AT"}}, // Q111167423
    {Coordinate{13.3739, 48.2272}, CountryId{"AT"}}, // Q111167424
    {Coordinate{13.4081, 46.6312}, CountryId{"AT"}}, // Q111167426
    {Coordinate{13.4152, 48.316}, CountryId{"AT"}}, // Q111167427
    {Coordinate{13.4584, 48.4408}, CountryId{"AT"}}, // Q111167428
    {Coordinate{13.4708, 46.6232}, CountryId{"AT"}}, // Q111167429
    {Coordinate{13.5132, 48.171}, CountryId{"AT"}}, // Q111167430
    {Coordinate{13.5227, 48.4068}, CountryId{"AT"}}, // Q111167431
    {Coordinate{13.5682, 47.4042}, CountryId{"AT"}}, // Q111167432
    {Coordinate{13.5716, 48.1296}, CountryId{"AT"}}, // Q111167433
    {Coordinate{13.5727, 46.5953}, CountryId{"AT"}}, // Q111167434
    {Coordinate{13.5804, 46.7603}, CountryId{"AT"}}, // Q111167435
    {Coordinate{13.6171, 48.2317}, CountryId{"AT"}}, // Q111167436
    {Coordinate{13.6203, 48.2694}, CountryId{"AT"}}, // Q111167437
    {Coordinate{13.6502, 48.2464}, CountryId{"AT"}}, // Q111167438
    {Coordinate{13.6633, 47.7388}, CountryId{"AT"}}, // Q111167439
    {Coordinate{13.6815, 48.0529}, CountryId{"AT"}}, // Q111167440
    {Coordinate{13.7199, 46.6795}, CountryId{"AT"}}, // Q111167441
    {Coordinate{13.8208, 47.4204}, CountryId{"AT"}}, // Q111167444
    {Coordinate{13.8331, 48.0951}, CountryId{"AT"}}, // Q111167445
    {Coordinate{13.8685, 48.2238}, CountryId{"AT"}}, // Q111167447
    {Coordinate{13.8745, 46.6209}, CountryId{"AT"}}, // Q111167448
    {Coordinate{13.8764, 46.641}, CountryId{"AT"}}, // Q111167449
    {Coordinate{13.8885, 48.094}, CountryId{"AT"}}, // Q111167451
    {Coordinate{13.9009, 47.4269}, CountryId{"AT"}}, // Q111167453
    {Coordinate{13.9165, 46.6628}, CountryId{"AT"}}, // Q111167454
    {Coordinate{13.9223, 48.2287}, CountryId{"AT"}}, // Q111167456
    {Coordinate{13.9255, 47.5511}, CountryId{"AT"}}, // Q111167457
    {Coordinate{13.9419, 47.4373}, CountryId{"AT"}}, // Q111167458
    {Coordinate{13.9454, 48.1321}, CountryId{"AT"}}, // Q111167459
    {Coordinate{13.9461, 47.5503}, CountryId{"AT"}}, // Q111167461
    {Coordinate{13.959, 46.6021}, CountryId{"AT"}}, // Q111167462
    {Coordinate{13.9595, 46.6745}, CountryId{"AT"}}, // Q111167463
    {Coordinate{13.9604, 48.5999}, CountryId{"AT"}}, // Q111167464
    {Coordinate{13.9651, 46.5629}, CountryId{"AT"}}, // Q111167465
    {Coordinate{13.8389, 48.231}, CountryId{"AT"}}, // Q111167719
    {Coordinate{13.9713, 47.9155}, CountryId{"AT"}}, // Q111167720
    {Coordinate{13.9742, 46.6826}, CountryId{"AT"}}, // Q111167721
    {Coordinate{13.9749, 48.6426}, CountryId{"AT"}}, // Q111167722
    {Coordinate{13.975, 48.2473}, CountryId{"AT"}}, // Q111167723
    {Coordinate{13.9871, 48.5819}, CountryId{"AT"}}, // Q111167724
    {Coordinate{13.9876, 47.4607}, CountryId{"AT"}}, // Q111167725
    {Coordinate{13.9981, 48.3392}, CountryId{"AT"}}, // Q111167726
    {Coordinate{14.0051, 48.4837}, CountryId{"AT"}}, // Q111167727
    {Coordinate{14.0068, 48.2869}, CountryId{"AT"}}, // Q111167728
    {Coordinate{14.0103, 48.3219}, CountryId{"AT"}}, // Q111167730
    {Coordinate{14.0113, 47.5515}, CountryId{"AT"}}, // Q111167731
    {Coordinate{14.0115, 47.9622}, CountryId{"AT"}}, // Q111167732
    {Coordinate{14.0141, 48.3633}, CountryId{"AT"}}, // Q111167735
    {Coordinate{14.0141, 46.6982}, CountryId{"AT"}}, // Q111167736
    {Coordinate{14.0143, 47.4817}, CountryId{"AT"}}, // Q111167737
    {Coordinate{14.0173, 48.1566}, CountryId{"AT"}}, // Q111167738
    {Coordinate{14.0179, 48.1193}, CountryId{"AT"}}, // Q111167740
    {Coordinate{14.0196, 48.1525}, CountryId{"AT"}}, // Q111167741
    {Coordinate{14.022, 47.9681}, CountryId{"AT"}}, // Q111167742
    {Coordinate{14.0309, 48.5545}, CountryId{"AT"}}, // Haslach/Mühl railway station
    {Coordinate{14.0321, 48.4585}, CountryId{"AT"}}, // Q111167744
    {Coordinate{14.0448, 46.62}, CountryId{"AT"}}, // Q111167745
    {Coordinate{14.0471, 48.0124}, CountryId{"AT"}}, // Q111167746
    {Coordinate{14.058, 48.0741}, CountryId{"AT"}}, // Q111167747
    {Coordinate{14.06, 46.7014}, CountryId{"AT"}}, // Q111167748
    {Coordinate{14.0646, 47.5286}, CountryId{"AT"}}, // Q111167749
    {Coordinate{14.099, 46.7215}, CountryId{"AT"}}, // Q111167751
    {Coordinate{14.1112, 47.9369}, CountryId{"AT"}}, // Q111167752
    {Coordinate{14.1162, 47.9062}, CountryId{"AT"}}, // Q111167753
    {Coordinate{14.1216, 47.989}, CountryId{"AT"}}, // Q111167754
    {Coordinate{14.123, 47.9721}, CountryId{"AT"}}, // Q111167755
    {Coordinate{14.1264, 47.8831}, CountryId{"AT"}}, // Q111167756
    {Coordinate{14.1375, 48.3602}, CountryId{"AT"}}, // Q111167757
    {Coordinate{14.1398, 47.5455}, CountryId{"AT"}}, // Q111167759
    {Coordinate{14.1414, 48.0536}, CountryId{"AT"}}, // Q111167760
    {Coordinate{14.1463, 46.6362}, CountryId{"AT"}}, // Q111167761
    {Coordinate{14.1511, 48.2276}, CountryId{"AT"}}, // Q111167762
    {Coordinate{14.1536, 48.3484}, CountryId{"AT"}}, // Q111167763
    {Coordinate{14.1637, 47.8017}, CountryId{"AT"}}, // Q111167764
    {Coordinate{14.1771, 48.3378}, CountryId{"AT"}}, // Q111167767
    {Coordinate{14.179, 47.7746}, CountryId{"AT"}}, // Q111167770
    {Coordinate{14.1862, 48.2457}, CountryId{"AT"}}, // Q111167771
    {Coordinate{14.1912, 48.0696}, CountryId{"AT"}}, // Q111167773
    {Coordinate{14.203, 48.113}, CountryId{"AT"}}, // Q111167775
    {Coordinate{14.2089, 48.2573}, CountryId{"AT"}}, // Q111167776
    {Coordinate{14.2107, 46.7165}, CountryId{"AT"}}, // Q111167777
    {Coordinate{14.2214, 46.6263}, CountryId{"AT"}}, // Q111167778
    {Coordinate{14.2224, 48.3125}, CountryId{"AT"}}, // Q111167779
    {Coordinate{14.2365, 46.7282}, CountryId{"AT"}}, // Q111167780
    {Coordinate{14.2384, 48.3116}, CountryId{"AT"}}, // Q111167781
    {Coordinate{14.2385, 48.136}, CountryId{"AT"}}, // Q111167783
    {Coordinate{14.2419, 47.5627}, CountryId{"AT"}}, // Q111167784
    {Coordinate{14.2435, 46.5393}, CountryId{"AT"}}, // Q111167785
    {Coordinate{14.2465, 48.164}, CountryId{"AT"}}, // Q111167786
    {Coordinate{14.2538, 48.2256}, CountryId{"AT"}}, // Q111167787
    {Coordinate{14.2611, 48.2089}, CountryId{"AT"}}, // Q111167788
    {Coordinate{14.2765, 48.2647}, CountryId{"AT"}}, // Q111167789
    {Coordinate{14.284, 46.6215}, CountryId{"AT"}}, // Q111167790
    {Coordinate{14.2931, 46.7364}, CountryId{"AT"}}, // Q111167793
    {Coordinate{14.3273, 47.7154}, CountryId{"AT"}}, // Q111167795
    {Coordinate{14.3475, 47.6731}, CountryId{"AT"}}, // Q111167796
    {Coordinate{14.355, 47.9492}, CountryId{"AT"}}, // Q111167797
    {Coordinate{14.3623, 48.2845}, CountryId{"AT"}}, // Q111167798
    {Coordinate{14.3671, 47.5273}, CountryId{"AT"}}, // Q111167799
    {Coordinate{14.4083, 48.0238}, CountryId{"AT"}}, // Q111167800
    {Coordinate{14.4103, 46.9537}, CountryId{"AT"}}, // Q111167802
    {Coordinate{14.4232, 48.0382}, CountryId{"AT"}}, // Q111167803
    {Coordinate{14.4233, 46.7619}, CountryId{"AT"}}, // Q111167804
    {Coordinate{14.4315, 46.9143}, CountryId{"AT"}}, // Q111167805
    {Coordinate{14.4404, 48.2652}, CountryId{"AT"}}, // Q111167806
    {Coordinate{14.4423, 47.2011}, CountryId{"AT"}}, // train station Unzmarkt
    {Coordinate{14.4596, 46.6189}, CountryId{"AT"}}, // train station Grafenstein
    {Coordinate{14.4656, 46.8685}, CountryId{"AT"}}, // train station Treibach-Althofen
    {Coordinate{13.8415, 47.5707}, CountryId{"AT"}}, // Q111171333
    {Coordinate{13.9383, 47.8772}, CountryId{"AT"}}, // Q111171335
    {Coordinate{13.9873, 48.2733}, CountryId{"AT"}}, // Q111171336
    {Coordinate{13.9931, 47.9324}, CountryId{"AT"}}, // Q111171337
    {Coordinate{13.9958, 47.5521}, CountryId{"AT"}}, // Q111171339
    {Coordinate{14.0001, 46.6059}, CountryId{"AT"}}, // Q111171340
    {Coordinate{14.315, 46.6506}, CountryId{"AT"}}, // Q111171342
    {Coordinate{14.322, 46.6216}, CountryId{"AT"}}, // Q111171343
    {Coordinate{14.362, 46.7625}, CountryId{"AT"}}, // Q111171345
    {Coordinate{14.4149, 47.0735}, CountryId{"AT"}}, // Q111171346
    {Coordinate{14.4171, 47.1491}, CountryId{"AT"}}, // Q111171347
    {Coordinate{14.4667, 48.2212}, CountryId{"AT"}}, // Q111171348
    {Coordinate{14.4684, 47.5733}, CountryId{"AT"}}, // train station Admont
    {Coordinate{14.4727, 47.8915}, CountryId{"AT"}}, // Q111171350
    {Coordinate{14.48, 48.1266}, CountryId{"AT"}}, // Q111171351
    {Coordinate{14.4815, 48.4952}, CountryId{"AT"}}, // Q111171352
    {Coordinate{14.4893, 47.4892}, CountryId{"AT"}}, // train station Trieben
    {Coordinate{14.4902, 48.3121}, CountryId{"AT"}}, // Q111171354
    {Coordinate{14.4961, 48.2165}, CountryId{"AT"}}, // Q111171355
    {Coordinate{14.5035, 48.1614}, CountryId{"AT"}}, // Q111171356
    {Coordinate{14.5108, 47.893}, CountryId{"AT"}}, // Q111171357
    {Coordinate{14.5327, 48.2429}, CountryId{"AT"}}, // Q111171358
    {Coordinate{14.5381, 48.4369}, CountryId{"AT"}}, // Q111171359
    {Coordinate{14.5466, 47.4891}, CountryId{"AT"}}, // Q111171360
    {Coordinate{14.5511, 47.8822}, CountryId{"AT"}}, // Q111171361
    {Coordinate{14.5661, 48.1157}, CountryId{"AT"}}, // Q111171364
    {Coordinate{14.5886, 47.1966}, CountryId{"AT"}}, // Q111171365
    {Coordinate{14.5959, 47.5824}, CountryId{"AT"}}, // Q111171366
    {Coordinate{14.6275, 48.2475}, CountryId{"AT"}}, // Q111171367
    {Coordinate{14.6299, 46.6221}, CountryId{"AT"}}, // Q111171368
    {Coordinate{14.6336, 47.5914}, CountryId{"AT"}}, // train station Gstatterboden
    {Coordinate{14.6599, 47.1747}, CountryId{"AT"}}, // Q111171370
    {Coordinate{14.667, 47.8616}, CountryId{"AT"}}, // Q111171371
    {Coordinate{14.6708, 47.4504}, CountryId{"AT"}}, // Q111171372
    {Coordinate{14.7011, 48.2269}, CountryId{"AT"}}, // Q111171373
    {Coordinate{14.738, 47.9927}, CountryId{"AT"}}, // Q111171374
    {Coordinate{14.7469, 47.4237}, CountryId{"AT"}}, // Q111171375
    {Coordinate{14.7477, 48.2087}, CountryId{"AT"}}, // Q111171376
    {Coordinate{14.7653, 47.9681}, CountryId{"AT"}}, // Q111171377
    {Coordinate{14.7678, 47.9584}, CountryId{"AT"}}, // Q111171378
    {Coordinate{14.7895, 48.2054}, CountryId{"AT"}}, // Q111171379
    {Coordinate{14.8114, 46.6301}, CountryId{"AT"}}, // Q111171380
    {Coordinate{14.8252, 46.6628}, CountryId{"AT"}}, // Q111171381
    {Coordinate{14.8361, 47.3968}, CountryId{"AT"}}, // Q111171382
    {Coordinate{14.8376, 47.2153}, CountryId{"AT"}}, // train station Knittelfeld
    {Coordinate{14.8382, 46.6851}, CountryId{"AT"}}, // Q111171384
    {Coordinate{14.8384, 46.8426}, CountryId{"AT"}}, // Q111171385
    {Coordinate{14.856, 48.23}, CountryId{"AT"}}, // Q111171386
    {Coordinate{14.8677, 46.7065}, CountryId{"AT"}}, // Q111171387
    {Coordinate{14.8685, 46.6964}, CountryId{"AT"}}, // Q111171388
    {Coordinate{14.9091, 48.2335}, CountryId{"AT"}}, // Q111171392
    {Coordinate{14.944, 48.2296}, CountryId{"AT"}}, // Q111171393
    {Coordinate{14.9455, 47.306}, CountryId{"AT"}}, // Q111171394
    {Coordinate{14.9796, 48.1251}, CountryId{"AT"}}, // Q111171397
    {Coordinate{15.0092, 47.3467}, CountryId{"AT"}}, // Q111171399
    {Coordinate{14.7237, 47.8938}, CountryId{"AT"}}, // Q111171447
    {Coordinate{14.8461, 46.8067}, CountryId{"AT"}}, // Q111171448
    {Coordinate{15.1311, 48.059}, CountryId{"AT"}}, // Q111171451
    {Coordinate{15.1555, 47.3939}, CountryId{"AT"}}, // train station Niklasdorf
    {Coordinate{15.157, 48.1435}, CountryId{"AT"}}, // Q111171453
    {Coordinate{15.1643, 48.0053}, CountryId{"AT"}}, // Q111171454
    {Coordinate{15.1821, 48.1838}, CountryId{"AT"}}, // Q111171457
    {Coordinate{15.2921, 47.4452}, CountryId{"AT"}}, // Q111171460
    {Coordinate{15.343, 47.3595}, CountryId{"AT"}}, // Q111171463
    {Coordinate{15.4483, 47.5011}, CountryId{"AT"}}, // train station Kindberg
    {Coordinate{15.477, 46.9164}, CountryId{"AT"}}, // Q111171470
    {Coordinate{15.4831, 47.5273}, CountryId{"AT"}}, // train station Wartberg im Mürztal
    {Coordinate{15.496, 47.0301}, CountryId{"AT"}}, // Q111171472
    {Coordinate{15.56, 47.5472}, CountryId{"AT"}}, // train station Krieglach
    {Coordinate{15.5856, 46.7277}, CountryId{"AT"}}, // Q111171474
    {Coordinate{15.9489, 46.7238}, CountryId{"AT"}}, // Q111171475
    {Coordinate{16.0034, 46.9794}, CountryId{"AT"}}, // Q111171476
    {Coordinate{16.1428, 47.7033}, CountryId{"AT"}}, // Q111171477
    {Coordinate{16.1756, 47.9294}, CountryId{"AT"}}, // Q111171479
    {Coordinate{16.4196, 48.1024}, CountryId{"AT"}}, // Q111171480
    {Coordinate{16.5388, 48.3617}, CountryId{"AT"}}, // Q111171482
    {Coordinate{16.6032, 48.3578}, CountryId{"AT"}}, // Q111171483
    {Coordinate{16.6152, 48.1165}, CountryId{"AT"}}, // Q111171484
    {Coordinate{16.7476, 48.248}, CountryId{"AT"}}, // Q111171485
    {Coordinate{17.0062, 48.1356}, CountryId{"AT"}}, // Q111171486
    {Coordinate{15.3433, 47.2072}, CountryId{"AT"}}, // train station Peggau-Deutschfeistritz
    {Coordinate{14.4556, 46.7689}, CountryId{"AT"}}, // Q111171554
    {Coordinate{16.9009, 48.5983}, CountryId{"AT"}}, // Q111171555
    {Coordinate{15.999, 47.1889}, CountryId{"AT"}}, // Q111171556
    {Coordinate{16.0353, 47.2806}, CountryId{"AT"}}, // Q111171557
    {Coordinate{16.0996, 47.5624}, CountryId{"AT"}}, // Q111171558
    {Coordinate{15.5884, 47.0789}, CountryId{"AT"}}, // Q111171559
    {Coordinate{16.6605, 47.8886}, CountryId{"AT"}}, // Q111171560
    {Coordinate{16.8958, 48.5401}, CountryId{"AT"}}, // Q111171561
    {Coordinate{16.3625, 47.8776}, CountryId{"AT"}}, // Q111171562
    {Coordinate{16.9159, 47.84}, CountryId{"AT"}}, // train station Frauenkirchen
    {Coordinate{16.7462, 47.9411}, CountryId{"AT"}}, // Q111171564
    {Coordinate{16.4088, 47.7359}, CountryId{"AT"}}, // Q111171565
    {Coordinate{16.619, 47.8481}, CountryId{"AT"}}, // Q111171567
    {Coordinate{16.8242, 47.9561}, CountryId{"AT"}}, // train station Neusiedl am See
    {Coordinate{16.1796, 47.7172}, CountryId{"AT"}}, // Q111171642
    {Coordinate{15.7089, 47.0994}, CountryId{"AT"}}, // Q111171644
    {Coordinate{16.377, 48.0821}, CountryId{"AT"}}, // Q111171645
    {Coordinate{16.4947, 47.7478}, CountryId{"AT"}}, // Q111171646
    {Coordinate{16.4089, 47.9612}, CountryId{"AT"}}, // Q111171647
    {Coordinate{16.5298, 47.8396}, CountryId{"AT"}}, // Q111171648
    {Coordinate{16.9055, 47.8916}, CountryId{"AT"}}, // train station Gols
    {Coordinate{16.4815, 48.1436}, CountryId{"AT"}}, // Q111171650
    {Coordinate{16.9392, 48.1488}, CountryId{"AT"}}, // Q111171651
    {Coordinate{16.7907, 47.9567}, CountryId{"AT"}}, // train station Jois
    {Coordinate{16.2669, 47.7928}, CountryId{"AT"}}, // Q111171654
    {Coordinate{15.7034, 47.1054}, CountryId{"AT"}}, // Q111171655
    {Coordinate{16.3213, 47.8614}, CountryId{"AT"}}, // Q111171656
    {Coordinate{16.9305, 47.7335}, CountryId{"AT"}}, // Q111171657
    {Coordinate{16.4169, 47.9307}, CountryId{"AT"}}, // Q111171658
    {Coordinate{16.8638, 47.9257}, CountryId{"AT"}}, // Q111171660
    {Coordinate{16.4128, 47.9521}, CountryId{"AT"}}, // Q111171661
    {Coordinate{15.1425, 48.1321}, CountryId{"AT"}}, // Q111171662
    {Coordinate{16.759, 47.947}, CountryId{"AT"}}, // Q111171664
    {Coordinate{16.4906, 47.7893}, CountryId{"AT"}}, // Q111171665
    {Coordinate{15.3232, 47.129}, CountryId{"AT"}}, // Q111171668
    {Coordinate{16.3251, 48.0443}, CountryId{"AT"}}, // Q111171670
    {Coordinate{16.3863, 48.0325}, CountryId{"AT"}}, // Q111171671
    {Coordinate{16.0139, 47.0287}, CountryId{"AT"}}, // Q111171672
    {Coordinate{16.0137, 47.1703}, CountryId{"AT"}}, // Q111171673
    {Coordinate{16.3247, 47.7741}, CountryId{"AT"}}, // Q111171674
    {Coordinate{15.771, 46.7113}, CountryId{"AT"}}, // Q111171675
    {Coordinate{16.3813, 47.8685}, CountryId{"AT"}}, // Q111171676
    {Coordinate{16.8512, 47.9921}, CountryId{"AT"}}, // train station Parndorf Ort
    {Coordinate{16.8677, 48.1059}, CountryId{"AT"}}, // Q111171681
    {Coordinate{16.3962, 47.9054}, CountryId{"AT"}}, // Q111171682
    {Coordinate{16.6986, 47.9063}, CountryId{"AT"}}, // Q111171683
    {Coordinate{16.6881, 48.1097}, CountryId{"AT"}}, // Q111171684
    {Coordinate{16.9108, 48.1328}, CountryId{"AT"}}, // Q111171685
    {Coordinate{15.9109, 47.8769}, CountryId{"AT"}}, // Q111171686
    {Coordinate{16.1731, 47.8268}, CountryId{"AT"}}, // Q111171687
    {Coordinate{16.1715, 47.8314}, CountryId{"AT"}}, // Q111171688
    {Coordinate{15.7537, 48.2004}, CountryId{"AT"}}, // Q111171689
    {Coordinate{16.0566, 47.1234}, CountryId{"AT"}}, // Q111171690
    {Coordinate{13.9678, 48.2231}, CountryId{"AT"}}, // Q111171693
    {Coordinate{16.1874, 47.9213}, CountryId{"AT"}}, // Q111171694
    {Coordinate{15.6674, 47.1793}, CountryId{"AT"}}, // Q111171695
    {Coordinate{16.5122, 48.6434}, CountryId{"AT"}}, // Q111171696
    {Coordinate{16.5697, 48.3541}, CountryId{"AT"}}, // Q111171698
    {Coordinate{16.0611, 47.4405}, CountryId{"AT"}}, // Q111171980
    {Coordinate{15.7749, 46.9988}, CountryId{"AT"}}, // Q111171981
    {Coordinate{16.4919, 47.7007}, CountryId{"AT"}}, // Q111171982
    {Coordinate{16.2972, 47.8499}, CountryId{"AT"}}, // Q111171983
    {Coordinate{16.8454, 47.9426}, CountryId{"AT"}}, // train station Neusiedl am See Bad
    {Coordinate{14.8416, 46.7638}, CountryId{"AT"}}, // train station St.Andrä im Lavanttal
    {Coordinate{16.6423, 48.368}, CountryId{"AT"}}, // Q111171986
    {Coordinate{16.0219, 47.4186}, CountryId{"AT"}}, // Q111171987
    {Coordinate{16.8601, 48.4698}, CountryId{"AT"}}, // Q111171988
    {Coordinate{16.1288, 47.6792}, CountryId{"AT"}}, // Q111171989
    {Coordinate{16.6395, 48.2421}, CountryId{"AT"}}, // Q111171990
    {Coordinate{15.8532, 46.9618}, CountryId{"AT"}}, // Q111171991
    {Coordinate{16.4837, 48.2933}, CountryId{"AT"}}, // Q111171992
    {Coordinate{15.9979, 47.7975}, CountryId{"AT"}}, // Q111171993
    {Coordinate{15.7976, 46.7244}, CountryId{"AT"}}, // Q111171994
    {Coordinate{16.0603, 46.9442}, CountryId{"AT"}}, // Q111171995
    {Coordinate{16.7104, 48.1097}, CountryId{"AT"}}, // Q111171996
    {Coordinate{15.3439, 47.1185}, CountryId{"AT"}}, // Q111171997
    {Coordinate{16.8783, 48.495}, CountryId{"AT"}}, // Q111171998
    {Coordinate{16.4951, 48.3168}, CountryId{"AT"}}, // Q111171999
    {Coordinate{16.4643, 48.7035}, CountryId{"AT"}}, // Q111172000
    {Coordinate{15.593, 48.0138}, CountryId{"AT"}}, // Q111172001
    {Coordinate{15.6563, 47.0881}, CountryId{"AT"}}, // Q111172002
    {Coordinate{15.9455, 46.9547}, CountryId{"AT"}}, // Q111172003
    {Coordinate{16.4027, 48.7237}, CountryId{"AT"}}, // Q111172004
    {Coordinate{15.497, 48.1964}, CountryId{"AT"}}, // Q111172006
    {Coordinate{15.9341, 48.2965}, CountryId{"AT"}}, // Michelhausen train station
    {Coordinate{15.1355, 48.111}, CountryId{"AT"}}, // Q111172008
    {Coordinate{16.5636, 48.5657}, CountryId{"AT"}}, // Q111172009
    {Coordinate{16.4798, 48.478}, CountryId{"AT"}}, // Q111172010
    {Coordinate{14.7448, 47.9023}, CountryId{"AT"}}, // Q111172011
    {Coordinate{16.0972, 47.8745}, CountryId{"AT"}}, // Q111172012
    {Coordinate{15.9793, 47.8934}, CountryId{"AT"}}, // Q111172013
    {Coordinate{16.0895, 47.9614}, CountryId{"AT"}}, // Q111172014
    {Coordinate{15.9103, 47.7904}, CountryId{"AT"}}, // Q111172015
    {Coordinate{16.5819, 48.239}, CountryId{"AT"}}, // Bahnhof Raasdorf
    {Coordinate{16.8947, 48.6519}, CountryId{"AT"}}, // Q111172017
    {Coordinate{16.6673, 48.3996}, CountryId{"AT"}}, // Q111172018
    {Coordinate{15.137, 48.079}, CountryId{"AT"}}, // Q111172019
    {Coordinate{16.3059, 47.9555}, CountryId{"AT"}}, // Q111172020
    {Coordinate{16.6435, 48.0242}, CountryId{"AT"}}, // Q111172021
    {Coordinate{16.2898, 47.9425}, CountryId{"AT"}}, // Q111172022
    {Coordinate{16.3323, 47.9925}, CountryId{"AT"}}, // Q111172023
    {Coordinate{16.0743, 47.098}, CountryId{"AT"}}, // Q111172075
    {Coordinate{16.0035, 47.3466}, CountryId{"AT"}}, // Q111172076
    {Coordinate{16.1279, 47.6169}, CountryId{"AT"}}, // Q111172077
    {Coordinate{14.5061, 48.3303}, CountryId{"AT"}}, // Q111172078
    {Coordinate{13.9748, 48.2098}, CountryId{"AT"}}, // Q111172079
    {Coordinate{13.9589, 47.9006}, CountryId{"AT"}}, // Q111172080
    {Coordinate{16.9494, 47.8735}, CountryId{"AT"}}, // train station Mönchhof-Halbturn
    {Coordinate{16.3006, 47.7938}, CountryId{"AT"}}, // Q111172082
    {Coordinate{14.0556, 48.0387}, CountryId{"AT"}}, // Q111172083
    {Coordinate{15.6001, 48.0215}, CountryId{"AT"}}, // Q111172084
    {Coordinate{15.3224, 47.1775}, CountryId{"AT"}}, // Q111172086
    {Coordinate{14.7564, 48.0697}, CountryId{"AT"}}, // Q111172087
    {Coordinate{15.2559, 47.219}, CountryId{"AT"}}, // Q111172088
    {Coordinate{15.2517, 47.2194}, CountryId{"AT"}}, // Q111172089
    {Coordinate{16.2423, 47.7507}, CountryId{"AT"}}, // Q111172090
    {Coordinate{16.5101, 48.5362}, CountryId{"AT"}}, // Q111172091
    {Coordinate{16.8336, 48.3064}, CountryId{"AT"}}, // Q111172092
    {Coordinate{16.5352, 48.5468}, CountryId{"AT"}}, // Q111172093
    {Coordinate{16.6058, 48.4485}, CountryId{"AT"}}, // Q111172094
    {Coordinate{16.1241, 47.8746}, CountryId{"AT"}}, // Q111172095
    {Coordinate{15.7428, 48.0478}, CountryId{"AT"}}, // Q111172096
    {Coordinate{16.5312, 48.6114}, CountryId{"AT"}}, // Q111172098
    {Coordinate{16.891, 48.5111}, CountryId{"AT"}}, // Q111172099
    {Coordinate{14.6132, 48.075}, CountryId{"AT"}}, // Q111172100
    {Coordinate{16.8072, 48.251}, CountryId{"AT"}}, // Q111172101
    {Coordinate{15.668, 47.1518}, CountryId{"AT"}}, // Q111172102
    {Coordinate{16.6344, 48.3186}, CountryId{"AT"}}, // Q111172103
    {Coordinate{16.4926, 48.6997}, CountryId{"AT"}}, // Q111172104
    {Coordinate{15.5785, 48.009}, CountryId{"AT"}}, // Q111172106
    {Coordinate{15.6718, 48.0451}, CountryId{"AT"}}, // Q111172107
    {Coordinate{16.1491, 47.9332}, CountryId{"AT"}}, // Q111172108
    {Coordinate{16.7862, 48.3636}, CountryId{"AT"}}, // Q111172109
    {Coordinate{16.4881, 48.4021}, CountryId{"AT"}}, // Q111172110
    {Coordinate{16.0585, 47.8689}, CountryId{"AT"}}, // Q111172111
    {Coordinate{16.7633, 48.3388}, CountryId{"AT"}}, // Q111172112
    {Coordinate{15.3243, 47.2069}, CountryId{"AT"}}, // Q111172113
    {Coordinate{17.0238, 47.9681}, CountryId{"AT"}}, // train station Zurndorf
    {Coordinate{53.5304, 57.9199}, CountryId{"RU"}}, // Q111172120
    {Coordinate{53.5894, 57.8992}, CountryId{"RU"}}, // Q111172121
    {Coordinate{53.6415, 57.9078}, CountryId{"RU"}}, // Q111172122
    {Coordinate{53.9721, 57.9555}, CountryId{"RU"}}, // Q111172123
    {Coordinate{54.1452, 57.9572}, CountryId{"RU"}}, // Q111172125
    {Coordinate{54.2243, 57.9588}, CountryId{"RU"}}, // Q111172126
    {Coordinate{54.2758, 57.9615}, CountryId{"RU"}}, // Q111172128
    {Coordinate{54.3866, 57.9992}, CountryId{"RU"}}, // Q111172129
    {Coordinate{54.4529, 58.0401}, CountryId{"RU"}}, // Q111172130
    {Coordinate{54.6107, 58.0333}, CountryId{"RU"}}, // Q111172131
    {Coordinate{54.6365, 58.0607}, CountryId{"RU"}}, // Q111172132
    {Coordinate{54.7312, 58.1276}, CountryId{"RU"}}, // Q111172134
    {Coordinate{54.7793, 58.1279}, CountryId{"RU"}}, // Q111172135
    {Coordinate{54.848, 58.1479}, CountryId{"RU"}}, // Q111172136
    {Coordinate{54.9259, 58.1462}, CountryId{"RU"}}, // Q111172138
    {Coordinate{54.9936, 58.1662}, CountryId{"RU"}}, // Q111172139
    {Coordinate{55.0609, 58.2311}, CountryId{"RU"}}, // Q111172140
    {Coordinate{55.1565, 58.2515}, CountryId{"RU"}}, // Q111172141
    {Coordinate{55.1947, 58.2434}, CountryId{"RU"}}, // Q111172143
    {Coordinate{55.2566, 58.2339}, CountryId{"RU"}}, // Q111172144
    {Coordinate{55.3064, 58.216}, CountryId{"RU"}}, // Q111172145
    {Coordinate{55.3715, 58.1873}, CountryId{"RU"}}, // Q111172146
    {Coordinate{55.3894, 58.1792}, CountryId{"RU"}}, // Q111172147
    {Coordinate{55.4245, 58.1704}, CountryId{"RU"}}, // Q111172148
    {Coordinate{55.4711, 58.1503}, CountryId{"RU"}}, // Q111172149
    {Coordinate{55.5245, 58.1336}, CountryId{"RU"}}, // Q111172150
    {Coordinate{55.5833, 58.131}, CountryId{"RU"}}, // Q111172151
    {Coordinate{55.6466, 58.1365}, CountryId{"RU"}}, // Q111172152
    {Coordinate{55.683, 58.1377}, CountryId{"RU"}}, // Q111172153
    {Coordinate{55.725, 58.1402}, CountryId{"RU"}}, // Q111172154
    {Coordinate{55.8142, 58.1201}, CountryId{"RU"}}, // Q111172155
    {Coordinate{55.8336, 58.113}, CountryId{"RU"}}, // Q111172156
    {Coordinate{55.8683, 58.0861}, CountryId{"RU"}}, // Q111172157
    {Coordinate{55.9078, 58.059}, CountryId{"RU"}}, // Q111172158
    {Coordinate{55.9589, 58.0711}, CountryId{"RU"}}, // Q111172159
    {Coordinate{16.6783, 48.3283}, CountryId{"AT"}}, // Q111172224
    {Coordinate{15.6952, 47.1231}, CountryId{"AT"}}, // Q111172225
    {Coordinate{14.5904, 48.2562}, CountryId{"AT"}}, // Q111172227
    {Coordinate{13.9785, 48.2608}, CountryId{"AT"}}, // Q111172228
    {Coordinate{16.1338, 47.9403}, CountryId{"AT"}}, // Q111172229
    {Coordinate{16.1087, 47.9448}, CountryId{"AT"}}, // Bahnhof Berndorf Stadt
    {Coordinate{13.6313, 48.1009}, CountryId{"AT"}}, // Q111172231
    {Coordinate{16.1883, 47.7225}, CountryId{"AT"}}, // Q111172233
    {Coordinate{16.1573, 47.8256}, CountryId{"AT"}}, // Q111172235
    {Coordinate{16.5366, 47.8438}, CountryId{"AT"}}, // Q111172236
    {Coordinate{16.3586, 48.1127}, CountryId{"AT"}}, // Q111172237
    {Coordinate{16.0264, 47.8787}, CountryId{"AT"}}, // Q111172301
    {Coordinate{14.5054, 48.3417}, CountryId{"AT"}}, // Q111172302
    {Coordinate{15.4029, 47.482}, CountryId{"AT"}}, // Q111172303
    {Coordinate{16.8776, 48.2548}, CountryId{"AT"}}, // Breitensee NÖ train station
    {Coordinate{14.7541, 47.9831}, CountryId{"AT"}}, // Q111172305
    {Coordinate{16.511, 48.6728}, CountryId{"AT"}}, // Q111172307
    {Coordinate{14.893, 47.2517}, CountryId{"AT"}}, // Q111172308
    {Coordinate{16.4202, 48.2707}, CountryId{"AT"}}, // Q111172309
    {Coordinate{14.8512, 48.2207}, CountryId{"AT"}}, // Q111172310
    {Coordinate{15.9719, 47.7982}, CountryId{"AT"}}, // Q111172311
    {Coordinate{16.4451, 48.0823}, CountryId{"AT"}}, // Q111172312
    {Coordinate{15.7686, 48.0394}, CountryId{"AT"}}, // Q111172313
    {Coordinate{16.4392, 48.1333}, CountryId{"AT"}}, // Q111172314
    {Coordinate{15.3082, 47.2129}, CountryId{"AT"}}, // Q111172315
    {Coordinate{16.73, 48.3824}, CountryId{"AT"}}, // Q111172316
    {Coordinate{15.5261, 48.2031}, CountryId{"AT"}}, // Q111172317
    {Coordinate{16.1755, 48.206}, CountryId{"AT"}}, // Q111172318
    {Coordinate{14.4595, 48.0677}, CountryId{"AT"}}, // Q111172320
    {Coordinate{14.7418, 48.0105}, CountryId{"AT"}}, // Q111172321
    {Coordinate{15.1138, 48.1926}, CountryId{"AT"}}, // Q111172322
    {Coordinate{14.8201, 48.1919}, CountryId{"AT"}}, // Q111172382
    {Coordinate{16.1101, 47.8725}, CountryId{"AT"}}, // Q111172383
    {Coordinate{14.3538, 47.9784}, CountryId{"AT"}}, // Q111172384
    {Coordinate{14.1923, 48.3315}, CountryId{"AT"}}, // Q111172385
    {Coordinate{14.3985, 47.57}, CountryId{"AT"}}, // Q111172386
    {Coordinate{14.3235, 48.2859}, CountryId{"AT"}}, // Q111172387
    {Coordinate{14.8385, 48.108}, CountryId{"AT"}}, // Q111172388
    {Coordinate{15.2658, 47.2186}, CountryId{"AT"}}, // Q111172389
    {Coordinate{14.7617, 48.0225}, CountryId{"AT"}}, // Q111172390
    {Coordinate{16.9322, 48.1448}, CountryId{"AT"}}, // Q111172392
    {Coordinate{16.9481, 48.1483}, CountryId{"AT"}}, // Q111172393
    {Coordinate{16.4929, 48.4513}, CountryId{"AT"}}, // Q111172394
    {Coordinate{16.5167, 48.3623}, CountryId{"AT"}}, // Q111172395
    {Coordinate{15.5747, 48.0014}, CountryId{"AT"}}, // Q111172396
    {Coordinate{14.4492, 48.0476}, CountryId{"AT"}}, // Q111172397
    {Coordinate{16.3031, 48.0174}, CountryId{"AT"}}, // Q111172398
    {Coordinate{15.6124, 48.0568}, CountryId{"AT"}}, // Q111172399
    {Coordinate{15.2741, 47.2184}, CountryId{"AT"}}, // Q111172614
    {Coordinate{15.47, 46.9643}, CountryId{"AT"}}, // Q111172615
    {Coordinate{13.9938, 48.3521}, CountryId{"AT"}}, // Q111172616
    {Coordinate{15.6079, 48.1006}, CountryId{"AT"}}, // Q111172617
    {Coordinate{14.638, 47.8507}, CountryId{"AT"}}, // Q111172618
    {Coordinate{15.1598, 48.2078}, CountryId{"AT"}}, // Q111172619
    {Coordinate{14.6992, 48.0552}, CountryId{"AT"}}, // Q111172620
    {Coordinate{14.6109, 47.8583}, CountryId{"AT"}}, // Q111172621
    {Coordinate{15.405, 48.1948}, CountryId{"AT"}}, // Q111172622
    {Coordinate{14.4784, 48.2887}, CountryId{"AT"}}, // Q111172623
    {Coordinate{14.0998, 48.2011}, CountryId{"AT"}}, // Q111172624
    {Coordinate{15.8481, 48.1916}, CountryId{"AT"}}, // Q111172626
    {Coordinate{15.7019, 48.2237}, CountryId{"AT"}}, // Q111172627
    {Coordinate{14.3937, 48.2783}, CountryId{"AT"}}, // Q111172628
    {Coordinate{16.7807, 48.107}, CountryId{"AT"}}, // Q111172629
    {Coordinate{16.6545, 48.3898}, CountryId{"AT"}}, // Q111172630
    {Coordinate{15.6144, 48.1378}, CountryId{"AT"}}, // Q111172631
    {Coordinate{10.7683, 48.1787}, CountryId{"DE"}}, // Schwabmünchen station
    {Coordinate{55.7709, 58.0747}, CountryId{"RU"}}, // Q111177132
    {Coordinate{59.3381, 57.0865}, CountryId{"RU"}}, // Q111183612
    {Coordinate{56.7835, 57.4563}, CountryId{"RU"}}, // Q111193503
    {Coordinate{56.8913, 57.4564}, CountryId{"RU"}}, // Q111193504
    {Coordinate{56.9211, 57.4231}, CountryId{"RU"}}, // Q111193505
    {Coordinate{56.9589, 57.4209}, CountryId{"RU"}}, // Q111193506
    {Coordinate{57.1129, 57.381}, CountryId{"RU"}}, // Q111193507
    {Coordinate{57.1545, 57.3521}, CountryId{"RU"}}, // Q111193508
    {Coordinate{57.2447, 57.3618}, CountryId{"RU"}}, // Q111193509
    {Coordinate{57.2842, 57.3754}, CountryId{"RU"}}, // Q111193511
    {Coordinate{57.3093, 57.3935}, CountryId{"RU"}}, // Q111193512
    {Coordinate{57.3602, 57.3751}, CountryId{"RU"}}, // Q111193513
    {Coordinate{57.4194, 57.3801}, CountryId{"RU"}}, // Q111193514
    {Coordinate{57.4532, 57.3916}, CountryId{"RU"}}, // Q111193515
    {Coordinate{57.5079, 57.4145}, CountryId{"RU"}}, // Q111193516
    {Coordinate{57.6241, 57.433}, CountryId{"RU"}}, // Q111193517
    {Coordinate{57.7628, 57.4035}, CountryId{"RU"}}, // Q111193518
    {Coordinate{57.9213, 57.4115}, CountryId{"RU"}}, // Q111193519
    {Coordinate{57.9868, 57.3764}, CountryId{"RU"}}, // Q111193520
    {Coordinate{58.0623, 57.3444}, CountryId{"RU"}}, // Q111193521
    {Coordinate{58.1344, 57.3258}, CountryId{"RU"}}, // Q111193522
    {Coordinate{58.2237, 57.3497}, CountryId{"RU"}}, // Q111193523
    {Coordinate{58.3714, 57.3436}, CountryId{"RU"}}, // Q111193525
    {Coordinate{58.5256, 57.3327}, CountryId{"RU"}}, // Q111193526
    {Coordinate{58.6388, 57.2713}, CountryId{"RU"}}, // Q111193527
    {Coordinate{58.7337, 57.2474}, CountryId{"RU"}}, // Q111193528
    {Coordinate{58.8607, 57.2291}, CountryId{"RU"}}, // Q111193529
    {Coordinate{58.9414, 57.1975}, CountryId{"RU"}}, // Q111193530
    {Coordinate{59.1177, 57.1454}, CountryId{"RU"}}, // Q111193531
    {Coordinate{59.194, 57.1116}, CountryId{"RU"}}, // Q111193532
    {Coordinate{11.48, 48.0187}, CountryId{"DE"}}, // Baierbrunn station
    {Coordinate{11.4974, 48.0313}, CountryId{"DE"}}, // Buchenhain station
    {Coordinate{59.5824, 57.0076}, CountryId{"RU"}}, // Q111204096
    {Coordinate{59.7288, 56.937}, CountryId{"RU"}}, // Q111204098
    {Coordinate{60.4051, 56.8807}, CountryId{"RU"}}, // Q111204099
    {Coordinate{6.91389, 46.4789}, CountryId{"CH"}}, // Lally railway station
    {Coordinate{57.7298, 58.1901}, CountryId{"RU"}}, // Q111206053
    {Coordinate{57.7809, 58.1118}, CountryId{"RU"}}, // Q111206055
    {Coordinate{57.7818, 58.0867}, CountryId{"RU"}}, // Q111206057
    {Coordinate{57.8086, 58.0601}, CountryId{"RU"}}, // Q111206059
    {Coordinate{58.0265, 57.868}, CountryId{"RU"}}, // Q111206064
    {Coordinate{58.355, 57.8627}, CountryId{"RU"}}, // Q111206066
    {Coordinate{58.5137, 57.7982}, CountryId{"RU"}}, // Q111206068
    {Coordinate{58.6277, 57.6862}, CountryId{"RU"}}, // Q111206070
    {Coordinate{58.6081, 57.638}, CountryId{"RU"}}, // Q111206072
    {Coordinate{58.6872, 57.5862}, CountryId{"RU"}}, // Q111206074
    {Coordinate{58.8123, 57.4567}, CountryId{"RU"}}, // Q111206076
    {Coordinate{58.958, 57.3658}, CountryId{"RU"}}, // Q111206078
    {Coordinate{59.0143, 57.2749}, CountryId{"RU"}}, // Q111206080
    {Coordinate{59.0641, 57.2488}, CountryId{"RU"}}, // Q111206083
    {Coordinate{59.2663, 57.1854}, CountryId{"RU"}}, // Q111206085
    {Coordinate{59.3433, 57.1649}, CountryId{"RU"}}, // Q111206087
    {Coordinate{59.6014, 56.7749}, CountryId{"RU"}}, // Q111206690
    {Coordinate{59.6925, 56.817}, CountryId{"RU"}}, // Q111206691
    {Coordinate{59.7188, 56.8047}, CountryId{"RU"}}, // Q111206693
    {Coordinate{59.7686, 56.7699}, CountryId{"RU"}}, // Q111206694
    {Coordinate{59.7686, 56.7699}, CountryId{"RU"}}, // Q111206696
    {Coordinate{59.9554, 56.8196}, CountryId{"RU"}}, // Q111206697
    {Coordinate{59.979, 56.8206}, CountryId{"RU"}}, // Q111206698
    {Coordinate{60.0348, 56.8115}, CountryId{"RU"}}, // Q111206699
    {Coordinate{60.1489, 56.8338}, CountryId{"RU"}}, // Q111206701
    {Coordinate{60.2207, 56.837}, CountryId{"RU"}}, // Q111206702
    {Coordinate{60.2546, 56.8464}, CountryId{"RU"}}, // Q111206703
    {Coordinate{60.3255, 56.8565}, CountryId{"RU"}}, // Q111206704
    {Coordinate{60.3714, 56.8626}, CountryId{"RU"}}, // Q111206705
    {Coordinate{60.1033, 56.8242}, CountryId{"RU"}}, // Q111206715
    {Coordinate{61.9673, 56.399}, CountryId{"RU"}}, // Q111219330
    {Coordinate{61.9553, 56.3785}, CountryId{"RU"}}, // Q111219331
    {Coordinate{61.945, 56.3538}, CountryId{"RU"}}, // Q111219332
    {Coordinate{61.9027, 56.3001}, CountryId{"RU"}}, // Q111219333
    {Coordinate{61.9002, 56.2931}, CountryId{"RU"}}, // Q111219335
    {Coordinate{61.8965, 56.2412}, CountryId{"RU"}}, // Q111219336
    {Coordinate{61.8874, 56.1944}, CountryId{"RU"}}, // Q111219337
    {Coordinate{61.9114, 56.1522}, CountryId{"RU"}}, // Q111219357
    {Coordinate{13.3869, 52.5203}, CountryId{"DE"}}, // S-Bahnhof Friedrichstraße
    {Coordinate{60.698, 56.8175}, CountryId{"RU"}}, // Putyovka
    {Coordinate{60.7277, 56.7949}, CountryId{"RU"}}, // Q111222291
    {Coordinate{60.7754, 56.7871}, CountryId{"RU"}}, // Q111222292
    {Coordinate{60.9899, 56.7137}, CountryId{"RU"}}, // Q111222295
    {Coordinate{61.0452, 56.6812}, CountryId{"RU"}}, // Q111222296
    {Coordinate{61.1355, 56.6604}, CountryId{"RU"}}, // Q111222297
    {Coordinate{61.1841, 56.6419}, CountryId{"RU"}}, // Q111222298
    {Coordinate{61.2244, 56.632}, CountryId{"RU"}}, // Q111222299
    {Coordinate{61.2558, 56.6233}, CountryId{"RU"}}, // Q111222300
    {Coordinate{61.2868, 56.6143}, CountryId{"RU"}}, // Q111222301
    {Coordinate{61.3125, 56.594}, CountryId{"RU"}}, // Q111222303
    {Coordinate{61.3559, 56.5857}, CountryId{"RU"}}, // Q111222304
    {Coordinate{61.3987, 56.5627}, CountryId{"RU"}}, // Q111222306
    {Coordinate{61.4469, 56.5499}, CountryId{"RU"}}, // Q111222307
    {Coordinate{61.5328, 56.5199}, CountryId{"RU"}}, // Q111222308
    {Coordinate{61.5789, 56.4975}, CountryId{"RU"}}, // Q111222310
    {Coordinate{61.634, 56.4848}, CountryId{"RU"}}, // Q111222311
    {Coordinate{61.6914, 56.471}, CountryId{"RU"}}, // Q111222312
    {Coordinate{61.7613, 56.4618}, CountryId{"RU"}}, // Q111222314
    {Coordinate{61.8295, 56.4529}, CountryId{"RU"}}, // Q111222315
    {Coordinate{61.8906, 56.4327}, CountryId{"RU"}}, // Q111222316
    {Coordinate{61.9569, 56.4226}, CountryId{"RU"}}, // Q111222908
    {Coordinate{62.0442, 56.4126}, CountryId{"RU"}}, // Q111222909
    {Coordinate{62.1512, 56.3938}, CountryId{"RU"}}, // Q111222910
    {Coordinate{19.9675, 46.4661}, CountryId{"HU"}}, // Kistelek railway station
    {Coordinate{13.3894, 52.5486}, CountryId{"DE"}}, // S-Bahnhof Berlin-Gesundbrunnen
    {Coordinate{57.281, 58.1037}, CountryId{"RU"}}, // Q111239744
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // S-Bahnhof Berlin-Hauptbahnhof
    {Coordinate{33.0346, 68.8787}, CountryId{"RU"}}, // 1437 km
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof (tief)
    {Coordinate{33.0247, 68.852}, CountryId{"RU"}}, // 1434 km
    {Coordinate{33.0815, 68.8366}, CountryId{"RU"}}, // Vykhodnoy
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof (Stadtbahn)
    {Coordinate{13.4747, 52.5142}, CountryId{"DE"}}, // S-Bahnhof Frankfurter Allee
    {Coordinate{13.4689, 52.5031}, CountryId{"DE"}}, // S-Bahnhof Ostkreuz
    {Coordinate{13.3326, 52.5782}, CountryId{"DE"}}, // S-Bahnhof Karl-Bonhoeffer-Nervenklinik
    {Coordinate{57.4093, 58.1415}, CountryId{"RU"}}, // Q111261549
    {Coordinate{57.476, 58.1723}, CountryId{"RU"}}, // Q111261550
    {Coordinate{57.5693, 58.1988}, CountryId{"RU"}}, // Q111261551
    {Coordinate{33.0986, 68.7942}, CountryId{"RU"}}, // 1425 km
    {Coordinate{13.4311, 52.4675}, CountryId{"DE"}}, // S-Bahnhof Hermannstraße
    {Coordinate{13.3439, 52.4786}, CountryId{"DE"}}, // S-Bahnhof Innsbrucker Platz
    {Coordinate{13.3216, 52.4562}, CountryId{"DE"}}, // S-Bahnhof Rathaus Steglitz
    {Coordinate{13.3343, 52.597}, CountryId{"DE"}}, // S-Bahnhof Berlin-Wittenau
    {Coordinate{13.3854, 52.4708}, CountryId{"DE"}}, // S-Bahnhof Berlin-Tempelhof
    {Coordinate{13.4137, 52.5493}, CountryId{"DE"}}, // S-Bahnhof Schönhauser Allee
    {Coordinate{57.9142, 58.3475}, CountryId{"RU"}}, // Q111265677
    {Coordinate{57.973, 58.3623}, CountryId{"RU"}}, // Q111265678
    {Coordinate{58.0624, 58.3608}, CountryId{"RU"}}, // Q111265679
    {Coordinate{58.2132, 58.3942}, CountryId{"RU"}}, // Q111265680
    {Coordinate{58.3237, 58.3801}, CountryId{"RU"}}, // Q111265681
    {Coordinate{58.4954, 58.4182}, CountryId{"RU"}}, // Q111265682
    {Coordinate{58.6569, 58.473}, CountryId{"RU"}}, // Q111265683
    {Coordinate{58.7779, 58.5034}, CountryId{"RU"}}, // Q111265685
    {Coordinate{58.88, 58.5144}, CountryId{"RU"}}, // Q111265686
    {Coordinate{59.4651, 58.4102}, CountryId{"RU"}}, // Q111265687
    {Coordinate{59.6617, 58.3159}, CountryId{"RU"}}, // Q111265688
    {Coordinate{33.16, 68.7538}, CountryId{"RU"}}, // Shonguy
    {Coordinate{33.1348, 68.7375}, CountryId{"RU"}}, // 1417 km
    {Coordinate{33.1221, 68.6991}, CountryId{"RU"}}, // 1410 km
    {Coordinate{33.1265, 68.68}, CountryId{"RU"}}, // Magnetity
    {Coordinate{33.2188, 68.6368}, CountryId{"RU"}}, // Loparskaya
    {Coordinate{14.0355, 46.5309}, CountryId{"AT"}}, // Q111267099
    {Coordinate{16.391, 48.1779}, CountryId{"AT"}}, // Q111267113
    {Coordinate{13.9133, 46.5644}, CountryId{"AT"}}, // Q111267114
    {Coordinate{16.5179, 47.7278}, CountryId{"AT"}}, // Q111267115
    {Coordinate{15.7579, 47.0457}, CountryId{"AT"}}, // Q111267116
    {Coordinate{16.9812, 48.0106}, CountryId{"AT"}}, // Q111267117
    {Coordinate{13.1335, 48.1608}, CountryId{"AT"}}, // Q111267118
    {Coordinate{16.3698, 47.7534}, CountryId{"AT"}}, // Q111267119
    {Coordinate{17.0715, 48.0814}, CountryId{"AT"}}, // Q111267120
    {Coordinate{16.9383, 48.0089}, CountryId{"AT"}}, // Q111267121
    {Coordinate{13.1524, 48.1087}, CountryId{"AT"}}, // Q111267123
    {Coordinate{12.5951, 46.7696}, CountryId{"AT"}}, // Q111267124
    {Coordinate{14.716, 46.5986}, CountryId{"AT"}}, // Q111267125
    {Coordinate{14.4311, 47.9241}, CountryId{"AT"}}, // Q111267126
    {Coordinate{14.5223, 48.356}, CountryId{"AT"}}, // Q111267127
    {Coordinate{17.0414, 48.0421}, CountryId{"AT"}}, // Q111267128
    {Coordinate{15.4496, 46.9977}, CountryId{"AT"}}, // Q111267129
    {Coordinate{13.1978, 48.0458}, CountryId{"AT"}}, // Q111267130
    {Coordinate{9.83892, 47.1363}, CountryId{"AT"}}, // Q111267131
    {Coordinate{14.4731, 48.0914}, CountryId{"AT"}}, // Q111267132
    {Coordinate{13.6285, 46.7329}, CountryId{"AT"}}, // Q111267133
    {Coordinate{13.8679, 46.5688}, CountryId{"AT"}}, // Q111267134
    {Coordinate{13.1398, 48.1319}, CountryId{"AT"}}, // Q111267136
    {Coordinate{14.3811, 46.7499}, CountryId{"AT"}}, // Q111267137
    {Coordinate{13.8469, 46.5684}, CountryId{"AT"}}, // Q111267138
    {Coordinate{14.0771, 48.3973}, CountryId{"AT"}}, // Q111267139
    {Coordinate{15.4576, 48.1881}, CountryId{"AT"}}, // Q111267140
    {Coordinate{15.9184, 48.1919}, CountryId{"AT"}}, // Q111267141
    {Coordinate{16.5163, 48.6203}, CountryId{"AT"}}, // Q111267142
    {Coordinate{15.3291, 47.4547}, CountryId{"AT"}}, // Q111267143
    {Coordinate{13.6698, 48.2666}, CountryId{"AT"}}, // Q111267144
    {Coordinate{15.8215, 48.1902}, CountryId{"AT"}}, // Q111267146
    {Coordinate{14.9036, 47.3899}, CountryId{"AT"}}, // Q111267147
    {Coordinate{13.9406, 47.8867}, CountryId{"AT"}}, // Q111267148
    {Coordinate{14.4756, 46.8376}, CountryId{"AT"}}, // Q111267149
    {Coordinate{14.789, 48.0426}, CountryId{"AT"}}, // Q111267150
    {Coordinate{14.3335, 46.6166}, CountryId{"AT"}}, // Q111267151
    {Coordinate{9.62448, 47.3086}, CountryId{"AT"}}, // Q111267153
    {Coordinate{14.0914, 48.3859}, CountryId{"AT"}}, // Q111267154
    {Coordinate{14.3738, 47.9948}, CountryId{"AT"}}, // Q111267155
    {Coordinate{16.3555, 48.0769}, CountryId{"AT"}}, // Q111267156
    {Coordinate{14.3472, 48.2521}, CountryId{"AT"}}, // Q111267157
    {Coordinate{15.5322, 46.8549}, CountryId{"AT"}}, // Q111267158
    {Coordinate{15.6983, 46.7139}, CountryId{"AT"}}, // Q111267159
    {Coordinate{14.254, 48.274}, CountryId{"AT"}}, // Q111267161
    {Coordinate{16.4475, 48.1132}, CountryId{"AT"}}, // Q111267162
    {Coordinate{14.5215, 48.4609}, CountryId{"AT"}}, // Q111267163
    {Coordinate{13.6424, 46.7252}, CountryId{"AT"}}, // Q111267164
    {Coordinate{14.3391, 46.6828}, CountryId{"AT"}}, // Q111267165
    {Coordinate{15.3733, 47.4733}, CountryId{"AT"}}, // Q111267166
    {Coordinate{14.3742, 47.1043}, CountryId{"AT"}}, // Q111267167
    {Coordinate{14.2585, 48.1895}, CountryId{"AT"}}, // Q111267168
    {Coordinate{16.1324, 47.6338}, CountryId{"AT"}}, // Q111267170
    {Coordinate{15.9239, 47.7957}, CountryId{"AT"}}, // Q111267171
    {Coordinate{13.6133, 47.3884}, CountryId{"AT"}}, // Q111267172
    {Coordinate{14.38, 48.2426}, CountryId{"AT"}}, // Q111267173
    {Coordinate{15.9581, 47.8959}, CountryId{"AT"}}, // Q111267174
    {Coordinate{14.8462, 46.825}, CountryId{"AT"}}, // Q111267175
    {Coordinate{13.8748, 47.4234}, CountryId{"AT"}}, // Q111267176
    {Coordinate{14.4694, 46.8069}, CountryId{"AT"}}, // Q111267178
    {Coordinate{13.5494, 48.2339}, CountryId{"AT"}}, // Q111267179
    {Coordinate{13.0905, 47.7131}, CountryId{"AT"}}, // Q111267180
    {Coordinate{11.0247, 47.2921}, CountryId{"AT"}}, // Q111267181
    {Coordinate{15.1525, 48.0217}, CountryId{"AT"}}, // Q111267182
    {Coordinate{16.6771, 48.0232}, CountryId{"AT"}}, // Q111267183
    {Coordinate{14.7509, 46.5823}, CountryId{"AT"}}, // Q111267184
    {Coordinate{16.5018, 48.3308}, CountryId{"AT"}}, // Q111267185
    {Coordinate{14.4988, 47.2122}, CountryId{"AT"}}, // Q111267186
    {Coordinate{13.9754, 48.6366}, CountryId{"AT"}}, // Q111267187
    {Coordinate{16.4899, 48.4221}, CountryId{"AT"}}, // Q111267189
    {Coordinate{13.2129, 48.0198}, CountryId{"AT"}}, // Q111267190
    {Coordinate{15.521, 46.8842}, CountryId{"AT"}}, // Q111267191
    {Coordinate{16.5075, 48.1365}, CountryId{"AT"}}, // Q111267192
    {Coordinate{13.7597, 46.6631}, CountryId{"AT"}}, // Q111267193
    {Coordinate{15.5424, 46.8022}, CountryId{"AT"}}, // Q111267194
    {Coordinate{16.1362, 47.8765}, CountryId{"AT"}}, // Q111267195
    {Coordinate{16.0515, 47.8676}, CountryId{"AT"}}, // Q111267197
    {Coordinate{16.5688, 48.5707}, CountryId{"AT"}}, // Q111267198
    {Coordinate{13.2198, 48.0085}, CountryId{"AT"}}, // Q111267199
    {Coordinate{16.4026, 47.7414}, CountryId{"AT"}}, // Q111267200
    {Coordinate{14.6404, 48.2425}, CountryId{"AT"}}, // Q111267202
    {Coordinate{15.5075, 47.0418}, CountryId{"AT"}}, // Q111267203
    {Coordinate{13.2454, 47.9767}, CountryId{"AT"}}, // Q111267205
    {Coordinate{12.4444, 46.7459}, CountryId{"AT"}}, // Q111267206
    {Coordinate{16.1893, 47.8488}, CountryId{"AT"}}, // Q111267368
    {Coordinate{13.701, 48.0354}, CountryId{"AT"}}, // Q111267369
    {Coordinate{15.6139, 47.5681}, CountryId{"AT"}}, // Q111267370
    {Coordinate{14.2755, 48.2495}, CountryId{"AT"}}, // Q111267371
    {Coordinate{14.1892, 46.7213}, CountryId{"AT"}}, // Q111267373
    {Coordinate{15.3603, 47.3316}, CountryId{"AT"}}, // Q111267375
    {Coordinate{14.5802, 48.2687}, CountryId{"AT"}}, // Q111267376
    {Coordinate{16.0329, 47.7907}, CountryId{"AT"}}, // Q111267377
    {Coordinate{16.0605, 47.7892}, CountryId{"AT"}}, // Q111267378
    {Coordinate{16.0511, 47.7892}, CountryId{"AT"}}, // Q111267379
    {Coordinate{15.9468, 47.8923}, CountryId{"AT"}}, // Q111267380
    {Coordinate{16.2098, 47.8119}, CountryId{"AT"}}, // Q111267381
    {Coordinate{13.1629, 48.096}, CountryId{"AT"}}, // Q111267382
    {Coordinate{15.4405, 47.0126}, CountryId{"AT"}}, // Q111267383
    {Coordinate{15.4631, 47.0399}, CountryId{"AT"}}, // Q111267384
    {Coordinate{14.3024, 46.6103}, CountryId{"AT"}}, // Q111267385
    {Coordinate{13.8757, 46.6301}, CountryId{"AT"}}, // Q111267386
    {Coordinate{16.4288, 47.7176}, CountryId{"AT"}}, // Q111267448
    {Coordinate{14.1524, 46.7321}, CountryId{"AT"}}, // Q111267449
    {Coordinate{16.0053, 47.8776}, CountryId{"AT"}}, // Q111267450
    {Coordinate{15.5124, 47.5366}, CountryId{"AT"}}, // Q111267451
    {Coordinate{14.8009, 48.095}, CountryId{"AT"}}, // Q111267453
    {Coordinate{16.3126, 48.029}, CountryId{"AT"}}, // Q111267454
    {Coordinate{16.5007, 48.4973}, CountryId{"AT"}}, // Q111267455
    {Coordinate{15.051, 48.1423}, CountryId{"AT"}}, // Q111267456
    {Coordinate{14.0392, 48.104}, CountryId{"AT"}}, // Q111267457
    {Coordinate{13.7669, 48.2459}, CountryId{"AT"}}, // Q111267458
    {Coordinate{14.17, 46.6282}, CountryId{"AT"}}, // Q111267459
    {Coordinate{15.9034, 46.7316}, CountryId{"AT"}}, // Q111267460
    {Coordinate{15.8125, 46.9763}, CountryId{"AT"}}, // Q111267462
    {Coordinate{16.8465, 48.412}, CountryId{"AT"}}, // Q111267463
    {Coordinate{14.6461, 48.0547}, CountryId{"AT"}}, // Q111267464
    {Coordinate{14.8157, 48.0749}, CountryId{"AT"}}, // Q111267465
    {Coordinate{14.0426, 48.0891}, CountryId{"AT"}}, // Q111267466
    {Coordinate{16.7589, 48.3495}, CountryId{"AT"}}, // Q111267467
    {Coordinate{14.0437, 48.0219}, CountryId{"AT"}}, // Q111267468
    {Coordinate{16.8019, 48.108}, CountryId{"AT"}}, // Q111267469
    {Coordinate{16.2199, 47.9203}, CountryId{"AT"}}, // Q111267472
    {Coordinate{16.2554, 47.8336}, CountryId{"AT"}}, // Q111267473
    {Coordinate{16.0768, 47.8737}, CountryId{"AT"}}, // Q111267474
    {Coordinate{15.9683, 47.8957}, CountryId{"AT"}}, // Q111267475
    {Coordinate{14.2057, 48.3215}, CountryId{"AT"}}, // Q111267476
    {Coordinate{16.1655, 47.8648}, CountryId{"AT"}}, // Q111267477
    {Coordinate{14.0513, 48.442}, CountryId{"AT"}}, // Q111267505
    {Coordinate{13.6657, 47.5917}, CountryId{"AT"}}, // Q111267506
    {Coordinate{15.7074, 48.0506}, CountryId{"AT"}}, // Q111267507
    {Coordinate{14.4509, 48.2709}, CountryId{"AT"}}, // Q111267508
    {Coordinate{16.1892, 48.2075}, CountryId{"AT"}}, // Q111267509
    {Coordinate{16.0898, 47.7974}, CountryId{"AT"}}, // Q111267510
    {Coordinate{16.1281, 48.1917}, CountryId{"AT"}}, // Q111267511
    {Coordinate{15.7198, 46.7147}, CountryId{"AT"}}, // Q111267512
    {Coordinate{15.6084, 48.1114}, CountryId{"AT"}}, // Q111267513
    {Coordinate{16.1113, 47.8107}, CountryId{"AT"}}, // Q111267515
    {Coordinate{16.178, 47.8615}, CountryId{"AT"}}, // Q111267516
    {Coordinate{14.6355, 47.7143}, CountryId{"AT"}}, // Q111267517
    {Coordinate{14.0291, 47.9806}, CountryId{"AT"}}, // Q111267519
    {Coordinate{13.0988, 48.2164}, CountryId{"AT"}}, // Q111267553
    {Coordinate{14.2647, 48.2365}, CountryId{"AT"}}, // Q111267554
    {Coordinate{14.5286, 48.2276}, CountryId{"AT"}}, // Q111267555
    {Coordinate{13.5335, 46.6003}, CountryId{"AT"}}, // Q111267556
    {Coordinate{16.1563, 47.7074}, CountryId{"AT"}}, // Q111267557
    {Coordinate{16.0929, 48.1861}, CountryId{"AT"}}, // Q111267558
    {Coordinate{14.1104, 46.6331}, CountryId{"AT"}}, // Q111267559
    {Coordinate{14.3547, 47.9303}, CountryId{"AT"}}, // Q111267560
    {Coordinate{16.0536, 47.0269}, CountryId{"AT"}}, // Q111267561
    {Coordinate{15.9577, 48.1818}, CountryId{"AT"}}, // Q111267563
    {Coordinate{16.2388, 47.835}, CountryId{"AT"}}, // Q111267564
    {Coordinate{15.6486, 48.0513}, CountryId{"AT"}}, // Q111267565
    {Coordinate{15.9815, 47.8014}, CountryId{"AT"}}, // Q111267567
    {Coordinate{15.1327, 48.1032}, CountryId{"AT"}}, // Q111267568
    {Coordinate{15.1404, 48.039}, CountryId{"AT"}}, // Q111267569
    {Coordinate{14.0087, 48.1359}, CountryId{"AT"}}, // Q111267570
    {Coordinate{15.6142, 48.1474}, CountryId{"AT"}}, // Q111267571
    {Coordinate{14.4278, 48.2272}, CountryId{"AT"}}, // Q111267572
    {Coordinate{12.2926, 44.3144}, CountryId{"IT"}}, // Lido di Classe-Lido di Savio railway station
    {Coordinate{13.4111, 52.5667}, CountryId{"DE"}}, // S-Bahnhof Pankow
    {Coordinate{59.4619, 58.4134}, CountryId{"RU"}}, // Q111276228
    {Coordinate{59.4564, 58.4865}, CountryId{"RU"}}, // Q111276230
    {Coordinate{59.4897, 58.5987}, CountryId{"RU"}}, // Q111276232
    {Coordinate{59.4997, 58.6142}, CountryId{"RU"}}, // Q111276235
    {Coordinate{59.5077, 58.6294}, CountryId{"RU"}}, // Q111276237
    {Coordinate{59.5058, 58.6534}, CountryId{"RU"}}, // Q111276239
    {Coordinate{59.51, 58.6821}, CountryId{"RU"}}, // Q111276242
    {Coordinate{33.1845, 68.5128}, CountryId{"RU"}}, // Kitsa
    {Coordinate{33.3469, 68.4357}, CountryId{"RU"}}, // Taybola
    {Coordinate{59.7187, 58.1668}, CountryId{"RU"}}, // Q111281391
    {Coordinate{59.7276, 58.1558}, CountryId{"RU"}}, // Q111281393
    {Coordinate{59.7684, 58.1079}, CountryId{"RU"}}, // Q111281396
    {Coordinate{59.8001, 58.091}, CountryId{"RU"}}, // Q111281399
    {Coordinate{59.8814, 58.0394}, CountryId{"RU"}}, // Q111281401
    {Coordinate{59.9581, 58.0083}, CountryId{"RU"}}, // Q111281402
    {Coordinate{59.9559, 57.9905}, CountryId{"RU"}}, // Q111281404
    {Coordinate{11.407, 47.2728}, CountryId{"AT"}}, // Q111286383
    {Coordinate{60.0214, 57.8238}, CountryId{"RU"}}, // Q111286400
    {Coordinate{60.4273, 56.9428}, CountryId{"RU"}}, // Q111286456
    {Coordinate{60.0156, 57.8921}, CountryId{"RU"}}, // Q111286778
    {Coordinate{60.0407, 57.7824}, CountryId{"RU"}}, // Q111286782
    {Coordinate{60.077, 57.743}, CountryId{"RU"}}, // Q111286785
    {Coordinate{60.1102, 57.6928}, CountryId{"RU"}}, // Q111286787
    {Coordinate{60.0978, 57.668}, CountryId{"RU"}}, // Q111286788
    {Coordinate{60.1103, 57.5849}, CountryId{"RU"}}, // Q111286790
    {Coordinate{60.1976, 57.4362}, CountryId{"RU"}}, // Q111286792
    {Coordinate{60.1739, 57.0551}, CountryId{"RU"}}, // Q111286794
    {Coordinate{60.2512, 57.0338}, CountryId{"RU"}}, // Q111286795
    {Coordinate{60.353, 57.0055}, CountryId{"RU"}}, // Q111286798
    {Coordinate{60.4583, 56.9027}, CountryId{"RU"}}, // Q111286800
    {Coordinate{59.8282, 58.6323}, CountryId{"RU"}}, // Q111287045
    {Coordinate{59.8925, 58.618}, CountryId{"RU"}}, // Q111287068
    {Coordinate{59.8482, 58.6362}, CountryId{"RU"}}, // Q111287071
    {Coordinate{60.3979, 58.7085}, CountryId{"RU"}}, // Q111287072
    {Coordinate{60.721, 58.8818}, CountryId{"RU"}}, // Q111287083
    {Coordinate{60.6091, 59.0511}, CountryId{"RU"}}, // Q111287101
    {Coordinate{60.4889, 59.1791}, CountryId{"RU"}}, // Q111287105
    {Coordinate{60.4746, 59.262}, CountryId{"RU"}}, // Q111287112
    {Coordinate{60.5399, 58.7487}, CountryId{"RU"}}, // Q111287468
    {Coordinate{60.6152, 56.7675}, CountryId{"RU"}}, // Q111293396
    {Coordinate{60.6087, 56.7505}, CountryId{"RU"}}, // Q111293397
    {Coordinate{60.5871, 56.711}, CountryId{"RU"}}, // Q111293398
    {Coordinate{60.5777, 56.6772}, CountryId{"RU"}}, // Q111293399
    {Coordinate{60.5519, 56.646}, CountryId{"RU"}}, // Q111293400
    {Coordinate{60.5099, 56.6209}, CountryId{"RU"}}, // Q111293401
    {Coordinate{60.3949, 56.5361}, CountryId{"RU"}}, // Q111293403
    {Coordinate{60.3455, 56.4795}, CountryId{"RU"}}, // Q111293404
    {Coordinate{60.7583, 56.8056}, CountryId{"RU"}}, // Q111301108
    {Coordinate{60.7881, 56.7874}, CountryId{"RU"}}, // Q111301109
    {Coordinate{60.8211, 56.7714}, CountryId{"RU"}}, // Q111301111
    {Coordinate{60.9124, 56.7634}, CountryId{"RU"}}, // Q111301112
    {Coordinate{60.9391, 56.7728}, CountryId{"RU"}}, // Q111301114
    {Coordinate{60.9724, 56.7537}, CountryId{"RU"}}, // Q111301115
    {Coordinate{61.0379, 56.7477}, CountryId{"RU"}}, // Q111301116
    {Coordinate{61.0664, 56.7497}, CountryId{"RU"}}, // Q111301118
    {Coordinate{61.1264, 56.7501}, CountryId{"RU"}}, // Q111301119
    {Coordinate{61.1968, 56.7471}, CountryId{"RU"}}, // Q111301120
    {Coordinate{61.2614, 56.7406}, CountryId{"RU"}}, // Q111301121
    {Coordinate{61.507, 56.7349}, CountryId{"RU"}}, // Q111301122
    {Coordinate{61.6117, 56.7401}, CountryId{"RU"}}, // Q111301124
    {Coordinate{61.8755, 56.7664}, CountryId{"RU"}}, // Q111301126
    {Coordinate{61.9241, 56.7723}, CountryId{"RU"}}, // Q111301127
    {Coordinate{13.5746, 52.4122}, CountryId{"DE"}}, // S-Bahnhof Grünau
    {Coordinate{62.201, 56.7893}, CountryId{"RU"}}, // Q111309907
    {Coordinate{62.2873, 56.7985}, CountryId{"RU"}}, // Q111309908
    {Coordinate{62.3867, 56.8088}, CountryId{"RU"}}, // Q111309909
    {Coordinate{62.4881, 56.8128}, CountryId{"RU"}}, // Q111309910
    {Coordinate{62.9729, 56.9055}, CountryId{"RU"}}, // Q111309911
    {Coordinate{63.2662, 56.9764}, CountryId{"RU"}}, // Q111309912
    {Coordinate{63.3967, 57.0194}, CountryId{"RU"}}, // Q111309913
    {Coordinate{63.4658, 57.0315}, CountryId{"RU"}}, // Q111309914
    {Coordinate{63.6676, 57.0644}, CountryId{"RU"}}, // Q111309915
    {Coordinate{63.866, 57.0744}, CountryId{"RU"}}, // Q111309916
    {Coordinate{63.9437, 57.0777}, CountryId{"RU"}}, // Q111309917
    {Coordinate{64.0652, 57.0753}, CountryId{"RU"}}, // Q111309918
    {Coordinate{64.0652, 57.0753}, CountryId{"RU"}}, // Q111309919
    {Coordinate{64.2647, 57.0739}, CountryId{"RU"}}, // Q111309920
    {Coordinate{64.6239, 57.0655}, CountryId{"RU"}}, // Q111309921
    {Coordinate{64.8547, 57.0956}, CountryId{"RU"}}, // Q111309922
    {Coordinate{64.9202, 57.1051}, CountryId{"RU"}}, // Q111309923
    {Coordinate{65.008, 57.1121}, CountryId{"RU"}}, // Q111309925
    {Coordinate{65.0311, 57.1138}, CountryId{"RU"}}, // Q111309926
    {Coordinate{65.164, 57.1237}, CountryId{"RU"}}, // Q111309927
    {Coordinate{65.187, 57.1253}, CountryId{"RU"}}, // Q111309928
    {Coordinate{65.2264, 57.1284}, CountryId{"RU"}}, // Q111309929
    {Coordinate{65.2679, 57.1325}, CountryId{"RU"}}, // Q111309931
    {Coordinate{65.3566, 57.1411}, CountryId{"RU"}}, // Q111309932
    {Coordinate{65.4428, 57.1494}, CountryId{"RU"}}, // Q111309933
    {Coordinate{65.4757, 57.152}, CountryId{"RU"}}, // Q111309935
    {Coordinate{33.2972, 68.3584}, CountryId{"RU"}}, // Pulozero
    {Coordinate{33.3253, 68.2727}, CountryId{"RU"}}, // Laplandiya
    {Coordinate{13.3289, 52.43}, CountryId{"DE"}}, // S-Bahnhof Berlin Lichterfelde-Ost
    {Coordinate{13.3289, 52.43}, CountryId{"DE"}}, // Regionalbahnhof Berlin Lichterfelde-Ost
    {Coordinate{33.3539, 68.0581}, CountryId{"RU"}}, // Yagelny Bor
    {Coordinate{33.3949, 67.9968}, CountryId{"RU"}}, // Kuna
    {Coordinate{13.3644, 52.4756}, CountryId{"DE"}}, // S-Bahnhof Berlin Südkreuz
    {Coordinate{}, CountryId{"DE"}}, // Fern- und Regionalbahnhof Berlin-Südkreuz
    {Coordinate{13.5094, 52.455}, CountryId{"DE"}}, // S-Bahnhof Berlin Schöneweide
    {Coordinate{13.5094, 52.455}, CountryId{"DE"}}, // Regionalbahnhof Berlin-Schöneweide
    {Coordinate{13.4119, 52.5214}, CountryId{"DE"}}, // S-Bahnhof Berlin Alexanderplatz
    {Coordinate{13.4119, 52.5214}, CountryId{"DE"}}, // Regionalbahnhof Berlin Alexanderplatz
    {Coordinate{13.4347, 52.51}, CountryId{"DE"}}, // S-Bahnhof Berlin Ostbahnhof
    {Coordinate{13.2089, 52.532}, CountryId{"DE"}}, // S-Bahnhof Berlin Stresow
    {Coordinate{33.335, 67.9429}, CountryId{"RU"}}, // Rudny
    {Coordinate{13.2994, 52.5303}, CountryId{"DE"}}, // Regionalbahnhof Berlin Jungfernheide
    {Coordinate{59.9755, 57.9515}, CountryId{"RU"}}, // Q111327809
    {Coordinate{60.2519, 57.9731}, CountryId{"RU"}}, // Q111327811
    {Coordinate{60.2744, 57.976}, CountryId{"RU"}}, // Q111327812
    {Coordinate{60.38, 58.0195}, CountryId{"RU"}}, // Q111327813
    {Coordinate{60.5573, 58.0597}, CountryId{"RU"}}, // Q111327814
    {Coordinate{60.579, 58.0716}, CountryId{"RU"}}, // Q111327815
    {Coordinate{60.6422, 58.0806}, CountryId{"RU"}}, // Q111327816
    {Coordinate{60.7266, 58.0874}, CountryId{"RU"}}, // Q111327818
    {Coordinate{60.9252, 58.0088}, CountryId{"RU"}}, // Q111327819
    {Coordinate{61.1786, 57.9438}, CountryId{"RU"}}, // Q111327820
    {Coordinate{61.4, 57.9134}, CountryId{"RU"}}, // Q111327821
    {Coordinate{61.5536, 57.8845}, CountryId{"RU"}}, // Q111327822
    {Coordinate{7.1393, 50.0909}, CountryId{"DE"}}, // Neef railway station
    {Coordinate{61.7037, 57.8377}, CountryId{"RU"}}, // Q111336137
    {Coordinate{61.7097, 57.7853}, CountryId{"RU"}}, // Q111336138
    {Coordinate{61.7474, 57.6821}, CountryId{"RU"}}, // Q111336139
    {Coordinate{61.7647, 57.6544}, CountryId{"RU"}}, // Q111336140
    {Coordinate{61.7785, 57.606}, CountryId{"RU"}}, // Q111336141
    {Coordinate{61.8174, 57.4935}, CountryId{"RU"}}, // Q111336142
    {Coordinate{61.8666, 57.3964}, CountryId{"RU"}}, // Q111336143
    {Coordinate{61.8884, 57.3412}, CountryId{"RU"}}, // Q111336209
    {Coordinate{61.8856, 57.2975}, CountryId{"RU"}}, // Q111336210
    {Coordinate{61.8951, 57.2151}, CountryId{"RU"}}, // Q111336211
    {Coordinate{61.9082, 57.1512}, CountryId{"RU"}}, // Q111336212
    {Coordinate{61.952, 57.0747}, CountryId{"RU"}}, // Q111336213
    {Coordinate{61.9866, 56.9919}, CountryId{"RU"}}, // Q111336215
    {Coordinate{62.0007, 56.958}, CountryId{"RU"}}, // Q111336216
    {Coordinate{62.0447, 56.8895}, CountryId{"RU"}}, // Q111336218
    {Coordinate{62.0584, 56.8113}, CountryId{"RU"}}, // Q111336219
    {Coordinate{33.189, 67.7665}, CountryId{"RU"}}, // Nefelinovye Peski
    {Coordinate{33.212, 67.673}, CountryId{"RU"}}, // Khibiny
    {Coordinate{32.9996, 67.4313}, CountryId{"RU"}}, // Khabozero
    {Coordinate{62.0161, 56.7594}, CountryId{"RU"}}, // Q111366202
    {Coordinate{61.9889, 56.704}, CountryId{"RU"}}, // Q111366203
    {Coordinate{61.9706, 56.6486}, CountryId{"RU"}}, // Q111366204
    {Coordinate{61.9684, 56.6216}, CountryId{"RU"}}, // Q111366205
    {Coordinate{61.9563, 56.5918}, CountryId{"RU"}}, // Q111366206
    {Coordinate{61.9411, 56.5591}, CountryId{"RU"}}, // Q111366207
    {Coordinate{61.9305, 56.5364}, CountryId{"RU"}}, // Q111366208
    {Coordinate{61.9047, 56.4808}, CountryId{"RU"}}, // Q111366209
    {Coordinate{61.8997, 56.4391}, CountryId{"RU"}}, // Q111366210
    {Coordinate{14.8727, 40.6403}, CountryId{"IT"}}, // Pontecagnano railway station
    {Coordinate{56.518, 58.2095}, CountryId{"RU"}}, // Q111371040
    {Coordinate{57.3657, 58.8391}, CountryId{"RU"}}, // Q111372260
    {Coordinate{57.182, 58.8328}, CountryId{"RU"}}, // Q111372261
    {Coordinate{57.1665, 58.7923}, CountryId{"RU"}}, // Q111372262
    {Coordinate{57.1404, 58.7775}, CountryId{"RU"}}, // Q111372263
    {Coordinate{57.1053, 58.7688}, CountryId{"RU"}}, // Q111372264
    {Coordinate{57.0602, 58.7486}, CountryId{"RU"}}, // Q111372265
    {Coordinate{56.9577, 58.6944}, CountryId{"RU"}}, // Q111372266
    {Coordinate{56.9474, 58.6844}, CountryId{"RU"}}, // Q111372267
    {Coordinate{56.9474, 58.6219}, CountryId{"RU"}}, // Q111372270
    {Coordinate{56.7761, 58.5121}, CountryId{"RU"}}, // Q111372272
    {Coordinate{56.756, 58.4868}, CountryId{"RU"}}, // Q111372273
    {Coordinate{56.6904, 58.437}, CountryId{"RU"}}, // Q111372274
    {Coordinate{56.7057, 58.3856}, CountryId{"RU"}}, // Q111372275
    {Coordinate{56.6712, 58.3543}, CountryId{"RU"}}, // Q111372277
    {Coordinate{56.6623, 58.3119}, CountryId{"RU"}}, // Q111372278
    {Coordinate{56.6222, 58.303}, CountryId{"RU"}}, // Q111372280
    {Coordinate{56.6163, 58.265}, CountryId{"RU"}}, // Q111372281
    {Coordinate{32.7781, 67.4426}, CountryId{"RU"}}, // Afrikanda
    {Coordinate{32.6108, 67.4105}, CountryId{"RU"}}, // Vostochnaya Guba
    {Coordinate{56.7324, 59.6334}, CountryId{"RU"}}, // Q111382377
    {Coordinate{57.1985, 59.3194}, CountryId{"RU"}}, // Q111382557
    {Coordinate{57.2627, 59.3275}, CountryId{"RU"}}, // Q111382558
    {Coordinate{57.4473, 59.2262}, CountryId{"RU"}}, // Q111382559
    {Coordinate{57.4784, 59.1878}, CountryId{"RU"}}, // Q111382560
    {Coordinate{57.5694, 59.1558}, CountryId{"RU"}}, // Q111382561
    {Coordinate{57.5605, 59.0587}, CountryId{"RU"}}, // Q111382562
    {Coordinate{57.6048, 59.049}, CountryId{"RU"}}, // Q111382563
    {Coordinate{57.6503, 59.0544}, CountryId{"RU"}}, // Q111382564
    {Coordinate{57.6655, 59.0292}, CountryId{"RU"}}, // Q111382565
    {Coordinate{57.0153, 59.3352}, CountryId{"RU"}}, // Q111382645
    {Coordinate{57.0726, 59.3302}, CountryId{"RU"}}, // Q111382647
    {Coordinate{57.1331, 59.3283}, CountryId{"RU"}}, // Q111382649
    {Coordinate{57.5385, 58.7713}, CountryId{"RU"}}, // Q111382872
    {Coordinate{57.5947, 58.6876}, CountryId{"RU"}}, // Usva
    {Coordinate{57.6278, 58.6546}, CountryId{"RU"}}, // Q111382874
    {Coordinate{57.674, 58.617}, CountryId{"RU"}}, // Q111382875
    {Coordinate{57.7579, 58.5756}, CountryId{"RU"}}, // Q111382876
    {Coordinate{57.7406, 58.5091}, CountryId{"RU"}}, // Q111382877
    {Coordinate{57.7603, 58.4727}, CountryId{"RU"}}, // Q111382878
    {Coordinate{57.7491, 58.4335}, CountryId{"RU"}}, // Q111382879
    {Coordinate{57.7435, 58.3489}, CountryId{"RU"}}, // Q111382880
    {Coordinate{57.7868, 58.327}, CountryId{"RU"}}, // Q111382881
    {Coordinate{60.6365, 59.6148}, CountryId{"RU"}}, // Q111382992
    {Coordinate{11.3968, 45.2304}, CountryId{"IT"}}, // Bevilacqua railway station
    {Coordinate{60.5923, 59.56}, CountryId{"RU"}}, // Q111397223
    {Coordinate{60.588, 59.5367}, CountryId{"RU"}}, // Q111397224
    {Coordinate{60.5373, 59.4811}, CountryId{"RU"}}, // Q111397225
    {Coordinate{60.5196, 59.428}, CountryId{"RU"}}, // Q111397226
    {Coordinate{60.4757, 59.3643}, CountryId{"RU"}}, // Q111397227
    {Coordinate{60.4746, 59.3157}, CountryId{"RU"}}, // Q111397228
    {Coordinate{60.5081, 59.1242}, CountryId{"RU"}}, // Q111397229
    {Coordinate{60.6849, 58.8616}, CountryId{"RU"}}, // Q111397230
    {Coordinate{60.6022, 58.7879}, CountryId{"RU"}}, // Q111397231
    {Coordinate{59.9585, 58.5138}, CountryId{"RU"}}, // Q111397232
    {Coordinate{59.9267, 58.4104}, CountryId{"RU"}}, // Q111397233
    {Coordinate{61.5124, 57.0048}, CountryId{"RU"}}, // Q111420846
    {Coordinate{61.3429, 56.7699}, CountryId{"RU"}}, // Q111421109
    {Coordinate{61.3534, 56.7857}, CountryId{"RU"}}, // Q111421110
    {Coordinate{61.3933, 56.8567}, CountryId{"RU"}}, // Q111421111
    {Coordinate{61.4625, 56.9671}, CountryId{"RU"}}, // Q111421114
    {Coordinate{61.4269, 56.917}, CountryId{"RU"}}, // Q111421133
    {Coordinate{61.6765, 57.0982}, CountryId{"RU"}}, // Q111421185
    {Coordinate{61.7179, 57.13}, CountryId{"RU"}}, // Q111421242
    {Coordinate{61.825, 57.1493}, CountryId{"RU"}}, // Q111421247
    {Coordinate{65.9202, 59.5696}, CountryId{"RU"}}, // Q111427171
    {Coordinate{63.5517, 57.9279}, CountryId{"RU"}}, // Q111427182
    {Coordinate{66.0128, 59.3222}, CountryId{"RU"}}, // Q111434227
    {Coordinate{66.0777, 59.0656}, CountryId{"RU"}}, // Q111434228
    {Coordinate{65.9787, 58.8053}, CountryId{"RU"}}, // Q111434230
    {Coordinate{65.677, 58.4391}, CountryId{"RU"}}, // Q111434231
    {Coordinate{65.5199, 58.2434}, CountryId{"RU"}}, // Q111434232
    {Coordinate{65.1123, 58.0478}, CountryId{"RU"}}, // Q111434233
    {Coordinate{64.7885, 58.0424}, CountryId{"RU"}}, // Q111434235
    {Coordinate{64.4285, 58.0158}, CountryId{"RU"}}, // Q111434236
    {Coordinate{64.162, 58.043}, CountryId{"RU"}}, // Q111434238
    {Coordinate{63.9915, 58.0334}, CountryId{"RU"}}, // Q111434239
    {Coordinate{63.7485, 58.0455}, CountryId{"RU"}}, // Q111434241
    {Coordinate{63.6961, 58.0084}, CountryId{"RU"}}, // Q111434242
    {Coordinate{63.4115, 57.8595}, CountryId{"RU"}}, // Q111434243
    {Coordinate{63.3765, 57.844}, CountryId{"RU"}}, // Q111434244
    {Coordinate{63.2245, 57.7647}, CountryId{"RU"}}, // Q111434246
    {Coordinate{63.0442, 57.6713}, CountryId{"RU"}}, // Q111434247
    {Coordinate{63.0086, 57.6698}, CountryId{"RU"}}, // Q111434248
    {Coordinate{62.8927, 57.6113}, CountryId{"RU"}}, // Q111434249
    {Coordinate{62.8479, 57.5805}, CountryId{"RU"}}, // Q111434250
    {Coordinate{62.7315, 57.5433}, CountryId{"RU"}}, // Q111434252
    {Coordinate{62.6503, 57.5139}, CountryId{"RU"}}, // Q111434254
    {Coordinate{62.5286, 57.4688}, CountryId{"RU"}}, // Q111434257
    {Coordinate{62.4605, 57.4452}, CountryId{"RU"}}, // Q111434258
    {Coordinate{62.3083, 57.3859}, CountryId{"RU"}}, // Q111434259
    {Coordinate{62.1326, 57.3818}, CountryId{"RU"}}, // Q111434260
    {Coordinate{61.8309, 57.3585}, CountryId{"RU"}}, // Q111434805
    {Coordinate{61.7995, 57.3604}, CountryId{"RU"}}, // Q111434806
    {Coordinate{61.7258, 57.3724}, CountryId{"RU"}}, // Q111434807
    {Coordinate{61.6859, 57.3702}, CountryId{"RU"}}, // Q111434808
    {Coordinate{61.6434, 57.3639}, CountryId{"RU"}}, // Q111434809
    {Coordinate{61.4952, 57.3569}, CountryId{"RU"}}, // Q111434810
    {Coordinate{61.3332, 57.3125}, CountryId{"RU"}}, // Q111434811
    {Coordinate{61.2286, 57.2656}, CountryId{"RU"}}, // Q111434812
    {Coordinate{61.1045, 57.2137}, CountryId{"RU"}}, // Q111434813
    {Coordinate{61.0478, 57.1447}, CountryId{"RU"}}, // Q111434814
    {Coordinate{60.9604, 57.1188}, CountryId{"RU"}}, // Q111434815
    {Coordinate{60.7744, 57.0071}, CountryId{"RU"}}, // Q111434817
    {Coordinate{60.723, 56.9536}, CountryId{"RU"}}, // Q111434818
    {Coordinate{60.9306, 57.1}, CountryId{"RU"}}, // Q111434826
    {Coordinate{65.6402, 57.1018}, CountryId{"RU"}}, // Q111435066
    {Coordinate{32.498, 67.3173}, CountryId{"RU"}}, // Pinozero
    {Coordinate{32.4751, 67.2999}, CountryId{"RU"}}, // 1189 km
    {Coordinate{32.4532, 67.278}, CountryId{"RU"}}, // 1186 km
    {Coordinate{32.4279, 67.2426}, CountryId{"RU"}}, // Plesozero
    {Coordinate{32.4575, 67.1983}, CountryId{"RU"}}, // 1178 km
    {Coordinate{32.46, 67.1867}, CountryId{"RU"}}, // 1176 km
    {Coordinate{65.5834, 57.1236}, CountryId{"RU"}}, // Q111443718
    {Coordinate{65.6081, 57.1141}, CountryId{"RU"}}, // Q111443720
    {Coordinate{32.2766, 67.1466}, CountryId{"RU"}}, // Prolivy
    {Coordinate{32.2645, 67.0802}, CountryId{"RU"}}, // Beloye More
    {Coordinate{32.2037, 67.0363}, CountryId{"RU"}}, // 1147 km
    {Coordinate{65.6487, 57.0985}, CountryId{"RU"}}, // Q111453895
    {Coordinate{65.7313, 57.0389}, CountryId{"RU"}}, // Q111453898
    {Coordinate{65.7788, 56.9691}, CountryId{"RU"}}, // Q111453901
    {Coordinate{65.8192, 56.9368}, CountryId{"RU"}}, // Q111453904
    {Coordinate{65.8939, 56.8919}, CountryId{"RU"}}, // Q111453906
    {Coordinate{65.9528, 56.8524}, CountryId{"RU"}}, // Q111453909
    {Coordinate{65.9774, 56.836}, CountryId{"RU"}}, // Q111453911
    {Coordinate{66.0657, 56.7779}, CountryId{"RU"}}, // Q111453912
    {Coordinate{66.1914, 56.7018}, CountryId{"RU"}}, // Q111453914
    {Coordinate{66.2631, 56.6693}, CountryId{"RU"}}, // Q111453916
    {Coordinate{66.3099, 56.6615}, CountryId{"RU"}}, // Q111453919
    {Coordinate{66.3689, 56.6439}, CountryId{"RU"}}, // Q111453922
    {Coordinate{66.4248, 56.5688}, CountryId{"RU"}}, // Q111453925
    {Coordinate{66.5426, 56.5132}, CountryId{"RU"}}, // Q111453928
    {Coordinate{66.6561, 56.4981}, CountryId{"RU"}}, // Q111453930
    {Coordinate{66.7023, 56.4943}, CountryId{"RU"}}, // Q111453933
    {Coordinate{66.8886, 56.4801}, CountryId{"RU"}}, // Q111453935
    {Coordinate{66.9525, 56.4754}, CountryId{"RU"}}, // Q111453937
    {Coordinate{67.0807, 56.4795}, CountryId{"RU"}}, // Q111453938
    {Coordinate{67.3063, 56.4742}, CountryId{"RU"}}, // Q111453939
    {Coordinate{67.5096, 56.4665}, CountryId{"RU"}}, // Q111453940
    {Coordinate{67.6687, 56.4627}, CountryId{"RU"}}, // Q111453942
    {Coordinate{67.9857, 56.4315}, CountryId{"RU"}}, // Q111453944
    {Coordinate{68.3773, 56.3899}, CountryId{"RU"}}, // Q111453947
    {Coordinate{68.5446, 56.3699}, CountryId{"RU"}}, // Q111453950
    {Coordinate{68.9277, 56.283}, CountryId{"RU"}}, // Q111453951
    {Coordinate{69.2738, 56.1933}, CountryId{"RU"}}, // Q111453954
    {Coordinate{69.547, 56.0996}, CountryId{"RU"}}, // Q111453956
    {Coordinate{69.5639, 56.0784}, CountryId{"RU"}}, // Q111453957
    {Coordinate{69.6797, 56.0767}, CountryId{"RU"}}, // Q111453958
    {Coordinate{69.793, 56.0269}, CountryId{"RU"}}, // Q111453959
    {Coordinate{69.9526, 55.9829}, CountryId{"RU"}}, // Q111453960
    {Coordinate{70.1166, 55.9375}, CountryId{"RU"}}, // Q111453961
    {Coordinate{70.1384, 55.9315}, CountryId{"RU"}}, // Q111453964
    {Coordinate{70.2837, 55.8908}, CountryId{"RU"}}, // Q111453966
    {Coordinate{70.4472, 55.8577}, CountryId{"RU"}}, // Q111453969
    {Coordinate{70.6077, 55.8163}, CountryId{"RU"}}, // Q111453973
    {Coordinate{70.7603, 55.7767}, CountryId{"RU"}}, // Q111453975
    {Coordinate{70.8083, 55.7556}, CountryId{"RU"}}, // Q111453977
    {Coordinate{70.9109, 55.7231}, CountryId{"RU"}}, // Q111453978
    {Coordinate{71.0615, 55.6698}, CountryId{"RU"}}, // Q111453979
    {Coordinate{71.1298, 55.6399}, CountryId{"RU"}}, // Q111453980
    {Coordinate{71.217, 55.6068}, CountryId{"RU"}}, // Q111453981
    {Coordinate{60.4789, 60.657}, CountryId{"RU"}}, // Q111462179
    {Coordinate{60.401, 60.6549}, CountryId{"RU"}}, // Q111462320
    {Coordinate{60.3929, 60.4408}, CountryId{"RU"}}, // Q111462321
    {Coordinate{60.4077, 60.4095}, CountryId{"RU"}}, // Q111462322
    {Coordinate{60.4213, 60.2931}, CountryId{"RU"}}, // Q111462323
    {Coordinate{60.4118, 60.2096}, CountryId{"RU"}}, // Q111462324
    {Coordinate{60.4569, 60.1097}, CountryId{"RU"}}, // Q111462325
    {Coordinate{60.4708, 60.0478}, CountryId{"RU"}}, // Q111462326
    {Coordinate{60.5745, 59.9233}, CountryId{"RU"}}, // Q111462327
    {Coordinate{60.639, 59.8486}, CountryId{"RU"}}, // Q111462328
    {Coordinate{60.6256, 59.7565}, CountryId{"RU"}}, // Q111462329
    {Coordinate{60.6023, 59.5968}, CountryId{"RU"}}, // Q111462377
    {Coordinate{61.7552, 59.1385}, CountryId{"RU"}}, // Q111462495
    {Coordinate{60.6677, 59.6118}, CountryId{"RU"}}, // Q111463772
    {Coordinate{60.7138, 59.6017}, CountryId{"RU"}}, // Q111463773
    {Coordinate{60.7563, 59.605}, CountryId{"RU"}}, // Q111463774
    {Coordinate{60.8082, 59.5638}, CountryId{"RU"}}, // Q111463775
    {Coordinate{60.8327, 59.5373}, CountryId{"RU"}}, // Q111463776
    {Coordinate{60.9112, 59.4991}, CountryId{"RU"}}, // Q111463777
    {Coordinate{61.0315, 59.4805}, CountryId{"RU"}}, // Q111463778
    {Coordinate{61.0703, 59.4703}, CountryId{"RU"}}, // Q111463779
    {Coordinate{61.2087, 59.3978}, CountryId{"RU"}}, // Q111463781
    {Coordinate{61.2612, 59.3796}, CountryId{"RU"}}, // Q111463782
    {Coordinate{61.5861, 59.2153}, CountryId{"RU"}}, // Q111463783
    {Coordinate{61.6358, 59.2047}, CountryId{"RU"}}, // Q111463784
    {Coordinate{61.8031, 59.0988}, CountryId{"RU"}}, // Q111463785
    {Coordinate{61.7868, 58.9282}, CountryId{"RU"}}, // Q111463787
    {Coordinate{61.799, 58.8045}, CountryId{"RU"}}, // Q111463788
    {Coordinate{61.7889, 58.7534}, CountryId{"RU"}}, // Q111463789
    {Coordinate{61.7997, 58.7183}, CountryId{"RU"}}, // Q111463792
    {Coordinate{61.783, 58.6323}, CountryId{"RU"}}, // Q111463795
    {Coordinate{61.7542, 58.5225}, CountryId{"RU"}}, // Q111463798
    {Coordinate{61.7477, 58.4433}, CountryId{"RU"}}, // Q111463801
    {Coordinate{61.7689, 58.4064}, CountryId{"RU"}}, // Q111463806
    {Coordinate{61.7637, 58.3438}, CountryId{"RU"}}, // Q111463810
    {Coordinate{61.7296, 58.2418}, CountryId{"RU"}}, // Q111463815
    {Coordinate{61.729, 58.1572}, CountryId{"RU"}}, // Q111463819
    {Coordinate{61.7251, 58.1284}, CountryId{"RU"}}, // Q111463823
    {Coordinate{61.7204, 58.0355}, CountryId{"RU"}}, // Q111463828
    {Coordinate{61.7154, 57.9953}, CountryId{"RU"}}, // Q111463833
    {Coordinate{61.7961, 59.0724}, CountryId{"RU"}}, // Q111463976
    {Coordinate{61.8219, 59.1657}, CountryId{"RU"}}, // Q111464797
    {Coordinate{32.1911, 67.0048}, CountryId{"RU"}}, // Ruchyi-Karelskiye
    {Coordinate{32.2089, 66.9215}, CountryId{"RU"}}, // Zhemchuzhnaya
    {Coordinate{32.3551, 66.8195}, CountryId{"RU"}}, // Knyazhaya
    {Coordinate{74.2043, 61.4989}, CountryId{"RU"}}, // Q111465505
    {Coordinate{74.0177, 61.4509}, CountryId{"RU"}}, // Q111474304
    {Coordinate{73.8052, 61.414}, CountryId{"RU"}}, // Q111474305
    {Coordinate{73.7423, 61.3696}, CountryId{"RU"}}, // Q111474306
    {Coordinate{73.6741, 61.3465}, CountryId{"RU"}}, // Q111474307
    {Coordinate{73.1777, 61.2523}, CountryId{"RU"}}, // Q111474308
    {Coordinate{73.1681, 61.1584}, CountryId{"RU"}}, // Q111474309
    {Coordinate{73.1701, 61.124}, CountryId{"RU"}}, // Q111474310
    {Coordinate{73.1426, 61.0582}, CountryId{"RU"}}, // Q111474312
    {Coordinate{73.14, 61.0319}, CountryId{"RU"}}, // Q111474313
    {Coordinate{73.0901, 60.9247}, CountryId{"RU"}}, // Q111474314
    {Coordinate{72.9625, 60.8306}, CountryId{"RU"}}, // Q111474315
    {Coordinate{72.8451, 60.7549}, CountryId{"RU"}}, // Q111474316
    {Coordinate{72.7244, 60.6956}, CountryId{"RU"}}, // Q111474318
    {Coordinate{72.6293, 60.6271}, CountryId{"RU"}}, // Q111474319
    {Coordinate{72.4713, 60.5501}, CountryId{"RU"}}, // Q111474320
    {Coordinate{72.3688, 60.4741}, CountryId{"RU"}}, // Q111474321
    {Coordinate{72.0292, 60.3276}, CountryId{"RU"}}, // Q111474322
    {Coordinate{71.4623, 60.058}, CountryId{"RU"}}, // Q111474323
    {Coordinate{69.9967, 59.5459}, CountryId{"RU"}}, // Q111474324
    {Coordinate{69.1213, 58.9276}, CountryId{"RU"}}, // Q111474325
    {Coordinate{68.7643, 58.6076}, CountryId{"RU"}}, // Q111474327
    {Coordinate{68.1829, 58.2253}, CountryId{"RU"}}, // Q111474328
    {Coordinate{67.7996, 58.0261}, CountryId{"RU"}}, // Q111474329
    {Coordinate{67.4357, 57.8941}, CountryId{"RU"}}, // Q111474330
    {Coordinate{67.1559, 57.7772}, CountryId{"RU"}}, // Q111474331
    {Coordinate{66.8556, 57.5439}, CountryId{"RU"}}, // Q111474332
    {Coordinate{66.5838, 57.5073}, CountryId{"RU"}}, // Q111474333
    {Coordinate{66.3895, 57.4739}, CountryId{"RU"}}, // Q111474334
    {Coordinate{66.2572, 57.4111}, CountryId{"RU"}}, // Q111474335
    {Coordinate{65.8713, 57.1743}, CountryId{"RU"}}, // Q111474336
    {Coordinate{65.7656, 57.0984}, CountryId{"RU"}}, // Q111474337
    {Coordinate{32.6369, 66.7131}, CountryId{"RU"}}, // Kovda
    {Coordinate{32.6638, 66.6855}, CountryId{"RU"}}, // 1093 km
    {Coordinate{32.7498, 66.6372}, CountryId{"RU"}}, // Lesnoy
    {Coordinate{32.8082, 66.5851}, CountryId{"RU"}}, // Poyakonda
    {Coordinate{32.8503, 66.4358}, CountryId{"RU"}}, // Polyarnyj Krug
    {Coordinate{76.4581, 61.0022}, CountryId{"RU"}}, // Q111488314
    {Coordinate{76.3309, 61.0618}, CountryId{"RU"}}, // Q111488315
    {Coordinate{75.9995, 61.142}, CountryId{"RU"}}, // Q111488316
    {Coordinate{75.4589, 61.2436}, CountryId{"RU"}}, // Q111488317
    {Coordinate{75.219, 61.2753}, CountryId{"RU"}}, // Q111488318
    {Coordinate{74.8579, 61.4012}, CountryId{"RU"}}, // Q111488319
    {Coordinate{74.545, 62.2587}, CountryId{"RU"}}, // Q111488620
    {Coordinate{75.9361, 63.723}, CountryId{"RU"}}, // Q111488622
    {Coordinate{76.7094, 64.4858}, CountryId{"RU"}}, // Q111488624
    {Coordinate{77.5654, 64.9382}, CountryId{"RU"}}, // Q111488625
    {Coordinate{77.7457, 65.2662}, CountryId{"RU"}}, // Q111488626
    {Coordinate{78.1774, 65.9303}, CountryId{"RU"}}, // Q111488627
    {Coordinate{32.9271, 66.308}, CountryId{"RU"}}, // Katozero
    {Coordinate{32.9009, 66.1966}, CountryId{"RU"}}, // Keret'
    {Coordinate{65.5979, 62.4624}, CountryId{"RU"}}, // Q111507902
    {Coordinate{65.5231, 62.2589}, CountryId{"RU"}}, // Q111507903
    {Coordinate{65.3867, 62.1356}, CountryId{"RU"}}, // Q111507904
    {Coordinate{64.9482, 61.9448}, CountryId{"RU"}}, // Q111507905
    {Coordinate{64.7834, 61.8615}, CountryId{"RU"}}, // Q111507906
    {Coordinate{64.484, 61.6748}, CountryId{"RU"}}, // Q111507907
    {Coordinate{64.0554, 61.4723}, CountryId{"RU"}}, // Q111507908
    {Coordinate{63.8479, 61.3982}, CountryId{"RU"}}, // Q111507909
    {Coordinate{63.5757, 61.3585}, CountryId{"RU"}}, // Q111507910
    {Coordinate{63.3289, 61.3087}, CountryId{"RU"}}, // Q111507911
    {Coordinate{63.0965, 61.2495}, CountryId{"RU"}}, // Q111507912
    {Coordinate{62.8548, 61.2029}, CountryId{"RU"}}, // Q111507914
    {Coordinate{62.6707, 61.1601}, CountryId{"RU"}}, // Q111507915
    {Coordinate{62.2798, 61.0668}, CountryId{"RU"}}, // Q111507916
    {Coordinate{61.9962, 61.0147}, CountryId{"RU"}}, // Q111507917
    {Coordinate{61.7659, 60.9697}, CountryId{"RU"}}, // Q111507918
    {Coordinate{61.5039, 60.8929}, CountryId{"RU"}}, // Q111507919
    {Coordinate{61.2634, 60.8371}, CountryId{"RU"}}, // Q111507920
    {Coordinate{61.0242, 60.7804}, CountryId{"RU"}}, // Q111507921
    {Coordinate{60.7883, 60.7231}, CountryId{"RU"}}, // Q111507922
    {Coordinate{60.5029, 60.6613}, CountryId{"RU"}}, // Q111507923
    {Coordinate{63.545, 61.4155}, CountryId{"RU"}}, // Q111508082
    {Coordinate{63.3886, 61.5721}, CountryId{"RU"}}, // Q111508084
    {Coordinate{63.0014, 61.9277}, CountryId{"RU"}}, // Q111508085
    {Coordinate{11.6606, 43.4965}, CountryId{"IT"}}, // Laterina railway station
    {Coordinate{33.3545, 65.9623}, CountryId{"RU"}}, // Boyarskaya
    {Coordinate{33.4315, 65.9485}, CountryId{"RU"}}, // 981 km
    {Coordinate{33.7102, 65.8977}, CountryId{"RU"}}, // Ambarnyj
    {Coordinate{33.9448, 65.7898}, CountryId{"RU"}}, // Engozero
    {Coordinate{33.8578, 65.8283}, CountryId{"RU"}}, // 957 km
    {Coordinate{41.6887, 58.4268}, CountryId{"RU"}}, // Q111539229
    {Coordinate{41.749, 58.4221}, CountryId{"RU"}}, // Q111539230
    {Coordinate{41.8864, 58.4235}, CountryId{"RU"}}, // Q111539231
    {Coordinate{41.971, 58.4277}, CountryId{"RU"}}, // Q111539232
    {Coordinate{42.1144, 58.406}, CountryId{"RU"}}, // Q111539234
    {Coordinate{42.2073, 58.3675}, CountryId{"RU"}}, // Q111539235
    {Coordinate{42.2619, 58.3709}, CountryId{"RU"}}, // Q111539236
    {Coordinate{42.407, 58.3654}, CountryId{"RU"}}, // Q111541244
    {Coordinate{42.4549, 58.3498}, CountryId{"RU"}}, // Q111541245
    {Coordinate{42.5347, 58.3498}, CountryId{"RU"}}, // Q111541246
    {Coordinate{42.5959, 58.3417}, CountryId{"RU"}}, // Q111541247
    {Coordinate{42.6677, 58.3383}, CountryId{"RU"}}, // Q111541248
    {Coordinate{42.722, 58.3499}, CountryId{"RU"}}, // Q111541249
    {Coordinate{42.8503, 58.38}, CountryId{"RU"}}, // Q111541250
    {Coordinate{43.0039, 58.4006}, CountryId{"RU"}}, // Q111541251
    {Coordinate{43.0879, 58.3881}, CountryId{"RU"}}, // Q111541252
    {Coordinate{43.2648, 58.3651}, CountryId{"RU"}}, // Q111541253
    {Coordinate{43.5715, 58.3048}, CountryId{"RU"}}, // Q111541254
    {Coordinate{43.7358, 58.2987}, CountryId{"RU"}}, // Q111541255
    {Coordinate{43.8592, 58.2927}, CountryId{"RU"}}, // Q111541256
    {Coordinate{43.9575, 58.2923}, CountryId{"RU"}}, // Q111541257
    {Coordinate{44.1202, 58.3158}, CountryId{"RU"}}, // Q111541258
    {Coordinate{44.3244, 58.3148}, CountryId{"RU"}}, // Q111541260
    {Coordinate{44.4318, 58.3243}, CountryId{"RU"}}, // Q111541261
    {Coordinate{44.5697, 58.3264}, CountryId{"RU"}}, // Q111541262
    {Coordinate{44.7428, 58.3341}, CountryId{"RU"}}, // Q111541263
    {Coordinate{44.8268, 58.3403}, CountryId{"RU"}}, // Q111541265
    {Coordinate{44.9416, 58.3473}, CountryId{"RU"}}, // Q111541266
    {Coordinate{45.0709, 58.3405}, CountryId{"RU"}}, // Q111541267
    {Coordinate{45.182, 58.3441}, CountryId{"RU"}}, // Q111541269
    {Coordinate{45.3414, 58.3699}, CountryId{"RU"}}, // Q111541270
    {Coordinate{45.3866, 58.3783}, CountryId{"RU"}}, // Q111541271
    {Coordinate{45.4376, 58.3783}, CountryId{"RU"}}, // Q111541272
    {Coordinate{45.491, 58.372}, CountryId{"RU"}}, // Q111541273
    {Coordinate{45.5688, 58.3662}, CountryId{"RU"}}, // Q111541274
    {Coordinate{45.6455, 58.3721}, CountryId{"RU"}}, // Q111541275
    {Coordinate{45.7405, 58.3707}, CountryId{"RU"}}, // Q111541276
    {Coordinate{45.921, 58.3607}, CountryId{"RU"}}, // Q111541278
    {Coordinate{46.1132, 58.349}, CountryId{"RU"}}, // Q111541279
    {Coordinate{46.2079, 58.3568}, CountryId{"RU"}}, // Q111541280
    {Coordinate{46.3151, 58.3547}, CountryId{"RU"}}, // Q111541281
    {Coordinate{46.6879, 58.3333}, CountryId{"RU"}}, // Q111541282
    {Coordinate{47.1089, 58.3024}, CountryId{"RU"}}, // Q111541283
    {Coordinate{47.3093, 58.2964}, CountryId{"RU"}}, // Q111541284
    {Coordinate{47.3471, 58.2923}, CountryId{"RU"}}, // Q111541285
    {Coordinate{47.4016, 58.2864}, CountryId{"RU"}}, // Q111541286
    {Coordinate{12.4925, 55.687}, CountryId{"DK"}}, // Vanløse Station
    {Coordinate{34.1216, 65.6864}, CountryId{"RU"}}, // 935 km
    {Coordinate{34.2019, 65.573}, CountryId{"RU"}}, // Sig
    {Coordinate{34.1884, 65.5044}, CountryId{"RU"}}, // 912 km
    {Coordinate{34.2227, 65.4693}, CountryId{"RU"}}, // 908 km
    {Coordinate{34.2683, 65.4238}, CountryId{"RU"}}, // Von'ga
    {Coordinate{34.266, 65.3533}, CountryId{"RU"}}, // Kuzema
    {Coordinate{34.3376, 65.3276}, CountryId{"RU"}}, // 883 km
    {Coordinate{34.4662, 65.2431}, CountryId{"RU"}}, // Pon'goma
    {Coordinate{34.5828, 65.09}, CountryId{"RU"}}, // Lambino
    {Coordinate{34.627, 65.028}, CountryId{"RU"}}, // 846 km
    {Coordinate{30.0895, 55.356}, CountryId{"BY"}}, // Q111585571
    {Coordinate{13.5854, 54.486}, CountryId{"DE"}}, // Sassnitz Fährhafen railway station
    {Coordinate{34.6704, 64.863}, CountryId{"RU"}}, // Myagreka
    {Coordinate{34.6995, 64.7392}, CountryId{"RU"}}, // Shuyeretskaya
    {Coordinate{34.8007, 64.6626}, CountryId{"RU"}}, // Zalivy
    {Coordinate{14.8302, 38.1593}, CountryId{"IT"}}, // Brolo-Ficarra railway station
    {Coordinate{34.4692, 64.431}, CountryId{"RU"}}, // Sosnovets
    {Coordinate{34.4293, 64.367}, CountryId{"RU"}}, // Kilbo
    {Coordinate{34.3044, 64.2282}, CountryId{"RU"}}, // Tunguda
    {Coordinate{34.2458, 64.1368}, CountryId{"RU"}}, // Idel'
    {Coordinate{15.6526, 38.1264}, CountryId{"IT"}}, // Reggio di Calabria Santa Caterina railway station
    {Coordinate{14.2709, 51.0844}, CountryId{"DE"}}, // Neukirch West railway station
    {Coordinate{40.1831, 57.4806}, CountryId{"RU"}}, // Q111621868
    {Coordinate{40.2599, 57.4574}, CountryId{"RU"}}, // Q111621869
    {Coordinate{40.3762, 57.4371}, CountryId{"RU"}}, // Q111621871
    {Coordinate{8.7703, 55.3276}, CountryId{"DK"}}, // Ribe railway station
    {Coordinate{34.2361, 63.9448}, CountryId{"RU"}}, // Shavan'
    {Coordinate{34.2685, 63.8937}, CountryId{"RU"}}, // Nadvoitsy
    {Coordinate{34.253, 63.8156}, CountryId{"RU"}}, // May-Guba
    {Coordinate{34.2818, 63.661}, CountryId{"RU"}}, // Shpalovoy
    {Coordinate{40.1647, 58.0644}, CountryId{"RU"}}, // Q111634116
    {Coordinate{34.2975, 63.6028}, CountryId{"RU"}}, // Rigozero
    {Coordinate{34.2664, 63.5205}, CountryId{"RU"}}, // Suglitsa
    {Coordinate{34.2445, 63.4378}, CountryId{"RU"}}, // Urosozero
    {Coordinate{34.3258, 63.3467}, CountryId{"RU"}}, // Sumerichi
    {Coordinate{34.3172, 63.2768}, CountryId{"RU"}}, // Ramentsy
    {Coordinate{34.3462, 63.2209}, CountryId{"RU"}}, // Bystryagi
    {Coordinate{34.389, 63.1044}, CountryId{"RU"}}, // Vanzozero
    {Coordinate{34.4309, 63.0484}, CountryId{"RU"}}, // Malyga
    {Coordinate{34.4995, 62.9847}, CountryId{"RU"}}, // Lumbushozero
    {Coordinate{34.5491, 62.9313}, CountryId{"RU"}}, // Vichka
    {Coordinate{38.7241, 58.025}, CountryId{"RU"}}, // Q111652214
    {Coordinate{38.6838, 58.0154}, CountryId{"RU"}}, // Q111652215
    {Coordinate{38.614, 57.9986}, CountryId{"RU"}}, // Q111652216
    {Coordinate{38.4838, 57.9717}, CountryId{"RU"}}, // Q111652217
    {Coordinate{37.9639, 57.8751}, CountryId{"RU"}}, // Q111652218
    {Coordinate{37.8479, 57.8501}, CountryId{"RU"}}, // Q111652219
    {Coordinate{37.7576, 57.8304}, CountryId{"RU"}}, // Q111652220
    {Coordinate{37.6288, 57.8182}, CountryId{"RU"}}, // Q111652221
    {Coordinate{37.5067, 57.8246}, CountryId{"RU"}}, // Q111652222
    {Coordinate{37.3665, 57.8196}, CountryId{"RU"}}, // Q111652223
    {Coordinate{34.4394, 62.8544}, CountryId{"RU"}}, // Predmedgorsky
    {Coordinate{34.4571, 62.8037}, CountryId{"RU"}}, // Perguba
    {Coordinate{34.3613, 62.7391}, CountryId{"RU"}}, // Unitsa
    {Coordinate{7.5411, 45.2556}, CountryId{"IT"}}, // Mathi railway station
    {Coordinate{34.2696, 62.6742}, CountryId{"RU"}}, // Kyappeselga
    {Coordinate{34.2563, 62.6506}, CountryId{"RU"}}, // 522 km
    {Coordinate{34.2843, 62.5906}, CountryId{"RU"}}, // Vikshezero
    {Coordinate{34.3516, 62.4892}, CountryId{"RU"}}, // Novy Posyolok
    {Coordinate{46.924, 60.8727}, CountryId{"RU"}}, // Q111660325
    {Coordinate{46.8408, 60.9071}, CountryId{"RU"}}, // Q111660326
    {Coordinate{46.7871, 60.9427}, CountryId{"RU"}}, // Q111660327
    {Coordinate{46.7846, 60.996}, CountryId{"RU"}}, // Q111660328
    {Coordinate{46.7799, 61.0592}, CountryId{"RU"}}, // Q111660329
    {Coordinate{46.7491, 61.0873}, CountryId{"RU"}}, // Q111660330
    {Coordinate{46.7383, 61.0971}, CountryId{"RU"}}, // Q111660332
    {Coordinate{46.7262, 61.1081}, CountryId{"RU"}}, // Q111660333
    {Coordinate{46.6897, 61.1411}, CountryId{"RU"}}, // Q111660334
    {Coordinate{46.675, 61.1543}, CountryId{"RU"}}, // Q111660335
    {Coordinate{46.6334, 61.1931}, CountryId{"RU"}}, // Q111660336
    {Coordinate{46.6251, 61.2113}, CountryId{"RU"}}, // Q111660467
    {Coordinate{34.471, 62.3882}, CountryId{"RU"}}, // 489 km
    {Coordinate{34.4872, 62.3628}, CountryId{"RU"}}, // Kedrozero
    {Coordinate{34.5163, 62.2999}, CountryId{"RU"}}, // Ilemselga
    {Coordinate{34.4486, 62.261}, CountryId{"RU"}}, // Myanselga
    {Coordinate{34.4373, 62.2399}, CountryId{"RU"}}, // 468 km
    {Coordinate{34.3428, 62.2239}, CountryId{"RU"}}, // Nigozero
    {Coordinate{46.8792, 61.2449}, CountryId{"RU"}}, // Q111662622
    {Coordinate{46.6222, 61.2462}, CountryId{"RU"}}, // Q111662678
    {Coordinate{46.6487, 61.2593}, CountryId{"RU"}}, // Q111662679
    {Coordinate{46.6816, 61.2573}, CountryId{"RU"}}, // Q111662680
    {Coordinate{46.708, 61.2539}, CountryId{"RU"}}, // Q111662681
    {Coordinate{46.8505, 61.2478}, CountryId{"RU"}}, // Q111662682
    {Coordinate{34.2286, 62.2068}, CountryId{"RU"}}, // 454 km
    {Coordinate{34.2056, 62.1681}, CountryId{"RU"}}, // Zadeliye
    {Coordinate{34.2453, 62.1079}, CountryId{"RU"}}, // Suna
    {Coordinate{34.231, 62.0644}, CountryId{"RU"}}, // 437 km
    {Coordinate{34.214, 62.0382}, CountryId{"RU"}}, // Luchevoy
    {Coordinate{34.2456, 61.9797}, CountryId{"RU"}}, // 427 km
    {Coordinate{40.2, 58.209}, CountryId{"RU"}}, // Q111668436
    {Coordinate{40.3508, 58.2483}, CountryId{"RU"}}, // Q111668437
    {Coordinate{40.4712, 58.272}, CountryId{"RU"}}, // Q111668438
    {Coordinate{40.6181, 58.3153}, CountryId{"RU"}}, // Q111668439
    {Coordinate{40.791, 58.3451}, CountryId{"RU"}}, // Q111668440
    {Coordinate{40.8586, 58.3379}, CountryId{"RU"}}, // Q111668441
    {Coordinate{41.0438, 58.3455}, CountryId{"RU"}}, // Q111668443
    {Coordinate{41.1001, 58.3627}, CountryId{"RU"}}, // Q111668444
    {Coordinate{41.1817, 58.3939}, CountryId{"RU"}}, // Q111668445
    {Coordinate{41.2415, 58.4077}, CountryId{"RU"}}, // Q111668446
    {Coordinate{41.298, 58.4249}, CountryId{"RU"}}, // Q111668447
    {Coordinate{41.3391, 58.4397}, CountryId{"RU"}}, // Q111668448
    {Coordinate{41.3751, 58.455}, CountryId{"RU"}}, // Q111668449
    {Coordinate{41.4185, 58.4658}, CountryId{"RU"}}, // Q111668450
    {Coordinate{40.2607, 58.6129}, CountryId{"RU"}}, // Q111668800
    {Coordinate{34.2499, 61.8858}, CountryId{"RU"}}, // Shuysky Most
    {Coordinate{33.3771, 69.0556}, CountryId{"RU"}}, // Vaenga
    {Coordinate{32.4539, 68.9693}, CountryId{"RU"}}, // Pyayve
    {Coordinate{32.1231, 69.0784}, CountryId{"RU"}}, // Nyal
    {Coordinate{40.1904, 58.2653}, CountryId{"RU"}}, // Q111697593
    {Coordinate{40.2222, 58.3099}, CountryId{"RU"}}, // Q111697594
    {Coordinate{40.2768, 58.3663}, CountryId{"RU"}}, // Q111697595
    {Coordinate{40.3326, 58.3903}, CountryId{"RU"}}, // Q111697596
    {Coordinate{40.3529, 58.4199}, CountryId{"RU"}}, // Q111697597
    {Coordinate{40.3406, 58.4891}, CountryId{"RU"}}, // Q111697598
    {Coordinate{40.3068, 58.5053}, CountryId{"RU"}}, // Q111697600
    {Coordinate{40.2194, 58.5318}, CountryId{"RU"}}, // Q111697601
    {Coordinate{40.2291, 58.5768}, CountryId{"RU"}}, // Q111697602
    {Coordinate{40.1841, 58.6519}, CountryId{"RU"}}, // Q111697603
    {Coordinate{40.126, 58.7175}, CountryId{"RU"}}, // Q111697604
    {Coordinate{40.1832, 58.8105}, CountryId{"RU"}}, // Q111697605
    {Coordinate{40.2217, 58.9269}, CountryId{"RU"}}, // Q111697606
    {Coordinate{40.2173, 58.9507}, CountryId{"RU"}}, // Q111697607
    {Coordinate{40.2254, 59.0044}, CountryId{"RU"}}, // Q111697608
    {Coordinate{40.2393, 59.0367}, CountryId{"RU"}}, // Q111697609
    {Coordinate{40.2216, 59.0624}, CountryId{"RU"}}, // Q111697611
    {Coordinate{40.1981, 59.0744}, CountryId{"RU"}}, // Q111697612
    {Coordinate{40.0857, 59.1471}, CountryId{"RU"}}, // Q111697613
    {Coordinate{40.0472, 59.1567}, CountryId{"RU"}}, // Q111697614
    {Coordinate{40.0032, 59.1645}, CountryId{"RU"}}, // Q111697615
    {Coordinate{39.9737, 59.178}, CountryId{"RU"}}, // Q111697616
    {Coordinate{39.9266, 59.1958}, CountryId{"RU"}}, // Q111697617
    {Coordinate{40.2243, 59.0815}, CountryId{"RU"}}, // Q111698086
    {Coordinate{40.3051, 59.0618}, CountryId{"RU"}}, // Q111698087
    {Coordinate{40.377, 59.0427}, CountryId{"RU"}}, // Q111698088
    {Coordinate{40.4589, 59.0213}, CountryId{"RU"}}, // Q111698089
    {Coordinate{40.5839, 58.9891}, CountryId{"RU"}}, // Q111698090
    {Coordinate{40.6157, 58.9835}, CountryId{"RU"}}, // Q111698091
    {Coordinate{40.6439, 58.9745}, CountryId{"RU"}}, // Q111698092
    {Coordinate{40.6953, 58.9562}, CountryId{"RU"}}, // Q111698093
    {Coordinate{40.7655, 58.9307}, CountryId{"RU"}}, // Q111698094
    {Coordinate{40.8511, 58.8966}, CountryId{"RU"}}, // Q111698095
    {Coordinate{40.918, 58.8696}, CountryId{"RU"}}, // Q111698096
    {Coordinate{40.9935, 58.8386}, CountryId{"RU"}}, // Q111698097
    {Coordinate{41.1354, 58.7573}, CountryId{"RU"}}, // Q111698098
    {Coordinate{41.1758, 58.7297}, CountryId{"RU"}}, // Q111698099
    {Coordinate{41.2871, 58.6519}, CountryId{"RU"}}, // Q111698101
    {Coordinate{41.3444, 58.609}, CountryId{"RU"}}, // Q111698102
    {Coordinate{41.4049, 58.5515}, CountryId{"RU"}}, // Q111698103
    {Coordinate{41.4732, 58.5086}, CountryId{"RU"}}, // Q111698104
    {Coordinate{9.11234, 48.2899}, CountryId{"DE"}}, // Burladingen station
    {Coordinate{9.03761, 48.3264}, CountryId{"DE"}}, // Jungingen (Hohenz) station
    {Coordinate{9.02515, 48.3435}, CountryId{"DE"}}, // Schlatt (Hohenz) railway stop
    {Coordinate{9.06811, 48.3016}, CountryId{"DE"}}, // Hausen-Starzeln railway stop
    {Coordinate{9.16319, 48.2762}, CountryId{"DE"}}, // Gauselfingen railway stop
    {Coordinate{40.6101, 57.4889}, CountryId{"RU"}}, // Q111698915
    {Coordinate{40.6731, 57.5136}, CountryId{"RU"}}, // Q111698916
    {Coordinate{40.814, 57.6456}, CountryId{"RU"}}, // Q111698917
    {Coordinate{41.0709, 57.7869}, CountryId{"RU"}}, // Q111698918
    {Coordinate{41.1766, 57.8003}, CountryId{"RU"}}, // Q111698919
    {Coordinate{41.2393, 57.7996}, CountryId{"RU"}}, // Q111698920
    {Coordinate{41.4089, 57.8101}, CountryId{"RU"}}, // Q111698921
    {Coordinate{41.4936, 57.8303}, CountryId{"RU"}}, // Q111698922
    {Coordinate{41.5587, 57.8393}, CountryId{"RU"}}, // Q111698923
    {Coordinate{41.6022, 57.8745}, CountryId{"RU"}}, // Q111698924
    {Coordinate{41.6533, 57.8909}, CountryId{"RU"}}, // Q111698925
    {Coordinate{41.7384, 57.9737}, CountryId{"RU"}}, // Q111698926
    {Coordinate{41.8049, 57.998}, CountryId{"RU"}}, // Q111698927
    {Coordinate{41.9317, 58.037}, CountryId{"RU"}}, // Q111698928
    {Coordinate{42.0584, 58.1095}, CountryId{"RU"}}, // Q111698929
    {Coordinate{42.1443, 58.1682}, CountryId{"RU"}}, // Q111698930
    {Coordinate{42.1849, 58.1926}, CountryId{"RU"}}, // Q111698931
    {Coordinate{42.2293, 58.2496}, CountryId{"RU"}}, // Q111698932
    {Coordinate{42.2477, 58.3379}, CountryId{"RU"}}, // Q111698933
    {Coordinate{40.6917, 57.4063}, CountryId{"RU"}}, // Q111699218
    {Coordinate{40.838, 57.3465}, CountryId{"RU"}}, // Q111699220
    {Coordinate{40.9154, 57.2824}, CountryId{"RU"}}, // Q111699221
    {Coordinate{41.2064, 57.1543}, CountryId{"RU"}}, // Q111699222
    {Coordinate{31.6988, 69.1908}, CountryId{"RU"}}, // Mokket
    {Coordinate{31.2454, 69.2681}, CountryId{"RU"}}, // Titovka
    {Coordinate{9.17562, 48.4963}, CountryId{"DE"}}, // Reutlingen-Betzingen station
    {Coordinate{9.23685, 48.5153}, CountryId{"DE"}}, // Reutlingen-Sondelfingen station
    {Coordinate{9.37632, 48.4993}, CountryId{"DE"}}, // Bad Urach Wasserfall railway stop
    {Coordinate{9.34424, 48.528}, CountryId{"DE"}}, // Dettingen-Mitte railway stop
    {Coordinate{9.39659, 48.4916}, CountryId{"DE"}}, // Bad Urach station
    {Coordinate{41.7526, 57.1938}, CountryId{"RU"}}, // Q111709136
    {Coordinate{41.9244, 57.2217}, CountryId{"RU"}}, // Q111709137
    {Coordinate{42.0208, 57.3215}, CountryId{"RU"}}, // Q111709138
    {Coordinate{41.0641, 56.9832}, CountryId{"RU"}}, // Q111709377
    {Coordinate{41.139, 56.9519}, CountryId{"RU"}}, // Q111709378
    {Coordinate{41.2375, 56.8946}, CountryId{"RU"}}, // Q111709379
    {Coordinate{41.3068, 56.7265}, CountryId{"RU"}}, // Q111709380
    {Coordinate{41.2637, 56.6598}, CountryId{"RU"}}, // Q111709381
    {Coordinate{41.212, 56.5894}, CountryId{"RU"}}, // Q111709382
    {Coordinate{41.197, 56.4898}, CountryId{"RU"}}, // Q111709383
    {Coordinate{41.1992, 56.4569}, CountryId{"RU"}}, // Q111709384
    {Coordinate{41.1642, 56.4429}, CountryId{"RU"}}, // Q111709385
    {Coordinate{41.147, 56.4102}, CountryId{"RU"}}, // Q111709386
    {Coordinate{32.2898, 67.3493}, CountryId{"RU"}}, // Chervas
    {Coordinate{32.0871, 67.4115}, CountryId{"RU"}}, // Pasma
    {Coordinate{31.9058, 67.4933}, CountryId{"RU"}}, // Upoloksha
    {Coordinate{31.3919, 67.5751}, CountryId{"RU"}}, // Kolyuzhny
    {Coordinate{9.60582, 47.7848}, CountryId{"DE"}}, // Bahnhof Ravensburg
    {Coordinate{31.1418, 67.5812}, CountryId{"RU"}}, // Yona
    {Coordinate{30.8409, 67.4885}, CountryId{"RU"}}, // Kuropta
    {Coordinate{30.4815, 67.5489}, CountryId{"RU"}}, // Kovdor
    {Coordinate{31.4552, 66.9625}, CountryId{"RU"}}, // Nyam-Ozero
    {Coordinate{30.3436, 66.9636}, CountryId{"RU"}}, // Alakurti
    {Coordinate{22.3721, 38.891}, CountryId{"GR"}}, // Lianokladi Railway Station
    {Coordinate{34.788, 64.4715}, CountryId{"RU"}}, // Shizhnya
    {Coordinate{35.0057, 64.3904}, CountryId{"RU"}}, // Sukhoye
    {Coordinate{42.1499, 61.0526}, CountryId{"RU"}}, // Q111731860
    {Coordinate{42.1972, 61.0404}, CountryId{"RU"}}, // Q111731863
    {Coordinate{42.2126, 61.0364}, CountryId{"RU"}}, // Q111731866
    {Coordinate{42.2822, 61.0239}, CountryId{"RU"}}, // Q111731869
    {Coordinate{42.3408, 61.0215}, CountryId{"RU"}}, // Q111731872
    {Coordinate{42.4556, 61.0346}, CountryId{"RU"}}, // Q111731876
    {Coordinate{42.7792, 61.0697}, CountryId{"RU"}}, // Q111731880
    {Coordinate{42.8414, 61.0727}, CountryId{"RU"}}, // Q111731883
    {Coordinate{42.8647, 61.0742}, CountryId{"RU"}}, // Q111731886
    {Coordinate{42.9623, 61.0832}, CountryId{"RU"}}, // Q111731889
    {Coordinate{43.0957, 61.0912}, CountryId{"RU"}}, // Q111731892
    {Coordinate{43.1671, 61.0758}, CountryId{"RU"}}, // Q111731895
    {Coordinate{43.2962, 61.0756}, CountryId{"RU"}}, // Q111731898
    {Coordinate{43.3621, 61.0615}, CountryId{"RU"}}, // Q111731900
    {Coordinate{43.4207, 61.0438}, CountryId{"RU"}}, // Q111731903
    {Coordinate{43.5017, 61.0368}, CountryId{"RU"}}, // Q111731905
    {Coordinate{43.6549, 61.0337}, CountryId{"RU"}}, // Q111731907
    {Coordinate{43.7366, 61.0298}, CountryId{"RU"}}, // Q111731909
    {Coordinate{43.9061, 61.0532}, CountryId{"RU"}}, // Q111731911
    {Coordinate{43.968, 61.0591}, CountryId{"RU"}}, // Q111731914
    {Coordinate{44.1017, 61.0567}, CountryId{"RU"}}, // Q111731917
    {Coordinate{44.1585, 61.0608}, CountryId{"RU"}}, // Q111731920
    {Coordinate{44.2362, 61.0664}, CountryId{"RU"}}, // Q111731922
    {Coordinate{44.3158, 61.072}, CountryId{"RU"}}, // Q111731924
    {Coordinate{44.3887, 61.0772}, CountryId{"RU"}}, // Q111731926
    {Coordinate{44.6124, 61.0826}, CountryId{"RU"}}, // Q111731928
    {Coordinate{44.8201, 61.116}, CountryId{"RU"}}, // Q111731930
    {Coordinate{44.8398, 61.1168}, CountryId{"RU"}}, // Q111731932
    {Coordinate{44.9812, 61.1377}, CountryId{"RU"}}, // Q111731933
    {Coordinate{45.1171, 61.1426}, CountryId{"RU"}}, // Q111731934
    {Coordinate{45.2803, 61.1339}, CountryId{"RU"}}, // Q111731936
    {Coordinate{45.3401, 61.1474}, CountryId{"RU"}}, // Q111731937
    {Coordinate{45.3805, 61.1442}, CountryId{"RU"}}, // Q111731938
    {Coordinate{45.4203, 61.1474}, CountryId{"RU"}}, // Q111731939
    {Coordinate{45.5108, 61.1333}, CountryId{"RU"}}, // Q111731940
    {Coordinate{45.7371, 61.1471}, CountryId{"RU"}}, // Q111731941
    {Coordinate{45.7861, 61.1505}, CountryId{"RU"}}, // Q111731942
    {Coordinate{45.9204, 61.1429}, CountryId{"RU"}}, // Q111731943
    {Coordinate{46.1418, 61.161}, CountryId{"RU"}}, // Q111731945
    {Coordinate{46.2081, 61.166}, CountryId{"RU"}}, // Q111731946
    {Coordinate{46.3499, 61.1522}, CountryId{"RU"}}, // Q111731947
    {Coordinate{46.4535, 61.1829}, CountryId{"RU"}}, // Q111731949
    {Coordinate{46.5114, 61.1974}, CountryId{"RU"}}, // Q111731950
    {Coordinate{46.589, 61.2052}, CountryId{"RU"}}, // Q111731951
    {Coordinate{46.3981, 61.165}, CountryId{"RU"}}, // Q111731976
    {Coordinate{12.2988, 45.8848}, CountryId{"IT"}}, // Conegliano railway station
    {Coordinate{35.9175, 64.0467}, CountryId{"RU"}}, // Ukhtitsa
    {Coordinate{36.004, 64.013}, CountryId{"RU"}}, // Virandozero
    {Coordinate{36.1124, 63.9702}, CountryId{"RU"}}, // Ruyga
    {Coordinate{36.2573, 63.9101}, CountryId{"RU"}}, // Nyukhcha
    {Coordinate{36.6355, 63.7872}, CountryId{"RU"}}, // Unezhma
    {Coordinate{36.9159, 63.735}, CountryId{"RU"}}, // Sulozero
    {Coordinate{37.0518, 63.7244}, CountryId{"RU"}}, // Kusha
    {Coordinate{37.2934, 63.7409}, CountryId{"RU"}}, // Shundanets
    {Coordinate{37.4428, 63.7169}, CountryId{"RU"}}, // 183 km
    {Coordinate{37.465, 63.7058}, CountryId{"RU"}}, // Maloshuyka
    {Coordinate{37.8222, 63.705}, CountryId{"RU"}}, // 205 km
    {Coordinate{7.64878, 48.0404}, CountryId{"DE"}}, // Ihringen station
    {Coordinate{7.68681, 48.0466}, CountryId{"DE"}}, // Wasenweiler station
    {Coordinate{7.78393, 48.0482}, CountryId{"DE"}}, // Hugstetten station
    {Coordinate{7.83267, 48.0129}, CountryId{"DE"}}, // Freiburg Messe/Universität station
    {Coordinate{7.84275, 48.0056}, CountryId{"DE"}}, // Freiburg Klinikum station
    {Coordinate{7.74996, 48.1542}, CountryId{"DE"}}, // Riegel am Kaiserstuhl Ort station
    {Coordinate{7.74778, 48.118}, CountryId{"DE"}}, // Bahlingen Riedlen station
    {Coordinate{}, CountryId{"FR"}}, // Q111792777
    {Coordinate{38.3545, 63.8029}, CountryId{"RU"}}, // Gribanikha
    {Coordinate{38.4713, 63.8399}, CountryId{"RU"}}, // 243 km
    {Coordinate{38.5374, 63.8451}, CountryId{"RU"}}, // Vonguda
    {Coordinate{-77.1461, 39.0842}, CountryId{"US"}}, // Q111806550
    {Coordinate{38.7646, 63.8132}, CountryId{"RU"}}, // Tyosovka
    {Coordinate{39.0074, 63.7893}, CountryId{"RU"}}, // Glazanikha
    {Coordinate{39.2535, 63.7765}, CountryId{"RU"}}, // Mudyuga
    {Coordinate{8.07689, 48.529}, CountryId{"DE"}}, // Oberkirch station
    {Coordinate{8.08944, 48.5248}, CountryId{"DE"}}, // Oberkirch-Köhlersiedlung station
    {Coordinate{8.11607, 48.5195}, CountryId{"DE"}}, // Lautenbach (Baden) station
    {Coordinate{8.13569, 48.5074}, CountryId{"DE"}}, // Hubacker station
    {Coordinate{8.13936, 48.4949}, CountryId{"DE"}}, // Ramsbach Höfle station
    {Coordinate{8.14567, 48.4883}, CountryId{"DE"}}, // Ramsbach Birkhof station
    {Coordinate{8.15976, 48.472}, CountryId{"DE"}}, // Oppenau station
    {Coordinate{8.16274, 48.4551}, CountryId{"DE"}}, // Ibach station
    {Coordinate{8.17225, 48.4347}, CountryId{"DE"}}, // Löcherberg station
    {Coordinate{8.20195, 48.4289}, CountryId{"DE"}}, // Bad Peterstal station
    {Coordinate{8.05647, 48.299}, CountryId{"DE"}}, // Steinach (Baden) station
    {Coordinate{8.08797, 48.28}, CountryId{"DE"}}, // Haslach station
    {Coordinate{8.19857, 48.2717}, CountryId{"DE"}}, // Gutach Freilichtmuseum station
    {Coordinate{39.4195, 63.7599}, CountryId{"RU"}}, // Kostrinsky Ruchey
    {Coordinate{39.6651, 63.7227}, CountryId{"RU"}}, // Kodino
    {Coordinate{39.885, 63.6685}, CountryId{"RU"}}, // Moshnoye
    {Coordinate{38.096, 63.9255}, CountryId{"RU"}}, // Onega
    {Coordinate{8.23294, 48.2119}, CountryId{"DE"}}, // Hornberg (Schwarzw) station
    {Coordinate{8.46915, 48.0313}, CountryId{"DE"}}, // Marbach West (Villingen-Schwenningen) station
    {Coordinate{8.46781, 48.0143}, CountryId{"DE"}}, // Brigachtal Kirchdorf station
    {Coordinate{8.46578, 48.0074}, CountryId{"DE"}}, // Brigachtal Klengen station
    {Coordinate{8.47182, 47.9831}, CountryId{"DE"}}, // Donaueschingen Grüningen station
    {Coordinate{8.47562, 47.9634}, CountryId{"DE"}}, // Donaueschingen Aufen station
    {Coordinate{8.48895, 47.9525}, CountryId{"DE"}}, // Donaueschingen Mitte/Siedlung station
    {Coordinate{8.65395, 47.9213}, CountryId{"DE"}}, // Geisingen station
    {Coordinate{8.71405, 47.9329}, CountryId{"DE"}}, // Immendingen Zimmern station
    {Coordinate{8.76922, 47.834}, CountryId{"DE"}}, // Welschingen-Neuhausen station
    {Coordinate{8.80439, 47.8137}, CountryId{"DE"}}, // Mühlhausen (b Engen) station
    {Coordinate{8.82705, 47.7607}, CountryId{"DE"}}, // Singen Landesgartenschau station
    {Coordinate{46.9045, 61.2419}, CountryId{"RU"}}, // Q111845130
    {Coordinate{46.9491, 61.2398}, CountryId{"RU"}}, // Q111845131
    {Coordinate{46.9914, 61.2504}, CountryId{"RU"}}, // Q111845132
    {Coordinate{47.1039, 61.261}, CountryId{"RU"}}, // Q111845134
    {Coordinate{47.2514, 61.2739}, CountryId{"RU"}}, // Q111845135
    {Coordinate{47.3257, 61.2804}, CountryId{"RU"}}, // Q111845136
    {Coordinate{47.4205, 61.2886}, CountryId{"RU"}}, // Q111845137
    {Coordinate{47.4831, 61.2933}, CountryId{"RU"}}, // Q111845138
    {Coordinate{47.5305, 61.312}, CountryId{"RU"}}, // Q111845139
    {Coordinate{47.6548, 61.3617}, CountryId{"RU"}}, // Q111845140
    {Coordinate{47.7162, 61.3898}, CountryId{"RU"}}, // Q111845141
    {Coordinate{47.8153, 61.4352}, CountryId{"RU"}}, // Q111845142
    {Coordinate{47.8808, 61.4533}, CountryId{"RU"}}, // Q111845143
    {Coordinate{47.9507, 61.4713}, CountryId{"RU"}}, // Q111845144
    {Coordinate{48.0058, 61.4855}, CountryId{"RU"}}, // Q111845145
    {Coordinate{48.064, 61.5069}, CountryId{"RU"}}, // Q111845146
    {Coordinate{48.141, 61.5366}, CountryId{"RU"}}, // Q111845147
    {Coordinate{48.2007, 61.5597}, CountryId{"RU"}}, // Q111845149
    {Coordinate{48.228, 61.5732}, CountryId{"RU"}}, // Q111845150
    {Coordinate{48.2416, 61.5878}, CountryId{"RU"}}, // Q111845152
    {Coordinate{48.2771, 61.6178}, CountryId{"RU"}}, // Q111845153
    {Coordinate{48.3584, 61.6718}, CountryId{"RU"}}, // Q111845154
    {Coordinate{48.5468, 61.7556}, CountryId{"RU"}}, // Q111845156
    {Coordinate{49.3144, 62.0275}, CountryId{"RU"}}, // Q111845157
    {Coordinate{49.4216, 62.0908}, CountryId{"RU"}}, // Q111845158
    {Coordinate{49.7935, 62.2145}, CountryId{"RU"}}, // Q111845159
    {Coordinate{39.8611, 59.2222}, CountryId{"RU"}}, // Q111846324
    {Coordinate{39.867, 59.2363}, CountryId{"RU"}}, // Q111846325
    {Coordinate{39.8981, 59.2651}, CountryId{"RU"}}, // Q111846326
    {Coordinate{39.9259, 59.317}, CountryId{"RU"}}, // Q111846329
    {Coordinate{39.9931, 59.3637}, CountryId{"RU"}}, // Q111846330
    {Coordinate{40.0276, 59.38}, CountryId{"RU"}}, // Q111846331
    {Coordinate{40.0644, 59.4172}, CountryId{"RU"}}, // Q111846332
    {Coordinate{40.1433, 59.5074}, CountryId{"RU"}}, // Q111846333
    {Coordinate{40.1754, 59.5713}, CountryId{"RU"}}, // Q111846334
    {Coordinate{40.1882, 59.6193}, CountryId{"RU"}}, // Q111846335
    {Coordinate{40.1792, 59.6692}, CountryId{"RU"}}, // Q111846336
    {Coordinate{40.1778, 59.694}, CountryId{"RU"}}, // Q111846338
    {Coordinate{40.1707, 59.7291}, CountryId{"RU"}}, // Q111846339
    {Coordinate{40.1633, 59.7656}, CountryId{"RU"}}, // Q111846341
    {Coordinate{40.1656, 59.8127}, CountryId{"RU"}}, // Q111846342
    {Coordinate{40.1671, 59.8766}, CountryId{"RU"}}, // Q111846343
    {Coordinate{40.1779, 59.9786}, CountryId{"RU"}}, // Q111846344
    {Coordinate{40.1899, 60.0118}, CountryId{"RU"}}, // Q111846345
    {Coordinate{40.203, 60.0785}, CountryId{"RU"}}, // Q111846347
    {Coordinate{40.2044, 60.1309}, CountryId{"RU"}}, // Q111846348
    {Coordinate{40.2565, 60.2372}, CountryId{"RU"}}, // Q111846349
    {Coordinate{40.2664, 60.274}, CountryId{"RU"}}, // Q111846350
    {Coordinate{40.2369, 60.3807}, CountryId{"RU"}}, // Q111846352
    {Coordinate{40.2189, 60.4203}, CountryId{"RU"}}, // Q111846353
    {Coordinate{40.219, 60.5298}, CountryId{"RU"}}, // Q111846355
    {Coordinate{40.1571, 60.6066}, CountryId{"RU"}}, // Q111846356
    {Coordinate{40.159, 60.6305}, CountryId{"RU"}}, // Q111846357
    {Coordinate{40.1469, 60.6384}, CountryId{"RU"}}, // Q111846358
    {Coordinate{40.1443, 60.6644}, CountryId{"RU"}}, // Q111846359
    {Coordinate{40.1405, 60.7027}, CountryId{"RU"}}, // Q111846360
    {Coordinate{40.1197, 60.7491}, CountryId{"RU"}}, // Q111846361
    {Coordinate{40.091, 60.8279}, CountryId{"RU"}}, // Q111846362
    {Coordinate{40.0948, 60.8619}, CountryId{"RU"}}, // Q111846363
    {Coordinate{40.1155, 60.8788}, CountryId{"RU"}}, // Q111846364
    {Coordinate{40.1181, 60.9016}, CountryId{"RU"}}, // Q111846366
    {Coordinate{40.1671, 60.9301}, CountryId{"RU"}}, // Q111846367
    {Coordinate{39.9084, 59.2924}, CountryId{"RU"}}, // Q111846393
    {Coordinate{40.2151, 60.4993}, CountryId{"RU"}}, // Q111846395
    {Coordinate{37.751, 59.1417}, CountryId{"RU"}}, // Q111846724
    {Coordinate{8.22185, 48.2937}, CountryId{"DE"}}, // Wolfach station
    {Coordinate{10.0503, 45.6564}, CountryId{"IT"}}, // Iseo railway station
    {Coordinate{15.4279, 40.8865}, CountryId{"IT"}}, // Calitri-Pescopagano railway station
    {Coordinate{8.27045, 48.2907}, CountryId{"DE"}}, // Halbmeil station
    {Coordinate{8.34477, 48.2913}, CountryId{"DE"}}, // Schiltach Mitte station
    {Coordinate{8.37189, 48.3084}, CountryId{"DE"}}, // Schenkenzell station
    {Coordinate{8.39825, 48.3438}, CountryId{"DE"}}, // Alpirsbach station
    {Coordinate{8.45319, 48.4181}, CountryId{"DE"}}, // Loßburg-Rodt station
    {Coordinate{-3.14281, 51.6658}, CountryId{"GB"}}, // Newbridge railway station
    {Coordinate{37.8833, 59.1526}, CountryId{"RU"}}, // Q111970496
    {Coordinate{37.8833, 59.1526}, CountryId{"RU"}}, // Q111970497
    {Coordinate{38.1376, 59.1249}, CountryId{"RU"}}, // Q111970498
    {Coordinate{38.1673, 59.1333}, CountryId{"RU"}}, // Q111970499
    {Coordinate{38.1853, 59.1528}, CountryId{"RU"}}, // Q111970500
    {Coordinate{38.2357, 59.1683}, CountryId{"RU"}}, // Q111970501
    {Coordinate{38.3125, 59.1754}, CountryId{"RU"}}, // Q111970502
    {Coordinate{38.3734, 59.1895}, CountryId{"RU"}}, // Q111970503
    {Coordinate{38.4263, 59.2014}, CountryId{"RU"}}, // Q111970504
    {Coordinate{38.4674, 59.1949}, CountryId{"RU"}}, // Q111970505
    {Coordinate{38.6016, 59.204}, CountryId{"RU"}}, // Q111970506
    {Coordinate{38.6756, 59.2064}, CountryId{"RU"}}, // Q111970507
    {Coordinate{38.7132, 59.1954}, CountryId{"RU"}}, // Q111970508
    {Coordinate{38.7714, 59.1934}, CountryId{"RU"}}, // Q111970509
    {Coordinate{38.9678, 59.2199}, CountryId{"RU"}}, // Q111970510
    {Coordinate{39.0374, 59.2294}, CountryId{"RU"}}, // Q111970511
    {Coordinate{39.321, 59.2551}, CountryId{"RU"}}, // Q111970512
    {Coordinate{39.321, 59.2551}, CountryId{"RU"}}, // Q111970513
    {Coordinate{39.3875, 59.2507}, CountryId{"RU"}}, // Q111970514
    {Coordinate{39.4177, 59.2501}, CountryId{"RU"}}, // Q111970515
    {Coordinate{39.6574, 59.2569}, CountryId{"RU"}}, // Q111970516
    {Coordinate{39.7413, 59.245}, CountryId{"RU"}}, // Q111970517
    {Coordinate{39.8465, 59.228}, CountryId{"RU"}}, // Q111970518
    {Coordinate{40.6569, 61.0391}, CountryId{"RU"}}, // Q111976822
    {Coordinate{40.761, 61.0472}, CountryId{"RU"}}, // Q111976824
    {Coordinate{40.8504, 61.0457}, CountryId{"RU"}}, // Q111976825
    {Coordinate{40.8869, 61.0457}, CountryId{"RU"}}, // Q111976826
    {Coordinate{40.9682, 61.0456}, CountryId{"RU"}}, // Q111976827
    {Coordinate{41.1318, 61.0556}, CountryId{"RU"}}, // Q111976828
    {Coordinate{41.3011, 61.0584}, CountryId{"RU"}}, // Q111976829
    {Coordinate{41.3384, 61.0564}, CountryId{"RU"}}, // Q111976830
    {Coordinate{41.4651, 61.0573}, CountryId{"RU"}}, // Q111976831
    {Coordinate{41.6267, 61.0346}, CountryId{"RU"}}, // Q111976832
    {Coordinate{41.6393, 61.0328}, CountryId{"RU"}}, // Q111976833
    {Coordinate{41.8636, 61.0234}, CountryId{"RU"}}, // Q111976834
    {Coordinate{41.9254, 61.0383}, CountryId{"RU"}}, // Q111976835
    {Coordinate{42.0167, 61.0552}, CountryId{"RU"}}, // Q111976836
    {Coordinate{8.5828, 49.5355}, CountryId{"DE"}}, // Q111985914
    {Coordinate{40.6567, 61.0393}, CountryId{"RU"}}, // Q111988147
    {Coordinate{40.7354, 61.0532}, CountryId{"RU"}}, // Q111988148
    {Coordinate{40.8735, 61.0971}, CountryId{"RU"}}, // Q111988149
    {Coordinate{41.1517, 61.1469}, CountryId{"RU"}}, // Q111988150
    {Coordinate{41.2584, 61.1447}, CountryId{"RU"}}, // Q111988151
    {Coordinate{41.3734, 61.1382}, CountryId{"RU"}}, // Q111988152
    {Coordinate{41.4299, 61.1056}, CountryId{"RU"}}, // Q111988153
    {Coordinate{41.5896, 61.086}, CountryId{"RU"}}, // Q111988154
    {Coordinate{41.7591, 61.0792}, CountryId{"RU"}}, // Q111988155
    {Coordinate{41.9636, 61.078}, CountryId{"RU"}}, // Q111988156
    {Coordinate{41.9917, 61.0689}, CountryId{"RU"}}, // Q111988157
    {Coordinate{14.1581, 46.3604}, CountryId{"SI"}}, // Lesce - Bled train station
    {Coordinate{50.2349, 62.4344}, CountryId{"RU"}}, // Q112005518
    {Coordinate{50.7361, 62.5522}, CountryId{"RU"}}, // Q112005521
    {Coordinate{50.8824, 62.5998}, CountryId{"RU"}}, // Q112005523
    {Coordinate{51.2747, 62.7034}, CountryId{"RU"}}, // Q112005526
    {Coordinate{51.4837, 62.756}, CountryId{"RU"}}, // Q112005528
    {Coordinate{51.8784, 62.8624}, CountryId{"RU"}}, // Q112005530
    {Coordinate{52.2757, 63.0259}, CountryId{"RU"}}, // Q112005534
    {Coordinate{52.6888, 63.2131}, CountryId{"RU"}}, // Q112005536
    {Coordinate{52.8909, 63.2401}, CountryId{"RU"}}, // Q112005537
    {Coordinate{53.6077, 63.4288}, CountryId{"RU"}}, // Q112005541
    {Coordinate{51.8784, 62.8624}, CountryId{"RU"}}, // Q112005603
    {Coordinate{53.0712, 63.2742}, CountryId{"RU"}}, // Q112005605
    {Coordinate{63.6492, 67.2829}, CountryId{"RU"}}, // Q112008933
    {Coordinate{95.1611, 27.7847}, CountryId{}}, // Jonekarang
    {Coordinate{53.9639, 63.5929}, CountryId{"RU"}}, // Q112066149
    {Coordinate{54.0636, 63.6365}, CountryId{"RU"}}, // Q112066150
    {Coordinate{54.1632, 63.6852}, CountryId{"RU"}}, // Q112066151
    {Coordinate{54.1925, 63.7216}, CountryId{"RU"}}, // Q112066152
    {Coordinate{54.4434, 63.9224}, CountryId{"RU"}}, // Q112066154
    {Coordinate{54.7012, 64.0808}, CountryId{"RU"}}, // Q112066155
    {Coordinate{54.836, 64.1796}, CountryId{"RU"}}, // Q112066156
    {Coordinate{54.9894, 64.25}, CountryId{"RU"}}, // Q112066157
    {Coordinate{55.1979, 64.4055}, CountryId{"RU"}}, // Q112066158
    {Coordinate{55.3148, 64.4828}, CountryId{"RU"}}, // Q112066159
    {Coordinate{55.4777, 64.5538}, CountryId{"RU"}}, // Q112066160
    {Coordinate{55.6922, 64.6179}, CountryId{"RU"}}, // Q112066161
    {Coordinate{55.875, 64.6836}, CountryId{"RU"}}, // Q112066162
    {Coordinate{55.9176, 64.6967}, CountryId{"RU"}}, // Q112066163
    {Coordinate{56.0585, 64.7528}, CountryId{"RU"}}, // Q112066164
    {Coordinate{56.2435, 64.8349}, CountryId{"RU"}}, // Q112066165
    {Coordinate{56.4287, 64.8987}, CountryId{"RU"}}, // Q112066166
    {Coordinate{56.6319, 64.9678}, CountryId{"RU"}}, // Q112066167
    {Coordinate{56.7579, 65.025}, CountryId{"RU"}}, // Q112066168
    {Coordinate{56.912, 65.0733}, CountryId{"RU"}}, // Q112066169
    {Coordinate{56.9946, 65.1061}, CountryId{"RU"}}, // Q112066170
    {Coordinate{57.044, 65.1223}, CountryId{"RU"}}, // Q112066171
    {Coordinate{57.0867, 65.129}, CountryId{"RU"}}, // Q112066172
    {Coordinate{57.1623, 65.1387}, CountryId{"RU"}}, // Q112066173
    {Coordinate{57.2127, 65.1497}, CountryId{"RU"}}, // Q112066174
    {Coordinate{57.6359, 65.2717}, CountryId{"RU"}}, // Q112066175
    {Coordinate{58.0346, 65.3725}, CountryId{"RU"}}, // Q112066176
    {Coordinate{58.1893, 65.4241}, CountryId{"RU"}}, // Q112066177
    {Coordinate{58.3862, 65.4895}, CountryId{"RU"}}, // Q112066178
    {Coordinate{58.5312, 65.5377}, CountryId{"RU"}}, // Q112066179
    {Coordinate{58.596, 65.5511}, CountryId{"RU"}}, // Q112066180
    {Coordinate{58.7732, 65.5728}, CountryId{"RU"}}, // Q112066181
    {Coordinate{58.964, 65.6143}, CountryId{"RU"}}, // Q112066182
    {Coordinate{59.0564, 65.6268}, CountryId{"RU"}}, // Q112066183
    {Coordinate{59.1593, 65.6403}, CountryId{"RU"}}, // Q112066184
    {Coordinate{59.424, 65.7001}, CountryId{"RU"}}, // Q112066185
    {Coordinate{59.548, 65.7337}, CountryId{"RU"}}, // Q112066186
    {Coordinate{59.6549, 65.7487}, CountryId{"RU"}}, // Q112066187
    {Coordinate{59.8691, 65.8224}, CountryId{"RU"}}, // Q112066188
    {Coordinate{60.1017, 65.9029}, CountryId{"RU"}}, // Q112066189
    {Coordinate{60.3244, 65.9925}, CountryId{"RU"}}, // Q112066190
    {Coordinate{60.3922, 66.0337}, CountryId{"RU"}}, // Q112066191
    {Coordinate{60.4717, 66.0723}, CountryId{"RU"}}, // Q112066192
    {Coordinate{60.5776, 66.128}, CountryId{"RU"}}, // Q112066193
    {Coordinate{60.6612, 66.1404}, CountryId{"RU"}}, // Q112066194
    {Coordinate{60.7838, 66.1824}, CountryId{"RU"}}, // Q112066195
    {Coordinate{60.893, 66.2273}, CountryId{"RU"}}, // Q112066196
    {Coordinate{61.068, 66.2764}, CountryId{"RU"}}, // Q112066197
    {Coordinate{61.2121, 66.3297}, CountryId{"RU"}}, // Q112066198
    {Coordinate{61.4136, 66.4102}, CountryId{"RU"}}, // Q112066199
    {Coordinate{61.6687, 66.5162}, CountryId{"RU"}}, // Q112066200
    {Coordinate{61.7504, 66.5284}, CountryId{"RU"}}, // Q112066201
    {Coordinate{61.9017, 66.538}, CountryId{"RU"}}, // Q112066202
    {Coordinate{62.4046, 66.6158}, CountryId{"RU"}}, // Q112066203
    {Coordinate{62.5675, 66.6748}, CountryId{"RU"}}, // Q112066204
    {Coordinate{62.7004, 66.739}, CountryId{"RU"}}, // Q112066205
    {Coordinate{62.8291, 66.8177}, CountryId{"RU"}}, // Q112066207
    {Coordinate{62.8647, 66.8993}, CountryId{"RU"}}, // Q112066208
    {Coordinate{63.3919, 67.136}, CountryId{"RU"}}, // Q112066209
    {Coordinate{63.5819, 67.2089}, CountryId{"RU"}}, // Q112066210
    {Coordinate{63.9199, 67.3729}, CountryId{"RU"}}, // Q112066211
    {Coordinate{58.0636, 65.8156}, CountryId{"RU"}}, // Q112066445
    {Coordinate{57.5474, 66.0244}, CountryId{"RU"}}, // Q112066447
    {Coordinate{73.5899, 21.9694}, CountryId{}}, // Tilakwada Railway Station
    {Coordinate{48.667, 63.4446}, CountryId{"RU"}}, // Q112085829
    {Coordinate{50.0725, 62.3736}, CountryId{"RU"}}, // Q112085959
    {Coordinate{49.737, 62.5559}, CountryId{"RU"}}, // Q112085960
    {Coordinate{49.5556, 62.7049}, CountryId{"RU"}}, // Q112085961
    {Coordinate{49.3031, 62.8453}, CountryId{"RU"}}, // Q112085962
    {Coordinate{49.1793, 62.9345}, CountryId{"RU"}}, // Q112085963
    {Coordinate{48.8633, 63.0586}, CountryId{"RU"}}, // Q112085965
    {Coordinate{48.5775, 63.2363}, CountryId{"RU"}}, // Q112085966
    {Coordinate{48.5296, 63.3025}, CountryId{"RU"}}, // Q112085967
    {Coordinate{50.2236, 62.2911}, CountryId{"RU"}}, // Q112091353
    {Coordinate{50.4013, 62.2273}, CountryId{"RU"}}, // Q112091354
    {Coordinate{50.4331, 62.2076}, CountryId{"RU"}}, // Q112091356
    {Coordinate{50.5109, 62.1459}, CountryId{"RU"}}, // Q112091358
    {Coordinate{50.5746, 62.061}, CountryId{"RU"}}, // Q112091360
    {Coordinate{50.602, 62.0061}, CountryId{"RU"}}, // Q112091362
    {Coordinate{50.6159, 61.9559}, CountryId{"RU"}}, // Q112091364
    {Coordinate{50.6823, 61.8489}, CountryId{"RU"}}, // Q112091366
    {Coordinate{50.7324, 61.8014}, CountryId{"RU"}}, // Q112091368
    {Coordinate{50.7747, 61.7302}, CountryId{"RU"}}, // Q112091370
    {Coordinate{40.3097, 62.897}, CountryId{"RU"}}, // Q112095373
    {Coordinate{40.3353, 63.0738}, CountryId{"RU"}}, // Q112095461
    {Coordinate{40.2838, 61.0161}, CountryId{"RU"}}, // Q112106642
    {Coordinate{40.2995, 61.0619}, CountryId{"RU"}}, // Q112106643
    {Coordinate{40.3091, 61.1512}, CountryId{"RU"}}, // Q112106644
    {Coordinate{40.298, 61.2367}, CountryId{"RU"}}, // Q112106645
    {Coordinate{40.2483, 61.4}, CountryId{"RU"}}, // Q112106647
    {Coordinate{40.2331, 61.4388}, CountryId{"RU"}}, // Q112106648
    {Coordinate{40.1811, 61.4893}, CountryId{"RU"}}, // Q112106649
    {Coordinate{40.2159, 61.5083}, CountryId{"RU"}}, // Q112106650
    {Coordinate{40.1999, 61.5779}, CountryId{"RU"}}, // Q112106651
    {Coordinate{40.2005, 61.6287}, CountryId{"RU"}}, // Q112106653
    {Coordinate{40.2043, 61.7241}, CountryId{"RU"}}, // Q112106655
    {Coordinate{40.1835, 61.7617}, CountryId{"RU"}}, // Q112106656
    {Coordinate{40.2098, 61.8064}, CountryId{"RU"}}, // Q112106657
    {Coordinate{40.228, 61.8286}, CountryId{"RU"}}, // Q112106659
    {Coordinate{40.2404, 61.8715}, CountryId{"RU"}}, // Q112106660
    {Coordinate{40.2638, 62.0064}, CountryId{"RU"}}, // Q112106661
    {Coordinate{40.2439, 62.0423}, CountryId{"RU"}}, // Q112106662
    {Coordinate{40.212, 62.0711}, CountryId{"RU"}}, // Q112106663
    {Coordinate{40.1985, 62.12}, CountryId{"RU"}}, // Q112106664
    {Coordinate{40.2228, 62.159}, CountryId{"RU"}}, // Q112106665
    {Coordinate{40.2636, 62.2246}, CountryId{"RU"}}, // Q112106666
    {Coordinate{40.3142, 62.3057}, CountryId{"RU"}}, // Q112106667
    {Coordinate{40.3282, 62.328}, CountryId{"RU"}}, // Q112106668
    {Coordinate{40.352, 62.3659}, CountryId{"RU"}}, // Q112106669
    {Coordinate{40.3823, 62.4139}, CountryId{"RU"}}, // Q112106670
    {Coordinate{40.4323, 62.4973}, CountryId{"RU"}}, // Q112106671
    {Coordinate{40.3849, 62.5602}, CountryId{"RU"}}, // Q112106672
    {Coordinate{40.3033, 62.8023}, CountryId{"RU"}}, // Q112106673
    {Coordinate{40.3156, 62.9566}, CountryId{"RU"}}, // Q112106674
    {Coordinate{40.3265, 62.9882}, CountryId{"RU"}}, // Q112106675
    {Coordinate{40.3519, 63.1773}, CountryId{"RU"}}, // Q112106676
    {Coordinate{40.3519, 63.1773}, CountryId{"RU"}}, // Q112106677
    {Coordinate{40.3401, 63.3729}, CountryId{"RU"}}, // Q112106679
    {Coordinate{40.2796, 61.2855}, CountryId{"RU"}}, // Q112106698
    {Coordinate{40.357, 63.3314}, CountryId{"RU"}}, // Q112106699
    {Coordinate{56.0462, 62.7491}, CountryId{"RU"}}, // Q112106916
    {Coordinate{53.9685, 63.5566}, CountryId{"RU"}}, // Q112106939
    {Coordinate{54.4759, 63.2052}, CountryId{"RU"}}, // Q112106940
    {Coordinate{54.7735, 63.0105}, CountryId{"RU"}}, // Q112106942
    {Coordinate{55.0497, 62.9074}, CountryId{"RU"}}, // Q112106943
    {Coordinate{9.21381, 48.1389}, CountryId{"DE"}}, // Jungnau station
    {Coordinate{9.19919, 48.1604}, CountryId{"DE"}}, // Veringendorf railway stop
    {Coordinate{9.21093, 48.1812}, CountryId{"DE"}}, // Veringenstat station
    {Coordinate{9.21737, 48.2009}, CountryId{"DE"}}, // Hermentingen railway stop
    {Coordinate{9.22949, 48.2172}, CountryId{"DE"}}, // Hettingen (Hohenz) station
    {Coordinate{9.21026, 48.2422}, CountryId{"DE"}}, // Gammertingen Europastrasse railway stop
    {Coordinate{9.0989, 48.2923}, CountryId{"DE"}}, // Burladingen-West railway stop
    {Coordinate{63.3604, 67.1079}, CountryId{"RU"}}, // Q112111680
    {Coordinate{63.7731, 67.054}, CountryId{"RU"}}, // Q112111681
    {Coordinate{64.2187, 67.0432}, CountryId{"RU"}}, // Q112111683
    {Coordinate{64.6474, 67.059}, CountryId{"RU"}}, // Q112111684
    {Coordinate{64.6474, 67.059}, CountryId{"RU"}}, // Q112111685
    {Coordinate{65.5106, 67.0559}, CountryId{"RU"}}, // Q112111686
    {Coordinate{65.6936, 66.9967}, CountryId{"RU"}}, // Q112111687
    {Coordinate{65.6909, 66.956}, CountryId{"RU"}}, // Q112111688
    {Coordinate{65.7419, 66.9061}, CountryId{"RU"}}, // Q112111689
    {Coordinate{65.8127, 66.8099}, CountryId{"RU"}}, // Q112111690
    {Coordinate{66.0198, 66.7627}, CountryId{"RU"}}, // Q112111691
    {Coordinate{66.1748, 66.7118}, CountryId{"RU"}}, // Q112111692
    {Coordinate{64.4117, 67.0167}, CountryId{"RU"}}, // Q112111711
    {Coordinate{40.6948, 64.5223}, CountryId{"RU"}}, // Q112112816
    {Coordinate{40.7088, 64.5096}, CountryId{"RU"}}, // Q112112817
    {Coordinate{40.8169, 64.4857}, CountryId{"RU"}}, // Q112112818
    {Coordinate{40.8969, 64.4786}, CountryId{"RU"}}, // Q112112819
    {Coordinate{40.929, 64.4798}, CountryId{"RU"}}, // Q112112820
    {Coordinate{41.1444, 64.4628}, CountryId{"RU"}}, // Q112112822
    {Coordinate{41.2262, 64.4434}, CountryId{"RU"}}, // Q112112823
    {Coordinate{41.4301, 64.3971}, CountryId{"RU"}}, // Q112112824
    {Coordinate{41.5446, 64.3788}, CountryId{"RU"}}, // Q112112825
    {Coordinate{41.8155, 64.3316}, CountryId{"RU"}}, // Q112112826
    {Coordinate{41.9219, 64.3032}, CountryId{"RU"}}, // Q112112827
    {Coordinate{42.2603, 64.1833}, CountryId{"RU"}}, // Q112112828
    {Coordinate{42.3198, 64.1572}, CountryId{"RU"}}, // Q112112829
    {Coordinate{42.6735, 64.0554}, CountryId{"RU"}}, // Q112112830
    {Coordinate{43.158, 64.0354}, CountryId{"RU"}}, // Q112112831
    {Coordinate{44.0104, 64.0389}, CountryId{"RU"}}, // Q112112832
    {Coordinate{44.0895, 64.0412}, CountryId{"RU"}}, // Q112112833
    {Coordinate{41.048, 64.4779}, CountryId{"RU"}}, // Q112112837
    {Coordinate{9.28686, 45.6456}, CountryId{"IT"}}, // Macherio-Canonica railway halt
    {Coordinate{10.4728, 45.1072}, CountryId{"IT"}}, // Bozzolo railway station
    {Coordinate{16.8671, 48.7379}, CountryId{"CZ"}}, // station Boří les
    {Coordinate{26.7658, 57.1828}, CountryId{"LV"}}, // Gulbene railway station
    {Coordinate{15.8097, 50.2147}, CountryId{"CZ"}}, // Hradec Králové hlavní nádraží
    {Coordinate{17.8056, 51.6492}, CountryId{"PL"}}, // Ostrów Wielkopolski
    {Coordinate{17.9081, 49.9344}, CountryId{"CZ"}}, // Opava východ
    {Coordinate{14.8654, 50.0766}, CountryId{"CZ"}}, // Český Brod train station
    {Coordinate{117.332, 49.6394}, CountryId{"RU"}}, // Zabaykalsk Railway Station
    {Coordinate{-81.8822, 31.6058}, CountryId{"US"}}, // Jesup
    {Coordinate{25.045, 60.2939}, CountryId{"FI"}}, // Tikkurila railway station
    {Coordinate{-77.4287, 37.2419}, CountryId{"US"}}, // Petersburg station
    {Coordinate{-77.4292, 37.5347}, CountryId{"US"}}, // Richmond Main Street Station
    {Coordinate{16.3394, 50.5808}, CountryId{"CZ"}}, // Broumov (train station)
    {Coordinate{-79.3853, 40.3183}, CountryId{"US"}}, // Latrobe station
    {Coordinate{131.16, 34.0533}, CountryId{"JP"}}, // Asa Station
    {Coordinate{142.85, 49.6847}, CountryId{"RU"}}, // Q114061
    {Coordinate{12.6469, 55.6358}, CountryId{"DK"}}, // Kastrup Station
    {Coordinate{7.61006, 43.7927}, CountryId{"IT"}}, // Ventimiglia railway station
    {Coordinate{12.4544, 41.8964}, CountryId{"IT"}}, // Roma San Pietro railway station
    {Coordinate{11.2367, 43.8003}, CountryId{"IT"}}, // Firenze Rifredi railway station
    {Coordinate{0.0258944, 51.5096}, CountryId{"GB"}}, // Custom House for ExCeL
    {Coordinate{-0.0103, 51.4815}, CountryId{"GB"}}, // Cutty Sark
    {Coordinate{-73.5668, 45.4996}, CountryId{"CA"}}, // Montreal Central Station
    {Coordinate{11.8803, 45.4175}, CountryId{"IT"}}, // Padova railway station
    {Coordinate{15.239, 66.4935}, CountryId{"NO"}}, // Bolna Station
    {Coordinate{142.731, 46.8058}, CountryId{"RU"}}, // Q1153093
    {Coordinate{10.6552, 44.7244}, CountryId{"IT"}}, // Reggio Emilia AV Mediopadana railway station
    {Coordinate{-87.6403, 41.8786}, CountryId{"US"}}, // Chicago Union Station
    {Coordinate{141.943, 46.8456}, CountryId{"JP"}}, // Q11584599
    {Coordinate{15.2806, 37.0689}, CountryId{"IT"}}, // Syracuse railway station
    {Coordinate{8.92667, 45.5694}, CountryId{"IT"}}, // Canegrate railway station
    {Coordinate{8.12617, 49.198}, CountryId{"DE"}}, // Landau (Pfalz) Hauptbahnhof
    {Coordinate{142.68, 46.9931}, CountryId{"RU"}}, // Q11627144
    {Coordinate{141.919, 46.799}, CountryId{"RU"}}, // Q11677451
    {Coordinate{-0.450597, 39.1531}, CountryId{"ES"}}, // Alzira
    {Coordinate{0.0575861, 40.0582}, CountryId{"ES"}}, // Q11681636
    {Coordinate{-4.62403, 36.5418}, CountryId{"ES"}}, // Fuengirola train station
    {Coordinate{0.912611, 40.9993}, CountryId{"ES"}}, // L'Hospitalet de l'Infant station
    {Coordinate{2.29452, 41.6176}, CountryId{"ES"}}, // Les Franqueses - Granollers Nord station
    {Coordinate{-1.8995, 43.3159}, CountryId{"ES"}}, // Lezo-Rentería railway station
    {Coordinate{-8.44784, 43.038}, CountryId{"ES"}}, // Ordes
    {Coordinate{-2.25642, 43.0403}, CountryId{"ES"}}, // Q11681665
    {Coordinate{-4.53391, 42.0157}, CountryId{"ES"}}, // Palencia railway station
    {Coordinate{-8.63574, 42.4216}, CountryId{"ES"}}, // Pontevedra train station
    {Coordinate{2.96461, 42.0683}, CountryId{"ES"}}, // Sant Jordi Desvalls station
    {Coordinate{0.455697, 40.4717}, CountryId{"ES"}}, // Vinaròs station
    {Coordinate{9.06885, 47.7145}, CountryId{"DE"}}, // Allensbach station
    {Coordinate{11.5734, 47.7606}, CountryId{"DE"}}, // Bad Tölz railway station
    {Coordinate{28.6134, 49.8894}, CountryId{"UA"}}, // Berdychiv
    {Coordinate{7.94266, 52.5511}, CountryId{"DE"}}, // Bersenbrück
    {Coordinate{18.0731, 49.9633}, CountryId{"CZ"}}, // Bolatice (train station)
    {Coordinate{17.8781, 49.8892}, CountryId{"CZ"}}, // Q11688765
    {Coordinate{8.88791, 53.061}, CountryId{"DE"}}, // Bremen-Sebaldsbrück
    {Coordinate{18.7176, 49.6363}, CountryId{"CZ"}}, // Bystřice
    {Coordinate{17.4044, 49.9175}, CountryId{"CZ"}}, // Q11689283
    {Coordinate{7.1668, 50.1531}, CountryId{"DE"}}, // Bahnhof Cochem
    {Coordinate{7.8817, 48.0687}, CountryId{"DE"}}, // Denzlingen station
    {Coordinate{18.4728, 49.6697}, CountryId{"CZ"}}, // Dobratice pod Prašivou
    {Coordinate{13.7904, 51.0214}, CountryId{"DE"}}, // Dresden-Reick station
    {Coordinate{13.8086, 51.0117}, CountryId{"DE"}}, // Dresden-Dobritz station
    {Coordinate{18.1714, 49.8806}, CountryId{"CZ"}}, // Děhylov (train station)
    {Coordinate{19.42, 54.1503}, CountryId{"PL"}}, // Elblag
    {Coordinate{9.6653, 47.5642}, CountryId{"DE"}}, // Enzisweiler
    {Coordinate{9.4095, 47.6883}, CountryId{"DE"}}, // Friedrichshafen-Kluftern
    {Coordinate{9.4291, 47.6643}, CountryId{"DE"}}, // Friedrichshafen-Manzell
    {Coordinate{19.3589, 47.5924}, CountryId{"HU"}}, // Gödöllő railway station
    {Coordinate{8.03083, 44.6978}, CountryId{"IT"}}, // Alba railway station
    {Coordinate{15.2056, 50.8761}, CountryId{"CZ"}}, // Bílý Potok pod Smrkem
    {Coordinate{11.9661, 51.445}, CountryId{"DE"}}, // Halle-Silberhöhe
    {Coordinate{12.4938, 64.5686}, CountryId{"NO"}}, // Harran Station
    {Coordinate{26.0459, 61.2028}, CountryId{"FI"}}, // Heinola railway station
    {Coordinate{11.0105, 52.2221}, CountryId{"DE"}}, // Helmstedt railway station
    {Coordinate{10.2133, 47.5592}, CountryId{"DE"}}, // Immenstadt station
    {Coordinate{10.7621, 47.219}, CountryId{"AT"}}, // Imst-Pitztal railway station
    {Coordinate{18.24, 52.8014}, CountryId{"PL"}}, // Inowrocław railway station
    {Coordinate{17.6917, 49.9175}, CountryId{"CZ"}}, // Q11716284
    {Coordinate{17.3181, 49.9342}, CountryId{"CZ"}}, // Q11716730
    {Coordinate{17.0156, 50.395}, CountryId{"CZ"}}, // Javorník ve Slezsku (train station)
    {Coordinate{17.9019, 49.6152}, CountryId{"CZ"}}, // Jeseník nad Odrou
    {Coordinate{17.1935, 50.2277}, CountryId{"CZ"}}, // Jeseník
    {Coordinate{18.1414, 49.8978}, CountryId{"CZ"}}, // Jilešovice
    {Coordinate{17.5383, 50.2483}, CountryId{"CZ"}}, // Q11727217
    {Coordinate{18.1509, 49.749}, CountryId{"CZ"}}, // Jistebník
    {Coordinate{25.1739, 61.8649}, CountryId{"FI"}}, // Jämsä railway station
    {Coordinate{17.4419, 49.7103}, CountryId{"CZ"}}, // Q11729826
    {Coordinate{13.0539, 51.9975}, CountryId{"DE"}}, // Jüterbog station
    {Coordinate{17.4394, 50.105}, CountryId{"CZ"}}, // Q11735892
    {Coordinate{17.4281, 50.1075}, CountryId{"CZ"}}, // Q11735893
    {Coordinate{8.3629, 49.0021}, CountryId{"DE"}}, // Karlsruhe West
    {Coordinate{17.6836, 50.0889}, CountryId{"CZ"}}, // Krnov (train station)
    {Coordinate{18.5397, 49.8347}, CountryId{"CZ"}}, // Karviná-Darkov
    {Coordinate{18.5272, 49.8558}, CountryId{"CZ"}}, // Karviná Main Station
    {Coordinate{9.4519, 51.3319}, CountryId{"DE"}}, // Kassel-Harleshausen station
    {Coordinate{9.454, 51.2763}, CountryId{"DE"}}, // Kassel-Oberzwehren railway station
    {Coordinate{9.54806, 47.6828}, CountryId{"DE"}}, // Kehlen station
    {Coordinate{20.6178, 50.8742}, CountryId{"PL"}}, // Kielce train station
    {Coordinate{17.6989, 50.2281}, CountryId{"CZ"}}, // Q11740482
    {Coordinate{17.1256, 50.3383}, CountryId{"CZ"}}, // Q11740588
    {Coordinate{18.5981, 49.7814}, CountryId{"CZ"}}, // Chotěbuz (Kocobędz)
    {Coordinate{9.16285, 47.6775}, CountryId{"DE"}}, // Konstanz Fürstenberg station
    {Coordinate{9.17347, 47.6741}, CountryId{"DE"}}, // Konstanz-Petershausen station
    {Coordinate{9.14733, 47.6825}, CountryId{"DE"}}, // Konstanz-Wollmatingen station
    {Coordinate{13.9993, 54.0452}, CountryId{"DE"}}, // Koserow railway station
    {Coordinate{14.6472, 52.5915}, CountryId{"PL"}}, // Kostrzyn station
    {Coordinate{18.1539, 49.9106}, CountryId{"CZ"}}, // Kozmice
    {Coordinate{15.5697, 54.1822}, CountryId{"PL"}}, // Train station in Kołobrzeg
    {Coordinate{18.0392, 49.9308}, CountryId{"CZ"}}, // Kravaře-Kouty
    {Coordinate{18.01, 49.935}, CountryId{"CZ"}}, // Kravaře ve Slezsku
    {Coordinate{6.6295, 51.3373}, CountryId{"DE"}}, // Krefeld-Linn station
    {Coordinate{6.6459, 51.3575}, CountryId{"DE"}}, // Krefeld-Uerdingen station
    {Coordinate{17.7128, 50.0939}, CountryId{"CZ"}}, // Krnov-Cvilín
    {Coordinate{15.9706, 50.6731}, CountryId{"CZ"}}, // Q11750075
    {Coordinate{17.6381, 50.1256}, CountryId{"CZ"}}, // Q11750080
    {Coordinate{16.2445, 50.4298}, CountryId{"PL"}}, // Kudowa-Zdrój
    {Coordinate{17.5158, 50.0372}, CountryId{"CZ"}}, // Kunov
    {Coordinate{18.2951, 49.535}, CountryId{"CZ"}}, // Kunčice pod Ondřejníkem
    {Coordinate{17.9089, 49.925}, CountryId{"CZ"}}, // Q11751788
    {Coordinate{14.3499, 53.3575}, CountryId{"DE"}}, // Kyritz
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Kölpinsee railway station
    {Coordinate{14.608, 52.5684}, CountryId{"DE"}}, // Küstrin-Kietz station
    {Coordinate{12.7142, 64.6961}, CountryId{"NO"}}, // Lassemoen Station
    {Coordinate{12.4299, 51.3716}, CountryId{"DE"}}, // Leipzig-Thekla railway station
    {Coordinate{12.3894, 51.3962}, CountryId{"DE"}}, // Leipzig Messe railway station
    {Coordinate{12.3744, 51.3629}, CountryId{"DE"}}, // Leipzig-Gohlis railway station
    {Coordinate{12.4438, 51.3442}, CountryId{"DE"}}, // Leipzig-Paunsdorf station
    {Coordinate{23.7542, 61.3133}, CountryId{"FI"}}, // Lempäälä railway station
    {Coordinate{16.5656, 51.8469}, CountryId{"PL"}}, // Leszno
    {Coordinate{18.0472, 49.9072}, CountryId{"CZ"}}, // Lhota u Opavy
    {Coordinate{15.0456, 50.7614}, CountryId{"CZ"}}, // Liberec (train station)
    {Coordinate{16.6589, 50.0973}, CountryId{"CZ"}}, // Lichkov (train station)
    {Coordinate{9.68472, 47.5593}, CountryId{"DE"}}, // Lindau-Aeschach
    {Coordinate{17.6142, 50.1364}, CountryId{"CZ"}}, // Q11756959
    {Coordinate{17.5729, 49.5292}, CountryId{"CZ"}}, // Lipník nad Bečvou (train station)
    {Coordinate{17.1311, 50.2283}, CountryId{"CZ"}}, // Lipová Lázně
    {Coordinate{17.1431, 50.2447}, CountryId{"CZ"}}, // Q11757753
    {Coordinate{17.1606, 50.2294}, CountryId{"CZ"}}, // Lipová Lázně zastávka
    {Coordinate{17.6086, 50.2236}, CountryId{"CZ"}}, // Liptaň
    {Coordinate{17.7342, 49.8875}, CountryId{"CZ"}}, // Q11761999
    {Coordinate{17.4192, 49.8733}, CountryId{"CZ"}}, // Q11762491
    {Coordinate{9.05294, 47.8156}, CountryId{"DE"}}, // Ludwigshafen (Bodensee)
    {Coordinate{16.9167, 49.8252}, CountryId{"CZ"}}, // Lukavice na Moravě
    {Coordinate{16.8415, 49.868}, CountryId{"CZ"}}, // Lupěné
    {Coordinate{18.4144, 49.9125}, CountryId{"CZ"}}, // Q11764364
    {Coordinate{18.3281, 49.6981}, CountryId{"CZ"}}, // Lískovec u Frýdku
    {Coordinate{9.4993, 47.6615}, CountryId{"DE"}}, // Löwental
    {Coordinate{13.961, 51.8622}, CountryId{"DE"}}, // Lübbenau railway station
    {Coordinate{16.8612, 50.3419}, CountryId{"PL"}}, // Train station in Lądek-Zdrój
    {Coordinate{11.6578, 52.1665}, CountryId{"DE"}}, // Magdeburg-Eichenweiler railway station
    {Coordinate{8.3141, 49.9612}, CountryId{"DE"}}, // Mainz-Laubenheim station
    {Coordinate{17.3169, 50.01}, CountryId{"CZ"}}, // Malá Morávka (train station)
    {Coordinate{17.9458, 49.9322}, CountryId{"CZ"}}, // Q11766896
    {Coordinate{8.4541, 49.4933}, CountryId{"DE"}}, // Mannheim-Handelshafen station
    {Coordinate{8.53514, 49.4238}, CountryId{"DE"}}, // Mannheim-Rheinau station
    {Coordinate{9.36987, 47.4232}, CountryId{"CH"}}, // St. Gallen railway station
    {Coordinate{9.00277, 47.7394}, CountryId{"DE"}}, // Markelfingen station
    {Coordinate{9.3884, 47.7168}, CountryId{"DE"}}, // Markdorf (Baden)
    {Coordinate{9.5584, 47.6996}, CountryId{"DE"}}, // Meckenbeuren
    {Coordinate{15.3353, 50.7641}, CountryId{"CZ"}}, // Q11774648
    {Coordinate{15.3141, 50.7592}, CountryId{"CZ"}}, // Q11774649
    {Coordinate{11.1431, 47.8449}, CountryId{"DE"}}, // Weilheim (Oberbay) station
    {Coordinate{6.6353, 49.4436}, CountryId{"DE"}}, // Q11777525
    {Coordinate{16.2436, 50.6266}, CountryId{"CZ"}}, // Meziměstí railway station
    {Coordinate{27.2776, 61.6879}, CountryId{"FI"}}, // Mikkeli railway station
    {Coordinate{17.3206, 50.3025}, CountryId{"CZ"}}, // Mikulovice (train station)
    {Coordinate{17.5578, 50.0142}, CountryId{"CZ"}}, // Milotice nad Opavou
    {Coordinate{12.9598, 50.9872}, CountryId{"DE"}}, // Mittweida railway station
    {Coordinate{17.7122, 49.8944}, CountryId{"CZ"}}, // Q11784196
    {Coordinate{16.9429, 49.7768}, CountryId{"CZ"}}, // Mohelnice
    {Coordinate{18.0308, 49.9094}, CountryId{"CZ"}}, // Mokré Lazce
    {Coordinate{16.9685, 49.7583}, CountryId{"CZ"}}, // Moravičany
    {Coordinate{17.4325, 49.7847}, CountryId{"CZ"}}, // Moravský Beroun
    {Coordinate{18.7514, 49.5078}, CountryId{"CZ"}}, // Mosty u Jablunkova station
    {Coordinate{18.7515, 49.5241}, CountryId{"CZ"}}, // Mosty u Jablunkova
    {Coordinate{14.5581, 67.2839}, CountryId{"NO"}}, // Mørkved
    {Coordinate{11.4283, 48.1546}, CountryId{"DE"}}, // München Leienfelsstraße station
    {Coordinate{11.4439, 48.149}, CountryId{"DE"}}, // München-Westkreuz station
    {Coordinate{17.5783, 50.1681}, CountryId{"CZ"}}, // Q11787946
    {Coordinate{12.8864, 52.6125}, CountryId{"DE"}}, // Nauen railway station
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Neu Pudagla railway station
    {Coordinate{13.2617, 53.5622}, CountryId{"DE"}}, // Neubrandenburg railway station
    {Coordinate{8.61288, 47.6821}, CountryId{"CH"}}, // Neuhausen Badischer Bahnhof
    {Coordinate{8.49481, 47.6892}, CountryId{"CH"}}, // Neunkirch railway station
    {Coordinate{88.4427, 26.6824}, CountryId{"IN"}}, // New Jalpaiguri Junction railway station
    {Coordinate{9.6125, 47.5753}, CountryId{"DE"}}, // Nonnenhorn railway station
    {Coordinate{17.5269, 50.0247}, CountryId{"CZ"}}, // Q11793340
    {Coordinate{18.7545, 49.5902}, CountryId{"CZ"}}, // Návsí
    {Coordinate{11.0478, 49.4096}, CountryId{"DE"}}, // Nürnberg-Eibach station
    {Coordinate{11.0547, 49.4296}, CountryId{"DE"}}, // Nürnberg-Sandreuth station
    {Coordinate{11.1114, 49.4445}, CountryId{"DE"}}, // Nürnberg-Gleißhammer station
    {Coordinate{11.068, 49.4427}, CountryId{"DE"}}, // Nürnberg-Steinbühl station
    {Coordinate{11.1217, 49.4641}, CountryId{"DE"}}, // Bahnhof Nürnberg Ost
    {Coordinate{10.3667, 55.3814}, CountryId{"DK"}}, // Odense Sygehus Station
    {Coordinate{17.2784, 49.5926}, CountryId{"CZ"}}, // Olomouc hlavní nádraží
    {Coordinate{17.3436, 50.2725}, CountryId{"CZ"}}, // Q11798302
    {Coordinate{17.3539, 50.2631}, CountryId{"CZ"}}, // Q11798303
    {Coordinate{17.9594, 49.9178}, CountryId{"CZ"}}, // Q11798470
    {Coordinate{17.9342, 49.9292}, CountryId{"CZ"}}, // Q11798471
    {Coordinate{17.8889, 49.9386}, CountryId{"CZ"}}, // Opava západ
    {Coordinate{10.4979, 48.8509}, CountryId{"DE"}}, // Nördlingen station
    {Coordinate{17.5235, 49.5171}, CountryId{"CZ"}}, // Osek nad Bečvou
    {Coordinate{17.7222, 50.2683}, CountryId{"CZ"}}, // Osoblaha (train station)
    {Coordinate{18.34, 49.7786}, CountryId{"CZ"}}, // Q11800679
    {Coordinate{18.2897, 49.8633}, CountryId{"CZ"}}, // Ostrava-Hrušov
    {Coordinate{18.2908, 49.7908}, CountryId{"CZ"}}, // Ostrava-Kunčice
    {Coordinate{18.2968, 49.8096}, CountryId{"CZ"}}, // Ostrava-Kunčičky
    {Coordinate{18.2803, 49.835}, CountryId{"CZ"}}, // Ostrava-Stodolní
    {Coordinate{18.2399, 49.8373}, CountryId{"CZ"}}, // Ostrava-Mariánské Hory (train station)
    {Coordinate{18.2101, 49.8213}, CountryId{"CZ"}}, // Ostrava-Svinov station
    {Coordinate{18.2622, 49.8011}, CountryId{"CZ"}}, // Ostrava-Vítkovice
    {Coordinate{18.1958, 49.8422}, CountryId{"CZ"}}, // Ostrava-Třebovice
    {Coordinate{18.3936, 49.5378}, CountryId{"CZ"}}, // Ostravice
    {Coordinate{18.2825, 49.8291}, CountryId{"CZ"}}, // Ostrava střed
    {Coordinate{18.3803, 49.5503}, CountryId{"CZ"}}, // Ostravice zastávka
    {Coordinate{17.8694, 49.9189}, CountryId{"CZ"}}, // Q11800991
    {Coordinate{11.8308, 53.4301}, CountryId{"DE"}}, // Parchim railway station
    {Coordinate{11.7239, 49.1642}, CountryId{"DE"}}, // Bahnhof Parsberg
    {Coordinate{18.3036, 49.7358}, CountryId{"CZ"}}, // Paskov
    {Coordinate{14.6469, 50.5733}, CountryId{"CZ"}}, // Doksy
    {Coordinate{10.2316, 52.319}, CountryId{"DE"}}, // Peine station
    {Coordinate{15.6544, 50.9688}, CountryId{"PL"}}, // Pilchowice Zapora
    {Coordinate{18.5484, 49.8934}, CountryId{"CZ"}}, // Petrovice u Karviné
    {Coordinate{17.4481, 50.075}, CountryId{"CZ"}}, // Q11819964
    {Coordinate{18.1898, 49.7787}, CountryId{"CZ"}}, // Polanka nad Odrou (train station)
    {Coordinate{17.8555, 49.5743}, CountryId{"CZ"}}, // Polom
    {Coordinate{21.7875, 61.4772}, CountryId{"FI"}}, // Pori railway station
    {Coordinate{13.0367, 52.3928}, CountryId{"DE"}}, // Potsdam Charlottenhof railway station
    {Coordinate{14.3997, 50.097}, CountryId{"CZ"}}, // Praha-Dejvice
    {Coordinate{14.3486, 50.0329}, CountryId{"CZ"}}, // Praha-Holyně
    {Coordinate{14.5359, 50.055}, CountryId{"CZ"}}, // Praha-Hostivař
    {Coordinate{14.4043, 49.9903}, CountryId{"CZ"}}, // Praha-Komořany
    {Coordinate{14.3644, 49.9858}, CountryId{"CZ"}}, // Praha-Radotín
    {Coordinate{14.3937, 50.1324}, CountryId{"CZ"}}, // Praha-Sedlec
    {Coordinate{14.3995, 49.9706}, CountryId{"CZ"}}, // Praha-Zbraslav
    {Coordinate{14.3081, 50.0324}, CountryId{"CZ"}}, // Praha-Řeporyje
    {Coordinate{17.4849, 49.5032}, CountryId{"CZ"}}, // Prosenice
    {Coordinate{12.9501, 48.8394}, CountryId{"DE"}}, // Deggendorf Hauptbahnhof
    {Coordinate{22.7767, 49.7839}, CountryId{"PL"}}, // Przemyśl Główny
    {Coordinate{17.4449, 49.447}, CountryId{"CZ"}}, // Přerov
    {Coordinate{18.3619, 49.6169}, CountryId{"CZ"}}, // Pržno
    {Coordinate{17.26, 50.2786}, CountryId{"CZ"}}, // Q11832244
    {Coordinate{18.3028, 49.7706}, CountryId{"CZ"}}, // Vratimov (train station)
    {Coordinate{8.97531, 47.7445}, CountryId{"DE"}}, // Radolfzell-Haselbrunn station
    {Coordinate{8.96898, 47.7359}, CountryId{"DE"}}, // Radolfzell station
    {Coordinate{19.1003, 49.5069}, CountryId{"PL"}}, // Rajcza Centrum railway station
    {Coordinate{17.3739, 49.4608}, CountryId{"CZ"}}, // Rokytnice u Přerova
    {Coordinate{17.1567, 49.6973}, CountryId{"CZ"}}, // Střeň
    {Coordinate{17.0325, 51.1256}, CountryId{"PL"}}, // Wrocław Nadodrze
    {Coordinate{12.3453, 51.5242}, CountryId{"DE"}}, // Delitzsch unterer station
    {Coordinate{18.8289, 68.3492}, CountryId{"SE"}}, // Abisko Östra
    {Coordinate{}, CountryId{"FI"}}, // Ajos rail yard
    {Coordinate{22.6958, 63.7069}, CountryId{"FI"}}, // Alholma (Leppäluoto) harbor track railway station
    {Coordinate{29.0247, 64.4508}, CountryId{"FI"}}, // Arola railway station
    {Coordinate{24.9568, 60.3041}, CountryId{"FI"}}, // Aviapolis railway station
    {Coordinate{20.0414, 64.7897}, CountryId{"SE"}}, // Bastuträsk
    {Coordinate{18.6853, 68.4065}, CountryId{"SE"}}, // Björkliden
    {Coordinate{21.7078, 65.8289}, CountryId{"SE"}}, // Boden Central Station
    {Coordinate{14.8323, 63.0761}, CountryId{"SE"}}, // Brunflo
    {Coordinate{23.0808, 59.8656}, CountryId{"FI"}}, // Dynamitväxel
    {Coordinate{24.1908, 62.5411}, CountryId{"FI"}}, // Eläinpuisto-Zoo
    {Coordinate{23.1835, 60.2233}, CountryId{"FI"}}, // Ervelä railway station
    {Coordinate{24.1508, 63.915}, CountryId{"FI"}}, // Eskola railway station
    {Coordinate{24.1309, 65.828}, CountryId{"FI"}}, // Haparanda
    {Coordinate{25.5086, 60.9208}, CountryId{"FI"}}, // Q11861183
    {Coordinate{21.3458, 60.7961}, CountryId{"FI"}}, // Hangonsaari railway station
    {Coordinate{22.1336, 61.31}, CountryId{"FI"}}, // Harjavalta railway station
    {Coordinate{30.1933, 62.5567}, CountryId{"FI"}}, // Heinävaara railway station
    {Coordinate{25.4728, 60.8958}, CountryId{"FI"}}, // Herrala railway station
    {Coordinate{24.9231, 60.7536}, CountryId{"FI"}}, // Hikiä railway station
    {Coordinate{25.2258, 64.7336}, CountryId{"FI"}}, // Hirvineva railway station
    {Coordinate{23.8491, 53.6865}, CountryId{"BY"}}, // Hrodna
    {Coordinate{28.4631, 64.6838}, CountryId{"FI"}}, // Hyrynsalmi railway station
    {Coordinate{29.4442, 63.4547}, CountryId{"FI"}}, // Q11864162
    {Coordinate{28.7767, 61.1958}, CountryId{"FI"}}, // Imatra railway station
    {Coordinate{24.1453, 62.5507}, CountryId{"FI"}}, // Inha railway station
    {Coordinate{26.8395, 60.6968}, CountryId{"FI"}}, // Inkeroinen railway station
    {Coordinate{22.3948, 62.9513}, CountryId{"FI"}}, // Isokyrö railway station
    {Coordinate{22.9542, 62.4719}, CountryId{"FI"}}, // Q11865685
    {Coordinate{28.4892, 61.1203}, CountryId{"FI"}}, // Joutseno station
    {Coordinate{26.9378, 60.604}, CountryId{"FI"}}, // Juurikorpi railway station
    {Coordinate{20.6514, 67.1336}, CountryId{"SE"}}, // Gällivare Central Station
    {Coordinate{25.2744, 60.8675}, CountryId{"FI"}}, // Järvelä railway station
    {Coordinate{23.0222, 62.0269}, CountryId{"FI"}}, // Q11869011
    {Coordinate{27.3476, 60.9108}, CountryId{"FI"}}, // Q11869035
    {Coordinate{23.9147, 63.8986}, CountryId{"FI"}}, // Kannus railway station
    {Coordinate{23.3883, 61.7511}, CountryId{"FI"}}, // Q11869852
    {Coordinate{24.4183, 64.0156}, CountryId{"FI"}}, // Karhukangas railway station
    {Coordinate{22.2119, 62.4599}, CountryId{"FI"}}, // Q11870457
    {Coordinate{23.0356, 63.0997}, CountryId{"FI"}}, // Kauhava railway station
    {Coordinate{23.6833, 66.4483}, CountryId{"FI"}}, // Q11870545
    {Coordinate{27.2281, 63.7094}, CountryId{"FI"}}, // Q11870623
    {Coordinate{26.3303, 60.8853}, CountryId{"FI"}}, // Kausala railway station
    {Coordinate{25.5139, 64.9128}, CountryId{"FI"}}, // Kempele railway station
    {Coordinate{29.8035, 61.8876}, CountryId{"FI"}}, // Q11871170
    {Coordinate{24.7069, 62.2555}, CountryId{"FI"}}, // Keuruu railway station
    {Coordinate{26.6117, 63.6411}, CountryId{"FI"}}, // Kiuruvesi railway station
    {Coordinate{27.4717, 64.4686}, CountryId{"FI"}}, // Kivesjärvi railway station
    {Coordinate{30.0646, 64.5496}, CountryId{"RU"}}, // Kiviyarvi
    {Coordinate{24.8458, 60.314}, CountryId{"FI"}}, // Kivistö railway station
    {Coordinate{22.3033, 61.2544}, CountryId{"FI"}}, // Kokemäki railway station
    {Coordinate{24.5069, 62.1281}, CountryId{"FI"}}, // Kolho railway station
    {Coordinate{29.8571, 62.7325}, CountryId{"FI"}}, // Kontiolahti railway station
    {Coordinate{28.1133, 64.3386}, CountryId{"FI"}}, // Kontiomäki railway station
    {Coordinate{22.4622, 62.6881}, CountryId{"FI"}}, // Q11872739
    {Coordinate{23.0367, 62.1744}, CountryId{"FI"}}, // Kuivasjärvi railway station
    {Coordinate{27.5171, 62.7719}, CountryId{"FI"}}, // Kurkimäki railway station
    {Coordinate{26.9066, 60.539}, CountryId{"FI"}}, // Kymi railway station
    {Coordinate{26.8976, 60.5076}, CountryId{"FI"}}, // Kyminlinna railway station
    {Coordinate{25.11, 60.4244}, CountryId{"FI"}}, // Kytömaa railway station
    {Coordinate{}, CountryId{"FI"}}, // Q11874094
    {Coordinate{28.0711, 64.1186}, CountryId{"FI"}}, // Q11874402
    {Coordinate{22.0032, 62.9902}, CountryId{"FI"}}, // Q11874419
    {Coordinate{27.7103, 64.2314}, CountryId{"FI"}}, // Q11874538
    {Coordinate{26.1267, 60.5992}, CountryId{"FI"}}, // Q11874637
    {Coordinate{25.1739, 60.8489}, CountryId{"FI"}}, // Lappila railway station
    {Coordinate{24.5356, 65.7961}, CountryId{"FI"}}, // Laurila railway station
    {Coordinate{25.0391, 60.3227}, CountryId{"FI"}}, // Leinelä railway station
    {Coordinate{24.969, 60.316}, CountryId{"FI"}}, // Helsinki Airport railway station
    {Coordinate{26.2472, 60.4194}, CountryId{"FI"}}, // Loviisa Port railyard
    {Coordinate{14.3474, 50.0959}, CountryId{"CZ"}}, // Nádraží Veleslavín
    {Coordinate{29.3219, 61.8003}, CountryId{"FI"}}, // Lusto railway station
    {Coordinate{28.5, 63.8817}, CountryId{"FI"}}, // Maanselkä railway station
    {Coordinate{23.3375, 63.8414}, CountryId{"FI"}}, // Q11881499
    {Coordinate{27.655, 64.4133}, CountryId{"FI"}}, // Melalahti railway station
    {Coordinate{23.885, 61.2333}, CountryId{"FI"}}, // Q11882289
    {Coordinate{25.08, 60.8231}, CountryId{"FI"}}, // Mommila railway station
    {Coordinate{20.8806, 66.4844}, CountryId{"SE"}}, // Murjek
    {Coordinate{}, CountryId{"FI"}}, // Svartå järnvägsstation
    {Coordinate{25.2711, 65.5367}, CountryId{"FI"}}, // Myllykangas railway station
    {Coordinate{26.7883, 60.77}, CountryId{"FI"}}, // Myllykoski railway station
    {Coordinate{24.2789, 62.525}, CountryId{"FI"}}, // Myllymäki railway station
    {Coordinate{25.9897, 61.1636}, CountryId{"FI"}}, // Q11883670
    {Coordinate{21.9642, 60.6507}, CountryId{"FI"}}, // Q11883684
    {Coordinate{26.8814, 61.4214}, CountryId{"FI"}}, // Mäntyharju railway station
    {Coordinate{22.4817, 61.8447}, CountryId{"FI"}}, // Niinisalo railway station
    {Coordinate{25.2661, 60.3825}, CountryId{"FI"}}, // Nikkilä railway station
    {Coordinate{}, CountryId{"FI"}}, // Q11884566
    {Coordinate{24.3172, 60.3292}, CountryId{"FI"}}, // Nummela railway station
    {Coordinate{25.7486, 60.8156}, CountryId{"FI"}}, // Q11885783
    {Coordinate{}, CountryId{"FI"}}, // Q11885792
    {Coordinate{24.3706, 61.6744}, CountryId{"FI"}}, // Orivesi center railway stop
    {Coordinate{27.0897, 64.1139}, CountryId{"FI"}}, // Otanmäki rail yard
    {Coordinate{26.9189, 60.475}, CountryId{"FI"}}, // Q11886387
    {Coordinate{22.6864, 60.4592}, CountryId{"FI"}}, // Paimio railway station
    {Coordinate{27.8222, 64.4008}, CountryId{"FI"}}, // Paltamo railway station
    {Coordinate{29.5022, 61.5586}, CountryId{"FI"}}, // Parikkala railway station
    {Coordinate{23.5522, 60.0981}, CountryId{"FI"}}, // Pohjankuru railway station
    {Coordinate{22.9411, 62.6483}, CountryId{"FI"}}, // Q11888470
    {Coordinate{29.9742, 62.0878}, CountryId{"FI"}}, // Puhos railway station
    {Coordinate{22.129, 60.4858}, CountryId{"FI"}}, // Raisio railway station
    {Coordinate{24.7617, 60.5322}, CountryId{"FI"}}, // Rajamäki railway station
    {Coordinate{29.2944, 61.8031}, CountryId{"FI"}}, // Q11890618
    {Coordinate{22.9967, 62.9033}, CountryId{"FI"}}, // Ruha railway station
    {Coordinate{26.8861, 63.6019}, CountryId{"FI"}}, // Q11891384
    {Coordinate{25.0983, 64.6608}, CountryId{"FI"}}, // Ruukki railway station
    {Coordinate{24.7575, 60.8175}, CountryId{"FI"}}, // Ryttylä railway station
    {Coordinate{27.345, 56.5197}, CountryId{"LV"}}, // Rezekne-II
    {Coordinate{29.6619, 61.6958}, CountryId{"FI"}}, // Q11891820
    {Coordinate{24.2822, 63.9794}, CountryId{"FI"}}, // Sievi railway station
    {Coordinate{27.4061, 62.2897}, CountryId{"FI"}}, // Q11893387
    {Coordinate{27.6661, 63.0753}, CountryId{"FI"}}, // Siilinjärvi railway station
    {Coordinate{23.3115, 59.9262}, CountryId{"FI"}}, // Skogby Stop
    {Coordinate{25.5403, 60.3003}, CountryId{"FI"}}, // Sköldvik railway station
    {Coordinate{27.21, 63.6317}, CountryId{"FI"}}, // Soinlahti railway station
    {Coordinate{27.4222, 63.8647}, CountryId{"FI"}}, // Sukeva railway station
    {Coordinate{28.3672, 62.3561}, CountryId{"FI"}}, // Q11895634
    {Coordinate{29.0608, 62.7172}, CountryId{"FI"}}, // Q11895636
    {Coordinate{27.998, 63.9777}, CountryId{"FI"}}, // Talvivaara rail yard
    {Coordinate{21.7419, 62.475}, CountryId{"FI"}}, // Q11897075
    {Coordinate{30.3552, 62.2448}, CountryId{"FI"}}, // Q11897816
    {Coordinate{27.7251, 62.997}, CountryId{"FI"}}, // Q11897875
    {Coordinate{24.6383, 60.9183}, CountryId{"FI"}}, // Turenki railway station
    {Coordinate{26.465, 55.6995}, CountryId{"LT"}}, // Turmantas train station
    {Coordinate{24.6305, 65.8959}, CountryId{"FI"}}, // Törmä railway station
    {Coordinate{30.2417, 62.9122}, CountryId{"FI"}}, // Uimaharju railway station
    {Coordinate{26.9326, 60.8775}, CountryId{"FI"}}, // Q11899737
    {Coordinate{21.4272, 60.7972}, CountryId{"FI"}}, // Uusikaupunki railway station
    {Coordinate{26.0156, 60.9278}, CountryId{"FI"}}, // Uusikylä railway station
    {Coordinate{26.8425, 64.5581}, CountryId{"FI"}}, // Vaala railway station
    {Coordinate{25.8744, 66.5189}, CountryId{"FI"}}, // Q11899953
    {Coordinate{28.3376, 60.8553}, CountryId{"FI"}}, // Vainikkala railway station
    {Coordinate{24.0167, 61.2742}, CountryId{"FI"}}, // Q11900121
    {Coordinate{30.1639, 62.305}, CountryId{"FI"}}, // Q11900131
    {Coordinate{22.8875, 61.3492}, CountryId{"FI"}}, // Vammala Railway Station
    {Coordinate{29.9486, 64.5397}, CountryId{"FI"}}, // Vartius railway station
    {Coordinate{29.6117, 63.4215}, CountryId{"FI"}}, // Q11901166
    {Coordinate{23.77, 61.2125}, CountryId{"FI"}}, // Viiala railway station
    {Coordinate{25.8248, 60.9466}, CountryId{"FI"}}, // Villähde railway station
    {Coordinate{24.5072, 62.0258}, CountryId{"FI"}}, // Vilppula railway station
    {Coordinate{22.8236, 63.2864}, CountryId{"FI"}}, // Q11901889
    {Coordinate{28.2733, 64.1475}, CountryId{"FI"}}, // Vuokatti Railway Station
    {Coordinate{30.6443, 62.1671}, CountryId{"RU"}}, // Vyartsilya (railway station)
    {Coordinate{22.9594, 62.4}, CountryId{"FI"}}, // Q11902887
    {Coordinate{29.5653, 62.6206}, CountryId{"FI"}}, // Ylämylly railway station
    {Coordinate{29.4689, 64.4794}, CountryId{"FI"}}, // Ypykkävaara railway station
    {Coordinate{24.0636, 62.5536}, CountryId{"FI"}}, // Ähtäri railway station
    {Coordinate{28.8906, 64.8867}, CountryId{"FI"}}, // Ämmänsaari railway station
    {Coordinate{53.9513, 56.9545}, CountryId{"RU"}}, // Kvarsa station
    {Coordinate{-0.022222, 51.4744}, CountryId{"GB"}}, // Deptford Bridge
    {Coordinate{14.3811, 49.9386}, CountryId{"CZ"}}, // Vrané nad Vltavou
    {Coordinate{12.5314, 64.2828}, CountryId{"NO"}}, // Agle Station
    {Coordinate{12.5328, 55.6858}, CountryId{"DK"}}, // Aksel Møllers Have Station
    {Coordinate{14.5572, 56.8989}, CountryId{"SE"}}, // Alvesta railway station
    {Coordinate{12.5911, 59.6535}, CountryId{"SE"}}, // Arvika Station
    {Coordinate{11.4829, 59.059}, CountryId{"NO"}}, // Aspedammen Station
    {Coordinate{10.3881, 59.3183}, CountryId{"NO"}}, // Barkåker Station
    {Coordinate{9.24833, 60.4761}, CountryId{"NO"}}, // Q11960710
    {Coordinate{16.3918, 61.3499}, CountryId{"SE"}}, // Bollnäs railway station
    {Coordinate{9.00833, 62.1036}, CountryId{"NO"}}, // Bottheim stoppested
    {Coordinate{12.0219, 60.3158}, CountryId{"NO"}}, // Brandval Station
    {Coordinate{9.20111, 60.4908}, CountryId{"NO"}}, // Bromma Station
    {Coordinate{11.5147, 59.0214}, CountryId{"NO"}}, // Q11962528
    {Coordinate{9.88611, 59.8069}, CountryId{"NO"}}, // Burud Station
    {Coordinate{9.32977, 59.3864}, CountryId{"NO"}}, // Dalsvatn Station
    {Coordinate{14.44, 59.2292}, CountryId{"SE"}}, // Degerfors station
    {Coordinate{12.9181, 63.3898}, CountryId{"SE"}}, // Duved
    {Coordinate{13.2428, 65.7008}, CountryId{"NO"}}, // Q11966887
    {Coordinate{12.5467, 55.6671}, CountryId{"DK"}}, // Enghave Plads Station
    {Coordinate{9.76972, 60.815}, CountryId{"NO"}}, // Etna Station
    {Coordinate{8.23278, 58.5225}, CountryId{"NO"}}, // Fidjetun Station
    {Coordinate{17.945, 59.2169}, CountryId{"SE"}}, // Flemingsberg railway station
    {Coordinate{16.5855, 59.0569}, CountryId{"SE"}}, // Flen station
    {Coordinate{12.0208, 60.5984}, CountryId{"NO"}}, // Flisa Station
    {Coordinate{9.2766, 62.1188}, CountryId{"NO"}}, // Fokstua Station
    {Coordinate{12.5404, 55.6737}, CountryId{"DK"}}, // Frederiksberg Allé Station
    {Coordinate{12.5791, 55.6776}, CountryId{"DK"}}, // Gammel Strand Station
    {Coordinate{5.47031, 60.4468}, CountryId{"NO"}}, // Garnes Station
    {Coordinate{12.3919, 64.5339}, CountryId{"NO"}}, // Gartland Station
    {Coordinate{11.2982, 59.3799}, CountryId{"NO"}}, // Gautestad stasjon
    {Coordinate{17.3108, 59.0486}, CountryId{"SE"}}, // Gnesta station
    {Coordinate{11.037, 59.2649}, CountryId{"NO"}}, // Greåker Station
    {Coordinate{12.0478, 60.4061}, CountryId{"NO"}}, // Grinder Station
    {Coordinate{10.4894, 60.2961}, CountryId{"NO"}}, // Grindvoll Station
    {Coordinate{9.60694, 60.3828}, CountryId{"NO"}}, // Gulsvik stasjon
    {Coordinate{12.8646, 56.6691}, CountryId{"SE"}}, // Halmstad Central Station
    {Coordinate{8.5225, 58.6286}, CountryId{"NO"}}, // Helldalsmo Station
    {Coordinate{10.2256, 60.2186}, CountryId{"NO"}}, // Hen Station
    {Coordinate{6.36333, 58.4736}, CountryId{"NO"}}, // Heskestad train station
    {Coordinate{8.36694, 60.5761}, CountryId{"NO"}}, // Hol Station
    {Coordinate{10.3497, 60.7072}, CountryId{"NO"}}, // Hov stasjon
    {Coordinate{9.9675, 61.5475}, CountryId{"NO"}}, // Hundorp Station
    {Coordinate{11.2389, 59.1589}, CountryId{"NO"}}, // Ingedal Station
    {Coordinate{11.2196, 59.3002}, CountryId{"NO"}}, // Ise Station
    {Coordinate{10.4042, 60.2403}, CountryId{"NO"}}, // Jevnaker Station
    {Coordinate{13.4721, 63.3424}, CountryId{"SE"}}, // Järpen
    {Coordinate{20.0304, 65.0544}, CountryId{"SE"}}, // Jörn
    {Coordinate{11.7081, 60.8075}, CountryId{"NO"}}, // Jømna Station
    {Coordinate{16.2077, 58.9966}, CountryId{"SE"}}, // Katrineholm central station
    {Coordinate{18.1612, 68.4198}, CountryId{"SE"}}, // Katterjåkk
    {Coordinate{9.83916, 60.0869}, CountryId{"NO"}}, // Kløftefoss stoppested
    {Coordinate{14.4481, 63.3259}, CountryId{"SE"}}, // Krokom
    {Coordinate{9.78087, 60.1268}, CountryId{"NO"}}, // Krøderen Station
    {Coordinate{10.9017, 63.5475}, CountryId{"NO"}}, // Langstein Station
    {Coordinate{10.151, 59.0615}, CountryId{"NO"}}, // Lauve Station
    {Coordinate{10.2411, 59.787}, CountryId{"NO"}}, // Lier station
    {Coordinate{18.3263, 68.4235}, CountryId{"SE"}}, // Låktatjåkka
    {Coordinate{12.589, 55.6851}, CountryId{"DK"}}, // Marmorkirken Station
    {Coordinate{12.1248, 60.0273}, CountryId{"NO"}}, // Matrand Station
    {Coordinate{10.2728, 63.2894}, CountryId{"NO"}}, // Melhus Station
    {Coordinate{10.7303, 63.4319}, CountryId{"NO"}}, // Midtsandan Station
    {Coordinate{11.2308, 60.3953}, CountryId{"NO"}}, // Minnesund Station
    {Coordinate{7.92389, 58.2156}, CountryId{"NO"}}, // Mosby Station
    {Coordinate{12.0792, 60.4992}, CountryId{"NO"}}, // Namnå Station
    {Coordinate{12.5426, 55.6886}, CountryId{"DK"}}, // Nuuks Plads station
    {Coordinate{10.3828, 59.4248}, CountryId{"NO"}}, // Nykirke Station
    {Coordinate{10.3369, 63.3167}, CountryId{"NO"}}, // Nypan Station
    {Coordinate{14.6943, 57.6521}, CountryId{"SE"}}, // Nässjö station
    {Coordinate{12.5488, 55.6936}, CountryId{"DK"}}, // Nørrebros Runddel Station
    {Coordinate{8.11139, 58.4442}, CountryId{"NO"}}, // Oggevatn stasjon
    {Coordinate{6.4675, 60.6347}, CountryId{"NO"}}, // Palmafoss Station
    {Coordinate{12.5763, 55.7094}, CountryId{"DK"}}, // Poul Henningsens Plads station
    {Coordinate{9.80333, 60.2689}, CountryId{"NO"}}, // Q11997017
    {Coordinate{10.8653, 62.9622}, CountryId{"NO"}}, // Reitstøa Station
    {Coordinate{7.76079, 62.4843}, CountryId{"NO"}}, // Q11998350
    {Coordinate{12.0529, 60.2565}, CountryId{"NO"}}, // Roverud Station
    {Coordinate{12.5681, 55.6764}, CountryId{"DK"}}, // Rådhuspladsen Station
    {Coordinate{9.60528, 59.6331}, CountryId{"NO"}}, // Saggrenda Station
    {Coordinate{11.0911, 59.2769}, CountryId{"NO"}}, // Sandesund Station
    {Coordinate{9.41618, 61.8388}, CountryId{"NO"}}, // Sel Station
    {Coordinate{8.60083, 58.7083}, CountryId{"NO"}}, // Simonstad Station
    {Coordinate{11.1898, 59.2108}, CountryId{"NO"}}, // Skjeberg Station
    {Coordinate{12.5492, 55.7037}, CountryId{"DK"}}, // Skjolds Plads station
    {Coordinate{10.3986, 60.6411}, CountryId{"NO"}}, // Skrukli Station
    {Coordinate{9.92694, 60.2408}, CountryId{"NO"}}, // Sokna Station
    {Coordinate{11.2308, 62.8558}, CountryId{"NO"}}, // Stensli Station
    {Coordinate{11.7329, 64.1205}, CountryId{"NO"}}, // Stod Station
    {Coordinate{11.6308, 64.0792}, CountryId{"NO"}}, // Sunnan stasjon
    {Coordinate{9.9165, 59.9942}, CountryId{"NO"}}, // Sysle Station
    {Coordinate{10.8964, 62.3419}, CountryId{"NO"}}, // Telneset stasjon
    {Coordinate{9.62056, 60.8442}, CountryId{"NO"}}, // Tonsåsen Station
    {Coordinate{8.71611, 60.66}, CountryId{"NO"}}, // Torpo stasjon
    {Coordinate{12.5756, 55.6992}, CountryId{"DK"}}, // Trianglen station
    {Coordinate{14.7467, 67.3019}, CountryId{"NO"}}, // Tverlandet Station
    {Coordinate{6.34306, 58.5286}, CountryId{"NO"}}, // Ualand Station
    {Coordinate{9.98472, 62.7492}, CountryId{"NO"}}, // Ulsberg Station
    {Coordinate{13.2411, 63.3144}, CountryId{"SE"}}, // Undersåker
    {Coordinate{9.96866, 57.4804}, CountryId{"DK"}}, // Vellingshøj station
    {Coordinate{8.05843, 62.3471}, CountryId{"NO"}}, // Verma Station
    {Coordinate{19.7129, 64.203}, CountryId{"SE"}}, // Vindeln
    {Coordinate{8.56213, 60.6262}, CountryId{"NO"}}, // Ål Station
    {Coordinate{9.91333, 59.8914}, CountryId{"NO"}}, // Åmot stasjon
    {Coordinate{12.5391, 63.3213}, CountryId{"SE"}}, // Ånn
    {Coordinate{11.3517, 61.0783}, CountryId{"NO"}}, // Åsta Station
    {Coordinate{14.6312, 63.178}, CountryId{"SE"}}, // Östersund western station
    {Coordinate{10.8919, 59.3051}, CountryId{"NO"}}, // Q12011874
    {Coordinate{6.2317, 51.008}, CountryId{"DE"}}, // Brachelen railway station
    {Coordinate{7.0752, 51.4503}, CountryId{"DE"}}, // Essen-Steele station
    {Coordinate{6.85219, 51.052}, CountryId{"DE"}}, // Köln-Worringen station
    {Coordinate{-88.2412, 40.1159}, CountryId{"US"}}, // Illinois Terminal
    {Coordinate{15.0734, 50.9188}, CountryId{"CZ"}}, // Frýdlant v Čechách
    {Coordinate{15.0765, 50.9268}, CountryId{"CZ"}}, // Frýdlant v Čechách předměstí
    {Coordinate{15.1973, 50.9288}, CountryId{"CZ"}}, // Hajniště
    {Coordinate{15.5877, 49.5987}, CountryId{"CZ"}}, // Havlíčkův Brod
    {Coordinate{17.6201, 49.0326}, CountryId{"CZ"}}, // Havřice
    {Coordinate{15.185, 50.8795}, CountryId{"CZ"}}, // Hejnice
    {Coordinate{14.5229, 50.6824}, CountryId{"CZ"}}, // Česká Lípa-Holý vrch railway station
    {Coordinate{15.1978, 50.952}, CountryId{"CZ"}}, // Horní Řasnice
    {Coordinate{18.0166, 49.521}, CountryId{"CZ"}}, // Hostašovice
    {Coordinate{13.8931, 49.1873}, CountryId{"CZ"}}, // Hoštice u Volyně
    {Coordinate{15.8654, 49.0942}, CountryId{"CZ"}}, // Jaroměřice nad Rokytnou
    {Coordinate{12.8669, 50.2353}, CountryId{"CZ"}}, // Karlovy Vary
    {Coordinate{12.8642, 50.2297}, CountryId{"CZ"}}, // Karlovy Vary dolní nádraží
    {Coordinate{15.1286, 50.9378}, CountryId{"CZ"}}, // Krásný Les
    {Coordinate{15.1092, 50.9308}, CountryId{"CZ"}}, // Krásný Les bažantnice
    {Coordinate{15.1519, 50.8917}, CountryId{"CZ"}}, // Luh pod Smrkem (train station)
    {Coordinate{15.1649, 50.8864}, CountryId{"CZ"}}, // Lužec pod Smrkem (train station)
    {Coordinate{15.0292, 50.9508}, CountryId{"CZ"}}, // Q12037746
    {Coordinate{18.0442, 49.5383}, CountryId{"CZ"}}, // Mořkov
    {Coordinate{18.0684, 49.5288}, CountryId{"CZ"}}, // Mořkov hlavní trať
    {Coordinate{15.0328, 50.7533}, CountryId{"CZ"}}, // Liberec-Horní Růžodol
    {Coordinate{14.4047, 49.9976}, CountryId{"CZ"}}, // Praha-Modřany
    {Coordinate{14.6767, 49.4139}, CountryId{"CZ"}}, // Tábor (train station)
    {Coordinate{15.9395, 49.5542}, CountryId{"CZ"}}, // Žďár nad Sázavou
    {Coordinate{14.4761, 50.0853}, CountryId{"CZ"}}, // Nákladové nádraží Žižkov
    {Coordinate{14.4733, 50.0511}, CountryId{"CZ"}}, // Praha jih
    {Coordinate{13.3961, 49.8039}, CountryId{"CZ"}}, // Q12045677
    {Coordinate{14.4374, 50.1062}, CountryId{"CZ"}}, // Praha-Holešovice railway stop
    {Coordinate{14.5653, 50.0481}, CountryId{"CZ"}}, // Praha-Horní Měcholupy
    {Coordinate{14.4614, 50.0417}, CountryId{"CZ"}}, // Praha-Kačerov
    {Coordinate{14.403, 50.0039}, CountryId{"CZ"}}, // Praha-Modřany zastávka
    {Coordinate{14.4053, 50.0678}, CountryId{"CZ"}}, // Praha-Smíchov Na Knížecí
    {Coordinate{14.4071, 50.0617}, CountryId{"CZ"}}, // Praha-Smíchov severní nástupiště
    {Coordinate{15.1306, 50.8964}, CountryId{"CZ"}}, // Raspenava
    {Coordinate{16.6275, 49.4086}, CountryId{"CZ"}}, // Rájec-Jestřebí
    {Coordinate{15.1578, 49.0661}, CountryId{"CZ"}}, // Senotín
    {Coordinate{8.44944, 52.2044}, CountryId{"DE"}}, // Bruchmühlen station
    {Coordinate{15.2283, 50.9592}, CountryId{"CZ"}}, // Srbská
    {Coordinate{6.94911, 51.4728}, CountryId{"DE"}}, // Essen-Borbeck station
    {Coordinate{13.8292, 50.6464}, CountryId{"CZ"}}, // Teplice v Čechách
    {Coordinate{9.06088, 48.3159}, CountryId{"DE"}}, // Killer railway stop
    {Coordinate{15.8529, 49.2089}, CountryId{"CZ"}}, // Třebíč-Borovina
    {Coordinate{15.8844, 49.2115}, CountryId{"CZ"}}, // Třebíč train station
    {Coordinate{22.7387, 38.0092}, CountryId{"GR"}}, // Kiato station
    {Coordinate{-0.458625, 51.9052}, CountryId{"GB"}}, // Leagrave railway station
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061636
    {Coordinate{34.5294, 47.6237}, CountryId{"UA"}}, // Q12061666
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061675
    {Coordinate{34.2442, 48.4961}, CountryId{"UA"}}, // Q12061689
    {Coordinate{33.7319, 46.8081}, CountryId{"UA"}}, // Q12061704
    {Coordinate{32.4676, 50.1162}, CountryId{"UA"}}, // 136 km
    {Coordinate{36.3958, 49.8481}, CountryId{"UA"}}, // Q12061729
    {Coordinate{36.2989, 49.9809}, CountryId{"UA"}}, // 13 km
    {Coordinate{32.5957, 50.0967}, CountryId{"UA"}}, // 143 km
    {Coordinate{34.7261, 48.4658}, CountryId{"UA"}}, // Q12061768
    {Coordinate{34.7378, 48.4586}, CountryId{"UA"}}, // Q12061769
    {Coordinate{34.7761, 48.4411}, CountryId{"UA"}}, // Q12061778
    {Coordinate{34.8508, 48.4433}, CountryId{"UA"}}, // Q12061784
    {Coordinate{34.8794, 48.4597}, CountryId{"UA"}}, // Q12061786
    {Coordinate{36.3494, 49.9614}, CountryId{"UA"}}, // Q12061803
    {Coordinate{35.005, 48.3553}, CountryId{"UA"}}, // Q12061894
    {Coordinate{34.8628, 48.3033}, CountryId{"UA"}}, // 233 km
    {Coordinate{34.6967, 48.2097}, CountryId{"UA"}}, // Q12061923
    {Coordinate{36.2694, 49.8772}, CountryId{"UA"}}, // Q12062006
    {Coordinate{27.1001, 50.1971}, CountryId{"UA"}}, // 4 km
    {Coordinate{36.2822, 49.8689}, CountryId{"UA"}}, // Q12062096
    {Coordinate{29.1722, 50.1317}, CountryId{"UA"}}, // 62 km
    {Coordinate{33.642, 48.0442}, CountryId{"UA"}}, // Q12062161
    {Coordinate{33.7751, 48.4236}, CountryId{"UA"}}, // 79 km
    {Coordinate{35.232, 49.8772}, CountryId{"UA"}}, // 80 km
    {Coordinate{28.9006, 50.1681}, CountryId{"UA"}}, // 82 km
    {Coordinate{12.5033, 52.5994}, CountryId{"DE"}}, // Nennhausen railway station
    {Coordinate{-1.825, 50.731}, CountryId{"GB"}}, // Pokesdown railway station
    {Coordinate{7.07925, 50.8581}, CountryId{"DE"}}, // Porz-Wahn station
    {Coordinate{-1.3765, 50.9411}, CountryId{"GB"}}, // Swaythling railway station
    {Coordinate{8.27944, 52.2364}, CountryId{"DE"}}, // Westerhausen station
    {Coordinate{24.3669, 50.635}, CountryId{"UA"}}, // Q12073651
    {Coordinate{26.9289, 49.4894}, CountryId{"UA"}}, // Q12073663
    {Coordinate{28.6704, 49.8599}, CountryId{"UA"}}, // Ivankivtsi
    {Coordinate{32.7239, 50.0827}, CountryId{"UA"}}, // Ivanivka
    {Coordinate{26.3613, 50.4616}, CountryId{"UA"}}, // Ivachkove
    {Coordinate{29.0392, 50.1369}, CountryId{"UA"}}, // Ivnytsya
    {Coordinate{35.1897, 48.4706}, CountryId{"UA"}}, // Q12073915
    {Coordinate{28.8125, 45.36}, CountryId{"UA"}}, // Izmail
    {Coordinate{37.3011, 49.216}, CountryId{"UA"}}, // Q12074128
    {Coordinate{26.8322, 50.1073}, CountryId{"UA"}}, // Izyaslav
    {Coordinate{35.2803, 48.4014}, CountryId{"UA"}}, // Ilarionove
    {Coordinate{35.1283, 47.8531}, CountryId{"UA"}}, // Imeni Anatoliya Alimova
    {Coordinate{31.6649, 51.367}, CountryId{"UA"}}, // Borys Oliinyk Station
    {Coordinate{38.4719, 48.3947}, CountryId{"UA"}}, // Q12074337
    {Coordinate{37.6823, 49.4734}, CountryId{"UA"}}, // Q12074338
    {Coordinate{27.06, 50.1328}, CountryId{"UA"}}, // Q12074339
    {Coordinate{31.8944, 49.2033}, CountryId{"UA"}}, // Taras Shevchenko station
    {Coordinate{33.1419, 47.6786}, CountryId{"UA"}}, // Inhulets
    {Coordinate{29.4517, 50.7211}, CountryId{"UA"}}, // Irsha
    {Coordinate{32.4082, 50.8422}, CountryId{"UA"}}, // Ichnia
    {Coordinate{29.2622, 47.9792}, CountryId{"UA"}}, // Abamelikove
    {Coordinate{30.3796, 50.4673}, CountryId{"UA"}}, // Akademmistechko
    {Coordinate{33.2219, 51.4531}, CountryId{"UA"}}, // Altynivka
    {Coordinate{29.0109, 50.0246}, CountryId{"UA"}}, // Q12078317
    {Coordinate{26.9831, 49.7928}, CountryId{"UA"}}, // Antoniny Railway Station
    {Coordinate{33.6906, 47.6594}, CountryId{"UA"}}, // Apostolove
    {Coordinate{29.4228, 45.9961}, CountryId{"UA"}}, // Q12079378
    {Coordinate{36.2983, 45.3747}, CountryId{"RU"}}, // Bagerovo
    {Coordinate{34.6467, 48.4819}, CountryId{"UA"}}, // Zaporizhzhia-Kamianske
    {Coordinate{32.4606, 50.1292}, CountryId{"UA"}}, // Q12080262
    {Coordinate{35.5874, 49.362}, CountryId{"UA"}}, // Q12080652
    {Coordinate{29.625, 47.8744}, CountryId{"UA"}}, // Balta
    {Coordinate{34.8381, 48.5936}, CountryId{"UA"}}, // Balivka
    {Coordinate{35.6193, 49.9261}, CountryId{"UA"}}, // Baranove
    {Coordinate{27.8328, 50.5036}, CountryId{"UA"}}, // Q12080994
    {Coordinate{31.32, 50.3461}, CountryId{"UA"}}, // Baryshivka
    {Coordinate{28.1231, 50.8233}, CountryId{"UA"}}, // Baskaky
    {Coordinate{33.4844, 47.8728}, CountryId{"UA"}}, // Q12081218
    {Coordinate{32.7987, 51.181}, CountryId{"UA"}}, // Bakhmach-Kyivskiy
    {Coordinate{33.8492, 44.7556}, CountryId{"RU"}}, // Bakhchysarai Railway Station
    {Coordinate{36.2491, 49.8885}, CountryId{"UA"}}, // Q12081555
    {Coordinate{36.1337, 50.1658}, CountryId{"UA"}}, // Bezrukivka Railway Halt
    {Coordinate{31.5019, 50.3282}, CountryId{"UA"}}, // Berezan
    {Coordinate{32.5527, 50.1011}, CountryId{"UA"}}, // Besidivshchyna
    {Coordinate{28.7427, 50.2293}, CountryId{"UA"}}, // Bystra
    {Coordinate{31.0372, 50.6468}, CountryId{"UA"}}, // Bobryk
    {Coordinate{31.3714, 50.7636}, CountryId{"UA"}}, // Bobrovytsia
    {Coordinate{33.3856, 51.8591}, CountryId{"UA"}}, // Q12083236
    {Coordinate{32.0083, 50.1919}, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{27.1394, 49.3739}, CountryId{"UA"}}, // Q12083285
    {Coordinate{35.4898, 50.1565}, CountryId{"UA"}}, // Bogodukhiv
    {Coordinate{28.5794, 50.3186}, CountryId{"UA"}}, // Q12083401
    {Coordinate{34.1228, 48.3553}, CountryId{"UA"}}, // Bozhedarivka
    {Coordinate{30.9456, 50.3767}, CountryId{"UA"}}, // Boryspil
    {Coordinate{29.8942, 50.6287}, CountryId{"UA"}}, // Borodianka
    {Coordinate{30.4091, 50.4261}, CountryId{"UA"}}, // Borshchahivka-Technichna
    {Coordinate{29.4931, 47.8661}, CountryId{"UA"}}, // Borshchi
    {Coordinate{30.5681, 50.4078}, CountryId{"UA"}}, // Botanichna Railway Halt
    {Coordinate{30.2994, 50.3211}, CountryId{"UA"}}, // Boiarka
    {Coordinate{106.07, 51.8489}, CountryId{"RU"}}, // Q12084491
    {Coordinate{39.1458, 48.3989}, CountryId{"UA"}}, // Q12084546
    {Coordinate{33.8531, 46.8314}, CountryId{"UA"}}, // Q12084628
    {Coordinate{36.9325, 49.4259}, CountryId{"UA"}}, // Q12084642
    {Coordinate{33.4859, 51.8032}, CountryId{"UA"}}, // Q12084850
    {Coordinate{25.1561, 50.0697}, CountryId{"UA"}}, // Q12084951
    {Coordinate{33.44, 51.6472}, CountryId{"UA"}}, // Bryulovetskyi
    {Coordinate{23.9369, 49.9042}, CountryId{"UA"}}, // Q12085088
    {Coordinate{29.2125, 49.9243}, CountryId{"UA"}}, // Brivky
    {Coordinate{36.4445, 49.6594}, CountryId{"UA"}}, // Q12085277
    {Coordinate{37.3941, 49.1314}, CountryId{"UA"}}, // Q12085501
    {Coordinate{30.2214, 50.5489}, CountryId{"UA"}}, // Bucha train station
    {Coordinate{30.1098, 49.8121}, CountryId{"UA"}}, // Bila Tserkva
    {Coordinate{30.3392, 46.1847}, CountryId{"UA"}}, // Bilhorod-Dnistrovskyi
    {Coordinate{30.3347, 50.4878}, CountryId{"UA"}}, // Bilychi
    {Coordinate{30.0844, 50.1736}, CountryId{"UA"}}, // Bilky Railway Halt
    {Coordinate{28.9903, 49.8175}, CountryId{"UA"}}, // Bilosillya
    {Coordinate{28.7447, 48.5336}, CountryId{"UA"}}, // Vapnyarka
    {Coordinate{28.5561, 49.4637}, CountryId{"UA"}}, // Varshitsya
    {Coordinate{30.2253, 50.2258}, CountryId{"UA"}}, // Vasylkiv 1st
    {Coordinate{27.7802, 49.1348}, CountryId{"UA"}}, // Q12088034
    {Coordinate{32.5449, 51.1143}, CountryId{"UA"}}, // Velyka Zahorivka
    {Coordinate{26.9536, 49.925}, CountryId{"UA"}}, // Q12088492
    {Coordinate{26.9433, 49.8319}, CountryId{"UA"}}, // Q12088497
    {Coordinate{33.7381, 50.3647}, CountryId{"UA"}}, // Veneslavivka
    {Coordinate{26.9822, 49.9853}, CountryId{"UA"}}, // Verbivtsi
    {Coordinate{28.7647, 50.3136}, CountryId{"UA"}}, // Veresy
    {Coordinate{28.9499, 49.7877}, CountryId{"UA"}}, // Vernyhorodok
    {Coordinate{34.3686, 48.5539}, CountryId{"UA"}}, // Verkhnodniprovsk
    {Coordinate{36.3074, 47.2072}, CountryId{"UA"}}, // Verkhnii Tokmak 1
    {Coordinate{29.992, 47.1059}, CountryId{"UA"}}, // Veselyi Kut
    {Coordinate{28.4775, 49.1364}, CountryId{"UA"}}, // Veselka
    {Coordinate{33.4281, 47.9958}, CountryId{"UA"}}, // Vechirnii Kut
    {Coordinate{30.3978, 46.6136}, CountryId{"UA"}}, // Vyhoda
    {Coordinate{31.6472, 48.6336}, CountryId{"UA"}}, // Vyska
    {Coordinate{32.8656, 47.9811}, CountryId{"UA"}}, // Visun
    {Coordinate{30.3689, 50.3844}, CountryId{"UA"}}, // Vyshneve
    {Coordinate{30.0275, 50.1478}, CountryId{"UA"}}, // Vyshnyaky
    {Coordinate{35.3764, 45.1683}, CountryId{"UA"}}, // Vladislavovka
    {Coordinate{36.9194, 50.2836}, CountryId{"UA"}}, // Q12089995
    {Coordinate{38.4883, 48.8697}, CountryId{"UA"}}, // Q12090014
    {Coordinate{35.9575, 49.9416}, CountryId{"UA"}}, // Vodyane
    {Coordinate{29.68, 50.0411}, CountryId{"UA"}}, // Volytsya
    {Coordinate{24.3347, 50.8417}, CountryId{"UA"}}, // Q12090407
    {Coordinate{26.2084, 49.5322}, CountryId{"UA"}}, // Volochysk
    {Coordinate{34.2246, 51.1702}, CountryId{"UA"}}, // Vorozhba
    {Coordinate{30.5844, 47.8767}, CountryId{"UA"}}, // Q12090819
    {Coordinate{29.1167, 49.8927}, CountryId{"UA"}}, // Vchoraishe
    {Coordinate{26.4503, 49.4955}, CountryId{"UA"}}, // Q12093150
    {Coordinate{34.0158, 48.4653}, CountryId{"UA"}}, // Vilnohirsk railway station
    {Coordinate{29.438, 51.3613}, CountryId{"UA"}}, // Vilcha
    {Coordinate{28.5333, 49.2692}, CountryId{"UA"}}, // Vinnitsya-Vantazhna
    {Coordinate{28.511, 49.2393}, CountryId{"UA"}}, // Vinnytsia
    {Coordinate{35.574, 50.0842}, CountryId{"UA"}}, // Q12093758
    {Coordinate{33.9756, 50.3856}, CountryId{"UA"}}, // Q12093803
    {Coordinate{30.8397, 49.7474}, CountryId{"UA"}}, // Halyne
    {Coordinate{32.1907, 50.7063}, CountryId{"UA"}}, // Halka
    {Coordinate{27.3918, 50.1311}, CountryId{"UA"}}, // Hannusyne
    {Coordinate{26.3708, 49.5175}, CountryId{"UA"}}, // Harnyshivka
    {Coordinate{33.0681, 47.9292}, CountryId{"UA"}}, // Heikivka
    {Coordinate{34.7741, 46.1737}, CountryId{"UA"}}, // Q12094739
    {Coordinate{30.3075, 50.2575}, CountryId{"UA"}}, // Hlevakha
    {Coordinate{33.9383, 51.6781}, CountryId{"UA"}}, // Hlukhiv
    {Coordinate{28.7213, 49.8038}, CountryId{"UA"}}, // Hluhivtsi
    {Coordinate{28.3298, 49.1024}, CountryId{"UA"}}, // Hnivan'
    {Coordinate{33.8228, 49.9125}, CountryId{"UA"}}, // Hoholeve
    {Coordinate{28.7153, 49.5653}, CountryId{"UA"}}, // Holendry
    {Coordinate{28.6823, 50.456}, CountryId{"UA"}}, // Gorbashi
    {Coordinate{31.6419, 51.9144}, CountryId{"UA"}}, // Horodnia
    {Coordinate{24.8156, 50.4498}, CountryId{"UA"}}, // Q12097137
    {Coordinate{34.9819, 48.4792}, CountryId{"UA"}}, // Horiaiinove
    {Coordinate{36.8671, 49.7292}, CountryId{"UA"}}, // Q12097411
    {Coordinate{33.3906, 48.0956}, CountryId{"UA"}}, // Hrekuvata
    {Coordinate{26.9511, 49.4282}, CountryId{"UA"}}, // Q12097633
    {Coordinate{31.8349, 50.9984}, CountryId{"UA"}}, // Hryhoro-Ivanivka
    {Coordinate{32.8234, 51.0179}, CountryId{"UA"}}, // Q12097711
    {Coordinate{33.5397, 51.2139}, CountryId{"UA"}}, // Q12098060
    {Coordinate{26.857, 49.4637}, CountryId{"UA"}}, // Hruzivtsi
    {Coordinate{35.3748, 50.1775}, CountryId{"UA"}}, // Q12098238
    {Coordinate{35.2661, 48.8022}, CountryId{"UA"}}, // Hubynykha
    {Coordinate{27.725, 50.5286}, CountryId{"UA"}}, // Q12098353
    {Coordinate{30.2736, 50.2444}, CountryId{"UA"}}, // Danylivka
    {Coordinate{30.6755, 50.4385}, CountryId{"UA"}}, // Darnytsia-Depo
    {Coordinate{27.1006, 49.765}, CountryId{"UA"}}, // Q12099624
    {Coordinate{28.2334, 49.0883}, CountryId{"UA"}}, // Demydivka
    {Coordinate{28.409, 49.948}, CountryId{"UA"}}, // Demchyn
    {Coordinate{38.4972, 48.3647}, CountryId{"UA"}}, // Q12100187
    {Coordinate{28.5596, 49.3239}, CountryId{"UA"}}, // Desenka
    {Coordinate{29.1164, 45.6519}, CountryId{"UA"}}, // Dzynilor
    {Coordinate{30.9408, 50.5923}, CountryId{"UA"}}, // Dymerka
    {Coordinate{34.4169, 48.5892}, CountryId{"UA"}}, // Q12101357
    {Coordinate{34.6353, 48.5897}, CountryId{"UA"}}, // Q12101384
    {Coordinate{34.5875, 48.5256}, CountryId{"UA"}}, // Kamianske
    {Coordinate{34.991, 48.4217}, CountryId{"UA"}}, // Dnipro-Vantazhnyi
    {Coordinate{28.5858, 51.2897}, CountryId{"UA"}}, // Khaichnoryn
    {Coordinate{32.7617, 48.115}, CountryId{"UA"}}, // Dolynska
    {Coordinate{31.688, 50.9443}, CountryId{"UA"}}, // Doslidna
    {Coordinate{28.6724, 50.9424}, CountryId{"UA"}}, // Drevlyanka
    {Coordinate{34.618, 49.6092}, CountryId{"UA"}}, // Dublianshchyna
    {Coordinate{33.3922, 51.1989}, CountryId{"UA"}}, // Q12102637
    {Coordinate{36.6941, 48.814}, CountryId{"UA"}}, // Q12102642
    {Coordinate{28.425, 50.3517}, CountryId{"UA"}}, // Q12102644
    {Coordinate{27.3403, 50.3197}, CountryId{"UA"}}, // Q12102711
    {Coordinate{26.8381, 49.0206}, CountryId{"UA"}}, // Dunaivtsi
    {Coordinate{34.9089, 48.4614}, CountryId{"UA"}}, // Diivka Railway Station
    {Coordinate{33.3906, 46.7575}, CountryId{"UA"}}, // Q12103718
    {Coordinate{34.0414, 51.8106}, CountryId{"UA"}}, // Q12104126
    {Coordinate{24.0172, 52.2006}, CountryId{"BY"}}, // Zhabinka
    {Coordinate{33.9153, 48.4369}, CountryId{"UA"}}, // Erastivka
    {Coordinate{31.001, 50.6264}, CountryId{"UA"}}, // Zherdove
    {Coordinate{28.6978, 50.2681}, CountryId{"UA"}}, // Zhytomyr
    {Coordinate{36.2475, 49.8475}, CountryId{"UA"}}, // Zhykhor
    {Coordinate{33.6153, 48.3817}, CountryId{"UA"}}, // Zhovti Vody 1
    {Coordinate{28.7204, 48.6012}, CountryId{"UA"}}, // Zhuravlivka
    {Coordinate{31.1357, 50.6901}, CountryId{"UA"}}, // Zavorychi
    {Coordinate{33.5589, 46.7731}, CountryId{"UA"}}, // Q12105183
    {Coordinate{29.795, 50.6567}, CountryId{"UA"}}, // Zahaltsi
    {Coordinate{37.2033, 49.3767}, CountryId{"UA"}}, // Q12105425
    {Coordinate{36.1617, 49.9675}, CountryId{"UA"}}, // Zalyutine
    {Coordinate{27.0186, 49.6111}, CountryId{"UA"}}, // Q12105801
    {Coordinate{35.2378, 47.8842}, CountryId{"UA"}}, // Zaporizhzhia-Ljive
    {Coordinate{35.1881, 47.7958}, CountryId{"UA"}}, // Zaporizhzhia I
    {Coordinate{35.1847, 47.8222}, CountryId{"UA"}}, // Zaporizhzhia 2
    {Coordinate{27.0297, 49.5506}, CountryId{"UA"}}, // Q12105943
    {Coordinate{35.2297, 49.2144}, CountryId{"UA"}}, // Q12106211
    {Coordinate{34.0224, 52.1839}, CountryId{"UA"}}, // Zernove
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Znamyanka-Pasazhirska
    {Coordinate{32.6539, 48.7163}, CountryId{"UA"}}, // Znamyanka
    {Coordinate{35.9883, 50.2737}, CountryId{"UA"}}, // Q12107002
    {Coordinate{35.0202, 48.3997}, CountryId{"UA"}}, // Zustrichny
    {Coordinate{36.3031, 49.79}, CountryId{"UA"}}, // Q12107263
    {Coordinate{29.0009, 50.8601}, CountryId{"UA"}}, // Yosypivka
    {Coordinate{30.7846, 49.8419}, CountryId{"UA"}}, // Kaharlyk
    {Coordinate{32.7614, 47.8806}, CountryId{"UA"}}, // Kazanka
    {Coordinate{24.3489, 49.0128}, CountryId{"UA"}}, // Kalush
    {Coordinate{33.6389, 48.1325}, CountryId{"UA"}}, // Q12107981
    {Coordinate{26.9744, 49.4167}, CountryId{"UA"}}, // Kamianetskyi Pereizd
    {Coordinate{31.7806, 51.8633}, CountryId{"UA"}}, // Kamka
    {Coordinate{24.9604, 51.6054}, CountryId{"UA"}}, // Q12108257
    {Coordinate{34.9506, 47.8383}, CountryId{"UA"}}, // Q12108331
    {Coordinate{35.8699, 49.9571}, CountryId{"UA"}}, // Karavanna
    {Coordinate{30.832, 49.6371}, CountryId{"UA"}}, // Karapyshi
    {Coordinate{34.7211, 48.4775}, CountryId{"UA"}}, // Q12108762
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12108950
    {Coordinate{33.4286, 46.7525}, CountryId{"UA"}}, // Q12109158
    {Coordinate{32.6583, 50.8896}, CountryId{"UA"}}, // Q12109192
    {Coordinate{30.845, 50.5342}, CountryId{"UA"}}, // Kvitnevyi
    {Coordinate{35.7639, 49.2867}, CountryId{"UA"}}, // Q12109390
    {Coordinate{26.825, 48.4444}, CountryId{"UA"}}, // Kelmentsi
    {Coordinate{36.4275, 45.3631}, CountryId{"RU"}}, // Kerch Railway station
    {Coordinate{38.6958, 48.4386}, CountryId{"UA"}}, // Q12109879
    {Coordinate{30.0164, 50.5813}, CountryId{"UA"}}, // Klavdijeve
    {Coordinate{23.9803, 49.8556}, CountryId{"UA"}}, // Q12110434
    {Coordinate{28.8618, 50.322}, CountryId{"UA"}}, // Q12110675
    {Coordinate{28.8129, 48.4719}, CountryId{"UA"}}, // Knyazheve
    {Coordinate{30.783, 50.495}, CountryId{"UA"}}, // Kniazhychi
    {Coordinate{34.1033, 49.2306}, CountryId{"UA"}}, // Q12110816
    {Coordinate{31.5493, 50.8237}, CountryId{"UA"}}, // Kobyzhchi
    {Coordinate{24.7119, 51.2217}, CountryId{"UA"}}, // Kovel
    {Coordinate{28.6646, 50.1078}, CountryId{"UA"}}, // Kodnia
    {Coordinate{29.7315, 49.9811}, CountryId{"UA"}}, // Kozhanka
    {Coordinate{28.8865, 50.3224}, CountryId{"UA"}}, // Q12111277
    {Coordinate{33.3284, 46.7846}, CountryId{"UA"}}, // Q12111317
    {Coordinate{28.1799, 49.0882}, CountryId{"UA"}}, // Kozachivka
    {Coordinate{28.8389, 49.7114}, CountryId{"UA"}}, // Koziatyn 1st
    {Coordinate{27.5033, 50.4281}, CountryId{"UA"}}, // Kolodyanka
    {Coordinate{28.3597, 50.365}, CountryId{"UA"}}, // Q12111684
    {Coordinate{35.2177, 49.855}, CountryId{"UA"}}, // Kolomak
    {Coordinate{31.0172, 47.3036}, CountryId{"UA"}}, // Kolosivka Railway Station
    {Coordinate{27.6656, 49.1947}, CountryId{"UA"}}, // Q12111948
    {Coordinate{36.6961, 47.3286}, CountryId{"UA"}}, // Komysh-Zoria
    {Coordinate{32.1067, 50.1775}, CountryId{"UA"}}, // Kononivka
    {Coordinate{28.7834, 49.64}, CountryId{"UA"}}, // Kordyshivka
    {Coordinate{33.0662, 48.7324}, CountryId{"UA"}}, // Korystivka
    {Coordinate{29.5172, 50.0419}, CountryId{"UA"}}, // Kornyn
    {Coordinate{28.6347, 50.9569}, CountryId{"UA"}}, // Korosten
    {Coordinate{29.0202, 50.3163}, CountryId{"UA"}}, // Q12113210
    {Coordinate{36.0355, 49.9548}, CountryId{"UA"}}, // Korotych
    {Coordinate{30.1353, 50.1942}, CountryId{"UA"}}, // Q12113323
    {Coordinate{31.5766, 50.8633}, CountryId{"UA"}}, // Kosmichna
    {Coordinate{34.0989, 51.1703}, CountryId{"UA"}}, // Q12113964
    {Coordinate{27.0139, 49.6692}, CountryId{"UA"}}, // Krasyliv Railway Station
    {Coordinate{24.6147, 49.9169}, CountryId{"UA"}}, // Krasne
    {Coordinate{35.445, 49.3606}, CountryId{"UA"}}, // Q12114235
    {Coordinate{28.62, 50.7697}, CountryId{"UA"}}, // Krasnosilka
    {Coordinate{26.9508, 49.8603}, CountryId{"UA"}}, // Q12114331
    {Coordinate{33.3097, 47.8789}, CountryId{"UA"}}, // Kryvyi Rih-West railway station
    {Coordinate{33.3764, 47.8783}, CountryId{"UA"}}, // Kryvyi Rih
    {Coordinate{26.7003, 50.3616}, CountryId{"UA"}}, // Kryvyn
    {Coordinate{28.8642, 48.3797}, CountryId{"UA"}}, // Kryzhopil'
    {Coordinate{33.3619, 51.5514}, CountryId{"UA"}}, // Krolevets
    {Coordinate{28.6708, 50.2947}, CountryId{"UA"}}, // Q12115030
    {Coordinate{33.4356, 49.0344}, CountryId{"UA"}}, // Kriukiv Railway Station
    {Coordinate{}, CountryId{"UA"}}, // Kriukivshchyna
    {Coordinate{34.0489, 48.2739}, CountryId{"UA"}}, // Q12115417
    {Coordinate{54.04, 57.9433}, CountryId{"RU"}}, // Q12115525
    {Coordinate{27.0872, 49.6806}, CountryId{"UA"}}, // Q12115546
    {Coordinate{35.3091, 50.2307}, CountryId{"UA"}}, // Q12115859
    {Coordinate{28.1189, 50.4308}, CountryId{"UA"}}, // Q12115988
    {Coordinate{31.1194, 50.3627}, CountryId{"UA"}}, // Kuchakove
    {Coordinate{35.1969, 47.7197}, CountryId{"UA"}}, // Q12116306
    {Coordinate{35.2736, 48.8767}, CountryId{"UA"}}, // Q12116431
    {Coordinate{32.2604, 48.5238}, CountryId{"UA"}}, // Kropyvnytskyi
    {Coordinate{35.2183, 45.2272}, CountryId{"UA"}}, // Q12116617
    {Coordinate{32.6436, 50.0955}, CountryId{"UA"}}, // Lazirky
    {Coordinate{26.8505, 48.4311}, CountryId{"UA"}}, // Larha
    {Coordinate{29.4858, 50.0647}, CountryId{"UA"}}, // Lypnyak
    {Coordinate{26.2882, 49.5278}, CountryId{"UA"}}, // Lozova
    {Coordinate{31.987, 50.8756}, CountryId{"UA"}}, // Q12118462
    {Coordinate{29.3353, 50.1197}, CountryId{"UA"}}, // Lotos
    {Coordinate{33.4603, 50.3681}, CountryId{"UA"}}, // Q12118512
    {Coordinate{39.2081, 48.4097}, CountryId{"UA"}}, // Q12118937
    {Coordinate{35.9273, 49.9412}, CountryId{"UA"}}, // Ljubotin
    {Coordinate{35.8936, 49.9517}, CountryId{"UA"}}, // Lubivka
    {Coordinate{30.5341, 50.2963}, CountryId{"UA"}}, // Lisnyky
    {Coordinate{28.8517, 50.1858}, CountryId{"UA"}}, // Lishchyn
    {Coordinate{27.3078, 50.2936}, CountryId{"UA"}}, // Maidan-Vyla
    {Coordinate{31.3262, 50.748}, CountryId{"UA"}}, // Makarivka
    {Coordinate{33.5894, 51.8261}, CountryId{"UA"}}, // Makove
    {Coordinate{35.701, 50.0897}, CountryId{"UA"}}, // Q12120655
    {Coordinate{29.9482, 50.6035}, CountryId{"UA"}}, // Makiychukove
    {Coordinate{34.52, 49.3964}, CountryId{"UA"}}, // Mala Pereshchepynska
    {Coordinate{29.2949, 50.7746}, CountryId{"UA"}}, // Malyn
    {Coordinate{26.5492, 51.0947}, CountryId{"UA"}}, // Q12120858
    {Coordinate{24.0858, 51.7939}, CountryId{"BY"}}, // Malaryta
    {Coordinate{30.305, 50.2897}, CountryId{"UA"}}, // Maliutianka
    {Coordinate{32.2672, 50.1481}, CountryId{"UA"}}, // Marianivka
    {Coordinate{30.5944, 50.2057}, CountryId{"UA"}}, // Marianivska
    {Coordinate{35.4712, 49.9289}, CountryId{"UA"}}, // Marjine
    {Coordinate{34.6214, 47.655}, CountryId{"UA"}}, // Q12121308
    {Coordinate{31.2775, 50.7286}, CountryId{"UA"}}, // Markivtsi
    {Coordinate{33.1464, 46.9188}, CountryId{"UA"}}, // Q12121920
    {Coordinate{27.9795, 49.0652}, CountryId{"UA"}}, // Q12122289
    {Coordinate{36.7361, 48.2506}, CountryId{"UA"}}, // Q12122299
    {Coordinate{28.8692, 50.8892}, CountryId{"UA"}}, // Meleni
    {Coordinate{35.7626, 50.0076}, CountryId{"UA"}}, // Q12122785
    {Coordinate{36.2017, 47.9833}, CountryId{"UA"}}, // Q12123151
    {Coordinate{24.5111, 51.3617}, CountryId{"UA"}}, // Q12123208
    {Coordinate{32.0619, 46.9372}, CountryId{"UA"}}, // Mykolaiv
    {Coordinate{28.7478, 49.6017}, CountryId{"UA"}}, // Mykolayivka
    {Coordinate{33.9628, 48.1994}, CountryId{"UA"}}, // Q12123391
    {Coordinate{33.6256, 49.9492}, CountryId{"UA"}}, // Myrhorod
    {Coordinate{30.9807, 49.6483}, CountryId{"UA"}}, // Myronivka
    {Coordinate{27.6687, 50.0998}, CountryId{"UA"}}, // Myropil
    {Coordinate{28.4694, 49.9536}, CountryId{"UA"}}, // Myroslavka
    {Coordinate{27.4761, 50.3917}, CountryId{"UA"}}, // Myroslavl
    {Coordinate{26.5572, 50.4152}, CountryId{"UA"}}, // Mohylyany
    {Coordinate{28.2742, 49.0921}, CountryId{"UA"}}, // Mohylivka
    {Coordinate{27.0642, 50.0592}, CountryId{"UA"}}, // Q12124186
    {Coordinate{28.2761, 50.3892}, CountryId{"UA"}}, // Q12128134
    {Coordinate{28.1119, 49.0339}, CountryId{"UA"}}, // Zhmerynka
    {Coordinate{31.4345, 50.3356}, CountryId{"UA"}}, // Zhovtnevyi
    {Coordinate{33.6436, 46.7903}, CountryId{"UA"}}, // Q12129294
    {Coordinate{30.1053, 50.1822}, CountryId{"UA"}}, // Motovylivka
    {Coordinate{36.4801, 49.8322}, CountryId{"UA"}}, // Q12130339
    {Coordinate{33.4025, 47.9153}, CountryId{"UA"}}, // Mudrona
    {Coordinate{22.7114, 48.4294}, CountryId{"UA"}}, // Mukachevo Railway Station
    {Coordinate{33.2039, 47.8867}, CountryId{"UA"}}, // Q12130877
    {Coordinate{39.1383, 48.5767}, CountryId{"UA"}}, // Milova
    {Coordinate{27.5744, 50.5564}, CountryId{"UA"}}, // Nalyvna
    {Coordinate{26.6211, 49.5085}, CountryId{"UA"}}, // Narkevychi
    {Coordinate{38.4079, 48.9422}, CountryId{"UA"}}, // Q12132512
    {Coordinate{28.2278, 50.4008}, CountryId{"UA"}}, // Q12133058
    {Coordinate{30.087, 50.5617}, CountryId{"UA"}}, // Nemishajeve
    {Coordinate{33.8442, 51.9728}, CountryId{"UA"}}, // Neplyujeve
    {Coordinate{34.7378, 45.4472}, CountryId{"UA"}}, // Q12133681
    {Coordinate{35.0636, 48.4981}, CountryId{"UA"}}, // Q12133684
    {Coordinate{28.6243, 50.6912}, CountryId{"UA"}}, // Nova Borova
    {Coordinate{28.7428, 50.2311}, CountryId{"UA"}}, // Nova Bystra
    {Coordinate{28.5164, 50.3322}, CountryId{"UA"}}, // Q12133825
    {Coordinate{29.7811, 50.0333}, CountryId{"UA"}}, // Nova Volytsya
    {Coordinate{28.7782, 50.9234}, CountryId{"UA"}}, // Novaki
    {Coordinate{33.2551, 51.9932}, CountryId{"UA"}}, // Novhorod-Siverskyi
    {Coordinate{33.4856, 47.9122}, CountryId{"UA"}}, // Q12134026
    {Coordinate{27.5931, 50.5978}, CountryId{"UA"}}, // Novohrad-Volynskyi 1
    {Coordinate{27.7833, 50.5139}, CountryId{"UA"}}, // Q12134061
    {Coordinate{35.4858, 48.0239}, CountryId{"UA"}}, // Novohupolivka (railway station)
    {Coordinate{35.2322, 48.6425}, CountryId{"UA"}}, // Q12134139
    {Coordinate{34.6503, 46.2306}, CountryId{"UA"}}, // Novooleksiivka
    {Coordinate{29.8686, 46.8022}, CountryId{"MD"}}, // Novosavitskaia
    {Coordinate{30.6236, 50.1863}, CountryId{"UA"}}, // Novi Bezradychi
    {Coordinate{34.4042, 49.3281}, CountryId{"UA"}}, // Q12134305
    {Coordinate{31.6041, 50.9028}, CountryId{"UA"}}, // Nosivka
    {Coordinate{34.3944, 47.5867}, CountryId{"UA"}}, // Nikopol Railway Station
    {Coordinate{30.7313, 50.0336}, CountryId{"UA"}}, // Ozernyi
    {Coordinate{26.035, 50.4578}, CountryId{"UA"}}, // Q12135355
    {Coordinate{33.1325, 48.6739}, CountryId{"UA"}}, // Oleksandriya
    {Coordinate{26.9283, 49.4708}, CountryId{"UA"}}, // Q12135739
    {Coordinate{30.6489, 49.6581}, CountryId{"UA"}}, // Olshanytsia
    {Coordinate{27.5614, 50.5053}, CountryId{"UA"}}, // Orepy
    {Coordinate{36.0191, 48.9746}, CountryId{"UA"}}, // Q12136461
    {Coordinate{26.9272, 49.4997}, CountryId{"UA"}}, // Q12136731
    {Coordinate{26.4941, 50.437}, CountryId{"UA"}}, // Ostroh
    {Coordinate{34.9165, 50.3175}, CountryId{"UA"}}, // Q12137017
    {Coordinate{33.6478, 48.4271}, CountryId{"UA"}}, // P'yatykhatky-Stykova
    {Coordinate{33.7031, 48.4144}, CountryId{"UA"}}, // P'yatykhatky
    {Coordinate{35.2699, 49.8936}, CountryId{"UA"}}, // Panasivka
    {Coordinate{32.075, 49.5053}, CountryId{"UA"}}, // Q12138703
    {Coordinate{30.9024, 50.5704}, CountryId{"UA"}}, // Parnykova
    {Coordinate{28.5182, 49.1748}, CountryId{"UA"}}, // Parpurivskyi Railway Halt
    {Coordinate{27.0508, 50.0983}, CountryId{"UA"}}, // Q12139250
    {Coordinate{29.3699, 50.7367}, CountryId{"UA"}}, // Penyzevychi
    {Coordinate{31.1822, 47.2967}, CountryId{"UA"}}, // Q12139466
    {Coordinate{30.8514, 48.0411}, CountryId{"UA"}}, // Pervomaisk-na-Buzi
    {Coordinate{38.5789, 48.6253}, CountryId{"UA"}}, // Q12139477
    {Coordinate{37.6131, 49.3647}, CountryId{"UA"}}, // Q12139564
    {Coordinate{35.3119, 49.0192}, CountryId{"UA"}}, // Q12139842
    {Coordinate{31.6556, 50.2641}, CountryId{"UA"}}, // Pereyaslavska
    {Coordinate{24.0294, 49.8097}, CountryId{"UA"}}, // Q12139900
    {Coordinate{27.8004, 50.0752}, CountryId{"UA"}}, // Pechanivka
    {Coordinate{35.8053, 49.9268}, CountryId{"UA"}}, // Pyrogova
    {Coordinate{32.5064, 50.2353}, CountryId{"UA"}}, // Q12140595
    {Coordinate{29.2202, 50.8042}, CountryId{"UA"}}, // Pirizhkivskiy
    {Coordinate{33.601, 48.0161}, CountryId{"UA"}}, // Q12140660
    {Coordinate{34.2822, 48.5389}, CountryId{"UA"}}, // Q12140803
    {Coordinate{34.3122, 48.5544}, CountryId{"UA"}}, // Q12140804
    {Coordinate{34.5511, 48.4994}, CountryId{"UA"}}, // Q12140805
    {Coordinate{34.4508, 48.5361}, CountryId{"UA"}}, // Q12140806
    {Coordinate{34.1324, 48.471}, CountryId{"UA"}}, // Hranove
    {Coordinate{32.4403, 51.1028}, CountryId{"UA"}}, // Plysky
    {Coordinate{36.2592, 47.4761}, CountryId{"UA"}}, // Polohy Railway Station
    {Coordinate{27.4882, 50.1396}, CountryId{"UA"}}, // Polonne
    {Coordinate{33.1642, 47.7644}, CountryId{"UA"}}, // Poltavka-Kryvorizka
    {Coordinate{34.2233, 48.4431}, CountryId{"UA"}}, // Q12142068
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Pomichna Railway Station
    {Coordinate{27.5248, 50.138}, CountryId{"UA"}}, // Poninka
    {Coordinate{31.4983, 50.7978}, CountryId{"UA"}}, // Popudrenko
    {Coordinate{29.4594, 49.9445}, CountryId{"UA"}}, // Popilnia
    {Coordinate{36.1872, 50.0168}, CountryId{"UA"}}, // Q12142757
    {Coordinate{34.6006, 49.5667}, CountryId{"UA"}}, // Q12142758
    {Coordinate{35.9855, 49.9472}, CountryId{"UA"}}, // Post 21 km
    {Coordinate{33.8864, 48.1597}, CountryId{"UA"}}, // Q12142876
    {Coordinate{29.8786, 50.0533}, CountryId{"UA"}}, // Potiivka
    {Coordinate{34.6589, 48.5172}, CountryId{"UA"}}, // Q12143209
    {Coordinate{34.7558, 48.2269}, CountryId{"UA"}}, // Q12144085
    {Coordinate{32.0375, 51.0624}, CountryId{"UA"}}, // Priosternij
    {Coordinate{35.0731, 48.4522}, CountryId{"UA"}}, // Q12145038
    {Coordinate{36.3764, 48.1175}, CountryId{"UA"}}, // Q12145067
    {Coordinate{36.1678, 50.2402}, CountryId{"UA"}}, // Q12145268
    {Coordinate{28.7064, 50.1758}, CountryId{"UA"}}, // Q12145327
    {Coordinate{33.8497, 51.2025}, CountryId{"UA"}}, // Putyvl
    {Coordinate{33.6036, 51.2131}, CountryId{"UA"}}, // Q12145664
    {Coordinate{30.0568, 50.166}, CountryId{"UA"}}, // Q12145835
    {Coordinate{26.1408, 49.5292}, CountryId{"UA"}}, // Q12145919
    {Coordinate{30.8936, 48.1092}, CountryId{"UA"}}, // Q12145956
    {Coordinate{30.5542, 50.2668}, CountryId{"UA"}}, // Pidhirtsi
    {Coordinate{24.0339, 49.8511}, CountryId{"UA"}}, // Pidzamche
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12146117
    {Coordinate{29.6454, 50.6946}, CountryId{"UA"}}, // Pisky
    {Coordinate{31.6852, 48.8874}, CountryId{"UA"}}, // Q12146564
    {Coordinate{27.395, 50.3578}, CountryId{"UA"}}, // Radulyn
    {Coordinate{33.5147, 47.8194}, CountryId{"UA"}}, // Q12146659
    {Coordinate{37.6061, 49.2697}, CountryId{"UA"}}, // Q12146685
    {Coordinate{27.7149, 49.1777}, CountryId{"UA"}}, // Q12146727
    {Coordinate{27.9558, 50.0526}, CountryId{"UA"}}, // Razine
    {Coordinate{36.0937, 49.95}, CountryId{"UA"}}, // Raj-Olenivka
    {Coordinate{28.5122, 49.9452}, CountryId{"UA"}}, // Raiky
    {Coordinate{27.0594, 49.4025}, CountryId{"UA"}}, // Rakove
    {Coordinate{31.7181, 50.2397}, CountryId{"UA"}}, // Rankovyi
    {Coordinate{30.7743, 49.9434}, CountryId{"UA"}}, // Rasava
    {Coordinate{34.5163, 47.6204}, CountryId{"UA"}}, // Q12147209
    {Coordinate{33.4453, 46.755}, CountryId{"UA"}}, // Q12147742
    {Coordinate{34.1433, 49.6372}, CountryId{"UA"}}, // Reshetylivka
    {Coordinate{28.636, 50.0128}, CountryId{"UA"}}, // Q12147811
    {Coordinate{29.3031, 49.4928}, CountryId{"UA"}}, // Rzhevuska
    {Coordinate{36.1149, 49.9578}, CountryId{"UA"}}, // Ryzhiv
    {Coordinate{35.6712, 49.9235}, CountryId{"UA"}}, // Rogivka
    {Coordinate{32.603, 48.6977}, CountryId{"UA"}}, // 5 km
    {Coordinate{35.5542, 49.3799}, CountryId{"UA"}}, // Q12148412
    {Coordinate{30.5073, 49.6957}, CountryId{"UA"}}, // Rokytne
    {Coordinate{33.4786, 48.0439}, CountryId{"UA"}}, // Rokuvata
    {Coordinate{30.5884, 50.239}, CountryId{"UA"}}, // Romankiv
    {Coordinate{33.3236, 49.9914}, CountryId{"UA"}}, // Romodan
    {Coordinate{27.0469, 49.7722}, CountryId{"UA"}}, // Q12148838
    {Coordinate{30.1871, 49.7796}, CountryId{"UA"}}, // Rotok
    {Coordinate{28.9344, 48.2606}, CountryId{"UA"}}, // Rudnytsya
    {Coordinate{23.9233, 49.8364}, CountryId{"UA"}}, // Rudno
    {Coordinate{35.7655, 50.0725}, CountryId{"UA"}}, // Q12149799
    {Coordinate{29.5464, 49.9562}, CountryId{"UA"}}, // Savertsi
    {Coordinate{37.0372, 49.3932}, CountryId{"UA"}}, // Q12149977
    {Coordinate{27.22, 50.2203}, CountryId{"UA"}}, // Savychi
    {Coordinate{33.6267, 48.2947}, CountryId{"UA"}}, // Q12150023
    {Coordinate{35.4192, 49.9345}, CountryId{"UA"}}, // Sadky
    {Coordinate{33.5856, 48.0664}, CountryId{"UA"}}, // Q12150237
    {Coordinate{28.5343, 49.3857}, CountryId{"UA"}}, // Salnitsky
    {Coordinate{35.8722, 49.1494}, CountryId{"UA"}}, // Q12150831
    {Coordinate{33.9422, 51.9564}, CountryId{"UA"}}, // Svesa
    {Coordinate{37.5503, 49.0752}, CountryId{"UA"}}, // Sviatohirsk Railway Station
    {Coordinate{31.2863, 50.3511}, CountryId{"UA"}}, // Selychivka
    {Coordinate{28.3811, 49.114}, CountryId{"UA"}}, // Q12151810
    {Coordinate{32.5828, 52.2039}, CountryId{"UA"}}, // Q12151992
    {Coordinate{31.0614, 50.6603}, CountryId{"UA"}}, // Semypolky
    {Coordinate{38.7496, 48.669}, CountryId{"UA"}}, // Q12152121
    {Coordinate{33.4422, 50.1981}, CountryId{"UA"}}, // Sencha
    {Coordinate{28.8936, 49.7499}, CountryId{"UA"}}, // Sestrynivka
    {Coordinate{21.6281, 47.5206}, CountryId{"HU"}}, // Debrecen Railway Station
    {Coordinate{34.4869, 45.9681}, CountryId{"UA"}}, // Syvash
    {Coordinate{28.8156, 49.6697}, CountryId{"UA"}}, // Sygnal
    {Coordinate{35.5269, 48.3158}, CountryId{"UA"}}, // Synelnykove 1st
    {Coordinate{35.5106, 48.3339}, CountryId{"UA"}}, // Synelnykove 2nd
    {Coordinate{34.8642, 50.7975}, CountryId{"UA"}}, // Syrovatka
    {Coordinate{24.0739, 49.7897}, CountryId{"UA"}}, // Q12153069
    {Coordinate{30.1992, 50.5335}, CountryId{"UA"}}, // Sklozavodskya
    {Coordinate{23.9308, 49.8169}, CountryId{"UA"}}, // Q12153286
    {Coordinate{37.6961, 49.5631}, CountryId{"UA"}}, // Q12153350
    {Coordinate{29.3853, 50.1}, CountryId{"UA"}}, // Skochyshche
    {Coordinate{29.735, 50.0414}, CountryId{"UA"}}, // Skryhalivka
    {Coordinate{35.5111, 48.1244}, CountryId{"UA"}}, // Q12153542
    {Coordinate{26.8851, 50.3207}, CountryId{"UA"}}, // Slavuta 1
    {Coordinate{36.1543, 50.2095}, CountryId{"UA"}}, // Slatyne Railway Station
    {Coordinate{32.3893, 50.1264}, CountryId{"UA"}}, // Sloboda-Petrivka
    {Coordinate{29.3442, 47.8851}, CountryId{"UA"}}, // Slobidka
    {Coordinate{37.5903, 48.8467}, CountryId{"UA"}}, // Q12153721
    {Coordinate{37.5558, 48.8325}, CountryId{"UA"}}, // Sloviansk Railway Station
    {Coordinate{27.66, 50.5478}, CountryId{"UA"}}, // Q12153972
    {Coordinate{34.9685, 50.4819}, CountryId{"UA"}}, // Trostyanets-Smorodyne railway station
    {Coordinate{31.8763, 49.2415}, CountryId{"UA"}}, // Smila
    {Coordinate{32.7797, 47.0653}, CountryId{"UA"}}, // Q12154073
    {Coordinate{29.9789, 50.1094}, CountryId{"UA"}}, // Snitynka
    {Coordinate{35.8502, 49.9532}, CountryId{"UA"}}, // Ljubotin-Zahidny
    {Coordinate{36.1282, 49.6876}, CountryId{"UA"}}, // Q12154992
    {Coordinate{33.8361, 48.0978}, CountryId{"UA"}}, // Q12156907
    {Coordinate{29.6033, 50.0294}, CountryId{"UA"}}, // Stavyshche
    {Coordinate{28.5425, 49.2813}, CountryId{"UA"}}, // Stadnytsya
    {Coordinate{28.7911, 50.2031}, CountryId{"UA"}}, // Stanyshivka
    {Coordinate{31.9756, 46.9575}, CountryId{"UA"}}, // Mykolaiv-Vantazhnyi
    {Coordinate{38.9275, 49.2772}, CountryId{"UA"}}, // Q12157377
    {Coordinate{27.1672, 49.7506}, CountryId{"UA"}}, // Q12157413
    {Coordinate{26.9708, 49.9544}, CountryId{"UA"}}, // Stari Beizymy
    {Coordinate{38.5855, 48.5192}, CountryId{"UA"}}, // Q12157568
    {Coordinate{29.0994, 50.1383}, CountryId{"UA"}}, // Stepok
    {Coordinate{33.9228, 45.1594}, CountryId{"UA"}}, // Q12158034
    {Coordinate{28.8106, 50.912}, CountryId{"UA"}}, // Stremyhorod
    {Coordinate{28.1819, 50.4125}, CountryId{"UA"}}, // Q12158187
    {Coordinate{28.974, 50.3231}, CountryId{"UA"}}, // Q12158200
    {Coordinate{23.8417, 49.2594}, CountryId{"UA"}}, // Stryi Railway Station
    {Coordinate{28.6921, 50.3683}, CountryId{"UA"}}, // Strokovytsi
    {Coordinate{32.8996, 50.0475}, CountryId{"UA"}}, // Stronske
    {Coordinate{30.739, 50.1505}, CountryId{"UA"}}, // Stuhna
    {Coordinate{27.1322, 50.1803}, CountryId{"UA"}}, // Sudylkiv
    {Coordinate{33.4006, 50.3992}, CountryId{"UA"}}, // Sula
    {Coordinate{34.9083, 48.3319}, CountryId{"UA"}}, // Q12158819
    {Coordinate{30.3675, 49.7384}, CountryId{"UA"}}, // Sukholisy
    {Coordinate{35.2842, 47.4378}, CountryId{"UA"}}, // Q12159700
    {Coordinate{31.1292, 49.5702}, CountryId{"UA"}}, // Tahancha
    {Coordinate{30.3025, 50.3442}, CountryId{"UA"}}, // Tarasivka
    {Coordinate{28.1122, 49.0772}, CountryId{"UA"}}, // Tartak
    {Coordinate{30.6621, 50.1743}, CountryId{"UA"}}, // Tatsenky
    {Coordinate{25.6994, 49.3006}, CountryId{"UA"}}, // Terebovlia Railway Station
    {Coordinate{33.4814, 51.7642}, CountryId{"UA"}}, // Tereshenska
    {Coordinate{33.5344, 48.1786}, CountryId{"UA"}}, // Terny
    {Coordinate{36.3492, 49.8536}, CountryId{"UA"}}, // Q12160819
    {Coordinate{25.601, 49.5552}, CountryId{"UA"}}, // Ternopil Railway Station
    {Coordinate{29.5994, 50.6986}, CountryId{"UA"}}, // Teteriv
    {Coordinate{27.9478, 50.4733}, CountryId{"UA"}}, // Q12161011
    {Coordinate{29.0696, 50.8448}, CountryId{"UA"}}, // Tyshiv
    {Coordinate{28.667, 50.5375}, CountryId{"UA"}}, // Toporyshche
    {Coordinate{31.0762, 50.365}, CountryId{"UA"}}, // Travneva
    {Coordinate{31.3053, 47.7053}, CountryId{"UA"}}, // Trykratne train station
    {Coordinate{29.8322, 50.0098}, CountryId{"UA"}}, // Trylisy
    {Coordinate{30.7531, 50.1398}, CountryId{"UA"}}, // Tripillya-Dniprovske
    {Coordinate{37.5281, 49.1316}, CountryId{"UA"}}, // Q12162474
    {Coordinate{31.195, 50.7036}, CountryId{"UA"}}, // Trubizh
    {Coordinate{31.671, 48.8617}, CountryId{"UA"}}, // Q12163031
    {Coordinate{28.4885, 49.1506}, CountryId{"UA"}}, // Tjushki
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12163177
    {Coordinate{30.2042, 48.7331}, CountryId{"UA"}}, // Uman
    {Coordinate{29.8283, 50.0378}, CountryId{"UA"}}, // Unava
    {Coordinate{28.5891, 50.8626}, CountryId{"UA"}}, // Ushomyr
    {Coordinate{29.9431, 50.0529}, CountryId{"UA"}}, // Fastiv 2nd
    {Coordinate{35.9492, 50.141}, CountryId{"UA"}}, // Q12165665
    {Coordinate{28.4092, 45.4397}, CountryId{"UA"}}, // Frycatzey
    {Coordinate{32.9958, 51.2028}, CountryId{"UA"}}, // Khalymonove
    {Coordinate{36.1813, 50.0262}, CountryId{"UA"}}, // Q12166913
    {Coordinate{29.3407, 49.9515}, CountryId{"UA"}}, // Kharliivka
    {Coordinate{36.1412, 49.9573}, CountryId{"UA"}}, // Khvylynka
    {Coordinate{35.6918, 49.923}, CountryId{"UA"}}, // Khvorostove
    {Coordinate{27.9819, 50.4633}, CountryId{"UA"}}, // Q12167448
    {Coordinate{31.4931, 52.0297}, CountryId{"UA"}}, // Khorobychi
    {Coordinate{32.2681, 51.0851}, CountryId{"UA"}}, // Khoroshe Ozero
    {Coordinate{24.1747, 51.7039}, CountryId{"BY"}}, // Khatsislaw
    {Coordinate{27.2443, 50.1507}, CountryId{"UA"}}, // Khrolyn
    {Coordinate{29.8537, 50.637}, CountryId{"UA"}}, // Khutir Hai
    {Coordinate{26.9541, 50.2572}, CountryId{"UA"}}, // Tsvitokha
    {Coordinate{37.2696, 49.3083}, CountryId{"UA"}}, // Q12168763
    {Coordinate{36.2364, 48.1278}, CountryId{"UA"}}, // Q12169135
    {Coordinate{33.3033, 47.9403}, CountryId{"UA"}}, // Q12169607
    {Coordinate{31.7587, 50.9704}, CountryId{"UA"}}, // Volodkova Divytsia
    {Coordinate{32.6223, 51.1266}, CountryId{"UA"}}, // Cheremushky
    {Coordinate{28.6513, 49.5261}, CountryId{"UA"}}, // Cherepashyntsi
    {Coordinate{26.9233, 49.5172}, CountryId{"UA"}}, // Q12169734
    {Coordinate{29.6191, 49.9661}, CountryId{"UA"}}, // Chernyavka
    {Coordinate{31.2489, 51.5197}, CountryId{"UA"}}, // Chernihiv-Pivnichnyi
    {Coordinate{28.9393, 50.8739}, CountryId{"UA"}}, // Chepovychi
    {Coordinate{26.7429, 49.4955}, CountryId{"UA"}}, // Chornyi Ostriv
    {Coordinate{38.4906, 48.3294}, CountryId{"UA"}}, // Q12170600
    {Coordinate{27.0117, 50.0278}, CountryId{"UA"}}, // Q12170667
    {Coordinate{30.3544, 46.14}, CountryId{"UA"}}, // Shabo
    {Coordinate{28.7108, 50.9358}, CountryId{"UA"}}, // Shatrishche
    {Coordinate{27.0753, 50.1639}, CountryId{"UA"}}, // Q12171670
    {Coordinate{23.5549, 49.9701}, CountryId{"UA"}}, // Q12171997
    {Coordinate{30.3136, 50.2711}, CountryId{"UA"}}, // Shliakhova
    {Coordinate{33.4103, 47.9642}, CountryId{"UA"}}, // Shmakovo
    {Coordinate{33.4689, 51.8633}, CountryId{"UA"}}, // Q12172245
    {Coordinate{28.6463, 48.6631}, CountryId{"UA"}}, // Shura
    {Coordinate{33.3944, 48.5944}, CountryId{"UA"}}, // Shchaslyva
    {Coordinate{29.3482, 50.7484}, CountryId{"UA"}}, // Shebzavod
    {Coordinate{30.7565, 50.1239}, CountryId{"UA"}}, // Sherbanivka
    {Coordinate{31.9447, 51.8142}, CountryId{"UA"}}, // Snovsk
    {Coordinate{28.3294, 50.3728}, CountryId{"UA"}}, // Q12172951
    {Coordinate{33.3317, 50.4708}, CountryId{"UA"}}, // Q12173151
    {Coordinate{35.1639, 46.6805}, CountryId{"UA"}}, // Yakymivka
    {Coordinate{30.7573, 50.4787}, CountryId{"UA"}}, // Yalynka
    {Coordinate{33.7447, 51.9119}, CountryId{"UA"}}, // Yampil
    {Coordinate{35.3564, 47.9081}, CountryId{"UA"}}, // Q12173803
    {Coordinate{25.5511, 52.1289}, CountryId{"BY"}}, // Janaŭ-Palieski train station
    {Coordinate{28.4461, 49.1248}, CountryId{"UA"}}, // Yaryshivka
    {Coordinate{33.8103, 45.1644}, CountryId{"UA"}}, // Q12173902
    {Coordinate{29.2703, 50.1247}, CountryId{"UA"}}, // Yaropovychi
    {Coordinate{31.2286, 50.7124}, CountryId{"UA"}}, // Yaroslavka
    {Coordinate{28.268, 48.9023}, CountryId{"UA"}}, // Yaroshenka
    {Coordinate{-0.1733, 51.6487}, CountryId{"GB"}}, // New Barnet railway station
    {Coordinate{7.27095, 46.2086}, CountryId{"CH"}}, // Ardon railway station
    {Coordinate{6.55933, 46.6877}, CountryId{"CH"}}, // Bavois railway station
    {Coordinate{7.00067, 46.2515}, CountryId{"CH"}}, // Bex railway station
    {Coordinate{7.2411, 46.1888}, CountryId{"CH"}}, // Chamoson-St-Pierre-de-Clages railway station
    {Coordinate{6.56816, 46.7101}, CountryId{"CH"}}, // Chavornay railway station
    {Coordinate{7.3051, 46.2161}, CountryId{"CH"}}, // Châteauneuf-Conthey railway station
    {Coordinate{7.12648, 46.1268}, CountryId{"CH"}}, // Charrat-Fully railway station
    {Coordinate{6.94875, 46.2713}, CountryId{"CH"}}, // Collombey railway station
    {Coordinate{6.55242, 46.6572}, CountryId{"CH"}}, // Eclépens railway station
    {Coordinate{6.60766, 46.7464}, CountryId{"CH"}}, // Ependes railway station
    {Coordinate{6.58066, 46.7277}, CountryId{"CH"}}, // Essert-Pittet railway station
    {Coordinate{7.74758, 46.3065}, CountryId{"CH"}}, // Gampel-Steg railway station
    {Coordinate{8.86577, 46.179}, CountryId{"CH"}}, // Gordola railway station
    {Coordinate{6.85347, 46.3859}, CountryId{"CH"}}, // Bouveret railway station
    {Coordinate{6.87947, 46.3632}, CountryId{"CH"}}, // Les Evouettes railway station
    {Coordinate{6.98556, 46.2414}, CountryId{"CH"}}, // Massongex railway station
    {Coordinate{8.37411, 47.045}, CountryId{"CH"}}, // Meggen Zentrum railway station
    {Coordinate{8.40906, 47.0677}, CountryId{"CH"}}, // Merlischachen railway station
    {Coordinate{8.38306, 47.0501}, CountryId{"CH"}}, // Meggen railway station
    {Coordinate{6.95523, 46.2556}, CountryId{"CH"}}, // Monthey railway station
    {Coordinate{7.80151, 46.3063}, CountryId{"CH"}}, // Raron railway station
    {Coordinate{7.21785, 46.1725}, CountryId{"CH"}}, // Riddes railway station
    {Coordinate{8.8864, 46.1753}, CountryId{"CH"}}, // Riazzino railway station
    {Coordinate{6.80616, 46.3922}, CountryId{"CH"}}, // St-Gingolph railway station
    {Coordinate{7.57819, 46.3092}, CountryId{"CH"}}, // Salgesch railway station
    {Coordinate{7.41957, 46.2515}, CountryId{"CH"}}, // St-Léonard railway station
    {Coordinate{7.17344, 46.1494}, CountryId{"CH"}}, // Saxon railway station
    {Coordinate{8.94338, 47.2252}, CountryId{"CH"}}, // Schmerikon railway station
    {Coordinate{8.85022, 46.1775}, CountryId{"CH"}}, // Tenero railway station
    {Coordinate{7.6996, 46.3093}, CountryId{"CH"}}, // Turtmann railway station
    {Coordinate{8.98069, 47.2243}, CountryId{"CH"}}, // Uznach railway station
    {Coordinate{6.91625, 46.315}, CountryId{"CH"}}, // Vionnaz railway station
    {Coordinate{6.89806, 46.3369}, CountryId{"CH"}}, // Vouvry railway station
    {Coordinate{6.64115, 46.7819}, CountryId{"CH"}}, // Yverdon-les-Bains railway station
    {Coordinate{-0.1667, 51.6379}, CountryId{"GB"}}, // Oakleigh Park railway station
    {Coordinate{-3.11408, 43.2103}, CountryId{"ES"}}, // Q12253835
    {Coordinate{-3.05029, 43.202}, CountryId{"ES"}}, // Q12267477
    {Coordinate{-3.1981, 43.2332}, CountryId{"ES"}}, // Q12268164
    {Coordinate{-3.1333, 43.2129}, CountryId{"ES"}}, // Q12269192
    {Coordinate{-3.01605, 43.2333}, CountryId{"ES"}}, // Q12269216
    {Coordinate{25.682, 43.1398}, CountryId{"BG"}}, // Gorna Oryahovitsa Railway Station
    {Coordinate{27.4727, 42.491}, CountryId{"BG"}}, // Burgas Railway Station
    {Coordinate{10.4082, 57.5926}, CountryId{"DK"}}, // Aalbæk station
    {Coordinate{10.0522, 55.3831}, CountryId{"DK"}}, // Aarup Station
    {Coordinate{9.8456, 56.0526}, CountryId{"DK"}}, // Alken station
    {Coordinate{8.32977, 56.3907}, CountryId{"DK"}}, // Amstrup Station
    {Coordinate{9.86007, 56.7694}, CountryId{"DK"}}, // Arden station
    {Coordinate{8.26568, 56.5293}, CountryId{"DK"}}, // Armose Station
    {Coordinate{11.4994, 55.8086}, CountryId{"DK"}}, // Asnæs Station
    {Coordinate{10.1824, 56.0039}, CountryId{"DK"}}, // Assedrup Station
    {Coordinate{8.78818, 56.2652}, CountryId{"DK"}}, // Aulum Station
    {Coordinate{11.2153, 54.8289}, CountryId{"DK"}}, // Avnede Station
    {Coordinate{11.7022, 55.5458}, CountryId{"DK"}}, // Bagmarken Station
    {Coordinate{8.24167, 56.5476}, CountryId{"DK"}}, // Balleby Station
    {Coordinate{8.28306, 55.6358}, CountryId{"DK"}}, // Baunhøj Station
    {Coordinate{10.1981, 56.0569}, CountryId{"DK"}}, // Beder Station
    {Coordinate{8.40776, 56.8067}, CountryId{"DK"}}, // Bedsted Thy Station
    {Coordinate{8.33144, 55.6169}, CountryId{"DK"}}, // Billum railway station
    {Coordinate{9.02962, 56.1253}, CountryId{"DK"}}, // Birk Centerpark railway station
    {Coordinate{9.65855, 56.3742}, CountryId{"DK"}}, // Bjerringbro station
    {Coordinate{8.22296, 56.5208}, CountryId{"DK"}}, // Bonnet Station
    {Coordinate{9.27857, 56.1467}, CountryId{"DK"}}, // Bording railway station
    {Coordinate{8.64445, 55.9584}, CountryId{"DK"}}, // Borris Station
    {Coordinate{11.9722, 55.4944}, CountryId{"DK"}}, // Borup Station
    {Coordinate{8.46, 55.6238}, CountryId{"DK"}}, // Boulevarden Station
    {Coordinate{10.1056, 55.3733}, CountryId{"DK"}}, // Bred Station
    {Coordinate{12.5008, 55.7936}, CountryId{"DK"}}, // Brede Station
    {Coordinate{8.82309, 55.0568}, CountryId{"DK"}}, // Bredebro Station
    {Coordinate{9.65917, 55.6664}, CountryId{"DK"}}, // Brejning Station
    {Coordinate{12.279, 55.8934}, CountryId{"DK"}}, // Brødeskov Station
    {Coordinate{9.9423, 57.2704}, CountryId{"DK"}}, // Brønderslev station
    {Coordinate{8.7408, 55.1947}, CountryId{"DK"}}, // Brøns Station
    {Coordinate{9.01603, 55.4827}, CountryId{"DK"}}, // Brørup Station
    {Coordinate{8.42773, 56.3677}, CountryId{"DK"}}, // Bur railway station
    {Coordinate{8.30806, 56.412}, CountryId{"DK"}}, // Bækmarksbro Station
    {Coordinate{9.65207, 55.6422}, CountryId{"DK"}}, // Børkop Station
    {Coordinate{11.4996, 55.5339}, CountryId{"DK"}}, // Dianalund Station
    {Coordinate{12.3875, 56.0978}, CountryId{"DK"}}, // Dronningmølle station
    {Coordinate{12.2623, 56.0093}, CountryId{"DK"}}, // Duemose Station
    {Coordinate{8.29818, 55.7}, CountryId{"DK"}}, // Dyreby railway station
    {Coordinate{11.9423, 55.9852}, CountryId{"DK"}}, // Dyssekilde Station
    {Coordinate{8.80781, 55.1175}, CountryId{"DK"}}, // Døstrup Sønderjylland Station
    {Coordinate{10.1927, 56.0499}, CountryId{"DK"}}, // Egelund Trinbræt
    {Coordinate{12.19, 55.4236}, CountryId{"DK"}}, // Egøje Station
    {Coordinate{9.93, 55.4287}, CountryId{"DK"}}, // Ejby Station
    {Coordinate{9.9776, 57.5721}, CountryId{"DK"}}, // Emmersbæk halt
    {Coordinate{9.35172, 56.1678}, CountryId{"DK"}}, // Engesvang Station
    {Coordinate{11.8854, 54.8561}, CountryId{"DK"}}, // Eskilstrup Station
    {Coordinate{12.5497, 55.9958}, CountryId{"DK"}}, // Espergærde Station
    {Coordinate{12.162, 55.2171}, CountryId{"DK"}}, // Faxe Ladeplads Station
    {Coordinate{12.1368, 55.2423}, CountryId{"DK"}}, // Faxe Syd Station
    {Coordinate{12.07, 55.6222}, CountryId{"DK"}}, // Festivalpladsen T
    {Coordinate{12.3547, 56.0982}, CountryId{"DK"}}, // Firhøj station
    {Coordinate{12.2984, 56.1163}, CountryId{"DK"}}, // Fjellenstrup railway halt
    {Coordinate{12.4068, 55.9772}, CountryId{"DK"}}, // Fredensborg station
    {Coordinate{12.0195, 55.9686}, CountryId{"DK"}}, // Frederiksværk station
    {Coordinate{8.48667, 55.6278}, CountryId{"DK"}}, // Frisvadvej Station
    {Coordinate{10.3775, 55.3697}, CountryId{"DK"}}, // Fruens Bøge Station
    {Coordinate{12.4982, 55.7841}, CountryId{"DK"}}, // Fuglevad Station
    {Coordinate{8.26171, 56.4537}, CountryId{"DK"}}, // Fåre Station
    {Coordinate{11.4697, 55.7881}, CountryId{"DK"}}, // Fårevejle Station
    {Coordinate{12.0994, 55.5728}, CountryId{"DK"}}, // Gadstrup Station
    {Coordinate{9.97444, 55.3961}, CountryId{"DK"}}, // Gelsted railway station
    {Coordinate{12.3088, 56.1229}, CountryId{"DK"}}, // Gilleleje East halt
    {Coordinate{12.3025, 56.1234}, CountryId{"DK"}}, // Gilleleje station
    {Coordinate{11.5469, 55.7297}, CountryId{"DK"}}, // Gislinge Station
    {Coordinate{8.45729, 55.5096}, CountryId{"DK"}}, // Gjesing railway station
    {Coordinate{11.6956, 55.3536}, CountryId{"DK"}}, // Glumsø Station
    {Coordinate{12.0972, 56.0599}, CountryId{"DK"}}, // Godhavn Station
    {Coordinate{8.74116, 55.3974}, CountryId{"DK"}}, // Gredstedbro Station
    {Coordinate{12.3018, 55.9874}, CountryId{"DK"}}, // Gribsø Station
    {Coordinate{12.1025, 55.9156}, CountryId{"DK"}}, // Grimstrup Halt
    {Coordinate{12.2006, 55.3803}, CountryId{"DK"}}, // Grubberholm Station
    {Coordinate{9.5939, 54.9189}, CountryId{"DK"}}, // Gråsten Station
    {Coordinate{11.7651, 54.7741}, CountryId{"DK"}}, // Grænge Station
    {Coordinate{12.2868, 56.0726}, CountryId{"DK"}}, // Græsted station
    {Coordinate{12.2956, 56.0631}, CountryId{"DK"}}, // Græsted South railway halt
    {Coordinate{12.3703, 55.9526}, CountryId{"DK"}}, // Grønholt railway halt
    {Coordinate{12.6112, 56.0404}, CountryId{"DK"}}, // Grønnehave station
    {Coordinate{8.44036, 55.5361}, CountryId{"DK"}}, // Guldager train station
    {Coordinate{10.126, 56.1116}, CountryId{"DK"}}, // Gunnar Clausens Vej Station
    {Coordinate{10.1542, 56.0895}, CountryId{"DK"}}, // Q12314651
    {Coordinate{8.61167, 55.7656}, CountryId{"DK"}}, // Gårde railway station
    {Coordinate{8.80117, 55.4696}, CountryId{"DK"}}, // Gørding Station
    {Coordinate{12.2025, 55.8867}, CountryId{"DK"}}, // Gørløse Station
    {Coordinate{10.0478, 56.3272}, CountryId{"DK"}}, // Hadsten Station
    {Coordinate{9.06325, 56.1318}, CountryId{"DK"}}, // Hammerum station
    {Coordinate{12.0009, 55.9753}, CountryId{"DK"}}, // Hanehoved Station
    {Coordinate{8.17883, 56.6205}, CountryId{"DK"}}, // Harboøre Station
    {Coordinate{11.9609, 55.3294}, CountryId{"DK"}}, // Haslev Station
    {Coordinate{12.1169, 55.5436}, CountryId{"DK"}}, // Havdrup Station
    {Coordinate{12.1975, 55.6486}, CountryId{"DK"}}, // Hedehusene Station
    {Coordinate{9.69888, 55.7685}, CountryId{"DK"}}, // Hedensted Station
    {Coordinate{8.2868, 56.144}, CountryId{"DK"}}, // Hee railway station
    {Coordinate{12.5543, 56.0665}, CountryId{"DK"}}, // Hellebæk halt
    {Coordinate{12.2056, 56.0231}, CountryId{"DK"}}, // Helsinge Station
    {Coordinate{8.30441, 55.7104}, CountryId{"DK"}}, // Henne railway station
    {Coordinate{12.1372, 55.4177}, CountryId{"DK"}}, // Herfølge Station
    {Coordinate{8.94435, 56.1236}, CountryId{"DK"}}, // Herning Messecenter railway station
    {Coordinate{9.96587, 57.4732}, CountryId{"DK"}}, // Herregårdsparken halt
    {Coordinate{12.2158, 55.3725}, CountryId{"DK"}}, // Himlingøje Station
    {Coordinate{10.0596, 56.2631}, CountryId{"DK"}}, // Hinnerup Station
    {Coordinate{10.3927, 55.3582}, CountryId{"DK"}}, // Hjallese Station
    {Coordinate{8.63979, 56.439}, CountryId{"DK"}}, // Hjerm station
    {Coordinate{10.2688, 56.2447}, CountryId{"DK"}}, // Hjortshøj station
    {Coordinate{12.1178, 56.0595}, CountryId{"DK"}}, // Holløse Station
    {Coordinate{11.8489, 55.261}, CountryId{"DK"}}, // Holme-Olstrup Station
    {Coordinate{8.91413, 55.4848}, CountryId{"DK"}}, // Holsted Station
    {Coordinate{12.4595, 56.0893}, CountryId{"DK"}}, // Hornbæk station
    {Coordinate{9.97255, 57.5594}, CountryId{"DK"}}, // Horne station
    {Coordinate{12.4356, 56.0899}, CountryId{"DK"}}, // Horneby Sand halt
    {Coordinate{10.3136, 56.3206}, CountryId{"DK"}}, // Hornslet Station
    {Coordinate{10.2556, 56.2342}, CountryId{"DK"}}, // Hovmarken railway halt
    {Coordinate{12.5331, 55.9639}, CountryId{"DK"}}, // Humlebæk station
    {Coordinate{8.55237, 56.5403}, CountryId{"DK"}}, // Humlum station
    {Coordinate{11.8461, 55.9658}, CountryId{"DK"}}, // Hundested Havn Station
    {Coordinate{8.41804, 56.7512}, CountryId{"DK"}}, // Hurup Thy station
    {Coordinate{11.8591, 55.5953}, CountryId{"DK"}}, // Hvalsø Station
    {Coordinate{8.52653, 56.6498}, CountryId{"DK"}}, // Hvidbjerg station
    {Coordinate{8.73018, 55.2745}, CountryId{"DK"}}, // Hviding Station
    {Coordinate{8.40069, 55.6263}, CountryId{"DK"}}, // Hyllerslev Station
    {Coordinate{12.2275, 55.3514}, CountryId{"DK"}}, // Hårlev Station
    {Coordinate{13.5415, 55.9369}, CountryId{"SE"}}, // Höör Station
    {Coordinate{11.6037, 55.9106}, CountryId{"DK"}}, // Højby Sjælland Station
    {Coordinate{10.4342, 55.3298}, CountryId{"DK"}}, // Højby (Fyn) railway station
    {Coordinate{9.11076, 56.5491}, CountryId{"DK"}}, // Højslev station
    {Coordinate{12.594, 56.0472}, CountryId{"DK"}}, // Højstrup halt
    {Coordinate{8.49052, 56.8508}, CountryId{"DK"}}, // Hørdum station
    {Coordinate{10.0378, 56.0822}, CountryId{"DK"}}, // Hørning station
    {Coordinate{11.4562, 55.7526}, CountryId{"DK"}}, // Hørve Station
    {Coordinate{9.15528, 56.1448}, CountryId{"DK"}}, // Ikast railway station
    {Coordinate{8.37417, 55.6228}, CountryId{"DK"}}, // Janderup railway station
    {Coordinate{8.30167, 55.6647}, CountryId{"DK"}}, // Jegum Station
    {Coordinate{9.4199, 55.754}, CountryId{"DK"}}, // Jelling railway station
    {Coordinate{10.4171, 57.5323}, CountryId{"DK"}}, // Jerup station
    {Coordinate{11.398, 55.6603}, CountryId{"DK"}}, // Jyderup Station
    {Coordinate{12.2861, 55.9975}, CountryId{"DK"}}, // Kagerup station
    {Coordinate{12.4686, 56.0831}, CountryId{"DK"}}, // Karinebæk halt
    {Coordinate{12.1958, 55.307}, CountryId{"DK"}}, // Karise Station
    {Coordinate{15.5852, 56.1668}, CountryId{"SE"}}, // Karlskrona centralstation
    {Coordinate{9.81111, 55.4758}, CountryId{"DK"}}, // Kauslunde Station
    {Coordinate{8.85212, 56.0323}, CountryId{"DK"}}, // Kibæk Station
    {Coordinate{12.286, 55.752}, CountryId{"DK"}}, // Kildedal station
    {Coordinate{12.4242, 56.0925}, CountryId{"DK"}}, // Kildekrog halt
    {Coordinate{8.22028, 56.565}, CountryId{"DK"}}, // Klinkby Station
    {Coordinate{9.39778, 54.9351}, CountryId{"DK"}}, // Kliplev Station
    {Coordinate{12.3253, 55.3464}, CountryId{"DK"}}, // Klippinge Station
    {Coordinate{11.5535, 55.6649}, CountryId{"DK"}}, // Knabstrup Station
    {Coordinate{12.5022, 55.9036}, CountryId{"DK"}}, // Kokkedal station
    {Coordinate{10.5876, 56.3629}, CountryId{"DK"}}, // Kolind station
    {Coordinate{10.1742, 56.1353}, CountryId{"DK"}}, // Kongsvang railway halt
    {Coordinate{11.7648, 55.5738}, CountryId{"DK"}}, // Kr. Eskilstrup Station
    {Coordinate{12.3933, 55.9678}, CountryId{"DK"}}, // Kratbjerg railway halt
    {Coordinate{12.047, 55.9348}, CountryId{"DK"}}, // Kregme Station
    {Coordinate{10.4128, 57.4719}, CountryId{"DK"}}, // Kvissel station
    {Coordinate{12.5029, 55.9906}, CountryId{"DK"}}, // Kvistgård station
    {Coordinate{9.97602, 57.4546}, CountryId{"DK"}}, // Kvægtorvet halt
    {Coordinate{10.5189, 55.1781}, CountryId{"DK"}}, // Kværndrup Station
    {Coordinate{12.1726, 55.4996}, CountryId{"DK"}}, // Køge Nord Station
    {Coordinate{12.999, 56.5022}, CountryId{"SE"}}, // Q12323579
    {Coordinate{12.4511, 55.9812}, CountryId{"DK"}}, // Langerød railway halt
    {Coordinate{10.5867, 55.3617}, CountryId{"DK"}}, // Langeskov Station
    {Coordinate{9.71761, 56.1247}, CountryId{"DK"}}, // Laven station
    {Coordinate{11.9714, 55.6046}, CountryId{"DK"}}, // Lejre Station
    {Coordinate{8.3859, 56.025}, CountryId{"DK"}}, // Lem railway station
    {Coordinate{8.29972, 56.5469}, CountryId{"DK"}}, // Lemvig Station
    {Coordinate{12.1403, 55.5114}, CountryId{"DK"}}, // Lille Skensved Station
    {Coordinate{9.97633, 57.5852}, CountryId{"DK"}}, // Lilleheden halt
    {Coordinate{9.90528, 57.0667}, CountryId{"DK"}}, // Lindholm station
    {Coordinate{12.0342, 55.9467}, CountryId{"DK"}}, // Kregme Halt
    {Coordinate{12.2189, 55.3361}, CountryId{"DK"}}, // Lille Linde Station
    {Coordinate{11.8698, 55.1104}, CountryId{"DK"}}, // Lundby Station
    {Coordinate{8.36401, 55.7562}, CountryId{"DK"}}, // Lunde railway station
    {Coordinate{12.5061, 55.7739}, CountryId{"DK"}}, // Lyngby Local Station
    {Coordinate{8.45073, 56.6644}, CountryId{"DK"}}, // Lyngs station
    {Coordinate{10.2347, 56.2309}, CountryId{"DK"}}, // Lystrup Station
    {Coordinate{8.35292, 55.7294}, CountryId{"DK"}}, // Løftgård railway station
    {Coordinate{10.3173, 56.2758}, CountryId{"DK"}}, // Løgten station
    {Coordinate{10.1913, 56.0376}, CountryId{"DK"}}, // Malling Station
    {Coordinate{12.6023, 56.0433}, CountryId{"DK"}}, // Marienlyst halt
    {Coordinate{11.9717, 55.9916}, CountryId{"DK"}}, // Melby Station
    {Coordinate{12.3175, 55.7475}, CountryId{"DK"}}, // Måløv station
    {Coordinate{10.1646, 56.0687}, CountryId{"DK"}}, // Mårslet Station
    {Coordinate{12.317, 56.0307}, CountryId{"DK"}}, // Mårum station
    {Coordinate{10.1543, 56.0727}, CountryId{"DK"}}, // Mølleparken Station
    {Coordinate{12.5319, 56.002}, CountryId{"DK"}}, // Mørdrup railway halt
    {Coordinate{10.3758, 56.3393}, CountryId{"DK"}}, // Mørke station
    {Coordinate{11.5021, 55.6545}, CountryId{"DK"}}, // Mørkøv Station
    {Coordinate{8.18694, 56.5656}, CountryId{"DK"}}, // Nejrup Station
    {Coordinate{12.5064, 55.9336}, CountryId{"DK"}}, // Nivå Station
    {Coordinate{11.6067, 55.8831}, CountryId{"DK"}}, // Nr. Asmindrup Station
    {Coordinate{11.5944, 55.7287}, CountryId{"DK"}}, // Ny Hagested Station
    {Coordinate{11.6556, 55.9219}, CountryId{"DK"}}, // Nyled Station
    {Coordinate{11.6525, 55.5423}, CountryId{"DK"}}, // Nyrup Station
    {Coordinate{12.5282, 55.8139}, CountryId{"DK"}}, // Nærum Station
    {Coordinate{11.7863, 55.2482}, CountryId{"DK"}}, // Næstved Nord Station
    {Coordinate{12.5126, 55.7708}, CountryId{"DK"}}, // Nørgaardsvej Station
    {Coordinate{11.8855, 54.8965}, CountryId{"DK"}}, // Nørre Alslev Station
    {Coordinate{9.87111, 55.46}, CountryId{"DK"}}, // Nørre Åby Station
    {Coordinate{10.1516, 56.092}, CountryId{"DK"}}, // Nørrevænget Station
    {Coordinate{8.54696, 56.5826}, CountryId{"DK"}}, // Oddesund North station
    {Coordinate{8.28368, 55.6259}, CountryId{"DK"}}, // Oksbøl railway station
    {Coordinate{13.9955, 56.381}, CountryId{"SE"}}, // Osby Station
    {Coordinate{8.3445, 55.7172}, CountryId{"DK"}}, // Outrup railway station
    {Coordinate{10.1518, 55.9784}, CountryId{"DK"}}, // Q12331004
    {Coordinate{10.486, 55.2833}, CountryId{"DK"}}, // Pederstrup Station
    {Coordinate{12.3014, 56.1008}, CountryId{"DK"}}, // Pårup railway halt
    {Coordinate{8.21028, 56.4889}, CountryId{"DK"}}, // Ramme Station
    {Coordinate{12.52, 55.8022}, CountryId{"DK"}}, // Ravnholm Station
    {Coordinate{11.6126, 55.6775}, CountryId{"DK"}}, // Regstrup Station
    {Coordinate{8.732, 55.2305}, CountryId{"DK"}}, // Rejsby Station
    {Coordinate{8.77587, 55.3397}, CountryId{"DK"}}, // Ribe Nørremark Station
    {Coordinate{10.4451, 57.5049}, CountryId{"DK"}}, // Rimmen halt
    {Coordinate{10.1472, 56.1169}, CountryId{"DK"}}, // Rosenhøj Station
    {Coordinate{10.1541, 55.9833}, CountryId{"DK"}}, // Rude Havvej railway station
    {Coordinate{10.4872, 55.1986}, CountryId{"DK"}}, // Rudme Station
    {Coordinate{11.3752, 55.5399}, CountryId{"DK"}}, // Ruds Vedby Station
    {Coordinate{9.75889, 56.0908}, CountryId{"DK"}}, // Ry station
    {Coordinate{11.3721, 54.7851}, CountryId{"DK"}}, // Ryde Station
    {Coordinate{12.3788, 55.2548}, CountryId{"DK"}}, // Rødvig Station
    {Coordinate{8.19468, 56.6566}, CountryId{"DK"}}, // Rønland Station
    {Coordinate{11.6353, 54.7965}, CountryId{"DK"}}, // Sakskøbing Station
    {Coordinate{12.3219, 56.0545}, CountryId{"DK"}}, // Saltrup railway halt
    {Coordinate{12.4849, 56.0769}, CountryId{"DK"}}, // Saunte station
    {Coordinate{8.7336, 55.435}, CountryId{"DK"}}, // Sejstrup Station
    {Coordinate{8.57717, 55.6656}, CountryId{"DK"}}, // Sig railway station
    {Coordinate{10.202, 57.4702}, CountryId{"DK"}}, // Sindal station
    {Coordinate{8.28389, 56.4378}, CountryId{"DK"}}, // Sinkbæk Station
    {Coordinate{8.58804, 56.9519}, CountryId{"DK"}}, // Sjørring station
    {Coordinate{10.1411, 55.3661}, CountryId{"DK"}}, // Skalbjerg Station
    {Coordinate{11.449, 55.5379}, CountryId{"DK"}}, // Skellebjerg Station
    {Coordinate{12.5131, 56.0783}, CountryId{"DK"}}, // Skibstrup halt
    {Coordinate{12.5717, 55.8236}, CountryId{"DK"}}, // Skodsborg Station
    {Coordinate{10.2131, 56.1571}, CountryId{"DK"}}, // Skolebakken Station
    {Coordinate{8.77167, 55.1586}, CountryId{"DK"}}, // Skærbæk Station
    {Coordinate{12.1497, 55.9074}, CountryId{"DK"}}, // Skævinge Station
    {Coordinate{10.3031, 56.2618}, CountryId{"DK"}}, // Skødstrup Station
    {Coordinate{9.88722, 56.8358}, CountryId{"DK"}}, // Skørping station
    {Coordinate{12.311, 55.9426}, CountryId{"DK"}}, // Slotspavillonen Station
    {Coordinate{8.52715, 56.8921}, CountryId{"DK"}}, // Snedsted station
    {Coordinate{11.6035, 55.8975}, CountryId{"DK"}}, // Sommerland Sjælland Station
    {Coordinate{8.46083, 55.4925}, CountryId{"DK"}}, // Spangsbjerg railway station
    {Coordinate{11.7113, 55.5449}, CountryId{"DK"}}, // St. Merløse Station
    {Coordinate{11.5913, 55.5391}, CountryId{"DK"}}, // Stenlille Station
    {Coordinate{10.5094, 55.1311}, CountryId{"DK"}}, // Stenstrup Station
    {Coordinate{10.5151, 55.1203}, CountryId{"DK"}}, // Stenstrup Syd Station
    {Coordinate{9.15016, 56.4874}, CountryId{"DK"}}, // Stoholm station
    {Coordinate{12.386, 55.3098}, CountryId{"DK"}}, // Store Heddinge Station
    {Coordinate{8.16056, 56.569}, CountryId{"DK"}}, // Strande Station
    {Coordinate{8.91058, 56.0917}, CountryId{"DK"}}, // Studsgård railway station
    {Coordinate{12.3189, 56.1119}, CountryId{"DK"}}, // Stæremosen halt
    {Coordinate{9.84389, 56.8919}, CountryId{"DK"}}, // Støvring station
    {Coordinate{11.2917, 55.6523}, CountryId{"DK"}}, // Svebølle Station
    {Coordinate{9.63667, 56.1328}, CountryId{"DK"}}, // Svejbæk Station
    {Coordinate{10.5819, 55.0558}, CountryId{"DK"}}, // Svendborg Vest Station
    {Coordinate{11.4675, 55.7234}, CountryId{"DK"}}, // Svinninge Station
    {Coordinate{12.3339, 56.1005}, CountryId{"DK"}}, // Søborg halt
    {Coordinate{11.2702, 54.811}, CountryId{"DK"}}, // Søllested Station
    {Coordinate{9.95113, 57.5252}, CountryId{"DK"}}, // Sønderby halt
    {Coordinate{8.52028, 55.9103}, CountryId{"DK"}}, // Tarm railway station
    {Coordinate{9.96302, 57.4601}, CountryId{"DK"}}, // Teglgårdsvej halt
    {Coordinate{8.20694, 56.6981}, CountryId{"DK"}}, // Thyborøn Kirke Station
    {Coordinate{12.0778, 56.0593}, CountryId{"DK"}}, // Tisvildeleje station
    {Coordinate{8.5981, 55.7167}, CountryId{"DK"}}, // Tistrup railway station
    {Coordinate{12.1429, 55.2833}, CountryId{"DK"}}, // Tokkerup Station
    {Coordinate{10.2283, 56.2057}, CountryId{"DK"}}, // Torsøvej Station
    {Coordinate{10.1357, 56.0967}, CountryId{"DK"}}, // Tranbjerg Station
    {Coordinate{12.1319, 55.6478}, CountryId{"DK"}}, // Trekroner Station
    {Coordinate{12.0759, 55.3732}, CountryId{"DK"}}, // Tureby Station
    {Coordinate{8.8605, 54.9333}, CountryId{"DK"}}, // Tønder station
    {Coordinate{9.79271, 56.3954}, CountryId{"DK"}}, // Ulstrup station
    {Coordinate{8.47222, 55.6121}, CountryId{"DK"}}, // Varde Kaserne station
    {Coordinate{8.47639, 55.6246}, CountryId{"DK"}}, // Varde Vest station
    {Coordinate{8.50056, 55.6314}, CountryId{"DK"}}, // Varde Nord station
    {Coordinate{12.2801, 55.3524}, CountryId{"DK"}}, // Varpelev Station
    {Coordinate{9.53703, 55.7149}, CountryId{"DK"}}, // Vejle Sygehus railway station
    {Coordinate{10.2374, 56.1942}, CountryId{"DK"}}, // Vestre Strandallé railway halt
    {Coordinate{11.8731, 55.9603}, CountryId{"DK"}}, // Vibehus Halt
    {Coordinate{12.5638, 55.7063}, CountryId{"DK"}}, // Vibenshus Runddel station
    {Coordinate{9.9476, 57.5019}, CountryId{"DK"}}, // Vidstrup station
    {Coordinate{11.5822, 55.8526}, CountryId{"DK"}}, // Vig Station
    {Coordinate{8.76859, 56.198}, CountryId{"DK"}}, // Vildbjerg Railway Station
    {Coordinate{10.1791, 56.064}, CountryId{"DK"}}, // Vilhelmsborg Station
    {Coordinate{11.7385, 55.6669}, CountryId{"DK"}}, // Vipperød Station
    {Coordinate{8.39871, 56.7143}, CountryId{"DK"}}, // Ydby station
    {Coordinate{10.4658, 55.3014}, CountryId{"DK"}}, // Årslev railway station
    {Coordinate{11.8361, 54.7597}, CountryId{"DK"}}, // Ø. Toreby Station
    {Coordinate{8.62274, 55.811}, CountryId{"DK"}}, // Ølgod railway station
    {Coordinate{10.1331, 56.1144}, CountryId{"DK"}}, // Øllegårdsvej Station
    {Coordinate{12.0731, 55.923}, CountryId{"DK"}}, // Ølsted train station
    {Coordinate{12.1626, 56.0557}, CountryId{"DK"}}, // Ørby Station
    {Coordinate{12.51, 55.7998}, CountryId{"DK"}}, // Ørholm Station
    {Coordinate{10.2163, 56.1628}, CountryId{"DK"}}, // Østbanetorvet Station
    {Coordinate{11.9139, 55.9769}, CountryId{"DK"}}, // Østerbjerg Station
    {Coordinate{12.4693, 55.699}, CountryId{"DK"}}, // Islev station
    {Coordinate{8.21456, 56.704}, CountryId{"DK"}}, // Thyborøn Station
    {Coordinate{10.3135, 57.4858}, CountryId{"DK"}}, // Tolne station
    {Coordinate{9.94947, 57.5327}, CountryId{"DK"}}, // Tornby station
    {Coordinate{8.86111, 54.9389}, CountryId{"DK"}}, // Tønder Nord Station
    {Coordinate{8.54153, 56.6123}, CountryId{"DK"}}, // Uglev station
    {Coordinate{8.32515, 56.2718}, CountryId{"DK"}}, // Ulfborg railway station
    {Coordinate{12.1922, 55.4003}, CountryId{"DK"}}, // Vallø Station
    {Coordinate{12.136, 56.0627}, CountryId{"DK"}}, // Vejby Station
    {Coordinate{12.0244, 55.5495}, CountryId{"DK"}}, // Viby Sjælland Station
    {Coordinate{8.14328, 56.5773}, CountryId{"DK"}}, // Victoria Street Station
    {Coordinate{8.78315, 56.4828}, CountryId{"DK"}}, // Vinderup station
    {Coordinate{8.14847, 56.6015}, CountryId{"DK"}}, // Vrist Station
    {Coordinate{9.9421, 57.3546}, CountryId{"DK"}}, // Vrå station
    {Coordinate{14.1368, 56.5509}, CountryId{"SE"}}, // Älmhult railway station
    {Coordinate{26.4223, 58.2248}, CountryId{"EE"}}, // Elva railway station
    {Coordinate{26.3999, 58.7476}, CountryId{"EE"}}, // Jõgeva railway station
    {Coordinate{24.6856, 59.2383}, CountryId{"EE"}}, // Kiisa railway station
    {Coordinate{24.9987, 58.7938}, CountryId{"EE"}}, // Q12367397
    {Coordinate{25.0082, 58.8671}, CountryId{"EE"}}, // Lelle railway station
    {Coordinate{24.7231, 59.3875}, CountryId{"EE"}}, // Liiva railway station
    {Coordinate{24.7872, 59.1153}, CountryId{"EE"}}, // Q12368930
    {Coordinate{25.5416, 58.6656}, CountryId{"EE"}}, // Q12371442
    {Coordinate{27.0913, 58.07}, CountryId{"EE"}}, // Põlva railway station
    {Coordinate{24.6765, 59.3009}, CountryId{"EE"}}, // Saku railway station
    {Coordinate{25.5371, 58.4875}, CountryId{"EE"}}, // Q12375980
    {Coordinate{24.7459, 59.4127}, CountryId{"EE"}}, // Tallinn-Väike
    {Coordinate{25.4242, 58.8047}, CountryId{"EE"}}, // Türi railway station
    {Coordinate{24.7135, 59.2009}, CountryId{"EE"}}, // Q12378648
    {Coordinate{25.5617, 58.6294}, CountryId{"EE"}}, // Võhma railway station
    {Coordinate{74.6375, 26.4566}, CountryId{"IN"}}, // Ajmer Junction railway station
    {Coordinate{80.8415, 26.7744}, CountryId{"IN"}}, // Amausi railway station
    {Coordinate{76.8287, 30.3382}, CountryId{"IN"}}, // Ambala Cantonment railway station
    {Coordinate{76.3225, 9.48376}, CountryId{"IN"}}, // Alappuzha railway station
    {Coordinate{83.1606, 26.0386}, CountryId{"IN"}}, // Azamgarh railway station
    {Coordinate{78.536, 19.6805}, CountryId{"IN"}}, // Adilabad railway station
    {Coordinate{81.8288, 25.4462}, CountryId{"IN"}}, // Allahabad Junction railway station
    {Coordinate{85.2173, 25.1386}, CountryId{"IN"}}, // Islampur railway station
    {Coordinate{73.6996, 24.5669}, CountryId{"IN"}}, // Udaipur City railway station
    {Coordinate{75.1549, 32.9266}, CountryId{"IN"}}, // Udhampur railway station
    {Coordinate{76.2757, 31.4788}, CountryId{"IN"}}, // Una Himachal railway station
    {Coordinate{78.2875, 30.1072}, CountryId{"IN"}}, // Rishikesh railway station
    {Coordinate{69.0738, 22.471}, CountryId{"IN"}}, // Okha railway station
    {Coordinate{77.5425, 8.08803}, CountryId{"IN"}}, // Kanyakumari railway station
    {Coordinate{82.2329, 16.967}, CountryId{"IN"}}, // Kakinada Town railway station
    {Coordinate{82.2401, 16.9552}, CountryId{"IN"}}, // Kakinada Port railway station
    {Coordinate{91.6907, 26.1571}, CountryId{"IN"}}, // Kamakhya Junction railway station
    {Coordinate{76.9318, 30.8377}, CountryId{"IN"}}, // Kalka railway station
    {Coordinate{88.3304, 25.6393}, CountryId{"IN"}}, // Kaliyaganj railway station
    {Coordinate{78.646, 27.8019}, CountryId{"IN"}}, // Kasganj Junction railway station
    {Coordinate{77.1451, 28.6469}, CountryId{"IN"}}, // Kirti Nagar railway station
    {Coordinate{79.3886, 10.953}, CountryId{"IN"}}, // Kumbakonam railway station
    {Coordinate{78.0327, 15.8337}, CountryId{"IN"}}, // Kurnool railway station
    {Coordinate{78.5212, 29.7429}, CountryId{"IN"}}, // Kotdwara railway station
    {Coordinate{82.713, 22.3376}, CountryId{"IN"}}, // Korba railway station
    {Coordinate{82.7194, 18.7922}, CountryId{"IN"}}, // Koraput railway station
    {Coordinate{76.5968, 8.88659}, CountryId{"IN"}}, // Kollam Junction railway station
    {Coordinate{79.89, 24.797}, CountryId{"IN"}}, // Khajuraho railway station
    {Coordinate{75.6425, 15.437}, CountryId{"IN"}}, // Gadag Junction railway station
    {Coordinate{77.4311, 28.6497}, CountryId{"IN"}}, // Ghaziabad railway station
    {Coordinate{83.3819, 26.76}, CountryId{"IN"}}, // Gorakhpur Junction railway station
    {Coordinate{16.3279, 48.1651}, CountryId{"AT"}}, // Tscherttegasse
    {Coordinate{48.8942, 55.8161}, CountryId{"RU"}}, // Yudino railway station
    {Coordinate{83.1544, 20.2844}, CountryId{"IN"}}, // Titlagarh railway station
    {Coordinate{83.6021, 25.5717}, CountryId{"IN"}}, // Tarighat railway station
    {Coordinate{77.708, 8.73636}, CountryId{"IN"}}, // Tirunelveli Junction railway station
    {Coordinate{77.238, 28.6276}, CountryId{"IN"}}, // Tilak Bridge railway station
    {Coordinate{95.3341, 27.4797}, CountryId{"IN"}}, // New Tinsukia railway station
    {Coordinate{77.1714, 28.6673}, CountryId{"IN"}}, // Daya basti railway station
    {Coordinate{81.88, 25.4426}, CountryId{"IN"}}, // Daraganj railway station
    {Coordinate{77.1436, 28.6283}, CountryId{"IN"}}, // Indrapuri railway station
    {Coordinate{77.2013, 28.6647}, CountryId{"IN"}}, // Delhi Kishanganj railway station
    {Coordinate{77.438, 28.6744}, CountryId{"IN"}}, // Naya Ghaziabad railway station
    {Coordinate{81.86, 25.3931}, CountryId{"IN"}}, // Naini railway station
    {Coordinate{77.1563, 28.66}, CountryId{"IN"}}, // Patel Nagar railway station
    {Coordinate{77.0929, 28.5857}, CountryId{"IN"}}, // Palam railway station
    {Coordinate{81.7416, 25.4449}, CountryId{"IN"}}, // Bamhrauli railway station
    {Coordinate{80.9614, 26.8686}, CountryId{"IN"}}, // Badshahnagar railway station
    {Coordinate{86.9768, 25.2419}, CountryId{"IN"}}, // Bhagalpur Junction railway station
    {Coordinate{73.9707, 15.2679}, CountryId{"IN"}}, // Madgaon Junction railway station
    {Coordinate{72.8386, 18.9524}, CountryId{"IN"}}, // Masjid railway station
    {Coordinate{77.6751, 28.9776}, CountryId{"IN"}}, // Meerut City railway station
    {Coordinate{77.5717, 28.8279}, CountryId{"IN"}}, // Modinagar railway station
    {Coordinate{81.2506, 24.5371}, CountryId{"IN"}}, // Rewa Terminal railway station
    {Coordinate{80.9179, 26.8591}, CountryId{"IN"}}, // Lucknow City railway station
    {Coordinate{77.2441, 28.5793}, CountryId{"IN"}}, // Lajpat Nagar railway station
    {Coordinate{77.2165, 28.5795}, CountryId{"IN"}}, // Lodhi Colony railway station
    {Coordinate{77.1837, 28.6641}, CountryId{"IN"}}, // Vivekanand Puri Halt railway station
    {Coordinate{70.3707, 20.9134}, CountryId{"IN"}}, // Veraval Junction railway station
    {Coordinate{77.2266, 28.6341}, CountryId{"IN"}}, // Shivaji Bridge railway station
    {Coordinate{73.8714, 29.9318}, CountryId{"IN"}}, // Sri Ganganagar railway station
    {Coordinate{77.1671, 28.5958}, CountryId{"IN"}}, // Sardar Patel Road railway station
    {Coordinate{86.595, 25.8752}, CountryId{"IN"}}, // Saharsa Junction railway station
    {Coordinate{77.5417, 29.9605}, CountryId{"IN"}}, // Saharanpur Junction railway station
    {Coordinate{87.6346, 25.2414}, CountryId{"IN"}}, // Sahibganj Junction railway station
    {Coordinate{77.3642, 28.674}, CountryId{"IN"}}, // Sahibabad Junction railway station
    {Coordinate{8.34944, 49.5353}, CountryId{"DE"}}, // Frankenthal Central Station
    {Coordinate{81.7899, 25.4399}, CountryId{"IN"}}, // Subedarganj railway station
    {Coordinate{77.2278, 28.5786}, CountryId{"IN"}}, // Sewa Nagar railway station
    {Coordinate{4.96806, 51.8339}, CountryId{"NL"}}, // Gorinchem railway station
    {Coordinate{19.0894, 47.5253}, CountryId{"HU"}}, // Rákosrendező railway station
    {Coordinate{73.0947, 49.793}, CountryId{"KZ"}}, // Karaganda railway station
    {Coordinate{11.3205, 50.2396}, CountryId{"DE"}}, // Kronach station
    {Coordinate{25.047, 54.6447}, CountryId{"LT"}}, // Lentvaris train station
    {Coordinate{6.99056, 49.2414}, CountryId{"DE"}}, // Saarbrücken Central Station
    {Coordinate{21.9357, 47.07}, CountryId{"RO"}}, // Oradea Railway Station
    {Coordinate{26.2661, 47.6706}, CountryId{"RO"}}, // Suceava railway station
    {Coordinate{17.1723, 48.1973}, CountryId{"SK"}}, // Bratislava východ railway station
    {Coordinate{18.679, 47.7998}, CountryId{"SK"}}, // Štúrovo railway station
    {Coordinate{7.90809, 46.5984}, CountryId{"CH"}}, // Lauterbrunnen railway station
    {Coordinate{7.95944, 46.5844}, CountryId{"CH"}}, // Kleine Scheidegg railway station
    {Coordinate{53.4517, 56.8713}, CountryId{"RU"}}, // Q1279157
    {Coordinate{54.0172, 57.0417}, CountryId{"RU"}}, // Q1279171
    {Coordinate{10.5256, 59.8928}, CountryId{"NO"}}, // Sandvika Station
    {Coordinate{7.26331, 47.6416}, CountryId{"FR"}}, // Q128074
    {Coordinate{15.601, 46.127}, CountryId{"SI"}}, // Q12807488
    {Coordinate{16.4461, 46.5564}, CountryId{"SI"}}, // Lendava train station
    {Coordinate{15.635, 46.5545}, CountryId{"SI"}}, // Maribor Studenci train station
    {Coordinate{15.6513, 46.5391}, CountryId{"SI"}}, // Maribor Tezno train station
    {Coordinate{15.6047, 46.1658}, CountryId{"SI"}}, // Podčetrtek Toplice railway station
    {Coordinate{8.5804, 49.4487}, CountryId{"DE"}}, // Mannheim-Friedrichsfeld station
    {Coordinate{10.555, 59.8972}, CountryId{"NO"}}, // Blommenholm Station
    {Coordinate{21.2297, 48.5083}, CountryId{"HU"}}, // Hidasnémeti railway station
    {Coordinate{17.7948, 46.3529}, CountryId{"HU"}}, // Kaposvár railway station
    {Coordinate{17.1925, 47.9942}, CountryId{"HU"}}, // Rajka railway station
    {Coordinate{19.1742, 47.4887}, CountryId{"HU"}}, // Rákos railway station
    {Coordinate{19.2581, 47.4861}, CountryId{"HU"}}, // Rákosliget railway station
    {Coordinate{20.1757, 47.1796}, CountryId{"HU"}}, // Szolnok railway station
    {Coordinate{18.3932, 47.5856}, CountryId{"HU"}}, // Tatabánya railway station
    {Coordinate{69.2861, 41.2921}, CountryId{"UZ"}}, // Tashkent Railway Station
    {Coordinate{1.51179, 44.3333}, CountryId{"FR"}}, // Gare de Lalbenque - Fontanes
    {Coordinate{23.9447, 37.9369}, CountryId{"GR"}}, // Athens International Airport station
    {Coordinate{22.9269, 38.4709}, CountryId{"GR"}}, // Livadeia railway station
    {Coordinate{13.7664, 51.1244}, CountryId{"DE"}}, // Dresden Flughafen railway station
    {Coordinate{20.1428, 46.2397}, CountryId{"HU"}}, // Szeged railway station
    {Coordinate{-4.057, 52.544}, CountryId{"GB"}}, // Aberdovey railway station
    {Coordinate{-0.9667, 50.8533}, CountryId{"GB"}}, // Warblington railway station
    {Coordinate{78.3931, 17.2629}, CountryId{"IN"}}, // Umdanagar railway station
    {Coordinate{3.33184, 50.2781}, CountryId{"FR"}}, // Gare de Bouchain
    {Coordinate{30.4033, 53.8769}, CountryId{"BY"}}, // Lupolava
    {Coordinate{29.9781, 55.6764}, CountryId{"BY"}}, // Byčycha
    {Coordinate{9.27, 48.82}, CountryId{"DE"}}, // Fellbach station
    {Coordinate{9.23472, 48.8061}, CountryId{"DE"}}, // Stuttgart Nürnberger Straße station
    {Coordinate{6.43971, 51.1631}, CountryId{"DE"}}, // Rheydt Central Station
    {Coordinate{75.2131, 43.54}, CountryId{"KZ"}}, // Otar
    {Coordinate{73.7199, 16.2588}, CountryId{"IN"}}, // Kankavli railway station
    {Coordinate{70.1181, 22.469}, CountryId{"IN"}}, // Hapa railway station
    {Coordinate{7.25396, 52.1623}, CountryId{"DE"}}, // Metelen Land railway station
    {Coordinate{79.8462, 10.6869}, CountryId{"IN"}}, // Velankanni railway station
    {Coordinate{13.8315, 66.1499}, CountryId{"NO"}}, // Bjerka Station
    {Coordinate{80.04, 44.01}, CountryId{"KZ"}}, // Kundyzdy
    {Coordinate{79.483, 43.738}, CountryId{"KZ"}}, // Taskaras
    {Coordinate{77.0161, 43.4253}, CountryId{"KZ"}}, // Zhety-Su railway station
    {Coordinate{6.62744, 46.5099}, CountryId{"CH"}}, // Jordils station
    {Coordinate{-123.098, 49.2737}, CountryId{"CA"}}, // Pacific Central Station
    {Coordinate{37.6572, 55.7764}, CountryId{"RU"}}, // Moscow Yaroslavsky railway station
    {Coordinate{-0.0162, 51.4684}, CountryId{"GB"}}, // Elverson Road
    {Coordinate{28.5971, 49.9183}, CountryId{"UA"}}, // Berdychiv-Zhytomyrskyi
    {Coordinate{32.8184, 51.1785}, CountryId{"UA"}}, // Q13360789
    {Coordinate{32.4274, 51.4033}, CountryId{"UA"}}, // Bondarivka
    {Coordinate{27.7013, 50.6465}, CountryId{"UA"}}, // Vershnytsia
    {Coordinate{33.1728, 51.2629}, CountryId{"UA"}}, // Vyrivka
    {Coordinate{27.9332, 50.7675}, CountryId{"UA"}}, // Virivka
    {Coordinate{28.3854, 50.915}, CountryId{"UA"}}, // Q13360800
    {Coordinate{29.8059, 49.3079}, CountryId{"UA"}}, // Denhofivka
    {Coordinate{32.5788, 51.316}, CountryId{"UA"}}, // Doch
    {Coordinate{30.0973, 49.2433}, CountryId{"UA"}}, // Zhashkiv
    {Coordinate{29.1978, 49.6461}, CountryId{"UA"}}, // Zarudyntsi
    {Coordinate{28.5936, 50.9565}, CountryId{"UA"}}, // Korosten-Zhytomyrskyi
    {Coordinate{32.2438, 51.7621}, CountryId{"UA"}}, // Koriukivka
    {Coordinate{32.3316, 51.4645}, CountryId{"UA"}}, // Makoshyne
    {Coordinate{28.9143, 49.7278}, CountryId{"UA"}}, // Makharyntsi
    {Coordinate{33.152, 51.368}, CountryId{"UA"}}, // Melnya
    {Coordinate{32.2348, 51.5323}, CountryId{"UA"}}, // Mena
    {Coordinate{32.0748, 51.6714}, CountryId{"UA"}}, // Q13360815
    {Coordinate{28.5648, 50.9638}, CountryId{"UA"}}, // Q13360816
    {Coordinate{28.2925, 50.8982}, CountryId{"UA"}}, // Omelyanivka
    {Coordinate{27.8193, 50.7069}, CountryId{"UA"}}, // Q13360831
    {Coordinate{29.6495, 49.3754}, CountryId{"UA"}}, // Q13360833
    {Coordinate{29.7103, 49.3663}, CountryId{"UA"}}, // Tetiiv
    {Coordinate{28.1975, 50.8584}, CountryId{"UA"}}, // Q13360836
    {Coordinate{32.6992, 51.2422}, CountryId{"UA"}}, // Q13360838
    {Coordinate{28.0664, 50.8061}, CountryId{"UA"}}, // Q13360839
    {Coordinate{26.8042, 49.1789}, CountryId{"UA"}}, // Yarmolyntsi
    {Coordinate{33.5978, 45.1447}, CountryId{"RU"}}, // Saky railway station
    {Coordinate{34.8008, 48.4403}, CountryId{"UA"}}, // Q13361022
    {Coordinate{32.0678, 49.0492}, CountryId{"UA"}}, // Kamianka
    {Coordinate{32.1708, 49.0119}, CountryId{"UA"}}, // Kosari
    {Coordinate{31.3974, 48.9954}, CountryId{"UA"}}, // Shpola
    {Coordinate{23.2981, 48.1617}, CountryId{"UA"}}, // Khust
    {Coordinate{34.4577, 51.2405}, CountryId{"UA"}}, // Volfine
    {Coordinate{33.0306, 52.0945}, CountryId{"UA"}}, // 70 km
    {Coordinate{33.3259, 51.8839}, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{33.4165, 51.2017}, CountryId{"UA"}}, // Q13361354
    {Coordinate{33.3496, 51.2009}, CountryId{"UA"}}, // Q13361355
    {Coordinate{33.2302, 51.2192}, CountryId{"UA"}}, // Q13361359
    {Coordinate{33.5007, 51.2146}, CountryId{"UA"}}, // Q13361360
    {Coordinate{33.7993, 51.9439}, CountryId{"UA"}}, // Ivotka
    {Coordinate{33.2981, 51.2032}, CountryId{"UA"}}, // Kalynivka
    {Coordinate{33.1243, 51.2154}, CountryId{"UA"}}, // Kukilka
    {Coordinate{33.4519, 51.7033}, CountryId{"UA"}}, // Pyrotchyne
    {Coordinate{28.5894, 50.9762}, CountryId{"UA"}}, // Chyhyri
    {Coordinate{33.985, 52.1162}, CountryId{"UA"}}, // Shalymivka
    {Coordinate{32.9224, 51.1954}, CountryId{"UA"}}, // Khutir Khalimonove
    {Coordinate{22.8534, 56.6916}, CountryId{"LV"}}, // Josta Station
    {Coordinate{7.4102, 49.5382}, CountryId{"DE"}}, // Kusel station
    {Coordinate{3.73481, 45.5492}, CountryId{"FR"}}, // Gare d'Ambert
    {Coordinate{7.4448, 49.4702}, CountryId{"DE"}}, // Glan-Münchweiler station
    {Coordinate{8.85501, 47.6561}, CountryId{"CH"}}, // Stein am Rhein railway station
    {Coordinate{44.7978, 41.7233}, CountryId{"GE"}}, // Tbilisi railway station
    {Coordinate{2.1932, 41.4361}, CountryId{"ES"}}, // Sant Andreu Comtal railway station
    {Coordinate{9.20278, 45.3389}, CountryId{"IT"}}, // Pieve Emanuele railway halt
    {Coordinate{6.72258, 49.3526}, CountryId{"DE"}}, // Dillingen (Saar) station
    {Coordinate{31.7833, 51.3271}, CountryId{"UA"}}, // Veresoch
    {Coordinate{31.8823, 51.1762}, CountryId{"UA"}}, // Vertiivka
    {Coordinate{31.1125, 51.7786}, CountryId{"UA"}}, // Q13423562
    {Coordinate{8.58705, 47.5206}, CountryId{"CH"}}, // Embrach-Rorbas railway station with goods shed
    {Coordinate{31.1566, 51.9661}, CountryId{"UA"}}, // Q13423579
    {Coordinate{31.3172, 51.4307}, CountryId{"UA"}}, // Q13423580
    {Coordinate{31.2146, 51.5981}, CountryId{"UA"}}, // Q13423581
    {Coordinate{31.5542, 51.4262}, CountryId{"UA"}}, // Q13423583
    {Coordinate{31.9047, 51.0972}, CountryId{"UA"}}, // Q13423584
    {Coordinate{28.6419, 51.0197}, CountryId{"UA"}}, // Q13423592
    {Coordinate{28.6131, 50.9846}, CountryId{"UA"}}, // Korosten-Podilskyi
    {Coordinate{2.94946, 48.9602}, CountryId{"FR"}}, // Gare de Trilport
    {Coordinate{15.025, 50.99}, CountryId{"CZ"}}, // Q13433906
    {Coordinate{10.9924, 62.958}, CountryId{"NO"}}, // Langlete Station
    {Coordinate{37.6553, 55.7763}, CountryId{"RU"}}, // Leningradsky railway station
    {Coordinate{6.8133, 51.3768}, CountryId{"DE"}}, // Duisburg-Entenfang station
    {Coordinate{6.32083, 50.8244}, CountryId{"DE"}}, // Eschweiler-Weisweiler railway station
    {Coordinate{8.65502, 50.1582}, CountryId{"DE"}}, // Frankfurt Eschersheim station
    {Coordinate{6.90833, 51.1333}, CountryId{"DE"}}, // Düsseldorf-Hellerhof station
    {Coordinate{11.7388, 53.1607}, CountryId{"DE"}}, // Karstädt station
    {Coordinate{11.9608, 50.4197}, CountryId{"DE"}}, // Gutenfürst station
    {Coordinate{-1.673, 52.2952}, CountryId{"GB"}}, // Hatton railway station (England)
    {Coordinate{-1.19861, 53.1422}, CountryId{"GB"}}, // Mansfield railway station
    {Coordinate{-4.3199, 55.9203}, CountryId{"GB"}}, // Hillfoot railway station
    {Coordinate{-1.113, 54.6096}, CountryId{"GB"}}, // British Steel Redcar railway station
    {Coordinate{-2.4636, 54.968}, CountryId{"GB"}}, // Haltwhistle railway station
    {Coordinate{-2.086, 53.464}, CountryId{"GB"}}, // Hyde North railway station
    {Coordinate{-0.36, 53.702}, CountryId{"GB"}}, // New Holland railway station
    {Coordinate{-0.3898, 51.3768}, CountryId{"GB"}}, // Hersham railway station
    {Coordinate{-0.5054, 51.3395}, CountryId{"GB"}}, // West Byfleet railway station
    {Coordinate{0.095, 51.181}, CountryId{"GB"}}, // Hever railway station
    {Coordinate{28.5917, 50.9753}, CountryId{"UA"}}, // Post-Pivdenny
    {Coordinate{7.01389, 51.4514}, CountryId{"DE"}}, // Essen Central Station
    {Coordinate{76.2722, 10.7589}, CountryId{"IN"}}, // Shoranur Junction railway station
    {Coordinate{5.88089, 45.2345}, CountryId{"FR"}}, // Lancey railway station
    {Coordinate{-2.97553, 43.2877}, CountryId{"ES"}}, // Lutxana
    {Coordinate{15.4632, 66.743}, CountryId{"NO"}}, // Lønsdal Station
    {Coordinate{-0.0998, 51.4944}, CountryId{"GB"}}, // Elephant & Castle railway station
    {Coordinate{-1.621, 51.17}, CountryId{"GB"}}, // Grateley railway station
    {Coordinate{75.797, 22.5142}, CountryId{"IN"}}, // Indore Patalpani railway station
    {Coordinate{-0.010556, 51.4881}, CountryId{"GB"}}, // Island Gardens
    {Coordinate{80.3284, 26.4562}, CountryId{"IN"}}, // Kanpur Anwarganj railway station
    {Coordinate{4.61778, 51.1508}, CountryId{"BE"}}, // Kessel railway station
    {Coordinate{23.4642, 56.7025}, CountryId{"LV"}}, // Līvbērze Station
    {Coordinate{6.47226, 51.1996}, CountryId{"DE"}}, // Mönchengladbach-Lürrip station
    {Coordinate{37.5803, 55.7764}, CountryId{"RU"}}, // Moscow Belorussky railway station
    {Coordinate{-2.942, 53.26}, CountryId{"GB"}}, // Capenhurst railway station
    {Coordinate{-2.237, 53.304}, CountryId{"GB"}}, // Alderley Edge railway station
    {Coordinate{10.5782, 49.298}, CountryId{"DE"}}, // Ansbach station
    {Coordinate{84.4221, 18.7568}, CountryId{"IN"}}, // Palasa railway station
    {Coordinate{12.0994, 49.0122}, CountryId{"DE"}}, // Regensburg Hauptbahnhof
    {Coordinate{10.5806, 59.9006}, CountryId{"NO"}}, // Høvik Station
    {Coordinate{37.6392, 55.7294}, CountryId{"RU"}}, // Paveletsky railway station
    {Coordinate{-2.8914, 53.208}, CountryId{"GB"}}, // Bache railway station
    {Coordinate{9.35444, 48.8681}, CountryId{"DE"}}, // Schwaikheim station
    {Coordinate{15.9787, 45.8044}, CountryId{"HR"}}, // Zagreb Main Station
    {Coordinate{16.3169, 48.1505}, CountryId{"AT"}}, // Alterlaa
    {Coordinate{11.1191, 46.0726}, CountryId{"IT"}}, // Trento railway station
    {Coordinate{10.7533, 59.9111}, CountryId{"NO"}}, // Oslo Central Station
    {Coordinate{15.2242, 50.925}, CountryId{"CZ"}}, // Nové Město pod Smrkem
    {Coordinate{15.1511, 50.9389}, CountryId{"CZ"}}, // Řasnice (train station)
    {Coordinate{15.0286, 50.9733}, CountryId{"CZ"}}, // Višňová
    {Coordinate{13.4311, 52.4675}, CountryId{"DE"}}, // Hermannstraße railway station
    {Coordinate{-0.130833, 51.5161}, CountryId{"GB"}}, // Tottenham Court Road tube station
    {Coordinate{16.3133, 48.1367}, CountryId{"AT"}}, // Perfektastraße metro station
    {Coordinate{15.0203, 51.1531}, CountryId{"PL"}}, // Zgorzelec Miasto
    {Coordinate{4.02472, 50.9483}, CountryId{"BE"}}, // Aalst-Kerrebroek railway station
    {Coordinate{6.24123, 51.2945}, CountryId{"DE"}}, // Breyell railway station
    {Coordinate{7.3509, 51.4959}, CountryId{"DE"}}, // Dortmund-Somborn station
    {Coordinate{6.20143, 50.8345}, CountryId{"DE"}}, // Eschweiler-St. Jöris station
    {Coordinate{15.6728, 48.6658}, CountryId{"AT"}}, // Horn station
    {Coordinate{12.94, 49.7431}, CountryId{"CZ"}}, // Q14386728
    {Coordinate{4.65361, 50.8358}, CountryId{"BE"}}, // Oud-Heverlee railway station
    {Coordinate{12.4, 50.1153}, CountryId{"CZ"}}, // Tršnice sttaion
    {Coordinate{21.3425, 41.02}, CountryId{"MK"}}, // Bitola railway station
    {Coordinate{21.6926, 56.6205}, CountryId{"LV"}}, // Kalvene Station
    {Coordinate{13.7513, 52.4296}, CountryId{"DE"}}, // Erkner railway station
    {Coordinate{18.4128, 49.7914}, CountryId{"CZ"}}, // Havířov railway station
    {Coordinate{24.3986, 57.225}, CountryId{"LV"}}, // Inčupe
    {Coordinate{6.84214, 46.7078}, CountryId{"CH"}}, // Lucens railway station
    {Coordinate{6.89429, 46.7588}, CountryId{"CH"}}, // Granges-Marnand railway station
    {Coordinate{73.8512, 18.5317}, CountryId{"IN"}}, // Shivajinagar railway station
    {Coordinate{24.4328, 57.2863}, CountryId{"LV"}}, // Ķīšupe Station
    {Coordinate{6.68628, 50.9381}, CountryId{"DE"}}, // Bahnhof Quadrath-Ichendorf
    {Coordinate{10.9306, 44.6539}, CountryId{"IT"}}, // Modena railway station
    {Coordinate{9.04722, 51.5247}, CountryId{"DE"}}, // Scherfede station
    {Coordinate{14.435, 50.0875}, CountryId{"CZ"}}, // Praha Masarykovo nádraží
    {Coordinate{6.79722, 50.9981}, CountryId{"DE"}}, // Pulheim station
    {Coordinate{16.4069, 48.1753}, CountryId{"AT"}}, // Wien Geiselbergstraße railway station
    {Coordinate{7.21945, 50.6395}, CountryId{"DE"}}, // Bad Honnef (Rhein) station
    {Coordinate{10.6297, 47.8756}, CountryId{"DE"}}, // Kaufbeuren station
    {Coordinate{7.21023, 50.6581}, CountryId{"DE"}}, // Rhöndorf station
    {Coordinate{8.91449, 49.1362}, CountryId{"DE"}}, // Eppingen station
    {Coordinate{8.86361, 52.1719}, CountryId{"DE"}}, // Vlotho station
    {Coordinate{12.6747, 48.2215}, CountryId{"DE"}}, // Altötting station
    {Coordinate{11.1075, 47.9508}, CountryId{"DE"}}, // Dießen station
    {Coordinate{9.82944, 52.9831}, CountryId{"DE"}}, // Soltau (Han) station
    {Coordinate{12.0838, 52.9032}, CountryId{"DE"}}, // Glöwen station
    {Coordinate{10.3321, 47.7313}, CountryId{"DE"}}, // Bahnhof Kempten Ost
    {Coordinate{11.8524, 53.0714}, CountryId{"DE"}}, // Perleberg station
    {Coordinate{10.9883, 48.2627}, CountryId{"DE"}}, // Mering station
    {Coordinate{8.76033, 47.4652}, CountryId{"CH"}}, // Sennhof-Kyburg railway station
    {Coordinate{24.5058, 56.8396}, CountryId{"LV"}}, // Ikšķile
    {Coordinate{14.5606, 50.1067}, CountryId{"CZ"}}, // Rajská zahrada
    {Coordinate{8.41639, 45.3298}, CountryId{"IT"}}, // Vercelli railway station
    {Coordinate{-0.021392, 51.5034}, CountryId{"GB"}}, // Heron Quays
    {Coordinate{18.9588, 47.5059}, CountryId{"HU"}}, // Virágvölgy
    {Coordinate{-0.873252, 38.585}, CountryId{"ES"}}, // Villena AV railway station
    {Coordinate{37.5017, 47.5972}, CountryId{"UA"}}, // Volnovakha Railway Station
    {Coordinate{-1.547, 53.794}, CountryId{"GB"}}, // Leeds railway station
    {Coordinate{-122.292, 37.8407}, CountryId{"US"}}, // Emeryville station
    {Coordinate{-81.9519, 28.0455}, CountryId{"US"}}, // Lakeland
    {Coordinate{-93.217, 30.2382}, CountryId{"US"}}, // Lake Charles
    {Coordinate{-90.0786, 29.9462}, CountryId{"US"}}, // New Orleans Union Passenger Terminal
    {Coordinate{-89.7828, 30.2783}, CountryId{"US"}}, // Slidell
    {Coordinate{-90.4427, 31.5794}, CountryId{"US"}}, // Brookhaven
    {Coordinate{-91.4327, 38.7073}, CountryId{"US"}}, // Hermann
    {Coordinate{-93.2284, 38.7116}, CountryId{"US"}}, // Sedalia
    {Coordinate{-107.872, 48.3605}, CountryId{"US"}}, // Malta
    {Coordinate{-105.643, 48.0915}, CountryId{"US"}}, // Wolf Point
    {Coordinate{-74.4461, 40.4967}, CountryId{"US"}}, // New Brunswick station
    {Coordinate{-74.1907, 40.7044}, CountryId{"US"}}, // Newark Liberty International Airport
    {Coordinate{-80.6246, 35.496}, CountryId{"US"}}, // Kannapolis
    {Coordinate{-94.7283, 32.4941}, CountryId{"US"}}, // Longview
    {Coordinate{-70.3761, 43.5144}, CountryId{"US"}}, // Old Orchard Beach
    {Coordinate{-86.2523, 41.8373}, CountryId{"US"}}, // Niles station
    {Coordinate{37.6325, 55.7928}, CountryId{"RU"}}, // Moscow Rizhsky railway station
    {Coordinate{7.59972, 50.3169}, CountryId{"DE"}}, // Niederlahnstein station
    {Coordinate{22.5296, 40.6365}, CountryId{"GR"}}, // Platy railway station
    {Coordinate{14.0444, 50.6597}, CountryId{"CZ"}}, // Ústí nad Labem hlavní nádraží
    {Coordinate{-0.100556, 51.4956}, CountryId{"GB"}}, // Elephant & Castle tube station
    {Coordinate{-98.4147, 55.0294}, CountryId{"CA"}}, // Lyddal railway station
    {Coordinate{-94.1686, 57.1972}, CountryId{"CA"}}, // Silcox railway station
    {Coordinate{8.05689, 50.0137}, CountryId{"DE"}}, // Hattenheim station
    {Coordinate{10.8665, 53.9589}, CountryId{"DE"}}, // Lübeck-Travemünde Hafen station
    {Coordinate{13.4809, 54.3563}, CountryId{"DE"}}, // Putbus railway station
    {Coordinate{12.2373, 51.8843}, CountryId{"DE"}}, // Roßlau (Elbe) station
    {Coordinate{8.54825, 49.0876}, CountryId{"DE"}}, // Untergrombach station
    {Coordinate{8.26764, 50.4864}, CountryId{"DE"}}, // Weilburg station
    {Coordinate{7.61046, 49.5841}, CountryId{"DE"}}, // Bahnhof Wolfstein
    {Coordinate{12.3466, 51.5198}, CountryId{"DE"}}, // Delitzsch oberer Bahnhof
    {Coordinate{16.3996, 48.1879}, CountryId{"AT"}}, // Bahnhof Wien St. Marx
    {Coordinate{11.4158, 47.1935}, CountryId{"AT"}}, // Patsch railway station
    {Coordinate{70.7549, 23.1032}, CountryId{"IN"}}, // Maliya Miyana railway station
    {Coordinate{4.6062, 45.5243}, CountryId{"FR"}}, // Q14918105
    {Coordinate{37.515, 55.7444}, CountryId{"RU"}}, // Fili
    {Coordinate{0.07179, 51.509}, CountryId{"GB"}}, // Gallions Reach DLR station
    {Coordinate{37.3973, 55.7237}, CountryId{"RU"}}, // Setun
    {Coordinate{37.5539, 55.8053}, CountryId{"RU"}}, // Grazhdanskaya
    {Coordinate{37.5533, 55.8973}, CountryId{"RU"}}, // Lianozovo
    {Coordinate{37.2467, 55.8233}, CountryId{"RU"}}, // Opalikha
    {Coordinate{35.3789, 55.5131}, CountryId{"RU"}}, // Drovnino
    {Coordinate{42.0228, 58.4252}, CountryId{"RU"}}, // Q14927507
    {Coordinate{45.0122, 53.2043}, CountryId{"RU"}}, // Penza 1 railway station
    {Coordinate{27.4422, 53.9375}, CountryId{"BY"}}, // Lyebyadziny
    {Coordinate{40.1906, 48.1555}, CountryId{"RU"}}, // Lykha
    {Coordinate{31.0615, 59.7556}, CountryId{"RU"}}, // Mga
    {Coordinate{38.1362, 56.1088}, CountryId{"RU"}}, // Krasnoarmeysk
    {Coordinate{38.0309, 54.987}, CountryId{"RU"}}, // Zhilyovo
    {Coordinate{49.3302, 55.9423}, CountryId{"RU"}}, // Q14927518
    {Coordinate{59.9778, 56.8889}, CountryId{"RU"}}, // Q14927533
    {Coordinate{30.9341, 59.976}, CountryId{"RU"}}, // Dunay platform
    {Coordinate{27.0659, 54.2537}, CountryId{"BY"}}, // Usha
    {Coordinate{48.0483, 56.5125}, CountryId{"RU"}}, // Q14927539
    {Coordinate{29.1541, 60.552}, CountryId{"RU"}}, // Leypyasuo
    {Coordinate{40.035, 57.7686}, CountryId{"RU"}}, // Q14927543
    {Coordinate{28.7136, 60.5825}, CountryId{"RU"}}, // Popovo railway station
    {Coordinate{35.7175, 56.9533}, CountryId{"RU"}}, // Tvertsa
    {Coordinate{38.9181, 55.0264}, CountryId{"RU"}}, // Chyornaya
    {Coordinate{43.4792, 44.1672}, CountryId{"RU"}}, // Q14927597
    {Coordinate{43.5816, 49.9016}, CountryId{"RU"}}, // Q14927598
    {Coordinate{38.666, 47.6978}, CountryId{"RU"}}, // Q14927599
    {Coordinate{42.992, 50.327}, CountryId{"RU"}}, // Q14927601
    {Coordinate{109.342, 55.6328}, CountryId{"RU"}}, // Severobaykalsk railway station
    {Coordinate{29.5424, 55.8469}, CountryId{"RU"}}, // Q14927614
    {Coordinate{56.9983, 57.4234}, CountryId{"RU"}}, // Kungur Railway Station
    {Coordinate{38.8093, 55.4104}, CountryId{"RU"}}, // Berendino
    {Coordinate{35.7871, 55.9942}, CountryId{"RU"}}, // Blagoveshchenskoye
    {Coordinate{37.2661, 55.6099}, CountryId{"RU"}}, // Aeroport
    {Coordinate{39.2114, 56.7063}, CountryId{"RU"}}, // Q14927621
    {Coordinate{45.4122, 53.1141}, CountryId{"RU"}}, // Q14927622
    {Coordinate{37.4616, 54.9949}, CountryId{"RU"}}, // 92 km
    {Coordinate{75.3441, 43.5342}, CountryId{"KZ"}}, // Q14927624
    {Coordinate{75.4881, 43.535}, CountryId{"KZ"}}, // Q14927625
    {Coordinate{78.8757, 43.7499}, CountryId{"KZ"}}, // Ortakudyk
    {Coordinate{79.8153, 43.9607}, CountryId{"KZ"}}, // Aydarly
    {Coordinate{55.9204, 53.4658}, CountryId{"RU"}}, // Q14927628
    {Coordinate{55.9256, 53.5367}, CountryId{"RU"}}, // Q14927629
    {Coordinate{55.9137, 53.5556}, CountryId{"RU"}}, // Q14927630
    {Coordinate{55.9196, 53.608}, CountryId{"RU"}}, // Q14927631
    {Coordinate{55.91, 53.5669}, CountryId{"RU"}}, // Q14927632
    {Coordinate{38.4069, 48.3422}, CountryId{"UA"}}, // Debaltseve Railway Station
    {Coordinate{37.4583, 56.1258}, CountryId{"RU"}}, // Bely Rast
    {Coordinate{126.75, 52.6311}, CountryId{"RU"}}, // Q14927635
    {Coordinate{45.1906, 54.1956}, CountryId{"RU"}}, // Saransk railway station
    {Coordinate{39.2425, 56.8027}, CountryId{"RU"}}, // Q14927637
    {Coordinate{38.3264, 55.1019}, CountryId{"RU"}}, // Lyutik
    {Coordinate{35.8914, 56.8358}, CountryId{"RU"}}, // Tver
    {Coordinate{36.7578, 54.515}, CountryId{"RU"}}, // Ferzikovo railway station
    {Coordinate{52.1845, 56.9893}, CountryId{"RU"}}, // Uva-1 station
    {Coordinate{52.3872, 56.9833}, CountryId{"RU"}}, // Karkalay station
    {Coordinate{52.8693, 56.9673}, CountryId{"RU"}}, // Q14927644
    {Coordinate{42.2661, 54.2642}, CountryId{"RU"}}, // Kustaryovka
    {Coordinate{25.3453, 52.7092}, CountryId{"BY"}}, // Ivatsevichy
    {Coordinate{25.2219, 52.6515}, CountryId{"BY"}}, // Kosava-Palyeskaye
    {Coordinate{25.0926, 52.6062}, CountryId{"BY"}}, // Bronnaya Hara
    {Coordinate{53.7375, 63.5572}, CountryId{"RU"}}, // Uhta
    {Coordinate{50.0752, 62.3599}, CountryId{"RU"}}, // Mikun railroad station
    {Coordinate{55.0747, 51.7763}, CountryId{"RU"}}, // Orenburg railway station
    {Coordinate{36.1964, 52.9372}, CountryId{"RU"}}, // Q14927652
    {Coordinate{35.18, 53.1403}, CountryId{"RU"}}, // Q14927653
    {Coordinate{40.1167, 47.4042}, CountryId{"RU"}}, // Novocherkassk railway station
    {Coordinate{34.9817, 53.1344}, CountryId{"RU"}}, // Karachev railway station
    {Coordinate{34.3081, 53.3142}, CountryId{"RU"}}, // Ordzhonikidzegrad
    {Coordinate{31.8484, 53.7258}, CountryId{"BY"}}, // Krychaw II
    {Coordinate{31.7089, 53.7403}, CountryId{"BY"}}, // Krychaw I
    {Coordinate{59.9931, 57.9099}, CountryId{"RU"}}, // Nizhny Tagil train station
    {Coordinate{34.8325, 53.1769}, CountryId{"RU"}}, // Q14927660
    {Coordinate{34.2353, 53.1117}, CountryId{"RU"}}, // Q14927661
    {Coordinate{33.4633, 52.9139}, CountryId{"RU"}}, // Pochep railway station
    {Coordinate{33.1347, 52.8792}, CountryId{"RU"}}, // Q14927663
    {Coordinate{32.6783, 52.8428}, CountryId{"RU"}}, // Unecha
    {Coordinate{32.2333, 52.735}, CountryId{"RU"}}, // Q14927665
    {Coordinate{31.9469, 52.5228}, CountryId{"RU"}}, // Novozybkov
    {Coordinate{31.165, 52.3881}, CountryId{"BY"}}, // Laryshchava
    {Coordinate{30.7536, 52.3986}, CountryId{"BY"}}, // Prybar
    {Coordinate{30.3928, 52.3486}, CountryId{"BY"}}, // Rechytsa
    {Coordinate{30.2031, 52.3361}, CountryId{"BY"}}, // Dzyemyakhi
    {Coordinate{29.8311, 52.2539}, CountryId{"BY"}}, // Vasilyevichy
    {Coordinate{29.6728, 52.2217}, CountryId{"BY"}}, // Nakhaw
    {Coordinate{29.4992, 52.1622}, CountryId{"BY"}}, // Halyavitsy
    {Coordinate{57.2351, 65.1582}, CountryId{"RU"}}, // Q14927688
    {Coordinate{41.5459, 58.4671}, CountryId{"RU"}}, // Q14927689
    {Coordinate{41.1154, 57.245}, CountryId{"RU"}}, // Q14927690
    {Coordinate{41.3006, 64.4097}, CountryId{"RU"}}, // Q14927691
    {Coordinate{47.5076, 58.2823}, CountryId{"RU"}}, // Svecha station
    {Coordinate{43.3911, 58.3394}, CountryId{"RU"}}, // Nikolo-Poloma railway station
    {Coordinate{41.6771, 57.9251}, CountryId{"RU"}}, // Q14927694
    {Coordinate{88.3939, 22.6397}, CountryId{"IN"}}, // Noapara metro station
    {Coordinate{7.6681, 45.0004}, CountryId{"IT"}}, // Moncalieri Sangone railway station
    {Coordinate{7.642, 44.9914}, CountryId{"IT"}}, // Nichelino railway halt
    {Coordinate{7.599, 44.9611}, CountryId{"IT"}}, // Candiolo railway station
    {Coordinate{11.4101, 48.14}, CountryId{"DE"}}, // München-Freiham Haltepunkt
    {Coordinate{12.5644, 55.6728}, CountryId{"DK"}}, // Copenhagen Central Station
    {Coordinate{27.4679, 57.84}, CountryId{"EE"}}, // Piusa railway station
    {Coordinate{-0.1609, 51.1565}, CountryId{"GB"}}, // Gatwick Airport railway station
    {Coordinate{-2.73374, 53.3787}, CountryId{"GB"}}, // Widnes railway station
    {Coordinate{11.4116, 63.963}, CountryId{"NO"}}, // Vist Station
    {Coordinate{9.26733, 59.5589}, CountryId{"NO"}}, // Notodden New Station
    {Coordinate{6.71583, 60.5208}, CountryId{"NO"}}, // Granvin Station
    {Coordinate{88.346, 22.5167}, CountryId{"IN"}}, // Kalighat metro station
    {Coordinate{10.2431, 50.0461}, CountryId{"DE"}}, // Schweinfurt Stadt station
    {Coordinate{12.6334, 42.2422}, CountryId{"IT"}}, // Poggio Mirteto railway station
    {Coordinate{12.5961, 42.0639}, CountryId{"IT"}}, // Monterotondo-Mentana railway station
    {Coordinate{9.43698, 45.0632}, CountryId{"IT"}}, // Castel San Giovanni railway station
    {Coordinate{11.3764, 44.4817}, CountryId{"IT"}}, // Bologna Mazzini railway halt
    {Coordinate{11.842, 44.6165}, CountryId{"IT"}}, // Argenta railway station
    {Coordinate{12.4609, 44.1502}, CountryId{"IT"}}, // Bellaria railway station
    {Coordinate{12.0401, 44.5116}, CountryId{"IT"}}, // Alfonsine railway station
    {Coordinate{12.0983, 44.4628}, CountryId{"IT"}}, // Mezzano railway station
    {Coordinate{7.7555, 46.3674}, CountryId{"CH"}}, // Goppenstein railway station
    {Coordinate{30.7406, 46.4639}, CountryId{"UA"}}, // Odesa-Holovna
    {Coordinate{8.78478, 47.3671}, CountryId{"CH"}}, // Pfäffikon ZH railway station
    {Coordinate{8.75027, 47.3851}, CountryId{"CH"}}, // Fehraltorf railway station
    {Coordinate{8.70475, 47.4517}, CountryId{"CH"}}, // Kemptthal railway station
    {Coordinate{8.93236, 47.354}, CountryId{"CH"}}, // Steg railway station
    {Coordinate{8.92318, 47.3334}, CountryId{"CH"}}, // Fischenthal railway station
    {Coordinate{8.62656, 47.4383}, CountryId{"CH"}}, // Bassersdorf railway station
    {Coordinate{8.91566, 47.3134}, CountryId{"CH"}}, // Gibswil railway station
    {Coordinate{8.8526, 47.2685}, CountryId{"CH"}}, // Tann-Dürnten railway station
    {Coordinate{8.84241, 47.2237}, CountryId{"CH"}}, // Blumenau railway station
    {Coordinate{8.85488, 47.3938}, CountryId{"CH"}}, // Saland railway station
    {Coordinate{8.84359, 47.4373}, CountryId{"CH"}}, // Turbenthal railway station
    {Coordinate{8.81892, 47.4416}, CountryId{"CH"}}, // Rämismühle-Zell railway station
    {Coordinate{8.76929, 47.5016}, CountryId{"CH"}}, // Winterthur Hegi railway station
    {Coordinate{8.6132, 47.2815}, CountryId{"CH"}}, // Herrliberg-Feldmeilen railway station
    {Coordinate{8.59892, 47.2974}, CountryId{"CH"}}, // Winkel am Zürichsee railway station
    {Coordinate{8.59161, 47.3053}, CountryId{"CH"}}, // Erlenbach ZH railway station
    {Coordinate{8.80066, 47.2136}, CountryId{"CH"}}, // Hurden railway station
    {Coordinate{8.75938, 47.2042}, CountryId{"CH"}}, // Freienbach SOB railway station
    {Coordinate{8.7562, 47.2073}, CountryId{"CH"}}, // Freienbach SBB railway station
    {Coordinate{8.82288, 47.194}, CountryId{"CH"}}, // Altendorf railway station
    {Coordinate{8.64661, 47.516}, CountryId{"CH"}}, // Pfungen railway station
    {Coordinate{8.50364, 47.4874}, CountryId{"CH"}}, // Niederglatt railway station
    {Coordinate{8.51059, 47.4702}, CountryId{"CH"}}, // Oberglatt railway station
    {Coordinate{8.37365, 47.5654}, CountryId{"CH"}}, // Rümikon AG railway station
    {Coordinate{8.35251, 47.5685}, CountryId{"CH"}}, // Mellikon railway station
    {Coordinate{8.32713, 47.57}, CountryId{"CH"}}, // Rekingen AG railway station
    {Coordinate{8.27733, 47.6007}, CountryId{"CH"}}, // Rietheim railway station
    {Coordinate{8.24016, 47.6094}, CountryId{"CH"}}, // Koblenz Dorf railway station
    {Coordinate{8.62586, 47.6829}, CountryId{"CH"}}, // Neuhausen railway station
    {Coordinate{10.2423, 53.6613}, CountryId{"DE"}}, // Ahrensburg Ost
    {Coordinate{13.6618, 51.0132}, CountryId{"DE"}}, // Freital-Potschappel station
    {Coordinate{6.45138, 51.2859}, CountryId{"DE"}}, // Anrath railway station
    {Coordinate{7.63904, 50.6851}, CountryId{"DE"}}, // Altenkirchen (Westerw) station
    {Coordinate{7.96625, 49.2053}, CountryId{"DE"}}, // Annweiler am Trifels station
    {Coordinate{8.0028, 49.1031}, CountryId{"DE"}}, // Bahnhof Bad Bergzabern
    {Coordinate{7.69807, 47.9197}, CountryId{"DE"}}, // Bad Krozingen station
    {Coordinate{13.4785, 52.5012}, CountryId{"DE"}}, // Berlin-Rummelsburg railway station
    {Coordinate{11.4085, 47.7235}, CountryId{"DE"}}, // Bichl station
    {Coordinate{13.22, 47.4173}, CountryId{"AT"}}, // Bischofshofen railway station
    {Coordinate{12.9521, 50.8612}, CountryId{"DE"}}, // Chemnitz-Hilbersdorf station
    {Coordinate{7.4283, 49.2454}, CountryId{"DE"}}, // Bahnhof Contwig
    {Coordinate{10.138, 50.1312}, CountryId{"DE"}}, // Ebenhausen (Unterfr) station
    {Coordinate{7.89941, 49.4903}, CountryId{"DE"}}, // Enkenbach station
    {Coordinate{6.82356, 50.8104}, CountryId{"DE"}}, // Erftstadt station
    {Coordinate{8.09867, 47.8716}, CountryId{"DE"}}, // Feldberg-Bärental Station
    {Coordinate{7.77304, 49.2031}, CountryId{"DE"}}, // Hinterweidenthal Ost station
    {Coordinate{8.89617, 49.4428}, CountryId{"DE"}}, // Bahnhof Hirschhorn
    {Coordinate{7.89667, 49.4428}, CountryId{"DE"}}, // Hochspeyer station
    {Coordinate{13.2714, 52.6725}, CountryId{"DE"}}, // Hohen Neuendorf West station
    {Coordinate{14.9024, 51.3039}, CountryId{"DE"}}, // Horka Pbf station
    {Coordinate{9.7628, 50.6733}, CountryId{"DE"}}, // Q15107193
    {Coordinate{9.60415, 50.2326}, CountryId{"DE"}}, // Q15107198
    {Coordinate{8.1977, 49.0792}, CountryId{"DE"}}, // Bahnhof Kandel
    {Coordinate{7.701, 49.5001}, CountryId{"DE"}}, // Q15107201
    {Coordinate{11.9884, 51.7522}, CountryId{"DE"}}, // Köthen railway station
    {Coordinate{8.07436, 49.3733}, CountryId{"DE"}}, // Lambrecht (Pfalz) station
    {Coordinate{11.8535, 48.4387}, CountryId{"DE"}}, // Langenbach station
    {Coordinate{8.5037, 49.5016}, CountryId{"DE"}}, // Mannheim-Käfertal station
    {Coordinate{8.81304, 49.3208}, CountryId{"DE"}}, // Meckesheim station
    {Coordinate{9.14667, 49.3522}, CountryId{"DE"}}, // Mosbach (Baden) station
    {Coordinate{11.193, 47.6823}, CountryId{"DE"}}, // Murnau station
    {Coordinate{9.02861, 50.6167}, CountryId{"DE"}}, // Mücke (Hesse) station
    {Coordinate{7.90111, 50.6247}, CountryId{"DE"}}, // Nistertal-Bad Marienberg station
    {Coordinate{7.42624, 51.8922}, CountryId{"DE"}}, // Nottuln-Appelhülsen station
    {Coordinate{7.65284, 49.5381}, CountryId{"DE"}}, // Q15107260
    {Coordinate{7.4442, 49.5421}, CountryId{"DE"}}, // Q15107280
    {Coordinate{7.4404, 49.4852}, CountryId{"DE"}}, // Q15107282
    {Coordinate{7.24275, 51.2153}, CountryId{"DE"}}, // Remscheid-Lüttringhausen station
    {Coordinate{11.0972, 47.9826}, CountryId{"DE"}}, // Riederau station
    {Coordinate{8.1414, 49.1379}, CountryId{"DE"}}, // Rohrbach (Pfalz)
    {Coordinate{8.829, 49.9732}, CountryId{"DE"}}, // Rödermark-Ober-Roden station
    {Coordinate{11.0898, 48.0528}, CountryId{"DE"}}, // Schondorf (Bay) station
    {Coordinate{7.68757, 49.3591}, CountryId{"DE"}}, // Schopp station
    {Coordinate{7.44845, 49.5191}, CountryId{"DE"}}, // Q15107299
    {Coordinate{8.2732, 49.0455}, CountryId{"DE"}}, // Wörth (Rhein) station
    {Coordinate{8.66429, 47.7172}, CountryId{"CH"}}, // Herblingen railway station
    {Coordinate{8.70323, 47.7455}, CountryId{"CH"}}, // Thayngen railway station
    {Coordinate{8.53276, 47.4543}, CountryId{"CH"}}, // Rümlang railway station
    {Coordinate{8.48868, 47.4783}, CountryId{"CH"}}, // Niederhasli railway station
    {Coordinate{8.44683, 47.49}, CountryId{"CH"}}, // Steinmaur railway station
    {Coordinate{16.4654, 48.146}, CountryId{"AT"}}, // Wien Kaiserebersdorf railway station
    {Coordinate{6.975, 50.9408}, CountryId{"DE"}}, // Köln Messe/Deutz station
    {Coordinate{18.3275, 47.6647}, CountryId{"HU"}}, // Tata railway station
    {Coordinate{18.1136, 47.7494}, CountryId{"HU"}}, // Komárom railway station
    {Coordinate{18.0039, 47.717}, CountryId{"HU"}}, // Ács railway station
    {Coordinate{12.3746, 51.3403}, CountryId{"DE"}}, // Leipzig Markt station
    {Coordinate{17.1914, 47.1825}, CountryId{"HU"}}, // Boba railway station
    {Coordinate{7.76528, 45.9844}, CountryId{"CH"}}, // Rotenboden railway station
    {Coordinate{80.2829, 13.0835}, CountryId{"IN"}}, // Chennai Fort railway station
    {Coordinate{91.2785, 23.7924}, CountryId{"IN"}}, // Agartala railway station
    {Coordinate{74.7219, 19.0755}, CountryId{"IN"}}, // Ahmednagar railway station
    {Coordinate{7.4834, 44.928}, CountryId{"IT"}}, // Airasca railway station
    {Coordinate{77.0055, 20.7231}, CountryId{"IN"}}, // Akola railway station
    {Coordinate{73.7642, 18.6481}, CountryId{"IN"}}, // Akurdi railway station
    {Coordinate{78.0746, 27.8896}, CountryId{"IN"}}, // Aligarh railway station
    {Coordinate{89.534, 26.5233}, CountryId{"IN"}}, // Alipurduar Junction railway station
    {Coordinate{87.1812, 23.579}, CountryId{"IN"}}, // Andal Junction railway station
    {Coordinate{85.1, 20.8594}, CountryId{"IN"}}, // Angul railway station
    {Coordinate{80.2308, 13.3043}, CountryId{"IN"}}, // Anuppambattu railway station
    {Coordinate{73.1526, 18.8635}, CountryId{"IN"}}, // Apta railway station
    {Coordinate{79.668, 13.0815}, CountryId{"IN"}}, // Arakkonam Junction railway station
    {Coordinate{7.30176, 43.7347}, CountryId{"FR"}}, // Gare de l'Ariane - La Trinité
    {Coordinate{7.19454, 43.6624}, CountryId{"FR"}}, // Gare de Saint-Laurent-du-Var
    {Coordinate{13.5382, 52.4525}, CountryId{"DE"}}, // Oberspree station
    {Coordinate{7.75917, 53.2209}, CountryId{"DE"}}, // Augustfehn railway station
    {Coordinate{7.84282, 46.3125}, CountryId{"CH"}}, // Ausserberg railway station
    {Coordinate{77.7323, 20.8568}, CountryId{"IN"}}, // Badnera railway station
    {Coordinate{88.7579, 25.233}, CountryId{"IN"}}, // Balurghat railway station
    {Coordinate{89.5862, 26.0706}, CountryId{"IN"}}, // Bamanhat railway station
    {Coordinate{88.8329, 23.0305}, CountryId{"IN"}}, // Bangaon Junction railway station
    {Coordinate{84.903, 22.6648}, CountryId{"IN"}}, // Bano railway station
    {Coordinate{86.9286, 23.7069}, CountryId{"IN"}}, // Barachak railway station
    {Coordinate{87.8703, 23.2497}, CountryId{"IN"}}, // Barddhaman Junction railway station
    {Coordinate{87.9226, 25.6509}, CountryId{"IN"}}, // Barsoi Junction railway station
    {Coordinate{13.6734, 52.5183}, CountryId{"DE"}}, // Hoppegarten (Mark) station
    {Coordinate{13.7625, 52.5265}, CountryId{"DE"}}, // Fredersdorf station
    {Coordinate{73.709, 18.7012}, CountryId{"IN"}}, // Begdewadi railway station
    {Coordinate{86.447, 23.6422}, CountryId{"IN"}}, // Bhojudih Junction railway station
    {Coordinate{75.7887, 21.0473}, CountryId{"IN"}}, // Bhusaval Junction railway station
    {Coordinate{77.6678, 27.5014}, CountryId{"IN"}}, // Bhuteshwar railway station
    {Coordinate{7.13443, 43.6298}, CountryId{"FR"}}, // Gare de Villeneuve-Loubet-plage
    {Coordinate{87.3013, 23.0651}, CountryId{"IN"}}, // Bishnupur Junction railway station
    {Coordinate{5.09142, 43.6999}, CountryId{"FR"}}, // Lamanon
    {Coordinate{7.33956, 51.3238}, CountryId{"DE"}}, // Gevelsberg Hauptbahnhof
    {Coordinate{86.085, 23.6566}, CountryId{"IN"}}, // Bokaro Steel City Junction railway station
    {Coordinate{84.9251, 22.2355}, CountryId{"IN"}}, // Bondamunda railway station
    {Coordinate{13.8206, 52.8728}, CountryId{"DE"}}, // Britz
    {Coordinate{8.33269, 44.3362}, CountryId{"IT"}}, // Altare railway station
    {Coordinate{8.19189, 44.3907}, CountryId{"IT"}}, // Cengio train station
    {Coordinate{8.5428, 44.3423}, CountryId{"IT"}}, // Celle Ligure railway halt
    {Coordinate{85.6278, 22.679}, CountryId{"IN"}}, // Chakradharpur railway station
    {Coordinate{83.2677, 25.2611}, CountryId{"IN"}}, // Chandauli Majhwar railway station
    {Coordinate{86.1198, 23.7557}, CountryId{"IN"}}, // Chandrapura railway station
    {Coordinate{74.2377, 16.7026}, CountryId{"IN"}}, // Chattrapati Shahu Maharaj Terminus
    {Coordinate{79.9815, 12.6929}, CountryId{"IN"}}, // Chengalpattu Junction railway station
    {Coordinate{76.6083, 9.3195}, CountryId{"IN"}}, // Chengannur railway station
    {Coordinate{82.8747, 25.1034}, CountryId{"IN"}}, // Chunar railway station
    {Coordinate{13.0334, 52.3237}, CountryId{"DE"}}, // Dallgow-Döberitz railway station
    {Coordinate{86.9085, 23.651}, CountryId{"IN"}}, // Damodar railway station
    {Coordinate{88.2908, 22.6783}, CountryId{"IN"}}, // Dankuni Junction railway station
    {Coordinate{73.8328, 18.58}, CountryId{"IN"}}, // Dapodi railway station
    {Coordinate{75.9196, 14.468}, CountryId{"IN"}}, // Davangere railway station
    {Coordinate{78.0336, 30.314}, CountryId{"IN"}}, // Dehradun railway station
    {Coordinate{84.1854, 24.9149}, CountryId{"IN"}}, // Dehri-on-Sone railway station
    {Coordinate{73.7342, 18.6802}, CountryId{"IN"}}, // Dehu Road railway station
    {Coordinate{71.4791, 22.9872}, CountryId{"IN"}}, // Dharangadhra Junction railway station
    {Coordinate{78.1547, 12.1266}, CountryId{"IN"}}, // Dharmapuri Junction railway station
    {Coordinate{89.978, 26.0231}, CountryId{"IN"}}, // Dhubri railway station
    {Coordinate{94.9353, 27.4636}, CountryId{"IN"}}, // Dibrugarh railway station
    {Coordinate{87.5082, 21.6229}, CountryId{"IN"}}, // Digha railway station
    {Coordinate{93.7278, 25.9057}, CountryId{"IN"}}, // Dimapur railway station
    {Coordinate{76.3363, 10.2854}, CountryId{"IN"}}, // Divine Nagar railway station
    {Coordinate{13.5642, 51.6206}, CountryId{"DE"}}, // Doberlug-Kirchhain railway station
    {Coordinate{9.19753, 47.2267}, CountryId{"CH"}}, // Nesslau-Neu St. Johann railway station
    {Coordinate{88.3933, 22.6209}, CountryId{"IN"}}, // Dum Dum Junction railway station
    {Coordinate{87.3174, 23.4953}, CountryId{"IN"}}, // Durgapur railway station
    {Coordinate{7.88116, 46.3065}, CountryId{"CH"}}, // Eggerberg railway station
    {Coordinate{12.9997, 52.5476}, CountryId{"DE"}}, // Elstal railway station
    {Coordinate{-3.2287, 51.5838}, CountryId{"GB"}}, // Energlyn & Churchill Park railway station
    {Coordinate{9.07719, 47.033}, CountryId{"CH"}}, // Ennenda railway station
    {Coordinate{78.654, 27.5719}, CountryId{"IN"}}, // Etah railway station
    {Coordinate{79.0215, 26.786}, CountryId{"IN"}}, // Etawah railway station
    {Coordinate{77.3094, 28.3762}, CountryId{"IN"}}, // Faridabad New Town railway station
    {Coordinate{77.3074, 28.4115}, CountryId{"IN"}}, // Faridabad railway station
    {Coordinate{80.8019, 25.9175}, CountryId{"IN"}}, // Fatehpur railway station
    {Coordinate{78.3867, 27.1474}, CountryId{"IN"}}, // Firozabad railway station
    {Coordinate{28.2339, 59.3678}, CountryId{"RU"}}, // Ivangorod
    {Coordinate{16.3998, 48.2561}, CountryId{"AT"}}, // Floridsdorf (Vienna U-Bahn)
    {Coordinate{24.2987, 56.921}, CountryId{"LV"}}, // Acone railway station
    {Coordinate{25.5775, 56.6336}, CountryId{"LV"}}, // Alotene
    {Coordinate{26.4075, 56.5303}, CountryId{"LV"}}, // Q15218596
    {Coordinate{25.2442, 56.5083}, CountryId{"LV"}}, // Daudzeva
    {Coordinate{26.6984, 57.1028}, CountryId{"LV"}}, // Elste railway station
    {Coordinate{23.9492, 56.6506}, CountryId{"LV"}}, // Garoza railway station
    {Coordinate{24.2347, 56.6286}, CountryId{"LV"}}, // Iecava
    {Coordinate{25.9763, 56.6871}, CountryId{"LV"}}, // Jaunkalsnava railway station
    {Coordinate{23.7567, 56.6508}, CountryId{"LV"}}, // Jelgava II
    {Coordinate{26.0187, 56.7339}, CountryId{"LV"}}, // Kalsnava railway station
    {Coordinate{22.743, 57.102}, CountryId{"LV"}}, // Līgciems Station
    {Coordinate{22.4194, 57.1783}, CountryId{"LV"}}, // Līči Station
    {Coordinate{25.1008, 56.5375}, CountryId{"LV"}}, // Menta
    {Coordinate{24.3964, 56.5914}, CountryId{"LV"}}, // Q15219390
    {Coordinate{21.9314, 57.3089}, CountryId{"LV"}}, // Puze Station
    {Coordinate{24.2242, 56.92}, CountryId{"LV"}}, // Q15219689
    {Coordinate{22.6519, 57.1315}, CountryId{"LV"}}, // Sabile Station
    {Coordinate{25.3703, 56.5106}, CountryId{"LV"}}, // Sece
    {Coordinate{23.2911, 56.8442}, CountryId{"LV"}}, // Slampe Station
    {Coordinate{25.8254, 56.6616}, CountryId{"LV"}}, // Spīgana railway station
    {Coordinate{25.6139, 56.5261}, CountryId{"LV"}}, // Sēlpils
    {Coordinate{24.9281, 56.5625}, CountryId{"LV"}}, // Taurkalne train station
    {Coordinate{26.7689, 56.5608}, CountryId{"LV"}}, // Q15219970
    {Coordinate{24.5367, 56.5903}, CountryId{"LV"}}, // Vecumnieki
    {Coordinate{26.9383, 56.5608}, CountryId{"LV"}}, // Q15220042
    {Coordinate{28.1161, 56.3917}, CountryId{"LV"}}, // Zilupe railway station
    {Coordinate{24.0856, 56.6414}, CountryId{"LV"}}, // Zālīte railway station
    {Coordinate{70.1478, 23.0691}, CountryId{"IN"}}, // Gandhidham Junction railway station
    {Coordinate{78.002, 22.1264}, CountryId{"IN"}}, // Ghoradongri railway station
    {Coordinate{73.697, 18.7206}, CountryId{"IN"}}, // Ghorawadi railway station
    {Coordinate{89.8307, 26.1084}, CountryId{"IN"}}, // Golokganj railway station
    {Coordinate{7.78222, 45.9833}, CountryId{"CH"}}, // Gornergrat railway station
    {Coordinate{80.2517, 13.0203}, CountryId{"IN"}}, // Greenways Road railway station
    {Coordinate{80.0571, 12.8449}, CountryId{"IN"}}, // Guduvancheri railway station
    {Coordinate{85.2155, 25.7029}, CountryId{"IN"}}, // Hajipur Junction railway station
    {Coordinate{11.4067, 52.2847}, CountryId{"DE"}}, // Haldensleben station
    {Coordinate{88.0659, 22.0453}, CountryId{"IN"}}, // Haldia railway station
    {Coordinate{88.7828, 26.336}, CountryId{"IN"}}, // Haldibari railway station
    {Coordinate{73.0793, 18.7839}, CountryId{"IN"}}, // Hamrapur railway station
    {Coordinate{9.49806, 53.4503}, CountryId{"DE"}}, // Harsefeld
    {Coordinate{88.9134, 22.5712}, CountryId{"IN"}}, // Hasnabad railway station
    {Coordinate{9.3898, 52.3794}, CountryId{"DE"}}, // Haste (Han) station
    {Coordinate{85.9872, 25.3658}, CountryId{"IN"}}, // Hathidah Junction railway station
    {Coordinate{78.1371, 27.6248}, CountryId{"IN"}}, // Hathras Junction railway station
    {Coordinate{8.97224, 53.4986}, CountryId{"DE"}}, // Heinschenwalde station
    {Coordinate{8.66833, 52.1581}, CountryId{"DE"}}, // Hiddenhausen-Schweicheln station
    {Coordinate{7.76459, 46.3224}, CountryId{"CH"}}, // Hohtenn railway station
    {Coordinate{88.3759, 22.9048}, CountryId{"IN"}}, // Hooghly railway station
    {Coordinate{8.58982, 47.2588}, CountryId{"CH"}}, // Horgen Oberdorf railway station
    {Coordinate{77.8228, 12.7176}, CountryId{"IN"}}, // Hosur railway station
    {Coordinate{73.5624, 19.6941}, CountryId{"IN"}}, // Igatpuri railway station
    {Coordinate{-1.2949, 52.9794}, CountryId{"GB"}}, // Ilkeston railway station
    {Coordinate{76.2809, 10.3395}, CountryId{"IN"}}, // Irinjalakuda railway station
    {Coordinate{79.1192, 21.1578}, CountryId{"IN"}}, // Itwari railway station
    {Coordinate{76.5732, 20.813}, CountryId{"IN"}}, // Jalamb railway station
    {Coordinate{75.5629, 21.0181}, CountryId{"IN"}}, // Jalgaon railway station
    {Coordinate{88.7237, 26.5189}, CountryId{"IN"}}, // Jalpaiguri railway station
    {Coordinate{70.0539, 22.494}, CountryId{"IN"}}, // Jamnagar railway station
    {Coordinate{78.553, 25.4436}, CountryId{"IN"}}, // Jhansi Junction railway station
    {Coordinate{73.0862, 18.8196}, CountryId{"IN"}}, // Jite railway station
    {Coordinate{78.5778, 12.5609}, CountryId{"IN"}}, // Jolarpettai Junction railway station
    {Coordinate{73.0178, 19.056}, CountryId{"IN"}}, // Juinagar railway station
    {Coordinate{73.1148, 19.0356}, CountryId{"IN"}}, // Kalamboli railway station
    {Coordinate{72.9191, 19.3365}, CountryId{"IN"}}, // Kaman Road railway station
    {Coordinate{7.66061, 51.585}, CountryId{"DE"}}, // Kamen station
    {Coordinate{73.5524, 18.7669}, CountryId{"IN"}}, // Kamshet railway station
    {Coordinate{79.7051, 12.8484}, CountryId{"IN"}}, // Kanchipuram railway station
    {Coordinate{7.67148, 46.4952}, CountryId{"CH"}}, // Kandersteg railway station
    {Coordinate{73.594, 18.7624}, CountryId{"IN"}}, // Kanhe railway station
    {Coordinate{88.4052, 22.8662}, CountryId{"IN"}}, // Kankinara railway station
    {Coordinate{73.8207, 18.6076}, CountryId{"IN"}}, // Kasarwadi railway station
    {Coordinate{73.0794, 18.6406}, CountryId{"IN"}}, // Kasu railway station
    {Coordinate{80.4005, 23.8334}, CountryId{"IN"}}, // Katni Junction railway station
    {Coordinate{80.0261, 12.8057}, CountryId{"IN"}}, // Kattangulathur railway station
    {Coordinate{88.1236, 23.6398}, CountryId{"IN"}}, // Katwa Junction railway station
    {Coordinate{78.5715, 12.6265}, CountryId{"IN"}}, // Kettandapatti railway station
    {Coordinate{13.62, 53.925}, CountryId{"DE"}}, // Klein Bünzow railway station
    {Coordinate{75.8805, 25.2236}, CountryId{"IN"}}, // Kota Junction railway station
    {Coordinate{7.21349, 45.7066}, CountryId{"IT"}}, // Villeneuve railway halt
    {Coordinate{7.90852, 46.3014}, CountryId{"CH"}}, // Lalden railway station
    {Coordinate{94.3082, 26.6524}, CountryId{"IN"}}, // Mariani Junction railway station
    {Coordinate{16.3847, 48.2063}, CountryId{"AT"}}, // Landstraße (Vienna U-Bahn)
    {Coordinate{9.70713, 46.8193}, CountryId{"CH"}}, // Langwies GR railway station
    {Coordinate{95.828, 27.321}, CountryId{"IN"}}, // Lekhapani railway station
    {Coordinate{8.91056, 52.0208}, CountryId{"DE"}}, // Lemgo-Lüttfeld railway station
    {Coordinate{88.3392, 22.6207}, CountryId{"IN"}}, // Liluah railway station
    {Coordinate{93.1767, 25.7502}, CountryId{"IN"}}, // Lumding Junction railway station
    {Coordinate{9.61333, 46.8317}, CountryId{"CH"}}, // Lüen-Castiel railway station
    {Coordinate{86.8695, 23.6269}, CountryId{"IN"}}, // Madhukunda railway station
    {Coordinate{76.9429, 10.9009}, CountryId{"IN"}}, // Madukkarai railway station
    {Coordinate{79.0348, 27.2165}, CountryId{"IN"}}, // Mainpuri railway station
    {Coordinate{95.441, 27.4857}, CountryId{"IN"}}, // Makum railway station
    {Coordinate{73.4806, 18.7438}, CountryId{"IN"}}, // Malavli railway station
    {Coordinate{74.4383, 20.2499}, CountryId{"IN"}}, // Manmad Junction railway station
    {Coordinate{80.0199, 12.7966}, CountryId{"IN"}}, // Maraimalai Nagar railway station
    {Coordinate{7.27056, 53.5208}, CountryId{"DE"}}, // Marienhafe station
    {Coordinate{88.0427, 23.1351}, CountryId{"IN"}}, // Masagram junction railway station
    {Coordinate{77.6731, 27.4801}, CountryId{"IN"}}, // Mathura Junction railway station
    {Coordinate{79.6287, 11.0952}, CountryId{"IN"}}, // Mayiladuthurai Junction railway station
    {Coordinate{8.27545, 47.4279}, CountryId{"CH"}}, // Mellingen Heitersberg railway station
    {Coordinate{80.2602, 13.282}, CountryId{"IN"}}, // Minjur railway station
    {Coordinate{82.5699, 25.1343}, CountryId{"IN"}}, // Mirzapur railway station
    {Coordinate{9.08121, 47.0101}, CountryId{"CH"}}, // Mitlödi railway station
    {Coordinate{59.3831, 56.2208}, CountryId{"RU"}}, // Araslanovo (railroad station in p.Araslanovo)
    {Coordinate{70.8293, 22.8253}, CountryId{"IN"}}, // Morbi railway station
    {Coordinate{-76.5028, 40.1087}, CountryId{"US"}}, // Mount Joy
    {Coordinate{76.2078, 10.5969}, CountryId{"IN"}}, // Mulankunnathukavu railway station
    {Coordinate{76.2714, 10.7058}, CountryId{"IN"}}, // Mullurkara railway station
    {Coordinate{11.7858, 48.3537}, CountryId{"DE"}}, // Munich Airport Terminal station
    {Coordinate{86.8093, 23.5931}, CountryId{"IN"}}, // Muradi railway station
    {Coordinate{77.3547, 20.7361}, CountryId{"IN"}}, // Murtajapur railway station
    {Coordinate{2.32556, 48.8606}, CountryId{"FR"}}, // Musée d'Orsay
    {Coordinate{8.23507, 47.4145}, CountryId{"CH"}}, // Mägenwil railway station
    {Coordinate{7.69077, 46.6385}, CountryId{"CH"}}, // Mülenen railway station
    {Coordinate{87.8681, 24.5906}, CountryId{"IN"}}, // Nagarnabi railway station
    {Coordinate{73.1408, 18.5399}, CountryId{"IN"}}, // Nagothane railway station
    {Coordinate{88.4175, 22.8871}, CountryId{"IN"}}, // Naihati Junction railway station
    {Coordinate{91.4403, 26.4506}, CountryId{"IN"}}, // Nalbari railway station
    {Coordinate{79.2834, 17.0612}, CountryId{"IN"}}, // Nalgonda railway station
    {Coordinate{73.8419, 19.9476}, CountryId{"IN"}}, // Nasik Road railway station
    {Coordinate{14.546, 52.3223}, CountryId{"DE"}}, // Frankfurt (Oder)-Neuberesinchen
    {Coordinate{13.9033, 53.4417}, CountryId{"DE"}}, // Nechlin railway station
    {Coordinate{76.276, 10.3924}, CountryId{"IN"}}, // Nellayi railway station
    {Coordinate{79.9894, 14.4606}, CountryId{"IN"}}, // Nellore railway station
    {Coordinate{11.3918, 47.2141}, CountryId{"AT"}}, // Unterberg-Stefansbrücke railway station
    {Coordinate{}, CountryId{"AT"}}, // Rum railway station
    {Coordinate{73.319, 19.0271}, CountryId{"IN"}}, // Neral railway station
    {Coordinate{73.0181, 19.0336}, CountryId{"IN"}}, // Nerul railway station
    {Coordinate{86.1482, 23.8731}, CountryId{"IN"}}, // Netaji Subhas Chandra Bose Gomoh railway station
    {Coordinate{9.05944, 47.0645}, CountryId{"CH"}}, // Netstal railway station
    {Coordinate{9.78722, 53.4728}, CountryId{"DE"}}, // Neu Wulmstorf station
    {Coordinate{8.02207, 51.8017}, CountryId{"DE"}}, // Neubeckum station
    {Coordinate{8.33131, 47.4504}, CountryId{"CH"}}, // Neuenhof railway station
    {Coordinate{14.2139, 51.0211}, CountryId{"DE"}}, // Neustadt (Sachs) railway station
    {Coordinate{9.455, 52.5028}, CountryId{"DE"}}, // Neustadt am Rübenberge station
    {Coordinate{90.5368, 26.4758}, CountryId{"IN"}}, // New Bongaigaon Junction railway station
    {Coordinate{80.4205, 23.8136}, CountryId{"IN"}}, // New Katni Junction railway station
    {Coordinate{88.8228, 26.5784}, CountryId{"IN"}}, // New Maynaguri railway station
    {Coordinate{-3.472, 50.7023}, CountryId{"GB"}}, // Newcourt railway station, Exeter
    {Coordinate{-3.06884, 55.8671}, CountryId{"GB"}}, // Newtongrange railway station
    {Coordinate{77.0811, 8.41041}, CountryId{"IN"}}, // Neyyattinkara railway station
    {Coordinate{73.1066, 18.4722}, CountryId{"IN"}}, // Nidi railway station
    {Coordinate{9.06239, 47.1224}, CountryId{"CH"}}, // Nieder- and Oberurnen railway station
    {Coordinate{73.0799, 19.1551}, CountryId{"IN"}}, // Nilaje railway station
    {Coordinate{86.0762, 23.9321}, CountryId{"IN"}}, // Nimiaghat railway station
    {Coordinate{74.0795, 20.0966}, CountryId{"IN"}}, // Niphad railway station
    {Coordinate{7.54, 44.938}, CountryId{"IT"}}, // None railway station
    {Coordinate{9.06996, 47.0987}, CountryId{"CH"}}, // Näfels-Mollis railway station
    {Coordinate{7.03056, 49.3044}, CountryId{"DE"}}, // Fischbach-Camphausen
    {Coordinate{6.95667, 49.2419}, CountryId{"DE"}}, // Saarbrücken-Burbach
    {Coordinate{7.00444, 49.2653}, CountryId{"DE"}}, // Jägersfreude
    {Coordinate{8.81047, 53.2834}, CountryId{"DE"}}, // Oldenbüttel station
    {Coordinate{-0.0172194, 51.5077}, CountryId{"GB"}}, // Poplar
    {Coordinate{8.21478, 47.4074}, CountryId{"CH"}}, // Othmarsingen railway station
    {Coordinate{83.9826, 26.8977}, CountryId{"IN"}}, // Padrauna railway station
    {Coordinate{87.743, 22.3931}, CountryId{"IN"}}, // Panskura Junction railway station
    {Coordinate{79.9837, 12.7302}, CountryId{"IN"}}, // Paranur railway station
    {Coordinate{83.4337, 18.7839}, CountryId{"IN"}}, // Parvathipuram Town railway station
    {Coordinate{85.0685, 25.6214}, CountryId{"IN"}}, // Patliputra Junction railway station
    {Coordinate{85.1368, 25.6026}, CountryId{"IN"}}, // Patna Junction railway station
    {Coordinate{9.67162, 46.8295}, CountryId{"CH"}}, // Peist railway station
    {Coordinate{73.0868, 18.7356}, CountryId{"IN"}}, // Pen railway station
    {Coordinate{7.3485, 44.8917}, CountryId{"IT"}}, // Pinerolo Olimpica railway station
    {Coordinate{7.4255, 44.9217}, CountryId{"IT"}}, // Piscina di Pinerolo railway station
    {Coordinate{77.0013, 10.6531}, CountryId{"IN"}}, // Pollachi Junction railway station
    {Coordinate{80.1988, 13.3323}, CountryId{"IN"}}, // Ponneri railway station
    {Coordinate{69.6155, 21.6436}, CountryId{"IN"}}, // Porbandar railway station
    {Coordinate{80.0369, 12.8209}, CountryId{"IN"}}, // Potheri railway station
    {Coordinate{76.2609, 10.4207}, CountryId{"IN"}}, // Pudukad railway station
    {Coordinate{78.3181, 20.7267}, CountryId{"IN"}}, // Pulgaon railway station
    {Coordinate{79.9371, 13.1229}, CountryId{"IN"}}, // Putlur railway station
    {Coordinate{77.9966, 27.1938}, CountryId{"IN"}}, // Raja ki Mandi railway station
    {Coordinate{87.8678, 24.545}, CountryId{"IN"}}, // Rajgram railway station
    {Coordinate{79.3068, 9.28097}, CountryId{"IN"}}, // Rameswaram railway station
    {Coordinate{86.7623, 23.5799}, CountryId{"IN"}}, // Ramkanali Junction railway station
    {Coordinate{88.5688, 23.1741}, CountryId{"IN"}}, // Ranaghat Junction railway station
    {Coordinate{91.6059, 26.4479}, CountryId{"IN"}}, // Rangiya railway station
    {Coordinate{87.1174, 23.6037}, CountryId{"IN"}}, // Raniganj railway station
    {Coordinate{73.1519, 18.894}, CountryId{"IN"}}, // Rasayani railway station
    {Coordinate{7.69077, 46.6249}, CountryId{"CH"}}, // Reichenbach im Kandertal railway station
    {Coordinate{80.8287, 16.0198}, CountryId{"IN"}}, // Repalle railway station
    {Coordinate{8.71208, 47.1968}, CountryId{"CH"}}, // Riedmatt railway station
    {Coordinate{73.1236, 18.4465}, CountryId{"IN"}}, // Roha railway station
    {Coordinate{87.9693, 23.2071}, CountryId{"IN"}}, // Saktigarh railway station
    {Coordinate{70.5034, 23.3098}, CountryId{"IN"}}, // Samakhiali Junction railway station
    {Coordinate{7.7822, 45.2186}, CountryId{"IT"}}, // San Benigno Canavese railway station
    {Coordinate{9.65384, 46.8292}, CountryId{"CH"}}, // St. Peter-Molinis railway station
    {Coordinate{76.3562, 26.0183}, CountryId{"IN"}}, // Sawai Madhopur railway station
    {Coordinate{10.2299, 50.0406}, CountryId{"DE"}}, // Schweinfurt Mitte station
    {Coordinate{24.6171, 56.8082}, CountryId{"LV"}}, // Pārogre Station
    {Coordinate{88.3284, 22.7748}, CountryId{"IN"}}, // Seoraphuli Junction railway station
    {Coordinate{78.575, 27.0857}, CountryId{"IN"}}, // Shikohabad railway station
    {Coordinate{80.0011, 12.7625}, CountryId{"IN"}}, // Singaperumal Koil railway station
    {Coordinate{7.045, 49.1431}, CountryId{"DE"}}, // Auersmacher
    {Coordinate{7.03472, 49.1794}, CountryId{"DE"}}, // Bübingen
    {Coordinate{7.03083, 49.1975}, CountryId{"DE"}}, // Güdingen
    {Coordinate{7.04917, 49.2278}, CountryId{"DE"}}, // Schafbrücke
    {Coordinate{}, CountryId{"DE"}}, // Schweighofen
    {Coordinate{70.4083, 20.8961}, CountryId{"IN"}}, // Somnath railway station
    {Coordinate{73.1455, 18.9522}, CountryId{"IN"}}, // Somtane railway station
    {Coordinate{8.00701, 48.5925}, CountryId{"DE"}}, // Renchen station
    {Coordinate{8.01043, 48.4047}, CountryId{"DE"}}, // Gengenbach station
    {Coordinate{7.62816, 47.8553}, CountryId{"DE"}}, // Buggingen station
    {Coordinate{7.56894, 47.7616}, CountryId{"DE"}}, // Schliengen station
    {Coordinate{7.05765, 47.4398}, CountryId{"CH"}}, // Courchavon railway station
    {Coordinate{7.12833, 47.4241}, CountryId{"CH"}}, // Alle railway station
    {Coordinate{7.01656, 47.4926}, CountryId{"CH"}}, // Boncourt railway station
    {Coordinate{6.47939, 46.9053}, CountryId{"CH"}}, // Les Verrières
    {Coordinate{}, CountryId{"FR"}}, // Feignies railway station
    {Coordinate{12.5382, 56.075}, CountryId{"DK"}}, // Ålsgårde station
    {Coordinate{8.29229, 55.6538}, CountryId{"DK"}}, // Vrøgum railway station
    {Coordinate{8.80203, 55.0094}, CountryId{"DK"}}, // Visby Station
    {Coordinate{10.1594, 56.1219}, CountryId{"DK"}}, // Viby J station
    {Coordinate{8.57928, 55.4665}, CountryId{"DK"}}, // Tjæreborg Station
    {Coordinate{8.3058, 56.1953}, CountryId{"DK"}}, // Tim railway station
    {Coordinate{9.73958, 47.5029}, CountryId{"AT"}}, // Bregenz railway station
    {Coordinate{8.00294, 49.4143}, CountryId{"DE"}}, // Weidenthal station
    {Coordinate{7.80615, 49.1024}, CountryId{"DE"}}, // Bundenthal-Rumbach railway station
    {Coordinate{8.12722, 49.2839}, CountryId{"DE"}}, // Bahnhof Edenkoben
    {Coordinate{4.87111, 46.3922}, CountryId{"FR"}}, // Gare de Senozan
    {Coordinate{4.88409, 46.4509}, CountryId{"FR"}}, // Gare de Fleurville - Pont-de-Vaux
    {Coordinate{9.65073, 46.6712}, CountryId{"CH"}}, // Alvaneu railway station
    {Coordinate{7.84079, 49.8067}, CountryId{"DE"}}, // Bahnhof Ebernburg
    {Coordinate{37.3815, 55.6395}, CountryId{"RU"}}, // Novoperedelkino
    {Coordinate{10.4669, 59.8497}, CountryId{"NO"}}, // Vakås Station
    {Coordinate{10.6072, 59.9081}, CountryId{"NO"}}, // Stabekk Station
    {Coordinate{12.4297, 50.8928}, CountryId{"DE"}}, // Gößnitz station
    {Coordinate{6.23055, 50.7643}, CountryId{"DE"}}, // Stolberg-Altstadt railway station
    {Coordinate{16.3949, 48.2465}, CountryId{"AT"}}, // Neue Donau
    {Coordinate{8.07051, 49.5545}, CountryId{"DE"}}, // Bahnhof Eisenberg, Rhineland-Palatinate
    {Coordinate{83.1584, 19.9339}, CountryId{"IN"}}, // Bhawanipatna railway station
    {Coordinate{}, CountryId{"FR"}}, // Q15401642
    {Coordinate{3.63513, 47.5378}, CountryId{"FR"}}, // Gare de Châtel-Censoir
    {Coordinate{3.67473, 47.604}, CountryId{"FR"}}, // Gare de Mailly-la-Ville et PN 41
    {Coordinate{12.4587, 52.4996}, CountryId{"DE"}}, // Pritzerbe station
    {Coordinate{11.94, 48.0433}, CountryId{"DE"}}, // Grafing Bahnhof
    {Coordinate{78.1554, 8.80611}, CountryId{"IN"}}, // Thoothukudi railway station
    {Coordinate{15.4484, 47.0538}, CountryId{"AT"}}, // Graz Ostbahnhof-Messe
    {Coordinate{13.5204, 51.2963}, CountryId{"DE"}}, // Großenhain Berliner Bahnhof
    {Coordinate{11.5309, 48.0711}, CountryId{"DE"}}, // Großhesselohe Isartalbahnhof
    {Coordinate{14.1085, 59.3165}, CountryId{"SE"}}, // Kristinehamn station
    {Coordinate{7.75058, 49.1975}, CountryId{"DE"}}, // Hinterweidenthal Ort station
    {Coordinate{13.3164, 59.505}, CountryId{"SE"}}, // Kil railway station
    {Coordinate{12.5198, 48.248}, CountryId{"DE"}}, // Mühldorf (Oberbay) station
    {Coordinate{13.2476, 51.5833}, CountryId{"DE"}}, // Falkenberg (Elster) station
    {Coordinate{17.1666, 49.4417}, CountryId{"CZ"}}, // Bedihošť
    {Coordinate{30.7711, 50.4125}, CountryId{"UA"}}, // Imeni Heorhiya Kirpy
    {Coordinate{14.4694, 50.1267}, CountryId{"CZ"}}, // Ládví
    {Coordinate{17.5328, 59.5689}, CountryId{"SE"}}, // Bålsta railway station
    {Coordinate{13.6559, 51.1031}, CountryId{"DE"}}, // Radebeul-Weintraube station
    {Coordinate{79.3161, 11.535}, CountryId{"IN"}}, // Vriddhachalam railway station
    {Coordinate{6.09389, 46.2207}, CountryId{"CH"}}, // Vernier railway station
    {Coordinate{6.0769, 46.2223}, CountryId{"CH"}}, // Meyrin railway station
    {Coordinate{6.06599, 46.2212}, CountryId{"CH"}}, // Zimeysa railway station
    {Coordinate{13.0709, 42.41}, CountryId{"IT"}}, // Antrodoco-Borgo Velino railway station
    {Coordinate{13.0763, 42.4154}, CountryId{"IT"}}, // Antrodoco Centro railway halt
    {Coordinate{13.096, 42.398}, CountryId{"IT"}}, // Rocca di Fondi railway station
    {Coordinate{13.1443, 42.3884}, CountryId{"IT"}}, // Rocca di Corno train station
    {Coordinate{13.19, 42.3606}, CountryId{"IT"}}, // Sella di Corno railway station
    {Coordinate{13.5629, 42.2507}, CountryId{"IT"}}, // Fagnano-Campana railway station
    {Coordinate{13.6044, 42.2228}, CountryId{"IT"}}, // Q15617152
    {Coordinate{13.642, 42.2049}, CountryId{"IT"}}, // Q15617153
    {Coordinate{13.6609, 42.1974}, CountryId{"IT"}}, // Beffi railway station
    {Coordinate{13.8091, 42.0981}, CountryId{"IT"}}, // Raiano railway station
    {Coordinate{13.7397, 42.1436}, CountryId{"IT"}}, // Molina-Castelvecchio Subequo railway station
    {Coordinate{13.8719, 42.0804}, CountryId{"IT"}}, // Pratola Peligna Superiore railway station
    {Coordinate{13.7111, 42.1767}, CountryId{"IT"}}, // Acciano railway station
    {Coordinate{10.6475, 45.1443}, CountryId{"IT"}}, // Castellucchio railway station
    {Coordinate{10.6043, 45.1298}, CountryId{"IT"}}, // Ospitaletto Mantovano railway halt
    {Coordinate{10.5735, 45.1225}, CountryId{"IT"}}, // San Michele in Bosco railway halt
    {Coordinate{10.5337, 45.1244}, CountryId{"IT"}}, // Marcaria railway station
    {Coordinate{14.25, 51.4333}, CountryId{"DE"}}, // Hoyerswerda railway station
    {Coordinate{7.05539, 49.2994}, CountryId{"DE"}}, // Sulzbach (Saar) station
    {Coordinate{12.3753, 51.3355}, CountryId{"DE"}}, // Leipzig Wilhelm-Leuschner-Platz railway station
    {Coordinate{11.189, 54.4436}, CountryId{"DE"}}, // Fehmarn-Burg station
    {Coordinate{76.5803, 9.39215}, CountryId{"IN"}}, // Tiruvalla railway station
    {Coordinate{9.59089, 47.4669}, CountryId{"CH"}}, // Rheineck railway station
    {Coordinate{9.50512, 47.478}, CountryId{"CH"}}, // Rorschach railway station
    {Coordinate{9.63824, 47.4532}, CountryId{"CH"}}, // St. Margrethen railway station
    {Coordinate{14.0922, 51.2739}, CountryId{"DE"}}, // Kamenz railway station
    {Coordinate{74.858, 31.6315}, CountryId{"IN"}}, // Amritsar railway station
    {Coordinate{80.8603, 26.8471}, CountryId{"IN"}}, // Alamnagar railway station
    {Coordinate{80.9096, 26.8374}, CountryId{"IN"}}, // Aishbagh junction railway station
    {Coordinate{77.187, 28.5821}, CountryId{"IN"}}, // Delhi Safdarjung railway station
    {Coordinate{39.9743, 43.412}, CountryId{"RU"}}, // Olympic Park
    {Coordinate{8.74647, 49.179}, CountryId{"DE"}}, // Odenheim train station
    {Coordinate{73.3166, 28.0141}, CountryId{"IN"}}, // Bikaner Junction railway station
    {Coordinate{25.1783, 54.63}, CountryId{"LT"}}, // Paneriai railway station
    {Coordinate{77.8097, 16.2251}, CountryId{"IN"}}, // Gadwal railway station
    {Coordinate{14.4489, 50.0642}, CountryId{"CZ"}}, // Praha-Vršovice railway station
    {Coordinate{78.0416, 15.9157}, CountryId{"IN"}}, // Jogulamba Halt railway station
    {Coordinate{17.7759, 48.4417}, CountryId{"SK"}}, // Leopoldov zastávka
    {Coordinate{17.7585, 48.4417}, CountryId{"SK"}}, // Leopoldov station
    {Coordinate{82.7246, 17.4529}, CountryId{"IN"}}, // Narsipatnam Road railway station
    {Coordinate{24.8453, 48.7364}, CountryId{"UA"}}, // Otynia
    {Coordinate{25.9303, 48.3014}, CountryId{"UA"}}, // Chernivtsi Railway Station
    {Coordinate{8.191, 53.2446}, CountryId{"DE"}}, // Rastede railway station
    {Coordinate{8.14995, 53.399}, CountryId{"DE"}}, // Varel railway station
    {Coordinate{8.03183, 53.4899}, CountryId{"DE"}}, // Sande railway station
    {Coordinate{8.1149, 53.5188}, CountryId{"DE"}}, // Wilhelmshaven railway station
    {Coordinate{8.33681, 53.1182}, CountryId{"DE"}}, // Wüsting railway station
    {Coordinate{8.6799, 53.0571}, CountryId{"DE"}}, // Heidkrug railway station
    {Coordinate{8.5329, 53.0991}, CountryId{"DE"}}, // Bookholzberg railway station
    {Coordinate{8.5786, 53.085}, CountryId{"DE"}}, // Schierbrok railway station
    {Coordinate{8.5989, 53.0695}, CountryId{"DE"}}, // Hoykenkamp railway station
    {Coordinate{11.3677, 44.5777}, CountryId{"IT"}}, // Castelmaggiore railway station
    {Coordinate{11.3789, 44.6467}, CountryId{"IT"}}, // San Giorgio di Piano railway station
    {Coordinate{11.4046, 44.698}, CountryId{"IT"}}, // San Pietro in Casale railway station
    {Coordinate{11.4417, 44.7377}, CountryId{"IT"}}, // Galliera railway station
    {Coordinate{11.5439, 44.7958}, CountryId{"IT"}}, // Coronella railway station
    {Coordinate{10.9779, 44.1558}, CountryId{"IT"}}, // Porretta Terme railway station
    {Coordinate{10.9807, 44.1776}, CountryId{"IT"}}, // Silla railway station
    {Coordinate{11.0535, 44.23}, CountryId{"IT"}}, // Riola railway station
    {Coordinate{11.1141, 44.2828}, CountryId{"IT"}}, // Vergato railway station
    {Coordinate{11.1618, 44.3106}, CountryId{"IT"}}, // Pioppe di Salvaro railway station
    {Coordinate{41.4461, 56.3897}, CountryId{"RU"}}, // Q15714625
    {Coordinate{11.5171, 50.3572}, CountryId{"DE"}}, // Dürrenwaid railway station
    {Coordinate{7.59, 50.3575}, CountryId{"DE"}}, // Koblenz Stadtmitte station
    {Coordinate{10.6981, 53.8022}, CountryId{"DE"}}, // Lübeck-Flughafen station
    {Coordinate{7.01861, 49.2303}, CountryId{"DE"}}, // Saarbrücken-Ost station
    {Coordinate{13.6619, 51.1061}, CountryId{"DE"}}, // Weißes Roß
    {Coordinate{16.3064, 48.1982}, CountryId{"AT"}}, // Wien Breitensee railway station
    {Coordinate{16.329, 48.2313}, CountryId{"AT"}}, // Wien Gersthof
    {Coordinate{16.3411, 48.2401}, CountryId{"AT"}}, // Wien Krottenbachstraße railway station
    {Coordinate{16.3587, 48.1802}, CountryId{"AT"}}, // Wien Matzleinsdorfer Platz railway station
    {Coordinate{16.3443, 48.2444}, CountryId{"AT"}}, // Wien Oberdöbling railway station
    {Coordinate{16.3818, 48.188}, CountryId{"AT"}}, // Wien Quartier Belvedere train station
    {Coordinate{16.3834, 48.2348}, CountryId{"AT"}}, // Wien Traisengasse railway station
    {Coordinate{12.3864, 51.3008}, CountryId{"DE"}}, // Leipzig-Connewitz railway station
    {Coordinate{14.201, 50.7735}, CountryId{"CZ"}}, // Děčín hlavní nádraží
    {Coordinate{14.8872, 50.4073}, CountryId{"CZ"}}, // Mladá Boleslav Main Station
    {Coordinate{14.5333, 50.6752}, CountryId{"CZ"}}, // Česká Lípa hlavní nádraží
    {Coordinate{14.5441, 50.0974}, CountryId{"CZ"}}, // Praha-Kyje
    {Coordinate{23.4447, 54.3611}, CountryId{"LT"}}, // Šeštokai
    {Coordinate{9.46722, 51.23}, CountryId{"DE"}}, // Baunatal-Guntershausen
    {Coordinate{7.28184, 49.2619}, CountryId{"DE"}}, // Bahnhof Bierbach
    {Coordinate{7.77131, 49.1547}, CountryId{"DE"}}, // Dahn railway station
    {Coordinate{8.10822, 49.564}, CountryId{"DE"}}, // Bahnhof Ebertsheim
    {Coordinate{7.45633, 49.4948}, CountryId{"DE"}}, // Q15785166
    {Coordinate{13.5184, 51.4722}, CountryId{"DE"}}, // Elsterwerda-Biehla station
    {Coordinate{8.21066, 49.4884}, CountryId{"DE"}}, // Erpolzheim station
    {Coordinate{7.96985, 49.439}, CountryId{"DE"}}, // Frankenstein (Pfalz) station
    {Coordinate{9.59564, 49.6981}, CountryId{"DE"}}, // Bahnhof Gamburg
    {Coordinate{11.5014, 47.2769}, CountryId{"AT"}}, // Hall in Tirol railway station
    {Coordinate{8.67521, 49.3799}, CountryId{"DE"}}, // Heidelberg-Kirchheim/Rohrbach station
    {Coordinate{8.72357, 48.4823}, CountryId{"DE"}}, // Bahnhof Hochdorf (b Horb)
    {Coordinate{7.74978, 49.4475}, CountryId{"DE"}}, // Bahnhof Kaiserslautern West
    {Coordinate{7.83509, 48.3403}, CountryId{"DE"}}, // Lahr (Schwarzw) station
    {Coordinate{7.56602, 49.4163}, CountryId{"DE"}}, // Landstuhl station
    {Coordinate{9.14595, 49.0764}, CountryId{"DE"}}, // Bahnhof Lauffen
    {Coordinate{8.13336, 50.3776}, CountryId{"DE"}}, // Lindenholzhausen station
    {Coordinate{8.84145, 49.4048}, CountryId{"DE"}}, // Bahnhof Neckarsteinach
    {Coordinate{8.16125, 50.3593}, CountryId{"DE"}}, // Niederbrechen station
    {Coordinate{8.18806, 50.3546}, CountryId{"DE"}}, // Oberbrechen station
    {Coordinate{7.70987, 47.285}, CountryId{"CH"}}, // Oensingen railway station
    {Coordinate{13.0786, 47.7888}, CountryId{"AT"}}, // Aigen train station
    {Coordinate{10.1739, 51.8875}, CountryId{"DE"}}, // Seesen station
    {Coordinate{11.0484, 48.0945}, CountryId{"DE"}}, // St. Ottilien station
    {Coordinate{7.16564, 49.467}, CountryId{"DE"}}, // St. Wendel station
    {Coordinate{10.5627, 51.9552}, CountryId{"DE"}}, // Vienenburg station
    {Coordinate{26.3108, 56.1844}, CountryId{"LV"}}, // Sergunta
    {Coordinate{26.478, 55.9338}, CountryId{"LV"}}, // 383. kilometers
    {Coordinate{26.4997, 55.8954}, CountryId{"LV"}}, // 387. kilometers
    {Coordinate{8.78281, 48.4798}, CountryId{"DE"}}, // Eutingen im Gäu station
    {Coordinate{8.1813, 49.5372}, CountryId{"DE"}}, // Bahnhof Kirchheim
    {Coordinate{9.73397, 49.1082}, CountryId{"DE"}}, // Schwäbisch Hall station
    {Coordinate{9.36794, 49.5783}, CountryId{"DE"}}, // Q15792337
    {Coordinate{24.2532, 56.883}, CountryId{"LV"}}, // Rumbula Station
    {Coordinate{24.3242, 56.8644}, CountryId{"LV"}}, // Dole
    {Coordinate{24.4367, 56.8496}, CountryId{"LV"}}, // Saulkalne
    {Coordinate{24.6536, 56.7821}, CountryId{"LV"}}, // Ciemupe
    {Coordinate{25.206, 56.6311}, CountryId{"LV"}}, // Muldakmens
    {Coordinate{14.3979, 52.3369}, CountryId{"DE"}}, // Pillgram
    {Coordinate{14.2814, 52.3464}, CountryId{"DE"}}, // Briesen (Mark) station
    {Coordinate{14.1653, 52.3571}, CountryId{"DE"}}, // Berkenbrück station
    {Coordinate{13.922, 52.4}, CountryId{"DE"}}, // Hangelsberg station
    {Coordinate{13.8716, 53.5283}, CountryId{"DE"}}, // Blumenhagen
    {Coordinate{14.1544, 53.1851}, CountryId{"DE"}}, // Schönow (Kr Uckermark)
    {Coordinate{14.2528, 53.24}, CountryId{"DE"}}, // Petershagen
    {Coordinate{14.148, 53.9529}, CountryId{"DE"}}, // Heringsdorf Neuhof railway station
    {Coordinate{13.694, 52.7746}, CountryId{"DE"}}, // Melchow
    {Coordinate{13.9287, 52.8307}, CountryId{"DE"}}, // Niederfinow
    {Coordinate{13.6752, 52.7558}, CountryId{"DE"}}, // Biesenthal
    {Coordinate{30.6058, 46.5247}, CountryId{"UA"}}, // Usatove
    {Coordinate{29.5361, 45.9889}, CountryId{"UA"}}, // Hnadental
    {Coordinate{10.9025, 47.8123}, CountryId{"DE"}}, // Schongau station
    {Coordinate{6.12495, 46.1859}, CountryId{"CH"}}, // Lancy-Pont-Rouge railway station
    {Coordinate{12.3791, 51.2501}, CountryId{"DE"}}, // Markkleeberg-Gaschwitz railway station
    {Coordinate{12.3763, 51.2627}, CountryId{"DE"}}, // Markkleeberg-Großstädteln railway station
    {Coordinate{11.2729, 43.3856}, CountryId{"IT"}}, // Badesse
    {Coordinate{11.4063, 43.2944}, CountryId{"IT"}}, // Arbia railway station
    {Coordinate{12.3663, 51.367}, CountryId{"DE"}}, // Leipzig Coppiplatz railway station
    {Coordinate{8.56693, 44.3568}, CountryId{"IT"}}, // Varazze railway station
    {Coordinate{2.8411, 50.3352}, CountryId{"FR"}}, // Gare de Bailleul-Sir-Berthoult
    {Coordinate{-93.0861, 44.9478}, CountryId{"US"}}, // Saint Paul Union Depot
    {Coordinate{13.1138, 59.3531}, CountryId{"SE"}}, // Grums railway station
    {Coordinate{12.4648, 58.7019}, CountryId{"SE"}}, // Mellerud railway station
    {Coordinate{14.5588, 61.0088}, CountryId{"SE"}}, // Mora Station
    {Coordinate{8.15941, 49.355}, CountryId{"DE"}}, // Neustadt (Weinstr) Böbig station
    {Coordinate{15.0186, 60.8182}, CountryId{"SE"}}, // Tällberg station
    {Coordinate{14.5989, 49.4458}, CountryId{"CZ"}}, // Q15886695
    {Coordinate{15.3983, 49.3175}, CountryId{"CZ"}}, // Batelov
    {Coordinate{14.4777, 49.3}, CountryId{"CZ"}}, // Bechyně railway station
    {Coordinate{15.0911, 49.1397}, CountryId{"CZ"}}, // Blažejov (train station)
    {Coordinate{13.5314, 49.5808}, CountryId{"CZ"}}, // Blovice railway station
    {Coordinate{14.6425, 48.8911}, CountryId{"CZ"}}, // Borovany (train station)
    {Coordinate{14.4442, 48.9269}, CountryId{"CZ"}}, // Boršov nad Vltavou (train station)
    {Coordinate{14.4925, 49.4475}, CountryId{"CZ"}}, // Q15886733
    {Coordinate{14.3456, 49.4025}, CountryId{"CZ"}}, // Q15886735
    {Coordinate{14.6666, 49.7415}, CountryId{"CZ"}}, // Bystřice u Benešova
    {Coordinate{12.843, 50.8156}, CountryId{"DE"}}, // Bahnhof Chemnitz-Siegmar
    {Coordinate{14.8681, 48.9503}, CountryId{"CZ"}}, // Majdalena
    {Coordinate{14.6689, 49.4736}, CountryId{"CZ"}}, // Q15886755
    {Coordinate{14.5292, 49.0783}, CountryId{"CZ"}}, // Chotýčany
    {Coordinate{14.9839, 49.3419}, CountryId{"CZ"}}, // Chválkov
    {Coordinate{14.8108, 49.4153}, CountryId{"CZ"}}, // Q15886763
    {Coordinate{15.6417, 49.4783}, CountryId{"CZ"}}, // Dobronín
    {Coordinate{14.7994, 49.2081}, CountryId{"CZ"}}, // Q15886782
    {Coordinate{14.6292, 49.1467}, CountryId{"CZ"}}, // Q15886785
    {Coordinate{14.3008, 49.1061}, CountryId{"CZ"}}, // Q15886787
    {Coordinate{14.5834, 49.6031}, CountryId{"CZ"}}, // Heřmaničky
    {Coordinate{14.42, 49.0325}, CountryId{"CZ"}}, // Hluboká nad Vltavou railway station
    {Coordinate{15.3244, 49.3108}, CountryId{"CZ"}}, // Horní Cerekev
    {Coordinate{14.0261, 48.7647}, CountryId{"CZ"}}, // Horní Planá
    {Coordinate{14.6661, 49.1672}, CountryId{"CZ"}}, // Q15886815
    {Coordinate{14.1828, 48.7714}, CountryId{"CZ"}}, // Q15886817
    {Coordinate{15.0789, 49.1819}, CountryId{"CZ"}}, // Q15886831
    {Coordinate{14.6072, 49.5769}, CountryId{"CZ"}}, // Q15886839
    {Coordinate{15.5995, 49.4147}, CountryId{"CZ"}}, // Jihlava railway station
    {Coordinate{15.2947, 49.2525}, CountryId{"CZ"}}, // Jihlávka
    {Coordinate{15.0042, 49.155}, CountryId{"CZ"}}, // Jindřichův Hradec
    {Coordinate{14.7044, 48.8772}, CountryId{"CZ"}}, // Q15886848
    {Coordinate{15.0744, 49.295}, CountryId{"CZ"}}, // Kamenice nad Lipou
    {Coordinate{14.8605, 49.1836}, CountryId{"CZ"}}, // Kardašova Řečice
    {Coordinate{13.8233, 49.2692}, CountryId{"CZ"}}, // Q15886855
    {Coordinate{14.4797, 49.6592}, CountryId{"CZ"}}, // Kosova Hora
    {Coordinate{9.5991, 47.594}, CountryId{"DE"}}, // Kressbronn
    {Coordinate{14.2658, 48.8128}, CountryId{"CZ"}}, // Kájov
    {Coordinate{14.3313, 48.9046}, CountryId{"CZ"}}, // Křemže
    {Coordinate{14.7297, 49.0911}, CountryId{"CZ"}}, // Q15886904
    {Coordinate{15.0506, 49.2014}, CountryId{"CZ"}}, // Q15886906
    {Coordinate{14.5853, 49.3594}, CountryId{"CZ"}}, // Q15886917
    {Coordinate{14.3775, 49.4417}, CountryId{"CZ"}}, // Q15886927
    {Coordinate{13.6083, 49.4975}, CountryId{"CZ"}}, // Nepomuk
    {Coordinate{13.5164, 49.6422}, CountryId{"CZ"}}, // Nezvěstice station
    {Coordinate{15.1108, 49.0189}, CountryId{"CZ"}}, // Nová Bystřice
    {Coordinate{15.1175, 49.4256}, CountryId{"CZ"}}, // Q15886945
    {Coordinate{13.9531, 48.7897}, CountryId{"CZ"}}, // Nová Pec (train station)
    {Coordinate{14.9228, 48.8117}, CountryId{"CZ"}}, // Nová Ves nad Lužnicí
    {Coordinate{15.0664, 49.2369}, CountryId{"CZ"}}, // Q15886952
    {Coordinate{14.8089, 48.8231}, CountryId{"CZ"}}, // Q15886954
    {Coordinate{14.9539, 49.4289}, CountryId{"CZ"}}, // Obrataň
    {Coordinate{14.6241, 49.6668}, CountryId{"CZ"}}, // Olbramovice (train station)
    {Coordinate{15.0172, 49.4599}, CountryId{"CZ"}}, // Q15886973
    {Coordinate{13.6206, 49.3913}, CountryId{"CZ"}}, // Pačejov railway station
    {Coordinate{15.2225, 49.4192}, CountryId{"CZ"}}, // Q15886977
    {Coordinate{14.7058, 49.3539}, CountryId{"CZ"}}, // Q15886983
    {Coordinate{14.1203, 48.7994}, CountryId{"CZ"}}, // Q15886990
    {Coordinate{14.1478, 48.7983}, CountryId{"CZ"}}, // Polná na Šumavě
    {Coordinate{15.1786, 49.2203}, CountryId{"CZ"}}, // Popelín
    {Coordinate{14.7822, 49.7378}, CountryId{"CZ"}}, // Postupice
    {Coordinate{14.2117, 49.2122}, CountryId{"CZ"}}, // Protivín
    {Coordinate{14.1314, 49.2639}, CountryId{"CZ"}}, // Putim
    {Coordinate{14.1428, 49.2964}, CountryId{"CZ"}}, // Písek
    {Coordinate{15.5131, 49.4066}, CountryId{"CZ"}}, // Rantířov (train station)
    {Coordinate{14.1083, 49.2447}, CountryId{"CZ"}}, // Ražice
    {Coordinate{14.7153, 49.2969}, CountryId{"CZ"}}, // Q15887039
    {Coordinate{14.4339, 49.6558}, CountryId{"CZ"}}, // Sedlčany
    {Coordinate{14.7256, 49.2556}, CountryId{"CZ"}}, // Soběslav
    {Coordinate{13.4783, 49.6953}, CountryId{"CZ"}}, // Starý Plzenec station
    {Coordinate{13.9158, 49.2553}, CountryId{"CZ"}}, // Strakonice
    {Coordinate{14.6775, 49.9494}, CountryId{"CZ"}}, // Strančice
    {Coordinate{13.7789, 49.3053}, CountryId{"CZ"}}, // Q15887089
    {Coordinate{14.6216, 49.5384}, CountryId{"CZ"}}, // Střezimíř
    {Coordinate{15.1344, 49.1347}, CountryId{"CZ"}}, // Q15887094
    {Coordinate{14.8825, 48.9022}, CountryId{"CZ"}}, // Q15887096
    {Coordinate{14.5411, 49.295}, CountryId{"CZ"}}, // Q15887098
    {Coordinate{14.6598, 49.5073}, CountryId{"CZ"}}, // Sudoměřice u Tábora
    {Coordinate{14.6553, 49.6989}, CountryId{"CZ"}}, // Q15887116
    {Coordinate{15.0094, 49.7075}, CountryId{"CZ"}}, // Trhový Štěpánov
    {Coordinate{14.7606, 49.0153}, CountryId{"CZ"}}, // Q15887122
    {Coordinate{14.7167, 49.1936}, CountryId{"CZ"}}, // Veselí nad Lužnicí
    {Coordinate{14.2231, 49.3692}, CountryId{"CZ"}}, // Q15887130
    {Coordinate{14.8975, 49.7003}, CountryId{"CZ"}}, // Vlašim
    {Coordinate{14.6196, 49.6379}, CountryId{"CZ"}}, // Votice
    {Coordinate{14.3514, 48.8506}, CountryId{"CZ"}}, // Zlatá Koruna
    {Coordinate{14.3618, 49.0655}, CountryId{"CZ"}}, // Zliv railway station
    {Coordinate{14.2036, 49.3431}, CountryId{"CZ"}}, // Q15887177
    {Coordinate{14.0156, 49.2517}, CountryId{"CZ"}}, // Čejetice
    {Coordinate{14.0867, 48.7428}, CountryId{"CZ"}}, // Q15887182
    {Coordinate{14.7017, 49.8514}, CountryId{"CZ"}}, // Čerčany
    {Coordinate{14.9572, 48.7694}, CountryId{"CZ"}}, // České Velenice
    {Coordinate{14.3172, 48.8222}, CountryId{"CZ"}}, // Český Krumlov train station
    {Coordinate{14.2216, 49.1536}, CountryId{"CZ"}}, // Číčenice station
    {Coordinate{14.6642, 49.9969}, CountryId{"CZ"}}, // Říčany
    {Coordinate{14.5742, 49.0975}, CountryId{"CZ"}}, // Ševětín
    {Coordinate{15.6526, 49.5452}, CountryId{"CZ"}}, // Q15887220
    {Coordinate{14.5169, 49.6667}, CountryId{"CZ"}}, // Q15887224
    {Coordinate{8.35117, 49.0145}, CountryId{"DE"}}, // Bahnhof Karlsruhe-Mühlburg
    {Coordinate{38.035, 48.7153}, CountryId{"UA"}}, // Sil Railway Station
    {Coordinate{16.4261, 48.1542}, CountryId{"AT"}}, // Wien Zentralfriedhof
    {Coordinate{84.8741, 25.5609}, CountryId{"IN"}}, // Bihta railway station
    {Coordinate{8.2831, 45.7163}, CountryId{"IT"}}, // Borgosesia railway station
    {Coordinate{11.6305, 52.1093}, CountryId{"DE"}}, // Bahnhof Magdeburg-Buckau
    {Coordinate{7.5631, 52.0218}, CountryId{"DE"}}, // Münster-Häger
    {Coordinate{7.48186, 52.0515}, CountryId{"DE"}}, // Altenberge
    {Coordinate{7.03005, 52.1836}, CountryId{"DE"}}, // Epe (Westf) railway station
    {Coordinate{7.18419, 52.2016}, CountryId{"DE"}}, // Ochtrup
    {Coordinate{7.37545, 52.1232}, CountryId{"DE"}}, // Steinfurt-Grottenkamp
    {Coordinate{7.39696, 52.1188}, CountryId{"DE"}}, // Steinfurt-Borghorst
    {Coordinate{7.46133, 52.0778}, CountryId{"DE"}}, // Nordwalde station
    {Coordinate{7.78105, 51.9811}, CountryId{"DE"}}, // Telgte
    {Coordinate{7.5282, 51.9146}, CountryId{"DE"}}, // Münster-Albachten
    {Coordinate{7.59895, 51.8841}, CountryId{"DE"}}, // Münster-Amelsbüren
    {Coordinate{7.59877, 51.8171}, CountryId{"DE"}}, // Davensberg
    {Coordinate{7.6892, 51.8446}, CountryId{"DE"}}, // Rinkerode
    {Coordinate{9.0315, 53.0158}, CountryId{"DE"}}, // Achim railway station
    {Coordinate{9.2464, 52.8469}, CountryId{"DE"}}, // Dörverden railway station
    {Coordinate{9.23139, 52.7829}, CountryId{"DE"}}, // Eystrup railway station
    {Coordinate{9.87639, 53.3244}, CountryId{"DE"}}, // Buchholz (Nordheide) railway station
    {Coordinate{9.19497, 52.9779}, CountryId{"DE"}}, // Langwedel railway station
    {Coordinate{9.69877, 52.4585}, CountryId{"DE"}}, // Hannover Flughafen railway station
    {Coordinate{10.1105, 52.3547}, CountryId{"DE"}}, // Hämelerwald station
    {Coordinate{9.8429, 52.2328}, CountryId{"DE"}}, // Sarstedt railway station
    {Coordinate{9.45102, 52.4222}, CountryId{"DE"}}, // Wunstorf station
    {Coordinate{7.88684, 53.2022}, CountryId{"DE"}}, // Westerstede-Ocholt railway station
    {Coordinate{9.7319, 53.2717}, CountryId{"DE"}}, // Tostedt railway station
    {Coordinate{10.359, 52.2579}, CountryId{"DE"}}, // Vechelde station
    {Coordinate{8.25528, 53.0545}, CountryId{"DE"}}, // Sandkrug
    {Coordinate{8.26644, 52.9905}, CountryId{"DE"}}, // Huntlosen
    {Coordinate{8.01466, 53.5074}, CountryId{"DE"}}, // Sanderbusch
    {Coordinate{8.8871, 53.054}, CountryId{"DE"}}, // Bremen-Hemelingen
    {Coordinate{9.08192, 53.0077}, CountryId{"DE"}}, // Baden railway station
    {Coordinate{9.1241, 52.9991}, CountryId{"DE"}}, // Etelsen station
    {Coordinate{7.7496, 44.9204}, CountryId{"IT"}}, // Villastellone railway station
    {Coordinate{8.55138, 44.8648}, CountryId{"IT"}}, // Cantalupo railway station
    {Coordinate{8.85581, 44.8106}, CountryId{"IT"}}, // Villalvernia railway station
    {Coordinate{6.01755, 46.1878}, CountryId{"CH"}}, // Russin railway station
    {Coordinate{8.60862, 46.5275}, CountryId{"CH"}}, // Airolo railway station
    {Coordinate{8.68993, 46.5108}, CountryId{"CH"}}, // Ambrì-Piotta railway station
    {Coordinate{8.69611, 47.1317}, CountryId{"CH"}}, // Altmatt railway station
    {Coordinate{8.66912, 47.0933}, CountryId{"CH"}}, // Biberegg railway station
    {Coordinate{6.51891, 46.6981}, CountryId{"CH"}}, // Arnex railway station
    {Coordinate{7.10623, 46.8169}, CountryId{"CH"}}, // Belfaux CFF railway station
    {Coordinate{7.11023, 46.8227}, CountryId{"CH"}}, // Belfaux-Village railway station
    {Coordinate{6.81169, 46.9297}, CountryId{"CH"}}, // Bevaix railway station
    {Coordinate{6.87771, 46.9796}, CountryId{"CH"}}, // Auvernier railway station
    {Coordinate{7.27249, 47.1447}, CountryId{"CH"}}, // Biel Mett railway station
    {Coordinate{7.42837, 47.1949}, CountryId{"CH"}}, // Bettlach railway station
    {Coordinate{7.50787, 47.2089}, CountryId{"CH"}}, // Bellach railway station
    {Coordinate{8.36559, 47.2468}, CountryId{"CH"}}, // Benzenschwil railway station
    {Coordinate{8.51706, 47.1831}, CountryId{"CH"}}, // Baar Lindenpark railway station
    {Coordinate{7.90822, 47.3203}, CountryId{"CH"}}, // Aarburg-Oftringen railway station
    {Coordinate{9.50522, 47.0103}, CountryId{"CH"}}, // Bad Ragaz railway station
    {Coordinate{9.55651, 47.3742}, CountryId{"CH"}}, // Altstätten SG railway station
    {Coordinate{9.64125, 47.4361}, CountryId{"CH"}}, // Au SG railway station
    {Coordinate{9.43333, 47.5106}, CountryId{"CH"}}, // Arbon railway station
    {Coordinate{9.42472, 47.5214}, CountryId{"CH"}}, // Arbon Seemoosriet railway station
    {Coordinate{9.26611, 47.6214}, CountryId{"CH"}}, // Altnau station
    {Coordinate{9.02194, 47.6731}, CountryId{"CH"}}, // Berlingen station
    {Coordinate{7.49864, 46.8889}, CountryId{"CH"}}, // Belp railway station
    {Coordinate{7.55951, 47.0955}, CountryId{"CH"}}, // Aefligen railway station
    {Coordinate{6.52369, 46.606}, CountryId{"CH"}}, // Cossonay-Penthalaz railway station
    {Coordinate{6.47474, 46.7151}, CountryId{"CH"}}, // Bretonnières railway station
    {Coordinate{6.69933, 46.5097}, CountryId{"CH"}}, // Bossière railway station
    {Coordinate{6.77855, 46.4811}, CountryId{"CH"}}, // Chexbres-Village railway station
    {Coordinate{7.00043, 46.7492}, CountryId{"CH"}}, // Chénens railway station
    {Coordinate{6.78639, 46.8169}, CountryId{"CH"}}, // Cheyres railway station
    {Coordinate{6.95719, 46.8288}, CountryId{"CH"}}, // Corcelles-Sud railway station
    {Coordinate{6.72317, 46.8509}, CountryId{"CH"}}, // Concise railway station
    {Coordinate{6.83505, 46.9594}, CountryId{"CH"}}, // Boudry railway station
    {Coordinate{6.84888, 46.9676}, CountryId{"CH"}}, // Colombier railway station
    {Coordinate{7.02337, 47.0386}, CountryId{"CH"}}, // Cornaux railway station
    {Coordinate{8.31526, 47.3052}, CountryId{"CH"}}, // Boswil-Bünzen railway station
    {Coordinate{8.45751, 47.1782}, CountryId{"CH"}}, // Cham railway station
    {Coordinate{8.47146, 47.1823}, CountryId{"CH"}}, // Cham Alpenblick railway station
    {Coordinate{8.35666, 47.0937}, CountryId{"CH"}}, // Buchrain railway station
    {Coordinate{7.95702, 47.2627}, CountryId{"CH"}}, // Brittnau-Wikon railway station
    {Coordinate{9.47862, 47.1684}, CountryId{"CH"}}, // Buchs SG railway station
    {Coordinate{6.47813, 46.6967}, CountryId{"CH"}}, // Croy-Romainmôtier railway station
    {Coordinate{6.54051, 46.5291}, CountryId{"CH"}}, // Denges-Echandens railway station
    {Coordinate{9.34791, 47.0966}, CountryId{"CH"}}, // Flums railway station
    {Coordinate{6.81105, 46.6104}, CountryId{"CH"}}, // Ecublens-Rue railway station
    {Coordinate{7.03479, 46.7512}, CountryId{"CH"}}, // Cottens railway station
    {Coordinate{6.84297, 46.8445}, CountryId{"CH"}}, // Estavayer-le-Lac railway station
    {Coordinate{6.88916, 46.816}, CountryId{"CH"}}, // Cugy FR railway station
    {Coordinate{6.97749, 46.8186}, CountryId{"CH"}}, // Cousset railway station
    {Coordinate{7.12271, 46.8671}, CountryId{"CH"}}, // Courtepin railway station
    {Coordinate{7.14972, 46.9002}, CountryId{"CH"}}, // Cressier FR railway station
    {Coordinate{7.03954, 47.0519}, CountryId{"CH"}}, // Cressier NE railway station
    {Coordinate{7.61891, 47.2182}, CountryId{"CH"}}, // Deitingen railway station
    {Coordinate{7.79895, 47.3149}, CountryId{"CH"}}, // Egerkingen railway station
    {Coordinate{7.94667, 47.3542}, CountryId{"CH"}}, // Dulliken railway station
    {Coordinate{7.97833, 47.3564}, CountryId{"CH"}}, // Däniken railway station
    {Coordinate{8.23468, 47.3736}, CountryId{"CH"}}, // Dottikon-Dintikon railway station
    {Coordinate{8.34236, 47.0843}, CountryId{"CH"}}, // Ebikon railway station
    {Coordinate{7.97901, 47.2175}, CountryId{"CH"}}, // Dagmersellen railway station
    {Coordinate{9.383, 47.544}, CountryId{"CH"}}, // Egnach railway station
    {Coordinate{8.87639, 47.6456}, CountryId{"CH"}}, // Eschenz railway station
    {Coordinate{9.08583, 47.67}, CountryId{"CH"}}, // Ermatingen railway station
    {Coordinate{8.7525, 47.6853}, CountryId{"CH"}}, // Diessenhofen railway station
    {Coordinate{7.31957, 46.8885}, CountryId{"CH"}}, // Flamatt railway station
    {Coordinate{6.72265, 46.4969}, CountryId{"CH"}}, // Grandvaux railway station
    {Coordinate{6.8701, 46.735}, CountryId{"CH"}}, // Henniez railway station
    {Coordinate{7.06605, 46.832}, CountryId{"CH"}}, // Grolley railway station
    {Coordinate{6.64194, 46.8063}, CountryId{"CH"}}, // Grandson railway station
    {Coordinate{7.12996, 46.8168}, CountryId{"CH"}}, // Givisiez railway station
    {Coordinate{6.78103, 46.8991}, CountryId{"CH"}}, // Gorgier-St-Aubin railway station
    {Coordinate{7.84381, 47.3303}, CountryId{"CH"}}, // Hägendorf railway station
    {Coordinate{8.16659, 47.4286}, CountryId{"CH"}}, // Holderbank railway station
    {Coordinate{8.20737, 47.3894}, CountryId{"CH"}}, // Hendschiken railway station
    {Coordinate{8.44991, 47.1692}, CountryId{"CH"}}, // Hünenberg Chämleten railway station
    {Coordinate{8.4501, 47.1736}, CountryId{"CH"}}, // Hünenberg Zythus railway station
    {Coordinate{8.39479, 47.1213}, CountryId{"CH"}}, // Gisikon-Root railway station
    {Coordinate{9.62725, 47.4104}, CountryId{"CH"}}, // Heerbrugg railway station
    {Coordinate{9.46333, 47.4903}, CountryId{"CH"}}, // Horn station
    {Coordinate{9.46698, 47.4738}, CountryId{"CH"}}, // Goldach railway station
    {Coordinate{9.2925, 47.6086}, CountryId{"CH"}}, // Güttingen station
    {Coordinate{9.27681, 47.3902}, CountryId{"CH"}}, // Herisau railway station
    {Coordinate{7.65563, 47.016}, CountryId{"CH"}}, // Hasle-Rüegsau railway station
    {Coordinate{7.38944, 47.1917}, CountryId{"CH"}}, // Grenchen Nord railway station
    {Coordinate{7.23441, 46.9422}, CountryId{"CH"}}, // Gümmenen railway station
    {Coordinate{8.83975, 46.4409}, CountryId{"CH"}}, // Lavorgo railway station
    {Coordinate{6.51736, 46.6588}, CountryId{"CH"}}, // La Sarraz railway station
    {Coordinate{6.67833, 46.5131}, CountryId{"CH"}}, // La Conversion railway station
    {Coordinate{7.06634, 47.0566}, CountryId{"CH"}}, // Le Landeron railway station
    {Coordinate{7.09523, 47.0628}, CountryId{"CH"}}, // La Neuveville railway station
    {Coordinate{7.13515, 47.0838}, CountryId{"CH"}}, // Ligerz railway station
    {Coordinate{7.36655, 47.1794}, CountryId{"CH"}}, // Lengnau railway station
    {Coordinate{7.94169, 47.302}, CountryId{"CH"}}, // Küngoldingen railway station
    {Coordinate{8.01906, 47.3247}, CountryId{"CH"}}, // Kölliken Oberdorf railway station
    {Coordinate{8.02644, 47.3373}, CountryId{"CH"}}, // Kölliken railway station
    {Coordinate{9.3175, 47.5956}, CountryId{"CH"}}, // Kesswil railway station
    {Coordinate{8.66222, 47.6833}, CountryId{"CH"}}, // Langwiesen railway station
    {Coordinate{7.78417, 46.9392}, CountryId{"CH"}}, // Langnau im Emmental railway station
    {Coordinate{7.62137, 46.8807}, CountryId{"CH"}}, // Konolfingen railway station
    {Coordinate{7.24084, 46.9015}, CountryId{"CH"}}, // Laupen BE railway station
    {Coordinate{8.85019, 46.1453}, CountryId{"CH"}}, // Magadino-Vira railway station
    {Coordinate{6.50805, 46.5182}, CountryId{"CH"}}, // Morges-St-Jean railway station
    {Coordinate{6.51955, 46.5231}, CountryId{"CH"}}, // Lonay-Préverenges railway station
    {Coordinate{9.17299, 47.1178}, CountryId{"CH"}}, // Mühlehorn railway station
    {Coordinate{9.21501, 47.1132}, CountryId{"CH"}}, // Murg railway station
    {Coordinate{9.27679, 47.113}, CountryId{"CH"}}, // Mols railway station
    {Coordinate{9.41774, 47.0537}, CountryId{"CH"}}, // Mels railway station
    {Coordinate{6.78565, 46.5084}, CountryId{"CH"}}, // Moreillon railway station
    {Coordinate{6.8025, 46.6681}, CountryId{"CH"}}, // Moudon railway station
    {Coordinate{7.09633, 46.7889}, CountryId{"CH"}}, // Matran railway station
    {Coordinate{7.01163, 46.8285}, CountryId{"CH"}}, // Léchelles railway station
    {Coordinate{7.58352, 47.2171}, CountryId{"CH"}}, // Luterbach-Attisholz railway station
    {Coordinate{8.33979, 47.2767}, CountryId{"CH"}}, // Muri AG railway station
    {Coordinate{8.3885, 47.225}, CountryId{"CH"}}, // Mühlau railway station
    {Coordinate{8.9139, 47.6442}, CountryId{"CH"}}, // former Mammern railway station
    {Coordinate{9.05278, 47.6736}, CountryId{"CH"}}, // Mannenbach-Salenstein  station
    {Coordinate{9.41436, 47.4748}, CountryId{"CH"}}, // Mörschwil railway station
    {Coordinate{7.83211, 47.2654}, CountryId{"CH"}}, // Murgenthal railway station
    {Coordinate{7.01059, 47.0091}, CountryId{"CH"}}, // Marin-Epagnier railway station
    {Coordinate{7.3063, 47.0763}, CountryId{"CH"}}, // Lyss railway station
    {Coordinate{7.68274, 47.0049}, CountryId{"CH"}}, // Lützelflüh-Goldbach railway station
    {Coordinate{8.88733, 46.1513}, CountryId{"CH"}}, // Quartino railway station
    {Coordinate{6.65799, 46.5147}, CountryId{"CH"}}, // Pully-Nord railway station
    {Coordinate{6.76569, 46.4938}, CountryId{"CH"}}, // Puidoux railway station
    {Coordinate{6.83711, 46.5725}, CountryId{"CH"}}, // Oron railway station
    {Coordinate{7.06503, 46.766}, CountryId{"CH"}}, // Neyruz railway station
    {Coordinate{7.13529, 46.8416}, CountryId{"CH"}}, // Pensier railway station
    {Coordinate{7.11623, 46.9109}, CountryId{"CH"}}, // Münchenwiler-Courgevaux railway station
    {Coordinate{6.90337, 46.984}, CountryId{"CH"}}, // Neuchâtel-Serrières railway station
    {Coordinate{7.34019, 47.1714}, CountryId{"CH"}}, // Pieterlen railway station
    {Coordinate{7.77171, 47.3052}, CountryId{"CH"}}, // Oberbuchsiten railway station
    {Coordinate{7.8977, 47.3485}, CountryId{"CH"}}, // Olten Hammer railway station
    {Coordinate{8.40476, 47.1659}, CountryId{"CH"}}, // Oberrüti railway station
    {Coordinate{8.13858, 47.1388}, CountryId{"CH"}}, // Nottwil railway station
    {Coordinate{8.11421, 47.1552}, CountryId{"CH"}}, // Oberkirch railway station
    {Coordinate{7.97744, 47.1924}, CountryId{"CH"}}, // Nebikon railway station
    {Coordinate{7.96876, 47.2415}, CountryId{"CH"}}, // Reiden railway station
    {Coordinate{8.04837, 47.3565}, CountryId{"CH"}}, // Oberentfelden railway station
    {Coordinate{8.08227, 47.3716}, CountryId{"CH"}}, // Suhr railway station
    {Coordinate{9.57137, 47.3235}, CountryId{"CH"}}, // Oberriet railway station
    {Coordinate{9.58675, 47.3926}, CountryId{"CH"}}, // Rebstein-Marbach railway station
    {Coordinate{8.67465, 47.1058}, CountryId{"CH"}}, // Rothenthurm railway station
    {Coordinate{8.62722, 47.0799}, CountryId{"CH"}}, // Sattel-Aegeri railway station
    {Coordinate{8.97392, 46.1604}, CountryId{"CH"}}, // Sant'Antonino railway station
    {Coordinate{8.80706, 46.1352}, CountryId{"CH"}}, // San Nazzaro railway station
    {Coordinate{7.06197, 46.7826}, CountryId{"CH"}}, // Rosé railway station
    {Coordinate{6.98212, 47.0146}, CountryId{"CH"}}, // St-Blaise CFF railway station
    {Coordinate{8.12694, 47.4033}, CountryId{"CH"}}, // Rupperswil railway station
    {Coordinate{8.27317, 47.0909}, CountryId{"CH"}}, // Rothenburg Dorf railway station
    {Coordinate{8.24917, 47.0882}, CountryId{"CH"}}, // Rothenburg railway station
    {Coordinate{8.37381, 47.1049}, CountryId{"CH"}}, // Root D4 railway station
    {Coordinate{7.9835, 47.3217}, CountryId{"CH"}}, // Safenwil railway station
    {Coordinate{9.50231, 47.2414}, CountryId{"CH"}}, // Salez-Sennwald railway station
    {Coordinate{9.53605, 47.2867}, CountryId{"CH"}}, // Rüthi SG railway station
    {Coordinate{9.49389, 47.4786}, CountryId{"CH"}}, // Rorschach Hafen station
    {Coordinate{9.48971, 47.4755}, CountryId{"CH"}}, // Rorschach Stadt railway station
    {Coordinate{9.33806, 47.4078}, CountryId{"CH"}}, // St. Gallen Haggen railway station
    {Coordinate{7.87938, 47.3064}, CountryId{"CH"}}, // Rothrist railway station
    {Coordinate{7.8149, 47.2516}, CountryId{"CH"}}, // Roggwil-Wynau railway station
    {Coordinate{6.98469, 47.0121}, CountryId{"CH"}}, // St-Blaise-Lac railway station
    {Coordinate{8.60743, 47.0477}, CountryId{"CH"}}, // Steinen railway station
    {Coordinate{8.58525, 47.0522}, CountryId{"CH"}}, // Steinerberg railway station
    {Coordinate{7.45664, 47.2006}, CountryId{"CH"}}, // Selzach railway station
    {Coordinate{8, 47.3714}, CountryId{"CH"}}, // Schönenwerd railway station
    {Coordinate{8.16694, 47.4517}, CountryId{"CH"}}, // Schinznach Bad railway station
    {Coordinate{8.3978, 47.1883}, CountryId{"CH"}}, // Sins railway station
    {Coordinate{8.19596, 47.1161}, CountryId{"CH"}}, // Sempach-Neuenkirch railway station
    {Coordinate{8.07455, 47.1801}, CountryId{"CH"}}, // St. Erhard-Knutwil railway station
    {Coordinate{9.49382, 47.1254}, CountryId{"CH"}}, // Sevelen railway station
    {Coordinate{9.53651, 47.4808}, CountryId{"CH"}}, // Staad railway station
    {Coordinate{9.44222, 47.5008}, CountryId{"CH"}}, // Steinach railway station
    {Coordinate{8.98111, 47.6644}, CountryId{"CH"}}, // Steckborn Station
    {Coordinate{8.77036, 47.6669}, CountryId{"CH"}}, // Schlattingen railway station
    {Coordinate{8.73194, 47.6875}, CountryId{"CH"}}, // St. Katharinental railway station
    {Coordinate{8.6875, 47.6794}, CountryId{"CH"}}, // Schlatt railway station
    {Coordinate{8.73444, 47.1976}, CountryId{"CH"}}, // Wilen bei Wollerau railway station
    {Coordinate{6.53077, 46.5762}, CountryId{"CH"}}, // Vufflens-la-Ville railway station
    {Coordinate{9.09472, 47.1299}, CountryId{"CH"}}, // Weesen station
    {Coordinate{9.25501, 47.1139}, CountryId{"CH"}}, // Unterterzen railway station
    {Coordinate{9.31296, 47.1199}, CountryId{"CH"}}, // Walenstadt railway station
    {Coordinate{6.85004, 46.6214}, CountryId{"CH"}}, // Vauderens railway station
    {Coordinate{6.96064, 46.7206}, CountryId{"CH"}}, // Villaz-Saint-Pierre railway station
    {Coordinate{7.11639, 46.7898}, CountryId{"CH"}}, // Villars-sur-Glâne railway station
    {Coordinate{6.7576, 46.8776}, CountryId{"CH"}}, // Vaumarcus railway station
    {Coordinate{7.1565, 47.0937}, CountryId{"CH"}}, // Twann railway station
    {Coordinate{7.19731, 47.115}, CountryId{"CH"}}, // Tüscherz railway station
    {Coordinate{7.65623, 47.2319}, CountryId{"CH"}}, // Wangen an der Aare railway station
    {Coordinate{7.86834, 47.3414}, CountryId{"CH"}}, // Wangen bei Olten railway station
    {Coordinate{8.16299, 47.4153}, CountryId{"CH"}}, // Wildegg railway station
    {Coordinate{8.50478, 47.1085}, CountryId{"CH"}}, // Walchwil Hörndli railway station
    {Coordinate{8.019, 47.1838}, CountryId{"CH"}}, // Wauwil railway station
    {Coordinate{8.51693, 47.0987}, CountryId{"CH"}}, // Walchwil railway station
    {Coordinate{7.96318, 47.3199}, CountryId{"CH"}}, // Walterswil-Striegel railway station
    {Coordinate{9.34028, 47.5858}, CountryId{"CH"}}, // Uttwil station
    {Coordinate{7.49603, 46.8585}, CountryId{"CH"}}, // Toffen railway station
    {Coordinate{7.55597, 47.1521}, CountryId{"CH"}}, // Wiler railway station
    {Coordinate{7.55366, 47.1295}, CountryId{"CH"}}, // Utzenstorf railway station
    {Coordinate{8.72476, 47.1954}, CountryId{"CH"}}, // Wollerau railway station
    {Coordinate{6.66232, 46.7822}, CountryId{"CH"}}, // Yverdon-Champ Pittet railway station
    {Coordinate{6.74669, 46.8009}, CountryId{"CH"}}, // Yvonand railway station
    {Coordinate{8.48665, 47.1802}, CountryId{"CH"}}, // Zug Chollermüli railway station
    {Coordinate{8.50724, 47.1737}, CountryId{"CH"}}, // Zug Schutzengel railway station
    {Coordinate{8.51694, 47.1683}, CountryId{"CH"}}, // Zug Postplatz railway station
    {Coordinate{8.5152, 47.1623}, CountryId{"CH"}}, // Zug Casino railway station
    {Coordinate{8.51229, 47.1566}, CountryId{"CH"}}, // Zug Fridbach railway station
    {Coordinate{9.38861, 47.4631}, CountryId{"CH"}}, // Wittenbach railway station
    {Coordinate{7.46291, 47.0018}, CountryId{"CH"}}, // Zollikofen railway station
    {Coordinate{7.37486, 46.5535}, CountryId{"CH"}}, // Montreux-Oberland railway station
    {Coordinate{9.2409, 51.3234}, CountryId{"DE"}}, // Hofgeismar-Hümme railway station
    {Coordinate{9.4775, 53.5961}, CountryId{"DE"}}, // Stade station
    {Coordinate{30.755, 46.554}, CountryId{"UA"}}, // Odesa-Sortuvalna
    {Coordinate{9.61542, 47.2562}, CountryId{"AT"}}, // Altenstadt railway station
    {Coordinate{9.59802, 47.2556}, CountryId{"AT"}}, // Gisingen
    {Coordinate{9.5757, 47.2273}, CountryId{"AT"}}, // Tisis
    {Coordinate{40.1045, 53.709}, CountryId{"RU"}}, // Ryazhsk I
    {Coordinate{7.06622, 51.6102}, CountryId{"DE"}}, // Gelsenkirchen-Hassel station
    {Coordinate{7.1418, 50.6965}, CountryId{"DE"}}, // Hochkreuz/Deutsches Museum Bonn
    {Coordinate{7.1005, 51.6541}, CountryId{"DE"}}, // Marl Mitte station
    {Coordinate{7.1311, 51.6826}, CountryId{"DE"}}, // Marl-Hamm station
    {Coordinate{8.66111, 49.2111}, CountryId{"DE"}}, // Bad Schönborn Süd station
    {Coordinate{8.66111, 49.2111}, CountryId{"DE"}}, // Bad Schönborn-Kronau station
    {Coordinate{19.0485, 47.5681}, CountryId{"HU"}}, // Aquincum HÉV station
    {Coordinate{35.7253, 64.1183}, CountryId{"RU"}}, // Kolezhma railway station
    {Coordinate{30.3778, 59.3025}, CountryId{"RU"}}, // Sluditsy
    {Coordinate{2.3002, 48.8303}, CountryId{"FR"}}, // Gare des abattoirs de Vaugirard
    {Coordinate{16.3698, 48.2352}, CountryId{"AT"}}, // Jägerstraße
    {Coordinate{10.6431, 44.6978}, CountryId{"IT"}}, // Reggio Emilia railway station
    {Coordinate{7.817, 49.7272}, CountryId{"DE"}}, // Alsenz station
    {Coordinate{11.7761, 49.87}, CountryId{"DE"}}, // Kirchenlaibach
    {Coordinate{8.27426, 49.1196}, CountryId{"DE"}}, // Rheinzabern station
    {Coordinate{12.5741, 48.8773}, CountryId{"DE"}}, // Bahnhof Straubing
    {Coordinate{9.01229, 51.6218}, CountryId{"DE"}}, // Willebadessen station
    {Coordinate{6.5731, 49.6953}, CountryId{"DE"}}, // Konz
    {Coordinate{6.57368, 49.7001}, CountryId{"DE"}}, // Konz Mitte
    {Coordinate{6.57667, 49.7039}, CountryId{"DE"}}, // Kreuz Konz
    {Coordinate{6.53739, 49.7083}, CountryId{"DE"}}, // Wasserliesch
    {Coordinate{6.57414, 49.6693}, CountryId{"DE"}}, // Kanzem
    {Coordinate{6.68347, 49.7797}, CountryId{"DE"}}, // Pfalzel
    {Coordinate{6.37264, 49.5044}, CountryId{"DE"}}, // Besch
    {Coordinate{6.37606, 49.5388}, CountryId{"DE"}}, // Nennig
    {Coordinate{6.37225, 49.565}, CountryId{"DE"}}, // Palzem
    {Coordinate{6.40665, 49.6084}, CountryId{"DE"}}, // Wincheringen
    {Coordinate{6.44101, 49.654}, CountryId{"DE"}}, // Nittel
    {Coordinate{6.44182, 49.6727}, CountryId{"DE"}}, // Wellen (Mosel) station
    {Coordinate{6.46225, 49.6883}, CountryId{"DE"}}, // Temmels
    {Coordinate{6.5119, 49.7101}, CountryId{"DE"}}, // Oberbillig
    {Coordinate{6.59403, 49.3437}, CountryId{"DE"}}, // Niedaltdorf
    {Coordinate{6.61405, 49.3539}, CountryId{"DE"}}, // Hemmersdorf
    {Coordinate{6.6659, 49.3617}, CountryId{"DE"}}, // Siersburg
    {Coordinate{6.77622, 49.3027}, CountryId{"DE"}}, // Ensdorf
    {Coordinate{6.79238, 49.276}, CountryId{"DE"}}, // Bous
    {Coordinate{6.94494, 49.2436}, CountryId{"DE"}}, // Burbach Mitte
    {Coordinate{6.6485, 49.4096}, CountryId{"DE"}}, // Fremersdorf
    {Coordinate{6.55181, 46.5476}, CountryId{"CH"}}, // Bussigny railway station
    {Coordinate{17.8449, 59.239}, CountryId{"SE"}}, // Alby metro station
    {Coordinate{9.02256, 53.0841}, CountryId{"DE"}}, // Sagehorn station
    {Coordinate{9.13356, 53.0969}, CountryId{"DE"}}, // Ottersberg railway station
    {Coordinate{9.25017, 53.1012}, CountryId{"DE"}}, // Sottrum railway station
    {Coordinate{9.5643, 53.197}, CountryId{"DE"}}, // Lauenbrück railway station
    {Coordinate{9.81253, 53.3094}, CountryId{"DE"}}, // Sprötze railway station
    {Coordinate{9.85524, 53.3159}, CountryId{"DE"}}, // Suerhop station
    {Coordinate{9.92919, 53.3661}, CountryId{"DE"}}, // Klecken railway station
    {Coordinate{9.97446, 53.4036}, CountryId{"DE"}}, // Hittfeld railway station
    {Coordinate{16.3242, 48.1607}, CountryId{"AT"}}, // Am Schöpfwerk
    {Coordinate{12.0684, 60.5592}, CountryId{"NO"}}, // Arneberg Station
    {Coordinate{2.03417, 49.0494}, CountryId{"FR"}}, // Gare de Cergy – Saint-Christophe
    {Coordinate{10.4855, 61.0367}, CountryId{"NO"}}, // Bergseng Station
    {Coordinate{9.33179, 61.9216}, CountryId{"NO"}}, // Brennhaug Station
    {Coordinate{-2.2508, 53.4742}, CountryId{"GB"}}, // Deansgate railway station
    {Coordinate{9.75725, 53.5832}, CountryId{"DE"}}, // Rissen
    {Coordinate{9.79757, 53.5811}, CountryId{"DE"}}, // Sülldorf
    {Coordinate{9.81446, 53.5764}, CountryId{"DE"}}, // Iserbrook
    {Coordinate{10.0377, 53.5609}, CountryId{"DE"}}, // Landwehr
    {Coordinate{10.044, 53.5384}, CountryId{"DE"}}, // Rothenburgsort
    {Coordinate{9.76062, 53.6751}, CountryId{"DE"}}, // Prisdorf station
    {Coordinate{9.71538, 53.6969}, CountryId{"DE"}}, // Tornesch
    {Coordinate{9.90115, 53.6099}, CountryId{"DE"}}, // Eidelstedt Zentrum
    {Coordinate{-0.4201, 51.502}, CountryId{"GB"}}, // Hayes & Harlington railway station
    {Coordinate{16.3344, 48.1845}, CountryId{"AT"}}, // Längenfeldgasse
    {Coordinate{75.1071, 33.7385}, CountryId{"IN"}}, // Anantnag railway station
    {Coordinate{78.1953, 26.2376}, CountryId{"IN"}}, // Birlanagar Junction railway station
    {Coordinate{84.5815, 18.9813}, CountryId{"IN"}}, // Sompeta railway station
    {Coordinate{78.7967, 28.8261}, CountryId{"IN"}}, // Katghar railway station
    {Coordinate{-2.63861, 53.3936}, CountryId{"GB"}}, // Warrington West railway station
    {Coordinate{72.9335, 20.6086}, CountryId{"IN"}}, // Valsad railway station
    {Coordinate{11.478, 48.1643}, CountryId{"DE"}}, // München-Obermenzing station
    {Coordinate{11.6989, 48.1183}, CountryId{"DE"}}, // Gronsdorf station
    {Coordinate{11.1966, 44.551}, CountryId{"IT"}}, // Anzola dell’Emilia railway station
    {Coordinate{10.1176, 44.8371}, CountryId{"IT"}}, // Borghetto Parmense railway halt
    {Coordinate{11.2751, 44.4437}, CountryId{"IT"}}, // Borgonuovo railway halt
    {Coordinate{11.0961, 44.2469}, CountryId{"IT"}}, // Carbona railway station
    {Coordinate{12.1019, 44.8365}, CountryId{"IT"}}, // Codigoro railway station
    {Coordinate{10.3828, 44.9279}, CountryId{"IT"}}, // Colorno railway station
    {Coordinate{11.8318, 44.5111}, CountryId{"IT"}}, // Conselice railway station
    {Coordinate{10.8154, 44.9392}, CountryId{"IT"}}, // Gonzaga-Reggiolo railway station
    {Coordinate{10.1402, 44.7493}, CountryId{"IT"}}, // Medesano railway station
    {Coordinate{11.11, 44.5104}, CountryId{"IT"}}, // Muffa railway station
    {Coordinate{10.1471, 44.8099}, CountryId{"IT"}}, // Noceto railway station
    {Coordinate{11.189, 44.3324}, CountryId{"IT"}}, // Pian di Venola railway station
    {Coordinate{11.2295, 44.4882}, CountryId{"IT"}}, // Pilastrino railway station
    {Coordinate{11.4842, 44.7672}, CountryId{"IT"}}, // Poggio Renatico railway station
    {Coordinate{11.2693, 44.423}, CountryId{"IT"}}, // Pontecchio Marconi railway station
    {Coordinate{11.241, 44.4855}, CountryId{"IT"}}, // Riale railway station
    {Coordinate{10.8677, 44.8857}, CountryId{"IT"}}, // Rolo-Novi-Fabbrico railway station
    {Coordinate{11.8258, 44.4903}, CountryId{"IT"}}, // San Patrizio railway station
    {Coordinate{11.0332, 44.4832}, CountryId{"IT"}}, // Savignano Comune railway station
    {Coordinate{11.047, 44.494}, CountryId{"IT"}}, // Savignano Mulino railway station
    {Coordinate{10.4463, 44.8432}, CountryId{"IT"}}, // Sorbolo railway station
    {Coordinate{11.5231, 44.4368}, CountryId{"IT"}}, // Varignana railway station
    {Coordinate{11.0085, 44.4817}, CountryId{"IT"}}, // Vignola railway station
    {Coordinate{10.8421, 44.9158}, CountryId{"IT"}}, // Villanova di Reggiolo railway halt
    {Coordinate{11.218, 44.4926}, CountryId{"IT"}}, // Zola Centro railway station
    {Coordinate{11.2095, 44.4942}, CountryId{"IT"}}, // Zola Chiesa railway station
    {Coordinate{40.2886, 48.2625}, CountryId{"RU"}}, // Q16271814
    {Coordinate{40.2508, 48.2236}, CountryId{"RU"}}, // Q16271822
    {Coordinate{40.2244, 48.1989}, CountryId{"RU"}}, // Q16271826
    {Coordinate{37.4153, 54.8719}, CountryId{"RU"}}, // 107 km
    {Coordinate{47.8636, 56.6289}, CountryId{"RU"}}, // Q16271835
    {Coordinate{37.4761, 54.6781}, CountryId{"RU"}}, // 132 km
    {Coordinate{142.663, 47.0579}, CountryId{"RU"}}, // Q16271848
    {Coordinate{35.7085, 56.0064}, CountryId{"RU"}}, // 141 km
    {Coordinate{37.6228, 54.5253}, CountryId{"RU"}}, // 153 km
    {Coordinate{55.9022, 54.7115}, CountryId{"RU"}}, // Q16271872
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16271880
    {Coordinate{37.5811, 54.2308}, CountryId{"RU"}}, // 191 km
    {Coordinate{31.1125, 59.7578}, CountryId{"RU"}}, // 3 km platform
    {Coordinate{38.9433, 55.4441}, CountryId{"RU"}}, // 32 km
    {Coordinate{39.2803, 57.8121}, CountryId{"RU"}}, // Q16271915
    {Coordinate{43.6692, 56.2589}, CountryId{"RU"}}, // Q16271929
    {Coordinate{31.7983, 59.5247}, CountryId{"RU"}}, // 52 km platform (Kirishsky District)
    {Coordinate{31.8442, 59.5025}, CountryId{"RU"}}, // Q16271947
    {Coordinate{53.5175, 56.8834}, CountryId{"RU"}}, // Q16271951
    {Coordinate{85.1111, 56.3892}, CountryId{"RU"}}, // Q16271959
    {Coordinate{142.094, 46.9964}, CountryId{"RU"}}, // Q16271977
    {Coordinate{142.079, 47.0091}, CountryId{"RU"}}, // Q16271986
    {Coordinate{29.1532, 60.2441}, CountryId{"RU"}}, // Zerkalny platform
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16271996
    {Coordinate{53.6447, 53.6826}, CountryId{"RU"}}, // Abdulino
    {Coordinate{55.7689, 54.65}, CountryId{"RU"}}, // Q16272081
    {Coordinate{47.8024, 56.629}, CountryId{"RU"}}, // Q16272545
    {Coordinate{132.058, 43.3333}, CountryId{"RU"}}, // Q16273069
    {Coordinate{33.3699, 67.5643}, CountryId{"RU"}}, // Apatity-1 railway station
    {Coordinate{43.7899, 55.4092}, CountryId{"RU"}}, // Arzamas-I
    {Coordinate{33.7023, 46.1161}, CountryId{"UA"}}, // Armyansk
    {Coordinate{23.3031, 56.5478}, CountryId{"LV"}}, // Q16273440
    {Coordinate{37.66, 54.3244}, CountryId{"RU"}}, // Baydiki
    {Coordinate{36.6625, 55.1789}, CountryId{"RU"}}, // Balabanovo
    {Coordinate{43.16, 51.535}, CountryId{"RU"}}, // Q16273755
    {Coordinate{131.957, 43.695}, CountryId{"RU"}}, // Banevurovo
    {Coordinate{89.3054, 56.1228}, CountryId{"RU"}}, // Bogotol
    {Coordinate{53.7731, 56.9382}, CountryId{"RU"}}, // Bolgury
    {Coordinate{104.09, 52.0775}, CountryId{"RU"}}, // Q16274588
    {Coordinate{25.4105, 52.7779}, CountryId{"BY"}}, // Borki
    {Coordinate{52.8094, 54.5212}, CountryId{"RU"}}, // Bugulma railway station
    {Coordinate{30.5675, 52.7126}, CountryId{"BY"}}, // Q16274652
    {Coordinate{32.4655, 58.7274}, CountryId{"RU"}}, // Q16274664
    {Coordinate{2.3021, 50.7281}, CountryId{"FR"}}, // Gare d'Arques
    {Coordinate{8.30536, 49.38}, CountryId{"DE"}}, // Böhl-Iggelheim station
    {Coordinate{8.39066, 49.4242}, CountryId{"DE"}}, // Limburgerhof station
    {Coordinate{11.6602, 48.0757}, CountryId{"DE"}}, // Neubiberg station
    {Coordinate{1.78424, 44.9216}, CountryId{"FR"}}, // Gare de Puybrun
    {Coordinate{27.9589, 56.4307}, CountryId{"LV"}}, // Nerza railway station
    {Coordinate{26.4917, 55.8765}, CountryId{"LV"}}, // 3. kilometres
    {Coordinate{25.5542, 56.89}, CountryId{"LV"}}, // Roplaiņi railway halt
    {Coordinate{24.5774, 57.395}, CountryId{"LV"}}, // Q16353013
    {Coordinate{34.4492, 45.884}, CountryId{"RU"}}, // Solone Ozero
    {Coordinate{24.7221, 57.5089}, CountryId{"LV"}}, // Limbaži railway station
    {Coordinate{22.35, 56.6977}, CountryId{"LV"}}, // Lutriņi Station
    {Coordinate{23.4097, 56.6025}, CountryId{"LV"}}, // Lāči railway station
    {Coordinate{33.5981, 44.6072}, CountryId{"RU"}}, // Q16389195
    {Coordinate{73.7603, 43.6014}, CountryId{"KZ"}}, // Chu station
    {Coordinate{}, CountryId{"NO"}}, // Narvik Port
    {Coordinate{20.9506, 66.7547}, CountryId{"SE"}}, // Nattavaara
    {Coordinate{21.935, 65.6735}, CountryId{"SE"}}, // Sunderby Sjukhus
    {Coordinate{15.6589, 62.5233}, CountryId{"SE"}}, // Ånge
    {Coordinate{16.0961, 61.8269}, CountryId{"SE"}}, // Ljusdal railway station
    {Coordinate{15.1317, 58.3224}, CountryId{"SE"}}, // Mjölby station
    {Coordinate{12.299, 58.2876}, CountryId{"SE"}}, // Trollhättan railway station
    {Coordinate{15.8742, 59.0421}, CountryId{"SE"}}, // Vingåker railway station
    {Coordinate{20.9942, 65.6784}, CountryId{"SE"}}, // Älvsbyn
    {Coordinate{10.7772, 44.9722}, CountryId{"IT"}}, // Palidano railway halt
    {Coordinate{133.52, 45.62}, CountryId{"RU"}}, // Prokhasko
    {Coordinate{24.8122, 54.7796}, CountryId{"LT"}}, // Vievis train station
    {Coordinate{21.4843, 55.3474}, CountryId{"LT"}}, // Šilutė railway station
    {Coordinate{12.635, 41.5521}, CountryId{"IT"}}, // Campo di Carne railway station
    {Coordinate{-8.38814, 41.3647}, CountryId{"PT"}}, // Q16483793
    {Coordinate{40.2886, 48.2625}, CountryId{"RU"}}, // Q16484388
    {Coordinate{35.5869, 56.0224}, CountryId{"RU"}}, // 149 km
    {Coordinate{1.93155, 44.9512}, CountryId{"FR"}}, // Gare de Laval-de-Cère
    {Coordinate{37.4973, 56.4185}, CountryId{"RU"}}, // Imeni Barsuchenko
    {Coordinate{30.4083, 59.1}, CountryId{"RU"}}, // Q16486682
    {Coordinate{16.0213, 40.5747}, CountryId{"IT"}}, // Q16487703
    {Coordinate{18.347, 39.8921}, CountryId{"IT"}}, // Alessano-Corsano railway station
    {Coordinate{104.265, 52.2547}, CountryId{"RU"}}, // Akademicheskaya
    {Coordinate{18.3398, 39.9795}, CountryId{"IT"}}, // Andrano-Castiglione railway station
    {Coordinate{43.7972, 56.2673}, CountryId{"RU"}}, // Q16495703
    {Coordinate{39.95, 59.1881}, CountryId{"RU"}}, // Q16495706
    {Coordinate{7.04965, 51.802}, CountryId{"DE"}}, // Reken railway station
    {Coordinate{1.84428, 44.9276}, CountryId{"FR"}}, // Gare de Bretenoux - Biars
    {Coordinate{2.41969, 48.0732}, CountryId{"FR"}}, // Gare de Beaune-la-Rolande
    {Coordinate{19.0393, 47.5068}, CountryId{"HU"}}, // Batthyány tér HÉV station
    {Coordinate{19.0549, 47.5985}, CountryId{"HU"}}, // Békásmegyer HÉV station
    {Coordinate{4.92156, 44.0053}, CountryId{"FR"}}, // Gare d'Entraigues-sur-la-Sorgue
    {Coordinate{5.04553, 43.7859}, CountryId{"FR"}}, // Gare d'Orgon
    {Coordinate{6.53029, 46.7242}, CountryId{"CH"}}, // Orbe train station
    {Coordinate{14.84, 66.4458}, CountryId{"NO"}}, // Dunderland Station
    {Coordinate{19.0393, 47.5148}, CountryId{"HU"}}, // Margit híd HÉV station
    {Coordinate{19.0463, 47.5519}, CountryId{"HU"}}, // Filatorigát HÉV station
    {Coordinate{19.0453, 47.5569}, CountryId{"HU"}}, // Kaszásdűlő HÉV station
    {Coordinate{19.0447, 47.5858}, CountryId{"HU"}}, // Csillaghegy HÉV station
    {Coordinate{19.0549, 47.6162}, CountryId{"HU"}}, // Budakalász HÉV station
    {Coordinate{19.0467, 47.6217}, CountryId{"HU"}}, // Budakalász, Lenfonó HÉV station
    {Coordinate{4.95693, 43.9298}, CountryId{"FR"}}, // Gare de Gadagne
    {Coordinate{2.83094, 50.3575}, CountryId{"FR"}}, // Gare de Farbus
    {Coordinate{6.5394, 46.5271}, CountryId{"CH"}}, // Lausanne-Triage classification yard
    {Coordinate{7.06194, 45.7446}, CountryId{"IT"}}, // La Salle railway halt
    {Coordinate{7.85465, 45.5148}, CountryId{"IT"}}, // Borgofranco railway station
    {Coordinate{7.12395, 47.2972}, CountryId{"CH"}}, // Bollement railway station
    {Coordinate{18.9902, 47.3909}, CountryId{"HU"}}, // Kastélypark railway station
    {Coordinate{19.0401, 47.5273}, CountryId{"HU"}}, // Szépvölgyi út HÉV station
    {Coordinate{19.0442, 47.5336}, CountryId{"HU"}}, // Tímár utca HÉV station
    {Coordinate{19.0472, 47.5397}, CountryId{"HU"}}, // Szentlélek Square HÉV station
    {Coordinate{19.0485, 47.5753}, CountryId{"HU"}}, // Rómaifürdő HÉV station
    {Coordinate{19.0433, 47.6288}, CountryId{"HU"}}, // Szentistvántelep HÉV station
    {Coordinate{19.0324, 47.643}, CountryId{"HU"}}, // Pomáz HÉV station
    {Coordinate{19.065, 47.6523}, CountryId{"HU"}}, // Pannóniatelep HÉV station
    {Coordinate{19.0754, 47.6609}, CountryId{"HU"}}, // Szentendre HÉV station
    {Coordinate{4.99483, 44.0374}, CountryId{"FR"}}, // Gare de Monteux
    {Coordinate{4.87399, 43.9325}, CountryId{"FR"}}, // Gare de Montfavet
    {Coordinate{5.07323, 43.7409}, CountryId{"FR"}}, // Gare de Sénas
    {Coordinate{7.73178, 48.5925}, CountryId{"FR"}}, // Gare de Strasbourg-Cronenbourg
    {Coordinate{7.25843, 45.7179}, CountryId{"IT"}}, // Sarre train station
    {Coordinate{7.87801, 45.2787}, CountryId{"IT"}}, // Rodallo railway station
    {Coordinate{0.335418, 46.5462}, CountryId{"FR"}}, // Gare de Saint-Benoît
    {Coordinate{-0.474483, 47.4541}, CountryId{"FR"}}, // Gare de Trélazé
    {Coordinate{2.61075, 46.5363}, CountryId{"FR"}}, // Gare de Vallon-en-Sully
    {Coordinate{4.99638, 43.9265}, CountryId{"FR"}}, // Gare du Thor
    {Coordinate{2.60008, 46.4145}, CountryId{"FR"}}, // Q16508099
    {Coordinate{6.54132, 46.721}, CountryId{"CH"}}, // Les Granges (Orbe) station
    {Coordinate{6.532, 46.7206}, CountryId{"CH"}}, // Q16508242
    {Coordinate{6.96512, 46.4547}, CountryId{"CH"}}, // Jor railway station
    {Coordinate{19.2712, 47.4872}, CountryId{"HU"}}, // Rákoscsaba-Újtelep railway station
    {Coordinate{18.6722, 47.1247}, CountryId{"HU"}}, // Zichyújfalu railway station
    {Coordinate{53.9938, 57.0257}, CountryId{"RU"}}, // Q16525083
    {Coordinate{-8.30082, 41.4216}, CountryId{"PT"}}, // Covas Halt
    {Coordinate{-8.31953, 41.4031}, CountryId{"PT"}}, // Q16531603
    {Coordinate{-8.32411, 41.3774}, CountryId{"PT"}}, // Q16531622
    {Coordinate{14.683, 49.78}, CountryId{"CZ"}}, // Benešov u Prahy
    {Coordinate{8.6625, 50.1069}, CountryId{"DE"}}, // Frankfurt (Main) Hauptbahnhof
    {Coordinate{15.2745, 49.3567}, CountryId{"CZ"}}, // Dobrá Voda u Pelhřimova
    {Coordinate{13.8008, 49.2881}, CountryId{"CZ"}}, // Q16540571
    {Coordinate{14.7169, 49.3222}, CountryId{"CZ"}}, // Q16541040
    {Coordinate{13.7774, 51.1282}, CountryId{"DE"}}, // Dresden Grenzstraße railway station
    {Coordinate{18.4672, 54.3825}, CountryId{"PL"}}, // Gdańsk Port Lotniczy railway station
    {Coordinate{18.9978, 54.0406}, CountryId{"PL"}}, // Q16550343
    {Coordinate{14.1353, 49.2367}, CountryId{"CZ"}}, // Q16558037
    {Coordinate{14.4642, 49.0506}, CountryId{"CZ"}}, // Hluboká nad Vltavou-Zámostí
    {Coordinate{13.7389, 49.3311}, CountryId{"CZ"}}, // Horažďovice předměstí station
    {Coordinate{14.4667, 49.0344}, CountryId{"CZ"}}, // Q16558520
    {Coordinate{14.4822, 49.0197}, CountryId{"CZ"}}, // Hrdějovice
    {Coordinate{15.1583, 49.0453}, CountryId{"CZ"}}, // Hůrky
    {Coordinate{13.6656, 49.3697}, CountryId{"CZ"}}, // Jetenovice railway station
    {Coordinate{15.5834, 49.404}, CountryId{"CZ"}}, // Jihlava město (train station)
    {Coordinate{15.4823, 49.3573}, CountryId{"CZ"}}, // Kostelec u Jihlavy (train station)
    {Coordinate{13.6133, 49.4133}, CountryId{"CZ"}}, // Kovčín railway station
    {Coordinate{15.1628, 49.1119}, CountryId{"CZ"}}, // Kunžak-Lomy (train station)
    {Coordinate{14.2203, 49.1728}, CountryId{"CZ"}}, // Q16577340
    {Coordinate{13.6081, 49.4617}, CountryId{"CZ"}}, // Q16577343
    {Coordinate{14.7197, 49.9103}, CountryId{"CZ"}}, // Mirošovice u Prahy
    {Coordinate{14.7072, 49.9326}, CountryId{"CZ"}}, // Mnichovice
    {Coordinate{15.0644, 50.8322}, CountryId{"CZ"}}, // Mníšek
    {Coordinate{13.9758, 49.2564}, CountryId{"CZ"}}, // Q16578843
    {Coordinate{13.6914, 50.7178}, CountryId{"CZ"}}, // Moldava v Krušných horách (train station)
    {Coordinate{34.2942, 45.5022}, CountryId{"UA"}}, // Q16580618
    {Coordinate{13.6103, 49.4383}, CountryId{"CZ"}}, // Nekvasovy railway station
    {Coordinate{14.6042, 49.125}, CountryId{"CZ"}}, // Neplachov
    {Coordinate{34.1786, 45.3525}, CountryId{"UA"}}, // Q16582012
    {Coordinate{13.4186, 49.7244}, CountryId{"CZ"}}, // Plzeň-Koterov station
    {Coordinate{9.64389, 47.9533}, CountryId{"DE"}}, // Aulendorf station
    {Coordinate{15.2124, 49.237}, CountryId{"CZ"}}, // Počátky-Žirovnice
    {Coordinate{13.8489, 49.2581}, CountryId{"CZ"}}, // Q16591052
    {Coordinate{14.6261, 50.0136}, CountryId{"CZ"}}, // Praha-Kolovraty
    {Coordinate{14.4906, 50.0675}, CountryId{"CZ"}}, // Praha-Strašnice zastávka
    {Coordinate{14.5913, 50.0338}, CountryId{"CZ"}}, // Praha-Uhříněves
    {Coordinate{14.2222, 49.1964}, CountryId{"CZ"}}, // Protivín zastávka
    {Coordinate{15.0525, 49.1681}, CountryId{"CZ"}}, // Rodvínov
    {Coordinate{14.6972, 49.3794}, CountryId{"CZ"}}, // Sezimovo Ústí
    {Coordinate{10.4561, 59.8437}, CountryId{"NO"}}, // Høn Station
    {Coordinate{14.1644, 49.2236}, CountryId{"CZ"}}, // Q16601616
    {Coordinate{7.16167, 53.6211}, CountryId{"DE"}}, // Norddeich railway station
    {Coordinate{3.39379, 50.3846}, CountryId{"FR"}}, // Gare de Wallers
    {Coordinate{13.5919, 49.5247}, CountryId{"CZ"}}, // Srby
    {Coordinate{15.0253, 50.7886}, CountryId{"CZ"}}, // Stráž nad Nisou
    {Coordinate{14.0569, 49.2494}, CountryId{"CZ"}}, // Q16607895
    {Coordinate{14.6572, 49.9697}, CountryId{"CZ"}}, // Světice
    {Coordinate{14.4255, 36.9968}, CountryId{"IT"}}, // Acate railway station
    {Coordinate{15.9562, 39.4865}, CountryId{"IT"}}, // Acquappesa railway halt
    {Coordinate{15.0016, 40.3515}, CountryId{"IT"}}, // Agropoli-Castellabate railway station
    {Coordinate{10.9965, 45.7591}, CountryId{"IT"}}, // Ala railway station
    {Coordinate{11.9444, 45.9026}, CountryId{"IT"}}, // Alano-Fener-Valdobbiadene railway station
    {Coordinate{14.1285, 40.9963}, CountryId{"IT"}}, // Albanova railway station
    {Coordinate{11.4542, 45.5118}, CountryId{"IT"}}, // Altavilla-Tavernelle railway station
    {Coordinate{10.6726, 43.8174}, CountryId{"IT"}}, // Stazione di Altopascio
    {Coordinate{13.5208, 43.5664}, CountryId{"IT"}}, // Q16608740
    {Coordinate{13.4559, 43.6101}, CountryId{"IT"}}, // Stazione di Ancona Torrette
    {Coordinate{13.8357, 42.0175}, CountryId{"IT"}}, // Anversa-Villalago-Scanno railway station
    {Coordinate{12.6161, 41.4617}, CountryId{"IT"}}, // Anzio Colonia railway halt
    {Coordinate{15.1723, 40.141}, CountryId{"IT"}}, // Ascea train station
    {Coordinate{10.9561, 45.7337}, CountryId{"IT"}}, // Avio railway station
    {Coordinate{15.126, 36.9075}, CountryId{"IT"}}, // Q16608770
    {Coordinate{10.5518, 44.0035}, CountryId{"IT"}}, // Bagni di Lucca train station
    {Coordinate{15.4954, 40.65}, CountryId{"IT"}}, // Q16608776
    {Coordinate{7.81947, 44.722}, CountryId{"IT"}}, // Bandito train station
    {Coordinate{10.4521, 44.0681}, CountryId{"IT"}}, // Barga-Gallicano railway halt
    {Coordinate{12.1525, 42.2124}, CountryId{"IT"}}, // Q16608802
    {Coordinate{8.50238, 45.9092}, CountryId{"IT"}}, // Baveno railway halt
    {Coordinate{8.57108, 45.8433}, CountryId{"IT"}}, // Belgirate railway station
    {Coordinate{15.8532, 39.6166}, CountryId{"IT"}}, // Q16608814
    {Coordinate{16.6823, 40.3977}, CountryId{"IT"}}, // Bernalda railway station
    {Coordinate{8.28954, 46.0684}, CountryId{"IT"}}, // Q16608820
    {Coordinate{7.28715, 44.8097}, CountryId{"IT"}}, // Bibiana railway halt
    {Coordinate{11.3728, 44.4961}, CountryId{"IT"}}, // Bologna San Vitale railway halt
    {Coordinate{8.26456, 45.4554}, CountryId{"IT"}}, // Bolzano Novarese railway halt
    {Coordinate{11.4114, 44.9019}, CountryId{"IT"}}, // Bondeno railway station
    {Coordinate{10.9269, 45.6968}, CountryId{"IT"}}, // Borghetto sull'Adige
    {Coordinate{10.5412, 43.9774}, CountryId{"IT"}}, // Borgo a Mozzano
    {Coordinate{16.8574, 38.9341}, CountryId{"IT"}}, // Botricello train station
    {Coordinate{7.30837, 44.8256}, CountryId{"IT"}}, // Bricherasio railway station
    {Coordinate{12.7932, 37.9469}, CountryId{"IT"}}, // Bruch railway station
    {Coordinate{11.9363, 46.8006}, CountryId{"IT"}}, // Bruneck Nord/Brunico Nord railway station
    {Coordinate{15.3742, 40.6009}, CountryId{"IT"}}, // Q16608869
    {Coordinate{13.8633, 42.0316}, CountryId{"IT"}}, // Bugnara railway station
    {Coordinate{8.26661, 45.4719}, CountryId{"IT"}}, // Buronzo railway station
    {Coordinate{11.9795, 46.04}, CountryId{"IT"}}, // Busche-Lentiai-Mel railway station
    {Coordinate{13.849, 42.1941}, CountryId{"IT"}}, // Bussi train station
    {Coordinate{14.1718, 37.1452}, CountryId{"IT"}}, // Butera railway station
    {Coordinate{10.9883, 45.3389}, CountryId{"IT"}}, // Buttapietra
    {Coordinate{12.8561, 37.9389}, CountryId{"IT"}}, // Calatafimi railway station
    {Coordinate{10.5321, 44.0199}, CountryId{"IT"}}, // Calavorno railway halt
    {Coordinate{9.84164, 45.5328}, CountryId{"IT"}}, // Calcio railway halt
    {Coordinate{11.1698, 45.4144}, CountryId{"IT"}}, // Caldiero railway station
    {Coordinate{8.66325, 45.9456}, CountryId{"IT"}}, // Caldè railway station
    {Coordinate{16.8192, 39.579}, CountryId{"IT"}}, // Calopezzati Railway Station
    {Coordinate{13.5207, 43.5297}, CountryId{"IT"}}, // Q16608906
    {Coordinate{10.3346, 44.1614}, CountryId{"IT"}}, // Camporgiano
    {Coordinate{8.10031, 45.5474}, CountryId{"IT"}}, // Candelo railway halt
    {Coordinate{13.0291, 42.3916}, CountryId{"IT"}}, // Canetra railway halt
    {Coordinate{18.3729, 40.156}, CountryId{"IT"}}, // Cannole railway station
    {Coordinate{15.0137, 40.4545}, CountryId{"IT"}}, // Capaccio-Roccadaspide railway station
    {Coordinate{15.8742, 39.5584}, CountryId{"IT"}}, // Q16608942
    {Coordinate{13.2046, 41.4006}, CountryId{"IT"}}, // Capocroce railway halt
    {Coordinate{16.9236, 41.0492}, CountryId{"IT"}}, // Capurso railway station
    {Coordinate{16.952, 39.4968}, CountryId{"IT"}}, // Stazione di Cariati
    {Coordinate{8.21235, 45.4033}, CountryId{"IT"}}, // Carisio railway station
    {Coordinate{8.42286, 45.529}, CountryId{"IT"}}, // Carpignano Sesia railway station
    {Coordinate{8.49034, 45.4912}, CountryId{"IT"}}, // Casaleggio railway station
    {Coordinate{16.9147, 40.9542}, CountryId{"IT"}}, // Casamassima railway station
    {Coordinate{8.85898, 44.7626}, CountryId{"IT"}}, // Cassano Spinola railway station
    {Coordinate{15.1918, 36.9628}, CountryId{"IT"}}, // Q16608984
    {Coordinate{17.1658, 40.8869}, CountryId{"IT"}}, // Castellana Grotte railway station
    {Coordinate{10.7585, 45.431}, CountryId{"IT"}}, // Castelnuovo del Garda railway halt
    {Coordinate{10.455, 44.0901}, CountryId{"IT"}}, // Castelvecchio Pascoli railway halt
    {Coordinate{9.80804, 46.1615}, CountryId{"IT"}}, // Castione Andevenno railway station
    {Coordinate{16.4671, 38.344}, CountryId{"IT"}}, // Caulonia railway station
    {Coordinate{15.3946, 40.1028}, CountryId{"IT"}}, // Q16609017
    {Coordinate{15.3467, 40.0905}, CountryId{"IT"}}, // Centola-Palinuro-Marina di Camerota railway halt
    {Coordinate{12.3914, 44.2007}, CountryId{"IT"}}, // Cesenatico railway station
    {Coordinate{15.9394, 39.5127}, CountryId{"IT"}}, // Q16609028
    {Coordinate{9.92641, 45.5399}, CountryId{"IT"}}, // Chiari railway halt
    {Coordinate{15.1567, 41.9218}, CountryId{"IT"}}, // Q16609034
    {Coordinate{9.84695, 45.6505}, CountryId{"IT"}}, // Chiuduno railway halt
    {Coordinate{12.9429, 42.3879}, CountryId{"IT"}}, // Cittaducale railway station
    {Coordinate{8.68996, 45.8603}, CountryId{"IT"}}, // Cocquio-Trevisago railway station
    {Coordinate{13.7766, 42.0408}, CountryId{"IT"}}, // Cocullo train station
    {Coordinate{13.6293, 42.0604}, CountryId{"IT"}}, // Collarmele train station
    {Coordinate{11.4416, 46.9381}, CountryId{"IT"}}, // Colle Isarco/Gossensaß railway station
    {Coordinate{9.93551, 45.5767}, CountryId{"IT"}}, // Cologne railway halt
    {Coordinate{8.56611, 45.7143}, CountryId{"IT"}}, // Comignago railway station
    {Coordinate{14.6005, 36.9472}, CountryId{"IT"}}, // Comiso railway station
    {Coordinate{15.5356, 38.1503}, CountryId{"IT"}}, // Q16609084
    {Coordinate{17.1153, 40.9711}, CountryId{"IT"}}, // Conversano railway station
    {Coordinate{16.5148, 39.6281}, CountryId{"IT"}}, // Corigliano Calabro railway station
    {Coordinate{18.2624, 40.1618}, CountryId{"IT"}}, // Corigliano d'Otranto railway station
    {Coordinate{12.0127, 45.8338}, CountryId{"IT"}}, // Cornuda railway station
    {Coordinate{9.52521, 46.1355}, CountryId{"IT"}}, // Cosio-Traona railway station
    {Coordinate{8.49826, 45.6463}, CountryId{"IT"}}, // Cressa-Fontaneto train station
    {Coordinate{16.8134, 38.9221}, CountryId{"IT"}}, // Cropani train station
    {Coordinate{17.0406, 39.4496}, CountryId{"IT"}}, // Crucoli railway station
    {Coordinate{8.4566, 45.6725}, CountryId{"IT"}}, // Cureggio railway station
    {Coordinate{16.9639, 39.0259}, CountryId{"IT"}}, // Cutro train station
    {Coordinate{8.37327, 45.9935}, CountryId{"IT"}}, // Cuzzago railway halt
    {Coordinate{9.46128, 46.1386}, CountryId{"IT"}}, // Delebio railway station
    {Coordinate{10.5077, 43.9596}, CountryId{"IT"}}, // Diecimo-Pescaglia railway station
    {Coordinate{14.5689, 36.8822}, CountryId{"IT"}}, // Donnafugata railway station
    {Coordinate{8.58222, 45.7234}, CountryId{"IT"}}, // Dormelletto railway halt
    {Coordinate{10.3294, 46.177}, CountryId{"IT"}}, // Edolo railway station
    {Coordinate{11.2574, 46.3194}, CountryId{"IT"}}, // Egna-Termeno/Neumarkt-Tramin railway station
    {Coordinate{9.06296, 39.2572}, CountryId{"IT"}}, // Elmas Aeroporto railway station
    {Coordinate{14.0526, 37.1135}, CountryId{"IT"}}, // Falconara railway station
    {Coordinate{11.9919, 45.7083}, CountryId{"IT"}}, // Fanzolo railway station
    {Coordinate{8.86285, 45.1119}, CountryId{"IT"}}, // Ferrera Lomellina railway halt
    {Coordinate{14.8089, 37.3112}, CountryId{"IT"}}, // Q16609182
    {Coordinate{15.544, 38.161}, CountryId{"IT"}}, // Fiumara Gazzi railway halt
    {Coordinate{9.29277, 45.9991}, CountryId{"IT"}}, // Fiumelatte railway halt
    {Coordinate{13.7749, 37.9666}, CountryId{"IT"}}, // Fiumetorto railway station
    {Coordinate{13.4249, 41.3378}, CountryId{"IT"}}, // Fondi-Sperlonga railway station
    {Coordinate{15.2114, 36.9691}, CountryId{"IT"}}, // Fontane Bianche railway halt
    {Coordinate{10.4733, 44.0454}, CountryId{"IT"}}, // Fornaci di Barga railway station
    {Coordinate{11.6103, 46.7889}, CountryId{"IT"}}, // Fortezza/Franzensfeste railway station
    {Coordinate{10.4443, 44.1187}, CountryId{"IT"}}, // Fosciandora-Ceserana
    {Coordinate{15.6245, 40.6786}, CountryId{"IT"}}, // Q16609213
    {Coordinate{13.2007, 41.3659}, CountryId{"IT"}}, // Frasso railway halt
    {Coordinate{16.0118, 39.4097}, CountryId{"IT"}}, // Fuscaldo railway station
    {Coordinate{18.3573, 39.8505}, CountryId{"IT"}}, // Gagliano Leuca railway station
    {Coordinate{11.6711, 44.7781}, CountryId{"IT"}}, // Gaibanella railway station
    {Coordinate{15.5054, 38.1046}, CountryId{"IT"}}, // Q16609231
    {Coordinate{11.8277, 45.6528}, CountryId{"IT"}}, // Q16609236
    {Coordinate{17.9883, 40.0574}, CountryId{"IT"}}, // Gallipoli railway station
    {Coordinate{8.36467, 45.6114}, CountryId{"IT"}}, // Gattinara railway station
    {Coordinate{8.37946, 45.5261}, CountryId{"IT"}}, // Ghislarengo railway halt
    {Coordinate{10.5103, 44.0278}, CountryId{"IT"}}, // Ghivizzano-Coreglia railway halt
    {Coordinate{15.4797, 38.0639}, CountryId{"IT"}}, // Giampilieri railway station
    {Coordinate{18.4395, 40.1428}, CountryId{"IT"}}, // Giurdignano railway station
    {Coordinate{13.7829, 42.0827}, CountryId{"IT"}}, // Goriano Sicoli train station
    {Coordinate{8.44057, 45.7446}, CountryId{"IT"}}, // Gozzano railway station
    {Coordinate{16.2408, 40.5931}, CountryId{"IT"}}, // Grassano-Garaguso railway station
    {Coordinate{8.42863, 45.9341}, CountryId{"IT"}}, // Gravellona Toce railway station
    {Coordinate{8.33367, 45.6828}, CountryId{"IT"}}, // Grignasco train station
    {Coordinate{15.8212, 39.7398}, CountryId{"IT"}}, // Q16609282
    {Coordinate{17.4244, 40.5291}, CountryId{"IT"}}, // Grottaglie train station
    {Coordinate{9.8629, 45.6342}, CountryId{"IT"}}, // Grumello del Monte railway station
    {Coordinate{16.5744, 38.4372}, CountryId{"IT"}}, // Guardavalle railway station
    {Coordinate{15.9795, 39.4643}, CountryId{"IT"}}, // Guardia Piemontese Terme railway halt
    {Coordinate{14.9142, 36.7782}, CountryId{"IT"}}, // Stazione di Ispica
    {Coordinate{8.62113, 45.8117}, CountryId{"IT"}}, // Ispra railway station
    {Coordinate{13.1988, 41.3331}, CountryId{"IT"}}, // La Fiora railway halt
    {Coordinate{11.1824, 46.6074}, CountryId{"IT"}}, // Lana-Postal/Lana-Burgstall railway station
    {Coordinate{8.55896, 45.8256}, CountryId{"IT"}}, // Lesa railway station
    {Coordinate{7.94153, 44.3857}, CountryId{"IT"}}, // Lesegno railway station
    {Coordinate{12.0066, 45.8502}, CountryId{"IT"}}, // Levada railway halt
    {Coordinate{12.626, 41.5006}, CountryId{"IT"}}, // Lido di Lavinio railway halt
    {Coordinate{9.30283, 45.9609}, CountryId{"IT"}}, // Lierna railway station
    {Coordinate{8.79912, 45.1174}, CountryId{"IT"}}, // Lomello railway station
    {Coordinate{10.4872, 45.4575}, CountryId{"IT"}}, // Lonato railway station
    {Coordinate{13.6203, 43.4481}, CountryId{"IT"}}, // Loreto train station
    {Coordinate{7.24765, 44.8158}, CountryId{"IT"}}, // Luserna San Giovanni railway halt
    {Coordinate{7.7477, 44.6954}, CountryId{"IT"}}, // Q16609371
    {Coordinate{7.77686, 44.4466}, CountryId{"IT"}}, // Magliano-Crava-Morozzo railway station
    {Coordinate{18.2997, 40.1258}, CountryId{"IT"}}, // Maglie railway station
    {Coordinate{11.1824, 45.0022}, CountryId{"IT"}}, // Magnacavallo railway station
    {Coordinate{16.8931, 39.5253}, CountryId{"IT"}}, // Q16609385
    {Coordinate{12.1348, 42.1282}, CountryId{"IT"}}, // Manziana-Canale Monterano
    {Coordinate{15.8229, 39.7669}, CountryId{"IT"}}, // Marcellina-Verbicaro-Orsomarso station
    {Coordinate{8.74251, 45.0951}, CountryId{"IT"}}, // Mede railway halt
    {Coordinate{8.53576, 45.7945}, CountryId{"IT"}}, // Meina railway station
    {Coordinate{18.2772, 40.1479}, CountryId{"IT"}}, // Melpignano railway halt
    {Coordinate{8.44101, 45.9615}, CountryId{"IT"}}, // Mergozzo railway station
    {Coordinate{18.3232, 39.9644}, CountryId{"IT"}}, // Miggiano-Specchia-Montesano railway station
    {Coordinate{8.93015, 44.5389}, CountryId{"IT"}}, // Mignanego railway station
    {Coordinate{15.5181, 38.1244}, CountryId{"IT"}}, // Q16609427
    {Coordinate{9.45005, 45.162}, CountryId{"IT"}}, // Miradolo Terme railway station
    {Coordinate{16.7773, 39.6047}, CountryId{"IT"}}, // Q16609433
    {Coordinate{13.3471, 41.3461}, CountryId{"IT"}}, // Monte San Biagio-Terracina Mare railway station
    {Coordinate{17.3615, 40.5237}, CountryId{"IT"}}, // Monteiasi-Montemesola train station
    {Coordinate{13.3466, 43.6513}, CountryId{"IT"}}, // Q16609458
    {Coordinate{7.96495, 44.7038}, CountryId{"IT"}}, // Q16609461
    {Coordinate{10.2393, 45.4513}, CountryId{"IT"}}, // Montirone railway station
    {Coordinate{9.56869, 46.1366}, CountryId{"IT"}}, // Morbegno railway station
    {Coordinate{18.3349, 40.0988}, CountryId{"IT"}}, // Muro Leccese railway station
    {Coordinate{8.01667, 44.7134}, CountryId{"IT"}}, // Q16609481
    {Coordinate{17.2577, 40.5082}, CountryId{"IT"}}, // Nasisi railway station
    {Coordinate{8.55804, 45.4814}, CountryId{"IT"}}, // Nibbia railway halt
    {Coordinate{8.67129, 45.2756}, CountryId{"IT"}}, // Nicorvo railway halt
    {Coordinate{12.7668, 43.1007}, CountryId{"IT"}}, // Q16609494
    {Coordinate{16.6439, 40.1304}, CountryId{"IT"}}, // Nova Siri-Rotondella railway station
    {Coordinate{8.41313, 45.8719}, CountryId{"IT"}}, // Omegna railway station
    {Coordinate{8.41413, 45.8981}, CountryId{"IT"}}, // Omegna-Crusinallo railway halt
    {Coordinate{15.1345, 40.2527}, CountryId{"IT"}}, // Q16609521
    {Coordinate{11.2972, 46.361}, CountryId{"IT"}}, // Ora/Auer railway station
    {Coordinate{8.42125, 45.7959}, CountryId{"IT"}}, // Orta-Miasino railway station
    {Coordinate{13.5471, 43.4968}, CountryId{"IT"}}, // Q16609534
    {Coordinate{10.0745, 45.546}, CountryId{"IT"}}, // Ospitaletto-Travagliato railway station
    {Coordinate{18.4816, 40.1495}, CountryId{"IT"}}, // Otranto railway station
    {Coordinate{12.6293, 41.5136}, CountryId{"IT"}}, // Padiglione railway station
    {Coordinate{17.0591, 40.5172}, CountryId{"IT"}}, // Palagiona-Chiatona railway station
    {Coordinate{14.8925, 37.3182}, CountryId{"IT"}}, // Q16609557
    {Coordinate{15.9901, 40.9392}, CountryId{"IT"}}, // Palazzo San Gervasio-Montemilone
    {Coordinate{8.5344, 45.3072}, CountryId{"IT"}}, // Palestro railway halt
    {Coordinate{8.26058, 46.0436}, CountryId{"IT"}}, // Pallanzeno railway halt
    {Coordinate{13.4298, 43.6171}, CountryId{"IT"}}, // Palombina railway halt
    {Coordinate{13.8443, 43.094}, CountryId{"IT"}}, // Q16609574
    {Coordinate{11.9651, 45.8772}, CountryId{"IT"}}, // Pederobba-Cavaso-Possagno railway halt
    {Coordinate{10.9006, 45.6583}, CountryId{"IT"}}, // Peri railway station
    {Coordinate{13.669, 42.0374}, CountryId{"IT"}}, // Pescina railway station
    {Coordinate{13.9516, 42.2544}, CountryId{"IT"}}, // Piano d'Orta Bolognano railway station
    {Coordinate{15.6417, 40.6403}, CountryId{"IT"}}, // railway station of Picerno
    {Coordinate{8.26106, 46.0244}, CountryId{"IT"}}, // Piedimulera railway halt
    {Coordinate{15.7921, 40.7533}, CountryId{"IT"}}, // Q16609605
    {Coordinate{8.95968, 45.1162}, CountryId{"IT"}}, // Pieve Albignola railway halt
    {Coordinate{8.27625, 46.0098}, CountryId{"IT"}}, // Pieve Vergonte railway station
    {Coordinate{12.4102, 43.0951}, CountryId{"IT"}}, // Piscille train station
    {Coordinate{15.2435, 40.0914}, CountryId{"IT"}}, // Pisciotta-Palinuro train station
    {Coordinate{16.5521, 40.4207}, CountryId{"IT"}}, // Q16609621
    {Coordinate{7.89254, 44.7011}, CountryId{"IT"}}, // Q16609623
    {Coordinate{18.3705, 40.0517}, CountryId{"IT"}}, // Poggiardo railway station
    {Coordinate{10.3506, 44.1485}, CountryId{"IT"}}, // Poggio-Careggine-Vagli
    {Coordinate{16.0839, 38.4071}, CountryId{"IT"}}, // Polistena railway station
    {Coordinate{8.63684, 45.6496}, CountryId{"IT"}}, // Stazione di Pombia
    {Coordinate{15.3901, 40.6087}, CountryId{"IT"}}, // Q16609644
    {Coordinate{10.4092, 45.4739}, CountryId{"IT"}}, // Ponte San Marco-Calcinato railway station
    {Coordinate{15.5028, 38.0961}, CountryId{"IT"}}, // Q16609651
    {Coordinate{15.4943, 38.0809}, CountryId{"IT"}}, // Q16609654
    {Coordinate{13.6617, 43.4338}, CountryId{"IT"}}, // Q16609672
    {Coordinate{13.7602, 43.2566}, CountryId{"IT"}}, // Q16609674
    {Coordinate{15.7771, 40.7811}, CountryId{"IT"}}, // Possidente railway station
    {Coordinate{12.1484, 45.716}, CountryId{"IT"}}, // Q16609682
    {Coordinate{13.698, 43.3602}, CountryId{"IT"}}, // Q16609685
    {Coordinate{14.8472, 36.7335}, CountryId{"IT"}}, // Pozzallo railway station
    {Coordinate{9.39771, 46.3078}, CountryId{"IT"}}, // Prata Camportaccio railway halt
    {Coordinate{8.37042, 45.6464}, CountryId{"IT"}}, // Prato Sesia train station
    {Coordinate{8.32718, 46.0024}, CountryId{"IT"}}, // Premosello-Chiovenda railway station
    {Coordinate{13.8345, 42.0537}, CountryId{"IT"}}, // Prezza railway station
    {Coordinate{8.26655, 45.7635}, CountryId{"IT"}}, // Quarona train station
    {Coordinate{11.92, 45.9396}, CountryId{"IT"}}, // Quero-Vas railway station
    {Coordinate{16.5281, 38.3892}, CountryId{"IT"}}, // Q16609720
    {Coordinate{11.6698, 46.7972}, CountryId{"IT"}}, // Mühlbach/Rio di Pusteria railway station
    {Coordinate{8.59703, 45.2934}, CountryId{"IT"}}, // Robbio railway station
    {Coordinate{16.9005, 38.9423}, CountryId{"IT"}}, // Stazione di Roccabernarda
    {Coordinate{16.5744, 38.4372}, CountryId{"IT"}}, // Q16609738
    {Coordinate{15.4476, 40.6102}, CountryId{"IT"}}, // Romagnano-Vietri-Salvitelle railway station
    {Coordinate{9.75352, 45.5238}, CountryId{"IT"}}, // Romano railway station
    {Coordinate{14.9528, 36.8161}, CountryId{"IT"}}, // Q16609750
    {Coordinate{16.6408, 39.6029}, CountryId{"IT"}}, // Q16609753
    {Coordinate{11.7849, 45.7022}, CountryId{"IT"}}, // Q16609756
    {Coordinate{17.0084, 41.0116}, CountryId{"IT"}}, // Rutigliano railway station
    {Coordinate{9.03064, 45.1339}, CountryId{"IT"}}, // Sairano-Zinasco railway halt
    {Coordinate{16.3515, 40.5834}, CountryId{"IT"}}, // Q16609768
    {Coordinate{8.08233, 44.3963}, CountryId{"IT"}}, // Sale Langhe railway station
    {Coordinate{8.17278, 44.4045}, CountryId{"IT"}}, // Saliceto train station
    {Coordinate{11.2029, 46.2457}, CountryId{"IT"}}, // Salorno/Salurn railway station
    {Coordinate{9.42375, 46.2465}, CountryId{"IT"}}, // Samolaco railway halt
    {Coordinate{14.7446, 36.732}, CountryId{"IT"}}, // Stazione di Sampieri
    {Coordinate{11.2742, 45.4024}, CountryId{"IT"}}, // San Bonifacio railway station
    {Coordinate{9.39769, 46.2742}, CountryId{"IT"}}, // San Cassiano Valchiavenna railway halt
    {Coordinate{14.1721, 40.9923}, CountryId{"IT"}}, // San Marcellino-Frignano railway station
    {Coordinate{12.1082, 42.382}, CountryId{"IT"}}, // San Martino al Cimino railway station
    {Coordinate{15.4883, 38.0712}, CountryId{"IT"}}, // Q16609817
    {Coordinate{11.0175, 44.9971}, CountryId{"IT"}}, // San Rocco Mantovano railway station
    {Coordinate{18.3474, 40.0836}, CountryId{"IT"}}, // Sanarica railway station
    {Coordinate{8.08119, 45.5195}, CountryId{"IT"}}, // Sandigliano railway halt
    {Coordinate{8.90513, 45.1055}, CountryId{"IT"}}, // Sannazzaro railway station
    {Coordinate{12.3292, 46.0939}, CountryId{"IT"}}, // Santa Croce del Lago railway station
    {Coordinate{12.043, 46.0778}, CountryId{"IT"}}, // Santa Giustina-Cesio railway station
    {Coordinate{7.91608, 44.6959}, CountryId{"IT"}}, // Q16609856
    {Coordinate{8.4932, 44.3098}, CountryId{"IT"}}, // Q16609869
    {Coordinate{13.9983, 42.2674}, CountryId{"IT"}}, // Scafa train station
    {Coordinate{15.8012, 39.8082}, CountryId{"IT"}}, // Q16609878
    {Coordinate{16.7054, 40.2536}, CountryId{"IT"}}, // Scanzano Jonico-Montalbano Jonico railway station
    {Coordinate{14.6989, 36.7899}, CountryId{"IT"}}, // Q16609884
    {Coordinate{12.8282, 37.9495}, CountryId{"IT"}}, // Segesta Tempio railway halt
    {Coordinate{16.7647, 38.9039}, CountryId{"IT"}}, // Q16609893
    {Coordinate{11.0153, 45.8083}, CountryId{"IT"}}, // Serravalle all'Adige railway station
    {Coordinate{8.44502, 45.5213}, CountryId{"IT"}}, // Q16609905
    {Coordinate{15.8959, 41.6131}, CountryId{"IT"}}, // Siponto railway halt
    {Coordinate{8.57907, 45.5396}, CountryId{"IT"}}, // Q16609916
    {Coordinate{7.77725, 44.7708}, CountryId{"IT"}}, // Sommariva del Bosco train station
    {Coordinate{18.3594, 40.014}, CountryId{"IT"}}, // Spongano railway halt
    {Coordinate{17.1081, 39.2281}, CountryId{"IT"}}, // Strongoli train station
    {Coordinate{8.6058, 45.7724}, CountryId{"IT"}}, // Taino-Angera railway halt
    {Coordinate{9.60031, 46.1399}, CountryId{"IT"}}, // Talamona railway halt
    {Coordinate{10.5705, 43.8342}, CountryId{"IT"}}, // Tassignano-Capannori railway station
    {Coordinate{13.2418, 41.2976}, CountryId{"IT"}}, // Terracina railway halt
    {Coordinate{18.3579, 39.9047}, CountryId{"IT"}}, // Tiggiano railway station
    {Coordinate{13.9047, 42.2267}, CountryId{"IT"}}, // Q16609961
    {Coordinate{7.57121, 45.0311}, CountryId{"IT"}}, // Q16609964
    {Coordinate{17.1083, 39.3044}, CountryId{"IT"}}, // Torre Melissa train station
    {Coordinate{15.4812, 40.0991}, CountryId{"IT"}}, // Q16609973
    {Coordinate{7.22602, 44.819}, CountryId{"IT"}}, // Torre Pellice railway halt
    {Coordinate{13.9375, 42.244}, CountryId{"IT"}}, // Q16609978
    {Coordinate{16.7073, 39.6075}, CountryId{"IT"}}, // Q16609984
    {Coordinate{15.5269, 38.1381}, CountryId{"IT"}}, // Q16609990
    {Coordinate{12.1038, 45.7474}, CountryId{"IT"}}, // Q16609993
    {Coordinate{18.3526, 39.9334}, CountryId{"IT"}}, // Tricase railway station
    {Coordinate{16.9164, 41.0642}, CountryId{"IT"}}, // Triggiano railway station
    {Coordinate{15.9978, 40.5886}, CountryId{"IT"}}, // Q16610005
    {Coordinate{15.1584, 40.2296}, CountryId{"IT"}}, // Vallo della Lucania-Castelnuovo train station
    {Coordinate{8.25926, 45.8143}, CountryId{"IT"}}, // Varallo Sesia railway station
    {Coordinate{13.5232, 43.5748}, CountryId{"IT"}}, // Varano railway station
    {Coordinate{8.88709, 45.7773}, CountryId{"IT"}}, // Vedano Olona railway station
    {Coordinate{8.89507, 45.7367}, CountryId{"IT"}}, // Venegono Inferiore railway station
    {Coordinate{8.89025, 45.7581}, CountryId{"IT"}}, // Venegono Superiore-Castiglione railway halt
    {Coordinate{9.4586, 46.2027}, CountryId{"IT"}}, // Verceia railway halt
    {Coordinate{10.332, 45.3738}, CountryId{"IT"}}, // Viadana Bresciana railway station
    {Coordinate{7.89567, 44.3738}, CountryId{"IT"}}, // Vicoforte-San Michele train station
    {Coordinate{12.6171, 41.4844}, CountryId{"IT"}}, // Villa Claudia railway halt
    {Coordinate{8.26455, 46.0642}, CountryId{"IT"}}, // Villadossola railway station
    {Coordinate{10.3678, 44.1469}, CountryId{"IT"}}, // Villetta San Romano railway halt
    {Coordinate{11.4402, 46.8957}, CountryId{"IT"}}, // Vipiteno-Val di Vizze/Sterzing-Pfitsch railway station
    {Coordinate{10.3633, 45.3154}, CountryId{"IT"}}, // Visano railway station
    {Coordinate{14.525, 36.9587}, CountryId{"IT"}}, // Vittoria railway station
    {Coordinate{8.29471, 46.0058}, CountryId{"IT"}}, // Vogogna Ossola railway halt
    {Coordinate{11.9361, 44.5404}, CountryId{"IT"}}, // Voltana railway station
    {Coordinate{12.3163, 46.1373}, CountryId{"IT"}}, // Alpago train station
    {Coordinate{14.6928, 49.3932}, CountryId{"CZ"}}, // Tábor - Čápův Dvůr
    {Coordinate{14.7775, 49.0072}, CountryId{"CZ"}}, // Třeboň lázně
    {Coordinate{13.7011, 49.3458}, CountryId{"CZ"}}, // Velký Bor
    {Coordinate{14.6961, 49.1772}, CountryId{"CZ"}}, // Veselí nad Lužnicí zastávka
    {Coordinate{20.8686, 52.1911}, CountryId{"PL"}}, // Warszawa Ursus Niedźwiadek railway station
    {Coordinate{14.3267, 49.0894}, CountryId{"CZ"}}, // Zbudov
    {Coordinate{13.5169, 49.6064}, CountryId{"CZ"}}, // Zdemyslice
    {Coordinate{14.9692, 49.6894}, CountryId{"CZ"}}, // Zdislavice
    {Coordinate{14.2647, 49.1247}, CountryId{"CZ"}}, // Q16620772
    {Coordinate{14.2733, 49.3717}, CountryId{"CZ"}}, // Q16621016
    {Coordinate{14.6128, 49.5585}, CountryId{"CZ"}}, // Q16621018
    {Coordinate{14.714, 49.8685}, CountryId{"CZ"}}, // Čtyřkoly
    {Coordinate{14.7242, 49.2242}, CountryId{"CZ"}}, // Řípec-Dráchov
    {Coordinate{13.5033, 49.6692}, CountryId{"CZ"}}, // Šťáhlavy (train station)
    {Coordinate{13.5736, 49.5506}, CountryId{"CZ"}}, // Ždírec u Plzně
    {Coordinate{52.4456, 59.595}, CountryId{"RU"}}, // Verkhnekamskaya station
    {Coordinate{48.1597, 52.7136}, CountryId{"RU"}}, // Vozrozhdeniye
    {Coordinate{5.3675, 43.3134}, CountryId{"FR"}}, // Gare d'Arenc-Euroméditerranée
    {Coordinate{-0.607064, 43.1792}, CountryId{"FR"}}, // Q16638563
    {Coordinate{2.19281, 44.9641}, CountryId{"FR"}}, // Q16638572
    {Coordinate{6.16097, 49.1284}, CountryId{"FR"}}, // Q16638580
    {Coordinate{1.42965, 45.2158}, CountryId{"FR"}}, // Gare de Le Burg
    {Coordinate{131.374, 44.4064}, CountryId{"RU"}}, // Grodekovo
    {Coordinate{43.4544, 56.2282}, CountryId{"RU"}}, // Dzerzhinsk railway station
    {Coordinate{39.4477, 54.8217}, CountryId{"RU"}}, // Divovo
    {Coordinate{25.4742, 52.8288}, CountryId{"BY"}}, // Damanava
    {Coordinate{33.4986, 53.6897}, CountryId{"RU"}}, // Q16646722
    {Coordinate{38.1253, 53.15}, CountryId{"RU"}}, // Q16650766
    {Coordinate{31.6419, 59.5656}, CountryId{"RU"}}, // Q16651331
    {Coordinate{94.4159, 55.5716}, CountryId{"RU"}}, // Zaozyorny train station
    {Coordinate{40.115, 48.0203}, CountryId{"RU"}}, // Zverevo railway station
    {Coordinate{106.504, 56.7462}, CountryId{"RU"}}, // Q16653716
    {Coordinate{40.304, 46.8465}, CountryId{"RU"}}, // Zernograd
    {Coordinate{11.5933, 50.8838}, CountryId{"DE"}}, // Jena-Göschwitz station
    {Coordinate{40.2531, 52.6328}, CountryId{"RU"}}, // Q16655143
    {Coordinate{80.1956, 44.1371}, CountryId{"KZ"}}, // Yintal railway station
    {Coordinate{96.0711, 56.2394}, CountryId{"RU"}}, // Ilanskaya train station
    {Coordinate{42.9167, 45.7072}, CountryId{"RU"}}, // Q16656069
    {Coordinate{69.5126, 56.112}, CountryId{"RU"}}, // Ishim station
    {Coordinate{53.6195, 56.9066}, CountryId{"RU"}}, // Q16656563
    {Coordinate{15.2136, 50.025}, CountryId{"CZ"}}, // Kolín train station
    {Coordinate{76.5129, 9.18259}, CountryId{"IN"}}, // Kayamkulam Junction railway station
    {Coordinate{37.5146, 56.3844}, CountryId{"RU"}}, // Kanalstroy
    {Coordinate{95.7033, 56.1986}, CountryId{"RU"}}, // Kansk train station
    {Coordinate{46.7303, 43.2433}, CountryId{"RU"}}, // Q16661998
    {Coordinate{41.3236, 54.8958}, CountryId{"RU"}}, // Q16662206
    {Coordinate{44.1625, 56.6523}, CountryId{"RU"}}, // Q16663003
    {Coordinate{51.505, 56.2802}, CountryId{"RU"}}, // Kizner station
    {Coordinate{131.924, 43.4721}, CountryId{"RU"}}, // Q16663489
    {Coordinate{107.455, 56.1794}, CountryId{"RU"}}, // Q16663546
    {Coordinate{52.2252, 59.346}, CountryId{"RU"}}, // Kirs station
    {Coordinate{44.0434, 56.4735}, CountryId{"RU"}}, // Q16663694
    {Coordinate{103.876, 52.5989}, CountryId{"RU"}}, // Kitoy station
    {Coordinate{52.3469, 58.1761}, CountryId{"RU"}}, // Kozhil railway station
    {Coordinate{33.0503, 68.8883}, CountryId{"RU"}}, // Kola
    {Coordinate{35.1332, 55.5304}, CountryId{"RU"}}, // Kolesniki
    {Coordinate{43.8342, 56.2788}, CountryId{"RU"}}, // Q16665322
    {Coordinate{48.3436, 58.3119}, CountryId{"RU"}}, // Kotelnich I railway station
    {Coordinate{46.6528, 61.2117}, CountryId{"RU"}}, // Q16666452
    {Coordinate{52.338, 59.125}, CountryId{"RU"}}, // Q16666512
    {Coordinate{57.9851, 55.0111}, CountryId{"RU"}}, // Kropachëvo
    {Coordinate{47.811, 52.598}, CountryId{"RU"}}, // Kulatka railway station
    {Coordinate{43.8678, 56.2591}, CountryId{"RU"}}, // Kustovaya
    {Coordinate{37.4183, 56.7699}, CountryId{"RU"}}, // Lebzino
    {Coordinate{55.885, 54.7083}, CountryId{"RU"}}, // Q16670346
    {Coordinate{105.951, 56.809}, CountryId{"RU"}}, // Q16670672
    {Coordinate{105.741, 56.7808}, CountryId{"RU"}}, // Lena railway station
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16670942
    {Coordinate{38.4341, 55.1677}, CountryId{"RU"}}, // Lesnye Dary
    {Coordinate{44.1018, 56.6127}, CountryId{"RU"}}, // Q16671349
    {Coordinate{32.9853, 53.8914}, CountryId{"RU"}}, // Q16671472
    {Coordinate{33.556, 60.7281}, CountryId{"RU"}}, // Lodeynoye Pole railway station
    {Coordinate{38.821, 54.5713}, CountryId{"RU"}}, // Loshatovka
    {Coordinate{36.1, 52.9319}, CountryId{"RU"}}, // Q16672319
    {Coordinate{36.4805, 55.0058}, CountryId{"RU"}}, // Maloyaroslavets
    {Coordinate{36.2163, 56.0183}, CountryId{"RU"}}, // Matryonino
    {Coordinate{52.2016, 56.4467}, CountryId{"RU"}}, // Mozhga station
    {Coordinate{44.0732, 56.3572}, CountryId{"RU"}}, // Mohovye Gory station
    {Coordinate{105.863, 51.7187}, CountryId{"RU"}}, // Mysovaya railway station
    {Coordinate{71.3562, 55.5676}, CountryId{"RU"}}, // Nazyvaevskaya station
    {Coordinate{124.757, 56.65}, CountryId{"RU"}}, // Neryungri-Passazhirskaya railway station
    {Coordinate{99.0167, 54.9}, CountryId{"RU"}}, // Nizhneudinsk train station
    {Coordinate{43.854, 56.2859}, CountryId{"RU"}}, // Nizhny Novgorod sorting
    {Coordinate{39.2228, 51.3114}, CountryId{"RU"}}, // Q16681310
    {Coordinate{132.019, 45.1002}, CountryId{"RU"}}, // Q16681385
    {Coordinate{34.4428, 61.4231}, CountryId{"RU"}}, // Nyrki
    {Coordinate{59.5925, 56.0167}, CountryId{"RU"}}, // Q16681950
    {Coordinate{36.8874, 55.4582}, CountryId{"RU"}}, // Ozhigovo
    {Coordinate{104.509, 51.4561}, CountryId{"RU"}}, // Q16684752
    {Coordinate{37.5481, 54.6278}, CountryId{"RU"}}, // Pakhomovo
    {Coordinate{45.0423, 53.2066}, CountryId{"RU"}}, // Q16685336
    {Coordinate{45.033, 53.1841}, CountryId{"RU"}}, // Penza 3 railway station
    {Coordinate{41.9564, 52.7167}, CountryId{"RU"}}, // Platonovka
    {Coordinate{103.457, 56.4598}, CountryId{"RU"}}, // Q16686497
    {Coordinate{31.5341, 59.6005}, CountryId{"RU"}}, // Q16686630
    {Coordinate{87.3263, 53.9016}, CountryId{"RU"}}, // Q16686898
    {Coordinate{34.3236, 45.5669}, CountryId{"UA"}}, // Q16687055
    {Coordinate{34.3094, 45.5344}, CountryId{"UA"}}, // Q16687057
    {Coordinate{30.6363, 46.3834}, CountryId{"UA"}}, // 13 km
    {Coordinate{34.2511, 45.4467}, CountryId{"UA"}}, // Q16687066
    {Coordinate{34.1125, 45.2664}, CountryId{"UA"}}, // Q16687068
    {Coordinate{34.0808, 45.2172}, CountryId{"UA"}}, // Q16687072
    {Coordinate{34.0725, 45.0661}, CountryId{"UA"}}, // Q16687076
    {Coordinate{34.0725, 45.0661}, CountryId{"UA"}}, // Q16687077
    {Coordinate{34.0475, 45.0067}, CountryId{"UA"}}, // Q16687079
    {Coordinate{34.0322, 44.8881}, CountryId{"UA"}}, // Q16687081
    {Coordinate{33.6244, 44.6744}, CountryId{"UA"}}, // Q16687089
    {Coordinate{33.6083, 44.5956}, CountryId{"UA"}}, // Q16687091
    {Coordinate{33.2309, 49.9928}, CountryId{"UA"}}, // 200 km
    {Coordinate{30.591, 46.3466}, CountryId{"UA"}}, // 22 km
    {Coordinate{33.1528, 47.7097}, CountryId{"UA"}}, // 22 km
    {Coordinate{30.6006, 46.3362}, CountryId{"UA"}}, // 25 km
    {Coordinate{33.386, 48.9959}, CountryId{"UA"}}, // 270 km
    {Coordinate{32.2409, 46.9811}, CountryId{"UA"}}, // 44 km
    {Coordinate{33.7893, 47.6319}, CountryId{"UA"}}, // 47 km
    {Coordinate{32.7748, 51.1727}, CountryId{"UA"}}, // Q16687297
    {Coordinate{33.2419, 47.8575}, CountryId{"UA"}}, // 6 km
    {Coordinate{32.48, 50.8909}, CountryId{"UA"}}, // 702 km
    {Coordinate{32.3642, 50.7498}, CountryId{"UA"}}, // 720 km
    {Coordinate{32.3417, 50.6947}, CountryId{"UA"}}, // 727 km
    {Coordinate{32.3282, 50.6782}, CountryId{"UA"}}, // 729 km
    {Coordinate{32.3372, 50.6514}, CountryId{"UA"}}, // 732 km
    {Coordinate{32.3658, 50.5883}, CountryId{"UA"}}, // 738 km
    {Coordinate{32.395, 50.5463}, CountryId{"UA"}}, // 746 km
    {Coordinate{32.3893, 50.5107}, CountryId{"UA"}}, // 750 km
    {Coordinate{32.0467, 49.4845}, CountryId{"UA"}}, // 882 km
    {Coordinate{32.0197, 49.3986}, CountryId{"UA"}}, // 894 km
    {Coordinate{31.996, 49.3699}, CountryId{"UA"}}, // 898 km
    {Coordinate{33.5075, 47.9514}, CountryId{"UA"}}, // 91 km
    {Coordinate{40.0908, 48.0619}, CountryId{"RU"}}, // Q16687943
    {Coordinate{32.8193, 47.0927}, CountryId{"UA"}}, // Q16689312
    {Coordinate{30.5993, 48.3388}, CountryId{"UA"}}, // Yemylivka
    {Coordinate{30.2697, 46.7192}, CountryId{"UA"}}, // Yeremiivka
    {Coordinate{36.5583, 56.5042}, CountryId{"RU"}}, // Puteprovodnaya
    {Coordinate{38.0947, 56.1156}, CountryId{"RU"}}, // Putilovo
    {Coordinate{32.8595, 47.0357}, CountryId{"UA"}}, // Q16689659
    {Coordinate{29.9387, 47.1821}, CountryId{"UA"}}, // Ivanivka
    {Coordinate{24.0581, 50.8285}, CountryId{"UA"}}, // Q16689895
    {Coordinate{27.7308, 48.5425}, CountryId{"UA"}}, // Q16689914
    {Coordinate{30.6293, 46.3223}, CountryId{"UA"}}, // Q16689983
    {Coordinate{23.0455, 48.3162}, CountryId{"UA"}}, // Q16690359
    {Coordinate{31.2177, 48.9913}, CountryId{"UA"}}, // Iskrene
    {Coordinate{34.3486, 49.6078}, CountryId{"UA"}}, // Abazivka
    {Coordinate{32.3694, 50.7789}, CountryId{"UA"}}, // Avhustivskyi
    {Coordinate{131.985, 45.1645}, CountryId{"RU"}}, // Q16690769
    {Coordinate{41.9697, 51.4167}, CountryId{"RU"}}, // Q16690865
    {Coordinate{31.4804, 48.3544}, CountryId{"UA"}}, // Q16691145
    {Coordinate{27.6715, 49.6683}, CountryId{"UA"}}, // Adampil
    {Coordinate{34.1789, 48.3967}, CountryId{"UA"}}, // Adamivske
    {Coordinate{131.204, 44.3812}, CountryId{"RU"}}, // Rassipnaya Padi
    {Coordinate{34.5686, 45.5878}, CountryId{"UA"}}, // Azovskaya
    {Coordinate{37.6631, 54.3633}, CountryId{"RU"}}, // Revyakino
    {Coordinate{30.5607, 46.3336}, CountryId{"UA"}}, // Q16691530
    {Coordinate{29.1875, 45.7903}, CountryId{"UA"}}, // Q16691763
    {Coordinate{44.007, 56.4501}, CountryId{"RU"}}, // Rekshino
    {Coordinate{33.374, 50.5626}, CountryId{"UA"}}, // Andriyashivka
    {Coordinate{32.7599, 46.6762}, CountryId{"UA"}}, // Antonivka
    {Coordinate{26.3031, 51.3117}, CountryId{"UA"}}, // Antonivka
    {Coordinate{40.4818, 48.1853}, CountryId{"RU"}}, // Q16691925
    {Coordinate{37.5803, 47.2481}, CountryId{"UA"}}, // Aslanove
    {Coordinate{31.0459, 49.0174}, CountryId{"UA"}}, // Bahacheve
    {Coordinate{31.9328, 47.0913}, CountryId{"UA"}}, // Q16692280
    {Coordinate{31.034, 48.1243}, CountryId{"UA"}}, // Q16692314
    {Coordinate{27.7226, 49.0361}, CountryId{"UA"}}, // Bar
    {Coordinate{30.5236, 46.2533}, CountryId{"UA"}}, // Q16692330
    {Coordinate{22.4901, 48.3681}, CountryId{"UA"}}, // Barkasovo railway station
    {Coordinate{22.3858, 48.3614}, CountryId{"UA"}}, // Batiovo
    {Coordinate{22.6306, 48.2019}, CountryId{"UA"}}, // Train stations in Berehove, Zakarpattia Oblast
    {Coordinate{29.206, 46.2303}, CountryId{"UA"}}, // Q16692604
    {Coordinate{32.9922, 47.2443}, CountryId{"UA"}}, // Q16692608
    {Coordinate{30.942, 47.1924}, CountryId{"UA"}}, // Q16692644
    {Coordinate{29.5477, 48.3404}, CountryId{"UA"}}, // Bershad Railway Station
    {Coordinate{23.3273, 48.7627}, CountryId{"UA"}}, // Q16692709
    {Coordinate{28.6771, 51.0729}, CountryId{"UA"}}, // Behy
    {Coordinate{33.9211, 48.1761}, CountryId{"UA"}}, // Blahoslovennya
    {Coordinate{33.4408, 47.4093}, CountryId{"UA"}}, // Q16692794
    {Coordinate{33.0225, 50.8538}, CountryId{"UA"}}, // Q16692814
    {Coordinate{30.8857, 49.5644}, CountryId{"UA"}}, // Q16692871
    {Coordinate{33.4578, 50.2916}, CountryId{"UA"}}, // Bodakva
    {Coordinate{34.7906, 49.6592}, CountryId{"UA"}}, // Bozhkiv
    {Coordinate{28.6027, 45.7362}, CountryId{"UA"}}, // Bolgrad
    {Coordinate{22.7193, 48.1646}, CountryId{"UA"}}, // Q16692989
    {Coordinate{24.2564, 49.8605}, CountryId{"UA"}}, // Q16693099
    {Coordinate{34.038, 49.6788}, CountryId{"UA"}}, // Brateshky
    {Coordinate{33.1592, 46.4237}, CountryId{"UA"}}, // Brylivka
    {Coordinate{39.5038, 54.7305}, CountryId{"RU"}}, // Rybnoye
    {Coordinate{34.7131, 51.5684}, CountryId{"RU"}}, // Q16693286
    {Coordinate{33.3177, 48.9759}, CountryId{"UA"}}, // Burty
    {Coordinate{23.4942, 48.0561}, CountryId{"UA"}}, // Q16693532
    {Coordinate{30.7194, 46.9108}, CountryId{"UA"}}, // Q16693536
    {Coordinate{33.1961, 47.3517}, CountryId{"UA"}}, // Q16693614
    {Coordinate{26.6234, 50.033}, CountryId{"UA"}}, // Bilhorodka
    {Coordinate{33.4886, 50.6552}, CountryId{"UA"}}, // Bilovody
    {Coordinate{31.9511, 49.3082}, CountryId{"UA"}}, // Biloziria
    {Coordinate{28.0507, 51.1174}, CountryId{"UA"}}, // Bilokorovychi
    {Coordinate{32.5686, 50.989}, CountryId{"UA"}}, // Q16693765
    {Coordinate{23.9424, 49.3898}, CountryId{"UA"}}, // Q16693771
    {Coordinate{33.5978, 46.1825}, CountryId{"UA"}}, // Vadym
    {Coordinate{34.627, 49.6154}, CountryId{"UA"}}, // Vakulintsi
    {Coordinate{23.1071, 49.483}, CountryId{"UA"}}, // Vankovychi
    {Coordinate{32.6682, 51.0892}, CountryId{"UA"}}, // Varvarivskyi
    {Coordinate{22.458, 48.8985}, CountryId{"UA"}}, // Velykyi Bereznyi railway station
    {Coordinate{32.9945, 46.5075}, CountryId{"UA"}}, // Velyki Kopani
    {Coordinate{28.4939, 51.2953}, CountryId{"UA"}}, // Q16694178
    {Coordinate{27.7798, 48.6073}, CountryId{"UA"}}, // Q16694183
    {Coordinate{25.5958, 50.2808}, CountryId{"UA"}}, // Q16694212
    {Coordinate{24.6933, 51.2339}, CountryId{"UA"}}, // Q16694222
    {Coordinate{23.5883, 49.0922}, CountryId{"UA"}}, // Q16694309
    {Coordinate{33.1877, 49.6032}, CountryId{"UA"}}, // Veselyi Podil
    {Coordinate{31.2259, 47.3625}, CountryId{"UA"}}, // Q16694347
    {Coordinate{32.8101, 50.0561}, CountryId{"UA"}}, // Vyly
    {Coordinate{23.0271, 48.134}, CountryId{"UA"}}, // Vynohradiv-Zakarpatskyi
    {Coordinate{33.5297, 47.4834}, CountryId{"UA"}}, // Q16694526
    {Coordinate{31.4498, 48.1615}, CountryId{"UA"}}, // Q16694534
    {Coordinate{23.0829, 48.6048}, CountryId{"UA"}}, // Vovchyi
    {Coordinate{31.3236, 47.5735}, CountryId{"UA"}}, // Voznesensk Station
    {Coordinate{23.1842, 48.7136}, CountryId{"UA"}}, // Q16694820
    {Coordinate{31.6929, 49.1888}, CountryId{"UA"}}, // Q16694848
    {Coordinate{22.8083, 48.9818}, CountryId{"UA"}}, // Volosianka-Zakarpatska railway station
    {Coordinate{28.7117, 49.1237}, CountryId{"UA"}}, // Q16694954
    {Coordinate{34.0044, 45.8708}, CountryId{"UA"}}, // Q16695005
    {Coordinate{35.9286, 52.9272}, CountryId{"RU"}}, // Q16695020
    {Coordinate{38.2736, 48.3167}, CountryId{"UA"}}, // Q16695089
    {Coordinate{52.3551, 59.4203}, CountryId{"RU"}}, // Q16695263
    {Coordinate{26.6004, 49.1685}, CountryId{"UA"}}, // Viktoriia
    {Coordinate{40.2844, 48.2456}, CountryId{"RU"}}, // Q16695774
    {Coordinate{29.8545, 48.3401}, CountryId{"UA"}}, // Haivoron
    {Coordinate{32.7557, 46.9597}, CountryId{"UA"}}, // Q16695974
    {Coordinate{33.7541, 49.1708}, CountryId{"UA"}}, // Haleshchyna
    {Coordinate{33.9004, 49.2371}, CountryId{"UA"}}, // Q16696072
    {Coordinate{29.6378, 48.4977}, CountryId{"UA"}}, // Q16696203
    {Coordinate{29.2215, 45.8606}, CountryId{"UA"}}, // Hlavani
    {Coordinate{25.5332, 49.6171}, CountryId{"UA"}}, // Hlybochok-Velykyi
    {Coordinate{23.897, 49.7374}, CountryId{"UA"}}, // Q16696424
    {Coordinate{33.2268, 49.3999}, CountryId{"UA"}}, // Q16696434
    {Coordinate{25.3195, 50.6909}, CountryId{"UA"}}, // Q16696492
    {Coordinate{25.0064, 51.0835}, CountryId{"UA"}}, // Holoby
    {Coordinate{30.3967, 48.3599}, CountryId{"UA"}}, // Q16696551
    {Coordinate{30.6507, 48.9045}, CountryId{"UA"}}, // Hordyshivka
    {Coordinate{31.4328, 49.2677}, CountryId{"UA"}}, // Horodyshche
    {Coordinate{23.6297, 49.7897}, CountryId{"UA"}}, // Horodok
    {Coordinate{32.5006, 47.448}, CountryId{"UA"}}, // Horozhene
    {Coordinate{32.1497, 46.9933}, CountryId{"UA"}}, // Horokhivka
    {Coordinate{32.4052, 50.365}, CountryId{"UA"}}, // Q16696866
    {Coordinate{32.3032, 47.1138}, CountryId{"UA"}}, // Hreihove
    {Coordinate{32.7314, 51.1525}, CountryId{"UA"}}, // Q16696977
    {Coordinate{30.238, 48.3249}, CountryId{"UA"}}, // Q16697037
    {Coordinate{29.3634, 48.6214}, CountryId{"UA"}}, // Hubnyk
    {Coordinate{26.606, 48.7699}, CountryId{"UA"}}, // Humentsi
    {Coordinate{30.779, 48.9189}, CountryId{"UA"}}, // Husakove
    {Coordinate{23.7193, 49.1807}, CountryId{"UA"}}, // Q16697291
    {Coordinate{29.2722, 45.9453}, CountryId{"UA"}}, // Q16697379
    {Coordinate{30.5469, 46.5807}, CountryId{"UA"}}, // Dachne
    {Coordinate{29.0855, 48.5712}, CountryId{"UA"}}, // Demkivka
    {Coordinate{31.4645, 52.1181}, CountryId{"UA"}}, // Q16697604
    {Coordinate{29.736, 48.4575}, CountryId{"UA"}}, // Dzhulynka
    {Coordinate{32.6701, 47.7831}, CountryId{"UA"}}, // Dobrovilskyi
    {Coordinate{37.6853, 47.8847}, CountryId{"UA"}}, // Dolia Railway Station
    {Coordinate{22.3358, 48.6376}, CountryId{"UA"}}, // Domanyntsi
    {Coordinate{32.2906, 49.945}, CountryId{"UA"}}, // Q16698284
    {Coordinate{22.9384, 48.5455}, CountryId{"UA"}}, // Q16698300
    {Coordinate{23.5436, 49.355}, CountryId{"UA"}}, // Q16698333
    {Coordinate{30.4928, 46.1005}, CountryId{"UA"}}, // Druzhba
    {Coordinate{33.6186, 47.57}, CountryId{"UA"}}, // Q16698501
    {Coordinate{25.7528, 50.3867}, CountryId{"UA"}}, // Q16698510
    {Coordinate{22.4876, 48.8096}, CountryId{"UA"}}, // Dubrynychi railway station
    {Coordinate{45.0394, 43.3322}, CountryId{"RU"}}, // Sleptsovskaya
    {Coordinate{26.5951, 51.5607}, CountryId{"UA"}}, // Dubrovytsya
    {Coordinate{29.5075, 48.6024}, CountryId{"UA"}}, // Duklia
    {Coordinate{23.0082, 48.0129}, CountryId{"UA"}}, // Q16698664
    {Coordinate{27.9708, 51.1558}, CountryId{"UA"}}, // Dibrova-Olevska
    {Coordinate{34.1322, 45.2914}, CountryId{"UA"}}, // Elevatornaya Railway Station
    {Coordinate{22.314, 48.3951}, CountryId{"UA"}}, // Q16699007
    {Coordinate{132.026, 43.3358}, CountryId{"RU"}}, // Q16699151
    {Coordinate{37.4308, 48.2133}, CountryId{"UA"}}, // Zhelanna
    {Coordinate{29.8763, 47.8365}, CountryId{"UA"}}, // Zherebkove
    {Coordinate{23.9675, 50.0495}, CountryId{"UA"}}, // Zhovkva
    {Coordinate{23.0215, 49.2109}, CountryId{"UA"}}, // Q16699304
    {Coordinate{22.633, 48.9869}, CountryId{"UA"}}, // Zhornava
    {Coordinate{31.0123, 51.5024}, CountryId{"UA"}}, // Q16699374
    {Coordinate{31.1569, 59.7281}, CountryId{"RU"}}, // Q16699435
    {Coordinate{24.2517, 51.6292}, CountryId{"UA"}}, // Q16699507
    {Coordinate{24.9764, 50.0378}, CountryId{"UA"}}, // Q16699508
    {Coordinate{24.4406, 49.8778}, CountryId{"UA"}}, // Q16699647
    {Coordinate{26.3204, 49.1119}, CountryId{"UA"}}, // Zakupne
    {Coordinate{23.1055, 48.6733}, CountryId{"UA"}}, // Zanka
    {Coordinate{24.2238, 49.9214}, CountryId{"UA"}}, // Q16699881
    {Coordinate{32.4209, 47.025}, CountryId{"UA"}}, // Zasillia
    {Coordinate{29.8787, 47.336}, CountryId{"UA"}}, // Zatyshshya
    {Coordinate{23.6756, 49.8403}, CountryId{"UA"}}, // Zatoka
    {Coordinate{32.3368, 50.6017}, CountryId{"UA"}}, // Q16700068
    {Coordinate{25.1328, 49.6918}, CountryId{"UA"}}, // Zboriv Railway Station
    {Coordinate{30.9833, 48.9824}, CountryId{"UA"}}, // Zvenyhorodka
    {Coordinate{24.9091, 50.518}, CountryId{"UA"}}, // Q16700109
    {Coordinate{32.7576, 48.0617}, CountryId{"UA"}}, // Zhoda
    {Coordinate{26.257, 50.528}, CountryId{"UA"}}, // Zdolbuniv
    {Coordinate{33.5025, 48.5081}, CountryId{"UA"}}, // Zelena
    {Coordinate{31.6056, 47.2518}, CountryId{"UA"}}, // Q16700166
    {Coordinate{32.0775, 49.6567}, CountryId{"UA"}}, // Zolotonosha 1
    {Coordinate{24.8914, 49.7889}, CountryId{"UA"}}, // Zolochiv
    {Coordinate{29.4447, 48.7103}, CountryId{"UA"}}, // Ziatkivtsi
    {Coordinate{30.5206, 51.4964}, CountryId{"BY"}}, // Yolcha
    {Coordinate{30.732, 48.2472}, CountryId{"UA"}}, // Q16700505
    {Coordinate{31.2727, 47.9101}, CountryId{"UA"}}, // Q16700548
    {Coordinate{33.4619, 49.1411}, CountryId{"UA"}}, // Kahamlytska Railway Station
    {Coordinate{33.4664, 46.2544}, CountryId{"UA"}}, // Kalanchak
    {Coordinate{23.2947, 49.5578}, CountryId{"UA"}}, // Q16700661
    {Coordinate{28.4761, 49.4565}, CountryId{"UA"}}, // Q16700669
    {Coordinate{32.9467, 47.162}, CountryId{"UA"}}, // Q16700722
    {Coordinate{30.7859, 47.9123}, CountryId{"UA"}}, // Q16700746
    {Coordinate{25.7, 50.3511}, CountryId{"UA"}}, // Q16700748
    {Coordinate{22.4144, 48.6924}, CountryId{"UA"}}, // Kamianytsia railway station
    {Coordinate{30.0806, 46.1114}, CountryId{"UA"}}, // Kantemyr
    {Coordinate{31.5513, 48.4715}, CountryId{"UA"}}, // Q16700899
    {Coordinate{33.0119, 51.5451}, CountryId{"UA"}}, // Q16701067
    {Coordinate{30.5322, 46.1447}, CountryId{"UA"}}, // Karolina-Buhaz
    {Coordinate{28.9606, 48.926}, CountryId{"UA"}}, // Q16701098
    {Coordinate{22.8786, 48.5229}, CountryId{"UA"}}, // Karpaty
    {Coordinate{30.3328, 46.6872}, CountryId{"UA"}}, // Karpove
    {Coordinate{11.7931, 60.7234}, CountryId{"NO"}}, // Braskereidfoss Station
    {Coordinate{33.4687, 49.9459}, CountryId{"UA"}}, // Kybyntsi
    {Coordinate{28.9934, 48.5786}, CountryId{"UA"}}, // Kyrnasivka
    {Coordinate{30.4109, 50.4523}, CountryId{"UA"}}, // Hrushky Railway Station
    {Coordinate{26.0275, 50.7511}, CountryId{"UA"}}, // Klevan
    {Coordinate{26.7594, 50.0567}, CountryId{"UA"}}, // Q16701606
    {Coordinate{26.8916, 51.3115}, CountryId{"UA"}}, // Klesiv
    {Coordinate{28.4974, 50.9979}, CountryId{"UA"}}, // Klochki
    {Coordinate{22.6415, 48.4092}, CountryId{"UA"}}, // Q16701705
    {Coordinate{31.3797, 59.6383}, CountryId{"RU"}}, // Q16701735
    {Coordinate{29.1214, 48.0912}, CountryId{"UA"}}, // Kodyma
    {Coordinate{33.8452, 49.2199}, CountryId{"UA"}}, // Kozelschina
    {Coordinate{28.7832, 49.7571}, CountryId{"UA"}}, // Kozyatyn 2
    {Coordinate{24.2752, 50.0018}, CountryId{"UA"}}, // Q16702132
    {Coordinate{32.3597, 50.7232}, CountryId{"UA"}}, // Q16702146
    {Coordinate{22.7693, 48.4654}, CountryId{"UA"}}, // Q16702209
    {Coordinate{23.68, 49.6577}, CountryId{"UA"}}, // Q16702240
    {Coordinate{23.7515, 49.2156}, CountryId{"UA"}}, // Q16702504
    {Coordinate{27.7544, 48.8838}, CountryId{"UA"}}, // Kopai
    {Coordinate{32.3074, 46.8096}, CountryId{"UA"}}, // Kopani
    {Coordinate{23.1407, 48.1534}, CountryId{"UA"}}, // Korolevo station
    {Coordinate{33.2233, 48.5761}, CountryId{"UA"}}, // Korolivka
    {Coordinate{32.9801, 51.5611}, CountryId{"UA"}}, // Korop
    {Coordinate{23.5705, 49.6687}, CountryId{"UA"}}, // Q16702763
    {Coordinate{31.3117, 49.4301}, CountryId{"UA"}}, // Korsun
    {Coordinate{22.4664, 48.287}, CountryId{"UA"}}, // Q16702836
    {Coordinate{26.4439, 50.8711}, CountryId{"UA"}}, // Q16702895
    {Coordinate{22.6008, 48.945}, CountryId{"UA"}}, // Q16702901
    {Coordinate{28.9764, 45.6268}, CountryId{"UA"}}, // Q16702947
    {Coordinate{32.1808, 46.8661}, CountryId{"UA"}}, // Kotlyareve
    {Coordinate{27.7535, 48.7883}, CountryId{"UA"}}, // Q16702979
    {Coordinate{46.8235, 43.2091}, CountryId{"RU"}}, // Q16703021
    {Coordinate{34.9697, 49.7419}, CountryId{"UA"}}, // Kochubejivka
    {Coordinate{40.0928, 47.8811}, CountryId{"RU"}}, // Sulin railway station
    {Coordinate{30.3104, 47.0078}, CountryId{"UA"}}, // Q16703206
    {Coordinate{34.2164, 45.4017}, CountryId{"UA"}}, // Krasnopartyzanska
    {Coordinate{33.0969, 51.5324}, CountryId{"UA"}}, // Q16703230
    {Coordinate{30.7846, 46.7373}, CountryId{"UA"}}, // Kremydivka Train Station
    {Coordinate{28.2433, 51.0751}, CountryId{"UA"}}, // Kremne
    {Coordinate{34.5875, 49.6028}, CountryId{"UA"}}, // Kryvokhatky
    {Coordinate{46.4797, 58.3464}, CountryId{"RU"}}, // Q16703417
    {Coordinate{24.3769, 51.5343}, CountryId{"UA"}}, // Q16703438
    {Coordinate{103.949, 52.5005}, CountryId{"RU"}}, // Q16703602
    {Coordinate{30.6215, 46.3633}, CountryId{"UA"}}, // Q16703703
    {Coordinate{29.647, 48.6738}, CountryId{"UA"}}, // Kublych
    {Coordinate{48.475, 53.15}, CountryId{"RU"}}, // Syzran-Gorod railway station
    {Coordinate{29.913, 46.0402}, CountryId{"UA"}}, // Kulevcha
    {Coordinate{34.007, 49.2254}, CountryId{"UA"}}, // Q16704032
    {Coordinate{30.7931, 46.6337}, CountryId{"UA"}}, // Q16704044
    {Coordinate{32.0694, 46.9155}, CountryId{"UA"}}, // Kulbakyne
    {Coordinate{114.834, 56.3594}, CountryId{"RU"}}, // Taksimo
    {Coordinate{30.0025, 46.7538}, CountryId{"UA"}}, // Q16704324
    {Coordinate{25.4728, 50.8317}, CountryId{"UA"}}, // Kivertsi
    {Coordinate{30.8447, 47.9672}, CountryId{"UA"}}, // Kinetspil
    {Coordinate{41.4284, 52.719}, CountryId{"RU"}}, // Tambov I
    {Coordinate{23.3576, 48.8106}, CountryId{"UA"}}, // Lavochne Railway Station
    {Coordinate{29.24, 48.6304}, CountryId{"UA"}}, // Ladyzhyn
    {Coordinate{44.1942, 56.6827}, CountryId{"RU"}}, // Q16704653
    {Coordinate{26.7496, 48.5224}, CountryId{"UA"}}, // Q16704793
    {Coordinate{26.2149, 49.9555}, CountryId{"UA"}}, // Q16704842
    {Coordinate{33.0668, 47.3001}, CountryId{"UA"}}, // Q16704844
    {Coordinate{30.5129, 46.129}, CountryId{"UA"}}, // Lymanska
    {Coordinate{32.376, 50.4725}, CountryId{"UA"}}, // Q16704911
    {Coordinate{29.2284, 49.2475}, CountryId{"UA"}}, // Lypovets
    {Coordinate{32.377, 47.2048}, CountryId{"UA"}}, // Lotskyne
    {Coordinate{28.3798, 51.035}, CountryId{"UA"}}, // Luhyny
    {Coordinate{25.3511, 50.758}, CountryId{"UA"}}, // Lutsk Railway Station
    {Coordinate{23.6951, 49.1498}, CountryId{"UA"}}, // Q16705489
    {Coordinate{24.8255, 51.1619}, CountryId{"UA"}}, // Lyubytiv
    {Coordinate{24.6206, 51.1797}, CountryId{"UA"}}, // Lyublynets-Volynskiy
    {Coordinate{26.3744, 50.7681}, CountryId{"UA"}}, // Q16705510
    {Coordinate{24.0408, 51.2156}, CountryId{"UA"}}, // Lyuboml
    {Coordinate{23.7317, 49.7153}, CountryId{"UA"}}, // Q16705527
    {Coordinate{31.4481, 48.0288}, CountryId{"UA"}}, // Liudmylivka Railway Station
    {Coordinate{142.587, 47.1131}, CountryId{"JP"}}, // Q16705556
    {Coordinate{33.1637, 48.8217}, CountryId{"UA"}}, // Q16705656
    {Coordinate{26.4712, 49.1466}, CountryId{"UA"}}, // Lisovody
    {Coordinate{33.485, 47.8958}, CountryId{"UA"}}, // Q16705745
    {Coordinate{34.2669, 49.2602}, CountryId{"UA"}}, // Lischynivka
    {Coordinate{25.9083, 49.5966}, CountryId{"UA"}}, // Q16706011
    {Coordinate{32.83, 48.0517}, CountryId{"UA"}}, // Tymkove
    {Coordinate{25.5334, 51.2931}, CountryId{"UA"}}, // Manevychi railway station
    {Coordinate{29.7391, 47.5364}, CountryId{"UA"}}, // Mardarivka
    {Coordinate{31.2791, 47.4687}, CountryId{"UA"}}, // Q16706407
    {Coordinate{27.9469, 49.0401}, CountryId{"UA"}}, // Mateikove
    {Coordinate{33.8542, 49.8554}, CountryId{"UA"}}, // Matyashivka
    {Coordinate{24.3642, 51.2406}, CountryId{"UA"}}, // Matseiv
    {Coordinate{32.2315, 49.8676}, CountryId{"UA"}}, // Mekhedivka
    {Coordinate{30.0483, 46.9869}, CountryId{"UA"}}, // Myhajeve
    {Coordinate{23.9535, 49.5116}, CountryId{"UA"}}, // Q16707010
    {Coordinate{33.7507, 49.9356}, CountryId{"UA"}}, // Mylashenkove
    {Coordinate{26.7228, 51.6961}, CountryId{"UA"}}, // Mylyachi
    {Coordinate{34.7108, 49.5086}, CountryId{"UA"}}, // Q16707070
    {Coordinate{27.775, 48.4577}, CountryId{"UA"}}, // Mohyliv-Podilskyi railway station
    {Coordinate{26.515, 50.9847}, CountryId{"UA"}}, // Q16707329
    {Coordinate{29.7127, 49.006}, CountryId{"UA"}}, // Monastyrysche
    {Coordinate{23.8746, 49.1501}, CountryId{"UA"}}, // Q16707509
    {Coordinate{23.1292, 49.8183}, CountryId{"UA"}}, // Mostyska  I
    {Coordinate{23.0328, 49.8167}, CountryId{"UA"}}, // Mostyska II
    {Coordinate{24.6189, 51.2913}, CountryId{"UA"}}, // Q16707606
    {Coordinate{37.5151, 56.1209}, CountryId{"RU"}}, // Trudovaya
    {Coordinate{23.7756, 49.83}, CountryId{"UA"}}, // Mshana
    {Coordinate{32.0902, 46.979}, CountryId{"UA"}}, // Q16708427
    {Coordinate{31.2419, 59.6908}, CountryId{"RU"}}, // Q16708683
    {Coordinate{30.637, 51.5117}, CountryId{"UA"}}, // Nedanchychi
    {Coordinate{27.7588, 48.6824}, CountryId{"UA"}}, // Q16708915
    {Coordinate{28.875, 48.9902}, CountryId{"UA"}}, // Nemyriv
    {Coordinate{26.5739, 51.2019}, CountryId{"UA"}}, // Q16708937
    {Coordinate{25.156, 50.6114}, CountryId{"UA"}}, // Q16708979
    {Coordinate{23.6406, 49.1034}, CountryId{"UA"}}, // Q16709066
    {Coordinate{32.7689, 47.9639}, CountryId{"UA"}}, // Novodanylivka
    {Coordinate{33.3261, 47.3748}, CountryId{"UA"}}, // Q16709201
    {Coordinate{31.3996, 47.299}, CountryId{"UA"}}, // Q16709210
    {Coordinate{33.3137, 46.3387}, CountryId{"UA"}}, // Novokyivka
    {Coordinate{32.6039, 47.0608}, CountryId{"UA"}}, // Q16709243
    {Coordinate{32.5174, 47.5386}, CountryId{"UA"}}, // Novopoltavka
    {Coordinate{26.6076, 48.8263}, CountryId{"UA"}}, // Q16709460
    {Coordinate{26.1796, 50.6762}, CountryId{"UA"}}, // Obariv
    {Coordinate{23.8926, 49.7813}, CountryId{"UA"}}, // Q16709645
    {Coordinate{29.5247, 47.8551}, CountryId{"UA"}}, // Q16709672
    {Coordinate{24.3853, 50.9283}, CountryId{"UA"}}, // Q16709684
    {Coordinate{28.818, 51.3248}, CountryId{"UA"}}, // Ovruch Railway Station
    {Coordinate{30.6542, 46.4782}, CountryId{"UA"}}, // Odesa-Zastava 1st
    {Coordinate{30.6535, 46.4387}, CountryId{"UA"}}, // Odessa-Zakhidna
    {Coordinate{30.7261, 46.455}, CountryId{"UA"}}, // Odesa-Mala
    {Coordinate{30.7264, 46.525}, CountryId{"UA"}}, // Q16709739
    {Coordinate{30.7871, 46.5953}, CountryId{"UA"}}, // Odesa-Skhidna
    {Coordinate{25.3345, 49.6423}, CountryId{"UA"}}, // Ozerna
    {Coordinate{27.6479, 51.2284}, CountryId{"UA"}}, // Olevsk
    {Coordinate{48.3217, 54.2717}, CountryId{"RU"}}, // Ulyanovsk-Tsentralny
    {Coordinate{31.3005, 47.6424}, CountryId{"UA"}}, // Q16709938
    {Coordinate{25.7391, 50.7833}, CountryId{"UA"}}, // Olyka
    {Coordinate{31.4828, 48.0989}, CountryId{"UA"}}, // Q16710075
    {Coordinate{23.343, 48.787}, CountryId{"UA"}}, // Q16710165
    {Coordinate{29.3902, 49.1753}, CountryId{"UA"}}, // Orativ
    {Coordinate{30.9229, 48.0498}, CountryId{"UA"}}, // Orlyk
    {Coordinate{32.6445, 51.0655}, CountryId{"UA"}}, // Q16710317
    {Coordinate{27.3683, 51.263}, CountryId{"UA"}}, // Ostky
    {Coordinate{103.65, 52.7296}, CountryId{"RU"}}, // Usolye-Siberian
    {Coordinate{37.6128, 48.2403}, CountryId{"UA"}}, // Q16710600
    {Coordinate{102.735, 57.9453}, CountryId{"RU"}}, // Ust-Ilimsk
    {Coordinate{58.1836, 54.9364}, CountryId{"RU"}}, // Ust-Katav
    {Coordinate{33.3389, 48.9117}, CountryId{"UA"}}, // Pavlysh
    {Coordinate{35.8537, 48.5504}, CountryId{"UA"}}, // Pavlohrad 1st
    {Coordinate{35.9619, 48.4936}, CountryId{"UA"}}, // Pavlohrad 2nd
    {Coordinate{104.061, 51.5414}, CountryId{"RU"}}, // Q16710729
    {Coordinate{32.1531, 49.761}, CountryId{"UA"}}, // Palmira
    {Coordinate{32.8835, 48.6759}, CountryId{"UA"}}, // Pantaivka
    {Coordinate{94.3297, 55.8053}, CountryId{"RU"}}, // Uyar station
    {Coordinate{32.3523, 50.1329}, CountryId{"UA"}}, // Parijskaya Kommuna
    {Coordinate{22.906, 48.5349}, CountryId{"UA"}}, // Q16711104
    {Coordinate{31.7625, 49.2214}, CountryId{"UA"}}, // Perehonivka
    {Coordinate{29.7319, 47.8729}, CountryId{"UA"}}, // Q16711280
    {Coordinate{25.1554, 50.9887}, CountryId{"UA"}}, // Perespa
    {Coordinate{29.7954, 47.4385}, CountryId{"UA"}}, // Perekhrestove
    {Coordinate{22.4782, 48.733}, CountryId{"UA"}}, // Perechyn railway station
    {Coordinate{32.3419, 50.025}, CountryId{"UA"}}, // Q16711626
    {Coordinate{29.5141, 47.8096}, CountryId{"UA"}}, // Poberezhzhya
    {Coordinate{25.1322, 51.2719}, CountryId{"UA"}}, // Povorsk
    {Coordinate{29.2948, 49.4383}, CountryId{"UA"}}, // Pohrebysche 1
    {Coordinate{30.2082, 48.93}, CountryId{"UA"}}, // Podibne
    {Coordinate{28.9757, 48.2152}, CountryId{"UA"}}, // Popelyukhy
    {Coordinate{28.7681, 51.2255}, CountryId{"UA"}}, // Potapovychi
    {Coordinate{30.3289, 48.9201}, CountryId{"UA"}}, // Potash
    {Coordinate{33.6198, 49.1265}, CountryId{"UA"}}, // Q16712474
    {Coordinate{27.8068, 51.2058}, CountryId{"UA"}}, // Poyasky
    {Coordinate{34.0714, 45.2017}, CountryId{"RU"}}, // Q16713308
    {Coordinate{31.2691, 48.9945}, CountryId{"UA"}}, // Prudianka
    {Coordinate{23.9085, 49.7165}, CountryId{"UA"}}, // Q16713541
    {Coordinate{31.2629, 47.82}, CountryId{"UA"}}, // Pivdennoukrainska
    {Coordinate{24.1287, 49.8473}, CountryId{"UA"}}, // Q16713656
    {Coordinate{23.9562, 49.4497}, CountryId{"UA"}}, // Q16713837
    {Coordinate{32.9443, 46.5639}, CountryId{"UA"}}, // Radenske
    {Coordinate{24.6256, 50.2842}, CountryId{"UA"}}, // Q16713914
    {Coordinate{31.9993, 49.0967}, CountryId{"UA"}}, // Raihorod
    {Coordinate{30.8317, 47.1699}, CountryId{"UA"}}, // Q16714076
    {Coordinate{25.9989, 51.3067}, CountryId{"UA"}}, // Rafalivka
    {Coordinate{28.472, 48.7888}, CountryId{"UA"}}, // Rakhny
    {Coordinate{29.2793, 51.3524}, CountryId{"UA"}}, // Q16714098
    {Coordinate{26.2797, 50.7056}, CountryId{"UA"}}, // Q16714318
    {Coordinate{33.3129, 50.8166}, CountryId{"UA"}}, // Rohyntsi
    {Coordinate{23.5114, 49.7931}, CountryId{"UA"}}, // Q16714477
    {Coordinate{25.2607, 50.9097}, CountryId{"UA"}}, // Rozhyshche
    {Coordinate{32.5202, 50.9365}, CountryId{"UA"}}, // Q16714526
    {Coordinate{30.0447, 46.8889}, CountryId{"UA"}}, // Rozdilna-Sortuvalna
    {Coordinate{30.0739, 46.8504}, CountryId{"UA"}}, // Rozdilna 1st
    {Coordinate{29.791, 48.7531}, CountryId{"UA"}}, // Rozkoshivka
    {Coordinate{30.8571, 48.9554}, CountryId{"UA"}}, // Rozsokhuvatka
    {Coordinate{30.0504, 48.7771}, CountryId{"UA"}}, // Rozsishky
    {Coordinate{27.2207, 51.2712}, CountryId{"UA"}}, // Rokytne-Volynske
    {Coordinate{23.1783, 48.1949}, CountryId{"UA"}}, // Q16714630
    {Coordinate{33.4684, 50.7491}, CountryId{"UA"}}, // Romny Station
    {Coordinate{30.4496, 46.9915}, CountryId{"UA"}}, // Q16714791
    {Coordinate{5.65167, 53.0322}, CountryId{"NL"}}, // Sneek railway station
    {Coordinate{32.9449, 50.9374}, CountryId{"UA"}}, // Rubanka
    {Coordinate{33.3343, 49.2508}, CountryId{"UA"}}, // Q16714834
    {Coordinate{23.4983, 49.6414}, CountryId{"UA"}}, // Rudki
    {Coordinate{28.9344, 48.2606}, CountryId{"UA"}}, // Rudnytsia
    {Coordinate{25.4978, 50.223}, CountryId{"UA"}}, // Q16714886
    {Coordinate{23.2122, 49.5167}, CountryId{"UA"}}, // Sambir railway station
    {Coordinate{29.079, 48.873}, CountryId{"UA"}}, // Samchyntsi
    {Coordinate{24.3379, 50.084}, CountryId{"UA"}}, // Q16715391
    {Coordinate{29.6794, 46.0158}, CountryId{"UA"}}, // Sarata
    {Coordinate{26.6029, 51.3388}, CountryId{"UA"}}, // Sarny
    {Coordinate{37.5739, 47.1536}, CountryId{"UA"}}, // Sartana
    {Coordinate{22.988, 48.5516}, CountryId{"UA"}}, // Q16715494
    {Coordinate{34.6894, 49.625}, CountryId{"UA"}}, // Svynkivka
    {Coordinate{33.255, 49.0457}, CountryId{"UA"}}, // Q16715673
    {Coordinate{27.001, 50.2254}, CountryId{"UA"}}, // Selo Kam'yanka
    {Coordinate{30.1059, 51.3957}, CountryId{"UA"}}, // Semikhody
    {Coordinate{30.7535, 47.0084}, CountryId{"UA"}}, // Q16716000
    {Coordinate{31.3974, 48.9954}, CountryId{"UA"}}, // Signajivka
    {Coordinate{29.1835, 48.9036}, CountryId{"UA"}}, // Sytkivtsi
    {Coordinate{30.4122, 59.0833}, CountryId{"RU"}}, // Q16716404
    {Coordinate{23.5046, 49.0341}, CountryId{"UA"}}, // Skole
    {Coordinate{35.0678, 49.7781}, CountryId{"UA"}}, // Skorohodove
    {Coordinate{23.2638, 48.7263}, CountryId{"UA"}}, // Q16716628
    {Coordinate{23.4446, 48.8486}, CountryId{"UA"}}, // Q16716695
    {Coordinate{30.753, 51.5153}, CountryId{"UA"}}, // Slavutych Railway Station
    {Coordinate{24.2567, 50.4644}, CountryId{"UA"}}, // Q16717090
    {Coordinate{22.8878, 49.0831}, CountryId{"UA"}}, // Sokolyky railway station
    {Coordinate{33.0365, 49.9812}, CountryId{"UA"}}, // Solonytska
    {Coordinate{23.877, 47.9498}, CountryId{"UA"}}, // Solotvyno 1
    {Coordinate{23.882, 47.9589}, CountryId{"UA"}}, // Solotvyno 2
    {Coordinate{22.5378, 48.9512}, CountryId{"UA"}}, // Solia
    {Coordinate{33.4798, 45.1611}, CountryId{"UA"}}, // Q16717243
    {Coordinate{30.48, 46.0875}, CountryId{"UA"}}, // Soniachna train halt
    {Coordinate{34.0037, 48.2422}, CountryId{"UA"}}, // Q16717279
    {Coordinate{24.2628, 50.2917}, CountryId{"UA"}}, // Q16717330
    {Coordinate{31.203, 49.49}, CountryId{"UA"}}, // Sotnyky
    {Coordinate{31.8906, 49.1355}, CountryId{"UA"}}, // Sofiivka
    {Coordinate{22.7063, 48.9923}, CountryId{"UA"}}, // Stavne railway station
    {Coordinate{23.8487, 49.7452}, CountryId{"UA"}}, // Q16717727
    {Coordinate{36.3472, 54.1014}, CountryId{"RU"}}, // Q16717830
    {Coordinate{23.0037, 49.4412}, CountryId{"UA"}}, // Q16717852
    {Coordinate{27.2789, 49.7336}, CountryId{"UA"}}, // Starokostiantyniv-II
    {Coordinate{31.973, 49.3365}, CountryId{"UA"}}, // Stepanky
    {Coordinate{23.6746, 49.1276}, CountryId{"UA"}}, // Q16718137
    {Coordinate{24.6666, 50.378}, CountryId{"UA"}}, // Q16718200
    {Coordinate{22.5662, 48.3875}, CountryId{"UA"}}, // Q16718203
    {Coordinate{26.7545, 51.3302}, CountryId{"UA"}}, // Strashiv
    {Coordinate{32.6942, 46.7841}, CountryId{"UA"}}, // Q16718320
    {Coordinate{22.2447, 48.5122}, CountryId{"UA"}}, // Q16718381
    {Coordinate{22.9897, 49.3366}, CountryId{"UA"}}, // Q16718403
    {Coordinate{26.5847, 51.432}, CountryId{"UA"}}, // Strilsk
    {Coordinate{30.5569, 46.1653}, CountryId{"UA"}}, // Q16718435
    {Coordinate{23.3844, 49.7992}, CountryId{"UA"}}, // Sudova Vyshnia
    {Coordinate{34.5075, 46.012}, CountryId{"UA"}}, // Chonhar
    {Coordinate{27.7037, 48.49}, CountryId{"UA"}}, // Sulyatytska Railway Station
    {Coordinate{34.4757, 49.5894}, CountryId{"UA"}}, // Suprunivka
    {Coordinate{26.3815, 49.9994}, CountryId{"UA"}}, // Sukhovolya
    {Coordinate{22.902, 49.0232}, CountryId{"UA"}}, // Sianky railway station
    {Coordinate{34.3746, 46.9423}, CountryId{"UA"}}, // Sirohozy Train Station
    {Coordinate{33.1412, 50.8466}, CountryId{"UA"}}, // Talalaivka
    {Coordinate{30.7231, 48.8954}, CountryId{"UA"}}, // Talne
    {Coordinate{33.1555, 49.987}, CountryId{"UA"}}, // Tarnavshchyna
    {Coordinate{30.1025, 48.3771}, CountryId{"UA"}}, // Q16719214
    {Coordinate{28.9221, 45.5185}, CountryId{"UA"}}, // Q16719233
    {Coordinate{46.6172, 57.6719}, CountryId{"RU"}}, // Q16719684
    {Coordinate{23.6999, 47.9959}, CountryId{"UA"}}, // Teresva railway station
    {Coordinate{23.3812, 48.8268}, CountryId{"UA"}}, // Q16719799
    {Coordinate{32.9856, 49.9784}, CountryId{"UA"}}, // Terny
    {Coordinate{31.9567, 47.0561}, CountryId{"UA"}}, // Q16719828
    {Coordinate{33.5189, 45.1428}, CountryId{"UA"}}, // Q16719918
    {Coordinate{28.8754, 51.3863}, CountryId{"UA"}}, // Q16720129
    {Coordinate{27.0688, 51.3017}, CountryId{"UA"}}, // Tomashhorod
    {Coordinate{31.8144, 47.149}, CountryId{"UA"}}, // Trykhaty
    {Coordinate{25.3375, 51.2885}, CountryId{"UA"}}, // Troyanivka
    {Coordinate{23.512, 49.2827}, CountryId{"UA"}}, // Q16720460
    {Coordinate{38.4808, 55.1779}, CountryId{"RU"}}, // Shkin
    {Coordinate{23.0239, 49.1519}, CountryId{"UA"}}, // Q16720551
    {Coordinate{32.8825, 47.0957}, CountryId{"UA"}}, // Q16720560
    {Coordinate{24.5328, 51.0797}, CountryId{"UA"}}, // Q16720582
    {Coordinate{23.478, 48.92}, CountryId{"UA"}}, // Q16720590
    {Coordinate{23.5759, 48.0148}, CountryId{"UA"}}, // Q16720627
    {Coordinate{23.8964, 49.3236}, CountryId{"UA"}}, // Q16720705
    {Coordinate{26.7504, 51.7473}, CountryId{"UA"}}, // Udryts'k
    {Coordinate{22.3005, 48.6095}, CountryId{"UA"}}, // Uzhhorod
    {Coordinate{28.204, 49.5074}, CountryId{"UA"}}, // Uladivka
    {Coordinate{34.274, 49.6257}, CountryId{"UA"}}, // Umantsivka
    {Coordinate{38.4122, 55.1483}, CountryId{"RU"}}, // Shubatovo
    {Coordinate{37.5947, 54.5747}, CountryId{"RU"}}, // Shulgino
    {Coordinate{32.985, 47.9556}, CountryId{"UA"}}, // Q16721214
    {Coordinate{33.9267, 49.7712}, CountryId{"UA"}}, // Fedunka
    {Coordinate{28.8548, 49.0708}, CountryId{"UA"}}, // Ferdynandivka
    {Coordinate{133.78, 46.0384}, CountryId{"RU"}}, // Q16721614
    {Coordinate{29.9584, 48.3149}, CountryId{"UA"}}, // Q16722009
    {Coordinate{32.6616, 46.693}, CountryId{"UA"}}, // Q16722048
    {Coordinate{31.4631, 49.201}, CountryId{"UA"}}, // Khlystunivka
    {Coordinate{27.9845, 49.5591}, CountryId{"UA"}}, // Q16722127
    {Coordinate{28.3468, 49.4918}, CountryId{"UA"}}, // Kholonivska
    {Coordinate{33.2074, 49.7844}, CountryId{"UA"}}, // Q16722260
    {Coordinate{29.9726, 48.8152}, CountryId{"UA"}}, // Khrystynivka
    {Coordinate{31.5292, 49.1537}, CountryId{"UA"}}, // Tsvitkove
    {Coordinate{32.4123, 48.8442}, CountryId{"UA"}}, // Tsybuleve
    {Coordinate{25.8839, 50.7732}, CountryId{"UA"}}, // Tsuman
    {Coordinate{32.8346, 46.6312}, CountryId{"UA"}}, // Oleshky
    {Coordinate{84.8417, 55.7128}, CountryId{"RU"}}, // Yurga I
    {Coordinate{32.0747, 49.572}, CountryId{"UA"}}, // Q16722826
    {Coordinate{24.2289, 50.3967}, CountryId{"UA"}}, // Q16723109
    {Coordinate{23.9018, 49.5834}, CountryId{"UA"}}, // Q16723173
    {Coordinate{105.901, 56.8047}, CountryId{"RU"}}, // Q16723195
    {Coordinate{54.9292, 56.2721}, CountryId{"RU"}}, // Q16723277
    {Coordinate{32.4189, 46.7672}, CountryId{"UA"}}, // Chekhovychi
    {Coordinate{22.8478, 48.4926}, CountryId{"UA"}}, // Q16723371
    {Coordinate{22.8152, 48.4827}, CountryId{"UA"}}, // Q16723373
    {Coordinate{52.1111, 58.2486}, CountryId{"RU"}}, // Yar
    {Coordinate{22.2056, 48.4328}, CountryId{"UA"}}, // Chop
    {Coordinate{32.5293, 46.7182}, CountryId{"UA"}}, // Chornobaivka
    {Coordinate{30.76, 46.8278}, CountryId{"UA"}}, // Chornomorska
    {Coordinate{25.8344, 51.2996}, CountryId{"UA"}}, // Chortoryisk
    {Coordinate{29.5834, 47.6521}, CountryId{"UA"}}, // Chubivka
    {Coordinate{26.6068, 57.0708}, CountryId{"LV"}}, // Q16723542
    {Coordinate{30.5342, 48.9185}, CountryId{"UA"}}, // Q16723616
    {Coordinate{34.557, 49.6308}, CountryId{"UA"}}, // Shvedska Mohyla
    {Coordinate{22.8186, 49.008}, CountryId{"UA"}}, // Shcherbyn railway station
    {Coordinate{23.8594, 49.6465}, CountryId{"UA"}}, // Q16723966
    {Coordinate{23.8701, 49.6558}, CountryId{"UA"}}, // Q16723967
    {Coordinate{28.5798, 48.7015}, CountryId{"UA"}}, // Yurkivka
    {Coordinate{32.4704, 47.3193}, CountryId{"UA"}}, // Yavkyne
    {Coordinate{23.0724, 49.1869}, CountryId{"UA"}}, // Q16724083
    {Coordinate{23.8958, 51.1981}, CountryId{"UA"}}, // Yahodyn
    {Coordinate{33.6178, 48.4524}, CountryId{"UA"}}, // Yakovlivka
    {Coordinate{33.8832, 49.8152}, CountryId{"UA"}}, // Yaresky
    {Coordinate{30.117, 48.9124}, CountryId{"UA"}}, // Yarovatka
    {Coordinate{22.9795, 49.276}, CountryId{"UA"}}, // Q16724256
    {Coordinate{31.7171, 47.1876}, CountryId{"UA"}}, // Q16724261
    {Coordinate{32.093, 50.7947}, CountryId{"UA"}}, // Q16724277
    {Coordinate{8.26977, 47.3485}, CountryId{"CH"}}, // Wohlen railway station
    {Coordinate{4.63635, 49.6501}, CountryId{"FR"}}, // Gare de Poix-Terron
    {Coordinate{}, CountryId{"FR"}}, // Gare Solférino
    {Coordinate{107.68, 51.8242}, CountryId{"RU"}}, // Zaudinskiy railway station
    {Coordinate{9.72278, 52.3527}, CountryId{"DE"}}, // Hannover-Linden station
    {Coordinate{8.72782, 48.5555}, CountryId{"DE"}}, // Bahnhof Nagold
    {Coordinate{11.5804, 50.0937}, CountryId{"DE"}}, // Q16830553
    {Coordinate{11.5954, 49.8106}, CountryId{"DE"}}, // Bahnhof Schnabelwaid
    {Coordinate{8.5302, 49.2919}, CountryId{"DE"}}, // Neulußheim station
    {Coordinate{12.5361, 55.6636}, CountryId{"DK"}}, // Carlsberg station
    {Coordinate{78.7803, 28.4586}, CountryId{"IN"}}, // Chandausi railway station
    {Coordinate{79.0778, 12.2381}, CountryId{"IN"}}, // Tiruvannamalai Town railway station
    {Coordinate{75.8585, 22.7423}, CountryId{"IN"}}, // Laxmibai Nagar Junction railway station
    {Coordinate{79.0907, 12.337}, CountryId{"IN"}}, // Turinjapuram railway station
    {Coordinate{11.5936, 50.9368}, CountryId{"DE"}}, // Jena Saalbahnhof
    {Coordinate{78.7213, 12.7829}, CountryId{"IN"}}, // Ambur railway station
    {Coordinate{78.1019, 9.52463}, CountryId{"IN"}}, // Aruppukkottai railway station
    {Coordinate{79.3486, 19.849}, CountryId{"IN"}}, // Balharshah railway station
    {Coordinate{91.1763, 26.4975}, CountryId{"IN"}}, // Pathsala railway station
    {Coordinate{8.23008, 50.3327}, CountryId{"DE"}}, // Niederselters station
    {Coordinate{72.7854, 24.4807}, CountryId{"IN"}}, // Abu Road railway station
    {Coordinate{76.8221, 30.702}, CountryId{"IN"}}, // Chandigarh Junction railway station
    {Coordinate{75.7888, 13.3039}, CountryId{"IN"}}, // Chikkamagaluru railway station
    {Coordinate{74.0254, 30.4086}, CountryId{"IN"}}, // Fazilka railway station
    {Coordinate{74.6184, 30.9425}, CountryId{"IN"}}, // Firozpur Cantonment railway station
    {Coordinate{10.91, 52.2138}, CountryId{"DE"}}, // Frellstedt railway station
    {Coordinate{76.8244, 17.3144}, CountryId{"IN"}}, // Kalaburagi Junction railway station
    {Coordinate{77.3666, 15.1756}, CountryId{"IN"}}, // Guntakal junction railway station
    {Coordinate{12.0279, 51.4548}, CountryId{"DE"}}, // Halle Messe railway station
    {Coordinate{75.5915, 31.3317}, CountryId{"IN"}}, // Jalandhar City Junction railway station
    {Coordinate{75.6321, 31.3062}, CountryId{"IN"}}, // Jalandhar Cantonment railway station
    {Coordinate{75.8245, 29.8018}, CountryId{"IN"}}, // Jakhal Junction railway station
    {Coordinate{76.2896, 29.3289}, CountryId{"IN"}}, // Jind Junction railway station
    {Coordinate{73.0232, 26.2838}, CountryId{"IN"}}, // Jodhpur railway station
    {Coordinate{79.839, 10.9171}, CountryId{"IN"}}, // Karaikal railway station
    {Coordinate{80.3912, 23.8312}, CountryId{"IN"}}, // Katni Murwara Junction railway station
    {Coordinate{74.9353, 32.9822}, CountryId{"IN"}}, // Katra railway station
    {Coordinate{79.511, 17.9742}, CountryId{"IN"}}, // Kazipet railway station
    {Coordinate{81.2589, 18.6381}, CountryId{"IN"}}, // Kirandul railway station
    {Coordinate{10.8125, 52.2572}, CountryId{"DE"}}, // Königslutter railway station
    {Coordinate{12.4011, 51.3645}, CountryId{"DE"}}, // Leipzig Nord railway station
    {Coordinate{12.2682, 51.3154}, CountryId{"DE"}}, // Leipzig Miltitzer Allee railway station
    {Coordinate{12.2914, 51.3191}, CountryId{"DE"}}, // Leipzig Allee-Center railway station
    {Coordinate{12.3217, 51.3334}, CountryId{"DE"}}, // Leipzig-Lindenau railway station
    {Coordinate{12.3864, 51.3199}, CountryId{"DE"}}, // Leipzig MDR railway station
    {Coordinate{12.4195, 51.3326}, CountryId{"DE"}}, // Leipzig Anger-Crottendorf railway station
    {Coordinate{75.8479, 30.9124}, CountryId{"IN"}}, // Ludhiana Junction railway station
    {Coordinate{86.6422, 24.2706}, CountryId{"IN"}}, // Madhupur Junction railway station
    {Coordinate{74.8801, 12.8662}, CountryId{"IN"}}, // Mangalore Junction railway station
    {Coordinate{76.2971, 30.6695}, CountryId{"IN"}}, // Mandi Gobindgarh railway station
    {Coordinate{12.3721, 51.288}, CountryId{"DE"}}, // Markkleeberg Nord railway station
    {Coordinate{76.9345, 11.2997}, CountryId{"IN"}}, // Mettupalayam railway station
    {Coordinate{78.7658, 28.8316}, CountryId{"IN"}}, // Moradabad railway station
    {Coordinate{75.6118, 31.9419}, CountryId{"IN"}}, // Mukerian railway station
    {Coordinate{75.4125, 23.4559}, CountryId{"IN"}}, // Nagda Junction railway station
    {Coordinate{21.9653, 37.251}, CountryId{"GR"}}, // Zevgolatio station
    {Coordinate{93.7008, 27.103}, CountryId{"IN"}}, // Naharlagun railway station
    {Coordinate{76.964, 29.389}, CountryId{"IN"}}, // Panipat railway station
    {Coordinate{76.6682, 8.81576}, CountryId{"IN"}}, // Paravur railway station
    {Coordinate{75.6444, 32.2718}, CountryId{"IN"}}, // Pathankot Junction railway station
    {Coordinate{75.636, 32.2593}, CountryId{"IN"}}, // Pathankot Cantonment railway station
    {Coordinate{75.7655, 31.2176}, CountryId{"IN"}}, // Phagwara railway station
    {Coordinate{85.0794, 25.5863}, CountryId{"IN"}}, // Phulwari Sharif Railway Station
    {Coordinate{79.8281, 11.9254}, CountryId{"IN"}}, // Pondicherry railway station
    {Coordinate{78.7098, 10.7918}, CountryId{"IN"}}, // Ponmalai (Golden Rock) railway station
    {Coordinate{87.5191, 25.7907}, CountryId{"IN"}}, // Purnia Junction railway station
    {Coordinate{74.5378, 26.4907}, CountryId{"IN"}}, // Pushkar railway station
    {Coordinate{77.3392, 16.1924}, CountryId{"IN"}}, // Raichur railway station
    {Coordinate{88.648, 26.544}, CountryId{"IN"}}, // Raninagar Jalpaiguri Junction railway station
    {Coordinate{78.5331, 17.4617}, CountryId{"IN"}}, // Safilguda railway station
    {Coordinate{75.9795, 30.8374}, CountryId{"IN"}}, // Sahnewal railway station
    {Coordinate{75.1362, 33.6755}, CountryId{"IN"}}, // Sadura railway station
    {Coordinate{10.6857, 52.2673}, CountryId{"DE"}}, // Schandelah railway station
    {Coordinate{76.3832, 30.6242}, CountryId{"IN"}}, // Sirhind Junction railway station
    {Coordinate{8.47844, 47.1946}, CountryId{"CH"}}, // Steinhausen railway station
    {Coordinate{-2.867, 55.692}, CountryId{"GB"}}, // Stow railway station
    {Coordinate{13.1072, 54.305}, CountryId{"DE"}}, // Stralsund Rügendamm railway station
    {Coordinate{86.4403, 23.6545}, CountryId{"IN"}}, // Sudamdih railway station
    {Coordinate{71.6301, 22.7443}, CountryId{"IN"}}, // Surendranagar Junction railway station
    {Coordinate{73.672, 18.7348}, CountryId{"IN"}}, // Talegaon railway station
    {Coordinate{11.97, 52.5458}, CountryId{"DE"}}, // Tangermünde station
    {Coordinate{88.0145, 22.8821}, CountryId{"IN"}}, // Tarakeswar railway station
    {Coordinate{79.1383, 10.7781}, CountryId{"IN"}}, // Thanjavur Junction railway station
    {Coordinate{79.6339, 10.7643}, CountryId{"IN"}}, // Thiruvarur Junction railway station
    {Coordinate{88.3243, 22.5986}, CountryId{"IN"}}, // Tikiapara railway station
    {Coordinate{85.4011, 24.822}, CountryId{"IN"}}, // Tilaiya Junction railway station
    {Coordinate{78.7031, 10.8294}, CountryId{"IN"}}, // Tiruchirappalli Town railway station
    {Coordinate{77.3412, 11.1089}, CountryId{"IN"}}, // Tiruppur railway station
    {Coordinate{77.2965, 28.5035}, CountryId{"IN"}}, // Tughlakabad railway station
    {Coordinate{88.0932, 22.4724}, CountryId{"IN"}}, // Uluberia railway station
    {Coordinate{80.4862, 26.5484}, CountryId{"IN"}}, // Unnao railway station
    {Coordinate{80.0718, 12.8672}, CountryId{"IN"}}, // Urapakkam railway station
    {Coordinate{73.6369, 18.7429}, CountryId{"IN"}}, // Vadgaon railway station
    {Coordinate{76.2809, 10.7316}, CountryId{"IN"}}, // Vallathol Nagar railway station
    {Coordinate{77.8906, 8.8821}, CountryId{"IN"}}, // Vanchi Maniyachchi Junction railway station
    {Coordinate{76.7229, 8.74073}, CountryId{"IN"}}, // Varkala Sivagiri railway station
    {Coordinate{72.9084, 20.3734}, CountryId{"IN"}}, // Vapi railway station
    {Coordinate{79.9987, 13.1239}, CountryId{"IN"}}, // Veppampattu railway station
    {Coordinate{18.2256, 46.0667}, CountryId{"HU"}}, // Pécs railway station
    {Coordinate{79.5001, 11.943}, CountryId{"IN"}}, // Viluppuram Junction railway station
    {Coordinate{10.1689, 52.3354}, CountryId{"DE"}}, // Vöhrum station
    {Coordinate{77.6939, 27.5762}, CountryId{"IN"}}, // Vrindavan railway station
    {Coordinate{76.9915, 17.0543}, CountryId{"IN"}}, // Wadi Junction railway station
    {Coordinate{14.0756, 49.9569}, CountryId{"CZ"}}, // Beroun
    {Coordinate{70.9656, 22.6226}, CountryId{"IN"}}, // Wankaner Junction railway station
    {Coordinate{10.6243, 52.2693}, CountryId{"DE"}}, // Weddel railway station
    {Coordinate{9.27926, 47.3757}, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{8.76097, 47.5167}, CountryId{"CH"}}, // Winterthur Wallrüti railway station
    {Coordinate{78.0381, 27.1915}, CountryId{"IN"}}, // Yamuna Bridge railway station
    {Coordinate{13.7547, 52.9639}, CountryId{"DE"}}, // Joachimsthal Kaiserbahnhof
    {Coordinate{25.1895, 62.2568}, CountryId{"FI"}}, // Petäjävesi railway station
    {Coordinate{72.8355, 18.9398}, CountryId{"IN"}}, // Bori Bunder railway station
    {Coordinate{8.78267, 44.7974}, CountryId{"IT"}}, // Pozzolo Formigaro train station
    {Coordinate{78.482, 17.3407}, CountryId{"IN"}}, // Huppuguda railway station
    {Coordinate{78.4917, 17.3596}, CountryId{"IN"}}, // Yakutpura railway station
    {Coordinate{78.5248, 17.4408}, CountryId{"IN"}}, // Lallaguda railway station
    {Coordinate{0.722236, 49.1467}, CountryId{"FR"}}, // Gare de La Rivière-Thibouville
    {Coordinate{6.9948, 51.5756}, CountryId{"DE"}}, // Haltepunkt Gladbeck Ost
    {Coordinate{0.692606, 49.2397}, CountryId{"FR"}}, // Gare de Pont-Authou
    {Coordinate{9.37028, 48.8131}, CountryId{"DE"}}, // Endersbach station
    {Coordinate{77.1166, 28.6135}, CountryId{"IN"}}, // Delhi Cantonment railway station
    {Coordinate{80.2512, 12.9893}, CountryId{"IN"}}, // Thiruvanmiyur railway station
    {Coordinate{14.4024, 50.0457}, CountryId{"CZ"}}, // Praha-Žvahov
    {Coordinate{15.7428, 49.5697}, CountryId{"CZ"}}, // Přibyslav
    {Coordinate{15.7177, 49.5794}, CountryId{"CZ"}}, // Přibyslav zastávka
    {Coordinate{92.7631, 26.6812}, CountryId{"IN"}}, // Dekargaon railway station
    {Coordinate{83.568, 25.5831}, CountryId{"IN"}}, // Ghazipur City railway station
    {Coordinate{0.562068, 49.4895}, CountryId{"FR"}}, // Q16964674
    {Coordinate{4.39987, 50.8391}, CountryId{"BE"}}, // Merode railway station
    {Coordinate{73.0133, 26.2485}, CountryId{"IN"}}, // Bhagat Ki Kothi railway station
    {Coordinate{13.5469, 49.5653}, CountryId{"CZ"}}, // Q16978284
    {Coordinate{14.4792, 48.9944}, CountryId{"CZ"}}, // České Budějovice severní zastávka
    {Coordinate{-76.2295, 43.0717}, CountryId{"US"}}, // New York State Fair
    {Coordinate{16.4994, 41.2353}, CountryId{"IT"}}, // Bisceglie railway station
    {Coordinate{-3.4206, 50.7501}, CountryId{"GB"}}, // Cranbrook railway station (Devon)
    {Coordinate{73.3084, 19.0042}, CountryId{"IN"}}, // Jummapatti railway station
    {Coordinate{77.5138, 17.9117}, CountryId{"IN"}}, // Bidar railway station
    {Coordinate{75.74, 16.8311}, CountryId{"IN"}}, // Bijapur railway station
    {Coordinate{29.1381, 63.5411}, CountryId{"FI"}}, // Nurmes railway station
    {Coordinate{8.57853, 49.3834}, CountryId{"DE"}}, // Schwetzingen train station
    {Coordinate{84.6626, 25.5489}, CountryId{"IN"}}, // Ara Junction railway station
    {Coordinate{77.5993, 12.9937}, CountryId{"IN"}}, // Bangalore Cantonment railway station
    {Coordinate{78.1782, 12.9848}, CountryId{"IN"}}, // Bangarapet railway station
    {Coordinate{75.1944, 31.8215}, CountryId{"IN"}}, // Batala Junction railway station
    {Coordinate{74.9321, 30.2095}, CountryId{"IN"}}, // Bathinda railway station
    {Coordinate{75.0428, 12.3855}, CountryId{"IN"}}, // Bekal Fort railway station
    {Coordinate{72.9996, 21.7034}, CountryId{"IN"}}, // Bharuch Junction railway station
    {Coordinate{76.1256, 28.7984}, CountryId{"IN"}}, // Bhiwani railway station
    {Coordinate{69.6778, 23.266}, CountryId{"IN"}}, // Bhuj railway station
    {Coordinate{83.3457, 18.5768}, CountryId{"IN"}}, // Bobbili railway station
    {Coordinate{75.7864, 26.8559}, CountryId{"IN"}}, // Durgapura railway station
    {Coordinate{82.3841, 26.5695}, CountryId{"IN"}}, // Goshainganj railway station
    {Coordinate{78.1823, 26.2165}, CountryId{"IN"}}, // Gwalior Junction railway station
    {Coordinate{12.5509, 37.9914}, CountryId{"IT"}}, // Q17056890
    {Coordinate{12.5042, 37.9265}, CountryId{"IT"}}, // Q17056891
    {Coordinate{12.4772, 37.8363}, CountryId{"IT"}}, // Q17056893
    {Coordinate{12.4432, 37.7932}, CountryId{"IT"}}, // Marsala railway station
    {Coordinate{12.4807, 37.7486}, CountryId{"IT"}}, // Q17056895
    {Coordinate{12.7333, 37.6363}, CountryId{"IT"}}, // Campobello di Mazara railway station
    {Coordinate{12.8657, 37.8067}, CountryId{"IT"}}, // Salemi-Gibellina railway station
    {Coordinate{12.9489, 37.8579}, CountryId{"IT"}}, // Gallitello railway station
    {Coordinate{12.9157, 37.9789}, CountryId{"IT"}}, // Alcamo Diramazione railway station
    {Coordinate{12.4991, 37.8849}, CountryId{"IT"}}, // Q17056946
    {Coordinate{67.8902, 55.0711}, CountryId{"RU"}}, // Q17057303
    {Coordinate{58.1141, 53.9104}, CountryId{"RU"}}, // Q17057339
    {Coordinate{58.1796, 53.9168}, CountryId{"RU"}}, // Q17057342
    {Coordinate{58.2398, 53.9223}, CountryId{"RU"}}, // Q17057343
    {Coordinate{88.2658, 22.7206}, CountryId{"IN"}}, // Janai Road railway station
    {Coordinate{84.99, 25.2247}, CountryId{"IN"}}, // Jehanabad railway station
    {Coordinate{82.9461, 19.8741}, CountryId{"IN"}}, // Junagarh Road railway station
    {Coordinate{82.1039, 21.1131}, CountryId{"IN"}}, // Mahasamund railway station
    {Coordinate{78.7933, 10.0685}, CountryId{"IN"}}, // Karaikkudi Junction railway station
    {Coordinate{73.3775, 18.7551}, CountryId{"IN"}}, // Khandala railway station
    {Coordinate{87.3249, 22.3399}, CountryId{"IN"}}, // Kharagpur Junction railway station
    {Coordinate{78.3311, 24.0515}, CountryId{"IN"}}, // Khurai railway station
    {Coordinate{79.7663, 11.7151}, CountryId{"IN"}}, // Cuddalore Port Junction railway station
    {Coordinate{75.4171, 18.0913}, CountryId{"IN"}}, // Kurduvadi railway station
    {Coordinate{76.7941, 30.4798}, CountryId{"IN"}}, // Lalru railway station
    {Coordinate{72.3887, 23.6026}, CountryId{"IN"}}, // Mahesana railway station
    {Coordinate{-81.6405, 29.6492}, CountryId{"US"}}, // Palatka station
    {Coordinate{78.4535, 9.68154}, CountryId{"IN"}}, // Manamadurai Junction railway station
    {Coordinate{73.6093, 25.7205}, CountryId{"IN"}}, // Marwar Junction railway station
    {Coordinate{90.6339, 25.9151}, CountryId{"IN"}}, // Mendipathar railway station
    {Coordinate{78.8019, 10.3725}, CountryId{"IN"}}, // Pudukkottai railway station
    {Coordinate{79.5335, 16.8604}, CountryId{"IN"}}, // Miryalaguda railway station
    {Coordinate{70.2765, 25.7426}, CountryId{"IN"}}, // Munabao railway station
    {Coordinate{7.74861, 46.0097}, CountryId{"CH"}}, // Findelbach railway station
    {Coordinate{77.5212, 10.4587}, CountryId{"IN"}}, // Palani railway station
    {Coordinate{-77.0621, 38.8063}, CountryId{"US"}}, // Union Station
    {Coordinate{75.9394, 24.6446}, CountryId{"IN"}}, // Ramganj Mandi railway station
    {Coordinate{85.7874, 25.8583}, CountryId{"IN"}}, // Samastipur Junction railway station
    {Coordinate{73.2904, 19.0091}, CountryId{"IN"}}, // Water Pipe railway station
    {Coordinate{75.8934, 17.6645}, CountryId{"IN"}}, // Solapur railway station
    {Coordinate{7.61904, 51.5047}, CountryId{"DE"}}, // Holzwickede station
    {Coordinate{7.68, 46.6861}, CountryId{"CH"}}, // Spiez railway station
    {Coordinate{13.2271, 50.7067}, CountryId{"DE"}}, // Pockau-Lengefeld station
    {Coordinate{16.338, 48.2078}, CountryId{"AT"}}, // Thaliastraße
    {Coordinate{17.1231, 40.8564}, CountryId{"IT"}}, // Putignano railway station
    {Coordinate{7.75389, 46.0047}, CountryId{"CH"}}, // Riffelalp railway station
    {Coordinate{7.755, 45.9928}, CountryId{"CH"}}, // Riffelberg railway station
    {Coordinate{7.68634, 45.0995}, CountryId{"IT"}}, // Torino Rebaudengo Fossata railway station
    {Coordinate{16.4178, 41.2725}, CountryId{"IT"}}, // Trani railway station
    {Coordinate{17.0174, 40.9142}, CountryId{"IT"}}, // Turi railway station
    {Coordinate{81.0444, 16.6941}, CountryId{"IN"}}, // Vatluru railway station
    {Coordinate{72.053, 23.1291}, CountryId{"IN"}}, // Viramgam railway station
    {Coordinate{78.1175, 8.5025}, CountryId{"IN"}}, // Thiruchendur railway station
    {Coordinate{10.8379, 48.2664}, CountryId{"DE"}}, // Bobingen station
    {Coordinate{13.5628, 47.4076}, CountryId{"AT"}}, // Bahnhof Eben im Pongau
    {Coordinate{8.99, 49.6568}, CountryId{"DE"}}, // Railway Station Erbach (Odenw)
    {Coordinate{6.97326, 51.6145}, CountryId{"DE"}}, // Haltepunkt Feldhausen
    {Coordinate{16.4692, 48.2327}, CountryId{"AT"}}, // Wien Hirschstetten railway station
    {Coordinate{27.6892, 62.2103}, CountryId{"FI"}}, // Huutokoski railway station
    {Coordinate{25.3339, 63.7544}, CountryId{"FI"}}, // Haapajärvi railway station
    {Coordinate{12.9862, 43.3458}, CountryId{"IT"}}, // Albacina railway station
    {Coordinate{29.2369, 62.6414}, CountryId{"FI"}}, // Viinijärvi railway station area
    {Coordinate{13.6748, 37.5704}, CountryId{"IT"}}, // Acquaviva-Casteltermini railway station
    {Coordinate{11.6024, 44.0684}, CountryId{"IT"}}, // Stazione di Biforco
    {Coordinate{13.6867, 37.5101}, CountryId{"IT"}}, // Campofranco railway station
    {Coordinate{14.2105, 41.1014}, CountryId{"IT"}}, // Capua railway station
    {Coordinate{13.7847, 37.9539}, CountryId{"IT"}}, // Cerda railway station
    {Coordinate{13.653, 37.4238}, CountryId{"IT"}}, // Comitini railway station
    {Coordinate{11.5482, 44.0418}, CountryId{"IT"}}, // Stazione di Crespino del Lamone
    {Coordinate{15.8241, 39.6769}, CountryId{"IT"}}, // Q17146374
    {Coordinate{13.838, 42.7059}, CountryId{"IT"}}, // Bellante-Ripattone railway station
    {Coordinate{13.7929, 42.6957}, CountryId{"IT"}}, // Q17146388
    {Coordinate{12.757, 43.2839}, CountryId{"IT"}}, // Fossato di Vico-Gubbio railway station
    {Coordinate{12.7673, 43.2334}, CountryId{"IT"}}, // Q17146397
    {Coordinate{13.6933, 37.859}, CountryId{"IT"}}, // Montemaggiore Belsito railway station
    {Coordinate{13.8763, 42.7067}, CountryId{"IT"}}, // Q17146404
    {Coordinate{8.41581, 45.9702}, CountryId{"IT"}}, // Ornavasso railway halt
    {Coordinate{8.40675, 45.8205}, CountryId{"IT"}}, // Pettenasco railway halt
    {Coordinate{11.6364, 44.093}, CountryId{"IT"}}, // Q17146420
    {Coordinate{13.8968, 42.9127}, CountryId{"IT"}}, // Porto d'Ascoli train station
    {Coordinate{11.8713, 44.5956}, CountryId{"IT"}}, // San Biagio railway station
    {Coordinate{13.7742, 37.9031}, CountryId{"IT"}}, // Sciara-Aliminusa railway station
    {Coordinate{12.4185, 42.7899}, CountryId{"IT"}}, // Todi Ponte Rio railway station
    {Coordinate{13.0666, 46.2193}, CountryId{"IT"}}, // Majano railway station
    {Coordinate{11.0025, 45.8613}, CountryId{"IT"}}, // Mori railway halt
    {Coordinate{9.79117, 48.4039}, CountryId{"DE"}}, // Q17148684
    {Coordinate{14.6355, 50.6816}, CountryId{"CZ"}}, // Zákupy
    {Coordinate{80.9186, 26.832}, CountryId{"IN"}}, // Lucknow Junctio railway station
    {Coordinate{17.7867, 59.7256}, CountryId{"SE"}}, // Knivsta station
    {Coordinate{61.3712, 56.7305}, CountryId{"RU"}}, // Bazhenovo
    {Coordinate{12.5953, 55.7119}, CountryId{"DK"}}, // Orientkaj Station
    {Coordinate{-72.6023, 42.204}, CountryId{"US"}}, // Holyoke
    {Coordinate{13.552, 66.0997}, CountryId{"NO"}}, // Elsfjord Station
    {Coordinate{7.9625, 62.4302}, CountryId{"NO"}}, // Flatmark stoppested
    {Coordinate{10.1851, 61.4493}, CountryId{"NO"}}, // Fåvang Station
    {Coordinate{10.1052, 62.8899}, CountryId{"NO"}}, // Garli Station
    {Coordinate{11.639, 60.824}, CountryId{"NO"}}, // Heradsbygd Station
    {Coordinate{8.35235, 58.5357}, CountryId{"NO"}}, // Herefoss Station
    {Coordinate{10.3071, 60.1889}, CountryId{"NO"}}, // Hval station
    {Coordinate{12.0613, 60.4579}, CountryId{"NO"}}, // Kirkenær Station
    {Coordinate{10.2257, 61.385}, CountryId{"NO"}}, // Losna Station
    {Coordinate{10.6589, 63.4389}, CountryId{"NO"}}, // Malvik Station
    {Coordinate{9.50113, 59.6301}, CountryId{"NO"}}, // Meheia Station
    {Coordinate{11.537, 58.9911}, CountryId{"NO"}}, // Prestebakke Station
    {Coordinate{10.3334, 59.2812}, CountryId{"NO"}}, // Sem Station
    {Coordinate{9.54154, 61.6822}, CountryId{"NO"}}, // Sjoa Station
    {Coordinate{9.89542, 59.8456}, CountryId{"NO"}}, // Skotselv stasjon
    {Coordinate{12.1181, 59.9843}, CountryId{"NO"}}, // Skotterud Station
    {Coordinate{10.2955, 61.3122}, CountryId{"NO"}}, // Tretten Station
    {Coordinate{10.1063, 60.0841}, CountryId{"NO"}}, // Tyristrand Station
    {Coordinate{10.0927, 60.2066}, CountryId{"NO"}}, // Veme Station
    {Coordinate{11.5928, 60.8404}, CountryId{"NO"}}, // Vesterhaug Station
    {Coordinate{12.1149, 60.1113}, CountryId{"NO"}}, // Åbogen Station
    {Coordinate{10.4071, 61.2634}, CountryId{"NO"}}, // Øyer stasjon
    {Coordinate{77.819, 28.2064}, CountryId{"IN"}}, // Khurja Junction railway station
    {Coordinate{80.4582, 16.31}, CountryId{"IN"}}, // New Guntur railway station
    {Coordinate{11.0444, 59.9531}, CountryId{"NO"}}, // Lillestrøm Station
    {Coordinate{24.8436, 60.295}, CountryId{"FI"}}, // Vehkala railway station
    {Coordinate{76.9161, 9.02334}, CountryId{"IN"}}, // Punalur Railway Station
    {Coordinate{15.6506, 41.4081}, CountryId{"IT"}}, // Incoronata railway station
    {Coordinate{16.091, 41.3494}, CountryId{"IT"}}, // Trinitapoli-San Ferdinando di Puglia railway station
    {Coordinate{17.9291, 59.6496}, CountryId{"SE"}}, // Arlanda Central Station
    {Coordinate{55.9228, 53.4492}, CountryId{"RU"}}, // Q17266153
    {Coordinate{19.2936, 48.0714}, CountryId{"HU"}}, // Balassagyarmat railway station
    {Coordinate{8.06528, 48.6336}, CountryId{"DE"}}, // Achern station
    {Coordinate{8.99028, 49.3539}, CountryId{"DE"}}, // Aglasterhausen station
    {Coordinate{7.72864, 50.3276}, CountryId{"DE"}}, // Bad Ems station
    {Coordinate{8.29456, 49.1883}, CountryId{"DE"}}, // Bellheim station
    {Coordinate{8.4107, 48.4675}, CountryId{"DE"}}, // Freudenstadt Stadt station
    {Coordinate{11.1852, 53.429}, CountryId{"DE"}}, // Hagenow Stadt railway station
    {Coordinate{30.4156, 59.0531}, CountryId{"RU"}}, // Q17333373
    {Coordinate{8.2097, 56.6922}, CountryId{"DK"}}, // Sprogøvej Station
    {Coordinate{17.9283, 62.635}, CountryId{"SE"}}, // Härnösand
    {Coordinate{6.00987, 44.1015}, CountryId{"FR"}}, // Q17347042
    {Coordinate{5.96917, 44.1411}, CountryId{"FR"}}, // Q17347043
    {Coordinate{8.179, 49.5807}, CountryId{"DE"}}, // Bahnhof Albsheim
    {Coordinate{8.27233, 49.0925}, CountryId{"DE"}}, // Jockgrim station
    {Coordinate{8.28348, 49.5119}, CountryId{"DE"}}, // Bahnhof Lambsheim
    {Coordinate{8.24987, 49.5139}, CountryId{"DE"}}, // Bahnhof Weisenheim
    {Coordinate{7.1877, 48.7238}, CountryId{"FR"}}, // Gare d'Arzviller
    {Coordinate{6.97102, 48.6919}, CountryId{"FR"}}, // Gare de Héming
    {Coordinate{7.75063, 48.5654}, CountryId{"FR"}}, // Strasbourg-Neudorf station
    {Coordinate{7.79404, 48.574}, CountryId{"FR"}}, // Gare de Strasbourg-Port-du-Rhin
    {Coordinate{6.16603, 49.0982}, CountryId{"FR"}}, // Q17355277
    {Coordinate{17.33, 62.4858}, CountryId{"SE"}}, // Timrå
    {Coordinate{16.5631, 48.1208}, CountryId{"AT"}}, // Vienna Airport station
    {Coordinate{6.71472, 51.9681}, CountryId{"NL"}}, // Winterswijk railway station
    {Coordinate{36.1271, 54.65}, CountryId{"RU"}}, // 146 km (Kaluga region)
    {Coordinate{16.3418, 48.2168}, CountryId{"AT"}}, // Alser Straße
    {Coordinate{-74.1642, 40.7347}, CountryId{"US"}}, // Pennsylvania Station
    {Coordinate{6.16108, 52.257}, CountryId{"NL"}}, // Deventer railway station
    {Coordinate{13.2879, 43.6773}, CountryId{"IT"}}, // Marzocca train station
    {Coordinate{44.3363, 48.6812}, CountryId{"RU"}}, // Q17462325
    {Coordinate{15.3927, 50.7716}, CountryId{"CZ"}}, // Harrachov railway station
    {Coordinate{9.17806, 59.3892}, CountryId{"NO"}}, // Gvarv Station
    {Coordinate{7.14222, 51.4264}, CountryId{"DE"}}, // Bochum-Dahlhausen station
    {Coordinate{4.78583, 43.9217}, CountryId{"FR"}}, // Gare d'Avignon TGV
    {Coordinate{11.515, 60.9286}, CountryId{"NO"}}, // Grundset Station
    {Coordinate{11.9905, 51.3569}, CountryId{"DE"}}, // Merseburg Hauptbahnhof
    {Coordinate{10.2889, 63.2625}, CountryId{"NO"}}, // Søberg Station
    {Coordinate{15.14, 59.1267}, CountryId{"SE"}}, // Kumla station
    {Coordinate{10.6353, 62.95}, CountryId{"NO"}}, // Bjørgen Station
    {Coordinate{9.96889, 59.9328}, CountryId{"NO"}}, // Geithus stasjon
    {Coordinate{8.4177, 45.5955}, CountryId{"IT"}}, // Ghemme train station
    {Coordinate{8.43602, 45.5738}, CountryId{"IT"}}, // Sizzano train station
    {Coordinate{12.1028, 45.6767}, CountryId{"IT"}}, // Q17494296
    {Coordinate{12.0144, 45.6703}, CountryId{"IT"}}, // Albaredo railway halt
    {Coordinate{11.8573, 45.6558}, CountryId{"IT"}}, // Q17494300
    {Coordinate{11.7489, 45.6349}, CountryId{"IT"}}, // Q17494303
    {Coordinate{11.7148, 45.6215}, CountryId{"IT"}}, // Carmignano di Brenta railway halt
    {Coordinate{8.47884, 45.5387}, CountryId{"IT"}}, // Briona train station
    {Coordinate{12.5337, 44.0883}, CountryId{"IT"}}, // Rimini Viserba railway station
    {Coordinate{12.0756, 44.4833}, CountryId{"IT"}}, // Glorie railway station
    {Coordinate{8.94688, 46.0055}, CountryId{"CH"}}, // Lugano railway station
    {Coordinate{10.8161, 60.9158}, CountryId{"NO"}}, // Rudshøgda Station
    {Coordinate{75.3106, 19.8593}, CountryId{"IN"}}, // Aurangabad railway station
    {Coordinate{32.6514, 46.6825}, CountryId{"UA"}}, // Puteiska
    {Coordinate{13.3343, 52.597}, CountryId{"DE"}}, // Berlin-Wittenau station
    {Coordinate{12.8817, 47.7308}, CountryId{"DE"}}, // Bad Reichenhall station
    {Coordinate{10.3301, 51.6439}, CountryId{"DE"}}, // Herzberg (Harz) station
    {Coordinate{7.03361, 49.1578}, CountryId{"DE"}}, // Kleinblittersdorf
    {Coordinate{8.42117, 49.4617}, CountryId{"DE"}}, // Ludwigshafen-Mundenheim station
    {Coordinate{30.438, 60.0331}, CountryId{"RU"}}, // Murino
    {Coordinate{-0.052222, 51.5008}, CountryId{"GB"}}, // Rotherhithe railway station
    {Coordinate{8.36036, 49.195}, CountryId{"DE"}}, // Sondernheim station
    {Coordinate{-8.43205, 40.2088}, CountryId{"PT"}}, // Coimbra-Cidade train station
    {Coordinate{16.4532, 48.2298}, CountryId{"AT"}}, // Wien Erzherzog-Karl-Straße railway station
    {Coordinate{36.6114, 45.3636}, CountryId{"UA"}}, // Krym
    {Coordinate{14.4517, 50.1231}, CountryId{"CZ"}}, // Kobylisy
    {Coordinate{-0.002761, 46.6646}, CountryId{"FR"}}, // Gare de Chalandray
    {Coordinate{6.12611, 46.1822}, CountryId{"CH"}}, // Geneva-La Praille station
    {Coordinate{7.3209, 47.7616}, CountryId{"FR"}}, // Q17628881
    {Coordinate{7.74031, 48.6074}, CountryId{"FR"}}, // Schiltigheim
    {Coordinate{-7.05562, 43.536}, CountryId{"ES"}}, // Train station of Ribadeo
    {Coordinate{15.3822, 41.7786}, CountryId{"IT"}}, // Apricena  railway station
    {Coordinate{12.2947, 42.518}, CountryId{"IT"}}, // Attigliano-Bomarzo railway station
    {Coordinate{13.6876, 45.754}, CountryId{"IT"}}, // Aurisina railway station
    {Coordinate{11.9694, 44.4123}, CountryId{"IT"}}, // Stazione di Bagnacavallo
    {Coordinate{11.9954, 45.0608}, CountryId{"IT"}}, // Baricetta train station
    {Coordinate{8.62239, 46.1584}, CountryId{"CH"}}, // Borgnone-Cadanza train station
    {Coordinate{9.05639, 40.8919}, CountryId{"IT"}}, // Bortigiadas train station
    {Coordinate{8.45164, 46.1358}, CountryId{"IT"}}, // Q17637147
    {Coordinate{8.611, 46.1549}, CountryId{"CH"}}, // Camedo railway station
    {Coordinate{12.2492, 45.1112}, CountryId{"IT"}}, // Cavanella d’Adige railway station
    {Coordinate{11.5702, 45.5963}, CountryId{"IT"}}, // Q17637176
    {Coordinate{8.72123, 46.1837}, CountryId{"CH"}}, // Cavigliano train station
    {Coordinate{8.39867, 46.1266}, CountryId{"IT"}}, // Coimo train station
    {Coordinate{12.779, 42.412}, CountryId{"IT"}}, // Contigliano train station
    {Coordinate{8.67516, 46.1688}, CountryId{"CH"}}, // Corcapolo train station
    {Coordinate{8.32562, 46.1241}, CountryId{"IT"}}, // Q17637214
    {Coordinate{8.43367, 46.133}, CountryId{"IT"}}, // Druogno railway station
    {Coordinate{11.5463, 45.6351}, CountryId{"IT"}}, // Dueville railway station
    {Coordinate{8.55804, 46.1343}, CountryId{"IT"}}, // Folsogno-Dissimo railway station
    {Coordinate{8.41983, 46.1288}, CountryId{"IT"}}, // Q17637269
    {Coordinate{16.6689, 41.1808}, CountryId{"IT"}}, // Giovinazzo railway station
    {Coordinate{12.0712, 44.3894}, CountryId{"IT"}}, // Godo railway halt
    {Coordinate{12.7768, 42.4628}, CountryId{"IT"}}, // Greccio train station
    {Coordinate{8.70222, 46.1775}, CountryId{"CH"}}, // Intragna train station
    {Coordinate{12.7463, 42.5061}, CountryId{"IT"}}, // Labro-Moggio railway station
    {Coordinate{11.913, 45.0434}, CountryId{"IT"}}, // Lama train station
    {Coordinate{8.80215, 46.1727}, CountryId{"CH"}}, // Locarno railway station (FART)
    {Coordinate{8.78614, 46.1689}, CountryId{"CH"}}, // Locarno Sant'Antonio train station
    {Coordinate{12.1916, 45.0595}, CountryId{"IT"}}, // Loreo train station
    {Coordinate{8.9476, 46.0045}, CountryId{"CH"}}, // Lugano FLP railway station
    {Coordinate{8.49935, 46.1292}, CountryId{"IT"}}, // Malesco train station
    {Coordinate{11.4246, 45.7068}, CountryId{"IT"}}, // Marano Vicentino railway halt
    {Coordinate{14.2879, 41.0359}, CountryId{"IT"}}, // Marcianise railway halt
    {Coordinate{12.7151, 42.5474}, CountryId{"IT"}}, // Marmore train station
    {Coordinate{8.33342, 46.1226}, CountryId{"IT"}}, // Q17637373
    {Coordinate{8.32403, 46.132}, CountryId{"IT"}}, // Q17637376
    {Coordinate{8.98303, 45.8777}, CountryId{"CH"}}, // Mendrisio San Martino railway station
    {Coordinate{10.3987, 44.9667}, CountryId{"IT"}}, // Mezzani-Rondani railway halt
    {Coordinate{16.5964, 41.1958}, CountryId{"IT"}}, // Molfetta railway station
    {Coordinate{8.54342, 39.2446}, CountryId{"IT"}}, // Monte Arcau railway station
    {Coordinate{14.7575, 40.82}, CountryId{"IT"}}, // Montoro-Forino railway station
    {Coordinate{10.8237, 45.3067}, CountryId{"IT"}}, // Mozzecane railway station
    {Coordinate{8.06125, 44.339}, CountryId{"IT"}}, // Nucetto train station
    {Coordinate{11.6065, 45.2217}, CountryId{"IT"}}, // Q17637425
    {Coordinate{8.63095, 46.1611}, CountryId{"CH"}}, // Palagnedra train station
    {Coordinate{15.3507, 41.8077}, CountryId{"IT"}}, // Q17637455
    {Coordinate{8.75331, 46.1856}, CountryId{"CH"}}, // Ponte Brolla train station
    {Coordinate{8.29283, 46.1455}, CountryId{"IT"}}, // Preglia railway station
    {Coordinate{8.4796, 46.1331}, CountryId{"IT"}}, // Q17637478
    {Coordinate{10.9119, 44.6913}, CountryId{"IT"}}, // Quattro Ville railway halt
    {Coordinate{8.5395, 46.1273}, CountryId{"IT"}}, // Re railway station
    {Coordinate{14.3034, 41.0623}, CountryId{"IT"}}, // Recale railway halt
    {Coordinate{8.60177, 46.1543}, CountryId{"IT"}}, // Ribellasca train station
    {Coordinate{15.49, 41.5792}, CountryId{"IT"}}, // Rignano Garganico railway station
    {Coordinate{12.2195, 42.2825}, CountryId{"IT"}}, // Ronciglione railway station
    {Coordinate{12.2397, 45.0755}, CountryId{"IT"}}, // Rosolina railway halt
    {Coordinate{8.77037, 46.172}, CountryId{"CH"}}, // San Martino train station
    {Coordinate{8.4605, 46.1364}, CountryId{"IT"}}, // Q17637544
    {Coordinate{14.2473, 40.949}, CountryId{"IT"}}, // Sant’Antimo-Sant’Arpino railway station
    {Coordinate{11.8491, 44.3565}, CountryId{"IT"}}, // Solarolo railway station
    {Coordinate{8.77759, 46.1695}, CountryId{"CH"}}, // Solduno train station
    {Coordinate{10.9061, 44.7227}, CountryId{"IT"}}, // Soliera Modenese railway station
    {Coordinate{14.0931, 41.1858}, CountryId{"IT"}}, // Sparanise train station
    {Coordinate{8.74278, 46.1861}, CountryId{"CH"}}, // Tegna train station
    {Coordinate{12.625, 42.5496}, CountryId{"IT"}}, // Terni Cospea railway station
    {Coordinate{11.4767, 45.6999}, CountryId{"IT"}}, // Q17637595
    {Coordinate{12.1833, 41.9243}, CountryId{"IT"}}, // Torre in Pietra-Palidoro railway station
    {Coordinate{10.3627, 44.8857}, CountryId{"IT"}}, // Torrile-San Polo railway station
    {Coordinate{8.33354, 46.1226}, CountryId{"IT"}}, // Q17637611
    {Coordinate{8.24519, 46.2063}, CountryId{"IT"}}, // Varzo railway station
    {Coordinate{8.64939, 46.1652}, CountryId{"CH"}}, // Verdasio train station
    {Coordinate{8.35215, 46.1219}, CountryId{"IT"}}, // Q17637630
    {Coordinate{8.72987, 46.1846}, CountryId{"CH"}}, // Verscio train station
    {Coordinate{11.5241, 45.6569}, CountryId{"IT"}}, // Q17637637
    {Coordinate{8.49076, 46.1296}, CountryId{"IT"}}, // Zornasco railway halt
    {Coordinate{10.4619, 59.8589}, CountryId{"NO"}}, // Hvalstad Station
    {Coordinate{12.0825, 50.0044}, CountryId{"DE"}}, // Marktredwitz station
    {Coordinate{10.0581, 60.0436}, CountryId{"NO"}}, // Nakkerud stasjon
    {Coordinate{24.7337, 59.4114}, CountryId{"EE"}}, // Tondi railway station
    {Coordinate{32.0503, 49.4261}, CountryId{"UA"}}, // Cherkasy
    {Coordinate{8.58297, 47.4482}, CountryId{"CH"}}, // Kloten railway station
    {Coordinate{8.56176, 47.43}, CountryId{"CH"}}, // Opfikon railway station
    {Coordinate{8.47208, 47.4368}, CountryId{"CH"}}, // Regensdorf-Watt railway station
    {Coordinate{8.50824, 47.421}, CountryId{"CH"}}, // Zurich Affoltern railway station
    {Coordinate{8.43615, 47.4533}, CountryId{"CH"}}, // Buchs-Dällikon railway station
    {Coordinate{2.34028, 48.8467}, CountryId{"FR"}}, // Gare du Luxembourg
    {Coordinate{8.73899, 41.9275}, CountryId{"FR"}}, // Ajaccio railway station
    {Coordinate{10.7329, 59.9146}, CountryId{"NO"}}, // Nationaltheatret Station
    {Coordinate{80.3536, 15.8308}, CountryId{"IN"}}, // Chirala railway station
    {Coordinate{80.4684, 15.9086}, CountryId{"IN"}}, // Bapatla railway station
    {Coordinate{15.2231, 51.2901}, CountryId{"PL"}}, // Węgliniec railway station
    {Coordinate{47.0465, 53.1509}, CountryId{"RU"}}, // Q17749204
    {Coordinate{46.8288, 53.1052}, CountryId{"RU"}}, // Evlashevo railway station
    {Coordinate{46.2287, 53.1402}, CountryId{"RU"}}, // Sjuzjum railway station
    {Coordinate{9.30806, 60.9667}, CountryId{"NO"}}, // Aurdal Station
    {Coordinate{16.0803, 49.5686}, CountryId{"CZ"}}, // Nové Město na Moravě
    {Coordinate{13.7358, 50.0989}, CountryId{"CZ"}}, // Rakovník (train station)
    {Coordinate{17.5317, 49.2026}, CountryId{"CZ"}}, // Otrokovice railway station
    {Coordinate{14.2431, 48.6336}, CountryId{"CZ"}}, // Lipno nad Vltavou
    {Coordinate{16.9626, 48.7328}, CountryId{"CZ"}}, // Lanžhot railway station
    {Coordinate{14.4922, 50.3528}, CountryId{"CZ"}}, // Mělník
    {Coordinate{12.6444, 50.1858}, CountryId{"CZ"}}, // Sokolov
    {Coordinate{17.3827, 48.9488}, CountryId{"CZ"}}, // Veselí nad Moravou
    {Coordinate{13.1531, 49.2969}, CountryId{"CZ"}}, // Nýrsko
    {Coordinate{16.7561, 50.0806}, CountryId{"CZ"}}, // Q17749992
    {Coordinate{17.9605, 49.4745}, CountryId{"CZ"}}, // Valašské Meziříčí
    {Coordinate{15.3491, 48.9938}, CountryId{"CZ"}}, // Slavonice
    {Coordinate{14.0031, 49.6889}, CountryId{"CZ"}}, // Příbram
    {Coordinate{14.3086, 48.6236}, CountryId{"CZ"}}, // Vyšší Brod klášter
    {Coordinate{15.3942, 49.9156}, CountryId{"CZ"}}, // Čáslav
    {Coordinate{17.9939, 49.3353}, CountryId{"CZ"}}, // Vsetín
    {Coordinate{15.7867, 49.9483}, CountryId{"CZ"}}, // Chrudim
    {Coordinate{15.1383, 50.5869}, CountryId{"CZ"}}, // Turnov
    {Coordinate{17.6585, 49.2265}, CountryId{"CZ"}}, // Zlín střed
    {Coordinate{13.8228, 50.3611}, CountryId{"CZ"}}, // Louny
    {Coordinate{17.122, 48.8564}, CountryId{"CZ"}}, // Hodonín railway station
    {Coordinate{14.0756, 50.2283}, CountryId{"CZ"}}, // Slaný
    {Coordinate{9.48083, 60.8922}, CountryId{"NO"}}, // Bjørgo Station
    {Coordinate{6.73683, 58.4096}, CountryId{"NO"}}, // Q17750496
    {Coordinate{16.4856, 48.2334}, CountryId{"AT"}}, // Hausfeldstraße
    {Coordinate{7.95198, 58.1626}, CountryId{"NO"}}, // Dalane train station
    {Coordinate{10.0269, 60.015}, CountryId{"NO"}}, // Drolsum stasjon
    {Coordinate{10.2472, 60.7692}, CountryId{"NO"}}, // Fluberg Station
    {Coordinate{12.3422, 64.4005}, CountryId{"NO"}}, // Formofoss stasjon
    {Coordinate{11.3296, 59.4738}, CountryId{"NO"}}, // Heia Station
    {Coordinate{10.8374, 59.7562}, CountryId{"NO"}}, // Vevelstad Station
    {Coordinate{10.7977, 59.8234}, CountryId{"NO"}}, // Rosenholm Station
    {Coordinate{10.8004, 59.7866}, CountryId{"NO"}}, // Myrvoll Station
    {Coordinate{10.6574, 59.4321}, CountryId{"NO"}}, // Moss Station
    {Coordinate{11.1179, 59.2858}, CountryId{"NO"}}, // Sarpsborg Station
    {Coordinate{10.8369, 59.7503}, CountryId{"NO"}}, // Langhus Station
    {Coordinate{11.3049, 59.5137}, CountryId{"NO"}}, // Eidsberg Station
    {Coordinate{11.2615, 59.5671}, CountryId{"NO"}}, // Slitu Station
    {Coordinate{10.8042, 59.8013}, CountryId{"NO"}}, // Solbråtan Station
    {Coordinate{11.0794, 59.6208}, CountryId{"NO"}}, // Spydeberg Station
    {Coordinate{10.8011, 59.8108}, CountryId{"NO"}}, // Kolbotn Station
    {Coordinate{11.3393, 59.4271}, CountryId{"NO"}}, // Rakkestad station
    {Coordinate{11.0327, 59.6245}, CountryId{"NO"}}, // Knapstad Station
    {Coordinate{10.9506, 59.2091}, CountryId{"NO"}}, // Fredrikstad Station
    {Coordinate{11.1631, 59.5817}, CountryId{"NO"}}, // Askim Station
    {Coordinate{10.6922, 59.4775}, CountryId{"NO"}}, // Kambo Station
    {Coordinate{10.7854, 59.8636}, CountryId{"NO"}}, // Nordstrand Station
    {Coordinate{10.8112, 59.7697}, CountryId{"NO"}}, // Oppegård Station
    {Coordinate{10.7256, 59.5146}, CountryId{"NO"}}, // Sonsveien Station
    {Coordinate{10.9475, 59.665}, CountryId{"NO"}}, // Skotbu Station
    {Coordinate{10.8075, 59.7723}, CountryId{"NO"}}, // Greverud Station
    {Coordinate{11.3236, 59.5542}, CountryId{"NO"}}, // Mysen Station
    {Coordinate{10.4378, 61.2232}, CountryId{"NO"}}, // Hunderfossen Station
    {Coordinate{10.6993, 60.9292}, CountryId{"NO"}}, // Moelv Station
    {Coordinate{11.1956, 60.7172}, CountryId{"NO"}}, // Stange Station
    {Coordinate{10.1388, 61.5291}, CountryId{"NO"}}, // Ringebu station
    {Coordinate{10.2853, 63.0517}, CountryId{"NO"}}, // Støren Station
    {Coordinate{10.8663, 59.3477}, CountryId{"NO"}}, // Råde station
    {Coordinate{10.7486, 59.6039}, CountryId{"NO"}}, // Vestby Station
    {Coordinate{11.0026, 59.6599}, CountryId{"NO"}}, // Tomter station
    {Coordinate{10.7851, 59.853}, CountryId{"NO"}}, // Ljan Station
    {Coordinate{10.8909, 59.6833}, CountryId{"NO"}}, // Kråkstad Station
    {Coordinate{10.7973, 59.8356}, CountryId{"NO"}}, // Holmlia Station
    {Coordinate{11.3842, 59.1202}, CountryId{"NO"}}, // Halden Station
    {Coordinate{10.7481, 59.3781}, CountryId{"NO"}}, // Rygge Station
    {Coordinate{10.8349, 59.7195}, CountryId{"NO"}}, // Ski Station
    {Coordinate{13.6311, 52.2966}, CountryId{"DE"}}, // Königs Wusterhausen station
    {Coordinate{10.8986, 63.4461}, CountryId{"NO"}}, // Hell Station
    {Coordinate{14.3914, 67.2864}, CountryId{"NO"}}, // Bodø Station
    {Coordinate{7.8699, 60.5114}, CountryId{"NO"}}, // Haugastøl Station
    {Coordinate{6.41035, 60.6292}, CountryId{"NO"}}, // Voss Station
    {Coordinate{9.32297, 59.4178}, CountryId{"NO"}}, // Nordagutu Station
    {Coordinate{5.62414, 60.429}, CountryId{"NO"}}, // Trengereid Station
    {Coordinate{5.46643, 60.4204}, CountryId{"NO"}}, // Arna Station
    {Coordinate{21.735, 38.2497}, CountryId{"GR"}}, // Patras railway station
    {Coordinate{22.9366, 39.3651}, CountryId{"GR"}}, // Volos railway station
    {Coordinate{8.51529, 47.1736}, CountryId{"CH"}}, // Zug railway station
    {Coordinate{5.73556, 60.4786}, CountryId{"NO"}}, // Vaksdal Station
    {Coordinate{7.0125, 60.7256}, CountryId{"NO"}}, // Upsete Station
    {Coordinate{5.8163, 60.5865}, CountryId{"NO"}}, // Dale Station
    {Coordinate{9.145, 45.1889}, CountryId{"IT"}}, // Pavia railway station
    {Coordinate{5.54944, 53.1822}, CountryId{"NL"}}, // Franeker railway station
    {Coordinate{6.56389, 53.2106}, CountryId{"NL"}}, // Groningen railway station
    {Coordinate{6.58444, 53.205}, CountryId{"NL"}}, // Groningen Europapark railway station
    {Coordinate{6.55639, 53.23}, CountryId{"NL"}}, // Groningen Noord railway station
    {Coordinate{5.79324, 53.1965}, CountryId{"NL"}}, // Leeuwarden railway station
    {Coordinate{5.84167, 53.2019}, CountryId{"NL"}}, // Leeuwarden Camminghaburen railway station
    {Coordinate{6.51861, 53.3614}, CountryId{"NL"}}, // Baflo railway station
    {Coordinate{6.51972, 53.3306}, CountryId{"NL"}}, // Winsum railway station
    {Coordinate{11.4016, 63.8575}, CountryId{"NO"}}, // Røra Station
    {Coordinate{10.5847, 60.3053}, CountryId{"NO"}}, // Lunner Station
    {Coordinate{-0.1919, 51.5374}, CountryId{"GB"}}, // Kilburn High Road railway station
    {Coordinate{11.7292, 45.9197}, CountryId{"IT"}}, // Cismon del Grappa railway station
    {Coordinate{14.3959, 41.0486}, CountryId{"IT"}}, // Maddaloni Superiore railway station
    {Coordinate{8.79518, 40.7776}, CountryId{"IT"}}, // Martis train station
    {Coordinate{12.7954, 42.3958}, CountryId{"IT"}}, // Poggio Fidoni railway halt
    {Coordinate{11.7247, 45.7945}, CountryId{"IT"}}, // Pove del Grappa-Campese railway halt
    {Coordinate{11.6914, 45.8381}, CountryId{"IT"}}, // San Nazario railway halt
    {Coordinate{8.2126, 48.9806}, CountryId{"DE"}}, // Bahnhof Berg (Pfalz)
    {Coordinate{8.25336, 49.0166}, CountryId{"DE"}}, // Q18005400
    {Coordinate{19.1272, 47.4829}, CountryId{"HU"}}, // Kőbánya alsó railway station
    {Coordinate{19.1338, 47.4918}, CountryId{"HU"}}, // Kőbánya felső railway station
    {Coordinate{8.23852, 48.9923}, CountryId{"DE"}}, // Bahnhof Neuburg
    {Coordinate{19.097, 47.4338}, CountryId{"HU"}}, // Pesterzsébet railway station
    {Coordinate{19.1881, 47.4025}, CountryId{"HU"}}, // Pestszentimre railway station
    {Coordinate{19.1731, 47.414}, CountryId{"HU"}}, // Pestszentimre felső railway station
    {Coordinate{19.1823, 47.455}, CountryId{"HU"}}, // Pestszentlőrinc railway station
    {Coordinate{19.1223, 47.5777}, CountryId{"HU"}}, // Rákospalota-Kertváros railway station
    {Coordinate{19.1462, 47.5212}, CountryId{"HU"}}, // Rákosszentmihály railway station
    {Coordinate{1.61806, 43.7506}, CountryId{"FR"}}, // Gare de Roqueserière-Buzet
    {Coordinate{19.1232, 47.4023}, CountryId{"HU"}}, // Soroksár railway station
    {Coordinate{19.0836, 47.4575}, CountryId{"HU"}}, // Soroksári út railway station
    {Coordinate{19.2128, 47.444}, CountryId{"HU"}}, // Szemeretelep railway station
    {Coordinate{21.9148, 39.3539}, CountryId{"GR"}}, // Karditsa railway station
    {Coordinate{6.23753, 60.632}, CountryId{"NO"}}, // Seimsgrend Station
    {Coordinate{6.28276, 60.6309}, CountryId{"NO"}}, // Bulken Station
    {Coordinate{5.73306, 60.5489}, CountryId{"NO"}}, // Stanghelle Station
    {Coordinate{5.95802, 60.6378}, CountryId{"NO"}}, // Bolstadøyri Station
    {Coordinate{6.10934, 60.647}, CountryId{"NO"}}, // Evanger Station
    {Coordinate{11.7908, 50.1891}, CountryId{"DE"}}, // Empfangsgebäude
    {Coordinate{9.76691, 49.0968}, CountryId{"DE"}}, // Schwäbisch Hall-Hessental station
    {Coordinate{12.4317, 52.0989}, CountryId{"DE"}}, // Wiesenburg station
    {Coordinate{-0.723, 51.519}, CountryId{"GB"}}, // Maidenhead railway station
    {Coordinate{12.9131, 49.7628}, CountryId{"CZ"}}, // Svojšín
    {Coordinate{-3.2299, 51.6928}, CountryId{"GB"}}, // Bargoed railway station
    {Coordinate{0.3406, 51.5679}, CountryId{"GB"}}, // West Horndon railway station
    {Coordinate{-4.3971, 55.804}, CountryId{"GB"}}, // Barrhead railway station
    {Coordinate{-0.296208, 46.3605}, CountryId{"FR"}}, // Q1808439
    {Coordinate{6.78213, 51.1235}, CountryId{"DE"}}, // Nievenheim station
    {Coordinate{9.33611, 59.5119}, CountryId{"NO"}}, // Trykkerud Station
    {Coordinate{7.63829, 48.4231}, CountryId{"FR"}}, // Erstein
    {Coordinate{1.99985, 43.4628}, CountryId{"FR"}}, // Gare de Revel - Sorèze
    {Coordinate{2.4592, 49.8993}, CountryId{"FR"}}, // Gare de Daours
    {Coordinate{16.3159, 48.1668}, CountryId{"AT"}}, // Wien Hetzendorf railway station
    {Coordinate{6.42083, 52.2839}, CountryId{"NL"}}, // Holten railway station
    {Coordinate{-0.414319, 51.8823}, CountryId{"GB"}}, // Luton railway station
    {Coordinate{2.75125, 48.4872}, CountryId{"FR"}}, // Gare de Fontaine-le-Port
    {Coordinate{-3.15721, 48.7056}, CountryId{"FR"}}, // Gare de Pontrieux
    {Coordinate{10.7225, 60.206}, CountryId{"NO"}}, // Harestua Station
    {Coordinate{7.83152, 48.9163}, CountryId{"FR"}}, // Q1810354
    {Coordinate{12.5781, 55.7156}, CountryId{"DK"}}, // Svanemøllen station
    {Coordinate{6.4161, 48.2446}, CountryId{"FR"}}, // Q1810836
    {Coordinate{7.39768, 51.3417}, CountryId{"DE"}}, // Hagen-Westerbauer station
    {Coordinate{76.7692, 11.3591}, CountryId{"IN"}}, // Aravankadu railway station
    {Coordinate{79.0683, 11.15}, CountryId{"IN"}}, // Ariyalur railway station
    {Coordinate{75.1892, 33.4507}, CountryId{"IN"}}, // Banihal railway station
    {Coordinate{78.8985, 17.5247}, CountryId{"IN"}}, // Bhongir railway station
    {Coordinate{78.7944, 17.4705}, CountryId{"IN"}}, // Bibinagar railway station
    {Coordinate{81.8654, 25.3787}, CountryId{"IN"}}, // Prayagraj Chheoki railway station
    {Coordinate{79.7033, 11.3915}, CountryId{"IN"}}, // Chidambaram railway station
    {Coordinate{76.7913, 11.3437}, CountryId{"IN"}}, // Coonoor railway station
    {Coordinate{-0.368163, 48.7019}, CountryId{"FR"}}, // Gare de Briouze
    {Coordinate{77.9855, 10.3538}, CountryId{"IN"}}, // Dindigul Junction railway station
    {Coordinate{80.1532, 17.446}, CountryId{"IN"}}, // Dornakal Junction railway station
    {Coordinate{1.205, 45.7783}, CountryId{"FR"}}, // Gare de l'Aiguille
    {Coordinate{-2.37, 53.753}, CountryId{"GB"}}, // Accrington railway station
    {Coordinate{8.58681, 50.2833}, CountryId{"DE"}}, // Bahnhof Saalburg
    {Coordinate{-4.0738, 55.8513}, CountryId{"GB"}}, // Bargeddie railway station
    {Coordinate{-0.031, 52.978}, CountryId{"GB"}}, // Boston railway station
    {Coordinate{76.6231, 8.86695}, CountryId{"IN"}}, // Eravipuram railway station
    {Coordinate{78.6782, 17.4531}, CountryId{"IN"}}, // Ghatkesar railway station
    {Coordinate{73.8934, 18.5278}, CountryId{"IN"}}, // Ghorpuri railway station
    {Coordinate{80.9876, 16.4299}, CountryId{"IN"}}, // Gudivada Junction railway station
    {Coordinate{83.81, 19.0691}, CountryId{"IN"}}, // Gunupur railway station
    {Coordinate{73.9278, 18.5269}, CountryId{"IN"}}, // Hadapsar railway station
    {Coordinate{-0.308, 51.3569}, CountryId{"GB"}}, // Chessington South railway station
    {Coordinate{75.9899, 17.5657}, CountryId{"IN"}}, // Hotgi Junction railway station
    {Coordinate{75.1481, 15.3503}, CountryId{"IN"}}, // Hubli Junction railway station
    {Coordinate{39.8921, 48.2812}, CountryId{"UA"}}, // Izvaryne railway station
    {Coordinate{88.7097, 26.5594}, CountryId{"IN"}}, // Jalpaiguri Road railway station
    {Coordinate{-3.011, 53.373}, CountryId{"GB"}}, // Rock Ferry railway station
    {Coordinate{79.1423, 18.459}, CountryId{"IN"}}, // Karimnagar railway station
    {Coordinate{76.544, 9.06527}, CountryId{"IN"}}, // Karunagappalli railway station
    {Coordinate{78.0851, 10.9656}, CountryId{"IN"}}, // Karur Junction railway station
    {Coordinate{76.7375, 11.382}, CountryId{"IN"}}, // Ketti railway station
    {Coordinate{76.6328, 8.91829}, CountryId{"IN"}}, // Kilikollur railway station
    {Coordinate{80.5467, 16.6232}, CountryId{"IN"}}, // Kondapalli railway station
    {Coordinate{76.766, 9.00028}, CountryId{"IN"}}, // Kottarakkara railway station
    {Coordinate{76.6786, 8.96037}, CountryId{"IN"}}, // Kundara railway station
    {Coordinate{76.8528, 29.9694}, CountryId{"IN"}}, // Kurukshetra Junction railway station
    {Coordinate{76.7043, 11.3824}, CountryId{"IN"}}, // Lovedale railway station
    {Coordinate{79.8931, 12.5044}, CountryId{"IN"}}, // Madurantakam railway station
    {Coordinate{80.565, 16.4383}, CountryId{"IN"}}, // Mangalagiri railway station
    {Coordinate{7.09398, 47.8132}, CountryId{"FR"}}, // Gare de Thann-Saint-Jacques
    {Coordinate{76.6473, 8.83776}, CountryId{"IN"}}, // Mayyanad railway station
    {Coordinate{75.7711, 22.5552}, CountryId{"IN"}}, // Dr. Ambedkar Nagar railway station
    {Coordinate{77.7078, 29.4687}, CountryId{"IN"}}, // Muzaffarnagar railway station
    {Coordinate{78.1791, 11.2261}, CountryId{"IN"}}, // Namakkal railway station
    {Coordinate{89.5414, 26.4857}, CountryId{"IN"}}, // New Alipurduar railway station
    {Coordinate{88.7858, 26.5695}, CountryId{"IN"}}, // New Domohani railway station
    {Coordinate{78.1032, 18.6792}, CountryId{"IN"}}, // Nizamabad Junction railway station
    {Coordinate{-4.996, 51.757}, CountryId{"GB"}}, // Johnston railway station
    {Coordinate{80.9615, 16.6499}, CountryId{"IN"}}, // Nuzvid railway station
    {Coordinate{78.0452, 11.7383}, CountryId{"IN"}}, // Omalur Junction railway station
    {Coordinate{72.8501, 19.151}, CountryId{"IN"}}, // Ram Mandir railway station
    {Coordinate{78.0721, 12.2974}, CountryId{"IN"}}, // Palakkodu railway station
    {Coordinate{72.4302, 24.1744}, CountryId{"IN"}}, // Palanpur Junction railway station
    {Coordinate{84.0806, 18.7866}, CountryId{"IN"}}, // Parlakhemundi railway station
    {Coordinate{-0.2147, 51.356}, CountryId{"GB"}}, // Cheam railway station
    {Coordinate{7.22127, 51.2742}, CountryId{"DE"}}, // Wuppertal-Oberbarmen
    {Coordinate{1.5628, 46.6947}, CountryId{"FR"}}, // Gare de Lothiers
    {Coordinate{0.675851, 44.2328}, CountryId{"FR"}}, // Gare de Pont-du-Casse
    {Coordinate{15.9461, 50.0019}, CountryId{"CZ"}}, // Moravany (train station)
    {Coordinate{-2.94639, 53.4025}, CountryId{"GB"}}, // Edge Hill railway station
    {Coordinate{1.74238, 43.744}, CountryId{"FR"}}, // Q1814219
    {Coordinate{-3.226, 54.119}, CountryId{"GB"}}, // Barrow-in-Furness railway station
    {Coordinate{3.45139, 50.5694}, CountryId{"BE"}}, // Antoing railway station
    {Coordinate{-80.2525, 35.8203}, CountryId{"US"}}, // Lexington
    {Coordinate{1.166, 52.081}, CountryId{"GB"}}, // Westerfield railway station
    {Coordinate{-78.7061, 35.7942}, CountryId{"US"}}, // North Carolina State Fair station
    {Coordinate{-4.2759, 55.8208}, CountryId{"GB"}}, // Langside railway station
    {Coordinate{0.628, 51.265}, CountryId{"GB"}}, // Hollingbourne railway station
    {Coordinate{-1.845, 52.403}, CountryId{"GB"}}, // Shirley railway station
    {Coordinate{5.70493, 43.1873}, CountryId{"FR"}}, // Station Saint-Cyr-les-Lecques-la-Cadière
    {Coordinate{2.29167, 48.9797}, CountryId{"FR"}}, // Gare du Champ de courses d'Enghien
    {Coordinate{-0.094, 51.3484}, CountryId{"GB"}}, // Sanderstead railway station
    {Coordinate{16.7192, 41.0153}, CountryId{"IT"}}, // Grumo Appula railway station
    {Coordinate{-0.996944, 50.8536}, CountryId{"GB"}}, // Bedhampton railway station
    {Coordinate{12.0497, 45.1978}, CountryId{"IT"}}, // Cona Veneta train station
    {Coordinate{16.026, 48.7808}, CountryId{"CZ"}}, // Šatov station
    {Coordinate{12.8311, 50.0828}, CountryId{"CZ"}}, // Bečov nad Teplou
    {Coordinate{15.4841, 49.2718}, CountryId{"CZ"}}, // Hodice
    {Coordinate{16.3885, 50.5598}, CountryId{"CZ"}}, // Otovice zastávka
    {Coordinate{15.4815, 49.3209}, CountryId{"CZ"}}, // Jezdovice
    {Coordinate{15.8743, 48.9231}, CountryId{"CZ"}}, // Šumná
    {Coordinate{15.3, 50.2106}, CountryId{"CZ"}}, // Městec Králové
    {Coordinate{13.4358, 49.295}, CountryId{"CZ"}}, // Q18170852
    {Coordinate{16.92, 50.0892}, CountryId{"CZ"}}, // Q18170853
    {Coordinate{16.3675, 48.8731}, CountryId{"CZ"}}, // Břežany
    {Coordinate{16.2736, 50.1578}, CountryId{"CZ"}}, // Rychnov nad Kněžnou
    {Coordinate{13.6633, 50.1417}, CountryId{"CZ"}}, // Q18170875
    {Coordinate{15.7236, 50.0317}, CountryId{"CZ"}}, // Zastávka ve Svítkově
    {Coordinate{15.1322, 50.4414}, CountryId{"CZ"}}, // Q18170878
    {Coordinate{15.1886, 49.8156}, CountryId{"CZ"}}, // Q18170880
    {Coordinate{13.3036, 49.3044}, CountryId{"CZ"}}, // Běšiny station
    {Coordinate{14.0294, 50.6581}, CountryId{"CZ"}}, // Ústí nad Labem západ (train station)
    {Coordinate{13.6286, 50.0917}, CountryId{"CZ"}}, // Q18170905
    {Coordinate{16.1644, 48.8415}, CountryId{"CZ"}}, // Hodonice
    {Coordinate{14.7581, 50.7692}, CountryId{"CZ"}}, // Jablonné v Podještědí
    {Coordinate{13.3747, 49.7367}, CountryId{"CZ"}}, // Plzeň zastávka
    {Coordinate{14.305, 50.7381}, CountryId{"CZ"}}, // Benešov nad Ploučnicí
    {Coordinate{16.0856, 50.0971}, CountryId{"CZ"}}, // Borohrádek
    {Coordinate{16.2877, 48.8233}, CountryId{"CZ"}}, // Božice u Znojma (train station)
    {Coordinate{16.9231, 50.0581}, CountryId{"CZ"}}, // Q18170982
    {Coordinate{13.6958, 50.0783}, CountryId{"CZ"}}, // Lubná
    {Coordinate{16.3831, 48.8101}, CountryId{"CZ"}}, // Hrušovany nad Jevišovkou-Šanov
    {Coordinate{15.0614, 50.7472}, CountryId{"CZ"}}, // Liberec-Rochlice
    {Coordinate{13.9547, 50.6125}, CountryId{"CZ"}}, // Řehlovice
    {Coordinate{15.7981, 50.2019}, CountryId{"CZ"}}, // Hradec Králové-Kukleny
    {Coordinate{14.335, 50.5854}, CountryId{"CZ"}}, // Úštěk
    {Coordinate{15.468, 49.8366}, CountryId{"CZ"}}, // Golčův Jeníkov
    {Coordinate{15.5228, 50.4864}, CountryId{"CZ"}}, // Nová Paka
    {Coordinate{13.3478, 49.7417}, CountryId{"CZ"}}, // Q18171014
    {Coordinate{13.6036, 50.1356}, CountryId{"CZ"}}, // Q18171015
    {Coordinate{2.48443, 47.0965}, CountryId{"FR"}}, // Gare de Saint-Germain-du-Puy
    {Coordinate{0.596, 51.839}, CountryId{"GB"}}, // White Notley railway station
    {Coordinate{7.3391, 48.5258}, CountryId{"FR"}}, // Gare d'Urmatt
    {Coordinate{-2.9529, 53.3757}, CountryId{"GB"}}, // St Michaels railway station
    {Coordinate{14.5131, 46.0589}, CountryId{"SI"}}, // Ljubljana railway station
    {Coordinate{-1.11561, 46.1081}, CountryId{"FR"}}, // Gare d'Angoulins-sur-Mer
    {Coordinate{2.40887, 50.7307}, CountryId{"FR"}}, // Ebblinghem
    {Coordinate{16.6635, 49.2953}, CountryId{"CZ"}}, // Adamov
    {Coordinate{16.6496, 49.3014}, CountryId{"CZ"}}, // Adamov zastávka
    {Coordinate{14.9228, 50.4719}, CountryId{"CZ"}}, // Bakov nad Jizerou
    {Coordinate{14.0839, 49.1264}, CountryId{"CZ"}}, // Bavorov
    {Coordinate{14.4828, 49.2933}, CountryId{"CZ"}}, // Bechyně zastávka
    {Coordinate{15.0708, 49.9558}, CountryId{"CZ"}}, // Bečváry (train station)
    {Coordinate{12.7206, 49.5886}, CountryId{"CZ"}}, // Q18180129
    {Coordinate{14.836, 50.4883}, CountryId{"CZ"}}, // Bělá pod Bezdězem (train station)
    {Coordinate{13.3211, 49.2936}, CountryId{"CZ"}}, // Q18180131
    {Coordinate{12.9694, 49.9031}, CountryId{"CZ"}}, // Q18180132
    {Coordinate{13.4003, 49.7681}, CountryId{"CZ"}}, // Q18180133
    {Coordinate{13.7719, 50.5539}, CountryId{"CZ"}}, // Bílina
    {Coordinate{15.7347, 49.3629}, CountryId{"CZ"}}, // Bítovčice
    {Coordinate{16.6478, 49.3521}, CountryId{"CZ"}}, // Blansko
    {Coordinate{13.8725, 49.4308}, CountryId{"CZ"}}, // Blatná railway station
    {Coordinate{16.9011, 50.0261}, CountryId{"CZ"}}, // Bohdíkov
    {Coordinate{14.1489, 50.4911}, CountryId{"CZ"}}, // Bohušovice nad Ohří
    {Coordinate{17.7955, 49.0361}, CountryId{"CZ"}}, // Bojkovice
    {Coordinate{13.3853, 49.7864}, CountryId{"CZ"}}, // Q18180142
    {Coordinate{12.7783, 49.7175}, CountryId{"CZ"}}, // Bor station
    {Coordinate{16.6514, 49.4913}, CountryId{"CZ"}}, // Boskovice
    {Coordinate{14.6533, 50.1839}, CountryId{"CZ"}}, // Brandýs nad Labem (train station)
    {Coordinate{17.015, 50.1467}, CountryId{"CZ"}}, // Branná
    {Coordinate{13.9639, 49.5583}, CountryId{"CZ"}}, // Březnice
    {Coordinate{0.592, 50.867}, CountryId{"GB"}}, // Ore railway station
    {Coordinate{16.5204, 49.6333}, CountryId{"CZ"}}, // Březová nad Svitavou
    {Coordinate{16.5083, 49.6553}, CountryId{"CZ"}}, // Q18180152
    {Coordinate{18.0365, 49.0942}, CountryId{"CZ"}}, // Brumov
    {Coordinate{16.9995, 49.1457}, CountryId{"CZ"}}, // Bučovice
    {Coordinate{17.6139, 49.7956}, CountryId{"CZ"}}, // Q18180155
    {Coordinate{14.1339, 50.405}, CountryId{"CZ"}}, // Q18180156
    {Coordinate{18.014, 49.0677}, CountryId{"CZ"}}, // Bylnice (train station)
    {Coordinate{17.6655, 49.393}, CountryId{"CZ"}}, // Bystřice pod Hostýnem
    {Coordinate{17.263, 48.9692}, CountryId{"CZ"}}, // Bzenec
    {Coordinate{16.9585, 48.9422}, CountryId{"CZ"}}, // Čejč
    {Coordinate{14.7542, 50.1578}, CountryId{"CZ"}}, // Čelákovice
    {Coordinate{16.7464, 50.0469}, CountryId{"CZ"}}, // Červená Voda (train station)
    {Coordinate{16.0755, 50.4838}, CountryId{"CZ"}}, // Červený Kostelec (train station)
    {Coordinate{14.4139, 50.7958}, CountryId{"CZ"}}, // Česká Kamenice (train station)
    {Coordinate{12.865, 49.3742}, CountryId{"CZ"}}, // Q18180165
    {Coordinate{16.054, 50.3956}, CountryId{"CZ"}}, // Česká Skalice
    {Coordinate{14.4756, 48.9592}, CountryId{"CZ"}}, // České Budějovice jižní zastávka
    {Coordinate{14.9353, 49.8136}, CountryId{"CZ"}}, // Český Šternberk (train station)
    {Coordinate{14.9297, 49.8083}, CountryId{"CZ"}}, // Český Šternberk zastávka
    {Coordinate{13.9214, 50.6803}, CountryId{"CZ"}}, // Q18180171
    {Coordinate{15.4572, 50.1633}, CountryId{"CZ"}}, // Chlumec nad Cidlinou
    {Coordinate{12.7539, 50.2314}, CountryId{"CZ"}}, // Chodov
    {Coordinate{13.4136, 50.4697}, CountryId{"CZ"}}, // Chomutov město
    {Coordinate{15.6825, 49.7117}, CountryId{"CZ"}}, // Chotěboř
    {Coordinate{14.9519, 50.8131}, CountryId{"CZ"}}, // Chrastava
    {Coordinate{17.361, 49.3694}, CountryId{"CZ"}}, // Chropyně
    {Coordinate{15.7939, 49.9577}, CountryId{"CZ"}}, // Chrudim město (train station)
    {Coordinate{13.2478, 50.1111}, CountryId{"CZ"}}, // Chyše
    {Coordinate{15.3292, 49.9424}, CountryId{"CZ"}}, // Q18180182
    {Coordinate{13.5689, 50.0331}, CountryId{"CZ"}}, // Čistá
    {Coordinate{15.4392, 49.0859}, CountryId{"CZ"}}, // Dačice (train station)
    {Coordinate{15.3089, 50.7533}, CountryId{"CZ"}}, // Desná
    {Coordinate{13.3033, 49.6564}, CountryId{"CZ"}}, // Dobřany
    {Coordinate{13.3239, 49.6814}, CountryId{"CZ"}}, // Q18180187
    {Coordinate{14.1833, 49.79}, CountryId{"CZ"}}, // Dobříš
    {Coordinate{16.1522, 50.2892}, CountryId{"CZ"}}, // Dobruška
    {Coordinate{16.7211, 50.0892}, CountryId{"CZ"}}, // Dolní Lipka (train station)
    {Coordinate{12.9431, 49.435}, CountryId{"CZ"}}, // Domažlice railway station
    {Coordinate{13.3831, 49.7217}, CountryId{"CZ"}}, // Q18180201
    {Coordinate{13.755, 50.6172}, CountryId{"CZ"}}, // Duchcov
    {Coordinate{16.9292, 50.0717}, CountryId{"CZ"}}, // Hanušovice
    {Coordinate{15.6583, 49.9514}, CountryId{"CZ"}}, // Q18180222
    {Coordinate{17.121, 48.8442}, CountryId{"CZ"}}, // Q18180226
    {Coordinate{17.5709, 49.327}, CountryId{"CZ"}}, // Holešov (train station)
    {Coordinate{15.9925, 50.0692}, CountryId{"CZ"}}, // Holice
    {Coordinate{13.7097, 49.3208}, CountryId{"CZ"}}, // Horažďovice
    {Coordinate{12.7664, 50.3878}, CountryId{"CZ"}}, // Horní Blatná
    {Coordinate{13.3794, 49.8508}, CountryId{"CZ"}}, // Horní Bříza
    {Coordinate{12.8039, 50.1375}, CountryId{"CZ"}}, // Horní Slavkov
    {Coordinate{12.9375, 49.5242}, CountryId{"CZ"}}, // Q18180239
    {Coordinate{15.7378, 50.5367}, CountryId{"CZ"}}, // Hostinné
    {Coordinate{14.2583, 50.0839}, CountryId{"CZ"}}, // Hostivice (train station)
    {Coordinate{14.3275, 50.4914}, CountryId{"CZ"}}, // Q18180243
    {Coordinate{15.8415, 50.2224}, CountryId{"CZ"}}, // Hradec Králové zastávka
    {Coordinate{15.8597, 50.2219}, CountryId{"CZ"}}, // Hradec Králové-Slezské Předměstí
    {Coordinate{16.4847, 49.7003}, CountryId{"CZ"}}, // Q18180246
    {Coordinate{14.847, 50.8558}, CountryId{"CZ"}}, // Hrádek nad Nisou railway station
    {Coordinate{17.7418, 49.5458}, CountryId{"CZ"}}, // Hranice na Moravě město
    {Coordinate{13.7218, 50.6603}, CountryId{"CZ"}}, // Q18180249
    {Coordinate{16.1767, 50.4728}, CountryId{"CZ"}}, // Hronov (train station)
    {Coordinate{16.5913, 49.0344}, CountryId{"CZ"}}, // Hrušovany u Brna
    {Coordinate{17.4766, 49.3165}, CountryId{"CZ"}}, // Hulín (train station)
    {Coordinate{15.3482, 49.5349}, CountryId{"CZ"}}, // Humpolec
    {Coordinate{17.4651, 49.1149}, CountryId{"CZ"}}, // Huštěnovice
    {Coordinate{16.2883, 50.6244}, CountryId{"CZ"}}, // Hynčice
    {Coordinate{16.3726, 49.0982}, CountryId{"CZ"}}, // Ivančice
    {Coordinate{17.0872, 49.3063}, CountryId{"CZ"}}, // Ivanovice na Hané
    {Coordinate{15.435, 50.7003}, CountryId{"CZ"}}, // Jablonec nad Jizerou (train station)
    {Coordinate{15.1606, 50.7208}, CountryId{"CZ"}}, // Jablonec nad Nisou (train station)
    {Coordinate{16.5944, 50.0264}, CountryId{"CZ"}}, // Q18180272
    {Coordinate{16.6025, 50.0397}, CountryId{"CZ"}}, // Q18180274
    {Coordinate{13.2036, 49.3525}, CountryId{"CZ"}}, // Janovice nad Úhlavou station
    {Coordinate{15.5809, 49.016}, CountryId{"CZ"}}, // Jemnice
    {Coordinate{13.4717, 50.0931}, CountryId{"CZ"}}, // Jesenice (train station)
    {Coordinate{16.7309, 49.6308}, CountryId{"CZ"}}, // Q18180284
    {Coordinate{15.3611, 50.4306}, CountryId{"CZ"}}, // Jičín
    {Coordinate{15.6085, 49.4438}, CountryId{"CZ"}}, // Jihlava-Bosch Diesel
    {Coordinate{15.5681, 49.4103}, CountryId{"CZ"}}, // Jihlava-Staré Hory
    {Coordinate{15.5136, 50.6042}, CountryId{"CZ"}}, // Jilemnice
    {Coordinate{14.4972, 49.8778}, CountryId{"CZ"}}, // Jílové u Prahy (train station)
    {Coordinate{16.9892, 50.0989}, CountryId{"CZ"}}, // Q18180296
    {Coordinate{13.4475, 50.4853}, CountryId{"CZ"}}, // Jirkov zastávka
    {Coordinate{15.0183, 49.7867}, CountryId{"CZ"}}, // Kácov
    {Coordinate{13.2769, 50.3817}, CountryId{"CZ"}}, // Kadaň
    {Coordinate{14.9836, 50.7736}, CountryId{"CZ"}}, // Karlov pod Ještědem
    {Coordinate{18.2457, 49.3504}, CountryId{"CZ"}}, // Karolinka
    {Coordinate{13.7439, 49.4569}, CountryId{"CZ"}}, // Kasejovice
    {Coordinate{13.3749, 49.8938}, CountryId{"CZ"}}, // Q18180312
    {Coordinate{13.0322, 49.3836}, CountryId{"CZ"}}, // Kdyně station
    {Coordinate{14.1139, 50.1278}, CountryId{"CZ"}}, // Kladno
    {Coordinate{14.1299, 50.1634}, CountryId{"CZ"}}, // Kladno-Dubí
    {Coordinate{14.1147, 50.1614}, CountryId{"CZ"}}, // Kladno-Švermov
    {Coordinate{13.1961, 50.385}, CountryId{"CZ"}}, // Klášterec nad Ohří
    {Coordinate{13.2749, 49.4012}, CountryId{"CZ"}}, // Klatovy (train station)
    {Coordinate{13.295, 49.3858}, CountryId{"CZ"}}, // Q18180325
    {Coordinate{12.8225, 49.4389}, CountryId{"CZ"}}, // Q18180326
    {Coordinate{14.9038, 50.0943}, CountryId{"CZ"}}, // Klučov
    {Coordinate{17.3048, 49.3454}, CountryId{"CZ"}}, // Kojetín
    {Coordinate{15.2228, 50.0153}, CountryId{"CZ"}}, // Kolín místní nádraží
    {Coordinate{15.195, 50.0306}, CountryId{"CZ"}}, // Kolín zastávka
    {Coordinate{16.8837, 49.5916}, CountryId{"CZ"}}, // Konice (train station)
    {Coordinate{15.2604, 50.334}, CountryId{"CZ"}}, // Kopidlno
    {Coordinate{18.1472, 49.5953}, CountryId{"CZ"}}, // Kopřivnice
    {Coordinate{18.1494, 49.6039}, CountryId{"CZ"}}, // Kopřivnice zastávka
    {Coordinate{15.3661, 50.77}, CountryId{"CZ"}}, // Kořenov railway station
    {Coordinate{15.3469, 50.7624}, CountryId{"CZ"}}, // Q18180336
    {Coordinate{17.065, 49.5091}, CountryId{"CZ"}}, // Kostelec na Hané (train station)
    {Coordinate{14.5792, 50.2211}, CountryId{"CZ"}}, // Kostelec nad Labem (train station)
    {Coordinate{16.2239, 50.1164}, CountryId{"CZ"}}, // Kostelec nad Orlicí
    {Coordinate{14.9878, 50.005}, CountryId{"CZ"}}, // Kouřim
    {Coordinate{13.0119, 49.3969}, CountryId{"CZ"}}, // Kout na Šumavě
    {Coordinate{16.7486, 50.0867}, CountryId{"CZ"}}, // Q18180342
    {Coordinate{14.3136, 50.2381}, CountryId{"CZ"}}, // Kralupy nad Vltavou
    {Coordinate{12.5022, 50.3306}, CountryId{"CZ"}}, // Kraslice
    {Coordinate{14.5119, 50.9189}, CountryId{"CZ"}}, // Krásná Lípa railway station
    {Coordinate{13.3686, 50.2556}, CountryId{"CZ"}}, // Krásný Dvůr
    {Coordinate{13.8686, 50.0381}, CountryId{"CZ"}}, // Křivoklát
    {Coordinate{17.403, 49.3023}, CountryId{"CZ"}}, // Kroměříž (train station)
    {Coordinate{13.7229, 50.1697}, CountryId{"CZ"}}, // Krupá
    {Coordinate{13.8506, 50.6783}, CountryId{"CZ"}}, // Q18180352
    {Coordinate{17.4703, 49.052}, CountryId{"CZ"}}, // Kunovice
    {Coordinate{16.5343, 49.301}, CountryId{"CZ"}}, // Kuřim
    {Coordinate{15.3011, 49.9617}, CountryId{"CZ"}}, // Kutná Hora hlavní nádraží
    {Coordinate{15.2772, 49.9497}, CountryId{"CZ"}}, // Kutná Hora město
    {Coordinate{15.2669, 49.9372}, CountryId{"CZ"}}, // Kutná Hora předměstí
    {Coordinate{15.2903, 49.9575}, CountryId{"CZ"}}, // Q18180358
    {Coordinate{17.1226, 49.0161}, CountryId{"CZ"}}, // Kyjov
    {Coordinate{16.881, 48.8131}, CountryId{"CZ"}}, // Ladná
    {Coordinate{15.9294, 50.6733}, CountryId{"CZ"}}, // Q18180361
    {Coordinate{16.6033, 49.9086}, CountryId{"CZ"}}, // Lanškroun (train station)
    {Coordinate{15.5772, 50.4261}, CountryId{"CZ"}}, // Q18180364
    {Coordinate{15.2704, 49.698}, CountryId{"CZ"}}, // Ledeč nad Sázavou
    {Coordinate{14.9322, 49.8472}, CountryId{"CZ"}}, // Ledečko
    {Coordinate{16.5709, 49.556}, CountryId{"CZ"}}, // Letovice
    {Coordinate{14.3642, 50.1997}, CountryId{"CZ"}}, // Libčice nad Vltavou
    {Coordinate{14.4356, 50.4142}, CountryId{"CZ"}}, // Liběchov
    {Coordinate{14.0547, 50.4103}, CountryId{"CZ"}}, // Libochovice
    {Coordinate{14.1314, 50.5408}, CountryId{"CZ"}}, // Litoměřice horní nádraží
    {Coordinate{16.3041, 49.8748}, CountryId{"CZ"}}, // Litomyšl
    {Coordinate{17.0709, 49.7015}, CountryId{"CZ"}}, // Litovel město
    {Coordinate{13.6103, 50.5928}, CountryId{"CZ"}}, // Litvínov
    {Coordinate{13.6139, 50.5911}, CountryId{"CZ"}}, // Litvínov město
    {Coordinate{12.7528, 50.1898}, CountryId{"CZ"}}, // Loket (train station)
    {Coordinate{15.3744, 50.527}, CountryId{"CZ"}}, // Lomnice nad Popelkou
    {Coordinate{17.0867, 50.0689}, CountryId{"CZ"}}, // Q18180384
    {Coordinate{17.0839, 50.0564}, CountryId{"CZ"}}, // Q18180385
    {Coordinate{14.2567, 48.6206}, CountryId{"CZ"}}, // Q18180386
    {Coordinate{14.2453, 48.6244}, CountryId{"CZ"}}, // Loučovice zastávka
    {Coordinate{13.7964, 50.35}, CountryId{"CZ"}}, // Louny město
    {Coordinate{13.7678, 50.3433}, CountryId{"CZ"}}, // Q18180389
    {Coordinate{14.0594, 50.5094}, CountryId{"CZ"}}, // Lovosice
    {Coordinate{14.0447, 50.5211}, CountryId{"CZ"}}, // Lovosice město (train station)
    {Coordinate{14.0422, 50.5186}, CountryId{"CZ"}}, // Q18180392
    {Coordinate{13.3056, 49.3642}, CountryId{"CZ"}}, // Luby u Klatov station
    {Coordinate{17.752, 49.0989}, CountryId{"CZ"}}, // Luhačovice
    {Coordinate{15.71, 49.3696}, CountryId{"CZ"}}, // Luka nad Jihlavou
    {Coordinate{16.4842, 50.0492}, CountryId{"CZ"}}, // Lukavice v Čechách
    {Coordinate{14.8422, 50.1956}, CountryId{"CZ"}}, // Lysá nad Labem
    {Coordinate{15.2308, 49.9072}, CountryId{"CZ"}}, // Malešov
    {Coordinate{13.3306, 50.4417}, CountryId{"CZ"}}, // Q18180402
    {Coordinate{15.6318, 49.4026}, CountryId{"CZ"}}, // Q18180403
    {Coordinate{17.8758, 49.6356}, CountryId{"CZ"}}, // Q18180406
    {Coordinate{14.8817, 50.2292}, CountryId{"CZ"}}, // Milovice
    {Coordinate{14.7144, 50.6578}, CountryId{"CZ"}}, // Mimoň
    {Coordinate{13.6661, 49.7}, CountryId{"CZ"}}, // Q18180409
    {Coordinate{14.0342, 49.5097}, CountryId{"CZ"}}, // Q18180410
    {Coordinate{16.6297, 50.0919}, CountryId{"CZ"}}, // Mladkov (train station)
    {Coordinate{14.9781, 50.5183}, CountryId{"CZ"}}, // Mnichovo Hradiště
    {Coordinate{14.2698, 49.8538}, CountryId{"CZ"}}, // Mníšek pod Brdy
    {Coordinate{16.6062, 49.1338}, CountryId{"CZ"}}, // Modřice
    {Coordinate{17.0221, 48.7996}, CountryId{"CZ"}}, // Moravská Nová Ves
    {Coordinate{16.6665, 49.7667}, CountryId{"CZ"}}, // Moravská Třebová
    {Coordinate{15.8092, 49.0575}, CountryId{"CZ"}}, // Moravské Budějovice (train station)
    {Coordinate{16.3384, 49.0465}, CountryId{"CZ"}}, // Moravský Krumlov
    {Coordinate{13.6583, 50.5112}, CountryId{"CZ"}}, // Most
    {Coordinate{13.6217, 50.5433}, CountryId{"CZ"}}, // Q18180421
    {Coordinate{13.6233, 50.5642}, CountryId{"CZ"}}, // Q18180422
    {Coordinate{14.6978, 49.8322}, CountryId{"CZ"}}, // Mrač
    {Coordinate{14.6406, 50.4356}, CountryId{"CZ"}}, // Mšeno
    {Coordinate{13.7042, 50.2169}, CountryId{"CZ"}}, // Mutějovice (train station)
    {Coordinate{13.7025, 50.1872}, CountryId{"CZ"}}, // Mutějovice zastávka
    {Coordinate{16.1475, 49.207}, CountryId{"CZ"}}, // Náměšť nad Oslavou (train station)
    {Coordinate{17.5048, 49.1631}, CountryId{"CZ"}}, // Napajedla
    {Coordinate{12.7274, 50.3191}, CountryId{"CZ"}}, // Nejdek
    {Coordinate{14.5175, 50.2625}, CountryId{"CZ"}}, // Neratovice
    {Coordinate{14.1069, 50.6725}, CountryId{"CZ"}}, // Neštěmice
    {Coordinate{14.1894, 49.0539}, CountryId{"CZ"}}, // Q18180435
    {Coordinate{16.1375, 50.3533}, CountryId{"CZ"}}, // Nové Město nad Metují
    {Coordinate{13.8817, 50.1519}, CountryId{"CZ"}}, // Nové Strašecí (train station)
    {Coordinate{14.5474, 50.7607}, CountryId{"CZ"}}, // Nový Bor
    {Coordinate{15.4858, 50.2447}, CountryId{"CZ"}}, // Nový Bydžov
    {Coordinate{18.0089, 49.5986}, CountryId{"CZ"}}, // Nový Jičín město
    {Coordinate{15.0456, 50.1931}, CountryId{"CZ"}}, // Nymburk hlavní nádraží
    {Coordinate{13.2095, 49.715}, CountryId{"CZ"}}, // Nýřany
    {Coordinate{17.8333, 49.6697}, CountryId{"CZ"}}, // Odry
    {Coordinate{17.2412, 49.5941}, CountryId{"CZ"}}, // Olomouc město
    {Coordinate{17.2366, 49.6023}, CountryId{"CZ"}}, // Olomouc-Hejčín
    {Coordinate{17.2443, 49.5873}, CountryId{"CZ"}}, // Nová Ulice
    {Coordinate{17.2547, 49.5856}, CountryId{"CZ"}}, // Olomouc-Smetanovy sady
    {Coordinate{16.3463, 49.1189}, CountryId{"CZ"}}, // Oslavany
    {Coordinate{15.0143, 50.7632}, CountryId{"CZ"}}, // Ostašov railway station
    {Coordinate{17.0506, 50.1833}, CountryId{"CZ"}}, // Ostružná
    {Coordinate{16.3717, 50.5611}, CountryId{"CZ"}}, // Otovice (train station)
    {Coordinate{15.7509, 50.0244}, CountryId{"CZ"}}, // Pardubice závodiště
    {Coordinate{15.0269, 50.0897}, CountryId{"CZ"}}, // Pečky train station
    {Coordinate{13.9586, 50.3358}, CountryId{"CZ"}}, // Peruc
    {Coordinate{15.8128, 50.5342}, CountryId{"CZ"}}, // Pilníkov
    {Coordinate{14.1614, 49.3139}, CountryId{"CZ"}}, // Písek město
    {Coordinate{13.3794, 49.9308}, CountryId{"CZ"}}, // Plasy
    {Coordinate{15.7925, 50.2347}, CountryId{"CZ"}}, // Q18180461
    {Coordinate{12.8114, 49.5133}, CountryId{"CZ"}}, // Poběžovice railway station
    {Coordinate{13.1356, 49.3461}, CountryId{"CZ"}}, // Pocinovice
    {Coordinate{13.4045, 50.2234}, CountryId{"CZ"}}, // Podbořany
    {Coordinate{16.8541, 48.8375}, CountryId{"CZ"}}, // Podivín
    {Coordinate{16.2641, 49.7189}, CountryId{"CZ"}}, // Polička
    {Coordinate{16.6682, 48.9243}, CountryId{"CZ"}}, // Popice
    {Coordinate{14.6764, 49.8372}, CountryId{"CZ"}}, // Poříčí nad Sázavou
    {Coordinate{13.6914, 50.3603}, CountryId{"CZ"}}, // Postoloprty
    {Coordinate{12.8147, 49.4589}, CountryId{"CZ"}}, // Q18180470
    {Coordinate{16.6305, 48.942}, CountryId{"CZ"}}, // Q18180471
    {Coordinate{13.3225, 49.575}, CountryId{"CZ"}}, // Přeštice
    {Coordinate{18.1423, 49.6359}, CountryId{"CZ"}}, // Příbor
    {Coordinate{17.1296, 49.4724}, CountryId{"CZ"}}, // Prostějov railway station
    {Coordinate{13.5967, 49.858}, CountryId{"CZ"}}, // Radnice
    {Coordinate{16.6054, 49.0853}, CountryId{"CZ"}}, // Rajhrad
    {Coordinate{13.7506, 50.1047}, CountryId{"CZ"}}, // Q18180482
    {Coordinate{16.8215, 48.8668}, CountryId{"CZ"}}, // Q18180483
    {Coordinate{14.9503, 49.8436}, CountryId{"CZ"}}, // Rataje nad Sázavou
    {Coordinate{14.9789, 49.8494}, CountryId{"CZ"}}, // Q18180485
    {Coordinate{14.9478, 49.8444}, CountryId{"CZ"}}, // Rataje nad Sázavou zastávka
    {Coordinate{14.9411, 49.8397}, CountryId{"CZ"}}, // Q18180487
    {Coordinate{15.1603, 49.9814}, CountryId{"CZ"}}, // Ratboř
    {Coordinate{16.5904, 49.2507}, CountryId{"CZ"}}, // Brno-Řečkovice
    {Coordinate{13.8008, 50.6422}, CountryId{"CZ"}}, // Řetenice (train station)
    {Coordinate{15.4229, 50.7121}, CountryId{"CZ"}}, // Rokytnice nad Jizerou
    {Coordinate{16.4653, 50.1614}, CountryId{"CZ"}}, // Rokytnice v Orlických horách (train station)
    {Coordinate{15.5281, 49.8947}, CountryId{"CZ"}}, // Ronov nad Doubravou (train station)
    {Coordinate{14.8047, 50.0786}, CountryId{"CZ"}}, // Rostoklaty
    {Coordinate{16.8677, 49.197}, CountryId{"CZ"}}, // Rousínov
    {Coordinate{15.2633, 50.5319}, CountryId{"CZ"}}, // Rovensko pod Troskami
    {Coordinate{14.3631, 48.6264}, CountryId{"CZ"}}, // Rožmberk nad Vltavou
    {Coordinate{13.8821, 49.6021}, CountryId{"CZ"}}, // Rožmitál pod Třemšínem (train station)
    {Coordinate{18.1345, 49.4605}, CountryId{"CZ"}}, // Rožnov pod Radhoštěm
    {Coordinate{14.9867, 50.1311}, CountryId{"CZ"}}, // Sadská
    {Coordinate{16.7065, 48.9126}, CountryId{"CZ"}}, // Šakvice
    {Coordinate{14.8936, 49.8692}, CountryId{"CZ"}}, // Sázava zastávka
    {Coordinate{14.9061, 49.875}, CountryId{"CZ"}}, // Sázava
    {Coordinate{15.4957, 49.2248}, CountryId{"CZ"}}, // Sedlejov
    {Coordinate{15.3239, 50.6033}, CountryId{"CZ"}}, // Semily
    {Coordinate{18.1283, 49.6564}, CountryId{"CZ"}}, // Skotnice
    {Coordinate{15.995, 49.8376}, CountryId{"CZ"}}, // Skuteč
    {Coordinate{16.7295, 49.1568}, CountryId{"CZ"}}, // Šlapanice
    {Coordinate{15.8251, 49.9189}, CountryId{"CZ"}}, // Slatiňany
    {Coordinate{17.8994, 49.0741}, CountryId{"CZ"}}, // Slavičín
    {Coordinate{16.8736, 49.145}, CountryId{"CZ"}}, // Slavkov u Brna
    {Coordinate{14.4617, 51.0064}, CountryId{"CZ"}}, // Šluknov railway station
    {Coordinate{17.065, 50.0175}, CountryId{"CZ"}}, // Sobotín (train station)
    {Coordinate{15.1678, 50.4653}, CountryId{"CZ"}}, // Sobotka
    {Coordinate{16.2539, 50.2036}, CountryId{"CZ"}}, // Solnice
    {Coordinate{17.4952, 49.1425}, CountryId{"CZ"}}, // Spytihněv
    {Coordinate{13.0716, 49.5475}, CountryId{"CZ"}}, // Staňkov
    {Coordinate{14.6922, 50.2097}, CountryId{"CZ"}}, // Stará Boleslav
    {Coordinate{16.9419, 50.1622}, CountryId{"CZ"}}, // Staré Město pod Sněžníkem
    {Coordinate{17.2859, 49.7205}, CountryId{"CZ"}}, // Q18180523
    {Coordinate{14.3939, 50.4564}, CountryId{"CZ"}}, // Štětí
    {Coordinate{16.7544, 49.9703}, CountryId{"CZ"}}, // Štíty
    {Coordinate{13.9653, 50.1411}, CountryId{"CZ"}}, // Stochov
    {Coordinate{13.155, 49.6394}, CountryId{"CZ"}}, // Q18180527
    {Coordinate{18.1322, 49.5829}, CountryId{"CZ"}}, // Štramberk
    {Coordinate{17.3185, 48.8975}, CountryId{"CZ"}}, // Strážnice
    {Coordinate{14.7458, 49.7619}, CountryId{"CZ"}}, // Struhařov
    {Coordinate{13.5417, 49.2467}, CountryId{"CZ"}}, // Sušice railway station
    {Coordinate{15.4172, 49.6703}, CountryId{"CZ"}}, // Světlá nad Sázavou
    {Coordinate{15.4017, 49.6692}, CountryId{"CZ"}}, // Světlá nad Sázavou město
    {Coordinate{16.4794, 49.7589}, CountryId{"CZ"}}, // Svitavy
    {Coordinate{16.4831, 49.7353}, CountryId{"CZ"}}, // Svitavy-Lány
    {Coordinate{15.8203, 50.6217}, CountryId{"CZ"}}, // Svoboda nad Úpou
    {Coordinate{12.6386, 49.8019}, CountryId{"CZ"}}, // Tachov (train station)
    {Coordinate{15.3108, 50.7433}, CountryId{"CZ"}}, // Tanvald
    {Coordinate{16.6081, 50.0686}, CountryId{"CZ"}}, // Q18180539
    {Coordinate{15.4645, 49.1825}, CountryId{"CZ"}}, // Telč
    {Coordinate{14.3464, 49.1956}, CountryId{"CZ"}}, // Temelín
    {Coordinate{12.86, 49.9756}, CountryId{"CZ"}}, // Teplá
    {Coordinate{16.1786, 50.5814}, CountryId{"CZ"}}, // Teplice nad Metují
    {Coordinate{13.8136, 50.6336}, CountryId{"CZ"}}, // Teplice zámecká zahrada
    {Coordinate{16.4184, 49.3469}, CountryId{"CZ"}}, // Tišnov
    {Coordinate{17.5012, 49.254}, CountryId{"CZ"}}, // Tlumačov
    {Coordinate{13.3092, 49.4292}, CountryId{"CZ"}}, // Q18180548
    {Coordinate{15.9822, 50.2}, CountryId{"CZ"}}, // Třebechovice pod Orebem
    {Coordinate{13.5803, 50.5236}, CountryId{"CZ"}}, // Q18180551
    {Coordinate{13.3944, 49.8189}, CountryId{"CZ"}}, // Třemošná u Plzně (train station)
    {Coordinate{15.5764, 49.8719}, CountryId{"CZ"}}, // Třemošnice
    {Coordinate{15.4766, 49.2984}, CountryId{"CZ"}}, // Třešť
    {Coordinate{15.482, 49.2874}, CountryId{"CZ"}}, // Třešť město
    {Coordinate{13.9869, 50.6472}, CountryId{"CZ"}}, // Q18180558
    {Coordinate{16.5256, 49.1634}, CountryId{"CZ"}}, // Troubsko
    {Coordinate{15.9451, 50.5777}, CountryId{"CZ"}}, // Trutnov střed
    {Coordinate{15.9608, 50.5779}, CountryId{"CZ"}}, // Trutnov zastávka
    {Coordinate{15.8817, 50.5908}, CountryId{"CZ"}}, // Q18180563
    {Coordinate{15.8881, 50.5806}, CountryId{"CZ"}}, // Trutnov-Zelená Louka
    {Coordinate{14.7706, 50.077}, CountryId{"CZ"}}, // Tuklaty
    {Coordinate{14.4082, 49.2233}, CountryId{"CZ"}}, // Q18180566
    {Coordinate{14.5929, 49.8342}, CountryId{"CZ"}}, // Týnec nad Sázavou
    {Coordinate{16.0739, 50.1547}, CountryId{"CZ"}}, // Týniště nad Orlicí (train station)
    {Coordinate{17.4574, 49.0667}, CountryId{"CZ"}}, // Uherské Hradiště
    {Coordinate{17.6435, 49.0218}, CountryId{"CZ"}}, // Uherský Brod (train station)
    {Coordinate{17.4035, 48.982}, CountryId{"CZ"}}, // Uherský Ostroh
    {Coordinate{15.0597, 49.8822}, CountryId{"CZ"}}, // Uhlířské Janovice
    {Coordinate{16.7457, 49.1073}, CountryId{"CZ"}}, // Újezd u Brna
    {Coordinate{17.1156, 49.7792}, CountryId{"CZ"}}, // Uničov
    {Coordinate{14.0806, 50.6642}, CountryId{"CZ"}}, // Ústí nad Labem sever
    {Coordinate{14.7263, 50.0745}, CountryId{"CZ"}}, // Úvaly
    {Coordinate{18.0228, 49.1423}, CountryId{"CZ"}}, // Valašské Klobouky
    {Coordinate{13.3381, 49.7131}, CountryId{"CZ"}}, // Plzeň-Valcha
    {Coordinate{16.7428, 48.7475}, CountryId{"CZ"}}, // Valtice
    {Coordinate{16.2828, 50.1178}, CountryId{"CZ"}}, // Vamberk
    {Coordinate{14.6386, 50.9031}, CountryId{"CZ"}}, // Varnsdorf railway station
    {Coordinate{13.2844, 49.7297}, CountryId{"CZ"}}, // Q18180584
    {Coordinate{14.1461, 50.6642}, CountryId{"CZ"}}, // Velké Březno
    {Coordinate{17.0439, 50.0333}, CountryId{"CZ"}}, // Velké Losiny (train station)
    {Coordinate{17.0589, 50.0417}, CountryId{"CZ"}}, // Q18180587
    {Coordinate{16.0219, 49.3457}, CountryId{"CZ"}}, // Velké Meziříčí
    {Coordinate{16.6908, 49.6113}, CountryId{"CZ"}}, // Velké Opatovice
    {Coordinate{16.8237, 48.8899}, CountryId{"CZ"}}, // Q18180590
    {Coordinate{14.2431, 50.2819}, CountryId{"CZ"}}, // Velvary
    {Coordinate{16.5575, 50.0114}, CountryId{"CZ"}}, // Q18180592
    {Coordinate{13.7906, 49.0553}, CountryId{"CZ"}}, // Q18180593
    {Coordinate{17.8432, 49.2201}, CountryId{"CZ"}}, // Vizovice
    {Coordinate{15.1717, 49.7286}, CountryId{"CZ"}}, // Vlastějovice (train station)
    {Coordinate{14.1801, 49.1451}, CountryId{"CZ"}}, // Q18180597
    {Coordinate{13.8831, 48.9069}, CountryId{"CZ"}}, // Volary
    {Coordinate{13.8928, 49.17}, CountryId{"CZ"}}, // Volyně (train station)
    {Coordinate{17.2195, 48.9766}, CountryId{"CZ"}}, // Vracov
    {Coordinate{15.0933, 50.74}, CountryId{"CZ"}}, // Q18180601
    {Coordinate{15.6228, 50.6188}, CountryId{"CZ"}}, // Vrchlabí (train station)
    {Coordinate{14.1072, 49.8675}, CountryId{"CZ"}}, // Všeradice
    {Coordinate{16.1471, 49.9554}, CountryId{"CZ"}}, // Vysoké Mýto
    {Coordinate{15.9117, 50.6653}, CountryId{"CZ"}}, // Žacléř
    {Coordinate{13.3264, 49.7472}, CountryId{"CZ"}}, // Q18180607
    {Coordinate{16.782, 48.8894}, CountryId{"CZ"}}, // Zaječí
    {Coordinate{16.4502, 50.0739}, CountryId{"CZ"}}, // Žamberk
    {Coordinate{15.0319, 49.9625}, CountryId{"CZ"}}, // Zásmuky
    {Coordinate{13.555, 50.3364}, CountryId{"CZ"}}, // Žatec
    {Coordinate{13.5347, 50.3381}, CountryId{"CZ"}}, // Žatec západ (train station)
    {Coordinate{15.8045, 49.7001}, CountryId{"CZ"}}, // Ždírec nad Doubravou
    {Coordinate{15.265, 50.6397}, CountryId{"CZ"}}, // Železný Brod
    {Coordinate{18.1308, 49.5647}, CountryId{"CZ"}}, // Ženklava
    {Coordinate{13.6175, 49.2675}, CountryId{"CZ"}}, // Žichovice railway station
    {Coordinate{17.6236, 49.2165}, CountryId{"CZ"}}, // Zlín-Louky
    {Coordinate{17.614, 49.2125}, CountryId{"CZ"}}, // Q18180620
    {Coordinate{17.5994, 49.2098}, CountryId{"CZ"}}, // Zlín-Malenovice (train station)
    {Coordinate{17.6407, 49.22}, CountryId{"CZ"}}, // Zlín-Prštné
    {Coordinate{17.5847, 49.2076}, CountryId{"CZ"}}, // Zlín-U mlýna (train station)
    {Coordinate{13.1592, 50.0844}, CountryId{"CZ"}}, // Žlutice
    {Coordinate{16.0593, 48.8528}, CountryId{"CZ"}}, // Znojmo
    {Coordinate{16.0442, 48.82}, CountryId{"CZ"}}, // Znojmo-Nový Šaldorf
    {Coordinate{15.1039, 49.7383}, CountryId{"CZ"}}, // Zruč nad Sázavou
    {Coordinate{15.0853, 49.7428}, CountryId{"CZ"}}, // Q18180628
    {Coordinate{4.58754, 48.7179}, CountryId{"FR"}}, // Gare de Vitry-le-François
    {Coordinate{79.6049, 17.9725}, CountryId{"IN"}}, // Warangal railway station
    {Coordinate{3.57556, 51.0644}, CountryId{"BE"}}, // Landegem railway station
    {Coordinate{20.9933, 52.1094}, CountryId{"PL"}}, // Warszawa Jeziorki railway station
    {Coordinate{-4.5864, 55.9247}, CountryId{"GB"}}, // Langbank railway station
    {Coordinate{-5.83959, 56.9129}, CountryId{"GB"}}, // Arisaig railway station
    {Coordinate{0.0013, 51.4064}, CountryId{"GB"}}, // Shortlands railway station
    {Coordinate{14.7275, 49.8969}, CountryId{"CZ"}}, // Senohraby
    {Coordinate{-3.2642, 55.919}, CountryId{"GB"}}, // Kingsknowe railway station
    {Coordinate{3.49635, 50.5472}, CountryId{"BE"}}, // Maubray railway station
    {Coordinate{-0.136389, 50.8367}, CountryId{"GB"}}, // London Road railway station
    {Coordinate{13.7703, 50.1447}, CountryId{"CZ"}}, // Lužná u Rakovníka
    {Coordinate{16.6494, 49.2181}, CountryId{"CZ"}}, // Brno-Maloměřice
    {Coordinate{15.9109, 49.9013}, CountryId{"CZ"}}, // Chrast u Chrudimi
    {Coordinate{-2.57, 53.591}, CountryId{"GB"}}, // Blackrod railway station
    {Coordinate{6.66447, 49.0517}, CountryId{"FR"}}, // Q1820464
    {Coordinate{14.3222, 50.0456}, CountryId{"CZ"}}, // Luka
    {Coordinate{4.28306, 51.0772}, CountryId{"BE"}}, // Puurs railway station
    {Coordinate{-83.1914, 42.5428}, CountryId{"US"}}, // Troy Transit Center
    {Coordinate{74.3884, 34.2208}, CountryId{"IN"}}, // Baramulla railway station
    {Coordinate{2.27333, 48.7347}, CountryId{"FR"}}, // Gare de Massy-Verrières
    {Coordinate{1.79384, 46.8503}, CountryId{"FR"}}, // Gare de Montierchaume
    {Coordinate{-3.5952, 51.5474}, CountryId{"GB"}}, // Tondu railway station
    {Coordinate{2.4275, 44.2703}, CountryId{"FR"}}, // Gare de Baraqueville
    {Coordinate{2.64855, 50.5329}, CountryId{"FR"}}, // Q18214129
    {Coordinate{0.664084, 44.1739}, CountryId{"FR"}}, // Q18214174
    {Coordinate{5.58186, 45.322}, CountryId{"FR"}}, // Gare de Moirans
    {Coordinate{7.3806, 48.9201}, CountryId{"FR"}}, // Wingen-sur-Moder
    {Coordinate{3.41078, 44.4996}, CountryId{"FR"}}, // Gare de Barjac
    {Coordinate{5.38274, 43.5028}, CountryId{"FR"}}, // Gare des Milles
    {Coordinate{2.25083, 48.5181}, CountryId{"FR"}}, // Lardy (Paris RER)
    {Coordinate{-2.5153, 53.5394}, CountryId{"GB"}}, // Daisy Hill railway station
    {Coordinate{1.94028, 42.4572}, CountryId{"FR"}}, // Gare de Ur-Les Escaldes
    {Coordinate{-5.79235, 43.3795}, CountryId{"ES"}}, // Colloto railway station
    {Coordinate{-5.70225, 43.3823}, CountryId{"ES"}}, // Train station of El Berrón
    {Coordinate{-5.72972, 43.3818}, CountryId{"ES"}}, // Q18223245
    {Coordinate{11.8033, 43.48}, CountryId{"IT"}}, // Indicatore railway station
    {Coordinate{-5.74859, 43.381}, CountryId{"ES"}}, // Meres railway station
    {Coordinate{-5.80879, 43.3865}, CountryId{"ES"}}, // Q18224563
    {Coordinate{14.3801, 41.0362}, CountryId{"IT"}}, // Maddaloni Inferiore railway station
    {Coordinate{14.0771, 41.232}, CountryId{"IT"}}, // Q18224699
    {Coordinate{-5.6648, 43.3882}, CountryId{"ES"}}, // Q18224711
    {Coordinate{0.413, 52.43}, CountryId{"GB"}}, // Shippea Hill railway station
    {Coordinate{9.28645, 55.4281}, CountryId{"DK"}}, // Vamdrup Station
    {Coordinate{4.36167, 50.7942}, CountryId{"BE"}}, // Saint-Job railway station
    {Coordinate{6.44595, 49.679}, CountryId{"LU"}}, // Q1823264
    {Coordinate{-1.2032, 52.5708}, CountryId{"GB"}}, // Narborough railway station
    {Coordinate{-0.3564, 51.6024}, CountryId{"GB"}}, // Headstone Lane railway station
    {Coordinate{-0.803569, 52.0653}, CountryId{"GB"}}, // Wolverton railway station
    {Coordinate{5.86417, 50.5908}, CountryId{"BE"}}, // Verviers-Palais railway station
    {Coordinate{14.3953, 50.1125}, CountryId{"CZ"}}, // Praha-Podbaba railway station
    {Coordinate{5.13455, 48.1095}, CountryId{"FR"}}, // Gare de Chaumont
    {Coordinate{-3.2998, 55.9366}, CountryId{"GB"}}, // South Gyle railway station
    {Coordinate{12.5836, 56.0094}, CountryId{"DK"}}, // Snekkersten Station
    {Coordinate{-122.687, 45.6287}, CountryId{"US"}}, // Vancouver station
    {Coordinate{0.708, 51.234}, CountryId{"GB"}}, // Lenham railway station
    {Coordinate{1.79736, 47.3693}, CountryId{"FR"}}, // Gare de Villeherviers
    {Coordinate{12.4731, 55.7961}, CountryId{"DK"}}, // Virum station
    {Coordinate{1.58147, 49.0387}, CountryId{"FR"}}, // Bonnières
    {Coordinate{-1.38983, 47.9132}, CountryId{"FR"}}, // Gare de Retiers
    {Coordinate{3.00652, 49.577}, CountryId{"FR"}}, // Gare de Noyon
    {Coordinate{-0.577, 53.7267}, CountryId{"GB"}}, // Brough railway station
    {Coordinate{14.3303, 49.9461}, CountryId{"CZ"}}, // Černošice-Mokropsy
    {Coordinate{1.13979, 48.4786}, CountryId{"FR"}}, // Gare de Pontgouin
    {Coordinate{11.4525, 47.1272}, CountryId{"AT"}}, // Matrei railway station
    {Coordinate{11.4852, 47.0411}, CountryId{"AT"}}, // Gries am Brenner railway station
    {Coordinate{12.39, 46.743}, CountryId{"AT"}}, // Weitlanbrunn railway station
    {Coordinate{-1.19556, 52.9997}, CountryId{"GB"}}, // Bulwell station
    {Coordinate{3.44861, 50.0911}, CountryId{"FR"}}, // Gare de Bertry
    {Coordinate{12.3686, 50.1658}, CountryId{"CZ"}}, // Skalná (train station)
    {Coordinate{7.55583, 50.1558}, CountryId{"DE"}}, // Bahnhof Emmelshausen
    {Coordinate{8.43143, 50.0173}, CountryId{"DE"}}, // Flörsheim (Main) station
    {Coordinate{8.59517, 50.0566}, CountryId{"DE"}}, // Frankfurt am Main Gateway Gardens station
    {Coordinate{12.3715, 50.7436}, CountryId{"DE"}}, // Werdau-Nord
    {Coordinate{8.67651, 39.2885}, CountryId{"IT"}}, // Musei railway station
    {Coordinate{12.0852, 45.1479}, CountryId{"IT"}}, // Cavarzere railway station
    {Coordinate{12.0915, 45.1361}, CountryId{"IT"}}, // Cavarzere Centro railway halt
    {Coordinate{12.5417, 55.7064}, CountryId{"DK"}}, // Bispebjerg station
    {Coordinate{3.40972, 50.1114}, CountryId{"FR"}}, // Gare de Caudry
    {Coordinate{-2.394, 53.15}, CountryId{"GB"}}, // Sandbach railway station
    {Coordinate{0.387395, 43.1142}, CountryId{"FR"}}, // Gare de Lannemezan
    {Coordinate{-4.8158, 55.9619}, CountryId{"GB"}}, // Gourock railway station
    {Coordinate{5.83944, 51.995}, CountryId{"NL"}}, // Oosterbeek railway station
    {Coordinate{1.25139, 43.3558}, CountryId{"FR"}}, // Gare de Longages-Noé
    {Coordinate{-0.565277, 51.2408}, CountryId{"GB"}}, // London Road (Guildford) railway station
    {Coordinate{-4.792, 51.66}, CountryId{"GB"}}, // Manorbier railway station
    {Coordinate{7.31256, 47.9603}, CountryId{"FR"}}, // Gare de Rouffach
    {Coordinate{2.17214, 50.4248}, CountryId{"FR"}}, // Gare de Blangy-sur-Ternoise
    {Coordinate{14.3497, 53.2708}, CountryId{"DE"}}, // Tantow railway station
    {Coordinate{19.6289, 48.8016}, CountryId{"SK"}}, // Brezno railway station
    {Coordinate{-4.83039, 50.4186}, CountryId{"GB"}}, // Roche railway station
    {Coordinate{22.1148, 65.612}, CountryId{"SE"}}, // Notviken station
    {Coordinate{26.2974, 41.706}, CountryId{"GR"}}, // Dikaia railway station
    {Coordinate{26.511, 41.3522}, CountryId{"GR"}}, // Didymoteicho railway station
    {Coordinate{38.374, 49.0027}, CountryId{"UA"}}, // Q18340062
    {Coordinate{21.4154, 40.7821}, CountryId{"GR"}}, // Florina railway station
    {Coordinate{10.3297, 51.3889}, CountryId{"DE"}}, // Leinefelde station
    {Coordinate{7.585, 51.5569}, CountryId{"DE"}}, // Dortmund-Kurl station
    {Coordinate{-0.317, 51.685}, CountryId{"GB"}}, // Radlett railway station
    {Coordinate{75.158, 33.5886}, CountryId{"IN"}}, // Qazigund railway station
    {Coordinate{-0.18725, 52.9697}, CountryId{"GB"}}, // Swineshead railway station
    {Coordinate{-0.2523, 51.4722}, CountryId{"GB"}}, // Barnes Bridge railway station
    {Coordinate{5.40647, 43.2962}, CountryId{"FR"}}, // Marseille-Blancarde
    {Coordinate{15.8774, 50.331}, CountryId{"CZ"}}, // Semonice (train station)
    {Coordinate{76.5989, 9.03231}, CountryId{"IN"}}, // Sasthamkotta railway station
    {Coordinate{74.9919, 33.8879}, CountryId{"IN"}}, // Awantipora railway station
    {Coordinate{-3.0133, 51.6974}, CountryId{"GB"}}, // Pontypool and New Inn railway station
    {Coordinate{79.3178, 11.7022}, CountryId{"IN"}}, // Ulundurpet railway station
    {Coordinate{17.1079, 40.5828}, CountryId{"IT"}}, // Massafra railway station
    {Coordinate{75.0756, 33.7895}, CountryId{"IN"}}, // Bijbehara railway station
    {Coordinate{77.2876, 30.1168}, CountryId{"IN"}}, // Jagadhri railway station
    {Coordinate{79.7275, 11.2414}, CountryId{"IN"}}, // Sirkazhi railway station
    {Coordinate{-3.16438, 48.698}, CountryId{"FR"}}, // Halte de Pontrieux
    {Coordinate{5.05495, 47.3228}, CountryId{"FR"}}, // Dijon-Porte-Neuve railway station
    {Coordinate{1.03959, 49.5133}, CountryId{"FR"}}, // Malaunay-Le Houlme
    {Coordinate{108.037, 51.915}, CountryId{"RU"}}, // Onohoy station
    {Coordinate{76.7861, 11.3559}, CountryId{"IN"}}, // Wellington railway station
    {Coordinate{5.19345, 45.9019}, CountryId{"FR"}}, // Gare de Meximieux - Pérouges
    {Coordinate{77.5636, 28.5079}, CountryId{"IN"}}, // Boraki railway station
    {Coordinate{2.31518, 44.1004}, CountryId{"FR"}}, // Gare de Tanus
    {Coordinate{5.25685, 43.3402}, CountryId{"FR"}}, // Gare de Niolon
    {Coordinate{2.26444, 49.9097}, CountryId{"FR"}}, // Q18380201
    {Coordinate{-4.28514, 48.3922}, CountryId{"FR"}}, // Gare de Dirinon
    {Coordinate{77.1997, 28.6687}, CountryId{"IN"}}, // Subzi Mandi railway station
    {Coordinate{16.9845, 40.6067}, CountryId{"IT"}}, // Palagianello railway station
    {Coordinate{9.02239, 47.2179}, CountryId{"CH"}}, // Kaltbrunn railway station
    {Coordinate{74.5632, 34.1659}, CountryId{"IN"}}, // Pattan railway station
    {Coordinate{76.9698, 29.6946}, CountryId{"IN"}}, // Karnal railway station
    {Coordinate{2.77722, 49.3866}, CountryId{"FR"}}, // Gare de Jaux
    {Coordinate{-1.919, 53.312}, CountryId{"GB"}}, // Chapel-en-le-Frith railway station
    {Coordinate{-5.096, 56.8439}, CountryId{"GB"}}, // Banavie railway station
    {Coordinate{78.1777, 29.9811}, CountryId{"IN"}}, // Motichur railway station
    {Coordinate{0.3827, 52.6727}, CountryId{"GB"}}, // Watlington railway station
    {Coordinate{74.7362, 34.0387}, CountryId{"IN"}}, // Budgam railway station
    {Coordinate{75.8049, 22.6331}, CountryId{"IN"}}, // Rau railway station
    {Coordinate{79.5063, 13.6363}, CountryId{"IN"}}, // Renigunta Junction railway station
    {Coordinate{79.6513, 12.2294}, CountryId{"IN"}}, // Tindivanam railway station
    {Coordinate{76.3528, 9.9501}, CountryId{"IN"}}, // Tripunithura railway station
    {Coordinate{30.4206, 58.9042}, CountryId{"RU"}}, // Q18394946
    {Coordinate{30.3717, 59.2283}, CountryId{"RU"}}, // Q18395256
    {Coordinate{34.217, 46.8981}, CountryId{"UA"}}, // 90 km
    {Coordinate{77.9577, 9.59641}, CountryId{"IN"}}, // Virudhunagar Junction railway station
    {Coordinate{36.2443, 54.566}, CountryId{"RU"}}, // Azarovo
    {Coordinate{12.7551, 43.0569}, CountryId{"IT"}}, // Q18397591
    {Coordinate{12.7541, 43.0268}, CountryId{"IT"}}, // Q18397592
    {Coordinate{12.7377, 42.9839}, CountryId{"IT"}}, // Q18397595
    {Coordinate{15.3433, 49.9297}, CountryId{"CZ"}}, // Q18398040
    {Coordinate{15.1006, 50.6672}, CountryId{"CZ"}}, // Hodkovice nad Mohelkou
    {Coordinate{17.6728, 49.2292}, CountryId{"CZ"}}, // Zlín-Dlouhá (train station)
    {Coordinate{16.4672, 48.8203}, CountryId{"CZ"}}, // Q18398044
    {Coordinate{30.3536, 59.3828}, CountryId{"RU"}}, // Q18398515
    {Coordinate{60.5103, 56.8642}, CountryId{"RU"}}, // Q18398720
    {Coordinate{48.1905, 46.7157}, CountryId{"RU"}}, // Q18398773
    {Coordinate{48.3627, 46.691}, CountryId{"RU"}}, // Q18398795
    {Coordinate{28.7331, 59.5397}, CountryId{"RU"}}, // Q18398978
    {Coordinate{31.9246, 53.6079}, CountryId{"BY"}}, // Klimavichy
    {Coordinate{25.125, 52.5614}, CountryId{"BY"}}, // Rechytsa
    {Coordinate{24.1241, 52.2543}, CountryId{"BY"}}, // Yakawchytsy
    {Coordinate{29.1825, 60.2225}, CountryId{"RU"}}, // Yappilya platform
    {Coordinate{39.2989, 51.3515}, CountryId{"RU"}}, // Kolodeznaya
    {Coordinate{32.0594, 53.3781}, CountryId{"BY"}}, // Q18399428
    {Coordinate{29.0097, 59.7283}, CountryId{"RU"}}, // Q18399596
    {Coordinate{23.8514, 52.1429}, CountryId{"BY"}}, // Koshalyeva
    {Coordinate{23.9834, 52.1879}, CountryId{"BY"}}, // Tsukrovy Zavod
    {Coordinate{38.1653, 49.4086}, CountryId{"UA"}}, // Svatove Railway Station
    {Coordinate{38.2369, 49.0536}, CountryId{"UA"}}, // Q18400018
    {Coordinate{38.8501, 56.5077}, CountryId{"RU"}}, // Balakirevo train station
    {Coordinate{33.5288, 44.5952}, CountryId{"RU"}}, // Sevastopol
    {Coordinate{35.5711, 45.2431}, CountryId{"UA"}}, // Q18400357
    {Coordinate{44.4847, 56.7958}, CountryId{"RU"}}, // Semyonov station
    {Coordinate{28.9142, 59.6606}, CountryId{"RU"}}, // Q18400466
    {Coordinate{25.1867, 52.4666}, CountryId{"BY"}}, // Byelaazyorsk
    {Coordinate{37.3437, 55.7009}, CountryId{"RU"}}, // Skolkovo
    {Coordinate{38.529, 54.6791}, CountryId{"RU"}}, // Bogatishchevo
    {Coordinate{38.6997, 55.7744}, CountryId{"RU"}}, // Lenskaya
    {Coordinate{31.1914, 58.6389}, CountryId{"RU"}}, // Q18400965
    {Coordinate{39.9784, 63.6045}, CountryId{"RU"}}, // Bolshaya Kyama
    {Coordinate{28.7639, 59.4839}, CountryId{"RU"}}, // Q18401016
    {Coordinate{30.6744, 61.6953}, CountryId{"RU"}}, // Sortavala railway station
    {Coordinate{23.7317, 52.1117}, CountryId{"BY"}}, // Brest-East railway station
    {Coordinate{38.3083, 56.3918}, CountryId{"RU"}}, // Buzhaninovo
    {Coordinate{24.3316, 52.4107}, CountryId{"BY"}}, // Lyasy
    {Coordinate{60.5539, 56.8581}, CountryId{"RU"}}, // Q18401552
    {Coordinate{34.4255, 45.7946}, CountryId{"RU"}}, // Mamut
    {Coordinate{24.1693, 52.2817}, CountryId{"BY"}}, // Stawpy
    {Coordinate{24.0882, 52.2347}, CountryId{"BY"}}, // Matsyeyevichy
    {Coordinate{38.5871, 56.3789}, CountryId{"RU"}}, // Strunino
    {Coordinate{-4.8673, 55.7928}, CountryId{"GB"}}, // Largs railway station
    {Coordinate{24.9739, 52.5477}, CountryId{"BY"}}, // Q18404556
    {Coordinate{61.2835, 56.7352}, CountryId{"RU"}}, // Q18404581
    {Coordinate{25.1561, 52.5125}, CountryId{"BY"}}, // Vaytsyeshyn
    {Coordinate{48.5289, 55.8394}, CountryId{"RU"}}, // Q18404803
    {Coordinate{29.0553, 59.8044}, CountryId{"RU"}}, // Q18404908
    {Coordinate{29.5092, 60.2019}, CountryId{"RU"}}, // Molodyozhnoye platform
    {Coordinate{37.6244, 55.8033}, CountryId{"RU"}}, // Q18405077
    {Coordinate{23.8818, 52.1522}, CountryId{"BY"}}, // Kharytony
    {Coordinate{36.1581, 54.6191}, CountryId{"RU"}}, // Muratovka
    {Coordinate{40.0939, 47.4442}, CountryId{"RU"}}, // Q18405474
    {Coordinate{23.9394, 52.1708}, CountryId{"BY"}}, // Naharany
    {Coordinate{36.1383, 54.6115}, CountryId{"RU"}}, // Gorenskaya
    {Coordinate{38.5788, 55.2125}, CountryId{"RU"}}, // Nepetsino
    {Coordinate{-1.831, 52.546}, CountryId{"GB"}}, // Wylde Green railway station
    {Coordinate{24.5229, 52.4704}, CountryId{"BY"}}, // Aranchytsy
    {Coordinate{49.99, 58.5336}, CountryId{"RU"}}, // Q18406895
    {Coordinate{36.7214, 56.6281}, CountryId{"RU"}}, // Donkhovka
    {Coordinate{35.9078, 45.3297}, CountryId{"UA"}}, // Q18407043
    {Coordinate{24.6851, 52.5074}, CountryId{"BY"}}, // Pawlavichy
    {Coordinate{45.5153, 51.1924}, CountryId{"RU"}}, // Q18407403
    {Coordinate{60.6467, 56.8297}, CountryId{"RU"}}, // Shartash Railway Station
    {Coordinate{43.3935, 56.6448}, CountryId{"RU"}}, // Q18407889
    {Coordinate{45.0159, 53.1608}, CountryId{"RU"}}, // Q18408010
    {Coordinate{42.597, 53.4961}, CountryId{"RU"}}, // Q18408133
    {Coordinate{33.61, 44.5889}, CountryId{"UA"}}, // Q18408450
    {Coordinate{24.3924, 52.4299}, CountryId{"BY"}}, // Prylutchyna
    {Coordinate{24.7717, 52.5146}, CountryId{"BY"}}, // Kabaki
    {Coordinate{38.2161, 49.2269}, CountryId{"UA"}}, // Q18408698
    {Coordinate{38.3837, 54.7319}, CountryId{"RU"}}, // Purlovo
    {Coordinate{61.9228, 56.4273}, CountryId{"RU"}}, // Kamensk-Uralsky train station
    {Coordinate{44.5264, 52.7006}, CountryId{"RU"}}, // Q18409141
    {Coordinate{30.3617, 59.4919}, CountryId{"RU"}}, // Q18409162
    {Coordinate{35.3431, 54.1178}, CountryId{"RU"}}, // Sukhinichi-Uzlovye
    {Coordinate{38.1657, 55.1223}, CountryId{"RU"}}, // Malino
    {Coordinate{24.6123, 52.4982}, CountryId{"BY"}}, // Tkachy
    {Coordinate{37.8966, 55.1548}, CountryId{"RU"}}, // Usady-Okruzhnye
    {Coordinate{-4.2825, 55.8973}, CountryId{"GB"}}, // Gilshochill railway station
    {Coordinate{-0.7696, 53.399}, CountryId{"GB"}}, // Gainsborough Central railway station
    {Coordinate{5.34208, 45.9266}, CountryId{"FR"}}, // Gare de Vaux-en-Bugey
    {Coordinate{21.1872, 52.1858}, CountryId{"PL"}}, // Warszawa Radość railway station
    {Coordinate{7.80935, 48.8861}, CountryId{"FR"}}, // Walbourg
    {Coordinate{13.4574, 66.0708}, CountryId{"NO"}}, // Drevvatn Station
    {Coordinate{2.54806, 48.8406}, CountryId{"FR"}}, // Noisy-le-Grand – Mont d'Est
    {Coordinate{15.1914, 37.6889}, CountryId{"IT"}}, // Q18420506
    {Coordinate{15.7581, 40.7877}, CountryId{"IT"}}, // Castel Lagopesole railway station
    {Coordinate{15.7523, 40.8372}, CountryId{"IT"}}, // Filiano railway station
    {Coordinate{10.1117, 45.7128}, CountryId{"IT"}}, // Sale Marasino railway station
    {Coordinate{15.6054, 41.3716}, CountryId{"IT"}}, // Santuario Incoronata railway halt
    {Coordinate{8.94394, 45.8497}, CountryId{"CH"}}, // Stabio railway station
    {Coordinate{16.1242, 50.6153}, CountryId{"CZ"}}, // Adršpach
    {Coordinate{-0.0754, 51.5386}, CountryId{"GB"}}, // Haggerston railway station
    {Coordinate{20.9947, 52.2586}, CountryId{"PL"}}, // Warszawa Gdańska station
    {Coordinate{16.673, 49.2766}, CountryId{"CZ"}}, // Babice nad Svitavou
    {Coordinate{12.8683, 49.3992}, CountryId{"CZ"}}, // Q18423293
    {Coordinate{16.6398, 49.3605}, CountryId{"CZ"}}, // Blansko město
    {Coordinate{13.0453, 50.1547}, CountryId{"CZ"}}, // Q18423513
    {Coordinate{13.2992, 49.5267}, CountryId{"CZ"}}, // Q18423528
    {Coordinate{14.4322, 48.7019}, CountryId{"CZ"}}, // Q18423596
    {Coordinate{16.247, 49.5137}, CountryId{"CZ"}}, // Bystřice nad Pernštejnem
    {Coordinate{16.6737, 49.2427}, CountryId{"CZ"}}, // Bílovice nad Svitavou
    {Coordinate{16.5543, 48.8129}, CountryId{"CZ"}}, // Březí (train station)
    {Coordinate{15.0794, 50.0778}, CountryId{"CZ"}}, // Cerhenice
    {Coordinate{15.7492, 50.0631}, CountryId{"CZ"}}, // Pardubice-Semtín
    {Coordinate{15.7808, 49.9592}, CountryId{"CZ"}}, // Q18423806
    {Coordinate{13.6711, 50.1483}, CountryId{"CZ"}}, // Q18423815
    {Coordinate{16.038, 50.5994}, CountryId{"CZ"}}, // Chvaleč
    {Coordinate{16.5338, 48.82}, CountryId{"CZ"}}, // Dobré Pole
    {Coordinate{12.925, 49.4356}, CountryId{"CZ"}}, // Domažlice město
    {Coordinate{14.3348, 48.8279}, CountryId{"CZ"}}, // Q18424238
    {Coordinate{14.2306, 50.7933}, CountryId{"CZ"}}, // Děčín-Prostřední Žleb
    {Coordinate{14.2233, 50.775}, CountryId{"CZ"}}, // Děčín východ railway station
    {Coordinate{16.5161, 48.9766}, CountryId{"CZ"}}, // Pohořelice
    {Coordinate{16.2119, 50.5133}, CountryId{"CZ"}}, // Police nad Metují
    {Coordinate{15.473, 49.8217}, CountryId{"CZ"}}, // Golčův Jeníkov město (train station)
    {Coordinate{16.7486, 49.1547}, CountryId{"CZ"}}, // Ponětovice
    {Coordinate{15.5394, 49.6142}, CountryId{"CZ"}}, // Havlíčkův Brod-Perknov
    {Coordinate{17.7581, 49.7133}, CountryId{"CZ"}}, // Heřmánky
    {Coordinate{14.9222, 50.1111}, CountryId{"CZ"}}, // Poříčany
    {Coordinate{14.6514, 49.8417}, CountryId{"CZ"}}, // Q18425251
    {Coordinate{13.3589, 49.8381}, CountryId{"CZ"}}, // Q18425263
    {Coordinate{15.6336, 49.8939}, CountryId{"CZ"}}, // Prachovice (train station)
    {Coordinate{14.2242, 50.0714}, CountryId{"CZ"}}, // Hostivice-Litovice
    {Coordinate{14.346, 50.0622}, CountryId{"CZ"}}, // Praha-Stodůlky
    {Coordinate{15.7314, 50.175}, CountryId{"CZ"}}, // Praskačka
    {Coordinate{12.8686, 50.3067}, CountryId{"CZ"}}, // Hroznětín
    {Coordinate{15.6961, 50.5472}, CountryId{"CZ"}}, // Prosečné (train station)
    {Coordinate{17.1117, 49.479}, CountryId{"CZ"}}, // Q18425459
    {Coordinate{16.4021, 49.0945}, CountryId{"CZ"}}, // Q18425576
    {Coordinate{17.7887, 49.6968}, CountryId{"CZ"}}, // Q18425664
    {Coordinate{15.9111, 50.3569}, CountryId{"CZ"}}, // Jaroměř zastávka
    {Coordinate{13.4486, 50.4922}, CountryId{"CZ"}}, // Jirkov
    {Coordinate{14.0378, 50.14}, CountryId{"CZ"}}, // Kamenné Žehrovice
    {Coordinate{14.4489, 48.8911}, CountryId{"CZ"}}, // Kamenný Újezd u Českých Budějovic
    {Coordinate{12.8328, 50.2289}, CountryId{"CZ"}}, // Q18426089
    {Coordinate{13.9953, 50.1565}, CountryId{"CZ"}}, // Kačice
    {Coordinate{14.0867, 50.1472}, CountryId{"CZ"}}, // Kladno-Ostrovec
    {Coordinate{14.0669, 50.1317}, CountryId{"CZ"}}, // Kladno-Rozdělov (train station)
    {Coordinate{14.1536, 50.1661}, CountryId{"CZ"}}, // Q18426208
    {Coordinate{14.0844, 50.1414}, CountryId{"CZ"}}, // Kladno město
    {Coordinate{12.9747, 49.8847}, CountryId{"CZ"}}, // Q18426336
    {Coordinate{15.6489, 49.9283}, CountryId{"CZ"}}, // Q18426382
    {Coordinate{15.6511, 49.9206}, CountryId{"CZ"}}, // Q18426384
    {Coordinate{14.9617, 50.1858}, CountryId{"CZ"}}, // Kostomlaty nad Labem (train station)
    {Coordinate{-1.24499, 49.3023}, CountryId{"FR"}}, // Gare de Carentan
    {Coordinate{14.9836, 50.0994}, CountryId{"CZ"}}, // Tatce
    {Coordinate{16.1722, 50.5928}, CountryId{"CZ"}}, // Teplice nad Metují město
    {Coordinate{16.1494, 50.5967}, CountryId{"CZ"}}, // Teplice nad Metují skály
    {Coordinate{16.7984, 49.1637}, CountryId{"CZ"}}, // Q18430251
    {Coordinate{16.409, 49.1722}, CountryId{"CZ"}}, // Tetčice
    {Coordinate{16.85, 48.9163}, CountryId{"CZ"}}, // Bořetice (train station)
    {Coordinate{13.2419, 49.7242}, CountryId{"CZ"}}, // Tlučná
    {Coordinate{12.9911, 50.0506}, CountryId{"CZ"}}, // Toužim
    {Coordinate{15.6567, 50.1594}, CountryId{"CZ"}}, // Q18430373
    {Coordinate{16.1201, 48.85}, CountryId{"CZ"}}, // Dyje
    {Coordinate{12.8394, 49.42}, CountryId{"CZ"}}, // Q18430408
    {Coordinate{15.8881, 50.5614}, CountryId{"CZ"}}, // Q18430427
    {Coordinate{14.4217, 48.6017}, CountryId{"CZ"}}, // Horní Dvořiště station
    {Coordinate{15.72, 50.5392}, CountryId{"CZ"}}, // Hostinné město
    {Coordinate{16.3826, 49.099}, CountryId{"CZ"}}, // Q18430588
    {Coordinate{14.4686, 48.775}, CountryId{"CZ"}}, // Q18430693
    {Coordinate{14.1358, 50.105}, CountryId{"CZ"}}, // Unhošť
    {Coordinate{16.7621, 48.7486}, CountryId{"CZ"}}, // Valtice město
    {Coordinate{13.0333, 50.5}, CountryId{"CZ"}}, // Vejprty station
    {Coordinate{14.4361, 48.8197}, CountryId{"CZ"}}, // Q18430775
    {Coordinate{14.4531, 48.8364}, CountryId{"CZ"}}, // Velešín město
    {Coordinate{15.1244, 50.0675}, CountryId{"CZ"}}, // Velim
    {Coordinate{16.0089, 49.3528}, CountryId{"CZ"}}, // Velké Meziříčí zastávka
    {Coordinate{16.8224, 48.9017}, CountryId{"CZ"}}, // Velké Pavlovice zastávka
    {Coordinate{14.38, 50.9931}, CountryId{"CZ"}}, // Velký Šenov railway station
    {Coordinate{17.3613, 48.9372}, CountryId{"CZ"}}, // Veselí nad Moravou-Zarazice
    {Coordinate{13.7636, 49.0486}, CountryId{"CZ"}}, // Q18430802
    {Coordinate{12.8144, 49.4864}, CountryId{"CZ"}}, // Q18430806
    {Coordinate{15.8342, 50.5464}, CountryId{"CZ"}}, // Q18430809
    {Coordinate{13.2997, 49.3492}, CountryId{"CZ"}}, // Vrhaveč station
    {Coordinate{16.1557, 49.9505}, CountryId{"CZ"}}, // Vysoké Mýto město
    {Coordinate{15.7642, 50.2525}, CountryId{"CZ"}}, // Všestary
    {Coordinate{16.5764, 49.536}, CountryId{"CZ"}}, // Letovice zastávka
    {Coordinate{15.6961, 50.1667}, CountryId{"CZ"}}, // Q18431479
    {Coordinate{15.1831, 50.1276}, CountryId{"CZ"}}, // Q18431491
    {Coordinate{16.2927, 49.8814}, CountryId{"CZ"}}, // Q18431629
    {Coordinate{17.0745, 49.7129}, CountryId{"CZ"}}, // Litovel
    {Coordinate{17.0713, 49.6941}, CountryId{"CZ"}}, // Litovel předměstí
    {Coordinate{13.1156, 49.3656}, CountryId{"CZ"}}, // Loučim
    {Coordinate{17.0911, 50.0889}, CountryId{"CZ"}}, // Loučná nad Desnou-Rejhotice
    {Coordinate{14.0811, 50.5103}, CountryId{"CZ"}}, // Q18431676
    {Coordinate{13.3272, 50.1261}, CountryId{"CZ"}}, // Lubenec
    {Coordinate{13.3144, 49.5483}, CountryId{"CZ"}}, // Q18431701
    {Coordinate{13.2156, 49.6803}, CountryId{"CZ"}}, // Q18431800
    {Coordinate{16.0506, 50.5294}, CountryId{"CZ"}}, // Malé Svatoňovice
    {Coordinate{17.5738, 49.2055}, CountryId{"CZ"}}, // Zlín-Malenovice zastávka
    {Coordinate{17.6911, 49.2259}, CountryId{"CZ"}}, // Zlín-Podvesná
    {Coordinate{17.7155, 49.2209}, CountryId{"CZ"}}, // Zlín-Příluky
    {Coordinate{14.7353, 50.1597}, CountryId{"CZ"}}, // Čelákovice zastávka
    {Coordinate{17.7094, 49.7881}, CountryId{"CZ"}}, // Q18432116
    {Coordinate{16.1847, 50.5522}, CountryId{"CZ"}}, // Česká Metuje
    {Coordinate{13.8289, 49.1111}, CountryId{"CZ"}}, // Čkyně
    {Coordinate{12.9844, 49.4667}, CountryId{"CZ"}}, // Milavče station
    {Coordinate{17.7442, 49.2196}, CountryId{"CZ"}}, // Želechovice nad Dřevnicí
    {Coordinate{16.2042, 50.5372}, CountryId{"CZ"}}, // Žďár nad Metují
    {Coordinate{16.429, 49.0852}, CountryId{"CZ"}}, // Moravské Bránice (train station)
    {Coordinate{13.8204, 50.6588}, CountryId{"CZ"}}, // Q18432742
    {Coordinate{16.4941, 48.8257}, CountryId{"CZ"}}, // Novosedly
    {Coordinate{12.78, 50.2736}, CountryId{"CZ"}}, // Nová Role
    {Coordinate{15.1506, 50.0547}, CountryId{"CZ"}}, // Nová Ves u Kolína
    {Coordinate{16.0602, 49.5648}, CountryId{"CZ"}}, // Q18432750
    {Coordinate{15.0333, 50.1844}, CountryId{"CZ"}}, // Nymburk město
    {Coordinate{17.8092, 49.685}, CountryId{"CZ"}}, // Q18432881
    {Coordinate{15.4869, 49.6306}, CountryId{"CZ"}}, // Okrouhlice
    {Coordinate{12.5581, 50.2547}, CountryId{"CZ"}}, // Q18432938
    {Coordinate{16.4467, 49.161}, CountryId{"CZ"}}, // Omice (train station)
    {Coordinate{14.4475, 48.725}, CountryId{"CZ"}}, // Q18432942
    {Coordinate{16.4858, 49.815}, CountryId{"CZ"}}, // Q18432944
    {Coordinate{17.5464, 49.2004}, CountryId{"CZ"}}, // Otrokovice-Trávníky
    {Coordinate{13.2989, 49.6006}, CountryId{"CZ"}}, // Q18433528
    {Coordinate{16.4616, 49.1343}, CountryId{"CZ"}}, // Radostice
    {Coordinate{16.06, 50.5753}, CountryId{"CZ"}}, // Radvanice
    {Coordinate{12.5353, 50.2872}, CountryId{"CZ"}}, // Q18433931
    {Coordinate{16.0732, 50.5156}, CountryId{"CZ"}}, // Rtyně v Podkrkonoší
    {Coordinate{16.4627, 49.1082}, CountryId{"CZ"}}, // Silůvky (train station)
    {Coordinate{15.9768, 38.713}, CountryId{"IT"}}, // Zambrone train station
    {Coordinate{14.1019, 50.2261}, CountryId{"CZ"}}, // Q18434317
    {Coordinate{12.7011, 49.7397}, CountryId{"CZ"}}, // Q18434544
    {Coordinate{16.4829, 49.1539}, CountryId{"CZ"}}, // Střelice
    {Coordinate{16.5062, 49.1566}, CountryId{"CZ"}}, // Střelice dolní (train station)
    {Coordinate{16.4869, 49.7928}, CountryId{"CZ"}}, // Svitavy-Lačnov (train station)
    {Coordinate{14.7777, 41.0517}, CountryId{"IT"}}, // Chianche-Ceppaloni railway station
    {Coordinate{14.5722, 41.2105}, CountryId{"IT"}}, // stazione di Solopaca
    {Coordinate{-0.709, 51.704}, CountryId{"GB"}}, // Great Missenden
    {Coordinate{0.803018, 44.38}, CountryId{"FR"}}, // Gare de Penne-d'Agenais
    {Coordinate{12.9758, 55.5627}, CountryId{"SE"}}, // Hyllie railway station
    {Coordinate{3.3435, 50.3102}, CountryId{"FR"}}, // Gare de Lourches
    {Coordinate{8.63891, 40.6814}, CountryId{"IT"}}, // Campomela railway station
    {Coordinate{24.7275, 59.4255}, CountryId{"EE"}}, // Lilleküla railway station
    {Coordinate{-4.3351, 55.9048}, CountryId{"GB"}}, // Westerton railway station
    {Coordinate{-2.1, 51.897}, CountryId{"GB"}}, // Cheltenham Spa railway station
    {Coordinate{-0.3204, 51.455}, CountryId{"GB"}}, // St Margarets railway station
    {Coordinate{5.10767, 50.2677}, CountryId{"BE"}}, // Leignon railway station
    {Coordinate{-2.9429, 53.7649}, CountryId{"GB"}}, // Moss Side railway station
    {Coordinate{-2.5253, 53.4124}, CountryId{"GB"}}, // Birchwood railway station
    {Coordinate{7.78227, 48.8135}, CountryId{"FR"}}, // Gare de Haguenau
    {Coordinate{0.1076, 51.3565}, CountryId{"GB"}}, // Chelsfield railway station
    {Coordinate{2.32126, 43.1305}, CountryId{"FR"}}, // Gare de Verzeille
    {Coordinate{-0.910766, 43.5245}, CountryId{"FR"}}, // Gare de Puyoô
    {Coordinate{2.13817, 48.8427}, CountryId{"FR"}}, // Gare de La Celle-Saint-Cloud
    {Coordinate{6.03222, 51.235}, CountryId{"NL"}}, // Swalmen railway station
    {Coordinate{-8.88834, 38.6064}, CountryId{"PT"}}, // Venda do Alcaide station
    {Coordinate{-8.45265, 40.6723}, CountryId{"PT"}}, // Sernada do Vouga railway station
    {Coordinate{-1.238, 51.826}, CountryId{"GB"}}, // Islip railway station
    {Coordinate{14.4514, 50.0925}, CountryId{"CZ"}}, // Křižíkova
    {Coordinate{4.86463, 51.0026}, CountryId{"BE"}}, // Langdorp railway station
    {Coordinate{6.16241, 47.2001}, CountryId{"FR"}}, // Mamirolle station
    {Coordinate{-9.20744, 38.7454}, CountryId{"PT"}}, // Q18483324
    {Coordinate{0.0463, 51.5526}, CountryId{"GB"}}, // Manor Park
    {Coordinate{-1.38926, 47.2929}, CountryId{"FR"}}, // Gare de Mauves-sur-Loire
    {Coordinate{-4.5306, 55.6368}, CountryId{"GB"}}, // Kilmaurs railway station
    {Coordinate{12.2598, 42.5919}, CountryId{"IT"}}, // Stazione di Alviano
    {Coordinate{2.5425, 48.5644}, CountryId{"FR"}}, // Saint-Fargeau railway station
    {Coordinate{73.1811, 22.3108}, CountryId{"IN"}}, // Vadodara junction railway station
    {Coordinate{8.22267, 44.9569}, CountryId{"IT"}}, // Stazione di Portacomaro
    {Coordinate{37.5881, 55.7942}, CountryId{"RU"}}, // Savyolovsky railway station
    {Coordinate{14.426, 41.0876}, CountryId{"IT"}}, // Q18510373
    {Coordinate{-0.745, 51.63}, CountryId{"GB"}}, // High Wycombe railway station
    {Coordinate{4.83977, 45.0723}, CountryId{"FR"}}, // Gare de Tain-l'Hermitage - Tournon
    {Coordinate{-4.4103, 50.4269}, CountryId{"GB"}}, // Menheniot railway station
    {Coordinate{72.8408, 21.2066}, CountryId{"IN"}}, // Surat railway station
    {Coordinate{-2.517, 52.7015}, CountryId{"GB"}}, // Wellington railway station
    {Coordinate{11.3745, 53.3863}, CountryId{"DE"}}, // Jasnitz railway station
    {Coordinate{-0.0754, 51.5318}, CountryId{"GB"}}, // Hoxton railway station
    {Coordinate{73.9258, 30.1471}, CountryId{"PK"}}, // Hindumalkote railway station
    {Coordinate{27.216, 59.3612}, CountryId{"EE"}}, // Kohtla railway station
    {Coordinate{27.0485, 59.3586}, CountryId{"EE"}}, // Püssi railway station
    {Coordinate{4.76879, 45.7347}, CountryId{"FR"}}, // Gare de Francheville
    {Coordinate{6.669, 51.4135}, CountryId{"DE"}}, // Trompet
    {Coordinate{26.9551, 59.3528}, CountryId{"EE"}}, // Kiviõli railway station
    {Coordinate{-2.9811, 53.4408}, CountryId{"GB"}}, // Kirkdale railway station
    {Coordinate{-5.6372, 57.3369}, CountryId{"GB"}}, // Duncraig railway station
    {Coordinate{13.2364, 49.3806}, CountryId{"CZ"}}, // Q18534518
    {Coordinate{-4.417, 52.888}, CountryId{"GB"}}, // Pwllheli railway station
    {Coordinate{4.59757, 50.7074}, CountryId{"BE"}}, // Bierges-Walibi railway station
    {Coordinate{-2.11278, 53.4744}, CountryId{"GB"}}, // Guide Bridge railway station
    {Coordinate{2.26726, 48.5916}, CountryId{"FR"}}, // Gare de La Norville - Saint-Germain-lès-Arpajon
    {Coordinate{13.8997, 49.8436}, CountryId{"CZ"}}, // Hořovice
    {Coordinate{14.3127, 45.8153}, CountryId{"SI"}}, // Rakek train station
    {Coordinate{4.21302, 50.3212}, CountryId{"BE"}}, // Fontaine-Valmont railway station
    {Coordinate{-4.10953, 52.8616}, CountryId{"GB"}}, // Harlech railway station
    {Coordinate{20.8789, 51.3603}, CountryId{"PL"}}, // Podbór
    {Coordinate{6.49261, 47.6831}, CountryId{"FR"}}, // Gare de Lure
    {Coordinate{-4.2249, 55.9038}, CountryId{"GB"}}, // Bishopbriggs railway station
    {Coordinate{1.10915, 46.0247}, CountryId{"FR"}}, // Gare de Vaulry
    {Coordinate{-1.84492, 53.8586}, CountryId{"GB"}}, // Crossflatts railway station
    {Coordinate{-3.725, 53.296}, CountryId{"GB"}}, // Colwyn Bay railway station
    {Coordinate{6.89348, 51.3415}, CountryId{"DE"}}, // Hösel station
    {Coordinate{-1.45, 53.805}, CountryId{"GB"}}, // Cross Gates railway station
    {Coordinate{0.519, 51.615}, CountryId{"GB"}}, // Wickford railway station
    {Coordinate{2.37167, 48.7478}, CountryId{"FR"}}, // Pont de Rungis – Aéroport d'Orly
    {Coordinate{2.82529, 49.4228}, CountryId{"FR"}}, // Gare de Compiègne
    {Coordinate{-0.2668, 51.5171}, CountryId{"GB"}}, // Acton Main Line railway station
    {Coordinate{2.3, 48.8625}, CountryId{"FR"}}, // Pont de l'Alma
    {Coordinate{15.4654, 38.0464}, CountryId{"IT"}}, // Scarlett Zanclea railway halt
    {Coordinate{15.4043, 37.9861}, CountryId{"IT"}}, // Nizza di Sicilia railway halt
    {Coordinate{15.4474, 49.1204}, CountryId{"CZ"}}, // Velký Pěčín
    {Coordinate{16.5726, 49.8925}, CountryId{"CZ"}}, // Rudoltice v Čechách
    {Coordinate{15.5611, 50.155}, CountryId{"CZ"}}, // Q18590819
    {Coordinate{16.4975, 49.8581}, CountryId{"CZ"}}, // Třebovice v Čechách
    {Coordinate{13.3439, 49.2847}, CountryId{"CZ"}}, // Nemilkov station
    {Coordinate{14.6106, 50.1161}, CountryId{"CZ"}}, // Praha-Horní Počernice
    {Coordinate{15.4622, 49.131}, CountryId{"CZ"}}, // Slaviboř (train station)
    {Coordinate{13.4853, 50.51}, CountryId{"CZ"}}, // Kyjice
    {Coordinate{16.5949, 49.0112}, CountryId{"CZ"}}, // Q18590894
    {Coordinate{13.8328, 50.1489}, CountryId{"CZ"}}, // Řevničov
    {Coordinate{15.0792, 49.4297}, CountryId{"CZ"}}, // Leskovice
    {Coordinate{14.4183, 50.3661}, CountryId{"CZ"}}, // Cítov
    {Coordinate{16.0719, 50.6047}, CountryId{"CZ"}}, // Hodkovice u Trutnova
    {Coordinate{17.7485, 49.53}, CountryId{"CZ"}}, // Teplice nad Bečvou
    {Coordinate{17.062, 48.8276}, CountryId{"CZ"}}, // Lužice
    {Coordinate{16.0847, 50.5869}, CountryId{"CZ"}}, // Janovice u Trutnova
    {Coordinate{17.1615, 49.3357}, CountryId{"CZ"}}, // Nezamyslice
    {Coordinate{-2.228, 54.011}, CountryId{"GB"}}, // Hellifield railway station
    {Coordinate{2.54222, 48.8231}, CountryId{"FR"}}, // Villiers-sur-Marne - Le Plessis-Trévise station
    {Coordinate{-2.24225, 53.4739}, CountryId{"GB"}}, // Manchester Oxford Road railway station
    {Coordinate{-2.24453, 53.4872}, CountryId{"GB"}}, // Manchester Victoria station
    {Coordinate{-4.7589, 43.4209}, CountryId{"ES"}}, // Llanes train station
    {Coordinate{21.1069, 52.2497}, CountryId{"PL"}}, // Warszawa Olszynka Grochowska
    {Coordinate{2.4357, 44.921}, CountryId{"FR"}}, // Gare d'Aurillac
    {Coordinate{-3.0719, 53.566}, CountryId{"GB"}}, // Freshfield railway station
    {Coordinate{11.2655, 47.4403}, CountryId{"DE"}}, // Mittenwald station
    {Coordinate{9.16317, 49.2304}, CountryId{"DE"}}, // Bad Wimpfen train station
    {Coordinate{6.49257, 47.0501}, CountryId{"FR"}}, // Gilley station
    {Coordinate{5.37218, 43.3232}, CountryId{"FR"}}, // Q18613203
    {Coordinate{11.7784, 45.2915}, CountryId{"IT"}}, // Q18613410
    {Coordinate{10.4208, 50.5742}, CountryId{"DE"}}, // Meiningen station
    {Coordinate{13.1981, 49.6569}, CountryId{"CZ"}}, // Chotěšov u Stoda
    {Coordinate{16.3702, 48.8487}, CountryId{"CZ"}}, // Pravice
    {Coordinate{14.2961, 50.4369}, CountryId{"CZ"}}, // Dobříň
    {Coordinate{17.1113, 49.3213}, CountryId{"CZ"}}, // Q18613953
    {Coordinate{13.7242, 50.525}, CountryId{"CZ"}}, // Q18613955
    {Coordinate{15.3748, 49.0343}, CountryId{"CZ"}}, // Dolní Bolíkov (train station)
    {Coordinate{12.6639, 49.8061}, CountryId{"CZ"}}, // Q18614025
    {Coordinate{14.8653, 49.4214}, CountryId{"CZ"}}, // Q18614027
    {Coordinate{13.1542, 50.3669}, CountryId{"CZ"}}, // Kotvina
    {Coordinate{13.175, 49.2772}, CountryId{"CZ"}}, // Dešenice
    {Coordinate{15.2439, 50.7402}, CountryId{"CZ"}}, // Smržovka
    {Coordinate{13.0161, 50.3075}, CountryId{"CZ"}}, // Vojkovice nad Ohří
    {Coordinate{14.7333, 49.8792}, CountryId{"CZ"}}, // Q18614115
    {Coordinate{2.63389, 48.8389}, CountryId{"FR"}}, // Lognes
    {Coordinate{2.44933, 49.2927}, CountryId{"FR"}}, // Gare de Laigneville
    {Coordinate{34.5697, 48.1833}, CountryId{"UA"}}, // Ryasna
    {Coordinate{-0.4099, 53.575}, CountryId{"GB"}}, // Barnetby railway station
    {Coordinate{8.24932, 50.4003}, CountryId{"DE"}}, // Aumenau station
    {Coordinate{9.10134, 49.2377}, CountryId{"DE"}}, // Bad Rappenau station
    {Coordinate{12.5307, 52.4118}, CountryId{"DE"}}, // Bahnhof Brandenburg-Altstadt
    {Coordinate{13.8822, 53.6597}, CountryId{"DE"}}, // Ferdinandshof railway station
    {Coordinate{10.4231, 51.9111}, CountryId{"DE"}}, // Goslar railway station
    {Coordinate{6.60694, 51.2228}, CountryId{"DE"}}, // Kaarster Bahnhof station
    {Coordinate{8.78175, 48.9837}, CountryId{"DE"}}, // Q18616528
    {Coordinate{16.2293, 46.9455}, CountryId{"AT"}}, // Bahnhof Mogersdorf
    {Coordinate{7.28874, 50.9329}, CountryId{"DE"}}, // Bahnhof Overath
    {Coordinate{21.7781, 57.3544}, CountryId{"LV"}}, // Elkšķene Station
    {Coordinate{4.4325, 51.2817}, CountryId{"BE"}}, // Kapellen railway station
    {Coordinate{-0.0075, 51.4141}, CountryId{"GB"}}, // Ravensbourne railway station
    {Coordinate{10.3142, 53.5297}, CountryId{"DE"}}, // Aumühle railway station
    {Coordinate{10.0964, 53.5158}, CountryId{"DE"}}, // Billwerder-Moorfleet station
    {Coordinate{83.4168, 26.7506}, CountryId{"IN"}}, // Gorakhpur Cantonment railway station
    {Coordinate{74.9136, 33.9531}, CountryId{"IN"}}, // Kakapora railway station
    {Coordinate{74.6388, 16.8199}, CountryId{"IN"}}, // Miraj Junction railway station
    {Coordinate{10.1317, 53.4978}, CountryId{"DE"}}, // Mittlerer Landweg station
    {Coordinate{76.6115, 8.99454}, CountryId{"IN"}}, // Munroturuttu railway station
    {Coordinate{10.1811, 53.4878}, CountryId{"DE"}}, // Nettelnburg station
    {Coordinate{76.5256, 9.13202}, CountryId{"IN"}}, // Ochira railway station
    {Coordinate{74.895, 33.9988}, CountryId{"IN"}}, // Pampore railway station
    {Coordinate{76.6203, 8.94792}, CountryId{"IN"}}, // Perinad railway station
    {Coordinate{85.4147, 25.0331}, CountryId{"IN"}}, // Rajgir railway station
    {Coordinate{17.9658, 40.3897}, CountryId{"IT"}}, // Salice-Veglie railway station
    {Coordinate{74.4512, 34.258}, CountryId{"IN"}}, // Sopore railway station
    {Coordinate{10.0658, 53.5311}, CountryId{"DE"}}, // Tiefstack station
    {Coordinate{22.5686, 51.2316}, CountryId{"PL"}}, // Lublin
    {Coordinate{-1.46222, 53.3778}, CountryId{"GB"}}, // Sheffield station
    {Coordinate{7.31428, 43.707}, CountryId{"FR"}}, // Villefranche-sur-Mer railway station
    {Coordinate{0.573483, 43.078}, CountryId{"FR"}}, // Gare de Montréjeau-Gourdan-Polignan
    {Coordinate{7.07957, 51.1638}, CountryId{"DE"}}, // Solingen Grünewald station
    {Coordinate{7.64659, 47.5337}, CountryId{"CH"}}, // Q18630045
    {Coordinate{12.3019, 55.6525}, CountryId{"DK"}}, // Taastrup station
    {Coordinate{1.066, 51.09}, CountryId{"GB"}}, // Sandling railway station
    {Coordinate{2.29074, 48.5651}, CountryId{"FR"}}, // Marolles-en-Hurepoix (Paris RER)
    {Coordinate{7.40799, 50.9868}, CountryId{"DE"}}, // Engelskirchen station
    {Coordinate{2.02757, 48.9704}, CountryId{"FR"}}, // Gare de Chanteloup-les-Vignes
    {Coordinate{28.8857, 60.3582}, CountryId{"RU"}}, // 106 km platform
    {Coordinate{29.3984, 60.1713}, CountryId{"RU"}}, // 70 km platform
    {Coordinate{29.359, 60.1793}, CountryId{"RU"}}, // 72 km platform
    {Coordinate{35.3939, 45.0819}, CountryId{"UA"}}, // Q18643874
    {Coordinate{3.34558, 44.474}, CountryId{"FR"}}, // Gare de Chanac
    {Coordinate{0.808, 51.3333}, CountryId{"GB"}}, // Teynham railway station
    {Coordinate{8.61004, 46.9992}, CountryId{"CH"}}, // Brunnen railway station
    {Coordinate{0.900523, 45.8814}, CountryId{"FR"}}, // Q1865229
    {Coordinate{0.611328, 51.3664}, CountryId{"GB"}}, // Rainham railway station
    {Coordinate{-1.338, 51.237}, CountryId{"GB"}}, // Whitchurch railway station
    {Coordinate{8.33194, 50.1136}, CountryId{"DE"}}, // Auringen-Medenbach
    {Coordinate{4.43472, 51.2914}, CountryId{"BE"}}, // Sint-Mariaburg railway station
    {Coordinate{-3.2794, 51.7466}, CountryId{"GB"}}, // Pontlottyn railway station
    {Coordinate{6.02552, 48.9855}, CountryId{"FR"}}, // Gare de Pagny-sur-Moselle
    {Coordinate{2.17532, 49.0705}, CountryId{"FR"}}, // Gare d'Auvers-sur-Oise
    {Coordinate{9.521, 47.1812}, CountryId{"LI"}}, // Forst Hilti railway station
    {Coordinate{27.175, 62.4522}, CountryId{"FI"}}, // Q18658791
    {Coordinate{}, CountryId{"FI"}}, // Hamina railway station
    {Coordinate{25.0726, 60.3399}, CountryId{"FI"}}, // Q18658843
    {Coordinate{27.22, 66.6967}, CountryId{"FI"}}, // Q18658855
    {Coordinate{26.675, 60.9383}, CountryId{"FI"}}, // Q18658867
    {Coordinate{26.7878, 61.1953}, CountryId{"FI"}}, // Q18659086
    {Coordinate{28.8849, 61.2477}, CountryId{"FI"}}, // Q18659345
    {Coordinate{22.6551, 63.4084}, CountryId{"FI"}}, // Q18659468
    {Coordinate{27.1179, 60.8999}, CountryId{"FI"}}, // Kaipiainen railway station
    {Coordinate{24.7128, 64.1433}, CountryId{"FI"}}, // Kangas railway station
    {Coordinate{29.114, 61.8614}, CountryId{"FI"}}, // Kerimäki railway station
    {Coordinate{24.9617, 64.3464}, CountryId{"FI"}}, // Kilpua railway station
    {Coordinate{29.2878, 63.5147}, CountryId{"FI"}}, // Q18660102
    {Coordinate{26.6019, 60.8472}, CountryId{"FI"}}, // Koria railway station
    {Coordinate{29.7533, 63.3617}, CountryId{"FI"}}, // Kylänlahti railway station
    {Coordinate{22.9359, 61.9804}, CountryId{"FI"}}, // Q18660483
    {Coordinate{28.26, 61.0668}, CountryId{"FI"}}, // Q18660512
    {Coordinate{29.9925, 63.1522}, CountryId{"FI"}}, // Q18660555
    {Coordinate{-1.6725, 48.1033}, CountryId{"FR"}}, // Rennes railway station
    {Coordinate{25.4948, 60.7997}, CountryId{"FI"}}, // Henna railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18660761
    {Coordinate{28.3371, 61.0867}, CountryId{"FI"}}, // Q18660892
    {Coordinate{21.513, 61.5904}, CountryId{"FI"}}, // Mäntyluoto railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18660944
    {Coordinate{}, CountryId{"FI"}}, // Q18660971
    {Coordinate{25.375, 60.3822}, CountryId{"FI"}}, // Olli points
    {Coordinate{22.5158, 60.4233}, CountryId{"FI"}}, // Piikkiö railway station
    {Coordinate{29.7416, 61.7904}, CountryId{"FI"}}, // Q18661412
    {Coordinate{27.9731, 60.9272}, CountryId{"FI"}}, // Pulsa railway station
    {Coordinate{29.3825, 61.7611}, CountryId{"FI"}}, // Punkaharju railway station
    {Coordinate{28.6875, 61.1785}, CountryId{"FI"}}, // Q18661641
    {Coordinate{}, CountryId{"FI"}}, // Q18661662
    {Coordinate{28.3181, 63.0631}, CountryId{"FI"}}, // Juankoski railway station
    {Coordinate{30.0486, 62.1428}, CountryId{"FI"}}, // Q18661666
    {Coordinate{21.4889, 61.1314}, CountryId{"FI"}}, // Rauma railway station
    {Coordinate{28.8028, 60.7322}, CountryId{"RU"}}, // Q18661669
    {Coordinate{24.1619, 65.7608}, CountryId{"FI"}}, // Q18661801
    {Coordinate{27.2856, 62.6758}, CountryId{"FI"}}, // Salminen railway station
    {Coordinate{26.9394, 60.4681}, CountryId{"FI"}}, // Kotka Port railway station
    {Coordinate{23.3128, 61.8361}, CountryId{"FI"}}, // Q18662004
    {Coordinate{23.4428, 59.9794}, CountryId{"FI"}}, // Tammisaari railway station
    {Coordinate{28.0961, 61.0178}, CountryId{"FI"}}, // Q18662288
    {Coordinate{26.9544, 60.5733}, CountryId{"FI"}}, // Q18662311
    {Coordinate{27.9973, 61.0094}, CountryId{"FI"}}, // Q18662535
    {Coordinate{25.8792, 62.2478}, CountryId{"FI"}}, // Vaajakoski railway station
    {Coordinate{23.2272, 61.9174}, CountryId{"FI"}}, // Q18662650
    {Coordinate{}, CountryId{"FI"}}, // Q18662782
    {Coordinate{}, CountryId{"FI"}}, // Q18662802
    {Coordinate{26.795, 61.0956}, CountryId{"FI"}}, // Q18662950
    {Coordinate{29.9925, 63.1522}, CountryId{"FI"}}, // Vuonislahti railway station
    {Coordinate{22.5328, 62.9181}, CountryId{"FI"}}, // Ylistaro railway station
    {Coordinate{22.7066, 61.2968}, CountryId{"FI"}}, // Q18663135
    {Coordinate{2.11661, 49.3472}, CountryId{"FR"}}, // Gare de Saint-Sulpice-Auteuil
    {Coordinate{16.2954, 48.0856}, CountryId{"AT"}}, // Mödling railway station
    {Coordinate{2.64037, 50.5212}, CountryId{"FR"}}, // Gare de Béthune
    {Coordinate{-2.7525, 47.6653}, CountryId{"FR"}}, // Gare de Vannes
    {Coordinate{-1.94139, 46.6964}, CountryId{"FR"}}, // Gare de Saint-Gilles-Croix-de-Vie
    {Coordinate{11.9975, 53.837}, CountryId{"DE"}}, // Bützow station
    {Coordinate{11.9863, 51.9934}, CountryId{"DE"}}, // Güterglück railway station
    {Coordinate{-0.0704, 51.594}, CountryId{"GB"}}, // Bruce Grove railway station
    {Coordinate{-2.856, 53.3606}, CountryId{"GB"}}, // Hunts Cross railway station
    {Coordinate{2.41917, 48.7253}, CountryId{"FR"}}, // gare d'Ablon
    {Coordinate{14.4911, 50.0728}, CountryId{"CZ"}}, // Strašnická
    {Coordinate{-1.467, 54.515}, CountryId{"GB"}}, // Dinsdale railway station
    {Coordinate{9.3927, 49.4214}, CountryId{"DE"}}, // Adelsheim Nord
    {Coordinate{9.027, 48.21}, CountryId{"DE"}}, // Albstadt-Ebingen
    {Coordinate{9.38237, 48.7204}, CountryId{"DE"}}, // Altbach
    {Coordinate{27.8089, 62.175}, CountryId{"FI"}}, // Q18681899
    {Coordinate{22.0886, 61.2095}, CountryId{"FI"}}, // Kiukainen railway station
    {Coordinate{25.2069, 66.1697}, CountryId{"FI"}}, // Koivu railway station
    {Coordinate{24.3756, 61.8077}, CountryId{"FI"}}, // Korkeakoski railway station
    {Coordinate{22.7489, 60.7028}, CountryId{"FI"}}, // Kyrö railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18682154
    {Coordinate{26.1961, 62.26}, CountryId{"FI"}}, // Lievestuore Railway Station
    {Coordinate{27.2628, 64.5347}, CountryId{"FI"}}, // Q18682185
    {Coordinate{28.6739, 62.9278}, CountryId{"FI"}}, // Luikonlahti railway station
    {Coordinate{27.7606, 60.9444}, CountryId{"FI"}}, // Luumäki railway station
    {Coordinate{8.84038, 47.7584}, CountryId{"DE"}}, // Singen (Hohentwiel) station
    {Coordinate{26.1855, 60.9164}, CountryId{"FI"}}, // Q18682240
    {Coordinate{}, CountryId{"FI"}}, // Q18682293
    {Coordinate{22.0011, 61.365}, CountryId{"FI"}}, // Q18682313
    {Coordinate{30.6003, 62.1747}, CountryId{"FI"}}, // Niirala railway station
    {Coordinate{24.3661, 61.05}, CountryId{"FI"}}, // Parola railway station
    {Coordinate{28.2775, 62.0139}, CountryId{"FI"}}, // Rantasalmi railway station
    {Coordinate{27.8975, 60.9778}, CountryId{"FI"}}, // Q18682507
    {Coordinate{26.4783, 62.3026}, CountryId{"FI"}}, // Hankasalmi Railway Station
    {Coordinate{29.085, 61.3008}, CountryId{"FI"}}, // Q18682514
    {Coordinate{23.6267, 61.0633}, CountryId{"FI"}}, // Q18682515
    {Coordinate{28.8001, 63.6864}, CountryId{"FI"}}, // Valtimo railway station
    {Coordinate{28.1867, 64.4886}, CountryId{"FI"}}, // Q18682528
    {Coordinate{24.3651, 61.7969}, CountryId{"FI"}}, // Juupajoki stop
    {Coordinate{25.0606, 65.6633}, CountryId{"FI"}}, // Simo railway station
    {Coordinate{29.3719, 61.425}, CountryId{"FI"}}, // Simpele railway station
    {Coordinate{30.1208, 62.3179}, CountryId{"FI"}}, // Säkäniemi railway point
    {Coordinate{27.5592, 60.9131}, CountryId{"FI"}}, // Taavetti railway station
    {Coordinate{25.2903, 64.7703}, CountryId{"FI"}}, // Tikkaperä railway station
    {Coordinate{25.0283, 64.6083}, CountryId{"FI"}}, // Tuomioja railway station
    {Coordinate{26.4139, 64.7589}, CountryId{"FI"}}, // Utajärvi railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18682850
    {Coordinate{}, CountryId{"FI"}}, // Q18682873
    {Coordinate{8.98453, 49.4654}, CountryId{"DE"}}, // Eberbach railway station
    {Coordinate{1.21219, 45.6213}, CountryId{"FR"}}, // Gare de La Meyze
    {Coordinate{4.25361, 51.9164}, CountryId{"NL"}}, // Maassluis Centrum metro station
    {Coordinate{12.9817, 52.9615}, CountryId{"DE"}}, // Lindow (Mark) railway station
    {Coordinate{12.9001, 53.0929}, CountryId{"DE"}}, // Rheinsberg (Mark) railway station
    {Coordinate{-1.155, 50.711}, CountryId{"GB"}}, // Smallbrook Junction railway station
    {Coordinate{0.830346, 44.8625}, CountryId{"FR"}}, // Gare de Trémolat
    {Coordinate{2.79944, 48.3783}, CountryId{"FR"}}, // Gare de Moret-Veneux-les-Sablons
    {Coordinate{1.98, 45.3544}, CountryId{"FR"}}, // Gare de Montaignac-Saint-Hippolyte
    {Coordinate{23.42, 62.6422}, CountryId{"FI"}}, // Niinimaa railway station
    {Coordinate{4.25776, 50.7507}, CountryId{"BE"}}, // Buizingen railway station
    {Coordinate{-3.698, 51.526}, CountryId{"GB"}}, // Pyle railway station
    {Coordinate{6.88229, 51.0372}, CountryId{"DE"}}, // Köln-Blumenberg station
    {Coordinate{2.43109, 50.4802}, CountryId{"FR"}}, // Gare de Pernes-Camblain
    {Coordinate{4.76405, 52.9326}, CountryId{"NL"}}, // Den Helder Zuid railway station
    {Coordinate{1.7076, 52.4696}, CountryId{"GB"}}, // Oulton Broad South railway station
    {Coordinate{1.27639, 49.5567}, CountryId{"FR"}}, // Gare de Longuerue-Vieux-Manoir
    {Coordinate{-2.5738, 50.8958}, CountryId{"GB"}}, // Yetminster railway station
    {Coordinate{0.330393, 49.5607}, CountryId{"FR"}}, // Gare d'Étainhus - Saint-Romain
    {Coordinate{-0.441667, 45.4389}, CountryId{"FR"}}, // Jonzac
    {Coordinate{25.7544, 64.9125}, CountryId{"FI"}}, // Pikkarala railway station
    {Coordinate{6.4825, 46.3692}, CountryId{"FR"}}, // Gare de Thonon-les-Bains
    {Coordinate{-0.256, 51.4039}, CountryId{"GB"}}, // New Malden railway station
    {Coordinate{14.5681, 50.0886}, CountryId{"CZ"}}, // Praha-Dolní Počernice
    {Coordinate{5.48294, 43.2863}, CountryId{"FR"}}, // Gare de la Barasse
    {Coordinate{23.5815, 49.9355}, CountryId{"UA"}}, // Q18712024
    {Coordinate{-0.0943, 51.6632}, CountryId{"GB"}}, // Gordon Hill railway station
    {Coordinate{14.1565, 49.9033}, CountryId{"CZ"}}, // Q18718630
    {Coordinate{6.77056, 43.4228}, CountryId{"FR"}}, // Gare de Saint-Raphaël-Valescure
    {Coordinate{-5.6634, 56.8814}, CountryId{"GB"}}, // Lochailort railway station
    {Coordinate{15.5281, 50.0364}, CountryId{"CZ"}}, // Q1872080
    {Coordinate{-1.4933, 50.9927}, CountryId{"GB"}}, // Romsey railway station
    {Coordinate{6.57556, 52.4414}, CountryId{"NL"}}, // Daarlerveen railway station
    {Coordinate{2.52018, 49.2979}, CountryId{"FR"}}, // Gare de Rieux - Angicourt
    {Coordinate{-1.37, 53.1}, CountryId{"GB"}}, // Alfreton railway station
    {Coordinate{-4.1599, 55.8536}, CountryId{"GB"}}, // Shettleston railway station
    {Coordinate{24.185, 65.8508}, CountryId{"FI"}}, // Tornio East railway station
    {Coordinate{-2.222, 52.195}, CountryId{"GB"}}, // Worcester Foregate Street railway station
    {Coordinate{4.70396, 44.3749}, CountryId{"FR"}}, // Gare de Pierrelatte
    {Coordinate{-1.1485, 51.8931}, CountryId{"GB"}}, // Bicester Village railway station
    {Coordinate{11.1527, 51.7853}, CountryId{"DE"}}, // Quedlinburg station
    {Coordinate{6.9916, 51.0316}, CountryId{"DE"}}, // Leverkusen Mitte station
    {Coordinate{12.3586, 50.1167}, CountryId{"CZ"}}, // Františkovy Lázně-Aquaforum station
    {Coordinate{3.07474, 45.9188}, CountryId{"FR"}}, // Gare de Châtel-Guyon
    {Coordinate{7.40128, 48.2763}, CountryId{"FR"}}, // Gare de Châtenois
    {Coordinate{7.34624, 48.2769}, CountryId{"FR"}}, // Q18745201
    {Coordinate{5.8668, 49.4991}, CountryId{"FR"}}, // Q18745245
    {Coordinate{14.9971, 37.4558}, CountryId{"IT"}}, // Q18747427
    {Coordinate{16.9494, 50.1431}, CountryId{"CZ"}}, // Q18747816
    {Coordinate{17.8358, 49.5342}, CountryId{"CZ"}}, // Milotice nad Bečvou
    {Coordinate{15.0625, 49.7494}, CountryId{"CZ"}}, // Chabeřice
    {Coordinate{16.634, 49.3869}, CountryId{"CZ"}}, // Q18747821
    {Coordinate{14.5844, 50.2822}, CountryId{"CZ"}}, // Všetaty
    {Coordinate{14.3247, 49.3928}, CountryId{"CZ"}}, // Q18747878
    {Coordinate{15.0486, 49.7519}, CountryId{"CZ"}}, // Čížov
    {Coordinate{14.6142, 50.2536}, CountryId{"CZ"}}, // Ovčáry
    {Coordinate{14.1875, 50.6875}, CountryId{"CZ"}}, // Povrly-Roztoky
    {Coordinate{16.2604, 49.8898}, CountryId{"CZ"}}, // Tržek
    {Coordinate{12.7686, 49.635}, CountryId{"CZ"}}, // Q18747884
    {Coordinate{9.87722, 53.4731}, CountryId{"DE"}}, // Neuwiedenthal station
    {Coordinate{7.29143, 43.7222}, CountryId{"FR"}}, // Gare de Nice-Pont-Michel
    {Coordinate{73.8119, 15.3961}, CountryId{"IN"}}, // Vasco da Gama railway station
    {Coordinate{2.4593, 50.7878}, CountryId{"FR"}}, // Cassel
    {Coordinate{10.0331, 53.6064}, CountryId{"DE"}}, // Rübenkamp station
    {Coordinate{2.3536, 48.9846}, CountryId{"FR"}}, // Gare de Groslay
    {Coordinate{3.43053, 46.2091}, CountryId{"FR"}}, // Gare de Saint-Germain-des-Fossés
    {Coordinate{12.1555, 50.243}, CountryId{"CZ"}}, // Q1875817
    {Coordinate{16.3677, 48.2606}, CountryId{"AT"}}, // Wien Nussdorf station
    {Coordinate{0.693611, 47.3897}, CountryId{"FR"}}, // Tours railway station
    {Coordinate{-0.3526, 51.38}, CountryId{"GB"}}, // Esher railway station
    {Coordinate{5.67278, 51.9222}, CountryId{"NL"}}, // Hemmen-Dodewaard railway station
    {Coordinate{1.80892, 48.983}, CountryId{"FR"}}, // Gare de Gargenville
    {Coordinate{0.1, 50.773}, CountryId{"GB"}}, // Seaford railway station
    {Coordinate{14.439, 50.091}, CountryId{"CZ"}}, // Florenc
    {Coordinate{6.89916, 45.9506}, CountryId{"FR"}}, // Les Tines railway station
    {Coordinate{57.8346, 55.0417}, CountryId{"RU"}}, // Q18776148
    {Coordinate{-2.023, 51.676}, CountryId{"GB"}}, // Kemble railway station
    {Coordinate{8.9409, 49.8331}, CountryId{"DE"}}, // Groß-Umstadt Wiebelsbach station
    {Coordinate{0.549316, 46.8186}, CountryId{"FR"}}, // Gare de Châtellerault
    {Coordinate{-2.079, 51.061}, CountryId{"GB"}}, // Tisbury railway station
    {Coordinate{5.93403, 49.5015}, CountryId{"LU"}}, // Belval-Lycée train station
    {Coordinate{9.08601, 40.9083}, CountryId{"IT"}}, // Aggius train station
    {Coordinate{8.46148, 45.3592}, CountryId{"IT"}}, // Borgo Vercelli railway halt
    {Coordinate{10.9681, 43.6054}, CountryId{"IT"}}, // Q18785594
    {Coordinate{15.5955, 41.0621}, CountryId{"IT"}}, // Leonessa railway station
    {Coordinate{10.6966, 44.9591}, CountryId{"IT"}}, // Luzzara railway station
    {Coordinate{11.8746, 44.767}, CountryId{"IT"}}, // Rovereto-San Vito-Medelana railway station
    {Coordinate{-4.225, 55.8484}, CountryId{"GB"}}, // Bridgeton railway station
    {Coordinate{-4.1137, 55.8445}, CountryId{"GB"}}, // Baillieston railway station
    {Coordinate{-2.9044, 53.543}, CountryId{"GB"}}, // Town Green railway station
    {Coordinate{7.27002, 48.5075}, CountryId{"FR"}}, // Wisches
    {Coordinate{6.01771, 49.225}, CountryId{"FR"}}, // Q1879204
    {Coordinate{8.83056, 54.3342}, CountryId{"DE"}}, // Katharinenheerd railway stop
    {Coordinate{2.11309, 42.5021}, CountryId{"FR"}}, // Gare de Mont-Louis - La Cabanasse
    {Coordinate{12.725, 49.9025}, CountryId{"CZ"}}, // Chodová Planá railway station
    {Coordinate{-3.0087, 56.3174}, CountryId{"GB"}}, // Cupar railway station
    {Coordinate{3.80171, 49.7773}, CountryId{"FR"}}, // Q1879696
    {Coordinate{6.30278, 45.353}, CountryId{"FR"}}, // Saint-Avre - La Chambre
    {Coordinate{-1.2703, 51.7534}, CountryId{"GB"}}, // Oxford railway station
    {Coordinate{-3.032, 53.185}, CountryId{"GB"}}, // Hawarden railway station
    {Coordinate{0.711, 51.551}, CountryId{"GB"}}, // Prittlewell railway station
    {Coordinate{14.4311, 50.0753}, CountryId{"CZ"}}, // I. P. Pavlova
    {Coordinate{4.60778, 52.3908}, CountryId{"NL"}}, // Overveen railway station
    {Coordinate{1.65722, 44.8183}, CountryId{"FR"}}, // Gare de Rocamadour-Padirac
    {Coordinate{37.8717, 48.1208}, CountryId{"UA"}}, // Yasynuvata
    {Coordinate{1.71532, 48.9836}, CountryId{"FR"}}, // Mantes-Station
    {Coordinate{6.22985, 50.7686}, CountryId{"DE"}}, // Q1881097
    {Coordinate{5.5242, 50.4027}, CountryId{"BE"}}, // Sy railway station
    {Coordinate{-3.067, 55.0007}, CountryId{"GB"}}, // Gretna Green railway station
    {Coordinate{14.1411, 50.6697}, CountryId{"CZ"}}, // Neštědice
    {Coordinate{15.3089, 49.6844}, CountryId{"CZ"}}, // Q18817191
    {Coordinate{14.6036, 50.3056}, CountryId{"CZ"}}, // Byšice
    {Coordinate{14.8575, 48.9647}, CountryId{"CZ"}}, // Q18817194
    {Coordinate{14.3245, 48.8931}, CountryId{"CZ"}}, // Holubov
    {Coordinate{14.5569, 50.2675}, CountryId{"CZ"}}, // Tišice
    {Coordinate{15.4617, 50.6322}, CountryId{"CZ"}}, // Q18817255
    {Coordinate{14.5725, 49.3336}, CountryId{"CZ"}}, // Třebelice
    {Coordinate{15.936, 50.2147}, CountryId{"CZ"}}, // Blešno
    {Coordinate{14.3572, 48.9172}, CountryId{"CZ"}}, // Vrábče (train station)
    {Coordinate{14.4983, 50.2356}, CountryId{"CZ"}}, // Kojetice u Prahy
    {Coordinate{15.2835, 49.6959}, CountryId{"CZ"}}, // Horní Ledeč
    {Coordinate{14.1569, 50.6706}, CountryId{"CZ"}}, // Povrly
    {Coordinate{13.9917, 49.8753}, CountryId{"CZ"}}, // Q18817280
    {Coordinate{15.3289, 50.1458}, CountryId{"CZ"}}, // Choťovice
    {Coordinate{14.5797, 49.3489}, CountryId{"CZ"}}, // Q18817282
    {Coordinate{14.5072, 50.215}, CountryId{"CZ"}}, // Zlonín
    {Coordinate{15.235, 49.7078}, CountryId{"CZ"}}, // Chřenovice-Podhradí
    {Coordinate{2.57806, 48.8425}, CountryId{"FR"}}, // Noisy - Champs Station
    {Coordinate{-1.97599, 52.5523}, CountryId{"GB"}}, // Tame Bridge Parkway railway station
    {Coordinate{2.22984, 48.8189}, CountryId{"FR"}}, // Gare de Bellevue
    {Coordinate{-1.2328, 53.7974}, CountryId{"GB"}}, // Sherburn-in-Elmet railway station
    {Coordinate{-1.5635, 53.535}, CountryId{"GB"}}, // Silkstone Common railway station
    {Coordinate{-1.03667, 52.9489}, CountryId{"GB"}}, // Radcliffe railway station
    {Coordinate{-0.646, 51.133}, CountryId{"GB"}}, // Witley railway station
    {Coordinate{-0.868, 51.181}, CountryId{"GB"}}, // Bentley railway station
    {Coordinate{0.466308, 51.4267}, CountryId{"GB"}}, // Higham railway station, Kent
    {Coordinate{-2.019, 54.966}, CountryId{"GB"}}, // Corbridge railway station
    {Coordinate{15.38, 37.9617}, CountryId{"IT"}}, // Furci railway halt
    {Coordinate{15.1695, 37.6618}, CountryId{"IT"}}, // Q18844700
    {Coordinate{15.3914, 37.9729}, CountryId{"IT"}}, // Roccalumera-Mandanici railway station
    {Coordinate{15.3677, 37.9463}, CountryId{"IT"}}, // Santa Teresa di Riva railway station
    {Coordinate{3.7936, 50.6612}, CountryId{"BE"}}, // Rebaix railway station
    {Coordinate{-0.893, 51.044}, CountryId{"GB"}}, // Liss railway station
    {Coordinate{-1.51083, 47.2067}, CountryId{"FR"}}, // Gare de Saint-Sébastien-Pas-Enchantés
    {Coordinate{-0.662222, 51.8583}, CountryId{"GB"}}, // Cheddington railway station
    {Coordinate{3.97351, 47.8596}, CountryId{"FR"}}, // Gare de Tonnerre
    {Coordinate{15.8175, 52.2419}, CountryId{"PL"}}, // Zbąszynek
    {Coordinate{0.578, 51.852}, CountryId{"GB"}}, // Cressing railway station
    {Coordinate{6.98788, 51.2508}, CountryId{"DE"}}, // Mettmann Stadtwald
    {Coordinate{5.92358, 46.8595}, CountryId{"FR"}}, // Andelot railway station
    {Coordinate{-2.109, 51.999}, CountryId{"GB"}}, // Ashchurch for Tewkesbury railway station
    {Coordinate{3.51694, 50.3633}, CountryId{"FR"}}, // Valenciennes railway station
    {Coordinate{-3.687, 52.082}, CountryId{"GB"}}, // Sugar Loaf railway station
    {Coordinate{-3.6258, 57.6097}, CountryId{"GB"}}, // Forres railway station
    {Coordinate{7.23919, 47.6273}, CountryId{"FR"}}, // Gare d'Altkirch
    {Coordinate{3.44608, 50.0397}, CountryId{"FR"}}, // Gare de Busigny
    {Coordinate{-2.4598, 53.4282}, CountryId{"GB"}}, // Glazebrook railway station
    {Coordinate{0.192021, 49.2871}, CountryId{"FR"}}, // Gare de Pont-l'Évêque
    {Coordinate{1.66695, 50.6609}, CountryId{"FR"}}, // Hesdigneul
    {Coordinate{7.42451, 48.5332}, CountryId{"FR"}}, // Gare de Gresswiller
    {Coordinate{2.18167, 48.6975}, CountryId{"FR"}}, // Orsay-Ville Station
    {Coordinate{-4.2894, 55.7942}, CountryId{"GB"}}, // Williamwood railway station
    {Coordinate{2.08939, 43.6241}, CountryId{"FR"}}, // Q1890161
    {Coordinate{-3.90535, 50.936}, CountryId{"GB"}}, // King's Nympton railway station
    {Coordinate{1.97052, 49.0997}, CountryId{"FR"}}, // Gare d'Us
    {Coordinate{7.07017, 46.0933}, CountryId{"CH"}}, // Martigny-Bourg railway station
    {Coordinate{7.73944, 50.7831}, CountryId{"DE"}}, // Q1891076
    {Coordinate{3.89257, 45.0428}, CountryId{"FR"}}, // Le Puy-en-Velay railway station
    {Coordinate{-2.372, 52.666}, CountryId{"GB"}}, // Shifnal railway station
    {Coordinate{-3.19321, 47.7822}, CountryId{"FR"}}, // Gare de Brandérion
    {Coordinate{6.73267, 43.432}, CountryId{"FR"}}, // Gare de Fréjus
    {Coordinate{6.07081, 50.7491}, CountryId{"DE"}}, // Aachen Süd railway station
    {Coordinate{57.214, 50.2808}, CountryId{"KZ"}}, // Aktobé railway station
    {Coordinate{2.32778, 48.7983}, CountryId{"FR"}}, // gare d'Arcueil - Cachan
    {Coordinate{1.00049, 47.1305}, CountryId{"FR"}}, // Gare de Loches
    {Coordinate{12.3185, 43.0947}, CountryId{"IT"}}, // Q18923658
    {Coordinate{12.3559, 43.1024}, CountryId{"IT"}}, // Perugia Capitini railway station
    {Coordinate{5.19434, 44.6945}, CountryId{"FR"}}, // Gare de Saillans
    {Coordinate{15.0578, 49.9136}, CountryId{"CZ"}}, // Hatě (train station)
    {Coordinate{15.9619, 49.8325}, CountryId{"CZ"}}, // Prosetín
    {Coordinate{15.0561, 49.8956}, CountryId{"CZ"}}, // Q18924229
    {Coordinate{16.9732, 49.1492}, CountryId{"CZ"}}, // Marefy
    {Coordinate{16.1358, 50.0648}, CountryId{"CZ"}}, // Čermná nad Orlicí (train station)
    {Coordinate{15.9374, 49.8548}, CountryId{"CZ"}}, // Q18924299
    {Coordinate{15.0483, 49.8656}, CountryId{"CZ"}}, // Q18924301
    {Coordinate{14.8872, 50.4478}, CountryId{"CZ"}}, // Mladá Boleslav-Debř
    {Coordinate{15.7709, 49.248}, CountryId{"CZ"}}, // Okříšky
    {Coordinate{14.5106, 49.2922}, CountryId{"CZ"}}, // Bežerovice
    {Coordinate{4.18049, 50.4782}, CountryId{"BE"}}, // La Louvière-Centre railway station
    {Coordinate{-4.251, 55.857}, CountryId{"GB"}}, // Argyle Street railway station
    {Coordinate{1.301, 51.377}, CountryId{"GB"}}, // Birchington-on-Sea railway station
    {Coordinate{4.97694, 52.2786}, CountryId{"NL"}}, // Abcoude railway station
    {Coordinate{-1.9136, 52.4897}, CountryId{"GB"}}, // Jewellery Quarter station
    {Coordinate{-1.915, 48.5317}, CountryId{"FR"}}, // Gare de Miniac
    {Coordinate{-4.1542, 55.9213}, CountryId{"GB"}}, // Lenzie railway station
    {Coordinate{3.98732, 50.911}, CountryId{"BE"}}, // Ede railway station
    {Coordinate{2.58139, 49.5625}, CountryId{"FR"}}, // Gare de Tricot
    {Coordinate{6.94111, 50.9686}, CountryId{"DE"}}, // Köln Geldernstraße Parkgürtel station
    {Coordinate{14.0833, 49.9669}, CountryId{"CZ"}}, // Beroun-Závodí railway station
    {Coordinate{2.09022, 41.3313}, CountryId{"ES"}}, // Prat de Llobregat
    {Coordinate{-1.5309, 53.588}, CountryId{"GB"}}, // Darton railway station
    {Coordinate{14.1731, 49.9317}, CountryId{"CZ"}}, // Karlštejn (train station)
    {Coordinate{-4.2578, 55.8901}, CountryId{"GB"}}, // Possilpark and Parkhouse railway station
    {Coordinate{-2.44972, 47.6833}, CountryId{"FR"}}, // Gare de Questembert
    {Coordinate{3.24916, 50.4772}, CountryId{"FR"}}, // Orchies
    {Coordinate{2.42278, 42.6181}, CountryId{"FR"}}, // Gare de Prades - Molitg-les-Bains
    {Coordinate{1.406, 51.3408}, CountryId{"GB"}}, // Ramsgate railway station
    {Coordinate{-4.7304, 56.0124}, CountryId{"GB"}}, // Helensburgh Upper railway station
    {Coordinate{6.47656, 50.6712}, CountryId{"DE"}}, // Abenden railway station
    {Coordinate{4.63194, 43.6847}, CountryId{"FR"}}, // Gare d'Arles
    {Coordinate{-0.0573, 51.4736}, CountryId{"GB"}}, // Queens Road Peckham railway station
    {Coordinate{-1.537, 50.761}, CountryId{"GB"}}, // Lymington Town railway station
    {Coordinate{-1.177, 54.584}, CountryId{"GB"}}, // South Bank railway station
    {Coordinate{0.448, 51.33}, CountryId{"GB"}}, // Snodland railway station
    {Coordinate{6.07917, 49.4725}, CountryId{"LU"}}, // Dudelange-Usines railway station
    {Coordinate{-4.11, 52.821}, CountryId{"GB"}}, // Llanbedr railway station
    {Coordinate{0.707778, 45.1874}, CountryId{"FR"}}, // Gare de Périgueux
    {Coordinate{12.4544, 55.7617}, CountryId{"DK"}}, // Bagsværd station
    {Coordinate{-2.587, 54.124}, CountryId{"GB"}}, // Wennington railway station
    {Coordinate{-4.6907, 56.7602}, CountryId{"GB"}}, // Corrour railway station
    {Coordinate{-1.55, 47.1842}, CountryId{"FR"}}, // Gare de Rezé-Pont-Rousseau
    {Coordinate{7.20966, 51.4725}, CountryId{"DE"}}, // Bochum-Ehrenfeld station
    {Coordinate{-2.4164, 51.002}, CountryId{"GB"}}, // Templecombe railway station
    {Coordinate{-3.566, 54.457}, CountryId{"GB"}}, // Nethertown railway station
    {Coordinate{2.09905, 47.2101}, CountryId{"FR"}}, // Gare de Vierzon-Forges
    {Coordinate{13.5381, 49.7492}, CountryId{"CZ"}}, // Q1901307
    {Coordinate{-4.8532, 55.7515}, CountryId{"GB"}}, // Fairlie railway station
    {Coordinate{-4.136, 53.222}, CountryId{"GB"}}, // Bangor railway station
    {Coordinate{-4.0044, 55.7651}, CountryId{"GB"}}, // Chatelherault railway station
    {Coordinate{1.64166, 45.1818}, CountryId{"FR"}}, // Gare d'Aubazine-Saint-Hilaire
    {Coordinate{-1.7257, 52.342}, CountryId{"GB"}}, // Lapworth railway station
    {Coordinate{6.02861, 49.4542}, CountryId{"LU"}}, // Rumelange - Ottange train station
    {Coordinate{8.88889, 40.8254}, CountryId{"IT"}}, // Perfugas train station
    {Coordinate{11.6753, 44.923}, CountryId{"IT"}}, // Canaro train station
    {Coordinate{11.7386, 44.961}, CountryId{"IT"}}, // Polesella train station
    {Coordinate{11.7492, 45.1322}, CountryId{"IT"}}, // Stanghella railway halt
    {Coordinate{131.969, 43.3997}, CountryId{"RU"}}, // Q19060782
    {Coordinate{17.1143, 49.133}, CountryId{"CZ"}}, // Nemotice
    {Coordinate{14.1553, 50.5322}, CountryId{"CZ"}}, // Q19061070
    {Coordinate{17.134, 49.1504}, CountryId{"CZ"}}, // Brankovice
    {Coordinate{15.9658, 49.2126}, CountryId{"CZ"}}, // Vladislav (train station)
    {Coordinate{15.0919, 49.1947}, CountryId{"CZ"}}, // Bednárec
    {Coordinate{14.5467, 50.2386}, CountryId{"CZ"}}, // Jiřice (train station)
    {Coordinate{14.4355, 51.0068}, CountryId{"CZ"}}, // Šluknov zastávka railway station
    {Coordinate{14.0442, 48.7519}, CountryId{"CZ"}}, // Q19061177
    {Coordinate{14.61, 50.2044}, CountryId{"CZ"}}, // Polerady nad Labem
    {Coordinate{17.8111, 49.0354}, CountryId{"CZ"}}, // Bojkovice město
    {Coordinate{14.9511, 49.1642}, CountryId{"CZ"}}, // Děbolín
    {Coordinate{12.2719, 50.0861}, CountryId{"CZ"}}, // Pomezí nad Ohří station
    {Coordinate{13.39, 50.1}, CountryId{"CZ"}}, // Blatno u Jesenice
    {Coordinate{14.8828, 49.1692}, CountryId{"CZ"}}, // Q19061224
    {Coordinate{14.6647, 50.1836}, CountryId{"CZ"}}, // Brandýs nad Labem-Zápská
    {Coordinate{17.778, 49.0213}, CountryId{"CZ"}}, // Záhorovice
    {Coordinate{14.6783, 50.18}, CountryId{"CZ"}}, // Brandýs nad Labem zastávka
    {Coordinate{15.9821, 49.2118}, CountryId{"CZ"}}, // Vladislav zastávka
    {Coordinate{-0.673809, 46.1997}, CountryId{"FR"}}, // Gare de Mauzé
    {Coordinate{5.49796, 50.6185}, CountryId{"BE"}}, // Jemeppe-sur-Meuse railway station
    {Coordinate{18.6775, 54.7012}, CountryId{"PL"}}, // Jastarnia railway station
    {Coordinate{-0.261, 51.385}, CountryId{"GB"}}, // Malden Manor railway station
    {Coordinate{-0.269, 51.334}, CountryId{"GB"}}, // Epsom railway station
    {Coordinate{-0.0527, 51.4671}, CountryId{"GB"}}, // Nunhead railway station
    {Coordinate{-3.88221, 48.5079}, CountryId{"FR"}}, // Gare de Pleyber-Christ
    {Coordinate{16.1361, 49.9958}, CountryId{"CZ"}}, // Q1907836
    {Coordinate{5.66222, 53.0397}, CountryId{"NL"}}, // Sneek Noord railway station
    {Coordinate{0.1307, 51.3459}, CountryId{"GB"}}, // Knockholt railway station
    {Coordinate{5.32146, 43.3635}, CountryId{"FR"}}, // L'Estaque
    {Coordinate{-0.188, 51.4255}, CountryId{"GB"}}, // Haydons Road railway station
    {Coordinate{12.459, 55.665}, CountryId{"DK"}}, // Rødovre station
    {Coordinate{-5.4286, 57.4228}, CountryId{"GB"}}, // Strathcarron railway station
    {Coordinate{3.27547, 50.1918}, CountryId{"FR"}}, // Gare d'Escaudoeuvres
    {Coordinate{-2.7502, 52.7115}, CountryId{"GB"}}, // Shrewsbury railway station
    {Coordinate{4.67194, 51.0947}, CountryId{"BE"}}, // Melkouwen railway station
    {Coordinate{3.20182, 51.2231}, CountryId{"BE"}}, // Brugge-Sint-Pieters railway station
    {Coordinate{12.3867, 55.6233}, CountryId{"DK"}}, // Vallensbæk station
    {Coordinate{7.10172, 51.2543}, CountryId{"DE"}}, // Velbert-Rosenhügel station
    {Coordinate{3.12106, 49.5807}, CountryId{"FR"}}, // Q1912185
    {Coordinate{-0.018, 51.126}, CountryId{"GB"}}, // East Grinstead railway station
    {Coordinate{-1.19605, 52.7791}, CountryId{"GB"}}, // Loughborough railway station
    {Coordinate{0.294444, 51.104}, CountryId{"GB"}}, // Frant railway station
    {Coordinate{7.10958, 51.4417}, CountryId{"DE"}}, // Essen-Eiberg station
    {Coordinate{-1.658, 50.756}, CountryId{"GB"}}, // New Milton railway station
    {Coordinate{-0.324, 51.241}, CountryId{"GB"}}, // Dorking railway station
    {Coordinate{-0.538965, 45.5781}, CountryId{"FR"}}, // Pons
    {Coordinate{-2.497, 53.261}, CountryId{"GB"}}, // Northwich railway station
    {Coordinate{-2.301, 51.342}, CountryId{"GB"}}, // Freshford railway station
    {Coordinate{-3.5215, 51.665}, CountryId{"GB"}}, // Ynyswen railway station
    {Coordinate{-1.9307, 53.6032}, CountryId{"GB"}}, // Marsden railway station
    {Coordinate{-2.74, 54.332}, CountryId{"GB"}}, // Kendal railway station
    {Coordinate{4.6325, 51.3569}, CountryId{"BE"}}, // Noorderkempen railway station
    {Coordinate{2.20972, 49.0358}, CountryId{"FR"}}, // Gare de Bessancourt
    {Coordinate{-1.96191, 48.4995}, CountryId{"FR"}}, // Gare de Pleudihen
    {Coordinate{6.93267, 46.0325}, CountryId{"FR"}}, // Vallorcine railway station
    {Coordinate{-0.3012, 51.4127}, CountryId{"GB"}}, // Kingston railway station
    {Coordinate{7.45762, 43.7607}, CountryId{"FR"}}, // Gare de Roquebrune-Cap-Martin
    {Coordinate{-3.2487, 51.4122}, CountryId{"GB"}}, // Cadoxton railway station
    {Coordinate{3.34876, 50.4564}, CountryId{"FR"}}, // Rosult
    {Coordinate{0.734808, 51.342}, CountryId{"GB"}}, // Sittingbourne railway station
    {Coordinate{2.36389, 49.7544}, CountryId{"FR"}}, // Gare d'Ailly-sur-Noye
    {Coordinate{3.88868, 50.508}, CountryId{"BE"}}, // Erbisœul railway station
    {Coordinate{7.1284, 51.1631}, CountryId{"DE"}}, // Bahnhof Solingen-Schaberg
    {Coordinate{-4.70465, 50.355}, CountryId{"GB"}}, // Par railway station
    {Coordinate{4.8132, 45.7174}, CountryId{"FR"}}, // Gare d'Oullins
    {Coordinate{-0.227205, 44.5686}, CountryId{"FR"}}, // Gare de Saint-Macaire
    {Coordinate{1.6522, 52.5102}, CountryId{"GB"}}, // Somerleyton railway station
    {Coordinate{-2.3472, 53.3875}, CountryId{"GB"}}, // Altrincham Interchange
    {Coordinate{3.38599, 45.8212}, CountryId{"FR"}}, // Gare de Lezoux
    {Coordinate{-2.6962, 51.5132}, CountryId{"GB"}}, // St Andrews Road railway station
    {Coordinate{6.67444, 53.4094}, CountryId{"NL"}}, // Uithuizen railway station
    {Coordinate{5.56944, 51.3853}, CountryId{"NL"}}, // Heeze railway station
    {Coordinate{-2.083, 53.36}, CountryId{"GB"}}, // Middlewood railway station
    {Coordinate{7.51607, 43.9441}, CountryId{"FR"}}, // Gare de Breil-sur-Roya
    {Coordinate{5.50972, 50.6197}, CountryId{"BE"}}, // Pont-de-Seraing railway station
    {Coordinate{18.9151, 50.3434}, CountryId{"PL"}}, // Bytom
    {Coordinate{4.80427, 45.8886}, CountryId{"FR"}}, // Gare de Saint-Germain-au-Mont-d'Or
    {Coordinate{7.56613, 48.5454}, CountryId{"FR"}}, // Gare de Duttlenheim
    {Coordinate{7.48756, 47.6349}, CountryId{"FR"}}, // Gare de Bartenheim
    {Coordinate{-0.1013, 51.6341}, CountryId{"GB"}}, // Winchmore Hill railway station
    {Coordinate{2.6991, 49.0321}, CountryId{"FR"}}, // Gare de Dammartin - Juilly - Saint-Mard
    {Coordinate{2.46389, 48.8436}, CountryId{"FR"}}, // Fontenay-sous-Bois (Paris RER)
    {Coordinate{-3.11806, 48.7618}, CountryId{"FR"}}, // Gare de Lancerf
    {Coordinate{19.4231, 50.4808}, CountryId{"PL"}}, // Zawiercie train station
    {Coordinate{-4.6143, 55.502}, CountryId{"GB"}}, // Prestwick Town railway station
    {Coordinate{12.6022, 55.6298}, CountryId{"DK"}}, // Tårnby Station
    {Coordinate{-5.4365, 50.1838}, CountryId{"GB"}}, // Lelant railway station
    {Coordinate{-0.362, 51.336}, CountryId{"GB"}}, // Oxshott railway station
    {Coordinate{-0.0763, 51.5482}, CountryId{"GB"}}, // Dalston Kingsland railway station
    {Coordinate{-1.82571, 52.6802}, CountryId{"GB"}}, // Lichfield City railway station
    {Coordinate{-0.3806, 51.5928}, CountryId{"GB"}}, // Pinner tube station
    {Coordinate{-2.09, 52.47}, CountryId{"GB"}}, // Cradley Heath railway station
    {Coordinate{-0.220278, 47.3622}, CountryId{"FR"}}, // Gare des Rosiers-sur-Loire
    {Coordinate{4.63876, 50.958}, CountryId{"BE"}}, // Wespelaar-Tildonk railway station
    {Coordinate{-0.595, 51.385}, CountryId{"GB"}}, // Longcross railway station
    {Coordinate{2.79925, 48.4067}, CountryId{"FR"}}, // Gare de Champagne-sur-Seine
    {Coordinate{7.21605, 48.4801}, CountryId{"FR"}}, // Gare de Schirmeck-La Broque
    {Coordinate{-1.965, 53.461}, CountryId{"GB"}}, // Hadfield railway station
    {Coordinate{3.01271, 48.5614}, CountryId{"FR"}}, // Gare de Nangis
    {Coordinate{4.77837, 45.9069}, CountryId{"FR"}}, // Gare de Quincieux
    {Coordinate{-4.6855, 55.3546}, CountryId{"GB"}}, // Maybole railway station
    {Coordinate{2.79439, 49.1428}, CountryId{"FR"}}, // Gare de Nanteuil-le-Haudouin
    {Coordinate{6.68544, 49.802}, CountryId{"DE"}}, // Ehrang station
    {Coordinate{13.6152, 52.3715}, CountryId{"DE"}}, // Eichwalde station
    {Coordinate{8.783, 50.6053}, CountryId{"DE"}}, // Großen Buseck station
    {Coordinate{13.2675, 52.2986}, CountryId{"DE"}}, // Ludwigsfelde railway station
    {Coordinate{11.1328, 51.6703}, CountryId{"DE"}}, // Bahnhof Mägdesprung
    {Coordinate{6.35789, 51.1505}, CountryId{"DE"}}, // Bahnhof Rheindahlen
    {Coordinate{14.1008, 52.5244}, CountryId{"DE"}}, // Müncheberg (Mark) station
    {Coordinate{14.4492, 51.8441}, CountryId{"DE"}}, // Peitz Ost station
    {Coordinate{13.9228, 52.5283}, CountryId{"DE"}}, // Rehfelde station
    {Coordinate{10.3722, 52.0496}, CountryId{"DE"}}, // Salzgitter-Bad station
    {Coordinate{14.3517, 52.5594}, CountryId{"DE"}}, // Seelow-Gusow station
    {Coordinate{13.7453, 53.515}, CountryId{"DE"}}, // Strasburg (Uckerm) railway station
    {Coordinate{13.1722, 52.685}, CountryId{"DE"}}, // Velten
    {Coordinate{7.95654, 51.6163}, CountryId{"DE"}}, // Welver station
    {Coordinate{14.4056, 52.565}, CountryId{"DE"}}, // Werbig station
    {Coordinate{10.5319, 52.1589}, CountryId{"DE"}}, // Wolfenbüttel station
    {Coordinate{6.59199, 51.5424}, CountryId{"DE"}}, // Rheinberg (Rheinland)
    {Coordinate{2.50472, 48.7525}, CountryId{"FR"}}, // Boissy-Saint-Léger
    {Coordinate{0.246111, 50.8211}, CountryId{"GB"}}, // Polegate railway station
    {Coordinate{-3.53858, 50.7171}, CountryId{"GB"}}, // Exeter St Thomas railway station
    {Coordinate{-0.34187, 47.8417}, CountryId{"FR"}}, // Gare de Sablé
    {Coordinate{6.985, 51.589}, CountryId{"DE"}}, // Gladbeck-Zweckel station
    {Coordinate{6.65956, 48.5049}, CountryId{"FR"}}, // Gare de Ménil-Flin
    {Coordinate{1.80869, 48.9632}, CountryId{"FR"}}, // Épône - Mézières
    {Coordinate{-2.9919, 53.4048}, CountryId{"GB"}}, // Liverpool James Street railway station
    {Coordinate{-1.24348, 51.612}, CountryId{"GB"}}, // Didcot Parkway railway station
    {Coordinate{18.6231, 49.7433}, CountryId{"CZ"}}, // Český Těšín railway station
    {Coordinate{14.0483, 50.65}, CountryId{"CZ"}}, // Ústí nad Labem-Střekov railway station
    {Coordinate{7.58717, 48.5441}, CountryId{"FR"}}, // Gare de Duppigheim
    {Coordinate{3.99945, 50.2556}, CountryId{"FR"}}, // Gare de Ferrière-la-Grande
    {Coordinate{7.6534, 48.9052}, CountryId{"FR"}}, // Gare de Gundershoffen
    {Coordinate{1.38322, 43.5965}, CountryId{"FR"}}, // Gare de Lardenne
    {Coordinate{5.72944, 51.8111}, CountryId{"NL"}}, // Wijchen railway station
    {Coordinate{-4.96, 51.803}, CountryId{"GB"}}, // Haverfordwest railway station
    {Coordinate{1.69183, 47.8136}, CountryId{"FR"}}, // Gare de Meung-sur-Loire
    {Coordinate{-2.667, 53.229}, CountryId{"GB"}}, // Delamere railway station
    {Coordinate{2.82481, 48.6446}, CountryId{"FR"}}, // Gare de Verneuil-l'Étang
    {Coordinate{-3.803, 53.144}, CountryId{"GB"}}, // North Llanrwst railway station
    {Coordinate{5.52448, 45.5446}, CountryId{"FR"}}, // Saint-André-le-Gaz railway station
    {Coordinate{3.82694, 50.8158}, CountryId{"BE"}}, // Lierde railway station
    {Coordinate{-0.1214, 51.4114}, CountryId{"GB"}}, // Norbury railway station
    {Coordinate{4.40816, 50.7947}, CountryId{"BE"}}, // Boitsfort railway station
    {Coordinate{10.8153, 59.6886}, CountryId{"NO"}}, // Holstad Station
    {Coordinate{11.4483, 59.1244}, CountryId{"NO"}}, // Tistedal Station
    {Coordinate{9.05083, 60.6489}, CountryId{"NO"}}, // Q19327501
    {Coordinate{9.5675, 59.2544}, CountryId{"NO"}}, // Hoppestad Station
    {Coordinate{9.34667, 59.3411}, CountryId{"NO"}}, // Valebø Station
    {Coordinate{9.85583, 61.5756}, CountryId{"NO"}}, // Harpefoss Station
    {Coordinate{10.42, 61.1406}, CountryId{"NO"}}, // Hove Station
    {Coordinate{10.6667, 60.96}, CountryId{"NO"}}, // Ring stasjon
    {Coordinate{10.7369, 60.9125}, CountryId{"NO"}}, // Ringsaker Station
    {Coordinate{9.42583, 62.1764}, CountryId{"NO"}}, // Vålåsjø stasjon
    {Coordinate{10.2464, 59.7669}, CountryId{"NO"}}, // Q19327607
    {Coordinate{14.17, 66.3222}, CountryId{"NO"}}, // Gullsmedvik Station
    {Coordinate{14.94, 66.4992}, CountryId{"NO"}}, // Hjartåsen Station
    {Coordinate{13.2894, 65.6217}, CountryId{"NO"}}, // Laksfors Station
    {Coordinate{11.4397, 63.7606}, CountryId{"NO"}}, // Rinnan Station
    {Coordinate{14.5356, 66.4017}, CountryId{"NO"}}, // Storforshei Station
    {Coordinate{9.05972, 60.0997}, CountryId{"NO"}}, // Kravikfjord stasjon
    {Coordinate{11.3722, 62.7036}, CountryId{"NO"}}, // Harborg stoppested
    {Coordinate{11.3019, 62.5472}, CountryId{"NO"}}, // Q19327899
    {Coordinate{11.4547, 60.9847}, CountryId{"NO"}}, // Øksna Station
    {Coordinate{11.9361, 60.6211}, CountryId{"NO"}}, // Haslemo Station
    {Coordinate{6.155, 58.5339}, CountryId{"NO"}}, // Helleland train station
    {Coordinate{9.08722, 59.1861}, CountryId{"NO"}}, // Nakksjø Station
    {Coordinate{7.01806, 58.3678}, CountryId{"NO"}}, // Sandvatn Station
    {Coordinate{8.72611, 58.6917}, CountryId{"NO"}}, // Selåsvatn Station
    {Coordinate{9.30806, 60.9667}, CountryId{"NO"}}, // Leira Station
    {Coordinate{9.96444, 60.8297}, CountryId{"NO"}}, // Nordsinni Station
    {Coordinate{10.4893, 60.6232}, CountryId{"NO"}}, // Trevatn Station
    {Coordinate{9.61222, 59.2061}, CountryId{"NO"}}, // Skien Old Station
    {Coordinate{-0.489167, 50.8164}, CountryId{"GB"}}, // Angmering railway station
    {Coordinate{-4.2921, 55.8988}, CountryId{"GB"}}, // Summerston railway station
    {Coordinate{2.8374, 49.2001}, CountryId{"FR"}}, // Gare d'Ormoy-Villers
    {Coordinate{6.62806, 52.5725}, CountryId{"NL"}}, // Hardenberg railway station
    {Coordinate{8.34558, 56.3437}, CountryId{"DK"}}, // Vemb Station
    {Coordinate{0.334675, 48.0195}, CountryId{"FR"}}, // Gare de Champagné
    {Coordinate{-0.3005, 51.3642}, CountryId{"GB"}}, // Chessington North railway station
    {Coordinate{5.7175, 50.8378}, CountryId{"NL"}}, // Maastricht Randwyck railway station
    {Coordinate{13.7692, 54.0439}, CountryId{"DE"}}, // Wolgast railway station
    {Coordinate{3.85723, 44.7327}, CountryId{"FR"}}, // Gare de Langogne
    {Coordinate{2.51782, 51.0705}, CountryId{"FR"}}, // Gare de Bray-Dunes
    {Coordinate{15.3231, 50.7605}, CountryId{"CZ"}}, // Dolní Polubný railway station
    {Coordinate{10.0833, 54.3311}, CountryId{"DE"}}, // Kronshagen
    {Coordinate{10.0909, 54.3492}, CountryId{"DE"}}, // Suchsdorf
    {Coordinate{8.25056, 56.0928}, CountryId{"DK"}}, // Ringkøbing Station
    {Coordinate{9.97891, 54.4098}, CountryId{"DE"}}, // Gettorf
    {Coordinate{9.82056, 54.5418}, CountryId{"DE"}}, // Rieseby
    {Coordinate{5.42317, 45.3967}, CountryId{"FR"}}, // Grand-Lemps railway station
    {Coordinate{9.77118, 54.6371}, CountryId{"DE"}}, // Süderbrarup
    {Coordinate{9.57535, 54.7644}, CountryId{"DE"}}, // Q19362037
    {Coordinate{15.6044, 50.5092}, CountryId{"CZ"}}, // Q19366262
    {Coordinate{17.1665, 48.9879}, CountryId{"CZ"}}, // Vlkoš
    {Coordinate{13.4228, 50.1686}, CountryId{"CZ"}}, // Kryry
    {Coordinate{17.3477, 48.9308}, CountryId{"CZ"}}, // Vnorovy
    {Coordinate{15.6589, 50.5}, CountryId{"CZ"}}, // Q19366266
    {Coordinate{12.6247, 50.19}, CountryId{"CZ"}}, // Svatava
    {Coordinate{14.0086, 49.6147}, CountryId{"CZ"}}, // Q19366338
    {Coordinate{15.0564, 50.5586}, CountryId{"CZ"}}, // Loukov u Mnichova Hradiště
    {Coordinate{13.8614, 48.8775}, CountryId{"CZ"}}, // Q19366341
    {Coordinate{17.124, 49.0031}, CountryId{"CZ"}}, // Kyjov zastávka
    {Coordinate{15.0517, 50.2392}, CountryId{"CZ"}}, // Q19366346
    {Coordinate{15.0122, 49.9994}, CountryId{"CZ"}}, // Q19366348
    {Coordinate{10.1817, 54.2867}, CountryId{"DE"}}, // Kiel-Elmschenhagen
    {Coordinate{10.0626, 54.2431}, CountryId{"DE"}}, // Q19366881
    {Coordinate{9.99788, 54.1293}, CountryId{"DE"}}, // Einfeld station
    {Coordinate{9.8233, 53.9898}, CountryId{"DE"}}, // Brokstedt station
    {Coordinate{9.68078, 53.8526}, CountryId{"DE"}}, // Q19368562
    {Coordinate{9.64506, 53.8049}, CountryId{"DE"}}, // Horst (Holst) station
    {Coordinate{-2.948, 52.3573}, CountryId{"GB"}}, // Bucknell railway station
    {Coordinate{2.73774, 42.6774}, CountryId{"FR"}}, // Q1937209
    {Coordinate{-0.348, 51.361}, CountryId{"GB"}}, // Claygate railway station
    {Coordinate{9.3275, 58.9356}, CountryId{"NO"}}, // Farsjø Station
    {Coordinate{-0.505715, 44.7168}, CountryId{"FR"}}, // Gare de Saint-Médard-d'Eyrans
    {Coordinate{11.5019, 54.7768}, CountryId{"DK"}}, // Maribo Station
    {Coordinate{-2.79892, 53.4236}, CountryId{"GB"}}, // Prescot railway station
    {Coordinate{6.56941, 48.1088}, CountryId{"FR"}}, // Gare de Pouxeux
    {Coordinate{1.045, 51.949}, CountryId{"GB"}}, // Manningtree railway station
    {Coordinate{0.855388, 49.0037}, CountryId{"FR"}}, // Gare de Romilly-la-Puthenaye
    {Coordinate{23.4942, 51.1409}, CountryId{"PL"}}, // Chełm
    {Coordinate{14.9391, 50.4789}, CountryId{"CZ"}}, // Q19400421
    {Coordinate{14.5539, 49.31}, CountryId{"CZ"}}, // Bechyňská Smoleč
    {Coordinate{15.15, 49.2089}, CountryId{"CZ"}}, // Bednáreček
    {Coordinate{12.7086, 49.5919}, CountryId{"CZ"}}, // Q19400435
    {Coordinate{14.1783, 49.9096}, CountryId{"CZ"}}, // Běleč
    {Coordinate{15.0087, 49.3291}, CountryId{"CZ"}}, // Benešov nad Lipou
    {Coordinate{15.7328, 50.4517}, CountryId{"CZ"}}, // Q19400444
    {Coordinate{13.7594, 50.5403}, CountryId{"CZ"}}, // Bílina kyselka (train station)
    {Coordinate{17.4396, 48.9407}, CountryId{"CZ"}}, // Blatnice pod Svatým Antonínkem
    {Coordinate{13.0822, 50.3592}, CountryId{"CZ"}}, // Q19400452
    {Coordinate{16.2112, 50.597}, CountryId{"CZ"}}, // Q19400454
    {Coordinate{13.8786, 50.6722}, CountryId{"CZ"}}, // Bohosudov
    {Coordinate{17.9262, 49.0962}, CountryId{"CZ"}}, // Bohuslavice nad Vláří
    {Coordinate{17.1192, 49.0549}, CountryId{"CZ"}}, // Bohuslavice u Kyjova (train station)
    {Coordinate{16.3561, 48.988}, CountryId{"CZ"}}, // Bohutice
    {Coordinate{12.7811, 49.6878}, CountryId{"CZ"}}, // Q19400459
    {Coordinate{15.015, 50.0153}, CountryId{"CZ"}}, // Bošice
    {Coordinate{15.7495, 49.3056}, CountryId{"CZ"}}, // Bransouze
    {Coordinate{14.0028, 49.7383}, CountryId{"CZ"}}, // Q19400466
    {Coordinate{17.4552, 49.3493}, CountryId{"CZ"}}, // Břest
    {Coordinate{15.0361, 50.5456}, CountryId{"CZ"}}, // Q19400468
    {Coordinate{16.2347, 50.6049}, CountryId{"CZ"}}, // Březová u Broumova
    {Coordinate{16.9056, 48.9473}, CountryId{"CZ"}}, // Brumovice
    {Coordinate{15.1844, 49.7222}, CountryId{"CZ"}}, // Budčice
    {Coordinate{17.2895, 48.9369}, CountryId{"CZ"}}, // Bzenec přívoz
    {Coordinate{17.2942, 48.9705}, CountryId{"CZ"}}, // Bzenec-Olšovec (train station)
    {Coordinate{14.9489, 50.2722}, CountryId{"CZ"}}, // Q19400479
    {Coordinate{16.4661, 49.3194}, CountryId{"CZ"}}, // Čebín
    {Coordinate{16.2061, 49.9057}, CountryId{"CZ"}}, // Q19400486
    {Coordinate{16.2186, 49.901}, CountryId{"CZ"}}, // Q19400487
    {Coordinate{17.7728, 49.5274}, CountryId{"CZ"}}, // Černotín
    {Coordinate{14.4058, 48.9267}, CountryId{"CZ"}}, // Q19400496
    {Coordinate{14.2861, 48.6442}, CountryId{"CZ"}}, // Q19400498
    {Coordinate{15.2069, 49.9878}, CountryId{"CZ"}}, // Červené Pečky
    {Coordinate{13.3047, 49.4956}, CountryId{"CZ"}}, // Q19400500
    {Coordinate{16.7836, 50.1044}, CountryId{"CZ"}}, // Červený Potok
    {Coordinate{16.5668, 49.2845}, CountryId{"CZ"}}, // Česká
    {Coordinate{16.8423, 48.7599}, CountryId{"CZ"}}, // Q19400504
    {Coordinate{12.3481, 50.0739}, CountryId{"CZ"}}, // Cheb-Skalka station
    {Coordinate{14.4564, 50.2672}, CountryId{"CZ"}}, // Q19400509
    {Coordinate{14.8058, 49.8697}, CountryId{"CZ"}}, // Chocerady
    {Coordinate{13.0678, 49.3653}, CountryId{"CZ"}}, // Chodská Lhota
    {Coordinate{15.6428, 49.9892}, CountryId{"CZ"}}, // Choltice
    {Coordinate{14.1858, 50.7236}, CountryId{"CZ"}}, // Q19400515
    {Coordinate{13.7844, 50.5756}, CountryId{"CZ"}}, // Q19400517
    {Coordinate{14.8103, 50.3394}, CountryId{"CZ"}}, // Chotětov
    {Coordinate{15.1211, 49.9703}, CountryId{"CZ"}}, // Q19400519
    {Coordinate{14.5769, 49.8394}, CountryId{"CZ"}}, // Chrást nad Sázavou
    {Coordinate{15.1944, 49.7122}, CountryId{"CZ"}}, // Q19400521
    {Coordinate{14.3375, 50.2397}, CountryId{"CZ"}}, // Q19400524
    {Coordinate{15.7635, 49.282}, CountryId{"CZ"}}, // Číchov (train station)
    {Coordinate{12.6156, 50.1644}, CountryId{"CZ"}}, // Citice (train station)
    {Coordinate{15.9775, 48.8789}, CountryId{"CZ"}}, // Citonice
    {Coordinate{15.4397, 49.0784}, CountryId{"CZ"}}, // Dačice město
    {Coordinate{12.8864, 50.2547}, CountryId{"CZ"}}, // Q19400547
    {Coordinate{14.3985, 49.8876}, CountryId{"CZ"}}, // Davle
    {Coordinate{16.188, 50.5616}, CountryId{"CZ"}}, // Dědov
    {Coordinate{13.2861, 49.4508}, CountryId{"CZ"}}, // Q19400554
    {Coordinate{17.9151, 49.098}, CountryId{"CZ"}}, // Divnice
    {Coordinate{14.9654, 49.3623}, CountryId{"CZ"}}, // Q19400563
    {Coordinate{14.1915, 50.7158}, CountryId{"CZ"}}, // Dobkovice
    {Coordinate{13.9992, 49.5561}, CountryId{"CZ"}}, // Q19400565
    {Coordinate{13.0881, 49.3717}, CountryId{"CZ"}}, // Dobříkov na Šumavě
    {Coordinate{14.7697, 49.42}, CountryId{"CZ"}}, // Dobronice u Chýnova (railway station)
    {Coordinate{17.6089, 49.3449}, CountryId{"CZ"}}, // Dobrotice
    {Coordinate{14.9394, 50.3553}, CountryId{"CZ"}}, // Q19400571
    {Coordinate{16.1211, 50.2844}, CountryId{"CZ"}}, // Dobruška-Pulice
    {Coordinate{14.3506, 50.2206}, CountryId{"CZ"}}, // Dolany nad Vltavou
    {Coordinate{16.3679, 48.9122}, CountryId{"CZ"}}, // Dolenice
    {Coordinate{14.4364, 50.3886}, CountryId{"CZ"}}, // Dolní Beřkovice
    {Coordinate{15.4617, 49.3428}, CountryId{"CZ"}}, // Dolní Cerekev
    {Coordinate{16.7472, 50.0656}, CountryId{"CZ"}}, // Q19400581
    {Coordinate{15.7473, 49.3229}, CountryId{"CZ"}}, // Dolní Smrčné
    {Coordinate{14.0484, 50.5967}, CountryId{"CZ"}}, // Dolní Zálezly
    {Coordinate{12.7392, 49.7353}, CountryId{"CZ"}}, // Q19400584
    {Coordinate{16.6218, 49.4387}, CountryId{"CZ"}}, // Doubravice nad Svitavou
    {Coordinate{15.0628, 49.9369}, CountryId{"CZ"}}, // Q19400592
    {Coordinate{14.6342, 50.2425}, CountryId{"CZ"}}, // Dřísy (train station)
    {Coordinate{12.7219, 49.6289}, CountryId{"CZ"}}, // Q19400600
    {Coordinate{13.1775, 49.3353}, CountryId{"CZ"}}, // Dubová Lhota
    {Coordinate{16.1922, 49.9843}, CountryId{"CZ"}}, // Q19400602
    {Coordinate{14.8969, 48.8553}, CountryId{"CZ"}}, // Q19400603
    {Coordinate{16.1743, 49.9252}, CountryId{"CZ"}}, // Džbánov
    {Coordinate{14.7364, 49.1183}, CountryId{"CZ"}}, // Q19400623
    {Coordinate{15.8744, 48.9846}, CountryId{"CZ"}}, // Grešlové Mýto
    {Coordinate{12.9381, 50.2803}, CountryId{"CZ"}}, // Q19400670
    {Coordinate{13.175, 49.2111}, CountryId{"CZ"}}, // Hamry-Hojsova Stráž
    {Coordinate{15.4734, 49.5254}, CountryId{"CZ"}}, // Herálec
    {Coordinate{14.3494, 48.6192}, CountryId{"CZ"}}, // Herbertov
    {Coordinate{16.3897, 48.7517}, CountryId{"CZ"}}, // Hevlín
    {Coordinate{15.2933, 49.9817}, CountryId{"CZ"}}, // Hlízov
    {Coordinate{14.6753, 48.8958}, CountryId{"CZ"}}, // Q19400682
    {Coordinate{15.2186, 50.0022}, CountryId{"CZ"}}, // Hluboký Důl
    {Coordinate{14.3614, 50.4528}, CountryId{"CZ"}}, // Hněvice
    {Coordinate{14.1039, 48.7786}, CountryId{"CZ"}}, // Hodňov
    {Coordinate{13.2222, 49.1908}, CountryId{"CZ"}}, // Hojsova Stráž-Brčálník
    {Coordinate{15.9273, 49.7882}, CountryId{"CZ"}}, // Q19400688
    {Coordinate{14.4478, 48.8514}, CountryId{"CZ"}}, // Q19400689
    {Coordinate{16.8246, 49.1798}, CountryId{"CZ"}}, // Holubice
    {Coordinate{15.0286, 50.1528}, CountryId{"CZ"}}, // Hořátev
    {Coordinate{15.5681, 50.5267}, CountryId{"CZ"}}, // Horka u Staré Paky
    {Coordinate{16.0831, 50.6231}, CountryId{"CZ"}}, // Horní Adršpach
    {Coordinate{15.5867, 50.5967}, CountryId{"CZ"}}, // Q19400694
    {Coordinate{13.3622, 49.9475}, CountryId{"CZ"}}, // Q19400695
    {Coordinate{17.4524, 49.4155}, CountryId{"CZ"}}, // Horní Moštěnice
    {Coordinate{14.3864, 50.4225}, CountryId{"CZ"}}, // Horní Počaply
    {Coordinate{15.3117, 49.2908}, CountryId{"CZ"}}, // Q19400700
    {Coordinate{15.2586, 49.2344}, CountryId{"CZ"}}, // Q19400701
    {Coordinate{16.7828, 49.1198}, CountryId{"CZ"}}, // Hostěrádky-Rešov
    {Coordinate{17.8723, 49.0536}, CountryId{"CZ"}}, // Hostětín
    {Coordinate{17.0594, 49.2917}, CountryId{"CZ"}}, // Q19400705
    {Coordinate{12.7778, 49.5603}, CountryId{"CZ"}}, // Q19400706
    {Coordinate{14.5275, 50.1806}, CountryId{"CZ"}}, // Hovorčovice
    {Coordinate{15.5011, 50.6231}, CountryId{"CZ"}}, // Hrabačov
    {Coordinate{16.3853, 48.7989}, CountryId{"CZ"}}, // Hrabětice
    {Coordinate{16.4384, 49.3336}, CountryId{"CZ"}}, // Hradčany (train station)
    {Coordinate{14.3653, 48.9264}, CountryId{"CZ"}}, // Hradce
    {Coordinate{17.5752, 49.0444}, CountryId{"CZ"}}, // Hradčovice
    {Coordinate{14.8794, 48.8728}, CountryId{"CZ"}}, // Q19400716
    {Coordinate{14.1742, 50.485}, CountryId{"CZ"}}, // Hrdly (train station)
    {Coordinate{14.2289, 50.4597}, CountryId{"CZ"}}, // Q19400720
    {Coordinate{16.1966, 49.9112}, CountryId{"CZ"}}, // Q19400721
    {Coordinate{14.0261, 49.0497}, CountryId{"CZ"}}, // Q19400722
    {Coordinate{14.7719, 49.8722}, CountryId{"CZ"}}, // Hvězdonice
    {Coordinate{15.4513, 50.6806}, CountryId{"CZ"}}, // Jablonec nad Jizerou-Hradsko train station
    {Coordinate{14.3969, 49.9472}, CountryId{"CZ"}}, // Dolní Břežany-Jarov
    {Coordinate{14.2114, 50.0942}, CountryId{"CZ"}}, // Jeneč (train station)
    {Coordinate{14.4077, 48.629}, CountryId{"CZ"}}, // Q19400739
    {Coordinate{17.1132, 49.0881}, CountryId{"CZ"}}, // Jestřabice
    {Coordinate{14.2908, 49.3819}, CountryId{"CZ"}}, // Q19400742
    {Coordinate{15.3806, 50.4503}, CountryId{"CZ"}}, // Q19400751
    {Coordinate{13.9872, 49.7822}, CountryId{"CZ"}}, // Jince
    {Coordinate{15.0308, 49.7756}, CountryId{"CZ"}}, // Kácov zastávka
    {Coordinate{15.0031, 50.1889}, CountryId{"CZ"}}, // Q19400759
    {Coordinate{14.5169, 49.8664}, CountryId{"CZ"}}, // Kamenný Přívoz
    {Coordinate{14.4511, 48.9092}, CountryId{"CZ"}}, // Q19400761
    {Coordinate{15.6608, 50.5583}, CountryId{"CZ"}}, // Klášterská Lhota
    {Coordinate{17.7692, 49.7372}, CountryId{"CZ"}}, // Klokočov
    {Coordinate{13.6406, 50.1422}, CountryId{"CZ"}}, // Kněževes
    {Coordinate{14.6561, 50.3069}, CountryId{"CZ"}}, // Kojovice
    {Coordinate{16.8995, 49.2158}, CountryId{"CZ"}}, // Komořany u Vyškova
    {Coordinate{15.1383, 49.9731}, CountryId{"CZ"}}, // Kořenice
    {Coordinate{14.6706, 50.3172}, CountryId{"CZ"}}, // Košátky
    {Coordinate{15.4036, 50.5686}, CountryId{"CZ"}}, // Košťálov
    {Coordinate{17.1069, 50.0992}, CountryId{"CZ"}}, // Kouty nad Desnou
    {Coordinate{15.8044, 49.2153}, CountryId{"CZ"}}, // Krahulov (train station)
    {Coordinate{12.675, 50.1892}, CountryId{"CZ"}}, // Královské Poříčí
    {Coordinate{16.6876, 49.8488}, CountryId{"CZ"}}, // Krasíkov
    {Coordinate{15.6106, 50.1575}, CountryId{"CZ"}}, // Q19400844
    {Coordinate{14.9417, 49.3856}, CountryId{"CZ"}}, // Q19400846
    {Coordinate{16.8341, 49.1443}, CountryId{"CZ"}}, // Q19400847
    {Coordinate{16.8246, 49.1435}, CountryId{"CZ"}}, // Křenovice horní nádraží
    {Coordinate{14.2144, 50.5258}, CountryId{"CZ"}}, // Q19400850
    {Coordinate{14.5531, 49.8486}, CountryId{"CZ"}}, // Krhanice
    {Coordinate{15.1436, 50.2658}, CountryId{"CZ"}}, // Křinec
    {Coordinate{16.9348, 49.1451}, CountryId{"CZ"}}, // Křižanovice
    {Coordinate{14.8689, 50.3764}, CountryId{"CZ"}}, // Krnsko
    {Coordinate{14.7008, 50.3244}, CountryId{"CZ"}}, // Kropáčova Vrutice (train station)
    {Coordinate{15.8842, 50.3958}, CountryId{"CZ"}}, // Kuks
    {Coordinate{15.6228, 50.5839}, CountryId{"CZ"}}, // Kunčice nad Labem
    {Coordinate{17.9636, 49.6364}, CountryId{"CZ"}}, // Q19400863
    {Coordinate{17.4611, 49.0382}, CountryId{"CZ"}}, // Kunovice zastávka
    {Coordinate{15.1589, 49.7294}, CountryId{"CZ"}}, // Laziště
    {Coordinate{14.7114, 50.1683}, CountryId{"CZ"}}, // Lázně Toušeň
    {Coordinate{15.1858, 50.2839}, CountryId{"CZ"}}, // Q19400879
    {Coordinate{16.8016, 48.7941}, CountryId{"CZ"}}, // Lednice (train station)
    {Coordinate{16.8032, 48.7811}, CountryId{"CZ"}}, // Q19400882
    {Coordinate{14.3725, 50.1894}, CountryId{"CZ"}}, // Libčice nad Vltavou-Letky (train station)
    {Coordinate{14.6194, 49.3814}, CountryId{"CZ"}}, // Q19400887
    {Coordinate{14.0406, 50.5642}, CountryId{"CZ"}}, // Q19400888
    {Coordinate{15.4172, 50.5556}, CountryId{"CZ"}}, // Q19400889
    {Coordinate{11.1281, 60.0397}, CountryId{"NO"}}, // Lindeberg Station
    {Coordinate{15.5383, 49.5561}, CountryId{"CZ"}}, // Lípa
    {Coordinate{17.4578, 48.9098}, CountryId{"CZ"}}, // Lipov
    {Coordinate{14.3711, 49.4211}, CountryId{"CZ"}}, // Q19400895
    {Coordinate{15.2122, 50.6472}, CountryId{"CZ"}}, // Q19400896
    {Coordinate{14.0333, 50.5586}, CountryId{"CZ"}}, // Litochovice nad Labem
    {Coordinate{14.1389, 50.5325}, CountryId{"CZ"}}, // Litoměřice město (train station)
    {Coordinate{16.2798, 49.8858}, CountryId{"CZ"}}, // Nedošín
    {Coordinate{14.5306, 50.2508}, CountryId{"CZ"}}, // Lobkovice
    {Coordinate{13.9742, 49.8464}, CountryId{"CZ"}}, // Lochovice (train station)
    {Coordinate{12.6853, 49.8172}, CountryId{"CZ"}}, // Q19400905
    {Coordinate{14.7156, 49.8636}, CountryId{"CZ"}}, // Lštění
    {Coordinate{15.225, 50.7395}, CountryId{"CZ"}}, // Lučany nad Nisou
    {Coordinate{14.4625, 49.8647}, CountryId{"CZ"}}, // Luka pod Medníkem
    {Coordinate{14.0931, 50.5025}, CountryId{"CZ"}}, // Q19400914
    {Coordinate{16.6045, 49.8801}, CountryId{"CZ"}}, // Luková u Rudoltic v Čechách
    {Coordinate{16.923, 49.2486}, CountryId{"CZ"}}, // Q19400916
    {Coordinate{14.9461, 50.3183}, CountryId{"CZ"}}, // Q19400918
    {Coordinate{14.75, 49.0536}, CountryId{"CZ"}}, // Q19400920
    {Coordinate{14.8014, 50.2}, CountryId{"CZ"}}, // Lysá nad Labem-Dvorce
    {Coordinate{14.0564, 50.5381}, CountryId{"CZ"}}, // Malé Žernoseky
    {Coordinate{13.3672, 49.2992}, CountryId{"CZ"}}, // Malonice station
    {Coordinate{14.9319, 49.8219}, CountryId{"CZ"}}, // Q19400943
    {Coordinate{15.4476, 49.108}, CountryId{"CZ"}}, // Malý Pěčín
    {Coordinate{12.6578, 49.7869}, CountryId{"CZ"}}, // Q19400946
    {Coordinate{14.5258, 50.3331}, CountryId{"CZ"}}, // Malý Újezd
    {Coordinate{15.5408, 50.5806}, CountryId{"CZ"}}, // Martinice v Krkonoších
    {Coordinate{15.7676, 49.9746}, CountryId{"CZ"}}, // Medlešice
    {Coordinate{14.4675, 50.375}, CountryId{"CZ"}}, // Mělník-Mlazice
    {Coordinate{17.2472, 49.3438}, CountryId{"CZ"}}, // Měrovice nad Hanou
    {Coordinate{14.5133, 50.2056}, CountryId{"CZ"}}, // Měšice u Prahy
    {Coordinate{14.2408, 48.7886}, CountryId{"CZ"}}, // Q19400962
    {Coordinate{14.5803, 49.4478}, CountryId{"CZ"}}, // Q19400963
    {Coordinate{14.3367, 50.9842}, CountryId{"CZ"}}, // Mikulášovice dolní nádraží
    {Coordinate{14.3572, 50.9622}, CountryId{"CZ"}}, // Mikulášovice střed
    {Coordinate{14.0219, 49.6322}, CountryId{"CZ"}}, // Milín
    {Coordinate{16.3625, 48.9354}, CountryId{"CZ"}}, // Miroslav
    {Coordinate{14.9156, 50.4192}, CountryId{"CZ"}}, // Mladá Boleslav město
    {Coordinate{13.3639, 49.9867}, CountryId{"CZ"}}, // Mladotice
    {Coordinate{13.3461, 49.9717}, CountryId{"CZ"}}, // Mladotice zastávka
    {Coordinate{14.3467, 50.3186}, CountryId{"CZ"}}, // Mlčechvosty
    {Coordinate{14.1264, 50.6783}, CountryId{"CZ"}}, // Mojžíř (train station)
    {Coordinate{16.7531, 50.0256}, CountryId{"CZ"}}, // Q19400986
    {Coordinate{17.3147, 48.9772}, CountryId{"CZ"}}, // Moravský Písek
    {Coordinate{17.3295, 48.9908}, CountryId{"CZ"}}, // Moravský Písek zastávka
    {Coordinate{15.6922, 50.4911}, CountryId{"CZ"}}, // Q19400992
    {Coordinate{14.6914, 50.1364}, CountryId{"CZ"}}, // Mstětice
    {Coordinate{17.0395, 48.9047}, CountryId{"CZ"}}, // Mutěnice station
    {Coordinate{17.0272, 48.9119}, CountryId{"CZ"}}, // Mutěnice zastávka
    {Coordinate{12.7731, 49.5447}, CountryId{"CZ"}}, // Mutěnín
    {Coordinate{15.3781, 49.0155}, CountryId{"CZ"}}, // Mutišov
    {Coordinate{15.4863, 49.2078}, CountryId{"CZ"}}, // Mysliboř
    {Coordinate{14.0219, 49.5286}, CountryId{"CZ"}}, // Q19401008
    {Coordinate{14.6394, 49.4503}, CountryId{"CZ"}}, // Q19401013
    {Coordinate{16.3511, 48.9631}, CountryId{"CZ"}}, // Našiměřice
    {Coordinate{15.3519, 50.5842}, CountryId{"CZ"}}, // Q19401015
    {Coordinate{14.3086, 50.2833}, CountryId{"CZ"}}, // Nelahozeves
    {Coordinate{14.3025, 50.2627}, CountryId{"CZ"}}, // Nelahozeves zámek
    {Coordinate{17.2165, 49.3449}, CountryId{"CZ"}}, // Němčice nad Hanou
    {Coordinate{14.9111, 50.3739}, CountryId{"CZ"}}, // Q19401019
    {Coordinate{14.5217, 50.2558}, CountryId{"CZ"}}, // Neratovice město
    {Coordinate{17.0802, 49.1493}, CountryId{"CZ"}}, // Nesovice
    {Coordinate{14.4214, 50.26}, CountryId{"CZ"}}, // Netřeba
    {Coordinate{17.0477, 49.1368}, CountryId{"CZ"}}, // Nevojice
    {Coordinate{17.7489, 49.0223}, CountryId{"CZ"}}, // Nezdenice (train station)
    {Coordinate{13.2994, 49.3256}, CountryId{"CZ"}}, // Neznašovy (train station)
    {Coordinate{14.4983, 48.9519}, CountryId{"CZ"}}, // Train station Nové Hodějovice
    {Coordinate{14.1192, 50.4972}, CountryId{"CZ"}}, // Q19401035
    {Coordinate{17.0053, 50.1161}, CountryId{"CZ"}}, // Q19401036
    {Coordinate{14.3164, 50.3014}, CountryId{"CZ"}}, // Nové Ouholice (train station)
    {Coordinate{17.9931, 49.6114}, CountryId{"CZ"}}, // Šenov u Nového Jičína
    {Coordinate{12.8125, 49.4772}, CountryId{"CZ"}}, // Q19401043
    {Coordinate{14.9483, 49.4244}, CountryId{"CZ"}}, // Q19401052
    {Coordinate{12.85, 49.5131}, CountryId{"CZ"}}, // Q19401055
    {Coordinate{15.949, 48.9032}, CountryId{"CZ"}}, // Olbramkostel
    {Coordinate{14.1939, 50.4775}, CountryId{"CZ"}}, // Q19401061
    {Coordinate{15.0861, 50.2417}, CountryId{"CZ"}}, // Q19401071
    {Coordinate{14.8909, 50.1879}, CountryId{"CZ"}}, // Ostrá
    {Coordinate{14.7461, 50.2058}, CountryId{"CZ"}}, // Otradovice
    {Coordinate{13.9378, 48.8053}, CountryId{"CZ"}}, // Q19401079
    {Coordinate{14.535, 49.4475}, CountryId{"CZ"}}, // Q19401081
    {Coordinate{13.3942, 50.0711}, CountryId{"CZ"}}, // Q19401218
    {Coordinate{14.1653, 50.095}, CountryId{"CZ"}}, // Pavlov
    {Coordinate{15.3979, 49.0446}, CountryId{"CZ"}}, // Peč
    {Coordinate{14.6256, 49.8336}, CountryId{"CZ"}}, // Pecerady
    {Coordinate{16.4192, 50.1608}, CountryId{"CZ"}}, // Q19401224
    {Coordinate{13.9108, 48.8481}, CountryId{"CZ"}}, // Pěkná
    {Coordinate{12.6792, 49.7708}, CountryId{"CZ"}}, // Q19401229
    {Coordinate{13.1128, 50.3675}, CountryId{"CZ"}}, // Q19401230
    {Coordinate{14.7558, 48.8456}, CountryId{"CZ"}}, // Petříkov
    {Coordinate{16.0033, 50.6017}, CountryId{"CZ"}}, // Q19401232
    {Coordinate{13.4341, 50.1354}, CountryId{"CZ"}}, // Petrohrad (train station)
    {Coordinate{14.4283, 49.8792}, CountryId{"CZ"}}, // Petrov u Prahy
    {Coordinate{17.2738, 48.8789}, CountryId{"CZ"}}, // Petrov u Strážnice
    {Coordinate{14.4106, 49.8764}, CountryId{"CZ"}}, // Q19401237
    {Coordinate{13.1795, 49.3209}, CountryId{"CZ"}}, // Q19401238
    {Coordinate{17.8431, 49.0375}, CountryId{"CZ"}}, // Pitín zastávka
    {Coordinate{14.3508, 48.865}, CountryId{"CZ"}}, // Plešovice
    {Coordinate{14.875, 49.8783}, CountryId{"CZ"}}, // Q19401256
    {Coordinate{15.6244, 50.6006}, CountryId{"CZ"}}, // Q19401262
    {Coordinate{16.8492, 50.0906}, CountryId{"CZ"}}, // Q19401263
    {Coordinate{15.9815, 49.7935}, CountryId{"CZ"}}, // Q19401265
    {Coordinate{14.2675, 50.5108}, CountryId{"CZ"}}, // Polepy
    {Coordinate{17.7113, 49.0685}, CountryId{"CZ"}}, // Polichno
    {Coordinate{15.4569, 50.6486}, CountryId{"CZ"}}, // Poniklá
    {Coordinate{15.4508, 50.6667}, CountryId{"CZ"}}, // Poniklá zastávka
    {Coordinate{17.9668, 49.0807}, CountryId{"CZ"}}, // Popov
    {Coordinate{16.8521, 48.7509}, CountryId{"CZ"}}, // Poštorná
    {Coordinate{16.9633, 50.08}, CountryId{"CZ"}}, // Potůčník
    {Coordinate{13.3747, 50.0239}, CountryId{"CZ"}}, // Potvorov
    {Coordinate{14.0086, 49.0151}, CountryId{"CZ"}}, // Prachatice
    {Coordinate{13.9975, 49.0058}, CountryId{"CZ"}}, // Prachatice lázně
    {Coordinate{14.0361, 50.5725}, CountryId{"CZ"}}, // Prackovice nad Labem
    {Coordinate{14.394, 50.0407}, CountryId{"CZ"}}, // Praha-Hlubočepy zastávka
    {Coordinate{14.3103, 50.0839}, CountryId{"CZ"}}, // Praha-Ruzyně
    {Coordinate{15.4072, 50.1525}, CountryId{"CZ"}}, // Převýšov
    {Coordinate{16.5742, 48.9657}, CountryId{"CZ"}}, // Q19401296
    {Coordinate{15.7415, 49.3435}, CountryId{"CZ"}}, // Přímělkov
    {Coordinate{15.0786, 50.5789}, CountryId{"CZ"}}, // Příšovice
    {Coordinate{13.8378, 50.6608}, CountryId{"CZ"}}, // Proboštov
    {Coordinate{14.5322, 49.8636}, CountryId{"CZ"}}, // Prosečnice
    {Coordinate{16.7539, 50.0989}, CountryId{"CZ"}}, // Prostřední Lipka
    {Coordinate{14.4442, 48.6811}, CountryId{"CZ"}}, // Q19401313
    {Coordinate{15.1058, 49.9672}, CountryId{"CZ"}}, // Pučery
    {Coordinate{14.6986, 49.8611}, CountryId{"CZ"}}, // Pyšely
    {Coordinate{15.4719, 49.1461}, CountryId{"CZ"}}, // Radkov
    {Coordinate{14.6117, 48.9008}, CountryId{"CZ"}}, // Radostice u Trocnova
    {Coordinate{17.0331, 50.0156}, CountryId{"CZ"}}, // Q19401327
    {Coordinate{16.9125, 50.04}, CountryId{"CZ"}}, // Q19401329
    {Coordinate{13.9703, 49.8089}, CountryId{"CZ"}}, // Rejkovice
    {Coordinate{14.3553, 50.1792}, CountryId{"CZ"}}, // Řež
    {Coordinate{16.2462, 49.892}, CountryId{"CZ"}}, // Q19401342
    {Coordinate{17.4539, 49.379}, CountryId{"CZ"}}, // Říkovice
    {Coordinate{14.7319, 49.2067}, CountryId{"CZ"}}, // Q19401344
    {Coordinate{17.1986, 48.8929}, CountryId{"CZ"}}, // Rohatec
    {Coordinate{17.2123, 48.8925}, CountryId{"CZ"}}, // Q19401346
    {Coordinate{17.1784, 48.8833}, CountryId{"CZ"}}, // Rohatec zastávka
    {Coordinate{15.1803, 50.2992}, CountryId{"CZ"}}, // Rožďalovice
    {Coordinate{15.49, 50.5544}, CountryId{"CZ"}}, // Q19401354
    {Coordinate{14.365, 50.1678}, CountryId{"CZ"}}, // Roztoky-Žalov
    {Coordinate{16.0911, 50.4994}, CountryId{"CZ"}}, // Rtyně v Podkrkonoší zastávka
    {Coordinate{14.4317, 48.6494}, CountryId{"CZ"}}, // Rybník station
    {Coordinate{15.1439, 50.6836}, CountryId{"CZ"}}, // Rychnov u Jablonce nad Nisou
    {Coordinate{13.9261, 50.1392}, CountryId{"CZ"}}, // Rynholec
    {Coordinate{14.835, 49.8861}, CountryId{"CZ"}}, // Samechov
    {Coordinate{14.9164, 49.8611}, CountryId{"CZ"}}, // Samopše
    {Coordinate{15.2411, 50.13}, CountryId{"CZ"}}, // Q19401373
    {Coordinate{14.0533, 50.5928}, CountryId{"CZ"}}, // Q19401375
    {Coordinate{14.42, 49.4406}, CountryId{"CZ"}}, // Q19401391
    {Coordinate{14.9747, 49.4378}, CountryId{"CZ"}}, // Q19401403
    {Coordinate{16.6094, 49.4804}, CountryId{"CZ"}}, // Skalice nad Svitavou
    {Coordinate{14.3761, 49.9247}, CountryId{"CZ"}}, // Skochovice
    {Coordinate{16.1633, 49.975}, CountryId{"CZ"}}, // Slatina u Vysokého Mýta
    {Coordinate{14.475, 50.9903}, CountryId{"CZ"}}, // Šluknov údolí railway station
    {Coordinate{14.7353, 49.4158}, CountryId{"CZ"}}, // Smyslov (railway station)
    {Coordinate{14.9606, 49.7897}, CountryId{"CZ"}}, // Q19401428
    {Coordinate{16.7333, 49.108}, CountryId{"CZ"}}, // Sokolnice-Telnice
    {Coordinate{13.9694, 48.9261}, CountryId{"CZ"}}, // Spálenecv
    {Coordinate{12.9858, 49.4156}, CountryId{"CZ"}}, // Spáňov
    {Coordinate{13.2225, 49.1614}, CountryId{"CZ"}}, // Špičák
    {Coordinate{17.813, 49.5368}, CountryId{"CZ"}}, // Q19401448
    {Coordinate{15.757, 50.0001}, CountryId{"CZ"}}, // Q19401460
    {Coordinate{13.0106, 49.3842}, CountryId{"CZ"}}, // Starec
    {Coordinate{13.4128, 50.1197}, CountryId{"CZ"}}, // Q19401469
    {Coordinate{14.9931, 50.2379}, CountryId{"CZ"}}, // Q19401473
    {Coordinate{14.9078, 50.1872}, CountryId{"CZ"}}, // Stratov
    {Coordinate{13.0592, 50.3403}, CountryId{"CZ"}}, // Stráž nad Ohří
    {Coordinate{12.7725, 49.6653}, CountryId{"CZ"}}, // Q19401476
    {Coordinate{15.0219, 49.7628}, CountryId{"CZ"}}, // Q19401478
    {Coordinate{14.8569, 49.8831}, CountryId{"CZ"}}, // Stříbrná Skalice
    {Coordinate{16.0691, 49.2226}, CountryId{"CZ"}}, // Studenec
    {Coordinate{15.3194, 49.6703}, CountryId{"CZ"}}, // Stvořidla
    {Coordinate{14.8803, 48.8919}, CountryId{"CZ"}}, // Q19401489
    {Coordinate{16.0053, 50.5322}, CountryId{"CZ"}}, // Suchovršice (train station)
    {Coordinate{14.9458, 49.4066}, CountryId{"CZ"}}, // Q19401491
    {Coordinate{17.2432, 48.8718}, CountryId{"CZ"}}, // Sudoměřice nad Moravou
    {Coordinate{17.7238, 49.03}, CountryId{"CZ"}}, // Šumice
    {Coordinate{14.0986, 50.6619}, CountryId{"CZ"}}, // Q19401497
    {Coordinate{12.6069, 50.1972}, CountryId{"CZ"}}, // Q19401498
    {Coordinate{17.6686, 49.7997}, CountryId{"CZ"}}, // Q19401499
    {Coordinate{18.0352, 49.0461}, CountryId{"CZ"}}, // Q19401500
    {Coordinate{16.5981, 49.4997}, CountryId{"CZ"}}, // Svitávka (train station)
    {Coordinate{12.7694, 49.5742}, CountryId{"CZ"}}, // Q19401503
    {Coordinate{15.465, 50.5458}, CountryId{"CZ"}}, // Q19401520
    {Coordinate{16.71, 49.8593}, CountryId{"CZ"}}, // Tatenice
    {Coordinate{14.3219, 48.6197}, CountryId{"CZ"}}, // Těchoraz
    {Coordinate{13.9875, 49.5886}, CountryId{"CZ"}}, // Tochovice
    {Coordinate{15.0147, 49.9853}, CountryId{"CZ"}}, // Toušice
    {Coordinate{14.9603, 50.1253}, CountryId{"CZ"}}, // Q19401531
    {Coordinate{17.5195, 49.3174}, CountryId{"CZ"}}, // Třebětice
    {Coordinate{12.7014, 49.6253}, CountryId{"CZ"}}, // Q19401534
    {Coordinate{14.3483, 48.8833}, CountryId{"CZ"}}, // Třísov
    {Coordinate{14.5872, 48.9025}, CountryId{"CZ"}}, // Trocnov
    {Coordinate{13.1578, 49.3275}, CountryId{"CZ"}}, // Úborsko
    {Coordinate{14.3519, 50.1697}, CountryId{"CZ"}}, // Úholičky
    {Coordinate{12.75, 49.5778}, CountryId{"CZ"}}, // Q19401546
    {Coordinate{16.1789, 50.0317}, CountryId{"CZ"}}, // Újezd u Chocně
    {Coordinate{15.4189, 49.0536}, CountryId{"CZ"}}, // Urbaneč
    {Coordinate{14.3764, 50.2564}, CountryId{"CZ"}}, // Q19401569
    {Coordinate{14.5069, 50.9811}, CountryId{"CZ"}}, // Valdek railway station
    {Coordinate{14.1219, 50.6722}, CountryId{"CZ"}}, // Q19401571
    {Coordinate{14.4494, 48.9242}, CountryId{"CZ"}}, // Q19401574
    {Coordinate{15.0233, 50.2144}, CountryId{"CZ"}}, // Q19401575
    {Coordinate{15.3136, 50.7114}, CountryId{"CZ"}}, // Velké Hamry
    {Coordinate{13.6633, 49.2983}, CountryId{"CZ"}}, // Velké Hydčice
    {Coordinate{16.0222, 50.5403}, CountryId{"CZ"}}, // Q19401579
    {Coordinate{15.1008, 50.1644}, CountryId{"CZ"}}, // Velké Zboží (train station)
    {Coordinate{14.0803, 50.5261}, CountryId{"CZ"}}, // Velké Žernoseky
    {Coordinate{16.5308, 48.965}, CountryId{"CZ"}}, // Velký Dvůr
    {Coordinate{15.1933, 50.1017}, CountryId{"CZ"}}, // Velký Osek
    {Coordinate{14.3939, 51.0047}, CountryId{"CZ"}}, // Velký Šenov zastávka railway station
    {Coordinate{15.1997, 50.0736}, CountryId{"CZ"}}, // Q19401587
    {Coordinate{17.5027, 49.0428}, CountryId{"CZ"}}, // Vésky
    {Coordinate{17.4162, 49.4083}, CountryId{"CZ"}}, // Věžky
    {Coordinate{15.4839, 50.6269}, CountryId{"CZ"}}, // Víchová nad Jizerou
    {Coordinate{14.1808, 50.7469}, CountryId{"CZ"}}, // Q19401597
    {Coordinate{15.8779, 49.7531}, CountryId{"CZ"}}, // Q19401598
    {Coordinate{15.1581, 49.4156}, CountryId{"CZ"}}, // Q19401599
    {Coordinate{16.9001, 50.0875}, CountryId{"CZ"}}, // Q19401600
    {Coordinate{14.8142, 49.8747}, CountryId{"CZ"}}, // Q19401601
    {Coordinate{14.9472, 50.3364}, CountryId{"CZ"}}, // Q19401602
    {Coordinate{15.972, 49.792}, CountryId{"CZ"}}, // Q19401604
    {Coordinate{14.3717, 50.335}, CountryId{"CZ"}}, // Vraňany (train station)
    {Coordinate{14.9861, 49.7897}, CountryId{"CZ"}}, // Q19401608
    {Coordinate{16.6048, 48.9637}, CountryId{"CZ"}}, // Vranovice
    {Coordinate{14.5664, 49.3244}, CountryId{"CZ"}}, // Q19401610
    {Coordinate{14.9575, 50.2569}, CountryId{"CZ"}}, // Všejany
    {Coordinate{17.5412, 49.322}, CountryId{"CZ"}}, // Všetuly
    {Coordinate{14.8658, 48.7961}, CountryId{"CZ"}}, // Q19401613
    {Coordinate{16.9375, 50.1164}, CountryId{"CZ"}}, // Q19401614
    {Coordinate{17.8086, 49.2158}, CountryId{"CZ"}}, // Zádveřice (train station)
    {Coordinate{15.8799, 49.9005}, CountryId{"CZ"}}, // Zaječice
    {Coordinate{14.3264, 50.4572}, CountryId{"CZ"}}, // Záluží
    {Coordinate{12.8325, 49.5161}, CountryId{"CZ"}}, // Q19401704
    {Coordinate{14.3897, 50.7119}, CountryId{"CZ"}}, // Žandov
    {Coordinate{16.8069, 49.1327}, CountryId{"CZ"}}, // Q19401716
    {Coordinate{16.0671, 50.1195}, CountryId{"CZ"}}, // Q19401717
    {Coordinate{15.9781, 49.8262}, CountryId{"CZ"}}, // Žďárec u Skutče
    {Coordinate{13.1789, 49.2492}, CountryId{"CZ"}}, // Q19401719
    {Coordinate{14.6675, 50.1303}, CountryId{"CZ"}}, // Zeleneč
    {Coordinate{13.7714, 50.6014}, CountryId{"CZ"}}, // Q19401721
    {Coordinate{16.6551, 49.8604}, CountryId{"CZ"}}, // Žichlínek
    {Coordinate{13.3628, 50.0467}, CountryId{"CZ"}}, // Žihle
    {Coordinate{15.8481, 50.4031}, CountryId{"CZ"}}, // Žireč
    {Coordinate{14.1008, 48.7636}, CountryId{"CZ"}}, // Žlábek
    {Coordinate{19.5444, 51.7631}, CountryId{"PL"}}, // Łódź Widzew railway station
    {Coordinate{0.569167, 46.8747}, CountryId{"FR"}}, // Gare d'Ingrandes-sur-Vienne
    {Coordinate{-2.195, 53.4718}, CountryId{"GB"}}, // Ashburys railway station
    {Coordinate{0.288841, 46.1504}, CountryId{"FR"}}, // Q19406980
    {Coordinate{0.185239, 46.4801}, CountryId{"FR"}}, // Gare de Coulombiers
    {Coordinate{0.560377, 46.5636}, CountryId{"FR"}}, // Q19406988
    {Coordinate{0.08372, 47.0159}, CountryId{"FR"}}, // Loudun station
    {Coordinate{0.092968, 46.8368}, CountryId{"FR"}}, // Q19407010
    {Coordinate{2.99555, 50.6396}, CountryId{"FR"}}, // Gare de triage de Lille-Délivrance
    {Coordinate{0.173225, 46.9688}, CountryId{"FR"}}, // Q19407025
    {Coordinate{10.0574, 53.5767}, CountryId{"DE"}}, // Friedrichsberg station
    {Coordinate{-0.756, 51.297}, CountryId{"GB"}}, // Farnborough (Main) railway station
    {Coordinate{-1.716, 52.194}, CountryId{"GB"}}, // Stratford-upon-Avon railway station
    {Coordinate{-4.3471, 55.8406}, CountryId{"GB"}}, // Mosspark railway station
    {Coordinate{1.69964, 46.8097}, CountryId{"FR"}}, // Gare de Châteauroux
    {Coordinate{12.7131, 52.6758}, CountryId{"DE"}}, // Paulinenaue station
    {Coordinate{12.5156, 55.6906}, CountryId{"DK"}}, // Grøndal station
    {Coordinate{4.27509, 50.8897}, CountryId{"BE"}}, // Zellik railway station
    {Coordinate{-0.975, 54.4818}, CountryId{"GB"}}, // Commondale railway station
    {Coordinate{6.92648, 45.9819}, CountryId{"FR"}}, // Argentière railway station
    {Coordinate{7.26948, 51.2855}, CountryId{"DE"}}, // Schwelm West station
    {Coordinate{-2.214, 53.835}, CountryId{"GB"}}, // Nelson railway station
    {Coordinate{5.57389, 52.0458}, CountryId{"NL"}}, // Veenendaal-De Klomp railway station
    {Coordinate{4.3625, 50.5128}, CountryId{"BE"}}, // Pont-à-Celles railway station
    {Coordinate{-2.3, 52.6448}, CountryId{"GB"}}, // Cosford railway station
    {Coordinate{-1.20056, 53.28}, CountryId{"GB"}}, // Whitwell railway station
    {Coordinate{89.7822, 26.2115}, CountryId{"IN"}}, // Agomani railway station
    {Coordinate{-3.781, 51.592}, CountryId{"GB"}}, // Port Talbot Parkway railway station
    {Coordinate{76.6417, 8.9298}, CountryId{"IN"}}, // Chandanattop Halt
    {Coordinate{76.7151, 8.97914}, CountryId{"IN"}}, // Ezhukone railway station
    {Coordinate{77.0317, 26.7562}, CountryId{"IN"}}, // Hindaun City railway station
    {Coordinate{10.0356, 53.5975}, CountryId{"DE"}}, // Alte Wöhr station
    {Coordinate{6.60017, 48.0871}, CountryId{"FR"}}, // Gare d'Éloyes
    {Coordinate{10.0544, 53.6325}, CountryId{"DE"}}, // Kornweg station
    {Coordinate{-3.798, 53.267}, CountryId{"GB"}}, // Glan Conwy railway station
    {Coordinate{0.2277, 51.2142}, CountryId{"GB"}}, // Hildenborough railway station
    {Coordinate{18.6142, 53}, CountryId{"PL"}}, // Toruń Główny railway station
    {Coordinate{2.3626, 49.167}, CountryId{"FR"}}, // Gare de Boran-sur-Oise
    {Coordinate{6.696, 48.4913}, CountryId{"FR"}}, // Gare d'Azerailles
    {Coordinate{5.73639, 50.8969}, CountryId{"NL"}}, // Bunde railway station
    {Coordinate{3.1485, 50.5605}, CountryId{"FR"}}, // Fretin
    {Coordinate{12.1833, 50.3022}, CountryId{"CZ"}}, // Hranice v Čechách
    {Coordinate{-4.057, 52.723}, CountryId{"GB"}}, // Barmouth railway station
    {Coordinate{6.22222, 52.4267}, CountryId{"NL"}}, // Heino railway station
    {Coordinate{8.5441, 47.4115}, CountryId{"CH"}}, // Zürich Oerlikon railway station
    {Coordinate{-3.9409, 51.6253}, CountryId{"GB"}}, // Swansea railway station
    {Coordinate{6.57753, 46.3979}, CountryId{"FR"}}, // Évian-les-Bains railway station
    {Coordinate{1.2926, 52.9305}, CountryId{"GB"}}, // Cromer railway station
    {Coordinate{4.4288, 50.2693}, CountryId{"BE"}}, // Pry railway station
    {Coordinate{-1.125, 50.8489}, CountryId{"GB"}}, // Portchester railway station
    {Coordinate{4.86247, 50.4691}, CountryId{"BE"}}, // Namur railway station
    {Coordinate{5.61972, 52.3375}, CountryId{"NL"}}, // Harderwijk railway station
    {Coordinate{18.6969, 52.8756}, CountryId{"PL"}}, // Aleksandrów Kujawski railway station
    {Coordinate{6.24057, 50.8066}, CountryId{"DE"}}, // Eschweiler-Aue station
    {Coordinate{-0.067, 51.615}, CountryId{"GB"}}, // Silver Street railway station
    {Coordinate{8.77001, 58.4649}, CountryId{"NO"}}, // Arendal Station
    {Coordinate{12.5217, 55.7617}, CountryId{"DK"}}, // Jægersborg station
    {Coordinate{6.95806, 50.9425}, CountryId{"DE"}}, // Cologne Central Station
    {Coordinate{11.2471, 60.3295}, CountryId{"NO"}}, // Eidsvoll station
    {Coordinate{-2.0142, 53.5388}, CountryId{"GB"}}, // Greenfield railway station
    {Coordinate{12.5004, 45.6242}, CountryId{"IT"}}, // Fossalta di Piave railway halt
    {Coordinate{12.7594, 45.7519}, CountryId{"IT"}}, // Q19545550
    {Coordinate{14.6483, 41.2198}, CountryId{"IT"}}, // Q19545569
    {Coordinate{10.6843, 44.9318}, CountryId{"IT"}}, // Tagliata railway halt
    {Coordinate{0.0885, 51.3741}, CountryId{"GB"}}, // Orpington railway station
    {Coordinate{-3.7883, 56.1179}, CountryId{"GB"}}, // Alloa railway station
    {Coordinate{-1.281, 52.021}, CountryId{"GB"}}, // Kings Sutton railway station
    {Coordinate{18.9889, 47.3987}, CountryId{"HU"}}, // Barosstelep railway station
    {Coordinate{3.12522, 48.9509}, CountryId{"FR"}}, // Gare de La Ferté-sous-Jouarre
    {Coordinate{19.0995, 47.5439}, CountryId{"HU"}}, // Vasútmúzeum railway station
    {Coordinate{19.2956, 47.4566}, CountryId{"HU"}}, // Rákoskert railway station
    {Coordinate{19.2448, 47.468}, CountryId{"HU"}}, // Rákoshegy railway station
    {Coordinate{18.9494, 47.5959}, CountryId{"HU"}}, // Solymár railway station
    {Coordinate{19.0142, 47.575}, CountryId{"HU"}}, // Aranyvölgy railway station
    {Coordinate{19.2843, 47.4921}, CountryId{"HU"}}, // Rákoscsaba railway station
    {Coordinate{-2.327, 53.4523}, CountryId{"GB"}}, // Humphrey Park railway station
    {Coordinate{-2.8278, 51.3909}, CountryId{"GB"}}, // Yatton railway station
    {Coordinate{10.0681, 53.6356}, CountryId{"DE"}}, // Hoheneichen station
    {Coordinate{76.8174, 9.0351}, CountryId{"IN"}}, // Kuri railway station
    {Coordinate{10.0825, 53.6411}, CountryId{"DE"}}, // Wellingsbüttel station
    {Coordinate{80.4009, 23.8167}, CountryId{"IN"}}, // Katni South railway station
    {Coordinate{18.1664, 40.3039}, CountryId{"IT"}}, // San Cesario di Lecce railway station
    {Coordinate{18.1853, 40.2697}, CountryId{"IT"}}, // San Donato di Lecce railway station
    {Coordinate{17.2125, 40.5656}, CountryId{"IT"}}, // Statte railway station
    {Coordinate{18.2253, 40.2181}, CountryId{"IT"}}, // Sternatia railway station
    {Coordinate{2.32111, 48.7931}, CountryId{"FR"}}, // Bagneux
    {Coordinate{5.27278, 45.5839}, CountryId{"FR"}}, // Gare de Bourgoin-Jallieu
    {Coordinate{-2.96056, 47.6783}, CountryId{"FR"}}, // Gare de Sainte-Anne
    {Coordinate{16.2126, 48.3825}, CountryId{"AT"}}, // Bahnhof Stockerau
    {Coordinate{10.2528, 53.5083}, CountryId{"DE"}}, // Reinbek station
    {Coordinate{10.2781, 53.5207}, CountryId{"DE"}}, // Wohltorf station
    {Coordinate{-1.09, 51.4853}, CountryId{"GB"}}, // Pangbourne railway station
    {Coordinate{-0.029, 53.562}, CountryId{"GB"}}, // Cleethorpes railway station
    {Coordinate{4.89235, 45.8039}, CountryId{"FR"}}, // Gare de Crépieux-la-Pape
    {Coordinate{-1.5459, 43.4592}, CountryId{"FR"}}, // Gare de Biarritz
    {Coordinate{-2.1226, 53.3777}, CountryId{"GB"}}, // Hazel Grove railway station
    {Coordinate{10.0028, 52.4492}, CountryId{"DE"}}, // Burgdorf station
    {Coordinate{17.224, 49.6165}, CountryId{"CZ"}}, // Olomouc-Řepčín
    {Coordinate{2.15107, 48.8065}, CountryId{"FR"}}, // Gare de Montreuil
    {Coordinate{1.56, 52.565}, CountryId{"GB"}}, // Reedham railway station
    {Coordinate{-3.66797, 40.3816}, CountryId{"ES"}}, // Estación de Asamblea de Madrid-Entrevías
    {Coordinate{6.56694, 53.3906}, CountryId{"NL"}}, // Warffum railway station
    {Coordinate{5.86833, 51.8267}, CountryId{"NL"}}, // Nijmegen Heyendaal railway station
    {Coordinate{8.61959, 47.4205}, CountryId{"CH"}}, // Dietlikon railway station
    {Coordinate{10.2044, 59.74}, CountryId{"NO"}}, // Drammen Station
    {Coordinate{-2.7594, 53.4367}, CountryId{"GB"}}, // Thatto Heath railway station
    {Coordinate{8.44786, 47.3986}, CountryId{"CH"}}, // Schlieren railway station
    {Coordinate{8.42136, 47.3987}, CountryId{"CH"}}, // Glanzenberg railway station
    {Coordinate{12.5078, 55.7447}, CountryId{"DK"}}, // Kildebakke station
    {Coordinate{5.63444, 53.1778}, CountryId{"NL"}}, // Dronryp railway station
    {Coordinate{8.62294, 47.4}, CountryId{"CH"}}, // Dübendorf railway station
    {Coordinate{-2.9542, 57.5514}, CountryId{"GB"}}, // Keith railway station
    {Coordinate{2.09837, 48.9969}, CountryId{"FR"}}, // Gare de Conflans-Sainte-Honorine
    {Coordinate{54.3653, 39.4964}, CountryId{"TM"}}, // Q19613410
    {Coordinate{60.6406, 56.7925}, CountryId{"RU"}}, // Botanicheskaya platform, Yekaterinburg
    {Coordinate{28.0526, 56.4148}, CountryId{"LV"}}, // Briģi railway station
    {Coordinate{60.1189, 57.2539}, CountryId{"RU"}}, // Verkh-Neyvinsk
    {Coordinate{107.518, 51.8881}, CountryId{"RU"}}, // Divizionnaya station
    {Coordinate{-3.8489, 55.7312}, CountryId{"GB"}}, // Carluke railway station
    {Coordinate{16.0083, 50.8511}, CountryId{"PL"}}, // Train station in Marciszów
    {Coordinate{27.829, 56.4822}, CountryId{"LV"}}, // Istalsna railway station
    {Coordinate{108.451, 55.7633}, CountryId{"RU"}}, // Q19618666
    {Coordinate{60.6669, 56.8169}, CountryId{"RU"}}, // Q19618876
    {Coordinate{48.3857, 55.8573}, CountryId{"RU"}}, // Q19619183
    {Coordinate{2.29778, 48.8853}, CountryId{"FR"}}, // Pereire – Levallois
    {Coordinate{2.48583, 48.8053}, CountryId{"FR"}}, // Le Parc de Saint-Maur (Paris RER)
    {Coordinate{5.15194, 52.3428}, CountryId{"NL"}}, // Almere Poort railway station
    {Coordinate{7.77925, 48.703}, CountryId{"FR"}}, // Hœrdt
    {Coordinate{11.7959, 45.7323}, CountryId{"IT"}}, // Q19622699
    {Coordinate{11.8776, 45.6881}, CountryId{"IT"}}, // Q19622702
    {Coordinate{13.633, 42.8443}, CountryId{"IT"}}, // Marino del Tronto-Folignano railway halt
    {Coordinate{13.8189, 42.8857}, CountryId{"IT"}}, // Monsampolo del Tronto railway station
    {Coordinate{13.8499, 42.8942}, CountryId{"IT"}}, // Monteprandone railway station
    {Coordinate{13.7202, 42.8621}, CountryId{"IT"}}, // stazione di Offida-Castel di Lama
    {Coordinate{13.7628, 42.8703}, CountryId{"IT"}}, // Q19622714
    {Coordinate{14.2906, 50.0536}, CountryId{"CZ"}}, // Zličín
    {Coordinate{7.25549, 48.9062}, CountryId{"FR"}}, // Station Tieffenbach - Struth
    {Coordinate{2.31194, 48.78}, CountryId{"FR"}}, // Gare de Bourg-la-Reine
    {Coordinate{-2.6716, 52.968}, CountryId{"GB"}}, // Whitchurch railway station
    {Coordinate{15.0439, 49.3039}, CountryId{"CZ"}}, // Q19632318
    {Coordinate{12.5187, 50.3119}, CountryId{"CZ"}}, // Q19632319
    {Coordinate{14.1286, 49.8748}, CountryId{"CZ"}}, // Nesvačily
    {Coordinate{15.2247, 49.8772}, CountryId{"CZ"}}, // Krasoňovice
    {Coordinate{17.1616, 49.3528}, CountryId{"CZ"}}, // Doloplazy Railway Station
    {Coordinate{12.5808, 50.2217}, CountryId{"CZ"}}, // Q19632323
    {Coordinate{13.4253, 50.3075}, CountryId{"CZ"}}, // Q19632453
    {Coordinate{15.486, 50.5163}, CountryId{"CZ"}}, // Stará Paka
    {Coordinate{17.397, 49.0527}, CountryId{"CZ"}}, // Kostelany nad Moravou
    {Coordinate{15.2206, 50.3175}, CountryId{"CZ"}}, // Q19632457
    {Coordinate{17.6319, 49.3709}, CountryId{"CZ"}}, // Hlinsko pod Hostýnem
    {Coordinate{15.192, 50.634}, CountryId{"CZ"}}, // Malá Skála
    {Coordinate{4.34417, 51.9031}, CountryId{"NL"}}, // Vlaardingen Centrum metro station
    {Coordinate{12.5378, 55.7006}, CountryId{"DK"}}, // Nørrebro station
    {Coordinate{6.73611, 51.4572}, CountryId{"DE"}}, // Duisburg-Ruhrort railway halt
    {Coordinate{6.9709, 51.713}, CountryId{"DE"}}, // Bahnhof Deuten
    {Coordinate{-4.38813, 48.4095}, CountryId{"FR"}}, // Gare de Kerhuon
    {Coordinate{-3.0088, 51.8167}, CountryId{"GB"}}, // Abergavenny railway station
    {Coordinate{-2.9125, 54.0335}, CountryId{"GB"}}, // Heysham Port railway station
    {Coordinate{-4.0281, 55.8669}, CountryId{"GB"}}, // Coatbridge Sunnyside railway station
    {Coordinate{-2.22897, 48.5216}, CountryId{"FR"}}, // Gare de Plancoët
    {Coordinate{9.35842, 54.8242}, CountryId{"DK"}}, // Padborg Station
    {Coordinate{-2.84359, 48.4993}, CountryId{"FR"}}, // Gare de La Méaugon
    {Coordinate{1.90462, 47.9078}, CountryId{"FR"}}, // Gare d'Orléans
    {Coordinate{11.7083, 55.7156}, CountryId{"DK"}}, // Holbæk Station
    {Coordinate{10.6789, 59.9222}, CountryId{"NO"}}, // Skøyen Station
    {Coordinate{-3.31194, 52.5122}, CountryId{"GB"}}, // Newtown railway station
    {Coordinate{-2.885, 52.423}, CountryId{"GB"}}, // Broome railway station
    {Coordinate{10.6358, 59.9136}, CountryId{"NO"}}, // Lysaker Station
    {Coordinate{-1.7559, 52.2226}, CountryId{"GB"}}, // Wilmcote railway station
    {Coordinate{4.61694, 51.9653}, CountryId{"NL"}}, // Nieuwerkerk aan den IJssel railway station
    {Coordinate{-1.21639, 53.2639}, CountryId{"GB"}}, // Creswell railway station
    {Coordinate{6.11904, 50.8874}, CountryId{"DE"}}, // Herzogenrath August-Schmidt-Platz station
    {Coordinate{39.8353, 57.6256}, CountryId{"RU"}}, // Yaroslavl railway station
    {Coordinate{-3.8298, 56.0222}, CountryId{"GB"}}, // Larbert railway station
    {Coordinate{-4.19982, 50.4863}, CountryId{"GB"}}, // Bere Alston
    {Coordinate{7.14363, 46.0279}, CountryId{"CH"}}, // Orsières railway station
    {Coordinate{16.1506, 38.7264}, CountryId{"IT"}}, // Pizzo railway station
    {Coordinate{2.26333, 48.9897}, CountryId{"FR"}}, // Gare d'Ermont-Halte
    {Coordinate{-1.714, 50.753}, CountryId{"GB"}}, // Hinton Admiral railway station
    {Coordinate{7.05228, 48.7385}, CountryId{"FR"}}, // Gare de Sarrebourg
    {Coordinate{43.9217, 40.1831}, CountryId{"AM"}}, // Q19689155
    {Coordinate{8.72933, 40.4559}, CountryId{"IT"}}, // Giave railway station
    {Coordinate{6.49661, 44.567}, CountryId{"FR"}}, // Gare d'Embrun
    {Coordinate{27.0784, 52.2232}, CountryId{"BY"}}, // Lakhva
    {Coordinate{27.6887, 53.7461}, CountryId{"BY"}}, // Mikhanavichy
    {Coordinate{25.3745, 49.0612}, CountryId{"UA"}}, // Buchach
    {Coordinate{3.11561, 50.6228}, CountryId{"FR"}}, // Hellemmes
    {Coordinate{5.98167, 49.9564}, CountryId{"LU"}}, // Merkholtz railway station
    {Coordinate{20.5022, 51.4242}, CountryId{"PL"}}, // Bieliny Opoczyńskie
    {Coordinate{-4.08217, 48.496}, CountryId{"FR"}}, // Gare de Landivisiau
    {Coordinate{10.704, 44.8131}, CountryId{"IT"}}, // San Giovanni railway halt
    {Coordinate{0.4965, 46.7597}, CountryId{"FR"}}, // Naintré-les-Barres
    {Coordinate{8.53032, 40.6893}, CountryId{"IT"}}, // Tissi-Usini railway station
    {Coordinate{-4.17018, 50.3785}, CountryId{"GB"}}, // Devonport railway station
    {Coordinate{27.485, 48.4056}, CountryId{"MD"}}, // Ocnița railway station
    {Coordinate{1.58971, 46.7353}, CountryId{"FR"}}, // Gare de Luant
    {Coordinate{-0.752, 51.413}, CountryId{"GB"}}, // Bracknell railway station
    {Coordinate{0.419, 51.629}, CountryId{"GB"}}, // Billericay railway station
    {Coordinate{-1.5363, 52.2846}, CountryId{"GB"}}, // Leamington Spa railway station
    {Coordinate{6.4497, 48.56}, CountryId{"FR"}}, // Gare de Mont-sur-Meurthe
    {Coordinate{-3.1426, 56.1623}, CountryId{"GB"}}, // Glenrothes with Thornton railway station
    {Coordinate{11.797, 51.1631}, CountryId{"DE"}}, // Naumburg (Saale) Hauptbahnhof
    {Coordinate{8.8712, 53.0185}, CountryId{"DE"}}, // Dreye railway station
    {Coordinate{8.8185, 52.9468}, CountryId{"DE"}}, // Barrien railway station
    {Coordinate{14.4377, 50.0753}, CountryId{"CZ"}}, // Náměstí Míru
    {Coordinate{57.2664, 54.9958}, CountryId{"RU"}}, // Asha
    {Coordinate{34.5817, 46.0357}, CountryId{"UA"}}, // 1334 km
    {Coordinate{107.619, 51.8024}, CountryId{"RU"}}, // Komushka stopping point
    {Coordinate{107.553, 51.7761}, CountryId{"RU"}}, // Medvedchikovo railway station
    {Coordinate{107.389, 51.6139}, CountryId{"RU"}}, // Sayantuy railway station
    {Coordinate{107.321, 51.5517}, CountryId{"RU"}}, // Omuluvka stopping point
    {Coordinate{15.0865, 50.7074}, CountryId{"CZ"}}, // Jeřmanice
    {Coordinate{-0.1233, 51.3313}, CountryId{"GB"}}, // Reedham railway station
    {Coordinate{13.6675, 50.2025}, CountryId{"CZ"}}, // Milostín
    {Coordinate{14.0817, 49.8364}, CountryId{"CZ"}}, // Osov
    {Coordinate{17.3614, 49.3208}, CountryId{"CZ"}}, // Postoupky
    {Coordinate{15.2162, 49.841}, CountryId{"CZ"}}, // Černíny
    {Coordinate{12.6075, 50.1539}, CountryId{"CZ"}}, // Hlavno
    {Coordinate{-4.3653, 55.8422}, CountryId{"GB"}}, // Crookston railway station
    {Coordinate{13.5536, 52.5575}, CountryId{"DE"}}, // Mehrower Allee station
    {Coordinate{-2.702, 54.75}, CountryId{"GB"}}, // Lazonby and Kirkoswald railway station
    {Coordinate{-0.242, 51.4671}, CountryId{"GB"}}, // Barnes railway station
    {Coordinate{2.31194, 51.0022}, CountryId{"FR"}}, // Gare de Grande-Synthe
    {Coordinate{60.0889, 57.9543}, CountryId{"RU"}}, // Q19742076
    {Coordinate{60.021, 57.9544}, CountryId{"RU"}}, // Q19742671
    {Coordinate{29.1094, 60.9619}, CountryId{"RU"}}, // Kamennogorsk railway station
    {Coordinate{15.3594, 50.0375}, CountryId{"CZ"}}, // Týnec nad Labem
    {Coordinate{-2.20943, 52.1948}, CountryId{"GB"}}, // Worcester Shrub Hill railway station
    {Coordinate{-0.295278, 51.5722}, CountryId{"GB"}}, // Preston Road tube station
    {Coordinate{-0.19904, 51.4341}, CountryId{"GB"}}, // Wimbledon Park tube station
    {Coordinate{-2.7805, 53.4306}, CountryId{"GB"}}, // Eccleston Park railway station
    {Coordinate{2.20056, 49.9283}, CountryId{"FR"}}, // Gare d'Ailly-sur-Somme
    {Coordinate{14.215, 50.8464}, CountryId{"CZ"}}, // Dolní Žleb railway station
    {Coordinate{-3.86799, 40.4943}, CountryId{"ES"}}, // Las Rozas
    {Coordinate{4.60972, 51.6414}, CountryId{"NL"}}, // Zevenbergen railway station
    {Coordinate{18.9142, 47.6092}, CountryId{"HU"}}, // Vörösvárbánya railway station
    {Coordinate{18.9281, 47.6011}, CountryId{"HU"}}, // Szélhegy railway station
    {Coordinate{-3.395, 54.29}, CountryId{"GB"}}, // Bootle railway station
    {Coordinate{11.5546, 49.4988}, CountryId{"DE"}}, // Hartmannshof station
    {Coordinate{4.22278, 50.955}, CountryId{"BE"}}, // Merchtem railway station
    {Coordinate{-0.555143, 44.7994}, CountryId{"FR"}}, // Gare de Bègles
    {Coordinate{-1.8055, 51.0705}, CountryId{"GB"}}, // Salisbury railway station
    {Coordinate{13.6647, 42.8449}, CountryId{"IT"}}, // Maltignano railway station
    {Coordinate{0.006, 51.769}, CountryId{"GB"}}, // Rye House railway station
    {Coordinate{-1.341, 54.837}, CountryId{"GB"}}, // Seaham railway station
    {Coordinate{-3.441, 50.6625}, CountryId{"GB"}}, // Lympstone Commando railway station
    {Coordinate{5.08168, 50.4972}, CountryId{"BE"}}, // Château-de-Seilles railway station
    {Coordinate{1.3425, 51.27}, CountryId{"GB"}}, // Sandwich railway station
    {Coordinate{6.87695, 48.3672}, CountryId{"FR"}}, // Gare d'Étival-Clairefontaine
    {Coordinate{3.18431, 51.3303}, CountryId{"BE"}}, // Zeebrugge-Strand railway station
    {Coordinate{-2.048, 52.323}, CountryId{"GB"}}, // Bromsgrove railway station
    {Coordinate{18.2517, 52.2314}, CountryId{"PL"}}, // Konin train station
    {Coordinate{15.7561, 50.9028}, CountryId{"PL"}}, // Jelenia Góra train station
    {Coordinate{-3.3765, 51.6817}, CountryId{"GB"}}, // Mountain Ash railway station
    {Coordinate{20.7217, 51.365}, CountryId{"PL"}}, // Skrzynno
    {Coordinate{-1.872, 52.504}, CountryId{"GB"}}, // Aston railway station
    {Coordinate{-0.041, 51.4085}, CountryId{"GB"}}, // Clock House railway station
    {Coordinate{82.8653, 18.3329}, CountryId{"IN"}}, // Araku railway station
    {Coordinate{81.5383, 16.5431}, CountryId{"IN"}}, // Bhimavaram Junction railway station
    {Coordinate{81.5195, 16.5472}, CountryId{"IN"}}, // Bhimavaram town railway station
    {Coordinate{4.96472, 50.2106}, CountryId{"BE"}}, // Gendron-Celles railway station
    {Coordinate{7.5897, 48.0271}, CountryId{"DE"}}, // Breisach station
    {Coordinate{0.6088, 46.9376}, CountryId{"FR"}}, // Gare de Dangé
    {Coordinate{60.0215, 57.8045}, CountryId{"RU"}}, // Monzino
    {Coordinate{37.1583, 57.7806}, CountryId{"RU"}}, // Sonkovo railway station
    {Coordinate{-3.68868, 50.4356}, CountryId{"GB"}}, // Totnes railway station
    {Coordinate{17.0884, 59.6445}, CountryId{"SE"}}, // Enköping railway station
    {Coordinate{3.79528, 50.4358}, CountryId{"BE"}}, // Boussu railway station
    {Coordinate{-118.235, 34.0551}, CountryId{"US"}}, // Los Angeles Union Station
    {Coordinate{-2.049, 52.525}, CountryId{"GB"}}, // Dudley Port railway station
    {Coordinate{73.5224, 17.5425}, CountryId{"IN"}}, // Chiplun railway station
    {Coordinate{-2.1995, 51.2665}, CountryId{"GB"}}, // Westbury railway station
    {Coordinate{6.62349, 47.6991}, CountryId{"FR"}}, // Gare de Ronchamp
    {Coordinate{7.17667, 49.3531}, CountryId{"DE"}}, // Neunkirchen Central Station
    {Coordinate{-3.4371, 51.6174}, CountryId{"GB"}}, // Dinas Rhondda railway station
    {Coordinate{37.7463, 48.0439}, CountryId{"UA"}}, // Donetsk Railway Station
    {Coordinate{-0.0894, 51.4683}, CountryId{"GB"}}, // Denmark Hill railway station
    {Coordinate{4.72099, 50.5514}, CountryId{"BE"}}, // Lonzée railway station
    {Coordinate{81.2869, 27.1214}, CountryId{"IN"}}, // Sundhiamau railway station
    {Coordinate{13.3881, 49.7436}, CountryId{"CZ"}}, // Plzeň hlavní nádraží
    {Coordinate{-0.385, 51.644}, CountryId{"GB"}}, // Bushey railway station
    {Coordinate{7.02889, 49.2164}, CountryId{"DE"}}, // Brebach
    {Coordinate{13.3577, 43.6072}, CountryId{"IT"}}, // Castelferretti-Falconara Aeroporto delle Marche railway halt
    {Coordinate{13.3276, 43.5958}, CountryId{"IT"}}, // Chiaravalle railway halt
    {Coordinate{13.2519, 43.5208}, CountryId{"IT"}}, // Q19819430
    {Coordinate{13.1828, 43.501}, CountryId{"IT"}}, // Q19819431
    {Coordinate{13.0847, 43.4816}, CountryId{"IT"}}, // Q19819433
    {Coordinate{13.0273, 43.445}, CountryId{"IT"}}, // Q19819434
    {Coordinate{12.9774, 43.403}, CountryId{"IT"}}, // Genga-San Vittore Terme railway station
    {Coordinate{12.7844, 43.1819}, CountryId{"IT"}}, // Q19819439
    {Coordinate{12.7339, 42.8763}, CountryId{"IT"}}, // Q19819440
    {Coordinate{12.7615, 42.8228}, CountryId{"IT"}}, // Q19819441
    {Coordinate{12.443, 42.479}, CountryId{"IT"}}, // San Liberato railway halt
    {Coordinate{14.061, 42.3059}, CountryId{"IT"}}, // Manoppello railway station
    {Coordinate{14.0196, 42.2872}, CountryId{"IT"}}, // Alanno railway station
    {Coordinate{13.8762, 42.1023}, CountryId{"IT"}}, // Q19819467
    {Coordinate{8.59696, 40.6989}, CountryId{"IT"}}, // Scala di Giocca railway station
    {Coordinate{6.36528, 51.9217}, CountryId{"NL"}}, // Terborg railway station
    {Coordinate{12.0319, 48.0836}, CountryId{"DE"}}, // Steinhöring station
    {Coordinate{6.94433, 51.2186}, CountryId{"DE"}}, // Hochdahl station
    {Coordinate{8.70806, 50.1128}, CountryId{"DE"}}, // Frankfurt East station
    {Coordinate{21.2294, 55.8867}, CountryId{"LT"}}, // Kretinga train station
    {Coordinate{14.4039, 50.0703}, CountryId{"CZ"}}, // Anděl
    {Coordinate{-2.3107, 51.2263}, CountryId{"GB"}}, // Frome railway station
    {Coordinate{1.91254, 48.1414}, CountryId{"FR"}}, // Gare de Château-Gaillard
    {Coordinate{8.6505, 49.9506}, CountryId{"DE"}}, // Bahnhof Erzhausen
    {Coordinate{7.05007, 49.1188}, CountryId{"DE"}}, // Hanweiler-Bad Rilchingen
    {Coordinate{9.7354, 52.4508}, CountryId{"DE"}}, // Langenhagen Pferdemarkt station
    {Coordinate{8.32381, 48.8895}, CountryId{"DE"}}, // Malsch station
    {Coordinate{12.4503, 52.8531}, CountryId{"DE"}}, // Neustadt (Dosse) station
    {Coordinate{11.2274, 52.0307}, CountryId{"DE"}}, // Oschersleben
    {Coordinate{7.16303, 51.1692}, CountryId{"DE"}}, // Remscheid-Güldenwerth station
    {Coordinate{8.11496, 49.8461}, CountryId{"DE"}}, // Q19835127
    {Coordinate{13.3175, 52.9797}, CountryId{"DE"}}, // Zehdenick (Mark) train station
    {Coordinate{3.28832, 45.7845}, CountryId{"FR"}}, // Gare de Vertaizon
    {Coordinate{13.8633, 45.7042}, CountryId{"SI"}}, // Sežana railway station
    {Coordinate{15.8581, 50.3003}, CountryId{"CZ"}}, // Smiřice
    {Coordinate{6.80819, 51.392}, CountryId{"DE"}}, // Duisburg-Bissingheim station
    {Coordinate{6.71977, 45.9263}, CountryId{"FR"}}, // Chedde railway station
    {Coordinate{10.5628, 50.8628}, CountryId{"DE"}}, // Reinhardsbrunn-Friedrichroda railway station
    {Coordinate{-1.24583, 53.1139}, CountryId{"GB"}}, // Sutton Parkway railway station
    {Coordinate{9.39847, 54.6647}, CountryId{"DE"}}, // Tarp station
    {Coordinate{-5.3834, 56.4524}, CountryId{"GB"}}, // Connel Ferry railway station
    {Coordinate{-1.1783, 51.3961}, CountryId{"GB"}}, // Midgham railway station
    {Coordinate{9.59053, 54.3926}, CountryId{"DE"}}, // Owschlag Station
    {Coordinate{9.85188, 54.1671}, CountryId{"DE"}}, // Nortorf station
    {Coordinate{34.6333, 47.5019}, CountryId{"UA"}}, // Enerhodar
    {Coordinate{3.64179, 49.0791}, CountryId{"FR"}}, // Gare de Dormans
    {Coordinate{-3.1743, 56.0692}, CountryId{"GB"}}, // Kinghorn railway station
    {Coordinate{-0.719, 51.089}, CountryId{"GB"}}, // Haslemere railway station
    {Coordinate{0.166, 52.104}, CountryId{"GB"}}, // Whittlesford Parkway railway station
    {Coordinate{8.81849, 40.6321}, CountryId{"IT"}}, // Ardara railway station
    {Coordinate{8.68706, 40.0206}, CountryId{"IT"}}, // Bauladu-Milis railway station
    {Coordinate{8.76067, 40.4178}, CountryId{"IT"}}, // Bonorva railway station
    {Coordinate{-4.873, 51.667}, CountryId{"GB"}}, // Lamphey railway station
    {Coordinate{-1.858, 52.463}, CountryId{"GB"}}, // Small Heath railway station
    {Coordinate{16.9552, 46.2494}, CountryId{"HU"}}, // Gyékényes railway station
    {Coordinate{-0.1271, 51.438}, CountryId{"GB"}}, // Streatham Hill railway station
    {Coordinate{-2.042, 53.515}, CountryId{"GB"}}, // Mossley railway station
    {Coordinate{9.65182, 52.3232}, CountryId{"DE"}}, // Ronnenberg station
    {Coordinate{9.63528, 52.2981}, CountryId{"DE"}}, // Weetzen station
    {Coordinate{-1.9513, 47.3587}, CountryId{"FR"}}, // Savenay
    {Coordinate{2.29417, 48.7022}, CountryId{"FR"}}, // Longjumeau
    {Coordinate{-88.0789, 41.5244}, CountryId{"US"}}, // Joliet Transportation Center
    {Coordinate{3.00763, 48.9982}, CountryId{"FR"}}, // Gare d'Isles - Armentières - Congis
    {Coordinate{0.095125, 51.7811}, CountryId{"GB"}}, // Harlow Town railway station
    {Coordinate{6.5612, 44.0054}, CountryId{"FR"}}, // Q1988162
    {Coordinate{75.0578, 21.0495}, CountryId{"IN"}}, // Amalner railway station
    {Coordinate{92.5563, 24.8652}, CountryId{"IN"}}, // Badarpur railway station
    {Coordinate{77.5946, 14.1002}, CountryId{"IN"}}, // Penukonda Junction railway station
    {Coordinate{77.7576, 14.1605}, CountryId{"IN"}}, // Sathya Sai Prasanthi Nilayam railway station
    {Coordinate{88.3398, 22.6357}, CountryId{"IN"}}, // Belur railway station
    {Coordinate{76.017, 20.9036}, CountryId{"IN"}}, // Bodwad railway station
    {Coordinate{34.3449, 61.7844}, CountryId{"RU"}}, // Petrozavodsk railway station
    {Coordinate{9.4037, 40.8377}, CountryId{"IT"}}, // Su Canale railway station
    {Coordinate{-1.146, 52.947}, CountryId{"GB"}}, // Nottingham station
    {Coordinate{16.7361, 48.9374}, CountryId{"CZ"}}, // Hustopeče (train station)
    {Coordinate{74.999, 20.4641}, CountryId{"IN"}}, // Chalisgaon Junction railway station
    {Coordinate{74.6237, 24.8743}, CountryId{"IN"}}, // Chittaurgarh Junction railway station
    {Coordinate{84.0748, 24.0331}, CountryId{"IN"}}, // Daltonganj railway station
    {Coordinate{75.2861, 21.0064}, CountryId{"IN"}}, // Dharangaon railway station
    {Coordinate{74.7688, 20.8878}, CountryId{"IN"}}, // Dhule railway station
    {Coordinate{79.4841, 15.8346}, CountryId{"IN"}}, // Donakonda railway station
    {Coordinate{76.7277, 26.469}, CountryId{"IN"}}, // Gangapur City railway station
    {Coordinate{77.7152, 14.4261}, CountryId{"IN"}}, // Dharmavaram Junction railway station
    {Coordinate{77.868, 15.3952}, CountryId{"IN"}}, // Dhone Junction railway station
    {Coordinate{77.6258, 15.1492}, CountryId{"IN"}}, // Gooty Junction railway station
    {Coordinate{78.8292, 14.4517}, CountryId{"IN"}}, // Kadapa railway station
    {Coordinate{79.1141, 13.4511}, CountryId{"IN"}}, // Pakala Junction railway station
    {Coordinate{85.5407, 25.3718}, CountryId{"IN"}}, // Harnaut railway station
    {Coordinate{85.3402, 23.9837}, CountryId{"IN"}}, // Hazaribagh Town railway station
    {Coordinate{74.5096, 15.8492}, CountryId{"IN"}}, // Belagavi railway station
    {Coordinate{74.497, 15.4503}, CountryId{"IN"}}, // Londa Junction railway station
    {Coordinate{17.5769, 50.3294}, CountryId{"PL"}}, // Prudnik
    {Coordinate{77.0691, 11.0172}, CountryId{"IN"}}, // Irugur Junction railway station
    {Coordinate{75.7748, 20.8064}, CountryId{"IN"}}, // Jamner railway station
    {Coordinate{93.1244, 24.7988}, CountryId{"IN"}}, // Jiribam railway station
    {Coordinate{82.9185, 25.6478}, CountryId{"IN"}}, // Kirakat railway station
    {Coordinate{83.5643, 25.9395}, CountryId{"IN"}}, // Mau Junction railway station
    {Coordinate{74.6191, 34.1106}, CountryId{"IN"}}, // Mazhom railway station
    {Coordinate{76.74, 30.6661}, CountryId{"IN"}}, // SAS Nagar Mohali railway station
    {Coordinate{87.8387, 24.2957}, CountryId{"IN"}}, // Nalhati Junction railway station
    {Coordinate{74.2465, 21.3748}, CountryId{"IN"}}, // Nandurbar railway station
    {Coordinate{75.3483, 20.6684}, CountryId{"IN"}}, // Pachora Junction railway station
    {Coordinate{-0.382, 51.687}, CountryId{"GB"}}, // Garston (Hertfordshire) railway station
    {Coordinate{3.0754, 50.612}, CountryId{"FR"}}, // Gare de Lille-Porte-de-Douai
    {Coordinate{79.4351, 18.7633}, CountryId{"IN"}}, // Ramagundam railway station
    {Coordinate{76.0446, 21.2222}, CountryId{"IN"}}, // Raver railway station
    {Coordinate{5.16823, 46.1306}, CountryId{"FR"}}, // Gare de Servas - Lent
    {Coordinate{9.13014, 55.9446}, CountryId{"DK"}}, // Brande Station
    {Coordinate{26.0597, 56.5403}, CountryId{"LV"}}, // Q19896844
    {Coordinate{23.6778, 56.4089}, CountryId{"LV"}}, // Meitene railway station
    {Coordinate{26.252, 56.5421}, CountryId{"LV"}}, // Mežāre railway station
    {Coordinate{27.1514, 56.537}, CountryId{"LV"}}, // Sakstagals railway station
    {Coordinate{26.6368, 56.5659}, CountryId{"LV"}}, // Q19896854
    {Coordinate{35.015, 48.4772}, CountryId{"UA"}}, // Dnipro Railway station
    {Coordinate{-0.391811, 51.6526}, CountryId{"GB"}}, // Watford High Street railway station
    {Coordinate{13.4006, 50.4572}, CountryId{"CZ"}}, // Chomutov
    {Coordinate{83.2205, 17.7447}, CountryId{"IN"}}, // Simhachalam railway station
    {Coordinate{16.3855, 48.2419}, CountryId{"AT"}}, // Handelskai (Vienna U-Bahn)
    {Coordinate{-0.39, 51.676}, CountryId{"GB"}}, // Watford North railway station
    {Coordinate{-3.46377, 50.6856}, CountryId{"GB"}}, // Topsham railway station
    {Coordinate{5.57556, 52.2653}, CountryId{"NL"}}, // Putten railway station
    {Coordinate{2.06972, 48.7025}, CountryId{"FR"}}, // Gare de Saint-Rémy-lès-Chevreuse
    {Coordinate{2.78139, 50.2869}, CountryId{"FR"}}, // Arras railway station
    {Coordinate{36.9003, 55.389}, CountryId{"RU"}}, // 240 km
    {Coordinate{36.9099, 55.3791}, CountryId{"RU"}}, // 241 km
    {Coordinate{107.048, 51.5278}, CountryId{"RU"}}, // 5751 km stopping point
    {Coordinate{106.652, 51.4078}, CountryId{"RU"}}, // 5751 km stopping point
    {Coordinate{106.245, 50.9364}, CountryId{"RU"}}, // 5822 km stopping point
    {Coordinate{37.62, 63.7}, CountryId{"RU"}}, // Nimenga
    {Coordinate{60.6325, 56.8425}, CountryId{"RU"}}, // Q19907082
    {Coordinate{61.1739, 55.0328}, CountryId{"RU"}}, // Butaky
    {Coordinate{106.269, 50.7586}, CountryId{"RU"}}, // Butikha stopping point
    {Coordinate{60.625, 56.7778}, CountryId{"RU"}}, // Uktus railway station
    {Coordinate{48.361, 55.8628}, CountryId{"RU"}}, // Volzhsk railway station
    {Coordinate{106.187, 50.6875}, CountryId{"RU"}}, // Dzhida railway station
    {Coordinate{39.0311, 55.3746}, CountryId{"RU"}}, // Yegorievsk I railway station
    {Coordinate{28.7745, 60.3693}, CountryId{"RU"}}, // Yermilovo
    {Coordinate{49.6014, 54.2261}, CountryId{"RU"}}, // Dimitrovgrad railway station
    {Coordinate{56.0783, 54.9258}, CountryId{"RU"}}, // Q19909402
    {Coordinate{34.6752, 59.4953}, CountryId{"RU"}}, // Yefimovskaya station
    {Coordinate{36.6747, 45.3407}, CountryId{"RU"}}, // Port Kavkaz railway station
    {Coordinate{28.9828, 60.3376}, CountryId{"RU"}}, // Kuolemajärvi station
    {Coordinate{98.9388, 54.9648}, CountryId{"RU"}}, // Q19909810
    {Coordinate{29.2632, 60.1971}, CountryId{"RU"}}, // Mesterjärvi platform
    {Coordinate{105.588, 51.6529}, CountryId{"RU"}}, // Q19910124
    {Coordinate{107.497, 52.011}, CountryId{"RU"}}, // Mostovoy
    {Coordinate{106.311, 51.1861}, CountryId{"RU"}}, // Murtoy stopping point
    {Coordinate{106.102, 50.3883}, CountryId{"RU"}}, // Naushki railway station
    {Coordinate{60.1828, 57.4914}, CountryId{"RU"}}, // Nevyansk
    {Coordinate{30.3769, 59.1869}, CountryId{"RU"}}, // Q19910405
    {Coordinate{47.654, 56.6791}, CountryId{"RU"}}, // Nol'ka railway station
    {Coordinate{47.6467, 56.7758}, CountryId{"RU"}}, // Q19910454
    {Coordinate{131.9, 43.5142}, CountryId{"RU"}}, // Q19910463
    {Coordinate{131.951, 43.4508}, CountryId{"RU"}}, // 9230 km
    {Coordinate{131.951, 43.4414}, CountryId{"RU"}}, // 9232 km
    {Coordinate{-4.7135, 56.4336}, CountryId{"GB"}}, // Tyndrum Lower railway station
    {Coordinate{45.0157, 53.2176}, CountryId{"RU"}}, // Q19910626
    {Coordinate{29.3628, 58.4233}, CountryId{"RU"}}, // Plyussa railway station
    {Coordinate{39.1754, 54.9563}, CountryId{"RU"}}, // Podlipki
    {Coordinate{29.4306, 60.1725}, CountryId{"RU"}}, // Privetnenskoye railway station
    {Coordinate{28.63, 60.3653}, CountryId{"RU"}}, // Primorsk railway station
    {Coordinate{59.9258, 56.8119}, CountryId{"RU"}}, // Q19910901
    {Coordinate{31.2747, 59.7833}, CountryId{"RU"}}, // Rusanovskaya
    {Coordinate{39.5571, 55.1461}, CountryId{"RU"}}, // Ryazanovka
    {Coordinate{106.872, 52.0332}, CountryId{"RU"}}, // Q19911141
    {Coordinate{106.244, 50.8744}, CountryId{"RU"}}, // Selenduma railway station
    {Coordinate{35.7728, 45.2992}, CountryId{"UA"}}, // Sim Kolodiaziv Railway Station
    {Coordinate{59.98, 57.94}, CountryId{"RU"}}, // Smychka
    {Coordinate{106.699, 51.457}, CountryId{"RU"}}, // Sofhoz Telman stopping point
    {Coordinate{60.0249, 57.853}, CountryId{"RU"}}, // Staratel
    {Coordinate{-0.938611, 50.8517}, CountryId{"GB"}}, // Emsworth railway station
    {Coordinate{47.7108, 56.9634}, CountryId{"RU"}}, // Tabashino
    {Coordinate{47.6512, 56.8763}, CountryId{"RU"}}, // Q19915880
    {Coordinate{46.4115, 55.491}, CountryId{"RU"}}, // Shumerlya train station
    {Coordinate{106.158, 50.4806}, CountryId{"RU"}}, // Kharankoy railway station
    {Coordinate{99.3417, 54.7911}, CountryId{"RU"}}, // Q19916091
    {Coordinate{106.195, 50.5739}, CountryId{"RU"}}, // Khuzhir railway station
    {Coordinate{14.2875, 49.9272}, CountryId{"CZ"}}, // Dobřichovice
    {Coordinate{105.216, 56.8566}, CountryId{"RU"}}, // Q19916711
    {Coordinate{73.3233, 61.2898}, CountryId{"RU"}}, // Surgut railway station
    {Coordinate{107.139, 52.1142}, CountryId{"RU"}}, // Q19916827
    {Coordinate{29.1364, 60.2597}, CountryId{"RU"}}, // Tarasovskoye platform
    {Coordinate{107.435, 52.1393}, CountryId{"RU"}}, // Q19916854
    {Coordinate{106.261, 51.0125}, CountryId{"RU"}}, // Temnik stopping point
    {Coordinate{106.849, 51.5004}, CountryId{"RU"}}, // Ubukun railway station
    {Coordinate{57.9138, 53.9343}, CountryId{"RU"}}, // Q19917149
    {Coordinate{55.9254, 54.5657}, CountryId{"RU"}}, // Q19917179
    {Coordinate{4.61276, 50.6383}, CountryId{"BE"}}, // Mont-Saint-Guibert railway station
    {Coordinate{-3.831, 53.28}, CountryId{"GB"}}, // Conwy railway station
    {Coordinate{4.82556, 45.7483}, CountryId{"FR"}}, // Gare de Lyon-Perrache
    {Coordinate{-2.28, 51.746}, CountryId{"GB"}}, // Stonehouse railway station
    {Coordinate{5.59776, 46.7628}, CountryId{"FR"}}, // Gare de Domblans - Voiteur
    {Coordinate{6.67698, 51.3978}, CountryId{"DE"}}, // Bahnhof Rumeln
    {Coordinate{12.2689, 55.5661}, CountryId{"DK"}}, // Karlslunde station
    {Coordinate{0.515833, 49.3514}, CountryId{"FR"}}, // Gare de Pont-Audemer
    {Coordinate{18.9944, 51.5894}, CountryId{"PL"}}, // Zduńska Wola Karsznice
    {Coordinate{8.60167, 56.4917}, CountryId{"DK"}}, // Struer station
    {Coordinate{-2.011, 52.618}, CountryId{"GB"}}, // Bloxwich railway station
    {Coordinate{0.9325, 44.1019}, CountryId{"FR"}}, // Gare de Pommevic
    {Coordinate{4.77365, 51.0373}, CountryId{"BE"}}, // Booischot railway station
    {Coordinate{22.0128, 51.6686}, CountryId{"PL"}}, // Leopoldów
    {Coordinate{15.2323, 46.1545}, CountryId{"SI"}}, // Laško train station
    {Coordinate{9.17937, 40.9239}, CountryId{"IT"}}, // Luras train station
    {Coordinate{1.73068, 41.2206}, CountryId{"ES"}}, // Vilanova i la Geltrú railway station
    {Coordinate{17.0603, 50.785}, CountryId{"PL"}}, // Strzelin train station
    {Coordinate{4.07043, 50.2496}, CountryId{"FR"}}, // Q1994347
    {Coordinate{-0.463, 51.733}, CountryId{"GB"}}, // Apsley railway station
    {Coordinate{0.421255, 46.7039}, CountryId{"FR"}}, // Gare de Dissay
    {Coordinate{6.63707, 46.5207}, CountryId{"CH"}}, // Bessières station
    {Coordinate{6.64149, 46.5264}, CountryId{"CH"}}, // CHUV station
    {Coordinate{-0.188, 51.993}, CountryId{"GB"}}, // Baldock railway station
    {Coordinate{18.1495, 46.37}, CountryId{"HU"}}, // Dombóvár railway station
    {Coordinate{-2.19278, 53.4444}, CountryId{"GB"}}, // Levenshulme railway station
    {Coordinate{-0.562, 51.763}, CountryId{"GB"}}, // Berkhamsted railway station
    {Coordinate{-0.216, 51.764}, CountryId{"GB"}}, // Hatfield railway station
    {Coordinate{3.20838, 44.9329}, CountryId{"FR"}}, // Gare de Loubaresse
    {Coordinate{4.06417, 51.0151}, CountryId{"BE"}}, // Oudegem railway station
    {Coordinate{-0.194, 51.697}, CountryId{"GB"}}, // Potters Bar railway station
    {Coordinate{18.8941, 47.6259}, CountryId{"HU"}}, // Szabadságliget railway station
    {Coordinate{18.8525, 47.6302}, CountryId{"HU"}}, // Pázmáneum railway station
    {Coordinate{18.8463, 47.6377}, CountryId{"HU"}}, // Klotildliget railway station
    {Coordinate{18.8299, 47.6382}, CountryId{"HU"}}, // Piliscsaba railway station
    {Coordinate{18.8184, 47.6478}, CountryId{"HU"}}, // Magdolnavölgy railway station
    {Coordinate{18.9022, 47.6142}, CountryId{"HU"}}, // Pilisvörösvár railway station
    {Coordinate{18.7964, 47.6562}, CountryId{"HU"}}, // Pilisjászfalu railway station
    {Coordinate{18.7913, 47.6739}, CountryId{"HU"}}, // Piliscsév railway station
    {Coordinate{18.7719, 47.688}, CountryId{"HU"}}, // Leányvár railway station
    {Coordinate{1.1989, 51.2409}, CountryId{"GB"}}, // Adisham railway station
    {Coordinate{18.7329, 47.7233}, CountryId{"HU"}}, // Dorog railway station
    {Coordinate{18.7177, 47.7429}, CountryId{"HU"}}, // Esztergom-Kertváros railway station
    {Coordinate{18.7445, 47.7756}, CountryId{"HU"}}, // Esztergom railway station
    {Coordinate{-1.53195, 53.5442}, CountryId{"GB"}}, // Dodworth railway station
    {Coordinate{14.0828, 52.7628}, CountryId{"DE"}}, // Bahnhof Altranft
    {Coordinate{14.14, 52.7158}, CountryId{"DE"}}, // Wriezen station
    {Coordinate{6.70133, 45.9064}, CountryId{"FR"}}, // Saint-Gervais-les-Bains-Le Fayet railway station
    {Coordinate{-0.491, 51.742}, CountryId{"GB"}}, // Hemel Hempstead railway station
    {Coordinate{6.94814, 51.7512}, CountryId{"DE"}}, // Bahnhof Rhade
    {Coordinate{-0.207, 51.902}, CountryId{"GB"}}, // Stevenage railway station
    {Coordinate{6.9062, 51.8092}, CountryId{"DE"}}, // Bahnhof Marbeck-Heiden
    {Coordinate{0.131, 50.99}, CountryId{"GB"}}, // Buxted railway station
    {Coordinate{-0.882882, 48.8463}, CountryId{"FR"}}, // Gare de Vire
    {Coordinate{-1.59639, 48.0469}, CountryId{"FR"}}, // Gare de Vern
    {Coordinate{-2.34327, 53.3959}, CountryId{"GB"}}, // Navigation Road station
    {Coordinate{73.3569, 17.0028}, CountryId{"IN"}}, // Ratnagiri railway station
    {Coordinate{-0.294019, 52.9773}, CountryId{"GB"}}, // Heckington railway station
    {Coordinate{-0.3274, 51.7504}, CountryId{"GB"}}, // St Albans City railway station
    {Coordinate{-3.7192, 55.8224}, CountryId{"GB"}}, // Fauldhouse railway station
    {Coordinate{-2.915, 53.379}, CountryId{"GB"}}, // Mossley Hill railway station
    {Coordinate{12.401, 50.2534}, CountryId{"CZ"}}, // Luby u Chebu
    {Coordinate{5.37548, 45.5611}, CountryId{"FR"}}, // Q1998901
    {Coordinate{-3.9261, 55.7721}, CountryId{"GB"}}, // Wishaw railway station
    {Coordinate{1.87558, 48.8594}, CountryId{"FR"}}, // Gare de Beynes
    {Coordinate{7.49314, 43.7748}, CountryId{"FR"}}, // Gare de Menton
    {Coordinate{-0.646, 51.524}, CountryId{"GB"}}, // Burnham railway station
    {Coordinate{-0.844, 51.718}, CountryId{"GB"}}, // Princes Risborough
    {Coordinate{32.9107, 57.0195}, CountryId{"RU"}}, // Sigovo
    {Coordinate{2.43528, 48.7717}, CountryId{"FR"}}, // Créteil-Pompadour (Paris RER)
    {Coordinate{16.0994, 53.7711}, CountryId{"PL"}}, // Q2000658
    {Coordinate{-75.1544, 39.9975}, CountryId{"US"}}, // North Philadelphia station
    {Coordinate{13.5987, 42.8505}, CountryId{"IT"}}, // San Filippo railway halt
    {Coordinate{9.58761, 41.0107}, CountryId{"IT"}}, // Cala Sabina railway station
    {Coordinate{9.43107, 40.8571}, CountryId{"IT"}}, // Enas railway station
    {Coordinate{9.04604, 40.672}, CountryId{"IT"}}, // Madonna di Castro railway station
    {Coordinate{10.723, 44.8457}, CountryId{"IT"}}, // Novellara railway station
    {Coordinate{8.98649, 40.6274}, CountryId{"IT"}}, // Ozieri-Fraigas railway station
    {Coordinate{9.53111, 40.9941}, CountryId{"IT"}}, // Rudalza railway station
    {Coordinate{16.2074, 38.1757}, CountryId{"IT"}}, // Ardore railway station
    {Coordinate{11.8584, 43.4632}, CountryId{"IT"}}, // Arezzo-Pescaiola train station
    {Coordinate{8.01835, 45.19}, CountryId{"IT"}}, // Q20009382
    {Coordinate{8.52063, 45.0871}, CountryId{"IT"}}, // Borgo San Martino railway station
    {Coordinate{15.9239, 37.9303}, CountryId{"IT"}}, // Bova Marina railway station
    {Coordinate{8.44053, 45.1604}, CountryId{"IT"}}, // Casale Popolo railway station
    {Coordinate{16.8908, 40.4292}, CountryId{"IT"}}, // Castellaneta Marina railway station
    {Coordinate{15.8749, 37.9277}, CountryId{"IT"}}, // Condofuri train station
    {Coordinate{8.10717, 45.1942}, CountryId{"IT"}}, // Crescentino railway station
    {Coordinate{10.8507, 45.6015}, CountryId{"IT"}}, // Dolcè railway station
    {Coordinate{16.1345, 38.0163}, CountryId{"IT"}}, // Ferruzzano train station
    {Coordinate{8.18873, 45.1912}, CountryId{"IT"}}, // Q20009400
    {Coordinate{14.2881, 42.4215}, CountryId{"IT"}}, // Francavilla al Mare railway station
    {Coordinate{8.56095, 45.0561}, CountryId{"IT"}}, // Giarole railway station
    {Coordinate{16.8908, 40.4292}, CountryId{"IT"}}, // Ginosa railway station
    {Coordinate{12.5545, 45.7844}, CountryId{"IT"}}, // Gorgo al Monticano railway halt
    {Coordinate{12.0134, 44.8041}, CountryId{"IT"}}, // Massafiscaglia railway station
    {Coordinate{11.9385, 44.7693}, CountryId{"IT"}}, // Migliarino railway station
    {Coordinate{11.975, 44.7951}, CountryId{"IT"}}, // Migliaro railway station
    {Coordinate{12.6973, 43.9775}, CountryId{"IT"}}, // Misano Adriatico railway station
    {Coordinate{13.6463, 43.2893}, CountryId{"IT"}}, // Montecosaro railway station
    {Coordinate{8.36619, 45.1707}, CountryId{"IT"}}, // Morano sul Po railway station
    {Coordinate{13.5828, 43.2792}, CountryId{"IT"}}, // Q20009421
    {Coordinate{8.12018, 44.7228}, CountryId{"IT"}}, // Q20009422
    {Coordinate{8.23281, 45.189}, CountryId{"IT"}}, // Q20009427
    {Coordinate{15.9864, 37.9188}, CountryId{"IT"}}, // Q20009428
    {Coordinate{8.42675, 45.2333}, CountryId{"IT"}}, // Pertengo railway station
    {Coordinate{8.72806, 40.6613}, CountryId{"IT"}}, // Ploaghe railway station
    {Coordinate{12.4605, 45.7193}, CountryId{"IT"}}, // Q20009436
    {Coordinate{15.6517, 38.0672}, CountryId{"IT"}}, // Reggio di Calabria Aeroporto railway station
    {Coordinate{15.6386, 38.0057}, CountryId{"IT"}}, // Reggio di Calabria Bocale train station
    {Coordinate{15.651, 38.0587}, CountryId{"IT"}}, // Reggio di Calabria San Gregorio train station
    {Coordinate{16.6156, 40.1001}, CountryId{"IT"}}, // Rocca Imperiale railway station
    {Coordinate{13.5012, 45.8183}, CountryId{"IT"}}, // Ronchi dei Legionari Sud railway station
    {Coordinate{12.3774, 45.6867}, CountryId{"IT"}}, // Q20009451
    {Coordinate{8.41232, 45.1015}, CountryId{"IT"}}, // San Giorgio Casale railway halt
    {Coordinate{8.95603, 40.8692}, CountryId{"IT"}}, // Scala Ruia train station
    {Coordinate{13.8758, 41.1961}, CountryId{"IT"}}, // Sessa Aurunca-Roccamonfina train station
    {Coordinate{7.96952, 45.1931}, CountryId{"IT"}}, // Verolengo railway station
    {Coordinate{14.7278, 40.6742}, CountryId{"IT"}}, // Vietri sul Mare-Amalfi railway station
    {Coordinate{10.698, 44.8058}, CountryId{"IT"}}, // Vezzola railway halt
    {Coordinate{8.47044, 44.8312}, CountryId{"IT"}}, // Carentino railway halt
    {Coordinate{16.3308, 38.3001}, CountryId{"IT"}}, // Gioiosa Jonica train station
    {Coordinate{14.0687, 42.6077}, CountryId{"IT"}}, // Pineto-Atri train station
    {Coordinate{14.0413, 42.6424}, CountryId{"IT"}}, // Q20009826
    {Coordinate{14.3397, 42.3939}, CountryId{"IT"}}, // Tollo-Canosa Sannita railway halt
    {Coordinate{16.144, 38.0527}, CountryId{"IT"}}, // Africo Nuovo railway station
    {Coordinate{16.5676, 38.5722}, CountryId{"IT"}}, // Badolato railway station
    {Coordinate{16.1532, 38.0891}, CountryId{"IT"}}, // Bianco railway station
    {Coordinate{8.80953, 40.2189}, CountryId{"IT"}}, // Borore train station
    {Coordinate{16.1806, 38.1491}, CountryId{"IT"}}, // Q20009909
    {Coordinate{16.1033, 37.9654}, CountryId{"IT"}}, // Brancaleone train station
    {Coordinate{13.0575, 43.2104}, CountryId{"IT"}}, // Q20009918
    {Coordinate{16.2648, 38.2332}, CountryId{"IT"}}, // Locri railway station
    {Coordinate{16.5977, 40.0408}, CountryId{"IT"}}, // Monte Giordano railway station
    {Coordinate{16.5418, 38.7286}, CountryId{"IT"}}, // Montepaone-Montauro train station
    {Coordinate{8.87589, 40.5559}, CountryId{"IT"}}, // Mores-Ittireddu railway station
    {Coordinate{16.6029, 39.9338}, CountryId{"IT"}}, // Amendolara-Oriolo railway station
    {Coordinate{8.74101, 39.6112}, CountryId{"IT"}}, // Pabillonis railway station
    {Coordinate{8.77582, 40.0773}, CountryId{"IT"}}, // Paulilatino railway station
    {Coordinate{15.7108, 37.9387}, CountryId{"IT"}}, // Saline di Reggio railway station
    {Coordinate{16.302, 38.2708}, CountryId{"IT"}}, // Siderno railway station
    {Coordinate{8.6798, 39.9525}, CountryId{"IT"}}, // Solarussa railway station
    {Coordinate{12.6688, 42.9844}, CountryId{"IT"}}, // Spello train station
    {Coordinate{8.78162, 40.4827}, CountryId{"IT"}}, // Torralba railway station
    {Coordinate{16.5321, 39.8656}, CountryId{"IT"}}, // Trebisacce railway station
    {Coordinate{8.69631, 39.6926}, CountryId{"IT"}}, // Uras-Mogoro railway station
    {Coordinate{16.4906, 39.8105}, CountryId{"IT"}}, // Villapiana Lido railway station
    {Coordinate{16.4794, 39.7906}, CountryId{"IT"}}, // Villapiana-Torre Cerchiara railway station
    {Coordinate{6.62887, 46.5149}, CountryId{"CH"}}, // Grancy station
    {Coordinate{8.28254, 47.0706}, CountryId{"CH"}}, // Emmenbrücke railway station
    {Coordinate{-1.31156, 53.5188}, CountryId{"GB"}}, // Bolton-on-Dearne railway station
    {Coordinate{6.62965, 46.5176}, CountryId{"CH"}}, // Lausanne-Gare station
    {Coordinate{6.62664, 46.5075}, CountryId{"CH"}}, // Ouchy-Olympique station
    {Coordinate{6.63266, 46.5229}, CountryId{"CH"}}, // Riponne–Maurice Béjart station
    {Coordinate{-1.623, 53.526}, CountryId{"GB"}}, // Penistone railway station
    {Coordinate{6.64068, 46.5212}, CountryId{"CH"}}, // Ours station
    {Coordinate{-0.0987, 51.3469}, CountryId{"GB"}}, // Purley Oaks railway station
    {Coordinate{14.5987, 50.0817}, CountryId{"CZ"}}, // Praha-Běchovice
    {Coordinate{7.79211, 47.5512}, CountryId{"CH"}}, // Rheinfelden railway station
    {Coordinate{10.3827, 53.8054}, CountryId{"DE"}}, // Bad Oldesloe railway station
    {Coordinate{14.1914, 45.6753}, CountryId{"SI"}}, // Pivka railway station
    {Coordinate{3.03161, 49.0217}, CountryId{"FR"}}, // Gare de Lizy-sur-Ourcq
    {Coordinate{2.03517, 50.3783}, CountryId{"FR"}}, // Gare d'Hesdin
    {Coordinate{14.2211, 45.7731}, CountryId{"SI"}}, // Postojna railway station
    {Coordinate{5.7875, 51.4561}, CountryId{"NL"}}, // Deurne railway station
    {Coordinate{2.88891, 48.6137}, CountryId{"FR"}}, // Gare de Mormant
    {Coordinate{7.17432, 50.7098}, CountryId{"DE"}}, // Oberkassel Süd/Römlinghoven
    {Coordinate{7.08151, 50.7365}, CountryId{"DE"}}, // Bonn West
    {Coordinate{1.144, 52.051}, CountryId{"GB"}}, // Ipswich railway station
    {Coordinate{7.10246, 50.7374}, CountryId{"DE"}}, // Bertha-von-Suttner-Platz
    {Coordinate{6.77167, 45.6