{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetNeedsDepth: Boolean;
    procedure SetNeedsDepth(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdNeedsDepth: TSFBool;
    { Internal wrapper for property @code(NeedsDepth). This wrapper API may change, we advise to access simpler @code(NeedsDepth) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNeedsDepth: TSFBool read FFdNeedsDepth;
    {  }
    property NeedsDepth: Boolean read GetNeedsDepth write SetNeedsDepth;

    strict private FFdShaders: TMFNode;
    { Internal wrapper for property @code(Shaders). This wrapper API may change, we advise to access simpler @code(Shaders) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShaders: TMFNode read FFdShaders;
    {  }
    procedure SetShaders(const Value: array of TAbstractShaderNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TScreenEffectNode ----------------------------------------------- }

function TScreenEffectNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TScreenEffectNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TScreenEffectNode.GetNeedsDepth: Boolean;
begin
  Result := FdNeedsDepth.Value;
end;

procedure TScreenEffectNode.SetNeedsDepth(const Value: Boolean);
begin
  FdNeedsDepth.Send(Value);
end;

procedure TScreenEffectNode.SetShaders(const Value: array of TAbstractShaderNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractShaderNode));
  FdShaders.Send(A);
end;

class function TScreenEffectNode.ClassX3DType: String;
begin
  Result := 'ScreenEffect';
end;

procedure TScreenEffectNode.CreateNode;
begin
  inherited;

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chScreenEffectEnabled;
  AddField(FFdEnabled);

  FFdNeedsDepth := TSFBool.Create(Self, True, 'needsDepth', false);
   FdNeedsDepth.ChangeAlways := chRedisplay;
  AddField(FFdNeedsDepth);

  FFdShaders := TMFNode.Create(Self, True, 'shaders', [TAbstractShaderNode]);
   FdShaders.ChangeAlways := chEverything;
  AddField(FFdShaders);
end;

{$endif read_implementation}
