{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetKeyValueQuaternions: Boolean;
    procedure SetKeyValueQuaternions(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdKeyValue: TMFRotation;
    { Internal wrapper for property @code(KeyValue). This wrapper API may change, we advise to access simpler @code(KeyValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKeyValue: TMFRotation read FFdKeyValue;
    {  }
    procedure SetKeyValue(const Value: array of TVector4); overload;
    {  }
    procedure SetKeyValue(const Value: TVector4List); overload;

    strict private FEventValue_changed: TSFRotationEvent;
    {  }
    public property EventValue_changed: TSFRotationEvent read FEventValue_changed;

    strict private FFdKeyValueQuaternions: TSFBool;
    { Internal wrapper for property @code(KeyValueQuaternions). This wrapper API may change, we advise to access simpler @code(KeyValueQuaternions) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKeyValueQuaternions: TSFBool read FFdKeyValueQuaternions;
    { When @true, key values are provided as unit quaternions. By default (when @false) they have to be axis angle rotations. This allows extra optimization in case your input data is in quaternions, which is true in case of glTF. It is then most efficient to just put quternions in TOrientationInterpolatorNode.FdKeyValue and set this to @true.  Otherwise, you would 1. needlessly convert quaternion -> axisangle when reading glTF file, 2. needlessly convert axisangle -> quaternion as a first step of SLerp. }
    property KeyValueQuaternions: Boolean read GetKeyValueQuaternions write SetKeyValueQuaternions;

{$endif read_interface}

{$ifdef read_implementation}

{ TOrientationInterpolatorNode ----------------------------------------------- }

procedure TOrientationInterpolatorNode.SetKeyValue(const Value: array of TVector4);
begin
  FdKeyValue.Send(Value);
end;

procedure TOrientationInterpolatorNode.SetKeyValue(const Value: TVector4List);
begin
  FdKeyValue.Send(Value);
end;

function TOrientationInterpolatorNode.GetKeyValueQuaternions: Boolean;
begin
  Result := FdKeyValueQuaternions.Value;
end;

procedure TOrientationInterpolatorNode.SetKeyValueQuaternions(const Value: Boolean);
begin
  FdKeyValueQuaternions.Send(Value);
end;

class function TOrientationInterpolatorNode.ClassX3DType: String;
begin
  Result := 'OrientationInterpolator';
end;

procedure TOrientationInterpolatorNode.CreateNode;
begin
  inherited;

  FFdKeyValue := TMFRotation.Create(Self, True, 'keyValue', []);
   FdKeyValue.ChangeAlways := chNone;
  AddField(FFdKeyValue);

  FEventValue_changed := TSFRotationEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdKeyValueQuaternions := TSFBool.Create(Self, True, 'keyValueQuaternions', false);
   FdKeyValueQuaternions.ChangeAlways := chNone;
  AddField(FFdKeyValueQuaternions);
end;

{$endif read_implementation}
