{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdData: TMFNode;
    { Internal wrapper for property @code(Data). This wrapper API may change, we advise to access simpler @code(Data) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdData: TMFNode read FFdData;
    {  }
    procedure SetData(const Value: array of TAbstractNode);

    strict private FFdSummary: TMFString;
    { Internal wrapper for property @code(Summary). This wrapper API may change, we advise to access simpler @code(Summary) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSummary: TMFString read FFdSummary;
    {  }
    procedure SetSummary(const Value: array of string); overload;
    {  }
    procedure SetSummary(const Value: TCastleStringList); overload;

    strict private FFdUrl: TMFString;
    { Internal wrapper for property @code(Url). This wrapper API may change, we advise to access simpler @code(Url) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUrl: TMFString read FFdUrl;
    {  }
    procedure SetUrl(const Value: array of string); overload;
    {  }
    procedure SetUrl(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoMetadataNode ----------------------------------------------- }

procedure TGeoMetadataNode.SetData(const Value: array of TAbstractNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNode));
  FdData.Send(A);
end;

procedure TGeoMetadataNode.SetSummary(const Value: array of string);
begin
  FdSummary.Send(Value);
end;

procedure TGeoMetadataNode.SetSummary(const Value: TCastleStringList);
begin
  FdSummary.Send(Value);
end;

procedure TGeoMetadataNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TGeoMetadataNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

class function TGeoMetadataNode.ClassX3DType: String;
begin
  Result := 'GeoMetadata';
end;

procedure TGeoMetadataNode.CreateNode;
begin
  inherited;

  FFdData := TMFNode.Create(Self, True, 'data', [TAbstractNode]);
   FdData.ChangeAlways := chNone;
  AddField(FFdData);

  FFdSummary := TMFString.Create(Self, True, 'summary', []);
   FdSummary.ChangeAlways := chNone;
  AddField(FFdSummary);

  FFdUrl := TMFString.Create(Self, True, 'url', []);
   FdUrl.ChangeAlways := chNone;
  AddField(FFdUrl);
end;

{$endif read_implementation}
