#!/usr/bin/env bash
#Title........: language_strings.sh
#Description..: All the translated strings that airgeddon uses are located here.
#Author.......: v1s1t0r
#Bash Version.: 4.2 or later

#Set language_strings file version
#shellcheck disable=SC2034
function set_language_strings_version() {

	debug_print

	language_strings_version="11.40-1"
}

#Set different language text strings
#shellcheck disable=SC2154,SC2034
function initialize_language_strings() {

	debug_print

	if [[ "$(declare -p wps_data_array 2> /dev/null)" != "declare -A"* ]]; then
		declare -gA wps_data_array
	fi

	if [[ "$(declare -p interfaces_band_info 2> /dev/null)" != "declare -A"* ]]; then
		declare -gA interfaces_band_info
	fi

	if [[ "$(declare -p function_hooks 2> /dev/null)" != "declare -A"* ]]; then
		declare -gA function_hooks
	fi

	declare -A unknown_chipset
	unknown_chipset["ENGLISH"]="Unknown"
	unknown_chipset["SPANISH"]="Desconocido"
	unknown_chipset["FRENCH"]="Inconnu"
	unknown_chipset["CATALAN"]="Desconegut"
	unknown_chipset["PORTUGUESE"]="Desconhecido"
	unknown_chipset["RUSSIAN"]="Неизвестно"
	unknown_chipset["GREEK"]="Άγνωστο"
	unknown_chipset["ITALIAN"]="Sconosciuto"
	unknown_chipset["POLISH"]="Nieznany"
	unknown_chipset["GERMAN"]="Unbekannt"
	unknown_chipset["TURKISH"]="Bilinmeyen"
	unknown_chipset["ARABIC"]="مجهول"
	unknown_chipset["CHINESE"]="未知的"
	unknown_chipsetvar="${unknown_chipset[${language}]}"

	declare -A hintprefix
	hintprefix["ENGLISH"]="Hint"
	hintprefix["SPANISH"]="Consejo"
	hintprefix["FRENCH"]="Conseil"
	hintprefix["CATALAN"]="Consell"
	hintprefix["PORTUGUESE"]="Conselho"
	hintprefix["RUSSIAN"]="Подсказка"
	hintprefix["GREEK"]="Συμβουλή"
	hintprefix["ITALIAN"]="Consiglio"
	hintprefix["POLISH"]="Wskazówka"
	hintprefix["GERMAN"]="Tipp"
	hintprefix["TURKISH"]="İpucu"
	hintprefix["ARABIC"]="تلميح"
	hintprefix["CHINESE"]="提示"
	hintvar="*${hintprefix[${language}]}*"
	escaped_hintvar="\*${hintprefix[${language}]}\*"

	declare -A optionaltool_needed
	optionaltool_needed["ENGLISH"]="Locked option, it needs: "
	optionaltool_needed["SPANISH"]="Opción bloqueada, requiere: "
	optionaltool_needed["FRENCH"]="Option bloquée parce qu’il manque: "
	optionaltool_needed["CATALAN"]="Opció bloquejada, necessita: "
	optionaltool_needed["PORTUGUESE"]="Opção bloqueada requer: "
	optionaltool_needed["RUSSIAN"]="Опция заблокирована, требуется: "
	optionaltool_needed["GREEK"]="Κλειδωμένη επιλογή, χρειάζεται: "
	optionaltool_needed["ITALIAN"]="Opzione bloccata, richiede: "
	optionaltool_needed["POLISH"]="Opcja zablokowana, wymaga: "
	optionaltool_needed["GERMAN"]="Option gesperrt, folgendes ist erfordert: "
	optionaltool_needed["TURKISH"]="Engellenen seçenek şunları gerektirir: "
	optionaltool_needed["ARABIC"]=":خيار مغلق يتطلب"
	optionaltool_needed["CHINESE"]="锁定选项，它需要:"

	declare -gA under_construction
	under_construction["ENGLISH"]="under construction"
	under_construction["SPANISH"]="en construcción"
	under_construction["FRENCH"]="en construction"
	under_construction["CATALAN"]="en construcció"
	under_construction["PORTUGUESE"]="em construção"
	under_construction["RUSSIAN"]="на ремонте"
	under_construction["GREEK"]="υπό κατασκευή"
	under_construction["ITALIAN"]="in costruzione"
	under_construction["POLISH"]="w budowie"
	under_construction["GERMAN"]="im Aufbau"
	under_construction["TURKISH"]="yapım aşamasında"
	under_construction["ARABIC"]="في طور الإنشاء"
	under_construction["CHINESE"]="正在准备"

	declare -gA possible_package_names_text
	possible_package_names_text["ENGLISH"]="Possible package name"
	possible_package_names_text["SPANISH"]="Posible nombre del paquete"
	possible_package_names_text["FRENCH"]="Possible nom du paquet"
	possible_package_names_text["CATALAN"]="Possible nom del paquet"
	possible_package_names_text["PORTUGUESE"]="Possível nome do pacote"
	possible_package_names_text["RUSSIAN"]="Возможное имя пакета"
	possible_package_names_text["GREEK"]="Πιθανό όνομα πακέτου"
	possible_package_names_text["ITALIAN"]="Possibile nome del pacchetto"
	possible_package_names_text["POLISH"]="Możliwa nazwa pakietu"
	possible_package_names_text["GERMAN"]="Möglicher Paketname"
	possible_package_names_text["TURKISH"]="Olası paket adı"
	possible_package_names_text["ARABIC"]="اسم الحزمة المحتمل"
	possible_package_names_text["CHINESE"]="可能的软件包名称"

	declare -gA disabled_text
	disabled_text["ENGLISH"]="Disabled"
	disabled_text["SPANISH"]="Desactivado"
	disabled_text["FRENCH"]="Désactivé"
	disabled_text["CATALAN"]="Desactivat"
	disabled_text["PORTUGUESE"]="Desativado"
	disabled_text["RUSSIAN"]="Отключено"
	disabled_text["GREEK"]="Απενεργοποιημένο"
	disabled_text["ITALIAN"]="Disattivato"
	disabled_text["POLISH"]="Dezaktywowany"
	disabled_text["GERMAN"]="Deaktiviert"
	disabled_text["TURKISH"]="Aktif Değil"
	disabled_text["ARABIC"]="معطل"
	disabled_text["CHINESE"]="禁用"

	declare -gA reboot_required
	reboot_required["ENGLISH"]="${red_color_slim} (reboot required)${normal_color}"
	reboot_required["SPANISH"]="${red_color_slim} (reinicio requerido)${normal_color}"
	reboot_required["FRENCH"]="${red_color_slim} (redémarrage requis)${normal_color}"
	reboot_required["CATALAN"]="${red_color_slim} (reinici requerit)${normal_color}"
	reboot_required["PORTUGUESE"]="${red_color_slim} (é necessário reiniciar)${normal_color}"
	reboot_required["RUSSIAN"]="${red_color_slim} (требуется перезагрузка)${normal_color}"
	reboot_required["GREEK"]="${red_color_slim} (απαιτείται επανεκκίνηση)${normal_color}"
	reboot_required["ITALIAN"]="${red_color_slim} (riavvio richiesto)${normal_color}"
	reboot_required["POLISH"]="${red_color_slim} (wymagane ponowne uruchomienie)${normal_color}"
	reboot_required["GERMAN"]="${red_color_slim} (Neustart erforderlich)${normal_color}"
	reboot_required["TURKISH"]="${red_color_slim} (yeniden başlatma gerekli)${normal_color}"
	reboot_required["ARABIC"]="${red_color_slim} (المطلوب إعادة التشغيل) ${normal_color}"
	reboot_required["CHINESE"]="${red_color_slim} (需要重启) ${normal_color}"

	declare -gA docker_image
	docker_image["ENGLISH"]="${docker_based_distro} Docker image based"
	docker_image["SPANISH"]="Basado en imagen de Docker de ${docker_based_distro}"
	docker_image["FRENCH"]="Fondé sur l'image de Docker d'${docker_based_distro}"
	docker_image["CATALAN"]="Basat en imatge de Docker de ${docker_based_distro}"
	docker_image["PORTUGUESE"]="Baseado na imagem Docker do ${docker_based_distro}"
	docker_image["RUSSIAN"]="Основано на образе ${docker_based_distro} Docker"
	docker_image["GREEK"]="Με βάση to ${docker_based_distro} Docker image"
	docker_image["ITALIAN"]="Basato sull'immagine di Docker di ${docker_based_distro}"
	docker_image["POLISH"]="Na podstawie obrazu ${docker_based_distro} Docker"
	docker_image["GERMAN"]="Auf dem ${docker_based_distro} Docker-Image"
	docker_image["TURKISH"]="${docker_based_distro} Docker image tabanlı"
	docker_image["ARABIC"]="Docker ${docker_based_distro} الصورة مبنية على"
	docker_image["CHINESE"]="${docker_based_distro} 基于 Docker 镜像"

	declare -gA et_misc_texts
	et_misc_texts["ENGLISH",0]="Evil Twin AP Info"
	et_misc_texts["SPANISH",0]="Info Evil Twin AP"
	et_misc_texts["FRENCH",0]="Info Evil Twin AP"
	et_misc_texts["CATALAN",0]="Info Evil Twin AP"
	et_misc_texts["PORTUGUESE",0]="Informações do AP Evil Twin"
	et_misc_texts["RUSSIAN",0]="Информация о Злом Двойнике ТД"
	et_misc_texts["GREEK",0]="Πληροφορίες Evil Twin AP"
	et_misc_texts["ITALIAN",0]="Info Evil Twin AP"
	et_misc_texts["POLISH",0]="Informacja Evil Twin AP"
	et_misc_texts["GERMAN",0]="Information über Evil Twin AP"
	et_misc_texts["TURKISH",0]="Şeytani İkiz"
	et_misc_texts["ARABIC",0]="Evil Twin AP معلومات"
	et_misc_texts["CHINESE",0]="邪恶双胞胎 AP 信息"

	et_misc_texts["ENGLISH",1]="Channel"
	et_misc_texts["SPANISH",1]="Canal"
	et_misc_texts["FRENCH",1]="Canal"
	et_misc_texts["CATALAN",1]="Canal"
	et_misc_texts["PORTUGUESE",1]="Canal"
	et_misc_texts["RUSSIAN",1]="Канал"
	et_misc_texts["GREEK",1]="Κανάλι"
	et_misc_texts["ITALIAN",1]="Canale"
	et_misc_texts["POLISH",1]="Kanał"
	et_misc_texts["GERMAN",1]="Kanal"
	et_misc_texts["TURKISH",1]="Kanal"
	et_misc_texts["ARABIC",1]="قناة"
	et_misc_texts["CHINESE",1]="信道"

	et_misc_texts["ENGLISH",2]="Online time"
	et_misc_texts["SPANISH",2]="Tiempo online"
	et_misc_texts["FRENCH",2]="Temps en ligne"
	et_misc_texts["CATALAN",2]="Temps online"
	et_misc_texts["PORTUGUESE",2]="Tempo online"
	et_misc_texts["RUSSIAN",2]="Время онлайн"
	et_misc_texts["GREEK",2]="Χρόνος σε σύνδεση"
	et_misc_texts["ITALIAN",2]="Tempo online"
	et_misc_texts["POLISH",2]="Czas online"
	et_misc_texts["GERMAN",2]="Zeit online"
	et_misc_texts["TURKISH",2]="Çevrimiçi zaman"
	et_misc_texts["ARABIC",2]="الوقت على الانترنت"
	et_misc_texts["CHINESE",2]="在线时间"

	et_misc_texts["ENGLISH",3]="DHCP ips given to possible connected clients"
	et_misc_texts["SPANISH",3]="Ips entregadas por DHCP a posibles clientes conectados"
	et_misc_texts["FRENCH",3]="Ips attribuées à d'éventuels clients DHCP"
	et_misc_texts["CATALAN",3]="Ips lliurades per DHCP a possibles clients connectats"
	et_misc_texts["PORTUGUESE",3]="Ips entregues pelo DHCP aos possíveis clientes conectados"
	et_misc_texts["RUSSIAN",3]="IP, которые DHCP будет давать возможным подключённым клиентам"
	et_misc_texts["GREEK",3]="DHCP IP διευθύνσεις που έχουν δωθεί σε πιθανούς συνδεδεμένους χρήστες"
	et_misc_texts["ITALIAN",3]="Ips forniti dal DHCP a possibili clienti collegati"
	et_misc_texts["POLISH",3]="Adresy IP przydzielane przez DHCP do połączonych potencjalnych klientów"
	et_misc_texts["GERMAN",3]="IPs durch DHCP an mögliche verbundene Clients geliefert"
	et_misc_texts["TURKISH",3]="Olası bağlanmış istemcilere verilen DHCP IPler"
	et_misc_texts["ARABIC",3]="المحتملين DHCP مخصصة لزبناء Ips"
	et_misc_texts["CHINESE",3]="DHCP 服务器分配 IP 地址给可能连接的设备"

	et_misc_texts["ENGLISH",4]="On this attack you have to use an external sniffer to try to obtain client passwords connected to the network"
	et_misc_texts["SPANISH",4]="Con este ataque has de usar un sniffer externo para intentar obtener contraseñas de los clientes conectados a la red"
	et_misc_texts["FRENCH",4]="Avec cette attaque, vous devez utiliser un sniffeur pour tenter d'obtenir les mots de passe des clients connectés au réseau"
	et_misc_texts["CATALAN",4]="Amb aquest atac has d'utilitzar un sniffer extern per intentar obtenir contrasenyes dels clients connectats a la xarxa"
	et_misc_texts["PORTUGUESE",4]="Com este ataque você tem que usar um sniffer externo para tentar obter as senhas dos clientes conectados à rede"
	et_misc_texts["RUSSIAN",4]="С этой атакой вам нужно использовать внешний сниффер для попытки получить пароли клиентов, подключённых к сети"
	et_misc_texts["GREEK",4]="Με αυτή την επίθεση θα πρέπει να χρησιμοποιήσετε έναν εξωτερικό sniffer για να μπορέσετε να υποκλέψετε κωδικούς πρόσβασης από τους χρήστες που είναι συνδεδεμένοι στο δίκτυο"
	et_misc_texts["ITALIAN",4]="Con questo attacco è necessario utilizzare uno sniffer esterno per cercare di ottenere le password dei clienti connessi alla rete"
	et_misc_texts["POLISH",4]="W tym ataku musisz użyć zewnętrznego sniffera, aby spróbować uzyskać hasła od klientów podłączonych do sieci"
	et_misc_texts["GERMAN",4]="Für diesen Angriff ist ein externer Sniffer erforderlich um Passwörter von am Netzwerk verbundenen Clients zu stehlen"
	et_misc_texts["TURKISH",4]="Bu saldırı sonucunda ağa bağlı client şifrelerini edinmek için harici bir algılayıcı kullanmanız gerekir"
	et_misc_texts["ARABIC",4]="مع هذا الهجوم ، يجب عليك استخدام المتشمم لمحاولة الحصول على كلمات مرور الزبناء المتصلين بالشبكة"
	et_misc_texts["CHINESE",4]="在这种攻击中，您必须使用外部嗅探器来尝试获取连接到网络的客户端密码"

	et_misc_texts["ENGLISH",5]="On this attack, watch the sniffer's screen to see if a password appears"
	et_misc_texts["SPANISH",5]="Con este ataque, estate atento a la pantalla del sniffer para ver si aparece alguna contraseña"
	et_misc_texts["FRENCH",5]="Vérifiez pendant l'attaque dans la console du sniffeur si un mot de passe a été capturé"
	et_misc_texts["CATALAN",5]="Amb aquest atac, estigues atent a la pantalla de l'sniffer per veure si apareix alguna contrasenya"
	et_misc_texts["PORTUGUESE",5]="Com este ataque, fique atento na tela do sniffer para ver se aparece alguma senha"
	et_misc_texts["RUSSIAN",5]="С этой атакой смотрите на окно сниффера, чтобы следить за появлением пароля"
	et_misc_texts["GREEK",5]="Με αυτή την επίθεση, παρακολουθήστε την οθόνη του sniffer για να δείτε αν εχει εμφανιστεί κάποιος κωδικός πρόσβασης"
	et_misc_texts["ITALIAN",5]="Con questo attacco, presta attenzione alla schermata dello sniffer per vedere se compare una password"
	et_misc_texts["POLISH",5]="Podczas tego ataku obserwuj ekran sniffera, aby zobaczyć, czy pojawia się hasło"
	et_misc_texts["GERMAN",5]="Schau mit diesem Angriff am Bildschirm ob ein Passwort erscheint"
	et_misc_texts["TURKISH",5]="Bu saldırı ile algılayıcının ekranını görebilir ve şifre çıktığında şifreyi görebilirsiniz"
	et_misc_texts["ARABIC",5]="تحقق أثناء الهجوم في شاشة المتشمم إذا تم التقاط كلمة مرور"
	et_misc_texts["CHINESE",5]="在这次攻击中，观察嗅探器的屏幕以查看是否出现密码"

	et_misc_texts["ENGLISH",6]="On this attack, we'll wait for a network client to provide us the password for the wifi network in our captive portal"
	et_misc_texts["SPANISH",6]="Con este ataque, esperaremos a que un cliente de la red nos provea de la contraseña de la red wifi en nuestro portal cautivo"
	et_misc_texts["FRENCH",6]="Avec cette attaque nous allons attendre qu'un client rentre le mot de passe du réseau cible dans notre portail captif"
	et_misc_texts["CATALAN",6]="Amb aquest atac, esperarem que un client de la xarxa ens proveeixi de la contrasenya de la xarxa wifi al nostre portal captiu"
	et_misc_texts["PORTUGUESE",6]="Com este ataque, vamos esperar que um cliente nos forneça a senha da rede wifi em nosso portal cativo"
	et_misc_texts["RUSSIAN",6]="С этой атакой вы будете ожидать, чтобы сетевые клиенты ввели пароль для wifi сети на нашем перехватывающем портале"
	et_misc_texts["GREEK",6]="Με αυτή την επίθεση, θα περιμένουμε για έναν χρήστη του δικτύου να μας παρέχει με τον κωδικό πρόσβασης του wifi στο captive portal μας"
	et_misc_texts["ITALIAN",6]="Con questo attacco, aspettaremo che un cliente della rete ci fornisca la password per la rete wireless attraverso il nostro captive portal"
	et_misc_texts["POLISH",6]="W tym ataku poczekamy na klienta sieci aż poda nam hasło do sieci wifi na naszej stronie captive portal"
	et_misc_texts["GERMAN",6]="Mit diesem Angriff warten wir bis ein Client im Netzwerk uns das Passwort des WLANs in unserer Vorschaltseite übergibt"
	et_misc_texts["TURKISH",6]="Bu saldırı ile, şifrenin doğru bir şekilde esaret portalımıza giriş yapılmasını bekleyeceğiz"
	et_misc_texts["ARABIC",6]="مع هذا الهجوم، سننتظر حتى يقوم الزبون بإدخال كلمة مرور الشبكة المستهدفة في بوابتنا الأسيرة"
	et_misc_texts["CHINESE",6]="在这次攻击中，我们将等待用户在我们的强制门户中为我们提供 wifi 网络的密码"

	et_misc_texts["ENGLISH",7]="No clients connected yet"
	et_misc_texts["SPANISH",7]="No hay clientes conectados aún"
	et_misc_texts["FRENCH",7]="Toujours pas de clients connectés"
	et_misc_texts["CATALAN",7]="Encara no hi han clients connectats"
	et_misc_texts["PORTUGUESE",7]="Ainda não há clientes conectados"
	et_misc_texts["RUSSIAN",7]="Клиенты ещё не подключены"
	et_misc_texts["GREEK",7]="Ακόμα κανένας συνδεδεμένος χρήστης"
	et_misc_texts["ITALIAN",7]="Non ci sono ancora clienti collegati"
	et_misc_texts["POLISH",7]="Nie ma jeszcze żadnych podłączonych klientów"
	et_misc_texts["GERMAN",7]="Keine Clients bisher verbunden"
	et_misc_texts["TURKISH",7]="Henüz hiçbir alıcı bağlanmadı"
	et_misc_texts["ARABIC",7]="لا يزال لا يوجد زبناء متصلون"
	et_misc_texts["CHINESE",7]="还没有客户端连接"

	et_misc_texts["ENGLISH",8]="airgeddon. Evil Twin attack captured passwords"
	et_misc_texts["SPANISH",8]="airgeddon. Contraseñas capturadas en ataque Evil Twin"
	et_misc_texts["FRENCH",8]="airgeddon. Mots de passe capturés par attaque Evil Twin"
	et_misc_texts["CATALAN",8]="airgeddon. Contrasenyes capturades amb atac Evil Twin"
	et_misc_texts["PORTUGUESE",8]="airgeddon. Senhas capturadas no ataque ataque Evil Twin"
	et_misc_texts["RUSSIAN",8]="airgeddon. Атака Злой Двойник захватила пароли"
	et_misc_texts["GREEK",8]="airgeddon. Η επίθεση Evil Twin κατέγραψε κωδικούς πρόσβασης"
	et_misc_texts["ITALIAN",8]="airgeddon. Password catturate con l'attacco Evil Twin"
	et_misc_texts["POLISH",8]="airgeddon. Hasła przechwycone podczas ataku Evil Twin"
	et_misc_texts["GERMAN",8]="airgeddon. Passwörter im Evil Twin-Angriff erfassen"
	et_misc_texts["TURKISH",8]="airgeddon. Şeytani İkiz şifreleri yakaladı"
	et_misc_texts["ARABIC",8]="Evil Twin كلمات المرور التي تم التقاطها بواسطة هجوم .airgeddon"
	et_misc_texts["CHINESE",8]="airgeddon 邪恶双胞胎攻击捕获的密码"

	et_misc_texts["ENGLISH",9]="Wireless network, ESSID:"
	et_misc_texts["SPANISH",9]="Red inalámbrica, ESSID:"
	et_misc_texts["FRENCH",9]="Réseau sans fil, ESSID:"
	et_misc_texts["CATALAN",9]="Xarxa sense fils, ESSID:"
	et_misc_texts["PORTUGUESE",9]="ESSID da rede sem fio:"
	et_misc_texts["RUSSIAN",9]="Беспроводная сеть, ESSID:"
	et_misc_texts["GREEK",9]="Ασύρματο Δίκτυο, ESSID:"
	et_misc_texts["ITALIAN",9]="Rete wireless, ESSID:"
	et_misc_texts["POLISH",9]="Sieć bezprzewodowa, ESSID:"
	et_misc_texts["GERMAN",9]="WLAN, ESSID:"
	et_misc_texts["TURKISH",9]="Kablosuz ağ, ESSID:"
	et_misc_texts["ARABIC",9]=":الشبكه اللاسلكية"
	et_misc_texts["CHINESE",9]="无线网络，ESSID:"

	et_misc_texts["ENGLISH",10]="Enter your wireless network password to get internet access"
	et_misc_texts["SPANISH",10]="Introduzca su contraseña de acceso a la red inalámbrica para poder acceder a internet"
	et_misc_texts["FRENCH",10]="Veuillez saisir la clé de sécurité du réseau wifi pour obtenir accès à internet"
	et_misc_texts["CATALAN",10]="Introduïu la contrasenya d&#39;accés a la xarxa sense fils per poder accedir a internet"
	et_misc_texts["PORTUGUESE",10]="Digite a senha da rede wifi para ter acesso a internet"
	et_misc_texts["RUSSIAN",10]="Введите пароль Вашей беспроводной сети для подключения к Интернету"
	et_misc_texts["GREEK",10]="Εισάγετε τον κωδικό πρόσβασης του wifi δικτύου σας για να υπάρξει σύνδεση στο διαδίκτυο"
	et_misc_texts["ITALIAN",10]="Introdurre la password della rete wireless per poter accedere a internet"
	et_misc_texts["POLISH",10]="Wprowadź hasło do sieci bezprzewodowej, aby uzyskać dostęp do internetu"
	et_misc_texts["GERMAN",10]="Geben Sie ihr WLAN-Passwort für den Internetzugang ein"
	et_misc_texts["TURKISH",10]="İnternete bağlanabilmek için kablosuz ağ şifrenizi girmelisiniz"
	et_misc_texts["ARABIC",10]="أدخل كلمة مرور الشبكة اللاسلكية للوصول إلى الإنترنت"
	et_misc_texts["CHINESE",10]="请输入您的无线网络密码以访问互联网"

	et_misc_texts["ENGLISH",11]="Password"
	et_misc_texts["SPANISH",11]="Contraseña"
	et_misc_texts["FRENCH",11]="Clé de sécurité"
	et_misc_texts["CATALAN",11]="Contrasenya"
	et_misc_texts["PORTUGUESE",11]="Senha"
	et_misc_texts["RUSSIAN",11]="Пароль"
	et_misc_texts["GREEK",11]="Κωδικός πρόσβασης"
	et_misc_texts["ITALIAN",11]="Password"
	et_misc_texts["POLISH",11]="Hasło"
	et_misc_texts["GERMAN",11]="Passwort"
	et_misc_texts["TURKISH",11]="Şifre"
	et_misc_texts["ARABIC",11]="كلمه السر"
	et_misc_texts["CHINESE",11]="密码"

	et_misc_texts["ENGLISH",12]="Show password"
	et_misc_texts["SPANISH",12]="Mostrar contraseña"
	et_misc_texts["FRENCH",12]="Afficher les caractères"
	et_misc_texts["CATALAN",12]="Mostra la contrasenya"
	et_misc_texts["PORTUGUESE",12]="Mostrar senha"
	et_misc_texts["RUSSIAN",12]="Показать пароль"
	et_misc_texts["GREEK",12]="Εμφάνιση κωδικού πρόσβασης"
	et_misc_texts["ITALIAN",12]="Mostrare password"
	et_misc_texts["POLISH",12]="Pokaż hasło"
	et_misc_texts["GERMAN",12]="Passwort zeigen"
	et_misc_texts["TURKISH",12]="Şifreyi göster"
	et_misc_texts["ARABIC",12]="إظهار كلمة المرور"
	et_misc_texts["CHINESE",12]="显示密码"

	et_misc_texts["ENGLISH",13]="Submit"
	et_misc_texts["SPANISH",13]="Enviar"
	et_misc_texts["FRENCH",13]="Enregistrer"
	et_misc_texts["CATALAN",13]="Enviar"
	et_misc_texts["PORTUGUESE",13]="Enviar"
	et_misc_texts["RUSSIAN",13]="Отправить"
	et_misc_texts["GREEK",13]="Υποβολή"
	et_misc_texts["ITALIAN",13]="Inviare"
	et_misc_texts["POLISH",13]="Wyślij"
	et_misc_texts["GERMAN",13]="Schicken"
	et_misc_texts["TURKISH",13]="Gönder"
	et_misc_texts["ARABIC",13]="إرسال"
	et_misc_texts["CHINESE",13]="提交"

	et_misc_texts["ENGLISH",14]="An unexpected error occurred, redirecting to the main screen"
	et_misc_texts["SPANISH",14]="Ha ocurrido un error inesperado, redirigiendo a la pantalla principal"
	et_misc_texts["FRENCH",14]="Une erreur inattendue s&#39;est produite, retour à l&#39;écran principal"
	et_misc_texts["CATALAN",14]="Hi ha hagut un error inesperat, redirigint a la pantalla principal"
	et_misc_texts["PORTUGUESE",14]="Ocorreu um erro inesperado, redirecionando para a pagina principal"
	et_misc_texts["RUSSIAN",14]="Непредвиденная ошибка, перенаправление на главную страницу"
	et_misc_texts["GREEK",14]="Παρουσιάστηκε μη αναμενόμενο σφάλμα, Θα καθοδηγηθείτε στην κύρια οθόνη"
	et_misc_texts["ITALIAN",14]="Si è verificato un errore imprevisto, reindirizzando alla schermata principale"
	et_misc_texts["POLISH",14]="Wystąpił nieoczekiwany błąd, zostaniesz przekierowany do ekranu głównego"
	et_misc_texts["GERMAN",14]="Ein Fehler ist aufgetreten, Sie werden zur Homepage weitergeleitet"
	et_misc_texts["TURKISH",14]="Beklenmeyen bir hata oluştu, anasayfaya yönlendiriliyorsunuz"
	et_misc_texts["ARABIC",14]="حدث خطأ غير متوقع، سيتم إعادة التوجيه إلى الشاشة الرئيسية"
	et_misc_texts["CHINESE",14]="出现意外错误，正在重定向到主屏幕"

	et_misc_texts["ENGLISH",15]="Internet Portal"
	et_misc_texts["SPANISH",15]="Portal de Internet"
	et_misc_texts["FRENCH",15]="Portail Internet"
	et_misc_texts["CATALAN",15]="Portal d&#39;Internet"
	et_misc_texts["PORTUGUESE",15]="Portal de Internet"
	et_misc_texts["RUSSIAN",15]="Интернет-портал"
	et_misc_texts["GREEK",15]="Internet Portal"
	et_misc_texts["ITALIAN",15]="Portale Internet"
	et_misc_texts["POLISH",15]="Portal internetowy"
	et_misc_texts["GERMAN",15]="Internet Portal"
	et_misc_texts["TURKISH",15]="İnternet Portalı"
	et_misc_texts["ARABIC",15]="بوابة الإنترنت"
	et_misc_texts["CHINESE",15]="门户网站"

	et_misc_texts["ENGLISH",16]="The password must be at least 8 characters"
	et_misc_texts["SPANISH",16]="La contraseña debe tener al menos 8 caracteres"
	et_misc_texts["FRENCH",16]="La clé de sécurité doit contenir au moins 8 caractères"
	et_misc_texts["CATALAN",16]="La contrasenya ha de tenir almenys 8 caràcters"
	et_misc_texts["PORTUGUESE",16]="A senha deve ter no mínimo 8 caracteres"
	et_misc_texts["RUSSIAN",16]="Длина пароля должна быть не менее 8 символов"
	et_misc_texts["GREEK",16]="Ο κωδικός πρόσβασης πρέπει να αποτελείται από τουλάχιστον 8 χαρακτήρες"
	et_misc_texts["ITALIAN",16]="La password deve contenere almeno 8 caratteri"
	et_misc_texts["POLISH",16]="Hasło musi mieć długość co najmniej 8 znaków"
	et_misc_texts["GERMAN",16]="Das Passwort muss mindestens 8 Zeichen lang sein"
	et_misc_texts["TURKISH",16]="Şifre en az 8 karakter olmalıdır"
	et_misc_texts["ARABIC",16]="يجب أن تكون كلمة السر على الأقل 8 أحرف"
	et_misc_texts["CHINESE",16]="密码必须至少为 8 个字符"

	et_misc_texts["ENGLISH",17]="The password is incorrect, redirecting to the main screen"
	et_misc_texts["SPANISH",17]="La contraseña introducida es incorrecta, redirigiendo a la pantalla principal"
	et_misc_texts["FRENCH",17]="Clé de sécurité incorrecte, retour à l&#39;écran principal"
	et_misc_texts["CATALAN",17]="La contrasenya introduïda és incorrecta, redirigint a la pantalla principal"
	et_misc_texts["PORTUGUESE",17]="A senha está incorreta, redirecionando para a pagina principal"
	et_misc_texts["RUSSIAN",17]="Неправильный пароль, возврат на главную страницу"
	et_misc_texts["GREEK",17]="Ο κωδικός πρόσβασης είναι λανθασμένος, Θα καθοδηγηθείτε στην κύρια οθόνη"
	et_misc_texts["ITALIAN",17]="La password non è corretta, reindirizzando alla schermata principale"
	et_misc_texts["POLISH",17]="Wprowadzone hasło jest niepoprawne, zostaniesz przekierowany do ekranu głównego"
	et_misc_texts["GERMAN",17]="Das eingegebene Passwort ist falsch, Sie werden zur Homepage weitergeleitet"
	et_misc_texts["TURKISH",17]="Şifre yanlış, anasayfaya yönlendiriliyorsunuz"
	et_misc_texts["ARABIC",17]="كلمة السر غير صحيحة، سيتم إعادة التوجيه إلى الشاشة الرئيسية"
	et_misc_texts["CHINESE",17]="密码错误，正在跳转到主界面"

	et_misc_texts["ENGLISH",18]="The password is correct, the connection will be restablished in a few moments"
	et_misc_texts["SPANISH",18]="La contraseña es correcta, la conexión se restablecerá en unos momentos"
	et_misc_texts["FRENCH",18]="Clé de sécurité correcte, la connexion sera établie dans quelques instants"
	et_misc_texts["CATALAN",18]="La contrasenya és correcta, la connexió es restablirà en uns moments"
	et_misc_texts["PORTUGUESE",18]="A senha está correta, a conexão será estabelecida em alguns momentos"
	et_misc_texts["RUSSIAN",18]="Пароль верен, подключение устанавливается"
	et_misc_texts["GREEK",18]="Ο κωδικός πρόσβασης είναι σωστός, η σύνδεση θα αποκατασταθεί σε λίγα λεπτά"
	et_misc_texts["ITALIAN",18]="La password è corretta, la connessione sará ripristinata in un momento"
	et_misc_texts["POLISH",18]="Hasło jest prawidłowe, połączenie zostanie przywrócone za chwilę"
	et_misc_texts["GERMAN",18]="Das Passwort ist richtig, die Verbindung wird in kurzer Zeit wiederhergestellt"
	et_misc_texts["TURKISH",18]="Şifre doğru, bağlantınız bir kaç dakika içerisinde yeniden gerçekleşecektir"
	et_misc_texts["ARABIC",18]="كلمة السر صحيحة، سيتم إعادة الاتصال خلال لحظات قليلة"
	et_misc_texts["CHINESE",18]="密码正确，稍后将重新建立连接"

	et_misc_texts["ENGLISH",19]="airgeddon. Captive portal Evil Twin attack captured password"
	et_misc_texts["SPANISH",19]="airgeddon. Contraseña capturada en el portal cautivo del ataque Evil Twin"
	et_misc_texts["FRENCH",19]="airgeddon. Mot de passe capturé par le portail captif de l'attaque Evil Twin"
	et_misc_texts["CATALAN",19]="airgeddon. Contrasenya capturada al portal captiu de l'atac Evil Twin"
	et_misc_texts["PORTUGUESE",19]="airgeddon. Senha capturada no ataque Evil Twin portal cativo"
	et_misc_texts["RUSSIAN",19]="airgeddon. Атака Злой Двойник + Перехватывающий портал захватили пароль"
	et_misc_texts["GREEK",19]="airgeddon. Η επίθεση Evil Twin με captive portal κατέγραψε τον κωδικό πρόσβασης"
	et_misc_texts["ITALIAN",19]="airgeddon. Password catturata nel captive portal dell'attacco Evil Twin"
	et_misc_texts["POLISH",19]="airgeddon. Hasło przechwycone podczas ataku captive portal Evil Twin"
	et_misc_texts["GERMAN",19]="airgeddon. Passwort im Evil Twin Captive Portal gefangen"
	et_misc_texts["TURKISH",19]="airgeddon. Esaret Portalı Şeytani ikizi şifreyi yakaladı"
	et_misc_texts["ARABIC",19]="Evil Twin تم التقاط كلمة السر بواسطة البوابة الأسيرة لهجوم .airgeddon"
	et_misc_texts["CHINESE",19]="airgeddon 邪恶双胞胎强制门户攻击捕获的密码"

	et_misc_texts["ENGLISH",20]="Attempts"
	et_misc_texts["SPANISH",20]="Intentos"
	et_misc_texts["FRENCH",20]="Essais"
	et_misc_texts["CATALAN",20]="Intents"
	et_misc_texts["PORTUGUESE",20]="Tentativas"
	et_misc_texts["RUSSIAN",20]="Попытки"
	et_misc_texts["GREEK",20]="Προσπάθειες"
	et_misc_texts["ITALIAN",20]="Tentativi"
	et_misc_texts["POLISH",20]="Próby"
	et_misc_texts["GERMAN",20]="Versuche"
	et_misc_texts["TURKISH",20]="Denemeler"
	et_misc_texts["ARABIC",20]="محاولات"
	et_misc_texts["CHINESE",20]="尝试"

	et_misc_texts["ENGLISH",21]="last password:"
	et_misc_texts["SPANISH",21]="última contraseña:"
	et_misc_texts["FRENCH",21]="dernier mot de passe:"
	et_misc_texts["CATALAN",21]="última contrasenya:"
	et_misc_texts["PORTUGUESE",21]="última senha:"
	et_misc_texts["RUSSIAN",21]="последний пароль:"
	et_misc_texts["GREEK",21]="τελευταίος κωδικός πρόσβασης:"
	et_misc_texts["ITALIAN",21]="ultima password:"
	et_misc_texts["POLISH",21]="ostatnie hasło:"
	et_misc_texts["GERMAN",21]="letztes Passwort:"
	et_misc_texts["TURKISH",21]="son şifre:"
	et_misc_texts["ARABIC",21]="كلمة المرور الأخيرة:"
	et_misc_texts["CHINESE",21]="最后密码:"

	et_misc_texts["ENGLISH",22]="Captured passwords on failed attempts"
	et_misc_texts["SPANISH",22]="Contraseñas capturadas en intentos fallidos"
	et_misc_texts["FRENCH",22]="Mots de passe capturés lors des tentatives infructueuses"
	et_misc_texts["CATALAN",22]="Contrasenyes capturades en intents fallits"
	et_misc_texts["PORTUGUESE",22]="Senhas erradas capturadas durante as tentativas"
	et_misc_texts["RUSSIAN",22]="Пароли, захваченные в неудачных попытках"
	et_misc_texts["GREEK",22]="Καταγεγραμμένοι κωδικοί πρόσβασης σε αποτυχημένες προσπάθειες"
	et_misc_texts["ITALIAN",22]="Password catturate in tentativi falliti"
	et_misc_texts["POLISH",22]="Hasła przechwycone podczas nieudanych prób"
	et_misc_texts["GERMAN",22]="Gefundene Passwörter bei Fehlversuchen"
	et_misc_texts["TURKISH",22]="Başarısız girişimlerde yakalanan şifreler"
	et_misc_texts["ARABIC",22]="تم التقاط كلمات السر في المحاولات الفاشلة"
	et_misc_texts["CHINESE",22]="尝试失败时捕获的密码"

	et_misc_texts["ENGLISH",23]="Password captured successfully"
	et_misc_texts["SPANISH",23]="Contraseña capturada con éxito"
	et_misc_texts["FRENCH",23]="Mot de passe capturé avec succès"
	et_misc_texts["CATALAN",23]="Contrasenya capturada amb èxit"
	et_misc_texts["PORTUGUESE",23]="Senha capturada com sucesso"
	et_misc_texts["RUSSIAN",23]="Пароль успешно захвачен"
	et_misc_texts["GREEK",23]="Ο κωδικός πρόσβασης καταγράφτηκε επιτυχώς"
	et_misc_texts["ITALIAN",23]="Password catturata con successo"
	et_misc_texts["POLISH",23]="Hasło zostało pomyślnie przechwycone"
	et_misc_texts["GERMAN",23]="Passwörter erfolgreich gefunden"
	et_misc_texts["TURKISH",23]="Şifre başarıyla yakalandı"
	et_misc_texts["ARABIC",23]="تم التقاط كلمة السر بنجاح"
	et_misc_texts["CHINESE",23]="密码获取成功"

	et_misc_texts["ENGLISH",24]="The password was saved on file"
	et_misc_texts["SPANISH",24]="La contraseña se ha guardado en el fichero"
	et_misc_texts["FRENCH",24]="Le mot de passe est enregistré dans le fichier"
	et_misc_texts["CATALAN",24]="La contrasenya s'ha guardat en el fitxer"
	et_misc_texts["PORTUGUESE",24]="A senha foi salva no arquivo"
	et_misc_texts["RUSSIAN",24]="Пароль был сохранён в файле"
	et_misc_texts["GREEK",24]="Ο κωδικός πρόσβασης αποθηκεύτηκε σε αρχείο"
	et_misc_texts["ITALIAN",24]="La password è stata salvata nel file"
	et_misc_texts["POLISH",24]="Hasło zostało zapisane do pliku"
	et_misc_texts["GERMAN",24]="Das Passwort wurde in der Datei gespeichert"
	et_misc_texts["TURKISH",24]="Şifre dosyaya kaydedildi"
	et_misc_texts["ARABIC",24]="تم حفظ كلمة السر في الملف"
	et_misc_texts["CHINESE",24]="密码已保存至文件"

	et_misc_texts["ENGLISH",25]="Press [Enter] on the main script window to continue, this window will be closed"
	et_misc_texts["SPANISH",25]="Pulsa [Enter] en la ventana principal del script para continuar, esta ventana se cerrará"
	et_misc_texts["FRENCH",25]="Appuyez sur [Enter] dans la fenêtre principale du script pour continuer, cette fenêtre se fermera"
	et_misc_texts["CATALAN",25]="Prem [Enter] a la finestra principal del script per continuar, aquesta finestra es tancarà"
	et_misc_texts["PORTUGUESE",25]="Pressione [Enter] na janela principal do script para continuar e esta janela será fechada"
	et_misc_texts["RUSSIAN",25]="Нажмите [Enter] в главном окне для продолжения, это окно будет закрыто"
	et_misc_texts["GREEK",25]="Πατήστε [Enter] στο κύριο παράθυρο του script για να συνεχίσετε, το παράθυρο αυτό θα κλείσει"
	et_misc_texts["ITALIAN",25]="Premere il tasto [Enter] nella finestra principale dello script per continuare, questa finestra si chiuderà"
	et_misc_texts["POLISH",25]="Wciśnij [Enter] w oknie głównym skryptu aby kontynuować, to okno zostanie zamknięte"
	et_misc_texts["GERMAN",25]="Drücken Sie [Enter] im Hauptfenster um fortzufahren, dieses Fenster wird geschlossen"
	et_misc_texts["TURKISH",25]="Devam etmek için [Enter] tuşuna basınız, bu sayfa kapatılacaktır"
	et_misc_texts["ARABIC",25]="في نافذة البرنامج الرئيسية للمتابعة، سيتم إغلاق هذه النافذة [Enter] اضغط على"
	et_misc_texts["CHINESE",25]="在脚本主窗口按 [Enter] 键继续，该窗口将关闭"

	et_misc_texts["ENGLISH",26]="Error. The password must be at least 8 characters. Redirecting to the main screen"
	et_misc_texts["SPANISH",26]="Error. La contraseña debe tener al menos 8 caracteres. Redirigiendo a la pantalla principal"
	et_misc_texts["FRENCH",26]="Erreur. La clé de sécurité doit contenir au moins 8 caractères. Retour à l&#39;écran principal"
	et_misc_texts["CATALAN",26]="Error. La contrasenya ha de tenir almenys 8 caràcters. Redirigint a la pantalla principal"
	et_misc_texts["PORTUGUESE",26]="Erro. A senha deve ter no mínimo 8 caracteres. Redirecionando para a pagina principal"
	et_misc_texts["RUSSIAN",26]="Ошибка. В пароле должно быть не менее 8 символов. Перенаправление на главную страницу"
	et_misc_texts["GREEK",26]="Σφάλμα. Ο κωδικός πρόσβασης πρέπει να αποτελείται από τουλάχιστον 8 χαρακτήρες. Θα καθοδηγηθείτε στην κύρια οθόνη"
	et_misc_texts["ITALIAN",26]="Errore. La password deve contenere almeno 8 caratteri. Reindirizzando alla schermata principale"
	et_misc_texts["POLISH",26]="Błąd. Hasło musi mieć co najmniej 8 znaków. Przekierowywanie do ekranu głównego"
	et_misc_texts["GERMAN",26]="Fehler. Das Passwort muss mindestens 8 Zeichen lang sein. Zur Homepage weitergeleitet"
	et_misc_texts["TURKISH",26]="Hata. Şifre en az 8 karakter olmalıdır. Anasayfaya yönlendiriliyorsunuz"
	et_misc_texts["ARABIC",26]="خطأ. يجب أن تتكون كلمة المرور من 8 أحرف على الأقل.حة، سيتم إعادة التوجيه إلى الشاشة الرئيسية"
	et_misc_texts["CHINESE",26]="错误。密码必须至少为 8 个字符。重定向到主屏幕"

	et_misc_texts["ENGLISH",27]="This attack has two parts. Watch the sniffer's screen to see if a password appears. You can also open BeEF control panel at ${white_color}${beef_control_panel_url}${pink_color} , log in (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) and try to control the clients browser"
	et_misc_texts["SPANISH",27]="Este ataque tiene dos partes. Estate atento a la pantalla del sniffer para ver si aparece alguna contraseña. También puedes abrir el panel de control de BeEF en ${white_color}${beef_control_panel_url}${pink_color} , hacer login (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) e intentar controlar el navegador de los clientes"
	et_misc_texts["FRENCH",27]="Cette attaque comporte deux parties. Vérifiez pendant l'attaque dans la console du sniffeur si un mot de passe a été capturé. Vous pouvez également ouvrir le BeEF du panneau de commande dans ${white_color}${beef_control_panel_url}${pink_color} , pour vous connecter (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) et essayer de contrôler le navigateur client"
	et_misc_texts["CATALAN",27]="Aquest atac té dues parts. Amb aquest atac, estigues atent a la pantalla de l'sniffer per veure si apareix alguna contrasenya. També pots obrir el panell de control de BeEF en ${white_color}${beef_control_panel_url}${pink_color} , fer login (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) i intentar controlar el navegador dels clients"
	et_misc_texts["PORTUGUESE",27]="Este ataque tem duas partes. Com este ataque, fique atento na tela do sniffer para ver se aparece alguma senha. Você também pode abrir o painel de controle do BeEF em ${white_color}${beef_control_panel_url}${pink_color} , login (user: ${white_color}beef${pink_color} / senha: ${white_color}${beef_pass}${pink_color}) e tentar controlar o navegador dos clientes"
	et_misc_texts["RUSSIAN",27]="Эта атака идёт по двум направлениям. Вы можете наблюдать за окном сниффера, чтобы отследить появление пароля. Также можете перейти в панель управления BeEF ${white_color}${beef_control_panel_url}${pink_color} , учётные данные для входа (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) и попытаться управлять браузером клиентов"
	et_misc_texts["GREEK",27]="Αυτή η επίθεση έχει δύο μέρη. Παρακολουθήστε την οθόνη του sniffer για να δείτε εαν εμφανιστεί κάποιος κωδικός. Μπορείτε επίσης να ανοίξετε τον πίνακα ελέγχου του BeEF στο ${white_color}${beef_control_panel_url}${pink_color} , συνδεθείτε (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) και προσπαθείστε να ελέγξετε τον browser του χρήστη-πελάτη"
	et_misc_texts["ITALIAN",27]="Questo attacco è composto da due parti. Presta attenzione alla schermata dello sniffer per vedere se compare una password. È inoltre possibile aprire il pannello di controllo di BeEF in ${white_color}${beef_control_panel_url}${pink_color} , effettuare il login (utente: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) e cercare di controllare il navigatore degli utenti"
	et_misc_texts["POLISH",27]="Ten atak ma dwie części. Obserwuj ekran sniffera aby sprawdzić, czy pojawia się hasło. Możesz także otworzyć panel sterowania BeEF w ${white_color}${beef_control_panel_url}${pink_color} , zaloguj się (użytkownik: ${white_color}beef${pink_color} / hasło: ${white_color}${beef_pass}${pink_color}) i spróbuj kontrolować przeglądarkę klientów"
	et_misc_texts["GERMAN",27]="Dieser Angriff besteht aus zwei Teilen. Bleiben Sie auf dem Sniffer-Bildschirm, um zu sehen, ob ein Passwort erscheint. Sie können auch das BeEF-Kontrollfeld in ${white_color}${beef_control_panel_url}${pink_color} öffnen, login (Benutzer: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) und versuchen den Browser des Clients zu kontrollieren"
	et_misc_texts["TURKISH",27]="Bu saldırı iki parçadan oluşur. Sniffer ekranını şifre görünene kadar izleyin. Ayrıca BeEF kontrol panelini açabilir ${white_color}${beef_control_panel_url}${pink_color} , log in (user: ${white_color}beef${pink_color} / pass: ${white_color}${beef_pass}${pink_color}) ve kontrol edebilirsiniz"
	et_misc_texts["ARABIC",27]="هذا الهجوم من جزئين. تحقق أثناء الهجوم في وحدة تحكم المتشمم إذا تم التقاط كلمة سر. يمكنك أيضًا فتحوحاول التحكم في متصفح الزبون (${white_color}${beef_pass}${pink_color}:كلمة السر ${white_color}beef${pink_color}:المستخدم) ${white_color}${beef_control_panel_url}${pink_color} في BeEF هذا الهجوم من جزئين. تحقق أثناء الهجوم في وحدة تحكم المتشمم إذا تم التقاط كلمة سر. يمكنك أيضًا فتح"
	et_misc_texts["CHINESE",27]="这次攻击有两个部分。观察嗅探器的屏幕以查看是否出现密码。您还可以在 ${white_color}${beef_control_panel_url}${pink_color} 打开 BeEF 控制面板，登录 (用户: ${white_color}beef${pink_color} / 密码: ${white_color}${beef_pass}${pink_color}) 并尝试控制客户端浏览器"

	et_misc_texts["ENGLISH",28]="Portal accessed"
	et_misc_texts["SPANISH",28]="Accedió al portal"
	et_misc_texts["FRENCH",28]="Portail consulté"
	et_misc_texts["CATALAN",28]="Portal accedit"
	et_misc_texts["PORTUGUESE",28]="Portal acessado"
	et_misc_texts["RUSSIAN",28]="Доступ к порталу получен"
	et_misc_texts["GREEK",28]="Eισήχθη στο portal"
	et_misc_texts["ITALIAN",28]="Ha acceduto al portale"
	et_misc_texts["POLISH",28]="Uzyskano dostęp do portalu"
	et_misc_texts["GERMAN",28]="Portal aufgerufen"
	et_misc_texts["TURKISH",28]="Portala erişildi"
	et_misc_texts["ARABIC",28]="تم الوصول إلى البوابة"
	et_misc_texts["CHINESE",28]="门户访问成功"

	et_misc_texts["ENGLISH",29]="Is alive"
	et_misc_texts["SPANISH",29]="Está activo"
	et_misc_texts["FRENCH",29]="Est actif"
	et_misc_texts["CATALAN",29]="Està actiu"
	et_misc_texts["PORTUGUESE",29]="Está ativo"
	et_misc_texts["RUSSIAN",29]="Активен"
	et_misc_texts["GREEK",29]="Είναι ενεργό"
	et_misc_texts["ITALIAN",29]="È attivo"
	et_misc_texts["POLISH",29]="Jest aktywny"
	et_misc_texts["GERMAN",29]="Ist aktiv"
	et_misc_texts["TURKISH",29]="Aktif"
	et_misc_texts["ARABIC",29]="نشط"
	et_misc_texts["CHINESE",29]="处于活动状态"

	declare -gA wps_texts
	wps_texts["ENGLISH",0]="The password was saved on file"
	wps_texts["SPANISH",0]="La contraseña se ha guardado en el fichero"
	wps_texts["FRENCH",0]="Le mot de passe est enregistré dans le fichier"
	wps_texts["CATALAN",0]="La contrasenya s'ha guardat en el fitxer"
	wps_texts["PORTUGUESE",0]="A senha foi salva no arquivo"
	wps_texts["RUSSIAN",0]="Пароль был сохранён в файле"
	wps_texts["GREEK",0]="Ο κωδικός πρόσβασης αποθηκεύτηκε σε αρχείο"
	wps_texts["ITALIAN",0]="La password è stata salvata nel file"
	wps_texts["POLISH",0]="Hasło zostało zapisane do pliku"
	wps_texts["GERMAN",0]="Das Passwort wurde in der Datei gespeichert"
	wps_texts["TURKISH",0]="Şifre dosyaya kaydedildi"
	wps_texts["ARABIC",0]="تم حفظ كلمة السر في ملف"
	wps_texts["CHINESE",0]="密码已保存至文件"

	wps_texts["ENGLISH",1]="airgeddon. Decrypted password during WPS attack"
	wps_texts["SPANISH",1]="airgeddon. Contraseña descifrada en ataque WPS"
	wps_texts["FRENCH",1]="airgeddon. Mot de passe déchiffré à l'aide de l'attaque WPS"
	wps_texts["CATALAN",1]="airgeddon. Contrasenya desxifrada amb l'atac WPS"
	wps_texts["PORTUGUESE",1]="airgeddon. Senha decifrada no ataque WPS"
	wps_texts["RUSSIAN",1]="airgeddon. Пароль расшифрован во время WPS атаки"
	wps_texts["GREEK",1]="airgeddon. Ο κωδικός αποκρυπτογραφήθηκε κατά την επίθεση WPS"
	wps_texts["ITALIAN",1]="airgeddon. Password decifrata con l'attacco WPS"
	wps_texts["POLISH",1]="airgeddon. Hasło odszyfrowane w ataku WPS"
	wps_texts["GERMAN",1]="airgeddon. Passwort während WPS-Angriff entschlüsselt"
	wps_texts["TURKISH",1]="airgeddon. WPS saldırısı sırasında çözülen şifre"
	wps_texts["ARABIC",1]="WPS فك تشفير كلمة السر أثناء هجوم .airgeddon"
	wps_texts["CHINESE",1]="airgeddon WPS 攻击期间解密的密码"

	wps_texts["ENGLISH",2]="Channel"
	wps_texts["SPANISH",2]="Canal"
	wps_texts["FRENCH",2]="Canal"
	wps_texts["CATALAN",2]="Canal"
	wps_texts["PORTUGUESE",2]="Canal"
	wps_texts["RUSSIAN",2]="Канал"
	wps_texts["GREEK",2]="Κανάλι"
	wps_texts["ITALIAN",2]="Canale"
	wps_texts["POLISH",2]="Kanał"
	wps_texts["GERMAN",2]="Kanal"
	wps_texts["TURKISH",2]="Kanal"
	wps_texts["ARABIC",2]="قناة"
	wps_texts["CHINESE",2]="信道"

	declare -gA wep_texts
	wep_texts["ENGLISH",0]="Press [Enter] on the main script window to continue, this window will be closed"
	wep_texts["SPANISH",0]="Pulsa [Enter] en la ventana principal del script para continuar, esta ventana se cerrará"
	wep_texts["FRENCH",0]="Appuyez sur [Enter] dans la fenêtre principale du script pour continuer, cette fenêtre se fermera"
	wep_texts["CATALAN",0]="Prem [Enter] a la finestra principal del script per continuar, aquesta finestra es tancarà"
	wep_texts["PORTUGUESE",0]="Pressione [Enter] na janela principal do script para continuar e esta janela será fechada"
	wep_texts["RUSSIAN",0]="Нажмите [Enter] в главном окне для продолжения, это окно будет закрыто"
	wep_texts["GREEK",0]="Πατήστε [Enter] στο κύριο παράθυρο του script για να συνεχίσετε, το παράθυρο αυτό θα κλείσει"
	wep_texts["ITALIAN",0]="Premere il tasto [Enter] nella finestra principale dello script per continuare, questa finestra si chiuderà"
	wep_texts["POLISH",0]="Wciśnij [Enter] w oknie głównym skryptu aby kontynuować, to okno zostanie zamknięte"
	wep_texts["GERMAN",0]="Drücken Sie [Enter] im Hauptfenster des Skripts um fortzufahren. Dieses Fenster wird geschlossen"
	wep_texts["TURKISH",0]="Yazılımın ana penceresinde [Enter] tuşlayarak devam ediniz. Bu pencere kapatılacak"
	wep_texts["ARABIC",0]="في النافذة الرئيسية للبرنامج للمتابعة ، وستغلق هذه النافذة [Enter] اضغط على"
	wep_texts["CHINESE",0]="在脚本主窗口按 [Enter] 键继续，该窗口将关闭"

	wep_texts["ENGLISH",1]="airgeddon. Decrypted password during WEP attack"
	wep_texts["SPANISH",1]="airgeddon. Contraseña descifrada en ataque WEP"
	wep_texts["FRENCH",1]="airgeddon. Mot de passe déchiffré à l'aide de l'attaque WEP"
	wep_texts["CATALAN",1]="airgeddon. Contrasenya desxifrada amb l'atac WEP"
	wep_texts["PORTUGUESE",1]="airgeddon. Senha decifrada no ataque WEP"
	wep_texts["RUSSIAN",1]="airgeddon. Пароль расшифрован во время WEP атаки"
	wep_texts["GREEK",1]="airgeddon. Ο κωδικός αποκρυπτογραφήθηκε κατά την επίθεση WEP"
	wep_texts["ITALIAN",1]="airgeddon. Password decifrata con l'attacco WEP"
	wep_texts["POLISH",1]="airgeddon. Hasło odszyfrowane w ataku WEP"
	wep_texts["GERMAN",1]="airgeddon. Passwort während WEP-Angriff entschlüsselt"
	wep_texts["TURKISH",1]="airgeddon. WEP saldırısı sırasında çözülen şifre"
	wep_texts["ARABIC",1]="WEP تم فك تشفير كلمة المرور أثناء هجوم .airgeddon"
	wep_texts["CHINESE",1]="airgeddon WEP 攻击期间解密的密码"

	wep_texts["ENGLISH",2]="Channel"
	wep_texts["SPANISH",2]="Canal"
	wep_texts["FRENCH",2]="Canal"
	wep_texts["CATALAN",2]="Canal"
	wep_texts["PORTUGUESE",2]="Canal"
	wep_texts["RUSSIAN",2]="Канал"
	wep_texts["GREEK",2]="Κανάλι"
	wep_texts["ITALIAN",2]="Canale"
	wep_texts["POLISH",2]="Kanał"
	wep_texts["GERMAN",2]="Kanal"
	wep_texts["TURKISH",2]="Kanal"
	wep_texts["ARABIC",2]="قناة"
	wep_texts["CHINESE",2]="信道"

	wep_texts["ENGLISH",3]="Hexadecimal"
	wep_texts["SPANISH",3]="Hexadecimal"
	wep_texts["FRENCH",3]="Hexadécimal"
	wep_texts["CATALAN",3]="Hexadecimal"
	wep_texts["PORTUGUESE",3]="Hexadecimal"
	wep_texts["RUSSIAN",3]="Шестнадцатеричный"
	wep_texts["GREEK",3]="Δεκαεξαδικό"
	wep_texts["ITALIAN",3]="Esadecimale"
	wep_texts["POLISH",3]="Hexadecymalny"
	wep_texts["GERMAN",3]="Hexadezimal"
	wep_texts["TURKISH",3]="Hexadecimal"
	wep_texts["ARABIC",3]="السداسي عشري"
	wep_texts["CHINESE",3]="十六进制"

	wep_texts["ENGLISH",4]="WEP key decrypted successfully:"
	wep_texts["SPANISH",4]="Clave WEP descifrada con éxito:"
	wep_texts["FRENCH",4]="Clef WEP déchiffré:"
	wep_texts["CATALAN",4]="Clau WEP desxifrada amb èxit:"
	wep_texts["PORTUGUESE",4]="Senha WEP descriptografada com sucesso:"
	wep_texts["RUSSIAN",4]="Ключ WEP расшифрован:"
	wep_texts["GREEK",4]="Το κλειδί WEP αποκρυπτογραφήθηκε με επιτυχία:"
	wep_texts["ITALIAN",4]="Chiave WEP decifrata con successo:"
	wep_texts["POLISH",4]="Klucz WEP odszyfrowywany prawidłowo:"
	wep_texts["GERMAN",4]="WEP-Schlüssel erfolgreich entschlüsselt:"
	wep_texts["TURKISH",4]="WEP anahtarı başarıyla çözüldü:"
	wep_texts["ARABIC",4]=":بنجاح WEP تم فك تشفير مفتاح"
	wep_texts["CHINESE",4]="WEP 密钥解密成功:"

	wep_texts["ENGLISH",5]="WEP AP Info"
	wep_texts["SPANISH",5]="Info WEP AP"
	wep_texts["FRENCH",5]="Info WEP AP"
	wep_texts["CATALAN",5]="Info WEP AP"
	wep_texts["PORTUGUESE",5]="Info WEP AP"
	wep_texts["RUSSIAN",5]="Информация о WEP ТД"
	wep_texts["GREEK",5]="Πληροφορίες WEP AP"
	wep_texts["ITALIAN",5]="Info WEP AP"
	wep_texts["POLISH",5]="Informacja o AP WEP"
	wep_texts["GERMAN",5]="Info über WEP AP"
	wep_texts["TURKISH",5]="WEP AP Bilgisi"
	wep_texts["ARABIC",5]="WEP AP معلومات"
	wep_texts["CHINESE",5]="WEP AP 信息"

	wep_texts["ENGLISH",6]="The password was saved on file"
	wep_texts["SPANISH",6]="La contraseña se ha guardado en el fichero"
	wep_texts["FRENCH",6]="Le mot de passe est enregistré dans le fichier"
	wep_texts["CATALAN",6]="La contrasenya s'ha guardat en el fitxer"
	wep_texts["PORTUGUESE",6]="A senha foi salva no arquivo"
	wep_texts["RUSSIAN",6]="Пароль был сохранён в файле"
	wep_texts["GREEK",6]="Ο κωδικός πρόσβασης αποθηκεύτηκε σε αρχείο"
	wep_texts["ITALIAN",6]="La password è stata salvata nel file"
	wep_texts["POLISH",6]="Hasło zostało zapisane do pliku"
	wep_texts["GERMAN",6]="Das Passwort wurde in der Datei gespeichert"
	wep_texts["TURKISH",6]="Şifre dosyaya kaydedildi"
	wep_texts["ARABIC",6]="تم حفظ كلمة المرور في الملف"
	wep_texts["CHINESE",6]="密码已保存至文件"

	declare -gA asleap_texts
	asleap_texts["ENGLISH",0]="Response"
	asleap_texts["SPANISH",0]="Response"
	asleap_texts["FRENCH",0]="Réponse"
	asleap_texts["CATALAN",0]="Response"
	asleap_texts["PORTUGUESE",0]="Resposta"
	asleap_texts["RUSSIAN",0]="Ответ"
	asleap_texts["GREEK",0]="Response"
	asleap_texts["ITALIAN",0]="Response"
	asleap_texts["POLISH",0]="Odpowiedź"
	asleap_texts["GERMAN",0]="Rückmeldung"
	asleap_texts["TURKISH",0]="Yanıt"
	asleap_texts["ARABIC",0]="جواب"
	asleap_texts["CHINESE",0]="响应"

	asleap_texts["ENGLISH",1]="airgeddon. Decrypted password using asleap"
	asleap_texts["SPANISH",1]="airgeddon. Contraseña descifrada con asleap"
	asleap_texts["FRENCH",1]="airgeddon. Mot de passe déchiffré avec asleap"
	asleap_texts["CATALAN",1]="airgeddon. Contrasenya desxifrada amb asleap"
	asleap_texts["PORTUGUESE",1]="airgeddon descriptografou a senha usando asleap"
	asleap_texts["RUSSIAN",1]="airgeddon. Пароль расшифрован с использованием asleap"
	asleap_texts["GREEK",1]="airgeddon. Αποκρυπτογραφημένος κωδικός πρόσβασης με χρήση asleap"
	asleap_texts["ITALIAN",1]="airgeddon. Password decifrata con asleap"
	asleap_texts["POLISH",1]="airgeddon. Hasło odszyfrowane z użyciem asleap"
	asleap_texts["GERMAN",1]="airgeddon. Passwort mit asleap entschlüsselt"
	asleap_texts["TURKISH",1]="airgeddon. asleap kullanarak şifreyi çözdü"
	asleap_texts["ARABIC",1]="asleap فك تشفير كلمة السر باستخدام .airgeddon"
	asleap_texts["CHINESE",1]="airgeddon 使用 asleap 破解密码"

	asleap_texts["ENGLISH",2]="Challenge"
	asleap_texts["SPANISH",2]="Challenge"
	asleap_texts["FRENCH",2]="Défi"
	asleap_texts["CATALAN",2]="Challenge"
	asleap_texts["PORTUGUESE",2]="Desafio"
	asleap_texts["RUSSIAN",2]="Вызов"
	asleap_texts["GREEK",2]="Challenge"
	asleap_texts["ITALIAN",2]="Challenge"
	asleap_texts["POLISH",2]="Challenge"
	asleap_texts["GERMAN",2]="Challenge"
	asleap_texts["TURKISH",2]="Challenge"
	asleap_texts["ARABIC",2]="التحدي"
	asleap_texts["CHINESE",2]="挑战"

	declare -gA jtr_texts
	jtr_texts["ENGLISH",0]="Enterprise users and passwords"
	jtr_texts["SPANISH",0]="Usuarios y contraseñas enterprise"
	jtr_texts["FRENCH",0]="Utilisateurs et mots de passe d'entreprise"
	jtr_texts["CATALAN",0]="Usuaris i contrasenyes enterprise"
	jtr_texts["PORTUGUESE",0]="Usuários e senhas enterprise"
	jtr_texts["RUSSIAN",0]="Пользователь и пароль в enterprise"
	jtr_texts["GREEK",0]="Enterprise χρήστες και κωδικοί πρόσβασης"
	jtr_texts["ITALIAN",0]="Utenti e password enterprise"
	jtr_texts["POLISH",0]="Użytkownicy i hasła enterprise"
	jtr_texts["GERMAN",0]="Enterprise-Benutzernamen und Kennwörter"
	jtr_texts["TURKISH",0]="Enterprise kullanıcılar ve şifreler"
	jtr_texts["ARABIC",0]="Enterprise مستخدمي وكلمات السر"
	jtr_texts["CHINESE",0]="企业用户和密码"

	jtr_texts["ENGLISH",1]="airgeddon. Decrypted password using john the ripper"
	jtr_texts["SPANISH",1]="airgeddon. Contraseña descifrada con john the ripper"
	jtr_texts["FRENCH",1]="airgeddon. Mot de passe déchiffré avec john the ripper"
	jtr_texts["CATALAN",1]="airgeddon. Contrasenya desxifrada amb john the ripper"
	jtr_texts["PORTUGUESE",1]="airgeddon descriptografou a senha usando john the ripper"
	jtr_texts["RUSSIAN",1]="airgeddon. Пароль расшифрован с использованием john the ripper"
	jtr_texts["GREEK",1]="airgeddon. Αποκρυπτογραφημένος κωδικός πρόσβασης με χρήση john the ripper"
	jtr_texts["ITALIAN",1]="airgeddon. Password decifrata con john the ripper"
	jtr_texts["POLISH",1]="airgeddon. Hasło odszyfrowane z użyciem john the ripper"
	jtr_texts["GERMAN",1]="airgeddon. Passwort mit john the ripper entschlüsselt"
	jtr_texts["TURKISH",1]="airgeddon. John the ripper kullanarak şifreyi çözdü"
	jtr_texts["ARABIC",1]="john the ripper فك تشفير كلمة السر باستخدام .airgeddon"
	jtr_texts["CHINESE",1]="airgeddon 使用 john the ripper 破解密码"

	jtr_texts["ENGLISH",2]="Enterprise user"
	jtr_texts["SPANISH",2]="Usuario enterprise"
	jtr_texts["FRENCH",2]="Nom d'utilisateur enterprise"
	jtr_texts["CATALAN",2]="Nom d'usuari enterprise"
	jtr_texts["PORTUGUESE",2]="Nome de usuário enterprise"
	jtr_texts["RUSSIAN",2]="Пользователь в enterprise"
	jtr_texts["GREEK",2]="Όνομα χρήστη enterprise"
	jtr_texts["ITALIAN",2]="Utente enterprise"
	jtr_texts["POLISH",2]="Użytkownik enterprise"
	jtr_texts["GERMAN",2]="Enterprise-Benutzername"
	jtr_texts["TURKISH",2]="Enterprise kullanıcı"
	jtr_texts["ARABIC",2]="Enterprise مستخدم"
	jtr_texts["CHINESE",2]="企业用户"

	declare -gA hashcat_texts
	hashcat_texts["ENGLISH",0]="PMKID password"
	hashcat_texts["SPANISH",0]="Contraseña PMKID"
	hashcat_texts["FRENCH",0]="Mot de passe PMKID"
	hashcat_texts["CATALAN",0]="Contrasenya PMKID"
	hashcat_texts["PORTUGUESE",0]="Senha PMKID"
	hashcat_texts["RUSSIAN",0]="Пароль PMKID"
	hashcat_texts["GREEK",0]="Κωδικός πρόσβασης PMKID"
	hashcat_texts["ITALIAN",0]="Password PMKID"
	hashcat_texts["POLISH",0]="Hasło PMKID"
	hashcat_texts["GERMAN",0]="PMKID-Passwort"
	hashcat_texts["TURKISH",0]="PMKID şifresi"
	hashcat_texts["ARABIC",0]="PMKID كلمة سر"
	hashcat_texts["CHINESE",0]="PMKID 密码"

	hashcat_texts["ENGLISH",1]="airgeddon. Decrypted password using hashcat"
	hashcat_texts["SPANISH",1]="airgeddon. Contraseña descifrada con hashcat"
	hashcat_texts["FRENCH",1]="airgeddon. Mot de passe déchiffré avec hashcat"
	hashcat_texts["CATALAN",1]="airgeddon. Contrasenya desxifrada amb hashcat"
	hashcat_texts["PORTUGUESE",1]="airgeddon descriptografou a senha usando hashcat"
	hashcat_texts["RUSSIAN",1]="airgeddon. Пароль расшифрован с использованием hashcat"
	hashcat_texts["GREEK",1]="airgeddon. Αποκρυπτογραφημένος κωδικός πρόσβασης με χρήση hashcat"
	hashcat_texts["ITALIAN",1]="airgeddon. Password decifrata con hashcat"
	hashcat_texts["POLISH",1]="airgeddon. Hasło odszyfrowane z użyciem hashcat"
	hashcat_texts["GERMAN",1]="airgeddon. Passwort mit hashcat entschlüsselt"
	hashcat_texts["TURKISH",1]="airgeddon. Hashcat kullanarak şifreyi çözdü"
	hashcat_texts["ARABIC",1]="hashcat فك تشفير كلمة السر باستخدام .airgeddon"
	hashcat_texts["CHINESE",1]="airgeddon 使用 hashcat 解密密码"

	hashcat_texts["ENGLISH",2]="Enterprise user"
	hashcat_texts["SPANISH",2]="Usuario enterprise"
	hashcat_texts["FRENCH",2]="Nom d'utilisateur enterprise"
	hashcat_texts["CATALAN",2]="Nom d'usuari enterprise"
	hashcat_texts["PORTUGUESE",2]="Nome de usuário enterprise"
	hashcat_texts["RUSSIAN",2]="Пользователь в enterprise"
	hashcat_texts["GREEK",2]="Όνομα χρήστη enterprise"
	hashcat_texts["ITALIAN",2]="Utente enterprise"
	hashcat_texts["POLISH",2]="Użytkownik enterprise"
	hashcat_texts["GERMAN",2]="Enterprise-Benutzername"
	hashcat_texts["TURKISH",2]="Enterprise kullanıcı"
	hashcat_texts["ARABIC",2]="Enterprise مستخدم"
	hashcat_texts["CHINESE",2]="企业用户"

	hashcat_texts["ENGLISH",3]="Enterprise users and passwords"
	hashcat_texts["SPANISH",3]="Usuarios y contraseñas enterprise"
	hashcat_texts["FRENCH",3]="Utilisateurs et mots de passe d'entreprise"
	hashcat_texts["CATALAN",3]="Usuaris i contrasenyes enterprise"
	hashcat_texts["PORTUGUESE",3]="Usuários e senhas enterprise"
	hashcat_texts["RUSSIAN",3]="Пользователь и пароль в enterprise"
	hashcat_texts["GREEK",3]="Enterprise χρήστες και κωδικοί πρόσβασης"
	hashcat_texts["ITALIAN",3]="Utenti e password enterprise"
	hashcat_texts["POLISH",3]="Użytkownicy i hasła enterprise"
	hashcat_texts["GERMAN",3]="Enterprise-Benutzernamen und Kennwörter"
	hashcat_texts["TURKISH",3]="Enterprise kullanıcılar ve şifreler"
	hashcat_texts["ARABIC",3]="Enterprise مستخدمي وكلمات السر"
	hashcat_texts["CHINESE",3]="企业用户和密码"

	declare -gA aircrack_texts
	aircrack_texts["ENGLISH",0]="airgeddon. Decrypted password using aircrack"
	aircrack_texts["SPANISH",0]="airgeddon. Contraseña descifrada con aircrack"
	aircrack_texts["FRENCH",0]="airgeddon. Mot de passe déchiffré avec aircrack"
	aircrack_texts["CATALAN",0]="airgeddon. Contrasenya desxifrada amb aircrack"
	aircrack_texts["PORTUGUESE",0]="airgeddon descriptografou a senha usando aircrack"
	aircrack_texts["RUSSIAN",0]="airgeddon. Пароль расшифрован с использованием aircrack"
	aircrack_texts["GREEK",0]="airgeddon. Αποκρυπτογραφημένος κωδικός πρόσβασης με χρήση aircrack"
	aircrack_texts["ITALIAN",0]="airgeddon. Password decifrata con aircrack"
	aircrack_texts["POLISH",0]="airgeddon. Hasło odszyfrowane z użyciem aircrack"
	aircrack_texts["GERMAN",0]="airgeddon. Passwort mit aircrack entschlüsselt"
	aircrack_texts["TURKISH",0]="airgeddon. Aircrack kullanarak şifreyi çözdü"
	aircrack_texts["ARABIC",0]="aircrack فك تشفير كلمة السر باستخدام .airgeddon"
	aircrack_texts["CHINESE",0]="airgeddon 使用 aircrack 解密密码"

	declare -gA enterprise_texts
	enterprise_texts["ENGLISH",0]="Enterprise Evil Twin AP Info"
	enterprise_texts["SPANISH",0]="Info Evil Twin Enterprise AP"
	enterprise_texts["FRENCH",0]="Info Evil Twin Enterprise AP"
	enterprise_texts["CATALAN",0]="Info Evil Twin Enterprise AP"
	enterprise_texts["PORTUGUESE",0]="Informações do AP Evil Twin Enterprise"
	enterprise_texts["RUSSIAN",0]="Информация о Enterprise Evil Twin"
	enterprise_texts["GREEK",0]="Πληροφορίες Enterprise Evil Twin AP"
	enterprise_texts["ITALIAN",0]="Info Evil Twin Enterprise AP"
	enterprise_texts["POLISH",0]="Informacja o Evil Twin Enterprise AP"
	enterprise_texts["GERMAN",0]="Information über Evil Twin Enterprise AP"
	enterprise_texts["TURKISH",0]="Enterprise Şeytani İkiz AP Bilgisi"
	enterprise_texts["ARABIC",0]="Enterprise Evil Twin AP معلومات"
	enterprise_texts["CHINESE",0]="企业级加密 邪恶双胞胎 AP 信息"

	enterprise_texts["ENGLISH",1]="Channel"
	enterprise_texts["SPANISH",1]="Canal"
	enterprise_texts["FRENCH",1]="Canal"
	enterprise_texts["CATALAN",1]="Canal"
	enterprise_texts["PORTUGUESE",1]="Canal"
	enterprise_texts["RUSSIAN",1]="Канал"
	enterprise_texts["GREEK",1]="Κανάλι"
	enterprise_texts["ITALIAN",1]="Canale"
	enterprise_texts["POLISH",1]="Kanał"
	enterprise_texts["GERMAN",1]="Kanal"
	enterprise_texts["TURKISH",1]="Kanal"
	enterprise_texts["ARABIC",1]="قناة"
	enterprise_texts["CHINESE",1]="信道"

	enterprise_texts["ENGLISH",2]="Online time"
	enterprise_texts["SPANISH",2]="Tiempo online"
	enterprise_texts["FRENCH",2]="Temps en ligne"
	enterprise_texts["CATALAN",2]="Temps online"
	enterprise_texts["PORTUGUESE",2]="Tempo online"
	enterprise_texts["RUSSIAN",2]="Время онлайн"
	enterprise_texts["GREEK",2]="Χρόνος σε σύνδεση"
	enterprise_texts["ITALIAN",2]="Tempo online"
	enterprise_texts["POLISH",2]="Czas online"
	enterprise_texts["GERMAN",2]="Zeit online"
	enterprise_texts["TURKISH",2]="Çevrimiçi zaman"
	enterprise_texts["ARABIC",2]="المدة على الانترنت"
	enterprise_texts["CHINESE",2]="在线时间"

	enterprise_texts["ENGLISH",3]="On this attack, we'll wait for a network client to provide us a hash or a password for the Enterprise wifi network in our fake AP. You selected \"smooth\" mode, so as soon as one password or hash is captured, the attack will be dismantled. You can also stop it pressing [Enter] key on the main window"
	enterprise_texts["SPANISH",3]="Con este ataque, esperaremos a que algún cliente nos de un hash o su contraseña de la red wifi Enterprise en nuestro AP falso. Has seleccionado el modo \"smooth\", por lo que tan pronto se capture un hash o contraseña, el ataque se parará. También puedes parar el ataque pulsando la tecla [Enter] en la pantalla principal"
	enterprise_texts["FRENCH",3]="Avec cette attaque, nous attendrons qu'un client nous donne un hash ou son mot de passe pour le réseau wifi d'entreprise dans notre faux point d'accès. \"silencieux\" mode, donc dès qu'un hash ou un mot de passe soit capturé, l'attaque va s'arrêter. Vous pouvez également arrêter l'attaque en appuyant sur la touche [Enter] de l'écran principal"
	enterprise_texts["CATALAN",3]="Amb aquest atac, esperarem que algun client ens done un hash o la contrasenya de la xarxa wifi Enterprise en el nostre AP fals. Heu seleccionat el mode \"smooth\", de manera que tan aviat es capturi un hash o contrasenya, l'atac es pararà. També pots parar l'atac prement la tecla [Enter] a la pantalla principal"
	enterprise_texts["PORTUGUESE",3]="Com esse ataque vamos esperar que um cliente nos forneça uma hash ou senha para a rede wifi da empresa em nosso AP falso. No \"modo discreto\" assim que uma hash ou senha é capturada o ataque irá parar. Você também pode parar o ataque pressionando a tecla [Enter] na janela principal"
	enterprise_texts["RUSSIAN",3]="С этой атакой мы будем ждать, пока клиент сети в нашей поддельной ТД предоставит нам хэш или его пароль для сети Enterprise wifi. Вы выбрали режим \"smooth\", поэтому, как только хеш или пароль будут захвачены, атака остановится. Вы также можете остановить атаку, нажав клавишу [Enter] на главном экране"
	enterprise_texts["GREEK",3]="Σε αυτήν την επίθεση, θα περιμένουμε έναν πελάτη του δικτύου να μας δώσει ένα hash ή τον κωδικό του για το Enterprise wifi δίκτυο στο fake AP μας. \"smooth\", έτσι ώστε μόλις καταγραφεί ένα hash ή ένας κωδικός πρόσβασης, η επίθεση θα σταματήσει. Μπορείτε επίσης να σταματήσετε την επίθεση πατώντας το πλήκτρο [Enter] στην κύρια οθόνη"
	enterprise_texts["ITALIAN",3]="Con questo attacco, aspetteremo che un cliente ci dia un hash o la sua password per la rete wifi Enterprise attraverso il nostro AP falso. Hai selezione la modalità \"smooth\", quindi non appena viene catturato un hash o una password, l'attacco si interrompe. Puoi anche fermare l'attacco premendo il tasto [Enter] nella schermata principale"
	enterprise_texts["POLISH",3]="W tym ataku poczekamy aż klient poda nam hash lub hasło do sieci wifi Enterprise w naszym fałszywym AP. W trybie \"smooth\", gdy tylko hash lub hasło zostanie przechwycone atak się zatrzyma. Możesz także zatrzymać atak naciskając klawisz [Enter] na ekranie głównym"
	enterprise_texts["GERMAN",3]="Mit diesem Angriff werden wir darauf warten, dass uns ein Kunde einen Hash oder sein Passwort für das Enterprise WLAN-Netzwerk in unserem gefälschten AP gibt. Mit dem \"smooth\" Modus wird der Angriff sobald ein Hash oder Passwort erfasst wurde beenden. Sie können den Angriff auch durch Drücken der [Enter]-Taste auf dem Hauptbildschirm stoppen"
	enterprise_texts["TURKISH",3]="Bu saldırı ile, bir clientin sahte AP'deki Enterprise wifi ağı için bize bir hash veya şifre vermesini bekleyeceğiz. \"smooth\" modunu seçtiniz, böylece bir hash veya şifre yakalanır yakalanmaz saldırı duracaktır. Ana ekranda [Enter] tuşuna basarak da saldırıyı durdurabilirsiniz"
	enterprise_texts["ARABIC",3]="[Enter] وبمجرد التقاط كلمة مرور أو تجزئة واحدة ، سيتم تفكيك الهجوم. يمكنك أيضًا إيقافه بالضغط على مفتاح \"smooth\" في نقطة الوصول المزيفة. لقد حددت الوضع Enterprise wifi في هذا الهجوم ، سننتظر حتى يقوم عميل الشبكة بتزويدنا بتجزئة أو كلمة مرور لشبكة"
	enterprise_texts["CHINESE",3]="在这次攻击中，我们将等待网络客户端在我们的假 AP 中为我们提供企业级加密 wifi 网络的哈希值或密码。您选择了“平滑”模式，因此一旦捕获到某个密码或哈希值，攻击就会被解除。您也可以在主窗口按 [Enter] 键停止它"

	enterprise_texts["ENGLISH",4]="On this attack, we'll wait for a network client to provide us a hash or a password for the Enterprise wifi network in our fake AP. You selected \"noisy\" mode, so the attack won't stop until you press [Enter] key on the main window"
	enterprise_texts["SPANISH",4]="Con este ataque, esperaremos a que algún cliente nos de un hash o su contraseña de la red wifi Enterprise en nuestro AP falso. Has seleccionado el modo \"noisy\", por lo que el ataque no parará hasta que pulses la tecla [Enter] en la pantalla principal"
	enterprise_texts["FRENCH",4]="Avec cette attaque, nous attendrons qu'un client nous donne un hash ou son mot de passe pour le réseau de wifi entreprise dans notre faux point d'accès. Vous avez sélectionné le mode \"bruyant\", donc l'attaque ne s'arrêtera pas tant que vous n'appuyez pas sur la touche [Enter] de l'écran principal"
	enterprise_texts["CATALAN",4]="Amb aquest atac, esperarem que algun client ens done un hash o la contrasenya de la xarxa wifi Enterprise en el nostre AP fals. Heu seleccionat el mode \"noisy\", de manera que l'atac no pararà fins que premis la tecla [Enter] a la pantalla principal"
	enterprise_texts["PORTUGUESE",4]="Com esse ataque vamos esperar que um cliente nos forneça uma hash ou senha para a rede wifi da empresa em nosso AP falso. Você selecionou o \"modo agressivo\", então o ataque não irá parar até que você pressione a tecla [Enter] na janela principal"
	enterprise_texts["RUSSIAN",4]="С этой атакой мы будем ждать, пока клиент предоставит нам хэш или его пароль для сети Enterprise wifi в нашей поддельной AP. Вы выбрали режим \"noisy\", поэтому атака не остановится, пока вы не нажмёте клавишу [Enter] на главном экране"
	enterprise_texts["GREEK",4]="Σε αυτήν την επίθεση, θα περιμένουμε έναν πελάτη του δικτύου να μας δώσει ένα hash ή τον κωδικό του για το Enterprise wifi δίκτυο στο fake AP μας. Έχετε επιλέξει τη λειτουργία \"noisy\", οπότε η επίθεση δεν θα σταματήσει μέχρι να πατήσετε το πλήκτρο [Enter] στην κύρια οθόνη"
	enterprise_texts["ITALIAN",4]="Con questo attacco, aspetteremo che un cliente ci dia un hash o la sua password per la rete wifi Enterprise attraverso il nostro AP falso. Hai selezionato la modalità \"noisy\", quindi l'attacco non si fermerà finché non premi il tasto [Enter] nella schermata principale"
	enterprise_texts["POLISH",4]="W tym ataku poczekamy aż klient poda nam skrót lub hasło do sieci wifi Enterprise w naszym fałszywym AP. Wybrałeś tryb \"noisy\" więc atak nie zostanie zatrzymany dopóki nie naciśniesz klawisza [Enter] na głównym ekranie"
	enterprise_texts["GERMAN",4]="Mit diesem Angriff werden wir darauf warten, dass uns ein Kunde einen Hash oder sein Passwort für das Enterprise Wi-Fi-Netzwerk in unserem gefälschten AP gibt. Sie haben den \"noisy\" Modus gewählt, der Angriff wird somit nicht stoppen, bis Sie die [Enter]-Taste auf dem Hauptbildschirm drücken"
	enterprise_texts["TURKISH",4]="Bu saldırı ile, bir clientin sahte AP'deki Enterprise wifi ağı için bize bir hash veya şifresini vermesini bekleyeceğiz. \"noisy\" modunu seçtiniz, bu yüzden ana ekranda [Enter] tuşuna basana kadar saldırı durmayacak"
	enterprise_texts["ARABIC",4]="[Enter] وبمجرد التقاط كلمة مرور أو تجزئة واحدة ، سيتم تفكيك الهجوم. يمكنك أيضًا إيقافه بالضغط على مفتاح \"noisy\" في نقطة الوصول المزيفة. لقد حددت الوضع Enterprise wifi في هذا الهجوم ، سننتظر حتى يقوم عميل الشبكة بتزويدنا بتجزئة أو كلمة مرور لشبكة"
	enterprise_texts["CHINESE",4]="在这次攻击中，我们将等待网络客户端在我们的假 AP 中为我们提供企业 wifi 网络的哈希值或密码。您选择了“嘈杂”模式，因此在您按下主窗口上的 [Enter] 键之前攻击都不会停止"

	enterprise_texts["ENGLISH",5]="Last captured user"
	enterprise_texts["SPANISH",5]="Último usuario capturado"
	enterprise_texts["FRENCH",5]="Dernier utilisateur capturé"
	enterprise_texts["CATALAN",5]="Darrer usuari capturat"
	enterprise_texts["PORTUGUESE",5]="Último usuário capturado"
	enterprise_texts["RUSSIAN",5]="Последний захваченный пользователь"
	enterprise_texts["GREEK",5]="Τελευταίος χρήστης που καταγράφηκε"
	enterprise_texts["ITALIAN",5]="Ultimo utente catturato"
	enterprise_texts["POLISH",5]="Ostatni przechwycony użytkownik"
	enterprise_texts["GERMAN",5]="Letzter erfasste Nutzer"
	enterprise_texts["TURKISH",5]="Son yakalanan kullanıcı"
	enterprise_texts["ARABIC",5]="آخرمستخدم تم القبض عليه"
	enterprise_texts["CHINESE",5]="最后捕获的用户"

	enterprise_texts["ENGLISH",6]="Nothing captured yet"
	enterprise_texts["SPANISH",6]="Aún no se ha capturado nada"
	enterprise_texts["FRENCH",6]="Rien encore a été capturé"
	enterprise_texts["CATALAN",6]="Encara no s'ha capturat res"
	enterprise_texts["PORTUGUESE",6]="Nada foi capturado ainda"
	enterprise_texts["RUSSIAN",6]="Пока ничего не захвачено"
	enterprise_texts["GREEK",6]="Τίποτα δεν έχει καταγραφεί ακόμα"
	enterprise_texts["ITALIAN",6]="Non è stato ancora catturato niente"
	enterprise_texts["POLISH",6]="Jeszcze nic nie zostało przechwycone"
	enterprise_texts["GERMAN",6]="Nichts wurde bisher erfasst"
	enterprise_texts["TURKISH",6]="Henüz yakalanan bir şey yok"
	enterprise_texts["ARABIC",6]="لم يتم التقاط أي شيء حتى الآن"
	enterprise_texts["CHINESE",6]="尚未捕获任何内容"

	enterprise_texts["ENGLISH",7]="Captured hashes"
	enterprise_texts["SPANISH",7]="Hashes capturados"
	enterprise_texts["FRENCH",7]="Hashes capturés"
	enterprise_texts["CATALAN",7]="Hashes capturats"
	enterprise_texts["PORTUGUESE",7]="Hashes capturadas"
	enterprise_texts["RUSSIAN",7]="Захваченные хеши"
	enterprise_texts["GREEK",7]="Καταγεγραμμένα hashes"
	enterprise_texts["ITALIAN",7]="Hash catturati"
	enterprise_texts["POLISH",7]="Przechwycone hashe"
	enterprise_texts["GERMAN",7]="Erfasste Hashes"
	enterprise_texts["TURKISH",7]="Yakalanan hashler"
	enterprise_texts["ARABIC",7]="التجزئات الملتقطة"
	enterprise_texts["CHINESE",7]="捕获的哈希值"

	enterprise_texts["ENGLISH",8]="Captured plain text passwords"
	enterprise_texts["SPANISH",8]="Contraseñas en texto plano capturadas"
	enterprise_texts["FRENCH",8]="Mots de passe en texte brut capturés"
	enterprise_texts["CATALAN",8]="Contrasenyes en text pla capturades"
	enterprise_texts["PORTUGUESE",8]="Senhas em texto simples capturadas"
	enterprise_texts["RUSSIAN",8]="Захвачены пароли в виде простого текста"
	enterprise_texts["GREEK",8]="Καταγεγραμμένοι κωδικοί απλού κειμένου"
	enterprise_texts["ITALIAN",8]="Password in chiaro acquisite"
	enterprise_texts["POLISH",8]="Przechwycone hasła w tekscie jawnym"
	enterprise_texts["GERMAN",8]="Erfasste Klartextpasswörter"
	enterprise_texts["TURKISH",8]="Yakalanan text şifreler"
	enterprise_texts["ARABIC",8]="كلمات السر الملتقطة"
	enterprise_texts["CHINESE",8]="捕获的明文密码"

	enterprise_texts["ENGLISH",9]="Press [Enter] on the main script window to continue, this window will be closed and the files will be generated"
	enterprise_texts["SPANISH",9]="Pulsa [Enter] en la ventana principal del script para continuar, esta ventana se cerrará y los ficheros serán generados"
	enterprise_texts["FRENCH",9]="Appuyez sur [Enter] dans la fenêtre principale du script pour continuer, cette fenêtre sera fermée et les fichiers seront générés"
	enterprise_texts["CATALAN",9]="Prem [Enter] a la finestra principal del script per continuar, aquesta finestra es tancarà i els fitxers seran generats"
	enterprise_texts["PORTUGUESE",9]="Para continuar pressione [Enter] na janela principal do script, esta janela será fechada e os arquivos serão gerados"
	enterprise_texts["RUSSIAN",9]="Нажмите [Enter] в главном окне для продолжения, это окно будет закрыто и файлы будут сгенерированы"
	enterprise_texts["GREEK",9]="Πατήστε [Enter] στο κύριο παράθυρο του script για να συνεχίσετε, το παράθυρο αυτό θα κλείσει και θα δημιουργηθούν τα ανάλογα αρχεία"
	enterprise_texts["ITALIAN",9]="Premi il tasto [Enter] nella finestra principale dello script per continuare, questa finestra si chiuderà e i file verranno generati"
	enterprise_texts["POLISH",9]="Wciśnij [Enter] w oknie głównym skryptu aby kontynuować, to okno zostanie zamknięte a pliki zostaną wygenerowane"
	enterprise_texts["GERMAN",9]="Drücken Sie die [Enter]-Taste im Hauptfenster um fortzufahren. Dieses Fenster wird geschlossen und die Dateien werden generiert"
	enterprise_texts["TURKISH",9]="Devam etmek için [Enter] tuşuna basınız, bu sayfa kapatılacaktır ve dosyalar oluşturulacak"
	enterprise_texts["ARABIC",9]="في نافذة البرنامج الرئيسية للمتابعة ، سيتم إغلاق هذه النافذة وسيتم إنشاء الملفات  [Enter]  اضغط على"
	enterprise_texts["CHINESE",9]="在脚本主窗口按 [Enter] 键继续，该窗口将关闭并生成文件"

	enterprise_texts["ENGLISH",10]="The captured files will be saved on directory"
	enterprise_texts["SPANISH",10]="Los ficheros capturados se guardarán en el directorio"
	enterprise_texts["FRENCH",10]="Les fichiers capturés seront enregistrés dans le répertoire"
	enterprise_texts["CATALAN",10]="Els fitxers capturats es guardaran al directori"
	enterprise_texts["PORTUGUESE",10]="Os arquivos capturados serão salvos no diretório"
	enterprise_texts["RUSSIAN",10]="Захваченные файлы будут сохранены в каталоге"
	enterprise_texts["GREEK",10]="Τα αρχεία που έχουν καταγραφεί θα αποθηκευτούν στον κατάλογο"
	enterprise_texts["ITALIAN",10]="I file catturati verranno salvati nella directory"
	enterprise_texts["POLISH",10]="Przechwycone pliki zostaną zapisane w katalogu"
	enterprise_texts["GERMAN",10]="Die erfassten Dateien werden im Verzeichnis gespeichert"
	enterprise_texts["TURKISH",10]="Yakalanan dosyalar dizine kaydedilecek"
	enterprise_texts["ARABIC",10]="سيتم حفظ الملفات الملتقطة في المجلد"
	enterprise_texts["CHINESE",10]="捕获的文件将保存在文件夹中"

	enterprise_texts["ENGLISH",11]="airgeddon. Captured passwords during Enterprise Evil Twin"
	enterprise_texts["SPANISH",11]="airgeddon. Contraseñas capturadas en Evil Twin Enterprise"
	enterprise_texts["FRENCH",11]="airgeddon. Mots de passe capturés dans Evil Twin Enterprise"
	enterprise_texts["CATALAN",11]="airgeddon. Contrasenyes capturades en Evil Twin Enterprise"
	enterprise_texts["PORTUGUESE",11]="airgeddon. Senhas capturadas no Ataque Evil Twin Enterprise"
	enterprise_texts["RUSSIAN",11]="airgeddon. По время Evil Twin Enterprise захвачены пароли"
	enterprise_texts["GREEK",11]="airgeddon. Κωδικοί που καταγράφηκαν στο Enterprise Evil Twin"
	enterprise_texts["ITALIAN",11]="airgeddon. Password catturate con Evil Twin Enterprise"
	enterprise_texts["POLISH",11]="airgeddon. Hasła przechwycone w Evil Twin Enterprise"
	enterprise_texts["GERMAN",11]="airgeddon. Erfasste Passwörter während Evil Twin Enterprise"
	enterprise_texts["TURKISH",11]="airgeddon. Evil Twin Enterprise'da yakalanan şifreler"
	enterprise_texts["ARABIC",11]="Enterprise Evil Twin تم التقاط كلمات السرأثناء .airgeddon"
	enterprise_texts["CHINESE",11]="airgeddon 在企业级加密的邪恶双胞胎攻击期间捕获的密码"

	declare -gA footer_texts
	footer_texts["ENGLISH",0]="If you enjoyed the script and found it useful, you can support the project by making a donation. Through PayPal (${mail}) or sending a fraction of cryptocurrency (Bitcoin, Ethereum, Litecoin...). Any amount, no matter how small (1, 2, 5 $/€) is welcome. More information and direct links to do it at: ${urlgithub_wiki}/Contributing"
	footer_texts["SPANISH",0]="Si te gustó el script y te pareció útil, puedes apoyar el proyecto haciendo una donación. A través de PayPal (${mail}) o enviando una fracción de criptomoneda (Bitcoin, Ethereum, Litecoin...). Cualquier cantidad por pequeña que sea (1, 2, 5 $/€) es bien recibida. Más información y enlaces directos para realizarla en: ${urlgithub_wiki}/Contributing"
	footer_texts["FRENCH",0]="Si le script vous a plus et que vous l'avez trouvé utile, vous pouvez soutenir le projet en faisant un don PayPal (${mail}) ou en envoyant une fraction de crypto-monnaie (Bitcoin, Ethereum, Litecoin...). Toute contribution (1, 2, 5 $/€) est bienvenue. Pour faire un don allez à: ${urlgithub_wiki}/Contributing"
	footer_texts["CATALAN",0]="Si et va agradar el script i et va semblar útil, pots donar suport al projecte fent una donació. A través de PayPal (${mail}) o enviant una fracció criptomoneda (Bitcoin, Ethereum, Litecoin...). Qualsevol quantitat per petita que sigui (1, 2, 5 $/€) és ben rebuda. Més informació i enllaços directes per a realitzar-la en: ${urlgithub_wiki}/Contributing"
	footer_texts["PORTUGUESE",0]="Se você gostou do script e o achou útil, apoie o projeto fazendo uma doação através: do PayPal (${mail}) ou enviando uma fração de uma criptomoeda (Bitcoin, Ethereum, Litecoin...). Qualquer quantidade, mesmo pequena (1, 2, 5 $/€) é bem-vinda. Links diretos e de com realizar em: ${urlgithub_wiki}/Contributing"
	footer_texts["RUSSIAN",0]="Если вам понравилась эта программа и она оказалась для вас полезной, вы можете поддержать проект, сделав пожертвование. Доступны переводы через PayPal (${mail}) и криптовалюту (Bitcoin, Ethereum, Litecoin...). Приветствуется любая сумма, даже небольшая (1, 2, 5 $/€). Более подробную информацию и прямые ссылки можно получить по адресу: ${urlgithub_wiki}/Contributing"
	footer_texts["GREEK",0]="Εαν μείνατε ευχαριστημένοι από το script και το βρήκατε χρήσιμο, μπορείτε να υποστηρίξετε το project κάνοντας κάποια δωρεά. Μέσω PayPal (${mail}) ή αποστέλλοντας κάποιο κλάσμα κρυπτονομίσματος (Bitcoin, Ethereum, Litecoin...). Είναι καλοδεχούμενο οποιοδήποτε ποσό (1, 2, 5 $/€), δεν έχει σημασία το πόσο λίγο μπορεί να είναι. Δίνονται περισσότερες πληροφορίες και links για να κάνετε δωρεά, στη διεύθυνση: ${urlgithub_wiki}/Contributing"
	footer_texts["ITALIAN",0]="Se ti è piaciuto lo script e l'hai trovato utile, puoi sostenere il progetto con una donazione. Attraverso PayPal (${mail}) o inviando una frazione di criptovaluta (Bitcoin, Ethereum, Litecoin...). Qualsiasi importo per quanto piccolo (1, 2, 5 $/€) è ben accolto. Piú informazioni e collegamenti diretti per realizzarla in: ${urlgithub_wiki}/Contributing"
	footer_texts["POLISH",0]="Jeśli podobał Ci się ten skrypt i okazał się użyteczny, możesz poprzeć ten projekt, składając donację. Za pośrednictwem usługi PayPal (${mail}) lub wysyłając ułamek kryptowaluty (Bitcoin, Ethereum, Litecoin...). Każda kwota, nawet malutka (1, 2, 5 $/€) będzie mile widziana. Więcej informacji i linki do donacji: ${urlgithub_wiki}/Contributing"
	footer_texts["GERMAN",0]="Wenn Ihnen das Skript gefallen hat und Sie es nützlich fanden, können Sie das Projekt mit einer Spende unterstützen. Durch PayPal (${mail}) oder durch Senden eines Bruchteils von Kryptowährung (Bitcoin, Ethereum, Litecoin...). Jeder kleine Betrag (1, 2, 5 $/€) wird gut angenommen. Weitere Informationen und direkte Links dazu finden Sie unter: ${urlgithub_wiki}/Contributing"
	footer_texts["TURKISH",0]="Eğer bu yazılımı kullanışlı ve eğlenceli bulduysanız, bize bağış yaparak destekte bulunabilirsiniz. PayPal üzerinden (${mail}) ya da herhangi bir kripto para birimi ile (Bitcoin, Ethereum, Litecoin...) Yolladığınız miktarın küçüklüğü fark etmez (1, 2, 5 $/€). Daha fazla fazla bilgi için linkler: ${urlgithub_wiki}/Contributing"
	footer_texts["ARABIC",0]="${urlgithub_wiki}/Contributing :نرحب بأي مبلغ مهما كان صغيرا (1 ، 2 ، 5 دولارات / يورو). مزيد من المعلومات والروابط المباشرة للقيام بذلك على  .(Bitcoin, Ethereum, Litecoin...) أو إرسال جزء بسيط من العملة المشفرة  PayPal (${mail})  إذا كنت قد استمتعت بالبرنامج ووجدته مفيدًا ، فيمكنك دعم المشروع من خلال التبرع. من خلال"
	footer_texts["CHINESE",0]="如果您喜欢该脚本并发现它很有用，您可以通过捐赠来支持该项目。通过 PayPal (${mail}) 或一点加密货币来付款 (比特币、以太币、莱特币...) 。欢迎任何金额，无论金额多少 (1、2、5 ￥/$/€) 。更多信息和直接链接: ${urlgithub_wiki}/Contributing"

	declare -gA arr
	arr["ENGLISH",0]="This interface \${current_iface_on_messages} is already in managed mode"
	arr["SPANISH",0]="Esta interfaz \${current_iface_on_messages} ya está en modo managed"
	arr["FRENCH",0]="L'interface \${current_iface_on_messages} est déjà en mode managed"
	arr["CATALAN",0]="Aquesta interfície \${current_iface_on_messages} ja està en mode managed"
	arr["PORTUGUESE",0]="Esta interface \${current_iface_on_messages} já está em modo managed"
	arr["RUSSIAN",0]="Этот интерфейс \${current_iface_on_messages} уже в управляемом режиме"
	arr["GREEK",0]="Αυτή η διεπαφή \${current_iface_on_messages} είναι ήδη σε ετερόκλητη κατάσταση"
	arr["ITALIAN",0]="Questa interfaccia \${current_iface_on_messages} è già in modalità managed"
	arr["POLISH",0]="Ten interfejs \${current_iface_on_messages} jest już w trybie managed"
	arr["GERMAN",0]="Diese \${current_iface_on_messages}-Schnittstelle befindet sich bereits im managed Modus"
	arr["TURKISH",0]="Bu arayüz \${current_iface_on_messages} zaten yönetici modunda"
	arr["ARABIC",0]="Managed mode  في الوضع  \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",0]="此接口 \${current_iface_on_messages} 已处于管理模式"

	arr["ENGLISH",1]="This interface \${current_iface_on_messages} is not a wifi card. It doesn't support managed mode"
	arr["SPANISH",1]="Esta interfaz \${current_iface_on_messages} no es una tarjeta wifi. No soporta modo managed"
	arr["FRENCH",1]="L'interface \${current_iface_on_messages} n'est pas une carte wifi. Elle n'est donc pas compatible mode managed"
	arr["CATALAN",1]="Aquesta interfície \${current_iface_on_messages} no és una targeta wifi vàlida. No es compatible amb mode managed"
	arr["PORTUGUESE",1]="Esta interface \${current_iface_on_messages} não é wifi. Ela não suporta o modo managed"
	arr["RUSSIAN",1]="Этот интерфейс \${current_iface_on_messages} не является wifi картой. Он не поддерживает управляемый режим"
	arr["GREEK",1]="Αυτή η διεπαφή \${current_iface_on_messages} δεν είναι κάρτα wifi. Δεν υποστηρίζει ετερόκλητη κατάσταση"
	arr["ITALIAN",1]="Questa interfaccia \${current_iface_on_messages} non è una scheda wifi. Non supporta la modalità managed"
	arr["POLISH",1]="Interfejs \${current_iface_on_messages} nie jest kartą wifi. Nie obsługuje trybu zarządzania"
	arr["GERMAN",1]="Diese \${current_iface_on_messages}-Schnittstelle ist keine WIFI-Karte. Managed Modus ist nicht unterstützt"
	arr["TURKISH",1]="Bu arayüz \${current_iface_on_messages} wifi kart değildir. Yönetici modunu desteklemiyor"
	arr["ARABIC",1]="Managed mode  لذلك فهي لا تتحمل الوضع  .wifi  ليست بطاقة  \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",1]="这个接口 \${current_iface_on_messages} 不是 wifi 网卡。它不支持管理模式"

	arr["ENGLISH",2]="English O.S. language detected. Supported by script. Automatically changed"
	arr["SPANISH",2]="Idioma Español del S.O. detectado. Soportado por el script. Se cambió automáticamente"
	arr["FRENCH",2]="S.E. en Français détecté. Langue prise en charge par le script et changée automatiquement"
	arr["CATALAN",2]="Idioma Català del S.O. detectat. Suportat pel script. S'ha canviat automàticament"
	arr["PORTUGUESE",2]="S.O. em Português detectado. Compatível com o script. Idioma automaticamente alterada"
	arr["RUSSIAN",2]="Определена ОС на русском. Поддерживается скриптом. Локализация автоматически изменена. Помощь на русском: https://hackware.ru/?"
	arr["GREEK",2]="Εντοπίστηκε Ελληνική γλώσσα συστήματος. Υποστηρίξιμη από το script. Άλλαξε αυτόματα"
	arr["ITALIAN",2]="Lingua Italiana del S.O. rilevata. Supportata dallo script. Viene cambiata automaticamente"
	arr["POLISH",2]="Wykryto system operacyjny w języku Polskim. Obsługiwany przez skrypt. Zmieniono automatycznie"
	arr["GERMAN",2]="Deutsch als Betriebssystemsprache erkannt. Vom Skript unterstützt. Sie wurde automatisch geändert"
	arr["TURKISH",2]="Türkçe İşletim Sistemi tespit edildi. Yazılım tarafından otomatik olarak değiştirildi"
	arr["ARABIC",2]="تم الكشف أن اللغة العربية هي لغة نظام التشغيل. وهي متحملة من البرنامج. تغيرت اللغة تلقائيا"
	arr["CHINESE",2]="检测到您的操作系统语言是中文。由脚本支持。自动更改"

	arr["ENGLISH",3]="Select target network:"
	arr["SPANISH",3]="Selecciona la red objetivo:"
	arr["FRENCH",3]="Sélectionnez le réseau cible:"
	arr["CATALAN",3]="Selecciona la xarxa objectiu:"
	arr["PORTUGUESE",3]="Selecione uma rede como objetivo:"
	arr["RUSSIAN",3]="Выбор целевой сети:"
	arr["GREEK",3]="Διαλέξτε δίκτυο:"
	arr["ITALIAN",3]="Scegliere una rete come obiettivo:"
	arr["POLISH",3]="Wybierz sieć docelową:"
	arr["GERMAN",3]="Wählen Sie das Zielnetzwerk aus:"
	arr["TURKISH",3]="Hedef ağı seçiniz:"
	arr["ARABIC",3]=":حدد الشبكة المستهدفة"
	arr["CHINESE",3]="请选择目标网络:"

	arr["ENGLISH",4]="Press [Enter] key to start attack..."
	arr["SPANISH",4]="Pulse la tecla [Enter] para comenzar el ataque..."
	arr["FRENCH",4]="Pressez [Enter] pour commencer l'attaque..."
	arr["CATALAN",4]="Premi la tecla [Enter] per començar l'atac..."
	arr["PORTUGUESE",4]="Pressione [Enter] para iniciar o ataque..."
	arr["RUSSIAN",4]="Нажмите клавишу [Enter] для начала атаки..."
	arr["GREEK",4]="Πατήστε [Enter] για να ξεκινήσει η επίθεση..."
	arr["ITALIAN",4]="Premere il tasto [Enter] per iniziare l'attacco..."
	arr["POLISH",4]="Naciśnij klawisz [Enter], aby rozpocząć atak..."
	arr["GERMAN",4]="Drücken Sie die [Enter]-Taste um den Angriff zu starten..."
	arr["TURKISH",4]="Saldırıya başlamak için [Enter] tuşuna basınız..."
	arr["ARABIC",4]="...لبدء الهجوم  [Enter]  اضغط على مفتاح"
	arr["CHINESE",4]="按 [Enter] 键开始攻击..."

	arr["ENGLISH",5]="It looks like your internet connection is unstable. The script can't connect to repository. It will continue without updating..."
	arr["SPANISH",5]="Parece que tu conexión a internet no es estable. El script no puede conectar al repositorio. Continuará sin actualizarse..."
	arr["FRENCH",5]="Votre connexion internet est trop médiocre pour pouvoir se connecter aux dépôts comme ils se doit. Le script va s’exécuter sans s'actualiser..."
	arr["CATALAN",5]="Sembla que la teva connexió a internet no és estable. El script no pot connectar amb el repositori. Continuarà sense actualitzar-se..."
	arr["PORTUGUESE",5]="Parece que sua conexão com a internet não é estável. O script não pode conectar-se ao repositório. Ele continuará sem atualizar..."
	arr["RUSSIAN",5]="Интернет-подключение кажется нестабильным. Скрипт не может подключиться к репозиторию. Он продолжит без обновления..."
	arr["GREEK",5]="Φαίνεται πως η σύνδεση με το διαδίκτυο δεν είναι σταθερή. Το script δεν μπορεί να συνδεθεί στο αποθετήριο. Θα συνεχίσει χωρίς να έχει ενημερωθεί..."
	arr["ITALIAN",5]="Sembra che la connessione a internet non sia stabile. Lo script non riesce a connettersi al repository. Continuerà senza aggiornarsi..."
	arr["POLISH",5]="Wygląda na to, że połączenie internetowe nie jest stabilne. Skrypt nie może połączyć się z repozytorium. Będzie kontynuowany bez aktualizacji..."
	arr["GERMAN",5]="Anscheinend ist Ihre Internetverbindung nicht stabil. Das Skript kann keine Verbindung zum Repository herstellen. Es wird ohne Aktualisierung fortgesetzt..."
	arr["TURKISH",5]="Görünüşe göre internet bağlantınız dengesiz. Yazılım depoya bağlanamadı. Güncelleme olmadan devam edilecek..."
	arr["ARABIC",5]="...يبدو أن اتصالك بالإنترنت غير مستقر. البرنامج لا يمكنه الاتصال بالمستودع. سيستمر دون تحديث"
	arr["CHINESE",5]="您的互联网连接似乎不稳定。该脚本无法连接到 GitHub 远程仓库。它会继续运行而不更新..."

	arr["ENGLISH",6]="Welcome to airgeddon script \${normal_color}v\${airgeddon_version}"
	arr["SPANISH",6]="Bienvenid@ a airgeddon script \${normal_color}v\${airgeddon_version}"
	arr["FRENCH",6]="Bienvenue au script airgeddon \${normal_color}v\${airgeddon_version}"
	arr["CATALAN",6]="Benvingut a airgeddon script \${normal_color}v\${airgeddon_version}"
	arr["PORTUGUESE",6]="Bem-vindo ao script airgeddon \${normal_color}v\${airgeddon_version}"
	arr["RUSSIAN",6]="Добро пожаловать в скрипт airgeddon \${normal_color}v\${airgeddon_version}"
	arr["GREEK",6]="Καλωσήρθατε στο airgeddon \${normal_color}v\${airgeddon_version}"
	arr["ITALIAN",6]="Benvenuti a airgeddon script \${normal_color}v\${airgeddon_version}"
	arr["POLISH",6]="Witaj w skrypcie airgeddon \${normal_color}v\${airgeddon_version}"
	arr["GERMAN",6]="Willkommen bei airgeddon Skript \${normal_color}v\${airgeddon_version}"
	arr["TURKISH",6]="airgeddon yazılımına hoşgeldiniz \${normal_color}v\${airgeddon_version}"
	arr["ARABIC",6]="\${normal_color}v\${airgeddon_version}\${blue_color} airgeddon مرحبا بكم في"
	arr["CHINESE",6]="欢迎使用 airgeddon 脚本 \${normal_color}v\${airgeddon_version}"

	arr["ENGLISH",7]="This script is only for educational purposes. Be good boyz&girlz!"
	arr["SPANISH",7]="Este script se ha hecho sólo con fines educativos. Sed buen@s chic@s!"
	arr["FRENCH",7]="Ce script a été fait à des fins purement éducatives. Portez-vous bien!"
	arr["CATALAN",7]="Aquest script s'ha fet només amb fins educatius. Porteu-vos bé!"
	arr["PORTUGUESE",7]="Este script foi feito apenas para fins educacionais. Comportem-se!"
	arr["RUSSIAN",7]="Этот скрипт только для образовательных целей. Будьте хорошими мальчиками и девочками!"
	arr["GREEK",7]="Αυτό το script είναι για διδακτικούς σκοπούς. Να είστε φρόνιμοι!"
	arr["ITALIAN",7]="Questo script è stato fatto solo per scopi didattici. Fate i bravi!"
	arr["POLISH",7]="Ten skrypt został napisany tylko do celów edukacyjnych. Bądź grzeczny!"
	arr["GERMAN",7]="Dieses Skript wurde nur für Bildungszwecke erstellt. Seid brav, Jungs!"
	arr["TURKISH",7]="Bu yazılım sadece eğitim amaçlıdır. Akıllı olun çocuklar!"
	arr["ARABIC",7]="!هذا البرنامج هو فقط لأغراض تعليمية. كونوا أولاد وبنات جيدين"
	arr["CHINESE",7]="此脚本仅用于教育目的。请做个好孩子！"

	arr["ENGLISH",8]="Known compatible distros with this script:"
	arr["SPANISH",8]="Distros conocidas compatibles con este script:"
	arr["FRENCH",8]="Distros connues compatibles avec ce script:"
	arr["CATALAN",8]="Distros conegudes compatibles amb aquest script:"
	arr["PORTUGUESE",8]="Distros conhecidas compatíveis com este script:"
	arr["RUSSIAN",8]="Известно совместимые дистрибутивы:"
	arr["GREEK",8]="Γνώστες εκδόσεις που υποστηρίζουν αυτό το script:"
	arr["ITALIAN",8]="Distribuzioni note compatibili con questo script:"
	arr["POLISH",8]="Znane dystrybucje kompatybilne z tym skryptem:"
	arr["GERMAN",8]="Bekannte Distros, die mit diesem Skript kompatibel sind:"
	arr["TURKISH",8]="Bu komut dosyasıyla bilinen uyumlu dağıtımlar:"
	arr["ARABIC",8]=":التوزيعات المتوافقة المعروفة مع هذا البرنامج"
	arr["CHINESE",8]="与此脚本兼容的已知的 Linux 发行版:"

	arr["ENGLISH",9]="Detecting system..."
	arr["SPANISH",9]="Detectando sistema..."
	arr["FRENCH",9]="Détection du système..."
	arr["CATALAN",9]="Detecció del sistema..."
	arr["PORTUGUESE",9]="Detectando sistema..."
	arr["RUSSIAN",9]="Определяем систему..."
	arr["GREEK",9]="Το σύστημα εντοπίζεται..."
	arr["ITALIAN",9]="Rilevando sistema..."
	arr["POLISH",9]="Wykrywanie systemu..."
	arr["GERMAN",9]="Systemerkennung..."
	arr["TURKISH",9]="Sistem tespit ediliyor..."
	arr["ARABIC",9]="...الكشف عن النظام"
	arr["CHINESE",9]="检测到当前系统..."

	arr["ENGLISH",10]="This interface \${current_iface_on_messages} is already in monitor mode"
	arr["SPANISH",10]="Esta interfaz \${current_iface_on_messages} ya está en modo monitor"
	arr["FRENCH",10]="L'interface \${current_iface_on_messages} est déjà en mode moniteur"
	arr["CATALAN",10]="Aquesta interfície \${current_iface_on_messages} ja està en mode monitor"
	arr["PORTUGUESE",10]="Esta interface \${current_iface_on_messages} já está em modo monitor"
	arr["RUSSIAN",10]="Этот интерфейс \${current_iface_on_messages} уже в режиме монитора"
	arr["GREEK",10]="Αυτή η διεπαφή \${current_iface_on_messages} είναι ήδη σε κατάσταση παρακολούθησης"
	arr["ITALIAN",10]="Questa interfaccia \${current_iface_on_messages} è già in modalità monitor"
	arr["POLISH",10]="Ten interfejs \${current_iface_on_messages} jest już w trybie monitorowania"
	arr["GERMAN",10]="Diese \${current_iface_on_messages}-Schnittstelle befindet sich bereits im Monitor-Modus"
	arr["TURKISH",10]="Bu arayüz \${current_iface_on_messages} zaten izleme modunda"
	arr["ARABIC",10]="Monitor mode  في وضع  \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",10]="此接口 \${current_iface_on_messages} 已处于监控模式"

	arr["ENGLISH",11]="Exiting airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} - See you soon! :)"
	arr["SPANISH",11]="Saliendo de airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} - Nos vemos pronto! :)"
	arr["FRENCH",11]="Fermeture du script airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} - A bientôt! :)"
	arr["CATALAN",11]="Sortint de airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} - Ens veiem aviat! :)"
	arr["PORTUGUESE",11]="Saindo do script airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} - Até breve! :)"
	arr["RUSSIAN",11]="Выход из скрипта airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} - До встречи! :)"
	arr["GREEK",11]="Κλείσιμο του airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} - Αντίο! :)"
	arr["ITALIAN",11]="Abbandonando airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} - A presto! :)"
	arr["POLISH",11]="Wyjście z skryptu airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} - Do zobaczenia wkrótce! :)"
	arr["GERMAN",11]="Sie verlassen airgeddon Skript \${normal_color}v\${airgeddon_version}\${blue_color} - Bis bald! :)"
	arr["TURKISH",11]="airgeddon yazılımından çıkış yapılıyor \${normal_color}v\${airgeddon_version}\${blue_color} - Tekrar görüşürüz! :)"
	arr["ARABIC",11]="اراك قريبا! :) - \${normal_color}v\${airgeddon_version}\${blue_color} الخروج من البرنامج"
	arr["CHINESE",11]="退出 airgeddon 脚本 \${normal_color}v\${airgeddon_version}\${blue_color} - 待会见！:)"

	arr["ENGLISH",12]="\${blue_color}Interruption detected. \${green_color}Do you really want to exit? \${normal_color}\${visual_choice}"
	arr["SPANISH",12]="\${blue_color}Detectada interrupción. \${green_color}¿Quieres realmente salir del script? \${normal_color}\${visual_choice}"
	arr["FRENCH",12]="\${blue_color}Interruption détectée. \${green_color}Voulez-vous vraiment arrêter le script? \${normal_color}\${visual_choice}"
	arr["CATALAN",12]="\${blue_color}Interrupció detectada. \${green_color}¿Realment vols sortir de l'script? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",12]="\${blue_color}Interrupção detectada. \${green_color}Você quer realmente sair o script? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",12]="\${blue_color}Обнаружено прерывание. \${green_color}Вы действительно хотите выйти? \${normal_color}\${visual_choice}"
	arr["GREEK",12]="\${blue_color}Εντοπίστηκε διακοπή. \${green_color}Είστε σίγουροι ότι θέλετε να τερματίσετε το script; \${normal_color}\${visual_choice}"
	arr["ITALIAN",12]="\${blue_color}Rilevata interruzione. \${green_color}Vuoi davvero uscire dallo script? \${normal_color}\${visual_choice}"
	arr["POLISH",12]="\${blue_color}Wykryto przerwanie. \${green_color}Czy naprawdę chcesz wyjść ze skryptu? \${normal_color}\${visual_choice}"
	arr["GERMAN",12]="\${blue_color}Unterbrechung wurde erkannt. \${green_color}Wollen Sie wirklich aus dem Skript raus? \${normal_color}\${visual_choice}"
	arr["TURKISH",12]="\${blue_color}Kesinti algılandı. \${green_color}Gerçekten çıkış yapmak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",12]="\${normal_color}\${visual_choice} \${green_color}هل تريد حقًا الخروج؟ \${blue_color}.تم اكتشاف مقاطعة\${normal_color}"
	arr["CHINESE",12]="\${blue_color}检测到中断信号。\${green_color}您真的要退出吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",13]="This interface \${current_iface_on_messages} is not a wifi card. It doesn't support monitor mode"
	arr["SPANISH",13]="Esta interfaz \${current_iface_on_messages} no es una tarjeta wifi. No soporta modo monitor"
	arr["FRENCH",13]="L'interface \${current_iface_on_messages} n'est pas une carte wifi. Elle n'est pas compatible avec le mode moniteur"
	arr["CATALAN",13]="Aquesta interfície \${current_iface_on_messages} no és una targeta wifi vàlida. No es compatible amb mode monitor"
	arr["PORTUGUESE",13]="Esta interface \${current_iface_on_messages} não é wifi. Ela não suporta o modo monitor"
	arr["RUSSIAN",13]="Этот интерфейс \${current_iface_on_messages} не является wifi картой. Он не поддерживает режим монитора"
	arr["GREEK",13]="Αυτή η διεπαφή \${current_iface_on_messages} δεν έιναι κάρτα wifi. Δεν υποστηρίζει κατάσταση παρακολούθησης"
	arr["ITALIAN",13]="Questa interfaccia \${current_iface_on_messages} non è una scheda wifi. Non supporta la modalità del monitor"
	arr["POLISH",13]="Interfejs \${current_iface_on_messages} nie jest kartą wifi. Nie obsługuje trybu monitorowania"
	arr["GERMAN",13]="Diese \${current_iface_on_messages}-interface ist keine WLAN-Karte. Monitor-Modus ist nicht unterstützt"
	arr["TURKISH",13]="Bu arayüz \${current_iface_on_messages} bir wifi kartı değildir. İzleme modunu desteklemiyor"
	arr["ARABIC",13]="monitor mode لذلك فهي لا تتحمل الوضع .wifi  ليست بطاقة \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",13]="接口\${current_iface_on_messages}不是 wifi 网卡。不支持监听模式"

	arr["ENGLISH",14]="This interface \${current_iface_on_messages} is not in monitor mode"
	arr["SPANISH",14]="Esta interfaz \${current_iface_on_messages} no está en modo monitor"
	arr["FRENCH",14]="L'interface \${current_iface_on_messages} n'est pas en mode moniteur"
	arr["CATALAN",14]="Aquesta interfície \${current_iface_on_messages} no està en mode monitor"
	arr["PORTUGUESE",14]="Esta interface \${current_iface_on_messages} não está em modo monitor"
	arr["RUSSIAN",14]="Этот интерфейс \${current_iface_on_messages} не в режиме монитора"
	arr["GREEK",14]="Αυτή η διεπαφή \${current_iface_on_messages} δεν είναι σε κατάσταση παρακολούθησης"
	arr["ITALIAN",14]="Questa interfaccia \${current_iface_on_messages} non è in modalità monitor"
	arr["POLISH",14]="Ten interfejs \${current_iface_on_messages} nie jest w trybie monitorowania"
	arr["GERMAN",14]="Diese \${current_iface_on_messages}-Interface befindet sich nicht im Monitor-Modus"
	arr["TURKISH",14]="Bu arayüz \${current_iface_on_messages} izleme modunda değildir"
	arr["ARABIC",14]="monitor mode ليست في وضع \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",14]="此接口 \${current_iface_on_messages} 未处于监听模式"

	arr["ENGLISH",15]="The interface changed its name while setting in managed mode. Autoselected"
	arr["SPANISH",15]="Esta interfaz ha cambiado su nombre al ponerse en modo managed. Se ha seleccionado automáticamente"
	arr["FRENCH",15]="Le nom de l'interface a changé lors du passage en mode managed. Elle a été sélectionnée automatiquement"
	arr["CATALAN",15]="Aquesta interfície ha canviat de nom al posar-la en mode managed. S'ha triat automàticament"
	arr["PORTUGUESE",15]="Esta interface mudou de nome ao ser colocada em modo managed. Ela foi selecionada automaticamente"
	arr["RUSSIAN",15]="Интерфейс изменил имя во время перевода в управляемый режим. Выбран автоматически"
	arr["GREEK",15]="Η διεπάφη άλλαξε όνομα καθώς ήταν σε ετερόκλητη κατάσταση. Επιλέχθηκε αυτόματα"
	arr["ITALIAN",15]="Questa interfaccia ha cambiato il suo nome passando in modalità managed. È stata selezionata automaticamente"
	arr["POLISH",15]="Ten interfejs zmienił nazwę w trakcie uruchamiania trybu zarządzania. Wybrany automatycznie"
	arr["GERMAN",15]="Dieses Interface hat im Managed-Modus seinen Namen geändert. Es wurde automatisch ausgewählt"
	arr["TURKISH",15]="Arayüz ismi yönetici moduna alınırken değiştirildi. Otomatik olarak seçildi"
	arr["ARABIC",15]="تلقائيًا managed mode غيرت الواجهة اسمها أثناء الإعداد في الوضع"
	arr["CHINESE",15]="在管理模式下，接口名称已变更。自动重新选择"

	arr["ENGLISH",16]="Managed mode now is set on \${current_iface_on_messages}"
	arr["SPANISH",16]="Se ha puesto el modo managed en \${current_iface_on_messages}"
	arr["FRENCH",16]="\${current_iface_on_messages} est maintenant en mode manged"
	arr["CATALAN",16]="\${current_iface_on_messages} s'ha configurat en mode managed"
	arr["PORTUGUESE",16]="Modo managed configurado em \${current_iface_on_messages}"
	arr["RUSSIAN",16]="Управляемый режим теперь установлен на \${current_iface_on_messages}"
	arr["GREEK",16]="Η διεπαφή \${current_iface_on_messages} είναι τώρα σε ετερόκλητη κατάσταση"
	arr["ITALIAN",16]="\${current_iface_on_messages} è stata configurata in modalitá managed"
	arr["POLISH",16]="Tryb zarządzany został ustawiony na \${current_iface_on_messages}"
	arr["GERMAN",16]="Der Managed-Modus wurde auf \${current_iface_on_messages} festgelegt"
	arr["TURKISH",16]="Yönetici modu açıldı \${current_iface_on_messages}"
	arr["ARABIC",16]="managed mode  على \${current_iface_on_messages} الآن"
	arr["CHINESE",16]="管理接口现在设置为 \${current_iface_on_messages}"

	arr["ENGLISH",17]="Setting your interface in managed mode..."
	arr["SPANISH",17]="Poniendo la interfaz en modo managed..."
	arr["FRENCH",17]="L'interface est en train de passer en mode managed..."
	arr["CATALAN",17]="Configurant la interfície en mode managed..."
	arr["PORTUGUESE",17]="Colocando a interface em modo managed..."
	arr["RUSSIAN",17]="Переводим ваш интерфейс в управляемый режим..."
	arr["GREEK",17]="Ενεργοποιείται η ετερόκλητη κατάσταση στην διεπαφή..."
	arr["ITALIAN",17]="Mettendo l'interfaccia in modalità managed..."
	arr["POLISH",17]="Ustawianie interfejsu w trybie zarządzania..."
	arr["GERMAN",17]="Interface wird zum Managed-Modus versetzt..."
	arr["TURKISH",17]="Arayüzünüz yönetici moduna çeviriliyor..."
	arr["ARABIC",17]="...managed mode جارٍ ضبط واجهتك في الوضع"
	arr["CHINESE",17]="正在将您的接口设置为管理模式..."

	arr["ENGLISH",18]="Setting your interface in monitor mode..."
	arr["SPANISH",18]="Poniendo la interfaz en modo monitor..."
	arr["FRENCH",18]="L'interface est en train de passer en mode moniteur..."
	arr["CATALAN",18]="Configurant la interfície en mode monitor..."
	arr["PORTUGUESE",18]="Colocando a interface em modo monitor..."
	arr["RUSSIAN",18]="Переводим ваш интерфейс в режим монитора..."
	arr["GREEK",18]="Ενεργοποιείται η κατάσταση παρακολούθησης στην διεπαφή..."
	arr["ITALIAN",18]="Mettendo l'interfaccia modalità monitor..."
	arr["POLISH",18]="Ustawianie interfejsu w trybie monitorowania..."
	arr["GERMAN",18]="Interface wird in den Monitor-Modus gesetzt..."
	arr["TURKISH",18]="Arayüzünüz izleme moduna çeviriliyor..."
	arr["ARABIC",18]="...monitor mode جارٍ ضبط واجهتك في الوضع"
	arr["CHINESE",18]="正在将您的接口设置为监听模式..."

	arr["ENGLISH",19]="Please be patient. Maybe killing some conflicting processes..."
	arr["SPANISH",19]="Por favor ten paciencia. Puede que esté matando algunos procesos que podrían causar conflicto..."
	arr["FRENCH",19]="Soyez patients s'il vous plaît. Il se peut qu'il faile tuer des processus conflictuels..."
	arr["CATALAN",19]="Si us plau tinguis paciència. Pot ser que s'estiguin matant alguns processos que podrien causar conflicte..."
	arr["PORTUGUESE",19]="Por favor, seja paciente. Matando alguns processos que podem causar conflitos..."
	arr["RUSSIAN",19]="Пожалуйста, подождите. Возможно завершение некоторых конфликтующих процессов..."
	arr["GREEK",19]="Παρακαλώ δείξτε υπομονή. Ίσως τερματίζουν κάποιες εμπλέκουσες διεργασίες..."
	arr["ITALIAN",19]="Si prega di essere pazienti. Puó essere che si stiano terminando alcuni processi che potrebbero causare un conflitto..."
	arr["POLISH",19]="Cierpliwości. Zakańczam procesy, które mogłyby powodować konflikty..."
	arr["GERMAN",19]="Wir bitten um Geduld. Mögliche konfliktreiche Prozesse werden gerade gestoppt..."
	arr["TURKISH",19]="Lütfen sabırlı olun. Bazı çelişkili süreçler sonlandırılıyor..."
	arr["ARABIC",19]="...يرجى التحلي بالصبر. ربما  يجب قتل بعض العمليات المتضاربة"
	arr["CHINESE",19]="请耐心等待。也许会杀死一些有冲突的进程..."

	arr["ENGLISH",20]="This interface \${current_iface_on_messages} doesn't support monitor mode"
	arr["SPANISH",20]="Esta interfaz \${current_iface_on_messages} no soporta modo monitor"
	arr["FRENCH",20]="L'interface \${current_iface_on_messages} n'est pas compatible mode moniteur"
	arr["CATALAN",20]="Aquesta interfície \${current_iface_on_messages} no suporta mode monitor"
	arr["PORTUGUESE",20]="Esta interface \${current_iface_on_messages} não suporta o modo monitor"
	arr["RUSSIAN",20]="Этот интерфейс \${current_iface_on_messages} не поддерживает режим монитора"
	arr["GREEK",20]="Αυτή η διεπαφή \${current_iface_on_messages} δεν υποστηρίζει κατάσταση παρακολούθησης"
	arr["ITALIAN",20]="Questa interfaccia \${current_iface_on_messages} non supporta la modalità monitor"
	arr["POLISH",20]="Interfejs \${current_iface_on_messages} nie obsługuje trybu monitorowania"
	arr["GERMAN",20]="Diese \${current_iface_on_messages}-Interface unterstützt den Monitor-Modus nicht"
	arr["TURKISH",20]="Bu arayüz \${current_iface_on_messages} izleme modunu desteklemiyor"
	arr["ARABIC",20]="monitor mode لا تتحمل \${current_iface_on_messages} هذه الواجهة"
	arr["CHINESE",20]="此接口\${current_iface_on_messages}不支持监听模式"

	arr["ENGLISH",21]="The interface changed its name while setting in monitor mode. Autoselected"
	arr["SPANISH",21]="Esta interfaz ha cambiado su nombre al ponerla en modo monitor. Se ha seleccionado automáticamente"
	arr["FRENCH",21]="Le nom de l'interface a changé lors de l'activation du mode moniteur. Elle a été automatiquement sélectionnée"
	arr["CATALAN",21]="Aquesta interfície ha canviat de nom al posar-la en mode monitor. S'ha seleccionat automàticament"
	arr["PORTUGUESE",21]="Esta interface mudou de nome ao ser colocada em modo monitor. Ela foi selecionada automaticamente"
	arr["RUSSIAN",21]="Этот интерфейс изменил своё имя во время перевода в режим монитора. Выбран автоматически"
	arr["GREEK",21]="Η διεπαφή άλλαξε όνομα καθώς ήταν σε κατάσταση παρακολούθησης"
	arr["ITALIAN",21]="Questa interfaccia ha cambiato il suo nome passando in modalità monitor. È stata selezionata automaticamente"
	arr["POLISH",21]="Ten interfejs zmienił nazwę w trakcie uruchamiania trybu monitorowania. Wybrany automatycznie"
	arr["GERMAN",21]="Dieses Interface hat im Monitor-Modus seinen Namen geändert. Es wurde automatisch ausgewählt"
	arr["TURKISH",21]="Arayüz, monitör moduna girerken adını değiştirdi. Otomatik olarak seçildi"
	arr["ARABIC",21]="تلقائيًا monitor mode غيرت الواجهة اسمها أثناء الإعداد في وضع"
	arr["CHINESE",21]="在监听模式下，接口名称已变更。自动重新选择"

	arr["ENGLISH",22]="Monitor mode now is set on \${current_iface_on_messages}"
	arr["SPANISH",22]="Se ha puesto el modo monitor en \${current_iface_on_messages}"
	arr["FRENCH",22]="Mode moniteur activé sur l'interface \${current_iface_on_messages}"
	arr["CATALAN",22]="S'ha configurat el mode monitor en \${current_iface_on_messages}"
	arr["PORTUGUESE",22]="Modo monitor foi ativo em \${current_iface_on_messages}"
	arr["RUSSIAN",22]="Режим монитора установлен на \${current_iface_on_messages}"
	arr["GREEK",22]="Η διεπαφή \${current_iface_on_messages} είναι τώρα σε κατάσταση παρακολούθησης"
	arr["ITALIAN",22]="È stato impostato il modo monitor in \${current_iface_on_messages}"
	arr["POLISH",22]="Tryb monitorowania został ustawiony na \${current_iface_on_messages}"
	arr["GERMAN",22]="Monitor-Modus wurde auf \${current_iface_on_messages} gesetzt"
	arr["TURKISH",22]="İzleme modu açıldı \${current_iface_on_messages}"
	arr["ARABIC",22]="managed mode على \${current_iface_on_messages} الآن"
	arr["CHINESE",22]="监听接口现在已经设置为 \${current_iface_on_messages}"

	arr["ENGLISH",23]="There is a problem with the selected interface. Redirecting you to script exit"
	arr["SPANISH",23]="Hay un problema con la interfaz seleccionada. Redirigiendo a la salida del script"
	arr["FRENCH",23]="Il y a un problème avec l'interface choisie. Vous allez être dirigés vers la sortie du script"
	arr["CATALAN",23]="Hi ha un problema amb la interfície seleccionada. Redirigint cap a la sortida del script"
	arr["PORTUGUESE",23]="Existe um problema com a interface selecionada. Saindo do script"
	arr["RUSSIAN",23]="Проблема с выбранным интерфейсом. Перенаправляем вас к выходу из скрипта"
	arr["GREEK",23]="Υπάρχει πρόβλημε με την επιλεγμένη διεπαφή. Θα καθοδηγηθείτε στην έξοδο του script"
	arr["ITALIAN",23]="C'è un problema con l'interfaccia selezionata. Reindirizzando l'output dello script"
	arr["POLISH",23]="Wystąpił problem z wybranym interfejsem. Przekierowanie do wyjścia ze skryptu"
	arr["GERMAN",23]="Ein Problem ist mit dem ausgewählten Interface aufgetreten. Weiterleitung zur Ausgabe des Skripts"
	arr["TURKISH",23]="Seçilen arayüz ile ilgili bir problem oluştu. Yazılımdan çıkışa yönlendiriliyorsunuz"
	arr["ARABIC",23]="توجد مشكلة في الواجهة المحددة. إعادة توجيهك إلى الخروج من البرنامج"
	arr["CHINESE",23]="所选择的接口有问题。您将被重定向到脚本出口"

	arr["ENGLISH",24]="Select an interface to work with:"
	arr["SPANISH",24]="Selecciona una interfaz para trabajar con ella:"
	arr["FRENCH",24]="Sélectionnez l'interface pour travailler:"
	arr["CATALAN",24]="Seleccionar una interfície per treballar-hi:"
	arr["PORTUGUESE",24]="Selecione uma interface para trabalhar:"
	arr["RUSSIAN",24]="Выберите интерфейс для работы:"
	arr["GREEK",24]="Επιλέξτε διεπαφή:"
	arr["ITALIAN",24]="Seleziona un'interfaccia con cui lavorare:"
	arr["POLISH",24]="Wybierz interfejs:"
	arr["GERMAN",24]="Wählen Sie ein Interface aus, mit dem Sie arbeiten möchten:"
	arr["TURKISH",24]="Çalışmak için bir arayüz seçiniz:"
	arr["ARABIC",24]=":حدد واجهة للعمل بها"
	arr["CHINESE",24]="请选择要使用的网络接口:"

	arr["ENGLISH",25]="Set channel (1-14):"
	arr["SPANISH",25]="Selecciona un canal (1-14):"
	arr["FRENCH",25]="Sélectionnez un canal (1-14):"
	arr["CATALAN",25]="Seleccioni un canal (1-14):"
	arr["PORTUGUESE",25]="Escolha um canal (1-14):"
	arr["RUSSIAN",25]="Установите канал (1-14):"
	arr["GREEK",25]="Θέστε κανάλι (1-14):"
	arr["ITALIAN",25]="Seleziona un canale (1-14):"
	arr["POLISH",25]="Wybierz kanał (1-14):"
	arr["GERMAN",25]="Wähle einen Kanal (1-14):"
	arr["TURKISH",25]="Kanal ayarlayınız (1-14):"
	arr["ARABIC",25]=":(1-14) ضبط القناة"
	arr["CHINESE",25]="设置信道 (1-14):"

	arr["ENGLISH",26]="Channel set to \${normal_color}\${channel}"
	arr["SPANISH",26]="Canal elegido \${normal_color}\${channel}"
	arr["FRENCH",26]="Le canal \${normal_color}\${channel}\${blue_color} a été choisi"
	arr["CATALAN",26]="El canal \${normal_color}\${channel}\${blue_color} s'ha escollit"
	arr["PORTUGUESE",26]="Canal \${normal_color}\${channel}\${blue_color} selecionado"
	arr["RUSSIAN",26]="Выбран канал \${normal_color}\${channel}"
	arr["GREEK",26]="Το κανάλι \${normal_color}\${channel}\${blue_color} έχει επιλεχθεί"
	arr["ITALIAN",26]="Canale selezionato \${normal_color}\${channel}"
	arr["POLISH",26]="Wybrany kanał \${normal_color}\${channel}"
	arr["GERMAN",26]="Ausgewählter Kanal \${normal_color}\${channel}"
	arr["TURKISH",26]="Kanal şu şekilde ayarlandı \${normal_color}\${channel}"
	arr["ARABIC",26]="\${normal_color}\${channel}\${blue_color} القناة المختارة\${normal_color}"
	arr["CHINESE",26]="信道设置为 \${normal_color}\${channel}"

	arr["ENGLISH",27]="Type target BSSID (example: 00:11:22:33:44:55):"
	arr["SPANISH",27]="Escribe el BSSID objetivo (ejemplo: 00:11:22:33:44:55):"
	arr["FRENCH",27]="Veuillez entrer le BSSID de l'objectif (exemple: 00:11:22:33:44:55):"
	arr["CATALAN",27]="Escriu el BSSID objectiu (exemple: 00:11:22:33:44:55):"
	arr["PORTUGUESE",27]="Escreva o BSSID alvo (exemplo: 00:11:22:33:44:55):"
	arr["RUSSIAN",27]="Введите BSSID цели (пример: 00:11:22:33:44:55):"
	arr["GREEK",27]="Πληκτρολογήστε BSSID στόχου (παράδειγμα: 00:11:22:33:44:55):"
	arr["ITALIAN",27]="Scrivere l'BSSID obiettivo (es: 00:11:22:33:44:55):"
	arr["POLISH",27]="Wpisz BSSID celu (przykład: 00:11:22:33:44:55):"
	arr["GERMAN",27]="Geben Sie die Ziel-BSSID ein (Beispiel: 00:11:22:33:44:55):"
	arr["TURKISH",27]="Hedef türü BSSID (example: 00:11:22:33:44:55):"
	arr["ARABIC",27]=":(00:11:22:33:44:55:الهدف (مثال BSSID اكتب"
	arr["CHINESE",27]="请输入目标的 BSSID (例如: 00:11:22:33:44:55):"

	arr["ENGLISH",28]="BSSID set to \${normal_color}\${bssid}"
	arr["SPANISH",28]="BSSID elegido \${normal_color}\${bssid}"
	arr["FRENCH",28]="Le BSSID choisi est \${normal_color}\${bssid}"
	arr["CATALAN",28]="El BSSID escollit \${normal_color}\${bssid}"
	arr["PORTUGUESE",28]="BSSID escolhido \${normal_color}\${bssid}"
	arr["RUSSIAN",28]="Установленный BSSID: \${normal_color}\${bssid}"
	arr["GREEK",28]="Το BSSID τέθηκε σε \${normal_color}\${bssid}"
	arr["ITALIAN",28]="BSSID selezionato \${normal_color}\${bssid}"
	arr["POLISH",28]="Wybrany BSSID \${normal_color}\${bssid}"
	arr["GERMAN",28]="Gewählte BSSID \${normal_color}\${bssid}"
	arr["TURKISH",28]="BSSID şu şekilde ayarlandı \${normal_color}\${bssid}"
	arr["ARABIC",28]="\${normal_color}\${bssid}\${blue_color} المختار BSSID\${normal_color}"
	arr["CHINESE",28]="BSSID 设置为 \${normal_color}\${bssid}"

	arr["ENGLISH",29]="Type target ESSID:"
	arr["SPANISH",29]="Escribe el ESSID objetivo:"
	arr["FRENCH",29]="Écrivez l'ESSID du réseau cible:"
	arr["CATALAN",29]="Escriu el ESSID objectiu:"
	arr["PORTUGUESE",29]="Escreva o ESSID do alvo:"
	arr["RUSSIAN",29]="Введите BSSID цели:"
	arr["GREEK",29]="Πληκτρολογήστε ESSID στόχου:"
	arr["ITALIAN",29]="Scrivere l'ESSID obiettivo:"
	arr["POLISH",29]="Wpisz ESSID celu:"
	arr["GERMAN",29]="Geben Sie die Ziel ESSID ein:"
	arr["TURKISH",29]="Hedef türü ESSID:"
	arr["ARABIC",29]=":الهدف ESSID اكتب"
	arr["CHINESE",29]="请输入目标的 ESSID:"

	arr["ENGLISH",30]="\${blue_color}You haven't selected any target or you have selected a hidden network ESSID. This could be because you scanned few time or maybe the selected network has a hidden ESSID. These kind of networks will show their real ESSID only if a client connects while scanning and that could require so much time. If you already know the real ESSID of this target, it can be set manually. \${green_color}Do you want to set ESSID manually for this target network? \${normal_color}\${visual_choice}"
	arr["SPANISH",30]="\${blue_color}No tienes seleccionado ningún objetivo o has seleccionado un ESSID de red oculta. Esto podría deberse a que escaneste poco tiempo o quizás la red seleccionada tiene el ESSID oculto. Este tipo de redes mostrarán su ESSID real sólo si un cliente se conecta mientras escaneas pero eso podría requerir mucho tiempo. Si ya conoces el ESSID real de este objetivo, puedes configurarlo manualmente. \${green_color}¿Quieres configurar el ESSID manualmente para esta red objetivo? \${normal_color}\${visual_choice}"
	arr["FRENCH",30]="\${blue_color}Vous n'avez pas sélectionné aucune cible ou vous avez sélectionné un ESSID de réseau masqué. La raison peut être c'est que vous avez scanné plusieurs fois ou que le réseau sélectionné a un ESSID masqué. Ces types de réseaux afficheront leur véritable ESSID uniquement si un client se connecte pendant l'enumeration, mais il peut prendre beaucoup de temps. Si vous connaissez déjà le véritable ESSID de cette cible, il peut être défini manuellement. \${green_color}Voulez-vous définir l'ESSID manuellement pour ce réseau cible? \${normal_color}\${visual_choice}"
	arr["CATALAN",30]="\${blue_color}No has seleccionat cap objectiu o has seleccionat un ESSID de xarxa amagada. Això pot ser perquè has escanejat poc temps o potser la xarxa seleccionada té un ESSID amagat. Aquest tipus de xarxes només mostraran el seu ESSID real si un client es connecta mentre escanejes i això podria requerir molt de temps. Si ja saps l'ESSID real d'aquest objectiu, pots configurar-lo manualment. \${green_color}Vols configurar l'ESSID manualment per a aquesta xarxa objectiu? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",30]="\${blue_color}Você não selecionou nenhum alvo ou selecionou um ESSID de rede oculta. Isso pode ocorrer porque você escaneou pouco tempo ou talvez a rede selecionada tenha um ESSID oculto. Esse tipo de rede mostrará seu ESSID real somente se um cliente se conectar durante a varredura o que pode exigir muito tempo. Se você conhece o ESSID real do alvo, pode defini-lo manualmente. \${green_color}Deseja definir o ESSID manualmente para essa rede? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",30]="\${blue_color}Вы не выбрали цель, либо целевая сеть имеет скрытый ESSID.  Сети со скрытым ESSID раскроют свой реальный ESSID только в том случае, если во время сканирования к сети подключится клиент, что может занять очень много времени. Если вы уже знаете действительный ESSID целевой сети, его можно установить вручную. \${green_color}Хотите ли вы установить ESSID вручную? \${normal_color}\${visual_choice}"
	arr["GREEK",30]="\${blue_color}Δεν έχετε επιλέξει κανένα στόχο ή έχετε επιλέξει ένα κρυφό ESSID δίκτυο. Αυτό μπορεί να οφείλεται στο ότι σαρώσατε λίγες φορές ή ίσως το επιλεγμένο δίκτυο έχει ένα κρυφό ESSID. Αυτού του είδους τα δίκτυα θα εμφανίσουν το πραγματικό τους ESSID μόνο εάν ένα client συνδεθεί κατά τη σάρωση και αυτό μπορεί να απαιτήσει πολύ χρόνο. Εάν γνωρίζετε ήδη το πραγματικό ESSID αυτού του στόχου, μπορείτε να το ορίσετε χειροκίνητα. \${green_color}Θέλετε να ορίσετε το ESSID χειροκίνητα για αυτό το δίκτυο; \${normal_color}\${visual_choice}"
	arr["ITALIAN",30]="\${blue_color}Non hai selezionato nessun target o hai selezionato un ESSID di rete nascosta. Ciò potrebbe essere dovuto al fatto che hai eseguito la scansione poche volte o forse la rete selezionata ha un ESSID nascosto. Questo tipo di reti mostreranno il loro ESSID reale solo se un client si connette durante la scansione e ciò potrebbe richiedere molto tempo. Se conosci già l'ESSID reale di questo target, puoi impostarlo manualmente. \${green_color}Vuoi impostare manualmente l'ESSID per questa rete obiettivo? \${normal_color}\${visual_choice}"
	arr["POLISH",30]="\${blue_color}Nie wybrałeś żadnego celu lub wybrałeś ukryty identyfikator ESSID sieci. Może to być spowodowane tym, że skanowałeś kilka razy lub wybrana sieć ma ukryty ESSID. Tego rodzaju sieci pokażą swój prawdziwy ESSID tylko wtedy, gdy klient połączy się podczas skanowania, a to może zająć dużo czasu. Jeśli znasz już prawdziwy identyfikator ESSID tego celu, możesz go ustawić ręcznie. \${green_color}Czy chcesz ręcznie ustawić ESSID dla tej sieci docelowej? \${normal_color}\${visual_choice}"
	arr["GERMAN",30]="\${blue_color}Sie haben kein Ziel ausgewählt oder Sie haben eine versteckte Netzwerk-ESSID ausgewählt. Dies kann daran liegen, dass Sie nicht genug Zeit gescannt haben oder dass das ausgewählte Netzwerk eine versteckte ESSID hat. Versteckte ESSIDs zeigen ihre echte ESSID nur an, wenn ein Client während des Scannens eine Verbindung herstellt, und das kann sehr viel Zeit in Anspruch nehmen. Wenn Sie die tatsächliche ESSID dieses Ziels bereits kennen, können Sie sie manuell festlegen. \${green_color}Möchten Sie die ESSID für dieses Zielnetzwerk manuell festlegen? \${normal_color}\${visual_choice}"
	arr["TURKISH",30]="\${blue_color}Herhangi bir hedef seçmediniz veya gizli bir ağ ESSID'si seçtiniz. Bunun nedeni birkaç kez tarama yapmış olmanız veya seçilen ağın gizli bir ESSID'ye sahip olması olabilir. Bu tür ağlar gerçek ESSID'lerini yalnızca bir istemci tarama sırasında bağlanırsa gösterir ve bu çok fazla zaman gerektirir. Bu hedefin gerçek ESSID'sini zaten biliyorsanız manuel olarak ayarlanabilir. \${green_color}Bu hedef ağ için ESSID'yi manuel olarak ayarlamak ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",30]="\${normal_color}\${visual_choice} \${green_color}لهذة الشبكة يدوياً؟ ESSIDهل تريد ادخال ال\${blue_color} .الحقيقي لشبكة, يمكن تحديدها يدوياً ESSIDلحقيقي اذا اتصل العميل في خلال الفحص فقط و هذا قد يستغرق وقت طويل. اذا كنت تعلم ال ESSIDمخفى. هذا النوع من الشباكات سيظهر ال ESSIDلشبكة مختفيه. هذا قد يكون لانك لم تفحص لفترة كافية او اخترت شبكة ب ESSID لم يتم تحديد اي هدف او تم تحديد\${normal_color}"
	arr["CHINESE",30]="\${blue_color}您尚未选择任何目标或您选择了隐藏网络的 ESSID。这可能是因为您扫描的次数过少, 或所选网络可能具有隐藏 ESSID。此类网络仅当连接它时才会显示其真实的 ESSID。如果您已经知道该目标的真实 ESSID, 则可以手动设置。 \${green_color}您要为此目标网络手动设置 ESSID 吗? \${normal_color}\${visual_choice}"

	arr["ENGLISH",31]="ESSID set to \${normal_color}\${essid}"
	arr["SPANISH",31]="ESSID elegido \${normal_color}\${essid}"
	arr["FRENCH",31]="l'ESSID sélectionné est \${normal_color}\${essid}"
	arr["CATALAN",31]="l'ESSID seleccionat \${normal_color}\${essid}"
	arr["PORTUGUESE",31]="ESSID escolhido \${normal_color}\${essid}"
	arr["RUSSIAN",31]="Установленный ESSID: \${normal_color}\${essid}"
	arr["GREEK",31]="Το ESSID τέθηκε σε \${normal_color}\${essid}"
	arr["ITALIAN",31]="ESSID selezionato \${normal_color}\${essid}"
	arr["POLISH",31]="Wybrany ESSID \${normal_color}\${essid}"
	arr["GERMAN",31]="Gewählte ESSID \${normal_color}\${essid}"
	arr["TURKISH",31]="ESSID şu şekilde ayarlandı \${normal_color}\${essid}"
	arr["ARABIC",31]="\${normal_color}\${essid}\${blue_color} المختار ESSID\${normal_color}"
	arr["CHINESE",31]="ESSID 设置为 \${normal_color}\${essid}"

	arr["ENGLISH",32]="All parameters set"
	arr["SPANISH",32]="Todos los parámetros están listos"
	arr["FRENCH",32]="Tous les paramètres sont correctement établis"
	arr["CATALAN",32]="Tots els paràmetres establerts"
	arr["PORTUGUESE",32]="Todos os parâmetros configurados"
	arr["RUSSIAN",32]="Все параметры установлены"
	arr["GREEK",32]="Έχουν τεθεί όλοι οι παράμετροι"
	arr["ITALIAN",32]="Tutti i parametri sono pronti"
	arr["POLISH",32]="Wszystkie parametry są gotowe"
	arr["GERMAN",32]="Alle Parameter eingestellt"
	arr["TURKISH",32]="Tüm parametreler ayalandı"
	arr["ARABIC",32]="جميع المعلمات جاهزة"
	arr["CHINESE",32]="所有参数设置完毕"

	arr["ENGLISH",33]="Starting attack. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",33]="Comenzando ataque. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",33]="L'attaque est lancé. Pressez [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",33]="Començant l'atac. Un cop començat, premeu [Ctrl+C] per aturar-lo..."
	arr["PORTUGUESE",33]="Começando ataque. Uma vez iniciado, pressione [Ctrl+C] para parar..."
	arr["RUSSIAN",33]="Атака запускается. Нажмите [Ctrl+C] для остановки..."
	arr["GREEK",33]="Έναρξη επίθεσης. Όταν ξεκινήσει, πατήστε [Ctrl+C] για να σταματήσει..."
	arr["ITALIAN",33]="Cominciando l'attacco. Una volta avviato, premere [Ctrl+C] per fermare..."
	arr["POLISH",33]="Uruchomienie ataku. Waciśnij [Ctrl+C] w trakcie działania, aby go przerwać..."
	arr["GERMAN",33]="Angriff starten. Einmal gestartet, drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",33]="Saldırı başlıyor. Başladıktan sonra, durdurmak için [Ctrl+C] basınız..."
	arr["ARABIC",33]="...للإيقاف [Ctrl+C] بدء الهجوم. عند البدء ، اضغط على"
	arr["CHINESE",33]="开始攻击。按[Ctrl+C] 停止..."

	arr["ENGLISH",34]="Selected interface \${current_iface_on_messages} is in monitor mode. Attack can be performed"
	arr["SPANISH",34]="La interfaz seleccionada \${current_iface_on_messages} está en modo monitor. El ataque se puede realizar"
	arr["FRENCH",34]="L'interface \${current_iface_on_messages} qui a été sélectionnée est bien en mode moniteur. L'attaque peut être lancée"
	arr["CATALAN",34]="La interfície seleccionada \${current_iface_on_messages} està configurada en mode monitor. L'atac es pot realitzar"
	arr["PORTUGUESE",34]="Interface selecionada \${current_iface_on_messages} está em modo monitor. O ataque pode ser realizado"
	arr["RUSSIAN",34]="Выбранный интерфейс \${current_iface_on_messages} в режиме монитора. Можно выполнить атаку"
	arr["GREEK",34]="Η επιλεγμένη διεπαφή \${current_iface_on_messages} είναι σε κατάσταση παρακολούθησης. Μπορεί να γίνει επίθεση"
	arr["ITALIAN",34]="L'interfaccia selezionata \${current_iface_on_messages} è in modalità monitor. L'attacco può essere eseguito"
	arr["POLISH",34]="Wybrany interfejs \${current_iface_on_messages} jest w trybie monitorowania. Można wykonać atak"
	arr["GERMAN",34]="Das ausgewählte Interface \${current_iface_on_messages} befindet sich im Monitor-Modus. Der Angriff kann ausgeführt werden"
	arr["TURKISH",34]="Seçilen arayüz \${current_iface_on_messages} izleme modunda. Saldırı yapılabilir"
	arr["ARABIC",34]="يمكن تنفيذ الهجوم .monitor mode في وضع \${current_iface_on_messages} الواجهة المحددة"
	arr["CHINESE",34]="所选接口 \${current_iface_on_messages} 已处于监听模式。可以进行攻击"

	arr["ENGLISH",35]="Deauthentication / Dissasociation \${mdk_command} attack chosen (monitor mode needed)"
	arr["SPANISH",35]="Elegido ataque de Desautenticación / Desasociación \${mdk_command} (modo monitor requerido)"
	arr["FRENCH",35]="L'attaque de Dés-authentification / Dissociation \${mdk_command} a été choisie (mode moniteur nécessaire)"
	arr["CATALAN",35]="Seleccionat atac de Desautenticació / Dissociació \${mdk_command} (es requereix mode monitor)"
	arr["PORTUGUESE",35]="Ataque de desautenticação com \${mdk_command} (modo monitor obrigatório)"
	arr["RUSSIAN",35]="Выбрана \${mdk_command} атака Деаутентификации / Разъединения (необходим режим монитора)"
	arr["GREEK",35]="Deauthentication / Έχει επιλεχθεί επίθεση dissasociation \${mdk_command} (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",35]="Attacco Deauth / Disassociation \${mdk_command} scelto (modalità monitor richiesta)"
	arr["POLISH",35]="Wybrano atak Deauthentication / Disassociation \${mdk_command} (wymagany tryb monitorowania)"
	arr["GERMAN",35]="Deauthentication / Disassociation \${mdk_command} Angriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",35]="Deauthentication / Dissasociation \${mdk_command} saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",35]="(monitor mode يلزم وضع) \${mdk_command} Deauthentication / Dissasociation تم اختيار هجوم"
	arr["CHINESE",35]="选择 \${mdk_command} amok 解除身份验证攻击 (需要监听Aireplay deauth 参数模式)"

	arr["ENGLISH",36]="Deauthentication aireplay attack chosen (monitor mode needed)"
	arr["SPANISH",36]="Elegido ataque de Desautenticación aireplay (modo monitor requerido)"
	arr["FRENCH",36]="L'attaque de Dés-authentification aireplay a été choisie (mode moniteur nécessaire)"
	arr["CATALAN",36]="Seleccionat atac de Desautenticació aireplay (es requereix mode monitor)"
	arr["PORTUGUESE",36]="Ataque de desautenticação com Aireplay (modo monitor obrigatório)"
	arr["RUSSIAN",36]="Выбрана атака Деаутентификации с помощью Aireplay (необходим режим монитора)"
	arr["GREEK",36]="Έχει επιλεχθεί επίθεση deauthentication aireplay (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",36]="Attacco Deauth aireplay scelto (modalità monitor richiesta)"
	arr["POLISH",36]="Wybrano atak Deauthentication aireplay (wymagany tryb monitorowania)"
	arr["GERMAN",36]="Airplay-Deauthentifizierungsangriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",36]="Deauthentication aireplay saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",36]="(monitor mode يلزم وضع) Deauthentication aireplay تم اختيار هجوم"
	arr["CHINESE",36]="选择 aireplay 解除身份验证攻击 (需要监听模式)"

	arr["ENGLISH",37]="WIDS / WIPS / WDS Confusion attack chosen (monitor mode needed)"
	arr["SPANISH",37]="Elegido ataque Confusion WIDS / WIPS / WDS (modo monitor requerido)"
	arr["FRENCH",37]="L'attaque Confusion WIDS / WIPS / WDS a été choisie (mode moniteur nécessaire)"
	arr["CATALAN",37]="Seleccionat atac Confusion WIDS /WIPS / WDS (es requereix mode monitor)"
	arr["PORTUGUESE",37]="Ataque Confusion WIDS / WIPS / WDS (modo monitor obrigatório)"
	arr["RUSSIAN",37]="Выбрана атака запутывания WIDS / WIPS / WDS (необходим режим монитора)"
	arr["GREEK",37]="Έχει επιλεχθεί επίθεση σύγχυσης WIDS / WIPS / WDS (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",37]="Attacco Confusion / WIDS / WIPS / WDS scelto (modalità monitor richiesta)"
	arr["POLISH",37]="Wybrano ataki typu WIDS / WIPS / WDS Confusion (wymagany tryb monitorowania)"
	arr["GERMAN",37]="Confusion WIDS / WIPS / WDS Angriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",37]="WIDS / WIPS / WDS Confusion saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",37]="(monitor mode يلزم وضع) WIDS / WIPS / WDS Confusion تم اختيار هجوم"
	arr["CHINESE",37]="选择 WIDS / WIPS / WDS 混淆攻击 (需要监听模式)"

	arr["ENGLISH",38]="Beacon flood attack chosen (monitor mode needed)"
	arr["SPANISH",38]="Elegido ataque Beacon flood (modo monitor requerido)"
	arr["FRENCH",38]="L'attaque Beacon flood a été choisie (mode moniteur nécessaire)"
	arr["CATALAN",38]="Seleccionat atac Beacon flood (es requereix mode monitor)"
	arr["PORTUGUESE",38]="Ataque de Beacon flood (modo monitor obrigatório)"
	arr["RUSSIAN",38]="Выбрана атака флуд маяками (необходим режим монитора)"
	arr["GREEK",38]="Έχει επιλεχθεί επίθεση πλημμύρας φάρου (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",38]="Attacco Beacon flood scelto (modalità monitor richiesta)"
	arr["POLISH",38]="Wybrano atak Beacon flood (wymagany tryb monitorowania)"
	arr["GERMAN",38]="Beacon flood Angriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",38]="Beacon flood saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",38]="(monitor mode يلزم وضع) Beacon flood تم اختيار هجوم"
	arr["CHINESE",38]="WiFi 信号信标伪造 DoS 攻击 (需要监听模式)"

	arr["ENGLISH",39]="Auth DoS attack chosen (monitor mode needed)"
	arr["SPANISH",39]="Elegido ataque Auth DoS (modo monitor requerido)"
	arr["FRENCH",39]="L'attaque Auth DoS a été choisie (modo moniteur nécessaire)"
	arr["CATALAN",39]="Seleccionat atac Auth DoS (es requereix mode monitor)"
	arr["PORTUGUESE",39]="O ataque DoS Auth foi escolhido (modo monitor obrigatório)"
	arr["RUSSIAN",39]="Выбрана атака Auth DoS (необходим режим монитора)"
	arr["GREEK",39]="Έχει επιλεχθεί επίθεση Auth DoS (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",39]="Attacco DoS Auth scelto (modalità monitor richiesta)"
	arr["POLISH",39]="Wybrano atak DoS Auth (wymagany tryb monitorowania)"
	arr["GERMAN",39]="Auth DoS Angriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",39]="Auth DoS saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",39]="(monitor mode يلزم وضع) Auth DoS تم اختيار هجوم"
	arr["CHINESE",39]="选择了身份验证 DoS 攻击 (需要监听模式)"

	arr["ENGLISH",40]="Michael Shutdown (TKIP) attack chosen (monitor mode needed)"
	arr["SPANISH",40]="Elegido ataque Michael Shutdown (TKIP) (modo monitor requerido)"
	arr["FRENCH",40]="L'attaque Michael Shutdown (TKIP) a été choisie (mode moniteur nécessaire)"
	arr["CATALAN",40]="Seleccionat atac Michael Shutdown (TKIP) (es requereix mode monitor)"
	arr["PORTUGUESE",40]="Ataque selecionado Michael Shutdown (TKIP) (modo monitor obrigatório)"
	arr["RUSSIAN",40]="Выбрана атака Michael Shutdown (TKIP) (необходим режим монитора)"
	arr["GREEK",40]="Έχει επιλεχθεί επίθεση Michael Shutdown (TKIP) (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",40]="Attacco Michael Shutdown (TKIP) scelto (modalità monitor richiesta)"
	arr["POLISH",40]="Wybrano atak Michael Shutdown (TKIP) (wymagany tryb monitorowania)"
	arr["GERMAN",40]="Michael Shutdown (TKIP) Angriff ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",40]="Michael Shutdown (TKIP) saldırısı seçildi (izleme modu gereklidir)"
	arr["ARABIC",40]="(monitor mode يلزم وضع) Michael Shutdown (TKIP) تم اختيار هجوم"
	arr["CHINESE",40]="选择了迈克尔关机 (TKIP) (需要监听模式)"

	arr["ENGLISH",41]="No interface selected. You'll be redirected to select one"
	arr["SPANISH",41]="No hay interfaz seleccionada. Serás redirigido para seleccionar una"
	arr["FRENCH",41]="Aucune interface sélectionnée. Vous allez retourner au menu de sélection pour en choisir une"
	arr["CATALAN",41]="No hi ha intefície seleccionada. Seràs redirigit per seleccionar una"
	arr["PORTUGUESE",41]="Nenhuma interface selecionada. Você será redirecionado para selecionar uma"
	arr["RUSSIAN",41]="Интерфейс не выбран. Вы будете перенаправлены на меню выбора интерфейса"
	arr["GREEK",41]="Δεν έχει επιλεχθεί κάποια διεπαφή. Θα καθοδηγηθείτε για να επιλέξετε μία"
	arr["ITALIAN",41]="Nessuna interfaccia selezionata. Sarai reindirizzato per selezionarne una"
	arr["POLISH",41]="Nie wybrano interfejsu. Zostaniesz przekierowany, aby któryś wybrać"
	arr["GERMAN",41]="Kein Interface ausgewählt. Sie werden zur Auswahl weitergeleitet"
	arr["TURKISH",41]="Hiçbir arayüz seçilmedi. Seçmeniz için yönlendiriliyorsunuz"
	arr["ARABIC",41]="لم يتم تحديد واجهة. ستتم إعادة توجيهك لتحديد واحدة"
	arr["CHINESE",41]="未选择接口。您将被重定向以选择一个网络接口"

	arr["ENGLISH",42]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} selected. Mode: \${pink_color}\${ifacemode}\${normal_color}"
	arr["SPANISH",42]="Interfaz \${pink_color}\${current_iface_on_messages}\${blue_color} seleccionada. Modo: \${pink_color}\${ifacemode}\${normal_color}"
	arr["FRENCH",42]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} sélectionnée. Mode: \${pink_color}\${ifacemode}\${normal_color}"
	arr["CATALAN",42]="Interfície \${pink_color}\${current_iface_on_messages}\${blue_color} seleccionada. Mode: \${pink_color}\${ifacemode}\${normal_color}"
	arr["PORTUGUESE",42]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} selecionada. Modo: \${pink_color}\${ifacemode}\${normal_color}"
	arr["RUSSIAN",42]="Интерфейс \${pink_color}\${current_iface_on_messages}\${blue_color} выбран. Режим: \${pink_color}\${ifacemode}\${normal_color}"
	arr["GREEK",42]="Η διεπαφή \${pink_color}\${current_iface_on_messages}\${blue_color} έχει επιλεχθεί. Κατάσταση: \${pink_color}\${ifacemode}\${normal_color}"
	arr["ITALIAN",42]="Interfaccia \${pink_color}\${current_iface_on_messages}\${blue_color} selezionata. Modalità: \${pink_color}\${ifacemode}\${normal_color}"
	arr["POLISH",42]="Interfejs \${pink_color}\${current_iface_on_messages}\${blue_color} został wybrany. Tryb: \${pink_color}\${ifacemode}\${normal_color}"
	arr["GERMAN",42]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} ausgewählt. Modus: \${pink_color}\${ifacemode}\${normal_color}"
	arr["TURKISH",42]="Arayüz \${pink_color}\${current_iface_on_messages}\${blue_color} seçildi. Mod: \${pink_color}\${ifacemode}\${normal_color}"
	arr["ARABIC",42]="\${pink_color}\${ifacemode}\${blue_color} :الوضع المختار \${pink_color}\${current_iface_on_messages}\${blue_color} تم تحديد الواجهة\${normal_color}"
	arr["CHINESE",42]="已选择接口 \${pink_color}\${current_iface_on_messages}\${blue_color}。模式: \${pink_color}\${ifacemode}\${normal_color}"

	arr["ENGLISH",43]="Selected BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["SPANISH",43]="BSSID seleccionado: \${pink_color}\${bssid}\${normal_color}"
	arr["FRENCH",43]="BSSID sélectionné: \${pink_color}\${bssid}\${normal_color}"
	arr["CATALAN",43]="BSSID seleccionat: \${pink_color}\${bssid}\${normal_color}"
	arr["PORTUGUESE",43]="BSSID selecionado: \${pink_color}\${bssid}\${normal_color}"
	arr["RUSSIAN",43]="Выбранный BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["GREEK",43]="Επιλεγμένο BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["ITALIAN",43]="BSSID selezionato: \${pink_color}\${bssid}\${normal_color}"
	arr["POLISH",43]="Wybrany BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["GERMAN",43]="Ausgewählte BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["TURKISH",43]="Seçildi BSSID: \${pink_color}\${bssid}\${normal_color}"
	arr["ARABIC",43]="\${pink_color}\${bssid}\${blue_color} :المختار BSSID\${normal_color}"
	arr["CHINESE",43]="选中 AP 的 BSSID: \${pink_color}\${bssid}\${normal_color}"

	arr["ENGLISH",44]="Selected channel: \${pink_color}\${channel}\${normal_color}"
	arr["SPANISH",44]="Canal seleccionado: \${pink_color}\${channel}\${normal_color}"
	arr["FRENCH",44]="Canal sélectionné: \${pink_color}\${channel}\${normal_color}"
	arr["CATALAN",44]="Canal seleccionat: \${pink_color}\${channel}\${normal_color}"
	arr["PORTUGUESE",44]="Canal selecionado: \${pink_color}\${channel}\${normal_color}"
	arr["RUSSIAN",44]="Выбранный канал: \${pink_color}\${channel}\${normal_color}"
	arr["GREEK",44]="Επιλεγμένο κανάλι: \${pink_color}\${channel}\${normal_color}"
	arr["ITALIAN",44]="Canale selezionato: \${pink_color}\${channel}\${normal_color}"
	arr["POLISH",44]="Wybrany kanał: \${pink_color}\${channel}\${normal_color}"
	arr["GERMAN",44]="Ausgewählter Kanal: \${pink_color}\${channel}\${normal_color}"
	arr["TURKISH",44]="Seçilen kanal: \${pink_color}\${channel}\${normal_color}"
	arr["ARABIC",44]="\${pink_color}\${channel}\${blue_color} :القناة المختارة\${normal_color}"
	arr["CHINESE",44]="当前信道: \${pink_color}\${channel}\${normal_color}"

	arr["ENGLISH",45]="Selected ESSID: \${pink_color}\${essid}\${blue_color} <- can't be used"
	arr["SPANISH",45]="ESSID seleccionado: \${pink_color}\${essid}\${blue_color} <- no se puede usar"
	arr["FRENCH",45]="ESSID sélectionné: \${pink_color}\${essid}\${blue_color} <- ne peut pas être utilisé"
	arr["CATALAN",45]="ESSID seleccionat: \${pink_color}\${essid}\${blue_color} <- no es pot utilitzar"
	arr["PORTUGUESE",45]="ESSID selecionado: \${pink_color}\${essid}\${blue_color} <- não pode ser utilizada"
	arr["RUSSIAN",45]="Выбранный ESSID: \${pink_color}\${essid}\${blue_color} <- не может быть использован"
	arr["GREEK",45]="Επιλεγμένο ESSID: \${pink_color}\${essid}\${blue_color} <- δεν μπορεί να χρησιμοποιηθεί"
	arr["ITALIAN",45]="ESSID selezionato: \${pink_color}\${essid}\${blue_color} <- non può essere utilizzato"
	arr["POLISH",45]="Wybrany ESSID: \${pink_color}\${essid}\${blue_color} <- nie można używać"
	arr["GERMAN",45]="Ausgewählte ESSID: \${pink_color}\${essid}\${blue_color} <- kann nicht verwendet werden"
	arr["TURKISH",45]="Seçilen ESSID: \${pink_color}\${essid}\${blue_color} <- kullanılamaz"
	arr["ARABIC",45]="لا يمكن استخدامه -> \${pink_color}\${essid}\${blue_color} :المختار ESSID"
	arr["CHINESE",45]="选择的 ESSID: \${pink_color}\${essid}\${blue_color} <- 不能使用"

	arr["ENGLISH",46]="Selected ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["SPANISH",46]="ESSID seleccionado: \${pink_color}\${essid}\${normal_color}"
	arr["FRENCH",46]="ESSID sélectionné: \${pink_color}\${essid}\${normal_color}"
	arr["CATALAN",46]="ESSID seleccionat: \${pink_color}\${essid}\${normal_color}"
	arr["PORTUGUESE",46]="ESSID selecionado: \${pink_color}\${essid}\${normal_color}"
	arr["RUSSIAN",46]="Выбранный ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["GREEK",46]="Επιλεγμένο ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["ITALIAN",46]="ESSID selezionato: \${pink_color}\${essid}\${normal_color}"
	arr["POLISH",46]="Wybrano ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["GERMAN",46]="Ausgewählte ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["TURKISH",46]="Seçildi ESSID: \${pink_color}\${essid}\${normal_color}"
	arr["ARABIC",46]="\${pink_color}\${essid}\${blue_color} :المختار ESSID\${normal_color}"
	arr["CHINESE",46]="选中 AP 的 ESSID: \${pink_color}\${essid}\${normal_color}"

	arr["ENGLISH",47]="Select an option from menu:"
	arr["SPANISH",47]="Selecciona una opción del menú:"
	arr["FRENCH",47]="Choisissez une des options du menu:"
	arr["CATALAN",47]="Selecciona una opció del menú:"
	arr["PORTUGUESE",47]="Selecione uma opção no menu:"
	arr["RUSSIAN",47]="Выбрать опцию из меню:"
	arr["GREEK",47]="Επιλέξτε μία επιλογή από το μενού:"
	arr["ITALIAN",47]="Selezionare un'opzione del menú:"
	arr["POLISH",47]="Wybierz opcję z menu:"
	arr["GERMAN",47]="Wählen Sie eine Menüoption:"
	arr["TURKISH",47]="Menüden bir ayar seçiniz:"
	arr["ARABIC",47]=":حدد خيارا من القائمة"
	arr["CHINESE",47]="请从菜单中选择选项:"

	arr["ENGLISH",48]="1.  Select another network interface"
	arr["SPANISH",48]="1.  Selecciona otra interfaz de red"
	arr["FRENCH",48]="1.  Sélectionnez une autre interface réseaux"
	arr["CATALAN",48]="1.  Selecciona un altra interfície de xarxa"
	arr["PORTUGUESE",48]="1.  Selecione outra interface de rede"
	arr["RUSSIAN",48]="1.  Выбрать другой сетевой интерфейс"
	arr["GREEK",48]="1.  Επιλογή διαφορετικής διεπαφής"
	arr["ITALIAN",48]="1.  Selezionare un'altra interfaccia di rete"
	arr["POLISH",48]="1.  Wybierz inny interfejs sieciowy"
	arr["GERMAN",48]="1.  Wählen Sie ein anderes Netzwerk-Interface"
	arr["TURKISH",48]="1.  Başka bir ağ arayüzü seç"
	arr["ARABIC",48]="1.  حدد واجهة شبكة أخرى"
	arr["CHINESE",48]="1.  选择另一个网络接口"

	arr["ENGLISH",49]="4.  Explore for targets (monitor mode needed)"
	arr["SPANISH",49]="4.  Explorar para buscar objetivos (modo monitor requerido)"
	arr["FRENCH",49]="4.  Détection des réseaux pour choisir une cible (modo moniteur obligatoire)"
	arr["CATALAN",49]="4.  Explorar per buscar objectius (es requereix mode monitor)"
	arr["PORTUGUESE",49]="4.  Procurar por redes wifi (modo monitor obrigatório)"
	arr["RUSSIAN",49]="4.  Поиск целей (необходим режим монитора)"
	arr["GREEK",49]="4.  Εξερεύνηση στόχων (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",49]="4.  Esplora per cercare obiettivi (modalità monitor richiesta)"
	arr["POLISH",49]="4.  Skanowanie możliwych celów (wymagany tryb monitorowania)"
	arr["GERMAN",49]="4.  Scannen, um Ziele zu finden (Monitor-Modus erforderlich)"
	arr["TURKISH",49]="4.  Hedefleri tara (izleme modu gereklidir)"
	arr["ARABIC",49]="4.  (إلزامي monitor mode) اكتشاف الشبكات لاختيار الهدف"
	arr["CHINESE",49]="4.  扫描目标 (需要监听模式)"

	arr["ENGLISH",50]="monitor mode needed for attacks"
	arr["SPANISH",50]="modo monitor requerido en ataques"
	arr["FRENCH",50]="modo moniteur obligatoire pour ces attaques"
	arr["CATALAN",50]="mode monitor requerit per atacs"
	arr["PORTUGUESE",50]="modo monitor necessário para ataques"
	arr["RUSSIAN",50]="для атак необходим режим монитора"
	arr["GREEK",50]="χρειάζεται η κατάσταση παρακολούθησης για τις επιθέσεις"
	arr["ITALIAN",50]="modalità monitor richiesta per gli attacchi"
	arr["POLISH",50]="wymagany tryb monitorowania do wykonania ataku"
	arr["GERMAN",50]="Monitor-Modus bei Angriffen erforderlich"
	arr["TURKISH",50]="saldırılar için izleme modu gereklidir"
	arr["ARABIC",50]="مطلوب للهجمات monitor mode"
	arr["CHINESE",50]="以下攻击需要监听模式"

	arr["ENGLISH",51]="5.  Deauth / disassoc amok \${mdk_command} attack"
	arr["SPANISH",51]="5.  Ataque Deauth / Disassoc amok \${mdk_command}"
	arr["FRENCH",51]="5.  Attaque Deauth / Disassoc amok \${mdk_command}"
	arr["CATALAN",51]="5.  Atac Deauth / Disassoc amok \${mdk_command}"
	arr["PORTUGUESE",51]="5.  Ataque Deauth / Disassoc amok \${mdk_command}"
	arr["RUSSIAN",51]="5.  Атака деаутентификации / разъединения amok \${mdk_command}"
	arr["GREEK",51]="5.  Επίθεση Deauth / Disassoc amok \${mdk_command}"
	arr["ITALIAN",51]="5.  Attacco Deauth / Disassoc amok \${mdk_command}"
	arr["POLISH",51]="5.  Atak Deauth / Disassoc amok \${mdk_command}"
	arr["GERMAN",51]="5.  Deauth / Disassoc Amok \${mdk_command} Angriff"
	arr["TURKISH",51]="5.  Deauth / disassoc amok \${mdk_command} saldırısı"
	arr["ARABIC",51]="5.  DeAuth / Disassoc amok \${mdk_command} هجوم"
	arr["CHINESE",51]="5.  \${mdk_command} amok 解除身份验证攻击"

	arr["ENGLISH",52]="6.  Deauth aireplay attack"
	arr["SPANISH",52]="6.  Ataque Deauth aireplay"
	arr["FRENCH",52]="6.  Attaque Deauth aireplay"
	arr["CATALAN",52]="6.  Atac Deauth aireplay"
	arr["PORTUGUESE",52]="6.  Ataque Deauth aireplay"
	arr["RUSSIAN",52]="6.  Атака деаутентификации aireplay"
	arr["GREEK",52]="6.  Επίθεση Deauth aireplay"
	arr["ITALIAN",52]="6.  Attacco Deauth aireplay"
	arr["POLISH",52]="6.  Atak Deauth aireplay"
	arr["GERMAN",52]="6.  Deauth aireplay Angriff"
	arr["TURKISH",52]="6.  Deauth aireplay saldırısı"
	arr["ARABIC",52]="6.  DeAuth aireplay هجوم"
	arr["CHINESE",52]="6.  aireplay 解除身份验证攻击"

	arr["ENGLISH",53]="9.  WIDS / WIPS / WDS Confusion attack"
	arr["SPANISH",53]="9.  Ataque WIDS / WIPS / WDS Confusion"
	arr["FRENCH",53]="9.  Attaque WIDS / WIPS / WDS Confusion"
	arr["CATALAN",53]="9.  Atac WIDS / WIPS / WDS Confusion"
	arr["PORTUGUESE",53]="9.  Ataque Confusion WIDS / WIPS / WDS"
	arr["RUSSIAN",53]="9.  Атака запутывания WIDS / WIPS / WDS"
	arr["GREEK",53]="9.  Επίθεση σύγχυσης WIDS / WIPS / WDS"
	arr["ITALIAN",53]="9.  Attacco WIDS / WIPS / WDS Confusion"
	arr["POLISH",53]="9.  Ataki WIDS / WIPS / WDS"
	arr["GERMAN",53]="9.  WIDS / WIPS / WDS Confusion Angriff"
	arr["TURKISH",53]="9.  WIDS / WIPS / WDS Confusion saldırısı"
	arr["ARABIC",53]="9.  WIDS / WIPS / WDS Confusion هجوم"
	arr["CHINESE",53]="9.  WIDS / WIPS / WDS 混淆攻击"

	arr["ENGLISH",54]="old \"obsolete/non very effective\" attacks"
	arr["SPANISH",54]="antiguos ataques \"obsoletos/no muy efectivos\""
	arr["FRENCH",54]="anciennes attaques \"obsolètes/peu efficaces\""
	arr["CATALAN",54]="antics atacs \"obsolets/no molt efectius\""
	arr["PORTUGUESE",54]="ataques antigos \"obsoletos/não muito eficazes\""
	arr["RUSSIAN",54]="старые \"устаревшие/не очень эффективные\" атаки"
	arr["GREEK",54]="παλιές \"απαρχαιωμένες/όχι και τόσο αποδοτικές\" επιθέσεις"
	arr["ITALIAN",54]="vecchi attacchi \"obsoleti/non molto efficaci\""
	arr["POLISH",54]="stare ataki \"przestarzałe/niezbyt skuteczne\""
	arr["GERMAN",54]="alte Angriffe \"veraltet/nicht sehr effektiv\""
	arr["TURKISH",54]="eski \"obsolete/non çok etkili\" saldırılar"
	arr["ARABIC",54]="هجمات القديمة \"عفا عليها الزمن/ليست فعالة جدا\""
	arr["CHINESE",54]="过时的 / 可能不是很有效的攻击"

	arr["ENGLISH",55]="2.  Put interface in monitor mode"
	arr["SPANISH",55]="2.  Poner la interfaz en modo monitor"
	arr["FRENCH",55]="2.  Passer l'interface en mode moniteur"
	arr["CATALAN",55]="2.  Configurar la interfície en mode monitor"
	arr["PORTUGUESE",55]="2.  Colocar a interface em modo monitor"
	arr["RUSSIAN",55]="2.  Перевести интерфейс в режим монитора"
	arr["GREEK",55]="2.  Βάλτε τη διεπαφή σε κατάσταση παρακολούθησης"
	arr["ITALIAN",55]="2.  Mettere l'interfaccia in modalità monitor"
	arr["POLISH",55]="2.  Uruchom interfejs w trybie monitorowania"
	arr["GERMAN",55]="2.  Setzen Sie das Interface im Monitor-Modus ein"
	arr["TURKISH",55]="2.  Arayüzün izleme modunu aç"
	arr["ARABIC",55]="2.  Monitor mode ضع الواجهة على"
	arr["CHINESE",55]="2.  将当前接口设置为监听模式 (Monitor)"

	arr["ENGLISH",56]="3.  Put interface in managed mode"
	arr["SPANISH",56]="3.  Poner la interfaz en modo managed"
	arr["FRENCH",56]="3.  Passer l'interface en mode managed"
	arr["CATALAN",56]="3.  Configurar la interfície en mode managed"
	arr["PORTUGUESE",56]="3.  Colocar a interface em modo managed"
	arr["RUSSIAN",56]="3.  Перевести интерфейс в управляемый режим"
	arr["GREEK",56]="3.  Βάλτε τη διεπαφή σε ετερόκλητη κατάσταση"
	arr["ITALIAN",56]="3.  Mettere l'interfaccia in modalità managed"
	arr["POLISH",56]="3.  Uruchom interfejs w trybie zarządzanym"
	arr["GERMAN",56]="3.  Setzen Sie das Interface im Managed-Modus ein"
	arr["TURKISH",56]="3.  Arayüzün yönetici modunu aç"
	arr["ARABIC",56]="3.  Managed mode ضع الواجهة على"
	arr["CHINESE",56]="3.  将当前接口设置为管理模式 (Managed)"

	arr["ENGLISH",57]="10. Enterprise attacks menu"
	arr["SPANISH",57]="10. Menú de ataques Enterprise"
	arr["FRENCH",57]="10. Menu d'attaque Entreprise"
	arr["CATALAN",57]="10. Menú d'atacs Enterprise"
	arr["PORTUGUESE",57]="10. Menu de ataques Enterprise"
	arr["RUSSIAN",57]="10. Меню Enterprise атак"
	arr["GREEK",57]="10. Μενού επιλογών Enterprise"
	arr["ITALIAN",57]="10. Menu dell'attacco Enterprise"
	arr["POLISH",57]="10. Menu ataków Enterprise"
	arr["GERMAN",57]="10. Enterprise-Angriffsmenü"
	arr["TURKISH",57]="10. Enterprise saldırılar menüsü"
	arr["ARABIC",57]="10. Entreprise قائمة هجمات"
	arr["CHINESE",57]="10. 企业级加密攻击菜单"

	arr["ENGLISH",58]="9.  Polish"
	arr["SPANISH",58]="9.  Polaco"
	arr["FRENCH",58]="9.  Polonais"
	arr["CATALAN",58]="9.  Polonès"
	arr["PORTUGUESE",58]="9.  Polonês"
	arr["RUSSIAN",58]="9.  Польский"
	arr["GREEK",58]="9.  Πολωνικά"
	arr["ITALIAN",58]="9.  Polacco"
	arr["POLISH",58]="9.  Polski"
	arr["GERMAN",58]="9.  Polnisch"
	arr["TURKISH",58]="9.  Polish"
	arr["ARABIC",58]="9.  البولندية"
	arr["CHINESE",58]="9.  波兰语"

	arr["ENGLISH",59]="0.  Return to main menu"
	arr["SPANISH",59]="0.  Volver al menú principal"
	arr["FRENCH",59]="0.  Retourner au menu principal"
	arr["CATALAN",59]="0.  Tornar al menú principal"
	arr["PORTUGUESE",59]="0.  Voltar ao menu principal"
	arr["RUSSIAN",59]="0.  Вернуться в главное меню"
	arr["GREEK",59]="0.  Επιστροφή στο αρχικό μενού"
	arr["ITALIAN",59]="0.  Torna al menu principale"
	arr["POLISH",59]="0.  Wróć do menu głównego"
	arr["GERMAN",59]="0.  Zum Hauptmenü zurück"
	arr["TURKISH",59]="0.  Ana menüye dön"
	arr["ARABIC",59]="0.  العودة إلى القائمة الرئيسية"
	arr["CHINESE",59]="0.  返回主菜单"

	arr["ENGLISH",60]="11. About & Credits / Sponsorship mentions"
	arr["SPANISH",60]="11. Acerca de & Créditos / Menciones de patrocinadores"
	arr["FRENCH",60]="11. À propos de & Crédits / Mentions du sponsors"
	arr["CATALAN",60]="11. Sobre & Crédits / Mencions de sponsors"
	arr["PORTUGUESE",60]="11. Sobre & Créditos / Nossos patrocinadores"
	arr["RUSSIAN",60]="11. О программе и Благодарности / Спонсорские упоминания"
	arr["GREEK",60]="11. Σχετικά με & Εύσημα / Αναφορές χορηγίας"
	arr["ITALIAN",60]="11. Informazioni & Crediti / Menzioni di sponsorizzazione"
	arr["POLISH",60]="11. O programie & Podziękowania / Wzmianki sponsorskie"
	arr["GERMAN",60]="11. About & Credits / Sponsoring-Erwähnungen"
	arr["TURKISH",60]="11. Krediler ve Sponsorluk Hakkında"
	arr["ARABIC",60]="11. فريق العمل برعاية"
	arr["CHINESE",60]="11. 关于 & 鸣谢 / 赞助"

	arr["ENGLISH",61]="0.  Exit script"
	arr["SPANISH",61]="0.  Salir del script"
	arr["FRENCH",61]="0.  Sortir du script"
	arr["CATALAN",61]="0.  Sortir del script"
	arr["PORTUGUESE",61]="0.  Sair do script"
	arr["RUSSIAN",61]="0.  Выйти из скрипта"
	arr["GREEK",61]="0.  Έξοδος script"
	arr["ITALIAN",61]="0.  Uscire dallo script"
	arr["POLISH",61]="0.  Zamknij skrypt"
	arr["GERMAN",61]="0.  Skript beenden"
	arr["TURKISH",61]="0.  Yazılımdan çıkış yap"
	arr["ARABIC",61]="0.  الخروج من البرنامج"
	arr["CHINESE",61]="0.  退出脚本"

	arr["ENGLISH",62]="8.  Beacon flood attack"
	arr["SPANISH",62]="8.  Ataque Beacon flood"
	arr["FRENCH",62]="8.  Attaque Beacon flood"
	arr["CATALAN",62]="8.  Atac Beacon flood"
	arr["PORTUGUESE",62]="8.  Ataque Beacon flood"
	arr["RUSSIAN",62]="8.  Beacon flood атака"
	arr["GREEK",62]="8.  Επίθεση πλημμύρας φάρου (beacon)"
	arr["ITALIAN",62]="8.  Attacco Beacon flood"
	arr["POLISH",62]="8.  Atak Beacon flood"
	arr["GERMAN",62]="8.  Beacon flood Angriff"
	arr["TURKISH",62]="8.  Beacon flood saldırısı"
	arr["ARABIC",62]="8.  Beacon flood هجوم"
	arr["CHINESE",62]="8.  WiFi 信号信标伪造 DoS 攻击 (Beacon flood)"

	arr["ENGLISH",63]="7.  Auth DoS attack"
	arr["SPANISH",63]="7.  Ataque Auth DoS"
	arr["FRENCH",63]="7.  Attaque Auth DoS"
	arr["CATALAN",63]="7.  Atac Auth Dos"
	arr["PORTUGUESE",63]="7.  Ataque Auth DoS"
	arr["RUSSIAN",63]="7.  DoS атака деаутентификации"
	arr["GREEK",63]="7.  Επίθεση Auth DoS"
	arr["ITALIAN",63]="7.  Attacco Auth DoS"
	arr["POLISH",63]="7.  Atak Auth DoS"
	arr["GERMAN",63]="7.  Auth DoS Angriff"
	arr["TURKISH",63]="7.  Auth DoS saldırısı"
	arr["ARABIC",63]="7.  Auth DoS هجوم"
	arr["CHINESE",63]="7.  身份验证 DoS 攻击 (Auth DoS)"

	arr["ENGLISH",64]="10. Michael shutdown exploitation (TKIP) attack"
	arr["SPANISH",64]="10. Ataque Michael shutdown exploitation (TKIP)"
	arr["FRENCH",64]="10. Attaque Michael shutdown exploitation (TKIP)"
	arr["CATALAN",64]="10. Atac Michael shutdown exploitation (TKIP)"
	arr["PORTUGUESE",64]="10. Ataque Michael shutdown exploitation (TKIP)"
	arr["RUSSIAN",64]="10. Атака \"Michael shutdown exploitation (TKIP)\""
	arr["GREEK",64]="10. Επίθεση Michael shutdown exploitation (TKIP)"
	arr["ITALIAN",64]="10. Attacco Michael shutdown exploitation (TKIP)"
	arr["POLISH",64]="10. Atak Michael shutdown exploitation (TKIP)"
	arr["GERMAN",64]="10. Michael Shutdown Exploitation Angriff (TKIP)"
	arr["TURKISH",64]="10. Michael shutdown exploitation (TKIP) saldırısı"
	arr["ARABIC",64]="10. Michael shutdown exploitation (TKIP) هجوم"
	arr["CHINESE",64]="10. 迈克尔关机 (TKIP) 攻击 (Michael shutdown exploitation) 仅针对 TKIP 加密的 WiFi 有效"

	arr["ENGLISH",65]="Exploring for targets option chosen (monitor mode needed)"
	arr["SPANISH",65]="Elegida opción de exploración para buscar objetivos (modo monitor requerido)"
	arr["FRENCH",65]="L'option de recherche des objectifs a été choisie (modo moniteur nécessaire)"
	arr["CATALAN",65]="Seleccionada opció d'exploració per buscar objectius (requerit mode monitor)"
	arr["PORTUGUESE",65]="Selecione uma opção de busca para encontrar redes wifi (modo monitor obrigatório)"
	arr["RUSSIAN",65]="Выбрано сканирование целей (необходим режим монитора)"
	arr["GREEK",65]="Η επιλογή για εξερεύνηση στόχων έχει επιλεχθεί (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",65]="Scelta la opzione di scansione per cercare obiettivi (modalità monitor richiesta)"
	arr["POLISH",65]="Opcja skanowania w celu wyszukania celów wybrana (wymaga trybu monitorowania)"
	arr["GERMAN",65]="Zielsuche ausgewählt (Monitor-Modus erforderlich)"
	arr["TURKISH",65]="Hedef tarama modu seçildi (izleme modu gereklidir)"
	arr["ARABIC",65]="(إلزامي monitor mode) تم تحديد خيار استكشاف الأهداف"
	arr["CHINESE",65]="扫描目标并选择 (需要监听模式)"

	arr["ENGLISH",66]="Selected interface \${current_iface_on_messages} is in monitor mode. Exploration can be performed"
	arr["SPANISH",66]="La interfaz seleccionada \${current_iface_on_messages} está en modo monitor. La exploración se puede realizar"
	arr["FRENCH",66]="L'interface choisie \${current_iface_on_messages} est en mode moniteur. L'exploration des réseaux environnants peut s'effectuer"
	arr["CATALAN",66]="La interfície seleccionada \${current_iface_on_messages} està en mode monitor. L'exploració es pot realitzar"
	arr["PORTUGUESE",66]="A interface selecionada \${current_iface_on_messages} está no modo monitor. A verificação pode ser realizada"
	arr["RUSSIAN",66]="Выбранный интерфейс \${current_iface_on_messages} в режиме монитора. Сканирование может быть выполнено"
	arr["GREEK",66]="Η επιλεγμένη διεπαφή \${current_iface_on_messages} είναι σε κατάσταση παρακολούθησης. Μπορεί να γίνει εξερεύνηση"
	arr["ITALIAN",66]="L'interfaccia selezionata \${current_iface_on_messages} è in modalità monitor. La scansione può essere eseguita"
	arr["POLISH",66]="Wybrany interfejs \${current_iface_on_messages} jest w trybie monitorowania. Można wykonać skanowanie"
	arr["GERMAN",66]="Das ausgewählte Interface \${current_iface_on_messages} befindet sich im monitor-Modus. Der Scan kann durchgeführt werden"
	arr["TURKISH",66]="Seçilen arayüz \${current_iface_on_messages} izleme modunda. Tarama gerçekleştirilebilir"
	arr["ARABIC",66]="يمكن إجراء الاستكشاف .monior mode في وضع \${current_iface_on_messages} الواجهة المختارة"
	arr["CHINESE",66]="所选接口 \${current_iface_on_messages} 已处于监听模式。可以扫描目标"

	arr["ENGLISH",67]="WEP filter enabled in scan. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",67]="Filtro WEP activado en escaneo. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",67]="Le filtre WEP est activé dans le scan. Une fois l'opération lancée, veuillez presser [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",67]="Filtre WEP activat en escaneig. Una vegada iniciat, polsi [Ctrl+C] per detenir-ho..."
	arr["PORTUGUESE",67]="Filtro WEP ativo na busca de redes wifi. Uma vez iniciado, pressione [Ctrl+C] para pará-lo..."
	arr["RUSSIAN",67]="Для сканирования активирован фильтр WEP. После запуска, нажмите [Ctrl+C] для остановки..."
	arr["GREEK",67]="Το φίλτρο WEP ενεργοποιήθηκε κατά τη σάρωση. Όταν αρχίσει, μπορείτε να το σταματήσετε πατώντας [Ctrl+C]..."
	arr["ITALIAN",67]="Filtro WEP attivato durante la scansione. Una volta avviato, premere [Ctrl+C] per fermarlo..."
	arr["POLISH",67]="Filtr WEP aktywowany podczas skanowania. Naciśnij [Ctrl+C] w trakcie trwania, aby zatrzymać..."
	arr["GERMAN",67]="WEP-Filter beim Scannen aktiviert. Nach den Start, drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",67]="WEP filtesi taraması etkin. Başladıktan sonra, durdurmak için [Ctrl+C] tuşlayınız..."
	arr["ARABIC",67]="...للإيقاف [Ctrl+C] في المسح. عند البدء ، اضغط على WEP تم تفعيل مرشح"
	arr["CHINESE",67]="扫描中启用了 WEP 过滤器。按 [Ctrl+C] 终止..."

	arr["ENGLISH",68]="No networks found"
	arr["SPANISH",68]="No se encontraron redes"
	arr["FRENCH",68]="Aucun réseau détecté"
	arr["CATALAN",68]="No s'han trobat xarxes"
	arr["PORTUGUESE",68]="Nenhuma rede encontrada"
	arr["RUSSIAN",68]="Сетей не найдено"
	arr["GREEK",68]="Δεν βρέθηκαν δίκτυα"
	arr["ITALIAN",68]="Nessuna rete trovata"
	arr["POLISH",68]="Nie znaleziono sieci"
	arr["GERMAN",68]="Keine Netzwerke wurden gefunden"
	arr["TURKISH",68]="Herhangi bir ağ bulunamadı"
	arr["ARABIC",68]="لم نعثر على أي شبكة"
	arr["CHINESE",68]="未找到网络"

	arr["ENGLISH",69]="  N.         BSSID      CHANNEL  PWR   ENC    ESSID"
	arr["SPANISH",69]="  N.         BSSID        CANAL  PWR   ENC    ESSID"
	arr["FRENCH",69]="  N.         BSSID        CANAL  PWR   ENC    ESSID"
	arr["CATALAN",69]="  N.         BSSID        CANAL  PWR   ENC    ESSID"
	arr["PORTUGUESE",69]="  N.         BSSID        CANAL  PWR   ENC    ESSID"
	arr["RUSSIAN",69]="  N.         BSSID      CHANNEL  PWR   ENC    ESSID"
	arr["GREEK",69]="  N.         BSSID      CHANNEL  PWR   ENC    ESSID"
	arr["ITALIAN",69]="  N.         BSSID       CANALE  PWR   ENC    ESSID"
	arr["POLISH",69]="  N.         BSSID        KANAŁ  PWR   ENC    ESSID"
	arr["GERMAN",69]="  N.         BSSID        KANAL  PWR   ENC    ESSID"
	arr["TURKISH",69]="  N.         BSSID      KANAL  PWR   ENC    ESSID"
	arr["ARABIC",69]="  N.         BSSID      CHANNEL  PWR   ENC    ESSID"
	arr["CHINESE",69]=" 序号        BSSID        信道 信号强度 加密方式  ESSID"


	arr["ENGLISH",70]="Only one target detected. Autoselected"
	arr["SPANISH",70]="Sólo un objetivo detectado. Se ha seleccionado automáticamente"
	arr["FRENCH",70]="Un seul réseau a été détecté. Il a été automatiquement sélectionné"
	arr["CATALAN",70]="Només un objectiu detectat. Seleccionat automàticament"
	arr["PORTUGUESE",70]="Apenas uma rede encontrada. Ela foi selecionada automaticamente"
	arr["RUSSIAN",70]="Обнаружена только одна цель. Выбрана автоматически"
	arr["GREEK",70]="Εντοπίστηκε μόνο ένας στόχος. Επιλέχθηκε αυτόματα"
	arr["ITALIAN",70]="Solo un obiettivo rilevato. É stato selezionato automaticamente"
	arr["POLISH",70]="Wykryto tylko jeden cel. Wybrany automatycznie"
	arr["GERMAN",70]="Nur ein Ziel erkannt. Es wurde automatisch ausgewählt"
	arr["TURKISH",70]="Sadece bir hedef tespit edildi. Otomatik olarak seçildi"
	arr["ARABIC",70]="تم اكتشاف هدف واحد فقط. وقد تم الإختيار تلقائيا"
	arr["CHINESE",70]="只检测到一个目标。自动选择"

	arr["ENGLISH",71]="(*) Network with clients"
	arr["SPANISH",71]="(*) Red con clientes"
	arr["FRENCH",71]="(*) Réseau avec clients"
	arr["CATALAN",71]="(*) Xarxa amb clients"
	arr["PORTUGUESE",71]="(*) Rede com clientes"
	arr["RUSSIAN",71]="(*) Сеть с клиентами"
	arr["GREEK",71]="(*) Δίκτυο με χρήστες"
	arr["ITALIAN",71]="(*) Rete con clienti"
	arr["POLISH",71]="(*) Sieć z podłączonymi klientami"
	arr["GERMAN",71]="(*) Netzwerk mit Benutzern"
	arr["TURKISH",71]="(*) Ağ ile istemciler"
	arr["ARABIC",71]="(*) شبكة مع زبناء"
	arr["CHINESE",71]="(*) 有活动用户的无线网络"

	arr["ENGLISH",72]="Invalid target network was chosen"
	arr["SPANISH",72]="Red objetivo elegida no válida"
	arr["FRENCH",72]="Le choix du réseau cible est invalide"
	arr["CATALAN",72]="Xarxa de destí seleccionada no vàlida"
	arr["PORTUGUESE",72]="A rede escolhida é inválida"
	arr["RUSSIAN",72]="Была выбрана неподходящая целевая сеть"
	arr["GREEK",72]="Επιλέχθηκε άκυρο δίκτυο"
	arr["ITALIAN",72]="La rete scelta come obiettivo non è valida"
	arr["POLISH",72]="Wybrano nieprawidłową sieć docelową"
	arr["GERMAN",72]="ungültiges Zielnetzwerk ausgewählt"
	arr["TURKISH",72]="Gerçersiz hedef ağ seçildi"
	arr["ARABIC",72]="تم اختيار شبكة مستهدفة غير صالحة"
	arr["CHINESE",72]="选择了无效的目标网络"

	arr["ENGLISH",73]="airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} developed by:"
	arr["SPANISH",73]="airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} programado por:"
	arr["FRENCH",73]="Le script airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} a été programmé par:"
	arr["CATALAN",73]="airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} desenvolupat per:"
	arr["PORTUGUESE",73]="Script airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} desenvolvido por:"
	arr["RUSSIAN",73]="скрипт airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} создал:"
	arr["GREEK",73]="Το airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} προγραμματίστηκε από:"
	arr["ITALIAN",73]="airgeddon script \${normal_color}v\${airgeddon_version}\${blue_color} sviluppato da:"
	arr["POLISH",73]="Skrypt airgeddon \${normal_color}v\${airgeddon_version}\${blue_color} napisany przez:"
	arr["GERMAN",73]="airgeddon Skript \${normal_color}v\${airgeddon_version}\${blue_color} entwickelt von:"
	arr["TURKISH",73]="airgeddon yazılımı \${normal_color}v\${airgeddon_version}\${blue_color} geliştiricisi:"
	arr["ARABIC",73]=":بواسطة \${normal_color}v\${airgeddon_version}\${blue_color} تمت برمجة"
	arr["CHINESE",73]="airgeddon 脚本 \${normal_color}v\${airgeddon_version}\${blue_color} 开发者:"

	arr["ENGLISH",74]="This script is under GPLv3 (or later) License"
	arr["SPANISH",74]="Este script está bajo Licencia GPLv3 (o posterior)"
	arr["FRENCH",74]="Script publié sous Licence GPLv3 (ou version supèrieure)"
	arr["CATALAN",74]="Aquest script està publicat sota llicència GPLv3 (o versió superior)"
	arr["PORTUGUESE",74]="Este script está sob licença GPLv3 (ou posterior)"
	arr["RUSSIAN",74]="Этот скрипт под лицензией GPLv3 (или более поздней)"
	arr["GREEK",74]="Αυτό το script είναι υπό την άδεια GPLv3 (ή νεότερη)"
	arr["ITALIAN",74]="Questo script è sotto GPLv3 (o versione successiva)"
	arr["POLISH",74]="Ten skrypt objęty jest licencją GPLv3 (lub nowszą)"
	arr["GERMAN",74]="Dieses Skript ist unter GPLv3 (oder höher) lizenziert"
	arr["TURKISH",74]="Bu yazılım GPLv3 (ya da daha üstü) lisansı altındadır"
	arr["ARABIC",74]="(أو أحدث) GPLv3 هذا البرنامج خاضع لترخيص"
	arr["CHINESE",74]="此脚本遵循 GPLv3 (或更高版本) 的开源许可证"

	arr["ENGLISH",75]="Thanks to the \"Spanish pentesting crew\", to the \"Wifislax Staff\", to the forums people who help me, my collaborators, translators and specially to kcdtv, xpz3 and xtonousou for beta testing and support received"
	arr["SPANISH",75]="Gracias al \"Spanish pentesting crew\", al \"Wifislax Staff\", a la gente de los foros que me ayuda, a mis colaboradores, traductores y en especial a kcdtv, xpz3 y xtonousou por el beta testing y el apoyo recibido"
	arr["FRENCH",75]="Merci au \"Spanish pentesting crew\" , au \"Wifislax Staff\", aux gens des forums qui m'ont aidés, à mes collaborateurs, aux traducteurs et tout spécialement à kcdtv, xpz3 et xtonousou pour les tests en phase bêta et son soutien"
	arr["CATALAN",75]="Agraïments al \"Spanish pentesting crew\", al \"Wifislax Staff\", a la gent dels fòrums que m'ajuda, als meus col·laboradors, traductors i especialment al kcdtv, xpz3 i xtonousou per les proves beta i el suport rebut"
	arr["PORTUGUESE",75]="Agradecimentos a \"Spanish pentesting crew\", \"Wifislax Staff\", as pessoas dos fóruns por me ajudar, os colaboradores, tradutores e especialmente para kcdtv, xpz3 e xtonousou por testes beta e também a todo apoio recebido"
	arr["RUSSIAN",75]="Спасибо \"Spanish pentesting crew\", \"Wifislax Staff\", людям с форумов, которые мне помогают, моим коллобораторам, переводчикам и особенно kcdtv, xpz3 и xtonousou за бета тестирование и полученную поддержку"
	arr["GREEK",75]="Τις ευχαριστίες μου στην \"Ισπανική ομάδα pentesting\", στο \"Wifislax Staff\", στα άτομα από το forum που με βοηθάνε, στους συνεργάτες μου, στους μεταφραστές και ειδικά στον kcdtv, xpz3 και στον xtonousou για το beta testing και την υποστήριξη που λάβαμε"
	arr["ITALIAN",75]="Grazie alla \"Spanish pentesting crew\", a \"Wifislax Staff\", alla gente dei forum per aiutarmi, al mio staff, ai traduttori e soprattutto a kcdtv, xpz3 e xtonousou per il beta testing e il supporto ricevuto"
	arr["POLISH",75]="Podziękowania dla \"Spanish pentesting crew\", \"Wifislax Staff\", ludziom z forum którzy mi pomagają, moim współpracownikom, tłumaczom, a zwłaszcza kcdtv, xpz3 i xtonousou za testy beta i otrzymane wsparcie"
	arr["GERMAN",75]="Danke an die \"Spanish Pentesting Crew\", an den \"Wifislax Staff\", an die Leute in den Foren, die mir helfen, an meine Mitarbeiter, Übersetzer und besonders an kcdtv, xpz3 und xtonousou für den Beta-Test und die erhaltene Unterstützung"
	arr["TURKISH",75]="Teşekkürler \"Spanish pentesting crew\", to the \"Wifislax Staff\", to the forums people who help me, my collaborators, translators and specially to kcdtv, xpz3 and xtonousou for beta testing and support received"
	arr["ARABIC",75]="لاختبارات المرحلة التجريبية و دعمه  xtonousou و xpz3 و  kcdtv  و الأشخاص في المنتديات الذين ساعدوني ، والمتعاونين معي ، والمترجمين وخاصةً  \"Wifislax Staff\"  و  \"Spanish pentesting crew\" نشكر"
	arr["CHINESE",75]="感谢“西班牙渗透测试人员*”、“Wifislax 员工*”、论坛上帮助我的人、我的合作者、所有翻译人员，特别感谢 kcdtv、xpz3 和 xtonousou 的 beta 测试和支持"

	arr["ENGLISH",76]="Invalid menu option was chosen"
	arr["SPANISH",76]="Opción del menú no válida"
	arr["FRENCH",76]="Option erronée"
	arr["CATALAN",76]="Opció del menú no vàlida"
	arr["PORTUGUESE",76]="Opção inválida"
	arr["RUSSIAN",76]="Выбрана недействительная опция"
	arr["GREEK",76]="Επιλέχθηκε άκυρη επιλογή μενού"
	arr["ITALIAN",76]="Opzione del menú non valida"
	arr["POLISH",76]="Niewłaściwa opcja"
	arr["GERMAN",76]="Ungültige Menüoption"
	arr["TURKISH",76]="Geçersiz bir menü seçildi"
	arr["ARABIC",76]="اختيارغير صالح"
	arr["CHINESE",76]="选择了无效的菜单选项"

	arr["ENGLISH",77]="Invalid interface was chosen"
	arr["SPANISH",77]="Interfaz no válida"
	arr["FRENCH",77]="L'interface choisie n'existe pas"
	arr["CATALAN",77]="Interfície no vàlida"
	arr["PORTUGUESE",77]="Interface inválida"
	arr["RUSSIAN",77]="Был выбран недействительный интерфейс"
	arr["GREEK",77]="Επιλέχθηκε άκυρη διεπαφή"
	arr["ITALIAN",77]="Interfaccia non valida"
	arr["POLISH",77]="Nieprawidłowy interfejs"
	arr["GERMAN",77]="Ungültiges Interface"
	arr["TURKISH",77]="Geçersiz bir arayüz seçildi"
	arr["ARABIC",77]="واجهة غير صالحة"
	arr["CHINESE",77]="选择了无效的接口"

	arr["ENGLISH",78]="1.  Change language"
	arr["SPANISH",78]="1.  Cambiar idioma"
	arr["FRENCH",78]="1.  Changer de langue"
	arr["CATALAN",78]="1.  Canviar l'idioma"
	arr["PORTUGUESE",78]="1.  Alterar idioma"
	arr["RUSSIAN",78]="1.  Сменить язык"
	arr["GREEK",78]="1.  Αλλαγή γλώσσας"
	arr["ITALIAN",78]="1.  Cambiare la lingua"
	arr["POLISH",78]="1.  Zmień język"
	arr["GERMAN",78]="1.  Sprache ändern"
	arr["TURKISH",78]="1.  Dil değiştir"
	arr["ARABIC",78]="1.  تغيير اللغة"
	arr["CHINESE",78]="1.  更改语言"

	arr["ENGLISH",79]="1.  English"
	arr["SPANISH",79]="1.  Inglés"
	arr["FRENCH",79]="1.  Anglais"
	arr["CATALAN",79]="1.  Anglés"
	arr["PORTUGUESE",79]="1.  Inglês"
	arr["RUSSIAN",79]="1.  Английский"
	arr["GREEK",79]="1.  Αγγλικά"
	arr["ITALIAN",79]="1.  Inglese"
	arr["POLISH",79]="1.  Angielski"
	arr["GERMAN",79]="1.  Englisch"
	arr["TURKISH",79]="1.  İngilizce"
	arr["ARABIC",79]="1.  الإنجليزية"
	arr["CHINESE",79]="1.  英语"

	arr["ENGLISH",80]="2.  Spanish"
	arr["SPANISH",80]="2.  Español"
	arr["FRENCH",80]="2.  Espagnol"
	arr["CATALAN",80]="2.  Espanyol"
	arr["PORTUGUESE",80]="2.  Espanhol"
	arr["RUSSIAN",80]="2.  Испанский"
	arr["GREEK",80]="2.  Ισπανικά"
	arr["ITALIAN",80]="2.  Spagnolo"
	arr["POLISH",80]="2.  Hiszpański"
	arr["GERMAN",80]="2.  Spanisch"
	arr["TURKISH",80]="2.  İspanyolca"
	arr["ARABIC",80]="2.  الإسبانية"
	arr["CHINESE",80]="2.  西班牙语"

	arr["ENGLISH",81]="Select a language:"
	arr["SPANISH",81]="Selecciona un idioma:"
	arr["FRENCH",81]="Choisissez une langue:"
	arr["CATALAN",81]="Selecciona un idioma:"
	arr["PORTUGUESE",81]="Selecione um idioma:"
	arr["RUSSIAN",81]="Выберите язык:"
	arr["GREEK",81]="Επιλέξτε μία γλώσσα:"
	arr["ITALIAN",81]="Scegli una lingua:"
	arr["POLISH",81]="Wybierz język:"
	arr["GERMAN",81]="Wählen Sie eine Sprache:"
	arr["TURKISH",81]="Bir dil seçiniz:"
	arr["ARABIC",81]=":اختر لغة"
	arr["CHINESE",81]="请选择语言:"

	arr["ENGLISH",82]="Invalid language was chosen"
	arr["SPANISH",82]="Idioma no válido"
	arr["FRENCH",82]="Langue non valide"
	arr["CATALAN",82]="Idioma no vàlid"
	arr["PORTUGUESE",82]="Idioma inválido"
	arr["RUSSIAN",82]="Был выбран неверный язык"
	arr["GREEK",82]="Επιλέχθηκε άκυρη γλώσσα"
	arr["ITALIAN",82]="Lingua non valida"
	arr["POLISH",82]="Nieprawidłowy język"
	arr["GERMAN",82]="Ungültige Sprache"
	arr["TURKISH",82]="Yanlış bir dil seçildi"
	arr["ARABIC",82]="لغة غير صحيحة"
	arr["CHINESE",82]="选择了无效的语言，请重新输入"

	arr["ENGLISH",83]="Language changed to English"
	arr["SPANISH",83]="Idioma cambiado a Español"
	arr["FRENCH",83]="Le script sera maintenant en Français"
	arr["CATALAN",83]="Idioma canviat a Català"
	arr["PORTUGUESE",83]="Idioma alterado para Português"
	arr["RUSSIAN",83]="Язык изменён на русский"
	arr["GREEK",83]="Η γλώσσα άλλαξε στα Ελληνικά"
	arr["ITALIAN",83]="Lingua cambiata in Italiano"
	arr["POLISH",83]="Zmieniono język na Polski"
	arr["GERMAN",83]="Sprache wurde auf deutsch geändert"
	arr["TURKISH",83]="Dil Türkçe olarak değiştirildi"
	arr["ARABIC",83]="تغيرت اللغة إلى العربية"
	arr["CHINESE",83]="当前语言已更改为简体中文"

	arr["ENGLISH",84]="Enterprise attacks menu"
	arr["SPANISH",84]="Menú de ataques Enterprise"
	arr["FRENCH",84]="Menu d'attaque Entreprise"
	arr["CATALAN",84]="Menú d'atacs Enterprise"
	arr["PORTUGUESE",84]="Menu de ataques Enterprise"
	arr["RUSSIAN",84]="Меню Enterprise атак"
	arr["GREEK",84]="Μενού επιλογών Enterprise"
	arr["ITALIAN",84]="Menu dell'attacco Enterprise"
	arr["POLISH",84]="Menu ataków Enterprise"
	arr["GERMAN",84]="Enterprise-Angriffsmenü"
	arr["TURKISH",84]="Enterprise saldırı menüsü"
	arr["ARABIC",84]="Entreprise قائمة هجمات"
	arr["CHINESE",84]="企业级加密攻击菜单"

	arr["ENGLISH",85]="Contact us by mail, IRC, Discord, etc. More info here: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["SPANISH",85]="Contáctanos por mail, IRC, Discord, etc. Más información aquí: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["FRENCH",85]="Contactez-nous par e-mail, IRC, Discord, etc. Plus d'infos ici: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["CATALAN",85]="Poseu-vos en contacte amb nosaltres per correu, IRC, Discord, etc. Més informació ací: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["PORTUGUESE",85]="Contacte-nos por e-mail, IRC, Discord, etc. Mais informações em: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["RUSSIAN",85]="Для связи с нами вы можете использовать электронную почту, IRC, Discord, и прочее. Больше информации здесь: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["GREEK",85]="Επικοινωνήστε μαζί μας μέσω mail, IRC, Discord, κλπ. Περισσότερες πληροφορίες εδώ: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["ITALIAN",85]="Contattaci via e-mail, IRC, Discord, ecc. Maggiori informazioni qui: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["POLISH",85]="Skontaktuj się z nami za pośrednictwem poczty, IRC, Discord, itp. Więcej informacji tutaj: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["GERMAN",85]="Kontaktieren Sie uns per E-Mail, IRC, Discord, etc. Mehr Infos hier: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["TURKISH",85]="E-posta, IRC, Discord, vb. ile ile bize ulaşın. Daha fazla bilgi için: \${normal_color}\${urlgithub_wiki}/Contact"
	arr["ARABIC",85]="\${normal_color}\${urlgithub_wiki}/Contact \${pink_color}:إلخ. مزيد من المعلومات هنا:  ، IRC ، Discord ، اتصل بنا عن طريق البريد"
	arr["CHINESE",85]="通过邮件、IRC、Discord 等方式联系我们。更多信息在这里: \${normal_color}\${urlgithub_wiki}/Contact"

	arr["ENGLISH",86]="Welcome"
	arr["SPANISH",86]="Bienvenid@"
	arr["FRENCH",86]="Bienvenue"
	arr["CATALAN",86]="Benvingut"
	arr["PORTUGUESE",86]="Bem-vindo"
	arr["RUSSIAN",86]="Добро пожаловать"
	arr["GREEK",86]="Καλως ορίσατε"
	arr["ITALIAN",86]="Benvenuti"
	arr["POLISH",86]="Witaj"
	arr["GERMAN",86]="Willkommen"
	arr["TURKISH",86]="Hoşgeldiniz"
	arr["ARABIC",86]="مرحبا"
	arr["CHINESE",86]="欢迎"

	arr["ENGLISH",87]="Change language"
	arr["SPANISH",87]="Cambiar idioma"
	arr["FRENCH",87]="Changer de langue"
	arr["CATALAN",87]="Canviar d'idioma"
	arr["PORTUGUESE",87]="Mudar idioma"
	arr["RUSSIAN",87]="Сменить язык"
	arr["GREEK",87]="Αλλάξτε γλώσσα"
	arr["ITALIAN",87]="Cambia la lingua"
	arr["POLISH",87]="Zmień język"
	arr["GERMAN",87]="Sprache ändern"
	arr["TURKISH",87]="Dili Değiştir"
	arr["ARABIC",87]="تغيير اللغة"
	arr["CHINESE",87]="设置语言"

	arr["ENGLISH",88]="Interface selection"
	arr["SPANISH",88]="Selección de interfaz"
	arr["FRENCH",88]="Sélection de l'interface"
	arr["CATALAN",88]="Selecció d'interfície"
	arr["PORTUGUESE",88]="Seleção de interface"
	arr["RUSSIAN",88]="Выбор интерфейса"
	arr["GREEK",88]="Επιλογή διεπαφής"
	arr["ITALIAN",88]="Selezione dell'interfaccia"
	arr["POLISH",88]="Wybór interfejsu"
	arr["GERMAN",88]="Interface-Auswahl"
	arr["TURKISH",88]="Arayüz seçimi"
	arr["ARABIC",88]="اختيار الواجهة"
	arr["CHINESE",88]="接口选择菜单"

	arr["ENGLISH",89]="\${mdk_command} amok action"
	arr["SPANISH",89]="Acción \${mdk_command} amok"
	arr["FRENCH",89]="Action \${mdk_command} amok"
	arr["CATALAN",89]="Acció \${mdk_command} amok"
	arr["PORTUGUESE",89]="Ação \${mdk_command} amok"
	arr["RUSSIAN",89]="\${mdk_command} amok в действии"
	arr["GREEK",89]="Ενέργεια \${mdk_command} amok"
	arr["ITALIAN",89]="Azione \${mdk_command} amok"
	arr["POLISH",89]="Akcja \${mdk_command} amok"
	arr["GERMAN",89]="\${mdk_command} amok Aktion"
	arr["TURKISH",89]="\${mdk_command} amok etkisi"
	arr["ARABIC",89]="\${mdk_command} amok فعل"
	arr["CHINESE",89]="\${mdk_command} amok 行动"

	arr["ENGLISH",90]="Aireplay deauth action"
	arr["SPANISH",90]="Acción aireplay deauth"
	arr["FRENCH",90]="Action aireplay deauth"
	arr["CATALAN",90]="Acció aireplay deauth"
	arr["PORTUGUESE",90]="Ação deauth aireplay"
	arr["RUSSIAN",90]="Деаутентификация Aireplay в действии"
	arr["GREEK",90]="Ενέργεια aireplay deauth"
	arr["ITALIAN",90]="Azione aireplay deauth"
	arr["POLISH",90]="Akcja aireplay deauth"
	arr["GERMAN",90]="Aireplay deauth Aktion"
	arr["TURKISH",90]="Aireplay deauth etkisi"
	arr["ARABIC",90]="Aireplay deauth فعل"
	arr["CHINESE",90]="Aireplay 解除身份验证行动"

	arr["ENGLISH",91]="WIDS / WIPS / WDS confusion action"
	arr["SPANISH",91]="Acción WIDS / WIPS / WDS confusion"
	arr["FRENCH",91]="Action WIDS / WIPS / WDS confusion"
	arr["CATALAN",91]="Acció WIDS / WIPS / WDS confusion"
	arr["PORTUGUESE",91]="Ação WIDS / WIPS / confusão WDS"
	arr["RUSSIAN",91]="Запутывание WIDS / WIPS / WDS в действии"
	arr["GREEK",91]="Ενέργεια σύγχυσης WIDS / WIPS / WDS"
	arr["ITALIAN",91]="Azione WIDS / WIPS / WDS confusion"
	arr["POLISH",91]="Akcja WIDS / WIPS / WDS confusion"
	arr["GERMAN",91]="WIDS / WIPS / WDS confusion Aktion"
	arr["TURKISH",91]="WIDS / WIPS / WDS confusion etkisi"
	arr["ARABIC",91]="WIDS / WIPS / WDS confusion فعل"
	arr["CHINESE",91]="WIDS / WIPS / WDS 混淆行动"

	arr["ENGLISH",92]="Beacon flood action"
	arr["SPANISH",92]="Acción Beacon flood"
	arr["FRENCH",92]="Action Beacon flood"
	arr["CATALAN",92]="Acció Beacon flood"
	arr["PORTUGUESE",92]="Ação Beacon flood"
	arr["RUSSIAN",92]="Beacon flood в действии"
	arr["GREEK",92]="Ενέργεια πλημμυρίσματος φάρου"
	arr["ITALIAN",92]="Azione Beacon flood"
	arr["POLISH",92]="Akcja Beacon flood"
	arr["GERMAN",92]="Beacon flood Aktion"
	arr["TURKISH",92]="Beacon flood etkisi"
	arr["ARABIC",92]="Beacon flood فعل"
	arr["CHINESE",92]="WiFi 信号信标伪造 DoS 行动"

	arr["ENGLISH",93]="Auth DoS action"
	arr["SPANISH",93]="Acción Auth DoS"
	arr["FRENCH",93]="Action Auth DoS"
	arr["CATALAN",93]="Acció Auth DoS"
	arr["PORTUGUESE",93]="Ação Auth DoS"
	arr["RUSSIAN",93]="DoS аутентификации в действии"
	arr["GREEK",93]="Ενέργεια Auth DoS"
	arr["ITALIAN",93]="Azione Auth DoS"
	arr["POLISH",93]="Akcja Auth DoS"
	arr["GERMAN",93]="Auth DoS Aktion"
	arr["TURKISH",93]="Auth DoS etkisi"
	arr["ARABIC",93]="Auth DoS فعل"
	arr["CHINESE",93]="授权 DoS 行动"

	arr["ENGLISH",94]="Michael Shutdown action"
	arr["SPANISH",94]="Acción Michael Shutdown"
	arr["FRENCH",94]="Action Michael Shutdown"
	arr["CATALAN",94]="Acció Michael Shutdown"
	arr["PORTUGUESE",94]="Ação Michael Shutdown"
	arr["RUSSIAN",94]="Michael Shutdown в действии"
	arr["GREEK",94]="Ενέργεια Michael Shutdown"
	arr["ITALIAN",94]="Azione Michael Shutdown"
	arr["POLISH",94]="Akcja Michael Shutdown"
	arr["GERMAN",94]="Michael Shutdown Aktion"
	arr["TURKISH",94]="Michael Shutdown etkisi"
	arr["ARABIC",94]="Michael Shutdown فعل"
	arr["CHINESE",94]=" 迈克尔关机 (TKIP) 行动"

	arr["ENGLISH",95]="\${mdk_command} amok parameters"
	arr["SPANISH",95]="Parámetros \${mdk_command} amok"
	arr["FRENCH",95]="Paramètres \${mdk_command} amok"
	arr["CATALAN",95]="Paràmetres \${mdk_command} amok"
	arr["PORTUGUESE",95]="Parâmetros \${mdk_command} amok"
	arr["RUSSIAN",95]="Параметры \${mdk_command} amok"
	arr["GREEK",95]="Παράμετροι \${mdk_command} amok"
	arr["ITALIAN",95]="Parametri \${mdk_command} amok"
	arr["POLISH",95]="Parametry \${mdk_command} amok"
	arr["GERMAN",95]="\${mdk_command} amok Parameter"
	arr["TURKISH",95]="\${mdk_command} amok parametreleri"
	arr["ARABIC",95]="\${mdk_command} amok معايير"
	arr["CHINESE",95]="\${mdk_command} amok 攻击参数"

	arr["ENGLISH",96]="Aireplay deauth parameters"
	arr["SPANISH",96]="Parámetros Aireplay deauth"
	arr["FRENCH",96]="Paramètres Aireplay deauth"
	arr["CATALAN",96]="Paràmetres Aireplay deauth"
	arr["PORTUGUESE",96]="Parâmetros Aireplay deauth"
	arr["RUSSIAN",96]="Параметры деаутентификации Aireplay"
	arr["GREEK",96]="Παράμετροι Aireplay deauth"
	arr["ITALIAN",96]="Parametri Aireplay deauth"
	arr["POLISH",96]="Parametry Aireplay deauth"
	arr["GERMAN",96]="Aireplay deauth Parameter"
	arr["TURKISH",96]="Aireplay deauth parametreleri"
	arr["ARABIC",96]="Aireplay deauth معايير"
	arr["CHINESE",96]="Aireplay 参数"

	arr["ENGLISH",97]="WIDS / WIPS / WDS parameters"
	arr["SPANISH",97]="Parámetros WIDS / WIPS / WDS"
	arr["FRENCH",97]="Paramètres WIDS / WIPS / WDS"
	arr["CATALAN",97]="Paràmetres WIDS / WIPS / WDS"
	arr["PORTUGUESE",97]="Parâmetros WIDS / WIPS / WDS"
	arr["RUSSIAN",97]="Параметры WIDS / WIPS / WDS"
	arr["GREEK",97]="Παράμετροι WIDS / WIPS / WDS"
	arr["ITALIAN",97]="Parametri WIDS / WIPS / WDS"
	arr["POLISH",97]="Parametry WIDS / WIPS / WDS"
	arr["GERMAN",97]="WIDS / WIPS / WDS Parameter"
	arr["TURKISH",97]="WIDS / WIPS / WDS parametreleri"
	arr["ARABIC",97]="WIDS / WIPS / WDS معايير"
	arr["CHINESE",97]="WIDS / WIPS / WDS 参数"

	arr["ENGLISH",98]="Beacon flood parameters"
	arr["SPANISH",98]="Parámetros Beacon flood"
	arr["FRENCH",98]="Paramètres Beacon flood"
	arr["CATALAN",98]="Paràmetres Beacon flood"
	arr["PORTUGUESE",98]="Parâmetros Beacon flood"
	arr["RUSSIAN",98]="Параметры Beacon flood"
	arr["GREEK",98]="Παράμετροι πλημμυρίσματος φάρου"
	arr["ITALIAN",98]="Parametri Beacon flood"
	arr["POLISH",98]="Parametry Beacon flood"
	arr["GERMAN",98]="Beacon flood Parameter"
	arr["TURKISH",98]="Beacon flood parametreleri"
	arr["ARABIC",98]="Beacon flood معايير"
	arr["CHINESE",98]="WiFi 信号信标伪造 DoS 攻击"

	arr["ENGLISH",99]="Auth DoS parameters"
	arr["SPANISH",99]="Parámetros Auth DoS"
	arr["FRENCH",99]="Paramètres Auth DoS"
	arr["CATALAN",99]="Paràmetres Auth DoS"
	arr["PORTUGUESE",99]="Parâmetros Auth DoS"
	arr["RUSSIAN",99]="Параметры аутентификации DoS"
	arr["GREEK",99]="Παράμετροι Auth DoS"
	arr["ITALIAN",99]="Parametri Auth DoS"
	arr["POLISH",99]="Parametry Auth DoS"
	arr["GERMAN",99]="Auth DoS Parameter"
	arr["TURKISH",99]="Auth DoS parametreleri"
	arr["ARABIC",99]="Auth DoS معايير"
	arr["CHINESE",99]="身份验证 DoS 参数"

	arr["ENGLISH",100]="Michael Shutdown parameters"
	arr["SPANISH",100]="Parámetros Michael Shutdown"
	arr["FRENCH",100]="Paramètres Michael Shutdown"
	arr["CATALAN",100]="Paràmetres Michael Shutdown"
	arr["PORTUGUESE",100]="Parâmetros Michael Shutdown"
	arr["RUSSIAN",100]="Параметры Michael Shutdown"
	arr["GREEK",100]="Παράμετροι Michael Shutdown"
	arr["ITALIAN",100]="Parametri Michael Shutdown"
	arr["POLISH",100]="Parametry Michael Shutdown"
	arr["GERMAN",100]="Michael Shutdown Parameter"
	arr["TURKISH",100]="Michael Shutdown parametreleri"
	arr["ARABIC",100]="Michael Shutdown معايير"
	arr["CHINESE",100]="迈克尔关机 (TKIP) 参数"

	arr["ENGLISH",101]="airgeddon ${normal_color}v${airgeddon_version}${green_color_title} main menu"
	arr["SPANISH",101]="Menú principal airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["FRENCH",101]="Menu principal d'airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["CATALAN",101]="Menú principal airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["PORTUGUESE",101]="Menu principal airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["RUSSIAN",101]="Главное меню airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["GREEK",101]="Αρχικό μενού airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["ITALIAN",101]="Menú principale airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["POLISH",101]="Menu główne airgeddon ${normal_color}v${airgeddon_version}${green_color_title}"
	arr["GERMAN",101]="airgeddon ${normal_color}v${airgeddon_version}${green_color_title} Hauptmenü"
	arr["TURKISH",101]="airgeddon ${normal_color}v${airgeddon_version}${green_color_title} ana menü"
	arr["ARABIC",101]="القائمة الرئيسية ${normal_color}v${airgeddon_version}${green_color_title} airgeddon"
	arr["CHINESE",101]="airgeddon ${normal_color}v${airgeddon_version}${green_color_title} 主菜单"

	arr["ENGLISH",102]="DoS attacks menu"
	arr["SPANISH",102]="Menú ataques DoS"
	arr["FRENCH",102]="Menu des attaques DoS"
	arr["CATALAN",102]="Menú d'atacs DoS"
	arr["PORTUGUESE",102]="Menu de ataques DoS"
	arr["RUSSIAN",102]="Меню DoS атак"
	arr["GREEK",102]="Μενού επιθέσεων DoS"
	arr["ITALIAN",102]="Menú attacchi DoS"
	arr["POLISH",102]="Menu ataków DoS"
	arr["GERMAN",102]="DoS-Angriffsmenü"
	arr["TURKISH",102]="DoS saldırı menüsü"
	arr["ARABIC",102]="DoS قائمة هجمات"
	arr["CHINESE",102]="DoS 攻击菜单"

	arr["ENGLISH",103]="Exploring for targets"
	arr["SPANISH",103]="Explorar para buscar objetivos"
	arr["FRENCH",103]="Détection pour trouver des cibles"
	arr["CATALAN",103]="Explorar per buscar objectius"
	arr["PORTUGUESE",103]="Procurar por redes wifi"
	arr["RUSSIAN",103]="Сканирование целей"
	arr["GREEK",103]="Εξερεύνηση στόχων"
	arr["ITALIAN",103]="Scansionare per cercare obiettivi"
	arr["POLISH",103]="Skanowanie w poszukiwaniu celów"
	arr["GERMAN",103]="Scans, um Ziele zu finden"
	arr["TURKISH",103]="Hedefler taranıyor"
	arr["ARABIC",103]="تصفح للعثور على الأهداف"
	arr["CHINESE",103]="扫描目标"

	arr["ENGLISH",104]="Select target"
	arr["SPANISH",104]="Seleccionar objetivo"
	arr["FRENCH",104]="Selection de l'objectif"
	arr["CATALAN",104]="Seleccionar objectiu"
	arr["PORTUGUESE",104]="Escolha um objetivo"
	arr["RUSSIAN",104]="Выбор цели"
	arr["GREEK",104]="Επιλέξτε στόχο"
	arr["ITALIAN",104]="Selezionare obiettivo"
	arr["POLISH",104]="Wybierz cel"
	arr["GERMAN",104]="Wählen Sie das Ziel aus"
	arr["TURKISH",104]="Hedef seçiniz"
	arr["ARABIC",104]="حدد هدف"
	arr["CHINESE",104]="选择目标"

	arr["ENGLISH",105]="About & Credits"
	arr["SPANISH",105]="Acerca de & Créditos"
	arr["FRENCH",105]="A propos de & Crédits"
	arr["CATALAN",105]="Sobre de & Crédits"
	arr["PORTUGUESE",105]="Sobre & Créditos"
	arr["RUSSIAN",105]="О программе и Благодарности"
	arr["GREEK",105]="Σχετικά με & Εύσυμα"
	arr["ITALIAN",105]="Informazioni & Crediti"
	arr["POLISH",105]="Informacje & Podziękowania"
	arr["GERMAN",105]="About & Credits"
	arr["TURKISH",105]="Hakkımızda & Güven"
	arr["ARABIC",105]="بشأن ومنسوبات"
	arr["CHINESE",105]="关于 & 鸣谢 / 赞助"

	arr["ENGLISH",106]="Exiting"
	arr["SPANISH",106]="Saliendo"
	arr["FRENCH",106]="Sortie du script"
	arr["CATALAN",106]="Sortint"
	arr["PORTUGUESE",106]="Saindo"
	arr["RUSSIAN",106]="Выход"
	arr["GREEK",106]="Γίνεται έξοδος"
	arr["ITALIAN",106]="Uscendo"
	arr["POLISH",106]="Wychodzenie"
	arr["GERMAN",106]="Verlassen"
	arr["TURKISH",106]="Çıkış yapılıyor"
	arr["ARABIC",106]="الخروج من البرنامج"
	arr["CHINESE",106]="正在退出"

	arr["ENGLISH",107]="Join the project at \${normal_color}\${urlgithub}"
	arr["SPANISH",107]="Únete al proyecto en \${normal_color}\${urlgithub}"
	arr["FRENCH",107]="Rejoignez le projet: \${normal_color}\${urlgithub}"
	arr["CATALAN",107]="Uneix-te al projecte a \${normal_color}\${urlgithub}"
	arr["PORTUGUESE",107]="Junte-se ao projeto em \${normal_color}\${urlgithub}"
	arr["RUSSIAN",107]="Присоединитесь к проекту на \${normal_color}\${urlgithub}"
	arr["GREEK",107]="Συμμετέχετε στο project \${normal_color}\${urlgithub}"
	arr["ITALIAN",107]="Unisciti al progetto in \${normal_color}\${urlgithub}"
	arr["POLISH",107]="Dołącz do projektu w \${normal_color}\${urlgithub}"
	arr["GERMAN",107]="Treten Sie das Projekt in \${normal_color}\${urlgithub} \${pink_color}bei"
	arr["TURKISH",107]="Projeye buradan katılın \${normal_color}\${urlgithub}"
	arr["ARABIC",107]="\${normal_color}\${urlgithub}\${pink_color} انضم إلى المشروع على"
	arr["CHINESE",107]="在 \${normal_color}\${urlgithub} 加入项目"

	arr["ENGLISH",108]="Let's check if you have installed what script needs"
	arr["SPANISH",108]="Vamos a chequear si tienes instalado lo que el script requiere"
	arr["FRENCH",108]="Nous allons vérifier si les dépendances sont bien installées"
	arr["CATALAN",108]="Anem a verificar si tens instal·lat el que l'script requereix"
	arr["PORTUGUESE",108]="Vamos verificar se você tem instalado tudo que o script exige"
	arr["RUSSIAN",108]="Давайте проверим, всё ли, что нужно скрипту, установлено"
	arr["GREEK",108]="Ας ελέγξουμε αν έχετε εγκαταστήσει ό,τι χρειάζεται το script"
	arr["ITALIAN",108]="Andiamo a verificare se è stato installato quello che richiede lo script"
	arr["POLISH",108]="Sprawdźmy czy jest zainstalowane to, czego wymaga skrypt"
	arr["GERMAN",108]="Lassen Sie uns überprüfen, ob Sie die vom Skript benötigte Paketen installiert sind"
	arr["TURKISH",108]="Hadi yazılımın ihtiyacı olan diğer yazılımları kontrol edelim"
	arr["ARABIC",108]="دعنا نتحقق مما إذا كنت قد قمت بتثبيت ما يحتاجه البرنامج"
	arr["CHINESE",108]="让我们检查一下你是否已经安装了脚本需要的软件包"

	arr["ENGLISH",109]="Essential tools: checking..."
	arr["SPANISH",109]="Herramientas esenciales: comprobando..."
	arr["FRENCH",109]="Vérification de la présence des outils nécessaires..."
	arr["CATALAN",109]="Eines essencials: comprovant..."
	arr["PORTUGUESE",109]="Verificando se as ferramentas necessárias estão presentes..."
	arr["RUSSIAN",109]="Основные инструменты: проверка..."
	arr["GREEK",109]="Απαραίτητα εργαλεία: γίνεται έλεγχος..."
	arr["ITALIAN",109]="Strumenti essenziali: controllando..."
	arr["POLISH",109]="Podstawowe narzędzia: sprawdzanie..."
	arr["GERMAN",109]="Wesentliche Werkzeuge: Überprüfung..."
	arr["TURKISH",109]="Temel araçlar: kontrol ediliyor..."
	arr["ARABIC",109]="...التحقق من وجود الأدوات اللازمة"
	arr["CHINESE",109]="必备工具: 检查中..."

	arr["ENGLISH",110]="Your distro has all necessary essential tools. Script can continue..."
	arr["SPANISH",110]="Tu distro tiene todas las herramientas esenciales necesarias. El script puede continuar..."
	arr["FRENCH",110]="Les outils essentiels nécessaires au bon fonctionnement du programme sont tous présents dans votre système. Le script peut continuer..."
	arr["CATALAN",110]="La teva distro té totes les eines essencials necessàries. El script pot continuar..."
	arr["PORTUGUESE",110]="Sua distro tem as ferramentas essenciais. O script pode continuar..."
	arr["RUSSIAN",110]="Ваша система имеет все необходимые основные инструменты. Скрипт может продолжать..."
	arr["GREEK",110]="Η διανομή σας έχει όλα τα απαραίτητα εργαλεία. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",110]="La tua distro ha tutti gli strumenti essenziali necessari. Lo script può continuare..."
	arr["POLISH",110]="Twój distro posiada wszystkie niezbędne niezbędne narzędzia. Skrypt może kontynuować..."
	arr["GERMAN",110]="Ihre Distribution verfügt über alle notwendigen Werkzeuge. Das Skript kann fortfahren..."
	arr["TURKISH",110]="Senin dağıtımın tüm gerekli temel araçları barındırıyor. Yazılım devam edebilir..."
	arr["ARABIC",110]="...الأدوات الأساسية اللازمة للتشغيل السليم للبرنامج كلها موجودة في نظامك. يمكن أن يستمر البرنامج"
	arr["CHINESE",110]="您的发行版已经安装了所有的脚本必备工具。脚本可以继续..."

	arr["ENGLISH",111]="You need to install some essential tools before running this script"
	arr["SPANISH",111]="Necesitas instalar algunas herramientas esenciales antes de lanzar este script"
	arr["FRENCH",111]="Vous devez installer quelques programmes avant de pouvoir lancer ce script"
	arr["CATALAN",111]="Necessites instal·lar algunes eines essencials abans d'executar aquest script"
	arr["PORTUGUESE",111]="Você precisa instalar algumas ferramentas essenciais antes de executar este script"
	arr["RUSSIAN",111]="Перед работой в этом скрипте, вам нужно установить некоторые основные инструменты"
	arr["GREEK",111]="Χρειάζεται να εγκαταστήσετε κάποια απαραίτητα εργαλεία πριν τρέξετε το script"
	arr["ITALIAN",111]="È necessario installare alcuni strumenti essenziali prima di lanciare questo script"
	arr["POLISH",111]="Przed uruchomieniem tego skryptu musisz zainstalować kilka niezbędnych narzędzi"
	arr["GERMAN",111]="Sie müssen einige wichtige Tools installieren, bevor Sie dieses Skript starten"
	arr["TURKISH",111]="Bu yazılımı çalıştırmadan önce bazı temel araçları yüklemeniz gerekmektedir"
	arr["ARABIC",111]="تحتاج إلى تثبيت بعض الأدوات الأساسية قبل تشغيل هذا البرنامج"
	arr["CHINESE",111]="在运行此脚本之前，您需要安装一些必要的工具"

	arr["ENGLISH",112]="WPA/WPA2 Enterprise networks are commonly used in corporate environments. They use a Radius server for authentication and unlike conventional networks require more elements for authentication, not just a password. They may require username, password and occasionally a certificate"
	arr["SPANISH",112]="Las redes WPA/WPA2 Enterprise suelen configurarse en entornos corporativos. Utilizan un servidor Radius para la autenticación y a diferencia de las redes convencionales requieren más elementos para la autenticación, no solo una contraseña. Pueden requerir usuario y contraseña además de un certificado"
	arr["FRENCH",112]="Les réseaux WPA/WPA2 Enterprise sont généralement configurés sur environnements d'entreprise. Ils utilisent un serveur Radius pour l'authentification et, contrairement aux réseaux conventionnels, ont besoin de plus éléments pour l'authentification, pas seulement un mot de passe. Ils peuvent exiger un nom d'utilisateur et un mot de passe en plus d'un certificat"
	arr["CATALAN",112]="Les xarxes WPA/WPA2 Enterprise solen configurar-se en entorns corporatius. Utilitzen un servidor Radius per a l'autenticació i a diferència de les xarxes convencionals requereixen més elements per a l'autenticació, no sols una contrasenya. Poden requerir usuari i contrasenya a més d'un certificat"
	arr["PORTUGUESE",112]="As redes WPA/WPA2 Enterprise geralmente são configuradas em ambientes corporativos. É usado um servidor Radius para autenticação o que exige mais elementos para autenticação, ao contrário das redes convencionais que exigem apenas uma senha. Pode ser exigido: um nome de usuário, uma senha e um certificado"
	arr["RUSSIAN",112]="Сети WPA/WPA2 Enterprise обычно используются в корпоративных средах. Они используют сервер Radius для аутентификации и, в отличие от обычных сетей, требуют больше элементов аутентификации, помимо пароля. Они могут требовать имя пользователя, пароль и иногда сертификат"
	arr["GREEK",112]="Τα WPA/WPA2 Enterprise δίκτυα χρησιμοποιούνται συνήθως σε εταιρικά περιβάλλοντα. Χρησιμοποιούν έναν διακομιστή Radius για έλεγχο ταυτότητας και σε αντίθεση με τα συμβατικά δίκτυα απαιτούν περισσότερα στοιχεία για τον έλεγχο ταυτότητας και όχι μόνο τον κωδικό πρόσβασης. Μπορεί να απαιτούν όνομα χρήστη, κωδικό πρόσβασης και περιστασιακά κάποιο certificate"
	arr["ITALIAN",112]="Le reti WPA/WPA2 Enterprise sono solitamente configurate negli ambienti aziendali. Utilizzano un server Radius per l'autenticazione e, diversamente dalle reti convenzionali, richiedono più elementi per l'autenticazione, non solo una password. Possono richiedere un nome utente e una password oltre a un certificato"
	arr["POLISH",112]="Sieci WPA/WPA2 Enterprise są powszechnie stosowane w środowiskach korporacyjnych. Korzystają z serwera Radius do uwierzytelniania i w przeciwieństwie do sieci konwencjonalnych wymagają więcej elementów do uwierzytelnienia, a nie tylko hasła. Mogą wymagać nazwy użytkownika, hasła i czasami certyfikatu"
	arr["GERMAN",112]="WPA/WPA2 Enterprise-Netzwerke werden häufig in Unternehmensumgebungen verwendet. Sie verwenden einen Radius-Server zur Authentifizierung und benötigen im Gegensatz zu herkömmlichen Netzwerken mehr Elemente zur Authentifizierung als ein Passwort. Sie benötigen möglicherweise Benutzernamen, Passwort und gelegentlich ein Zertifikat"
	arr["TURKISH",112]="WPA/WPA2 Enterprise ağlar, şirket ortamlarında yaygın olarak kullanılır. Kimlik doğrulaması için bir Radius sunucu kullanıyorlar ve geleneksel ağların aksine, yalnızca bir şifre değil, kimlik doğrulama için daha fazla öğe gerekiyor. Kullanıcı adı, şifre ve bazen sertifika isteyebilirler"
	arr["ARABIC",112]="للمصادقة وعلى عكس الشبكات التقليدية تتطلب عناصر أكثر للمصادقة ، وليس مجرد كلمة مرور. قد يطلبون اسم مستخدم وكلمة مرور وأحيانًا شهادة Radius بشكل شائع في بيئات الشركات. يستخدمون خادم WPA/WPA2 Entreprise تستخدم شبكات"
	arr["CHINESE",112]="WPA/WPA2 企业级加密的网络通常用于企业环境。他们使用 Radius 服务器进行身份验证，与传统加密方式的网络不同，它们需要更多元素进行身份验证，而不仅仅是密码，可能还需要用户名等凭据，有时还需要证书"

	arr["ENGLISH",113]="3.  French"
	arr["SPANISH",113]="3.  Francés"
	arr["FRENCH",113]="3.  Français"
	arr["CATALAN",113]="3.  Francès"
	arr["PORTUGUESE",113]="3.  Francês"
	arr["RUSSIAN",113]="3.  Французский"
	arr["GREEK",113]="3.  Γαλλικά"
	arr["ITALIAN",113]="3.  Francese"
	arr["POLISH",113]="3.  Francuski"
	arr["GERMAN",113]="3.  Französisch"
	arr["TURKISH",113]="3.  Fransızca"
	arr["ARABIC",113]="3.  الفرنسية"
	arr["CHINESE",113]="3.  法语"

	arr["ENGLISH",114]="Use it only on your own networks!!"
	arr["SPANISH",114]="Utilízalo solo en tus propias redes!!"
	arr["FRENCH",114]="Utilisez-le seulement dans vos propres réseaux!!"
	arr["CATALAN",114]="Utilitza'l només a les teves pròpies xarxes!!"
	arr["PORTUGUESE",114]="Use-o apenas em suas próprias redes!!"
	arr["RUSSIAN",114]="Используйте только на ваших собственных сетях!!"
	arr["GREEK",114]="Χρησιμοποιήστε το μόνο σε δικά σας δίκτυα!!"
	arr["ITALIAN",114]="Usalo solo nelle tue reti!!"
	arr["POLISH",114]="Używaj tylko we własnych sieciach!!"
	arr["GERMAN",114]="Verwenden Sie es nur in Ihren eigenen Netzwerken!!"
	arr["TURKISH",114]="Sadece kendi ağlarında kullan!!"
	arr["ARABIC",114]="!!استخدامه فقط على شبكة الخاصة بك"
	arr["CHINESE",114]="请仅在您自己的网络上使用它！！"

	arr["ENGLISH",115]="Press [Enter] key to continue..."
	arr["SPANISH",115]="Pulsa la tecla [Enter] para continuar..."
	arr["FRENCH",115]="Pressez [Enter] pour continuer..."
	arr["CATALAN",115]="Prem la tecla [Enter] per continuar..."
	arr["PORTUGUESE",115]="Pressione a tecla [Enter] para continuar..."
	arr["RUSSIAN",115]="Нажмите клавишу [Enter] для продолжения..."
	arr["GREEK",115]="Πατήστε το κουμπί [Enter] για να συνεχίσετε..."
	arr["ITALIAN",115]="Premere il tasto [Enter] per continuare..."
	arr["POLISH",115]="Naciśnij klawisz [Enter], aby kontynuować..."
	arr["GERMAN",115]="Drücken Sie die [Enter]-Taste, um fortzufahren..."
	arr["TURKISH",115]="Devam etmek için [Enter] tuşlayınız..."
	arr["ARABIC",115]="...للمتابعة [Enter] اضغط على مفتاح"
	arr["CHINESE",115]="按 [Enter] 键继续..."

	arr["ENGLISH",116]="4.  Catalan"
	arr["SPANISH",116]="4.  Catalán"
	arr["FRENCH",116]="4.  Catalan"
	arr["CATALAN",116]="4.  Català"
	arr["PORTUGUESE",116]="4.  Catalão"
	arr["RUSSIAN",116]="4.  Каталонский"
	arr["GREEK",116]="4.  Καταλανικά"
	arr["ITALIAN",116]="4.  Catalano"
	arr["POLISH",116]="4.  Kataloński"
	arr["GERMAN",116]="4.  Katalanisch"
	arr["TURKISH",116]="4.  Katalan"
	arr["ARABIC",116]="4.  الكاتالونية"
	arr["CHINESE",116]="4.  加泰罗尼亚语"

	arr["ENGLISH",117]="smooth mode, disconnect on capture"
	arr["SPANISH",117]="modo smooth, desconectar tras capturar"
	arr["FRENCH",117]="mode silencieux, déconnecter après la capture"
	arr["CATALAN",117]="mode smooth, desconnectar després de capturar"
	arr["PORTUGUESE",117]="modo discreto, finaliza após uma captura"
	arr["RUSSIAN",117]="smooth mode, отключить атаку, как только захвачены данные,"
	arr["GREEK",117]="smooth mode, αποσυνδέστε τη συσκευή μετά τη λήψη"
	arr["ITALIAN",117]="modalità smooth, disconnettersi dopo la cattura"
	arr["POLISH",117]="tryb smooth, odłącz po przechwyceniu"
	arr["GERMAN",117]="smooth-Modus, nach dem Erfassen abschalten"
	arr["TURKISH",117]="smooth mod, yakalamadan sonra bağlantıyı keser"
	arr["ARABIC",117]="قطع الاتصال عند الالتقاط ،smooth mode وضع"
	arr["CHINESE",117]="平滑模式，捕获密码或哈希时断开连接"

	arr["ENGLISH",118]="4.  DoS attacks menu"
	arr["SPANISH",118]="4.  Menú de ataques DoS"
	arr["FRENCH",118]="4.  Menu des attaques DoS"
	arr["CATALAN",118]="4.  Menú d'atacs DoS"
	arr["PORTUGUESE",118]="4.  Menu de ataques DoS"
	arr["RUSSIAN",118]="4.  Меню DoS атак"
	arr["GREEK",118]="4.  Μενού επιθέσεων DoS"
	arr["ITALIAN",118]="4.  Menù attacchi DoS"
	arr["POLISH",118]="4.  Menu ataków DoS"
	arr["GERMAN",118]="4.  DoS-Angriffsmenü"
	arr["TURKISH",118]="4.  DoS attacks menüsü"
	arr["ARABIC",118]="4.  DoS قائمة هجمات"
	arr["CHINESE",118]="4.  DoS 攻击菜单"

	arr["ENGLISH",119]="5.  Handshake/PMKID/Decloaking tools menu"
	arr["SPANISH",119]="5.  Menú de herramientas Handshake/PMKID/Decloaking"
	arr["FRENCH",119]="5.  Menu des outils pour Handshake/PMKID/Decloaking"
	arr["CATALAN",119]="5.  Menú d'eines Handshake/PMKID/Decloaking"
	arr["PORTUGUESE",119]="5.  Menu de ferramentas Handshake/PMKID/Descamuflagem"
	arr["RUSSIAN",119]="5.  Меню инструментов для работы с Handshake/PMKID/Decloaking"
	arr["GREEK",119]="5.  Μενού εργαλειών Handshake/PMKID/Decloaking"
	arr["ITALIAN",119]="5.  Menu degli strumenti Handshake/PMKID/Decloaking"
	arr["POLISH",119]="5.  Menu narzędzi Handshake/PMKID/Decloaking"
	arr["GERMAN",119]="5.  Handshake/PMKID/Decloaking-Tools-Menü"
	arr["TURKISH",119]="5.  Handshake/PMKID/Decloaking araçları menüsü"
	arr["ARABIC",119]="5.  Handshake/PMKID/Decloaking قائمة أدوات"
	arr["CHINESE",119]="5.  Handshake/PMKID/Decloaking 工具菜单"

	arr["ENGLISH",120]="Handshake/PMKID/Decloaking tools menu"
	arr["SPANISH",120]="Menú de herramientas Handshake/PMKID/Decloaking"
	arr["FRENCH",120]="Menu des outils pour Handshake/PMKID/Decloaking"
	arr["CATALAN",120]="Menú d'eines Handshake/PMKID/Decloaking"
	arr["PORTUGUESE",120]="Menu de ferramentas Handshake/PMKID/Descamuflagem"
	arr["RUSSIAN",120]="Меню инструментов для работы с Handshake/PMKID/Decloaking"
	arr["GREEK",120]="Μενού εργαλειών Handshake/PMKID/Decloaking"
	arr["ITALIAN",120]="Menu degli strumenti Handshake/PMKID/Decloaking"
	arr["POLISH",120]="Menu narzędzi Handshake/PMKID/Decloaking"
	arr["GERMAN",120]="Handshake/PMKID/Decloaking-Tools-Menü"
	arr["TURKISH",120]="Handshake/PMKID/Decloaking araçları menüsü"
	arr["ARABIC",120]="Handshake/PMKID/Decloaking قائمة أدوات"
	arr["CHINESE",120]="Handshake/PMKID/Decloaking 工具菜单"

	arr["ENGLISH",121]="6.  Capture Handshake"
	arr["SPANISH",121]="6.  Capturar Handshake"
	arr["FRENCH",121]="6.  Capture du Handshake"
	arr["CATALAN",121]="6.  Captura Handshake"
	arr["PORTUGUESE",121]="6.  Capturar Handshake"
	arr["RUSSIAN",121]="6.  Захват handshake"
	arr["GREEK",121]="6.  Καταγράψτε την Χειραψία"
	arr["ITALIAN",121]="6.  Catturare Handshake"
	arr["POLISH",121]="6.  Przechwyć Handshake"
	arr["GERMAN",121]="6.  Handshake ergreifen"
	arr["TURKISH",121]="6.  Handshake yakala"
	arr["ARABIC",121]="6.  Handshake التقاط"
	arr["CHINESE",121]="6.  捕捉握手包"

	arr["ENGLISH",122]="7.  Clean/optimize Handshake file"
	arr["SPANISH",122]="7.  Limpiar/optimizar fichero de Handshake"
	arr["FRENCH",122]="7.  Laver/optimiser le fichier Handshake"
	arr["CATALAN",122]="7.  Netejar/optimitzar fitxer de Handshake"
	arr["PORTUGUESE",122]="7.  Limpar arquivo/otimizar Handshake"
	arr["RUSSIAN",122]="7.  Очистка/оптимизация Handshake файла"
	arr["GREEK",122]="7.  Καθαρισμός/βελτιστοποίηση του αρχείου Χειραψίας"
	arr["ITALIAN",122]="7.  Pulire/ottimizzare file Handshake"
	arr["POLISH",122]="7.  Oczyść/zoptymalizuj plik Handshake"
	arr["GERMAN",122]="7.  Handshake-Datei bereinigen/optimieren"
	arr["TURKISH",122]="7.  Handshake dosyalarını Temizle/Optimize et"
	arr["ARABIC",122]="7.  Handshake تنظيف/تحسين ملف"
	arr["CHINESE",122]="7.  清理/优化握手包文件"

	arr["ENGLISH",123]="If the password for the wifi network is obtained with the WPS attack, you should decide where to save it. \${green_color}Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${wps_potpath}]"
	arr["SPANISH",123]="Si se consigue la contraseña de la red wifi con el ataque WPS, hay que decidir donde guardarla. \${green_color}Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${wps_potpath}]"
	arr["FRENCH",123]="Si le mot de passe est obtenu par une attaque WPS, il faut ensuite indiquer l'endroit pour la sauvegarder. \${green_color}Entrez le chemin de l'endroit où vous voulez garder le fichier ou bien appuyez sur [Enter] si le chemin proposée par défaut vous convient \${normal_color}[\${wps_potpath}]"
	arr["CATALAN",123]="Si s'aconsegueix la contrasenya de la xarxa wifi amb l'atac WPS, cal decidir on guardar-la. \${green_color}Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${wps_potpath}]"
	arr["PORTUGUESE",123]="Se a senha da rede wifi for obtida com o ataque WPS, onde deseja salvá-la?. \${green_color}Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${wps_potpath}]"
	arr["RUSSIAN",123]="Вы должны решить где сохранить пароль, если его получится захватить во время WPS атаки. \${green_color} Наберите путь для сохранения файла или нажмите [Enter] для принятия значения по умолчанию \${normal_color}[\${wps_potpath}]"
	arr["GREEK",123]="Εάν ο κωδικός πρόσβασης του ασύρματου δικτύου αποκτηθεί με WPS attack, πρέπει να αποφασίσετε πού θα τον αποθηκεύσετε. \${green_color}Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${wps_potpath}]"
	arr["ITALIAN",123]="Se si ottiene la password della rete wireless con l'attacco WPS, bisogna decidere dove salvarla. \${green_color}Scrivere il percorso dove salvare il file o premere [Enter] per accettare la proposta di default \${normal_color}[\${wps_potpath}]"
	arr["POLISH",123]="Jeśli hasło sieci wifi zostanie uzyskane atakiem WPS, musisz zdecydować gdzie je zapisać. \${green_color}Wpisz ścieżkę, w której będziemy zapisywać plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${wps_potpath}]"
	arr["GERMAN",123]="Wenn Sie das WLAN-Passwort mit dem WPS-Angriff erhalten, müssen Sie entscheiden, wo Sie es speichern möchten. \${green_color} Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag \${normal_color}[\${wps_potpath}] \${blue_color}zu akzeptieren"
	arr["TURKISH",123]="Eğer wifi şifresini WPS saldırısı yöntemi ile elde ettiyseniz, nereye kaydedileceğini belirlemelisiniz. \${green_color}Dizin yolu girin veya [Enter] tuşuna varsayılan yere kaydedin. \${normal_color}[\${wps_potpath}]"
	arr["ARABIC",123]="\${normal_color}[\${wps_potpath}] \${green_color}لقبول الاقتراح [Enter] اكتب الطريق لتخزين الملف أو اضغط على \${blue_color}  .فيجب أن تقرر مكان حفظها ،WPS  بهجوم wifi إذا تم الحصول على كلمة المرور الخاصة بشبكة"
	arr["CHINESE",123]="如果 wifi 网络的密码是通过 WPS 攻击获得的，您应该决定将其保存在何处。 \${green_color}键入存储文件的路径或按 [Enter] 接受默认建议 \${normal_color}[\${wps_potpath}]"

	arr["ENGLISH",124]="monitor mode needed for capturing"
	arr["SPANISH",124]="modo monitor requerido en captura"
	arr["FRENCH",124]="modo moniteur nécessaire pour la capture"
	arr["CATALAN",124]="mode monitor requerit en captura"
	arr["PORTUGUESE",124]="modo monitor necessário para captura"
	arr["RUSSIAN",124]="для захвата необходим режим монитора"
	arr["GREEK",124]="χρειάζεται η κατάσταση παρακολούθησης για την καταγραφή"
	arr["ITALIAN",124]="modo monitor richesto per la cattura"
	arr["POLISH",124]="aby przechwytywać wymagany jest tryb monitorowania"
	arr["GERMAN",124]="Monitor-Modus für die Erfassung erforderlich"
	arr["TURKISH",124]="yakalamak için izleme modu gereklidir"
	arr["ARABIC",124]="لازم لالتقاط monitor mode وضع"
	arr["CHINESE",124]="抓包需要监听模式"

	arr["ENGLISH",125]="There is no valid target network selected. You'll be redirected to select one"
	arr["SPANISH",125]="No hay una red objetivo válida seleccionada. Serás redirigido para seleccionar una"
	arr["FRENCH",125]="Le choix du réseau cible est incorrect. Vous allez être redirigé vers le menu de sélection pour effectuer un nouveau choix"
	arr["CATALAN",125]="No hi ha una xarxa objectiu vàlida seleccionada. Seràs redirigit per seleccionar una"
	arr["PORTUGUESE",125]="Nenhuma rede válida selecionada. Você será redirecionado para selecionar uma"
	arr["RUSSIAN",125]="Не выбрана подходящая сеть. Вы будете перенаправлены на выбор сети"
	arr["GREEK",125]="Δεν έχει επιλεχθεί κάποιο έγκυρο δίκτυο-στόχος. Θα καθοδηγηθείτε ώστε να επιλέξετε ένα"
	arr["ITALIAN",125]="Nessuna rete valida selezionata come obiettivo. Sarai reindirizzato per selezionarne una"
	arr["POLISH",125]="Nie wybrano prawidłowej sieci docelowej. Zostaniesz przekierowany, aby ją wybrać"
	arr["GERMAN",125]="Kein gültiges Ziel-Netzwerk ausgewählt. Sie werden zur Auswahl weitergeleitet"
	arr["TURKISH",125]="Geçerli bir hedef ağ seçilmedi. Seçmek için yönlendiriliyorsunuz"
	arr["ARABIC",125]="لم يتم تحديد شبكة مستهدفة صالحة. ستتم إعادة توجيهك لتحديد واحدة"
	arr["CHINESE",125]="没有选择有效的目标网络。您需要选择一个"

	arr["ENGLISH",126]="You have a valid WPA, WPA2 or WPA2/WPA3 in \"Mixed mode\" target network selected. Script can continue..."
	arr["SPANISH",126]="Tienes una red objetivo WPA, WPA2 o WPA2/WPA3 en \"Mixed mode\" válida seleccionada. El script puede continuar..."
	arr["FRENCH",126]="Vous avez choisi une réseau valide WPA, WPA2 ou WPA2/WPA3 en \"Mixed mode\". Le script peut continuer..."
	arr["CATALAN",126]="Tens una xarxa objectiu WPA, WPA2 o WPA2/WPA3 en \"Mixed mode\" vàlida seleccionada. El script pot continuar..."
	arr["PORTUGUESE",126]="Você tem uma rede WPA, WPA2 ou WPA2/WPA3 em \"Mixed mode\" válida selecionada. O script pode continuar..."
	arr["RUSSIAN",126]="Вы выбрали подходящую целевую сеть WPA, WPA2 или WPA2/WPA3 в \"Mixed mode\". Скрипт может продолжить..."
	arr["GREEK",126]="Έχετε επιλέξει ένα έγκυρο δίκτυο-στόχος WPA, WPA2 ή WPA2/WPA3 σε \"Mixed mode\". Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",126]="Hai selezionato una rete WPA, WPA2 o WPA2/WPA3 in \"Mixed mode\" valida. Lo script può continuare..."
	arr["POLISH",126]="Wybrano prawidłową sieć docelową WPA, WPA2 lub WPA2/WPA3 w \"Mixed mode\". Skrypt może kontynuować..."
	arr["GERMAN",126]="Sie haben ein gültiges WPA, WPA2 oder WPA2/WPA3 im \"Mixed mode\"-Zielnetzwerk ausgewählt. Das Skript kann fortfahren..."
	arr["TURKISH",126]="Geçerli bir \"Mixed mode\" da WPA, WPA2 veya WPA2/WPA3 hedef ağı seçtiniz. Yazılım devam edebilir..."
	arr["ARABIC",126]="...يمكن أن يستمرالبرنامج .\"Mixed mode\" صالح فى WPA2/WPA3 أو WPA2 و WPA يوجد "
	arr["CHINESE",126]="您在“混合模式”目标中选择了有效的 WPA、WPA2 或 WPA2/WPA3 加密方式的无线网络。脚本可以继续..."

	arr["ENGLISH",127]="The natural order to proceed in this menu is usually: 1-Select wifi card 2-Put it in monitor mode 3-Select target network 4-Capture Handshake/PMKID"
	arr["SPANISH",127]="El orden natural para proceder en este menú suele ser: 1-Elige tarjeta wifi 2-Ponla en modo monitor 3-Elige red objetivo 4-Captura Handshake/PMKID"
	arr["FRENCH",127]="La marche à suivre est généralement: 1-Selectionner la carte wifi 2-Activer le mode moniteur 3-Choisir un réseau cible 4-Capturer le Handshake/PMKID"
	arr["CATALAN",127]="L'ordre natural per procedir a aquest menú sol ser: 1-Tria targeta wifi 2-Posa-la en mode monitor 3-Tria xarxa objectiu 4-Captura Handshake/PMKID"
	arr["PORTUGUESE",127]="A ordem normal para esse menu é: 1-Escolha de uma interface wifi 2-colocar interface wifi no modo monitor 3-Selecionar uma rede 4-Capturar o Handshake/PMKID"
	arr["RUSSIAN",127]="Обычный порядок работы в этом меню: 1-Выбрать wifi карту 2-Перевести её в режим монитора 3-Выбрать целевую сеть 4-Захватить рукопожатие/PMKID"
	arr["GREEK",127]="Η σειρά εντολών για να προχωρήσετε σε αυτό το μενού είναι συνήθως: 1-Επιλέξτε κάρτα wifi 2-Βάλτε την σε monitor mode 3-Επιλέξτε δίκτυο-στόχος 4-Καταγράψτε την Χειραψία/PMKID"
	arr["ITALIAN",127]="L'ordine naturale per procedere in questo menú di solito è: 1-Seleziona la scheda wifi 2-Mettila in modalità monitor 3-Seleziona rete obiettivo 4-Cattura Handshake/PMKID"
	arr["POLISH",127]="Naturalnym sposobem kontynuowania w tym menu jest zazwyczaj: 1-Wybierz kartę wifi 2-Włącz tryb monitorowania 3-Wybierz sieć docelową 4-Przechwyć Handshake/PMKID"
	arr["GERMAN",127]="Die natürliche Reihenfolge, um in diesem Menü fortzufahren, ist normalerweise: 1-Wählen Sie die WLAN-Karte 2-Setzen Sie sie in den monitor-Modus 3-Wählen Sie das Ziel-Netzwerk 4-Handshake/PMKID ergreifen"
	arr["TURKISH",127]="Normal olarak izlemeniz gereken yol: 1-Wifi kartı seç 2-İzleme modunu aç 3-Hedef ağ seç 4-Handshake yakala"
	arr["ARABIC",127]="Handshake/PMKID عادة ما يكون الترتيب الطبيعي للمتابعة في هذه القائمة هو: 1- حدد بطاقة  الويفي  2- تنشيط وضع المراقبة 3- اختيار شبكة مستهدفة 4- التقاط"
	arr["CHINESE",127]="在此菜单中进行的自然顺序通常是: 1-选择无线网络接口 2-将其置于监听模式 3-选择目标网络 4-捕获握手包/PMKID"

	arr["ENGLISH",128]="Select a wifi card to work in order to be able to do more actions than with an ethernet interface"
	arr["SPANISH",128]="Selecciona una interfaz wifi para poder realizar más acciones que con una interfaz ethernet"
	arr["FRENCH",128]="Veuillez sélectionner une carte wifi au lieu d'une carte ethernet afin d'être en mesure de réaliser plus d'actions"
	arr["CATALAN",128]="Seleccioneu una targeta wifi per treballar amb la finalitat de ser capaç de fer més accions que amb una interfície ethernet"
	arr["PORTUGUESE",128]="Selecione uma interface wifi para realizar mais ações do que com uma interface ethernet"
	arr["RUSSIAN",128]="Выберите wifi карту для работы, чтобы вы могли выполнить больше действий, чем с ethernet интерфейсом"
	arr["GREEK",128]="Επιλέξτε κάρτα wifi ώστε να μπορείτε να έχετε περισσοτερες επιλογές από μία διεπαφή ethernet"
	arr["ITALIAN",128]="Seleziona un'interfaccia wifi per poter eseguire più azioni che con un interfaccia ethernet"
	arr["POLISH",128]="Wybierz interfejs wifi, aby wykonać więcej czynności niż z interfejsem sieci ethernet"
	arr["GERMAN",128]="Wählen Sie ein WLAN-Interface, um mehr Aktionen als mit einer Ethernet-Schnittstelle auszuführen"
	arr["TURKISH",128]="Bir ethernet arabiriminden daha fazla işlem yapabilmek için çalışmak üzere bir wifi kartı seçin"
	arr["ARABIC",128]="حدد بطاقة wifi للعمل من أجل أن تكون قادرًا على القيام بإجراءات أكثر من استخدام واجهة ethernet"
	arr["CHINESE",128]="请选择要使用的 wifi 网卡，以便能够执行比使用有线网络 (以太网) 接口更多的操作"

	arr["ENGLISH",129]="The natural order to proceed in this menu is usually: 1-Select wifi card 2-Put it in monitor mode 3-Select target network 4-Start attack"
	arr["SPANISH",129]="El orden natural para proceder en este menú suele ser: 1-Elige tarjeta wifi 2-Ponla en modo monitor 3-Elige red objetivo 4-Comienza el ataque"
	arr["FRENCH",129]="La marche à suivre est généralement: 1-Selectionner la carte wifi 2-Activer le mode moniteur 3-Choisir un réseau cible 4-Capturer le Handshake"
	arr["CATALAN",129]="L'ordre natural per procedir a aquest menú sol ser: 1-Tria targeta wifi 2-Posa-la en mode monitor 3-Tria xarxa objectiu 4-Iniciar l'atac"
	arr["PORTUGUESE",129]="A ordem normal para esse menu é: 1-Escolha de uma interface wifi 2-colocar a interface wifi no modo monitor 3-Selecionar uma rede 4-Começar o ataque"
	arr["RUSSIAN",129]="Обычный порядок работы в этом меню: 1-Выберите wifi карту 2-Переведите её в режим монитора 3-Выберите целевую сеть 4-Запустите атаку"
	arr["GREEK",129]="Η διαδικασία για να προχωρήσετε σε αυτό το μενού είναι συνήθως: 1-Επιλέξτε κάρτα wifi 2-Βάλτε την σε κατάσταση παρακολούθησης 3-Επιλέξτε δίκτυο-στόχος 4-Ξεκινήστε την επίθεση"
	arr["ITALIAN",129]="L'ordine naturale per procedere in questo menú di solito è: 1-Seleziona la scheda wifi 2-Mettila in modalità monitor 3-Seleziona rete obiettivo 4-Inizia l'attacco"
	arr["POLISH",129]="Naturalnym sposobem działania w tym menu jest zazwyczaj: 1-Wybierz kartę wifi 2-Włącz tryb monitorowania 3-Wybierz sieć docelową 4-Rozpocznij ataku"
	arr["GERMAN",129]="Um in diesem Menü fortzufahren machen Sie folgendes: 1-Wählen Sie die WLAN-Karte 2-Stellen Sie sie im Monitur-modus ein 3-Wählen Sie das Zielnetzwerk 4-Starten Sie den Angriff"
	arr["TURKISH",129]="Bu menüde devam etmek için genellikle şu yol izlenir: 1-Wifi kartı seçmi 2-İzleme modunu açma 3-Hedef ağ seçme 4-Saldırıya başlama"
	arr["ARABIC",129]="عادة ما يكون الترتيب الطبيعي للمتابعة في هذه القائمة هو: 1- حدد بطاقة الويفي  2- تنشيط وضع المراقبة 3- اختيار شبكة مستهدفة 4- بدء الهجوم"
	arr["CHINESE",129]="在此菜单中进行的攻击准备顺序通常是: 1-选择 wifi 网卡 2-将其置于监控模式 3-选择目标网络 4-进入本菜单开始攻击"

	arr["ENGLISH",130]="Remember to select a target network with clients to capture Handshake"
	arr["SPANISH",130]="Recuerda seleccionar una red objetivo con clientes para capturar el Handshake"
	arr["FRENCH",130]="Rappelez-vous de sélectionner un réseau cible avec un/des client(s) connecté(s) pour pouvoir capturer un Handshake"
	arr["CATALAN",130]="Recorda que has de seleccionar una xarxa objectiu amb clients per capturar el Handshake"
	arr["PORTUGUESE",130]="Lembre-se de selecionar uma rede com clientes para capturar o Handshake"
	arr["RUSSIAN",130]="Не забудьте выбрать целевую сеть с клиентами для захвата рукопожатия"
	arr["GREEK",130]="Θυμηθείτε να επιλέξετε ένα δίκτυο-στόχος με έναν ή παραπάνω χρήστες για να καταγράψετε μία Χειραψία"
	arr["ITALIAN",130]="Ricorda di selezionare una rete di destinazione con clienti per poter catturare l'Handshake"
	arr["POLISH",130]="W celu przechwycenia Handshake, pamiętaj aby wybrać sieć docelową z klientami"
	arr["GERMAN",130]="Denken Sie daran, ein Zielnetzwerk mit Clients auszuwählen, um den Handshake zu erfassen"
	arr["TURKISH",130]="Handshake'i yakalamak için istemcilerle bir hedef ağ seçmeyi unutmayın"
	arr["ARABIC",130]="Handshake تذكر تحديد شبكة مستهدفة مع الزبناء لالتقاط"
	arr["CHINESE",130]="记得选择一个有客户端连接的无线网络来捕获握手包"

	arr["ENGLISH",131]="Not all attacks affect all access points. If an attack is not working against an access point, choose another one :)"
	arr["SPANISH",131]="No todos los ataques afectan a todos los puntos de acceso. Si un ataque no funciona contra un punto de acceso, elige otro :)"
	arr["FRENCH",131]="Toutes les attaques n'affectent pas les points d'accès de la même manière. Si une attaque ne donne pas de résultats, choisissez en une autre :)"
	arr["CATALAN",131]="No tots els atacs afecten tots els punts d'accés. Si un atac no està treballant cap a un punt d'accés, tria un altre :)"
	arr["PORTUGUESE",131]="Nem todos os ataques funcionam em todas as redes. Se um ataque não funcionar contra uma rede, escolha outro :)"
	arr["RUSSIAN",131]="Не все атаки справляются со всеми точками доступа. Если атака не работает в отношении точки доступа, выберите другую :)"
	arr["GREEK",131]="Δεν είναι όλες οι επιθέσεις αποτελεσματικές σε όλα τα σημεία πρόσβασης. Αν μια επίθεση δεν δουλεύει ενάντια σε ένα σημείο πρόσβασης, διαλέξτε κάποια άλλη :)"
	arr["ITALIAN",131]="Non tutti gli attacchi funzionano su tutti gli access point. Se un attacco non funziona contro un access point, selezionane un altro :)"
	arr["POLISH",131]="Nie wszystkie ataki działają na wszystkie punkty dostępu. Jeśli atak nie działa przeciwko któremuś punktowi dostępowemu, wybierz inny :)"
	arr["GERMAN",131]="Nicht alle Angriffe betreffen alle Access Points. Wenn ein Angriff gegen einen Access Point nicht funktioniert, wählen Sie einen anderen :)"
	arr["TURKISH",131]="Tüm saldırılar tüm erişim noktalarını etkilemez. Bir saldırı bir erişim noktasına karşı çalışmıyorsa, başka birini seçin :)"
	arr["ARABIC",131]="(: لا تؤثر جميع الهجمات على جميع نقاط الوصول. إذا كان الهجوم لا يعمل ضد نقطة وصول ، فاختر نقطة أخرى"
	arr["CHINESE",131]="有的攻击方式可能对部分 AP 不起作用。如果效果未达预期，请选择另一个 :)"

	arr["ENGLISH",132]="Cleaning a Handshake file is recommended only for big size files. It's better to have a backup, sometimes file can be corrupted while cleaning it"
	arr["SPANISH",132]="Limpiar un fichero de Handshake se recomienda solo para ficheros grandes. Es mejor hacer una copia de seguridad antes, a veces el fichero se puede corromper al limpiarlo"
	arr["FRENCH",132]="Épurer le fichier contenant le Handshake est seulement recommandable si le fichier est volumineux. Si vous décidez d'épurer le fichier il est conseillé de faire une copie de sauvegarde du fichier originel, l'opération de nettoyage comporte des risques et peut le rendre illisible"
	arr["CATALAN",132]="Netejar un fitxer de Handshake es recomana només per a fitxers grans. És millor fer una còpia de seguretat abans, de vegades el fitxer es pot corrompre al netejar-lo"
	arr["PORTUGUESE",132]="Limpar um Handshake é recomendado apenas para arquivos grandes. É melhor fazer um backup antes, porque as vezes o arquivo pode corromper ao limpar"
	arr["RUSSIAN",132]="Очистка файла рукопожатия рекомендована только для файлов больших размеров. Лучше иметь резервную копию, иногда во время очистки файл может быть повреждён"
	arr["GREEK",132]="Ο καθαρισμός ενός αρχείου Χειραψίας συνιστάται μόνο για μεγάλου μεγέθους αρχεία. Καλύτερα κρατήστε ένα backup, μερικές φορές το αρχείο μπορεί να καταστραφεί κατά τη διάρκεια του καθαρισμού"
	arr["ITALIAN",132]="Pulire un file di Handshake è consigliato solo per file di grandi dimensioni. Meglio fare un backup prima, a volte il file si può corrompere con la pulizia"
	arr["POLISH",132]="Usunięcie pliku Handshake jest zalecane tylko w przypadku dużych plików. Lepiej jest zachować kopie zapasowe, czasami plik może być uszkodzony podczas czyszczenia"
	arr["GERMAN",132]="Das Bereinigen einer Handshake-Datei wird nur für große Dateien empfohlen. Es ist besser, vorher ein Backup zu erstellen, manchmal kann die Datei beim Säubern beschädigt werden"
	arr["TURKISH",132]="Bir Handshake dosyasının temizlenmesi yalnızca büyük boyutlu dosyalar için önerilir. Bir yedeğin olması daha iyidir, bazen dosya temizlenirken bozulabilir"
	arr["ARABIC",132]="فقط للملفات كبيرة الحجم. من الأفضل أن يكون لديك نسخة احتياطية ، في بعض الأحيان يمكن أن يتلف الملف أثناء تنظيفه Handshake يوصى بتنظيف ملف"
	arr["CHINESE",132]="建议仅清理较大的握手包文件。而且最好有一个备份，有时文件可能会在清理时损坏"

	arr["ENGLISH",133]="If you select a target network with hidden ESSID, you can't use it, but you can perform BSSID based attacks to that network"
	arr["SPANISH",133]="Si seleccionas una red objetivo con el ESSID oculto, no podrás usarlo, pero puedes hacer ataques basados en BSSID sobre esa red"
	arr["FRENCH",133]="Si vous sélectionnez un réseau cible avec un ESSID caché, vous n'allez pas pouvoir utiliser l'ESSID pour attaquer, mais vous pourrez effectuer les attaques basées sur le BSSID du réseau"
	arr["CATALAN",133]="Si selecciones una xarxa objectiu amb el ESSID ocult, no podràs usar-lo, però pots fer atacs basats en BSSID sobre aquesta xarxa"
	arr["PORTUGUESE",133]="Se você selecionar uma rede com ESSID oculto você não poderá usá-la, mas você poderá fazer ataques com base no BSSID"
	arr["RUSSIAN",133]="Если вы выбрали целевую сеть со скрытым ESSID, вы не сможете использовать её, но вы можете выполнить атаку на эту сеть на основе BSSID"
	arr["GREEK",133]="Αν επιλέξετε ένα δίκτυο-στόχος με κρυφό ESSID, δεν μπορείτε να το χρησιμοποιήσετε, αλλά μπορείτε να εκτελέσετε επιθέσεις BSSID σε αυτό το δίκτυο"
	arr["ITALIAN",133]="Se si seleziona una rete obiettivo con ESSID nascosto, non potrai utilizzarla, peró puoi fare attacchi a questa rete basati sul BSSID"
	arr["POLISH",133]="Jeśli wybierzesz sieć docelową z ukrytym identyfikatorem ESSID, nie będziesz w stanie jej używać, ale możesz atakować tą sieć w oparciu o BSSID"
	arr["GERMAN",133]="Wenn Sie ein Zielnetzwerk mit ausgeblendeter ESSID auswählen, können Sie es nicht verwenden, Sie können jedoch BSSID-basierte Angriffe auf dieses Netzwerk durchführen"
	arr["TURKISH",133]="Gizli ESSID ile bir hedef ağ seçerseniz, bunu kullanamazsınız, ancak bu ağa BSSID tabanlı saldırılar gerçekleştirebilirsiniz"
	arr["ARABIC",133]="على تلك الشبكة BSSID فلا يمكنك استخدامها ، ولكن يمكنك تنفيذ هجمات تستند على ESSID إذا قمت بتحديد شبكة مستهدفة باستخدام"
	arr["CHINESE",133]="如果你选择一个隐藏了 ESSID 的目标网络，你将无法使用它，但你可以对该网络执行基于 BSSID 的攻击"

	arr["ENGLISH",134]="If your Linux is a virtual machine, it is normal that the integrated wifi cards are detected as ethernet. You will need an external usb wifi card. More info at this link: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["SPANISH",134]="Si tu Linux es una máquina virtual, es normal que las tarjetas wifi integradas sean detectadas como ethernet. Necesitarás una tarjeta wifi externa usb. Más info en este enlace: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["FRENCH",134]="Si votre Linux est une machine virtuelle, il est normal que les cartes wifi intégrées soient détectées comme Ethernet. Vous aurez besoin d'une carte wifi USB externe. Plus d'informations sur ce lien: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["CATALAN",134]="Si el teu Linux és una màquina virtual, és normal que les targetes wifi integrades siguin detectades com a ethernet. Necessitaràs una targeta wifi externa usb. Més info en aquest enllaç: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["PORTUGUESE",134]="Se o seu Linux for uma máquina virtual é normal que as placas wifi integradas sejam detectadas como Ethernet. Você precisará de uma placa wifi USB externa. Mais informações neste link: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["RUSSIAN",134]="Если вы используете Linux в виртуальной машине, встроенные Wi-Fi модули могут определяться как Ethernet. Вам понадобится внешний USB Wi-Fi адаптер. Дополнительная информация по этой ссылке: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["GREEK",134]="Εάν το Linux σας είναι virtual machine, είναι φυσιολογικό οι ενσωματωμένες κάρτες wifi να ανιχνεύονται ως ethernet. Θα χρειαστείτε μια εξωτερική κάρτα wifi usb. Περισσότερες πληροφορίες σε αυτόν τον σύνδεσμο: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["ITALIAN",134]="Se il tuo Linux è una macchina virtuale, è normale che le schede wifi integrate vengano rilevate come ethernet. Avrai bisogno di una scheda wifi USB esterna. Maggiori informazioni in questo link: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["POLISH",134]="Jeśli Twój Linux uruchomiony jako maszyna wirtualna, normalne jest, że zintegrowane (wewnętrzne) karty Wi-Fi będą wykrywane jako karty Ethernet. Potrzebujesz zewnętrznej karty Wi-Fi USB. Więcej informacji pod tym linkiem: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["GERMAN",134]="Wenn Ihr Linux eine virtuelle Maschine ist, ist es normal, dass die integrierten WLAN-Karten als Ethernet erkannt werden. Sie benötigen eine externe USB-WLAN-Karte. Weitere Informationen unter diesem Link: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["TURKISH",134]="Eğer Linux'unuz sanal makine ise entegre wifi kartlarının ethernet olarak algılanması normaldir. Harici bir usb wifi kartına ihtiyacınız olacak. Daha fazla bilgiyi bu bağlantıda bulabilirsiniz: \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"
	arr["ARABIC",134]=" \${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine \${pink_color}:خارجيه. للمزيد من المعلومات Wifi سوف تحتاج إلى بطاقة .ethernet علي انها Wifi الخاص بك افتراضي, فمن الطبيعي ان يتم اكتشاف بطاقة ال Linux إذا كان نظام ال\${normal_color}"
	arr["CHINESE",134]="如果你的Linux发行版正运行在虚拟化环境，则物理机的无线 wifi 网卡被检测为以太网卡是正常的。此时您可能需要一个外部 USB 无线网卡。更多信息请访问此链接：\${normal_color}\${urlgithub_wiki}/FAQ%20&%20Troubleshooting#why-is-my-integrated-wifi-card-detected-as-an-ethernet-interface-in-a-virtual-machine"

	arr["ENGLISH",135]="Type of encryption: \${pink_color}\${enc}\${normal_color}"
	arr["SPANISH",135]="Tipo de encriptado: \${pink_color}\${enc}\${normal_color}"
	arr["FRENCH",135]="Type de chiffrement: \${pink_color}\${enc}\${normal_color}"
	arr["CATALAN",135]="Tipus d'encriptat: \${pink_color}\${enc}\${normal_color}"
	arr["PORTUGUESE",135]="Tipo de criptografia: \${pink_color}\${enc}\${normal_color}"
	arr["RUSSIAN",135]="Тип шифрования: \${pink_color}\${enc}\${normal_color}"
	arr["GREEK",135]="Τύπος κρυπτογράφησης: \${pink_color}\${enc}\${normal_color}"
	arr["ITALIAN",135]="Tipo di crittografia: \${pink_color}\${enc}\${normal_color}"
	arr["POLISH",135]="Typ szyfrowania: \${pink_color}\${enc}\${normal_color}"
	arr["GERMAN",135]="Verschlüsselungsart: \${pink_color}\${enc}\${normal_color}"
	arr["TURKISH",135]="Şifreleme tipi: \${pink_color}\${enc}\${normal_color}"
	arr["ARABIC",135]="\${pink_color}\${enc}\${blue_color} :نوع التشفير\${normal_color}"
	arr["CHINESE",135]="加密类型: \${pink_color}\${enc}\${normal_color}"

	arr["ENGLISH",136]="Only some networks are vulnerable to PMKID capturing. For this they must have activated roaming features like 802.11r"
	arr["SPANISH",136]="Solo algunas redes son vulnerables a la captura de un paquete que contenga un PMKID. Para ello han de tener activadas características de roaming como el 802.11r"
	arr["FRENCH",136]="Seulement certains réseaux sont vulnérables à la capture d'un paquet contenant un PMKID. Pour ce faire, ils doivent avoir activé l'itinérance des fonctionnalités telles que 802.11r"
	arr["CATALAN",136]="Només algunes xarxes són vulnerables a la captura d'un paquet que contingui un PMKID. Per això han de tenir activades característiques de roaming com el 802.11r"
	arr["PORTUGUESE",136]="Apenas algumas redes são vulneráveis a captura de um pacote contendo um PMKID. Para isso o recurso de roaming deve estar ativado, como 802.11r"
	arr["RUSSIAN",136]="Только некоторые сети уязвимы для захвата пакета, содержащего PMKID. Для этой уязвимости в них должны быть активированы функции роуминга, такая как 802.11r"
	arr["GREEK",136]="Μόνο ορισμένα δίκτυα είναι ευάλωτα στη σύλληψη ενός πακέτου που περιέχει PMKID. Για να γίνει αυτό θα πρέπει να έχετε ενεργοποιήσει τα features περιαγωγής όπως 802.11r"
	arr["ITALIAN",136]="Solo alcune reti sono vulnerabili alla cattura di un pacchetto contenente un PMKID. Per fare questo devono aver attivato features di roaming come 802.11r"
	arr["POLISH",136]="Tylko niektóre sieci są podatne na przechwytywanie pakietu z PMKID. W tym celu muszą one aktywowane funkcje roamingu takie jak 802.11r"
	arr["GERMAN",136]="Nur einige Netzwerke sind für PMKID capture anfällig. Diese müssen Roaming-Features wie 802.11r aktiviert haben"
	arr["TURKISH",136]="Sadece bazı ağlar bir PMKID içeren bir paket yakalamak için savunmasız. 802.11r özellikleri roaming için etkinleştirilmiş olmalı"
	arr["ARABIC",136]="802.11r لهذا يجب أن يكونوا قد قاموا بتنشيط ميزات التجوال مثل .PMKID بعض الشبكات فقط هي عرضة لالتقاط"
	arr["CHINESE",136]="只有一些网络容易捕获到 PMKID。前提是它们已经激活了 802.11r 等漫游功能"

	arr["ENGLISH",137]="The selected network is invalid. To get a Handshake, encryption type of target network should be WPA, WPA2 or WPA2/WPA3 in \"Mixed mode\""
	arr["SPANISH",137]="La red seleccionada no es válida. Para obtener un Handshake, el tipo de encriptación de la red objetivo debe ser WPA, WPA2 o WPA2/WPA3 en \"Mixed mode\""
	arr["FRENCH",137]="Le réseau sélectionné est invalide. Pour obtenir un Handshake, le réseau cible doit être WPA, WPA2 ou WPA2/WPA3 en \"Mixed mode\""
	arr["CATALAN",137]="La xarxa seleccionada no és vàlida. Per obtenir un Handshake, el tipus d'encriptació de la xarxa objectiu ha de ser WPA, WPA2 o WPA2/WPA3 en \"Mixed mode\""
	arr["PORTUGUESE",137]="A rede selecionada é inválida. Para obter um Handshake, o tipo de criptografia da rede deve ser WPA, WPA2 ou WPA2/WPA3 em \"Mixed mode\""
	arr["RUSSIAN",137]="Выбранная сеть не подходит. Для получения хендшейка, тип шифрования должен WPA, WPA2 или WPA2/WPA3 в \"Mixed mode\""
	arr["GREEK",137]="Το επιλεγμένο δίκτυο είναι μη έγκυρο. Για να αποκτήσετε μία Χειραψία, ο τύπος κρυπτογράφησης του δικτύου-στόχου πρέπει να έιναι WPA, WPA2 ή WPA2/WPA3 σε \"Mixed mode\""
	arr["ITALIAN",137]="La rete selezionata non è valida. Per ottenere un Handshake, il tipo di crittografia della rete obiettivo deve essere WPA, WPA2 o WPA2/WPA3 in \"Mixed mode\""
	arr["POLISH",137]="Wybrana sieć jest nieprawidłowa. Aby przechwycić Handshake, typem szyfrowania sieci docelowej musi być WPA, WPA2 lub WPA2/WPA3 w \"Mixed mode\""
	arr["GERMAN",137]="Das ausgewählte Netzwerk ist nicht gültig. Um einen Handshake zu erhalten, muss die Verschlüsselungsart des Zielnetzwerks WPA, WPA2 oder WPA2/WPA3 im \"Mixed mode\" sein"
	arr["TURKISH",137]="Seçilen ağ geçersiz. Bir Handshake almak için, şifreleme türünün hedef ağ \"Mixed mode\" da  WPA, WPA2 veya WPA2/WPA3 olmalıdır"
	arr["ARABIC",137]="\"Mixed mode\" في WPA2/WPA3 أو WPA2 و WPA الشبكة المحددة غير صالحة. للحصول على المصافحة ، يجب أن يكون نوع التشفير للشبكة المستهدفة هو"
	arr["CHINESE",137]="所选网络无效。要捕获握手包，目标无线网络的加密类型应 WPA、WPA2 或“混合模式”下的 WPA2/WPA3"

	arr["ENGLISH",138]="Attack for Handshake"
	arr["SPANISH",138]="Ataque para Handshake"
	arr["FRENCH",138]="Attaque pour obtenir un Handshake"
	arr["CATALAN",138]="Atac de Handshake"
	arr["PORTUGUESE",138]="Ataque para obter um Handshake"
	arr["RUSSIAN",138]="Атаковать для рукопожатия"
	arr["GREEK",138]="Επίθεση για Χειραψία"
	arr["ITALIAN",138]="Attacco per Handshake"
	arr["POLISH",138]="Atak na Handshake"
	arr["GERMAN",138]="Handshake-Angriff"
	arr["TURKISH",138]="Saldırı için Handshake"
	arr["ARABIC",138]="Handshake هجوم للحصول على"
	arr["CHINESE",138]="握手包攻击"

	arr["ENGLISH",139]="1.  Deauth / disassoc amok \${mdk_command} attack"
	arr["SPANISH",139]="1.  Ataque Deauth / Disassoc amok \${mdk_command}"
	arr["FRENCH",139]="1.  Attaque Deauth / Disassoc amok \${mdk_command}"
	arr["CATALAN",139]="1.  Atac Deauth / Disassoc amok \${mdk_command}"
	arr["PORTUGUESE",139]="1.  Ataque Deauth / Disassoc amok \${mdk_command}"
	arr["RUSSIAN",139]="1.  Атака деаутентификации / разъединения amok \${mdk_command}"
	arr["GREEK",139]="1.  Επίθεση Deauth / disassoc amok \${mdk_command}"
	arr["ITALIAN",139]="1.  Attacco Deauth / Disassoc amok \${mdk_command}"
	arr["POLISH",139]="1.  Atak Deauth / Disassoc amok \${mdk_command}"
	arr["GERMAN",139]="1.  Deauth / Disassoc Amok \${mdk_command} Angriff"
	arr["TURKISH",139]="1.  Deauth / disassoc amok \${mdk_command} saldırısı"
	arr["ARABIC",139]="1.  Deauth / disassoc amok \${mdk_command} هجوم"
	arr["CHINESE",139]="1.  Deauth / disassoc amok \${mdk_command} 攻击"

	arr["ENGLISH",140]="2.  Deauth aireplay attack"
	arr["SPANISH",140]="2.  Ataque Deauth aireplay"
	arr["FRENCH",140]="2.  Attaque Deauth aireplay"
	arr["CATALAN",140]="2.  Atac Deauth aireplay"
	arr["PORTUGUESE",140]="2.  Ataque Deauth aireplay"
	arr["RUSSIAN",140]="2.  Атака деаутентификации aireplay"
	arr["GREEK",140]="2.  Επίθεση Deauth aireplay"
	arr["ITALIAN",140]="2.  Attacco Deauth aireplay"
	arr["POLISH",140]="2.  Atak Deauth aireplay"
	arr["GERMAN",140]="2.  Deauth aireplay Angriff"
	arr["TURKISH",140]="2.  Deauth aireplay saldırısı"
	arr["ARABIC",140]="2.  DeAuth aireplay هجوم"
	arr["CHINESE",140]="2.  Deauth aireplay 攻击"

	arr["ENGLISH",141]="3.  Auth DoS attack"
	arr["SPANISH",141]="3.  Ataque Auth DoS"
	arr["FRENCH",141]="3.  Attaque Auth DoS"
	arr["CATALAN",141]="3.  Atac Auth Dos"
	arr["PORTUGUESE",141]="3.  Ataque Auth DoS"
	arr["RUSSIAN",141]="3.  DoS атака деаутентификации"
	arr["GREEK",141]="3.  Επίθεση Auth DoS"
	arr["ITALIAN",141]="3.  Attacco Auth DoS"
	arr["POLISH",141]="3.  Atak Auth DoS"
	arr["GERMAN",141]="3.  Auth DoS Angriff"
	arr["TURKISH",141]="3.  Auth DoS saldırısı"
	arr["ARABIC",141]="3.  Auth DoS هجوم"
	arr["CHINESE",141]="3.  身份验证 DoS 攻击 (Auth DoS)"

	arr["ENGLISH",142]="If the Handshake doesn't appear after an attack, try again or change the type of attack"
	arr["SPANISH",142]="Si tras un ataque el Handshake no aparece, vuelve a intentarlo o cambia de ataque hasta conseguirlo"
	arr["FRENCH",142]="Si vous n'obtenez pas le Handshake après une attaque, veuillez recommencer ou bien changer d'attaque jusqu'à son obtention"
	arr["CATALAN",142]="Si després d'un atac el Handshake no apareix, torna a intentar-ho o canvia d'atac fins aconseguir-ho"
	arr["PORTUGUESE",142]="Se o Handshake não aparecer após um ataque, tente novamente ou tente alterar o tipo de ataque"
	arr["RUSSIAN",142]="Если рукопожатие не появилось после атаки, попробуйте снова или измените тип атаки"
	arr["GREEK",142]="Αν η Χειραψία δεν εμφανιστεί μετά από την επίθεση, προσπαθήστε ξανά ή αλλάξτε τύπο επίθεσης"
	arr["ITALIAN",142]="Se dopo un attacco non compare l'Handshake, prova di nuovo o cambia attacco fino ad ottenerlo"
	arr["POLISH",142]="Jeśli po ataku nie pojawi się Handshake, spróbuj ponownie lub zmień atak"
	arr["GERMAN",142]="Wenn nach einem Angriff der Handshake nicht erscheint, versuchen Sie es erneut oder ändern Sie den Angriff, bis Sie ihn erhalten"
	arr["TURKISH",142]="Eğer handshake başarısız olduysa, başka bir saldırı yöntemi deneyin"
	arr["ARABIC",142]="بعد هجوم ، فحاول مرة أخرى أو قم بتغيير نوع الهجوم Handshake إذا لم يظهر"
	arr["CHINESE",142]="如果攻击无线网络中的客户端后没有捕获到握手包，请重试或更改攻击类型"

	arr["ENGLISH",143]="Two windows will be opened. One with the Handshake capturer and other with the attack to force clients to reconnect"
	arr["SPANISH",143]="Se abrirán dos ventanas. Una con el capturador del Handshake y otra con el ataque para expulsar a los clientes y forzarles a reconectar"
	arr["FRENCH",143]="Deux fenêtres vont s'ouvrir: La première pour capturer le handshake et la deuxième pour effectuer l'attaque visant à expulser les clients du réseau et les forcer à renégocier un Handshake pour se reconnecter"
	arr["CATALAN",143]="S'obriran dues finestres. Una amb el capturador de Handshake i una altra amb l'atac per expulsar als clients i forçar-los a reconnectar"
	arr["PORTUGUESE",143]="Duas janelas serão abertas. Uma para captura do Handshake e outra com o ataque para forçar os clientes a se reconectarem"
	arr["RUSSIAN",143]="Будут открыты два окна. Одно с захватчиком рукопожатия, а другое с атакой для принудительного переподключения клиентов"
	arr["GREEK",143]="Θα ανοίξουν δύο παράθυρα. Ένα με τον καταγραφέα Χειραψίας, και ένα με την επίθεση εξαναγκασμένης επανασύνδεσης των χρηστών"
	arr["ITALIAN",143]="Si apriranno due finestre. Una con il catturatore dell'Handshake, l'altra con l'attacco per cacciare i clienti e costringerli a riconnettersi"
	arr["POLISH",143]="Otworzą się dwa okna. Jedna z przechwytywaczem Handshake, a druga z atakiem, zmuszającym klientów ich do ponownego połączenia"
	arr["GERMAN",143]="Zwei Fenster werden sich öffnen. Eine mit dem Handshake-Grabber und eine mit dem Angriff, der die Kunden zwingt, sich wieder zu verbinden"
	arr["TURKISH",143]="Eğer Handshake bir saldırıdan sonra görünmezse, tekrar deneyin veya saldırı türünü değiştirin"
	arr["ARABIC",143]="والأخرى مع الهجوم لإجبار العملاء على إعادة الاتصال Handshake سيتم فتح نافذتين. واحدة مع آسر"
	arr["CHINESE",143]="脚本将打开两个窗口。一个用于捕获握手包，另一个攻击无线网络中的客户端迫使其重新连接以便于脚本捕获握手包"

	arr["ENGLISH",144]="Don't close any window manually, script will do when needed. In about \${timeout} seconds maximum you'll know if you've got the Handshake"
	arr["SPANISH",144]="No cierres manualmente ninguna ventana, el script lo hará cuando proceda. En unos \${timeout} segundos como máximo sabrás si conseguiste el Handshake"
	arr["FRENCH",144]="Ne pas fermer une des fenêtres manuellement: Le script va le faire automatiquement si besoin est. Vous saurez dans tout au plus \${timeout} secondes si vous avez obtenu le Handshake"
	arr["CATALAN",144]="No tanquis manualment cap finestra, el script ho farà quan escaigui. En uns \${timeout} segons com a màxim sabràs si vas aconseguir el Handshake"
	arr["PORTUGUESE",144]="Não feche nenhuma janela manualmente, o script fechará quando necessário. Em cerca de \${timeout} segundos no máximo você vai saber se tem o Handshake"
	arr["RUSSIAN",144]="Не закрывайте вручную какое-либо окно, скрипт сделает это когда нужно. Примерно в максимум \${timeout} секунд вы узнаете, получили ли вы рукопожатие"
	arr["GREEK",144]="Μην επιχειρήσετε το κλείσιμο κάποιου παραθύρου χειροκίνητα, εάν χρειαστεί το script θα το κάνει μόνο του. Σε περίπου \${timeout} δευτερόλεπτα το μέγιστο θα μάθετε αν αποκτήσατε την Χειραψία"
	arr["ITALIAN",144]="Non chiudere nessuna finestra manualmente, lo script lo fará quando necessario. In \${timeout} secondi al massimo scoprirai se hai catturato l'Handshake"
	arr["POLISH",144]="Nie należy ręcznie zamykać okien, skrypt to zrobi w razie potrzeby. W ciągu co najwyżej \${timeout} sekund dowiesz się, czy masz Handshake"
	arr["GERMAN",144]="Schließen Sie kein Fenster manuell, das Skript wird dies bei Bedarf tun. In ungefähr \${timeout} Sekunden werden Sie wissen, ob Sie den Handshake bekommen haben"
	arr["TURKISH",144]="Herhangi bir pencereyi elle kapatmayın, yazılım gerektiğinde yapacaktır. Yaklaşık \${timeout} saniye içinde, Handshake'e sahip olup olmadığınızı bileceksiniz"
	arr["ARABIC",144]="Handshake ثانية كحد أقصى ستعرف ما إذا كنت قد حصلت على \${timeout} لا تغلق أي نافذة يدويًا ، فسيقوم البرنامج بذلك عند الحاجة. في غضون"
	arr["CHINESE",144]="请不要手动关闭任何窗口，脚本会在需要时自动关闭。在大约 \${timeout} 秒内，您将知道是否已经捕获握手包"

	arr["ENGLISH",145]="\${blue_color}Your wifi card supports the 5Ghz band but your \"wash\" version included in reaver package (v\${reaver_version}) is not able to scan both bands at once. To use dual-band scan feature you must have at least version v\${minimum_wash_dualscan_version} so you have to make a choice. \${green_color}Do you want to scan the 5Ghz band? \${pink_color}(If you answer no (\"n\"), 2.4Ghz band will be scanned) \${normal_color}\${visual_choice}"
	arr["SPANISH",145]="\${blue_color}Tu tarjeta wifi soporta la banda de los 5Ghz pero tu versión de \"wash\" incluido en el paquete reaver (v\${reaver_version}) no es capaz de escanear ambas bandas a la vez. Para utilizar el escaneo dual debes tener al menos la versión v\${minimum_wash_dualscan_version} por lo que has de elegir. \${green_color}¿Deseas escanear en la banda de los 5Ghz? \${pink_color}(Si respondes que no (\"n\"), se escaneará la banda de 2.4Ghz) \${normal_color}\${visual_choice}"
	arr["FRENCH",145]="\${blue_color}Votre carte wifi supporte la bande 5Ghz mais votre version du \"wash\" incluse dans le paquet reaver (v\${reaver_version}) n'est pas capable de balayer les deux bandes en même temps. Pour utiliser l'analyse dual, vous devez avoir au moins la version v\${minimum_wash_dualscan_version} vous devez donc choisir. \${green_color}Voulez-vous scanner dans la bande 5Ghz? \${pink_color}(Si vous répondez non (\"n\"), la bande 2.4Ghz sera analysée) \${normal_color}\${visual_choice}"
	arr["CATALAN",145]="\${blue_color}La teva targeta wifi suporta la banda dels 5Ghz però la teva versió del \"wash\" inclòs en el paquet reaver (v\${reaver_version}) no és capaç d'escanejar les dues bandes alhora. Per utilitzar l'escaneig dual has de tenir almenys la versió v\${minimum_wash_dualscan_version} pel que has de triar. \${green_color}¿Voleu escanejar a la banda dels 5Ghz? \${pink_color}(Si respons que no (\"n\"), es escanejarà la banda de 2.4Ghz) \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",145]="\${blue_color}A sua interface wifi suporta a banda 5Ghz, mas a sua versão do \"wash\" incluída no pacote reaver (v\${reaver_version}) não é capaz de escanear ambas as bandas ao mesmo tempo. Para usar a varredura dupla, você deve ter pelo menos a versão v\${minimum_wash_dualscan_version}. Você deve escolher. \${green_color}Deseja escanear a banda 5Ghz? \${pink_color}(Se você responder não (\"n\"), somente banda 2.4Ghz será digitalizada) \${normal_color}\${visual_choice}"
	arr["RUSSIAN",145]="\${blue_color}Ваша карта wifi поддерживает диапазон 5Ghz, но ваша версия \"wash\", включенная в пакет reaver (v\${reaver_version}), не может одновременно сканировать обе полосы. Чтобы использовать двойное сканирование, вы должны иметь хотя бы версию v\${minimum_wash_dualscan_version}, поэтому вам нужно выбрать только одну из частот. \${green_color}Вы хотите сканировать частоты 5Ghz? \${pink_color}(Если вы ответите нет (\"n\"), будут просканированы частоты 2.4Ghz) \${normal_color}\${visual_choice}"
	arr["GREEK",145]="\${blue_color}Η κάρτα wifi σας υποστηρίζει την 5Ghz ζώνη, αλλά η έκδοση του \"wash\" που περιλαμβάνεται στο πακέτο του reaver (v\${reaver_version}) δεν είναι σε θέση να σαρώσει ταυτόχρονα και τις δύο ζώνες (dual band). Για να χρησιμοποιήσετε την σάρωση για dual band, πρέπει να έχετε τουλάχιστον την έκδοση v\${minimum_wash_dualscan_version} για να μπορέσετε να συνεχίσετε. \${green_color}Θέλετε να σαρώσετε στην 5Ghz ζώνη; \${pink_color}(Εάν απαντήσετε όχι (\"n\"), η 2.4Ghz ζώνη θα σαρωθεί) \${normal_color}\${visual_choice}"
	arr["ITALIAN",145]="\${blue_color}La tua scheda wifi supporta la banda 5Ghz ma la tua versione di \"wash\" inclusa nel pacchetto reaver (v\${reaver_version}) non è in grado di scansionare entrambe le bande contemporaneamente. Per usare la doppia scansione devi avere almeno la versione v\${minimum_wash_dualscan_version}, quindi devi sceglierne una. \${green_color}Vuoi eseguire la scansione nella banda 5Ghz? \${pink_color}(Se rispondi no (\"n\"), verrà scansionata la banda 2.4Ghz) \${normal_color}\${visual_choice}"
	arr["POLISH",145]="\${blue_color}Twoja karta wifi obsługuje pasmo 5Ghz, ale twoja wersja \"wash\" zawarta w pakiecie reaver (v\${reaver_version}) nie jest w stanie skanować obu pasm w tym samym czasie. Aby użyć podwójnego skanowania, musisz mieć przynajmniej wersję v\${minimum_wash_dualscan_version}. \${green_color}Musisz wybrać: czy chcesz skanować w paśmie 5Ghz? \${pink_color}(Jeśli odpowiesz nie (\"n\"), zostanie zeskanowane pasmo 2.4Ghz) \${normal_color}\${visual_choice}"
	arr["GERMAN",145]="\${blue_color}Ihre WLAN-Karte unterstützt das 5Ghz-Band, aber Ihre im reaver-Paket enthaltene Version von \"wash\" (v\${reaver_version}) kann nicht beide Bänder gleichzeitig scannen. Um den dualen Scan zu verwenden, müssen Sie mindestens Version v\${minimum_wash_dualscan_version} haben, also müssen Sie wählen. \${green_color}Möchten Sie im 5Ghz-Band scannen? \${pink_color}(Wenn Sie nein (\"n\" antworten), wird das 2.4Ghz-Band gescannt) \${normal_color}\${visual_choice}"
	arr["TURKISH",145]="\${blue_color}Wifi kartınız 5Ghz destekliyor fakat \"wash\" versiyonunuz iki bandı aynı anda taramayı desteklemiyor. İkili band taramayı yapabilmek için en son versiyona v\${minimum_wash_dualscan_version} sahip olmanız gerekiyor. \${green_color}5Ghz band taramayı istiyor musunuz? \${pink_color}(Eğer cevabınız hayır ise (\"n\"), 2.4Ghz band taranacak) \${normal_color}\${visual_choice}"
	arr["ARABIC",145]="\${normal_color}\${visual_choice} \${pink_color}(فسيتم فحص نطاق 2.4 جيجا هرتز ، (\"n\") إذا أجبت بـ لا( ، \${green_color}هل تريد مسح نطاق 5 جيجاهرتز؟ \${blue_color}.لذلك عليك أن تختار .v\${minimum_wash_dualscan_version} غير قادر على فحص كلا النطاقين في وقت واحد. لاستخدام ميزة المسح ثنائي النطاق ، يجب أن يكون لديك على (v\${reaver_version}) المتضمن في حزمة \"wash \" نطاق 5 جيجا هرتز ولكن إصدار wifi تتحمل بطاقة\${normal_color}"
	arr["CHINESE",145]="\${blue_color}您的 wifi 网卡支持 5Ghz 频段，但 reaver 包中包含的 \"wash\" 版本 (v\${reaver_version}) 无法同时扫描两个频段。要使用双频扫描功能，您的版本必须至少为 v\${minimum_wash_dualscan_version}，因此您必须做出选择。\${green_color}您要扫描5Ghz频段吗？ \${pink_color}(如果您回答否 (\"n\")，将扫描 2.4Ghz 频段) \${normal_color}\${visual_choice}"

	arr["ENGLISH",146]="It seems we failed... try it again, choose another attack or increase the timeout"
	arr["SPANISH",146]="Parece que no lo hemos conseguido... inténtalo de nuevo, elige otro ataque o incrementa el timeout"
	arr["FRENCH",146]="Il semble que c'est un échec... Essayez à nouveau, choisissez une autre attaque ou augmentez le timeout"
	arr["CATALAN",146]="Sembla que no ho hem aconseguit... intenta-ho de nou, tria un altre atac o incrementa el timeout"
	arr["PORTUGUESE",146]="Parece que nos falhamos... Tente novamente, escolha outro ataque ou aumente o timeout"
	arr["RUSSIAN",146]="Кажется мы потерпели неудачу... повторите попытку, выберите другую атаку или увеличьте время ожидания"
	arr["GREEK",146]="Φαίνεται πως αποτύχαμε... προσπαθήστε ξανά ή επιλέξτε άλλου είδους επίθεση ή αυξήστε το timeout"
	arr["ITALIAN",146]="Sembra che abbiamo fallito... riprova, scegli un altro attacco o aumenta il timeout"
	arr["POLISH",146]="Wygląda na to, że się nie udało... spróbuj ponownie, wybierz inny atak lub zwiększ timeout"
	arr["GERMAN",146]="Anscheinend haben wir es nicht geschafft... versuchen Sie es erneut oder erhöhen Sie den Timeout"
	arr["TURKISH",146]="Başarısız görünüyoruz... tekrar deneyin, başka bir saldırı seçin veya zaman aşımını artırın"
	arr["ARABIC",146]="يبدو أننا فشلنا ... حاول مرة أخرى ، اختر هجومًا آخر أو قم بزيادة المهلة"
	arr["CHINESE",146]="看来我们失败了... 再试一次！选择另一种攻击方式或增加等待时间"

	arr["ENGLISH",147]="0.  Return to Handshake/PMKID/Decloak tools menu"
	arr["SPANISH",147]="0.  Volver al menú de herramientas Handshake/PMKID/Decloak"
	arr["FRENCH",147]="0.  Retourner au menu des outils pour la capture du Handshake/PMKID/Decloak"
	arr["CATALAN",147]="0.  Tornar al menú d'eines Handshake/PMKID/Decloak"
	arr["PORTUGUESE",147]="0.  Voltar para o menu de ferramentas Handshake/PMKID/Descamuflagem"
	arr["RUSSIAN",147]="0.  Вернуться в меню инструментов для работы с Handshake/PMKID/Decloak"
	arr["GREEK",147]="0.  Επιστροφή στο μενού με τα εργαλεία Handshake/PMKID/Decloak"
	arr["ITALIAN",147]="0.  Torna al menu degli strumenti Handshake/PMKID/Decloak"
	arr["POLISH",147]="0.  Wróć do menu narzędzi Handshake/PMKID/Decloak"
	arr["GERMAN",147]="0.  Zurück zum Handshake/PMKID/Decloaking-Toolsmenü"
	arr["TURKISH",147]="0.  Handshake/PMKID/Decloak menüsüne geri dön"
	arr["ARABIC",147]=" 0.  Handshake/PMKID/Decloak ارجع إلى قائمة أدوات"
	arr["CHINESE",147]="0.  返回 Handshake/PMKID/Decloak 工具菜单"

	arr["ENGLISH",148]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${handshakepath}]"
	arr["SPANISH",148]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${handshakepath}]"
	arr["FRENCH",148]="Entrez le chemin où vous voulez enregistrer le fichier ou bien appuyez sur [Enter] pour prendre le chemin proposé par défaut \${normal_color}[\${handshakepath}]"
	arr["CATALAN",148]="Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${handshakepath}]"
	arr["PORTUGUESE",148]="Digite o caminho para salvar o arquivo ou pressione [Enter] para o caminho padrão \${normal_color}[\${handshakepath}]"
	arr["RUSSIAN",148]="Напечатайте путь, по которому сохранить файл или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${handshakepath}]"
	arr["GREEK",148]="Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${handshakepath}]"
	arr["ITALIAN",148]="Scrivere il percorso dove memorizzare il file o premere [Enter] per accettare la proposta di default \${normal_color}[\${handshakepath}]"
	arr["POLISH",148]="Wpisz ścieżkę do zapisywania plików lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${handshakepath}]"
	arr["GERMAN",148]="Schreiben Sie den Pfad, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag \${normal_color}[\${handshakepath}] \${green_color}zu benutzen"
	arr["TURKISH",148]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${handshakepath}]"
	arr["ARABIC",148]="\${normal_color}[\${handshakepath}]\${green_color} لقبول المقترح [Enter] اكتب المسار حيث نقوم بتخزين ملف أو اضغط"
	arr["CHINESE",148]="输入文件的存储路径或按 [Enter] 接受默认建议 \${normal_color}[\${handshakepath}]"

	arr["ENGLISH",149]="Handshake file generated successfully at [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["SPANISH",149]="Fichero de Handshake generado con éxito en [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["FRENCH",149]="Fichier Handshake généré avec succès dans [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["CATALAN",149]="Fitxer de Handshake generat amb èxit a [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["PORTUGUESE",149]="Arquivo de Handshake gerado com sucesso [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["RUSSIAN",149]="Файл рукопожатия успешно создан в [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GREEK",149]="Το αρχείο Χειραψίας δημιουργήθηκε επιτυχώς στο [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ITALIAN",149]="Handshake del file generato con successo in [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["POLISH",149]="Plik Handshake został pomyślnie wygenerowany w [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GERMAN",149]="Handshake-Datei erfolgreich in [\${normal_color}\${enteredpath}\${blue_color}] erstellt"
	arr["TURKISH",149]="Handshake dosyası şu hedefte başarıyla oluşturuldu [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ARABIC",149]="[\${normal_color}\${enteredpath}\${blue_color}] بنجاح في Handshake تم إنشاء ملف"
	arr["CHINESE",149]="在 [\${normal_color}\${enteredpath}\${blue_color}] 成功生成握手包文件"

	arr["ENGLISH",150]="No captured Handshake file detected during this session..."
	arr["SPANISH",150]="No se ha detectado ningún fichero de Handshake capturado en esta sesión..."
	arr["FRENCH",150]="Aucun fichier Handshake valide détecté durant cette session..."
	arr["CATALAN",150]="No s'ha detectat un fitxer de Handshake capturat en aquesta sessió..."
	arr["PORTUGUESE",150]="Nenhum Handshake capturado nessa sessão..."
	arr["RUSSIAN",150]="За эту сессию не обнаружено захваченного рукопожатия..."
	arr["GREEK",150]="Δεν εντοπίστηκε κάποιο αρχείο καταγραφής Χειραψίας κατά τη διάρκεια της συνεδρίας..."
	arr["ITALIAN",150]="Non è stato trovato nessun file di Handshake catturato in questa sessione..."
	arr["POLISH",150]="Nie wykryto pliku Handshake przechwyconego w tej sesji..."
	arr["GERMAN",150]="Keine erfasste Handshake-Datei wurde in dieser Sitzung erkannt..."
	arr["TURKISH",150]="Bu oturumda hiçbir handshake dosyayı tespit edilmedi..."
	arr["ARABIC",150]="...تم التقاطه أثناء هذه الدورة Handshake لم يتم اكتشاف ملف"
	arr["CHINESE",150]="在此会话期间未检测到已捕获的握手包文件..."

	arr["ENGLISH",151]="Handshake captured file detected during this session [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["SPANISH",151]="Se ha detectado un fichero de Handshake capturado en esta sesión [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["FRENCH",151]="Un fichier contenant un Handshake a été détecté pour la session effectuée et se trouve dans \${normal_color}\${enteredpath}\${blue_color}]"
	arr["CATALAN",151]="S'ha detectat un fitxer de Handshake capturat en aquesta sessió [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["PORTUGUESE",151]="Handshake capturado com sucesso [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["RUSSIAN",151]="В этой сессии обнаружен файл с захваченным рукопожатием [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GREEK",151]="Εντοπίστηκε αρχείο καταγραφής Χειραψίας κατά τη διάρκεια της συνεδρίας [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ITALIAN",151]="Trovato un file di Handshake catturato in questa sessione [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["POLISH",151]="Plik Handshake został przechwycony w tej sesji został [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GERMAN",151]="Eine erfasste Handshake-Datei wurde erkannt [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["TURKISH",151]="Bu oturum sırasında yakalanmış bir handshake dosyası tespit edildi [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ARABIC",151]="[\${normal_color}\${enteredpath}\${blue_color}] لالدورة التي تم إجراؤها ويقع في Handshake تم اكتشاف ملف يحتوي على"
	arr["CHINESE",151]="在此会话期间检测到的捕获的握手包文件 [\${normal_color}\${enteredpath}\${blue_color}]"

	arr["ENGLISH",152]="Do you want to clean/optimize the Handshake captured file during this session? \${normal_color}\${visual_choice}"
	arr["SPANISH",152]="¿Quieres limpiar/optimizar el fichero de Handshake capturado en esta sesión? \${normal_color}\${visual_choice}"
	arr["FRENCH",152]="Voulez-vous nettoyer/optimiser le fichier Handshake capturé pendant cette session? \${normal_color}\${visual_choice}"
	arr["CATALAN",152]="¿Vols netejar/optimitzar el fitxer de Handshake capturat en aquesta sessió? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",152]="Quer limpar/otimizar o arquivo handshake capturado nesta sessão? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",152]="Вы хотите очистить/оптимизировать захваченный за эту сессию файл рукопожания? \${normal_color}\${visual_choice}"
	arr["GREEK",152]="Θέλετε να καθαρίσετε/βελτιστοποιήσετε το αρχείο καταγραφής Χειραψίας της συνεδρίας; \${normal_color}\${visual_choice}"
	arr["ITALIAN",152]="Vuoi pulire/ottimizzare il file di Handshake catturato in questa sessione? \${normal_color}\${visual_choice}"
	arr["POLISH",152]="Czy chcesz wyczyścić/zoptymalizować plik Handshake przechwycony w tej sesji? \${normal_color}\${visual_choice}"
	arr["GERMAN",152]="Möchten Sie die Handshake-Datei bereinigen/optimieren? \${normal_color}\${visual_choice}"
	arr["TURKISH",152]="Handshake ele geçirilmiş dosyayı bu oturum sırasında temizlemek/optimize etmek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",152]="\${normal_color}\${visual_choice} \${green_color}الذي تم التقاطه أثناء هذه الدورة؟ Handshake هل تريد تنظيف/تحسين ملف\${normal_color}"
	arr["CHINESE",152]="您想在此会话期间清理/优化捕获的文件吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",153]="File cleaned/optimized successfully"
	arr["SPANISH",153]="Fichero limpiado/optimizado con éxito"
	arr["FRENCH",153]="Fichier lavé/optimisé avec succès"
	arr["CATALAN",153]="Fitxer netejat/optimitzat amb èxit"
	arr["PORTUGUESE",153]="Arquivo limpo/otimizado com sucesso"
	arr["RUSSIAN",153]="Файл успешно очищен/оптимизирован"
	arr["GREEK",153]="Το αρχείο καθαρίστηκε/βελτιστοποιήθηκε επιτυχώς"
	arr["ITALIAN",153]="File pulito/ottimizzato con successo"
	arr["POLISH",153]="Plik pomyślnie wyczyszczony/zoptymalizowany"
	arr["GERMAN",153]="Datei erfolgreich bereinigt/optimiert"
	arr["TURKISH",153]="Dosya başarıyla temizlendi/optimize edildi"
	arr["ARABIC",153]="تم تنظيف/تحسين الملف بنجاح"
	arr["CHINESE",153]="文件清理/优化成功"

	arr["ENGLISH",154]="Set path to file:"
	arr["SPANISH",154]="Introduce la ruta al fichero:"
	arr["FRENCH",154]="Entrez le chemin vers le fichier:"
	arr["CATALAN",154]="Introdueix la ruta al fitxer:"
	arr["PORTUGUESE",154]="Digite o caminho do arquivo:"
	arr["RUSSIAN",154]="Установить путь до файла:"
	arr["GREEK",154]="Θέστε μονοπάτι για το αρχείο:"
	arr["ITALIAN",154]="Introdurre il percorso del file:"
	arr["POLISH",154]="Wprowadź ścieżkę do pliku:"
	arr["GERMAN",154]="Geben Sie den Pfad zur Datei ein:"
	arr["TURKISH",154]="Path dizini girin:"
	arr["ARABIC",154]=":تعيين المسار للملف"
	arr["CHINESE",154]="设置文件路径:"

	arr["ENGLISH",155]="The directory exists but you didn't specify filename. It will be autogenerated [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["SPANISH",155]="El directorio existe pero no se especificó nombre de fichero. Se autogenerará [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["FRENCH",155]="Le dossier existe mais sans qu'aucun nom pour le fichier soit précisé. Il sera donc appelé [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["CATALAN",155]="El directori existeix però no s'ha especificat nom de fitxer. Es autogenerará [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["PORTUGUESE",155]="O diretório existe, mas o nome do arquivo não foi especificado. Será gerado automaticamente [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["RUSSIAN",155]="Директория существует, но вы не указали имя файла. Оно будет сгенерировано автоматически [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["GREEK",155]="Ο κατάλογος υπάρχει αλλά δεν έχετε προσδιορίσει το όνομα του αρχείου [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["ITALIAN",155]="La directory esiste, peró non è stato specificato il nome del file. Sarà generato automaticamente [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["POLISH",155]="Katalog istnieje, ale nie określono nazwy pliku. Zostanie ona wygenerowana automatycznie [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["GERMAN",155]="Das Verzeichnis existiert, aber es wurde kein Dateiname angegeben. Er wird sich selbst erzeugen [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["TURKISH",155]="Dizin var ancak dosya adı belirtmediniz. O otomatik üretilecek [\${normal_color}\${suggested_filename}\${yellow_color}]"
	arr["ARABIC",155]="[\${normal_color}\${suggested_filename}\${yellow_color}] الملف موجود ولكنك لم تحدد اسمه. سيتم إنشاؤه تلقائيًا"
	arr["CHINESE",155]="该目录存在但您没有指定文件名。它将自动生成 [\${normal_color}\${suggested_filename}\${yellow_color}]"

	arr["ENGLISH",156]="Directory does not exist"
	arr["SPANISH",156]="El directorio no existe"
	arr["FRENCH",156]="Le dossier n'existe pas"
	arr["CATALAN",156]="El directori no existeix"
	arr["PORTUGUESE",156]="O diretório não existe"
	arr["RUSSIAN",156]="Директория не существует"
	arr["GREEK",156]="Ο κατάλογος δεν υπάρχει"
	arr["ITALIAN",156]="La directory non esiste"
	arr["POLISH",156]="Katalog nie istnieje"
	arr["GERMAN",156]="Das Verzeichnis existiert nicht"
	arr["TURKISH",156]="Dizn bulunamadı"
	arr["ARABIC",156]="الملف غير موجود"
	arr["CHINESE",156]="目录不存在"

	arr["ENGLISH",157]="The path exists but you don't have write permissions"
	arr["SPANISH",157]="La ruta existe pero no tienes permisos de escritura"
	arr["FRENCH",157]="Le chemin existe mais vous ne disposez pas des permis d'écriture"
	arr["CATALAN",157]="La ruta existeix, però no tens permisos d'escriptura"
	arr["PORTUGUESE",157]="O diretório existe, mas você não tem permissões de gravação"
	arr["RUSSIAN",157]="Путь существует, но у вас нет прав на запись"
	arr["GREEK",157]="Το μονοπάτι υπάρχει, αλλά δεν έχετε δικαιώματα εγγραφής"
	arr["ITALIAN",157]="Il percorso esiste, ma non si dispone dei permessi di scrittura"
	arr["POLISH",157]="Ścieżka istnieje, ale nie masz uprawnień do zapisu"
	arr["GERMAN",157]="Die Route existiert, Sie haben jedoch keine Schreibberechtigung"
	arr["TURKISH",157]="Path bulundu ama sizin yazma hakkınız yok"
	arr["ARABIC",157]="المسار موجود ولكن ليس لديك تصاريح الكتابة"
	arr["CHINESE",157]="该路径存在但您没有写权限"

	arr["ENGLISH",158]="The path is valid and you have write permissions. Script can continue..."
	arr["SPANISH",158]="La ruta es válida y tienes permisos de escritura. El script puede continuar..."
	arr["FRENCH",158]="Le chemin est valide et vous disposez des privilèges nécessaires pour l'écriture. Le script peut continuer..."
	arr["CATALAN",158]="La ruta és vàlida i tens permisos d'escriptura. El script pot continuar..."
	arr["PORTUGUESE",158]="O diretório é válido e você tem permissões de gravação. O script pode continuar..."
	arr["RUSSIAN",158]="Путь существует и у вас есть права на запись. Скрипт может продолжить..."
	arr["GREEK",158]="Το μονοπάτι είναι έγκυρο και έχετε δικαιώματα εγγραφής. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",158]="Il percorso è valido e si dispone di permessi di scrittura. Lo script può continuare..."
	arr["POLISH",158]="Ścieżka jest poprawna i masz uprawnienia do zapisu. Skrypt może kontynuować..."
	arr["GERMAN",158]="Die Route ist gültig und Sie haben Schreibberechtigung. Das Skript kann fortfahren..."
	arr["TURKISH",158]="Path doğrulandı ve yazma hakkınız var. Yazılım devam edebilir..."
	arr["ARABIC",158]="...المسار صالح ولديك الامتيازات اللازمة للكتابة. يمكن أن يستمر البرنامج"
	arr["CHINESE",158]="该路径有效并且具有写入权限。脚本可以继续..."

	arr["ENGLISH",159]="The file doesn't need to be cleaned/optimized"
	arr["SPANISH",159]="El fichero no necesita ser limpiado/optimizado"
	arr["FRENCH",159]="Le fichier n'a pas besoin d'être nettoyé/optimisé"
	arr["CATALAN",159]="El fitxer no necessita ser netejat/optimitzat"
	arr["PORTUGUESE",159]="O arquivo não precisa ser limpo/otimizado"
	arr["RUSSIAN",159]="Файлу не требуется очистка/оптимизация"
	arr["GREEK",159]="Το αρχείο δεν χρειάζεται να καθαριστεί/βελτιστοποιηθεί"
	arr["ITALIAN",159]="Il file non ha bisogno di essere pulito/ottimizzato"
	arr["POLISH",159]="Nie ma potrzeby wyczyszczenia/zoptymalizowania tego pliku"
	arr["GERMAN",159]="Die Datei braucht nicht bereinigt/optimiert werden"
	arr["TURKISH",159]="Dosyanın temizlenmeye/optimize edilmeye ihtiyacı yok"
	arr["ARABIC",159]="لا يحتاج الملف إلى تنظيف/تحسين"
	arr["CHINESE",159]="该文件不需要清理/优化"

	arr["ENGLISH",160]="No tasks to perform on exit"
	arr["SPANISH",160]="No hay que realizar ninguna tarea a la salida"
	arr["FRENCH",160]="Aucune opération n'est planifiée pour l’arrêt du script"
	arr["CATALAN",160]="No cal fer cap tasca a la sortida"
	arr["PORTUGUESE",160]="Não há tarefas a serem executadas na saída"
	arr["RUSSIAN",160]="Нет задач для выполнения перед выходом"
	arr["GREEK",160]="Δεν απομένει κάποιο task για να εκτελεστεί στην έξοδο"
	arr["ITALIAN",160]="Non bisogna fare niente dopo l'uscita dello script"
	arr["POLISH",160]="Plik nie musi być wczyszczony/zoptymalizowany"
	arr["GERMAN",160]="Es gibt keine Aufgabe beim Verlassen"
	arr["TURKISH",160]="Çıkışta gerçekleştirilecek görev yok"
	arr["ARABIC",160]="لا توجد مهام للأداء عند الخروج"
	arr["CHINESE",160]="退出时没有要执行的任务..."

	arr["ENGLISH",161]="File doesn't exist"
	arr["SPANISH",161]="El fichero no existe"
	arr["FRENCH",161]="Le fichier n' existe pas"
	arr["CATALAN",161]="El fitxer no existeix"
	arr["PORTUGUESE",161]="O arquivo não existe"
	arr["RUSSIAN",161]="Файл не существует"
	arr["GREEK",161]="Το αρχείο δεν υπάρχει"
	arr["ITALIAN",161]="Il file non esiste"
	arr["POLISH",161]="Plik nie istnieje"
	arr["GERMAN",161]="Die Datei existiert nicht"
	arr["TURKISH",161]="Dosya bulunamadı"
	arr["ARABIC",161]="الملف غير موجود"
	arr["CHINESE",161]="文件不存在"

	arr["ENGLISH",162]="Congratulations!!"
	arr["SPANISH",162]="Enhorabuena!!"
	arr["FRENCH",162]="Félicitations!!"
	arr["CATALAN",162]="Enhorabona!!"
	arr["PORTUGUESE",162]="Parabéns!!"
	arr["RUSSIAN",162]="Поздравления!!"
	arr["GREEK",162]="Συγχαρητήρια!!"
	arr["ITALIAN",162]="Congratulazioni!!"
	arr["POLISH",162]="Gratulacje!!"
	arr["GERMAN",162]="Herzlichen Glückwunsch!!"
	arr["TURKISH",162]="Tebrikler!!"
	arr["ARABIC",162]="!!تهانينا"
	arr["CHINESE",162]="恭喜！！"

	arr["ENGLISH",163]="When airgeddon requests you to enter a path to a file either to use a dictionary, a Handshake or anything else, did you know that you can drag and drop the file over the airgeddon window? In this way you don't have to type the path manually"
	arr["SPANISH",163]="Cuando airgeddon solicita que introduzcas una ruta a un fichero ya sea para utilizar un diccionario, un Handshake o cualquier otra cosa, ¿sabías que puedes arrastrar y soltar el fichero sobre la ventana de airgeddon? Así no tendrás que escribir la ruta manualmente"
	arr["FRENCH",163]="Quand airgeddon demande d'entrer un chemin d'accès vers un fichier soit pour utiliser un dictionnaire, un Handshake ou autre chose, saviez-vous que vous pouvez faire glisser le fichier sur la fenêtre airgeddon? Donc vous n'avez pas à taper la route manuellement"
	arr["CATALAN",163]="Quan airgeddon sol·licita que introdueixis una ruta a un fitxer ja sigui per utilitzar un diccionari, un Handshake o qualsevol altra cosa, ¿saps que pots arrossegar i deixar anar el fitxer sobre la finestra de airgeddon? Així no hauràs d'escriure la ruta manualment"
	arr["PORTUGUESE",163]="Quando a airgeddon solicita que você insira o caminho de: um dicionário, um Handshake ou qualquer outra coisa, você sabia que pode arrastar o arquivo para janela do airgeddon? Assim você não precisa digitar o caminho manualmente"
	arr["RUSSIAN",163]="Когда airgeddon просит вас ввести путь до файла, будь то словарь, рукопожатие или что-то ещё, знаете ли вы, что можно захватить этот файл мышкой, перетащить и бросить этот файл прямо в окно airgeddon? Таким образом вам не придётся вводить путь до файла вручную"
	arr["GREEK",163]="Γνωρίζατε ότι μπορείτε να εισάγετε μονοπάτι για κάποιο αρχείο είτε για να χρησιμοποιήσετε λεξικό, αρχείο Χειραψίας ή οτιδήποτε άλλο, κάνοντας Drag & Drop το αρχείο αυτό στο παράθυρο του airgeddon; Με αυτόν τον τρόπο δεν χρειάζεται να πληκτρολογείτε το μονοπάτι χειροκίνητα"
	arr["ITALIAN",163]="Quando airgeddon chiede di introdurre il percorso di un file per utilizzare un dizionario, un Handshake o qualsiasi altra cosa, sapevi che puoi trascinare e rilasciare il file sulla finestra di airgeddon? Cosí non dovrai digitare manualmente il percorso"
	arr["POLISH",163]="Wiesz, że kiedy airgeddon poprosi Cię o podanie ścieżki do pliku aby użyć słownika, pliku Handshake lub cokolwiek innego, możesz przeciągnąć i upuścić plik przez okno airgeddon? Nie musisz wpisywać scieżki ręcznie"
	arr["GERMAN",163]="Wenn airgeddon Sie auffordert, einen Dateipfad einzugeben, um ein Wörterbuch, einen Handshake oder etwas anderes zu verwenden, wussten Sie, dass Sie die Datei per Drag & Drop auf das airgeddon-Fenster ziehen können? Sie müssen die Route nicht manuell schreiben"
	arr["TURKISH",163]="airgeddon, bir sözlük, bir Handshake veya başka bir şey kullanmak için dosyaya bir yol girmenizi istediğinde, dosyayı airgeddon penceresinin üzerine sürükleyip bırakabileceğinizi biliyor muydunuz? Bu şekilde yolu elle yazmanız gerekmez"
	arr["ARABIC",163]="؟ بهذه الطريقة لن تضطر إلى كتابة المسار يدويًاairgeddon إدخال مسار إلى ملف إما لاستخدام قاموس أو مصافحة أو أي شيء آخر ، هل تعلم أنه يمكنك سحب الملف وإفلاته فوق نافذة airgeddon عندما يطلب منك"
	arr["CHINESE",163]="当 airgeddon 要求您输入文件路径以使用字典、握手包或其他任何文件时，您是否知道可以将文件拖放到 airgeddon 窗口上？这样您就不必手动输入路径"

	arr["ENGLISH",164]="Cleaning temp files"
	arr["SPANISH",164]="Limpiando archivos temporales"
	arr["FRENCH",164]="Effacement des fichiers temporaires"
	arr["CATALAN",164]="Netejant arxius temporals"
	arr["PORTUGUESE",164]="Limpando arquivos temporários"
	arr["RUSSIAN",164]="Очистка временных файлов"
	arr["GREEK",164]="Γίνεται καθαρισμός προσωρινών αρχείων"
	arr["ITALIAN",164]="Pulendo i file temporanei"
	arr["POLISH",164]="Usuwanie plików tymczasowych"
	arr["GERMAN",164]="Temporäre Dateien bereinigen"
	arr["TURKISH",164]="Temp dosyaları temizleniyor"
	arr["ARABIC",164]="تنظيف الملفات المؤقتة"
	arr["CHINESE",164]="正在清理临时文件"

	arr["ENGLISH",165]="Checking if cleaning/restoring tasks are needed..."
	arr["SPANISH",165]="Comprobando si hay que realizar tareas de limpieza/restauración..."
	arr["FRENCH",165]="Vérification de la nécessité d'effectuer ou pas des opérations de nettoyage/restauration..."
	arr["CATALAN",165]="Comprovant si cal realitzar tasques de neteja/restauració..."
	arr["PORTUGUESE",165]="Verificando se é necessário executar tarefas de limpeza/restauração..."
	arr["RUSSIAN",165]="Проверка, нужны ли задачи по очистке/восстановлению..."
	arr["GREEK",165]="Γίνεται έλεγχος αν χρειάζονται tasks καθαρισμού/αποκατάστασης..."
	arr["ITALIAN",165]="Verificando se è necessarrio eseguire la pulizia/restauro..."
	arr["POLISH",165]="Sprawdzenie czy wymagane jest czyszczenie/przywrócenie..."
	arr["GERMAN",165]="Überprüfung, ob Reinigungs/Restaurierungsarbeiten durchgeführt werden müssen..."
	arr["TURKISH",165]="Temizlik/geri yükleme görevlerinin gerekli olup olmadığı denetleniyor..."
	arr["ARABIC",165]="...التحقق مما إذا كانت مهام التنظيف/الاستعادة مطلوبة"
	arr["CHINESE",165]="检查是否有需要清理 / 恢复的任务..."

	arr["ENGLISH",166]="Do you want to preserve monitor mode for your card on exit? \${normal_color}\${visual_choice}"
	arr["SPANISH",166]="¿Deseas conservar el modo monitor de tu interfaz al salir? \${normal_color}\${visual_choice}"
	arr["FRENCH",166]="Voulez-vous laisser votre interface en mode moniteur après l'arrêt du script? \${normal_color}\${visual_choice}"
	arr["CATALAN",166]="¿Vols conservar el mode monitor de la teva interfície en sortir? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",166]="Quer manter sua interface em modo monitor ao sair do script? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",166]="Вы хотите сохранить режим монитора вашей карты при выходе? \${normal_color}\${visual_choice}"
	arr["GREEK",166]="Θέλετε να παραμείνει η κάρτα σε κατάσταση παρακολούθησης κατά την έξοδο; \${normal_color}\${visual_choice}"
	arr["ITALIAN",166]="Vuoi mantenere l'interfaccia in modalità monitor dopo essere uscito? \${normal_color}\${visual_choice}"
	arr["POLISH",166]="Czy chcesz zachować tryb monitorowania teojej karty sieciowej po wyjsciu? \${normal_color}\${visual_choice}"
	arr["GERMAN",166]="Möchten Sie den Monitor-Modus Ihres Interface beim Beenden beibehalten? \${normal_color}\${visual_choice}"
	arr["TURKISH",166]="Çıkışta kartınızın monitör modunu korumak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",166]="\${normal_color}\${visual_choice} \${green_color}لبطاقتك عند الخروج؟ monitor mode هل تريد الاحتفاظ بوضع\${normal_color}"
	arr["CHINESE",166]="您想在退出时为选择的网络接口保留监听模式吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",167]="Setting your interface in managed mode"
	arr["SPANISH",167]="Poniendo interfaz en modo managed"
	arr["FRENCH",167]="L'interface est en train de passer en mode managed"
	arr["CATALAN",167]="Configurant la interfície en mode managed"
	arr["PORTUGUESE",167]="Colocando interface de modo managed"
	arr["RUSSIAN",167]="Перевод вашего интерфейса в управляемый режим"
	arr["GREEK",167]="Η διεπαφή μπαίνει σε ετερόκλητη κατάσταση"
	arr["ITALIAN",167]="Mettendo l'interfaccia in modalità managed"
	arr["POLISH",167]="Uruchamianie w trybie zarządzania"
	arr["GERMAN",167]="Interface wird im Managed-Modus eingestellt"
	arr["TURKISH",167]="Arayüzünüzün yönetici modu açılıyor"
	arr["ARABIC",167]="managed mode ضبط واجهتك في وضع"
	arr["CHINESE",167]="正在将接口设置为管理模式"

	arr["ENGLISH",168]="Launching previously killed processes"
	arr["SPANISH",168]="Arrancando procesos cerrados anteriormente"
	arr["FRENCH",168]="Lancement des processus précédemment tués"
	arr["CATALAN",168]="Llançant processos tancats anteriorment"
	arr["PORTUGUESE",168]="Processos de inicialização previamente fechados"
	arr["RUSSIAN",168]="Запуск ранее убитых процессов"
	arr["GREEK",168]="Γίνεται έναρξη των προηγούμενων σταματημένων διεργασιών"
	arr["ITALIAN",168]="Lanciando i processi chiusi precedentemente"
	arr["POLISH",168]="Uruchamianie wcześniej zakończonych procesów"
	arr["GERMAN",168]="Vorab geschlossene Prozesse starten"
	arr["TURKISH",168]="Daha önce sonlandırılan görevler başlatılıyor"
	arr["ARABIC",168]="إطلاق عمليات قتلت سابقًا"
	arr["CHINESE",168]="启动先前终止的进程"

	arr["ENGLISH",169]="6.  Offline WPA/WPA2 decrypt menu"
	arr["SPANISH",169]="6.  Menú de descifrado WPA/WPA2 offline"
	arr["FRENCH",169]="6.  Menu crack WPA/WPA2 offline"
	arr["CATALAN",169]="6.  Menú per desxifrar WPA/WPA2 offline"
	arr["PORTUGUESE",169]="6.  Menu de descriptografia WPA/WPA2 offline"
	arr["RUSSIAN",169]="6.  Меню офлайн расшифровки WPA/WPA2"
	arr["GREEK",169]="6.  Μενού offline αποκρυπτογράφησης WPA/WPA2"
	arr["ITALIAN",169]="6.  Menù per decifrare WPA/WPA2 offline"
	arr["POLISH",169]="6.  Menu deszyfrowania WPA/WPA2 offline"
	arr["GERMAN",169]="6.  Offline WPA/WPA2-Entschlüsselungsmenü"
	arr["TURKISH",169]="6.  Çevrimdışı WPA/WPA2 decrypt menüsü"
	arr["ARABIC",169]="6.  غير المتصلة WPA/WPA2 اقائمة فك تشفير"
	arr["CHINESE",169]="6.  离线 WPA/WPA2 捕获文件暴力破解菜单"

	arr["ENGLISH",170]="Offline WPA/WPA2 decrypt menu"
	arr["SPANISH",170]="Menú de descifrado WPA/WPA2 offline"
	arr["FRENCH",170]="Menu crack WPA/WPA2 offline"
	arr["CATALAN",170]="Menú per desxifrar WPA/WPA2 offline"
	arr["PORTUGUESE",170]="Menu de descriptografia WPA/WPA2 offline"
	arr["RUSSIAN",170]="Меню офлайн расшифровки WPA/WPA2"
	arr["GREEK",170]="Μενού offline αποκρυπτογράφησης WPA/WPA2"
	arr["ITALIAN",170]="Menù per decifrare WPA/WPA2 offline"
	arr["POLISH",170]="Menu deszyfrowania WPA/WPA2 offline"
	arr["GERMAN",170]="Offline WPA/WPA2-Entschlüsselungsmenü"
	arr["TURKISH",170]="Çevrimdışı WPA/WPA2 decrypt menüsü"
	arr["ARABIC",170]="غير المتصلة WPA/WPA2 اقائمة فك تشفير"
	arr["CHINESE",170]="离线 WPA/WPA2 捕获文件暴力破解菜单"

	arr["ENGLISH",171]="The key decrypt process is performed offline on a previously captured file"
	arr["SPANISH",171]="El proceso de descifrado de las claves se realiza de manera offline sobre un fichero capturado previamente"
	arr["FRENCH",171]="Le crack de la clef s'effectue offline en utilisant le fichier capturé antérieurement"
	arr["CATALAN",171]="El procés de desxifrat de les claus es realitza de manera offline sobre un fitxer capturat prèviament"
	arr["PORTUGUESE",171]="O processo de descriptografia é realizada de modo offline em um arquivo previamente capturado"
	arr["RUSSIAN",171]="Процесс расшифровки ключа выполняется офлайн на ранее захваченном файле"
	arr["GREEK",171]="Η διεργασία αποκρυπτογράφησης κλειδιού έχει εκτελεστεί offline σε προηγούμενο αρχείο καταγραφής"
	arr["ITALIAN",171]="Il processo di decodifica della chiave viene eseguito offline su un file catturato precedentemente"
	arr["POLISH",171]="Proces deszyfrowania klucza odbywa się offline na poprzednio przechwyconym pliku"
	arr["GERMAN",171]="Die Entschlüsselung erfolgt offline über eine zuvor erfasste Datei"
	arr["TURKISH",171]="Anahtar şifre çözme işlemi daha önce yakalanan bir dosyada çevrimdışı gerçekleştirilir"
	arr["ARABIC",171]="يتم تنفيذ عملية فك تشفير المفتاح في وضع عدم الاتصال على ملف تم التقاطه مسبقًا"
	arr["CHINESE",171]="WiFi 密钥破解的过程是在先前捕获的文件上离线执行的"

	arr["ENGLISH",172]="1.  (aircrack) Dictionary attack against Handshake/PMKID capture file"
	arr["SPANISH",172]="1.  (aircrack) Ataque de diccionario sobre fichero de captura Handshake/PMKID"
	arr["FRENCH",172]="1.  (aircrack) Attaque de dictionnaire en utilisant le fichier de capture Handshake/PMKID"
	arr["CATALAN",172]="1.  (aircrack) Atac de diccionari sobre fitxer de captura Handshake/PMKID"
	arr["PORTUGUESE",172]="1.  (aircrack) Ataque de dicionário em um arquivo de captura Handshake/PMKID"
	arr["RUSSIAN",172]="1.  (aircrack) Атака по словарю в отношении захваченного файла рукопожатия/PMKID"
	arr["GREEK",172]="1.  (aircrack) Επίθεση με χρήση λεξικού σε αρχείο καταγραφής Handshake/PMKID"
	arr["ITALIAN",172]="1.  (aircrack) Attacco dizionario sul file di cattura Handshake/PMKID"
	arr["POLISH",172]="1.  (aircrack) Atak słownikowy na plik przechwytywania Handshake/PMKID"
	arr["GERMAN",172]="1.  (aircrack) Wörterbuchangriff auf der aufgenommenen Handshake/PMKID Datei"
	arr["TURKISH",172]="1.  (aircrack) Yakalanan Handshake/PMKID dosyasına sözlük saldırısı"
	arr["ARABIC",172]="1.  Handshake/PMKID هجوم القاموس على ملف الالتقاط (aircrack)"
	arr["CHINESE",172]="1.  (aircrack) 字典攻击 Handshake/PMKID 捕获文件"

	arr["ENGLISH",173]="Selected capture file: \${pink_color}\${enteredpath}\${normal_color}"
	arr["SPANISH",173]="Fichero de captura seleccionado: \${pink_color}\${enteredpath}\${normal_color}"
	arr["FRENCH",173]="Fichier de capture sélectionné: \${pink_color}\${enteredpath}\${normal_color}"
	arr["CATALAN",173]="Fitxer de captura seleccionat: \${pink_color}\${enteredpath}\${normal_color}"
	arr["PORTUGUESE",173]="Arquivo de captura selecionado: \${pink_color}\${enteredpath}\${normal_color}"
	arr["RUSSIAN",173]="Выбранный файл захвата: \${pink_color}\${enteredpath}\${normal_color}"
	arr["GREEK",173]="Επιλεγμένο αρχείο καταγραφής: \${pink_color}\${enteredpath}\${normal_color}"
	arr["ITALIAN",173]="File di cattura selezionato: \${pink_color}\${enteredpath}\${normal_color}"
	arr["POLISH",173]="Wybrany plik przechwytywania: \${pink_color}\${enteredpath}\${normal_color}"
	arr["GERMAN",173]="Ausgewählte Capture-Datei: \${pink_color}\${enteredpath}\${normal_color}"
	arr["TURKISH",173]="Seçilen yakalama dosyası: \${pink_color}\${enteredpath}\${normal_color}"
	arr["ARABIC",173]="\${pink_color}\${enteredpath}\${blue_color} :اختيار ملف الالتقاط\${normal_color}"
	arr["CHINESE",173]="已选择的捕获文件: \${pink_color}\${enteredpath}\${normal_color}"

	arr["ENGLISH",174]="It seems you have an unsupported bettercap version to perform sslstrip. Use the old bettercap 1.x or use bettercap>=\${bettercap2_sslstrip_working_version}. Early versions of bettercap 2.x have known problems to perform sslstrip attacks. More info at Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["SPANISH",174]="Parece que tienes una versión de bettercap no soportada para realizar sslstrip. Utiliza el antiguo bettercap 1.x o bien utiliza bettercap>=\${bettercap2_sslstrip_working_version}. Las primeras versiones de bettercap 2.x tienen problemas conocidos para realizar ataques sslstrip. Más info en el Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["FRENCH",174]="Il semble que vous avez une version non supportée de bettercap pour la réalization de sslstrip. Utilisez l'ancien bettercap 1.x ou utilisez bettercap>=\${bettercap2_sslstrip_working_version}. Les premières versions de bettercap 2.x ont des problèmes connus avec les attaques sslstrip. Plus d'informations sur le Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["CATALAN",174]="Sembla que tens una versió de bettercap no suportada per realitzar sslstrip. Utilitza l'antic bettercap 1.x o bé utilitza bettercap>=\${bettercap2_sslstrip_working_version}. Les primeres versions de bettercap 2.x tenen problemes coneguts per realitzar atacs sslstrip. Més info al Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["PORTUGUESE",174]="Parece que você tem uma versão incompatível do bettercap com o sslstrip. Use o antigo bettercap 1.x ou o bettercap>=\${bettercap2_sslstrip_working_version}. As primeiras versões do bettercap 2.x têm problemas conhecidos com ataques que utilizam o sslstrip. Mais informações no Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["RUSSIAN",174]="Похоже, у вас неподдерживаемая версия bettercap для выполнения sslstrip. Используйте старую версию bettercap 1.x или используйте bettercap>=\${bettercap2_sslstrip_working_version}. В ранних версиях bettercap 2.x были известные проблемы с выполнением sslstrip-атак. Больше информации на Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["GREEK",174]="Φαίνεται ότι έχετε μια μη υποστηριζόμενη έκδοση bettercap για εκτέλεση sslstrip. Χρησιμοποιήστε το παλιό bettercap 1.x ή χρησιμοποιήστε bettercap>=\${bettercap2_sslstrip_working_version} Οι αρχικές εκδόσεις του bettercap 2.x έχουν γνωστά προβλήματα για την εκτέλεση επιθέσεων sslstrip. Περισσότερες πληροφορίες στο Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["ITALIAN",174]="Sembra che tu abbia una versione di bettercap non supportata per eseguire sslstrip. Utilizza il vecchio bettercap 1.x oppure bettercap>=\${bettercap2_sslstrip_working_version}. Le prime versioni di bettercap 2.x avevano problemi noti con gli attacchi sslstrip. Maggiori informazioni sul Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap Tips"
	arr["POLISH",174]="Wygląda na to, że masz nieobsługiwaną wersję Bettercap do przeprowadzenia sslstrip. Użyj starego bettercap 1.x lub użyj bettercap>=\${bettercap2_sslstrip_working_version}. Wczesne wersje bettercap 2.x mają znane problemy z atakami sslstrip. Więcej informacji na Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap Tips"
	arr["GERMAN",174]="Sie scheinen eine nicht unterstützte Version von bettercap zu haben, um sslstrip auszuführen. Verwenden Sie entweder die alte Bettercap 1.x oder Bettercap>=\${bettercap2_sslstrip_working_version}. Frühere Versionen von bettercap 2.x haben bekannte Probleme mit sslstrip-Angriffen. Weitere Infos im Wiki: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"
	arr["TURKISH",174]="Görünüşe göre sslstrip gerçekleştirmek için desteklenmeyen bir bettercap sürümünüz var. Eski bettercap 1.x'i veya bettercap>=\${bettercap2_sslstrip_working_version} seçeneğini kullanın. Bettercap 2.x'in ilk sürümlerinde, sslstrip saldırılarını gerçekleştirmek için bilinen sorunlar vardır. Wiki'de daha fazla bilgi: \${normal_color}\$ {urlgithub_wiki}/Bettercap%20Tips"
	arr["ARABIC",174]="\${normal_color}\${urlgithub_wiki}/Bettercap%20Tips\${red_color} :مزيد من المعلومات على الويكي .sslstrip عرفت مشاكل أثناء تنفيذ هجمات bettercap 2.x الإصدارات القديمة من .bettercap>=\${bettercap2_sslstrip_working_version} أو استخدم bettercap 1.x استخدم الإصدارالقديم .sslstrip لا يسمح باستخدام bettercap يبدو أن لديك إصدار"
	arr["CHINESE",174]="您似乎有一个不受支持的 bettercap 版本来执行 sslstrip。使用旧的 bettercap 1.x 或使用 bettercap>=\${bettercap2_sslstrip_working_version}。 bettercap 2.x 的早期版本在执行 sslstrip 攻击时存在已知问题。 Wiki 上的更多信息: \${normal_color}\${urlgithub_wiki}/Bettercap%20Tips"

	arr["ENGLISH",175]="2.  (aircrack + crunch) Bruteforce attack against Handshake/PMKID capture file"
	arr["SPANISH",175]="2.  (aircrack + crunch) Ataque de fuerza bruta sobre fichero de captura Handshake/PMKID"
	arr["FRENCH",175]="2.  (aircrack + crunch) Attaque de force brute en utilisant le fichier de capture Handshake/PMKID"
	arr["CATALAN",175]="2.  (aircrack + crunch) Atac de força bruta sobre fitxer de captura Handshake/PMKID"
	arr["PORTUGUESE",175]="2.  (aircrack + crunch) Ataque de força bruta em um arquivo de captura Handshake/PMKID"
	arr["RUSSIAN",175]="2.  (aircrack + crunch) Атака методом брут-форса в отношении захваченного файла рукопожатия/PMKID"
	arr["GREEK",175]="2.  (aircrack + crunch) Επίθεση bruteforce σε αρχείο καταγραφής Handshake/PMKID"
	arr["ITALIAN",175]="2.  (aircrack + crunch) Attacco di forza bruta sul file di cattura Handshake/PMKID"
	arr["POLISH",175]="2.  (aircrack + crunch) Atak brute force na plik przechwytywania Handshake/PMKID"
	arr["GERMAN",175]="2.  (aircrack + crunch) Brute-Force-Angriff auf die Capture-Datei Handshake/PMKID"
	arr["TURKISH",175]="2.  (aircrack + crunch) Yakalanan Handshake/PMKID dosyasına karşı bruteforce saldırısı"
	arr["ARABIC",175]="2.  Handshake/PMKID باستخدام ملف التقاط Bruteforce هجوم (aircrack + crunch)"
	arr["CHINESE",175]="2.  (aircrack + crunch) 暴力破解 Handshake/PMKID 捕获文件"

	arr["ENGLISH",176]="aircrack CPU, non GPU attacks"
	arr["SPANISH",176]="ataques aircrack CPU, no GPU"
	arr["FRENCH",176]="attaques aircrack CPU, pas GPU"
	arr["CATALAN",176]="atacs aircrack CPU, no GPU"
	arr["PORTUGUESE",176]="ataques aircrack CPU, não GPU"
	arr["RUSSIAN",176]="aircrack атаки с использованием процессора, а не видеокарты"
	arr["GREEK",176]="επιθέσεις aircrack CPU, όχι GPU"
	arr["ITALIAN",176]="attacchi aircrack CPU, non GPU"
	arr["POLISH",176]="ataki CPU, nie GPU"
	arr["GERMAN",176]="CPU aircrack Angriffe, keine GPU"
	arr["TURKISH",176]="aircrack CPU, GPU olmayan saldırılar"
	arr["ARABIC",176]="GPU وليس ، CPU ل aircrack هجمات"
	arr["CHINESE",176]="aircrack CPU 破解"

	arr["ENGLISH",177]="Selected captured file: \${pink_color}None\${normal_color}"
	arr["SPANISH",177]="Fichero capturado seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",177]="Fichier de capture sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",177]="Fitxer capturat seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",177]="Arquivo de captura selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",177]="Выбран файл захвата: \${pink_color}Нет\${normal_color}"
	arr["GREEK",177]="Επιλεγμένο αρχείο καταγραφής: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",177]="File catturato selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",177]="Wybrany przechwycony plik: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",177]="Ausgewählte erfasste Datei: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",177]="Seçilen yakalanmış dosya: \${pink_color}None\${normal_color}"
	arr["ARABIC",177]="\${pink_color}None\${blue_color} :ملف الالتقاط المحدد\${normal_color}"
	arr["CHINESE",177]="已选择的捕获文件: \${pink_color}None\${normal_color}"

	arr["ENGLISH",178]="To decrypt the key of a WPA/WPA2 network, the capture file must contain a Handshake/PMKID"
	arr["SPANISH",178]="Para descifrar la clave de una red WPA/WPA2, el fichero de captura debe contener un Handshake/PMKID"
	arr["FRENCH",178]="Pour cracker la clé d'un réseau WPA/WPA2 le fichier de capture doit contenir un Handshake/PMKID"
	arr["CATALAN",178]="Per desxifrar la clau d'una xarxa WPA/WPA2 el fitxer de captura ha de contenir un Handshake/PMKID"
	arr["PORTUGUESE",178]="Para descriptografar a senha de uma rede WPA/WPA2, o arquivo de captura deve conter um Handshake/PMKID"
	arr["RUSSIAN",178]="Для расшифровки ключа сетей WPA/WPA2, файл захвата должен содержать четырёхэтапное рукопожатие/PMKID"
	arr["GREEK",178]="Για να αποκρυπτογραφήσετε το κλειδί ενός WPA/WPA2 δικτύου, το αρχείο καταγραφής πρέπει να περιέχει μία Χειραψία/PMKID"
	arr["ITALIAN",178]="Per decriptare la chiave per una rete WPA/WPA2, il file di cattura deve contenere un Handshake/PMKID"
	arr["POLISH",178]="Aby odszyfrować klucz sieci WPA/WPA2, plik przechwytywania musi zawierać Handshake/PMKID"
	arr["GERMAN",178]="Um den Schlüssel eines WPA/WPA2-Netzwerks zu entschlüsseln, muss die Erfassungsdatei einen Handshake/PMKID enthalten"
	arr["TURKISH",178]="WPA/WPA2 ağının şifresini çözmek için, yakalama dosyası bir Handshake/PMKID içermelidir"
	arr["ARABIC",178]="Handshake/PMKID يجب أن يحتوي ملف الالتقاط على ، WPA/WPA2 لفك تشفير مفتاح شبكة"
	arr["CHINESE",178]="要解密 WPA/WPA2 网络的密钥，捕获的文件必须包含 Handshake/PMKID"

	arr["ENGLISH",179]="Decrypting by bruteforce, it could pass hours, days, weeks or even months to take it depending on the complexity of the password and your processing speed"
	arr["SPANISH",179]="Descifrando por fuerza bruta, podrían pasar horas, días, semanas o incluso meses hasta conseguirlo dependiendo de la complejidad de la contraseña y de tu velocidad de proceso"
	arr["FRENCH",179]="Le crack de la clef par attaque de type brute force peut prendre des heures, des jours, des semaines ou même des mois en fonction de la complexité de la clef et de la puissance de calcul de votre matériel"
	arr["CATALAN",179]="Desxifrant per força bruta, podrien passar hores, dies, setmanes o fins i tot mesos fins a aconseguir-ho depenent de la complexitat de la contrasenya i de la teva velocitat de procés"
	arr["PORTUGUESE",179]="Descriptografar com força bruta pode levar horas, dias, semanas ou mesmo meses dependendo da complexidade da senha e velocidade de processamento"
	arr["RUSSIAN",179]="Расшифровка полным перебором может занять часы, дни, недели или даже месяцы в зависимости от сложности пароля и вашей скорости обработки"
	arr["GREEK",179]="Αποκρυπτογραφώντας με χρήση ωμής βίας, μπορεί να περάσουν ώρες, μέρες, εβδομάδες ή ακόμη και μήνες για να το αποκτήσετε έχοντας υπόψιν την πολυπλοκότητα του κωδικού πρόσβασης και την ταχύτητα του επεξεργαστή"
	arr["ITALIAN",179]="Decifrando con forza bruta, potrebbero trascorrere ore, giorni, settimane o addirittura mesi per ottenere la password a seconda della sua complessità e della velocità del processore"
	arr["POLISH",179]="Odszyfrowywanie przez brut force może trwać godziny, dni, tygodnie lub nawet miesiące w zależności od złożoności hasła i szybkości przetwarzania"
	arr["GERMAN",179]="Die Entschlüsselung mit roher Gewalt könnte Stunden, Tage, Wochen oder sogar Monate in Anspruch nehmen, abhängig von der Komplexität des Passworts und der Geschwindigkeit des Prozesses"
	arr["TURKISH",179]="Bruteforce tarafından şifresini çözmek, şifrenin karmaşıklığına ve işlem hızınıza bağlı olarak bunu almak için saatler, günler, haftalar hatta aylar geçirebilir"
	arr["ARABIC",179]="يمكن أن يمر ساعات أو أيام أو أسابيع أو حتى أشهر لأخذها اعتمادًا على مدى تعقيد كلمة المرور وسرعة المعالجة ،bruteforce فك التشفير عن طريق"
	arr["CHINESE",179]="暴力破解密码可能需要数小时、数天、数周甚至数月才能完成，具体取决于密码的复杂程度和您设备的处理速度"

	arr["ENGLISH",180]="Enter the path of a dictionary file:"
	arr["SPANISH",180]="Introduce la ruta de un fichero de diccionario:"
	arr["FRENCH",180]="Saisissez un chemin vers un dictionnaire d'attaque:"
	arr["CATALAN",180]="Introdueix la ruta d'un fitxer de diccionari:"
	arr["PORTUGUESE",180]="Digite o caminho de um arquivo de dicionário:"
	arr["RUSSIAN",180]="Введите путь до файла словаря:"
	arr["GREEK",180]="Εισάγετε το μονοπάτι ενός λεξικού:"
	arr["ITALIAN",180]="Immettere il percorso di un file dizionario:"
	arr["POLISH",180]="Wprowadź ścieżkę pliku słownika:"
	arr["GERMAN",180]="Geben Sie den Pfad einer Wörterbuchdatei ein:"
	arr["TURKISH",180]="Dosya yolunu girin:"
	arr["ARABIC",180]=":أدخل مسار ملف القاموس"
	arr["CHINESE",180]="请输入字典文件的路径:"

	arr["ENGLISH",181]="The path to the dictionary file is valid. Script can continue..."
	arr["SPANISH",181]="La ruta al fichero de diccionario es válida. El script puede continuar..."
	arr["FRENCH",181]="Le chemin vers le fichier dictionnaire est valide. Le script peut continuer..."
	arr["CATALAN",181]="La ruta cap al fitxer de diccionari és vàlida. El script pot continuar..."
	arr["PORTUGUESE",181]="O caminho para o arquivo de dicionário é válido. O script pode continuar..."
	arr["RUSSIAN",181]="Путь до файла словаря правильный. Скрипт может продолжить..."
	arr["GREEK",181]="Το μονοπάτι για το λεξικό είναι έγκυρο. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",181]="Il percorso del file dizionario è valido. Lo script può continuare..."
	arr["POLISH",181]="Ścieżka do pliku słownika jest prawidłowa. Skrypt może kontynuować..."
	arr["GERMAN",181]="Der Pfad zur Wörterbuchdatei ist gültig. Das Skript kann fortfahren..."
	arr["TURKISH",181]="Dosya yolu geçerli. Yazılım devam edebilir..."
	arr["ARABIC",181]="...المسار إلى ملف القاموس صالح. البرنامج يمكن أن يستمر"
	arr["CHINESE",181]="字典文件的路径有效。脚本可以继续..."

	arr["ENGLISH",182]="Selected dictionary file: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["SPANISH",182]="Fichero de diccionario seleccionado: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["FRENCH",182]="Fichier dictionnaire sélectionné: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["CATALAN",182]="Fitxer de diccionari seleccionat: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["PORTUGUESE",182]="Dicionário selecionado: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["RUSSIAN",182]="Выбранный файл словаря: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["GREEK",182]="Επιλεγμένο λεξικό: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["ITALIAN",182]="File di dizionario selezionato: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["POLISH",182]="Wybrany plik słownika: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["GERMAN",182]="Ausgewählte Wörterbuchdatei: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["TURKISH",182]="Seçilen sözlük dosyası: \${pink_color}\${DICTIONARY}\${normal_color}"
	arr["ARABIC",182]="\${pink_color}\${DICTIONARY}\${blue_color} :ملف القاموس المحدد\${normal_color}"
	arr["CHINESE",182]="已选择的字典文件: \${pink_color}\${DICTIONARY}\${normal_color}"

	arr["ENGLISH",183]="You already have selected a dictionary file during this session [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["SPANISH",183]="Ya tienes seleccionado un fichero de diccionario en esta sesión [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["FRENCH",183]="Vous avez déjà sélectionné un fichier dictionnaire pour cette session \${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["CATALAN",183]="Ja tens seleccionat un fitxer de diccionari en aquesta sessió [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["PORTUGUESE",183]="Você selecionou um arquivo de dicionário nesta sessão [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["RUSSIAN",183]="Во время этой сессии вы выбрали файл словаря [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["GREEK",183]="Έχετε ήδη επιλέξει λεξικό κατά τη διάρκεια της συνεδρίας [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["ITALIAN",183]="È stato selezionato un file di dizionario in questa sessione [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["POLISH",183]="W tej sesji wybrano plik słownika [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["GERMAN",183]="Sie haben in dieser Sitzung bereits eine Wörterbuchdatei ausgewählt [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["TURKISH",183]="Bu oturumda zaten sözlük dosyası seçtiniz [\${normal_color}\${DICTIONARY}\${blue_color}]"
	arr["ARABIC",183]="[\${normal_color}\${DICTIONARY}\${blue_color}] لقد قمت بالفعل بتحديد ملف قاموس أثناء هذه الدورة"
	arr["CHINESE",183]="您在此会话期间已经选择了字典文件 [\${normal_color}\${DICTIONARY}\${blue_color}]"

	arr["ENGLISH",184]="Do you want to use this already selected dictionary file? \${normal_color}\${visual_choice}"
	arr["SPANISH",184]="¿Quieres utilizar este fichero de diccionario ya seleccionado? \${normal_color}\${visual_choice}"
	arr["FRENCH",184]="Souhaitez vous utiliser le dictionnaire déjà sélectionné? \${normal_color}\${visual_choice}"
	arr["CATALAN",184]="¿Vols fer servir aquest fitxer de diccionari ja seleccionat? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",184]="Você quer usar esse arquivo de dicionário já selecionado? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",184]="Вы хотите использовать этот уже выбранный файл словаря? \${normal_color}\${visual_choice}"
	arr["GREEK",184]="Θέλετε να χρησιμοποιήσετε το ήδη επιλεγμένο λεξικό; \${normal_color}\${visual_choice}"
	arr["ITALIAN",184]="Vuoi utilizzare questo file di dizionario già selezionato? \${normal_color}\${visual_choice}"
	arr["POLISH",184]="Czy chcesz użyć już wybraniego pliku słownika? \${normal_color}\${visual_choice}"
	arr["GERMAN",184]="Möchten Sie diese ausgewählte Wörterbuchdatei verwenden? \${normal_color}\${visual_choice}"
	arr["TURKISH",184]="Seçilen sözlük dosyasını kullanmak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",184]="\${normal_color}\${visual_choice} \${green_color}هل ترغب في استخدام القاموس المحدد بالفعل؟\${normal_color}"
	arr["CHINESE",184]="您要使用这个已选择的字典文件吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",185]="Selected BSSID: \${pink_color}None\${normal_color}"
	arr["SPANISH",185]="BSSID seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",185]="BSSID sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",185]="BSSID seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",185]="BSSID selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",185]="Выбранная BSSID: \${pink_color}Нет\${normal_color}"
	arr["GREEK",185]="Επιλεγμένο BSSID: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",185]="BSSID selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",185]="Wybrany BSSID: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",185]="Ausgewählte BSSID: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",185]="Seçilen BSSID: \${pink_color}None\${normal_color}"
	arr["ARABIC",185]="\${pink_color}None\${blue_color} :المختار BSSID\${normal_color}"
	arr["CHINESE",185]="已选择的 BSSID: \${pink_color}None\${normal_color}"

	arr["ENGLISH",186]="You already have selected a capture file during this session [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["SPANISH",186]="Ya tienes seleccionado un fichero de captura en esta sesión [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["FRENCH",186]="Vous avez déjà sélectionné un fichier de capture pour cette session \${normal_color}\${enteredpath}\${blue_color}]"
	arr["CATALAN",186]="Ja tens seleccionat un fitxer de captura en aquesta sessió [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["PORTUGUESE",186]="Você selecionou um arquivo de captura nesta sessão [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["RUSSIAN",186]="Вы уже выбрали файл захвата во время этой сессии [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GREEK",186]="Έχετε ήδη επιλέξει αρχείο καταγραφής κατά τη διάρκεια της συνεδρίας [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ITALIAN",186]="È stato selezionato un file di cattura in questa sessione [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["POLISH",186]="W tej sesji wybrano już plik przechwytywania [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["GERMAN",186]="Sie haben bereits eine Capture-Datei in dieser Sitzung ausgewählt [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["TURKISH",186]="Bu oturumda zaten bir yakalama dosyası seçtiniz [\${normal_color}\${enteredpath}\${blue_color}]"
	arr["ARABIC",186]="[\${normal_color}\${enteredpath}\${blue_color}] لقد قمت بالفعل بتحديد ملف الالتقاط أثناء هذه الدورة"
	arr["CHINESE",186]="您已经在此次脚本运行期间已经选择了一个捕获文件 [\${normal_color}\${enteredpath}\${blue_color}]"

	arr["ENGLISH",187]="Do you want to use this already selected capture file? \${normal_color}\${visual_choice}"
	arr["SPANISH",187]="¿Quieres utilizar este fichero de captura ya seleccionado? \${normal_color}\${visual_choice}"
	arr["FRENCH",187]="Souhaitez vous utiliser le fichier de capture déjà sélectionné? \${normal_color}\${visual_choice}"
	arr["CATALAN",187]="¿Vols fer servir aquest fitxer de captura ja seleccionat? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",187]="Você quer usar esse arquivo de captura selecionado? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",187]="Вы хотите использовать этот уже выбранный файл захвата? \${normal_color}\${visual_choice}"
	arr["GREEK",187]="Θέλετε να χρησιμοποιήσετε το ήδη επιλεγμένο αρχείο καταγραφής; \${normal_color}\${visual_choice}"
	arr["ITALIAN",187]="Vuoi utilizzare questo file di cattura giá selezionato? \${normal_color}\${visual_choice}"
	arr["POLISH",187]="Czy chcesz użyć już wybranego pliku przechwytywania? \${normal_color}\${visual_choice}"
	arr["GERMAN",187]="Möchten Sie diese ausgewählte Capture-Datei verwenden? \${normal_color}\${visual_choice}"
	arr["TURKISH",187]="Bu yakalama dosyasını kullanmak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",187]="\${normal_color}\${visual_choice}\${green_color} هل تريد استخدام ملف الالتقاط المحدد بالفعل؟\${normal_color}"
	arr["CHINESE",187]="您想使用这个已选择的捕获文件吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",188]="Enter the path of a captured file:"
	arr["SPANISH",188]="Introduce la ruta de un fichero de captura:"
	arr["FRENCH",188]="Entrez le chemin vers un fichier de capture:"
	arr["CATALAN",188]="Introdueix la ruta d'un fitxer de captura:"
	arr["PORTUGUESE",188]="Digite o caminho para um arquivo de captura:"
	arr["RUSSIAN",188]="Введите путь файла захвата:"
	arr["GREEK",188]="Εισάγετε το μονοπάτι για ένα αρχείο καταγραφής:"
	arr["ITALIAN",188]="Immettere il percorso di un file di cattura:"
	arr["POLISH",188]="Wprowadź ścieżkę do pliku przechwytywania:"
	arr["GERMAN",188]="Geben Sie den Pfad zu einer Capture-Datei ein:"
	arr["TURKISH",188]="Yakalama dosyasının yolunu girin:"
	arr["ARABIC",188]=":أدخل المسار إلى ملف التقاط"
	arr["CHINESE",188]="请输入捕获文件的路径:"

	arr["ENGLISH",189]="The path to the capture file is valid. Script can continue..."
	arr["SPANISH",189]="La ruta al fichero de captura es válida. El script puede continuar..."
	arr["FRENCH",189]="Le chemin du fichier de capture est valide. Le script peut continuer..."
	arr["CATALAN",189]="La ruta al fitxer de captura és vàlida. El script pot continuar..."
	arr["PORTUGUESE",189]="O caminho para o arquivo de captura é válido. O script pode continuar..."
	arr["RUSSIAN",189]="Путь до файла захвата верен. Скрипт может продолжать..."
	arr["GREEK",189]="Το μονοπάτι για το αρχείο καταγραφής είναι έγκυρο. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",189]="Il percorso del file di cattura è valido. Lo script può continuare..."
	arr["POLISH",189]="Ścieżka do pliku przechwytywania jest prawidłowa. Skrypt może kontynuować..."
	arr["GERMAN",189]="Der Pfad zur Capture-Datei ist gültig. Das Skript kann fortfahren..."
	arr["TURKISH",189]="Yakalama dosyasının yolu doğru. Yazılım devam edebilir..."
	arr["ARABIC",189]="...المسار إلى ملف الالتقاط صالح. البرنامج يمكن أن يستمر"
	arr["CHINESE",189]="已找到有效的捕获文件。脚本可以继续..."

	arr["ENGLISH",190]="Starting decrypt. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",190]="Comenzando descifrado. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",190]="Lancement du crack. Pressez [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",190]="Començant el desxifrat. Un cop començat, premeu [Ctrl+C] per aturar-lo..."
	arr["PORTUGUESE",190]="Começando a descriptografar. Uma vez iniciado, pressione [Ctrl+C] para parar..."
	arr["RUSSIAN",190]="Начало расшифровки. После запуска, нажмите [Ctrl+C] для остановки..."
	arr["GREEK",190]="Γίνεται έναρξη αποκρυπτογράφησης. Όταν ξεκινήσει, πατήστε [Ctrl+C] για να σταματήσει..."
	arr["ITALIAN",190]="Cominciando a decifrare. Una volta avviato, premere [Ctrl+C] per fermare..."
	arr["POLISH",190]="Uruchamianie odszyfrowania. Naciśnij [Ctrl+C] w trakcie trwania aby go zatrzymać..."
	arr["GERMAN",190]="Entschlüsselung starten. Nach dem Start drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",190]="Şifre çözme başlıyor. Başladıktan sonra, durdurmak için [Ctrl+C] basınız..."
	arr["ARABIC",190]="...للإيقاف [Ctrl+C] بدء فك تشفير. عند البدء ، اضغط على"
	arr["CHINESE",190]="准备开始暴破。启动后，按 [Ctrl+C] 停止..."

	arr["ENGLISH",191]="\${blue_color}airgeddon can't find the directory path where you have BeEF installed. \${green_color}Do you want to enter it manually? \${normal_color}\${visual_choice}"
	arr["SPANISH",191]="\${blue_color}airgeddon no ha podido encontrar la ruta del directorio donde tienes instalado BeEF. \${green_color}¿Quieres introducirla manualmente? \${normal_color}\${visual_choice}"
	arr["FRENCH",191]="\${blue_color}airgeddon n'a pas trouvé le dossier qui contient BeEF. \${green_color}Voulez-vous l'indiquer manuellement? \${normal_color}\${visual_choice}"
	arr["CATALAN",191]="\${blue_color}airgeddon no ha pogut trobar la ruta del directori on tens instal·lat BeEF. \${green_color}¿Vols introduir-la manualment? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",191]="\${blue_color}O airgeddon não conseguiu encontrar o diretório onde você instalou o BeEF. \${green_color}Você quer inseri-lo manualmente? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",191]="\${blue_color}airgeddon не может найти путь к каталогу, где вы установили BeEF. \${green_color}Вы хотите ввести его вручную? \${normal_color}\${visual_choice}"
	arr["GREEK",191]="\${blue_color}Το airgeddon δεν μπορεί να βρει το μονοπάτι για τον κατάλογο όπου έχετε εγκαταστημένο το BeEF. \${green_color}Θέλετε να το εισάγετε χειροκίνητα; \${normal_color}\${visual_choice}"
	arr["ITALIAN",191]="\${blue_color}airgeddon non ha potuto trovare il percorso della directory in cui è stato installato BeEF. \${green_color}Vuoi inserirlo manualmente? \${normal_color}\${visual_choice}"
	arr["POLISH",191]="\${blue_color}airgeddon nie mógł znaleźć ścieżki, w której zainstalowano BeEF. \${green_color}Czy chcesz ją wprowadzić ręcznie? \${normal_color}\${visual_choice}"
	arr["GERMAN",191]="\${blue_color}airgeddon konnte den Verzeichnispfad, in den BeEF installiert ist, nicht finden. \${green_color}Möchten Sie es manuell eingeben? \${normal_color}\${visual_choice}"
	arr["TURKISH",191]="\${blue_color}airgeddon BeEF yazılımının kurulu olduğu dizini bulamadı. \${green_color}Elle girmek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",191]="\${normal_color}\${visual_choice} \${green_color}هل تريد إدخاله يدويًا؟\${blue_color}.BeEF من العثور على مسار الدليل حيث تم تثبيت airgeddon لم يتمكن\${normal_color}"
	arr["CHINESE",191]="\${blue_color}airgeddon 找不到您 BeEF 的安装路径。 \${green_color}您要手动输入吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",192]="You already have selected a BSSID during this session and is present in capture file [\${normal_color}\${bssid}\${blue_color}]"
	arr["SPANISH",192]="Ya tienes seleccionado un BSSID en esta sesión y está presente en el fichero de captura [\${normal_color}\${bssid}\${blue_color}]"
	arr["FRENCH",192]="Vous avez déjà sélectionné un BSSID pour la session en cours et est présent dans le fichier de capture \${normal_color}\${bssid}\${blue_color}]"
	arr["CATALAN",192]="Ja tens seleccionat un BSSID en aquesta sessió i està present en el fitxer de captura [\${normal_color}\${bssid}\${blue_color}]"
	arr["PORTUGUESE",192]="Você selecionou um BSSID nesta sessão que está presente no arquivo de captura [\${normal_color}\${bssid}\${blue_color}]"
	arr["RUSSIAN",192]="У вас уже есть выбранная во время этой сессии BSSID и она присутствует в файле захвата [\${normal_color}\${bssid}\${blue_color}]"
	arr["GREEK",192]="Έχετε ήδη επιλέξει BSSID κατά τη διάρκεια της συνεδρίας και βρίσκεται στο αρχείο καταγραφής [\${normal_color}\${bssid}\${blue_color}]"
	arr["ITALIAN",192]="È stato selezionato un BSSID in questa sessione che è giá presente nel file di cattura [\${normal_color}\${bssid}\${blue_color}]"
	arr["POLISH",192]="Wybrano już BSSID w tej sesji i jest on obecny w pliku przechwytywania [\${normal_color}\${bssid}\${blue_color}]"
	arr["GERMAN",192]="Sie haben in dieser Sitzung bereits eine BSSID ausgewählt, die in der Erfassungsdatei vorhanden ist [\${normal_color}\${bssid}\${blue_color}]"
	arr["TURKISH",192]="Bu oturum sırasında zaten bir BSSID seçtiniz ve yakalama dosyasında mevcut [\${normal_color}\${bssid}\${blue_color}]"
	arr["ARABIC",192]="[\${normal_color}\${bssid}\${blue_color}] وموجود في ملف الالتقاط ،خلال هذه الدورة BSSIDلديك بالفعل اختيار"
	arr["CHINESE",192]="您已经在此次脚本运行期间已经选择了一个 BSSID，并且存在于捕获文件中 [\${normal_color}\${bssid}\${blue_color}]"

	arr["ENGLISH",193]="Do you want to use this already selected BSSID? \${normal_color}\${visual_choice}"
	arr["SPANISH",193]="¿Quieres utilizar este BSSID ya seleccionado? \${normal_color}\${visual_choice}"
	arr["FRENCH",193]="Souhaitez vous utiliser le BSSID déjà sélectionné? \${normal_color}\${visual_choice}"
	arr["CATALAN",193]="¿Vols fer servir aquest BSSID ja seleccionat? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",193]="Você quer usar este BSSID já selecionado? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",193]="Вы хотите использовать эту уже выбранную BSSID? \${normal_color}\${visual_choice}"
	arr["GREEK",193]="Θέλετε να χρησιμοποιήσετε το ήδη επιλεγμένο BSSID; \${normal_color}\${visual_choice}"
	arr["ITALIAN",193]="Vuoi usare questo BSSID già selezionato? \${normal_color}\${visual_choice}"
	arr["POLISH",193]="Czy chcesz użyć już wybranego BSSID? \${normal_color}\${visual_choice}"
	arr["GERMAN",193]="Möchten Sie diese ausgewählte BSSID verwenden? \${normal_color}\${visual_choice}"
	arr["TURKISH",193]="Seçilen BSSID ile devam etmek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",193]="\${normal_color}\${visual_choice} \${green_color}المحدد بالفعل؟ BSSID هل تريد استخدام هذا\${normal_color}"
	arr["CHINESE",193]="您想使用这个已经选择的 BSSID 吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",194]="Enter the minimum length of the key to decrypt (\${minlength_text}-63):"
	arr["SPANISH",194]="Introduce la longitud mínima de la clave a descifrar (\${minlength_text}-63):"
	arr["FRENCH",194]="Entrez la longueur minimale de la clef à cracker (\${minlength_text}-63):"
	arr["CATALAN",194]="Introdueix la longitud mínima de la clau a desxifrar (\${minlength_text}-63):"
	arr["PORTUGUESE",194]="Digite o comprimento mínimo da senha para descriptografar (\${minlength_text}-63):"
	arr["RUSSIAN",194]="Введите минимальную длину ключа для расшифровки (\${minlength_text}-63):"
	arr["GREEK",194]="Εισάγετε το ελάχιστο μήκος κλειδιού για αποκρυπτογράφηση (\${minlength_text}-63):"
	arr["ITALIAN",194]="Inserire la lunghezza minima della chiave da decifrare (\${minlength_text}-63):"
	arr["POLISH",194]="Wpisz minimalną długość klucza do odszyfrowania (\${minlength_text}-63):"
	arr["GERMAN",194]="Geben Sie die Mindestlänge des zu entschlüsselnden Schlüssels ein (\${minlength_text}-63):"
	arr["TURKISH",194]="Şifreyi çözmek için anahtarın minimum uzunluğunu girin (\${minlength_text}-63):"
	arr["ARABIC",194]="(\${minlength_text}-63): أدخل طول الحد الأدنى من مفتاح فك"
	arr["CHINESE",194]="请输入要解密的密钥的最小长度 (\${minlength_text}-63):"

	arr["ENGLISH",195]="Enter the maximum length of the key to decrypt (\${minlength}-63):"
	arr["SPANISH",195]="Introduce la longitud máxima de la clave a descifrar (\${minlength}-63):"
	arr["FRENCH",195]="Entrez la longueur maximale de la clef à cracker (\${minlength}-63):"
	arr["CATALAN",195]="Introdueix la longitud màxima de la clau a desxifrar (\${minlength}-63):"
	arr["PORTUGUESE",195]="Digite o comprimento máximo da senha para descriptografar (\${minlength}-63):"
	arr["RUSSIAN",195]="Введите максимальную длину ключа для расшифровки (\${minlength}-63):"
	arr["GREEK",195]="Εισάγετε το μέγιστο μήκος κλειδιού για αποκρυπτογράφηση (\${minlength}-63):"
	arr["ITALIAN",195]="Inserire la lunghezza massima della chiave da decifrare (\${minlength}-63):"
	arr["POLISH",195]="Wpisz maksymalną długość klucza do odszyfrowania (\${minlength}-63):"
	arr["GERMAN",195]="Geben Sie die maximale Länge des zu entschlüsselnden Schlüssels ein (\${minlength}-63):"
	arr["TURKISH",195]="Şifreyi çözmek için anahtarın maximum uzunluğunu girin (\${minlength}-63):"
	arr["ARABIC",195]="(\${minlength}-63) :أدخل الحد الأقصى لطول مفتاح فك"
	arr["CHINESE",195]="请输入要解密的密钥的最大长度 (\${minlength}-63):"

	arr["ENGLISH",196]="Select the character set to use:"
	arr["SPANISH",196]="Selecciona el juego de caracteres a utilizar:"
	arr["FRENCH",196]="Sélectionnez le jeu de caractères à utiliser:"
	arr["CATALAN",196]="Selecciona el joc de caràcters a utilitzar:"
	arr["PORTUGUESE",196]="Selecione o conjunto de caracteres a ser usado:"
	arr["RUSSIAN",196]="Выберите набор символов для использования:"
	arr["GREEK",196]="Επιλέξτε το σετ χαρακτήρων που θα χρησιμοποιηθεί:"
	arr["ITALIAN",196]="Selezionare il set di caratteri da utilizzare:"
	arr["POLISH",196]="Wybierz zestaw znaków do użycia:"
	arr["GERMAN",196]="Wählen Sie den Zeichensatz zu verwenden aus:"
	arr["TURKISH",196]="Kullanılacak karakter kümesini seçin:"
	arr["ARABIC",196]=":حدد مجموعة الأحرف المراد استخدامها"
	arr["CHINESE",196]="请选择要使用的字符集:"

	arr["ENGLISH",197]="1.  Lowercase chars"
	arr["SPANISH",197]="1.  Caracteres en minúsculas"
	arr["FRENCH",197]="1.  Lettres minuscules"
	arr["CATALAN",197]="1.  Caràcters en minúscules"
	arr["PORTUGUESE",197]="1.  Caracteres minúsculos"
	arr["RUSSIAN",197]="1.  Символы нижнего регистра"
	arr["GREEK",197]="1.  Πεζά"
	arr["ITALIAN",197]="1.  Caratteri minuscoli"
	arr["POLISH",197]="1.  Małe litery"
	arr["GERMAN",197]="1.  Zeichen in Kleinbuchstaben"
	arr["TURKISH",197]="1.  Küçük harfli karakterler"
	arr["ARABIC",197]="1.  أحرف صغيرة"
	arr["CHINESE",197]="1.  小写字符"

	arr["ENGLISH",198]="2.  Uppercase chars"
	arr["SPANISH",198]="2.  Caracteres en mayúsculas"
	arr["FRENCH",198]="2.  Lettres majuscules"
	arr["CATALAN",198]="2.  Caràcters en majúscules"
	arr["PORTUGUESE",198]="2.  Caracteres maiúsculos"
	arr["RUSSIAN",198]="2.  Символы верхнего регистра"
	arr["GREEK",198]="2.  Κεφαλαία"
	arr["ITALIAN",198]="2.  Caratteri maiuscoli"
	arr["POLISH",198]="2.  Wielkie litery"
	arr["GERMAN",198]="2.  Zeichen in Großbuchstaben"
	arr["TURKISH",198]="2.  Büyük harfli karakterler"
	arr["ARABIC",198]="2.  أحرف كبيرة"
	arr["CHINESE",198]="2.  大写字符"

	arr["ENGLISH",199]="3.  Numeric chars"
	arr["SPANISH",199]="3.  Caracteres numéricos"
	arr["FRENCH",199]="3.  Chiffres"
	arr["CATALAN",199]="3.  Caràcters numèrics"
	arr["PORTUGUESE",199]="3.  Caracteres numéricos"
	arr["RUSSIAN",199]="3.  Цифры"
	arr["GREEK",199]="3.  Αριθμοί"
	arr["ITALIAN",199]="3.  Caratteri numerici"
	arr["POLISH",199]="3.  Cyfry"
	arr["GERMAN",199]="3.  Numerische Zeichen"
	arr["TURKISH",199]="3.  Numerik karakterler"
	arr["ARABIC",199]="3.  أرقام"
	arr["CHINESE",199]="3.  数字字符"

	arr["ENGLISH",200]="4.  Symbol chars"
	arr["SPANISH",200]="4.  Caracteres símbolos"
	arr["FRENCH",200]="4.  Symboles"
	arr["CATALAN",200]="4.  Caràcters símbols"
	arr["PORTUGUESE",200]="4.  Símbolos"
	arr["RUSSIAN",200]="4.  Символы"
	arr["GREEK",200]="4.  Σύμβολα"
	arr["ITALIAN",200]="4.  Simboli"
	arr["POLISH",200]="4.  Symbole"
	arr["GERMAN",200]="4.  Zeichensymbole"
	arr["TURKISH",200]="4.  Sembol karakterler"
	arr["ARABIC",200]="4.  رموز"
	arr["CHINESE",200]="4.  符号字符"

	arr["ENGLISH",201]="5.  Lowercase + uppercase chars"
	arr["SPANISH",201]="5.  Caracteres en minúsculas + mayúsculas"
	arr["FRENCH",201]="5.  Lettres minuscules + majuscules"
	arr["CATALAN",201]="5.  Caràcters en minúscules + majúscules"
	arr["PORTUGUESE",201]="5.  Caracteres minúsculos + maiúsculos"
	arr["RUSSIAN",201]="5.  Буквы верхнего + нижнего регистра"
	arr["GREEK",201]="5.  Πεζά + κεφαλαία"
	arr["ITALIAN",201]="5.  Caratteri minuscoli + maiuscoli"
	arr["POLISH",201]="5.  Małe + wielkie litery"
	arr["GERMAN",201]="5.  Zeichen in Klein- und Großbuchstaben"
	arr["TURKISH",201]="5.  Küçük + büyük harfli karakterler"
	arr["ARABIC",201]="5.  أحرف صغيرة + كبيرة"
	arr["CHINESE",201]="5.  小写+大写字符"

	arr["ENGLISH",202]="6.  Lowercase + numeric chars"
	arr["SPANISH",202]="6.  Caracteres en minúsculas + numéricos"
	arr["FRENCH",202]="6.  Lettres minuscules + chiffres"
	arr["CATALAN",202]="6.  Caràcters en minúscules + numèrics"
	arr["PORTUGUESE",202]="6.  Caracteres minúsculos + números"
	arr["RUSSIAN",202]="6.  Буквы нижнего регистра + цифры"
	arr["GREEK",202]="6.  Πεζά + αριθμοί"
	arr["ITALIAN",202]="6.  Caratteri minuscoli + numerici"
	arr["POLISH",202]="6.  Małe litery + cyfry"
	arr["GERMAN",202]="6.  Zeichen in Kleinbuchstaben + numerisch"
	arr["TURKISH",202]="6.  Küçük harf + numerik karakterler"
	arr["ARABIC",202]="6.  أحرف صغيرة + أرقام"
	arr["CHINESE",202]="6.  小写+数字字符"

	arr["ENGLISH",203]="7.  Uppercase + numeric chars"
	arr["SPANISH",203]="7.  Caracteres en mayúsculas + numéricos"
	arr["FRENCH",203]="7.  Lettres majuscules + chiffres"
	arr["CATALAN",203]="7.  Caràcters en majúscules + numèrics"
	arr["PORTUGUESE",203]="7.  Caracteres maiúsculos + números"
	arr["RUSSIAN",203]="7.  Буквы верхнего регистра + цифры"
	arr["GREEK",203]="7.  Κεφαλαία + αριθμοί"
	arr["ITALIAN",203]="7.  Caratteri numerici + maiuscoli"
	arr["POLISH",203]="7.  Wielkie litery + cyfry"
	arr["GERMAN",203]="7.  Zeichen in Großbuchstaben + Zahlen"
	arr["TURKISH",203]="7.  Büyük harf + numerik karakterler"
	arr["ARABIC",203]="7.  أحرف كبيرة + أرقام"
	arr["CHINESE",203]="7.  大写+数字字符"

	arr["ENGLISH",204]="8.  Symbol + numeric chars"
	arr["SPANISH",204]="8.  Caracteres símbolos + numéricos"
	arr["FRENCH",204]="8.   Symboles + chiffres"
	arr["CATALAN",204]="8.  Caràcters símbols + numèrics"
	arr["PORTUGUESE",204]="8.  Símbolos + números"
	arr["RUSSIAN",204]="8.  Символы + цифры"
	arr["GREEK",204]="8.  Σύμβολα + αριθμοί"
	arr["ITALIAN",204]="8.  simboli + numeri"
	arr["POLISH",204]="8.  Cyfry + symbole"
	arr["GERMAN",204]="8.  Symbole + Ziffern"
	arr["TURKISH",204]="8.  Sembol + numerik karakterler"
	arr["ARABIC",204]="8.  رموز+ أرقام"
	arr["CHINESE",204]="8.  符号+数字字符"

	arr["ENGLISH",205]="9.  Lowercase + uppercase + numeric chars"
	arr["SPANISH",205]="9.  Caracteres en minúsculas + mayúsculas + numéricos"
	arr["FRENCH",205]="9.  Lettres minuscules et majuscules + chiffres"
	arr["CATALAN",205]="9.  Caràcters en minúscules + majúscules + numèrics"
	arr["PORTUGUESE",205]="9.  Caracteres minúsculos + maiúsculos + números"
	arr["RUSSIAN",205]="9.  Буквы нижнего регистра + верхнего регистра + цифры"
	arr["GREEK",205]="9.  Πεζά + κεφαλαία + αριθμοί"
	arr["ITALIAN",205]="9.  Caratteri minuscoli + maiuscoli + numeri"
	arr["POLISH",205]="9.  Małe litery + wielkie litery + cyfry"
	arr["GERMAN",205]="9.  Zeichen in Kleinbuchstaben + Großbuchstaben + Ziffern"
	arr["TURKISH",205]="9.  Küçük + büyük harf + numerik karakterler"
	arr["ARABIC",205]="9.  أحرف صغيرة + أحرف كبيرة + أرقام"
	arr["CHINESE",205]="9.  小写+大写+数字字符"

	arr["ENGLISH",206]="10. Lowercase + uppercase + symbol chars"
	arr["SPANISH",206]="10. Caracteres en minúsculas + mayúsculas + símbolos"
	arr["FRENCH",206]="10. Lettres minuscules et majuscules + symboles"
	arr["CATALAN",206]="10. Caràcters en minúscules + majúscules + símbols"
	arr["PORTUGUESE",206]="10. Caracteres minúsculos + maiúsculos + símbolos"
	arr["RUSSIAN",206]="10. Буквы нижнего регистра + верхнего регистра + символы"
	arr["GREEK",206]="10. Πεζά + κεφαλαία + σύμβολα"
	arr["ITALIAN",206]="10. Caratteri minuscoli + maiuscoli + simboli"
	arr["POLISH",206]="10. Małe litery + wielkie + symbole"
	arr["GERMAN",206]="10. Zeichen in Kleinbuchstaben + Großbuchstaben + Symbole"
	arr["TURKISH",206]="10. Küçük + büyük harf + sembol karakterler"
	arr["ARABIC",206]="10. أأحرف صغيرة + أحرف كبيرة + رموز"
	arr["CHINESE",206]="10. 小写+大写+符号字符"

	arr["ENGLISH",207]="11. Lowercase + uppercase + numeric + symbol chars"
	arr["SPANISH",207]="11. Caracteres en minúsculas + mayúsculas + numéricos + símbolos"
	arr["FRENCH",207]="11. Lettres minuscules et majuscules + chiffres + symboles"
	arr["CATALAN",207]="11. Caràcters en minúscules + majúscules + numèrics + símbols"
	arr["PORTUGUESE",207]="11. Caracteres minúsculos + maiúsculos + números + símbolos"
	arr["RUSSIAN",207]="11. Буквы нижнего регистра + верхнего регистра + цифры + символы"
	arr["GREEK",207]="11. Πεζά + κεφαλαία + αριθμοί + σύμβολα"
	arr["ITALIAN",207]="11. Caratteri minuscoli + maiuscoli + numeri + simboli"
	arr["POLISH",207]="11. Małe litery + wielkie litery + cyfry + symbole"
	arr["GERMAN",207]="11. Zeichen in Kleinbuchstaben + Großbuchstaben + Ziffern + Symbole"
	arr["TURKISH",207]="11. Küçük + büyük harf + numerik + sembol karakterler"
	arr["ARABIC",207]="11. أحرف صغيرة + أحرف كبيرة + أرقام + رموز"
	arr["CHINESE",207]="11. 小写+大写+数字+符号字符"

	arr["ENGLISH",208]="If you choose a big charset and a long key length, the process could take so much time"
	arr["SPANISH",208]="Si eliges un juego de caracteres amplio y una longitud de clave grande, el proceso podría demorarse mucho tiempo"
	arr["FRENCH",208]="Si vous choisissez un jeu de caractères ample et une longitude de clef importante, le processus pourrait prendre beaucoup de temps"
	arr["CATALAN",208]="Si tries un joc de caràcters ampli i una longitud de clau gran, el procés podria demorar-se molt temps"
	arr["PORTUGUESE",208]="Se você escolher um grande conjunto de caracteres e um grande comprimento da senha, o processo pode levar um longo tempo"
	arr["RUSSIAN",208]="Если вы выберете большой набор символов и большую длинну ключа, процесс может занять очень много времени"
	arr["GREEK",208]="Αν επιλέξετε μεγάλη συμβολοσειρά και μεγάλο μήκος κλειδιού, η διεργασία θα διαρκέσει αρκετά"
	arr["ITALIAN",208]="Se si sceglie un set di caratteri grande e una grande lunghezza della chiave, il processo potrebbe richiedere molto tempo"
	arr["POLISH",208]="Jeśli wybierzesz duży zestaw znaków i dużą długość klucza, proces może potrwać bardzo długo"
	arr["GERMAN",208]="Wenn Sie einen breiten Zeichensatz und eine große Schlüssellänge auswählen, kann der Vorgang sehr lange dauern"
	arr["TURKISH",208]="Büyük bir karakter kümesi ve uzun bir anahtar uzunluğu seçerseniz, süreç çok zaman alabilir"
	arr["ARABIC",208]="إذا اخترت مجموعة أحرف كبيرة وطول مفتاح طويل ، فقد تستغرق العملية الكثير من الوقت"
	arr["CHINESE",208]="如果你选择一个较大的字符集和一个较长的密钥长度，那么这个破解过程可能会花费很多时间"

	arr["ENGLISH",209]="The charset to use is: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["SPANISH",209]="El juego de caracteres elegido es: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["FRENCH",209]="Le jeu de caractères définit est: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["CATALAN",209]="El joc de caràcters escollit és: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["PORTUGUESE",209]="Conjunto de caracteres escolhido: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["RUSSIAN",209]="Символы для использования: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["GREEK",209]="Η συμβολοσειρά που θα χρησιμοποιηθεί είναι: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["ITALIAN",209]="Il set di caratteri scelto è: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["POLISH",209]="Wybrany zestaw znaków to: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["GERMAN",209]="Der gewählte Zeichensatz ist: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["TURKISH",209]="Kullanılacak karakter kümesi: [\${normal_color}\${showcharset}\${blue_color}]"
	arr["ARABIC",209]="[\${normal_color}\${showcharset}\${blue_color}] :مجموعة الأحرف المراد استخدامها هي"
	arr["CHINESE",209]="要使用的字符集是: [\${normal_color}\${showcharset}\${blue_color}]"

	arr["ENGLISH",210]="The script will check for internet access looking for a newer version. Please be patient..."
	arr["SPANISH",210]="El script va a comprobar si tienes acceso a internet para ver si existe una nueva versión. Por favor ten paciencia..."
	arr["FRENCH",210]="Le script va vérifier que vous aillez accès à internet pour voir si une nouvelle version du script est disponible. Soyez patients s'il vous plaît..."
	arr["CATALAN",210]="El script va a comprovar si tens accés a internet per veure si hi ha una nova versió. Si us plau té paciència..."
	arr["PORTUGUESE",210]="O script irá verificar se você tem acesso à internet para ver se há uma nova versão. Por favor, seja paciente..."
	arr["RUSSIAN",210]="Скрипт проверит доступ в Интернет для поиска новой версии. Подождите немного..."
	arr["GREEK",210]="Το script θα ελέγξει αν έχετε πρόσβαση στο διαδίκτυο και έπειτα για νεότερη έκδοση. Παρακαλώ κάντε υπομονή..."
	arr["ITALIAN",210]="Lo script controllerà se si ha accesso a internet per vedere se c'è una nuova versione. Si prega di essere pazienti..."
	arr["POLISH",210]="Skrypt sprawdzi, czy masz dostęp do internetu i czy jest nowa wersja. Cierpliwości..."
	arr["GERMAN",210]="Das Skript überprüft, ob Sie Zugriff auf das Internet haben, um zu sehen, ob eine neue Version existiert. Wir bitten um Geduld..."
	arr["TURKISH",210]="Yazılım, daha yeni bir sürümü arayan internet erişimini kontrol edecektir. Lütfen sabırlı olun..."
	arr["ARABIC",210]="...سيتحقق البرنامج من الوصول إلى الإنترنت بحثًا عن إصدار أحدث. يرجى التحلي بالصبر"
	arr["CHINESE",210]="脚本将访问互联网以检查是否有新版本。请耐心等待..."

	arr["ENGLISH",211]="It seems you have no internet access. The script can't connect to repository. It will continue without updating..."
	arr["SPANISH",211]="Parece que no tienes conexión a internet. El script no puede conectar al repositorio. Continuará sin actualizarse..."
	arr["FRENCH",211]="Il semble que vous ne pouvez pas vous connecter à internet. Impossible dans ces conditions de pouvoir accéder aux dépôts. Le script va donc s’exécuter sans s'actualiser..."
	arr["CATALAN",211]="Sembla que no tens connexió a internet. El script no pot connectar al repositori. Continuarà sense actualitzar-se..."
	arr["PORTUGUESE",211]="Parece que você não tem acesso à internet. O script não pode conectar-se ao repositório. Ele continuará sem atualizar..."
	arr["RUSSIAN",211]="Кажется, у вас нет доступа в Интернет. Скрипт не может подключится к репозиторию. Он продолжит без обновления..."
	arr["GREEK",211]="Φαίνεται πως δεν έχετε πρόσβαση στο διαδίκτυο. Το script δεν μπορεί να συνδεθεί στο αποθετήριο. Θα συνεχίσει χωρίς να έχει ενημερωθεί..."
	arr["ITALIAN",211]="Sembra che tu non abbia alcuna connessione a internet. Lo script non riesce a connettersi al repository. Continuerà senza aggiornarsi..."
	arr["POLISH",211]="Wygląda na to, że nie masz połączenia z internetem. Skrypt nie może połączyć się z repozytorium. Kontynuacja bez aktualizacji..."
	arr["GERMAN",211]="Es scheint, dass Sie keine Internetverbindung haben. Das Skript kann keine Verbindung zum Repository herstellen. Es wird ohne Aktualisierung fortgesetzt..."
	arr["TURKISH",211]="İnternet bağlantınız yok. Yazılım depoya bağlanamadı. Güncelleme olmadan devam edilecek..."
	arr["ARABIC",211]="...يبدو أنه ليس لديك اتصال بالإنترنت. البرنامج لا يمكنه الاتصال بالمستودع. سيستمر دون تحديث"
	arr["CHINESE",211]="该脚本似乎无法连接到 GitHub，这可能与您的网络环境有关。您可以自行访问 GitHub 上 airgeddon 的代码仓库并手动检查更新..."

	arr["ENGLISH",212]="The script is already in the latest version. It doesn't need to be updated"
	arr["SPANISH",212]="El script ya está en la última versión. No necesita ser actualizado"
	arr["FRENCH",212]="La dernière version du script est déjà installée. Pas de mise à jour possible"
	arr["CATALAN",212]="El script ja està en l'última versió. No necessita ser actualitzat"
	arr["PORTUGUESE",212]="O script já está na versão mais recente. Ele não necessita ser atualizado"
	arr["RUSSIAN",212]="Скрипт уже последней версии, обновление не требуется"
	arr["GREEK",212]="Το script είναι ήδη στην τελευταία έκδοση. Δεν χρειάζεται να ενημερωθεί"
	arr["ITALIAN",212]="Lo script è già alla sua ultima versione. Non c'è bisogno di aggiornamenti"
	arr["POLISH",212]="Skrypt jest już w najnowszej wersji. Nie ma potrzeby aktualizacji"
	arr["GERMAN",212]="Das Skript ist bereits in der neuesten Version. Es muss nicht aktualisiert werden"
	arr["TURKISH",212]="Yazılım zaten en son sürüm. Güncellemeye gerek yok"
	arr["ARABIC",212]="البرنامج موجود بالفعل في أحدث إصدار. لا يحتاج إلى التحديث"
	arr["CHINESE",212]="该脚本已经是最新版本。无需更新"

	arr["ENGLISH",213]="A new version of the script exists (v\${airgeddon_last_version}). It will be downloaded"
	arr["SPANISH",213]="Existe una nueva versión del script (v\${airgeddon_last_version}). Será descargada"
	arr["FRENCH",213]="Une nouvelle version du script est disponible (v\${airgeddon_last_version}). Lancement du téléchargement"
	arr["CATALAN",213]="Hi ha una nova versió dels script (v\${airgeddon_last_version}). Serà descarregada"
	arr["PORTUGUESE",213]="Existe uma nova versão do script (v\${airgeddon_last_version}). Download será iniciado"
	arr["RUSSIAN",213]="Существует новая версия скрипта (v\${airgeddon_last_version}). Она будет загружена"
	arr["GREEK",213]="Υπάρχει νεότερη έκδοση του script (v\${airgeddon_last_version}). Θα κατέβει"
	arr["ITALIAN",213]="Esiste una nuova versione dello script (v\${airgeddon_last_version}). Sarà scaricata"
	arr["POLISH",213]="Jest nowa wersja skryptu (v\${airgeddon_last_version}). Zostanie ona pobrana"
	arr["GERMAN",213]="Es gibt eine neue Version des Skripts (v\${airgeddon_last_version}). Sie wird automatisch heruntergeladet"
	arr["TURKISH",213]="Yazılımın yeni bir sürümü mevcut (v\${airgeddon_last_version}). İndirilecek"
	arr["ARABIC",213]="سيتم تنزيله .(v\${airgeddon_last_version}) يوجد إصدار جديد من البرنامج"
	arr["CHINESE",213]="存在新版本的脚本 (v\${airgeddon_last_version})。它将被下载"

	arr["ENGLISH",214]="The new version was successfully downloaded. The script will be launched again"
	arr["SPANISH",214]="La nueva versión se ha descargado con éxito. El script se lanzará de nuevo"
	arr["FRENCH",214]="Le téléchargement de la dernière version du script a réussit. Le script a été lancé à nouveau"
	arr["CATALAN",214]="La nova versió s'ha descarregat amb èxit. El script es llençarà de nou"
	arr["PORTUGUESE",214]="A nova versão foi baixado com sucesso. O script será carregado novamente"
	arr["RUSSIAN",214]="Новая версия успешно загружена. Скрипт будет перезапущен"
	arr["GREEK",214]="Η νεότερη έκδοση κατέβηκε επιτυχώς. Το script θα επανεκκινηθεί"
	arr["ITALIAN",214]="La nuova versione è stata scaricata con successo. Lo script sarà lanciato di nuovo"
	arr["POLISH",214]="Nowa wersja została pobrana pomyślnie. Skrypt zostanie uruchomiony ponownie"
	arr["GERMAN",214]="Die neue Version wurde erfolgreich heruntergeladen. Das Skript wird erneut gestartet"
	arr["TURKISH",214]="Yeni sürüm başarıyla indirildi. Yazılım yeniden başlatılacak"
	arr["ARABIC",214]="تم تنزيل الإصدار الجديد بنجاح. سيتم إطلاق البرنامج مرة أخرى"
	arr["CHINESE",214]="新版本已成功下载。脚本将再次启动"

	arr["ENGLISH",215]="Chosen action can be carried out only over WPA/WPA2 networks, however WPA3 has been included in the scan filter because these networks sometimes work in \"Mixed mode\" offering WPA2/WPA3 and in that case they are displayed in the scan window as WPA3. So WPA3 networks will appear but then airgeddon will analyze them after scan to allow you select only those that also offering WPA2"
	arr["SPANISH",215]="La acción que has elegido realizar solo se puede llevar a cabo sobre redes WPA/WPA2, no obstante en el filtro de escaneo se ha incluido WPA3 ya que estas redes a veces funcionan en \"Mixed mode\" ofreciendo WPA2/WPA3 y cuando es el caso son mostradas en la ventana de escaneo como WPA3. Es decir, que aparecerán redes WPA3 pero luego airgeddon las analizará tras el escaneo para dejarte seleccionar solo aquellas que ofrezcan también WPA2"
	arr["FRENCH",215]="L'action que vous avez choisi ne peut pas être effectuée sur réseaux WPA/WPA2. Cependant WPA3 a été inclus dans le filtre d'analyse parce que ces réseaux fonctionnent parfois en \"Mixed mode\" offrant WPA2/WPA3. Quand c'est le cas, ils sont affichés dans la fenêtre de numérisation en tant que WPA3. C'est-à-dire, les réseaux WPA3 apparaîtront et airgeddon les analysera ensuite après l'analyse pour vous permettre de sélectionner uniquement ceux qui offrent également WPA2"
	arr["CATALAN",215]="L'acció que has triat realitzar només es pot dur a terme sobre xarxes WPA/WPA2, no obstant això al filtre d'escaneig s'ha inclòs WPA3 ja que aquestes xarxes de vegades funcionen a \"Mixed mode\" oferint WPA2/WPA3 i quan és el cas són mostrades a la finestra d'escaneig com WPA3. És a dir, que apareixeran xarxes WPA3 però després airgeddon les analitzarà després de l'escaneig per deixar-te seleccionar només aquelles que ofereixin també WPA2"
	arr["PORTUGUESE",215]="A ação que você escolheu só pode ser realizada em redes WPA/WPA2, no entanto, o WPA3 foi adicionado ao filtro, pois essas redes podem operar em \"Mixed mode\" oferecendo WPA2/WPA3, quando esse for o caso elas são exibidos na janela de busca como WPA3. Embora as redes WPA3 apareçam o airgeddon as analisará após a busca para permitir que você selecione apenas aquelas que também oferecem WPA2"
	arr["RUSSIAN",215]="Выбранное действие может быть исполнено только в WPA/WPA2 сетях, однако WPA3 был включен в фильтр сканирования, поскольку эти сети иногда работают в \"Mixed mode\", предлагая WPA2/WPA3, при этом, отображаясь в окне сканирования как WPA3. То есть сети WPA3 появятся, но после сканирования airgeddon проанализирует их, чтобы позволить вам выбрать только те, которые также предлагают WPA2"
	arr["GREEK",215]="Η ενέργεια που επιλέξατε μπορεί να εκτελεστεί μόνο σε δίκτυα WPA/WPA2, ωστόσο το WPA3 έχει συμπεριληφθεί στο φίλτρο σάρωσης, καθώς αυτά τα δίκτυα μερικές φορές λειτουργούν σε \"Mixed mode\" προσφέροντας WPA2/WPA3 και σε αυτήν την περίπτωση εμφανίζονται στο παράθυρο σάρωσης ως WPA3. Επομένως θα εμφανιστούν δίκτυα WPA3, αλλά στη συνέχεια το airgeddon θα τα αναλύσει μετά τη σάρωση για να σας επιτρέψει να επιλέξετε μόνο εκείνα που προσφέρουν επίσης WPA2"
	arr["ITALIAN",215]="L'azione che hai scelto di eseguire può essere eseguita solo su reti WPA/WPA2, tuttavia WPA3 è stato incluso nel filtro di scansione poiché queste reti a volte funzionano in \"Mixed mode\" offrendo WPA2/WPA3 e quando è il caso vengono visualizzate nella finestra di scansione come WPA3. Cioè, appariranno le reti WPA3 ma poi airgeddon le analizzerà dopo la scansione per farti selezionare solo quelle che offrono anche WPA2"
	arr["POLISH",215]="Wybrana czynność może być wykonana tylko w sieciach WPA/WPA2 ale szyfrowanie WPA3 również zostało uwzględnione w filtrze skanowania. Jest to spowodowane tym, że sieci te czasami działają w \"Mixed mode\" oferując tryb WPA2/WPA3, który jest wyświetlany w oknie skanowania jako WPA3. Czyli przy skanowaniu pojawią się sieci WPA3, ale airgeddon przeanalizuje je potem, aby wybrać tylko te, które oferują również WPA2"
	arr["GERMAN",215]="Die Aktion, die Sie ausführen möchten, kann nur über WPA/WPA2-Netzwerke ausgeführt werden, jedoch wurde WPA3 in den Suchfilter aufgenommen, da diese Netzwerke manchmal im \"Mixed mode\" arbeiten und WPA2/WPA3 anbieten, und wenn dies der Fall ist, werden im Scan-Fenster als WPA3 angezeigt. Das heißt, WPA3-Netzwerke werden angezeigt, aber airgeddon analysiert sie nach dem Scan, damit Sie nur diejenigen auswählen können, die auch WPA2 anbieten"
	arr["TURKISH",215]="Gerçekleştirmeyi seçtiğiniz eylem yalnızca WPA/WPA2 ağları üzerinden gerçekleştirilebilir, ancak bu ağlar bazen WPA2/WPA3 sunan \"Mixed mode\" da çalıştığı ve durum ne zaman görüntülendiği için WPA3 tarama filtresine dahil edilmiştir. WPA3 olarak tarama penceresinde. Yani, WPA3 ağları görünecek, ancak daha sonra airgeddon, yalnızca WPA2 sunanları seçmenize izin vermek için taramadan sonra bunları analiz edecektir"
	arr["ARABIC",215]="WPA2 بتحليل هذه الشباكات ليسمح لك باختيار الشباكات التي تقدم  airgeddon و فى هذه الحالة سيتم عرضه علي نافذة المسح . سيقوم WPA2/WPA3 بحالة \"Mixed mode\" حيث ان بعض هذه الشباكات تعمل في  WPA3 ولكن تم الفحص عن ,WPA/WPA2 لا يمكن تنفيذ الإجراء الذي اخترت تنفيذه إلا عبر شبكات"
	arr["CHINESE",215]="所选操作只能在 WPA/WPA2 网络上执行，但 WPA3 已包含在扫描过滤器中，因为这些网络有时会以“混合模式”工作，同时提供 WPA2/WPA3 两种加密方式，这种情况下，它们在扫描窗口中显示为 WPA3。因此虽然有 WPA3 的网络出现，但 airgeddon 将在扫描后对其进行分析，过滤出那些也同时提供 WPA2 的网络"

	arr["ENGLISH",216]="No networks found with Handshake captured on the selected file"
	arr["SPANISH",216]="No se encontraron redes con Handshake capturado en el fichero seleccionado"
	arr["FRENCH",216]="Aucun réseau avec son Handshake n'a été trouvé dans le fichier sélectionné"
	arr["CATALAN",216]="No s'han trobat xarxes amb Handshake capturat en el fitxer seleccionat"
	arr["PORTUGUESE",216]="Nenhuma rede encontrada no arquivo Handshake selecionado"
	arr["RUSSIAN",216]="В выбранном файле сети с захваченным рукопожатием не найдены"
	arr["GREEK",216]="Δεν βρέθηκαν δίκτυα με Χειραψία στο επιλεγμένο αρχείο"
	arr["ITALIAN",216]="Nessuna rete trovata con Handshake catturati nel file selezionato"
	arr["POLISH",216]="Nie znaleziono sieci z przechwyconym Handshake w wybranym pliku"
	arr["GERMAN",216]="In der ausgewählten Datei wurden keine Netzwerke mit Handshake gefunden"
	arr["TURKISH",216]="Seçilen dosyada yakalanan Handshake ile ağ bulunamadı"
	arr["ARABIC",216]="تم التقاطها في الملف المحدد Handshake لم يتم العثور على شبكات "
	arr["CHINESE",216]="在所选握手包文件中未找到对应的无线网络"

	arr["ENGLISH",217]="Only one valid target detected on file. BSSID autoselected [\${normal_color}\${bssid}\${blue_color}]"
	arr["SPANISH",217]="Sólo un objetivo válido detectado en el fichero. Se ha seleccionado automáticamente el BSSID [\${normal_color}\${bssid}\${blue_color}]"
	arr["FRENCH",217]="Le seul réseau valide présent dans le fichier choisi a été sélectionné automatiquement, son BSSID est [\${normal_color}\${bssid}\${blue_color}]"
	arr["CATALAN",217]="Només un objectiu vàlid detectat en el fitxer. S'ha seleccionat automàticament el BSSID [\${normal_color}\${bssid}\${blue_color}]"
	arr["PORTUGUESE",217]="Apenas um alvo válido detectado no arquivo. BSSID selecionado automaticamente [\${normal_color}\${bssid}\${blue_color}]"
	arr["RUSSIAN",217]="В файле обнаружена только одна подходящая цель. BSSID выбрана автоматически [\${normal_color}\${bssid}\${blue_color}]"
	arr["GREEK",217]="Μόνο ένας έγκυρος στόχος εντοπίστηκε στο αρχείο. Επιλέχθηκε αυτόματα το BSSID [\${normal_color}\${bssid}\${blue_color}]"
	arr["ITALIAN",217]="Solo un bersaglio valido rilevato nel file. Viene selezionato automaticamente il BSSID [\${normal_color}\${bssid}\${blue_color}]"
	arr["POLISH",217]="W pliku został wykryty tylko jeden prawidłowy cel. BSSID wybrany automatycznie [\${normal_color}\${bssid}\${blue_color}]"
	arr["GERMAN",217]="Nur ein gültiges Ziel wurde in der Datei gefunden. Die BSSID [\${normal_color}\${bssid}\${blue_color}] wurde automatisch ausgewählt"
	arr["TURKISH",217]="Dosyada sadece bir tane geçerli hedef tespit edildi. BSSID otomatik seçildi [\${normal_color}\${bssid}\${blue_color}]"
	arr["ARABIC",217]="[\${normal_color}\${bssid}\${blue_color}] تلقائيًا BSSID  تم اكتشاف هدف واحد صالح في الملف. تم تحديد"
	arr["CHINESE",217]="文件中仅检测到一个有效目标。BSSID 自动选择 [\${normal_color}\${bssid}\${blue_color}]"

	arr["ENGLISH",218]="Optional tools: checking..."
	arr["SPANISH",218]="Herramientas opcionales: comprobando..."
	arr["FRENCH",218]="Vérification de la présence des outils optionnels..."
	arr["CATALAN",218]="Eines opcionals: comprovant..."
	arr["PORTUGUESE",218]="Verificando se as ferramentas opcionais estão presentes..."
	arr["RUSSIAN",218]="Опциональные инструменты: проверка..."
	arr["GREEK",218]="Προαιρετικά εργαλεία: γίνεται έλεγχος..."
	arr["ITALIAN",218]="Strumenti opzionali: controllo ..."
	arr["POLISH",218]="Narzędzia opcjonalne: sprawdzanie..."
	arr["GERMAN",218]="Optionale Tools: Überprüfung..."
	arr["TURKISH",218]="İsteğe bağlı araçlar: kontrol ediliyor..."
	arr["ARABIC",218]="...أدوات اختيارية: فحص"
	arr["CHINESE",218]="可选工具: 检查中..."

	arr["ENGLISH",219]="Your distro has the essential tools but it hasn't some optional. The script can continue but you can't use some features. It is recommended to install missing tools"
	arr["SPANISH",219]="Tu distro tiene las herramientas esenciales pero le faltan algunas opcionales. El script puede continuar pero no podrás utilizar algunas funcionalidades. Es recomendable instalar las herramientas que faltan"
	arr["FRENCH",219]="Votre système contient les outils fondamentaux nécessaires à l’exécution du script mais il manque quelques outils pour pouvoir utiliser pleinement toutes les fonctionnalités proposées par le script. Le script va pouvoir être exécuté mais il est conseillé d'installer les outils manquants"
	arr["CATALAN",219]="La teva distro té les eines essencials però li falten algunes opcionals. El script pot continuar però no podràs utilitzar algunes funcionalitats. És recomanable instal·lar les eines que faltin"
	arr["PORTUGUESE",219]="Sua distro tem as ferramentas essenciais, mas carece de algumas opcionais. O script pode continuar, mas você não poderá usar alguns recursos. É aconselhável instalar as ferramentas ausentes"
	arr["RUSSIAN",219]="Ваш дистрибутив имеет базовые инструменты, но не имеет некоторые опциональные. Скрипт может продолжить работу, но вы не сможете использовать некоторые функции. Рекомендуется установить отсутствующие инструменты"
	arr["GREEK",219]="Η διανομή σας έχει τα απαραίτητα εργαλεία αλλά δεν έχει κάποια προαιρετικά. Το script μπορεί να συνεχίσει αλλά δεν θα μπορέσετε να χρησιμοποιήσετε κάποια χαρακτηριστικά. Συνιστάται να εγκαταστήσετε τα λείποντα εργαλεία"
	arr["ITALIAN",219]="La tua distro ha gli strumenti essenziali, ma mancano alcuni opzionali. Lo script può continuare, ma non è possibile utilizzare alcune funzioni. Si consiglia di installare gli strumenti mancanti"
	arr["POLISH",219]="Twoja dystrybucja Linuxa ma podstawowe narzędzia, ale brakuje niektórych opcjonalnych. Skrypt może być kontynuowany, ale nie będziesz mógł używać niektórych funkcji. Zaleca się zainstalowanie brakujących narzędzi"
	arr["GERMAN",219]="Ihre Distribution hat die wesentlichen Werkzeuge, aber einige optionale fehlen. Das Skript kann fortgesetzt werden, Sie können jedoch einige Funktionen nicht verwenden. Es empfiehlt sich, die fehlenden Tools zu installieren"
	arr["TURKISH",219]="Dağıtımınız temel araçlara sahiptir, ancak bazı opsiyonel araçlar mevcut değildir. Yazılım devam edebilir, ancak bazı özellikleri kullanamazsınız. Eksik araçların tamamlanması tavsiye edilir"
	arr["ARABIC",219]="تحتوي التوزيعة الخاصة بك على الأدوات الأساسية ولكنها ليست اختيارية. يمكن أن يستمر البرنامج ولكن لا يمكنك استخدام بعض الميزات. يوصى بتثبيت الأدوات المفقودة"
	arr["CHINESE",219]="您的发行版具有基本工具，但没有一些可选工具。脚本可以继续，但您不能使用某些功能。建议安装缺少的工具"

	arr["ENGLISH",220]="Locked menu option was chosen"
	arr["SPANISH",220]="Opción del menú bloqueada"
	arr["FRENCH",220]="Cette option du menu est bloquée"
	arr["CATALAN",220]="Opció del menú bloquejada"
	arr["PORTUGUESE",220]="Menu bloqueado"
	arr["RUSSIAN",220]="Была выбрана заблокированная опция меню"
	arr["GREEK",220]="Επιλέχθηκε κλειδωμένη επιλογή"
	arr["ITALIAN",220]="Opzione del menù bloccata"
	arr["POLISH",220]="Opcja zablokowana"
	arr["GERMAN",220]="Blockierte Menüoption"
	arr["TURKISH",220]="Kilitli menü seçeneği seçildi"
	arr["ARABIC",220]="تم اختيار خيارمقفل في القائمة"
	arr["CHINESE",220]="选择了锁定的菜单选项"

	arr["ENGLISH",221]="Accepted bash version (\${BASH_VERSION}). Minimum required version: \${minimum_bash_version_required}"
	arr["SPANISH",221]="Versión de bash (\${BASH_VERSION}) aceptada. Mínimo requerido versión: \${minimum_bash_version_required}"
	arr["FRENCH",221]="Votre version de bash (\${BASH_VERSION}) est acceptée. Version minimale requise: \${minimum_bash_version_required}"
	arr["CATALAN",221]="Versió de bash (\${BASH_VERSION}) acceptada. Versió minima requerida: \${minimum_bash_version_required}"
	arr["PORTUGUESE",221]="Versão Bash (\${BASH_VERSION}) aceita. Versão mínima exigida: \${minimum_bash_version_required}"
	arr["RUSSIAN",221]="Используемая версия bash (\${BASH_VERSION}). Минимальная требуемая версия: \${minimum_bash_version_required}"
	arr["GREEK",221]="Αποδεκτή έκδοση bash (\${BASH_VERSION}). Ελάχιστη απαιτούμενη έκδοση: \${minimum_bash_version_required}"
	arr["ITALIAN",221]="Versione di bash (\${BASH_VERSION}) accettata. Minima versione richiesta: \${minimum_bash_version_required}"
	arr["POLISH",221]="Zaakceptowano wersję bash (\${BASH_VERSION}). Minimalna wymagana wersja: \${minimum_bash_version_required}"
	arr["GERMAN",221]="Bash-Version (\${BASH_VERSION}) akzeptiert. Mindestversion erforderlich: \${minimum_bash_version_required}"
	arr["TURKISH",221]="Kabul edilen bash sürümü (\${BASH_VERSION}). Gerekli minimum sürüm: \${minimum_bash_version_required}"
	arr["ARABIC",221]="\${minimum_bash_version_required} :أدنى إصدار مطلوب.(\${BASH_VERSION}) مقبول bashإصدار"
	arr["CHINESE",221]="可接受 bash 版本 (\${BASH_VERSION})。最低要求版本: \${minimum_bash_version_required}"

	arr["ENGLISH",222]="Insufficient bash version (\${BASH_VERSION}). Minimum required version: \${minimum_bash_version_required}"
	arr["SPANISH",222]="Versión de bash insuficiente (\${BASH_VERSION}). Mínimo requerido versión: \${minimum_bash_version_required}"
	arr["FRENCH",222]="Votre version de bash (\${BASH_VERSION}) n'est pas suffisante. Version minimale requise: \${minimum_bash_version_required}"
	arr["CATALAN",222]="Versió de bash insuficient (\${BASH_VERSION}). Versió mínima requerida: \${minimum_bash_version_required}"
	arr["PORTUGUESE",222]="Versão Bash insuficiente (\${BASH_VERSION}). Versão mínima exigida: \${minimum_bash_version_required}"
	arr["RUSSIAN",222]="Неудовлетворительная версия bash (\${BASH_VERSION}). Минимальная требуемая версия: \${minimum_bash_version_required}"
	arr["GREEK",222]="Ανεπαρκής έκδοση bash (\${BASH_VERSION}). Ελάχιστη απαιτούμενη έκδοση: \${minimum_bash_version_required}"
	arr["ITALIAN",222]="Versione di bash insufficiente (\${BASH_VERSION}). Versione minima richiesta: \${minimum_bash_version_required}"
	arr["POLISH",222]="Niewystarczająca wersja bash (\${BASH_VERSION}). Minimalna wymagana wersja: \${minimum_bash_version_required}"
	arr["GERMAN",222]="Unzureichende Bash-Version (\${BASH_VERSION}). Mindestversion erforderlich: \${minimum_bash_version_required}"
	arr["TURKISH",222]="Yetersiz bash sürümü (\${BASH_VERSION}). Gerekli minimum sürüm: \${minimum_bash_version_required}"
	arr["ARABIC",222]="\${minimum_bash_version_required} :أدنى إصدار مطلوب.(\${BASH_VERSION}) غير كافي bashإصدار"
	arr["CHINESE",222]="bash 版本不足 (\${BASH_VERSION})。最低要求版本: \${minimum_bash_version_required}"

	arr["ENGLISH",223]="airgeddon needs root permissions to work. Launch the script as root user or using \"sudo\""
	arr["SPANISH",223]="airgeddon necesita permisos de root para funcionar. Lanza el script como usuario root o usando \"sudo\""
	arr["FRENCH",223]="airgeddon a besoin de permissions root pour être exécuté. Lancez the script en tant que root ou en utilisant \"sudo\""
	arr["CATALAN",223]="airgeddon necessita permisos de root per funcionar. Llança l'script com a usuari root o utilitza \"sudo\""
	arr["PORTUGUESE",223]="airgeddon necessita de permissões root para funcionar. Execute o script como root ou usando \"sudo\""
	arr["RUSSIAN",223]="airgeddon требует для работы прав root. Запустите скрипт как root пользователь или используйте \"sudo\""
	arr["GREEK",223]="Το airgeddon χρειάζεται root δικαιώματα για να δουλέψει. Ανοίξτε το script ως χρήστης root ή χρησιμοποιήστε \"sudo\""
	arr["ITALIAN",223]="airgeddon ha bisogno dei permessi di root per l'esecuzione. Lancia lo script come root o usando \"sudo\""
	arr["POLISH",223]="airgeddon wymaga uprawnień root do pracy. Uruchom skrypt jako root lub użyj \"sudo\""
	arr["GERMAN",223]="airgeddon benötigt root Berechtigungen um zu arbeiten. Starten Sie das Skript als root oder mit \"sudo\""
	arr["TURKISH",223]="airgeddon'un çalışması için root izinlerine ihtiyacı var. Yazılımı root kullanıcısı olarak veya \"sudo\" kullanarak başlat"
	arr["ARABIC",223]="\"sudo\" أو باستخدام root للعمل. قم بتشغيل البرنامج ك root إلى أذونات airgeddon يحتاج"
	arr["CHINESE",223]="airgeddon 需要 root 权限才能工作。以 root 用户或使用 \"sudo\" 启动脚本"

	arr["ENGLISH",224]="The script execution continues from exactly the same point where it was"
	arr["SPANISH",224]="El script continua su ejecución desde exactamente el mismo punto en el que estaba"
	arr["FRENCH",224]="L'exécution du script se poursuit à partir exactement le même point où il était"
	arr["CATALAN",224]="El script contínua la seva execució des d'exactament el mateix punt en el qual estava"
	arr["PORTUGUESE",224]="A execução do script continuará exatamente do mesmo ponto"
	arr["RUSSIAN",224]="Выполнение скрипта продолжиться с точно той точки, на которой он был"
	arr["GREEK",224]="Η εκτέλεση του script συνεχίζει ακριβώς από το ίδιο σημείο που ήταν"
	arr["ITALIAN",224]="Lo script continua l'esecuzione esattamente dallo stesso punto in cui era"
	arr["POLISH",224]="Skrypt kontynuuje wykonywanie z punktu, w którym zakończyl"
	arr["GERMAN",224]="Das Skript setzt seine Ausführung von genau dem Punkt fort, wo es war"
	arr["TURKISH",224]="Yazılım tam olarak aynı noktadan devam eder"
	arr["ARABIC",224]="يستمر تنفيذ البرنامج من نفس النقطة التي كان فيها"
	arr["CHINESE",224]="脚本将完全从相同的点继续向下执行"

	arr["ENGLISH",225]="The script can't check if there is a new version because you haven't installed update tools needed"
	arr["SPANISH",225]="El script no puede comprobar si hay una nueva versión porque no tienes instaladas las herramientas de actualización necesarias"
	arr["FRENCH",225]="Le script ne peut pas vérifier si une nouvelle version est disponible parce que vous n'avez pas installé les outils nécessaires de mise à jour"
	arr["CATALAN",225]="El script no pot comprovar si hi ha una nova versió perquè no tens instal·lades les eines d'actualització necessàries"
	arr["PORTUGUESE",225]="O script não pôde verificar se há uma nova versão porque você não tem instalado as ferramentas de atualização necessárias"
	arr["RUSSIAN",225]="Скрипт не может проверить имеется ли новая версия, поскольку у вас не установлены необходимые инструменты обновления"
	arr["GREEK",225]="Το script δεν μπορεί να ελέγξει αν υπάρχει νεότερη έκδοση γιατί δεν έχετε εγκαταστήσει τα απαραίτητα εργαλεία ενημερώσεων"
	arr["ITALIAN",225]="Lo script non può verificare se c'è una nuova versione perché non sono stati installati gli strumenti di aggiornamento necessari"
	arr["POLISH",225]="Skrypt nie może sprawdzić nowej wersji, ponieważ nie ma zainstalowanych niezbędnych narzędzi aktualizacji"
	arr["GERMAN",225]="Das Skript kann nicht überprüfen, ob eine neue Version vorhanden ist, da die erforderlichen Update-Tools nicht installiert sind"
	arr["TURKISH",225]="Yazılım, ihtiyaç duyduğunuz güncelleme araçlarını yüklemediğinden yeni bir sürüm olup olmadığını kontrol edemiyor"
	arr["ARABIC",225]="يتعذر على البرنامج التحقق مما إذا كان هناك إصدار جديد لأنك لم تقم بتثبيت أدوات التحديث المطلوبة"
	arr["CHINESE",225]="该脚本无法检查是否有新版本，因为您尚未安装所需的更新工具"

	arr["ENGLISH",226]="Update tools: checking..."
	arr["SPANISH",226]="Herramientas de actualización: comprobando..."
	arr["FRENCH",226]="Vérification de la présence des outils de mise à jour..."
	arr["CATALAN",226]="Eines d'actualització: comprovant..."
	arr["PORTUGUESE",226]="Verificando ferramentas de atualização..."
	arr["RUSSIAN",226]="Инструменты для обновления: проверка..."
	arr["GREEK",226]="Εργαλεία ενημερώσεων: γίνεται έλεγχος..."
	arr["ITALIAN",226]="Strumenti di aggiornamento: controllo ..."
	arr["POLISH",226]="Narzędzia aktualizacji: sprawdzanie..."
	arr["GERMAN",226]="Update-Tools: Überprüfung..."
	arr["TURKISH",226]="Güncelleme araçları: kontrol ediliyor..."
	arr["ARABIC",226]="...التحقق من وجود أدوات التحديث"
	arr["CHINESE",226]="脚本更新工具: 检查中..."

	arr["ENGLISH",227]="Working...  "
	arr["SPANISH",227]="Trabajando...  "
	arr["FRENCH",227]="Travail...  "
	arr["CATALAN",227]="Treballant...  "
	arr["PORTUGUESE",227]="Trabalhando...  "
	arr["RUSSIAN",227]="Работаем...  "
	arr["GREEK",227]="Δουλεύει...  "
	arr["ITALIAN",227]="Lavorando...  "
	arr["POLISH",227]="Praca...  "
	arr["GERMAN",227]="In Arbeit...  "
	arr["TURKISH",227]="Çalışıyor...  "
	arr["ARABIC",227]="...جاري العمل"
	arr["CHINESE",227]="工作中..."

	arr["ENGLISH",228]="                             Developed by \${author}"
	arr["SPANISH",228]="                             Programado por \${author}"
	arr["FRENCH",228]="                             Programmé par \${author}"
	arr["CATALAN",228]="                             Desenvolupat per \${author}"
	arr["PORTUGUESE",228]="                             Programado por \${author}"
	arr["RUSSIAN",228]="                             Создал \${author}"
	arr["GREEK",228]="                             Προγραμματισμένο από \${author}"
	arr["ITALIAN",228]="                             Sviluppato da \${author}"
	arr["POLISH",228]="                             Opracowany przez \${author}"
	arr["GERMAN",228]="                             Entwickelt von \${author}"
	arr["TURKISH",228]="                              \${author} tarafından geliştirildi"
	arr["ARABIC",228]="                                \${author} المبرمج"
	arr["CHINESE",228]="                                  由 \${author} 开发"

	arr["ENGLISH",229]="hashcat CPU/GPU attacks"
	arr["SPANISH",229]="ataques hashcat CPU/GPU"
	arr["FRENCH",229]="attaques hashcat CPU/GPU"
	arr["CATALAN",229]="atacs hashcat CPU/GPU"
	arr["PORTUGUESE",229]="Ataques com hashcat usando CPU/GPU"
	arr["RUSSIAN",229]="Атаки hashcat с использованием CPU/GPU"
	arr["GREEK",229]="επιθέσεις hashcat CPU/GPU"
	arr["ITALIAN",229]="attacchi hashcat CPU/GPU"
	arr["POLISH",229]="ataki hashcat CPU/GPU"
	arr["GERMAN",229]="CPU/GPU-hashcat-Angriffe"
	arr["TURKISH",229]="hashcat CPU/GPU saldırılar"
	arr["ARABIC",229]="hashcat CPU/GPU هجمات"
	arr["CHINESE",229]="hashcat CPU/GPU 破解"

	arr["ENGLISH",230]="3.  (hashcat) Dictionary attack against Handshake capture file"
	arr["SPANISH",230]="3.  (hashcat) Ataque de diccionario sobre fichero de captura Handshake"
	arr["FRENCH",230]="3.  (hashcat) Attaque de dictionnaire en utilisant le fichier de capture Handshake"
	arr["CATALAN",230]="3.  (hashcat) Atac de diccionari sobre fitxer de captura Handshake"
	arr["PORTUGUESE",230]="3.  (hashcat) Ataque com dicionário em um Handshake"
	arr["RUSSIAN",230]="3.  (hashcat) Атака по словарю в отношению захваченного файла рукопожатия"
	arr["GREEK",230]="3.  (hashcat) Επίθεση με χρήση λεξικού σε αρχείο καταγραφής Handshake"
	arr["ITALIAN",230]="3.  (hashcat) Attacco di dizionario sul file di cattura Handshake"
	arr["POLISH",230]="3.  (hashcat) Atak słownikowy na plik przechwytywania Handshake"
	arr["GERMAN",230]="3.  (hashcat) Wörterbuchangriff auf die Aufnahmedatei Handshake"
	arr["TURKISH",230]="3.  (hashcat) Yakalanan Handshake dosyasına karşı sözlük saldırısı"
	arr["ARABIC",230]="3.  Handshake هجوم القاموس على ملف التقاط (hashcat)"
	arr["CHINESE",230]="3.  (hashcat) 针对 Handshake 捕获文件的字典攻击"

	arr["ENGLISH",231]="4.  (hashcat) Bruteforce attack against Handshake capture file"
	arr["SPANISH",231]="4.  (hashcat) Ataque de fuerza bruta sobre fichero de captura Handshake"
	arr["FRENCH",231]="4.  (hashcat) Attaque de force brute en utilisant le fichier de capture Handshake"
	arr["CATALAN",231]="4.  (hashcat) Atac de força bruta sobre fitxer de captura Handshake"
	arr["PORTUGUESE",231]="4.  (hashcat) Ataque de força bruta em um Handshake"
	arr["RUSSIAN",231]="4.  (hashcat) Атака брут-форсом в отношении захваченного файла рукопожатия"
	arr["GREEK",231]="4.  (hashcat) Επίθεση bruteforce σε αρχείο καταγραφής Handshake"
	arr["ITALIAN",231]="4.  (hashcat) Attacco di forza bruta sul file di cattura Handshake"
	arr["POLISH",231]="4.  (hashcat) Atak brute force na plik przechwytywania Handshake"
	arr["GERMAN",231]="4.  (hashcat) Brute-Force-Angriff auf die Capture-Handshake-Datei"
	arr["TURKISH",231]="4.  (hashcat) Yakalanan Handshake dosyasına karşı bruteforce saldırısı"
	arr["ARABIC",231]="4.  Handshake ضد ملف التقاط Bruteforce هجوم (hashcat)"
	arr["CHINESE",231]="4.  (hashcat) 暴力破解 Handshake 捕获文件"

	arr["ENGLISH",232]="5.  (hashcat) Rule based attack against Handshake capture file"
	arr["SPANISH",232]="5.  (hashcat) Ataque basado en reglas sobre fichero de captura Handshake"
	arr["FRENCH",232]="5.  (hashcat) Attaque fondé sur des règles en utilisant le fichier de capture Handshake"
	arr["CATALAN",232]="5.  (hashcat) Atac basat en regles sobre el fitxer de captura Handshake"
	arr["PORTUGUESE",232]="5.  (hashcat) Ataque baseado em regras em um arquivo Handshake"
	arr["RUSSIAN",232]="5.  (hashcat) Атака на основе правил в отношении захваченного файла рукопожатия"
	arr["GREEK",232]="5.  (hashcat) Επίθεση rule based σε αρχείο καταγραφής Handshake"
	arr["ITALIAN",232]="5.  (hashcat) Attacco basato su regole contro il file di cattura Handshake"
	arr["POLISH",232]="5.  (hashcat) Atak na plik przechwytywania Handshake bazujący na regułach"
	arr["GERMAN",232]="5.  (hashcat) Regeln-basierender Angriff gegen der Capture-Handshake-Datei"
	arr["TURKISH",232]="5.  (hashcat) Yakalanan Handshake dosyasına karşı kural tabanlı saldırı"
	arr["ARABIC",232]="5.  Handshake هجوم قائم على القواعد ضد ملف التقاط (hashcat)"
	arr["CHINESE",232]="5.  (hashcat) Handshake 捕获文件基于字典规则文件的攻击"

	arr["ENGLISH",233]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${hashcat_potpath}]"
	arr["SPANISH",233]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${hashcat_potpath}]"
	arr["FRENCH",233]="Entrez le chemin où vous voulez enregistrer le fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${hashcat_potpath}]"
	arr["CATALAN",233]="Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${hashcat_potpath}]"
	arr["PORTUGUESE",233]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${hashcat_potpath}]"
	arr["RUSSIAN",233]="Напечатайте путь к сохранённому файлу или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${hashcat_potpath}]"
	arr["GREEK",233]="Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${hashcat_potpath}]"
	arr["ITALIAN",233]="Immettere il percorso dove memorizzare il file o premere [Enter] per accettare quello di default \${normal_color}[\${hashcat_potpath}]"
	arr["POLISH",233]="Wpisz ścieżkę do zapisu pliku lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${hashcat_potpath}]"
	arr["GERMAN",233]="Schreiben Sie den Pfad wo die Datei gespeichert werden soll, oder drücken Sie die [Enter], um den Standardvorschlag zu akzeptieren \${normal_color}[\${hashcat_potpath}]"
	arr["TURKISH",233]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın. \${normal_color}[\${hashcat_potpath}]"
	arr["ARABIC",233]="\${normal_color}[\${hashcat_potpath}]\${green_color} لاستخدام المسار المقترح [Enter] أدخل المسار الذي تريد حفظ الملف فيه أو اضغط على\${normal_color}"
	arr["CHINESE",233]="输入文件的存储路径或按 [Enter] 接受默认建议 \${normal_color}[\${hashcat_potpath}]"

	arr["ENGLISH",234]="Congratulations!! It seems the key has been decrypted"
	arr["SPANISH",234]="Enhorabuena!! Parece que la clave ha sido descifrada"
	arr["FRENCH",234]="Félicitations!! Il semble que la clef a été décryptée"
	arr["CATALAN",234]="Enhorabona!! Sembla que la clau ha estat desxifrada"
	arr["PORTUGUESE",234]="Parabéns!! Parece que a senha foi descriptografada"
	arr["RUSSIAN",234]="Поздравления!! Похоже на то, что ключ был расшифрован"
	arr["GREEK",234]="Συγχαρητήρια!! Φαίνεται πως το κλειδί αποκρυπτογραφήθηκε"
	arr["ITALIAN",234]="Congratulazioni!! Sembra che la password sia stata decifrata"
	arr["POLISH",234]="Gratulacje!! Wygląda na to, że klucz został odszyfrowany"
	arr["GERMAN",234]="Herzlichen Glückwunsch!! Es scheint, dass der Schlüssel entschlüsselt wurde"
	arr["TURKISH",234]="Tebrikler!! Görünüşe göre key şifresi çözüldü"
	arr["ARABIC",234]="تهانينا!! يبدو أنه تم فك تشفير المفتاح"
	arr["CHINESE",234]="恭喜！！密码已被破解"

	arr["ENGLISH",235]="Do you want to save the trophy file with the decrypted password? \${normal_color}\${visual_choice}"
	arr["SPANISH",235]="¿Quieres guardar el fichero de trofeo con la clave descifrada? \${normal_color}\${visual_choice}"
	arr["FRENCH",235]="Voulez-vous enregistrer le fichier trophée avec le mot de passe déchiffré? \${normal_color}\${visual_choice}"
	arr["CATALAN",235]="¿Vols desar el fitxer de trofeu amb la clau desxifrada? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",235]="Você quer salvar arquivo com a senha descriptografada? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",235]="Вы хотите сохранить трофейный файл с расшифрованным паролем? \${normal_color}\${visual_choice}"
	arr["GREEK",235]="Θέλετε να αποθηκεύσετε το αρχείο τρόπαιο με τον αποκρυπτογραφημένο κωδικό πρόσβασης; \${normal_color}\${visual_choice}"
	arr["ITALIAN",235]="Vuoi salvare il file trofeo con la password decifrata? \${normal_color}\${visual_choice}"
	arr["POLISH",235]="Czy chcesz zapisać plik trofeum przy użyciu odszyfrowanego klucza? \${normal_color}\${visual_choice}"
	arr["GERMAN",235]="Möchten Sie die Trophäendatei mit dem entschlüsselten Schlüssel speichern? \${normal_color}\${visual_choice}"
	arr["TURKISH",235]="Trophy dosyasını şifresi çözülmüş olarak kaydetmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",235]="\${normal_color}\${visual_choice} \${green_color}هل تريد حفظ ملف الغنيمة مع كلمة السرالتي تم فك تشفيرها؟\${normal_color}"
	arr["CHINESE",235]="你想保存得到的密码吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",236]="Hashcat trophy file generated successfully at [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["SPANISH",236]="Fichero de trofeo hashcat generado con éxito en [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["FRENCH",236]="Le fichier trophée hashcat a bien été crée dans [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["CATALAN",236]="Fitxer de trofeu hashcat generat amb èxit a [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["PORTUGUESE",236]="Arquivo de troféu hashcat gerado com sucesso [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["RUSSIAN",236]="Трофейный файл hashcat был успешно сгенерирован в [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["GREEK",236]="Το hashcat αρχείο τρόπαιο δημιουργήθηκε επιτυχώς [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["ITALIAN",236]="File di trofeo di hashcat generato con successo [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["POLISH",236]="Plik trofeum hashcat został pomyślnie wygenerowany w [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["GERMAN",236]="Trophäen-Datei-Hashcat erfolgreich in [\${normal_color}\${potenteredpath}\${blue_color}] generiert"
	arr["TURKISH",236]="Hashcat trophy dosyası başarıyla şurada oluşturuldu [\${normal_color}\${potenteredpath}\${blue_color}]"
	arr["ARABIC",236]="[\${normal_color}\${potenteredpath}\${blue_color}] بنجاح في Hashcat تم إنشاء ملف غنيمة"
	arr["CHINESE",236]="在 [\${normal_color}\${potenteredpath}\${blue_color}] 成功生成 Hashcat 文件"

	arr["ENGLISH",237]="There is a problem with the files or the entered path. Make sure that ca.pem, server.pem and server.key files exist in the given path. The attack can't be performed"
	arr["SPANISH",237]="Existe un problema con los ficheros o la ruta introducida. Asegúrate de que los ficheros ca.pem, server.pem y server.key existen en la ruta indicada. El ataque no se puede realizar"
	arr["FRENCH",237]="Il y a un problème avec les fichiers ou le chemin entré. Assurez-vous que les fichiers ca.pem, server.pem et server.key existent dans le chemin indiqué. L'attaque ne peut pas être effectuée"
	arr["CATALAN",237]="Hi ha un problema amb els fitxers o la ruta introduïda. assegura't que els fitxers ca.pem, server.pem i server.key existeixen a la ruta indicada. L'atac no es pot realitzar"
	arr["PORTUGUESE",237]="Existe um problema com os arquivos ou com o caminho digitado. Certifique-se de que os arquivos ca.pem, server.pem e server.key existam no caminho indicado. O ataque não pode ser realizado"
	arr["RUSSIAN",237]="Возникла проблема с файлами или указанным путём. Убедитесь, что файлы ca.pem, server.pem и server.key существуют по указанному пути. Атака не может быть выполнена"
	arr["GREEK",237]="Υπάρχει κάποιο πρόβλημα με τα αρχεία ή τη διαδρομή που έχετε εισάγει. Βεβαιωθείτε ότι τα αρχεία ca.pem, server.pem και server.key υπάρχουν στην υποδεικνυόμενη διαδρομή. Η επίθεση δεν μπορεί να εκτελεστεί"
	arr["ITALIAN",237]="C'è un problema con i files o il percorso immessi. Assicurati che i file ca.pem, server.pem e server.key esistano nel percorso indicato. L'attacco non può essere eseguito"
	arr["POLISH",237]="Wystąpił problem z plikami lub wprowadzoną ścieżką. Upewnij się, że pliki ca.pem, server.pem i server.key istnieją we wskazanej lokalizacji. Nie można wykonać ataku"
	arr["GERMAN",237]="Es gibt ein Problem mit den Dateien oder dem eingegebenen Pfad. Stellen Sie sicher, dass die Dateien ca.pem, server.pem und server.key im angegebenen Pfad vorhanden sind. Der Angriff kann nicht ausgeführt werden"
	arr["TURKISH",237]="Dosyalarda veya girilen yolda bir sorun var. ca.pem, server.pem ve server.key dosyalarının belirtilen yolda bulunduğundan emin olun. Saldırı gerçekleştirilemez"
	arr["ARABIC",237]="توجد مشكلة في الملفات أو المسار المدخل. تأكد من وجود ملفات ca.pem و server.pem و server.key في المسار المحدد. لا يمكن تنفيذ الهجوم"
	arr["CHINESE",237]="文件或输入的路径有问题。确保给定路径中存在 ca.pem、server.pem 和 server.key 文件。否则无法执行攻击"

	arr["ENGLISH",238]="Charset selection menu"
	arr["SPANISH",238]="Menú de selección de juego de caracteres"
	arr["FRENCH",238]="Menu de sélection du jeu de caractères"
	arr["CATALAN",238]="Menú de selecció de joc de caràcters"
	arr["PORTUGUESE",238]="Menu de seleção do conjunto de caracteres"
	arr["RUSSIAN",238]="Меню выбора набора символов"
	arr["GREEK",238]="Μενού επιλογής συμβολοσειράς"
	arr["ITALIAN",238]="Menú di selezione del set di caratteri"
	arr["POLISH",238]="Menu wyboru zestawu znaków"
	arr["GERMAN",238]="Zeichensatz-Auswahlmenü"
	arr["TURKISH",238]="Karakter kümesi seçim menüsü"
	arr["ARABIC",238]="قائمة اختيار مجموعة الأحرف"
	arr["CHINESE",238]="字符集选择菜单"

	arr["ENGLISH",239]="You already have selected a rules file during this session [\${normal_color}\${RULES}\${blue_color}]"
	arr["SPANISH",239]="Ya tienes seleccionado un fichero de reglas en esta sesión [\${normal_color}\${RULES}\${blue_color}]"
	arr["FRENCH",239]="Vous avez déjà sélectionné un fichier règles pour cette session \${normal_color}\${RULES}\${blue_color}]"
	arr["CATALAN",239]="Ja tens seleccionat un fitxer de regles en aquesta sessió [\${normal_color}\${RULES}\${blue_color}]"
	arr["PORTUGUESE",239]="Você selecionou um arquivo de regras nesta sessão [\${normal_color}\${RULES}\${blue_color}]"
	arr["RUSSIAN",239]="Во время этой сессии вы уже выбрали файл с правилами [\${normal_color}\${RULES}\${blue_color}]"
	arr["GREEK",239]="Έχετε ήδη επιλέξει αρχείο κανόνων κατά τη διάρκεια τησ συνεδρίας [\${normal_color}\${RULES}\${blue_color}]"
	arr["ITALIAN",239]="È giá stato selezionato un file di regole in questa sessione [\${normal_color}\${RULES}\${blue_color}]"
	arr["POLISH",239]="Plik reguły został już wybrany w tej sesji [\${normal_color}\${RULES}\${blue_color}]"
	arr["GERMAN",239]="Sie haben bereits eine Regeldatei ausgewählt [\${normal_color}\${RULES}\${blue_color}]"
	arr["TURKISH",239]="Bu oturumda zaten bir kural dosyası seçtiniz [\${normal_color}\${RULES}\${blue_color}]"
	arr["ARABIC",239]="[\${normal_color}\${RULES}\${blue_color}] لقد اخترت ملف القواعد أثناء هذه الدورة"
	arr["CHINESE",239]="您已经在此会话期间选择了一个规则文件 [\${normal_color}\${RULES}\${blue_color}]"

	arr["ENGLISH",240]="Do you want to use this already selected rules file? \${normal_color}\${visual_choice}"
	arr["SPANISH",240]="¿Quieres utilizar este fichero de reglas ya seleccionado? \${normal_color}\${visual_choice}"
	arr["FRENCH",240]="Souhaitez vous utiliser les règles déjà sélectionné? \${normal_color}\${visual_choice}"
	arr["CATALAN",240]="¿Vols fer servir aquest fitxer de regles ja seleccionat? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",240]="Você quer usar esse arquivo regras já selecionado? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",240]="Вы хотите использовать этот уже выбранный файл правил? \${normal_color}\${visual_choice}"
	arr["GREEK",240]="Θέλετε να χρησιμοποιήσετε το ήδη επιλεγμένο αρχείο κανόνων; \${normal_color}\${visual_choice}"
	arr["ITALIAN",240]="Vuoi utilizzare questo file di regole già selezionato? \${normal_color}\${visual_choice}"
	arr["POLISH",240]="Czy chcesz użyć tego już wybranego pliku reguł? \${normal_color}\${visual_choice}"
	arr["GERMAN",240]="Möchten Sie diese ausgewählte Regeldatei verwenden? \${normal_color}\${visual_choice}"
	arr["TURKISH",240]="Zaten seçilmiş olan kural dosyasını kullanmak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",240]="\${normal_color}\${visual_choice} \${green_color}هل تريد استخدام ملف القواعد الذي اخترته؟\${normal_color}"
	arr["CHINESE",240]="您要使用这个已经选择的规则文件吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",241]="The path to the rules file is valid. Script can continue..."
	arr["SPANISH",241]="La ruta al fichero de reglas es válida. El script puede continuar..."
	arr["FRENCH",241]="Le chemin vers le fichier règles est valide. Le script peut continuer..."
	arr["CATALAN",241]="La ruta cap al fitxer de regles és vàlida. El script pot continuar..."
	arr["PORTUGUESE",241]="O caminho para o arquivo de regras é válido. O script pode continuar..."
	arr["RUSSIAN",241]="Путь до файла с правилами верный. Скрипт может продолжать..."
	arr["GREEK",241]="Το μονοπάτι για το αρχείο κανόνων είναι έγκυρο. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",241]="Il percorso del file di regole è valido. Lo script può continuare..."
	arr["POLISH",241]="Ścieżka do pliku reguł jest prawidłowa. Skrypt może kontynuować..."
	arr["GERMAN",241]="Der Pfad zur Regeldatei ist gültig. Das Skript kann fortfahren..."
	arr["TURKISH",241]="Kural dosyasının dizini doğru. Yazılım devam edebilir..."
	arr["ARABIC",241]="...المسار إلى ملف القواعد صالح. البرنامج يمكن أن يستمر"
	arr["CHINESE",241]="规则文件的路径有效。脚本可以继续..."

	arr["ENGLISH",242]="Enter the path of a rules file:"
	arr["SPANISH",242]="Introduce la ruta de un fichero de reglas:"
	arr["FRENCH",242]="Saisissez un chemin vers un fichier règles d'attaque:"
	arr["CATALAN",242]="Introdueix la ruta d'un fitxer de regles:"
	arr["PORTUGUESE",242]="Digite o caminho para um arquivo de regras:"
	arr["RUSSIAN",242]="Введите путь файла с правилами:"
	arr["GREEK",242]="Εισάγετε το μονοπάτι για ένα αρχείο κανόνων:"
	arr["ITALIAN",242]="Immettere il percorso di un file di regole:"
	arr["POLISH",242]="Wprowadź ścieżkę do pliku reguł:"
	arr["GERMAN",242]="Geben Sie den Pfad einer Regeldatei ein:"
	arr["TURKISH",242]="Kural dosyasının dizinini girin:"
	arr["ARABIC",242]=":أدخل مسار ملف القواعد"
	arr["CHINESE",242]="输入规则文件的路径:"

	arr["ENGLISH",243]="Selected rules file: \${pink_color}\${RULES}\${normal_color}"
	arr["SPANISH",243]="Fichero de reglas seleccionado: \${pink_color}\${RULES}\${normal_color}"
	arr["FRENCH",243]="Fichier règles sélectionné: \${pink_color}\${RULES}\${normal_color}"
	arr["CATALAN",243]="Fitxer de regles seleccionat: \${pink_color}\${RULES}\${normal_color}"
	arr["PORTUGUESE",243]="Arquivo de regras selecionado: \${pink_color}\${RULES}\${normal_color}"
	arr["RUSSIAN",243]="Выбранный файл правил: \${pink_color}\${RULES}\${normal_color}"
	arr["GREEK",243]="Επιλεγμένο αρχείο κανόνων: \${pink_color}\${RULES}\${normal_color}"
	arr["ITALIAN",243]="File di regole selezionato: \${pink_color}\${RULES}\${normal_color}"
	arr["POLISH",243]="Wybrany plik reguł: \${pink_color}\${RULES}\${normal_color}"
	arr["GERMAN",243]="Ausgewählte Regeldatei: \${pink_color}\${RULES}\${normal_color}"
	arr["TURKISH",243]="Seçilen kural dosyası: \${pink_color}\${RULES}\${normal_color}"
	arr["ARABIC",243]="\${pink_color}\${RULES}\${blue_color} :ملف القواعد المحدد\${normal_color}"
	arr["CHINESE",243]="所选规则文件: \${pink_color}\${RULES}\${normal_color}"

	arr["ENGLISH",244]="Rule based attacks change the words of the dictionary list according to the rules written in the rules file itself. They are very useful. Some distros have predefined rule files (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["SPANISH",244]="Los ataques basados en reglas modifican las palabras de la lista del diccionario según las reglas escritas en el propio fichero de reglas. Son muy útiles. Algunas distros ya traen ficheros predefinidos de reglas (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["FRENCH",244]="Les attaques basées sur des règles modifient les mots du dictionnaire selon les règles établies dans le fichier règles. Ils sont très utiles. Certaines distros comportent des fichiers de règles prédéfinies (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["CATALAN",244]="Els atacs basats en regles modifiquen les paraules de la llista del diccionari segons les regles escrites en el propi fitxer de regles. Són molt útils. Algunes distros ja porten fitxers de regles predefinits (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["PORTUGUESE",244]="Ataques baseados em regras mudam as palavras de um dicionário de acordo com as regras escritas. Eles são muito úteis. Algumas distros já possuem regras predefinidas em (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["RUSSIAN",244]="Атака, основанная на правилах, изменяет слова из словаря в соответствии с правилами, написанными в самом файле правил. Они очень полезны. Некоторые дистрибутивы имеют предустановленные правила (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["GREEK",244]="Οι επιθέσεις κανόνων αλλάζουν τις λέξεις του λεξικού ανάλογα με τους κανόνες που έχουν γραφτεί στο αρχείο κανόνων. Είναι πολύ χρήσιμοι. Κάποιες διανομές έχουν προκαθορισμένα αρχεία κανόνων (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["ITALIAN",244]="Gli attacchi basato su regole cambiano le parole della lista del dizionario secondo le regole scritte nel file delle regole stesso. Essi sono molto utili. Alcune distribuzioni hanno giá file di regole predefiniti (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["POLISH",244]="Ataki bazujące na regułach modyfikują wyrazy ze słowników. Są bardzo przydatne. Niektóre dystrybucje Linuxa mają już predefiniowane pliki reguł (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["GERMAN",244]="Regelbasierte Angriffe modifizieren die Wörter in der Wörterbuchliste gemäß den Regeln, die in der Regeldatei selbst geschrieben sind. Sie sind sehr nützlich. Einige Distributionen bringen bereits vordefinierte Regeldateien mit (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["TURKISH",244]="Kural tabanlı saldırılar, kural listesindeki kurallara göre sözlük listesindeki kelimeleri değiştirir. Çok faydalılar. Bazı dağıtımlarda önceden tanımlanmış kural dosyaları vardır (Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules)"
	arr["ARABIC",244]="(Kali: /usr/share/hashcat/rules // Wifislax: /opt/hashcat/rules) تعدل الهجمات المستندة إلى القواعد الكلمات في القاموس وفقًا للقواعد الموضوعة في ملف القواعد. إنها مفيدة للغاية. تحتوي بعض التوزيعات على ملفات قواعد محددة مسبقًا"
	arr["CHINESE",244]="基于规则的密码破解根据规则文件本身中编写的规则更改字典列表中的单词。它们通常很有用。一些发行版有预定义的规则文件 (例如: Kali: /usr/share/hashcat/rules 和 Wifislax: /opt/hashcat/rules)"

	arr["ENGLISH",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["SPANISH",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["FRENCH",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["CATALAN",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["PORTUGUESE",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["RUSSIAN",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["GREEK",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["ITALIAN",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["POLISH",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["GERMAN",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["TURKISH",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"
	arr["ARABIC",245]="// \${normal_color}\${unknown_chipsetvar} \${yellow_color}:Chipset\${normal_color}"
	arr["CHINESE",245]="// \${yellow_color}Chipset:\${normal_color} \${unknown_chipsetvar}"

	arr["ENGLISH",246]="Every time you see a text with the prefix \${cyan_color}\${pending_of_translation}\${pink_color} acronym for \"Pending of Translation\", means the translation has been automatically generated and is still pending of review"
	arr["SPANISH",246]="Cada vez que veas un texto con el prefijo \${cyan_color}\${pending_of_translation}\${pink_color} acrónimo de \"Pending of Translation\", significa que su traducción ha sido generada automáticamente y que aún está pendiente de revisión"
	arr["FRENCH",246]="Chaque fois que vous voyez un texte précédé par \${cyan_color}\${pending_of_translation}\${pink_color} acronyme de \"Pending of Translation\" cela signifie que la traduction a été faite automatiquement et est en attente de correction"
	arr["CATALAN",246]="Cada vegada que vegis un text amb el prefix \${cyan_color}\${pending_of_translation}\${pink_color} acrònim de \"Pending of Translation\", vol dir que la traducció ha estat generada automàticament i encara està pendent de revisió"
	arr["PORTUGUESE",246]="Cada vez que você ver um texto com o prefixo \${cyan_color}\${pending_of_translation}\${pink_color} acrônimo para \"Pending of Translation\" significa que a tradução foi gerada automaticamente e ainda está pendente de revisão"
	arr["RUSSIAN",246]="Каждый раз, когда вы видите текст с префиксом \${cyan_color}\${pending_of_translation}\${pink_color} (акроним для \"Pending of Translation\"), это означает, что перевод был сгенерирован автоматически и ещё ожидает проверки"
	arr["GREEK",246]="Κάθε φορά που βλέπετε κάποιο κείμενο με πρόθεμα \${cyan_color}\${pending_of_translation}\${pink_color} (ακρωνύμιο για \"Pending of Translation\"), σημαίνει πως η μετάφραση δημιουργήθηκε αυτόματα και αναμένεται κριτική και πιθανή διόρθωση"
	arr["ITALIAN",246]="Ogni volta che vedi un testo con il prefisso \${cyan_color}\${pending_of_translation}\${pink_color} acronimo di \"Pending of Translation\" significa che la traduzione è stata generata automaticamente ed è ancora in attesa di revisione"
	arr["POLISH",246]="Za każdym razem, gdy zobaczysz tekst z symbolem \${cyan_color}\${pending_of_translation}\${pink_color} dla \"Pending of Translation\", to tłumaczenie zostało wygenerowane automatycznie i nadal oczekuje na ręczną korektę"
	arr["GERMAN",246]="Jedes Mal, wenn Sie einen Text mit dem Präfix \${cyan_color}\${pending_of_translation}\${pink_color} Akronym für \"Pending of Translation\" sehen, bedeutet dies, dass Ihre Übersetzung automatisch erstellt wurde"
	arr["TURKISH",246]="Yazılarda ön ek olarak \${cyan_color}\${pending_of_translation}\${pink_color} \"Pending of Translation\" görüyorsanız bunun anlamı; o yazı otomatik olarak çevirilmiş ve kontrol edilmeyi beklemektedir"
	arr["ARABIC",246]="يعني أن الترجمة قد تم إنشاؤها تلقائيا، وهو لا يزال في انتظار المراجعة \"Pending of Translation\" اختصار \${cyan_color}\${pending_of_translation}\${pink_color} في كل مرة ترى نصًا بالبادئة"
	arr["CHINESE",246]="每次您看到前缀为\${cyan_color}\${pending_of_translation}\${pink_color} (缩写为 \"Pending of Translation\") 的文本时，表示翻译已自动生成，但仍在等待人工审核"

	arr["ENGLISH",247]="Despite having all essential tools installed, your system uses airmon-zc instead of airmon-ng. In order to work properly you need to install ethtool and you don't have it right now. Please, install it and launch the script again"
	arr["SPANISH",247]="A pesar de tener todas las herramientas esenciales instaladas, tu sistema usa airmon-zc en lugar de airmon-ng. Para poder funcionar necesitas tener instalado ethtool y tú no lo tienes en este momento. Por favor, instálalo y vuelve a lanzar el script"
	arr["FRENCH",247]="En dépit d'avoir tous les outils essentiels installés votre système utilise airmon-zc au lieu de airmon-ng. Vous devez installer ethtool que vous n'avez pas à ce moment. S'il vous plaît, installez-le et relancez le script"
	arr["CATALAN",247]="Tot i tenir totes les eines essencials instal·lades, el teu sistema fa servir airmon-zc en lloc del airmon-ng. Per poder funcionar necessites tenir instal·lat ethtool i tu no el tens en aquest moment. Si us plau, instal·la-ho i torna a executar el script"
	arr["PORTUGUESE",247]="Apesar de ter todas as ferramentas essenciais instaladas, o sistema utiliza airmon-zc em vez de airmon-ng. Para funcionar você precisa instalar ethtool e você não tem neste momento. Por favor, instale e execute o script novamente"
	arr["RUSSIAN",247]="Не смотря на то, что все базовые инструменты установлены, система использует airmon-zc вместо airmon-ng. Чтобы работать должным образом, должен быть установлен пакет ethtool, а в данный момент он отсутствует. Пожалуйста, установите его и запустите скрипт снова"
	arr["GREEK",247]="Παρά του ότι είναι εγκατεστημένα όλα τα απραίτητα εργαλεία, το σύστημά σας χρησιμοποιεί το airmon-zc αντί το airmon-ng. Για να λειτουργήσει σωστά πρέπει να εγκαταστήσετε το ethtool το οποίο δεν το έχετε αυτή τη στιγμή. Παρακαλώ, εγκαταστήστε το και ξανανοίξτε το script"
	arr["ITALIAN",247]="Pur avendo tutti gli strumenti essenziali installati, il sistema utilizza airmon-zc invece di airmon-ng. Per funzionare è necessario installare ethtool e tu non lo hai in questo momento. Si prega di installaro e lanciare nuovamente lo script"
	arr["POLISH",247]="Mimo, iż zainstalowano wszystkie niezbędne narzędzia, twój system zamiast airmon-ng wykorzystuje airmon-zc. Aby móc korzystać ze skryptu, musisz zainstalować program ethtool, którego obecnie nie masz. Zainstaluj go i ponownie uruchom skrypt"
	arr["GERMAN",247]="Obwohl alle wesentlichen Tools installiert sind, verwendet Ihr System airmon-zc anstelle von airmon-ng. Um zu arbeiten, müssen Sie ethtool installiert haben und Sie haben es zur Zeit nicht. Bitte installieren Sie es und starten Sie das Skript erneut"
	arr["TURKISH",247]="Tüm gerekli araçlara sahip olmanıza rağmen, sisteminiz airmon-ng yerine airmon-zc kullanıyor. Düzgün çalışması için ethtool yüklemeniz gerekiyor ve şu anda ona sahip değilsiniz. Lütfen kurun ve komut dosyasını tekrar başlatın"
	arr["ARABIC",247]="وليس لديك الآن. من فضلك ، قم بتثبيته وتشغيل البرنامج النصي مرة أخرى ethtool لكي تعمل بشكل صحيح ، تحتاج إلى تثبيت .airmon-ng بدلاً من airmon-zc على الرغم من تثبيت جميع الأدوات الأساسية ، فإن نظامك يستخدم"
	arr["CHINESE",247]="尽管安装了所有必要的工具，您的系统还是使用 airmon-zc 而不是 airmon-ng。为了脚本能够正常工作，您需要安装 ethtool，请安装它并再次启动脚本"

	arr["ENGLISH",248]="noisy mode, non stop"
	arr["SPANISH",248]="modo noisy, sin interrupciones"
	arr["FRENCH",248]="mode bruyant, pas d'interruptions"
	arr["CATALAN",248]="mode noisy, sense interrupcions"
	arr["PORTUGUESE",248]="modo agressivo, constante"
	arr["RUSSIAN",248]="noisy режим (работает пока не остановлен явно)"
	arr["GREEK",248]="noisy mode, χωρίς διακοπές"
	arr["ITALIAN",248]="modalità noisy, senza interruzioni"
	arr["POLISH",248]="tryb noisy, bez przerw"
	arr["GERMAN",248]="noisy-Modus, ununterbrochen"
	arr["TURKISH",248]="noisy mod, aralıksız"
	arr["ARABIC",248]="بدون توقف ، noisy mode الوضع"
	arr["CHINESE",248]="嘈杂模式，不停止"

	arr["ENGLISH",249]="5.  Portuguese"
	arr["SPANISH",249]="5.  Portugués"
	arr["FRENCH",249]="5.  Portugais"
	arr["CATALAN",249]="5.  Portuguès"
	arr["PORTUGUESE",249]="5.  Português"
	arr["RUSSIAN",249]="5.  Португальский"
	arr["GREEK",249]="5.  Πορτογαλικά"
	arr["ITALIAN",249]="5.  Portoghese"
	arr["POLISH",249]="5.  Portugalski"
	arr["GERMAN",249]="5.  Portugiesisch"
	arr["TURKISH",249]="5.  Portekizce"
	arr["ARABIC",249]="5.  البرتغالية"
	arr["CHINESE",249]="5.  葡萄牙语"

	arr["ENGLISH",250]="If you see any bad translation or just want \${cyan_color}\${pending_of_translation}\${pink_color} marks to dissapear, write me to \${normal_color}\${mail}\${pink_color} to collaborate with translations"
	arr["SPANISH",250]="Si ves alguna traducción incorrecta o quieres que desparezcan las marcas \${cyan_color}\${pending_of_translation}\${pink_color}, escríbeme a \${normal_color}\${mail}\${pink_color} para colaborar con las traducciones"
	arr["FRENCH",250]="Si vous voyez des erreurs et contresens ou si vous voulez voir les marques \${cyan_color}\${pending_of_translation}\${pink_color} disparaitre, écrivez à \${normal_color}\${mail}\${pink_color} pour collaborer avec les traductions"
	arr["CATALAN",250]="Si veus alguna traducció incorrecta o vols que desapareguin les marques \${cyan_color}\${pending_of_translation}\${pink_color}, escriu-me a \${normal_color}\${mail}\${pink_color} per col·laborar amb les traduccions"
	arr["PORTUGUESE",250]="Se você ver qualquer erro de tradução ou quer que as marcas \${cyan_color}\${pending_of_translation}\${pink_color} sejam retiradas, escreva para \${normal_color}\${mail}\${pink_color} para colaborar com as traduções"
	arr["RUSSIAN",250]="Если вы видите плохой перевод или просто хотите снять пометку \${cyan_color}\${pending_of_translation}\${pink_color} напишите мне на \${normal_color}\${mail}\${pink_color} для сотрудничества с переводчиками"
	arr["GREEK",250]="Αν δείτε κάποια λανθασμένη ή ατελής μετάφραση ή απλά θέλετε τα σημάδια \${cyan_color}\${pending_of_translation}\${pink_color} να εξαφανιστούν, στείλτε μου στο \${normal_color}\${mail}\${pink_color} για να συνεργαστούμε με τις μεταφράσεις"
	arr["ITALIAN",250]="Se vedi qualche errore di traduzione o vuoi che spariscano le marche \${cyan_color}\${pending_of_translation}\${pink_color}, scrivimi a \${normal_color}\${mail}\${pink_color} per collaborare con le traduzioni"
	arr["POLISH",250]="Jeśli widzisz nieprawidłowe tłumaczenie lub chcesz usunąć tagi \${cyan_color}\${pending_of_translation}\${pink_color}, napisz do mnie \${normal_color}\${mail}\${pink_color}, aby współpracować przy tłumaczeniu"
	arr["GERMAN",250]="Wenn Sie eine falsche Übersetzung sehen oder möchten, dass die Marken \${cyan_color}\${pending_of_translation}\${pink_color} verschwinden, schreiben Sie mich an \${normal_color}\${mail}\${pink_color}, um mit den Übersetzungen zusammenzuarbeiten"
	arr["TURKISH",250]="Eğer kötü bir çeviri gördüyseniz veya sadece çeviri yapmak istiyorsanız \${cyan_color}\${pending_of_translation}\${pink_color} işaretleyip bana yazın. \${normal_color}\${mail}"
	arr["ARABIC",250]="\${normal_color}\${mail}\${pink_color} للتعاون مع الترجمات \${cyan_color}\${pending_of_translation}\${pink_color} رؤية العلامات تختفي ، فاكتب لي إلى إذا رأيت أي ترجمة سيئة أو أردت فقط"
	arr["CHINESE",250]="如果你看到任何不好的翻译或者只是想让 \${cyan_color}\${pending_of_translation}\${pink_color} 标记消失，写信给我到 \${normal_color}\${mail}\${pink_color} 与翻译合作"

	arr["ENGLISH",251]="You have chosen the same language that was selected. No changes will be done"
	arr["SPANISH",251]="Has elegido el mismo idioma que estaba seleccionado. No se realizarán cambios"
	arr["FRENCH",251]="Vous venez de choisir la langue qui est en usage. Pas de changements"
	arr["CATALAN",251]="Has triat el mateix idioma que estava seleccionat. No es realitzaran canvis"
	arr["PORTUGUESE",251]="Você escolheu o mesmo idioma que estava selecionado. Nenhuma alteração será feita"
	arr["RUSSIAN",251]="Вы выбрали такой же язык, какой и был. Никаких изменений не будет сделано"
	arr["GREEK",251]="Επιλέξατε την ίδια γλώσσα που ήταν ήδη επιλεγμένη. Δεν θα γίνει καμία αλλαγή"
	arr["ITALIAN",251]="Hai scelto la stessa lingua che è giá selezionata. Non sará effettutata nessuna modifica"
	arr["POLISH",251]="Wybrałeś ten sam język, który jest używany. Żadne zmiany nie zostaną wprowadzone"
	arr["GERMAN",251]="Sie haben die selbe Sprache ausgewählt. Es werden keine Änderungen vorgenommen"
	arr["TURKISH",251]="Seçilmiş olan dili seçtiniz. Hiçbir değişiklik yapılmayacak"
	arr["ARABIC",251]="لقد اخترت نفس اللغة التي تم اختيارها. لن يتم إجراء أي تغييرات"
	arr["CHINESE",251]="您选择的语言与当前语言相同。不会做任何改变"

	arr["ENGLISH",252]="7.  Evil Twin attacks menu"
	arr["SPANISH",252]="7.  Menú de ataques Evil Twin"
	arr["FRENCH",252]="7.  Menu des attaques Evil Twin"
	arr["CATALAN",252]="7.  Menú d'atacs Evil Twin"
	arr["PORTUGUESE",252]="7.  Menu de ataques Evil Twin"
	arr["RUSSIAN",252]="7.  Меню атак Злой Двойник"
	arr["GREEK",252]="7.  Μενού επιθέσεων Evil Twin"
	arr["ITALIAN",252]="7.  Menu degli attacchi Evil Twin"
	arr["POLISH",252]="7.  Menu ataków Evil Twin"
	arr["GERMAN",252]="7.  Evil Twin Angriffsmenü"
	arr["TURKISH",252]="7.  Şeytani İkiz saldırısı menüsü"
	arr["ARABIC",252]="7.  Evil Twin قائمة هجمات"
	arr["CHINESE",252]="7.  邪恶双胞胎 AP 攻击菜单"

	arr["ENGLISH",253]="Evil Twin attacks menu"
	arr["SPANISH",253]="Menú de ataques Evil Twin"
	arr["FRENCH",253]="Menu des attaques Evil Twin"
	arr["CATALAN",253]="Menú d'atacs Evil Twin"
	arr["PORTUGUESE",253]="Menu de ataques Evil Twin"
	arr["RUSSIAN",253]="Меню атак Злой Двойник"
	arr["GREEK",253]="Μενού επιθέσεων Evil Twin"
	arr["ITALIAN",253]="Menu degli attacchi Evil Twin"
	arr["POLISH",253]="Menu ataków Evil Twin"
	arr["GERMAN",253]="Evil Twin Angriffsmenü"
	arr["TURKISH",253]="Şeytani İkiz saldırısı menüsü"
	arr["ARABIC",253]="Evil Twin قائمة هجمات"
	arr["CHINESE",253]="邪恶双胞胎攻击菜单"

	arr["ENGLISH",254]="In order to use the Evil Twin just AP and sniffing attacks, you must have another one interface in addition to the wifi network interface will become the AP, which will provide internet access to other clients on the network. This doesn't need to be wifi, can be ethernet"
	arr["SPANISH",254]="Para utilizar los ataques de Evil Twin de solo AP y con sniffing, deberás tener además de la interfaz wifi que se transformará en el AP, otra interfaz de red con acceso a internet para proporcionar este servicio a otros clientes de la red. Esta no hace falta que sea wifi, puede ser ethernet"
	arr["FRENCH",254]="Pour effectuer l'attaque Evil Twin combinant Rogue AP et capture des données vous avez besoin d'une interface réseau en plus de celle utilisée pour créer le point d'accès. Cette interface supplémentaire devra être connecté à l'internet afin d'en proportionner l'accès aux clients du réseau. L'interface peut être une interface ethernet ou wifi"
	arr["CATALAN",254]="Per utilitzar els atacs d'Evil Twin només amb AP i sniffing, hauràs de tenir a més de la interfície wifi que es transformarà en el AP, una altre interfície de xarxa amb accés a internet per proporcionar aquest servei a altres clients de la xarxa. Aquesta no cal que sigui wifi, pot ser ethernet"
	arr["PORTUGUESE",254]="Para usar ataques Evil Twin Somente AP e com sniffing, você deve ter além da interface wifi que se tornará o AP, uma outra interface de rede com acesso à internet para fornecer este serviço a outros clientes da rede. Não precisa ser wifi, pode ser ethernet"
	arr["RUSSIAN",254]="Чтобы использовать Злого Двойника точки доступа и атаку сниффинга, вы должны иметь другой интерфейс в дополнение к сетевому интерфейсу wifi. Сетевой интерфейс wifi станет точкой доступа, к которому будут подключаться жертвы. Для того, чтобы у этой точки доступа было Интернет-подключение и используется второй сетевой адаптер. Ему необязательно быть wifi, достаточно ethernet"
	arr["GREEK",254]="Για να χρησιμοποιήσετε τις επιθέσεις sniffing και Evil Twin με AP, πρέπει να έχετε άλλη μία διεπαφή παράλληλα με την διεπαφή δικτύου wifi που θα γίνει AP, η οποία θα παρέχει πρόσβαση στο διαδίκτυο στους άλλες χρήστες του δικτύου. Δεν χρειάζεται να είναι wifi, μπορεί να έιναι και ethernet"
	arr["ITALIAN",254]="Per utilizzare gli attacchi Evil Twin con solo AP e con sniffing, è necessario che, oltre all'interfaccia wifi che diventerà l'AP, sia presente un'altra interfaccia di rete con connessione internet per fornire questo servizio agli altri clienti della rete. Questo non ha bisogno di essere wifi, può essere ethernet"
	arr["POLISH",254]="Aby używać ataków Evil Twin tylko z AP i sniffingiem pakietów, musisz oprócz interfejsu wifi, który stanie się AP, posiadać drugi interfejs sieciowy z dostępem do internetu, aby go udzielić innym klientom w sieci. To nie musi być wifi, może to być ethernet"
	arr["GERMAN",254]="Um die Evil-Twin-Angriffe von nur AP und mit Sniffing zu verwenden, müssen Sie zusätzlich zu dem WLAN-Interface, das in den AP umgewandelt wird, ein anderes Netzwerk-Interface mit Internetzugang haben, um diesen Dienst anderen Clients im Netzwerk bereitzustellen. Dies muss nicht WLAN sein, es kann Ethernet sein"
	arr["TURKISH",254]="Evil Twin'i sadece AP ve sniffing saldırılarını kullanmak için, ağdaki diğer istemcilere internet erişimi sağlayacak olan WiFi ağ arayüzüne ek olarak başka bir arabiriminiz de AP olacaktır. Bu wifi olması gerekmez, ethernet olabilir"
	arr["ARABIC",254]="ethernet يمكن أن يكون ، wifi والتي ستوفر الوصول إلى الإنترنت للعملاء الآخرين على الشبكة. هذا لا يلزم أن يكون ، AP ستصبح wifi وهجمات الشم ، يجب أن يكون لديك واجهة واحدة أخرى بالإضافة إلى واجهة شبكة Evil Twin just AP من أجل استخدام"
	arr["CHINESE",254]="为了使用邪恶双胞胎 (仅 AP) 嗅探攻击，除了已选择的 wifi 网络接口将成为 AP 之外，您还必须有另一个接口，它将为网络上的其他客户端提供互联网访问。这不需要是 wifi，可以是以太网"

	arr["ENGLISH",255]="without sniffing, just AP"
	arr["SPANISH",255]="sin sniffing, solo AP"
	arr["FRENCH",255]="rogue AP sans capture des données"
	arr["CATALAN",255]="sense sniffing, només AP"
	arr["PORTUGUESE",255]="somente AP, sem sniffing"
	arr["RUSSIAN",255]="без сниффинга, просто ТД"
	arr["GREEK",255]="χωρίς sniffing, μόνο AP"
	arr["ITALIAN",255]="senza sniffing, solo AP"
	arr["POLISH",255]="brak sniffingu, tylko AP"
	arr["GERMAN",255]="kein Sniffing, nur AP"
	arr["TURKISH",255]="siniffing olmadan, sadece AP"
	arr["ARABIC",255]="AP بدون شم ، فقط"
	arr["CHINESE",255]="仅 AP 模式 (无嗅探)"

	arr["ENGLISH",256]="5.  Evil Twin attack just AP"
	arr["SPANISH",256]="5.  Ataque Evil Twin solo AP"
	arr["FRENCH",256]="5.  Attaque Evil Twin Rogue AP simple"
	arr["CATALAN",256]="5.  Atac Evil Twin només AP"
	arr["PORTUGUESE",256]="5.  Ataque Evil Twin só AP"
	arr["RUSSIAN",256]="5.  Атака Злой Двойник, только ТД"
	arr["GREEK",256]="5.  Επίθεση Evil Twin μόνο AP"
	arr["ITALIAN",256]="5.  Attacco Evil Twin solo AP"
	arr["POLISH",256]="5.  Atak Evil Twin tylko AP"
	arr["GERMAN",256]="5.  Attack Evil Twin nur AP"
	arr["TURKISH",256]="5.  Şeytani İkiz saldırısı sadece AP"
	arr["ARABIC",256]="5.  Evil Twin فقط AP هجوم"
	arr["CHINESE",256]="5.  邪恶双胞胎攻击 (仅 AP)"

	arr["ENGLISH",257]="with sniffing"
	arr["SPANISH",257]="con sniffing"
	arr["FRENCH",257]="avec capture des données"
	arr["CATALAN",257]="amb sniffing"
	arr["PORTUGUESE",257]="com sniffing"
	arr["RUSSIAN",257]="со сниффингом"
	arr["GREEK",257]="με sniffing"
	arr["ITALIAN",257]="con sniffing"
	arr["POLISH",257]="ze sniffingiem"
	arr["GERMAN",257]="mit sniffing"
	arr["TURKISH",257]="sniffing ile"
	arr["ARABIC",257]="مع شم"
	arr["CHINESE",257]="使用嗅探"

	arr["ENGLISH",258]="If you use the attack without sniffing, just the AP, you can use any external sniffer script"
	arr["SPANISH",258]="Si utilizas el ataque sin sniffing, solo AP, podrás usar cualquier programa sniffer externo al script"
	arr["FRENCH",258]="Si vous lancez l'attaque sans capture des données (Rogue AP) vous pouvez utiliser un programme externe pour les capturer"
	arr["CATALAN",258]="Si utilitzes l'atac sense sniffing, només AP, podràs fer servir qualsevol programa sniffer extern a l'script"
	arr["PORTUGUESE",258]="Se você usar o ataque sem sniffing, apenas AP, você pode usar qualquer programa sniffer externo ao script"
	arr["RUSSIAN",258]="Если вы используете атаку без сниффинга, только ТД, то вы сможете использовать любое внешнее ПО для сниффинга"
	arr["GREEK",258]="Αν χρησιμοποιήσετε την επίθεση χωρίς sniffing, μόνο AP, θα μπορείτε να χρησιμοποιήσετε οποιοδήποτε εξωτερίκό sniffer script"
	arr["ITALIAN",258]="Se si utilizza l'attacco senza sniffing, solo AP, è possibile utilizzare qualsiasi programma di sniffer esterno per lo script"
	arr["POLISH",258]="Jeśli użyjesz ataku bez sniffingu, tylko AP, możesz użyć dowolnego zewnętrznego programu sniffującego"
	arr["GERMAN",258]="Wenn Sie den Angriff ohne Sniffing, nur AP, verwenden, können Sie jedes Sniffer-Programm außerhalb des Skripts verwenden"
	arr["TURKISH",258]="Saldırıyı kullanmadan sadece AP'yi kullanırsanız, sniffer yazılımı için herhangi bir harici komut kullanabilirsiniz"
	arr["ARABIC",258]="يمكنك استخدام أي برنامج خارجي للشم ، AP إذا كنت تستخدم الهجوم بدون شم ، فقط"
	arr["CHINESE",258]="如果你在没有进行流量嗅探的情况下进行攻击，那么你可以使用任何外部嗅探器脚本"

	arr["ENGLISH",259]="6.  Evil Twin AP attack with sniffing"
	arr["SPANISH",259]="6.  Ataque Evil Twin AP con sniffing"
	arr["FRENCH",259]="6.  Attaque Evil Twin avec Rogue AP et capture des données"
	arr["CATALAN",259]="6.  Atac Evil Twin AP amb sniffing"
	arr["PORTUGUESE",259]="6.  Ataque Evil Twin AP com sniffing"
	arr["RUSSIAN",259]="6.  Атака Злой Двойник ТД со сниффингом"
	arr["GREEK",259]="6.  Επίθεση Evil Twin AP με sniffing"
	arr["ITALIAN",259]="6.  Attacco Evil Twin AP con sniffing"
	arr["POLISH",259]="6.  Atak Evil Twin AP ze sniffingiem"
	arr["GERMAN",259]="6.  Evil Twin AP Angriff mit Sniffing"
	arr["TURKISH",259]="6.  Şeytani İkiz AP Saldırısı sniffing ile birlikte"
	arr["ARABIC",259]="6.  مع الشم Evil Twin AP هجوم"
	arr["CHINESE",259]="6.  邪恶双胞胎 AP 流量嗅探攻击"

	arr["ENGLISH",260]="6.  Smooth mode Enterprise Evil Twin"
	arr["SPANISH",260]="6.  Evil Twin Enterprise modo smooth"
	arr["FRENCH",260]="6.  Evil Twin Enterprise mode silencieux"
	arr["CATALAN",260]="6.  Evil Twin Enterprise mode smooth"
	arr["PORTUGUESE",260]="6.  Evil Twin Enterprise (discreto)"
	arr["RUSSIAN",260]="6.  Smooth режим Enterprise Evil Twin"
	arr["GREEK",260]="6.  Smooth mode Enterprise Evil Twin"
	arr["ITALIAN",260]="6.  Evil Twin Enterprise modalità smooth"
	arr["POLISH",260]="6.  Enterprise Evil Twin w trybie smooth"
	arr["GERMAN",260]="6.  Smooth-Modus Enterprise Evil Twin"
	arr["TURKISH",260]="6.  Smooth mod Enterprise Evil Twin"
	arr["ARABIC",260]="6.  Smooth mode Enterprise Evil Twin وضع"
	arr["CHINESE",260]="6.  平滑模式下针对企业级加密的邪恶双胞胎"

	arr["ENGLISH",261]="7.  Evil Twin AP attack with sniffing and bettercap-sslstrip2"
	arr["SPANISH",261]="7.  Ataque Evil Twin AP con sniffing y bettercap-sslstrip2"
	arr["FRENCH",261]="7.  Attaque Evil Twin avec capture des données et bettercap-sslstrip2"
	arr["CATALAN",261]="7.  Atac Evil Twin AP amb sniffing i bettercap-sslstrip2"
	arr["PORTUGUESE",261]="7.  Ataque Evil Twin AP com sniffing e bettercap-sslstrip2"
	arr["RUSSIAN",261]="7.  Атака Злой Двойник ТД со сниффингом и bettercap-sslstrip2"
	arr["GREEK",261]="7.  Επίθεση Evil Twin AP με sniffing και bettercap-sslstrip2"
	arr["ITALIAN",261]="7.  Attacco Evil Twin AP con sniffing e bettercap-sslstrip2"
	arr["POLISH",261]="7.  Ataku Evil Twin AP ze sniffingiem i bettercap-sslstrip2"
	arr["GERMAN",261]="7.  Evil Twin AP Angriff mit Sniffing und bettercap-sslstrip2"
	arr["TURKISH",261]="7.  Şeytani İkiz AP saldırısı sniffing ve bettercap-sslstrip2 ile birlikte"
	arr["ARABIC",261]="7.  bettercap-sslstrip2 مع الشم و Evil Twin AP هجوم"
	arr["CHINESE",261]="7.  使用嗅探和 bettercap-sslstrip2 进行邪恶双胞胎 AP 攻击"

	arr["ENGLISH",262]="without sniffing, captive portal"
	arr["SPANISH",262]="sin sniffing, portal cautivo"
	arr["FRENCH",262]="sans capture des données avec portail captif"
	arr["CATALAN",262]="sense sniffing, portal captiu"
	arr["PORTUGUESE",262]="sem sniffing, portal cativo"
	arr["RUSSIAN",262]="без сниффинга, перехватывающий портал"
	arr["GREEK",262]="χωρίς sniffing, captive portal"
	arr["ITALIAN",262]="senza sniffing, captive portal"
	arr["POLISH",262]="bez sniffingu, captive portal"
	arr["GERMAN",262]="ohne Sniffing, Captive Portal"
	arr["TURKISH",262]="sniffing olmadan, esaret portalı"
	arr["ARABIC",262]="بدون شم مع البوابة الأسيرة"
	arr["CHINESE",262]="没有嗅探，俘虏门户"

	arr["ENGLISH",263]="9.  Evil Twin AP attack with captive portal (monitor mode needed)"
	arr["SPANISH",263]="9.  Ataque Evil Twin AP con portal cautivo (modo monitor requerido)"
	arr["FRENCH",263]="9.  Attaque Evil Twin avec portail captif (mode moniteur nécessaire)"
	arr["CATALAN",263]="9.  Atac Evil Twin AP amb portal captiu (es requereix mode monitor)"
	arr["PORTUGUESE",263]="9.  Ataque Evil Twin AP com portal cativo (modo monitor obrigatório)"
	arr["RUSSIAN",263]="9.  Атака Злой Двойник ТД с перехватывающим порталом (необходим режим монитора)"
	arr["GREEK",263]="9.  Επίθεση Evil Twin AP με captive portal (χρειάζεται η κατάσταση παρακολούθησης)"
	arr["ITALIAN",263]="9.  Attacco Evil Twin AP con captive portal (modalità monitor richiesta)"
	arr["POLISH",263]="9.  Atak Evil Twin AP z captive portal (wymagany tryb monitorowania)"
	arr["GERMAN",263]="9.  Evil Twin AP Angriff mit Captive Portal (monitor-Modus erforderlich)"
	arr["TURKISH",263]="9.  Şeytani İkiz AP saldırısı esaret portalı ile birlikte (izleme modu gerekli)"
	arr["ARABIC",263]="9.  (مطلوب monitor mode مع بوابة أسيرة (وضع Evil Twin AP هجوم"
	arr["CHINESE",263]="9.  邪恶双胞胎 AP 攻击与俘虏门户 (需要监听模式)"

	arr["ENGLISH",264]="The captive portal attack tries to one of the network clients provide us the password for the wifi network by entering it on our portal"
	arr["SPANISH",264]="El ataque del portal cautivo intentará conseguir que uno de los clientes de la red nos proporcione la contraseña de la red wifi introduciéndola en nuestro portal"
	arr["FRENCH",264]="Le portail captif d'attaque tente d'obtenir l'un des clients du réseau nous fournir le mot de passe pour le réseau sans fil en entrant sur notre site"
	arr["CATALAN",264]="L'atac de portal captiu intenta aconseguir que un dels clients de la xarxa ens proporcioni la contrasenya de la xarxa wifi introduint-la al nostre portal"
	arr["PORTUGUESE",264]="O ataque com portal cativo tenta fazer com que um dos clientes da rede nos forneça a senha digitando-a em nosso site"
	arr["RUSSIAN",264]="Атака с перехватывающим порталом заключается в том, что мы ждём когда кто-то из пользователей введёт верный пароль от Wi-Fi на веб-странице, которую мы ему показываем"
	arr["GREEK",264]="Η επίθεση captive portal κάνει έναν από τους χρήστες του δικτύου να μας παρέχει τον κωδικό πρόσβασης του δικτύου wifi βάζοντάς τον στο portal μας"
	arr["ITALIAN",264]="L'attacco con il captive portal cercherà di ottenere che uno dei clienti della rete ci dia la password per la rete wireless inserendola sul nostro sito"
	arr["POLISH",264]="Atak w portalu captive spróbuje uzyskać hasło WiFi od jednego z klientów sieci, który wprowadzi je w naszym portalu"
	arr["GERMAN",264]="Der Angriff des Captive-Portals wird versuchen, einen der Clients des Netzwerks dazu zu bringen, uns das WLAN-Passwort zur Verfügung zu stellen, indem sie es in unser Portal eingeben"
	arr["TURKISH",264]="Esaret Portalı saldırısı, ağ istemcilerinden birinin portalımıza girerek wifi ağı için şifre sağlamasını dener"
	arr["ARABIC",264]="عن طريق إدخالها على بوابتنا wifi يحاول هجوم البوابة الأسيرة أن يقوم أحد عملاء الشبكة بتزويدنا بكلمة مرور شبكة"
	arr["CHINESE",264]="强制门户攻击通过在我们的门户上输入 wifi 网络的密码来向其中一个网络客户端提供密码"

	arr["ENGLISH",265]="Evil Twin deauth"
	arr["SPANISH",265]="Desautenticación para Evil Twin"
	arr["FRENCH",265]="Dés-authentification pour Evil Twin"
	arr["CATALAN",265]="Desautenticació per Evil Twin"
	arr["PORTUGUESE",265]="Desautenticação para Evil Twin"
	arr["RUSSIAN",265]="Деаутентификация для Злого Двойника"
	arr["GREEK",265]="Evil Twin deauth"
	arr["ITALIAN",265]="Deautenticazione per Evil Twin"
	arr["POLISH",265]="Deautentykacja dla Evil Twin"
	arr["GERMAN",265]="Deauthentifizierung für das Evil Twin"
	arr["TURKISH",265]="Şeytani İkiz deauth"
	arr["ARABIC",265]="Evil Twin إلغاء المصادقة على"
	arr["CHINESE",265]="邪恶双胞胎死亡"

	arr["ENGLISH",266]="0.  Return to Evil Twin attacks menu"
	arr["SPANISH",266]="0.  Volver al menú de ataques Evil Twin"
	arr["FRENCH",266]="0.  Retour au menu d'attaques Evil Twin"
	arr["CATALAN",266]="0.  Tornar al menú d'atacs Evil Twin"
	arr["PORTUGUESE",266]="0.  Voltar ao menu de ataques Evil Twin"
	arr["RUSSIAN",266]="0.  Вернуться в меню атак Злой Двойник"
	arr["GREEK",266]="0.  Επιστροφή στο μενού επιθέσεων Evil Twin"
	arr["ITALIAN",266]="0.  Tornare al menu attacchi Evil Twin"
	arr["POLISH",266]="0.  Wróć do menu Evil Twin Atak"
	arr["GERMAN",266]="0.  Zurück zum Evil Twin Angriffsmenü"
	arr["TURKISH",266]="0.  Şeytani İkiz saldırı menüsüne geri dön"
	arr["ARABIC",266]="0.  Evil Twin ارجع إلى قائمة هجمات"
	arr["CHINESE",266]="0.  返回邪恶双胞胎攻击菜单"

	arr["ENGLISH",267]="If you can't deauth clients from an AP using an attack, choose another one :)"
	arr["SPANISH",267]="Si no consigues desautenticar a los clientes de un AP con un ataque, elige otro :)"
	arr["FRENCH",267]="Si vous ne pouvez pas dé-authentifier des clients avec une attaque, choisissez-en une autre :)"
	arr["CATALAN",267]="Si no aconsegueixes desautenticar als clients d'un AP amb un atac, tria un altre :)"
	arr["PORTUGUESE",267]="Se você não conseguir desautenticar clientes de um AP usando um ataque, escolha outro :)"
	arr["RUSSIAN",267]="Если вы не можете деаутентифицировать клиентов от ТД используя эту атаку, выберите другую :)"
	arr["GREEK",267]="Αν δεν μπορείτε να κάνετε deauth τους χρήστες από ένα AP χρησιμοποιώντας μία επίθεση, διαλέξτε κάποια άλλη :)"
	arr["ITALIAN",267]="Se non è possibile scollegare i clienti da un AP con un attacco, scegline un altro :)"
	arr["POLISH",267]="Jeśli nie możesz deautentykować klientów AP tym atakiem, wybierz inny :)"
	arr["GERMAN",267]="Wenn es Ihnen nicht gelingt, die Clients eines AP mit einem Angriff zu deaktivieren, wählen Sie einen anderen :)"
	arr["TURKISH",267]="Eğer deauth yapamadıysanız başka bir yöntem seçiniz :)"
	arr["ARABIC",267]="(: باستخدام هجوم ، فاختر واحدًا آخر  AP إذا لم تتمكن من إلغاء مصادقة العملاء من"
	arr["CHINESE",267]="如果您无法迫使 AP 中的客户端取消身份验证，请选择另一个无线 AP 再次尝试攻击 :)"

	arr["ENGLISH",268]="With this attack, we'll try to deauth clients from the legitimate AP. Hopefully they'll reconnect to our Evil Twin AP"
	arr["SPANISH",268]="Con este ataque, intentaremos desautenticar a los clientes del AP legítimo. Con suerte reconectarán pero a nuestro Evil Twin AP"
	arr["FRENCH",268]="Avec cette attaque nous essayons de déconnecter des clients du point d'accès légitime en espérant qu'ils se connectent au notre Evil Twin AP"
	arr["CATALAN",268]="Amb aquest atac, intentarem desautenticar als clients del AP legítim. Amb sort reconectarán però al nostre Evil Twin AP"
	arr["PORTUGUESE",268]="Com este ataque, tentamos desautenticar clientes do AP legítimo e esperemos que eles se reconectem no nosso AP Evil Twin"
	arr["RUSSIAN",268]="Этой атакой мы попытаемся деаутентифицировать клиентов от легитимной ТД. В надежде, что они переподключатся к нашему Злому Двойнику ТД"
	arr["GREEK",268]="Με αυτήν την επίθεση, θα προσπαθήσουμε να κάνουμε deauth τους χρήστες από το αρχικό AP. Ας ελπίσουμε ότι θα επανασυνδεθούν στο Evil Twin AP μας"
	arr["ITALIAN",268]="Con questo attacco, si cerca di scollegare i clienti dal AP legittimo. Se abbiamo fortuna si riconnetteranno al nostro Evil Twin AP"
	arr["POLISH",268]="W tym ataku podejmiemy próbę deautentykacji legalnych klientów AP. Dzięki temu być może połączą się z naszym Evil Twin AP"
	arr["GERMAN",268]="Mit diesem Angriff werden wir versuchen, die Clients des legitimen AP zu deaktivieren. Hoffentlich werden sie sich wieder mit unserem Evil Twin AP verbinden"
	arr["TURKISH",268]="Bu saldırı ile, istemcileri meşru AP'den çıkarmaya çalışacağız. Umarız Şeytani İkiz AP'ye tekrar bağlanırlar"
	arr["ARABIC",268]="مع هذا الهجوم ، سنحاول إلغاء مصادقة العملاء من AP المشروعة. نأمل أن يعيدوا الاتصال بـ Evil Twin AP"
	arr["CHINESE",268]="通过这次攻击，我们将尝试从合法 AP 中取消客户端的身份验证。希望他们能重新连接到我们邪恶双胞胎的 AP"

	arr["ENGLISH",269]="To perform an Evil Twin attack you'll need to be very close to the target AP or have a very powerful wifi antenna. Your signal must reach clients equally strong or more than the legitimate AP"
	arr["SPANISH",269]="Para realizar un ataque Evil Twin necesitarás estar muy cerca del AP objetivo o tener una antena wifi muy potente. Tu señal ha de llegar a los clientes igual de fuerte o más que la del AP legítimo"
	arr["FRENCH",269]="Pour mener à bien une attaque Evil Twin il vous faut être dans de bonnes conditions d'émission et de réception tantôt avec le point d'accès qu'avec le(s) client(s)"
	arr["CATALAN",269]="Per realitzar un atac Evil Twin et caldrà estar molt a prop de l'AP objectiu o tenir una antena wifi molt potent. El teu senyal ha d'arribar als clients igual de fort o més que la de l'AP legítim"
	arr["PORTUGUESE",269]="Para fazer um ataque Evil Twin você precisa estar perto do alvo ou ter uma antena wifi muito poderosa. Seu sinal deve atingir os clientes igualmente forte ou mais do que o AP legítimo"
	arr["RUSSIAN",269]="Для выполнения атаки Злой Двойник, вы должны быть очень близко к целевой ТД или иметь очень мощную wifi антенну. Ваш сигнал должен достигать клиентов с такой же силой, или даже сильнее, чем легитимная ТД"
	arr["GREEK",269]="Για να πραγματοποιηθεί μία επίθεση Evil Twin θα πρέπει να είστε αρκετά κοντά στο AP-στόχο ή να έχετε μία πολύ ισχυρή κεραία. Το σήμα πρέπει να φτάνει στους χρήστες το ίδιο ή περισσότερο από το αρχικό AP"
	arr["ITALIAN",269]="Per un attacco Evil Twin c'è bisogno di essere vicino al punto di accesso obiettivo o di avere un'antenna wifi potente. Il segnale deve raggiungere i clienti come o piú forte che il legittimo AP"
	arr["POLISH",269]="Aby wykonać atak Evil Twin, musisz być bardzo blisko docelowego punktu dostępowego lub mieć bardzo silną antenę wifi. Twój sygnał musi dotrzeć do klientów con najmniej tak samo silny lub silniejszy od legalnego AP"
	arr["GERMAN",269]="Um einen Evil Twin Angriff durchzuführen, müssen Sie sehr nah am Ziel-AP sein oder eine sehr leistungsfähige WLAN-Antenne haben. Ihr Signal muss Kunden als stark oder mindestens stärker als die legitime AP erreichen"
	arr["TURKISH",269]="Şeytani İkiz bir saldırı gerçekleştirmek için hedef AP'ye çok yakın olmanız veya çok güçlü bir wifi antenine sahip olmanız gerekir. Sinyaliniz, clientlere yasal AP'den eşit veya daha güçlü olmalıdır"
	arr["ARABIC",269]="Evil Twin AP المشروعة. نأمل أن يعيدوا الاتصال بـ AP مع هذا الهجوم ، سنحاول إلغاء مصادقة العملاء من"
	arr["CHINESE",269]="要执行邪恶双胞胎攻击，您需要非常靠近目标 AP 或拥有较大功率的 wifi 天线用以屏蔽目标网络的信号。所以您的信号必须与目标 AP 等同强或更强"

	arr["ENGLISH",270]="Evil Twin attack just AP"
	arr["SPANISH",270]="Ataque Evil Twin solo AP"
	arr["FRENCH",270]="Attaque Evil Twin Rogue AP simple"
	arr["CATALAN",270]="Atac Evil Twin només AP"
	arr["PORTUGUESE",270]="Ataque Evil Twin só AP"
	arr["RUSSIAN",270]="Атака Злой Двойник, просто ТД"
	arr["GREEK",270]="Επίθεση Evil Twin μόνο AP"
	arr["ITALIAN",270]="Attacco Evil Twin solo AP"
	arr["POLISH",270]="Atak Evil Twin tylko AP"
	arr["GERMAN",270]="Evil Twin Angriff nur AP"
	arr["TURKISH",270]="Şeytani İkiz saldırısı sadece AP"
	arr["ARABIC",270]="AP فقط Evil Twin هجوم"
	arr["CHINESE",270]="邪恶双胞胎 仅攻击 AP "

	arr["ENGLISH",271]="Selected BSSID: \${pink_color}None\${normal_color}"
	arr["SPANISH",271]="BSSID seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",271]="BSSID sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",271]="BSSID seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",271]="BSSID selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",271]="Выбранная BSSID: \${pink_color}Нет\${normal_color}"
	arr["GREEK",271]="Επιλεγμένο BSSID: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",271]="BSSID selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",271]="Wybrany BSSID: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",271]="Ausgewählte BSSID: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",271]="Seçilen BSSID: \${pink_color}None\${normal_color}"
	arr["ARABIC",271]="\${pink_color}None\${blue_color} :المختار BSSID\${normal_color}"
	arr["CHINESE",271]="已选择的 BSSID: \${pink_color}None\${normal_color}"

	arr["ENGLISH",272]="Deauthentication chosen method: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["SPANISH",272]="Método elegido de desautenticación: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["FRENCH",272]="Méthode de dés-authentification: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["CATALAN",272]="Mètode elegit d'desautenticació: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["PORTUGUESE",272]="Método de desautenticação escolhido: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["RUSSIAN",272]="Выбор метода деаутентификации: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["GREEK",272]="Επιλεγμένη μέθοδος για deauthentication: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["ITALIAN",272]="Metodo deauth scelto: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["POLISH",272]="Wybrana metoda deautentykacji: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["GERMAN",272]="Designierte Methode der De-Authentifizierung: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["TURKISH",272]="Deauthentication seçilen yöntem: \${pink_color}\${et_dos_attack}\${normal_color}"
	arr["ARABIC",272]="\${pink_color}\${et_dos_attack}\${blue_color} :الطريقة المختارة لإلغاء المصادقة\${normal_color}"
	arr["CHINESE",272]="已选择解除认证的方法: \${pink_color}\${et_dos_attack}\${normal_color}"

	arr["ENGLISH",273]="Selected channel: \${pink_color}None\${normal_color}"
	arr["SPANISH",273]="Canal seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",273]="Canal sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",273]="Canal seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",273]="Canal selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",273]="Выбранный канал: \${pink_color}Нет\${normal_color}"
	arr["GREEK",273]="Επιλεγμένο κανάλι: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",273]="Canale selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",273]="Wybrany kanał: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",273]="Ausgewählter Kanal: \${pink_color}Keinen\${normal_color}"
	arr["TURKISH",273]="Seçilen kanal: \${pink_color}None\${normal_color}"
	arr["ARABIC",273]="\${pink_color}None\${blue_color} :القناة المختارة\${normal_color}"
	arr["CHINESE",273]="当前信道: \${pink_color}None\${normal_color}"

	arr["ENGLISH",274]="Selected ESSID: \${pink_color}None\${normal_color}"
	arr["SPANISH",274]="ESSID seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",274]="ESSID sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",274]="ESSID seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",274]="ESSID selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",274]="Выбранная ESSID: \${pink_color}Нет\${normal_color}"
	arr["GREEK",274]="Επιλεγμένο ESSID: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",274]="ESSID selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",274]="Wybrany ESSID: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",274]="Ausgewählte ESSID: \${pink_color}Keines\${normal_color}"
	arr["TURKISH",274]="Seçilen ESSID: \${pink_color}None\${normal_color}"
	arr["ARABIC",274]="\${pink_color}None\${blue_color} :المختار ESSID\${normal_color}"
	arr["CHINESE",274]="已选择的 ESSID: \${pink_color}None\${normal_color}"

	arr["ENGLISH",275]="In addition to the software requirements that already meet if you get here, you need to provide target AP data to carry out the attack"
	arr["SPANISH",275]="Además de los requisitos de software, que ya cumples si has llegado hasta aquí, es necesario proporcionar los datos del AP objetivo para llevar a cabo el ataque"
	arr["FRENCH",275]="Maintenant que les dépendances ont étés vérifiées il vous faut saisir les donnés sur le point d'accès cible"
	arr["CATALAN",275]="A més dels requisits de software, que ja compleixes si has arribat fins aquí, cal proporcionar les dades de l'AP objectiu per dur a terme l'atac"
	arr["PORTUGUESE",275]="Além dos requisitos de software, você precisa fornecer dados do AP objetivo para realizar o ataque"
	arr["RUSSIAN",275]="В дополнение к требованиям по программному обеспечению, которым вы соответствуете, вам нужно обеспечить Интернет подключение вашей ТД для выполнения атаки"
	arr["GREEK",275]="Εκτός από τις απαιτήσεις του λογισμικού οι οποίες πληρούνται αν έχετε φτάσει έως εδώ, χρειάζεται να παρέχετε δεδομένα AP-στόχου για να πραγματοποιηθεί η επίθεση"
	arr["ITALIAN",275]="Oltre ai requisiti software che già soddisfi se sei arrivato qui, è necessario fornire i dati dell'AP obiettivo per effettuare l'attacco"
	arr["POLISH",275]="Oprócz wymogów dotyczących oprogramowania, które już spełniłeś, konieczne jest dostarczenie danych AP docelowego do przeprowadzenia ataku"
	arr["GERMAN",275]="Zusätzlich zu den Softwareanforderungen, die Sie bereits erfüllen, wenn Sie hier angekommen sind, ist es notwendig, die Daten des Ziel-AP bereitzustellen, um den Angriff auszuführen"
	arr["TURKISH",275]="Buraya zaten ulaşmış olduğunuz yazılım gereksinimlerine ek olarak, saldırıyı gerçekleştirmek için hedef AP verileri sağlamanız gerekir"
	arr["ARABIC",275]="المستهدفة لتنفيذ الهجوم AP بالإضافة إلى متطلبات البرامج التي تفي بالفعل إذا وصلت إلى هنا ، فأنت بحاجة إلى توفير بيانات"
	arr["CHINESE",275]="到这里除了已经满足的软件包要求外，还需要提供目标 AP 数据才能进行攻击"

	arr["ENGLISH",276]="On top of this screen you can see all that is needed to perform the attack. If any of the parameters has no value, you can enter it manually, or you can go back to select a target and then return here"
	arr["SPANISH",276]="En la parte superior de esta pantalla puedes ver todo lo que hace falta para realizar el ataque. Si alguno de los parámetros no tiene valor, puedes introducirlo manualmente, o puedes retroceder para seleccionar un objetivo y regresar aquí"
	arr["FRENCH",276]="Vous pouvez voir dans la partie supérieure de l'écran tout ce qui est nécessaire à l'attaque. Si l'un des paramètres est en blanc vous pouvez l'entrer manuellement ou bien vous pouvez revenir en arrière pour sélectionner une cible et revenir ici"
	arr["CATALAN",276]="A la part superior d'aquesta pantalla pots veure tot el que cal per realitzar l'atac. Si algun dels paràmetres no té valor, pots introduir-lo manualment, o pots retrocedir per a seleccionar un objectiu i tornar aquí"
	arr["PORTUGUESE",276]="No topo da tela você pode ver tudo o que é necessário para realizar o ataque. Se qualquer um dos parâmetros não tem nenhum valor, pode introduzi-los manualmente, ou você pode voltar para selecionar um alvo e voltar aqui"
	arr["RUSSIAN",276]="Наверху экрана вы можете увидеть всё, что вам нужно для выполнения этой атаки. Если какие-либо из этих параметров не имеют значения, вы можете ввести их вручную или вы можете вернуться назад для выбора цели, а затем вернуться сюда"
	arr["GREEK",276]="Πάνω από αυτή την οθόνη μπορείτε να δείτε ό,τι χρειάζεται για να εκτελεστεί η επίθεση. Αν κάποια παραμέτρος δεν έχει τιμή, μπορείτε να την εισάγετε χειροκίνητα, ή μπορείτε να πάτε πίσω για να επιλέξετε εαν στόχο και μετά να επιστρέψετε εδώ"
	arr["ITALIAN",276]="In cima a questa schermata è possibile vedere tutto ciò che è necessario per eseguire l'attacco. Se uno dei parametri non ha alcun valore, è possibile inserirlo manualmente, oppure si può tornare indietro per selezionare un target e tornare qui"
	arr["POLISH",276]="U góry tego ekranu można zobaczyć wszystko, co jest potrzebne do przeprowadzenia ataku. Jeśli któryś z parametrów nie ma wartości, możesz go wprowadzić ręcznie lub wrócić do wybranego celu"
	arr["GERMAN",276]="Oben auf diesem Bildschirm können Sie alles sehen, was Sie für den Angriff benötigen. Wenn einer der Parameter keinen Wert hat, können Sie ihn manuell eingeben, oder Sie können zurückgehen, um ein Ziel auszuwählen und hierher zurückzukehren"
	arr["TURKISH",276]="Bu ekranın tepesinde, saldırıyı gerçekleştirmek için gereken her şeyi görebilirsiniz. Parametrelerden herhangi birinin değeri yoksa, manuel olarak girebilirsiniz veya bir hedef seçmek için geri dönüp buraya dönebilirsiniz"
	arr["ARABIC",276]="في الجزء العلوي من هذه الشاشة يمكنك رؤية كل ما هو مطلوب لتنفيذ الهجوم. إذا لم يكن لأي من المعلمات قيمة ، يمكنك إدخالها يدويًا ، أو يمكنك الرجوع لتحديد هدف ثم العودة هنا"
	arr["CHINESE",276]="在此屏幕顶部，您可以看到执行攻击所需的所有内容。如果有一个参数没有值，可以手动输入，也可以回头选择一个目标再返回这里"

	arr["ENGLISH",277]="Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",277]="¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",277]="Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",277]="¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",277]="Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",277]="Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",277]="Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",277]="Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",277]="Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",277]="Wollen Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",277]="Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",277]="\${normal_color}\${visual_choice} \${green_color}هل هل تريد المتابعة؟\${normal_color}"
	arr["CHINESE",277]="你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",278]="Deauthentication chosen method: \${pink_color}None\${normal_color}"
	arr["SPANISH",278]="Método elegido de desautenticación: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",278]="Méthode de dés-authentification: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",278]="Mètode elegit d'desautenticació: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",278]="Método de desautenticação escolhido: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",278]="Выбор метода деаутентификации: \${pink_color}Нет\${normal_color}"
	arr["GREEK",278]="Επιλεγμένη μέθοδος deauthentication: \${pink_color}Καμία\${normal_color}"
	arr["ITALIAN",278]="Metodo deauth scelto: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",278]="Wybrana metoda deautentykacji: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",278]="Designierte Methode der De-Authentifizierung: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",278]="Deauthentication seçilen yöntem: \${pink_color}None\${normal_color}"
	arr["ARABIC",278]="\${pink_color}None\${blue_color} :الطريقة المختارة لإلغاء المصادقة\${normal_color}"
	arr["CHINESE",278]="已选择解除认证的方法: \${pink_color}None\${normal_color}"

	arr["ENGLISH",279]="Select another interface with internet access:"
	arr["SPANISH",279]="Selecciona otra interfaz que tenga acceso a internet:"
	arr["FRENCH",279]="Choisissez une autre interface qui ait accès à internet:"
	arr["CATALAN",279]="Selecciona una altra interfície que tingui accés a internet:"
	arr["PORTUGUESE",279]="Selecione outra interface que tem acesso à internet:"
	arr["RUSSIAN",279]="Выбор другого интерфейса с Интернет доступом:"
	arr["GREEK",279]="Επιλέξτε άλλη διεπαφή με προσβαση στο διαδίκτυο:"
	arr["ITALIAN",279]="Selezionare un'altra interfaccia che ha accesso a internet:"
	arr["POLISH",279]="Wybierz inny interfejs, który ma dostęp do internetu:"
	arr["GERMAN",279]="Wählen Sie ein anderes Interface mit Internetzugang:"
	arr["TURKISH",279]="Başka bir arayyüz seçiniz:"
	arr["ARABIC",279]=":حدد واجهة أخرى موصولة مع الإنترنت"
	arr["CHINESE",279]="选择另一个可以访问网络的接口:"

	arr["ENGLISH",280]="On this screen, it's supposed an additional interface to provide internet access is chosen, but you don't have anyone at this moment"
	arr["SPANISH",280]="En esta pantalla, se supone que deberías elegir otro interfaz adicional para proporcionar acceso a internet, pero no dispones de ninguno en este momento"
	arr["FRENCH",280]="Sur cet écran vous êtes censé choisir une interface supplémentaire connectée à internet mais vous n'en avez pas en ce moment"
	arr["CATALAN",280]="En aquesta pantalla, se suposa que hauries de triar un altre interfície addicional per a proporcionar accés a internet, però no disposes de cap en aquest moment"
	arr["PORTUGUESE",280]="Nesta tela você deveria escolher uma interface adicional para fornecer acesso à internet, mas você não tem nenhuma neste momento"
	arr["RUSSIAN",280]="На этом экране предполагается, что выбран дополнительный интерфейс для предоставления Интернет доступа, но у вас его на текущий момент нет"
	arr["GREEK",280]="Σε αυτή την οθόνη, υποτίθεται πως επιλέγεται μία επιπρόσθετη διεπαφή που παρέχει πρόσβαση στο διαδίκτυο, αλλά δεν έχετε κανέναν αυτή τη στιγμή"
	arr["ITALIAN",280]="In questa schermata, si suppone che devi scegliere un'interfaccia aggiuntiva per fornire l'accesso a internet, peró in questo momento non ne hai nessuna"
	arr["POLISH",280]="Na tym ekranie powinieneś wybrać inny dodatkowy interfejs, aby zapewnić dostęp do internetu, ale nie masz w tym momencie żadnego"
	arr["GERMAN",280]="Auf diesen Bildschirm sollten Sie ein anderes zusätzliches Interface für den Internetzugang auswählen, aber Sie haben derzeit keins"
	arr["TURKISH",280]="Bu ekranda, internet erişimi sağlamak için ek bir arayüz gerekiyordu, ancak şu anda kimseye sahip değilsiniz"
	arr["ARABIC",280]="من المفترض أن تختار في هذه الشاشة واجهة إضافية متصلة بالإنترنت ولكن ليس لديك واحدة في الوقت الحالي"
	arr["CHINESE",280]="在这个窗口中，应该选择一个额外的接口来提供互联网访问，但现在没有任何接口"

	arr["ENGLISH",281]="The interface \${current_iface_on_messages} you have already selected is not a wifi card. This attack needs a wifi card selected"
	arr["SPANISH",281]="El interfaz \${current_iface_on_messages} que tienes seleccionado no es una tarjeta wifi. Este ataque necesita que la interfaz seleccionada sea wifi"
	arr["FRENCH",281]="L'interface \${current_iface_on_messages} que vous avez sélectionnée n'est pas une carte wifi. Cette attaque exige que l'interface sélectionnée soit une carte wifi"
	arr["CATALAN",281]="La interfície \${current_iface_on_messages} que tens seleccionada no és una targeta wifi. Aquest atac necessita que la interfície seleccionada sigui wifi"
	arr["PORTUGUESE",281]="A interface \${current_iface_on_messages} que você selecionou não é wifi. Este ataque requer uma interface wifi selecionada"
	arr["RUSSIAN",281]="Интерфейс \${current_iface_on_messages}, который вы выбрали не является wifi картой. Эта атака требует выбрать wifi карту"
	arr["GREEK",281]="Η διεπαφή \${current_iface_on_messages} που έχετε ήδη επιλέξει δεν έιναι κάρτα wifi. Αυτή η επίθεση χρειάζεται μία κάρτα wifi επιλεγμένη"
	arr["ITALIAN",281]="L'interfaccia \${current_iface_on_messages} che hai scelto non è una scheda wifi. Per questo attacco è necessario che l'interfaccia selezionata sia wifi"
	arr["POLISH",281]="Interfejs \${current_iface_on_messages}, który wybrałeś, nie jest kartą wifi. Ten atak wymaga wybrania interfejsu wifi"
	arr["GERMAN",281]="Das von Ihnen ausgewählte \${current_iface_on_messages} Interface ist keine WLAN-Karte. Dieser Angriff erfordert, dass das ausgewählte Interface WLAN-fähig ist"
	arr["TURKISH",281]="Seçmiş olduğunuz arayüz \${current_iface_on_messages} bir wifi kartı değildir. Bu saldırı bir wifi kartı gerektirir"
	arr["ARABIC",281]="wifi التي اخترتها ليست بطاقة واي فاي. يحتاج هذا الهجوم إلى تحديد بطاقة \${current_iface_on_messages} واجهة"
	arr["CHINESE",281]="您已经选择的接口 \${current_iface_on_messages} 不是 wifi 网卡。此攻击需要选择 wifi 网卡"

	arr["ENGLISH",282]="Selected internet interface: \${pink_color}\${internet_interface}\${normal_color}"
	arr["SPANISH",282]="Interfaz con internet seleccionada: \${pink_color}\${internet_interface}\${normal_color}"
	arr["FRENCH",282]="Interface internet sélectionnée: \${pink_color}\${internet_interface}\${normal_color}"
	arr["CATALAN",282]="Interfície amb internet seleccionada: \${pink_color}\${internet_interface}\${normal_color}"
	arr["PORTUGUESE",282]="Interface com internet selecionada: \${pink_color}\${internet_interface}\${normal_color}"
	arr["RUSSIAN",282]="Выбранный Интернет интерфейс: \${pink_color}\${internet_interface}\${normal_color}"
	arr["GREEK",282]="Επιλεγμένη διεπαφή με πρόσβαση στο διαδίκτυο: \${pink_color}\${internet_interface}\${normal_color}"
	arr["ITALIAN",282]="Interfaccia internet selezionata: \${pink_color}\${internet_interface}\${normal_color}"
	arr["POLISH",282]="Wybrany interfejs z internetem: \${pink_color}\${internet_interface}\${normal_color}"
	arr["GERMAN",282]="Ausgewähltes Internet-Interface: \${pink_color}\${internet_interface}\${normal_color}"
	arr["TURKISH",282]="Seçilen internet arayüzü: \${pink_color}\${internet_interface}\${normal_color}"
	arr["ARABIC",282]="\${pink_color}\${internet_interface}\${blue_color} :واجهة إنترنت المختارة\${normal_color}"
	arr["CHINESE",282]="选定的互联网接口: \${pink_color}\${internet_interface}\${normal_color}"

	arr["ENGLISH",283]="Selected internet interface: \${pink_color}None\${normal_color}"
	arr["SPANISH",283]="Interfaz con internet seleccionada: \${pink_color}Ninguna\${normal_color}"
	arr["FRENCH",283]="Interface internet sélectionnée: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",283]="Interfície amb internet seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",283]="Interface com internet selecionada: \${pink_color}Nenhuma\${normal_color}"
	arr["RUSSIAN",283]="Выбранный Интернет интерфейс: \${pink_color}Нет\${normal_color}"
	arr["GREEK",283]="Επιλεγμένη διεπαφή με πρόσβαση στο διαδίκτυο: \${pink_color}Καμία\${normal_color}"
	arr["ITALIAN",283]="Interfaccia internet selezionata: \${pink_color}Nessuna\${normal_color}"
	arr["POLISH",283]="Wybrany interfejs z internetem: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",283]="Ausgewähltes Internet-Interface: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",283]="Seçilen internet arayüzü: \${pink_color}None\${normal_color}"
	arr["ARABIC",283]="\${pink_color}لا\${blue_color} :واجهة إنترنت المختارة\${normal_color}"
	arr["CHINESE",283]="选定的互联网接口: \${pink_color}None\${normal_color}"

	arr["ENGLISH",284]="Do you want to use this selected interface? \${normal_color}\${visual_choice}"
	arr["SPANISH",284]="¿Quieres utilizar esta interfaz ya seleccionada? \${normal_color}\${visual_choice}"
	arr["FRENCH",284]="Souhaitez-vous utiliser l'interface déjà sélectionnée? \${normal_color}\${visual_choice}"
	arr["CATALAN",284]="¿Vols fer servir aquesta interfície ja seleccionada? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",284]="Você quer usar essa interface selecionada? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",284]="Вы хотите использовать этот выбранный интерфейс? \${normal_color}\${visual_choice}"
	arr["GREEK",284]="Θέλετε να χρησιμοποιήσετε αυτή την επιλεγμένη διεπαφή; \${normal_color}\${visual_choice}"
	arr["ITALIAN",284]="Vuoi usare questa interfaccia già selezionata? \${normal_color}\${visual_choice}"
	arr["POLISH",284]="Czy chcesz skorzystać z tego interfejsu? \${normal_color}\${visual_choice}"
	arr["GERMAN",284]="Möchten Sie dieses ausgewählte Interface verwenden? \${normal_color}\${visual_choice}"
	arr["TURKISH",284]="Seçilmiş olan arayüzü kullanmak istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",284]="\${normal_color}\${visual_choice}\${green_color} هل تريد استخدام هذه الواجهة المختارة؟\${normal_color}"
	arr["CHINESE",284]="您想使用这个选定的接口吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",285]="Selected interface with internet access detected during this session [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["SPANISH",285]="Se ha detectado que ya tiene un interfaz con acceso a internet seleccionada en esta sesión [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["FRENCH",285]="Une interface avec accès à internet a déjà été sélectionné pour cette session [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["CATALAN",285]="S'ha detectat que ja té una interfície amb accés a internet seleccionada en aquesta sessió [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["PORTUGUESE",285]="Verificou-se que há uma interface com acesso à internet selecionada nesta sessão [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["RUSSIAN",285]="Во время этой сессии обнаружен выбранный интерфейс с Интернет подключением [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["GREEK",285]="Η επιλεγμένη διεπαφή με πρόσβαση στο διαδίκτυο εντοπίστηκε κατά τη διάρκεια της συνεδρίας [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["ITALIAN",285]="E' stato riscontrato che ha già un'interfaccia con accesso a internet selezionata in questa sessione [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["POLISH",285]="Wykryto, że w tej sesji masz już wybrany interfejs z dostępem do internetu [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["GERMAN",285]="Es wurde festgestellt, dass Sie bereits ein Interface mit Internetzugang ausgewählt haben [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["TURKISH",285]="Bu oturum sırasında seçilen arayüz internet erişimi ile tespit edildi [\${normal_color}\${internet_interface}\${blue_color}]"
	arr["ARABIC",285]="[\${normal_color}\${internet_interface}\${blue_color}] تم اكتشاف واجهة محددة موصولة بالإنترنت أثناء هذه الدورة"
	arr["CHINESE",285]="在此会话期间检测到具有互联网访问的网络接口 [\${normal_color}\${internet_interface}\${blue_color}]"

	arr["ENGLISH",286]="If you don't have a captured Handshake file from the target network you can get it now"
	arr["SPANISH",286]="Si no tienes un fichero de Handshake capturado de la red objetivo puedes obtenerlo ahora"
	arr["FRENCH",286]="Si vous n'avez pas un fichier de capture contenant un Handshake du réseau cible vous pouvez l'obtenir maintenant"
	arr["CATALAN",286]="Si no tens un fitxer de Handshake capturat de la xarxa objectiu pots obtenir-ho ara"
	arr["PORTUGUESE",286]="Se você não tem um arquivo de Handshake da rede alvo você pode capturar agora"
	arr["RUSSIAN",286]="Если у вас отсутствует файл с рукопожатием целевой сети, вы можете сейчас захватить его"
	arr["GREEK",286]="Εάν δεν έχετε κάποιο αρχείο Χειραψίας από το δίκτυο-στόχος μπορείτε να το πάρετε τώρα"
	arr["ITALIAN",286]="Se non hai catturato un file di Handshake dalla rete obiettivo puoi ottenerlo ora"
	arr["POLISH",286]="Jeśli nie masz pliku Handshake przechwyconego w sieci docelowej, możesz go teraz zdobyć"
	arr["GERMAN",286]="Wenn Sie keine Handshake-Datei vom Zielnetzwerk erhalten haben, können Sie sie jetzt abrufen"
	arr["TURKISH",286]="Eğer hedef ağ için henüz yakalanmış bir Handshake dosyanız yoksa hemen şimdi yakalayabilirsiniz"
	arr["ARABIC",286]="تم التقاطه من الشبكة المستهدفة ، يمكنك الحصول عليه الآن Handshake إذا لم يكن لديك ملف"
	arr["CHINESE",286]="如果您还没有从目标网络捕获握手包文件，那么您现在可以获取它"

	arr["ENGLISH",287]="The script will check for internet access. Please be patient..."
	arr["SPANISH",287]="El script va a comprobar si tienes acceso a internet. Por favor ten paciencia..."
	arr["FRENCH",287]="Le script va vérifier que vous aillez accès à internet. Soyez patients s'il vous plaît..."
	arr["CATALAN",287]="El script comprovarà si tens accés a internet. Si us plau sigues pacient..."
	arr["PORTUGUESE",287]="O script irá verificar se você tem acesso à internet. Por favor, aguarde..."
	arr["RUSSIAN",287]="Этот скрипт проверит доступ к Интернету. Подождите немного..."
	arr["GREEK",287]="Το script θα ελέγξει αν έχετε πρόσβαση στο διαδίκτυο. Παρακαλώ έχετε λίγη υπομονή..."
	arr["ITALIAN",287]="Lo script controllerà se si ha accesso a internet. Si prega di essere pazienti..."
	arr["POLISH",287]="Skrypt sprawdzi, czy masz dostęp do internetu. Bądź cierpliwy..."
	arr["GERMAN",287]="Das Skript überprüft, ob Sie Internetzugang. Bitte haben Sie etwas Geduld..."
	arr["TURKISH",287]="Yazılım internet erişimin, kontrol edecek. Lütfen sabırlı olun..."
	arr["ARABIC",287]="...سيتحقق البرنامج من الوصول إلى الإنترنت. يرجى التحلي بالصبر"
	arr["CHINESE",287]="该脚本将检查互联网访问。请耐心等待..."

	arr["ENGLISH",288]="It seems you have no internet access. This attack needs an interface with internet access"
	arr["SPANISH",288]="Parece que no tienes conexión a internet. Este ataque necesita una interfaz con acceso a internet"
	arr["FRENCH",288]="Il semble que vous ne pouvez pas vous connecter à internet. Cette attaque a besoin d'une interface avec u accès internet"
	arr["CATALAN",288]="Sembla que no tens connexió a internet. Aquest atac necessita una interfície amb accés a internet"
	arr["PORTUGUESE",288]="Parece que você não tem acesso à internet. Este ataque precisa de uma interface com acesso à internet"
	arr["RUSSIAN",288]="Судя по всему, у вас нет доступа к Интернету. Эта атака требует интерфейс с Интернет доступом"
	arr["GREEK",288]="Φαίνεται πως δεν έχετε πρόσβαση στο διαδίκτυο. Αυτή η επίθεση χρειάζεται μία διεπαφή με πρόσβαση στο διαδίκτυο"
	arr["ITALIAN",288]="Sembra che tu non abbia alcuna connessione a internet. Questo attacco ha bisogno di un'interfaccia con connessione a internet"
	arr["POLISH",288]="Wygląda na to, że nie masz połączenia internetowego. Ten atak wymaga interfejsu z dostępem do internetu"
	arr["GERMAN",288]="Es scheint, dass Sie keine Internetverbindung haben. Dieser Angriff benötigt ein Interface mit Internetzugang"
	arr["TURKISH",288]="İnternet erişiminiz yok gibi görünüyor. Bu saldırı internet erişimi olan bir arayüze ihtiyaç duyuyor"
	arr["ARABIC",288]="يبدو أنه ليس لديك اتصال بالإنترنت. يحتاج هذا الهجوم إلى واجهة متصلة بالإنترنت"
	arr["CHINESE",288]="您似乎无法访问互联网。这种攻击需要一个可以访问互联网的网络接口"

	arr["ENGLISH",289]="It has been verified successfully you have internet access on selected interface. Script can continue..."
	arr["SPANISH",289]="Se ha verificado correctamente que tienes acceso a internet en la interfaz seleccionada. El script puede continuar..."
	arr["FRENCH",289]="Confirmation de l'accès internet pour l'interface réseaux choisie. Le script peut continuer..."
	arr["CATALAN",289]="S'ha verificat correctament que tens accés a internet a la interfície seleccionada. El script pot continuar..."
	arr["PORTUGUESE",289]="Verificou-se com sucesso que você tem acesso à internet na interface selecionada. O script pode continuar..."
	arr["RUSSIAN",289]="Проверка доступа к Интернету прошла успешно на выбранном интерфейс. Скрипт может продолжать..."
	arr["GREEK",289]="Επαληθεύτηκε επιτυχώς πως έχετε πρόσβαση στο διαδίκτυο με την επιλεγμένη διεπαφή. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",289]="E' stato verificato con successo che si ha accesso a internet sull'interfaccia selezionata. Lo script può continuare ..."
	arr["POLISH",289]="Udało się potwierdzić, że masz dostęp do internet w wybranym interfejsie. Skrypt może kontynuować..."
	arr["GERMAN",289]="Es wurde korrekt überprüft, dass Sie in der ausgewählten Interface Zugriff auf das Internet haben. Das Skript kann fortfahren..."
	arr["TURKISH",289]="Başarılı bir şekilde doğrulandı ve seçilen arayüzde internet erişiminiz var. Yazılım devam edebilir..."
	arr["ARABIC",289]="...تم التحقق بنجاح من أن لديك إمكانية الوصول إلى الإنترنت على الواجهة المحددة. البرنامج يمكن أن يستمر"
	arr["CHINESE",289]="已成功验证您可以在所选接口上访问互联网。脚本可以继续..."

	arr["ENGLISH",290]="It seems you have internet access but not in the selected interface acting as interface with internet access"
	arr["SPANISH",290]="Parece que tienes conexión a internet pero no en la interfaz seleccionada como interfaz con acceso a internet"
	arr["FRENCH",290]="Il semble bien que vous avez accès à internet mais pas avec l'interface sélectionnée à cet effet"
	arr["CATALAN",290]="Sembla que tens connexió a internet però no en la interfície seleccionada com a interfície amb accés a internet"
	arr["PORTUGUESE",290]="Parece que você tem internet, mas não na interface selecionada"
	arr["RUSSIAN",290]="Судя по всему у вас есть доступ к Интернету, но не на выбранном для Интернет доступа интерфейсе"
	arr["GREEK",290]="Φαίνεται πως έχετε πρόσβαση στο διαδίκτυο αλλά όχι στην επιλεγμένη διεπαφή που ενεργεί ως διεπαφή με πρόσβαση στο διαδίκτυο"
	arr["ITALIAN",290]="Sembra che hai connessione a internet ma non nell'interfaccia selezionata come interfaccia con accesso ad internet"
	arr["POLISH",290]="Wydaje się, że masz połączenie z internetem ale w innym interfejsie"
	arr["GERMAN",290]="Es scheint, dass Sie eine Internetverbindung haben, aber nicht in das mit Internetzugang gewählte Interface"
	arr["TURKISH",290]="İnternet erişiminiz var gibi görünüyor fakat seçilen arayüz internet erişimi var gibi dvranmıyor"
	arr["ARABIC",290]="يبدو أن لديك اتصال بالإنترنت ولكن ليس بالواجهة المحددة لهذا الغرض"
	arr["CHINESE",290]="您似乎可以访问互联网，但选定接口中似乎无法访问"

	arr["ENGLISH",291]="Evil Twin AP attack with sniffing"
	arr["SPANISH",291]="Ataque Evil Twin AP con sniffing"
	arr["FRENCH",291]="Attaque Evil Twin avec capture de données"
	arr["CATALAN",291]="Atac Evil Twin AP amb sniffing"
	arr["PORTUGUESE",291]="Ataque Evil Twin AP com sniffing"
	arr["RUSSIAN",291]="Атака Злой Двойник ТД со сниффингом"
	arr["GREEK",291]="Επίθεση Evil Twin AP με sniffing"
	arr["ITALIAN",291]="Attacco Evil Twin AP con sniffing"
	arr["POLISH",291]="Atak Evil Twin AP ze sniffingiem"
	arr["GERMAN",291]="Evil Twin AP Angriff mit Sniffing"
	arr["TURKISH",291]="Şeytani İkiz AP saldırısı sniffing ile"
	arr["ARABIC",291]="مع الشم Evil Twin هجوم"
	arr["CHINESE",291]="邪恶双胞胎 AP 攻击与嗅探"

	arr["ENGLISH",292]="Evil Twin AP attack with sniffing and bettercap-sslstrip2"
	arr["SPANISH",292]="Ataque Evil Twin AP con sniffing y bettercap-sslstrip2"
	arr["FRENCH",292]="Attaque Evil Twin avec capture de données et bettercap-sslstrip2"
	arr["CATALAN",292]="Atac Evil Twin AP amb sniffing i bettercap-sslstrip2"
	arr["PORTUGUESE",292]="Ataque Evil Twin AP com sniffing e bettercap-sslstrip2"
	arr["RUSSIAN",292]="Атака Злой Двойник ТД со сниффингом и bettercap-sslstrip2"
	arr["GREEK",292]="Επίθεση Evil Twin AP με sniffing και bettercap-sslstrip2"
	arr["ITALIAN",292]="Attacco Evil Twin AP con sniffing e bettercap-sslstrip2"
	arr["POLISH",292]="Atak Evil Twin AP ze sniffingiem i bettercap-sslstrip2"
	arr["GERMAN",292]="Evil Twin AP Angriff mit Sniffing und bettercap-sslstrip2"
	arr["TURKISH",292]="Şeytani İkiz AP saldırısı sniffing ve bettercap-sslstrip2 ile"
	arr["ARABIC",292]="bettercap-sslstrip2 مع الشم و Evil Twin AP هجوم"
	arr["CHINESE",292]="带有嗅探和 bettercap-sslstrip2 的邪恶双胞胎 AP 攻击"

	arr["ENGLISH",293]="Evil Twin AP attack with captive portal"
	arr["SPANISH",293]="Ataque Evil Twin AP con portal cautivo"
	arr["FRENCH",293]="Attaque Evil Twin avec portail captif"
	arr["CATALAN",293]="Atac Evil Twin AP amb portal captiu"
	arr["PORTUGUESE",293]="Ataque Evil Twin AP com portal cativo"
	arr["RUSSIAN",293]="Атака Злой Двойник ТД с перехватывающим порталом"
	arr["GREEK",293]="Επίθεση Evil Twin AP με captive portal"
	arr["ITALIAN",293]="Attacco Evil Twin AP con captive portal"
	arr["POLISH",293]="Atak Evil Twin AP z portalem captive"
	arr["GERMAN",293]="Evil Twin AP Angriff mit Captive Portal"
	arr["TURKISH",293]="Şeytani İkiz AP saldırısı esaret portalı ile"
	arr["ARABIC",293]="مع بوابة أسيرة Evil Twin AP هجوم"
	arr["CHINESE",293]="邪恶双胞胎 AP 攻击与俘虏门户"

	arr["ENGLISH",294]="Detecting resolution... Detected!: \${normal_color}\${resolution}"
	arr["SPANISH",294]="Detectando resolución... Detectada!: \${normal_color}\${resolution}"
	arr["FRENCH",294]="Détection de la résolution... Détectée!: \${normal_color}\${resolution}"
	arr["CATALAN",294]="Detectant resolució... Detectada!: \${normal_color}\${resolution}"
	arr["PORTUGUESE",294]="Detectando resolução... Detectada!: \${normal_color}\${resolution}"
	arr["RUSSIAN",294]="Определение разрешения... Определено!: \${normal_color}\${resolution}"
	arr["GREEK",294]="Εντοπίζεται η ανάλυση... Εντοπίστηκε!: \${normal_color}\${resolution}"
	arr["ITALIAN",294]="Rilevamento risoluzione... Rilevata!: \${normal_color}\${resolution}"
	arr["POLISH",294]="Wykrywanie rozdzielczości... Wykryto!: \${normal_color}\${resolution}"
	arr["GERMAN",294]="Auflösung erkennen... Erkannt!: \${normal_color}\${resolution}"
	arr["TURKISH",294]="Çözünürlük tespit ediliyor... Tamamdır!: \${normal_color}\${resolution}"
	arr["ARABIC",294]="\${normal_color}\${resolution}\${blue_color} :!جاري الكشف عن درجة الوضوح... تم الكشف\${normal_color}"
	arr["CHINESE",294]="正在检测分辨率...检测到！: \${normal_color}\${resolution}"

	arr["ENGLISH",295]="Detecting resolution... Can't be detected!, using standard: \${normal_color}\${resolution}"
	arr["SPANISH",295]="Detectando resolución... No se ha podido detectar!, usando estándar: \${normal_color}\${resolution}"
	arr["FRENCH",295]="Détection de la résolution... Impossible à détecter!, utilisation de la résolution: \${normal_color}\${resolution}"
	arr["CATALAN",295]="Detectant resolució... No s'ha pogut detectar!, usant estàndard: \${normal_color}\${resolution}"
	arr["PORTUGUESE",295]="Detectando resolução... Não foi possível detectar!, usando o padrão: \${normal_color}\${resolution}"
	arr["RUSSIAN",295]="Определение разрешения... Не получается определить!, используется стандартное: \${normal_color}\${resolution}"
	arr["GREEK",295]="Εντοπίζεται η ανάλυση... Δεν μπορεί να εντοπιστεί!, χρησιμοποιείται η προεπιλεγμένη: \${normal_color}\${resolution}"
	arr["ITALIAN",295]="Rilevamento risoluzione... Non è stato possible rilevarla!, usando quella standard: \${normal_color}\${resolution}"
	arr["POLISH",295]="Wykrywanie rozdzielczości... Nie można wykryć! użycie standardu: \${normal_color}\${resolution}"
	arr["GERMAN",295]="Erkennen der Auflösung... Die Auflösung konnte nicht erkannt werden!, Standardauflösung: \${normal_color}\${resolution}"
	arr["TURKISH",295]="Çözünürlük tespit ediliyor... Başarısız!, standart olarak devam edilecek: \${normal_color}\${resolution}"
	arr["ARABIC",295]="\${normal_color}\${resolution}\${blue_color} :!جاري الكشف عن درجة الوضوح... تم الكشف\${normal_color}"
	arr["CHINESE",295]="正在检测分辨率...无法检测！，使用标准分辨率: \${normal_color}\${resolution}"

	arr["ENGLISH",296]="All parameters and requirements are set. The attack is going to start. Multiple windows will be opened, don't close anyone. When you want to stop the attack press [Enter] on this window and the script will automatically close them all"
	arr["SPANISH",296]="Todos los parámetros y requerimientos están listos. Va a comenzar el ataque. Se abrirán múltiples ventanas, no cierres ninguna. Cuando quieras parar el ataque pulsa [Enter] en esta ventana y el script cerrará automáticamente todo"
	arr["FRENCH",296]="Tous les paramètres de l'attaque sont prêts et elle peut comenmcer. Plusieurs consoles vont s'ouvrir, ne les fermez pas. Lorsque vous voulez arrêter l'attaque, appuyez sur [Enter] dans cette console et le script fermera automatiquement les autres"
	arr["CATALAN",296]="Tots els paràmetres i requeriments estan preparats. Començarà l'atac. S'obriran múltiples finestres, no tanquis cap. Quan vulguis parar l'atac prem [Enter] en aquesta finestra i el script tancarà automàticament tot"
	arr["PORTUGUESE",296]="Todos os parâmetros e requisitos estão prontos. Você vai começar o ataque. Várias janelas iram se abrir, não feche nenhuma delas. Quando quiser parar o ataque pressione [Enter] nesta janela e o script irá fechar automaticamente"
	arr["RUSSIAN",296]="Все параметры и требования готовы. Атака может быть начата. Будет открыто много окон, не закрывайте их. Когда вы захотите остановить атаку, нажмите [Enter] в этом окне и скрипт автоматически их все закроет"
	arr["GREEK",296]="Όλοι οι παράμετροι και οι απαιτήσεις έχουν τεθεί. Η επίθεση πρόκειται να ξεκινήσει. Θα ανοίξουν πολλαπλά παράθυρα, μην επιχειρήσετε να κλείσετε κάποιο. Όταν θελήσετε να σταματήσετε την επίθεση πατήστε [Enter] σε αυτό το παράθυρο και το script θα τα κλείσει όλα"
	arr["ITALIAN",296]="Tutti i parametri e i requisiti sono pronti. Si inizierà l'attacco. Si apriranno varie finestre, non chiuderne nessuna. Quando vuoi fermare l'attacco premi [Enter] in questa finestra e lo script chiuderá automaticamente tutto"
	arr["POLISH",296]="Wszystkie parametry i wymagania są gotowe. Atak może się rozpocząć. Otwarte zostanie wiele okien, nie zamykaj żadnego. Aby zatrzymać atak, wciśnij [Enter] w tym oknie, a skrypt automatycznie zamknie wszystkie"
	arr["GERMAN",296]="Alle Parameter und Anforderungen sind bereit. Der Angriff wird beginnen. Mehrere Fenster werden geöffnet, schließen Sie keines. Wenn Sie den Angriff stoppen möchten, drücken Sie [Enter] in diesem Fenster und das Skript wird automatisch alle schließen"
	arr["TURKISH",296]="Tüm parametreler ayarlandı. Saldırı başlayacak. Birden fazla pencere açılacak, bunların hiçbirini kapatmayın. Saldırıyı durdurmak istediğiniz zaman aman pencereden [Enter] tuşlamanız yeterli. Yazılım tüm pencereleri kapatacaktır"
	arr["ARABIC",296]="جميع معايير الهجوم جاهزة ويمكن أن تبدأ. سيتم فتح العديد من لوحات المفاتيح ، لا تغلقها. عندما تريد إيقاف الهجوم ، اضغط على [Enter] في وحدة التحكم هذه وسيغلق البرنامج البرامج الأخرى تلقائيًا"
	arr["CHINESE",296]="所有参数和要求都已设置。攻击即将开始。将打开多个窗口，不要关闭任何窗口。当你想停止攻击时，在此窗口上按 [Enter]，脚本将自动将它们全部关闭"

	arr["ENGLISH",297]="Cleaning nftables/iptables and routing rules if apply"
	arr["SPANISH",297]="Limpiando nftables/iptables y reglas de routing si procede"
	arr["FRENCH",297]="En rangeant des règles de routage nftables/iptables s'il y a lieu"
	arr["CATALAN",297]="Netejant nftables/iptables i regles de routing si escau"
	arr["PORTUGUESE",297]="Limpando as regras do nftables/iptables e de roteamento, se aplicável"
	arr["RUSSIAN",297]="Очистка nftables/iptables и правил маршрутизации если применимо"
	arr["GREEK",297]="Γίνεται καθαρισμός των nftables/iptables και των routing rules εάν υπάρχουν"
	arr["ITALIAN",297]="Pulendo nftables/iptables e le regole di routing se necessario"
	arr["POLISH",297]="Usuwanie nftables/iptables i reguł routingu jeśli istnieją"
	arr["GERMAN",297]="Bereinigung von nftables/iptables und Routing-Regeln falls zutreffend"
	arr["TURKISH",297]="nftables/iptables ve routing rules varsa temizleniyor"
	arr["ARABIC",297]="وقواعد التوجيه إذا لزم nftables/iptables تنظيف"
	arr["CHINESE",297]="清理 nftables/iptables 路由规则 (如果适用)"

	arr["ENGLISH",298]="Evil Twin attack has been started. Press [Enter] key on this window to stop it"
	arr["SPANISH",298]="El ataque Evil Twin ha comenzado. Pulse la tecla [Enter] en esta ventana para pararlo"
	arr["FRENCH",298]="L'attaque Evil Twin a commencé. Pressez la touche [Enter] dans cette console pour l'arrêter"
	arr["CATALAN",298]="L'atac Evil Twin ha començat. Prem [Enter] a aquesta finestra per aturar-lo"
	arr["PORTUGUESE",298]="Ataque Evil Twin iniciado. Pressione a tecla [Enter] nesta janela para parar"
	arr["RUSSIAN",298]="Атака Злой Двойник начата. Для её остановки клавишу [Enter] в этом окне"
	arr["GREEK",298]="Η επίθεση Evil Twin ξεκίνησε. Πατήστε το κουμπί [Enter] σε αυτό το παράθυρο για να την σταματήσετε"
	arr["ITALIAN",298]="L'attacco Evil Twin è iniziato. Premere il tasto [Enter] in questa finestra per fermarlo"
	arr["POLISH",298]="Rozpoczął się atak Evil Twin. Naciśnij klawisz [Enter] w tym oknie, aby go zatrzymać"
	arr["GERMAN",298]="Der Evil-Twin-Angriff hat begonnen. Drücken Sie die [Enter]-Taste in diesem Fenster, um es zu stoppen"
	arr["TURKISH",298]="Şeytani İkiz saldırısı başlatıldı. Durdurmak için bu pencerede [Enter] tuşlayınız"
	arr["ARABIC",298]="في هذه النافذة لإيقافه [Enter] اضغط على مفتاح .Evil Twin بدأ هجوم"
	arr["CHINESE",298]="邪恶双胞胎攻击已经开始。在此窗口中按 [Enter] 键停止它"

	arr["ENGLISH",299]="Restoring interface..."
	arr["SPANISH",299]="Restaurando interfaz..."
	arr["FRENCH",299]="Réinitialisation de l'interface..."
	arr["CATALAN",299]="Restablint interfície..."
	arr["PORTUGUESE",299]="Restaurando interface..."
	arr["RUSSIAN",299]="Восстановление интерфейса..."
	arr["GREEK",299]="Γίνεται επαναφορά διεπαφής..."
	arr["ITALIAN",299]="Ripristinando interfaccia..."
	arr["POLISH",299]="Przywracanie interfejsu..."
	arr["GERMAN",299]="Interface wiederherstellen..."
	arr["TURKISH",299]="Arayüz onarılıyor..."
	arr["ARABIC",299]="...إعادة تعيين الواجهة"
	arr["CHINESE",299]="正在恢复接口..."

	arr["ENGLISH",300]="If the xdpyinfo command works, the script will be able to calculate your screen resolution and display the windows in a better way. Depending on the system, the package name containing it could be x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["SPANISH",300]="Si haces que funcione en tu sistema el comando xdpyinfo, el script podrá calcular tu resolución de pantalla y mostrarte las ventanas de forma más optimizada. Dependiendo del sistema el paquete que lo contiene puede llamarse x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["FRENCH",300]="Si la commande xdpyinfo est installée dans vôtre système le script pourra calculer votre résolution d'écran et optimiser l'affichage en conséquence. Le paquet à installer pour avoir cette commande s'appelle (selon la distribution) x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["CATALAN",300]="Si fas que funcioni en el teu sistema l'ordre xdpyinfo, el script podrà calcular la teua resolució de pantalla i mostrar-te les finestres de forma més optimitzada. Depenent del sistema el paquet que el conté pot dir-se x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["PORTUGUESE",300]="Se o comando xdpyinfo funcionar em seu sistema o script será capaz de calcular a resolução da tela e mostrar-lhe as janelas de uma maneira melhor. Dependendo do sistema, o nome do pacote pode ser: x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["RUSSIAN",300]="Команда xdpyinfo поможет этому скрипту определить разрешение вашего экрана и выбрать наилучшее отображение окон. В зависимости от системы, имя пакета, в котором содержится эта программа, может быть x11-utils, xdpyinfo, xorg-xdpyinfo, и т.д."
	arr["GREEK",300]="Αν δουλέψει η εντολή xdpyinfo, το script θα μπορέσει να υπολογίσει την ανάλυση της οθόνης και να δείχνει τα παράθυρα καλύτερα. Εξαρτάται από το σύστημα, το όνομα του πακέτου που το περιέχει θα μπορούσε να είναι x11-utils, xdpyinfo, xorg-xdpyinfo, κτλπ."
	arr["ITALIAN",300]="Se funziona il comando xdpyinfo, lo script calcolerà la risoluzione dello schermo e mostrerá le finestre in modo ottimizzato. A seconda del sistema il pacchetto che lo contiene può chiamarsi x11-utils, xdpyinfo, xorg-xdpyinfo, etc."
	arr["POLISH",300]="Jeśli polecenie xdpyinfo działa w systemie, skrypt będzie mógł obliczyć rozdzielczość ekranu i lepiej wyświetlać okna. W zależności od systemu pakiet zawierający go może być nazwany x11-utils, xdpyinfo, xorg-xdpyinfo, itd."
	arr["GERMAN",300]="Wenn Sie den Befehl xdpyinfo in Ihrem System verwenden, kann das Skript Ihre Bildschirmauflösung berechnen und Ihnen die Fenster in einer optimierten Weise zeigen. Je nach System kann das Paket, das es enthält, x11-utils, xdpyinfo, xorg-xdpyinfo usw. genannt werden"
	arr["TURKISH",300]="Eğer xdpyinfo komutu çalışırsa, yazılım ekran çözünürlüğünüzü hesaplayabilecek ve en iyi boyutlardaki pencereler ile çalışacak. Paket isimleri sisteminize göre x11-utils, xdpyinfo, xorg-xdpyinfo, vb... olarak değişiklik gösterebilir"
	arr["ARABIC",300]=".وما إلى ذلك xorg-xdpyinfo و xdpyinfo و x11-utils يعمل ، فسيكون البرنامج قادرًا على حساب دقة الشاشة وعرض النوافذ بطريقة أفضل. اعتمادًا على النظام ، يمكن أن يكون اسم الحزمة الذي يحتوي عليه هو xdpyinfo إذا كان الأمر"
	arr["CHINESE",300]="如果 xdpyinfo 命令有效，则该脚本将能够计算您的屏幕分辨率并以更好的方式显示窗口。根据系统的不同，包含它的包名称可能是 x11-utils、xdpyinfo、xorg-xdpyinfo 等。"

	arr["ENGLISH",301]="For enterprise attacks, if you already have the legitimate certificates of the target network and the password, you can use them. If you don't have them, you can use airgeddon to generate some certificates with the same data and use them to make the attack more credible"
	arr["SPANISH",301]="Para los ataques enterprise, si tienes los certificados legítimos de la red objetivo y su contraseña, podrás utilizarlos. Si no los tienes, puedes generar con airgeddon unos certificados con los mismos datos y utilizarlos para que el ataque sea más creíble"
	arr["FRENCH",301]="Pour les attaques d'entreprise, si vous disposez des certificats légitimes du réseau objetive et de le mot de passe, vous pouvez les utiliser. Si vous ne les avez pas, vous pouvez générer avec airgeddon des certificats avec les mêmes données et les utiliser pour que l'attaque soit plus crédible"
	arr["CATALAN",301]="Per als atacs enterprise, si tens els certificats legítims de la xarxa objectiu i la contrasenya, podràs utilitzar-los. Si no els tens, pots generar amb airgeddon uns certificats amb les mateixes dades i utilitzar-los per que l'atac sigui més creïble"
	arr["PORTUGUESE",301]="Para ataques corporativos, se você tiver os certificados legítimos da rede e sua senha, poderá usá-los. Se você não tiver, pode gerar os certificados com airgeddon usando os mesmos dados tornando o ataque mais confiável"
	arr["RUSSIAN",301]="Для enterprise атак, если у вас есть действительные сертификаты целевой сети и пароль для них, вы можете использовать их. Если у вас их нет, вы можете создать сертификаты с помощью airgeddon с такими же данными и использовать их для повышения доверия у жертвы"
	arr["GREEK",301]="Για enterprise επιθέσεις, εάν έχετε τα νόμιμα πιστοποιητικά του δικτύου προορισμού και τον κωδικό πρόσβασής σας, μπορείτε να τα χρησιμοποιήσετε. Αν δεν τα έχετε, μπορείτε να χρησιμοποιήσετε το airgeddon για να δημιουργήσετε ορισμένα πιστοποιητικά με τα ίδια δεδομένα και να τα χρησιμοποιήσετε για να κάνετε την επίθεση πιο αξιόπιστη"
	arr["ITALIAN",301]="Per gli attacchi enterprise, se si dispone dei certificati legittimi della rete obiettivo e della sua password, è possibile utilizzarli. Se non li hai, puoi generareli con airgeddon con gli stessi dati e usarli per rendere l'attacco più credibile"
	arr["POLISH",301]="W przypadku ataków na sieci korporacyjne, jeśli masz prawidłowe certyfikaty sieci docelowej i hasło do nich, możesz ich użyć. Jeśli ich nie masz, możesz je wygenerować za pomocą airgeddon z tymi samymi danymi i wykorzystać je, aby atak był bardziej wiarygodny"
	arr["GERMAN",301]="Wenn Sie bei Unternehmensangriffen über die legitimen Zertifikate des Zielnetzwerks und Ihr Kennwort verfügen, können Sie diese verwenden. Wenn Sie diese nicht haben, können Sie mit airgeddon-Zertifikaten mit denselben Daten erstellen und sie verwenden, um den Angriff glaubwürdiger zu machen"
	arr["TURKISH",301]="Kurumsal saldırılarda, hedef ağın yasal sertifikalarına ve şifreniz varsa bunları kullanabilirsiniz. Onlara sahip değilseniz, aynı verilere sahip airgeddon sertifikalarıyla oluşturabilir ve saldırıyı daha inanılır hale getirmek için bunları kullanabilirsiniz"
	arr["ARABIC",301]="لإنشاء بعض الشهادات بنفس البيانات واستخدامها لجعل الهجوم أكثر مصداقية airgeddon إذا كان لديك بالفعل الشهادات الشرعية للشبكة المستهدفة وكلمة المرور ، فيمكنك استخدامها. إذا لم يكن لديك ، يمكنك استخدام ،enterprise بالنسبة لهجمات"
	arr["CHINESE",301]="对于企业级加密的无线网络攻击，如果你已经有目标网络的合法证书和密码，就可以使用。如果你没有它们，你可以使用airgeddon 生成一些具有相同数据的证书来使攻击更加容易"

	arr["ENGLISH",302]="Do you want to store in a file the sniffed captured passwords? \${blue_color}If you answer no (\"n\") they will be only shown on screen \${normal_color}\${visual_choice}"
	arr["SPANISH",302]="¿Deseas guardar en un fichero las contraseñas obtenidas del sniffing? \${blue_color}Si respondes que no (\"n\") solo se mostrarán por pantalla \${normal_color}\${visual_choice}"
	arr["FRENCH",302]="Voulez vous garder les mots de passe capturés dans un fichier? \${blue_color}Si vous répondez non (\"n\") les mots de passe s'afficheront à l'écran \${normal_color}\${visual_choice}"
	arr["CATALAN",302]="¿Vols guardar en un fitxer les contrasenyes obtingudes del sniffing? \${blue_color}Si respons que no (\"n\") només es mostraran per pantalla \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",302]="Você deseja armazenar em um arquivo as senhas obtidas com o sniffer? \${blue_color}Se você responder não (\"n\") as senhas só serão mostradas na tela \${normal_color}\${visual_choice}"
	arr["RUSSIAN",302]="Вы хотите сохранить в файл захваченные сниффингом пароли? \${blue_color}Если ваш ответ нет (\"n\") они будут только показаны на экране \${normal_color}\${visual_choice}"
	arr["GREEK",302]="Θέλετε να αποθηκεύσετε σε ένα αρχείο τους sniffed κωδικούς πρόσβασης; \${blue_color}Αν απαντήσετε όχι (\"n\") απλά θα εμφανιστούν στην οθόνη \${normal_color}\${visual_choice}"
	arr["ITALIAN",302]="Vuoi salvare in un file le password ottenute con sniffing? \${blue_color}Se si risponde no (\"n\") vengono visualizzate solo sullo schermo \${normal_color}\${visual_choice}"
	arr["POLISH",302]="Czy chcesz zapisywać hasła w plikach? \${blue_color}Jeśli odpowiesz nie (\"n\") zostaną tylko wyświetlone na ekranie \${normal_color}\${visual_choice}"
	arr["GERMAN",302]="Möchten Sie die aus dem Sniffing erhaltenen Passwörter in einer Datei speichern? \${blue_color} Wenn Sie mit Nein antworten (\"n\"), werden sie nur auf dem Bildschirm angezeigt \${normal_color}\${visual_choice}"
	arr["TURKISH",302]="Yakalanan şifreler bir dosyada saklamak ister misiniz? \${blue_color}Eğer cevap hayır ise (\"n\") sadece ekranda gösterilecekler \${normal_color}\${visual_choice}"
	arr["ARABIC",302]="\${normal_color}\${visual_choice} \${blue_color}فسيتم عرض كلمات المرور على الشاشة ،(\"n\") إذا أجبت بلا \${green_color}هل تريد الاحتفاظ بكلمات المرور الملتقطة في ملف؟\${normal_color}"
	arr["CHINESE",302]="您想将嗅探捕获到的密码存储在文件中吗？ \${blue_color}如果您回答否 (\"n\") 它们只会显示在屏幕上 \${normal_color}\${visual_choice}"

	arr["ENGLISH",303]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${default_ettercap_logpath}]"
	arr["SPANISH",303]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${default_ettercap_logpath}]"
	arr["FRENCH",303]="Entrez le chemin du fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${default_ettercap_logpath}]"
	arr["CATALAN",303]="Escriu la ruta on desarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${default_ettercap_logpath}]"
	arr["PORTUGUESE",303]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${default_ettercap_logpath}]"
	arr["RUSSIAN",303]="Напечатайте путь до файла для сохранения или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${default_ettercap_logpath}]"
	arr["GREEK",303]="Πληκτρολογήστε το μονοπάτι για να αποθηκεύσετε το αρχείο ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${default_ettercap_logpath}]"
	arr["ITALIAN",303]="Digitare il percorso dove memorizzare il file o premere [Enter] per accettare la proposta di default \${normal_color}[\${default_ettercap_logpath}]"
	arr["POLISH",303]="Wpisz ścieżkę, w której będziemy zapisywać plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${default_ettercap_logpath}]"
	arr["GERMAN",303]="Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag zu akzeptieren \${normal_color}[\${default_ettercap_logpath}]"
	arr["TURKISH",303]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${default_ettercap_logpath}]"
	arr["ARABIC",303]="\${normal_color}[\${default_ettercap_logpath}] \${green_color} لاستخدام المسار المقترح [Enter] أدخل مسار الملف أو اضغط على\${normal_color}"
	arr["CHINESE",303]="输入文件存储路径或按 [Enter] 接受默认建议 \${normal_color}[\${default_ettercap_logpath}]"

	arr["ENGLISH",304]="Parsing sniffer log..."
	arr["SPANISH",304]="Analizando log del sniffer..."
	arr["FRENCH",304]="Analyse du log des captures..."
	arr["CATALAN",304]="Analitzant log del sniffer..."
	arr["PORTUGUESE",304]="Analisando log do Sniffer..."
	arr["RUSSIAN",304]="Разбор журнала сниффера..."
	arr["GREEK",304]="Γίνεται ανάλυση του log του sniffer..."
	arr["ITALIAN",304]="Analizzando log dello sniffer..."
	arr["POLISH",304]="Analiza logu sniffera..."
	arr["GERMAN",304]="Sniffer-Protokoll Analyse..."
	arr["TURKISH",304]="Sniffer logu ayrıştırılıyor..."
	arr["ARABIC",304]="...تحليل سجل الشم"
	arr["CHINESE",304]="正在解析嗅探日志..."

	arr["ENGLISH",305]="No passwords detected on sniffers' log. File will not be saved"
	arr["SPANISH",305]="No se ha encontrado ninguna contraseña en el log del sniffer. No se guardará el fichero"
	arr["FRENCH",305]="Aucun mot de passe n'a été détecté. Le fichier ne sera pas sauvegardé"
	arr["CATALAN",305]="No s'ha trobat cap contrasenya en el log del sniffer. No es guarda el fitxer"
	arr["PORTUGUESE",305]="Nenhuma senha foi encontrada no log do sniffer. Arquivo não será salvo"
	arr["RUSSIAN",305]="В журнале сниффера паролей не обнаружено. Файл не будет сохранён"
	arr["GREEK",305]="Δεν εντοπίστηκαν κωδικοί πρόσβασης στο log του sniffer. Το αρχείο δεν θα αποθηκευτεί"
	arr["ITALIAN",305]="Nessuna password trovata nel log dello sniffer. Il file non viene salvato"
	arr["POLISH",305]="W logu sniffera nie znaleziono haseł. Plik nie zostanie zapisany"
	arr["GERMAN",305]="Im Sniffer-Protokoll wurde kein Passwort gefunden. Die Datei wird nicht gespeichert"
	arr["TURKISH",305]="Sniffers'ın günlüğünde hiçbir şifre algılanmadı. Dosya kaydedilmeyecek"
	arr["ARABIC",305]="لم يتم الكشف عن كلمة سر. لن يتم حفظ الملف"
	arr["CHINESE",305]="嗅探日志中未检测到密码。文件不会被保存"

	arr["ENGLISH",306]="Passwords captured by sniffer. File saved at \${normal_color}[\${ettercap_logpath}]"
	arr["SPANISH",306]="El sniffer ha capturado contraseñas. Fichero salvado en \${normal_color}[\${ettercap_logpath}]"
	arr["FRENCH",306]="Des mots de passe ont été capturé et ont été enregistré dans \${normal_color}[\${ettercap_logpath}]"
	arr["CATALAN",306]="El sniffer ha capturat contrasenyes. Fitxer desat a \${normal_color}[\${ettercap_logpath}]"
	arr["PORTUGUESE",306]="O sniffer capturou senhas. O arquivo foi salvo em \${normal_color}[\${ettercap_logpath}]"
	arr["RUSSIAN",306]="Сниффер захватил пароли. Файл сохранён в \${normal_color}[\${ettercap_logpath}]"
	arr["GREEK",306]="Καταγράφηκαν κωδικοί πρόσβασης από τον sniffer. Το αρχείο αποθηκεύτηκε στο \${normal_color}[\${ettercap_logpath}]"
	arr["ITALIAN",306]="Lo sniffer ha catturato delle password. File salvato in \${normal_color}[\${ettercap_logpath}]"
	arr["POLISH",306]="Sniffer przechwycił hasła. Plik zapisany w \${normal_color}[\${ettercap_logpath}]"
	arr["GERMAN",306]="Der Sniffer hat Passwörter erfasst. Datei in \${normal_color}[\${ettercap_logpath}] \${blue_color}gespeichert"
	arr["TURKISH",306]="Parolalar sniffer tarafından yakalandı. Şu dosyaya kaydedildi \${normal_color}[\${ettercap_logpath}]"
	arr["ARABIC",306]="\${normal_color}[\${ettercap_logpath}] \${blue_color}تم التقاط كلمات المرور بواسطة المتشمم. تم حفظ الملف في\${normal_color}"
	arr["CHINESE",306]="嗅探已经捕获密码。文件保存在 \${normal_color}[\${ettercap_logpath}]"

	arr["ENGLISH",307]="7.  Noisy mode Enterprise Evil Twin"
	arr["SPANISH",307]="7.  Evil Twin Enterprise modo noisy"
	arr["FRENCH",307]="7.  Evil Twin Enterprise mode bruyant"
	arr["CATALAN",307]="7.  Evil Twin Enterprise mode noisy"
	arr["PORTUGUESE",307]="7.  Evil Twin Enterprise (agressivo)"
	arr["RUSSIAN",307]="7.  Noisy режим Enterprise Evil Twin"
	arr["GREEK",307]="7.  Noisy mode Enterprise Evil Twin"
	arr["ITALIAN",307]="7.  Evil Twin Enterprise modalità noisy"
	arr["POLISH",307]="7.  Enterprise Evil Twin w trybie noisy"
	arr["GERMAN",307]="7.  Noisy-Modus Enterprise Evil Twin"
	arr["TURKISH",307]="7.  Noisy mod Enterprise Evil Twin"
	arr["ARABIC",307]="7.  Noisy mode Enterprise Evil Twin وضع"
	arr["CHINESE",307]="7.  嘈杂模式针对企业级加密的邪恶双胞胎"

	arr["ENGLISH",308]="6.  Russian"
	arr["SPANISH",308]="6.  Ruso"
	arr["FRENCH",308]="6.  Russe"
	arr["CATALAN",308]="6.  Rus"
	arr["PORTUGUESE",308]="6.  Russo"
	arr["RUSSIAN",308]="6.  Русский"
	arr["GREEK",308]="6.  Ρωσικά"
	arr["ITALIAN",308]="6.  Russo"
	arr["POLISH",308]="6.  Rosyjski"
	arr["GERMAN",308]="6.  Russisch"
	arr["TURKISH",308]="6.  Rusça"
	arr["ARABIC",308]="6.  الروسية"
	arr["CHINESE",308]="6.  俄语"

	arr["ENGLISH",309]="Sslstrip technique is not infallible. It depends on many factors and not always work. Some browsers such as Mozilla Firefox latest versions are not affected"
	arr["SPANISH",309]="La tecnica sslstrip no es infalible. Depende de muchos factores y no funciona siempre. Algunos navegadores como las últimas versiones de Mozilla Firefox no se ven afectados"
	arr["FRENCH",309]="La technique de sslstrip n'est pas à toute épreuve. Cela dépend de nombreux facteurs et ne fonctionne pas toujours. Certains navigateurs tels que Mozilla Firefox dans leurs versions les plus récentes ne sont pas vulnérables"
	arr["CATALAN",309]="La tècnica sslstrip no és infal·lible. Depèn de molts factors i no funciona sempre. Alguns navegadors com les últimes versions de Mozilla Firefox no es veuen afectats"
	arr["PORTUGUESE",309]="A técnica sslstrip não é infalível. Depende de muitos fatores e nem sempre funciona. Alguns navegadores como o Mozilla Firefox nas versões mais recentes não são afetados"
	arr["RUSSIAN",309]="Техника sslstrip не является надёжной. Эффект программы зависит от многих факторов и иногда она просто не работает. Некоторые браузеры, такие как Mozilla Firefox последних версий, не подвержены атаке"
	arr["GREEK",309]="Η τεχνική sslstrip δεν είναι αλάνθαστη. Εξαρτάται από πολλούς παράγοντες και δεν δουλεύει πάντα. Κάποιοι περιηγητές ιστού όπως οι τελευταίες εκδόσεις του Mozilla Firefox δεν επηρεάζονται"
	arr["ITALIAN",309]="La tecnica sslstrip non è infallibile. Dipende da molti fattori e non sempre funziona. Alcuni browser, come le ultime versioni di Mozilla Firefox non sono vulnerabili"
	arr["POLISH",309]="Technika sslstrip nie jest nieomylna. Zależy od wielu czynników i nie zawsze działa. Nie ma na przykład wpływu na niektóre przeglądarki, takie jak najnowsze wersje Mozilla Firefox"
	arr["GERMAN",309]="Die sslstrip-Technik ist nicht unfehlbar. Es hängt von vielen Faktoren ab und funktioniert nicht immer. Einige Browser wie die neuesten Mozilla Firefox Versionen sind nicht betroffen"
	arr["TURKISH",309]="Sslstrip tekniği yanılmaz değildir. Birçok faktöre bağlıdır ve her zaman işe yaramaz. Mozilla Firefox son sürümleri gibi bazı tarayıcılar etkilenmez"
	arr["ARABIC",309]="في أحدث إصداراتها محصنة Mozilla Firefox ليست مضمونة. يعتمد على العديد من العوامل ولا يعمل دائمًا. بعض المتصفحات مثل sslstrip تقنية"
	arr["CHINESE",309]="ssLstrip 并非万无一失。这取决于许多因素，它并不总是有效。部分浏览器如 Mozilla Firefox 的最新版本就不受影响"

	arr["ENGLISH",310]="Handshake file selected: \${pink_color}None\${normal_color}"
	arr["SPANISH",310]="Fichero de Handshake seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",310]="Fichier Handshake sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",310]="Fitxer de Handshake seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",310]="Arquivo de Handshake selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",310]="Выбранный файл рукопожатия: \${pink_color}Отсутствует\${normal_color}"
	arr["GREEK",310]="Επιλεγμένο αρχείο Χειραψίας: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",310]="File di Handshake selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",310]="Wybrany plik Handshake: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",310]="Ausgewählte Handshake-Datei: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",310]="Handshake dosyası seçildi: \${pink_color}None\${normal_color}"
	arr["ARABIC",310]="\${pink_color}None\${blue_color} :Handshake تم تحديد ملف\${normal_color}"
	arr["CHINESE",310]="选择的握手包文件: \${pink_color}None\${normal_color}"

	arr["ENGLISH",311]="Handshake file selected: \${pink_color}\${et_handshake}\${normal_color}"
	arr["SPANISH",311]="Fichero de Handshake seleccionado: \${pink_color}\${et_handshake}\${normal_color}"
	arr["FRENCH",311]="Fichier Handshake sélectionnée: \${pink_color}\${et_handshake}\${normal_color}"
	arr["CATALAN",311]="Fitxer de Handshake seleccionat: \${pink_color}\${et_handshake}\${normal_color}"
	arr["PORTUGUESE",311]="Arquivo de Handshake selecionado: \${pink_color}\${et_handshake}\${normal_color}"
	arr["RUSSIAN",311]="Выбранный файл рукопожатия: \${pink_color}\${et_handshake}\${normal_color}"
	arr["GREEK",311]="Επιλεγμένο αρχείο Χειραψίας: \${pink_color}\${et_handshake}\${normal_color}"
	arr["ITALIAN",311]="File di Handshake selezionato: \${pink_color}\${et_handshake}\${normal_color}"
	arr["POLISH",311]="Wybrany plik Handshake: \${pink_color}\${et_handshake}\${normal_color}"
	arr["GERMAN",311]="Ausgewählte Handshake-Datei: \${pink_color}\${et_handshake}\${normal_color}"
	arr["TURKISH",311]="Handshake dosyası seçildi: \${pink_color}\${et_handshake}\${normal_color}"
	arr["ARABIC",311]="\${pink_color}\${et_handshake}\${blue_color} :Handshake تم تحديد ملف\${normal_color}"
	arr["CHINESE",311]="选择的握手包文件: \${pink_color}\${et_handshake}\${normal_color}"

	arr["ENGLISH",312]="No selected Handshake file detected during this session..."
	arr["SPANISH",312]="No se ha detectado ningún fichero de Handshake seleccionado en esta sesión..."
	arr["FRENCH",312]="Aucun fichier Handshake valable a été sékectionné pour cette session..."
	arr["CATALAN",312]="No s'ha detectat un fitxer de Handshake seleccionat en aquesta sessió..."
	arr["PORTUGUESE",312]="Nenhum arquivo de Handshake foi selecionado nesta sessão..."
	arr["RUSSIAN",312]="Во время этой сессии выбранный файл рукопожатия не обнаружен..."
	arr["GREEK",312]="Δεν εντοπίστηκε κανένα αρχείο Χειραψίας κατά τη διάρκεια της συνεδρίας..."
	arr["ITALIAN",312]="Non è stato rilevato nessun file di Handshake selezionato in questa sessione..."
	arr["POLISH",312]="Nie wybrano pliku Handshake w tej sesji..."
	arr["GERMAN",312]="Keine Handshake-Datei erkannt bei dieser Session..."
	arr["TURKISH",312]="Bu oturumda hiçbir Handshake dosyası tespit edilmedi..."
	arr["ARABIC",312]="...محدد أثناء هذه الدورة Handshake لم يتم اكتشاف ملف"
	arr["CHINESE",312]="在此会话期间未检测到选定的握手包文件..."

	arr["ENGLISH",313]="Handshake selected file detected during this session [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["SPANISH",313]="Se ha detectado un fichero de Handshake seleccionado en esta sesión [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["FRENCH",313]="Le fichier handshake suivant a été détecté comme étant sélectionné pour cette session [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["CATALAN",313]="S'ha detectat un fitxer de Handshake seleccionat en aquesta sessió [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["PORTUGUESE",313]="Um arquivo de Handshake foi capturado nesta sessão [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["RUSSIAN",313]="Обнаружен файл рукопожатия, выбранный в этой сессии [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["GREEK",313]="Εντοπίστηκε επιλεγμένο αρχείο Χειραψίας κατά τη διάρκεια της συνεδρίας [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["ITALIAN",313]="Trovato un file di Handshake selezionato in questa sessione [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["POLISH",313]="Wkryto wybrany plik Handshake w tej sesji [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["GERMAN",313]="In dieser Sitzung wurde eine ausgewählte Handshake-Datei gefunden [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["TURKISH",313]="Bu oturumda handshake dosyyası tespit edildi [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["ARABIC",313]="[\${normal_color}\${et_handshake}\${blue_color}] المحدد أثناء هذه الدورة Handshake تم اكتشاف ملف"
	arr["CHINESE",313]="在此会话期间检测到选择的握手包文件 [\${normal_color}\${et_handshake}\${blue_color}]"

	arr["ENGLISH",314]="Handshake file selected: \${pink_color}\${enteredpath}\${normal_color}"
	arr["SPANISH",314]="Fichero de Handshake seleccionado: \${pink_color}\${enteredpath}\${normal_color}"
	arr["FRENCH",314]="Fichier Handshake sélectionné: \${pink_color}\${enteredpath}\${normal_color}"
	arr["CATALAN",314]="Fitxer de Handshake seleccionat: \${pink_color}\${enteredpath}\${normal_color}"
	arr["PORTUGUESE",314]="Arquivo de Handshake selecionado: \${pink_color}\${enteredpath}\${normal_color}"
	arr["RUSSIAN",314]="Выбранный файл рукопожатия: \${pink_color}\${enteredpath}\${normal_color}"
	arr["GREEK",314]="Επιλεγμένο αρχείο Χειραψίας: \${pink_color}\${enteredpath}\${normal_color}"
	arr["ITALIAN",314]="File di Handshake selezionato: \${pink_color}\${enteredpath}\${normal_color}"
	arr["POLISH",314]="Wybrany plik Handshake: \${pink_color}\${enteredpath}\${normal_color}"
	arr["GERMAN",314]="Ausgewählte Handshake-Datei: \${pink_color}\${enteredpath}\${normal_color}"
	arr["TURKISH",314]="Handshake dosyası seçildi \${pink_color}\${enteredpath}\${normal_color}"
	arr["ARABIC",314]="\${pink_color}\${enteredpath}\${blue_color} :Handshake تم تحديد ملف\${normal_color}"
	arr["CHINESE",314]="选择的握手包文件: \${pink_color}\${enteredpath}\${normal_color}"

	arr["ENGLISH",315]="This attack requires that you have previously a WPA/WPA2 network captured Handshake file"
	arr["SPANISH",315]="Este ataque requiere que tengas capturado previamente un fichero de Handshake de una red WPA/WPA2"
	arr["FRENCH",315]="Vous devez déjà avoir capturé un Handsahke WPA/WPA2 pour pouvoir lancer cette attaque"
	arr["CATALAN",315]="Aquest atac requereix que tinguis capturat prèviament un fitxer de Handshake d'una xarxa WPA/WPA2"
	arr["PORTUGUESE",315]="Este ataque requer que você já tenha capturado um arquivo de Handshake de uma rede WPA/WPA2"
	arr["RUSSIAN",315]="Эта атака требует предварительного захвата файла рукопожатия для WPA/WPA2 сети"
	arr["GREEK",315]="Αυτή η επίθεση απαιτεί να έχετε προηγουμένως κατεγράψει ένα αρχείο Χειραψίας από WPA/WPA2 δίκτο"
	arr["ITALIAN",315]="Questo attacco richiede che tu abbia catturato precedentemente un file di Handshake di una rete WPA/WPA2"
	arr["POLISH",315]="Ten atak wymaga uprzedniego przechwycenia pliku Handshake z sieci WPA/WPA2"
	arr["GERMAN",315]="Dieser Angriff erfordert, dass Sie zuvor eine Handshake-Datei aus einem WPA/WPA2-Netzwerk erfasst haben"
	arr["TURKISH",315]="Bu saldırı, daha önce WPA/WPA2 ağı ele geçirilmiş Handshake dosyasına sahip olmanızı gerektirir"
	arr["ARABIC",315]="مسبقًا WPA/WPA2 الذي تم التقاطه عبر شبكة Handshake يتطلب هذا الهجوم أن يكون لديك ملف"
	arr["CHINESE",315]="进行这种攻击之前需要有一个 WPA/WPA2 无线网络捕获的握手包文件"

	arr["ENGLISH",316]="An exploration looking for targets is going to be done..."
	arr["SPANISH",316]="Se va a realizar una exploración en busca de objetivos..."
	arr["FRENCH",316]="Recherche de réseaux cible..."
	arr["CATALAN",316]="Es realitzarà una exploració a la recerca d'objectius..."
	arr["PORTUGUESE",316]="Uma busca por redes wifi será realizada..."
	arr["RUSSIAN",316]="Выполнение сканирования целей..."
	arr["GREEK",316]="Πρόκειται να γίνει μία αναζήτηση για έυρεση στόχων..."
	arr["ITALIAN",316]="Si effettuerà una scansione in cerca di obiettivi..."
	arr["POLISH",316]="Zostanie przeprowadzone poszukiwanie celów..."
	arr["GERMAN",316]="Ein Scan wird auf der Suche nach Zielen durchgeführt..."
	arr["TURKISH",316]="Hedefleri arayan bir keşif yapılacaktır..."
	arr["ARABIC",316]="...سيتم إجراء استكشاف يبحث عن أهداف"
	arr["CHINESE",316]="一场寻找目标的探索即将展开……..."

	arr["ENGLISH",317]="If the password for the wifi network is achieved with the captive portal, you must decide where to save it. \${green_color}Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["SPANISH",317]="Si se consigue la contraseña de la red wifi con el portal cautivo, hay que decidir donde guardarla. \${green_color}Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["FRENCH",317]="Si un mot de passe est capté sur le portail captif il faut lui assigner un endroit pour être enregistré. \${green_color}Entrez le chemin du fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["CATALAN",317]="Si s'aconsegueix la contrasenya de la xarxa wifi amb el portal captiu, cal decidir on guardar-la. \${green_color}Escriu la ruta on desarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["PORTUGUESE",317]="Se a senha da rede wifi for conseguida com o portal cativo, onde deseja salvar? \${green_color}Digite um caminho para salvar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["RUSSIAN",317]="Вы должны решить, где будет сохранён пароль wifi сети, если он будет получен Перехватывающим порталом. \${green_color}Впишите путь до файла или нажмите [Enter] для принятия значения по умолчанию \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["GREEK",317]="Εάν ο κωδικός πρόσβασης του δικτύου wifi επιτευχθεί με captive portal, θα πρέπει να αποφασίσετε που θα τον αποθηκεύσετε. \${green_color}Πληκτρολογήστε το μονοπάτι για να αποθηκεύσετε το αρχείο ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["ITALIAN",317]="Se si ottiene la password della rete wireless con il captive portal, bisogna decidere dove salvarla. \${green_color}Immettere il percorso dove memorizzare il file o premere [Enter] per accettare quello di default proposto \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["POLISH",317]="Jeśli hasło sieci wifi zostanie uzyskane z portalu captive, musisz zdecydować gdzie je zapisać. \${green_color}Wpisz ścieżkę, w której zapiszemy plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["GERMAN",317]="Wenn Sie das WLAN-Passwort mit dem Captive Portal erhalten, müssen Sie entscheiden, wo es gespeichert werden soll. \${green_color} Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag zu akzeptieren \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["TURKISH",317]="Eğer wifi ağının şifresi esaret portalı ile yakalandıysa, nereye kaydedileceğini belirlemelisiniz. \${green_color}Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın. \${normal_color}[\${default_et_captive_portal_logpath}]"
	arr["ARABIC",317]="\${normal_color}[\${default_et_captive_portal_logpath}] \${green_color}لاستخدام المسار المقترح [Enter] أدخل مسار الملف أو اضغط على \${blue_color}.إذا تم التقاط كلمة سرعلى البوابة الأسيرة ، فيجب تخصيص مكان لتسجيلها"
	arr["CHINESE",317]="如果 wifi 网络的密码是通过强制门户获得的，您必须决定将其保存在何处。\${green_color}键入存储文件的路径或按 [Enter] 接受默认建议 \${normal_color}[\${default_et_captive_portal_logpath}]"

	arr["ENGLISH",318]="Choose the language in which network clients will see the captive portal:"
	arr["SPANISH",318]="Elige el idioma en el que los clientes de la red verán el portal cautivo:"
	arr["FRENCH",318]="Choisissez la langue dans laquelle les clients du réseau verront le portail captif:"
	arr["CATALAN",318]="Tria l'idioma en el qual els clients de la xarxa veuran el portal captiu:"
	arr["PORTUGUESE",318]="Escolha o idioma em que os clientes da rede irão ver o portal cativo:"
	arr["RUSSIAN",318]="Выберите язык, на котором клиенты сети будут видеть перехватывающий портал:"
	arr["GREEK",318]="Επιλέξτε τη γλώσσα που θα βλέπουν οι χρήστες του δικτύου στο captive portal:"
	arr["ITALIAN",318]="Scegli la lingua in cui i clienti della rete vedranno il captive portal:"
	arr["POLISH",318]="Wybierz język, w którym klienci sieci zobaczą portal:"
	arr["GERMAN",318]="Wählen Sie die Sprache, in der die Clients des Netzwerks das Captive-Portal sehen:"
	arr["TURKISH",318]="Ağ istemcilerinin Esaret Portalını göreceği dili seçin:"
	arr["ARABIC",318]=":اختر اللغة التي سيرى بها زبناء الشبكة البوابة الأسيرة"
	arr["CHINESE",318]="选择用户将看到的强制门户中的语言:"

	arr["ENGLISH",319]="The captive portal language has been established"
	arr["SPANISH",319]="Se ha establecido el idioma del portal cautivo"
	arr["FRENCH",319]="La langue pour le portail captif est activée"
	arr["CATALAN",319]="S'ha establert l'idioma del portal captiu"
	arr["PORTUGUESE",319]="A língua do portal cativo foi selecionada"
	arr["RUSSIAN",319]="Язык перехватывающего портала установлен"
	arr["GREEK",319]="Εγκαταστάθηκε η γλώσσα στο captive portal"
	arr["ITALIAN",319]="La lingua del captive portal è stata stabilita"
	arr["POLISH",319]="Został utworzony język portalu captive"
	arr["GERMAN",319]="Die Sprache des Captive-Portals wurde festgelegt"
	arr["TURKISH",319]="Esaret Portalının dili belirlendi"
	arr["ARABIC",319]="تم تفعيل لغة البوابة الأسيرة"
	arr["CHINESE",319]="强制门户语言已经建立"

	arr["ENGLISH",320]="7.  Greek"
	arr["SPANISH",320]="7.  Griego"
	arr["FRENCH",320]="7.  Grec"
	arr["CATALAN",320]="7.  Grec"
	arr["PORTUGUESE",320]="7.  Grego"
	arr["RUSSIAN",320]="7.  Греческий"
	arr["GREEK",320]="7.  Ελληνικά"
	arr["ITALIAN",320]="7.  Greco"
	arr["POLISH",320]="7.  Grecki"
	arr["GERMAN",320]="7.  Griechisch"
	arr["TURKISH",320]="7.  Yunanca"
	arr["ARABIC",320]="7.  اليونانية"
	arr["CHINESE",320]="7.  希腊语"

	arr["ENGLISH",321]="Do you already have a captured Handshake file? \${blue_color}Answer yes (\"y\") to enter the path or answer no (\"n\") to capture a new one now \${normal_color}\${visual_choice}"
	arr["SPANISH",321]="¿Tienes ya un fichero de Handshake capturado? \${blue_color}Responde sí (\"y\") para introducir la ruta o responde no (\"n\") para capturar uno ahora \${normal_color}\${visual_choice}"
	arr["FRENCH",321]="Avez-vous déjà un fichier contenant un Handshake capturé? \${blue_color}Répondre oui (\"y\") pour en saisir la route o buien répondre non (\"n\") pour le capturer \${normal_color}\${visual_choice}"
	arr["CATALAN",321]="¿Tens ja un fitxer de Handshake capturat? \${blue_color}Respon si (\"y\") per introduir la ruta o respon no (\"n\") per capturar-ne un ara \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",321]="Você já tem um arquivo de Handshake capturado? \${blue_color}Responda sim (\"y\") para colocar o caminho do arquivo ou responda não (\"n\") para capturar o arquivo agora \${normal_color}\${visual_choice}"
	arr["RUSSIAN",321]="У вас уже есть захваченный файл рукопожатия? \${blue_color}Ответьте Да (\"y\"), для ввода пути или ответьте Нет (\"n\"), для захвата нового рукопожатия \${normal_color}\${visual_choice}"
	arr["GREEK",321]="Έχετε ήδη κάποιο αρχείο Χειραψίας; \${blue_color}Απαντήστε ναι (\"y\") για να εισάγετε το μονοπάτι ή απαντήστε όχι (\"n\") για να καταγράψετε ένα νέο τώρα \${normal_color}\${visual_choice}"
	arr["ITALIAN",321]="Hai già catturato un file di Handshake? \${blue_color}Rispondi sì (\"y\") per introdurre il percorso o rispondi no (\"n\") per catturarne uno ora \${normal_color}\${visual_choice}"
	arr["POLISH",321]="Czy masz już przechwycony plik Handshake? \${blue_color}Odpowiedz tak (\"y\") aby wprowadzić ścieżkę lub odpowiedz nie (\"n\"), aby spróbować przechwycić go teraz \${normal_color}\${visual_choice}"
	arr["GERMAN",321]="Haben Sie bereits eine erfasste Handshake-Datei? \${blue_color} Ja beantworten (\"y\"), um den Pfad einzugeben oder antworten Sie mit Nein (\"n\"), um jetzt einen zu erfassen \${normal_color}\${visual_choice}"
	arr["TURKISH",321]="Yakalanmış bir Handshake dosyası var mı? \${blue_color}Evet ise (\"y\") dizini girin ya da cevap hayır ise (\"n\") yenisini yakalayın \${normal_color}\${visual_choice}"
	arr["ARABIC",321]="\${normal_color}\${visual_choice}\${blue_color} لالتقاط واحد جديد الآن (\"n\") لإدخال المسار أو أجب بلا (\"y\") أجب بنعم \${green_color}تم التقاطه؟ Handshake هل لديك بالفعل ملف\${normal_color}"
	arr["CHINESE",321]="您已经有捕获的握手包文件了吗？ \${blue_color}回答 yes (\"y\") 输入握手包路径或回答 no (\"n\") 现在捕获一个握手包 \${normal_color}\${visual_choice}"

	arr["ENGLISH",322]="It has been checked that there is a Handshake of the chosen target network while checking the selected capture file. Script can continue..."
	arr["SPANISH",322]="Se ha comprobado que existe un Handshake de la red elegida como objetivo durante la exploración en el fichero de captura seleccionado. El script puede continuar..."
	arr["FRENCH",322]="Un Handhsake du réseau cible a bien été retrouvé dans le paquet de capture préalablement choisi. Le script peut donc continuer..."
	arr["CATALAN",322]="S'ha comprovat que hi ha un Handshake de la xarxa triada com a objectiu durant l'exploració en el fitxer de captura seleccionat. El script pot continuar..."
	arr["PORTUGUESE",322]="Verificou-se que no arquivo de captura existe um Handshake da rede da selecionada como o alvo. O script pode continuar..."
	arr["RUSSIAN",322]="Проверка подтвердила, что рукопожатие относится к выбранной целевой сети. Скрипт может продолжать..."
	arr["GREEK",322]="Εντοπίστηκε η παρουσία Χειραψίας για το επιλεγμένο δίκτυο-στόχος καθώς γινόταν έλεγχος του επιλεγμένου αρχείου καταγραφής. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",322]="É stato riscontrato che c'è un Handshake della rete scelta como obiettivo durante la esplorazione del file di cattura selezionato. Lo script può continuare..."
	arr["POLISH",322]="Potwierdzono, że w wybranum pliku przechytywania jest plik Handshake z sieci docelowej. Skrypt może kontynuować..."
	arr["GERMAN",322]="Es wurde überprüft, dass beim Scannen in der ausgewählten Aufnahmedatei ein Handshake des Netzwerks als Ziel ausgewählt wurde. Das Skript kann fortfahren..."
	arr["TURKISH",322]="Seçilen çekim dosyasını kontrol ederken seçilen hedef ağın bir Handshake olduğunu kontrol edilmiştir. Yazılım devam edebilir..."
	arr["ARABIC",322]="...للشبكة المستهدفة المختارة أثناء فحص ملف الالتقاط المحدد. البرنامج يمكن أن يستمر Handshake تم التحقق من وجود"
	arr["CHINESE",322]="已发现所选的捕获文件包含目标网络的握手包。脚本可以继续..."

	arr["ENGLISH",323]="There is no Handshake/PMKID of the selected network on the capture file"
	arr["SPANISH",323]="No se ha encontrado un Handshake/PMKID de la red seleccionada en el fichero de captura"
	arr["FRENCH",323]="Aucun Handshake/PMKID du réseau cible n'a été retrouvé dans le fichier de captures"
	arr["CATALAN",323]="No s'ha trobat un Handshake/PMKID de la xarxa seleccionada en el fitxer de captura"
	arr["PORTUGUESE",323]="Não foi encontrado nenhum Handshake/PMKID da rede selecionada no arquivo de captura"
	arr["RUSSIAN",323]="В файле захвата отсутствует рукопожатие/PMKID выбранной сети"
	arr["GREEK",323]="Δεν υπάρχει Χειραψία/PMKID του επιλεγμένου δικτύου στο αρχείο καταγραφής"
	arr["ITALIAN",323]="Non è stato trovato una Handshake/PMKID della rete selezionata nel file di acquisizione"
	arr["POLISH",323]="Nie znaleziono pliku Handshake/PMKID z wybranej sieci w pliku przechwytywania"
	arr["GERMAN",323]="Ein Handshake/PMKID des ausgewählten Netzwerks wurde in der Erfassungsdatei nicht gefunden"
	arr["TURKISH",323]="Yakalama dosyasında seçilen ağın bir Handshake/PMKID'i yok"
	arr["ARABIC",323]="للشبكة المحددة في ملف الالتقاط Handshake/PMKID لا يوجد"
	arr["CHINESE",323]="捕获文件中没有所选网络的握手包/PMKID"

	arr["ENGLISH",324]="Capture file generated successfully at [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["SPANISH",324]="Fichero de captura generado con éxito en [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["FRENCH",324]="Fichier de capture généré avec succès dans [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["CATALAN",324]="Fitxer de captura generat amb èxit a [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["PORTUGUESE",324]="Arquivo de captura gerado com sucesso [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["RUSSIAN",324]="Файл с захваченными пакетами успешно создан в [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["GREEK",324]="Το αρχείο καταγραφής δημιουργήθηκε επιτυχώς στο [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["ITALIAN",324]="File di cattura generato con successo in [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["POLISH",324]="Plik przechwytywania został pomyślnie wygenerowany w [\${normal_color}\${et_handshake}\${blue_color}]"
	arr["GERMAN",324]="Capture-Datei wurde erfolgreich in [\${normal_color}\${et_handshake}\${blue_color}] generiert"
	arr["TURKISH",324]="Yakalama dosyası burada: [\${normal_color}\${et_handshake}\${blue_color}] başarıyla oluşturuldu"
	arr["ARABIC",324]="[\${normal_color}\${et_handshake}\${blue_color}] تم إنشاء ملف الالتقاط بنجاح في"
	arr["CHINESE",324]="在 [\${normal_color}\${et_handshake}\${blue_color}] 成功生成捕获文件"

	arr["ENGLISH",325]="Wait. Be patient..."
	arr["SPANISH",325]="Espera. Ten un poco de paciencia..."
	arr["FRENCH",325]="Ayez un peu de patience s'il vous plait..."
	arr["CATALAN",325]="Espera. Tingues una mica de paciència..."
	arr["PORTUGUESE",325]="Aguarde. Por favor, seja paciente..."
	arr["RUSSIAN",325]="Пожалуйста, подождите..."
	arr["GREEK",325]="Περιμένετε. Έχετε λίγη υπομονή..."
	arr["ITALIAN",325]="Aspetta. Devi avere un pò di pazienza..."
	arr["POLISH",325]="Czekaj cierpliwie..."
	arr["GERMAN",325]="Bitte warten. Wir bitten um ein wenig Geduld..."
	arr["TURKISH",325]="Bekleyin. Lütfen sabırlı olun..."
	arr["ARABIC",325]="...انتظر. كن صبورا"
	arr["CHINESE",325]="请稍等。要有耐心..."

	arr["ENGLISH",326]="Certificates are invalid or expired, so the attack can't be performed"
	arr["SPANISH",326]="Los certificados no son válidos o están caducados, por lo que el ataque no se puede realizar"
	arr["FRENCH",326]="Les certificats ne sont pas valides ou ont expiré. Donc l'attaque ne peut pas être effectuée"
	arr["CATALAN",326]="Els certificats no són vàlids o estan caducats, de manera que l'atac no es pot realitzar"
	arr["PORTUGUESE",326]="Os certificados são inválidos ou expiraram, o ataque não pode ser executado"
	arr["RUSSIAN",326]="Сертификаты недействительны или устарели, поэтому атака не может быть выполнена"
	arr["GREEK",326]="Τα certificates είναι άκυρα ή έχουν λήξει, οπότε η επίθεση δεν μπορεί να εκτελεστεί"
	arr["ITALIAN",326]="I certificati non sono validi o sono scaduti, quindi l'attacco non può essere eseguito"
	arr["POLISH",326]="Certyfikaty są nieprawidłowe lub nieaktualne, więc nie można wykonać ataku"
	arr["GERMAN",326]="Zertifikate sind ungültig oder veraltet, also kann der Angriff nicht ausgeführt werden"
	arr["TURKISH",326]="Sertifikalar geçersiz veya eski, bu nedenle saldırı gerçekleştirilemiyor"
	arr["ARABIC",326]="الشهادات غير صالحة أو منتهية الصلاحية ، لذا لا يمكن تنفيذ الهجوم"
	arr["CHINESE",326]="您的证书无效或过期，因此无法执行攻击"

	arr["ENGLISH",327]="Enter the directory path where the certificates files are located. \${blue_color}Make sure that the ca.pem, server.pem and server.key files exist in the given path:"
	arr["SPANISH",327]="Introduce la ruta del directorio donde se encuentran los ficheros de los certificados. \${blue_color}Asegúrate de que los ficheros ca.pem, server.pem y server.key existen en la ruta indicada:"
	arr["FRENCH",327]="Entrez le chemin du répertoire dans lequel se trouvent les fichiers du certificats. \${blue_color}Assurez-vous que les fichiers ca.pem, server.pem et server.key existent dans le chemin indiqué:"
	arr["CATALAN",327]="Introdueix la ruta del directori on es troben els fitxers dels certificats. \${blue_color}Assegura't que els fitxers ca.pem, server.pem i server.key existeixen a la ruta indicada:"
	arr["PORTUGUESE",327]="Digite o caminho do diretório onde os arquivos de certificado estão localizados. \${blue_color}Certifique-se de que os arquivos ca.pem, server.pem e server.key existam no caminho indicado:"
	arr["RUSSIAN",327]="Введите путь к каталогу, в котором находятся файлы сертификатов. \${blue_color}Убедитесь, что файлы ca.pem, server.pem и server.key существуют по указанному пути:"
	arr["GREEK",327]="Εισάγετε τη διαδρομή καταλόγου όπου βρίσκονται τα αρχεία certificates. \${blue_color}Βεβαιωθείτε ότι τα αρχεία ca.pem, server.pem και server.key υπάρχουν στην υποδεικνυόμενη διαδρομή:"
	arr["ITALIAN",327]="Immettere il percorso della directory in cui si trovano i files del certificato. \${blue_color}Assicurati che i file ca.pem, server.pem e server.key esistano nel percorso indicato:"
	arr["POLISH",327]="Wprowadź ścieżkę do katalogu, w którym znajdują się pliki certyfikatów. \${blue_color}Upewnij się, że pliki ca.pem, server.pem i server.key istnieją we wskazanej ścieżce:"
	arr["GERMAN",327]="Geben sie den Verzeichnispfad ein, in dem sich die Zertifikatdateien befinden. \${blue_color}Stellen Sie sicher, dass die Dateien ca.pem, server.pem und server.key im angegebenen Pfad vorhanden sind:"
	arr["TURKISH",327]="Sertifika dosyalarının bulunduğu dizin yolunu girin. \${blue_color}ca.pem, server.pem ve server.key dosyalarının belirtilen yolda bulunduğundan emin olun:"
	arr["ARABIC",327]="\${blue_color}:في المسار المحدد server.key و server.pem و ca.pem تأكد من وجود ملفات \${blue_color}.أدخل مسار الدليل حيث توجد ملفات الشهادات"
	arr["CHINESE",327]="请输入证书文件所在的目录路径。\${blue_color}确保给定路径中存在 ca.pem、server.pem 和 server.key 文件:"

	arr["ENGLISH",328]="The only Evil Twin attack in which it's not necessary to have an additional interface with internet access is the captive portal attack"
	arr["SPANISH",328]="El único ataque de Evil Twin en el que no es necesario tener una interfaz adicional con acceso a internet es el del portal cautivo"
	arr["FRENCH",328]="La seule attaque Evil Twin pour laquelle il n'est pas nécessaire d'avoir une interface supplémentaire connectée à internet est l'attaque du portail captif"
	arr["CATALAN",328]="L'únic atac d'Evil Twin en què no cal tenir una interfície addicional amb accés a internet és el del portal captiu"
	arr["PORTUGUESE",328]="O único ataque Evil Twin em que não é necessário ter uma interface adicional com acesso à internet é o portal cativo"
	arr["RUSSIAN",328]="Уникальная атака Злой Двойник, при которой необязательно иметь дополнительный интерфейс с доступом в Интернет для атаки Перехватывающим Порталом"
	arr["GREEK",328]="Η μόνη επίθεση Evil Twin στην οποία δεν είναι απαραίτητο να έχετε επιπλέον διεπαφή με πρόσβαση στο διαδίκτυο είναι η επίθεση με captive portal"
	arr["ITALIAN",328]="L'unico attacco di tipo Evil Twin in cui non è necessario avere un'interfaccia supplementare con accesso a internet è quello con captive portal"
	arr["POLISH",328]="Jedynym atakiem Evil Twin, w którym nie ma konieczności dodatkowego interfejsu z dostępem do internetu, jest atak Captive Portal"
	arr["GERMAN",328]="Der einzige Angriff von Evil Twin, bei dem keine zusätzliche Interface zum Internetzugang benötigt wird, ist die des Captive-Portals"
	arr["TURKISH",328]="İnternet erişimi olan ek bir arayüze sahip olmanın gerekli olmadığı benzersiz Şeytani İkiz saldırısı, esaret portalı saldırısıdır"
	arr["ARABIC",328]="الفريد الذي لا يلزم فيه وجود واجهة إضافية متصلة بالإنترنت هو هجوم البوابة الأسيرة Evil Twin هجوم"
	arr["CHINESE",328]="独特的邪恶双胞胎 (Evil Twin) 攻击不需要额外的网络接口来进行强制门户攻击"

	arr["ENGLISH",329]="Enter the password used during the creation of the certificate files. \${blue_color}Remember that if they were generated using airgeddon, the used password was \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["SPANISH",329]="Introduce la contraseña utilizada en la creación de los ficheros de los certificados. \${blue_color}Recuerda que si fueron generados con airgeddon, la contraseña que se utilizó fue \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["FRENCH",329]="Entrez le mot de passe utilisé lors de la création des fichiers du certificats. \${blue_color}N'oubliez pas que s'ils ont été générés avec airgeddon, le mot de passe utilisé était \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["CATALAN",329]="Introdueix la contrasenya utilitzada en la creació dels fitxers dels certificats. \${blue_color}Recorda que si van ser generats amb airgeddon, la contrasenya que es va utilitzar va ser \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["PORTUGUESE",329]="Digite a senha usada na criação dos arquivos de certificado. \${blue_color}Lembre-se de que, se eles foram gerados com airgeddon, a senha usada foi \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["RUSSIAN",329]="Введите пароль, использованный при создании файлов сертификата. \${blue_color}Помните, что если они были созданы с помощью airgeddon, то использовался пароль \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["GREEK",329]="Καταχωρίστε τον κωδικό πρόσβασης που χρησιμοποιήθηκε κατά δημιουργία των αρχείων certificates. \${blue_color}Να θυμάστε ότι αν δημιουργήθηκαν με airgeddon, ο κωδικός που χρησιμοποιήθηκε ήταν \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["ITALIAN",329]="Immettere la password utilizzata durante la creazione dei files del certificato. \${blue_color}Ricorda che se sono stati generati con airgeddon, la password utilizzata era \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["POLISH",329]="Wprowadź hasło użyte przy tworzeniu plików certyfikatów. \${blue_color}Pamiętaj, że jeśli zostały wygenerowane za pomocą airgeddon, użyte hasło to \${normal_color}\"airgeddon\"\${blue_color}:"
	arr["GERMAN",329]="Geben sie das Kennwort ein, das bei der Erstellung der Zertifikatdateien verwendet wurde. \${blue_color}Vergessen Sie nicht, dass das verwendete Passwort \${normal_color}\"airgeddon\"\${blue_color} lautet, wenn sie mit airgeddon generiert wurden:"
	arr["TURKISH",329]="Sertifika dosyalarının oluşturulmasında kullanılan şifreyi girin. \${blue_color}Unutmayın ki bunlar airgeddon ile oluşturulduysa, \${normal_color}\"airgeddon\"\${blue_color} kullanılan parolaydı:"
	arr["ARABIC",329]="\${normal_color}\"airgeddon\"\${blue_color} :إن كلمة المرور المستخدمة كانت .airgeddon تذكر أنه إذا تم إنشاؤها باستخدام \${green_color}.أدخل كلمة السرالمستخدمة عند إنشاء ملفات الشهادت\${blue_color}"
	arr["CHINESE",329]="请输入在创建证书文件时使用的密码。\${blue_color}请记住，如果它们是使用 airgeddon 生成的，则初始密码为 \${normal_color}\"airgeddon\"\${blue_color}:"

	arr["ENGLISH",330]="Private key is invalid or the password is wrong, so the attack can't be performed"
	arr["SPANISH",330]="La clave privada no es válida o la contraseña es errónea, por lo que el ataque no se puede realizar"
	arr["FRENCH",330]="La clé privée n'est pas valide ou le mot de passe est incorrect. Donc l'attaque ne peut pas être effectuée"
	arr["CATALAN",330]="La clau privada no és vàlida o la contrasenya és errònia, de manera que l'atac no es pot realitzar"
	arr["PORTUGUESE",330]="Sua chave privada não é válida ou a senha está errada, o ataque não pode ser executado"
	arr["RUSSIAN",330]="Закрытый ключ неверен или пароль неверен, поэтому атака не может быть выполнена"
	arr["GREEK",330]="Το ιδιωτικό κλειδί δεν είναι έγκυρο ή ο κωδικός πρόσβασης είναι λάθος, επομένως η επίθεση δεν μπορεί να εκτελεστεί"
	arr["ITALIAN",330]="La chiave privata non è valida o la password è errata, quindi l'attacco non può essere eseguito"
	arr["POLISH",330]="Klucz prywatny jest nieprawidłowy lub hasło jest błędne, więc nie można wykonać ataku"
	arr["GERMAN",330]="Der private Schlüssel ist ungültig oder das Passwort ist falsch, also kann der Angriff nicht ausgeführt werden"
	arr["TURKISH",330]="Özel anahtar geçersiz veya şifre yanlış, bu nedenle saldırı gerçekleştirilemiyor"
	arr["ARABIC",330]="المفتاح الخاص غير صالح أو كلمة المرور خاطئة ، لذلك لا يمكن تنفيذ الهجوم"
	arr["CHINESE",330]="私钥无效或密码错误，无法进行攻击"

	arr["ENGLISH",331]="10. German"
	arr["SPANISH",331]="10. Alemán"
	arr["FRENCH",331]="10. Allemand"
	arr["CATALAN",331]="10. Alemany"
	arr["PORTUGUESE",331]="10. Alemão"
	arr["RUSSIAN",331]="10. Немецкий"
	arr["GREEK",331]="10. Γερμανικά"
	arr["ITALIAN",331]="10. Tedesco"
	arr["POLISH",331]="10. Niemiecki"
	arr["GERMAN",331]="10. Deutsch"
	arr["TURKISH",331]="10. Almanca"
	arr["ARABIC",331]="10. الألمانية"
	arr["CHINESE",331]="10. 德语"

	arr["ENGLISH",332]="Before launching an attack against an Enterprise network, bear in mind that \"noisy\" mode will cause legitimate clients stuck trying to authenticate over and over again on the fake network. This could raise suspicions and you could be easily discovered"
	arr["SPANISH",332]="Antes de lanzar un ataque contra una red Enterprise, ten en cuenta que el modo \"noisy\" dejará a los clientes legítimos atrapados intentando autenticarse una y otra vez contra la red falsa. Esto podría levantar sospechas y podrías ser descubierto fácilmente"
	arr["FRENCH",332]="Avant d'efectuer une attaque contre un réseau entreprise, gardez à l'esprit que le mode \"noisy\" faira des clients légitimes piégés en s'authentifier encore et encore contre le faux réseau. Ça pourrait susciter des soupçons et pourrait être facilement découvert"
	arr["CATALAN",332]="Abans de llançar un atac contra una xarxa Enterprise, tingues en compte que el mode \"noisy\" deixarà als clients legítims atrapats intentant autenticar una vegada i un altra contra la xarxa falsa. Això podria aixecar sospites i podries ser descobert fàcilment"
	arr["PORTUGUESE",332]="Antes de iniciar um ataque contra uma rede Enterprise, lembre-se de que o \"modo agressivo\" fará com que os clientes legítimos falhem repetidas vezes ao se autenticar com a rede falsa. Isso pode levantar suspeitas e o ataque pode ser facilmente descoberto"
	arr["RUSSIAN",332]="Прежде чем приступать к атаке на корпоративную сеть, имейте в виду, что режим \"noisy\" приведёт к тому, что законные клиенты будут пытаться аутентифицироваться снова и снова в поддельной сети. Это может вызвать подозрения, и вас можно легко обнаружить"
	arr["GREEK",332]="Πριν ξεκινήσετε μια επίθεση σε ένα δίκτυο Enterprise, λάβετε υπόψη σας ότι το \"noisy\" mode θα προκαλέσει την παραμονή των πελατών που προσπαθούν να επαληθευθούν ξανά και ξανά στο πλαστό δίκτυο. Αυτό θα μπορούσε να προκαλέσει υποψίες και θα μπορούσε εύκολα να ανακαλυφθεί"
	arr["ITALIAN",332]="Prima di lanciare un attacco contro una rete Enterpise, tieni presente che la modalità \"noisy\" lascierá i clienti legittimi intrappolati cercando di eseguire ripetutamente l'autenticazione contro la rete falsa. Questo potrebbe sollevare sospetti e potrebbe essere facilmente scoperto"
	arr["POLISH",332]="Przed rozpoczęciem ataku na sieć Enterprise należy pamiętać, że tryb \"noisy\" uniemożliwi legalnym klientom próbę ponownego uwierzytelnienia się w fałszywej sieci. Może to wzbudzić podejrzenia i jest łatwe do wykrycia"
	arr["GERMAN",332]="Beachten Sie vor dem Starten eines Angriffs auf ein Enterprise-Netzwerk, dass der \"noisy\" Modus legitime Clients daran hindert, sich immer wieder gegen das gefälschte Netzwerk zu authentifizieren. Dies könnte zu Misstrauen führen und könnte leicht entdeckt werden"
	arr["TURKISH",332]="Kurumsal bir ağa karşı saldırı başlatmadan önce, \"noisy\" modun meşru istemcilerin sahte ağa karşı tekrar ve tekrar kimlik doğrulamaya çalışacağını unutmayın. Bu şüpheli gözükebilir ve kolayca keşfedilebilir"
	arr["ARABIC",332]="سيؤدي إلى توقف الزبناء الشرعيين عن محاولة المصادقة مرارًا وتكرارًا على الشبكة المزيفة. هذا يمكن أن يثير الشكوك ويمكن أن تكتشف بسهولة \"noisy\" ضع في اعتبارك أن الوضع،Enterprise قبل شن هجوم على شبكة"
	arr["CHINESE",332]="在对企业级加密的网络发起攻击之前，请记住“嘈杂”模式会导致合法客户端在虚假网络上一遍又一遍地尝试进行身份验证。这可能会引起怀疑，您很容易被发现"

	arr["ENGLISH",333]="8.  WPS attacks menu"
	arr["SPANISH",333]="8.  Menú de ataques WPS"
	arr["FRENCH",333]="8.  Menu d'attaques WPS"
	arr["CATALAN",333]="8.  Menú d'atacs WPS"
	arr["PORTUGUESE",333]="8.  Menu de ataques WPS"
	arr["RUSSIAN",333]="8.  Меню атак на WPS"
	arr["GREEK",333]="8.  Μενού επιθέσεων WPS"
	arr["ITALIAN",333]="8.  Menú degli attacchi WPS"
	arr["POLISH",333]="8.  Menu ataków WPS"
	arr["GERMAN",333]="8.  WPS-Angriffsmenü"
	arr["TURKISH",333]="8.  WPS saldırı menüsü"
	arr["ARABIC",333]="8.  WPS قائمة هجمات"
	arr["CHINESE",333]="8.  WPS 攻击菜单"

	arr["ENGLISH",334]="WPS attacks menu"
	arr["SPANISH",334]="Menú de ataques WPS"
	arr["FRENCH",334]="Menu d'attaques WPS"
	arr["CATALAN",334]="Menú d'atacs WPS"
	arr["PORTUGUESE",334]="Menu de ataques WPS"
	arr["RUSSIAN",334]="Меню атак на WPS"
	arr["GREEK",334]="Μενού επιθέσεων WPS"
	arr["ITALIAN",334]="Menú degli attacchi WPS"
	arr["POLISH",334]="Menu ataków WPS"
	arr["GERMAN",334]="WPS-Angriffsmenü"
	arr["TURKISH",334]="WPS saldırı menüsü"
	arr["ARABIC",334]="WPS قائمة هجمات"
	arr["CHINESE",334]="WPS 攻击菜单"

	arr["ENGLISH",335]="Selected WPS BSSID: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["SPANISH",335]="BSSID WPS seleccionado: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["FRENCH",335]="BSSID WPS sélectionné: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["CATALAN",335]="BSSID WPS seleccionat: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["PORTUGUESE",335]="BSSID WPS selecionado: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["RUSSIAN",335]="Выбран WPS BSSID: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["GREEK",335]="Επιλεγμένο WPS BSSID: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["ITALIAN",335]="BSSID WPS selezionato: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["POLISH",335]="Wybrano BSSID WPS: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["GERMAN",335]="Ausgewählte WPS BSSID: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["TURKISH",335]="WPS BSSID seçildi: \${pink_color}\${wps_bssid}\${normal_color}"
	arr["ARABIC",335]="\${pink_color}\${wps_bssid}\${blue_color} :المختار WPS BSSID\${normal_color}"
	arr["CHINESE",335]="已选择的 WPS BSSID: \${pink_color}\${wps_bssid}\${normal_color}"

	arr["ENGLISH",336]="Selected WPS channel: \${pink_color}\${wps_channel}\${normal_color}"
	arr["SPANISH",336]="Canal WPS seleccionado: \${pink_color}\${wps_channel}\${normal_color}"
	arr["FRENCH",336]="Canal WPS sélectionné: \${pink_color}\${wps_channel}\${normal_color}"
	arr["CATALAN",336]="Canal WPS seleccionat: \${pink_color}\${wps_channel}\${normal_color}"
	arr["PORTUGUESE",336]="Canal WPS selecionado: \${pink_color}\${wps_channel}\${normal_color}"
	arr["RUSSIAN",336]="Выбран WPS канал: \${pink_color}\${wps_channel}\${normal_color}"
	arr["GREEK",336]="Επιλεγμένο WPS κανάλι: \${pink_color}\${wps_channel}\${normal_color}"
	arr["ITALIAN",336]="Canale WPS selezionato: \${pink_color}\${wps_channel}\${normal_color}"
	arr["POLISH",336]="Wybrano kanał WPS: \${pink_color}\${wps_channel}\${normal_color}"
	arr["GERMAN",336]="Ausgewählter WPS-Kanal: \${pink_color}\${wps_channel}\${normal_color}"
	arr["TURKISH",336]="WPS kanal seçildi: \${pink_color}\${wps_channel}\${normal_color}"
	arr["ARABIC",336]="\${pink_color}\${wps_channel}\${blue_color} :المختارة WPS قناة\${normal_color}"
	arr["CHINESE",336]="当前 WPS 信道: \${pink_color}\${wps_channel}\${normal_color}"

	arr["ENGLISH",337]="Selected WPS ESSID: \${pink_color}\${wps_essid}\${blue_color} <- can't be used"
	arr["SPANISH",337]="ESSID WPS seleccionado: \${pink_color}\${wps_essid}\${blue_color} <- no se puede usar"
	arr["FRENCH",337]="ESSID WPS sélectionné: \${pink_color}\${wps_essid}\${blue_color} <- ne peut pas être utilisé"
	arr["CATALAN",337]="ESSID WPS seleccionat: \${pink_color}\${wps_essid}\${blue_color} <- no es pot utilitzar"
	arr["PORTUGUESE",337]="ESSID WPS selecionado: \${pink_color}\${wps_essid}\${blue_color} <- não pode ser utilizado"
	arr["RUSSIAN",337]="Выбран WPS ESSID: \${pink_color}\${wps_essid}\${blue_color} <- не может использоваться"
	arr["GREEK",337]="Επιλεγμένο WPS ESSID: \${pink_color}\${wps_essid}\${blue_color} <- δεν μπορεί να χρησιμοποιηθεί"
	arr["ITALIAN",337]="ESSID WPS selezionato: \${pink_color}\${wps_essid}\${blue_color} <- non può essere utilizzato"
	arr["POLISH",337]="Wybrano WPS ESSID: \${pink_color}\${wps_essid}\${blue_color} <- nie można użyć"
	arr["GERMAN",337]="Ausgewählte ESSID WPS: \${pink_color}\${wps_essid}\${blue_color} <- kann nicht verwendet werden"
	arr["TURKISH",337]="WPS ESSID seçildi: \${pink_color}\${wps_essid}\${blue_color} <- kullanılamaz"
	arr["ARABIC",337]="\${blue_color}لا يمكن استخدامها -> \${pink_color}\${wps_essid}\${blue_color} :المختار ESSID WPS"
	arr["CHINESE",337]="已选择的 WPS ESSID: \${pink_color}\${wps_essid}\${blue_color} <- 不能使用"

	arr["ENGLISH",338]="Selected WPS ESSID: \${pink_color}\${wps_essid}\${normal_color}"
	arr["SPANISH",338]="ESSID WPS seleccionado: \${pink_color}\${wps_essid}\${normal_color}"
	arr["FRENCH",338]="ESSID WPS sélectionné: \${pink_color}\${wps_essid}\${normal_color}"
	arr["CATALAN",338]="ESSID WPS seleccionat: \${pink_color}\${wps_essid}\${normal_color}"
	arr["PORTUGUESE",338]="ESSID WPS selecionado: \${pink_color}\${wps_essid}\${normal_color}"
	arr["RUSSIAN",338]="Выбран WPS ESSID: \${pink_color}\${wps_essid}\${normal_color}"
	arr["GREEK",338]="Επιλεγμένο WPS ESSID: \${pink_color}\${wps_essid}\${normal_color}"
	arr["ITALIAN",338]="ESSID WPS selezionato: \${pink_color}\${wps_essid}\${normal_color}"
	arr["POLISH",338]="Wybrano WPS ESSID: \${pink_color}\${wps_essid}\${normal_color}"
	arr["GERMAN",338]="Ausgewählte ESSID WPS: \${pink_color}\${wps_essid}\${normal_color}"
	arr["TURKISH",338]="WPS ESSID seçildi: \${pink_color}\${wps_essid}\${normal_color}"
	arr["ARABIC",338]="\${pink_color}\${wps_essid}\${blue_color} :المختار ESSID WPS\${normal_color}"
	arr["CHINESE",338]="已选择的 WPS ESSID: \${pink_color}\${wps_essid}\${normal_color}"

	arr["ENGLISH",339]="Selected WPS BSSID: \${pink_color}None\${normal_color}"
	arr["SPANISH",339]="BSSID WPS seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",339]="BSSID WPS sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",339]="BSSID WPS seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",339]="BSSID WPS selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",339]="Выбран WPS BSSID: \${pink_color}Нет\${normal_color}"
	arr["GREEK",339]="Επιλεγμένο WPS BSSID: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",339]="BSSID WPS selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",339]="Wybrano WPS BSSID: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",339]="Ausgewählte BSSID WPS: \${pink_color}Keines\${normal_color}"
	arr["TURKISH",339]="WPS BSSID seçildi: \${pink_color}None\${normal_color}"
	arr["ARABIC",339]="\${pink_color}None\${blue_color}:المختار WPS BSSID\${normal_color}"
	arr["CHINESE",339]="已选择的 WPS BSSID: \${pink_color}None\${normal_color}"

	arr["ENGLISH",340]="Selected WPS channel: \${pink_color}None\${normal_color}"
	arr["SPANISH",340]="Canal WPS seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",340]="Canal WPS sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",340]="Canal WPS seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",340]="Canal WPS selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",340]="Выбран WPS канал: \${pink_color}Нет\${normal_color}"
	arr["GREEK",340]="Επιλεγμένο WPS κανάλι: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",340]="Canale WPS selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",340]="Wybrano kanał WPS: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",340]="Ausgewählter WPS-Kanal: \${pink_color}Keinen\${normal_color}"
	arr["TURKISH",340]="WPS kanal seçildi: \${pink_color}None\${normal_color}"
	arr["ARABIC",340]="\${pink_color}None\${blue_color} :المختارة WPS قناة\${normal_color}"
	arr["CHINESE",340]="已选择的 WPS 信道: \${pink_color}None\${normal_color}"

	arr["ENGLISH",341]="Selected WPS ESSID: \${pink_color}None\${normal_color}"
	arr["SPANISH",341]="ESSID WPS seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",341]="ESSID WPS sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",341]="ESSID WPS seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",341]="ESSID WPS selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",341]="Выбран WPS ESSID: \${pink_color}Нет\${normal_color}"
	arr["GREEK",341]="Επιλεγμένο WPS ESSID: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",341]="ESSID WPS selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",341]="Wybrano WPS ESSID: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",341]="Ausgewählte ESSID WPS: \${pink_color}Keines\${normal_color}"
	arr["TURKISH",341]="WPS ESSID seçildi: \${pink_color}None\${normal_color}"
	arr["ARABIC",341]="\${pink_color}None\${blue_color} :المختار ESSID WPS\${normal_color}"
	arr["CHINESE",341]="已选择的 WPS ESSID: \${pink_color}None\${normal_color}"

	arr["ENGLISH",342]="Pixie Dust attack obtains PIN and password in seconds, but not all access points are affected"
	arr["SPANISH",342]="El ataque Pixie Dust obtiene el PIN y la clave en segundos, pero no todos los puntos de acceso son vulnerables a este ataque"
	arr["FRENCH",342]="L'attaque Pixie Dust permet l'obtention du PIN et du mot de passe en quelques secondes mais les points d'accès ne sont pas tous vulnérables"
	arr["CATALAN",342]="L'atac Pixie Dust obté el PIN i la clau en segons, però no tots els punts d'accés són vulnerables a aquest atac"
	arr["PORTUGUESE",342]="O ataque Pixie Dust recebe o PIN e a senha em segundos, mas nem todos os pontos de acesso são vulneráveis a este ataque"
	arr["RUSSIAN",342]="Pixie Dust находит PIN-код и пароль за считанные секунды, но не все точки доступа подвержены этой атаке"
	arr["GREEK",342]="Η επίθεση Pixie Dust αποκτά το PIN και τον κωδικό πρόσβασης σε δευτερόλεπτα, αλλά μερικά σημεία πρόσβασης δεν επηρεάζονται"
	arr["ITALIAN",342]="L'attacco Pixie Dust ottiene il PIN e la password in pochi secondi, ma non tutti i punti di accesso sono vulnerabili a questo attacco"
	arr["POLISH",342]="Atak Pixie Dust pobiera PIN i klucz sieci w kilka sekund, ale nie wszystkie punkty dostępu są na niego podatne"
	arr["GERMAN",342]="Der Pixie Dust Angriff erhält die PIN und den Schlüssel in Sekundenschnelle, aber nicht alle Access Points sind für diesen Angriff anfällig"
	arr["TURKISH",342]="Pixie Dust saldırısı saniyeler içinde PIN ve şifre alır, ancak tüm erişim noktaları etkilenmez"
	arr["ARABIC",342]="وكلمة مرور في ثوانٍ ، ولكن ليس كل نقاط الوصول عرضة لهذا الهجوم PIN على رمز Pixie Dust يحصل هجوم"
	arr["CHINESE",342]="Pixie Dust 攻击可在数秒内获取 PIN 和密码，但并非所有的 AP 都会受影响"

	arr["ENGLISH",343]="In order to success on any WPS based attack, you need good signal of target network. We might otherwise get false negatives"
	arr["SPANISH",343]="Para realizar cualquier ataque WPS es necesario tener una buena señal de la red objetivo. Si no, podríamos obtener falsos negativos"
	arr["FRENCH",343]="Il faut être dans de bonnes conditions d'émission et de réception pour pouvoir mener à bien une attaque WPS. Sinon l'attaque pourrait se solder par un faux négatif"
	arr["CATALAN",343]="Per realitzar qualsevol atac WPS cal tenir un bon senyal de la xarxa objectiu. Si no, podríem obtenir falsos negatius"
	arr["PORTUGUESE",343]="Para executar qualquer ataque WPS você precisa ter um bom sinal da rede alvo. Caso contrario você pode obter falsos negativos"
	arr["RUSSIAN",343]="Чтобы добиться успеха в WPS атаке, вам необходимо иметь хороший сигнал с целевой сетью. В противном случае могут быть ложные срабатывания"
	arr["GREEK",343]="Για να εκτελεστεί επιτυχώς οποιαδήποτε επίθεση WPS, θα πρέπει να υπάρχει ισχυρό σήμα του δικτύου στόχου. Αλλιώς μπορεί να υπάρξουν ψευδώς αρνητικά αποτελέσματα"
	arr["ITALIAN",343]="Per qualsiasi attacco WPS è necessario avere un buon segnale della rete obiettivo. Altrimenti potremmo ottenere falsi negativi"
	arr["POLISH",343]="Aby wykonać dowolny atak WPS, trzeba mieć dobry sygnał z sieci docelowej. Jeśli nie, możemy błędnie stwierdzić ze AP jest odporny"
	arr["GERMAN",343]="Um einen WPS-Angriff auszuführen, ist ein gutes Signal vom Zielnetzwerk erforderlich. Wenn nicht, könnten wir falsche Negative bekommen"
	arr["TURKISH",343]="Herhangi bir WPS tabanlı saldırıda başarılı olmak için, iyi bir hedef ağ sinyaline ihtiyacınız vardır. Aksi halde yanlış negatifler alabiliriz"
	arr["ARABIC",343]="فأنت بحاجة إلى إشارة جيدة للشبكة المستهدفة. وإلا فقد نحصل على سلبيات كاذبة ،WPS من أجل النجاح في أي هجوم يعتمد على"
	arr["CHINESE",343]="为了在 WPS 攻击上取得成功，您需要目标网络的良好信号。否则可能会得到假的反馈信息"

	arr["ENGLISH",344]="Some access points can be blocked after failing some PIN connection attempts. It may vary depending on the access point"
	arr["SPANISH",344]="Algunos puntos de acceso se bloquean tras fallar cierto número de intentos de conexión por PIN. Puede variar dependiendo del punto de acceso"
	arr["FRENCH",344]="Certains routeurs bloquent le WPS après un certain nombre de PIN erronés. Ce nombre varie selon les modèle"
	arr["CATALAN",344]="Alguns punts d'accés es bloquejan després de fallar un cert nombre d'intents de connexió per PIN. Pot variar depenent del punt d'accés"
	arr["PORTUGUESE",344]="Alguns pontos de acesso podem estar bloqueados depois de receber uma série de tentativas incorretas de conexão por PIN. Isso pode variar dependendo do ponto de acesso"
	arr["RUSSIAN",344]="Некоторые точки доступа блокируются после нескольких неудачных попыток подключения с PIN-кодом. Зависит от конкретной точки доступа"
	arr["GREEK",344]="Μερικά σημεία πρόσβασης μπορεί να μπλοκαριστούν μετά από μερικές αποτυχημένες προσπάθειες σύνδεσης PIN. Μπορεί να διαφέρει ανάλογα με το σημείο πρόσβασης"
	arr["ITALIAN",344]="Alcuni punti di accesso si bloccano dopo un certo numero di tentativi di connessione con PIN. Può variare a seconda del punto di accesso"
	arr["POLISH",344]="Niektóre punkty dostępu są blokowane po pewnej liczbie prób PIN. Liczba ta może się różnić w zależności od punktu dostępu"
	arr["GERMAN",344]="Einige APs sind blockiert, nachdem einige Versuche zur PIN-Verbindung fehlgeschlagen sind. Dies kann abhängig vom Zugriffspunkt variieren"
	arr["TURKISH",344]="Bazı erişim noktaları, bazı PIN bağlantı girişimleri başarısız olduktan sonra engellenebilir. Erişim noktasına bağlı olarak değişebilir"
	arr["ARABIC",344]="قد يختلف حسب نقطة الوصول .PIN يمكن حظر بعض نقاط الوصول بعد فشل بعض محاولات توصيل"
	arr["CHINESE",344]="在尝试某些 PIN 连接失败后，接入行为可能会被阻止。因 AP 而异"

	arr["ENGLISH",345]="5.  (bully) Custom PIN association"
	arr["SPANISH",345]="5.  (bully) Asociación con PIN personalizado"
	arr["FRENCH",345]="5.  (bully) Association avec PIN personnalisé"
	arr["CATALAN",345]="5.  (bully) Associació amb PIN personalitzat"
	arr["PORTUGUESE",345]="5.  (bully) Associação com um PIN personalizado"
	arr["RUSSIAN",345]="5.  (bully) Подключение с известным PIN-кодом для раскрытия пароля сети"
	arr["GREEK",345]="5.  (bully) Σύνδεση με εξατομικευμένο PIN"
	arr["ITALIAN",345]="5.  (bully) Associazione con PIN personalizzato"
	arr["POLISH",345]="5.  (bully) Asocjacja z niestandardowym kodem PIN"
	arr["GERMAN",345]="5.  (bully) Assoziation mit personalisierter PIN"
	arr["TURKISH",345]="5.  (bully) Özel PIN ilişkilendirmesi"
	arr["ARABIC",345]="5.  PIN الارتباط مع (bully)"
	arr["CHINESE",345]="5.  (bully) 自定义PIN关联"

	arr["ENGLISH",346]="7.  (bully) Pixie Dust attack"
	arr["SPANISH",346]="7.  (bully) Ataque Pixie Dust"
	arr["FRENCH",346]="7.  (bully) Attaque Pixie Dust"
	arr["CATALAN",346]="7.  (bully) Atac Pixie Dust"
	arr["PORTUGUESE",346]="7.  (bully) Ataque Pixie Dust"
	arr["RUSSIAN",346]="7.  (bully) Атака Pixie Dust"
	arr["GREEK",346]="7.  (bully) Επίθεση Pixie Dust"
	arr["ITALIAN",346]="7.  (bully) Attacco Pixie Dust"
	arr["POLISH",346]="7.  (bully) Atak Pixie Dust"
	arr["GERMAN",346]="7.  (bully) Pixie Dust Angriff"
	arr["TURKISH",346]="7.  (bully) Pixie Dust saldırısı"
	arr["ARABIC",346]="7.  Pixie Dust هجوم (bully)"
	arr["CHINESE",346]="7.  (bully) Pixie Dust 攻击"

	arr["ENGLISH",347]="9.  (bully) Bruteforce PIN attack"
	arr["SPANISH",347]="9.  (bully) Ataque de fuerza bruta por PIN"
	arr["FRENCH",347]="9.  (bully) Attaque brute force PIN"
	arr["CATALAN",347]="9.  (bully) Atac de força bruta per PIN"
	arr["PORTUGUESE",347]="9.  (bully) Ataque de força bruta por PIN"
	arr["RUSSIAN",347]="9.  (bully) Атака с полным перебором PIN-кода"
	arr["GREEK",347]="9.  (bully) Επίθεση PIN με χρήση ωμής βίας"
	arr["ITALIAN",347]="9.  (bully) Attacco forza bruta con PIN"
	arr["POLISH",347]="9.  (bully) Atak Brute Force za pomocą kodu PIN"
	arr["GERMAN",347]="9.  (bully) Brute-Force-Angriff durch PIN"
	arr["TURKISH",347]="9.  (bully) Bruteforce PIN saldırısı"
	arr["ARABIC",347]="9.  Bruteforce PIN هجوم (bully)"
	arr["CHINESE",347]="9. (bully) Bruteforce PIN 攻击"

	arr["ENGLISH",348]="11. (bully) Known PINs database based attack"
	arr["SPANISH",348]="11. (bully) Ataque basado en base de datos de PINs conocidos"
	arr["FRENCH",348]="11. (bully) Attaque en utilisant un PIN de la base de données"
	arr["CATALAN",348]="11. (bully) Atac basat en base de dades de PINs coneguts"
	arr["PORTUGUESE",348]="11. (bully) Ataque com base em um banco de dados de PINs conhecidos"
	arr["RUSSIAN",348]="11. (bully) Атака на основе базы данных известных и сгенерированных PIN-кодов"
	arr["GREEK",348]="11. (bully) Επίθεση με χρήση βάσης δεδομένων γνωστών PIN"
	arr["ITALIAN",348]="11. (bully) Attacco che utilizza una base dati di PIN"
	arr["POLISH",348]="11. (bully) Atak oparty o bazę danych znanych PINów"
	arr["GERMAN",348]="11. (bully) Angriff auf Datenbank bekannter PINs basiert"
	arr["TURKISH",348]="11. (bully) Bilinen PIN'ler veritabanı saldırısı"
	arr["ARABIC",348]="11. معروفة PINs هجوم قائم على قاعدة بيانات (bully)"
	arr["CHINESE",348]="11. (bully) 基于已知 PIN 数据库的攻击"

	arr["ENGLISH",349]="  N.         BSSID      CHANNEL  PWR    V   LOCKED  ESSID"
	arr["SPANISH",349]="  N.         BSSID        CANAL  PWR    V   LOCKED  ESSID"
	arr["FRENCH",349]="  N.         BSSID        CANAL  PWR    V   LOCKED  ESSID"
	arr["CATALAN",349]="  N.         BSSID        CANAL  PWR    V   LOCKED  ESSID"
	arr["PORTUGUESE",349]="  N.         BSSID        CANAL  PWR    V   LOCKED  ESSID"
	arr["RUSSIAN",349]="  N.         BSSID      CHANNEL  PWR    V   LOCKED  ESSID"
	arr["GREEK",349]="  N.         BSSID      CHANNEL  PWR    V   LOCKED  ESSID"
	arr["ITALIAN",349]="  N.         BSSID       CANALE  PWR    V   LOCKED  ESSID"
	arr["POLISH",349]="  N.         BSSID        KANAŁ  PWR    V   LOCKED  ESSID"
	arr["GERMAN",349]="  N.         BSSID        KANAL  PWR    V   LOCKED  ESSID"
	arr["TURKISH",349]="  N.         BSSID        KANAL  PWR    V   LOCKED  ESSID"
	arr["ARABIC",349]="  N.         BSSID      CHANNEL  PWR    V   LOCKED  ESSID"
	arr["CHINESE",349]=" 序号        BSSID        信道 信号强度 V   锁定     ESSID"

	arr["ENGLISH",350]="\${blue_color}You have selected a locked WPS network \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",350]="\${blue_color}Has seleccionado una red WPS bloqueada \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",350]="\${blue_color}Vous avez sélectionné un réseau dont le WPS est bloqué \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",350]="\${blue_color}Has seleccionat una xarxa WPS bloquejada \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",350]="\${blue_color}Você selecionou uma rede com WPS bloqueado \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",350]="\${blue_color}Вы выбрали заблокированную WPS сеть \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",350]="\${blue_color}Έχετε επιλέξει ένα κλειδωμένο WPS δίκτυο \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",350]="\${blue_color}È stata selezionata una rete WPS bloccata \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",350]="\${blue_color}Wybrano sieć z zablokowanym WPS \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",350]="\${blue_color}Sie haben ein blockiertes WPS-Netzwerk ausgewählt \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",350]="\${blue_color}Kilitli bir WPS ağı seçtiniz \${green_color}Devam etmek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",350]="\${normal_color}\${visual_choice} \${green_color}هل تريد المتابعة؟ \${blue_color}مقفلة WPS لقد اخترت شبكة\${normal_color}"
	arr["CHINESE",350]="\${blue_color}您选择了一个锁定的 WPS 网络\${green_color}您要继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",351]="WPS locked network: \${pink_color}\${wps_locked}\${normal_color}"
	arr["SPANISH",351]="Red WPS bloqueada: \${pink_color}\${wps_locked}\${normal_color}"
	arr["FRENCH",351]="Blocage du WPS: \${pink_color}\${wps_locked}\${normal_color}"
	arr["CATALAN",351]="Xarxa WPS bloquejada: \${pink_color}\${wps_locked}\${normal_color}"
	arr["PORTUGUESE",351]="Rede com WPS bloqueado: \${pink_color}\${wps_locked}\${normal_color}"
	arr["RUSSIAN",351]="Сеть с заблокированным WPS: \${pink_color}\${wps_locked}\${normal_color}"
	arr["GREEK",351]="Κλειδωμένο WPS δίκτυο: \${pink_color}\${wps_locked}\${normal_color}"
	arr["ITALIAN",351]="Rete WPS bloccata: \${pink_color}\${wps_locked}\${normal_color}"
	arr["POLISH",351]="Zablokowana sieć WPS: \${pink_color}\${wps_locked}\${normal_color}"
	arr["GERMAN",351]="Blockiertes WPS-Netzwerk: \${pink_color}\${wps_locked}\${normal_color}"
	arr["TURKISH",351]="WPS kilitli ağ: \${pink_color}\${wps_locked}\${normal_color}"
	arr["ARABIC",351]="\${pink_color}\${wps_locked}\${blue_color} :مقفلة WPS شبكة\${normal_color}"
	arr["CHINESE",351]="WPS锁定网络: \${pink_color}\${wps_locked}\${normal_color}"

	arr["ENGLISH",352]="WPS locked network: \${pink_color}None\${normal_color}"
	arr["SPANISH",352]="Red WPS bloqueada: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",352]="Blocage du WPS: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",352]="Xarxa WPS bloquejada: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",352]="Rede com WPS bloqueado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",352]="Сеть с заблокированным WPS: \${pink_color}Нет\${normal_color}"
	arr["GREEK",352]="Κλειδωμένο WPS δίκτυο: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",352]="Rete WPS bloccata: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",352]="Zablokowana sieć WPS: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",352]="Blockiertes WPS-Netzwerk: \${pink_color}Keins\${normal_color}"
	arr["TURKISH",352]="WPS kilitli ağ: \${pink_color}None\${normal_color}"
	arr["ARABIC",352]="\${pink_color}None\${blue_color} :مقفلة WPS شبكة\${normal_color}"
	arr["CHINESE",352]="WPS 锁定: \${pink_color}None\${normal_color}"

	arr["ENGLISH",353]="Checking to solve possible \"bad FCS\" problem if exists. Parameterizing..."
	arr["SPANISH",353]="Realizando una pequeña prueba para solventar el posible problema de \"bad FCS\" si existiese. Parametrizando..."
	arr["FRENCH",353]="Vérification de routine pour prévenir une éventuelle erreur de type \"bad FCS\""
	arr["CATALAN",353]="Realitzant una petita prova per solucionar el possible problema de \"bad FCS\" si existís. Parametritzant..."
	arr["PORTUGUESE",353]="Fazendo alguns testes para resolver o possível problema \"bad FCS\". Definindo parâmetro..."
	arr["RUSSIAN",353]="Проверка возможного решения проблемы \"bad FCS (контроля последовательности кадров)\" если она существует. Параметризация..."
	arr["GREEK",353]="Γίνεται έλεγχος επίλυσης πιθανού σφάλματος \"bad FCS\" αν υπάρχει. Γίνεται παραμετροποίηση..."
	arr["ITALIAN",353]="Effettuando un piccolo test per risolvere il possibile problema di \"bad FCS\" se presente. Parametrizzando..."
	arr["POLISH",353]="Przeprowadzenie małego testu, aby rozwiązać problem \"bad FCS\" jeśli istniał. Parametryzowanie..."
	arr["GERMAN",353]="Ein Test wird ausgeführt, um das mögliche Problem von \"bad FCS\" zu lösen, falls es existiert. Parametrieren..."
	arr["TURKISH",353]="Varsa olası \"bad FCS\" sorununu çözme kontrol ediliyor. Parametrelendiriliyor..."
	arr["ARABIC",353]="...تحديد المعلمات .\"bad FCS\" فحص لمنع حدوث خطأ محتمل في نوع"
	arr["CHINESE",353]="检查以解决可能存在的“坏 FCS”问题。正在进行参数化..."

	arr["ENGLISH",354]="Done! parameter set"
	arr["SPANISH",354]="Hecho! parámetro fijado"
	arr["FRENCH",354]="Paramètres définis!"
	arr["CATALAN",354]="Fet! paràmetre fixat"
	arr["PORTUGUESE",354]="Feito! parâmetro definido"
	arr["RUSSIAN",354]="Сделано! параметры заданы"
	arr["GREEK",354]="Έγινε! η παράμετρος τέθηκε"
	arr["ITALIAN",354]="Fatto! parametro impostato"
	arr["POLISH",354]="Zrobione! parametry ustawione"
	arr["GERMAN",354]="Fertig! Parameter eingestellt"
	arr["TURKISH",354]="Tamamdır! parametre ayarlandı"
	arr["ARABIC",354]="!تم تعريف المعلمات"
	arr["CHINESE",354]="参数化完毕！"

	arr["ENGLISH",355]="It seems this interface was parametrized before. It's not necessary to check again"
	arr["SPANISH",355]="Esta interfaz ya fue parametrizada anteriormente. No es necesario realizar de nuevo el chequeo"
	arr["FRENCH",355]="Cette interface a déjà été configurée: Pas besoin de vérifier de nouevau son état"
	arr["CATALAN",355]="Sembla que aquesta interfície va ser parametritzada abans. No cal verificar-ho de nou"
	arr["PORTUGUESE",355]="Esta interface já foi configurada anteriormente. Não é necessário verificar novamente"
	arr["RUSSIAN",355]="Этот интерфейс был параметризован ранее. Нет необходимости проверять снова"
	arr["GREEK",355]="Φαίνεται πως αυτή η διεπαφή παραμετροποιήθηκε προηγουμένως. Δεν είναι απαραίτητο να γίνει έλεγχος ξανά"
	arr["ITALIAN",355]="Questa interfaccia è stata configurata anteriormente. Non c'è bisogno di controllare di nuovo"
	arr["POLISH",355]="Ten interfejs został wcześniej sparametryzowany. Nie jest konieczne ponownie sprawdzenie"
	arr["GERMAN",355]="Diese Interface wurde zuvor parametriert. Es ist nicht notwendig, die Überprüfung erneut durchzuführen"
	arr["TURKISH",355]="Bu arayüz daha önce parametrize edilmiş gibi görünüyor. Tekrar kontrol etmek gerekli değil"
	arr["ARABIC",355]="تمت تهيئة هذه الواجهة بالفعل: لا داعي للتحقق من حالتها مرة أخرى"
	arr["CHINESE",355]="似乎这个接口之前被参数化了。没必要再检查"

	arr["ENGLISH",356]="Some combinations don't work well. Such as reaver and Ralink chipset cards. If your card has this chipset is recommended to use bully"
	arr["SPANISH",356]="Algunas combinaciones no funcionan bien. Como por ejemplo reaver y las tarjetas con chipset Ralink. Si tu tarjeta tiene este chipset es mejor utilizar bully"
	arr["FRENCH",356]="Il existe certains problèmes spécifiques de compatibilité. L’exemple le plus marquant est sans aucun doute celui des chipsets Ralink qui ne fonctionnent pas bien avec reaver. Il est donc conseillé d'utiliser bully avec ces chipsets"
	arr["CATALAN",356]="Algunes combinacions no funcionan bé. Com per exemple reaver i les targetes amb chipset Ralink. Si la teva targeta té aquest chipset és millor utilitzar bully"
	arr["PORTUGUESE",356]="Algumas combinações não funcionam bem. Tais como reaver e placas de rede com chipset Ralink. Se o sua placa de rede tem este chipset é melhor usar bully"
	arr["RUSSIAN",356]="Некоторые комбинации не работают нормально. К примеру reaver и карты с чипсетом Ralink. Если ваша карта имеет этот чипсет, то рекомендуется использовать bully"
	arr["GREEK",356]="Μερικοί συνδυασμοί δεν λειτουργούν καλά. Όπως για παράδειγμα το reaver με κάρτες που έχουν Ralink chipset. Αν η κάρτα σας έχει αυτό το chipset είναι προτιμότερο να χρησιμοποιήσετε το bully"
	arr["ITALIAN",356]="Alcune combinazioni non funzionano bene. Come ad esempio reaver e le schede con chipset Ralink. Se la scheda ha questo chipset è meglio usare bully"
	arr["POLISH",356]="Niektóre kombinacje nie działają dobrze. Jak na przykład reaver i karty z chipsetem Ralink. Jeśli Twoja karta ma ten chipset lepiej jest użyć bully"
	arr["GERMAN",356]="Einige Kombinationen funktionieren nicht gut. Zum Beispiel Reaver und Karten mit Ralink-Chipsatz. Wenn Ihre Karte diesen Chipsatz hat, ist es besser, bully zu benutzen"
	arr["TURKISH",356]="Bazı kombinasyonlar iyi çalışmıyor. Reaver ve Ralink chipset kartları gibi. Kartınızın bu yonga seti varsa, bully kullanmanız önerilir"
	arr["ARABIC",356]="bully إذا كانت بطاقتك تحتوي على هذه الشرائح فمن المستحسن استخدام .Ralink و reaver بعض التركيبات لا تعمل بشكل جيد. مثل بطاقات"
	arr["CHINESE",356]="有些组合效果不佳。比如 reaver 和 Ralink 芯片组的网卡。如果你的无线网卡使用这个芯片组，建议使用 bully 而不是 reaver"

	arr["ENGLISH",357]="6.  (reaver) Custom PIN association"
	arr["SPANISH",357]="6.  (reaver) Asociación con PIN personalizado"
	arr["FRENCH",357]="6.  (reaver) Association avec le code PIN personnalisé"
	arr["CATALAN",357]="6.  (reaver) Associació amb PIN personalitzat"
	arr["PORTUGUESE",357]="6.  (reaver) Associação com um PIN personalizado"
	arr["RUSSIAN",357]="6.  (reaver) Подключение с известным PIN-кодом для раскрытия пароля сети"
	arr["GREEK",357]="6.  (reaver) Σύνδεση με εξατομικευμένο PIN"
	arr["ITALIAN",357]="6.  (reaver) Associazione con PIN personalizzato"
	arr["POLISH",357]="6.  (reaver) Asocjacja z niestandardowym kodem PIN"
	arr["GERMAN",357]="6.  (reaver) Assoziation mit Custom PIN"
	arr["TURKISH",357]="6.  (reaver) Özel PIN ilişkilendirmesi"
	arr["ARABIC",357]="6.  مخصص PIN اقتران (reaver)"
	arr["CHINESE",357]="6.  (reaver) 自定义 PIN 关联 "

	arr["ENGLISH",358]="8.  (reaver) Pixie Dust attack"
	arr["SPANISH",358]="8.  (reaver) Ataque Pixie Dust"
	arr["FRENCH",358]="8.  (reaver) Attaque Pixie Dust"
	arr["CATALAN",358]="8.  (reaver) Atac Pixie Dust"
	arr["PORTUGUESE",358]="8.  (reaver) Ataque Pixie Dust"
	arr["RUSSIAN",358]="8.  (reaver) Атака Pixie Dust"
	arr["GREEK",358]="8.  (reaver) Επίθεση Pixie Dust"
	arr["ITALIAN",358]="8.  (reaver) Attacco Pixie Dust"
	arr["POLISH",358]="8.  (reaver) Atak Pixie Dust"
	arr["GERMAN",358]="8.  (reaver) Pixie Dust Angriff"
	arr["TURKISH",358]="8.  (reaver) Pixie Dust saldırısı"
	arr["ARABIC",358]="8.  Pixie Dust هجوم (reaver)"
	arr["CHINESE",358]="8.  (reaver) Pixie Dust 攻击"

	arr["ENGLISH",359]="10. (reaver) Bruteforce PIN attack"
	arr["SPANISH",359]="10. (reaver) Ataque de fuerza bruta por PIN"
	arr["FRENCH",359]="10. (reaver) Attaque de force brute PIN"
	arr["CATALAN",359]="10. (reaver) Atac de força bruta per PIN"
	arr["PORTUGUESE",359]="10. (reaver) Ataque de força bruta por PIN"
	arr["RUSSIAN",359]="10. (reaver) Атака c полным перебором PIN-кода"
	arr["GREEK",359]="10. (reaver) Επίθεση PIN με χρήση ωμής βίας"
	arr["ITALIAN",359]="10. (reaver) Attacco forza bruta con PIN"
	arr["POLISH",359]="10. (reaver) Atak Brute Force za pomocą kodu PIN"
	arr["GERMAN",359]="10. (reaver) Brute-Force-Angriff durch PIN"
	arr["TURKISH",359]="10. (reaver) Bruteforce PIN saldırısı"
	arr["ARABIC",359]="10. Bruteforce PIN هجوم (reaver)"
	arr["CHINESE",359]="10. (reaver) 暴力破解密码攻击"

	arr["ENGLISH",360]="12. (reaver) Known PINs database based attack"
	arr["SPANISH",360]="12. (reaver) Ataque basado en base de datos de PINs conocidos"
	arr["FRENCH",360]="12. (reaver) Attaque en utilisant la base de données de PIN connus"
	arr["CATALAN",360]="12. (reaver) Atac basat en base de dades de PINs coneguts"
	arr["PORTUGUESE",360]="12. (reaver) Ataque com base em um banco de dados de PINs conhecidos"
	arr["RUSSIAN",360]="12. (reaver) Атака на основе базы данных известных и сгенерированных PIN-кодов"
	arr["GREEK",360]="12. (reaver) Επίθεση με χρήση βάσης δεδομένων γνωστών PIN"
	arr["ITALIAN",360]="12. (reaver) Attacco che utilizza una base dati di PINs conosciuti"
	arr["POLISH",360]="12. (reaver) Atak oparty o bazę danych znanych PINów"
	arr["GERMAN",360]="12. (reaver) Angriff basiert auf Datenbank mit bekannte PINs"
	arr["TURKISH",360]="12. (reaver) Bilinen PIN'ler veritabanı tabanlı saldırı"
	arr["ARABIC",360]="12. معروفة PINs هجوم قائم على قاعدة بيانات (reaver)"
	arr["CHINESE",360]="12. (reaver) 基于已知 PIN 数据库的攻击"

	arr["ENGLISH",361]="WPA/WPA2/WPA3 filter enabled in scan. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",361]="Filtro WPA/WPA2/WPA3 activado en escaneo. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",361]="Le filtre WPA/WPA2/WPA3 est activé dans la scan. Une fois l'opération lancée, veuillez presser [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",361]="Filtre WPA/WPA2/WPA3 activat en escaneig. Una vegada iniciat, polsi [Ctrl+C] per detenir-ho..."
	arr["PORTUGUESE",361]="Filtro WPA/WPA2/WPA3 ativo na busca de redes wifi. Uma vez iniciado, pressione [Ctrl+C] para pará-lo..."
	arr["RUSSIAN",361]="Для сканирования включен фильтр WPA/WPA2/WPA3. После запуска, нажмите [Ctrl+C] для остановки..."
	arr["GREEK",361]="Το φίλτρο WPA/WPA2/WPA3 ενεργοποιήθηκε κατά τη σάρωση. Όταν αρχίσει, μπορείτε να το σταματήσετε πατώντας [Ctrl+C]..."
	arr["ITALIAN",361]="Filtro WPA/WPA2/WPA3 attivato nella scansione. Una volta avviata, premere [Ctrl+C] per fermarla..."
	arr["POLISH",361]="Filtr WPA/WPA2/WPA3 aktywowany podczas skanowania. Naciśnij [Ctrl+C] w trakcie trwania, aby zatrzymać..."
	arr["GERMAN",361]="WPA/WPA2/WPA3-Filter beim Scannen aktiviert. Nach dem Start, drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",361]="WPA/WPA2/WPA3 filtresi aktifleştirildi. Başladıktan sonra, durdurmak için [Ctrl+C] tuşlayınız..."
	arr["ARABIC",361]="...للإيقاف [Ctrl+C] عند البدء ، اضغط على .WPA/WPA2/WPA3 تم تفعيل مرشح"
	arr["CHINESE",361]="WPA/WPA2/WPA3 过滤器在扫描中启用。按 [Ctrl+C] 停止..."

	arr["ENGLISH",362]="Custom PIN set to \${normal_color}\${custom_pin}"
	arr["SPANISH",362]="PIN personalizado elegido \${normal_color}\${custom_pin}"
	arr["FRENCH",362]="PIN personnalisé définit \${normal_color}\${custom_pin}"
	arr["CATALAN",362]="PIN personalitzat triat \${normal_color}\${custom_pin}"
	arr["PORTUGUESE",362]="PIN personalizado escolhido \${normal_color}\${custom_pin}"
	arr["RUSSIAN",362]="Пользовательский PIN установлен на \${normal_color}\${custom_pin}"
	arr["GREEK",362]="Το εξατομικευμένο PIN τέθηκε σε \${normal_color}\${custom_pin}"
	arr["ITALIAN",362]="PIN personalizzato scelto \${normal_color}\${custom_pin}"
	arr["POLISH",362]="Wybrany PIN \${normal_color}\${custom_pin}"
	arr["GERMAN",362]="Custom PIN gewählt \${normal_color}\${custom_pin}"
	arr["TURKISH",362]="Özel PIN \${normal_color}\${custom_pin} \${blue_color}olarak ayarlandı"
	arr["ARABIC",362]="\${normal_color}\${custom_pin}\${blue_color} شخصي على PIN تم تعيين\${normal_color}"
	arr["CHINESE",362]="自定义 PIN 设置为 \${normal_color}\${custom_pin}"

	arr["ENGLISH",363]="Type custom PIN (8 digits):"
	arr["SPANISH",363]="Escribe el PIN personalizado (8 dígitos):"
	arr["FRENCH",363]="Rentrez PIN personnalisé (8 chiffres):"
	arr["CATALAN",363]="Escriu el PIN personalitzat (8 dígits):"
	arr["PORTUGUESE",363]="Digite o PIN personalizado (8 dígitos):"
	arr["RUSSIAN",363]="Введите пользовательский PIN (8 цифр):"
	arr["GREEK",363]="Πληκτρολογήστε εξατομικευμένο PIN (8 ψηφία):"
	arr["ITALIAN",363]="Inserire il PIN personalizzato (8 cifre):"
	arr["POLISH",363]="Wprowadź niestandardowy kod PIN (8 cyfr):"
	arr["GERMAN",363]="Schreiben Sie die Custom PIN (8-stellig):"
	arr["TURKISH",363]="Özel PIN (8 haneli) yazın:"
	arr["ARABIC",363]=":(شخصي (8 أرقام PIN اكتب رقم"
	arr["CHINESE",363]="输入自定义 PIN (8 位数字):"

	arr["ENGLISH",364]="BSSID set to \${normal_color}\${wps_bssid}"
	arr["SPANISH",364]="BSSID elegido \${normal_color}\${wps_bssid}"
	arr["FRENCH",364]="Le BSSID choisi est \${normal_color}\${wps_bssid}"
	arr["CATALAN",364]="El BSSID escollit \${normal_color}\${wps_bssid}"
	arr["PORTUGUESE",364]="BSSID escolhido \${normal_color}\${wps_bssid}"
	arr["RUSSIAN",364]="BSSID установлена на \${normal_color}\${wps_bssid}"
	arr["GREEK",364]="Το BSSID τέθηκε σε \${normal_color}\${wps_bssid}"
	arr["ITALIAN",364]="BSSID selezionato \${normal_color}\${wps_bssid}"
	arr["POLISH",364]="Wybrano BSSID \${normal_color}\${wps_bssid}"
	arr["GERMAN",364]="Gewählte BSSID \${normal_color}\${wps_bssid}"
	arr["TURKISH",364]="BSSID \${normal_color}\${wps_bssid} \${blue_color}olarak ayarlandı"
	arr["ARABIC",364]="\${normal_color}\${wps_bssid}\${blue_color} المختار BSSID\${normal_color}"
	arr["CHINESE",364]="BSSID 自动根据所选择的无线网设置为 \${normal_color}\${wps_bssid}"

	arr["ENGLISH",365]="Channel set to \${normal_color}\${wps_channel}"
	arr["SPANISH",365]="Canal elegido \${normal_color}\${wps_channel}"
	arr["FRENCH",365]="Le canal \${normal_color}\${wps_channel}\${blue_color} a été choisi"
	arr["CATALAN",365]="El canal \${normal_color}\${wps_channel}\${blue_color} s'ha escollit"
	arr["PORTUGUESE",365]="Canal \${normal_color}\${wps_channel}\${blue_color} selecionado"
	arr["RUSSIAN",365]="Канал установлен на \${normal_color}\${wps_channel}"
	arr["GREEK",365]="Το κανάλι \${normal_color}\${wps_channel}\${blue_color} έχει επιλεχθεί"
	arr["ITALIAN",365]="Canale selezionato \${normal_color}\${wps_channel}"
	arr["POLISH",365]="Wybrany kanał \${normal_color}\${wps_channel}"
	arr["GERMAN",365]="Ausgewählter Kanal \${normal_color}\${wps_channel}"
	arr["TURKISH",365]="Kanal \${normal_color}\${wps_channel} \${blue_color}olarak ayarlandı"
	arr["ARABIC",365]="\${normal_color}\${wps_channel}\${blue_color} القناة المختارة\${normal_color}"
	arr["CHINESE",365]="信道自动修改为 \${normal_color}\${wps_channel}"

	arr["ENGLISH",366]="No filters enabled on scan. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",366]="No hay filtros activados en el escaneo. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",366]="Aucun filtre activé dans le scan. Une fois l'opération lancée, veuillez presser [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",366]="No hi ha filtres activats en l'escaneig. Una vegada iniciat, polsi [Ctrl+C] per detenir-ho..."
	arr["PORTUGUESE",366]="Nenhum filtro ativo na busca de redes wifi. Uma vez iniciado, pressione [Ctrl+C] para pará-lo..."
	arr["RUSSIAN",366]="В сканировании не активированы фильтры. После запуска, нажмите [Ctrl+C] для остановки..."
	arr["GREEK",366]="Δεν έχουν ενεργοποιηθεί φίλτρα στη σάρωση. Όταν αρχίσει, μπορείτε να το σταματήσετε πατώντας [Ctrl+C]..."
	arr["ITALIAN",366]="Nessun filtro attivato nella scansione. Una volta avviata, premere [Ctrl+C] per fermarla..."
	arr["POLISH",366]="W skanowaniu nie zostały włączone żadne filtry. Naciśnij [Ctrl+C] w trakcie trwania, aby zatrzymać..."
	arr["GERMAN",366]="Es sind keine aktivierten Filter im Scan vorhanden. Nach dem Start, drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",366]="Taramada filtre yok. Başladıktan sonra, durdurmak için [Ctrl+C] tuşlayınız..."
	arr["ARABIC",366]="...لإيقافها [Ctrl+C] لم يتم تنشيط أي مرشح في الفحص. بمجرد بدء العملية ، يرجى الضغط على"
	arr["CHINESE",366]="扫描时未启用过滤器。按 [Ctrl+C] 停止扫描"

	arr["ENGLISH",367]="You have bully installed (v\${bully_version}), but not required version. To perform Pixie Dust integrated bully attack you must have at least version v\${minimum_bully_pixiewps_version}"
	arr["SPANISH",367]="Tienes bully instalado (v\${bully_version}), aunque no la versión requerida. Para realizar el ataque Pixie Dust integrado con bully has de tener al menos la versión v\${minimum_bully_pixiewps_version}"
	arr["FRENCH",367]="Bully est installé (v\${bully_version}) mais ce n'est pas la bonne version. Vous devez avoir au moins la version v\${minimum_bully_pixiewps_version} pour la compatibilité pixie dust"
	arr["CATALAN",367]="Tens bully instal·lat (v\${bully_version}), encara que no és la versió requerida. Per realitzar l'atac Pixie Dust integrat amb bully has de tenir almenys la versió v\${minimum_bully_pixiewps_version}"
	arr["PORTUGUESE",367]="Você tem o bully instalado (v\${bully_version}), mas não a versão necessária. Para fazer o ataque Pixie Dust com bully você precisa ter pelo menos a versão v\${minimum_bully_pixiewps_version}"
	arr["RUSSIAN",367]="У вас установлен bully (v\${bully_version}), но не та версия, которая требуется. Для выполнения интегрированной в bully атаки Pixie Dust у вас должна быть по крайне мере версия v\${minimum_bully_pixiewps_version}"
	arr["GREEK",367]="Έχετε εγκατεστημένο το bully (v\${bully_version}), αλλά όχι την απαιτούμενη έκδοση. Για να κάνετε την επίθεση Pixie Dust με ενσωματωμένο bully θα πρέπει να έχετε τουλάχιστον την έκδοση v\${minimum_bully_pixiewps_version}"
	arr["ITALIAN",367]="È stato installato bully (v\${bully_version}), ma non la versione richiesta. Per realizzare l'attacco Pixie Dust integrato con bully devi avere almeno la versione v\${minimum_bully_pixiewps_version}"
	arr["POLISH",367]="Masz zainstalowane bully (v\${bully_version}), ale nie wymaganą wersję. Aby atak Pixie Dust był zintegrowany z bully, musisz mieć co najmniej wersję v\${minimum_bully_pixiewps_version}"
	arr["GERMAN",367]="Sie haben Bully installiert (v\${bully_version}), obwohl nicht die erforderliche Version. Um den Pixie Dust Angriff mit Bully zu integrieren, müssen Sie mindestens die Version v\${minimum_bully_pixiewps_version} haben"
	arr["TURKISH",367]="Bully versiyonunuz (v\${bully_version}), ama istenilen versiyon değil. Pixie Dust entegreli bully saldırısı yapmak için en az versiyona sahip olmalısınız v\${minimum_bully_pixiewps_version}"
	arr["ARABIC",367]="v\${minimum_bully_pixiewps_version} يجب أن يكون لديك على الأقل الإصدار ،integrated bully Pixie Dust لكن ليس الإصدار المطلوب. لتنفيذ هجوم ،(v\${bully_version}) لقد قمت بتثبيت"
	arr["CHINESE",367]="您已安装 bully (v\${bully_version})，但不是必需的版本。要执行 Pixie Dust 集成欺凌攻击您必须至少具有版本 v\${minimum_bully_pixiewps_version}"

	arr["ENGLISH",368]="You have bully installed (v\${bully_version}). You meet the version requirement to perform Pixie Dust integrated bully attack (minimum version v\${minimum_bully_pixiewps_version}). Script can continue..."
	arr["SPANISH",368]="Tienes bully instalado (v\${bully_version}). Cumples con el requisito de versión para realizar el ataque Pixie Dust integrado con bully (versión mínima v\${minimum_bully_pixiewps_version}). El script puede continuar..."
	arr["FRENCH",368]="Bully est installé (v\${bully_version}). Cette version est compatible avec l'attaque pixie dust (version minimale v\${minimum_bully_pixiewps_version}). Le script peut continuer..."
	arr["CATALAN",368]="Tens bully instal·lat (v\${bully_version}). Compleixes amb el requisit de versió per realitzar l'atac Pixie Dust integrat amb bully (versió mínima v\${minimum_bully_pixiewps_version}). El script pot continuar..."
	arr["PORTUGUESE",368]="Você tem o bully instalado (v\${bully_version}). Você cumpre a exigência de versão para o ataque Pixie Dust com bully (versão mínima v\${minimum_bully_pixiewps_version}). O script pode continuar..."
	arr["RUSSIAN",368]="У вас установлен bully (v\${bully_version}). Версия удовлетворяет требованиям для проведения интегрированной в bully атаки Pixie Dust (минимальная версия v\${minimum_bully_pixiewps_version}). Скрипт может продолжить работу..."
	arr["GREEK",368]="Έχετε εγκατεστημένο το bully (v\${bully_version}). Έχετε την απαραίτητη έκδοση bully (ελάχιστη έκδοση v\${minimum_bully_pixiewps_version}), για την επίθεση Pixie Dust με ενσωματωμένο bully. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",368]="È stato installato bully (v\${bully_version}). Soddisfi il requisito della versione per realizzare l'attacco Pixie Dust integrato con bully (versione minima v\${minimum_bully_pixiewps_version}). Lo script può continuare..."
	arr["POLISH",368]="Masz zainstalowany bully (v\${bully_version}). Spełnia ona wymagania wersji, aby atak Pixie Dust był zintegrowany z bully (wersja minimalna v\${minimum_bully_pixiewps_version}). Skrypt może kontynuować..."
	arr["GERMAN",368]="Sie haben bully installiert (v\${bully_version}). Du erfüllst die Versionsvoraussetzung, um den mit dem bully integrierten Pixie Dust-Angriff auszuführen (Mindestversion v\${minimum_bully_pixiewps_version}). Das Skript kann fortfahren..."
	arr["TURKISH",368]="Bully versiyonunuz (v\${bully_version}), İstenilen versiyon karşılanıyor (minimum version v\${minimum_bully_pixiewps_version}) ve Pixie Dust entegreli bully saldırısı yapmak için yazılım devam edebilir..."
	arr["ARABIC",368]="...البرنامج يمكن أن يستمر .(v\${minimum_bully_pixiewps_version} الحد الأدنى من الإصدار) Pixie Dust integrated bully attack أنت تفي بمتطلبات الإصدار لأداء هجوم الفتوة  .(v\${bully_version}) لقد قمت بتثبيت"
	arr["CHINESE",368]="你已经安装了 bully (v\${bully_version})。您满足执行 Pixie Dust 集成欺凌攻击的版本要求 (最低版本 v\${minimum_bully_pixiewps_version}) 。脚本可以继续..."

	arr["ENGLISH",369]="To perform the Pixie Dust integrated attack with reaver or bully, you must have installed at least \${minimum_reaver_pixiewps_version} version for reaver and \${minimum_bully_pixiewps_version} for bully"
	arr["SPANISH",369]="Para realizar el ataque Pixie Dust integrado con reaver o con bully, has de tener instalada como mínimo la versión \${minimum_reaver_pixiewps_version} para reaver y \${minimum_bully_pixiewps_version} para bully"
	arr["FRENCH",369]="Les versions minimales requises de reaver et bully pour l'attaque pixie wps sont reaver \${minimum_reaver_pixiewps_version} et bully \${minimum_bully_pixiewps_version}"
	arr["CATALAN",369]="Per realitzar l'atac Pixie Dust integrat amb reaver o amb bully, has de tenir instal·lada com a mínim la versió \${minimum_reaver_pixiewps_version} per reaver i \${minimum_bully_pixiewps_version} per bully"
	arr["PORTUGUESE",369]="Para executar o ataque Pixie Dust com reaver ou bully, é necessário ter instalado pelo menos a versão \${minimum_reaver_pixiewps_version} para o reaver e \${minimum_bully_pixiewps_version} para o bully"
	arr["RUSSIAN",369]="Для выполнения интегрированной атаки Pixie Dust с reaver или bully, у вас должна быть установлена, по крайней мере, версия \${minimum_reaver_pixiewps_version} для reaver и \${minimum_bully_pixiewps_version} для bully"
	arr["GREEK",369]="Για να κάνετε την επίθεση Pixie Dust με ενσωματωμένο reaver ή bully, θα πρέπει να έχετε εγκαταστημένη τουλάχιστον την έκδοση \${minimum_reaver_pixiewps_version} για reaver και \${minimum_bully_pixiewps_version} για bully"
	arr["ITALIAN",369]="Per realizzare l'attacco Pixie Dust integrato con reaver o bully, deve essere installata almeno la versione \${minimum_reaver_pixiewps_version} per reaver e la versione \${minimum_bully_pixiewps_version} per bully"
	arr["POLISH",369]="Aby przeprowadzić zintegrowany atak Pixie Dust z użyciem reaver lub z bully, musisz mieć zainstalowaną co najmniej wersję \${minimum_reaver_pixiewps_version} reaver i \${minimum_bully_pixiewps_version} bully"
	arr["GERMAN",369]="Um den mit dem reaver oder mit bully integrierten Pixie Dust-Angriff auszuführen, müssen Sie mindestens die Reaver Version \${minimum_reaver_pixiewps_version} und die Bully Version \${minimum_bully_pixiewps_version} installiert haben"
	arr["TURKISH",369]="Reaver veya bully ile Pixie Dust entegre saldırısını gerçekleştirmek için, reaver için en az \${minimum_reaver_pixiewps_version} sürümü ve kabadayılık için \${minimum_bully_pixiewps_version} yüklemiş olmanız gerekir"
	arr["ARABIC",369]="bully ل \${minimum_bully_pixiewps_version} و reaver إصدار لـ \${minimum_reaver_pixiewps_version} أو الفتوة ، يجب أن تكون قد قمت بتثبيت ما لا يقل عن Reaver باستخدام Pixie Dust integrated لتنفيذ هجوم"
	arr["CHINESE",369]="要使用 reaver 或 bully 执行 Pixie Dust 集成攻击，您必须至少为 reaver 安装 \${minimum_reaver_pixiewps_version} 版本，为 bully 安装 \${minimum_bully_pixiewps_version}"

	arr["ENGLISH",370]="You have reaver installed (v\${reaver_version}). You meet the version requirement to perform Pixie Dust integrated reaver attack (minimum version v\${minimum_reaver_pixiewps_version}). Script can continue..."
	arr["SPANISH",370]="Tienes reaver instalado (v\${reaver_version}). Cumples con el requisito de versión para realizar el ataque Pixie Dust integrado con reaver (versión minima v\${minimum_reaver_pixiewps_version}). El script puede continuar..."
	arr["FRENCH",370]="Reaver est installé (v\${reaver_version}). Cette version est compatible avec l'attaque pixie dust (version minimale: \${minimum_reaver_pixiewps_version}). Le script peut continuer..."
	arr["CATALAN",370]="Tens reaver instal·lat (v\${reaver_version}). Compleixes amb el requisit de versió per a realitzar l'atac Pixie Dust integrat amb reaver (versió mínima v\${minimum_reaver_pixiewps_version}). El script pot continuar..."
	arr["PORTUGUESE",370]="Você tem o reaver instalado (v\${reaver_version}). Você cumpre a exigência de versão para o ataque Pixie Dust com reaver (versão mínima v\${minimum_reaver_pixiewps_version}). O script pode continuar..."
	arr["RUSSIAN",370]="У вас установлен reaver (v\${reaver_version}). Версия удовлетворяет требованиям для выполнения интегрированной в reaver атаки Pixie Dust (минимальная версия v\${minimum_reaver_pixiewps_version}). Скрипт может продолжить работу..."
	arr["GREEK",370]="Έχετε εγκατεστημένο το reaver (v\${reaver_version}). Έχετε την απαραίτητη έκδοση reaver (ελάχιστη έκδοση v\${minimum_reaver_pixiewps_version}), για την επίθεση Pixie Dust με ενσωματωμένο reaver. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",370]="È stato installato reaver (v\${reaver_version}). Soddisfi il requisito della versione per realizzare l'attacco Pixie Dust integrato con reaver (versione minima v\${minimum_reaver_pixiewps_version}). Lo script può continuare..."
	arr["POLISH",370]="Masz zainstalowany reaver (v\${reaver_version}). Spełnia on wymagania dotyczące wersji, aby wykonać atak Pixie Dust (wersja minimalna v\${minimum_reaver_pixiewps_version}). Skrypt może kontynuować..."
	arr["GERMAN",370]="Reaver ist installiert (v\${reaver_version}). Sie erfüllen die Versionsvoraussetzung, um den Pixie Dust-Angriff auszuführen, der mit Reaver integriert ist (min Version v\${minimum_reaver_pixiewps_version}). Das Skript kann fortfahren..."
	arr["TURKISH",370]="Reaver sisteminizde kurulu (v\${reaver_version}). Pixie Dust entegre reaver saldırısını gerçekleştirmek için sürüm gereksinimini karşılıyorsunuz (minimum sürüm v\${minimum_reaver_pixiewps_version}). Script devam edebilir..."
	arr["ARABIC",370]="...البرنامج يمكن أن يستمر .(v\${minimum_reaver_pixiewps_version}لحد الأدنى من الإصدار) Pixie Dust integrated reaver أنت تفي بمتطلبات الإصدار لتنفيذ هجوم .(v\${reaver_version}) لقد قمت بتثبيت"
	arr["CHINESE",370]="你已经安装了 reaver (v\${reaver_version})。您满足执行 Pixie Dust 集成掠夺者攻击的版本要求 (最低版本 v\${minimum_reaver_pixiewps_version}) 。脚本可以继续..."

	arr["ENGLISH",371]="You have reaver installed (v\${reaver_version}), but not required version. To perform Pixie Dust integrated reaver attack you must have at least version v\${minimum_reaver_pixiewps_version}"
	arr["SPANISH",371]="Tienes reaver instalado (v\${reaver_version}), aunque no la versión requerida. Para realizar el ataque Pixie Dust integrado con reaver has de tener al menos la versión v\${minimum_reaver_pixiewps_version}"
	arr["FRENCH",371]="Reaver est installé (v\${reaver_version}) mais cette version n'est pas compatible avec l'attaque pixie dust. Version minimale requise: v\${minimum_reaver_pixiewps_version}"
	arr["CATALAN",371]="Tens reaver instal·lat (v\${reaver_version}), encara que no és la versió requerida. Per realitzar l'atac Pixie Dust integrat amb reaver has de tenir almenys la versió v\${minimum_reaver_pixiewps_version}"
	arr["PORTUGUESE",371]="Você tem o reaver instalado (v\${reaver_version}), mas não a versão necessária. Para fazer o ataque Pixie Dust com reaver integrado você precisa ter pelo menos a versão v\${minimum_reaver_pixiewps_version}"
	arr["RUSSIAN",371]="У вас установлен reaver (v\${reaver_version}), но не та версия, которая требуется. Для выполнения интегрированной в reaver атаки Pixie Dust у вас должна быть по крайней мере v\${minimum_reaver_pixiewps_version}"
	arr["GREEK",371]="Έχετε εγκατεστημένο το reaver (v\${reaver_version}), αλλά όχι την απαιτούμενη έκδοση. Για να κάνετε την επίθεση Pixie Dust με ενσωματωμένο reaver θα πρέπει να έχετε τουλάχιστον την έκδοση v\${minimum_reaver_pixiewps_version}"
	arr["ITALIAN",371]="È stato installato reaver (v\${reaver_version}), ma non la versione richiesta. Per realizzare l'attacco Pixie Dust integrato con reaver devi avere almeno la versione v\${minimum_reaver_pixiewps_version}"
	arr["POLISH",371]="Masz zainstalowany reaver (v\${reaver_version}), ale nie wymaganą wersję. Aby zrealizować atak Pixie Dust zintegrowany z programem reaver musisz mieć co najmniej wersję v\${minimum_reaver_pixiewps_version}"
	arr["GERMAN",371]="Reaver ist installiert (v\${reaver_version}), jedoch nicht die erforderliche Version. Um den Pixie Dust-Angriff mit Reaver zu integrieren, müssen Sie mindestens die Version v\${minimum_reaver_pixiewps_version} haben"
	arr["TURKISH",371]="Reaver sisteminizde kurulu (v\${reaver_version}), ancak sürüm uygun değil. Pixie Dust entegre reaver saldırısını gerçekleştirmek için minimum sürüm olan \${minimum_reaver_pixiewps_version} olmalıdır"
	arr["ARABIC",371]="v\${minimum_reaver_pixiewps_version}يجب أن يكون لديك على الأقل الإصدار  ،Pixie Dust integrated reaver لكن ليس الإصدار المطلوب. لتنفيذ هجوم ،(v\${reaver_version}) لقد قمت بتثبيت"
	arr["CHINESE",371]="您已经安装了 reaver (v\${reaver_version})，但不是必需的版本。要执行 Pixie Dust 集成掠夺者攻击，您必须至少具有版本 v\${minimum_reaver_pixiewps_version}"

	arr["ENGLISH",372]="This action can't be performed without known PINs database file"
	arr["SPANISH",372]="Sin fichero de base de datos de PINs conocidos no se puede realizar esta acción"
	arr["FRENCH",372]="Sans la base donées des PINs cette action ne peut pas être exécutée"
	arr["CATALAN",372]="Sense fitxer de base de dades de PINs coneguts no es pot realitzar aquesta acció"
	arr["PORTUGUESE",372]="Esta ação não pode ser executada sem o arquivo com banco de dados de PINs conhecidos"
	arr["RUSSIAN",372]="Это действие не может быть выполнено без файла базы данных известных PIN"
	arr["GREEK",372]="Αυτή η ενέργεια δεν μπορεί να πραγματοποιηθεί χωρίς να υπάρχει το αρχείο με την βάση δεδομένων γνωστών PIN"
	arr["ITALIAN",372]="Senza il file del database dei PIN conosciuti non si puó eseguire questa azione"
	arr["POLISH",372]="Ta czynność nie może zostać zrealizowana bez bazy danych znanych kodów PIN"
	arr["GERMAN",372]="Ohne eine Datenbankdatei mit bekannten PINs kann diese Aktion nicht ausgeführt werden"
	arr["TURKISH",372]="Bu işlem bilinen PIN veritabanı dosyası olmadan gerçekleştirilemez"
	arr["ARABIC",372]="PINs لا يمكن تنفيذ هذا الإجراء بدون ملف قاعدة بيانات"
	arr["CHINESE",372]="如果没有已知的 PIN 数据库文件，则无法执行此操作"

	arr["ENGLISH",373]="The known PINs database file exists. Script can continue..."
	arr["SPANISH",373]="Existe el fichero de base de datos de PINs conocidos. El script puede continuar..."
	arr["FRENCH",373]="La base de données PIN est bien présente. Le script peut continuer..."
	arr["CATALAN",373]="S'ha trobat el fitxer de base de dades de PINs coneguts. El script pot continuar..."
	arr["PORTUGUESE",373]="Há um arquivo com banco de dados de PINs conhecidos. O script pode continuar..."
	arr["RUSSIAN",373]="Файл с базой данных известных PIN существует. Скрипт может продолжать..."
	arr["GREEK",373]="Το αρχείο με την βάση δεδομένων γνωστών PIN υπάρχει. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",373]="Esiste il file di base dati dei PINs conosciuti. Lo script può continuare..."
	arr["POLISH",373]="Znaleziono plik bazy danych znanych PIN. Skrypt może kontynuować..."
	arr["GERMAN",373]="Die Datenbankdatei mit bekannte PINs ist vorhanden. Das Skript kann fortfahren..."
	arr["TURKISH",373]="Bilinen PIN'ler veritabanı dosyası mevcut. Komut dosyası devam edebilir..."
	arr["ARABIC",373]="...البرنامج يمكن أن يستمر .PINs يوجد ملف قاعدة بيانات"
	arr["CHINESE",373]="存在已知的 PIN 数据库文件。脚本可以继续..."

	arr["ENGLISH",374]="Local PINs database file (\${known_pins_dbfile}) can't be found in the script folder. It will be attempted to download"
	arr["SPANISH",374]="No se ha podido encontrar el fichero local de la base de datos de PINs (\${known_pins_dbfile}) en la carpeta del script. Se intentará descargar"
	arr["FRENCH",374]="Base de donnée PIN (\${known_pins_dbfile}) absente du dossier contenant le script. Tentative de téléchargement"
	arr["CATALAN",374]="No s'ha pogut trobar el fitxer local de la base de dades de PINs (\${known_pins_dbfile}) a la carpeta del script. S'intentarà descarregar"
	arr["PORTUGUESE",374]="Não foi possível localizar o arquivo (\${known_pins_dbfile}) com banco de dados local na pasta do script. O script vai tentar realizar o download"
	arr["RUSSIAN",374]="Локальный файл базы данных PIN (\${known_pins_dbfile}) не найден в папке скрипта. Будет предпринята попытка загрузить его"
	arr["GREEK",374]="Το αρχείο με την βάση δεδομένων PIN (\${known_pins_dbfile}) δεν βρέθηκε στο φάκελο με το script. Θα προσπαθήσει να κατέβει"
	arr["ITALIAN",374]="Impossibile trovare il file di base dati con i PINs conosciuti (\${known_pins_dbfile}) nella cartella dello script. Cercheremo di scaricarla"
	arr["POLISH",374]="Nie znaleziono lokalnej bazy danych bazy danych kodów PIN (\${known_pins_dbfile}) w folderze skryptu. Spróbuję go pobrać"
	arr["GERMAN",374]="Die lokale Datei der PIN-Datenbank (\${known_pins_dbfile}) konnte im Skriptordner nicht gefunden werden. Versuch zum Herunterladen"
	arr["TURKISH",374]="Yerel PIN'ler veritabanı dosyası (\${known_pins_dbfile}) komut dosyası klasöründe bulunamadı. İndirilmeye çalışılacak"
	arr["ARABIC",374]="في مجلد البرنامج. ستتم محاولة تنزيله (\${known_pins_dbfile}) المحلية PINs لا يمكن العثور على ملف قاعدة بيانات "
	arr["CHINESE",374]="在脚本文件夹中找不到本地 PIN 数据库文件 (\${known_pins_dbfile})。它将尝试下载"

	arr["ENGLISH",375]="It seems you have no internet access"
	arr["SPANISH",375]="Parece que no tienes conexión a internet"
	arr["FRENCH",375]="Il semble que vous ne pouvez pas vous connecter à internet"
	arr["CATALAN",375]="Sembla que no tens connexió a internet"
	arr["PORTUGUESE",375]="Parece que você não tem acesso à internet"
	arr["RUSSIAN",375]="Судя по всему, у вас нет Интернет доступа"
	arr["GREEK",375]="Φαίνεται πως δεν έχετε πρόσβαση στο διαδίκτυο"
	arr["ITALIAN",375]="Sembra che tu non abbia connessione a internet"
	arr["POLISH",375]="Wygląda na to, że nie masz połączenia internetowego"
	arr["GERMAN",375]="Es scheint, dass Sie keine Internetverbindung haben"
	arr["TURKISH",375]="Görünüşe göre internet erişiminiz yok"
	arr["ARABIC",375]="يبدو لم يكن لديك اتصال بالإنترنت"
	arr["CHINESE",375]="您似乎无法访问互联网"

	arr["ENGLISH",376]="Local PINs database file (\${known_pins_dbfile}) was found. Anyway a check for a newer will be performed"
	arr["SPANISH",376]="Se ha encontrado un fichero local de base de datos de PINs (\${known_pins_dbfile}). No obstante se va a comprobar si existe uno más actualizado"
	arr["FRENCH",376]="Base de données PIN (\${known_pins_dbfile}) présente. Recherche d’éventuelles actualisations"
	arr["CATALAN",376]="S'ha trobat un fitxer local de base de dades de PINs (\${known_pins_dbfile}). No obstant, es comprovarà si existeix algun més actualitzat"
	arr["PORTUGUESE",376]="Um banco de dados local de PINs foi encontrado (\${known_pins_dbfile}). No entanto, será verificado se existe um mais atualizado"
	arr["RUSSIAN",376]="Локальный файл базы данных PIN (\${known_pins_dbfile}) был найден. В любом случае будет выполнена проверка на наличие новой версии"
	arr["GREEK",376]="Το αρχείο με την βάση δεδομένων PIN (\${known_pins_dbfile}) βρέθηκε. Παρ'όλα αυτά θα πραγματοποιηθεί έλεγχος για νεότερη έκδοση"
	arr["ITALIAN",376]="Trovato un file locale di base dati dei PINs (\${known_pins_dbfile}). Tuttavia sarà verificato se ne esiste uno più aggiornato"
	arr["POLISH",376]="Odnaleziono lokalny plik bazy danych PIN (\${known_pins_dbfile}). Sprawdzę jednak, czy jest bardziej aktualna wersja"
	arr["GERMAN",376]="Eine lokale Datenbankdatei mit PINs (\${known_pins_dbfile}) wurde gefunden. Es wird jedoch geprüft, ob es eine Aktualisierung gibt"
	arr["TURKISH",376]="Yerel PIN'ler veritabanı dosyası (\${known_pins_dbfile}) bulundu. Her neyse yeni bir kontrol yapılacaktır"
	arr["ARABIC",376]="موجودة. البحث عن تحديثات مفعلة (\${known_pins_dbfile}) قاعدة بيانات"
	arr["CHINESE",376]="已找到本地 PIN 数据库文件 (\${known_pins_dbfile})。执行更新检查"

	arr["ENGLISH",377]="An up-to-date PINs database file has been successfully downloaded"
	arr["SPANISH",377]="Se ha descargado con éxito un fichero de base de datos de PINs actualizado"
	arr["FRENCH",377]="La base de données a été actualisée"
	arr["CATALAN",377]="S'ha descarregat amb èxit un fitxer de base de dades de PINs actualitzat"
	arr["PORTUGUESE",377]="O banco de dados foi atualizado com sucesso"
	arr["RUSSIAN",377]="Новая версия файла базы данных PIN была успешно загружена"
	arr["GREEK",377]="Ένα ενημερωμένο αρχείο με την βάση δεδομένων PIN έχει κατέβει με επιτυχία"
	arr["ITALIAN",377]="È stato scaricato con successo un file di base dati dei PINs aggiornato"
	arr["POLISH",377]="Nowszy plik bazy danych PIN został pomyślnie pobrany"
	arr["GERMAN",377]="Eine PIN-Datenbankdatei wurde erfolgreich heruntergeladen"
	arr["TURKISH",377]="Daha bir PIN veritabanı dosyası başarıyla indirildi"
	arr["ARABIC",377]="المحدّث PINs تم بنجاح تنزيل ملف قاعدة بيانات"
	arr["CHINESE",377]="已成功下载最新的 PIN 数据库文件"

	arr["ENGLISH",378]="An error occurred while trying to download the PINs database file"
	arr["SPANISH",378]="Ocurrió un error al intentar descargar el fichero de base de datos de PINs"
	arr["FRENCH",378]="Erreur lors du téléchargement de l'actualisation de la base de données"
	arr["CATALAN",378]="S'ha produït un error en intentar descarregar el fitxer de base de dades de PINs"
	arr["PORTUGUESE",378]="Ocorreu um erro ao tentar atualizar o banco de dados"
	arr["RUSSIAN",378]="При попытке загрузить файл базы данных PIN произошла ошибка"
	arr["GREEK",378]="Παρουσιάστηκε σφάλμα στην προσπάθεια να κατέβει το αρχείο με την βάση δεδομένων PIN"
	arr["ITALIAN",378]="Si è verificato un errore durante il tentativo di scaricare i file di base dati dei PINs"
	arr["POLISH",378]="Podczas próby pobrania pliku bazy danych kodów PIN wystąpił błąd"
	arr["GERMAN",378]="Beim Versuchdes runterladens der PIN-Datenbankdatei ist ein Fehler aufgetreten"
	arr["TURKISH",378]="PINs veritabanı dosyasını indirmeye çalışırken bir hata oluştu"
	arr["ARABIC",378]="PIN حدث خطأ أثناء محاولة تنزيل ملف قاعدة بيانات"
	arr["CHINESE",378]="尝试下载 PIN 数据库文件时出错"

	arr["ENGLISH",379]="Check of the PINs database file has already been done. It will not be done again..."
	arr["SPANISH",379]="El chequeo del fichero de base de datos de PINs ya se hizo. No se realizará de nuevo..."
	arr["FRENCH",379]="La vérification de la base de données a été faite et ne sera plus relancée"
	arr["CATALAN",379]="La revisió del fitxer de base de dades de PINs ja es va fer. No es realitzarà de nou..."
	arr["PORTUGUESE",379]="Verificando os PINs do banco de dados. Isso não vai ser feito novamente..."
	arr["RUSSIAN",379]="Уже выполнена проверка файла базы данных PIN. Она не будет делаться ещё раз..."
	arr["GREEK",379]="Έχει γίνει ήδη έλεγχος του αρχείου με την βάση δεδομένων PIN. Δεν θα ξαναελεγχθεί..."
	arr["ITALIAN",379]="Il controllo del file di base dati dei PINs è già stato eseguito. Non sarà più fatto..."
	arr["POLISH",379]="Sprawdzenie pliku bazy danych PIN zostało już wykonane. To się nie powtórzy..."
	arr["GERMAN",379]="Die Überprüfung der PIN-Datenbankdatei wurde bereits durchgeführt. Es wird nicht wieder getan..."
	arr["TURKISH",379]="PIN veritabanı dosyasının kontrolü zaten yapıldı. Bir daha yapılmayacak..."
	arr["ARABIC",379]="...لن يتم ذلك مرة أخرى .PIN تم بالفعل التحقق من ملف قاعدة بيانات"
	arr["CHINESE",379]="PIN 数据库文件的检查已经完成。"

	arr["ENGLISH",380]="Do you want to try again next time you launch this attack for this session? \${normal_color}\${visual_choice}"
	arr["SPANISH",380]="¿Deseas que la próxima vez que lances este ataque en esta sesión se vuelva a intentar? \${normal_color}\${visual_choice}"
	arr["FRENCH",380]="La prochaine fois que vous relancez cette attaque pendant cette session, voulez-vous oui ou non \${visual_choice} que l'actualisation soit lancée? \${normal_color}\${visual_choice}"
	arr["CATALAN",380]="¿Vols que la propera vegada que llancis aquest atac en aquesta sessió es torni a intentar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",380]="Você quer buscar por atualizações na próxima vez que iniciar este ataque nessa sessão? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",380]="Вы хотите снова продолжить эту сессию при запуске этой атаки в следующий раз? \${normal_color}\${visual_choice}"
	arr["GREEK",380]="Θέλετε να δοκιμάσετε ξανά την επόμενη φορά που θα ξεκινήσει αυτή η επίθεση για αυτή την συνεδρία; \${normal_color}\${visual_choice}"
	arr["ITALIAN",380]="Desideri che la prossima volta che viene lanciato questo attacco in questa sessione si tenti di nuovo? \${normal_color}\${visual_choice}"
	arr["POLISH",380]="Czy chcesz spróbować ponownie tego ataku dla tej sesji podczas następnego uruchomienia? \${normal_color}\${visual_choice}"
	arr["GERMAN",380]="Möchten Sie beim nächsten Start dieses Angriffs in dieser Sitzung erneut versuchen? \${normal_color}\${visual_choice}"
	arr["TURKISH",380]="Bu seans için bu saldırıyı bir daha başlattığınızda tekrar denemek ister misin? \${normal_color}\${visual_choice}"
	arr["ARABIC",380]="\${normal_color}\${visual_choice} \${green_color}هل تريد أن تجرب مرة أخرى في المرة القادمة كنت اطلاق هذا الهجوم لهذه الدورة؟\${normal_color}"
	arr["CHINESE",380]="是否要在下次针对此会话发起此攻击时重试？\${normal_color}\${visual_choice}"

	arr["ENGLISH",381]="An error occurred while trying to access to the checksum file of remote PINs database"
	arr["SPANISH",381]="Ocurrió un error al intentar acceder al fichero de checksum de la base de datos de PINs remota"
	arr["FRENCH",381]="Erreur de checksum avec la base de données PIN en ligne"
	arr["CATALAN",381]="S'ha produït un error en intentar accedir al fitxer de checksum de la base de dades de PINs remota"
	arr["PORTUGUESE",381]="Ocorreu um erro ao tentar acessar o arquivo de checksum do banco de dados remoto"
	arr["RUSSIAN",381]="Произошла ошибка при попытке получить доступ к контрольной сумме файла удаленной базы данных PIN"
	arr["GREEK",381]="Παρουσιάστηκε σφάλμα στην προσπάθεια πρόσβασης στο αρχείο checksum της απομακρυσμένης βάσης δεδομένων PIN"
	arr["ITALIAN",381]="Si è verificato un errore durante il tentativo di accedere al file di checksum della basse dati dei PINs remota"
	arr["POLISH",381]="Podczas próby uzyskania dostępu do pliku kontrolnego zdalnej bazy danych PIN wystąpił błąd"
	arr["GERMAN",381]="Beim Versuch, auf die Checksumme der Remote-PIN-Datenbank zuzugreifen, ist ein Fehler aufgetreten"
	arr["TURKISH",381]="Uzak PIN'ler veritabanının sağlama dosyasına erişmeye çalışırken bir hata oluştu"
	arr["ARABIC",381]="البعيدة PINs لقاعدة بيانات checksum حدث خطأ أثناء محاولة الوصول إلى ملف"
	arr["CHINESE",381]="尝试访问远程 PIN 数据库的校验和文件时出错"

	arr["ENGLISH",382]="Checksums of the local and remote files match. Your PINs database file is up-to-date"
	arr["SPANISH",382]="Los checksum de los ficheros local y remoto coinciden. Tu fichero de base de datos de PINs está actualizado"
	arr["FRENCH",382]="Les checksum des fichiers locaux et distants correspondent. Votre base de données des PINs est à jour"
	arr["CATALAN",382]="Els checksum dels fitxers local i remot coincideixen. El teu fitxer de base de dades de PINs està actualitzat"
	arr["PORTUGUESE",382]="As checksums locais e remotas correspondem. Seu banco de dados local está atualizado"
	arr["RUSSIAN",382]="Контрольные суммы локального и удаленного файлов совпадают. Ваш файл базы данных PIN обновляется"
	arr["GREEK",382]="Τα checksums των τοπικών και των απομακρυσμένων αρχείων ταιριάζουν. Το αρχείο με την βάση δεδομένων PIN είναι ενημερωμένο"
	arr["ITALIAN",382]="I checksum dei file locali e remoti corrispondono. Il file di base dati dei PINs è aggiornato"
	arr["POLISH",382]="Sprawdzono sumy kontrolne pliku lokalnego i zdalnego. Plik bazy danych kodów PIN jest aktualny"
	arr["GERMAN",382]="Die Checksumme der lokalen und remote-Dateien stimmen überein. Ihre PIN-Datenbankdatei ist auf dem neuesten Stand"
	arr["TURKISH",382]="Yerel ve uzak dosyaların sağlama toplamları eşleşir. PIN'leriniz veritabanı dosyanız güncel"
	arr["ARABIC",382]="الخاص بك محدث PIN للملفات المحلية والبعيدة. ملف قاعدة بيانات Checksums تطابق"
	arr["CHINESE",382]="本地和远程文件的校验和匹配。您的 PIN 数据库文件是最新的"

	arr["ENGLISH",383]="It seems there is a more up-to-date PINs database file. It will be downloaded..."
	arr["SPANISH",383]="Parece que hay un fichero de base de datos de PINs más actualizado. Será descargado..."
	arr["FRENCH",383]="Une base de données PIN plus actuelle a été détectée et va être installée. Lancement du téléchargement..."
	arr["CATALAN",383]="Sembla que hi ha un fitxer de base de dades de PINs més actualitzat. Serà descarregat..."
	arr["PORTUGUESE",383]="Parece que há um banco de dados de PINs mais recente. Ele será baixado..."
	arr["RUSSIAN",383]="Есть более новый файл базы данных PIN. Он будет загружен..."
	arr["GREEK",383]="Φαίνεται πως υπάρχει ένα νεότερο αρχείο με την βάση δεδομένων PIN. Θα κατέβει..."
	arr["ITALIAN",383]="Sembra che ci sia un file di base dati dei PINs piú aggiornato. Sarà scaricato..."
	arr["POLISH",383]="Wygląda na to, że istnieje bardziej aktualny plik bazy danych PIN. Zostanie pobrany..."
	arr["GERMAN",383]="Es scheint, dass es eine aktualisierte Datenbank von PINs gibt. Sie wird heruntergeladen..."
	arr["TURKISH",383]="Daha güncel bir PIN veritabanı dosyası var gibi görünüyor. İndirilecek..."
	arr["ARABIC",383]="...أكثر حداثة. سيتم تنزيله PINs يبدو أن هناك ملف قاعدة بيانات"
	arr["CHINESE",383]="似乎有更新的 PIN 数据库文件。它将被下载..."

	arr["ENGLISH",384]="Searching in PINs database. Please be patient..."
	arr["SPANISH",384]="Buscando en la base de datos de PINs. Por favor ten paciencia..."
	arr["FRENCH",384]="Recherche dans la base de données PIN. Ayez un peu de patience s'il vous plaît..."
	arr["CATALAN",384]="Buscant a la base de dades de PINs. Si us plau tingues paciència..."
	arr["PORTUGUESE",384]="Pesquisando os PINs no banco de dados. Por favor, seja paciente..."
	arr["RUSSIAN",384]="Поиск в базе данных PIN. Подождите немного..."
	arr["GREEK",384]="Γίνεται αναζήτηση στην βάση δεδομένων PIN. Παρακαλώ έχετε λίγη υπομονή..."
	arr["ITALIAN",384]="Cercando nella base dati dei PINs. Si prega di essere pazienti..."
	arr["POLISH",384]="Wyszukiwanie bazy danych kodu PIN. Cierpliwości..."
	arr["GERMAN",384]="PINs Datenbank wird durchgesucht. Bitte haben Sie etwas Geduld..."
	arr["TURKISH",384]="PIN veritabanında arama. Lütfen sabırlı olun..."
	arr["ARABIC",384]="...يرجى التحلي بالصبر .PIN البحث في قاعدة بيانات"
	arr["CHINESE",384]="正在 PIN 数据库中搜索。请耐心等待..."

	arr["ENGLISH",385]="Only one match found in the PINs database"
	arr["SPANISH",385]="Se ha encontrado sólo una coincidencia en la base de datos de PINs"
	arr["FRENCH",385]="Un PIN a été trouvé avec la base de données"
	arr["CATALAN",385]="S'ha trobat només una coincidència a la base de dades de PINs"
	arr["PORTUGUESE",385]="Somente um PIN correspondente no banco de dados"
	arr["RUSSIAN",385]="В базе данных PIN найдено только одно совпадение"
	arr["GREEK",385]="Μόνο ένα αντίστοιχο PIN βρέθηκε στην βάση δεδομένων"
	arr["ITALIAN",385]="Solo una corrispondenza trovata nella base dati dei PINs"
	arr["POLISH",385]="Znaleziono tylko jeden pasujący kod PIN w bazie danych"
	arr["GERMAN",385]="In der PIN-Datenbank wurde nur eine Übereinstimmung gefunden"
	arr["TURKISH",385]="PIN veritabanında sadece bir eşleşme bulundu"
	arr["ARABIC",385]="PIN تم العثور على تطابق واحد فقط في قاعدة بيانات"
	arr["CHINESE",385]="在 PIN 数据库中只找到一个匹配项"

	arr["ENGLISH",386]="\${counter_pins_found} matching PINs have been found in the PINs database"
	arr["SPANISH",386]="Se han encontrado \${counter_pins_found} PINs coincidentes en la base de datos de PINs"
	arr["FRENCH",386]="\${counter_pins_found} PIN possibles selon la base de données"
	arr["CATALAN",386]="S'han trobat \${counter_pins_found} PINs coincidents a la base de dades de PINs"
	arr["PORTUGUESE",386]="Encontrados \${counter_pins_found} PINs correspondentes no banco de dados"
	arr["RUSSIAN",386]="\${counter_pins_found} соответствующих PIN-кода были найдены в базе данных WPS PIN кодов"
	arr["GREEK",386]="\${counter_pins_found} αντίστοιχα PINs βρέθηκαν στην βάση δεδομένων"
	arr["ITALIAN",386]="Trovati \${counter_pins_found} PINs coincidenti nella base dati dei PINs"
	arr["POLISH",386]="Znaleziono \${counter_pins_found} pasujących kodów PIN w bazie danych"
	arr["GERMAN",386]="\${counter_pins_found} übereinstimmende PINs wurden in der PIN-Datenbank"
	arr["TURKISH",386]="\${counter_pins_found} PIN'lerde eşleşen PIN'ler bulundu"
	arr["ARABIC",386]="PIN مطابقة في قاعدة بيانات PINs تم العثور على أرقام \${counter_pins_found}"
	arr["CHINESE",386]="\${counter_pins_found} 已在 PIN 数据库中找到匹配的 PIN"

	arr["ENGLISH",387]="No matches found in the PINs database"
	arr["SPANISH",387]="No se ha encontrado ninguna coincidencia en la base de datos de PINs"
	arr["FRENCH",387]="Aucun PIN n'a été trouvé dans la base données"
	arr["CATALAN",387]="No s'ha trobat cap coincidència a la base de dades de PINs"
	arr["PORTUGUESE",387]="Nenhuma correspondência encontrada no banco de dados"
	arr["RUSSIAN",387]="В базе данных PIN не найдено совпадений"
	arr["GREEK",387]="Δε βρέθηκε αντίστοιχο PIN στην βάση δεδομένων"
	arr["ITALIAN",387]="Nessuna corrispondenza trovata nella base dati dei PINs"
	arr["POLISH",387]="Brak dopasowania w bazie danych kodów PIN"
	arr["GERMAN",387]="Keine Übereinstimmungen in der PIN-Datenbank gefunden"
	arr["TURKISH",387]="PINs veritabanında eşleşme bulunamadı"
	arr["ARABIC",387]="PIN لم يتم العثور على مطابقات في قاعدة بيانات"
	arr["CHINESE",387]="在 PIN 数据库中找不到匹配项"

	arr["ENGLISH",388]="Calculating and adding possible PINs using common known algorithms (ComputePIN, EasyBox, etc.) ..."
	arr["SPANISH",388]="Calculando y añadiendo posibles PINs usando algoritmos conocidos comunes (ComputePIN, EasyBox, etc.) ..."
	arr["FRENCH",388]="Générations des PIN en appliquant les algorithmes les plus communs (ComputePIN, EasyBox, etc.) ..."
	arr["CATALAN",388]="Calculant i afegint possibles PINs usant algoritmes coneguts comuns (ComputePIN, EasyBox, etc.) ..."
	arr["PORTUGUESE",388]="Calculando e adicionando possíveis PINs usando algoritmos comuns conhecidos (ComputePIN, EasyBox, etc.) ..."
	arr["RUSSIAN",388]="Вычисление и добавление возможных PIN с использованием общеизвестных алгоритмов (ComputePIN, EasyBox, etc.) ..."
	arr["GREEK",388]="Γίνεται υπολογισμός πιθανών PINs και πρόσθεση αυτών κάνοντας χρήση κοινών γνωστών αλγορίθμων (ComputePIN, EasyBox, etc.) ..."
	arr["ITALIAN",388]="Calcolando e aggiungendo possibili PINs utilizzando noti algoritmi conosciuti (ComputePIN, EasyBox, etc.) ..."
	arr["POLISH",388]="Obliczanie i dodawanie możliwych kodów PIN przy użyciu powszechnie znanych algorytmów (ComputePIN, EasyBox, itd.) ..."
	arr["GERMAN",388]="Berechnung und Hinzufügen von möglichen PINs mit bekannten Algorithmen (ComputePIN, EasyBox, etc.) ..."
	arr["TURKISH",388]="Bilinen bilinen algoritmaları (ComputePIN, EasyBox, vb.) Kullanarak olası PIN'leri hesaplamak ve eklemek ..."
	arr["ARABIC",388]="...(وما إلى ذلك EasyBoxو ComputePIN) المحتملة باستخدام الخوارزميات المعروفة الشائعة PIN حساب وإضافة أرقام"
	arr["CHINESE",388]="正在使用常见的已知算法 (ComputePIN、EasyBox 等) 计算和添加可能的 PIN ..."

	arr["ENGLISH",389]="PINs calculated by algorithms have been added. The attack will be launched with a total of \${counter_pins_found} PINs"
	arr["SPANISH",389]="Se han añadido PINs calculados por los algoritmos. El ataque se lanzará con un total de \${counter_pins_found} PINs"
	arr["FRENCH",389]="Ajout des PIN calculées au moyen des algorithmes. L'attaque se fera avec \${counter_pins_found} PIN"
	arr["CATALAN",389]="S'han afegit PINs calculats pels algoritmes. L'atac es llançarà amb un total de \${counter_pins_found} PINs"
	arr["PORTUGUESE",389]="Os PINs calculados com algoritmos foram adicionados. O ataque será iniciado com um total de \${counter_pins_found} PINs"
	arr["RUSSIAN",389]="Добавлены PIN, рассчитанные с помощью алгоритмов. Атака будет произведена в общей сложности по \${counter_pins_found} PIN"
	arr["GREEK",389]="Προστέθηκαν τα PINs που υπολογίστηκαν από τους αλγορίθμους. Η επίθεση θα ξεκινήσει με \${counter_pins_found} PINs συνολικά"
	arr["ITALIAN",389]="Sono stati aggiunti PINs calcolati dagli algoritmi. L'attacco sará lanciato con un totale di \${counter_pins_found} PINs"
	arr["POLISH",389]="Kody PIN obliczone pzez algorytmy zostały dodane. Atak zostanie uruchomiony w sumie dla \${counter_pins_found} kodów PIN"
	arr["GERMAN",389]="Die von den Algorithmen berechneten PINs wurden hinzugefügt. Der Angriff wird mit insgesamt \${counter_pins_found} PINs gestartet"
	arr["TURKISH",389]="Algoritmalar tarafından hesaplanan PIN'ler eklendi. Saldırı toplam \${counter_pins_found} PIN ile başlatılacak"
	arr["ARABIC",389]="PINs \${counter_pins_found} تم إضافة أرقام التعريف الشخصية المحسوبة بواسطة الخوارزميات. سيتم إطلاق الهجوم بإجمالي"
	arr["CHINESE",389]="添加了通过算法计算的 PIN。攻击将以总共 \${counter_pins_found} 个 PIN 发起"

	arr["ENGLISH",390]="Some access points have only PBC (Push Button Connect) enabled and you can't connect via WPS if you don't press the physical button on the device"
	arr["SPANISH",390]="Algunos puntos de acceso tienen activado solamente PBC (Push Button Connect) y no podrás conectar por WPS si no se pulsa el boton físico del mismo"
	arr["FRENCH",390]="Certains points d'accès n'ont que le WPS PBC (Push Button Connect) activé et vous ne pourrez pas vous connecter par WPS sans presser le bouton du routeur"
	arr["CATALAN",390]="Alguns punts d'accés tenen activat només PBC (Push Button Connect) i no podràs connectar per WPS si no es prem el botó físic d'aquest"
	arr["PORTUGUESE",390]="Alguns pontos de acesso têm ativo somente o PBC (Push Button Connect) em que você não pode se conectar via WPS se o botão físico não for pressionado"
	arr["RUSSIAN",390]="На некоторых точках доступа включено только PBC (Push Button Connect), т.е. подключение по нажатой кнопке, и вы не можете подключиться через WPS, если вы не нажмете на физическую кнопку устройства"
	arr["GREEK",390]="Μερικά σημεία πρόσβασης έχουν PBC (Push Button Connect) και δεν μπορείτε να συνδεθείτε μέσω WPS αν δεν πατήσετε το κουμπί αυτό στη συσκευή"
	arr["ITALIAN",390]="Alcuni punti di accesso hanno solo PBC (Push Button Connect) attivato e non è possibile connettersi tramite WPS se non viene premuto il pulsante fisico"
	arr["POLISH",390]="Niektóre punkty dostępu mają włączoną funkcję PBC (Push Button Connect) i nie można połączyć się za pośrednictwem WPS, jeśli nie naciśniesz fizycznego przycisku"
	arr["GERMAN",390]="Bei einigen Access Points ist nur PBC (Push Button Connect) aktiviert, und Sie können keine Verbindung über WPS herstellen, wenn Sie nicht die physische Taste drücken"
	arr["TURKISH",390]="Bazı erişim noktalarının yalnızca PBC (Push Button Connect) özelliği vardır ve cihazdaki fiziksel tuşa basmazsanız WPS ile bağlanamazsınız"
	arr["ARABIC",390]="إذا لم تضغط على الزر الفعلي بالجهاز WPSممكّنة ولا يمكنك الاتصال عبر PBC (Push Button Connect) بعض نقاط الوصول لديها فقط"
	arr["CHINESE",390]="某些 AP 仅启用了 PBC (按钮连接)，如果不按下设备上的物理按钮，则无法通过 WPS 进行连接"

	arr["ENGLISH",391]="Timeout set to \${normal_color}\${timeout}\${blue_color} seconds"
	arr["SPANISH",391]="Timeout elegido \${normal_color}\${timeout}\${blue_color} segundos"
	arr["FRENCH",391]="Paramétrage du timeout \${normal_color}\${timeout}\${blue_color} secondes"
	arr["CATALAN",391]="Temps d'espera triat \${normal_color}\${timeout}\${blue_color} segons"
	arr["PORTUGUESE",391]="Timeout definido para \${normal_color}\${timeout}\${blue_color} segundos"
	arr["RUSSIAN",391]="Тайм-аут установлен на \${normal_color}\${timeout}\${blue_color} секунд"
	arr["GREEK",391]="Το timeout τέθηκε στα \${normal_color}\${timeout}\${blue_color} δευτερόλεπτα"
	arr["ITALIAN",391]="Timeout scelto \${normal_color}\${timeout}\${blue_color} secondi"
	arr["POLISH",391]="Wybrany limit czasu \${normal_color}\${timeout}\${blue_color} sekund"
	arr["GERMAN",391]="Ausgewähltes Timeout \${normal_color}\${timeout}\${blue_color} Sekunden"
	arr["TURKISH",391]="Zaman aşımı \${normal_color}\${timeout}\${blue_color} saniye olarak ayarlandı"
	arr["ARABIC",391]="ثانية \${normal_color}\${timeout}\${blue_color} تم ضبط المهلة على"
	arr["CHINESE",391]="设置超时为 \${normal_color}\${timeout}\${blue_color} 秒"

	arr["ENGLISH",392]="airgeddon detected you already have set up the country code for 5Ghz band \"\${normal_color}\${country_code}\${blue_color}\". Anyway, the 5Ghz band has several channels that may not be available for operation due to country restrictions (DFS channels). If the target network uses one of these channels, the attack may not be successful"
	arr["SPANISH",392]="airgeddon detectó que ya tienes configurado el código de país para la banda de los 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". De todos modos, la banda de los 5Ghz tiene varios canales no disponibles para operar debido a las restricciones del país (canales DFS). Si la red de destino utiliza uno de estos canales, es posible que el ataque no tenga éxito"
	arr["FRENCH",392]="airgeddon a détecté que vous avez déjà configuré le code du pays pour la bande 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". De toutes façons, la bande 5Ghz a plusieurs canaux qui peuvent ne pas être disponibles pour le fonctionnement en raison des restrictions nationales (canaux DFS). Si le réseau utilise l'un de ces canaux, l'attaque peut échouer"
	arr["CATALAN",392]="airgeddon ha detectat que ja heu configurat el codi de país per a la banda de 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". De totes maneres, la banda de 5Ghz té diversos canals que poden no estar disponibles per funcionar a causa de les restriccions del país (canals DFS). Si la xarxa objectiu utilitza un d'aquests canals, és possible que l'atac no tingui èxit"
	arr["PORTUGUESE",392]="airgeddon detectou que você já configurou o código do país para a banda de 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". Ainda sim, a banda 5Ghz possui vários canais que podem não estar disponíveis para operação devido a restrições do país (canais DFS). Se a rede de destino usar um desses canais, o ataque pode não ser bem-sucedido"
	arr["RUSSIAN",392]="airgeddon обнаружил, что для диапазона 5Ghz уже установлен код страны \"\${normal_color}\${country_code}\${blue_color}\". Также атака может быть неудачной из-за того, что в диапазоне 5Ghz есть несколько каналов, которые могут быть недоступны для работы из-за региональных ограничений (DFS каналы)"
	arr["GREEK",392]="Το airgeddon εντόπισε ότι έχετε ήδη ρυθμίσει τον κωδικό χώρας για τη ζώνη 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". Τέλος πάντων, η ζώνη των 5Ghz έχει αρκετά κανάλια που ενδέχεται να μην είναι διαθέσιμα για λειτουργία λόγω περιορισμών χώρας (κανάλια DFS). Εάν το δίκτυο-στόχος χρησιμοποιεί ένα από αυτά τα κανάλια, η επίθεση ενδέχεται να μην είναι επιτυχής"
	arr["ITALIAN",392]="airgeddon ha rilevato che hai già impostato il codice del paese per la banda 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". Ad ogni modo, la banda 5 Ghz ha diversi canali che potrebbero non essere disponibili per operare a causa di restrizioni nazionali (canali DFS). Se la rete obiettivo utilizza uno di questi canali, l'attacco potrebbe non avere successo"
	arr["POLISH",392]="airgeddon wykrył, że masz już ustawiony kod kraju dla pasma 5Ghz \"\${normal_color}\${country_code}\${blue_color}\". W każdym razie pasmo 5Ghz ma kilka kanałów, które mogą nie być dostępne do pracy ze względu na ograniczenia krajowe (kanały DFS). Jeśli sieć docelowa korzysta z jednego z tych kanałów, atak może się nie powieść"
	arr["GERMAN",392]="airgeddon hat festgestellt, dass Sie bereits den Ländercode für das 5Ghz-Band \"\${normal_color}\${country_code}\${blue_color}\" eingerichtet haben. Wie auch immer, das 5Ghz-Band hat mehrere Kanäle, die aufgrund von Länderbeschränkungen möglicherweise nicht für den Betrieb verfügbar sind (DFS-Kanäle). Wenn das Zielnetzwerk einen dieser Kanäle verwendet, ist der Angriff möglicherweise nicht erfolgreich"
	arr["TURKISH",392]="airgeddon, 5Ghz bandı \"\${normal_color}\${country_code}\${blue_color}\" için ülke kodunu zaten ayarlamış olduğunuzu algıladı. Yine de, 5Ghz bandında, ülke kısıtlamaları nedeniyle (DFS kanalları) işletilemeyen birkaç kanal vardır. Eğer hedef ağ bu kanallardan birini kullanıyorsa, saldırı başarılı olamayabilir"
 	arr["ARABIC",392]="إذا كانت الشبكة المستهدفة تستخدم إحدى هذه القنوات ، فقد لا تستطيع الهجوم عليه .(DFs) علي اي حال, يحتوي النطاق على العديد من القنوات التي قد لا تكون متاحة للتشغيل بسبب قيود البلد .\"\${normal_color}\${country_code}\${blue_color}\" 5Ghz انك قد اعددت كود البلد لنطاق ال airgeddon لقد اكتشف"
	arr["CHINESE",392]="airgeddon 检测到您已经为 5Ghz 频段设置了国家代码\"\${normal_color}\${country_code}\${blue_color}\"。无论如何，5Ghz 频段有几个频道可能由于国家限制 DFS 频道 (雷达保留频道) 而无法使用。如果目标网络使用这些渠道之一，则攻击可能不会成功"

	arr["ENGLISH",393]="Type value in seconds (\${min_max_timeout}) for timeout or press [Enter] to accept the proposal [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["SPANISH",393]="Escribe un valor en segundos (\${min_max_timeout}) para el timeout o pulsa [Enter] para aceptar el valor propuesto [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["FRENCH",393]="Entrez un intervalle de temps en secondes (\${min_max_timeout}) pour le timeout ou appuyez sur [Enter] pour valider la valeur proposée [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["CATALAN",393]="Escriu un valor en segons (\${min_max_timeout}) per al temps d'espera o prem [Enter] per acceptar el valor proposat [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["PORTUGUESE",393]="Insira um valor em segundos (\${min_max_timeout}) para o timeout ou pressione [Enter] para aceitar o valor padrão [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["RUSSIAN",393]="Введите значение в секундах (\${min_max_timeout}) для тайм-аута или нажмите [Enter], чтобы оставить по умолчанию [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["GREEK",393]="Εισάγετε μια τιμή σε δευτερόλεπτα (\${min_max_timeout}) για το timeout ή πατήστε [Enter] για να τεθεί η προεπιλεγμένη τιμή [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["ITALIAN",393]="Scrivi un valore in secondi (\${min_max_timeout}) per il timeout o premi [Enter] per accettare il valore proposto [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["POLISH",393]="Wprowadź wartość w sekundach (\${min_max_timeout}) dla limitu czasu lub naciśnij klawisz [Enter], aby zaakceptować proponowaną wartość [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["GERMAN",393]="Geben Sie einen Wert in Sekunden (\${min_max_timeout}) für die Zeitüberschreitung ein oder drücken Sie [Enter], um den vorgeschlagenen Wert zu übernehmen [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["TURKISH",393]="Zaman aşımı için saniye cinsinden değeri (\${min_max_timeout}) yazın veya teklifi kabul etmek için [Enter] tuşuna basın [\${normal_color}\${timeout_shown}\${green_color}]:"
	arr["ARABIC",393]="[\${normal_color}\${timeout_shown}\${green_color}] :لقبول الاقتراح  [Enter] للمهلة أو اضغط على (\${min_max_timeout}) اكتب القيمة بالثواني"
	arr["CHINESE",393]="输入以秒为单位的超时值 (\${min_max_timeout}) 或按 [Enter] 接受建议 [\${normal_color}\${timeout_shown}\${green_color}]:"

	arr["ENGLISH",394]="You have selected a 5Ghz target network and the \"DoS pursuit mode\", but the second interface needed to perform the attack doesn't support the 5Ghz band or it is disabled, so the attack can't be performed"
	arr["SPANISH",394]="Has seleccionado una red objetivo de 5Ghz y el \"modo persecución DoS\", pero el segundo interfaz necesario para llevar a cabo el ataque no soporta la banda de los 5Ghz o está desactivado, por lo que este no se puede realizar"
	arr["FRENCH",394]="Vous avez sélectionné un réseau de 5Ghz et le \"mode de poursuite DoS\", mais la deuxième interface nécessaire pour effectuer l'attaque ne supporte pas la bande 5Ghz ou est désactivée, donc elle ne peut pas être effectuée"
	arr["CATALAN",394]="Has seleccionat una xarxa objectiu de 5Ghz i el \"mode persecució DoS\", però el segon interfície necessari per dur a terme l'atac no suporta la banda dels 5Ghz o està desactivat, pel que aquest no es pot realitzar"
	arr["PORTUGUESE",394]="Você selecionou uma rede de 5Ghz e DoS com o \"modo de perseguição\", mas a segunda interface necessária para realizar o ataque não suporta a banda de 5Ghz ou foi desativada. O ataque não pode ser realizado"
	arr["RUSSIAN",394]="Вы выбрали целевую сеть на 5Ghz и \"режим преследования DoS\", но второй интерфейс, необходимый для выполнения атаки, не поддерживает частоты 5Ghz, или она отключена, поэтому атака не может быть выполнена"
	arr["GREEK",394]="Έχετε επιλέξει ένα 5Ghz δίκτυο-στόχος και το \"DoS pursuit mode\", αλλά η δεύτερη διεπαφή που απαιτείται για να εκτελέσετε την επίθεση δεν υποστηρίζει την 5Ghz ζώνη ή είναι απενεργοποιημένη, ως αποτέλεσμα η επίθεση να μην μπορεί να εκτελεστεί"
	arr["ITALIAN",394]="Hai selezionato come obbiettivo una rete di 5Ghz e il \"DoS pursuit mode\", ma la seconda interfaccia necessaria per eseguire l'attacco non supporta la banda 5Ghz o è disattivata, quindi l'attacco non puó essere eseguito"
	arr["POLISH",394]="Wybrałeś docelową sieć 5Ghz i \"tryb DoS pursuit\", ale drugi interfejs potrzebny do przeprowadzenia ataku nie obsługuje pasma 5Ghz lub jest ono wyłączone, więc nie można go wykonać"
	arr["GERMAN",394]="Sie haben ein Zielnetzwerk mit 5Ghz und den \"DoS pursuit mode\" gewählt, aber die zweite Interface, die zur Ausführung des Angriffs benötigt wird, unterstützt das 5Ghz-Band nicht oder sie ist deaktiviert, so dass es nicht ausgeführt werden kann"
	arr["TURKISH",394]="5Ghz hedef ve \"DoS pursuit mode\" seçtiniz, ancak saldırıyı gerçekleştirmek için gereken ikinci arayüz, 5Ghz'yi bandını desteklemiyor veya devre dışı bırakılmış, bu yüzden saldırı gerçekleştirilemiyor"
	arr["ARABIC",394]="لكن الواجهة الثانية المطلوبة لتنفيذ الهجوم لا تدعم النطاق 5 جيجاهرتز أو تم تعطيلها ، لذلك لا يمكن تنفيذ الهجوم ،\"DoS pursuit mode\"لقد حددت شبكة هدف 5 جيجاهرتز و"
	arr["CHINESE",394]="您选择了5Ghz目标网络和“DoS追踪模式”，但进行攻击所需的第二个接口不支持5Ghz频段或已禁用，因此无法进行攻击"

	arr["ENGLISH",395]="Skipping intro, more window size needed"
	arr["SPANISH",395]="Saltando presentación, se necesita más tamaño de ventana"
	arr["FRENCH",395]="Pas de présentation pour manque d'espace en fenêtre"
	arr["CATALAN",395]="Saltant presentació, es necessita més grandària de finestra"
	arr["PORTUGUESE",395]="Saltando intro, uma janela maior é necessária"
	arr["RUSSIAN",395]="Пропуск заставки, требуется окно большего размера"
	arr["GREEK",395]="Το intro παρακάμπτεται, χρειάζεται μεγαλύτερο μέγεθος παραθύρου"
	arr["ITALIAN",395]="Saltando la presentazione, è necessaria una finestra piú grande"
	arr["POLISH",395]="Pomijanie prezentacji, potrzebujesz większego rozmiaru okna"
	arr["GERMAN",395]="Intro wird übersprungen, mehr Fenstergröße ist erforderlich"
	arr["TURKISH",395]="Giriş atlanıyor, daha fazla pencere boyutu gerekiyor"
	arr["ARABIC",395]="تخطي المقدمة لعدم وجود مساحة للنافذة"
	arr["CHINESE",395]="当前窗口过小，已跳过脚本介绍"

	arr["ENGLISH",396]="8.  Evil Twin AP attack with sniffing and bettercap-sslstrip2/BeEF"
	arr["SPANISH",396]="8.  Ataque Evil Twin AP con sniffing y bettercap-sslstrip2/BeEF"
	arr["FRENCH",396]="8.  Attaque Evil Twin avec capture des données et bettercap-sslstrip2/BeEF"
	arr["CATALAN",396]="8.  Atac Evil Twin AP amb sniffing i bettercap-sslstrip2/BeEF"
	arr["PORTUGUESE",396]="8.  Ataque Evil Twin AP com sniffing e bettercap-sslstrip2/BeEF"
	arr["RUSSIAN",396]="8.  Атака Злой Двойник ТД со сниффингом и bettercap-sslstrip2/BeEF"
	arr["GREEK",396]="8.  Επίθεση Evil Twin AP με sniffing και bettercap-sslstrip2/BeEF"
	arr["ITALIAN",396]="8.  Attacco Evil Twin AP con sniffing e bettercap-sslstrip2/BeEF"
	arr["POLISH",396]="8.  Atak Evil Twin AP ze sniffingiem i bettercap-sslstrip2/BeEF"
	arr["GERMAN",396]="8.  Evil Twin AP Angriff mit Sniffing und bettercap-sslstrip2/BeEF"
	arr["TURKISH",396]="8.  Sniffing ve bettercap-sslstrip2/BeEF ile Kötü İkiz AP saldırısı"
	arr["ARABIC",396]="8.  bettercap-sslstrip2/BeEF مع الشم و Evil Twin AP هجوم"
	arr["CHINESE",396]="8.  带有嗅探和 bettercap-sslstrip2/BeEF 的邪恶双胞胎双胞胎AP 攻击"

	arr["ENGLISH",397]="Evil Twin AP attack with sniffing and bettercap-sslstrip2/BeEF"
	arr["SPANISH",397]="Ataque Evil Twin AP con sniffing y bettercap-sslstrip2/BeEF"
	arr["FRENCH",397]="Attaque Evil Twin avec capture de données et bettercap-sslstrip2/BeEF"
	arr["CATALAN",397]="Atac Evil Twin AP amb sniffing i bettercap-sslstrip2/BeEF"
	arr["PORTUGUESE",397]="Ataque Evil Twin AP com sniffing e bettercap-sslstrip2/BeEF"
	arr["RUSSIAN",397]="Атака Злой Двойник ТД со сниффингом и bettercap-sslstrip2/BeEF"
	arr["GREEK",397]="Επίθεση Evil Twin AP με sniffing και bettercap-sslstrip2/BeEF"
	arr["ITALIAN",397]="Attacco Evil Twin AP con sniffing e bettercap-sslstrip2/BeEF"
	arr["POLISH",397]="Atak Evil Twin AP ze sniffingiem i bettercap-sslstrip2/BeEF"
	arr["GERMAN",397]="Evil Twin AP Angriff mit Sniffing und bettercap-sslstrip2/BeEF"
	arr["TURKISH",397]="Şeytani İkiz AP saldırısı (sniffing ile) bettercap-sslstrip2/BeEF"
	arr["ARABIC",397]="bettercap-sslstrip2/BeEF مع الشم و Evil Twin AP هجوم"
	arr["CHINESE",397]="带有嗅探和 bettercap-sslstrip2/BeEF 的邪恶双胞胎AP 攻击"

	arr["ENGLISH",398]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${default_bettercap_logpath}]"
	arr["SPANISH",398]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${default_bettercap_logpath}]"
	arr["FRENCH",398]="Entrez le chemin du fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${default_bettercap_logpath}]"
	arr["CATALAN",398]="Escriu la ruta on desarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${default_bettercap_logpath}]"
	arr["PORTUGUESE",398]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${default_bettercap_logpath}]"
	arr["RUSSIAN",398]="Напечатайте путь до файла для сохранения или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${default_bettercap_logpath}]"
	arr["GREEK",398]="Πληκτρολογήστε το μονοπάτι για να αποθηκεύσετε το αρχείο ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${default_bettercap_logpath}]"
	arr["ITALIAN",398]="Digitare il percorso dove memorizzare il file o premere [Enter] per accettare la proposta di default \${normal_color}[\${default_bettercap_logpath}]"
	arr["POLISH",398]="Wpisz ścieżkę, w której będzie zapisany plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${default_bettercap_logpath}]"
	arr["GERMAN",398]="Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die Enter-Taste, um den Standardvorschlag zu akzeptieren \${normal_color}[\${default_bettercap_logpath}]"
	arr["TURKISH",398]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${default_bettercap_logpath}]"
	arr["ARABIC",398]="\${normal_color}[\${default_bettercap_logpath}]\${green_color} لقبول الاقتراح [Enter] اكتب المسار لتخزين الملف أو اضغط على"
	arr["CHINESE",398]="请输入文件的存储路径或按 [Enter] 接受默认建议 \${normal_color}[\${default_bettercap_logpath}]"

	arr["ENGLISH",399]="Passwords captured by sniffer. File saved at \${normal_color}[\${bettercap_logpath}]"
	arr["SPANISH",399]="El sniffer ha capturado contraseñas. Fichero salvado en \${normal_color}[\${bettercap_logpath}]"
	arr["FRENCH",399]="Des mots de passe ont été capturé et ont été enregistré dans \${normal_color}[\${bettercap_logpath}]"
	arr["CATALAN",399]="El sniffer ha capturat contrasenyes. Fitxer desat a \${normal_color}[\${bettercap_logpath}]"
	arr["PORTUGUESE",399]="O sniffer capturou senhas. O arquivo foi salvo em \${normal_color}[\${bettercap_logpath}]"
	arr["RUSSIAN",399]="Сниффер захватил пароли. Файл сохранён в \${normal_color}[\${bettercap_logpath}]"
	arr["GREEK",399]="Καταγράφηκαν κωδικοί πρόσβασης από τον sniffer. Το αρχείο αποθηκεύτηκε στο \${normal_color}[\${bettercap_logpath}]"
	arr["ITALIAN",399]="Lo sniffer ha catturato passwords. File salvato in \${normal_color}[\${bettercap_logpath}]"
	arr["POLISH",399]="Sniffer przechwycił hasła. Plik zapisany w \${normal_color}[\${bettercap_logpath}]"
	arr["GERMAN",399]="Der Sniffer hat Passwörter erfasst. Datei in \${normal_color}[\${bettercap_logpath}] gespeichert"
	arr["TURKISH",399]="Parolalar sniffer tarafından yakalandı. Şuraya kaydedildi: \${normal_color}[\${bettercap_logpath}]"
	arr["ARABIC",399]="\${normal_color}[\${bettercap_logpath}]\${blue_color} تم التقاط كلمات المرور بواسطة المتشمم. تم حفظ الملف في "
	arr["CHINESE",399]="嗅探器已经捕获密码。文件保存在 \${normal_color}[\${bettercap_logpath}]"

	arr["ENGLISH",400]="On Evil Twin attack with BeEF integrated, in addition to obtaining keys using sniffing techniques, you can try to control the client's browser launching numerous attack vectors. The success of these will depend on many factors such as the kind of client's browser and its version"
	arr["SPANISH",400]="En el ataque Evil Twin con BeEF integrado, además de obtener claves con sniffing, podrás intentar controlar el navegador de los clientes lanzando numerosos vectores de ataque. El éxito de estos dependerá de muchos factores como el tipo de navegador y la versión que utilice el cliente"
	arr["FRENCH",400]="Avec l'attaque Evil Twin plus BeEF il est possible obtenir les clés en sniffant, mais pas seulement. Vous pouvez essayer de prendre le contrôle du navigateur web de la vicitme. Le succès des attaques proposées dépendra, entre autre, de la version du navigateur installé"
	arr["CATALAN",400]="En l'atac Evil Twin amb BeEF integrat, a més d'obtenir claus amb sniffing, podràs intentar controlar el navegador dels clients llançant nombrosos vectors d'atac. L'èxit d'aquests dependrà de molts factors com el tipus de navegador i la versió que utilitzi el client"
	arr["PORTUGUESE",400]="No ataque Evil Twin com BeEF integrado, além de obter senhas com sniffing, você pode tentar controlar o navegador do cliente lançando inúmeros vetores de ataque. O sucesso destes dependerá de muitos fatores, como tipo de navegador e versão utilizada pelo cliente"
	arr["RUSSIAN",400]="С атакой Злой Двойник в дополнение к получению паролей сниффингом, вы можете попробовать контролировать клиентский браузер, запуская атаки по ряду векторов. Их успех зависит от многих факторов, в том числе от типа и версии клиентского браузера"
	arr["GREEK",400]="Στην επίθεση Evil Twin με ενσωματωμένο BeEF, εκτός από την απόκτηση κλειδιών με τη χρήση τεχνικών sniffing, μπορείτε να προσπαθήσετε να ελέγξετε τον browser του χρήστη-πελάτη κάνοντας χρήση κάποιων attack vectors. Η επιτυχία αυτών θα εξαρτηθεί από πολλούς παράγοντες όπως το είδος του browser του χρήστη-πελάτη και την έκδοσή του"
	arr["ITALIAN",400]="Nell'attacco Evil Twin con BeEF integrato, oltre ad ottenere le chiavi con sniffing, si può provare a controllare il browser dei clienti lanciando numerosi vettori di attacco. Il successo di questi attacchi dipende da molti fattori, come il tipo di browser e la versione utilizzata dal cliente"
	arr["POLISH",400]="W ataku Evil Twin ze zintegrowanym BeEF, oprócz uzyskiwania kluczy sniffingiem, można spróbować kontrolować przeglądarkę klientów, uruchamiając liczne ataki. Sukces tych działań będzie zależał od wielu czynników, takich jak typ przeglądarki i wersja używana przez klienta"
	arr["GERMAN",400]="Beim Evil-Twin Angriff mit integriertem BeEF können Sie nicht nur Schlüssel mit Sniffing erhalten, sondern auch versuchen, den Browser des Clients zu steuern, indem Sie zahlreiche Angriffsvektoren starten. Der Erfolg hängt von vielen Faktoren ab, beispielsweise vom Browsertyp und der vom Client verwendeten Version"
	arr["TURKISH",400]="BeEF ile Evil Twin saldırısında entegre olarak, koklama tekniklerini kullanarak anahtar elde etmenin yanı sıra, clientin tarayıcısını çok sayıda saldırı vektörünü başlatmaya çalışmayı deneyebilirsiniz. Bunların başarısı, clientin tarayıcısının türü ve versiyonu gibi birçok faktöre bağlı olacaktır"
	arr["ARABIC",400]="بالإضافة إلى الحصول على مفاتيح باستخدام تقنيات الشم ، يمكنك محاولة التحكم في متصفح العميل باستخدام العديد من الهجومات. سيعتمد نجاح هذه على العديد من العوامل مثل نوع متصفح العميل وإصداره ،BeEF مع دمج Evil Twin في هجوم"
	arr["CHINESE",400]="在集成 BeEF 的邪恶双胞胎攻击中，除了使用嗅探技术获取密钥外，还可以尝试控制客户端浏览器发起大量攻击请求。这些的成功将取决于许多因素，例如客户端浏览器的类型及其版本"

	arr["ENGLISH",401]="The beef package you have installed is not BeEF (Browser Exploitation Framework). You have Beef (Flexible Brainfuck interpreter) installed. Both executables have the same name and can lead to confusion. Uninstall it and install what airgeddon needs if you want to use that feature. Installation guide: \${normal_color}\${beef_installation_url}"
	arr["SPANISH",401]="El paquete beef que tienes instalado no es BeEF (Browser Exploitation Framework). Tienes instalado Beef (Flexible Brainfuck interpreter). Ambos ejecutables se llaman igual y puede dar lugar a confusión. Desinstálalo e instala el que airgeddon necesita si quieres usar esa característica. Guía de instalación: \${normal_color}\${beef_installation_url}"
	arr["FRENCH",401]="Le paquet beef installé n'est pas le bon: Vous avez installé Beef (Flexible Brainfuck interpreter) et vous devez installer BeEF (Browser Exploitation Framework). Les deux ont le même nom et peut induire en erreur. Désinstallez et installez la version dont airgeddon a besoin si vous souhaitez utiliser cette fonctionnalité. Guide d'installation: \${normal_color}\${beef_installation_url}"
	arr["CATALAN",401]="El paquet beef que tens instal·lat no és BeEF (Browser Exploitation Framework). Tens instal·lat Beef (Flexible Brainfuck interpreter). Tots dos executables es diuen igual i pot donar lloc a confusió. Desinstalalo i instal·la el que airgeddon necessita si vols utilitzar aquesta característica. Guia d'instal·lació: \${normal_color}\${beef_installation_url}"
	arr["PORTUGUESE",401]="O pacote beef instalado não é o BeEF (Browser Exploitation Framework). Você instalou Beef (Flexible Brainfuck interpreter). Ambos possuem o mesmo nome e executável o que pode levar a confusão. Desinstale-o e instale o que o airgeddon precisa se você quiser usar esse recurso. Guia de Instalação: \${normal_color}\${beef_installation_url}"
	arr["RUSSIAN",401]="Установленный вами пакет beef не является пакетом BeEF (Browser Exploitation Framework). Вы установили Beef (Flexible Brainfuck interpreter). Оба исполнимых файла имеют одинаковое имя и могут вызвать путаницу. Если вы хотите использовать эту функцию, удалите его и установите тот, который требует airgeddon. Инструкция по установке: \${normal_color}\${beef_installation_url}"
	arr["GREEK",401]="Το πακέτο beef που έχετε εγκαταστημένο δεν είναι το BeEF (Browser Exploitation Framework). Έχετε εγκατεστημένο το Beef (Flexible Brainfuck interpreter). Και τα δύο εκτελέσιμα αρχεία έχουν το ίδιο όνομα και μπορεί να γίνει κάποιο μπέρδεμα. Απεγκαταστήστε το και εγκαταστήστε αυτό που χρειάζεται το airgeddon, αν θέλετε να χρησιμοποιήσετε αυτή την επιλογή. Οδηγός εγκατάστασης: \${normal_color}\${beef_installation_url}"
	arr["ITALIAN",401]="Il pacchetto beef che hai installato non è BeEF (Browser Exploitation Framework). È stato installato Beef (Flexible Brainfuck interpreter). Entrambi gli eseguibili hanno lo nome e può essere fonte di confusione. Disinstallarlo e installare quello di cui ha bisogno airgeddon se si desidera utilizzare questa funzione. Guida all'installazione: \${normal_color}\${beef_installation_url}"
	arr["POLISH",401]="Zainstalowany pakiet beef nie jest BeEF (Browser Exploitation Framework). Masz zainstalowaną Beef (Flexible Brainfuck interpreter). Obydwa pliki wykonywalne są nazywane tak samo i mogą prowadzić do zamieszania. Odinstaluj i zainstaluj system airgeddon, jeśli potrzebujesz tej funkcji. Instrukcja instalacji: \${normal_color}\${beef_installation_url}"
	arr["GERMAN",401]="Das von Ihnen installierte beef-Paket ist nicht BeEF (Browser Exploitation Framework). Sie haben Beef (Flexible Brainfuck Interpreter) installiert. Beide ausführbare Dateien werden als gleich bezeichnet und können zu Verwirrung führen. Deinstallieren Sie es und installieren Sie das, das airgeddon benötigt, wenn Sie diese Funktion verwenden möchten. Installationsanleitung: \${normal_color}\${beef_installation_url}"
	arr["TURKISH",401]="Yüklediğiniz beef paketi, BeEF (Browser Exploitation Framework) değildir. Beef (Flexible Brainfuck interpreter) kurulu. Her iki yürütücü de aynı ada sahip ve karışıklığa yol açabilir. Bu özelliği kullanmak istiyorsanız kaldırın ve hangi airgeddon'un gereksinimlerini karşılayın. Kurulum kılavuzu: \${normal_color}\${beef_installation_url}"
	arr["ARABIC",401]="\${normal_color}\${beef_installation_url}\${red_color} :إذا كنت تريد استخدام هذه الميزة. دليل التثبيت airgeddon كلا الملفين التنفيذيين لهما نفس الاسم ويمكن أن يؤديا إلى الارتباك. قم بإلغاء تثبيته وتثبيت ما يحتاجه .مثبتًا Beef (Flexible Brainfuck interpreter) لديك .(Browser Exploitation Framework) التي قمت بتثبيتها ليست BeEF حزمة\${normal_color}"
	arr["CHINESE",401]="您已安装了 beef 包 (Brainfuck 语言解释器) 但需要 BeEF (Browser Exploitation Framework 浏览器开发框架) 。这两个可执行文件具有相同的名称，可能会导致混淆。如果您想使用该功能，请卸载 Beef (Brainfuck 语言解释器) 并安装 BeEF (Browser Exploitation Framework 浏览器开发框架) 。安装指南: \${normal_color}\${beef_installation_url}"

	arr["ENGLISH",402]="Enter the absolute path of the directory where BeEF is installed:"
	arr["SPANISH",402]="Introduce la ruta absoluta del directorio donde está instalado BeEF:"
	arr["FRENCH",402]="Entrez la route absolue vers le dossier où BeEF est installé:"
	arr["CATALAN",402]="Introdueix la ruta absoluta del directori on està instal·lat BeEF:"
	arr["PORTUGUESE",402]="Digite o caminho absoluto do diretório onde BeEF está instalado:"
	arr["RUSSIAN",402]="Введите абсолютный путь к каталогу, в котором установлен BeEF:"
	arr["GREEK",402]="Εισάγετε το απόλυτο μονοπάτι για τον κατάλογο στον όποιο βρίσκεται εγκατεστημένο το BeEF:"
	arr["ITALIAN",402]="Immettere il percorso assoluto della directory in cui è installato BeEF:"
	arr["POLISH",402]="Wprowadż ścieżkę absolutną do instalacji BeEF:"
	arr["GERMAN",402]="Geben Sie den absoluten Pfad des Verzeichnisses ein, in dem BeEF installiert ist:"
	arr["TURKISH",402]="BeEf'in kurulu olduğu dizini tam olarak giriniz:"
	arr["ARABIC",402]=":أدخل المسار المطلق للدليل حيث تم تثبيت BeEF"
	arr["CHINESE",402]="请输入安装 BeEF 的目录的绝对路径:"

	arr["ENGLISH",403]="The directory you entered doesn't exist"
	arr["SPANISH",403]="El directorio introducido no existe"
	arr["FRENCH",403]="Le dossier indiqué n'existe pas"
	arr["CATALAN",403]="El directori introduït no existeix"
	arr["PORTUGUESE",403]="O diretório digitado não existe"
	arr["RUSSIAN",403]="Каталог, который вы ввели, не существует"
	arr["GREEK",403]="Ο κατάλογος που έχετε εισάγει δεν υπάρχει"
	arr["ITALIAN",403]="La cartella indicata non esiste"
	arr["POLISH",403]="Wprowadzony katalog nie istnieje"
	arr["GERMAN",403]="Das eingegebene Verzeichnis existiert nicht"
	arr["TURKISH",403]="Girdiğiniz dizin mevcut değil"
	arr["ARABIC",403]="الدليل أدخلته غير موجود"
	arr["CHINESE",403]="您输入的目录不存在"

	arr["ENGLISH",404]="The entered path isn't absolute. An absolute path must always begin with \"/\""
	arr["SPANISH",404]="La ruta introducida no es absoluta. Una ruta absoluta siempre debe comenzar por \"/\""
	arr["FRENCH",404]="La route saisie n'est pas absolue. Une route absolue doit toujours commencer par \"/\""
	arr["CATALAN",404]="La ruta introduïda no és absoluta. Una ruta absoluta sempre ha de començar per \"/\""
	arr["PORTUGUESE",404]="O caminho digitado não é absoluto. Um caminho absoluto deve sempre começar com \"/\""
	arr["RUSSIAN",404]="Введенный путь не является абсолютным. Абсолютный путь всегда должен начинаться с \"/\""
	arr["GREEK",404]="Το μονοπάτι που έχετε εισάγει δεν είναι απόλυτο. Ένα απόλυτο μονοπάτι πρέπει πάντα να ξεκινάει με \"/\""
	arr["ITALIAN",404]="Il percorso immesso non è assoluto. Un percorso assoluto deve sempre iniziare con \"/\""
	arr["POLISH",404]="Wprowadzona ścieżka nie jest absolutna. Ścieżka abolutna musi się zawsze zaczynać od \"/\""
	arr["GERMAN",404]="Der eingegebene Pfad ist nicht absolut. Ein absoluter Pfad sollte immer mit \"/\" beginnen"
	arr["TURKISH",404]="Girilen yol mutlak değildir. Mutlak bir yol daima \"/\" ile başlamalıdır"
	arr["ARABIC",404]="\"/\" المسار الذي تم إدخاله ليس مطلقًا. يجب أن يبدأ المسار المطلق دائمًا بـ"
	arr["CHINESE",404]="您输入的路径有误。绝对路径必须始终以 \"/\" 开头"

	arr["ENGLISH",405]="Checking BeEF..."
	arr["SPANISH",405]="Comprobando BeEF..."
	arr["FRENCH",405]="Vérification de BeEF..."
	arr["CATALAN",405]="Comprovant BeEF..."
	arr["PORTUGUESE",405]="Verificando BeEF..."
	arr["RUSSIAN",405]="Проверка BeEF..."
	arr["GREEK",405]="Γίνεται έλεγχος του BeEF..."
	arr["ITALIAN",405]="Controllando BeEF..."
	arr["POLISH",405]="Sprawdzanie BeEF..."
	arr["GERMAN",405]="BeEF wird überprüft..."
	arr["TURKISH",405]="BeEF kontrol ediliyor..."
	arr["ARABIC",405]="...BeEF جارٍ التحقق من"
	arr["CHINESE",405]="正在检查 BeEF..."

	arr["ENGLISH",406]="No BeEF executable was detected in given directory"
	arr["SPANISH",406]="No se ha detectado un ejecutable de BeEF en el directorio indicado"
	arr["FRENCH",406]="BeEF n'est pas présent dans le dossier que vous avez indiqué"
	arr["CATALAN",406]="No s'ha detectat un executable de BeEF al directori indicat"
	arr["PORTUGUESE",406]="O executável do BeEF não foi detectado no diretório especificado"
	arr["RUSSIAN",406]="Ни один исполняемый файл BeEF не был обнаружен в заданной директории"
	arr["GREEK",406]="Δεν εντοπίστηκε κάποιο εκτελέσιμο αρχείο BeEF στον κατάλογο που έχετε εισάγει"
	arr["ITALIAN",406]="Non è stato rilevato un eseguibile di BeEF nella directory specificata"
	arr["POLISH",406]="Nie znaleziono pliku wykonywalnego BeEF w danym katalogu"
	arr["GERMAN",406]="Keine BeEF-Programmdatei wurde im angegebenen Verzeichnis nicht gefunden"
	arr["TURKISH",406]="Girilen dizinde BeEF yürütülebilir bulunamadı"
	arr["ARABIC",406]="قابل للتنفيذ في دليل معين BeEF لم يتم اكتشاف"
	arr["CHINESE",406]="在给定目录中未检测到 BeEF 可执行文件"

	arr["ENGLISH",407]="BeEF preparation"
	arr["SPANISH",407]="Preparación BeEF"
	arr["FRENCH",407]="Mise en place de BeEF"
	arr["CATALAN",407]="Preparació BeEF"
	arr["PORTUGUESE",407]="Preparando BeEF"
	arr["RUSSIAN",407]="Подготовка BeEF"
	arr["GREEK",407]="Προετοιμασία του BeEF"
	arr["ITALIAN",407]="Preparando BeEF"
	arr["POLISH",407]="Przygotowanie BeEF"
	arr["GERMAN",407]="BeEF wird vorbereitet"
	arr["TURKISH",407]="BeEF hazırlanması"
	arr["ARABIC",407]="BeEFتحضير"
	arr["CHINESE",407]="BeEF 准备"

	arr["ENGLISH",408]="If you installed BeEF manually, airgeddon might not be able to find it and the attack option can appear as restricted. You can try to solve it using the special menu option to fix this. It will work only if BeEF is already correctly installed and your unique problem is the script is not detecting it"
	arr["SPANISH",408]="Si instalaste BeEF manualmente, puede que airgeddon no sea capaz de encontrarlo y la opción del ataque te aparezca restringida. Puedes intentar solucionarlo usando la opción del menú especial para ello. Esto sólo funcionará si BeEF ya está instalado correctamente y el único problema que tienes es que el script no lo detecta"
	arr["FRENCH",408]="Si BeEF a été installé manuellement, il se peut qu'airgeddon ne soit pas en mesure de le trouver. L'option dédiée ne sera pas accessible. Vous pouvez essayer de la réparer en utilisant l'option consacrée à cette tâche depuis le menu spécial. Ça ne marchera que si BeEf est correctement instalé et c'est le script qui n'est pas capable de le détecter"
	arr["CATALAN",408]="Si vas instal·lar BeEF manualment, pot ser que airgeddon no sigui capaç de trobar-lo i l'opció de l'atac t'aparegui restringida. Pots intentar solucionar usant l'opció del menú especial per a això. Això només funcionarà si BeEF ja està instal·lat correctament i l'únic problema que tens és que el script no el detecta"
	arr["PORTUGUESE",408]="Se BeEF foi instalado manualmente, o airgeddon não pode encontrá-lo automaticamente e a opção de ataque aparecerá bloqueada. Você pode tentar corrigi-lo usando a opção de menu especial para isso. Isso só vai funcionar se BeEF já está instalado corretamente e o único problema que você tem é que o script não o detecta"
	arr["RUSSIAN",408]="Если вы установили BeEF вручную, airgeddon может быть не в состоянии найти его, и опция атаки в меню может быть ограничена. Для исправления этого, вы можете попытаться решить эту проблему с помощью специального пункта меню. Это сработает только если BeEF уже правильно установлен, и ваша единственная проблема в том, что скрипт не обнаруживает его"
	arr["GREEK",408]="Εάν έχετε εγκαταστήσει χειροκίνητα το BeEF, το airgeddon μπορεί να μην μπορέσει να το βρεί και η επιλογή της επίθεσης μπορεί να φανεί σαν περιορισμένη. Μπορείτε να προσπαθήσετε να διορθώσετε το πρόβλημα κάνοντας χρήση της ειδικής επιλογής στο μενού. Θα λειτουργήσει μόνο αν το BeEF έχει ήδη εγκατασταθεί σωστά και το μόνο πρόβλημα είναι ότι το script δεν το εντοπίζει"
	arr["ITALIAN",408]="Se BeEF è stato installato manualmente, airgeddon potrebbe non essere in grado di trovarlo e l'opzione di attacco apparirà limitata. Si può cercare di risolvere il problema utilizzando l'opzione del menú specifica per questo. Questo funzionerá solo se BeEF è già installato correttamente e l'unico problema che hai è che lo script non lo rileva"
	arr["POLISH",408]="Jeśli zainstalowałeś BeEF ręcznie, airgeddon może nie być w stanie go znaleźć, a opcja atakowania będzie ograniczona. Możesz spróbować rozwiązać ten problem używając specjalnej opcji menu. To będzie działać tylko wtedy, gdy BeEF jest już poprawnie zainstalowany i jedynym problemem jest to, że skrypt go nie wykrywa"
	arr["GERMAN",408]="Wenn Sie BeEF manuell installiert haben, kann airgeddon es möglicherweise nicht finden und die Angriffsoption scheint eingeschränkt zu sein. Sie können versuchen, es mit hilfe der speziellen Menüoption dafür zu lösen. Dies funktioniert nur, wenn BeEF bereits korrekt installiert ist und das einzige Problem, das Sie haben, ist, dass das Skript es nicht erkennt"
	arr["TURKISH",408]="BeEF'i manuel olarak yüklediyseniz, airgeddon onu bulamayabilir ve saldırı seçeneği kısıtlı olarak görünebilir. Bunu düzeltmek için özel menü seçeneğini kullanarak çözmeyi deneyebilirsiniz. Sadece BeEF zaten doğru bir şekilde kurulmuşsa ve tek sorun, komut dosyasının bunu algılamaması durumunda çalışır"
	arr["ARABIC",408]="بالفعل بشكل صحيح ومشكلتك الفريدة هي أن البرنامج لا يكتشفه BeEF من العثور عليه ويمكن أن يظهر خيار الهجوم على أنه مقيد. يمكنك محاولة حلها باستخدام خيار القائمة الخاص لإصلاح ذلك. لن يعمل إلا إذا تم تثبيت airgeddon يدويًا ، فقد لا يتمكن BeEF إذا قمت بتثبيت"
	arr["CHINESE",408]="如果您已经手动安装了 BeEF，但 airgeddon 无法找到它并且导致攻击选项显示为受限时，您可以尝试使用特殊菜单选项来解决此问题。仅当 BeEF 已正确安装并且脚本未检测到它时，才会起作用"

	arr["ENGLISH",409]="1.  Evil Twin AP attack with sniffing and bettercap-sslstrip2/BeEF"
	arr["SPANISH",409]="1.  Ataque Evil Twin AP con sniffing y bettercap-sslstrip2/BeEF"
	arr["FRENCH",409]="1.  Attaque Evil Twin avec capture des données et bettercap-sslstrip2/BeEF"
	arr["CATALAN",409]="1.  Atac Evil Twin AP amb sniffing i bettercap-sslstrip2/BeEF"
	arr["PORTUGUESE",409]="1.  Ataque Evil Twin AP com sniffing e bettercap-sslstrip2/BeEF"
	arr["RUSSIAN",409]="1.  Атака Злой Двойник ТД со сниффингом и bettercap-sslstrip2/BeEF"
	arr["GREEK",409]="1.  Επίθεση Evil Twin AP με sniffing και bettercap-sslstrip2/BeEF"
	arr["ITALIAN",409]="1.  Attacco Evil Twin AP con sniffing e bettercap-sslstrip2/BeEF"
	arr["POLISH",409]="1.  Atak Evil Twin AP ze sniffingiem i bettercap-sslstrip2/BeEF"
	arr["GERMAN",409]="1.  Evil Twin AP Angriff mit Sniffing und bettercap-sslstrip2/BeEF"
	arr["TURKISH",409]="1.  Sniffing ve bettercap-sslstrip2/BeEF ile Kötü İkiz AP saldırısı"
	arr["ARABIC",409]="1.  bettercap-sslstrip2/BeEFمع الشم و Evil Twin AP هجوم"
	arr["CHINESE",409]="1.  带有嗅探和 bettercap-sslstrip2/BeEF 的邪恶双胞胎 AP 攻击"

	arr["ENGLISH",410]="2.  Try to troubleshoot manually installed BeEF dependency problem"
	arr["SPANISH",410]="2.  Intentar solucionar problema de dependencia BeEF instalado manualmente"
	arr["FRENCH",410]="2.  Essayer de résoudre les problèmes de dépendances avec BeEF installé manuellement"
	arr["CATALAN",410]="2.  Intentar solucionar problema de dependència BeEF instal·lat manualment"
	arr["PORTUGUESE",410]="2.  Tentar resolver o problema de dependência do BeEF instalado manualmente"
	arr["RUSSIAN",410]="2.  Попробуйте устранить проблему вручную установив зависимости BeEF"
	arr["GREEK",410]="2.  Προσπαθήστε να αντιμετωπίσετε το πρόβλημα με τα dependencies του χειροκίνητα εγκατεστημένου BeEF"
	arr["ITALIAN",410]="2.  Cercare di risolvere il problema delle dipende di BeEF installato manualmente"
	arr["POLISH",410]="2.  Próba rozwiązywania problemów z ręcznie zainstalowanym BeEF"
	arr["GERMAN",410]="2.  Versuche manuell installierte BeEF-Abhängigkeitsprobleme zu lösen"
	arr["TURKISH",410]="2.  El ile yüklenmiş BeEF bağımlılık sorununu gidermeye çalışın"
	arr["ARABIC",410]="2.  المثبتة يدويًا وإصلاحها BeEF حاول استكشاف مشكلة تبعية"
	arr["CHINESE",410]="2.  尝试解决手动安装的 BeEF 依赖问题"

	arr["ENGLISH",411]="WPS filter enabled in scan. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",411]="Filtro WPS activado en escaneo. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",411]="Le filtre WPS est activé dans la scan. Une fois l'opération lancée, veuillez presser [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",411]="Filtre WPS activat en escaneig. Una vegada iniciat, polsi [Ctrl+C] per detenir-ho..."
	arr["PORTUGUESE",411]="Filtro WPS ativo na busca de redes wifi. Uma vez iniciado, pressione [Ctrl+C] para pará-lo..."
	arr["RUSSIAN",411]="Для сканирования включен фильтр WPS. После запуска, нажмите [Ctrl+C] для остановки..."
	arr["GREEK",411]="Το φίλτρο WPS ενεργοποιήθηκε κατά τη σάρωση. Όταν αρχίσει, μπορείτε να το σταματήσετε πατώντας [Ctrl+C]..."
	arr["ITALIAN",411]="Filtro WPS attivato nella scansione. Una volta avviata, premere [Ctrl+C] per fermarla..."
	arr["POLISH",411]="Filtr WPS aktywowany podczas skanowania. Naciśnij [Ctrl+C] w trakcie trwania, aby zatrzymać..."
	arr["GERMAN",411]="WPS-Filter beim Scannen aktiviert. Nach dem Start, drücken Sie [Ctrl+C], um es zu stoppen..."
	arr["TURKISH",411]="WPS filtresi taramada etkinleştirildi. Başladığınızda, durdurmak için [Ctrl+C] tuşlarına basın..."
	arr["ARABIC",411]="...للإيقاف [Ctrl+C] في الفحص. عند البدء ، اضغط على WPS تم تفعيل مرشح"
	arr["CHINESE",411]="已经在扫描中启用 WPS 过滤器。扫描时，按 [Ctrl+C] 停止..."

	arr["ENGLISH",412]="You don't need to perform this action. Your BeEF is operational"
	arr["SPANISH",412]="No necesitas realizar esta acción. Tu BeEF está operativo"
	arr["FRENCH",412]="Vous n'êtes pas obligé de le faire. BeEF est opérationnel"
	arr["CATALAN",412]="No necessites realitzar aquesta acció. El teu BeEF està operatiu"
	arr["PORTUGUESE",412]="Você não precisa fazer isso. Seu BeEF está operacional"
	arr["RUSSIAN",412]="Вам не нужно выполнять это действие. Ваш BeEF находится в рабочем состоянии"
	arr["GREEK",412]="Δεν χρειάζεται να εκτελέσετε αυτήν την ενέργεια. Το BeEF λειτουργεί κανονικά"
	arr["ITALIAN",412]="Non è necessario fare questo. Il tuo BeEF è operativo"
	arr["POLISH",412]="Nie musisz tego robić. Twoja BeEF działa"
	arr["GERMAN",412]="Sie müssen diese Aktion nicht durchführen. Ihr BeEF ist betriebsbereit"
	arr["TURKISH",412]="Bu eylemi gerçekleştirmeniz gerekmez. BeEF'in operasyonel"
	arr["ARABIC",412]="الخاص بك جاهز للعمل BeEF .لست بحاجة إلى تنفيذ هذا الإجراء"
	arr["CHINESE",412]="您不需要执行此操作。您的 BeEF 正在运行"

	arr["ENGLISH",413]="airgeddon fixed the problem. Your BeEF is operational"
	arr["SPANISH",413]="airgeddon ha solucionado el problema. Tu BeEF está operativo"
	arr["FRENCH",413]="airgeddon a résolu le problème. BeEF est opérationnel"
	arr["CATALAN",413]="airgeddon ha solucionat el problema. El teu BeEF està operatiu"
	arr["PORTUGUESE",413]="O airgeddon corrigiu o problema. Seu BeEF está operacional"
	arr["RUSSIAN",413]="airgeddon устранил проблему. Ваш BeEF находится в рабочем состоянии"
	arr["GREEK",413]="Το airgeddon διόρθωσε το πρόβλημα. Το BeEF λειτουργεί κανονικά"
	arr["ITALIAN",413]="airgeddon ha risolto il problema. Il tuo BeEF è operativo"
	arr["POLISH",413]="airgeddon rozwiązał problem. Twoja BeEF działa"
	arr["GERMAN",413]="airgeddon hat das Problem gelöst. Ihr BeEF ist betriebsbereit"
	arr["TURKISH",413]="airgeddon sorunu çözdü. BeEF'in operasyonel"
	arr["ARABIC",413]="الخاص بك جاهز للعمل BeEF .أصلحت المشكلة airgeddon"
	arr["CHINESE",413]="airgeddon 已经解决了这个问题。您的 BeEF 正在运行"

	arr["ENGLISH",414]="You don't have curl installed. Is not possible to download PINs database file"
	arr["SPANISH",414]="No tienes curl instalado. No se puede descargar el fichero de la base de datos de PINs"
	arr["FRENCH",414]="Curl n'est pas installé. Vous ne pouvez pas télécharger le fichier de la base de donées PIN"
	arr["CATALAN",414]="No tens curl instal·lat. No es pot descarregar el fitxer de la base de dades de PINs"
	arr["PORTUGUESE",414]="Você não tem o pacote curl instalado. Você não pode baixar o arquivo com banco de dados de PINs"
	arr["RUSSIAN",414]="У вас не установлен curl. Невозможно загрузить файл базы данных PIN"
	arr["GREEK",414]="Το curl δεν είναι εγκατεστημένο. Είναι αδύνατον να κατέβει το αρχείο με την βάση δεδομένων PIN"
	arr["ITALIAN",414]="Non si dispone di curl installato. Non è possibile scaricare il file della base dati dei PINs"
	arr["POLISH",414]="Nie masz zainstalowanego curl. Nie można pobrać pliku bazy danych kodu PIN"
	arr["GERMAN",414]="Sie haben curl nicht installiert. Die PIN-Datenbank konnte nicht heruntergeladen werden"
	arr["TURKISH",414]="Curl yüklü değil. PIN veritabanı dosyasını indirmek için Curl kurulu olmalı"
	arr["ARABIC",414]="PIN مثبت. لا يمكن تنزيل ملف قاعدة بيانات curl ليس لديك"
	arr["CHINESE",414]="您没有安装 curl 包。故无法下载 PIN 数据库文件"

	arr["ENGLISH",415]="\${blue_color}airgeddon knows you have BeEF installed and you pass the validation, but it was unable to locate the right directory path where you have BeEF installed. Knowing the location gives some advantages for the execution because its configuration file can be customized instead of generic. \${green_color}Do you want to enter it manually? \${normal_color}\${visual_choice}"
	arr["SPANISH",415]="\${blue_color}airgeddon sabe que tienes BeEF instalado y pasas la validación, pero no ha podido concretar la ruta del directorio exacto donde tienes instalado BeEF. Conocer la localización exacta tiene algunas ventajas a la hora de ejecutarlo ya que la configuración será personalizada en lugar de ser una configuración genérica. \${green_color}¿Quieres introducirla manualmente? \${normal_color}\${visual_choice}"
	arr["FRENCH",415]="\${blue_color}airgeddon a bien détecté que BeEF est installé mais il n'est malheuruesement pas possible de trouver le dossier le contenant. En l'état actuel des choses il ne sera pas possible de personaliser les parmétres d'éxécution de BeEF. \${green_color}Voulez-vous saisir l'emplacement du dossier? \${normal_color}\${visual_choice}"
	arr["CATALAN",415]="\${blue_color}airgeddon sap que tens BeEF instal·lat i passes la validació, però no ha pogut concretar la ruta del directori exacte on has instal·lat BeEF. Conèixer la localització exacta té alguns avantatges a l'hora d'executar ja que la configuració serà personalitzada en lloc de ser una configuració genèrica. \${green_color}¿Vols introduir-la manualment? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",415]="\${blue_color}O airgeddon sabe que você instalou o BeEF e validou a instalação, mas não pôde encontrar o diretório exato onde você instalou o BeEF. Saber a localização exata tem algumas vantagens quando executá-lo a configuração será personalizada em vez de uma configuração genérica. \${green_color}Você quer inseri-la manualmente? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",415]="\${blue_color}airgeddon знает, что у вас установлен BeEF и вы успешно прошли проверку, но скрипт оказался не в состоянии найти правильный путь к каталогу, где вы установили BeEF. Знание расположения даёт некоторые преимущества при выполнении, поскольку появляется возможность настроить его конфигурационный файл, а не использовать настройки по умолчанию. \${green_color}Вы хотите ввести расположение вручную? \${normal_color}\${visual_choice}"
	arr["GREEK",415]="\${blue_color}Το airgeddon γνωρίζει ότι έχετε εγκατεστημένο το BeEF και έχετε περάσει τους απαραίτητους ελέγχους, αλλά δεν μπόρεσε να εντοπίσει το σωστό μονοπάτι για τον κατάλογο όπου έχετε εγκαταστήσει το BeEF. Γνωρίζοντας το μονοπάτι για τον κατάλογο κάνει την διαδικασία της εκτέλεσης πλεονεκτική γιατί το αρχείο παραμέτρων μπορεί να ρυθμιστεί καταλλήλως, αντιθέτως με το προεπιλεγμένο. \${green_color}Θέλετε να το εισάγετε χειροκίνητα; \${normal_color}\${visual_choice}"
	arr["ITALIAN",415]="\${blue_color}airgeddon sa che hai BeEF installato e passi la validazione, peró non ha potuto trovare il percorso esatto della directory in cui hai installato BeEF. Conoscere l'esatta posizione ha alcuni vantaggi all'ora di eseguiro perchè la configurazione sarà personalizzata, piuttosto che una configurazione generica. \${green_color}Vuoi inserirla manualmente? \${normal_color}\${visual_choice}"
	arr["POLISH",415]="\${blue_color}airgeddon wie, że masz zainstalowaną wersję BeEF i przejdziesz walidację, ale nie możesz określić dokładnej ścieżki katalogu, w której zainstalowałeś BeEF. Znajomość dokładnej lokalizacji ma pewne zalety w czasie jej wykonywania, ponieważ konfiguracja zostanie dostosowana do indywidualnych potrzeb, a nie jako konfiguracja ogólna. \${green_color}Czy chcesz ją wprowadzić ręcznie? \${normal_color}\${visual_choice}"
	arr["GERMAN",415]="\${blue_color}airgeddon weiß, dass Sie BeEF installiert haben und Sie die Validierung bestehen, aber airgeddon konnte den genauen Verzeichnispfad, in den BeEF installiert ist, nicht angeben. Die genaue Position zu kennen, hat zum Zeitpunkt der Ausführung einige Vorteile, da die Konfiguration personalisiert wird, anstatt eine generische Konfiguration zu sein. \${green_color}Möchten Sie es manuell eingeben? \${normal_color}\${visual_choice}"
	arr["TURKISH",415]="\${blue_color}airgeddon, BeEF'in yüklü olduğunu ve doğrulama işlemini geçtiğinizi biliyor, ancak BeEF'in kurulu olduğu doğru dizin yolunu bulamadı. Konumun bilinmesi, yapılandırma dosyasının jenerik yerine özelleştirilebilmesi nedeniyle yürütme için bazı avantajlar sağlar. \${green_color}El ile girmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",415]="\${normal_color}\${visual_choice}\${green_color} هل تريد إدخاله يدويًا؟\${blue_color} .توفر معرفة الموقع بعض المزايا للتنفيذ لأنه يمكن تخصيص ملف التكوين الخاص به بدلاً من العام .BeEF مثبتًا وأنك نجحت في التحقق من الصحة ، لكنه لم يتمكن من تحديد مسار الدليل الصحيح حيث تم تثبيت BeEF أن لديك airgeddon يعرف\${normal_color}"
	arr["CHINESE",415]="\${blue_color}airgeddon 知道您安装了 BeEF 并且通过了验证，但是无法找到安装 BeEF 的正确目录路径。知道位置为执行提供了一些优势，因为它的配置文件可以自定义而不是通用的。 \${green_color}您要手动输入吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",416]="    You can run BeEF, but it is better if you run the second option before"
	arr["SPANISH",416]="    Puedes ejecutar BeEF, pero es recomendable ejecutar la segunda opción antes"
	arr["FRENCH",416]="    Vous pouvez exécuter BeEF mais il est recommandé d'exécuter préalablement la deuxième option"
	arr["CATALAN",416]="    Pots executar BeEF, però és recomanable executar la segona opció del menú abans"
	arr["PORTUGUESE",416]="    Você pode executar BeEF, mas é recomendado executar a segunda opção de menu antes"
	arr["RUSSIAN",416]="    Вы можете запустить BeEF, но лучше, если вы сначала запустите вторую опцию"
	arr["GREEK",416]="    Μπορείτε να εκτελέσετε το BeEF, αλλά είναι καλύτερα να διαλέξετε τη δεύτερη επιλογή από πρίν"
	arr["ITALIAN",416]="    Puoi eseguire BeEF, peró si consiglia di eseguire prima la seconda opzione"
	arr["POLISH",416]="    Możesz uruchomić BeEF, ale zaleca się uruchomienie drugiej opcji najpierw"
	arr["GERMAN",416]="    Sie können BeEF ausführen, es wird jedoch empfohlen, die zweite Option vorher auszuführen"
	arr["TURKISH",416]="    BeEF'i çalıştırabilirsiniz, ancak daha önce ikinci seçeneği çalıştırırsanız daha iyi olur"
	arr["ARABIC",416]="    لكن من الأفضل تشغيل الخيار الثاني من قبل ، BeEF يمكنك تشغيل"
	arr["CHINESE",416]="    您可以运行 BeEF，但最好先运行第二个选项"

	arr["ENGLISH",417]="An unexpected error occurred, redirecting to the menu"
	arr["SPANISH",417]="Ocurrió un error inesperado. Volviendo al menú"
	arr["FRENCH",417]="Une erreur inattendue s'est produite, retour au menu"
	arr["CATALAN",417]="Hi ha hagut un error inesperat, redirigint al menú"
	arr["PORTUGUESE",417]="Ocorreu um erro inesperado, retornando ao menu"
	arr["RUSSIAN",417]="Случилась непредвиденная ошибка, перенаправление в меню"
	arr["GREEK",417]="Παρουσιάστηκε μη αναμενόμενο σφάλμα, γίνεται ανακατεύθυνση στο μενού"
	arr["ITALIAN",417]="Errore imprevisto. Tornando al menú"
	arr["POLISH",417]="Wystąpił nieoczekiwany błąd. Powrót do menu"
	arr["GERMAN",417]="Ein unerwarteter Fehler ist aufgetreten. Zurück zum Menü"
	arr["TURKISH",417]="Beklenmeyen bir hata oluştu, menüye yönlendiriliyorsunuz"
	arr["ARABIC",417]="حدث خطأ غير متوقع ، إعادة التوجيه إلى القائمة"
	arr["CHINESE",417]="出现意外错误，正在重定向到上一级菜单"

	arr["ENGLISH",418]="Restoring MAC"
	arr["SPANISH",418]="Restaurando MAC"
	arr["FRENCH",418]="Rétablissement MAC"
	arr["CATALAN",418]="Restaurant MAC"
	arr["PORTUGUESE",418]="Restaurando MAC"
	arr["RUSSIAN",418]="Восстановление MAC-адреса"
	arr["GREEK",418]="Γίνεται αποκατάσταση της διεύθυνσης MAC"
	arr["ITALIAN",418]="Ripristinando MAC"
	arr["POLISH",418]="Przywracanie MAC"
	arr["GERMAN",418]="Wiederherstellen von MAC"
	arr["TURKISH",418]="MAC eski haline getiriliyor"
	arr["ARABIC",418]="MAC استعادة"
	arr["CHINESE",418]="恢复 MAC 地址"

	arr["ENGLISH",419]="Do you want to spoof your MAC address during this attack? \${normal_color}\${visual_choice}"
	arr["SPANISH",419]="¿Deseas falsear la dirección MAC de tu tarjeta durante el ataque? \${normal_color}\${visual_choice}"
	arr["FRENCH",419]="Voulez-vous falsifier l'adresse MAC de votre carte pour l'attaque? \${normal_color}\${visual_choice}"
	arr["CATALAN",419]="¿Vols falsejar l'adreça MAC de la targeta durant l'atac? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",419]="Você quer modificar o endereço MAC da sua interface durante o ataque? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",419]="Вы хотите подменить свой MAC-адрес во время этой атаки? \${normal_color}\${visual_choice}"
	arr["GREEK",419]="Θέλετε να κρύψετε την αληθινή διεύθυνση MAC, δημιουργώντας μία ψεύτικη κατά την διάρκεια αυτής της επίθεσης; \${normal_color}\${visual_choice}"
	arr["ITALIAN",419]="Vuoi falsificare l'indirizzo MAC della scheda durante l'attacco? \${normal_color}\${visual_choice}"
	arr["POLISH",419]="Chcesz spoofować adres MAC karty podczas ataku? \${normal_color}\${visual_choice}"
	arr["GERMAN",419]="Möchten Sie die MAC-Adresse Ihrer Karte während des Angriffs verfälschen? \${normal_color}\${visual_choice}"
	arr["TURKISH",419]="Bu saldırı sırasında MAC adresinizi değiştirmek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",419]="\${normal_color}\${visual_choice}\${green_color} الخاص بك أثناء هذا الهجوم؟ MAC address هل تريد انتحال\${normal_color}"
	arr["CHINESE",419]="您想在这次攻击中伪装您的 MAC 地址吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",420]="It has been detected that you are running airgeddon inside a Docker container. During this attack hostapd is used to create a fake AP. This component often conflicts with network-manager. From inside the container, airgeddon can't handle it. If you have network-manager installed on your host machine, close it or kill the conflicting processes or you'll get an error. For more information, see the Docker section of the Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["SPANISH",420]="Se ha detectado que estás ejecutando airgeddon en un contenedor de Docker. En este ataque se utiliza hostapd para crear un falso AP. Este componente suele dar conflicto con network-manager. Desde el contenedor, airgeddon no puede gestionarlo. Si tienes network-manager instalado en tu máquina host, ciérralo o mata los procesos en conflicto u obtendrás un error. Para más información consulta la sección Docker del Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["FRENCH",420]="Il a été détecté qu'airgeddon a été lancé depuis un conteneur Docker. Cette attaque à besoin d'hostapd pour créer un Point d'Accès piège. Hostapd a tendance à entrer en conflit avec network-manager et airgeddon ne peut pas le gérer depuis le conteneur. Si network-manager est installé sur votre machine host, arrêtez ou tuez les processus conflictuels. Dans le cas contraire vous obtiendrez une erreur. Pour plus d'informations, consultez la section Docker de notre Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["CATALAN",420]="S'ha detectat que estàs executant airgeddon en un contenidor de Docker. En aquest atac s'utilitza hostapd per crear un fals AP. Aquest component sol donar conflicte amb network-manager. Des del contenidor, airgeddon no pot gestionar-lo. Si tens network-manager instal·lat a la teua màquina host, tanca'l o mata els processos en conflicte u obtindràs un error. Per a més informació consulta la secció Docker del Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["PORTUGUESE",420]="Detectamos que você está executando airgeddon em um contêiner Docker. Neste ataque é usado hostapd para criar um AP falso. Este componente tende a entrar em conflito com network-manager. A partir do contêiner o airgeddon não pode controlá-lo. Se você tem network-manager instalado em sua máquina host feche-o, mate os processos conflitantes ou você irá obter um erro. Para mais informações consulte a seção Docker Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["RUSSIAN",420]="Определено, что вы запускаете airgeddon внутри контейнера Docker. Во время этой атаки для создания поддельной AP используется hostapd. Этот компонент часто конфликтует с network-manager. Изнутри контейнера airgeddon не может справиться с этим. Если на вашем хост-компьютере установлен network-manager, закройте его или уберите конфликтующие процессы, иначе вы получите сообщение об ошибке. Для получения дополнительной информации см. раздел Docker в Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["GREEK",420]="Εντοπίστηκε πως τρέχετε το airgeddon μέσα σε Docker container. Κατά τη διάρκεια αυτής της επίθεσης χρησιμοποιείται το hostapd για να δημιουργήσει ψεύτικο AP. Η δημιουργία αυτού κάνει conflicts με τον network-manager. Το airgeddon δεν μπορεί να το χειριστεί μέσα από το container. Αν υπάρχει ο network-manager εγκατεστημένος στον host-υπολογιστή, κλείστε τον ή διακόψτε τις διεργασίες που κάνουν conflict αλλιώς θα υπάρξουν σφάλματα. Για περισσότερες πληροφορίες, ανατρέξτε στην ενότητα Docker του Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["ITALIAN",420]="È stato rilevato che si sta eseguendo airgeddon in un contenitore Docker. In questo attacco viene utilizzato hostapd per creare un falso AP. Questo componente tende a creare un conflitto con il network-manager. Dal contenitore, airgeddon non può gestirlo. Se si dispone di network-manager installato sul computer host, chiuderlo o uccidere i processi in conflitto o ci sará un errore. Per ulteriori informazioni consultare la sezione Docker della nostra Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["POLISH",420]="Wykryto, że używasz airgeddon w kontenerze Docker. W tym ataku hostapd służy do utworzenia fałszywego AP. Ten komponent często ma konflikt z network-manager. Z kontenera airgeddon nie może sobie z tym poradzić. Jeśli na komputerze hosta zainstalowano network-manager, zamknij lub zabij sprzeczne procesy lub otrzymasz błąd. Aby uzyskać więcej informacji, zobacz sekcję Docker Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["GERMAN",420]="Es wurde festgestellt, dass Sie airgeddon in einem Docker-Container ausführen. Bei diesem Angriff wird mit hostapd ein falscher AP erstellt. Diese Komponente steht normalerweise im Konflikt mit dem network-manager. Aus dem Container kann airgeddon das nicht schaffen. Wenn Sie den network-manager auf Ihrem Host-Computer installiert haben, schließen Sie ihn oder beenden Sie die Prozesse im Konflikt oder Sie erhalten einen Fehler. Weitere Informationen finden Sie im Abschnitt Docker des Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["TURKISH",420]="Bir Docker konteynırı içinde airgeddon çalıştırdığınız tespit edildi. Bu saldırı sırasında hostapd sahte bir AP oluşturmak için kullanılır. Bu bileşen genellikle ağ yöneticisi ile çakışır. Konteynırın içinden, hava hücresi bunu kaldıramaz. Ana makinenize ağ yöneticisi yüklüyse, kapat veya çakışan işlemleri durdurun veya bir hatayla karşılaşırsınız. Daha fazla bilgi için, Wiki'nin Docker bölümüne bakın: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["ARABIC",420]="\${normal_color}\${urlgithub_wiki}/Docker\${pink_color} :Wiki في Docker التعامل معه. إذا كان لديك مدير شبكة مثبتًا على جهازك المضيف ، فأغلقه أو اقتل العمليات المتضاربة وإلا ستحصل على خطأ. لمزيد من المعلومات ، راجع قسم airgeddon  مزيف. غالبًا ما يتعارض هذا المكون مع مدير الشبكة. من داخل الحاوية ، لا يستطيع hostapd خلال هذا الهجوم ، يتم استخدام .Docker داخل حاوية airgeddon تم الكشف عن أنك تقوم بتشغيل\${normal_color}"
	arr["CHINESE",420]="检测到您正在 Docker 容器内运行 airgeddon。在此攻击期间，hostapd 用于创建伪造的 AP。该组件经常与网络管理器冲突。从容器内部，airgeddon 无法处理它。如果您的主机上安装了网络管理器，请关闭它或终止冲突进程，否则您将收到错误消息。有关详细信息，请参阅 Wiki 的 Docker 部分: \${normal_color}\${urlgithub_wiki}/Docker"

	arr["ENGLISH",421]="Doubts? Visit our Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["SPANISH",421]="¿Dudas? Visita nuestro Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["FRENCH",421]="Des questions? Visitez notre Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["CATALAN",421]="¿Dubtes? Visita el nostre Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["PORTUGUESE",421]="Dúvidas? Visite a Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["RUSSIAN",421]="Вопросы? Посетите Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["GREEK",421]="Απορίες; Επισκεφθείτε το Wiki μας: \${normal_color}\${urlgithub_wiki}"
	arr["ITALIAN",421]="Domande? Visita la nostra Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["POLISH",421]="Czy masz wątpliwości? Odwiedź nasze Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["GERMAN",421]="Fragen? Besuchen Sie unser Wiki: \${normal_color}\${urlgithub_wiki}"
	arr["TURKISH",421]="Yardım? Wiki'mizi ziyaret edin: \${normal_color}\${urlgithub_wiki}"
	arr["ARABIC",421]="\${normal_color}\${urlgithub_wiki}\${pink_color} :الخاص بنا Wiki لديك شكوك؟ قم بزيارة موقع\${normal_color}"
	arr["CHINESE",421]="使用此脚本时有疑惑？请访问我们的百科全书: \${normal_color}\${urlgithub_wiki}"

	arr["ENGLISH",422]="The automatic update has been disabled when airgeddon is running in a Docker container. If you want to update it, download again the image tagged as \"latest\""
	arr["SPANISH",422]="La actualización automática se ha desactivado cuando airgeddon se ejecuta en un contenedor de Docker. Si deseas actualizarlo descarga de nuevo la imagen con tag \"latest\""
	arr["FRENCH",422]="La mise à jour automatique est désactivée si airgeddon s'exécute depuis un conteneur Docker. Si vous voulez le mettre à jour vous devez télécharger l'image avec le label \"latest\""
	arr["CATALAN",422]="L'actualització automàtica s'ha desactivat quan airgeddon s'executa en un contenidor de Docker. Si vols actualitzar-lo descàrrega de nou la imatge amb tag \"latest\""
	arr["PORTUGUESE",422]="A atualização automática é desativada quando airgeddon é executado em um contêiner Docker. Se você quiser atualizar faça o download novamente da imagem em \"latest\""
	arr["RUSSIAN",422]="Когда airgeddon работает в контейнере Docker, то автоматическое обновление отключено,. Если вы хотите обновить программу, то снова загрузите образ отмеченный как \"latest\""
	arr["GREEK",422]="Η διαδικασία της αυτόματης ενημέρωσης είναι απενεργοποιημένη όταν το airgeddon τρέχει σε Docker container. Εάν θέλετε να το ενημερώσετε, κατεβάστε ξανά το αρχείο με την ετικέτα \"latest\""
	arr["ITALIAN",422]="L'aggiornamento automatico viene disattivato quando airgeddon viene eseguito in un contenitore Docker. Se vuoi aggiornarlo scaricare di nuovo l'immagine con il tag \"latest\""
	arr["POLISH",422]="Automatyczna aktualizacja została wyłączona, gdy airgeddon jest uruchomiony w kontenerze Docker. Jeśli chcesz go zaktualizować, pobierz ponownie obraz oznaczony jako \"latest\""
	arr["GERMAN",422]="Die automatische Aktualisierung wird deaktiviert, wenn airgeddon in einem Docker-Container ausgeführt wird. Wenn Sie es aktualisieren möchten, laden Sie das Bild erneut mit dem Tag \"latest\""
	arr["TURKISH",422]="airgeddon bir Docker konteynerinde çalışırken otomatik güncelleme devre dışı bırakıldı. Güncellemek isterseniz, \"latest\" etiketli görüntüyü tekrar indirin"
	arr["ARABIC",422]="مرة أخرى \"latest\" إذا كنت تريد تحديثه ، فقم بتنزيل الصورة التي تم وضع علامة عليها كـ .Docker في حاوية airgeddon تم تعطيل التحديث التلقائي عند تشغيل"
	arr["CHINESE",422]="当 airgeddon 在 Docker 容器中运行时，自动更新已被禁用。如果要更新它，请重新下载标记为“latest (新的) ”的 Docker 映像"

	arr["ENGLISH",423]="5.  WEP \"All-in-One\" attack"
	arr["SPANISH",423]="5.  Ataque WEP \"Todo-en-Uno\""
	arr["FRENCH",423]="5.  Attaque WEP \"Tout-en-Un\""
	arr["CATALAN",423]="5.  Atac WEP \"Tot-en-Un\""
	arr["PORTUGUESE",423]="5.  Ataque WEP \"Tudo-em-Um\""
	arr["RUSSIAN",423]="5.  Атака на WEP \"Все-в-Одном\""
	arr["GREEK",423]="5.  Επίθεση WEP \"All-in-One\""
	arr["ITALIAN",423]="5.  Attacco WEP \"Tutto-in-Uno\""
	arr["POLISH",423]="5.  Atak WEP \"Wszystko-w-Jednym\""
	arr["GERMAN",423]="5.  WEP-Angriff \"All-in-One\""
	arr["TURKISH",423]="5.  WEP \"Hepsi-bir-arada\" saldırı"
	arr["ARABIC",423]="5.   WEP \"All-in-One\" هجوم"
	arr["CHINESE",423]="5.  WEP \"All-in-One\" 攻击"

	arr["ENGLISH",424]="The selected network is invalid. Encryption type of target network must be WEP"
	arr["SPANISH",424]="La red seleccionada no es válida. El tipo de encriptación de la red objetivo debe ser WEP"
	arr["FRENCH",424]="Le réseau sélectionné est invalide . Le réseau cible doit être en WEP"
	arr["CATALAN",424]="La xarxa seleccionada no és vàlida. El tipus d'encriptació de la xarxa objectiu ha de ser WEP"
	arr["PORTUGUESE",424]="A rede selecionada é inválida. O tipo de criptografia da rede deve ser WEP"
	arr["RUSSIAN",424]="Выбранная сеть не подходит. Целевая сеть должна иметь шифрование WEP"
	arr["GREEK",424]="Το επιλεγμένο δίκτυο δεν είναι έγκυρο. Ο τύπος κρυπτογράφησης του δικτύου-στόχος πρέπει να είναι WEP"
	arr["ITALIAN",424]="La rete selezionata non è valida. Il tipo di crittografia della rete obiettivo deve essere WEP"
	arr["POLISH",424]="Wybrana sieć nie jest prawidłowa. Typem szyfrowania sieci docelowej musi być WEP"
	arr["GERMAN",424]="Das ausgewählte Netzwerk ist nicht gültig. Die Art der Verschlüsselung des Zielnetzwerks muss WEP sein"
	arr["TURKISH",424]="Seçilen ağ geçersiz. Hedef ağ şifreleme türü WEP olmalıdır"
	arr["ARABIC",424]="WEP الشبكة المحددة غير صالحة. يجب أن يكون نوع التشفير للشبكة المستهدفة هو"
	arr["CHINESE",424]="所选网络无效。目标网络的加密类型必须是 WEP"

	arr["ENGLISH",425]="You have a valid WEP target network selected. Script can continue..."
	arr["SPANISH",425]="Tienes una red objetivo WEP válida seleccionada. El script puede continuar..."
	arr["FRENCH",425]="Choix du réseau cible WEP valide. Le script peut continuer..."
	arr["CATALAN",425]="Tens una xarxa objectiu WEP vàlida seleccionada. El script pot continuar..."
	arr["PORTUGUESE",425]="Você tem uma rede WEP válida selecionada. O script pode continuar..."
	arr["RUSSIAN",425]="У вас есть подходящая целевая сеть WEP. Скрипт может продолжать..."
	arr["GREEK",425]="Έχετε επιλέξει ένα έγκυρο WEP δίκτυο-στόχος. Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",425]="Hai selezionato una rete obiettivo WEP valida. Lo script può continuare..."
	arr["POLISH",425]="Wybrano prawidłową sieć docelową WEP. Skrypt może kontynuować..."
	arr["GERMAN",425]="Sie haben ein gültiges WEP-Zielnetzwerk ausgewählt. Das Skript kann fortfahren..."
	arr["TURKISH",425]="Seçtiğiniz geçerli bir WEP hedef ağınız var. Komut dosyası devam edebilir..."
	arr["ARABIC",425]="محددة. البرنامج يمكن أن يستمر WEP لديك شبكة هدف"
	arr["CHINESE",425]="您选择了有效的 WEP 目标网络。脚本可以继续..."

	arr["ENGLISH",426]="9.  WEP attacks menu"
	arr["SPANISH",426]="9.  Menú de ataques WEP"
	arr["FRENCH",426]="9.  Menu d'attaques WEP"
	arr["CATALAN",426]="9.  Menú d'atacs WEP"
	arr["PORTUGUESE",426]="9.  Menu de ataques WEP"
	arr["RUSSIAN",426]="9.  Меню атак на WEP"
	arr["GREEK",426]="9.  Μενού επιθέσεων WEP"
	arr["ITALIAN",426]="9.  Menú degli attacchi WEP"
	arr["POLISH",426]="9.  Menu ataków WEP"
	arr["GERMAN",426]="9.  WEP-Angriffsmenü"
	arr["TURKISH",426]="9.  WEP saldırı menüsü"
	arr["ARABIC",426]="9.  WEP قائمة هجمات"
	arr["CHINESE",426]="9.  WEP 攻击菜单"

	arr["ENGLISH",427]="WEP attacks menu"
	arr["SPANISH",427]="Menú de ataques WEP"
	arr["FRENCH",427]="Menu d'attaques WEP"
	arr["CATALAN",427]="Menú d'atacs WEP"
	arr["PORTUGUESE",427]="Menu de ataques WEP"
	arr["RUSSIAN",427]="Меню атак на WEP"
	arr["GREEK",427]="Μενού επιθέσεων WEP"
	arr["ITALIAN",427]="Menú degli attacchi WEP"
	arr["POLISH",427]="Menu ataków WEP"
	arr["GERMAN",427]="WEP-Angriffsmenü"
	arr["TURKISH",427]="WEP saldırı menüsü"
	arr["ARABIC",427]="WEP قائمة هجمات"
	arr["CHINESE",427]="WEP 攻击菜单"

	arr["ENGLISH",428]="If real clients exist connected to the WEP encrypted network, the process will be significantly accelerated. Enough IVs (Initialization Vectors) will be catched faster"
	arr["SPANISH",428]="Si existen clientes reales conectados a la red con encriptación WEP, el proceso se acelerará notablemente. Se obtendrán antes suficientes IVs (Vectores de Inicialización)"
	arr["FRENCH",428]="Si des clients légitimes sont connectés à un rseau WEP le processus ira plus vite. Les Ivs requis (vecteurs d'incitiaisation) seront plus vite obtenus"
	arr["CATALAN",428]="Si hi ha clients reals connectats a la xarxa amb encriptació WEP, el procés s'accelerarà notablement. S'obtindran abans suficients IVs (Vectors d'Inicialització)"
	arr["PORTUGUESE",428]="Se clientes reais estiverem conectados à rede com criptografia WEP, o processo será acelerado significativamente. Serão obtidos IVs (Vetores de Inicialização) mais rapidamente"
	arr["RUSSIAN",428]="Если к сети с WEP шифрованием подключены реальные клиенты, то процесс будет значительно ускорен. Будет быстрее накоплено достаточное количество IVs (Векторов Инициализации)"
	arr["GREEK",428]="Εάν υπάρχουν αληθινοί συνδεδεμένοι χρήστες στο κρυπτογραφημένο WEP δίκτυο, η διαδικασία θα επιταχυνθεί σημαντικά. Θα καταγραφθούν αρκετά IVs (Initialization Vectors) γρηγορότερα"
	arr["ITALIAN",428]="Se esistono dei clienti reali connessi alla rete con crittografia WEP il processo sará piú veloce. Si otterrano prima sufficienti IV (Vettori di Inizializzazione)"
	arr["POLISH",428]="Jeśli istnieją prawdziwi klienci podłączeni do sieci z szyfrowaniem WEP, proces przyspiesza zauważalnie. Szybciej uzyskane zostaną wystarczające IVs (Wektory Inicjujące)"
	arr["GERMAN",428]="Wenn echte Clients über die WEP-Verschlüsselung mit dem Netzwerk verbunden sind, beschleunigt sich der Prozess erheblich. Ausreichende IVs werden vorher erhalten (InitialisierungsVektoren)"
	arr["TURKISH",428]="Gerçek istemciler WEP şifreli ağa bağlıysa, süreç önemli ölçüde hızlandırılacaktır. Yeterli İV'ler (Başlatma Vektörleri) daha hızlı yakalanacak"
	arr["ARABIC",428]="كافية بشكل أسرع IVs (Initialization Vectors) المشفرة ، فسيتم تسريع العملية بشكل كبير. سيتم التقاط WEP إذا كان هناك عملاء حقيقيون متصلون بشبكة"
	arr["CHINESE",428]="如果存在连接到 WEP 加密网络的真实客户端，则该过程将大大加快。足够的 IV (始化向量) 将被更快地捕获"

	arr["ENGLISH",429]="The WEP \"All-in-One\" attack combines different techniques to generate enough traffic to decrypt the key (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentation, Fake association, etc.)"
	arr["SPANISH",429]="El ataque WEP \"Todo-en-Uno\" combina diversas técnicas para generar el tráfico suficiente que hace falta para descifrar la clave (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentación, Falsa asociación, etc.)"
	arr["FRENCH",429]="L'attaque WEP \"Tout-en-Un\" combine plusieurs techniques pour générer le trafic nécessaire au décryptage de la clef (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentation, Fausse association, etc.)"
	arr["CATALAN",429]="L'atac WEP \"Tot-en-Un\" combina diverses tècniques per generar el trànsit suficient que cal per desxifrar la clau (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentació, Falsa associació, etc.)"
	arr["PORTUGUESE",429]="O ataque WEP \"Tudo-em-Um\" combina várias técnicas para gerar tráfego suficiente que é necessário para descriptografar a chave (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentação, Falsa associação, etc.)"
	arr["RUSSIAN",429]="Атака WEP \"Все-в-Одном\" сочетает в себе различные методы генерации трафика, достаточного для расшифровки ключа (Caffe Latte, Hirte, Replay, Chop-Chop, Дробление, Фальшивые ассоциации и т.д.)"
	arr["GREEK",429]="Η \"All-in-One\" επίθεση WEP συνδυάζει διαφορετικές τεχνικές για να παραχθεί αρκετή κίνηση για να αποκρυπτογραφήσει το κλειδί (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentation, Fake association, κλπ)"
	arr["ITALIAN",429]="L'attacco WEP \"Tutto-in-Uno\" combina diverse tecniche per generare il traffico necessario per decifrare la chiave (Caffe Latte, Hirte, Replay, Chop-Chop, Frammentazione, Falsa associazione, etc.)"
	arr["POLISH",429]="WEP typu \"Wszystko-w-Jednym\" łączy różne techniki, aby uzyskać wystarczająco dużo ruchu, aby odszyfrować klucz (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentation, Fałszywe asocjacja, itd.)"
	arr["GERMAN",429]="Der WEP-Angriff \"All-in-One\" kombiniert verschiedene Techniken, um genug Verkehr zu erzeugen, um den Schlüssel zu entschlüsseln (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentierung, falsche Assoziation, etc.)"
	arr["TURKISH",429]="WEP \"Hepsi-bir-arada\" saldırısı, anahtarın şifresini çözmek için yeterli teknikleri üretmek için farklı teknikleri birleştirir (Caffe Latte, Hirte, Replay, Chop-Chop, Fragmentation, Fake association, vb.)"
	arr["ARABIC",429]="(وما إلى ذلك Fake Association و Fragmentation و Chop-Chop و Replay و Hirte و Caffe Latte) بين تقنيات مختلفة لإنشاء حركة مرور كافية لفك تشفير المفتاح WEP \"All-in-One\" يجمع هجوم"
	arr["CHINESE",429]="WEP \"All-in-One\" 攻击结合了不同的技术来生成足够的流量来解密密钥 (Caffe Latte、Hirte、Replay、Chop-Chop、Fragmentation、Fake association 等)"

	arr["ENGLISH",430]="If the password for the wifi network is obtained with the WEP attack, you should decide where to save it. \${green_color}Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${wep_potpath}]"
	arr["SPANISH",430]="Si se consigue la contraseña de la red wifi con el ataque WEP, hay que decidir donde guardarla. \${green_color}Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${wep_potpath}]"
	arr["FRENCH",430]="Si le mot de passe est obtenu par une attaque WEP, il faut ensuite indiquer l'endroit pour la garder. \${green_color}Entrez la route vers l'endroit où vous voulez garder le fichier ou bien appuyez sur [Enter] si la route proposée par défaut vous convient \${normal_color}[\${wep_potpath}]"
	arr["CATALAN",430]="Si s'aconsegueix la contrasenya de la xarxa wifi amb l'atac WEP, cal decidir on guardar-la. \${green_color}Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${wep_potpath}]"
	arr["PORTUGUESE",430]="Se a senha da rede wifi for obtida com o ataque WEP, onde deseja salvá-la?. \${green_color}Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${wep_potpath}]"
	arr["RUSSIAN",430]="Если во время WEP атаки на Wi-Fi сеть получен пароль, вы должны решить, где его сохранить. \${green_color} Наберите путь для сохранения файла или нажмите [Enter] для принятия значения по умолчанию \${normal_color}[\${wep_potpath}]"
	arr["GREEK",430]="Εάν βρεθεί ο κωδικός πρόσβασης για το ασύρματο δίκτυο με την επίθεση WEP, θα πρέπει να αποφασίσετε που θα τον αποθηκεύσετε. \${green_color}Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${wep_potpath}]"
	arr["ITALIAN",430]="Se si ottiene la password della rete wireless con l'attacco WEP, decidere dove salvarla. \${green_color}Immettere il percorso dove memorizzare il file o premere [Enter] per accettare la proposta di default \${normal_color}[\${wep_potpath}]"
	arr["POLISH",430]="Jeśli hasło sieci wifi zostanie zdobyte atakiem WEP, musisz zdecydować, gdzie je zapisać. \${green_color}Wpisz ścieżkę, w której będziemy zapisywać plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${wep_potpath}]"
	arr["GERMAN",430]="Wenn Sie das WLAN-Passwort mit dem WEP-Angriff erhalten, müssen Sie entscheiden, wo Sie es speichern möchten. \${green_color} Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag \${normal_color}[\${wep_potpath}] \${blue_color}zu akzeptieren"
	arr["TURKISH",430]="Kablosuz ağın şifresi WEP saldırısıyla elde edilirse, nereye kaydedeceğinize karar vermelisiniz. \${green_color}Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${wep_potpath}]"
	arr["ARABIC",430]="\${normal_color}[\${wep_potpath}]\${green_color} لقبول الاقتراح [Enter] فيجب أن تقرر مكان حفظها \${blue_color}.اكتب المسار لتخزين الملف أو اضغط على ،WEP بهجوم wifi إذا تم الحصول على كلمة المرور لشبكة\${normal_color}"
	arr["CHINESE",430]="如果 wifi 网络的密码是通过 WEP 攻击获得的，您应该决定将其保存在何处。 \${green_color}键入存储文件的路径或按 [Enter] 接受默认建议 \${normal_color}[\${wep_potpath}]"

	arr["ENGLISH",431]="The WEP protocol had a bad design and can be cracked in a few minutes if we have enough generated traffic"
	arr["SPANISH",431]="El protocolo WEP tuvo un diseño erróneo y se puede romper en pocos minutos si se genera tráfico suficiente"
	arr["FRENCH",431]="Le protocole WEP n'est pas sûr et peut se déchiffrer en quelques minutes si suffisamment de trafic est généré"
	arr["CATALAN",431]="El protocol WEP va tindre un disseny erroni i es pot trencar en pocs minuts si es genera trànsit suficient"
	arr["PORTUGUESE",431]="O protocolo WEP é um projeto falho e pode ser quebrado em poucos minutos se tivermos tráfego suficiente"
	arr["RUSSIAN",431]="Протокол WEP сделан неудачно и при достаточном количестве сгенерированного трафика может быть взломан в считанные минуты"
	arr["GREEK",431]="Το πρωτόκολλο WEP είχε κακό σχεδιασμό και μπορεί να σπάσει μέσα σε λίγα λεπτά, αν έχουμε αρκετή κίνηση πακέτων"
	arr["ITALIAN",431]="Il protocollo WEP fú disegnato male e si puó rompere in pochi minuti se si genera abbastanza traffico"
	arr["POLISH",431]="Protokół WEP został nieprawidłowo zaprojektowany i może zostać złamany po kilku minutach, jeśli zostanie wygenerowany wystarczający ruch"
	arr["GERMAN",431]="Das WEP-Protokoll hatte ein falsches Design und kann in wenigen Minuten unterbrochen werden, wenn genügend Datenverkehr generiert wird"
	arr["TURKISH",431]="WEP protokolü kötü bir tasarıma sahipti ve yeterli trafik oluşturulması durumunda bir kaç dakika içinde kırılabilir"
	arr["ARABIC",431]="له تصميم سيء ويمكن اختراقه في بضع دقائق إذا كان لدينا ما يكفي من حركة المرور المولدة WEP بروتوكول"
	arr["CHINESE",431]="WEP 协议的设计的其实很糟糕，如果我们有足够的流量来进行分析，几分钟内就可以破解"

	arr["ENGLISH",432]="Captured IVs (Initialization Vectors) are shown on airodump capture window as \"Data\""
	arr["SPANISH",432]="Los IVs (Vectores de Inicialización) capturados, son representados en la ventana de captura de airodump como \"Data\""
	arr["FRENCH",432]="Les IVs (Vecteurs de Initialisation) capturés sont reportés dans la colomne \"Data\" de la console airodump-ng"
	arr["CATALAN",432]="Els IVs (Vectors d'Inicialització) capturats, són representats en la finestra de captura de airodump com \"Data\""
	arr["PORTUGUESE",432]="Os IVs (Vetores de Inicialização) capturados, são representados na captura de janela airodump como \"Data\""
	arr["RUSSIAN",432]="Захваченные IVs (Векторы Инициализации) показаны в окне захвата airodump как \"Data\""
	arr["GREEK",432]="Τα ληφθέντα IVs (Initialization Vectors) εμφανίζονται στο παράθυρο καταγραφής airodump ως \"Data\""
	arr["ITALIAN",432]="I IV (Vettori di Inizializzazione) catturati, sono rappresentati nella finestra di acquisizione di airodump come \"Data\""
	arr["POLISH",432]="Uchwycone obiekty IV (Wektory Inicjujące) są prezentowane w oknie przechwytywania airodump jako \"Data\""
	arr["GERMAN",432]="Die erfassten IVs (InitialisierungsVektoren) werden im Erfassungsfenster von airodump als \"Data\" dargestellt"
	arr["TURKISH",432]="Yakalanan IV'ler (Başlatma Vektörleri) airodump yakalama penceresinde \"Data\" olarak gösterilir"
	arr["ARABIC",432]="\"Data\" كـ airodump في نافذة التقاط الملتقطة IVs (Initialization Vectors) يتم عرض"
	arr["CHINESE",432]="捕获的 IV (初始化向量) 在 airodump 捕获窗口中显示为 \"Data\""

	arr["ENGLISH",433]="Some access points are not vulnerable to certain WEP attacks. Like for example the Chop-Chop attack, that only affects some of them"
	arr["SPANISH",433]="Algunos puntos de acceso no son vulnerables a ciertos ataques WEP. Como por ejemplo el ataque Chop-Chop, que solo afecta a algunos"
	arr["FRENCH",433]="Certains points d'accès ne sont pas vulnérables à certaines attaques WEP. Comme par example l'attaque Chop-Chop qui affecte seulement à certains Point d'Accès"
	arr["CATALAN",433]="Alguns punts d'accés no són vulnerables a certs atacs WEP. Com per exemple l'atac Chop-Chop, que només afecta alguns"
	arr["PORTUGUESE",433]="Alguns pontos de acesso não são vulneráveis a certos ataques WEP. Como por exemplo o ataque Chop-Chop, que só afeta alguns"
	arr["RUSSIAN",433]="Некоторые точки доступа не подвержены определенным атакам WEP. Например, атаке Chop-Chop подвержены только некоторые из них"
	arr["GREEK",433]="Ορισμένα σημεία πρόσβασης δεν είναι ευάλωτα σε ορισμένες επιθέσεις WEP. Για παράδειγμα η επίθεση Chop-Chop, επηρεάζει μόνο μερικά από αυτά"
	arr["ITALIAN",433]="Alcuni punti di accesso non sono vulnerabili a certi attacchi WEP. Come ad esempio l'attacco Chop-Chop, che colpisce solo alcuni"
	arr["POLISH",433]="Niektóre punkty dostępu nie są podatne na niektóre ataki WEP. Na przykład atak Chop-Chop, który dotyka tylko niektórych osób"
	arr["GERMAN",433]="Einige Access Points sind nicht anfällig für bestimmte WEP-Angriffe. Zum Beispiel der Chop-Chop-Angriff, der nur einige betrifft"
	arr["TURKISH",433]="Bazı erişim noktaları belirli WEP saldırılarına karşı savunmasız değildir. Örneğin Chop-Chop saldırısı gibi, sadece bazılarını etkiler"
	arr["ARABIC",433]="الذي يؤثر فقط على بعضها ، Chop-Chop معينة. مثل على سبيل المثال هجوم WEP بعض نقاط الوصول ليست عرضة لهجمات"
	arr["CHINESE",433]="部分 AP 不容易受到某些类型的 WEP 攻击。例如 Chop-Chop 攻击，它只会影响一些设备"

	arr["ENGLISH",434]="WEP \"All-in-One\" attack has been started. Press [Enter] key on this window to stop it"
	arr["SPANISH",434]="El ataque WEP \"Todo-en-Uno\" ha comenzado. Pulse la tecla [Enter] en esta ventana para pararlo"
	arr["FRENCH",434]="L'attaque WEP \"Tout-en-Un\" a commencé. Pressez la touche [Enter] dans cette console pour l'arrêter"
	arr["CATALAN",434]="L'atac WEP \"Tot-en-Un\" ha començat. Prem [Enter] a aquesta finestra per aturar-lo"
	arr["PORTUGUESE",434]="Ataque WEP \"Tudo-em-Um\" iniciado. Pressione a tecla [Enter] nesta janela para parar"
	arr["RUSSIAN",434]="Атака WEP \"Все-в-Одном\" началась. Для её остановки клавишу [Enter] в этом окне"
	arr["GREEK",434]="Η επίθεση WEP \"All-in-One\" έχει αρχίσει. Πατήστε το κουμπί [Enter] σε αυτό το παράθυρο για να την σταματήσετε"
	arr["ITALIAN",434]="L'attacco WEP \"Tutto-in-Uno\" è iniziato. Premere il tasto [Enter] in questa finestra per fermarlo"
	arr["POLISH",434]="Rozpoczął się atak WEP \"Wszystko-w-Jednym\". Naciśnij klawisz [Enter] w tym oknie, aby go zatrzymać"
	arr["GERMAN",434]="Der WEP-Angriff \"All-in-One\" hat begonnen. Drücken Sie die [Enter]-Taste in diesem Fenster, um sie zu stoppen"
	arr["TURKISH",434]="WEP \"Hepsi-bir-arada\" saldırı başlatıldı. Bunu durdurmak için bu pencerede [Enter] tuşuna basın"
	arr["ARABIC",434]="في هذه النافذة لإيقافه [Enter] اضغط على مفتاح .WEP \"All-in-One\" تم بدء هجوم"
	arr["CHINESE",434]="WEP \"All-in-One\" 攻击已经开始。在此窗口中按 [Enter] 键停止攻击"

	arr["ENGLISH",435]="Error trying to change interface mode. During the process the interface name must be changed, but it looks like you already have an interface occupying the name that would be needed (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["SPANISH",435]="Error al intentar cambiar el modo de la interfaz. En el proceso el nombre de la interfaz cambia, pero parece que ya tienes una interfaz ocupando el nombre que se necesitaría (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["FRENCH",435]="Une erreur est survenue lors de la tentative de changement du mode de l'interface. L'identifiant de l'interface est changé pendant le processus mais il semble que l'identifiant prévu n'est plus disponible car il est déjà utilisé par une autre interface (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["CATALAN",435]="Error en intentar canviar el mode de la interfície. En el procés el nom de la interfície canvia, però sembla que ja tens una interfície ocupant el nom que es necessitaria (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["PORTUGUESE",435]="Erro ao tentar alterar o modo da interface. No processo o nome da interface muda, mas parece que já há uma interface ocupando o mesmo nome (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["RUSSIAN",435]="Ошибка при попытке изменить режим интерфейса. Во время этого процесса имя интерфейса должно быть изменено, но похоже, что у вас уже есть интерфейс, занимающий нужное имя (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["GREEK",435]="Προέκυψε σφάλμα καθώς άλλαζε η κατάσταση της διεπαφής. Κατά τη διάρκεια της διαδικασίας, το όνομα της διεπαφής πρέπει να αλλάξει, αλλά φαίνεται ότι έχετε ήδη μια διεπαφή που έχει το όνομα που θα χρειαζόταν (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["ITALIAN",435]="Errore cercando di cambiare la modalità dell'interfaccia. Nel processo il nome dell'interfaccia cambia, peró sembra che già disponi di un'interfaccia che usa il nome di cui avresti bisogno (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["POLISH",435]="Wystąpił błąd podczas próby zmiany trybu interfejsu. Wymaga to zmiany jego nazwy, ale wygląda jednak na to, że masz już interfejs o nazwie, która będzie potrzebna (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["GERMAN",435]="Fehler beim Versuch, den Modus des Interface zu ändern. Dabei ändert sich der Name des Interface, aber es scheint, dass Sie bereits ein Interface haben, das den Namen belegt, der benötigt ist (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["TURKISH",435]="Arabirim modunu değiştirmeye çalışırken hata oluştu. İşlem sırasında arabirim adı değiştirilmeli, ancak gerekli olan adı taşıyan bir arabirime sahip olduğunuz anlaşılıyor (\${normal_color}\${desired_interface_name}\${red_color})"
	arr["ARABIC",435]="(\${normal_color}\${desired_interface_name}\${red_color}) خطأ في محاولة تغيير وضع الواجهة. أثناء العملية ، يجب تغيير اسم الواجهة ، ولكن يبدو أن لديك بالفعل واجهة تشغل الاسم المطلوب"
	arr["CHINESE",435]="尝试更改接口模式时出错。在此过程中，接口名称必须更改，但看起来您已经有一个接口占用了所需的名称 (\${normal_color}\${desired_interface_name}\${red_color})"

	arr["ENGLISH",436]="The hashcat version you have installed (\${hashcat_version}) is greater or equal than \${hashcat_hccapx_version} so you need to convert the capture files to \"hccapx\" format, airgeddon will do this automatically. To do this you need a converter that is not present on your system (hashcat-utils package), install it to be able to perform this attack"
	arr["SPANISH",436]="La versión de hashcat que tienes instalada (\${hashcat_version}) es igual o superior a la \${hashcat_hccapx_version} por lo que es necesario convertir los ficheros de captura a formato \"hccapx\", airgeddon lo hará automáticamente. Pero para ello hace falta un conversor que no está presente en tu sistema (paquete hashcat-utils), instálalo para poder realizar este ataque"
	arr["FRENCH",436]="La Version d'hashcat installée (\${hashcat_version}) est égale ou supérieure à la version \${hashcat_hccapx_version}. Il est nécessaire dans ce cas de convertir les captures au format \"hccapx\", ce que fera automatiquement airgeddon. Il faut pour cela un convertisseur qui n'est pas installé dans votre système (paquet hashcat-utils). Veuilez l'installer pour effectuer cette attaque"
	arr["CATALAN",436]="La versió de hashcat que tens instal·lada (\${hashcat_version}) és igual o superior a la \${hashcat_hccapx_version} pel que cal convertir els fitxers de captura a format \"hccapx\", airgeddon ho farà automàticament. Però per a això cal un convertidor que no està present al sistema (paquet hashcat-utils), instal·lal per poder realitzar aquest atac"
	arr["PORTUGUESE",436]="A versão do hashcat instalada (\${hashcat_version}) é maior ou igual a \${hashcat_hccapx_version}, portanto é necessário convertermos o arquivo de captura para o formato \"hccapx\", airgeddon fará isso automaticamente. Mas isso requer um conversor que não está instalado no seu sistema (pacote hashcat-utils), instale-o para realizar este ataque"
	arr["RUSSIAN",436]="Установленная версия hashcat (\${hashcat_version}) больше или равна \${hashcat_hccapx_version}, поэтому вам нужно конвертировать файлы захвата в формат \"hccapx\", airgeddon сделает это автоматически. Для этого вам нужен конвертер, которого нет в вашей системе (пакет hashcat-utils), установите его, чтобы иметь возможность выполнить эту атаку"
	arr["GREEK",436]="Η έκδοση του hashcat που έχετε εγκαταστήσει (\${hashcat_version}) είναι ίδια ή νεότερη από την έκδοση \${hashcat_hccapx_version}, άρα το airgeddon θα μετατρέψει τα αρχεία καταγραφής σε \"hccapx\" για να συνεχιστεί η διαδικασία. Για να επιτευχθεί αυτό χρειάζεστε ένα μετατροπέα που δεν υπάρχει στο σύστημά σας (περιέχεται στο πακέτο hashcat-utils), εγκαταστήστε το για να εκτελέσετε αυτήν την επίθεση"
	arr["ITALIAN",436]="La versione di hashcat installata (\${hashcat_version}) è uguale o superiore alla \${hashcat_hccapx_version} quindi è necessario convertire i file di acquisizione al formato \"hccapx\", airgeddon lo fará automaticamente. Peró questo richiede un convertitore che non è presente nel sistema (pacchetto hashcat-utils), installalo per eseguire questo attacco"
	arr["POLISH",436]="Zainstalowana wersja programu hashcat (\${hashcat_version}) jest równa lub większa niż \${hashcat_hccapx_version}, dlatego konieczne jest przekonwertowanie plików przechwytywania do formatu \"hccapx\", airgeddon zrobi to automatycznie. Do tego potrzebny jest konwerter, który nie jest obecny w systemie (pakiet hashcat-utils), zainstaluj go, aby móc wykonać ten atak"
	arr["GERMAN",436]="Ihre installierte hashcat-Version (\${hashcat_version}) ist gleich oder größer als \${hashcat_hccapx_version}. Daher ist es notwendig, die Capture-Dateien in das Format \"hccapx\" zu konvertieren. airgeddon macht das automatisch. Dafür benötigen Sie einen Konverter, der nicht in Ihrem System vorhanden ist (Paket hashcat-utils), installieren Sie es, um diesen Angriff ausführen zu können"
	arr["TURKISH",436]="Yüklediğiniz hashcat sürümü (\${hashcat_version}) \${hashcat_hccapx_version} boyutundan büyük ya da eşittir. Bu nedenle, yakalama dosyalarını \"hccapx\" biçimine dönüştürmeniz gerekir, bu nedenle airgeddon bunu otomatik olarak yapar. Bunu yapmak için sisteminizde mevcut olmayan bir dönüştürücüye ihtiyacınız vardır (hashcat-utils paketi), bu saldırıyı gerçekleştirebilmek için kurun"
	arr["ARABIC",436]="قم بتثبيته لتتمكن من تنفيذ هذا الهجوم ، (hashcat-utils package) بذلك تلقائيًا. للقيام بذلك ، تحتاج إلى محول غير موجود على نظامك airgeddon وسوف يقوم ، \"hccapx\" لذلك تحتاج إلى تحويل ملفات الالتقاط إلى تنسيق ،\${hashcat_hccapx_version} أكبر من أو يساوي (\${hashcat_version}) الذي قمت بتثبيته hashcat إصدار"
	arr["CHINESE",436]="您安装的 hashcat 版本 (\${hashcat_version}) 大于或等于 \${hashcat_hccapx_version} 因此您需要将捕获文件转换为 \"hccapx\" 格式，airgeddon 会自动执行此操作。为此，你需要安装一个转换器 (hashcat-utils 软件包)，以便它能够执行此攻击"

	arr["ENGLISH",437]="If you enjoyed the script and found it useful, you can support the project by making a donation. Through PayPal (\${normal_color}\${mail}\${pink_color}) or sending a fraction of cryptocurrency (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Any amount, no matter how small (1, 2, 5 $/€) is welcome. More information and direct links to do it at: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["SPANISH",437]="Si te gustó el script y te pareció útil, puedes apoyar el proyecto haciendo una donación. A través de PayPal (\${normal_color}\${mail}\${pink_color}) o enviando una fracción de criptomoneda (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Cualquier cantidad por pequeña que sea (1, 2, 5 $/€) es bien recibida. Más información y enlaces directos para realizarla en: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["FRENCH",437]="Si le script vous a plus et que vous l'avez trouvé utile, vous pouvez soutenir le projet en faisant un don PayPal (\${normal_color}\${mail}\${pink_color}) ou en envoyant une fraction de crypto-monnaie (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Toute contribution (1, 2, 5 $/€) est bienvenue. Pour faire un don allez à: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["CATALAN",437]="Si et va agradar el script i et va semblar útil, pots donar suport al projecte fent una donació. A través de PayPal (\${normal_color}\${mail}\${pink_color}) o enviant una fracció criptomoneda (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Qualsevol quantitat per petita que sigui (1, 2, 5 $/€) és ben rebuda. Més informació i enllaços directes per a realitzar-la en: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["PORTUGUESE",437]="Se você gostou do script e o achou útil, apoie o projeto fazendo uma doação através: do PayPal (\${normal_color}\${mail}\${pink_color}) ou enviando uma fração de uma criptomoeda (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Qualquer quantidade, mesmo pequena (1, 2, 5 $/€) é bem-vinda. Links diretos e de com realizar em: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["RUSSIAN",437]="Если вам понравилась эта программа и она оказался для вас полезной, вы можете поддержать проект, сделав пожертвование. Доступны переводы через PayPal (\${normal_color}\${mail}\${pink_color}) и криптовалюту (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Приветствуется любая сумма, даже небольшая (1, 2, 5 $/€). Более подробную информацию и прямые ссылки можно получить по адресу: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["GREEK",437]="Εαν μείνατε ευχαριστημένοι από το script και το βρήκατε χρήσιμο, μπορείτε να υποστηρίξετε το project κάνοντας κάποια δωρεά. Μέσω PayPal (\${normal_color}\${mail}\${pink_color}) ή αποστέλλοντας κάποιο κλάσμα κρυπτονομίσματος (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Είναι καλοδεχούμενο οποιοδήποτε ποσό (1, 2, 5 $/€), δεν έχει σημασία το πόσο λίγο μπορεί να είναι. Δίνονται περισσότερες πληροφορίες και links για να κάνετε δωρεά, στη διεύθυνση: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["ITALIAN",437]="Se ti è piaciuto lo script e l'hai trovato utile, puoi sostenere il progetto con una donazione. Attraverso PayPal (\${normal_color}\${mail}\${pink_color}) o inviando una frazione di criptovaluta (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Qualsiasi importo per quanto piccolo (1, 2, 5 $/€) è ben accolto. Piú informazioni e collegamenti diretti per realizzarla in: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["POLISH",437]="Jeśli podobał Ci się ten skrypt i okazał się użyteczny, możesz poprzeć ten projekt, składając donację. Za pośrednictwem usługi PayPal (\${normal_color}\${mail}\${pink_color}) lub wysyłając ułamek kryptowaluty (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Każda kwota, nawet malutka (1, 2, 5 $/€) będzie mile widziana. Więcej informacji i linki do donacji: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["GERMAN",437]="Wenn Ihnen das Skript gefallen hat und Sie es nützlich fanden, können Sie das Projekt mit einer Spende unterstützen. Durch PayPal (\${normal_color}\${mail}\${pink_color}) oder durch Senden eines Bruchteils der Kryptowährung (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}). Jeder kleine Betrag (1, 2, 5 $/€) wird gut angenommen. Mehr Informationen und direkte Links, um es zu machen: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["TURKISH",437]="Senaryoyu beğendiyseniz ve yararlı bulduysanız, projeyi bağış yaparak destekleyebilirsiniz. PayPal (\${normal_color}\${mail}\${pink_color}) veya cryptocurrency'ın bir kısmını (\${normal_color}Bitcoin, Ethereum, Litecoin... \${pink_color}) göndererek. Ne kadar küçük olursa olsun, ne kadar küçük olursa olsun (1, 2, 5 $/€) kabul edilir. Bunu yapmak için daha fazla bilgi ve doğrudan bağlantı: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["ARABIC",437]="\${normal_color}\${urlgithub_wiki}/Contributing\${pink_color} :نرحب بأي مبلغ مهما كان صغيرا (1 ، 2 ، 5 دولارات / يورو). مزيد من المعلومات والروابط المباشرة للقيام بذلك على (\${normal_color}Bitcoin, Ethereum, Litecoin...\${pink_color}) أو إرسال جزء من العملة المشفرة (\${normal_color}\${mail}\${pink_color}) إذا كنت قد استمتعت بالبرنامج ووجدته مفيدًا ، فيمكنك دعم المشروع من خلال التبرع. من خلال\${normal_color}"
	arr["CHINESE",437]="如果您喜欢该脚本并发现它很有用，您可以通过捐赠来支持该项目。通过 PayPal (\${normal_color}\${mail}\${pink_color}) 或一点加密货币来付款 (\${normal_color}比特币、以太币、莱特币...\${pink_color}).欢迎任何金额，无论金额多少 (1、2、5 ￥/\$/€) 。更多信息和直接链接: \${normal_color}\${urlgithub_wiki}/Contributing"

	arr["ENGLISH",438]="We are looking for translators to other languages. If you want to see airgeddon in your native language and you also know english, contact us. More information at: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["SPANISH",438]="Buscamos traductores para otros idiomas. Si quieres ver airgeddon en tu lengua materna y además sabes inglés, contáctanos. Más información en: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["FRENCH",438]="Nous recherchons des traducteurs pour d'autres langues. Si vous voulez voir airgeddon dans votre langue maternelle et que vous connaissez l'anglais contactez-nous: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["CATALAN",438]="Busquem traductors per a altres idiomes. Si vols veure airgeddon en la teva llengua materna i més saps anglès, contacta'ns. Més informació a: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["PORTUGUESE",438]="Procuramos tradutores para outros idiomas. Se você quiser ver airgeddon em sua língua nativa e também sabe inglês, por favor contacte-nos. Mais informações: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["RUSSIAN",438]="Мы ищем переводчиков на другие языки. Если вы хотите увидеть airgeddon на своем родном языке, и вы знаете английский язык, пожалуйста, свяжитесь с нами. Дополнительная информация: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["GREEK",438]="Ψάχνουμε μεταφραστές για την υποστήριξη περισσότερων γλωσσών. Αν θέλετε να χρησιμοποιείτε το airgeddon στη μητρική σας γλώσσα, αλλά ξέρετε και αγγλικά, παρακαλούμε επικοινωνήστε μαζί μας. Περισσότερες πληροφορίες: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["ITALIAN",438]="Cerchiamo traduttori per le altre lingue. Se volete vedere airgeddon nella vostra lingua madre e conoscete anche l'inglese, non esitate a contattarci. Per maggiori informazioni: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["POLISH",438]="Szukamy tłumaczy na inne języki. Jeśli chcesz zobaczyć airgeddon w swoim ojczystym języku i znasz angielski, skontaktuj się z nami. Więcej informacji: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["GERMAN",438]="Wir suchen Übersetzer für andere Sprachen. Wenn Sie airgeddon in Ihrer Muttersprache sehen möchten, kontaktieren Sie uns. Weitere Informationen unter: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["TURKISH",438]="Diğer dillere tercümanlar arıyoruz. Eğer kendi dilinizde airgeddon görmek ve ayrıca ingilizce bilmek isterseniz, bize ulaşın. Daha fazla bilgi için: \${normal_color}\${urlgithub_wiki}/Contributing"
	arr["ARABIC",438]="\${normal_color}\${urlgithub_wiki}/Contributing\${blue_color} :بلغتك الأم وتعرف اللغة الإنجليزية أيضًا ، فاتصل بنا. مزيد من المعلومات على airgeddon نحن نبحث عن مترجمين للغات أخرى. إذا كنت تريد أن ترى\${normal_color}"
	arr["CHINESE",438]="我们正在寻找其他语言的翻译。如果您想以您的母语使用 airgeddon，并且您也懂英语，请联系我们。更多信息在: \${normal_color}\${urlgithub_wiki}/Contributing"

	arr["ENGLISH",439]="\${blue_color}You haven't selected any target or your target is not valid, you'll be prompted to input data manually. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",439]="\${blue_color}Se ha detectado que no tienes seleccionado ningún objetivo o su objetivo no es válido, se le pedirá que ingrese los datos manualmente. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",439]="\${blue_color}Vous n'avez sélectionné aucune cible ou votre cible n'est pas valide, vous serez invité à introduire les données manuellement. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",439]="\${blue_color}No heu seleccionat cap objectiu o el vostre objectiu no és vàlid, se us demanarà que introduïu dades manualment. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",439]="\${blue_color}Você não selecionou nenhum alvo ou seu alvo não é válido, insira os dados manualmente. \${green_color}Deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",439]="\${blue_color}Вы не выбрали цель или ваша цель недействительна, Вам будет предложено ввести данные вручную. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",439]="\${blue_color}Δεν έχετε επιλέξει κανέναν στόχο ή ο στόχος σας δεν είναι έγκυρος, θα σας ζητηθεί να εισαγάγετε δεδομένα χειροκίνητα. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",439]="\${blue_color}Non hai selezionato nessun target o il tuo target non è valido, ti verrà richiesto di inserire i dati manualmente. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",439]="\${blue_color}Nie wybrałeś żadnego celu lub cel jest nieprawidłowy. Zostaniesz poproszony o ręczne wprowadzenie danych. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",439]="\${blue_color}Sie haben kein Ziel ausgewählt oder Ihr Ziel ist ungültig. Sie werden aufgefordert, Daten manuell einzugeben. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",439]="\${blue_color}Hiçbir hedef seçmediniz veya hedefiniz geçerli değil, verileri manuel olarak girmeniz istenecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",439]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟ \${blue_color}.لم تقم بتحديد أي هدف أو أن هدفك غير صالح، سيُطلب منك إدخال البيانات يدويًا\${normal_color}"
	arr["CHINESE",439]="\${blue_color}您尚未选择任何目标或您的目标无效，将提示您手动输入数据。 \${green_color}是否继续? \${normal_color}\${visual_choice}"

	arr["ENGLISH",440]="Aircrack trophy file generated successfully at [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["SPANISH",440]="Fichero de trofeo aircrack generado con éxito en [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["FRENCH",440]="Le fichier trophée aircrack a bien été crée dans [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["CATALAN",440]="Fitxer de trofeu aircrack generat amb èxit a [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["PORTUGUESE",440]="Arquivo de troféu aircrack gerado com sucesso [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["RUSSIAN",440]="Трофейный файл aircrack был успешно сгенерирован в [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["GREEK",440]="Το aircrack αρχείο τρόπαιο δημιουργήθηκε επιτυχώς [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["ITALIAN",440]="Il file trofeo di aircrack è stato generato con successo in [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["POLISH",440]="Plik trofeum aircrack został pomyślnie wygenerowany w [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["GERMAN",440]="Aircrack-Trophäendatei erfolgreich erstellt in [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["TURKISH",440]="Aircrack kupa dosyası başarıyla oluşturuldu [\${normal_color}\${aircrackpotenteredpath}\${blue_color}]"
	arr["ARABIC",440]="[\${normal_color}\${aircrackpotenteredpath}\${blue_color}] بنجاح في Aircrack trophy تم إنشاء ملف"
	arr["CHINESE",440]="在 [\${normal_color}\${aircrackpotenteredpath}\${blue_color}] 成功生成 Aircrack 密码文件"

	arr["ENGLISH",441]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${aircrack_potpath}]"
	arr["SPANISH",441]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${aircrack_potpath}]"
	arr["FRENCH",441]="Entrez le chemin où vous voulez enregistrer le fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${aircrack_potpath}]"
	arr["CATALAN",441]="Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${aircrack_potpath}]"
	arr["PORTUGUESE",441]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${aircrack_potpath}]"
	arr["RUSSIAN",441]="Напечатайте путь к сохранённому файлу или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${aircrack_potpath}]"
	arr["GREEK",441]="Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${aircrack_potpath}]"
	arr["ITALIAN",441]="Immettere il percorso dove memorizzare il file o premere [Enter] per accettare quello proposto di default \${normal_color}[\${aircrack_potpath}]"
	arr["POLISH",441]="Wpisz ścieżkę, w której będziemy zapisywać plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${aircrack_potpath}]"
	arr["GERMAN",441]="Schreiben Sie den Pfad, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag zu akzeptieren \${normal_color}[\${aircrack_potpath}]"
	arr["TURKISH",441]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${aircrack_potpath}]"
	arr["ARABIC",441]="\${normal_color}[\${aircrack_potpath}]\${green_color} لقبول الاقتراح [Enter] اكتب المسار لتخزين الملف أو اضغط على\${normal_color}"
	arr["CHINESE",441]="输入密码文件的存储路径或按 [Enter] 接受默认路径 \${normal_color}[\${aircrack_potpath}]"

	arr["ENGLISH",442]="If you install ccze you'll see some parts of airgeddon in a colorized way with better aspect. It's not a requirement or a dependency, but it will improve the user experience"
	arr["SPANISH",442]="Si instalas el paquete ccze podrás ver algunas partes de airgeddon colorizadas y con mejor aspecto. No es un requerimiento ni una dependencia, pero mejorará la experiencia de usuario"
	arr["FRENCH",442]="L'installation du paquet ccze améliore le rendu graphique d'airgeddon. Ce n'est pas un prérequis mais un petit plus pour rendre l’utilisation d'airgeddon plus agréable"
	arr["CATALAN",442]="Si instal·les el paquet ccze podràs veure algunes parts de airgeddon coloriçades i amb millor aspecte. No és un requeriment ni una dependència, però millorarà l'experiència d'usuari"
	arr["PORTUGUESE",442]="Se você instalar o pacote ccze poderá ver algumas partes do airgeddon coloridas e mais bonitas. Não é uma exigência nem uma dependência, mas melhora a experiência do usuário"
	arr["RUSSIAN",442]="Если вы установите ccze, то некоторые цветные элементы airgeddon будут выглядеть лучше. Это не требование или зависимость, но это улучшит работу пользователя"
	arr["GREEK",442]="Αν εγκαταστήσετε το ccze θα δείτε μερικά κομμάτια του airgeddon, πολύχρωμα με καλύτερη εμφάνιση. Δεν είναι απαραίτητο dependency, αλλά θα βελτιώσει την εμπειρία του χρήστη"
	arr["ITALIAN",442]="Se installi il pacchetto ccze vedrai alcune parti di airgeddon colorate e più belle. Non è un requisito né una dipendenza, ma migliorerà l'esperienza dell'utente"
	arr["POLISH",442]="Jeśli zainstalujesz pakiet ccze, zobaczysz niektóre części airgeddon kolorowe i lepiej wygladajce. Nie jest to wymóg ani zależność, ale poprawi to komfort użytkowania"
	arr["GERMAN",442]="Wenn Sie das ccze-Paket installieren, sehen Sie einige Teile von airgeddon gefärbt und besser aussehend. Es ist keine Voraussetzung oder eine Abhängigkeit, aber es wird die Benutzererfahrung verbessern"
	arr["TURKISH",442]="Eğer ccze'yi kurarsanız, daha iyi bir yönü olan renkli bir şekilde airgeddon'un bazı kısımlarını göreceksiniz. Bu bir gereksinim veya bağımlılık değil, ancak kullanıcı deneyimini geliştirecek"
	arr["ARABIC",442]="بطريقة ملونة مع جانب أفضل. انها ليست شرطا أو تبعية، ولكنها سوف تحسين تجربة المستخدم airgeddon فسترى بعض أجزاء ،ccze إذا قمت بتثبيت"
	arr["CHINESE",442]="如果你安装 ccze，你会看到 airgeddon 的某些部分以彩色的方式呈现更好的外观。这不是要求或依赖项，但会改善用户体验"

	arr["ENGLISH",443]="Options and language menu"
	arr["SPANISH",443]="Menú de opciones e idioma"
	arr["FRENCH",443]="Menu options et langues"
	arr["CATALAN",443]="Menú d'opcions i idioma"
	arr["PORTUGUESE",443]="Opções de menu e idioma"
	arr["RUSSIAN",443]="Настройки и языковое меню"
	arr["GREEK",443]="Μενού επιλογών και γλώσσας"
	arr["ITALIAN",443]="Menú opzioni e lingua"
	arr["POLISH",443]="Opcje i menu językowe"
	arr["GERMAN",443]="Optionen und Sprachmenü"
	arr["TURKISH",443]="Ayarlar ve dil menüsü"
	arr["ARABIC",443]="الخيارات وقائمة اللغة"
	arr["CHINESE",443]="脚本设置和语言菜单"

	arr["ENGLISH",444]="12. Options and language menu"
	arr["SPANISH",444]="12. Menú de opciones e idioma"
	arr["FRENCH",444]="12. Menu options et langues"
	arr["CATALAN",444]="12. Menú d'opcions i idioma"
	arr["PORTUGUESE",444]="12. Opções de menu e idioma"
	arr["RUSSIAN",444]="12. Настройки и языковое меню"
	arr["GREEK",444]="12. Μενού επιλογών και γλώσσας"
	arr["ITALIAN",444]="12. Menú opzioni e lingua"
	arr["POLISH",444]="12. Opcje i menu językowe"
	arr["GERMAN",444]="12. Optionen und Sprachmenü"
	arr["TURKISH",444]="12. Ayarlar ve dil menüsü"
	arr["ARABIC",444]="12. الخيارات وقائمة اللغة"
	arr["CHINESE",444]="12. 脚本设置和语言菜单"

	arr["ENGLISH",445]="If you have ccze installed and are experiencing display errors or glitches on some windows, you should disable extended colorization in the options and language menu"
	arr["SPANISH",445]="Si tienes instalado ccze y experimentas errores de visualización o parpadeos en algunas ventanas, desactiva la colorización extendida en el menú de opciones e idioma"
	arr["FRENCH",445]="Si ccze est installé et vous avez des erreurs de visualisation et de clignotement avec certaines fenêtres, désactivez la colorisation repandue vers le menu d'options et langues"
	arr["CATALAN",445]="Si tens instal·lat ccze i experimentes errors de visualització o parpelleigs en algunes finestres, desactiva la coloració estesa al menú d'opcions i idioma"
	arr["PORTUGUESE",445]="Se você tiver ccze instalado e estiver com erros de exibição ou com algumas janelas piscando, desative as cores estendidas em: Opções de menu e idioma"
	arr["RUSSIAN",445]="Если вы установили ccze и испытываете ошибки отображения или сбои в некоторых окнах, вы должны отключить расширенную раскраску в меню параметров и языков"
	arr["GREEK",445]="Εάν έχετε εγκαταστήσει ccze και αντιμετωπίζετε σφάλματα εμφάνισης ή δυσλειτουργίες σε ορισμένα παράθυρα, θα πρέπει να απενεργοποιήσετε το extended colorization στο μενού επιλογών και γλώσσας"
	arr["ITALIAN",445]="Se hai installato ccze e vedi errori o alcune finestre tremolanti, disattiva la colorazione estesa nel menú opzioni e lingua"
	arr["POLISH",445]="Jeśli zainstalowano ccze i wystąpiły błędy wizualizacji lub migotania w niektórych oknach, powinieneś wyłączyć rozszerzone kolory w menu opcji i języka"
	arr["GERMAN",445]="Wenn Sie ccze installiert haben und in einigen Fenstern Anzeigefehler oder Flimmern auftreten, deaktivieren Sie die erweiterte Einfärbung im Einstellung- und Sprachmenü"
	arr["TURKISH",445]="Eğer ccze kuruluysa ve bazı pencerelerde görüntü hataları veya hatalar yaşıyorsanız, seçenek ve dil menüsünde genişletilmiş renklendirmeyi devre dışı bırakmalısınız"
	arr["ARABIC",445]="ولديك أخطاء في العرض والوميض في بعض النوافذ ، فقم بإيقاف تشغيل التلوين الشائع في قائمة الخيارات واللغات ccze إذا تم تثبيت"
	arr["CHINESE",445]="如果您安装了 ccze 软件包并且在某些窗口中遇到显示错误或故障，那么您应该在选项和语言菜单中禁用扩展着色"

	arr["ENGLISH",446]="0.  Return to options menu"
	arr["SPANISH",446]="0.  Volver al menú de opciones"
	arr["FRENCH",446]="0.  Retourner au menu options"
	arr["CATALAN",446]="0.  Tornar al menú d'opcions"
	arr["PORTUGUESE",446]="0.  Voltar ao menu de opções"
	arr["RUSSIAN",446]="0.  Возврат в меню опций"
	arr["GREEK",446]="0.  Επιστροφή στο μενού επιλογών"
	arr["ITALIAN",446]="0.  Tornare al menú delle opzioni"
	arr["POLISH",446]="0.  Wróć do menu opcji"
	arr["GERMAN",446]="0.  Zum Optionsmenü zurückkehren"
	arr["TURKISH",446]="0.  Ayarlar menüsüne geri dön"
	arr["ARABIC",446]="0.  العودة إلى قائمة الخيارات"
	arr["CHINESE",446]="0.  返回选项菜单"

	arr["ENGLISH",447]="14. Set permanently airgeddon's language to the current one"
	arr["SPANISH",447]="14. Cambiar permanentemente el idioma de airgeddon al actual"
	arr["FRENCH",447]="14. Etablir comme langue permanente d'airgeddon celle utilisée actuellement"
	arr["CATALAN",447]="14. Canviar permanentment l'idioma de airgeddon a l'actual"
	arr["PORTUGUESE",447]="14. Alterar permanentemente o idioma do airgeddon para o atual"
	arr["RUSSIAN",447]="14. Сделать текущий язык airgeddon постоянным"
	arr["GREEK",447]="14. Θέστε μόνιμα την τρέχουσα γλώσσα του airgeddon ως προεπιλεγμένη"
	arr["ITALIAN",447]="14. Modificare in modo permanente la lingua di airgeddon a quella attuale"
	arr["POLISH",447]="14. Trwale ustaw język airgeddon na aktualny"
	arr["GERMAN",447]="14. Ändern Sie dauerhaft die Sprache von airgeddon zur aktuellen Sprache"
	arr["TURKISH",447]="14. Sürekli olarak airgeddon'un dilini geçerli olana ayarla"
	arr["ARABIC",447]="14. بشكل دائم على اللغة الحالية airgeddon اضبط لغة"
	arr["CHINESE",447]="14. 永久设置 airgeddon 的语言为当前语言"

	arr["ENGLISH",448]="If you installed airgeddon from a repository, you should not enable automatic updates. airgeddon will be updated when there is a new version in the repository"
	arr["SPANISH",448]="Si instalaste airgeddon desde un repositorio, no deberías activar la actualización automática. airgeddon se actualizará cuando haya una nueva versión en el repositorio"
	arr["FRENCH",448]="Si vous avez installé airgeddon depuis des dêpots vous devriez ne pas activer les mises à jour automatiques. airgeddon sera mis à jour quand une nouvelle version sera disponible dans vos dépôts"
	arr["CATALAN",448]="Si vas instal·lar airgeddon des d'un repositori, no hauries d'activar l'actualització automàtica. airgeddon s'actualitzarà quan hi hagi una nova versió al repositori"
	arr["PORTUGUESE",448]="Se você instalou airgeddon partir de um repositório, você não deve ativar a atualização automática. airgeddon será atualizado quando houver nova versão no repositório"
	arr["RUSSIAN",448]="Если вы установили airgeddon из репозитория, вам не следует включать автоматические обновления. airgeddon будет обновляться, когда в репозитории будет новая версия"
	arr["GREEK",448]="Αν εγκαταστήσατε το airgeddon από κάποιο επίσημο αποθετήριο, δεν θα πρέπει να ενεργοποιήσετε τις αυτόματες ενημερώσεις. Το airgeddon θα ενημερωθεί όταν υπάρξει κάποια νέα έκδοση στο επίσημο αποθετήριο"
	arr["ITALIAN",448]="Se è stato installato airgeddon da un repository, non si dovrebbe attivare l'aggiornamento automatico. airgeddon sará aggiornato quando ci sará una nuova versione nel repository"
	arr["POLISH",448]="Jeśli zainstalowano airgeddon z repozytorium, nie należy włączać automatycznej aktualizacji. airgeddon zostanie zaktualizowany, gdy w repozytorium znajduje się nowa wersja"
	arr["GERMAN",448]="Wenn Sie airgeddon aus einem Repository installiert haben, sollten Sie das automatische Update nicht aktivieren. airgeddon wird aktualisiert, wenn eine neue Version im Repository vorhanden ist"
	arr["TURKISH",448]="Bir depodan airgeddon'u yüklediyseniz, otomatik güncellemeleri etkinleştirmemelisiniz. depoda yeni bir sürüm olduğunda airgeddon güncellenecektir"
	arr["ARABIC",448]="عند توفر إصدار جديد في مستودعاتك airgeddon من المستودعات ، فلا يجب عليك تفعيل التحديثات التلقائية. سيتم تحديث airgeddon إذا قمت بتثبيت"
	arr["CHINESE",448]="如果您从软件源安装了 airgeddon，则不应启用自动更新。airgeddon 将在软件包有新版本时随其他软件包一同更新"

	arr["ENGLISH",449]="2.  Enable automatic updates permanently"
	arr["SPANISH",449]="2.  Habilitar permanentemente la actualización automática"
	arr["FRENCH",449]="2.  Activer de façon permanante la mise à jour automatique"
	arr["CATALAN",449]="2.  Habilita permanentment l'actualització automàtica"
	arr["PORTUGUESE",449]="2.  Ativar permanentemente a atualização automática"
	arr["RUSSIAN",449]="2.  Включение постоянных автоматических обновлений"
	arr["GREEK",449]="2.  Ενεργοποιήστε μόνιμα τις αυτόματες ενημερώσεις"
	arr["ITALIAN",449]="2.  Attivare permanentemente l'aggiornamento automatico"
	arr["POLISH",449]="2.  Trwale włącz automatyczną aktualizację"
	arr["GERMAN",449]="2.  Aktivieren Sie die automatische Aktualisierung dauerhaft"
	arr["TURKISH",449]="2.  Otomatik güncellemeleri kalıcı olarak etkinleştir"
	arr["ARABIC",449]="2.  تفعيل التحديث التلقائي بشكل دائم"
	arr["CHINESE",449]="2.  永久启用自动更新"

	arr["ENGLISH",450]="5.  Enable extended colorization permanently"
	arr["SPANISH",450]="5.  Habilitar permanentemente la colorización extendida"
	arr["FRENCH",450]="5.  Activer en permanence la colorisation étendue"
	arr["CATALAN",450]="5.  Habilita permanentment la coloració estesa"
	arr["PORTUGUESE",450]="5.  Ativar permanentemente as cores estendidas"
	arr["RUSSIAN",450]="5.  Включить расширенную раскраску навсегда"
	arr["GREEK",450]="5.  Ενεργοποιήστε το extended colorization μόνιμα"
	arr["ITALIAN",450]="5.  Attivare permanentemente la colorazione estesa"
	arr["POLISH",450]="5.  Trwale włącz rozszerzone kolorowanie"
	arr["GERMAN",450]="5.  Die erweiterte Einfärbung dauerhaft aktivieren"
	arr["TURKISH",450]="5.  Geliştirilmiş renklendirmeyi kalıcı olarak etkinleştir"
	arr["ARABIC",450]="5.  تفعيل التلوين الممتد بشكل دائم"
	arr["CHINESE",450]="5.  永久启用扩展着色"

	arr["ENGLISH",451]="Automatic updates: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",451]="Actualizaciones automáticas: \${pink_color}Activadas\${normal_color}"
	arr["FRENCH",451]="Mises à jour automatiques: \${pink_color}Activées\${normal_color}"
	arr["CATALAN",451]="Actualitzacions automàtiques: \${pink_color}Activades\${normal_color}"
	arr["PORTUGUESE",451]="Atualizações automáticas: \${pink_color}Ativa\${normal_color}"
	arr["RUSSIAN",451]="Автоматическое обновление: \${pink_color}Включено\${normal_color}"
	arr["GREEK",451]="Αυτόματη ενημέρωση: \${pink_color}Ενεργοποιημένο\${normal_color}"
	arr["ITALIAN",451]="Aggiornamenti automatici: \${pink_color}Attivati\${normal_color}"
	arr["POLISH",451]="Aktualizacje automatyczne: \${pink_color}Włączone\${normal_color}"
	arr["GERMAN",451]="Automatische Updates: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",451]="Otomatik güncellemeler: \${pink_color}Etkin\${normal_color}"
	arr["ARABIC",451]="\${pink_color}مفعلة\${blue_color} :التحديثات التلقائية\${normal_color}"
	arr["CHINESE",451]="自动更新: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",452]="Automatic updates: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",452]="Actualizaciones automáticas: \${pink_color}Desactivadas\${normal_color}"
	arr["FRENCH",452]="Mises à jour automatiques: \${pink_color}Désactivées\${normal_color}"
	arr["CATALAN",452]="Actualitzacions automàtiques: \${pink_color}Desactivades\${normal_color}"
	arr["PORTUGUESE",452]="Atualizações automáticas: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",452]="Автоматическое обновление: \${pink_color}Отключено\${normal_color}"
	arr["GREEK",452]="Αυτόματη ενημέρωση: \${pink_color}Απενεργοποιημένο\${normal_color}"
	arr["ITALIAN",452]="Aggiornamenti automatici: \${pink_color}Disattivati\${normal_color}"
	arr["POLISH",452]="Aktualizacje automatyczne: \${pink_color}Wyłączone\${normal_color}"
	arr["GERMAN",452]="Automatische Updates: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",452]="Otomatik güncellemeler: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",452]="\${pink_color}معطلة\${blue_color} :التحديثات التلقائية\${normal_color}"
	arr["CHINESE",452]="自动更新: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",453]="Extended colorization: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",453]="Colorización extendida: \${pink_color}Activada\${normal_color}"
	arr["FRENCH",453]="Colorisation répandue: \${pink_color}Activée\${normal_color}"
	arr["CATALAN",453]="Coloració estesa: \${pink_color}Activada\${normal_color}"
	arr["PORTUGUESE",453]="Cores estendidas: \${pink_color}Ativa\${normal_color}"
	arr["RUSSIAN",453]="Расширенная раскраска: \${pink_color}Включена\${normal_color}"
	arr["GREEK",453]="Extended colorization: \${pink_color}Ενεργοποιημένο\${normal_color}"
	arr["ITALIAN",453]="Colorazione estesa: \${pink_color}Attivata\${normal_color}"
	arr["POLISH",453]="Rozszerzone kolorowanie: \${pink_color}Włączone\${normal_color}"
	arr["GERMAN",453]="Erweiterte Einfärbung: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",453]="Geliştirilmiş renklendirme: \${pink_color}Etkin\${normal_color}"
	arr["ARABIC",453]="\${pink_color}مفعل\${blue_color} :التلوين الممتد\${normal_color}"
	arr["CHINESE",453]="扩展着色: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",454]="Extended colorization: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",454]="Colorización extendida: \${pink_color}Desactivada\${normal_color}"
	arr["FRENCH",454]="Colorisation répandue: \${pink_color}Désactivée\${normal_color}"
	arr["CATALAN",454]="Coloració estesa: \${pink_color}Desactivada\${normal_color}"
	arr["PORTUGUESE",454]="Cores estendidas: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",454]="Расширенная раскраска: \${pink_color}Отключена\${normal_color}"
	arr["GREEK",454]="Extended colorization: \${pink_color}Απενεργοποιημένο\${normal_color}"
	arr["ITALIAN",454]="Colorazione estesa: \${pink_color}Disattivata\${normal_color}"
	arr["POLISH",454]="Rozszerzone kolorowanie: \${pink_color}Wyłączone\${normal_color}"
	arr["GERMAN",454]="Erweiterte Einfärbung: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",454]="Geliştirilmiş renklendirme: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",454]="\${pink_color}معطل\${blue_color} :التلوين الممتد\${normal_color}"
	arr["CHINESE",454]="扩展着色: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",455]="2.  Disable automatic updates permanently"
	arr["SPANISH",455]="2.  Deshabilitar permanentemente la actualización automática"
	arr["FRENCH",455]="2.  Désactiver de façon permanante les mises à jour automatiques"
	arr["CATALAN",455]="2.  Deshabilita permanentment l'actualització automàtica"
	arr["PORTUGUESE",455]="2.  Desativar permanentemente a atualização automática"
	arr["RUSSIAN",455]="2.  Отключить постоянные автоматические обновления"
	arr["GREEK",455]="2.  Απενεργοποιήστε μόνιμα τις αυτόματες ενημερώσεις"
	arr["ITALIAN",455]="2.  Disattivare permanentemente gli aggiornamenti automatici"
	arr["POLISH",455]="2.  Trwale wyłącz automatyczną aktualizację"
	arr["GERMAN",455]="2.  Automatische Updates dauerhaft deaktivieren"
	arr["TURKISH",455]="2.  Otomatik güncellemeleri kalıcı olarak devre dışı bırak"
	arr["ARABIC",455]="2.  تعطيل التحديثات التلقائية بشكل دائم"
	arr["CHINESE",455]="2.  永久禁用自动更新"

	arr["ENGLISH",456]="5.  Disable extended colorization permanently"
	arr["SPANISH",456]="5.  Deshabilitar permanentemente la colorización extendida"
	arr["FRENCH",456]="5.  Désactiver en permanence la colorisation répandue"
	arr["CATALAN",456]="5.  Deshabilita permanentment la coloració estesa"
	arr["PORTUGUESE",456]="5.  Desativar permanentemente as cores estendidas"
	arr["RUSSIAN",456]="5.  Отключать расширенную раскраску на постоянной основе"
	arr["GREEK",456]="5.  Απενεργοποιήστε το extended colorization μόνιμα"
	arr["ITALIAN",456]="5.  Disattivare permanentemente la colorazione estesa"
	arr["POLISH",456]="5.  Trwale wyłącz rozszerzone kolorowanie"
	arr["GERMAN",456]="5.  Erweiterte Einfärbung dauerhaft deaktivieren"
	arr["TURKISH",456]="5.  Geliştirilmiş renklendirmeyi kalıcı olarak devre dışı bırak"
	arr["ARABIC",456]="5.  تعطيل التحديثات التلقائية بشكل دائم"
	arr["CHINESE",456]="5.  永久禁用扩展着色"

	arr["ENGLISH",457]="\${blue_color}Automatic updates are going to be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",457]="\${blue_color}Se van a desactivar las actualizaciones automáticas. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",457]="\${blue_color}Désactivation des mises à jour automatiques. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",457]="\${blue_color}Es van a desactivar les actualitzacions automàtiques. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",457]="\${blue_color}As atualizações automáticas serão desabilitadas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",457]="\${blue_color}Автоматические обновления будут отключены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",457]="\${blue_color}Οι αυτόματες ενημερώσεις πρόκειται να απενεργοποιηθούν. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",457]="\${blue_color}Si stano per disattivare gli aggiornamenti automatici. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",457]="\${blue_color}Aktualizacje automatyczne zostaną wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",457]="\${blue_color}Automatische Updates werden deaktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",457]="\${blue_color}Otomatik güncellemeler devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",457]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تعطيل التحديثات التلقائية\${normal_color}"
	arr["CHINESE",457]="\${blue_color}自动更新将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",458]="\${blue_color}Automatic updates are going to be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",458]="\${blue_color}Se van a activar las actualizaciones automáticas. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",458]="\${blue_color}Activation des mises à jour automatiques. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",458]="\${blue_color}Es van a activar les actualitzacions automàtiques. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",458]="\${blue_color}As atualizações automáticas serão ativadas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",458]="\${blue_color}Автоматические обновления будут включены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",458]="\${blue_color}Οι αυτόματες ενημερώσεις πρόκειται να ενεργοποιηθούν. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",458]="\${blue_color}Si stanno per attivare gli aggiornamenti automatici. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",458]="\${blue_color}Automatyczne aktualizacje będą włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",458]="\${blue_color}Automatische Updates werden aktiviert. \${green_color} Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",458]="\${blue_color}Otomatik güncellemeler etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",458]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل التحديثات التلقائية\${normal_color}"
	arr["CHINESE",458]="\${blue_color}自动更新将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",459]="If you installed airgeddon from a repository you shouldn't enable this option. airgeddon will be updated when the repositories do. If you continue, make sure you know what you are doing, or you could cause problems with update flow"
	arr["SPANISH",459]="Si instalaste airgeddon desde un repositorio no deberías activar esta opción. airgeddon se actualizará cuando lo hagan los repositorios. Si continuas, asegúrate de saber bien lo que haces o podrías causar problemas con flujo de actualizaciones"
	arr["FRENCH",459]="Si airgeddon a été installé depuis des dépôts vous devriez ne pas activer cette option. airgeddon sera mis à jour automatiquement en passant par vos dépôts. Si vous décidez de continuer soyez conscient du fait que vous pourriez générer ainsi des conflits lors de futures actualisations système"
	arr["CATALAN",459]="Si vas instal·lar airgeddon des d'un repositori no hauries d'activar aquesta opció. airgeddon s'actualitzarà quan ho facin els repositoris. Si continues, assegura't de saber bé el que fas o podries causar problemes amb flux d'actualitzacions"
	arr["PORTUGUESE",459]="Se você instalou airgeddon a partir de um repositório você não deve ativar essa opção. airgeddon será atualizado quando você estiver disponível nos repositórios. Se você continuar, verifique se você sabe o que está fazendo ou ou você pode causar problemas com o fluxo de atualização"
	arr["RUSSIAN",459]="Если вы установили airgeddon из репозитория, вы не должны включать эту опцию. airgeddon будет обновляться вместе с репозиториями. Если вы продолжите, убедитесь, что знаете, что делаете, или ваши действия могут вызвать проблемы для этой программы"
	arr["GREEK",459]="Εάν εγκαταστήσατε το airgeddon από κάποιο επίσημο αποθετήριο, δεν πρέπει να ενεργοποιήσετε αυτή την επιλογή. Το airgeddon θα ενημερωθεί όταν ενημερωθούν και τα αποθετήρια. Αν συνεχίσετε, βεβαιωθείτε ότι γνωρίζετε τι κάνετε και ότι θα μπορεί να προκαλέσετε προβλήματα με τη ροή ενημέρωσης"
	arr["ITALIAN",459]="Se airgeddon è stato installato da un repository non si dovrebbe attivare questa opzione. airgeddon sará aggiornato quando lo faranno i repository. Se continui, assicurati di sapere bene quello che fai o potrebbe causare problemi al flusso degli aggiornamenti"
	arr["POLISH",459]="Jeśli zainstalowano airgeddon z repozytorium, nie należy włączać tej opcji. airgeddon zostanie zaktualizowany, gdy w repozytorium pojawi się nowa wersja. Jeśli kontynuujesz, upewnij się, że wiesz co robisz, bo to może spowodować problemy z aktualizacją"
	arr["GERMAN",459]="Wenn Sie airgeddon aus einem Repository installiert haben, sollten Sie diese Option nicht aktivieren. airgeddon wird aktualisiert, wenn die Repositories dies tun. Wenn Sie fortfahren, vergewissern Sie sich, dass Sie wissen, was Sie tun. Probleme können erscheinen"
	arr["TURKISH",459]="Bir depodan airgeddon'u yüklediyseniz, bu seçeneği etkinleştirmemelisiniz. Havuzlar yapıldığı zaman airgeddon güncellenecektir. Devam ederseniz, ne yaptığınızı bildiğinizden emin olun, ya da güncelleme akışında sorunlara neden olabilirsiniz"
	arr["ARABIC",459]="عندما يتم تحديث المستودعات. إذا تابعت ، فتأكد من معرفتك بما تفعله ، وإلا فقد تتسبب في حدوث مشاكل في التحديث airgeddon من مستودع ، فلا يجب عليك تفعيل هذا الخيار. سيتم تحديث airgeddon إذا قمت بتثبيت"
	arr["CHINESE",459]="如果您从软件源安装了 airgeddon，则不应启用自动更新。airgeddon 将在软件包有新版本时随其他软件包一同更新。如果继续，请确保您知道自己在做什么，否则可能会导致软件包的更新流程出现问题"

	arr["ENGLISH",460]="Automatic updates have been enabled"
	arr["SPANISH",460]="Se han activado las actualizaciones automáticas"
	arr["FRENCH",460]="Mises à jour automatiques activées"
	arr["CATALAN",460]="S'han activat les actualitzacions automàtiques"
	arr["PORTUGUESE",460]="As atualizações automáticas foram ativadas"
	arr["RUSSIAN",460]="Автоматические обновления включены"
	arr["GREEK",460]="Οι αυτόματες ενημερώσεις έχουν ενεργοποιηθεί"
	arr["ITALIAN",460]="Sono stati attivati gli aggiornamenti automatici"
	arr["POLISH",460]="Automatyczne aktualizacje zostały włączone"
	arr["GERMAN",460]="Automatische Updates wurden aktiviert"
	arr["TURKISH",460]="Otomatik güncellemeler etkinleştirildi"
	arr["ARABIC",460]="تم تفعيل التحديثات التلقائية"
	arr["CHINESE",460]="已启用自动更新"

	arr["ENGLISH",461]="Automatic updates have been disabled"
	arr["SPANISH",461]="Se han desactivado las actualizaciones automáticas"
	arr["FRENCH",461]="Mises à jour automatiques désactivées"
	arr["CATALAN",461]="S'han desactivat les actualitzacions automàtiques"
	arr["PORTUGUESE",461]="As atualizações automáticas foram desativadas"
	arr["RUSSIAN",461]="Автоматические обновления отключены"
	arr["GREEK",461]="Οι αυτόματες ενημερώσεις έχουν απενεργοποιηθεί"
	arr["ITALIAN",461]="Sono stati disattivati gli aggiornamenti automatici"
	arr["POLISH",461]="Automatyczne aktualizacje zostały wyłączone"
	arr["GERMAN",461]="Automatische Updates wurden deaktiviert"
	arr["TURKISH",461]="Otomatik güncellemeler devre dışı bırakıldı"
	arr["ARABIC",461]="تم تعطيل التحديثات التلقائية"
	arr["CHINESE",461]="自动更新已被禁用"

	arr["ENGLISH",462]="\${blue_color}Extended colorization is going to be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",462]="\${blue_color}Se va a desactivar la colorización extendida. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",462]="\${blue_color}On va désactiver la colorisation répandue. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",462]="\${blue_color}Es va a desactivar le coloració estesa. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",462]="\${blue_color}As cores estendidas serão desativadas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",462]="\${blue_color}Расширенная раскраска будет отключена. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",462]="\${blue_color}Το extended colorization θα ενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",462]="\${blue_color}La colorazione estesa sará disattivata. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",462]="\${blue_color}Rozszerzone kolorowanie zostanie wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",462]="\${blue_color}Erweiterte Einfärbung wird deaktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",462]="\${blue_color}Geliştirilmiş renklendirme devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",462]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟ \${blue_color}.سيتم تعطيل التلوين الممتد\${normal_color}"
	arr["CHINESE",462]="\${blue_color}扩展着色将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",463]="\${blue_color}Extended colorization is going to be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",463]="\${blue_color}Se va a activar la colorización extendida. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",463]="\${blue_color}On va activer la colorisation répandue. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",463]="\${blue_color}Es va a activar la coloració estesa. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",463]="\${blue_color}As cores estendidas serão ativadas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",463]="\${blue_color}Расширенная раскраска будет включена. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",463]="\${blue_color}Το extended colorization θα ενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",463]="\${blue_color}La colorazione estesa sará attivata. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",463]="\${blue_color}Rozszerzone kolorowanie zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",463]="\${blue_color}Erweiterte Einfärbung wird aktiviert. \${green_color}Wollen Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",463]="\${blue_color}Geliştirilmiş renklendirme etkinleştirilecektir. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",463]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟ \${blue_color}.سيتم تفعيل التلوين الممتد\${normal_color}"
	arr["CHINESE",463]="\${blue_color}扩展着色将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",464]="You don't have the ccze package installed so any change on this option will have no effect until you install it"
	arr["SPANISH",464]="No tienes instalado el paquete ccze por lo que cualquier cambio que realices sobre esta opción no tendrá efecto hasta que lo instales"
	arr["FRENCH",464]="Ccze n'est pas installé, les paramétrages effectués avec cette option seront effectifs une fois czze installé"
	arr["CATALAN",464]="No tens instal·lat el paquet ccze pel que qualsevol canvi que facis sobre aquesta opció no tindrà efecte fins que el instal·lis"
	arr["PORTUGUESE",464]="Você não tem o pacote ccze instalado, qualquer alterações feita nesta opção não terá efeito até que você instale-o"
	arr["RUSSIAN",464]="У вас не установлен пакет ccze, поэтому любое изменение этой опции не будет иметь никакого эффекта, пока вы его не установите"
	arr["GREEK",464]="Δεν έχετε εγκατεστημένο το πακέτο ccze, οπότε οποιαδήποτε αλλαγή σε αυτήν την επιλογή δεν θα έχει αποτέλεσμα μέχρι να το εγκαταστήσετε"
	arr["ITALIAN",464]="Non è stato installato il pacchetto ccze per cui tutte le modifiche apportate su questa opzione non avranno alcun effetto finché non si installa"
	arr["POLISH",464]="Nie masz zainstalowanego pakietu ccze, więc wszelkie zmiany wprowadzone w tej opcji nie będą obowiązywać dopóki nie zostanie zainstalowany"
	arr["GERMAN",464]="Sie haben das ccze-Paket nicht installiert, sodass Änderungen, die Sie an dieser Option vornehmen, erst nach der Installation wirksam werden"
	arr["TURKISH",464]="Ccze paketinin yüklü olmaması, bu seçenek üzerinde herhangi bir değişikliğin kuruluncaya kadar hiçbir etkisi olmayacaktır"
	arr["ARABIC",464]="لذا لن يكون لأي تغيير في هذا الخيار أي تأثير حتى تقوم بتثبيته ،ccze لم يتم تثبيت حزمة"
	arr["CHINESE",464]="您没有安装 ccze 包，因此在您安装它之前对此选项的任何更改都不会生效"

	arr["ENGLISH",465]="Extended colorization has been enabled"
	arr["SPANISH",465]="Se ha activado la colorización extendida"
	arr["FRENCH",465]="Colorisation répandue activée"
	arr["CATALAN",465]="S'ha activat la coloració estesa"
	arr["PORTUGUESE",465]="As cores estendidas estendidas foram ativas"
	arr["RUSSIAN",465]="Расширенная раскраска включена"
	arr["GREEK",465]="Έχει ενεργοποιηθεί το extended colorization"
	arr["ITALIAN",465]="La colorazione estesa è stata attivata"
	arr["POLISH",465]="Rozszerzone kolorowanie zostało aktywowane"
	arr["GERMAN",465]="Erweiterte Einfärbung wurde aktiviert"
	arr["TURKISH",465]="Geliştirilmiş renklendirme etkinleştirildi"
	arr["ARABIC",465]="تم تفعيل التلوين الممتد"
	arr["CHINESE",465]="已启用扩展着色"

	arr["ENGLISH",466]="Extended colorization has been disabled"
	arr["SPANISH",466]="Se ha desactivado la colorización extendida"
	arr["FRENCH",466]="Colorisation répandue désactivée"
	arr["CATALAN",466]="S'ha desactivat la coloració estesa"
	arr["PORTUGUESE",466]="As cores estendidas estendidas foram desativadas"
	arr["RUSSIAN",466]="Расширенная раскраска отключена"
	arr["GREEK",466]="Το extended colorization έχει απενεργοποιηθεί"
	arr["ITALIAN",466]="La colorazione estesa è stata disattivata"
	arr["POLISH",466]="Rozszerzone kolorowanie zostało wyłączone"
	arr["GERMAN",466]="Erweiterte Einfärbung wurde deaktiviert"
	arr["TURKISH",466]="Geliştirilmiş renklendirme devre dışı bırakıldı"
	arr["ARABIC",466]="تم تعطيل التلوين الممتد"
	arr["CHINESE",466]="扩展着色已被禁用"

	arr["ENGLISH",467]="6.  Enable startup language autodetection permanently"
	arr["SPANISH",467]="6.  Habilitar permanentemente la autodetección de idioma al inicio"
	arr["FRENCH",467]="6.  Activer de façon permanente la détection de langue au lancement"
	arr["CATALAN",467]="6.  Habilitar permanentment l'autodetecció d'idioma a l'inici"
	arr["PORTUGUESE",467]="6.  Ativar permanentemente a detecção do idioma no início"
	arr["RUSSIAN",467]="6.  Автоматическое определение языка постоянно отключено"
	arr["GREEK",467]="6.  Ενεργοποίηση του αυτόματου εντοπισμού γλώσσας κατά την εκκίνηση μόνιμα"
	arr["ITALIAN",467]="6.  Attivare permanentemente il rilevamento automatico della lingua all'inizio"
	arr["POLISH",467]="6.  Trwale włącz automatyczne wykrywanie języka podczas uruchamiania"
	arr["GERMAN",467]="6.  Automatische Spracherkennung beim Start dauerhaft aktivieren"
	arr["TURKISH",467]="6.  Başlangıç dilini otomatik algılama özelliğini kalıcı olarak etkinleştir"
	arr["ARABIC",467]="6.  قم بتفعيل الاكتشاف التلقائي للغة عند بدء التشغيل بشكل دائم"
	arr["CHINESE",467]="6.  永久启用脚本语言自动检测"

	arr["ENGLISH",468]="6.  Disable startup language autodetection permanently"
	arr["SPANISH",468]="6.  Deshabilitar permanentemente la autodetección de idioma al inicio"
	arr["FRENCH",468]="6.  Désactiver de façon permanente la détection de langue au lancement"
	arr["CATALAN",468]="6.  Deshabilitar permanentment l'autodetecció d'idioma a l'inici"
	arr["PORTUGUESE",468]="6.  Desativar permanentemente a detecção do idioma no início"
	arr["RUSSIAN",468]="6.  Постоянное отключение автоматического определения языка"
	arr["GREEK",468]="6.  Απενεργοποίηση του αυτόματου εντοπισμού γλώσσας κατά την εκκίνηση μόνιμα"
	arr["ITALIAN",468]="6.  Disattivare permanentemente il rilevamento automatico della lingua all'inizio"
	arr["POLISH",468]="6.  Trwale wyłącz autodetekcję języka podczas uruchamiania"
	arr["GERMAN",468]="6.  Automatische Spracherkennung beim Start dauerhaft deaktivieren"
	arr["TURKISH",468]="6.  Başlangıç dili otomatik algılamayı kalıcı olarak devre dışı bırak"
	arr["ARABIC",468]="6.  تعطيل الاكتشاف التلقائي للغة عند بدء التشغيل بشكل دائم"
	arr["CHINESE",468]="6.  永久禁用脚本语言自动检测"

	arr["ENGLISH",469]="\${blue_color}Startup language autodetection will be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",469]="\${blue_color}Se va a deshabilitar la autodetección de idioma al inicio. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",469]="\${blue_color}Désactivation détection langue au lancement. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",469]="\${blue_color}Es va a desactivar la detecció automàtica d'idioma a l'inici. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",469]="\${blue_color}A detecção automática do idioma será desativada. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",469]="\${blue_color}Автоопределение языка при запуске будет отключено. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",469]="\${blue_color}Ο αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση θα απενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",469]="\${blue_color}Si sta per disattivare il rilevamento automatico della lingua all'inizio \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",469]="\${blue_color}Autodetekcja języka zostanie wyłączona podczas uruchamiania. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",469]="\${blue_color}Die automatische Spracherkennung am Anfang wird deaktiviert. \${green_color}Wollen Sie weitermachen? \${normal_color}\${visual_choice}"
	arr["TURKISH",469]="\${blue_color}Başlangıç dili otomatik algılama devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",469]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟ \${blue_color}.سيتم تعطيل الاكتشاف التلقائي للغة عند بدء التشغيل\${normal_color}"
	arr["CHINESE",469]="\${blue_color}脚本语言自动检测将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",470]="\${blue_color}Startup language autodetection will be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",470]="\${blue_color}Se va a habilitar la autodetección de idioma al inicio. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",470]="\${blue_color}Activation détection langue au lancement. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",470]="\${blue_color}Es va a habilitar la detecció automàtica d'idioma a l'inici. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",470]="\${blue_color}A detecção automática do idioma será ativada. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",470]="\${blue_color} Автоопределение языка при запуске будет включено. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",470]="\${blue_color}Ο αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση θα ενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",470]="\${blue_color}Si sta per attivare il rilevamento automatico della lingua all'inizio. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",470]="\${blue_color}Autodetekcja języka podczas uruchamiania zostanie włączona. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",470]="\${blue_color}Die automatische Spracherkennung wird zu Beginn aktiviert. \${green_color}Wollen Sie weitermachen? \${normal_color}\${visual_choice}"
	arr["TURKISH",470]="\${blue_color}Başlangıç dili otomatik algılama etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",470]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل الاكتشاف التلقائي للغة عند بدء التشغيل\${normal_color}"
	arr["CHINESE",470]="\${blue_color}脚本语言自动检测将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",471]="Any permanent change of language you have will be lost on the next start if you enable this option!!"
	arr["SPANISH",471]="Cualquier cambio permanente de idioma que tenga se perderá en el siguiente inicio si activa esta opción!!"
	arr["FRENCH",471]="Les configurations permanentes de langue seront perdues au prochain démarrage si vous choisssez cette option!!"
	arr["CATALAN",471]="Qualsevol canvi permanent d'idioma que tinguis es perdrà en el següent inici si actives aquesta opció!!"
	arr["PORTUGUESE",471]="Qualquer alteração no idioma será perdida no próximo inicio se você habilitar esta opção!!"
	arr["RUSSIAN",471]="При включении этой опции, сделанный выбор по изменению языка будет потерян при следующем запуске!!"
	arr["GREEK",471]="Οποιαδήποτε μόνιμη αλλαγή της γλώσσας θα χαθεί κατά την επόμενη εκκίνηση, αν ενεργοποιήσετε αυτή την επιλογή!!"
	arr["ITALIAN",471]="Qualsiasi cambio permanente di lingua si perderá nel prossimo inizio se si attiva questa opzione!!"
	arr["POLISH",471]="Każda trwała zmiana języka zostanie utracona podczas następnego startu, jeśli aktywujesz tę opcję!!"
	arr["GERMAN",471]="Jeder permanente Sprachwechsel, den Sie haben, wird beim nächsten Start verloren gehen, wenn Sie diese Option aktivieren!!"
	arr["TURKISH",471]="Bu seçeneği etkinleştirirseniz, bir sonraki başlangıçta herhangi bir kalıcı dil değişikliği kaybolur!!"
	arr["ARABIC",471]="!!سيتم فقدان أي تغيير دائم للغة لديك عند البداية الموالية إذا قمت بتفعيل هذا الخيار"
	arr["CHINESE",471]="如果启用此选项，您任何对语言的更改都将在下次启动时丢失！！"

	arr["ENGLISH",472]="Startup language autodetection has been enabled"
	arr["SPANISH",472]="Se ha activado la autodetección de idioma al inicio"
	arr["FRENCH",472]="Détection automatique du langage au démarrage activée"
	arr["CATALAN",472]="S'ha activat l'autodetecció d'idioma a l'inici"
	arr["PORTUGUESE",472]="A detecção automática do idioma foi ativa na inicialização"
	arr["RUSSIAN",472]="Автоматическое определение языка было включено"
	arr["GREEK",472]="Ο αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση έχει ενεργοποιηθεί"
	arr["ITALIAN",472]="Il rilevamento automatico della lingua all'inizio è attivato"
	arr["POLISH",472]="Autodetekcja języka podczas uruchamiania została aktywowana"
	arr["GERMAN",472]="Die automatische Spracherkennung am Start wurde aktiviert"
	arr["TURKISH",472]="Başlangıç dili otomatik algılama etkinleştirildi"
	arr["ARABIC",472]="تم تفعيل الاكتشاف التلقائي للغة عند بدء التشغيل"
	arr["CHINESE",472]="已启用脚本语言自动检测"

	arr["ENGLISH",473]="Startup language autodetection has been disabled"
	arr["SPANISH",473]="Se ha desactivado la autodetección de idioma al inicio"
	arr["FRENCH",473]="Détection automatique du langage au démarrage désactivée"
	arr["CATALAN",473]="S'ha desactivat l'autodetecció d'idioma a l'inici"
	arr["PORTUGUESE",473]="A detecção automática do idioma desativada na inicialização"
	arr["RUSSIAN",473]="Автоматическое определение языка было отключено"
	arr["GREEK",473]="Ο αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση έχει απενεργοποιηθεί"
	arr["ITALIAN",473]="È stato disattivato il rilevamento automatico della lingua all'inizio"
	arr["POLISH",473]="Autodetekcja języka podczas uruchamiania została wyłączona"
	arr["GERMAN",473]="Die automatische Spracherkennung am Start wurde deaktiviert"
	arr["TURKISH",473]="Başlangıç dili otomatik algılama devre dışı bırakıldı"
	arr["ARABIC",473]="تم تعطيل الاكتشاف التلقائي للغة عند بدء التشغيل"
	arr["CHINESE",473]="脚本语言自动检测已被禁用"

	arr["ENGLISH",474]="Startup language autodetection: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",474]="Autodetección de idioma al inicio: \${pink_color}Activada\${normal_color}"
	arr["FRENCH",474]="Détection automatique du langage au démarrage: \${pink_color}Activée\${normal_color}"
	arr["CATALAN",474]="Autodetecció d'idioma a l'inici: \${pink_color}Activade\${normal_color}"
	arr["PORTUGUESE",474]="Detecção automática do idioma: \${pink_color}ativa\${normal_color}"
	arr["RUSSIAN",474]="Автоопределение языка при запуске: \${pink_color}Включено\${normal_color}"
	arr["GREEK",474]="Αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση: \${pink_color}Ενεργοποιημένο\${normal_color}"
	arr["ITALIAN",474]="Rilevamento automatico della lingua all'inizio: \${pink_color}Attivato\${normal_color}"
	arr["POLISH",474]="Automatyczne wykrywanie języka podczas uruchamiania: \${pink_color}Aktywowane\${normal_color}"
	arr["GERMAN",474]="Automatische Spracherkennung am Start: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",474]="Başlangıç dili otomatik algılama: \${pink_color}Etkin\${normal_color}"
	arr["ARABIC",474]="\${pink_color}تفعيل\${blue_color} :الكشف التلقائي عن لغة عند بدء التشغيل\${normal_color}"
	arr["CHINESE",474]="脚本语言自动检测: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",475]="Startup language autodetection: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",475]="Autodetección de idioma al inicio: \${pink_color}Desactivada\${normal_color}"
	arr["FRENCH",475]="Détection automatique du langage au démarrage: \${pink_color}Désactivée\${normal_color}"
	arr["CATALAN",475]="Autodetecció d'idioma a l'inici: \${pink_color}Desactivade\${normal_color}"
	arr["PORTUGUESE",475]="Detecção automática do idioma: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",475]="Автоопределение языка при запуске: \${pink_color}Отключено\${normal_color}"
	arr["GREEK",475]="Αυτόματος εντοπισμός γλώσσας κατά την εκκίνηση: \${pink_color}Απενεργοποιημένο\${normal_color}"
	arr["ITALIAN",475]="Rilevamento automatico della lingua all'inizio: \${pink_color}Disattivato\${normal_color}"
	arr["POLISH",475]="Automatyczne wykrywanie języka podczas uruchamiania: \${pink_color}Niepełnosprawnych\${normal_color}"
	arr["GERMAN",475]="Automatische Spracherkennung am Start: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",475]="Başlangıç dili otomatik algılama: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",475]="\${pink_color}تعطيل\${blue_color} :الكشف التلقائي عن لغة عند بدء التشغيل\${normal_color}"
	arr["CHINESE",475]="脚本语言自动检测: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",476]="A graphical X windows system has been detected but airgeddon was unable to detect resolution. Try executing \"\${normal_color}xhost +\${red_color}\" command before launching airgeddon. If it does not work, probably your system is missing one of these two commands \"loginctl\", \"xdpyinfo\". Install the needed packages and then try again. For the first one, package name is systemd, for the second one there are some possibilities (it may vary depending on your Linux distribution). Some suggested package names are: x11-utils, xdpyinfo or xorg-xdpyinfo"
	arr["SPANISH",476]="Se detectó un sistema gráfico de ventanas X, pero airgeddon no pudo detectar la resolución. Intenta ejecutar el comando \"\${normal_color}xhost +\${red_color}\" antes de iniciar airgeddon. Si no funciona, probablemente a tu sistema le falta uno de estos dos comandos \"loginctl\", \"xdpyinfo\". Instala los paquetes necesarios y vuelve a intentarlo. Para el primero, el nombre del paquete es systemd, para el segundo hay varias posibilidades (puede variar dependiendo de la distribución de Linux). Algunos nombres de paquetes sugeridos son: x11-utils, xdpyinfo o xorg-xdpyinfo"
	arr["FRENCH",476]="Un système graphique X windows a été détecté mais airgeddon n'a pas pu détecter la résolution. Essayez d'exécuter la commande \"\${normal_color}xhost +\${red_color}\" avant de executer airgeddon. Si cela ne marche pas, probablement il manque à votre système l'une de ces deux commandes \"loginctl\", \"xdpyinfo\". Installez les packages nécessaires et réessayez. Pour le premier, le nom du package est systemd, pour le second il y a quelques possibilités (cela peut varier selon votre distribution de Linux). Certains noms de packages suggérés sont: x11-utils, xdpyinfo ou xorg-xdpyinfo"
	arr["CATALAN",476]="S'ha detectat un sistema gràfic X windows però airgeddon no ha pogut detectar la resolució. Proveu d'executar l'ordre \"\${normal_color}xhost +\${red_color}\" abans de llançar airgeddon. Si no funciona, probablement al vostre sistema li falta una d'aquestes dues ordres \"loginctl\", \"xdpyinfo\". Instal·leu els paquets necessaris i torneu-ho a provar. Per al primer, el nom del paquet és systemd, per al segon hi ha algunes possibilitats (pot variar segons la vostra distribució de Linux). Alguns noms de paquets suggerits són: x11-utils, xdpyinfo o xorg-xdpyinfo"
	arr["PORTUGUESE",476]="Um X Window System (ambiente gráfico) foi detectado, mas o airgeddon não conseguiu detectar a resolução. Tente executar o comando \"\${normal_color}xhost +\${red_color}\" antes de iniciar o airgeddon. Se não funcionar, provavelmente seu ambiente não tem um dos seguintes comandos: \"loginctl\" ou \"xdpyinfo\". Instale os pacotes necessários e tente novamente. Para o primeiro, o nome do pacote é systemd, para o segundo existem algumas possibilidades podendo variar dependendo da sua distribuição Linux. Alguns nomes sugeridos são: x11-utils, xdpyinfo ou xorg-xdpyinfo"
	arr["RUSSIAN",476]="airgeddon обнаружил графическую систему X11, но не смог определить разрешение. Попробуйте выполнить команду \"\${normal_color}xhost +\${red_color}\" перед запуском. Если это не помогло, возможно, в вашей системе отсутствует одна из этих двух программ \"loginctl\", \"xdpyinfo\". Установите необходимые пакеты и повторите попытку. Название первого пакета - systemd, название второго пакета варьируется в зависимости от дистрибутива Linux. Предположительные имена пакетов: x11-utils, xdpyinfo или xorg-xdpyinfo"
	arr["GREEK",476]="Εντοπίστηκε ένα γραφικό σύστημα Windows X, αλλά το airgeddon δεν μπόρεσε να ανιχνεύσει την ανάλυση. Δοκιμάστε να εκτελέσετε την εντολή \"\${normal_color}xhost +\${red_color}\" πριν ξεκινήσετε το airgeddon. Εάν δεν λειτουργεί, πιθανότατα από το σύστημά σας λείπει μία από αυτές τις δύο εντολές \"loginctl\", \"xdpyinfo\". Εγκαταστήστε τα απαραίτητα πακέτα και δοκιμάστε ξανά. Για το πρώτο, το όνομα πακέτου είναι systemd, για το δεύτερο υπάρχουν κάποιες δυνατότητες (μπορεί να διαφέρει ανάλογα με τη διανομή Linux σας). Μερικά προτεινόμενα ονόματα πακέτων είναι: x11-utils, xdpyinfo ή xorg-xdpyinfo"
	arr["ITALIAN",476]="È stato rilevato un sistema grafico X windows ma airgeddon non è stato in grado di rilevare la risoluzione. Prova a eseguire il comando \"\${normal_color}xhost +\${red_color}\" prima di avviare airgeddon. Se non funziona, probabilmente nel tuo sistema manca uno di questi due comandi \"loginctl\", \"xdpyinfo\". Installa i pacchetti necessari e riprova. Per il primo, il nome del pacchetto è systemd, per il secondo ci sono alcune possibilità (può variare a seconda della tua distribuzione Linux). Alcuni nomi di pacchetti suggeriti sono: x11-utils, xdpyinfo o xorg-xdpyinfo"
	arr["POLISH",476]="Graficzny system X Windows został wykryty, ale airgeddon nie był w stanie wykryć rozdzielczości. Spróbuj polecenie \"\${normal_color}xhost +\${red_color}\" przed uruchomieniem airgeddon. Jeśli nie działa, prawdopodobnie w systemie brakuje jednego z tych dwóch poleceń \"loginctl\", \"xdpyinfo\". Zainstaluj potrzebne pakiety, a następnie spróbuj ponownie. Dla pierwszego nazwa pakietu to systemd, dla drugiego jest kilka możliwości (może się różnić w zależności od dystrybucji Linuksa). Niektóre sugerowane nazwy pakietów to: x11-utils, xdpyinfo lub xorg-xdpyinfo"
	arr["GERMAN",476]="Ein grafisches X-Windows-System wurde erkannt, aber airgeddon konnte keine Auflösung erkennen. Versuchen Sie, den Befehl \"\${normal_color}xhost +\${red_color}\" auszuführen, bevor Sie airgeddon starten. Wenn es nicht funktioniert, fehlt Ihrem System wahrscheinlich einer dieser beiden Befehle \"loginctl\", \"xdpyinfo\". Installieren Sie die erforderlichen Pakete und versuchen Sie es erneut. Für den ersten ist der Paketname systemd, für den zweiten gibt es einige Möglichkeiten (dies kann je nach Linux-Distribution variieren). Einige vorgeschlagene Paketnamen sind: x11-utils, xdpyinfo oder xorg-xdpyinfo"
	arr["TURKISH",476]="Grafiksel bir X windows sistemi algılandı, ancak airgeddon çözünürlüğü algılayamadı. airgeddon'u başlatmadan önce \"\${normal_color}xhost +\${red_color}\" komutunu çalıştırmayı deneyin. Çalışmıyorsa, muhtemelen sisteminizde bu iki komuttan biri eksiktir \"loginctl\", \"xdpyinfo\". Gerekli paketleri kurun ve tekrar deneyin. İlki için paket adı systemd, ikincisi için bazı olasılıklar var (Linux dağıtımınıza bağlı olarak değişebilir). Önerilen bazı paket adları şunlardır: x11-utils, xdpyinfo veya xorg-xdpyinfo"
	arr["ARABIC",476]="x11-utils, xdpyinfo , xorg-xdpyinfo :الخاصه بك. بعض الاسماء المقترحه هي  linuxلكن الرابت الثانب قد يكون له اسماء مختلفه و هذا يعتمد علي نسخت ال , systemd الامرين. قم بتحميلهما ثم حاول مرة اخري.اسم اول رابط هو \"loginctl\", \"xdpyinfo\" اذا لم تعمل , قد يكون جهازك يفقد احدي هذين  .airgeddon قبل تشغيل \"\${normal_color}xhost +\${red_color}\" لم يستطع تحديد دقة تفاصيل صورة. حول تنفيذ الامر airgeddon لكن X تم اكتشاف نظام الجرافيكس"
	arr["CHINESE",476]="已检测到 X 图形窗口管理器，但 airgeddon 无法检测到分辨率。在启动 airgeddon 之前尝试执行 \"\${normal_color}xhost +\${red_color}\" 命令。如果它不起作用，可能是您的系统缺少这两个命令 \"loginctl\"、\"xdpyinfo\" 之一。安装所需的软件包，然后重试。对于第一个软件包的名称是 systemd，对于第二个软件包 (它可能因您的 Linux 发行版而异) 一些可能的名称是: x11-utils、xdpyinfo 或 xorg-xdpyinfo"

	arr["ENGLISH",477]="The options in this menu containing the word \"permanently\" modify airgeddon to save the settings for the next time that is to be launched. However, you can always return to this menu to change the value of the option again"
	arr["SPANISH",477]="Las opciones de este menú que contienen la palabra \"permanentemente\", modifican airgeddon para que incluso la siguiente vez que sea iniciado siga guardando la configuración. No obstante, siempre puedes volver a este menú a cambiar de nuevo el valor de la opción"
	arr["FRENCH",477]="Les options contenant le mot \"permanente\" modifiént airgeddon de sorte que les paramétrages persisteront lors des prochains redémarrages. Vous pourrez cependant toujours modifier la configuration permanante depuis ce même menu"
	arr["CATALAN",477]="Les opcions d'aquest menú que contenen la paraula \"permanentment\", modifiquen airgeddon perquè fins i tot la següent vegada que sigui iniciat segueixi guardant la configuració. No obstant això, sempre pots tornar a aquest menú a canviar de nou el valor de l'opció"
	arr["PORTUGUESE",477]="As opções neste menu contendo a palavra \"permanentemente\" serão modificadas de modo que mesmo no próximo início do airgeddon as configurações serão mantidas. No entanto, você pode sempre voltar a este menu e alterar as opções"
	arr["RUSSIAN",477]="Опции в этом меню, содержащие слово \"постоянное\", сохраняются в airgeddon при перезапусках программы. Однако вы всегда можете вернуться в это меню, чтобы снова изменить значение параметра"
	arr["GREEK",477]="Οι επιλογές σε αυτό το μενού που περιέχουν τη λέξη \"μόνιμα\" τροποποιούν το airgeddon ώστε να αποθηκεύει τις ρυθμίσεις για την επόμενη φορά. Ωστόσο, μπορείτε πάντα να επιστρέψετε σε αυτό το μενού για να αλλάξετε ξανά την τιμή της επιλογής"
	arr["ITALIAN",477]="Le opzioni di questo menú che contengono la parola \"permanentemente\" modificano airgeddon in modo che anche la volta successiva che viene avviato continui con la configurazione salvata. Tuttavia, si può sempre tornare a questo menú per cambiare di nuovo il valore dell'opzione"
	arr["POLISH",477]="Opcje w tym menu, które zawierają słowo \"trwale\" zmodyfikują airgeddon tak, że nawet przy następnym uruchomieniu będą zapisane. Jednak zawsze możesz wrócić do tego menu, aby ponownie zmienić ustawienia"
	arr["GERMAN",477]="Die Optionen dieses Menüs, die das Wort \"dauerhaft\" enthalten, modifizieren airgeddon so, dass auch beim nächsten Start die Konfiguration gespeichert wird. Sie können jedoch jederzeit zu diesem Menü zurückkehren, um den Wert der Option erneut zu ändern"
	arr["TURKISH",477]="Bu menüdeki \"kalıcı\" kelimesini içeren seçenekler, başlatılacak bir sonraki seferde ayarları kaydetmek için airgeddon'u değiştirir. Ancak, seçeneğin değerini tekrar değiştirmek için bu menüye her zaman dönebilirsiniz"
	arr["ARABIC",477]="لحفظ الإعدادات في المرة القادمة التي سيتم إطلاقها. ومع ذلك ، يمكنك دائمًا العودة إلى هذه القائمة لتغيير قيمة الخيار مرة أخرى airgeddon تعدل \"permanently\" الخيارات في هذه القائمة التي تحتوي على كلمة"
	arr["CHINESE",477]="此菜单中包含单词“永久*”的选项修改，airgeddon 会保存设置以供下次启动时使用。但您始终可以返回此菜单以再次更改这些选项的值"

	arr["ENGLISH",478]="\${blue_color}Language is going to be set permanently to the current one, so on the next start of airgeddon it will be used directly. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",478]="\${blue_color}Se va a cambiar permanentemente el idioma al actual para que al siguiente inicio de airgeddon este sea el idioma en el que arranque directamente. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",478]="\${blue_color}La langue actuelle va être activée de façon permanente, c'est à dire que ce sera la langue d'usage lors des prochains démarrages d'airgeddon. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",478]="\${blue_color}Es canviarà permanentment l'idioma a l'actual perquè al següent inici d' airgeddon aquest sigui l'idioma en què arrenqui directament. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",478]="\${blue_color}O idioma será definida permanentemente para o atual, no próximo início do airgeddon este será o idioma usado. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",478]="\${blue_color}Текущий язык будет установлен как постоянный, поэтому при следующем запуске airgeddon он будет использоваться без определения языка системы. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",478]="\${blue_color}Η τρέχουσα γλώσσα πρόκειται να τεθεί μόνιμα ως προεπιλεγμένη, ώστε κατά την επόμενη εκκίνηση του airgeddon θα χρησιμοποιηθεί κατ' ευθείαν αυτή. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",478]="\${blue_color}Sarà modificata in modo permanente la lingua corrente in modo che al prossimo avvio di airgeddon questa sia la lingua di avvio. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",478]="\${blue_color}To na stałe zmieni język na aktualny, tak aby był ustawiony przy następnym uruchomieniu airgeddon. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",478]="\${blue_color}Die aktuelle Sprache wird permanent geändert, so dass der nächste Start von airgeddon in diese Sprache direkt startet. \${green_color}Möchten Sie weitermachen? \${normal_color}\${visual_choice}"
	arr["TURKISH",478]="Dil, geçici olarak şu anki olarak ayarlanacaktır, böylece bir sonraki airgeddon başlatmada doğrudan kullanılacaktır. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",478]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم استخدامها مباشرة airgeddon سيتم تعيين اللغة بشكل دائم على اللغة الحالية ، لذلك عند البداية الموالية لـ\${normal_color}"
	arr["CHINESE",478]="\${blue_color}语言将永久设置为当前语言，因此在下次启动 airgeddon 时将直接使用它。\${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",479]="This change conflicts with the startup language autodetection which is currently enabled. It will be disabled automatically in order to perform the change"
	arr["SPANISH",479]="Este cambio entra en conflicto con la autodetección del idioma al inicio que en este momento está activada. Se desactivará automáticamente para poder realizar el cambio"
	arr["FRENCH",479]="Ce changement entre en conflit avec la détection automatique de la langue au démarrage qui est actuellement activée. Elle va être automatiquement désactivée pour effectuer le changement"
	arr["CATALAN",479]="Aquest canvi entra en conflicte amb la detecció automàtica de l'idioma a l'inici que en aquest moment està activada. Es desactivarà automàticament per a poder realitzar el canvi"
	arr["PORTUGUESE",479]="Esta mudança entra em conflito com a detecção automática do idioma, ativa atualmente. Ela será desativa automaticamente ao fazer essa mudança"
	arr["RUSSIAN",479]="Это изменение конфликтует с автоопределением языка, которое в данный момент включено. Оно будет автоматически отключено для выполнения изменения"
	arr["GREEK",479]="Αυτή η αλλαγή έρχεται σε σύγκρουση με τoν αυτόματo εντοπισμό της γλώσσας εκκίνησης, ο οποίος είναι αυτή τη στιγμή ενεργοποιημένος. Θα απενεργοποιηθεί αυτόματα για να πραγματοποιηθεί η αλλαγή αυτή"
	arr["ITALIAN",479]="Questo cambio è in conflitto con il rilevamento automatico di lingua di inizio che è attualmente attivo. Esso viene disattivato automaticamente per poter fare il cambio"
	arr["POLISH",479]="Ta zmiana jest sprzeczna z automatyczną detekcją języka na początku, która jest aktualnie aktywna. Zostanie ona automatycznie deazktywowana w celu wprowadzenia zmian"
	arr["GERMAN",479]="Diese Änderung steht im Konflikt mit der automatischen Spracherkennung, die zu diesem Zeitpunkt am Anfang aktiviert ist. Es wird automatisch deaktiviert, um die Änderung vorzunehmen"
	arr["TURKISH",479]="Bu değişiklik, şu anda etkin olan başlangıç dili otomatik algılama ile çakışıyor. Değişikliği gerçekleştirmek için otomatik olarak devre dışı bırakılacaktır"
	arr["ARABIC",479]="يتعارض هذا التغيير مع الاكتشاف التلقائي للغة عند بدء التشغيل والذي تم تفعيله حاليًا. سيتم تعطيله تلقائيًا لإجراء التغيير"
	arr["CHINESE",479]="此更改与当前已启用的脚本语言自动检测冲突。它将自动禁用以执行更改"

	arr["ENGLISH",480]="Current language is the same of permanent language already set. No changes will be done"
	arr["SPANISH",480]="El idioma actual es el mismo que ya está puesto como permanente. No se realizarán cambios"
	arr["FRENCH",480]="La langue actuelle est la même que celle désignée comme langue permanente. Pas de changements"
	arr["CATALAN",480]="L'idioma actual és el mateix que ja està posat com permanent. No es realitzaran canvis"
	arr["PORTUGUESE",480]="O idioma atual já é o permanente. Nenhuma alteração será feita"
	arr["RUSSIAN",480]="Текущий язык тот же, что и уже установленный постоянный язык. Никаких изменений не будет сделано"
	arr["GREEK",480]="Η τρέχουσα γλώσσα είναι ίδια με τη μόνιμη γλώσσα που έχει οριστεί ήδη. Δεν θα γίνει καμία αλλαγή"
	arr["ITALIAN",480]="La lingua è la stessa che è giá impostata come permanente. Nessuna modifica sará effettuata"
	arr["POLISH",480]="Obecny język jest taki sam jak ten, który został już ustawiony jako stały. Nie zostaną wprowadzone żadne zmiany"
	arr["GERMAN",480]="Die aktuelle Sprache ist dieselbe, die bereits als permanent festgelegt wurde. Es werden keine Änderungen vorgenommen"
	arr["TURKISH",480]="Mevcut dil, zaten ayarlanmış olan kalıcı dil ile aynı. Hiçbir değişiklik yapılmayacak"
	arr["ARABIC",480]="اللغة الحالية هي نفس اللغة الدائمة التي تم تعيينها بالفعل. لن يتم إجراء أي تغييرات"
	arr["CHINESE",480]="当前语言与已设置的永久语言相同。不会做任何改变"

	arr["ENGLISH",481]="Language set to the current one permanently"
	arr["SPANISH",481]="Idioma cambiado al actual permanentemente"
	arr["FRENCH",481]="La langue choisie est l'actuelle langue permanente"
	arr["CATALAN",481]="Idioma canviat a l'actual permanentment"
	arr["PORTUGUESE",481]="Idioma definido permanentemente para o atual"
	arr["RUSSIAN",481]="Язык изменён на текущий с сохранением после перезапуска"
	arr["GREEK",481]="Τέθηκε μόνιμα η τρέχουσα γλώσσα"
	arr["ITALIAN",481]="Lingua cambiata a quella attuale permanentemente"
	arr["POLISH",481]="Język trwale zmienił się na aktualny"
	arr["GERMAN",481]="Die Sprache wurde permanent geändert"
	arr["TURKISH",481]="Geçerli dil kalıcı olarak ayarlandı"
	arr["ARABIC",481]="يتم تعيين اللغة على اللغة الحالية بشكل دائم"
	arr["CHINESE",481]="语言永久设置为当前语言"

	arr["ENGLISH",482]="8.  Italian"
	arr["SPANISH",482]="8.  Italiano"
	arr["FRENCH",482]="8.  Italien"
	arr["CATALAN",482]="8.  Italià"
	arr["PORTUGUESE",482]="8.  Italiano"
	arr["RUSSIAN",482]="8.  Итальянский"
	arr["GREEK",482]="8.  Ιταλικά"
	arr["ITALIAN",482]="8.  Italiano"
	arr["POLISH",482]="8.  Włoski"
	arr["GERMAN",482]="8.  Italienisch"
	arr["TURKISH",482]="8.  İtalyanca"
	arr["ARABIC",482]="8.  الايطالية"
	arr["CHINESE",482]="8.  意大利语"

	arr["ENGLISH",483]="The attack in \"smooth\" mode will be dismantled as soon as a credential is captured to let clients reconnect again to the legitimate network. This reduces the possibility of being discovered, looking for some users as a punctual wireless network malfunction"
	arr["SPANISH",483]="El ataque en modo \"smooth\" tan pronto capture unas credenciales se desmantelará para dejar que los clientes vuelvan a conectarse a la red legítima. Esto reduce las posibilidades de ser descubierto haciendo que para algunos usuarios pueda parecer un fallo puntual de la red inalámbrica"
	arr["FRENCH",483]="L'attaque en mode \"smooth\" dès qu'elle capture des identifiants de connexion il sera démantelée pour permettre aux clients se reconnecter au réseau légitime. Cela réduit les chances d'être découvert, faisant ainsi penser à une défaillance puntuelle du réseau"
	arr["CATALAN",483]="L'atac en mode \"smooth\" tan aviat capturi unes credencials es desmantellarà per deixar que els clients tornin a connectar-se a la xarxa legítima. Això redueix les possibilitats de ser descobert fent que per a alguns usuaris pugui semblar una fallada puntual de la xarxa sense fil"
	arr["PORTUGUESE",483]="O ataque no \"modo discreto\" será encerrado assim que capturar uma credencial, permitindo que os clientes se reconectem à rede legítima. Isso reduz as chances de ser descoberto, fazendo com que pareça apenas uma falha da rede sem fio para alguns usuários"
	arr["RUSSIAN",483]="Атака в режиме \"smooth\" будет остановлена как только будут захвачены учётные данные, чтобы клиенты снова подключились к законной сети. Это уменьшает вероятность обнаружения, выглядит как небольшие проблемы в беспроводной сети"
	arr["GREEK",483]="Η επίθεση σε \"smooth\" mode θα σπάσει σε διάφορα μέρη μόλις ληφθεί η πιστοποίηση για να επιτρέψει στους πελάτες να επανασυνδεθούν ξανά στο κανονικό δίκτυο. Αυτό μειώνει την πιθανότητα να ανακαλυφθεί, αναζητώντας ορισμένους χρήστες ως μια εσφαλμένη λειτουργία ασύρματου δικτύου"
	arr["ITALIAN",483]="L'attacco con la modalità \"smooth\" non appena acquisisce una credenziale verrà fermato per consentire ai client di riconnettersi alla rete legittima. Questo riduce le possibilità di essere scoperti, facendo credere agli utenti che sia stato un errore della rete wireless"
	arr["POLISH",483]="Atak w trybie \"smooth\" zostanie zdemontowany zaraz po przechwyceniu danych, aby umożliwić klientom ponowne połączenie z właściwą siecią. Zmniejsza to szansę na wykrycie, ponieważ niektórym użytkownikom wydaje się że to chwilowa awaria sieci bezprzewodowej"
	arr["GERMAN",483]="Der Angriff im \"smooth\"-Modus wird sobald er einen Berechtigungsnachweis erfasst abgebaut, damit die Clients sich wieder mit dem legitimen Netzwerk verbinden können. Dies verringert die Wahrscheinlichkeit, entdeckt zu werden, was für einige Benutzer als sinnloser Ausfall des WLANs erscheint"
	arr["TURKISH",483]="\"smooth\" saldırı modu, herhangi bir giriş bilgisi yakalanır yakalanmaz, istemcilerin meşru ağa yeniden bağlanmasına izin vermek için durdurulacaktır. Bu, keşfedilme şansını azaltır ve bazı kullanıcılar için kablosuz ağın anlamsız bir başarısızlığı gibi görünmesini sağlar"
	arr["ARABIC",483]=".بمجرد أن يلتقط بيانات اعتماد تسجيل الدخول ، سيتم تفكيكه للسماح للعملاء بإعادة الاتصال بالشبكة الشرعية. هذا يقلل من فرص الاكتشاف ، مما يشير إلى فشل الشبكة في نقطة زمنية. \"smooth\" هجوم في الوضع"
	arr["CHINESE",483]="“平滑”模式下的攻击将在捕获凭据后立即解除，让客户端重新连接到合法网络。这减少了被发现的可能性。"

	arr["ENGLISH",484]="Root permissions successfully detected"
	arr["SPANISH",484]="Permisos de root correctamente detectados"
	arr["FRENCH",484]="Autorisation root detectée"
	arr["CATALAN",484]="Permisos de root correctament detectats"
	arr["PORTUGUESE",484]="Permissões de root detectadas corretamente"
	arr["RUSSIAN",484]="Успешно определены права root"
	arr["GREEK",484]="Τα δικαιώματα root έχουν παραχωρηθεί επιτυχώς"
	arr["ITALIAN",484]="I permessi di root sono stati rilevati correttamente"
	arr["POLISH",484]="Uprawnienia root zostały prawidłowo wykryte"
	arr["GERMAN",484]="Richtig erkannte root-Berechtigungen"
	arr["TURKISH",484]="Root yetkileri başarıyla tespit edildi"
	arr["ARABIC",484]="بنجاح root تم اكتشاف أذونات"
	arr["CHINESE",484]="成功检测到 root 权限"

	arr["ENGLISH",485]="\${blue_color}Some PINs have been added calculated using the algorithms (ComputePIN, EasyBox, etc.), however you can add one more (Arcadyan). Calculating it requires certain data and a background scan will have to be performed. The process may be very slow. \${green_color}Do you want to proceed with the calculation to add it? \${normal_color}\${visual_choice}"
	arr["SPANISH",485]="\${blue_color}Se han añadido algunos PINs calculados por algoritmos (ComputePIN, EasyBox, etc.), pero aún se puede añadir uno más (Arcadyan). Calcularlo requiere ciertos datos y habrá que realizar un escaneo en segundo plano. Es posible que el proceso sea muy lento. \${green_color}¿Quieres proceder con el cálculo para añadirlo? \${normal_color}\${visual_choice}"
	arr["FRENCH",485]="\${blue_color}Certains PINs ajouté ont été calculés par des algorithmes (ComputePIN, EasyBox, etc.), mais vous pouvez encore ajouter un autre (Arcadyan). Le calcul nécessite certaines données et une analyse d'arrière-plan devra être effectuée. Le processus peut être très lent. \${green_color}Voulez-vous procéder au calcul pour l'ajouter? \${normal_color}\${visual_choice}"
	arr["CATALAN",485]="\${blue_color}S'han afegit alguns PINs calculats per algoritmes (ComputePIN, EasyBox, etc.), però encara es pot afegir un més (Arcadyan). Calcular-lo requereix certes dades i caldrà realitzar un escaneig en segon pla. És possible que el procés sigui molt lent. \${green_color}¿Vols procedir amb el càlcul per afegir-ho? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",485]="\${blue_color}Alguns PINs adicionados foram calculados usando algoritmos (ComputePIN, EasyBox, etc.), mas você ainda pode adicionar mais um (Arcadyan). Calculá-lo requer certos dados e uma verificação em segundo plano terá que ser realizada. O processo pode ser muito lento. \${green_color}Deseja continuar com o cálculo para adicioná-lo? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",485]="\${blue_color}Некоторые добавленные PIN были вычислены алгоритмами (ComputePIN, EasyBox, и т.д.), но вы можете добавить ещё один (Arcadyan). Для его вычисления требуются определенные данные, и необходимо выполнить фоновое сканирование. Процесс может быть очень медленным. \${green_color}Вы хотите добавить PIN, вычисленные этим алгоритмом? \${normal_color}\${visual_choice}"
	arr["GREEK",485]="\${blue_color}Έχουν προστεθεί ορισμένοι κωδικοί PIN υπολογισμένοι με τους αλγόριθμους (ComputePIN, EasyBox, κτλπ.), μπορείτε όμως να προσθέσετε άλλον έναν κωδικό (Arcadyan). Ο υπολογισμός του απαιτεί ορισμένα δεδομένα και θα πρέπει να πραγματοποιηθεί κάποιο scan στο background. Η διαδικασία αυτή μπορεί να αργοπορήσει. \${green_color}Θέλετε να συνεχίσετε με τον υπολογισμό του και να τον προσθέσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",485]="\${blue_color}Sono stati aggiunti alcuni PIN calcolati da algoritmi (ComputePIN, EasyBox, etc.), ma è possibile aggiungerne ancora uno (Arcadyan). Il calcolo richiede alcuni dati e deve essere eseguita una scansione in secondo piano. Il processo può essere molto lento. \${green_color}Vuoi procedere con il calcolo per aggiungerlo? \${normal_color}\${visual_choice}"
	arr["POLISH",485]="\${blue_color}Niektóre kody PIN zostały dodane obliczone algorytmami (ComputePIN, EasyBox, itd.) ale można jeszcze dodać jeden (Arcadyan). Obliczanie go wymaga pewnych danych oraz będzie musiało zostać wykonane skanowanie w tle. Proces ten może być bardzo powolny. \${green_color}Czy chcesz kontynuować obliczenie, aby go dodać? \${normal_color}\${visual_choice}"
	arr["GERMAN",485]="\${blue_color}Einige von Algorithmen berechnete PINs (ComputePIN, EasyBox usw.) wurden hinzugefügt, aber es kann noch eine weitere hinzugefügt werden (Arcadyan). Die Berechnung erfordert bestimmte Daten und ein Scan im Hintergrund muss durchgeführt werden. Es ist möglich, dass der Prozess sehr langsam ist. \${green_color}Möchten Sie mit der Berechnung fortfahren, um sie hinzuzufügen? \${normal_color}\${visual_choice}"
	arr["TURKISH",485]="Bazı PIN'ler algoritmalar (ComputePIN, EasyBox, vb.) Kullanılarak hesaplanmıştır, ancak bir tane daha ekleyebilirsiniz (Arcadyan). Bunu hesaplamak belirli veriler gerektirir ve bir arka plan taramasının yapılması gerekir. İşlem çok yavaş olabilir. \${green_color}Eklemek istediğiniz hesaplamaya devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",485]="\${normal_color}\${visual_choice} \${green_color}هل تريد متابعة الحساب لإضافته؟\${blue_color} .يتطلب حسابها بيانات معينة وسيتعين إجراء مسح للخلفية. قد تكون العملية بطيئة للغاية (Arcadyan) وما إلى ذلك) ، ولكن يمكنك إضافة واحد آخر EasyBox و ComputePIN ) المحسوبة باستخدام الخوارزميات (PIN) تمت إضافة بعض أرقام التعريف الشخصية\${normal_color}"
	arr["CHINESE",485]="\${blue_color}一些 PIN 已使用算法计算 (如 ComputePIN、EasyBox 等)，但是您可以再添加一个 (Arcadyan) 。计算它需要某些数据，并且必须执行后台扫描。该过程可能非常缓慢。\${green_color}是否要添加它？\${normal_color}\${visual_choice}"

	arr["ENGLISH",486]="It's not possible to generate PIN with Arcadyan algorithm. To be able to do it, update \"wash\" (included in reaver package) to a newer version including the necessary \"-j\" option (v\${minimum_wash_json_version})"
	arr["SPANISH",486]="No es posible generar el PIN con el algoritmo Arcadyan. Para poder hacerlo actualice \"wash\" (incluido en el paquete reaver) a una versión superior que tenga la necesaria opción \"-j\" (v\${minimum_wash_json_version})"
	arr["FRENCH",486]="Il n'est pas possible de générer le PIN avec l'algorithme Arcadyan. Pour ce faire, mettez à jour \"wash\" (inclus dans le paquet reaver) vers une version supérieure qui a l'option \"-j\" (v\${minimum_wash_json_version})"
	arr["CATALAN",486]="No és possible fer el PIN amb l'algoritme Arcadyan. Per poder fer-ho actualitzi \"wash\" (inclòs en el paquet reaver) a una versió superior que tingui la necessària opció \"-j\" (v\${minimum_wash_json_version})"
	arr["PORTUGUESE",486]="Não foi possível gerar o PIN com o algoritmo Arcadyan. Para isso, atualize \"wash\" (incluso no pacote reaver) para uma versão que tenha a opção necessária \"-j\" (v\${minimum_wash_json_version})"
	arr["RUSSIAN",486]="Невозможно создать PIN с алгоритмом Arcadyan. Чтобы это сделать, обновите \"wash\" (включена в пакет reaver) на более новую версию, которая имеет необходимую опцию \"-j\" (v\${minimum_wash_json_version})"
	arr["GREEK",486]="Δεν είναι δυνατό να δημιουργηθεί PIN με τον αλγόριθμο Arcadyan. Για να το κάνετε αυτό, ενημερώστε το \"wash\" (περιλαμβάνεται στο πακέτο του reaver) σε νεότερη έκδοση, συμπεριλαμβανομένης της απαραίτητης επιλογής \"-j\" (v\${minimum_wash_json_version})"
	arr["ITALIAN",486]="Non è possibile generare il PIN con l'algoritmo Arcadyan. Per effettuare questa operazione, aggiornare \"wash\" (incluso nel pacchetto reaver) a una versione più nuova che disponga dell'opzione necessaria \"-j\" (v\${minimum_wash_json_version})"
	arr["POLISH",486]="Nie jest możliwe wygenerowanie kodu PIN za pomocą algorytmu Arcadyan. Aby to zrobić, uaktualnij \"wash\" (zawarty w pakiecie reaver) do wyższej wersji, która wspiera opcję \"-j\" (v\${minimum_wash_json_version})"
	arr["GERMAN",486]="Es ist nicht möglich, die PIN mit dem Arcadyan-Algorithmus zu generieren. Aktualisieren Sie dazu \"wash\" (im reaver-Paket enthalten) auf eine höhere Version mit der erforderlichen Option \"-j\" (v\${minimum_wash_json_version})"
	arr["TURKISH",486]="Arcadyan algoritması ile PIN üretmek mümkün değil. Bunu yapabilmek için gerekli \"-j\" seçeneği de dahil olmak üzere daha yeni bir sürüme \"wash\" (reaver paketinde yer alan) güncelleştirin (v\${minimum_wash_json_version})"
	arr["ARABIC",486]="(v\${minimum_wash_json_version}) الضروري \"-j\"إلى إصدار أحدث يتضمن الخيار (reaver الموجودة في حزمة) \"wash\" لتتمكن من القيام بذلك ، قم بتحديث .Arcadyan باستخدام خوارزمية PIN لا يمكن إنشاء"
	arr["CHINESE",486]="无法使用 Arcadyan 算法生成 PIN。为了能够做到这一点，将 \"wash\" (包含在 reaver 包中) 更新到更新版本，包括必要的 \"-j\" 选项 (v\${minimum_wash_json_version})"

	arr["ENGLISH",487]="PIN generated using Arcadyan algorithm (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["SPANISH",487]="Se ha generado el PIN con el algoritmo Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["FRENCH",487]="Le PIN a été généré avec l'algorithme Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["CATALAN",487]="S'ha generat el PIN amb l'algoritme Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["PORTUGUESE",487]="Foi gerado um PIN com o algoritmo Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["RUSSIAN",487]="PIN-код, созданный с использованием алгоритма Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["GREEK",487]="Το PIN δημιουργήθηκε με τον αλγόριθμο Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["ITALIAN",487]="Il PIN è stato generato con l'algoritmo Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["POLISH",487]="PIN został wygenerowany za pomocą algorytmu Arcadyan (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["GERMAN",487]="Die PIN wurde mit dem Arcadyan-Algorithmus generiert (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["TURKISH",487]="Arcadyan algoritması kullanılarak oluşturulan PIN (\${normal_color}\${arcadyan_pin}\${yellow_color})"
	arr["ARABIC",487]="(\${normal_color}\${arcadyan_pin}\${yellow_color}) Arcadyan باستخدام خوارزمية PIN تم إنشاء رقم التعريف الشخصي"
	arr["CHINESE",487]="使用 Arcadyan 算法生成的 PIN (\${normal_color}\${arcadyan_pin}\${yellow_color})"

	arr["ENGLISH",488]="PIN can't be generated using Arcadyan algorithm. Failed to collect a complete \"probe\" response from the access point. Probably because of low signal quality"
	arr["SPANISH",488]="No se ha podido generar el PIN con el algoritmo Arcadyan. No se ha podido recoger una respuesta \"probe\" completa del punto de acceso. Probablemente porque la señal no es buena"
	arr["FRENCH",488]="Impossible de générer le PIN avec l'algorithme Arcadyan. Impossible de collecter une réponse complète \"probe\" à partir du point d'accès. Probablement parce que le signal n'est pas de bonne qualite"
	arr["CATALAN",488]="No s'ha pogut generar el PIN amb l'algoritme Arcadyan. No s'ha pogut recollir una resposta \"probe\" completa del punt d'accés. Probablement perquè el senyal no és bona"
	arr["PORTUGUESE",488]="Não foi possível gerar um PIN com o algoritmo Arcadyan. Falha ao coletar a resposta de \"probe\" completa do ponto de acesso. Provavelmente porque o sinal não é bom"
	arr["RUSSIAN",488]="PIN-код не может быть сгенерирован с использованием алгоритма Arcadyan. Не удалось получить полный ответ \"probe\" от точки доступа. Возможно, из-за низкого качества сигнала"
	arr["GREEK",488]="Το PIN δεν μπορεί να δημιουργηθεί χρησιμοποιώντας τον αλγόριθμο Arcadyan. Δεν ήταν δυνατή η συλλογή πλήρους \"probe\" response από το σημείο πρόσβασης. Πιθανόν επειδή το σήμα είναι χαμηλό"
	arr["ITALIAN",488]="Impossibile generare il PIN con l'algoritmo Arcadyan. Impossibile raccogliere una risposta \"probe\" completa dal punto di accesso. Probabilmente perché il segnale non è buono"
	arr["POLISH",488]="Nie można wygenerować kodu PIN za pomocą algorytmu Arcadyan. Nie udało się zebrać kompletnej odpowiedzi \"probe\" z punktu dostępu. Prawdopodobnie dlatego, że pozion sygnału jest słaby"
	arr["GERMAN",488]="Die PIN konnte nicht mit dem Arcadyan-Algorithmus generiert werden. Keine vollständige Antwort \"probe\" vom Zugriffspunkt konnte gesammelt werden. Wahrscheinlich, weil das Signal nicht gut genug ist"
	arr["TURKISH",488]="PIN, Arcadyan algoritması kullanılarak oluşturulamaz. Erişim noktasından eksiksiz bir \"probe\" yanıtı toplanamadı. Muhtemelen düşük sinyal kalitesi nedeniyle"
	arr["ARABIC",488]="كاملة من نقطة الوصول. ربما بسبب انخفاض جودة الإشارة \"probe\" فشل في جمع استجابة .Arcadyan باستخدام خوارزمية PIN لا يمكن إنشاء"
	arr["CHINESE",488]="无法使用 Arcadyan 算法生成 PIN。无法从接入点收集完整的“探测”响应。可能是因为信号质量低"

	arr["ENGLISH",489]="Attempting to collect a complete \"probe\" response from the target access point. This process can take up to 4 minutes..."
	arr["SPANISH",489]="Intentando recoger una respuesta \"probe\" completa del punto de acceso objetivo. Este proceso puede durar hasta 4 minutos..."
	arr["FRENCH",489]="Tentative de collecter une réponse complète de \"probe\" à partir du point d'accès ciblé. Ce processus peut prendre jusqu'à 4 minutes..."
	arr["CATALAN",489]="Intentant recollir una resposta \"probe\" completa del punt d'accés objectiu. Aquest procés pot durar fins a 4 minuts..."
	arr["PORTUGUESE",489]="Tentando coletar uma resposta de \"probe\" completa do ponto do acesso. Este processo pode levar até 4 minutos..."
	arr["RUSSIAN",489]="Попытка собрать полный запрос \"probe\" от целевой точки доступа. Этот процесс может занять до 4 минут..."
	arr["GREEK",489]="Γίνεται προσπάθεια συλλογής πλήρους \"probe\" response από το σημείο πρόσβασης (στόχος). Αυτή η διαδικασία μπορεί να διαρκέσει έως και 4 λεπτά..."
	arr["ITALIAN",489]="Cercando di raccogliere una risposta \"probe\" completa dal punto di accesso obiettivo. Questo processo può richiedere fino a 4 minuti..."
	arr["POLISH",489]="Próba zebrania kompletnej odpowiedzi \"probe\" z docelowego punktu dostępu. Proces ten może potrwać do 4 minut..."
	arr["GERMAN",489]="Versuch, eine vollständige \"probe\"-Antwort vom Zielzugriffspunkt zu sammeln. Dieser Prozess kann bis zu 4 Minuten dauern..."
	arr["TURKISH",489]="Hedef erişim noktasından eksiksiz bir \"probe\" yanıtı toplamaya çalışılıyor. Bu işlem 4 dakika kadar sürebilir..."
	arr["ARABIC",489]="...كاملة من نقطة الوصول الهدف. قد تستغرق هذه العملية ما يصل إلى 4 دقائق \"probe\" محاولة تجميع استجابة"
	arr["CHINESE",489]="正在尝试从目标访问点收集完整的“探测”响应。此过程最多可能需要 4 分钟..."

	arr["ENGLISH",490]="The Arcadyan algorithm needs a very specific data to calculate the PIN (the serial number of the access point). Getting this data can take a lot of time. You can optionally choose to try to generate it. This generated PIN is very useful in networks of type Orange-XXXX"
	arr["SPANISH",490]="El algoritmo Arcadyan necesita un dato muy concreto para poder calcular el PIN (el número de serie del punto de acceso). Obtener este dato puede llevar bastante tiempo. Podrás elegir opcionalmente intentar generarlo. Este PIN generado es muy útil en redes del tipo Orange-XXXX"
	arr["FRENCH",490]="L'algorithme Arcadyan nécessite des données très spécifiques pour calculer le PIN (le numéro de série du point d'accès). L'obtention de ces données peut prendre un certain temps. Vous pouvez choisir optionnellement d'essayer de le générer. Ce PIN généré est très utile dans les réseaux de type Orange-XXXX"
	arr["CATALAN",490]="L'algoritme Arcadyan necessita una dada molt concret per poder calcular el PIN (el nombre de sèrie del punt d'accés). Obtenir aquesta dada pot portar prou de temps. Podràs triar opcionalment intentar generar-lo. Aquest PIN generat és molt útil en xarxes del tipus Orange-XXXX"
	arr["PORTUGUESE",490]="O algoritmo Arcadyan precisa de dados muito específicos para calcular o PIN (o número de série do ponto de acesso). Obter esses dados pode levar bastante tempo mas você pode optar por tentar gerá-los. O PIN gerado é muito útil nas redes Orange-XXXX"
	arr["RUSSIAN",490]="Алгоритм Arcadyan требует очень специфических данных для расчета PIN-кода (серийный номер точки доступа). Получение этих данных может занять много времени. При желании вы можете сгенерировать PIN, используя этот алгоритм. Этот сгенерированный PIN-код очень полезен в сетях типа Orange-XXXX"
	arr["GREEK",490]="Ο αλγόριθμος Arcadyan χρειάζεται πολύ συγκεκριμένα δεδομένα για τον υπολογισμό του PIN (ο σειριακός αριθμός του σημείου πρόσβασης). Η λήψη αυτών των δεδομένων μπορεί να χρειαστεί αρκετό χρόνο. Μπορείτε να επιλέξετε να προσπαθήσετε να το δημιουργήσετε. Tο PIN που θα δημιουργηθεί είναι πολύ χρήσιμο σε δίκτυα τύπου Orange-XXXX"
	arr["ITALIAN",490]="L'algoritmo Arcadyan richiede dati molto specifici per calcolare il PIN (il numero di serie del punto di accesso). Ottenere questi dati può richiedere molto tempo. Puoi scegliere opzionalmente di provare a generarlo. Questo PIN generato è molto utile nelle reti di tipo Orange-XXXX"
	arr["POLISH",490]="Algorytm Arcadyan potrzebuje bardzo specyficznych danych do obliczania numeru PIN (numeru seryjny punktu dostępu). Uzyskanie tych danych może zająć trochę czasu. Można opcjonalnie zdecydować się na jego wygenerowanie. Ten wygenerowany kod PIN jest bardzo przydatny w sieciach typu Orange-XXXX"
	arr["GERMAN",490]="Der Arcadyan-Algorithmus benötigt sehr spezifische Daten, um die PIN (die Seriennummer des Access Points) berechnen zu können. Die Beschaffung dieser Daten kann sehr lange dauern. Sie können optional auswählen, ob Sie versuchen möchten, es zu generieren. Diese generierte PIN ist sehr nützlich in Netzwerken vom Typ Orange-XXXX"
	arr["TURKISH",490]="Arcadyan algoritmasının PIN'i hesaplamak için çok özel bir veriye ihtiyacı vardır (erişim noktasının seri numarası). Bu verileri almak çok zaman alabilir. İsteğe bağlı olarak onu oluşturmayı deneyebilirsiniz. Bu oluşturulan PIN, Orange-XXXX türündeki ağlarda çok kullanışlıdır"
	arr["ARABIC",490]="Orange-XXXX الذي تم إنشاؤه مفيدًا جدًا في الشبكات من النوع PIN (الرقم التسلسلي لنقطة الوصول). قد يستغرق الحصول على هذه البيانات الكثير من الوقت. يمكنك اختياريا محاولة إنشائه. يعتبر رمز PIN إلى بيانات محددة جدًا لحساب Arcadyan تحتاج خوارزمية"
	arr["CHINESE",490]="Arcadyan 算法需要非常具体的数据来计算 PIN (接入点的序列号) 。获取这些数据可能会花费很多时间。您可以选择尝试生成它。此生成的 PIN 在 Orange-XXXX 类型的网络中非常有用"

	arr["ENGLISH",491]="Arcadyan algorithm is not useful for the selected target network, a valid value can't be calculated"
	arr["SPANISH",491]="El algoritmo Arcadyan no sirve para la red objetivo seleccionada, no se puede calcular un valor válido"
	arr["FRENCH",491]="L'algorithme Arcadyan ne correspond pas au réseau sélectionné, une valeur valide ne peut pas être calculée"
	arr["CATALAN",491]="L'algoritme Arcadyan no serveix per a la xarxa objectiu seleccionada, no es pot calcular un valor vàlid"
	arr["PORTUGUESE",491]="O algoritmo Arcadyan não se encaixa na rede selecionada, não foi possível calcular um valor válido"
	arr["RUSSIAN",491]="Алгоритм Arcadyan бесполезен для выбранной целевой сети, действительное значение не может быть рассчитано"
	arr["GREEK",491]="Ο αλγόριθμος Arcadyan δεν είναι χρήσιμος για το επιλεγμένο δίκτυο, δεν μπορεί να υπολογιστεί έγκυρη τιμή"
	arr["ITALIAN",491]="L'algoritmo Arcadyan non è adatto alla rete selezionata come obiettivo, non è possibile calcolare un valore valido"
	arr["POLISH",491]="Algorytm Arcadyan nie pasuje do wybranej sieci docelowej, nie można obliczyć prawidłowej wartości"
	arr["GERMAN",491]="Der Arcadyan-Algorithmus funktioniert nicht für das ausgewählte Zielnetzwerk, ein gültiger Wert kann nicht berechnet werden"
	arr["TURKISH",491]="Arcadyan algoritması seçilen hedef ağ için kullanışlı değildir, geçerli bir değer hesaplanamaz"
	arr["ARABIC",491]="لا تتطابق خوارزمية Arcadyan مع الشبكة المحددة ، ولا يمكن حساب قيمة صالحة"
	arr["CHINESE",491]="Arcadyan 算法对选定的目标网络无用，无法计算出有效值"

	arr["ENGLISH",492]="The Arcadyan algorithm can't be calculated. Although you chose the bully option for the attack, you need to use wash (included in reaver package) to calculate that PIN and you don't have it installed. The script will continue the attack without including it"
	arr["SPANISH",492]="El algoritmo Arcadyan no puede ser calculado. Aunque elegiste la opción de ataque con bully, para calcular ese PIN se necesita utilizar wash (incluido en el paquete reaver) y tú no lo tienes instalado. El script continuará el ataque sin incluirlo"
	arr["FRENCH",492]="L'algorithme Arcadyan ne peut pas être calculé. Bien que vous ayez choisi l'option d'attaque bully, pour calculer ce PIN, vous devez utiliser wash (inclus dans le paquet reaver) et vous ne l'avez pas installé. Le script continuera l'attaque sans l'inclure"
	arr["CATALAN",492]="L'algoritme Arcadyan no pot ser calculat. Encara que vas triar l'opció d'atac amb bully, per calcular aquest PIN es necessita utilitzar wash (inclòs en el paquet reaver) i tu no el tens instal·lat. El script continuarà l'atac sense incloure"
	arr["PORTUGUESE",492]="O algoritmo Arcadyan não pôde efetuar o calculo. Embora você tenha escolhido a opção de ataque com bully, para calcular esse PIN, você precisa usar wash (incluso no pacote reaver) que você não possui. O script continuará o ataque sem calculá-lo"
	arr["RUSSIAN",492]="Алгоритм Arcadyan не может быть рассчитан. Вы выбрали опцию bully для атаки, а для расчета этого PIN-кода вам необходимо использовать wash (включенную в пакет reaver), который у вас не установлен. Скрипт продолжит атаку без этого алгоритма"
	arr["GREEK",492]="Ο αλγόριθμος Arcadyan δεν μπορεί να υπολογιστεί. Παρόλο που επιλέξατε την επιλογή bully για την επίθεση, χρειάζεται να χρησιμοποιήσετε το wash (περιλαμβάνεται στο πακέτο του reaver) για να υπολογίσετε το PIN και δεν το έχετε εγκαταστήσει. Το script θα συνεχίσει την επίθεση χωρίς να το συμπεριλάβει"
	arr["ITALIAN",492]="L'algoritmo Arcadyan non può essere calcolato. Anche se hai scelto l'opzione di attacco con bully, per calcolare quel PIN che devi usare wash (incluso nel pacchetto reaver) e non l'hai installato. Lo script continuerà l'attacco senza includerlo"
	arr["POLISH",492]="Nie można obliczyć algorytmu Arcadyan. Chociaż wybrano opcję ataku za pomocą bully, aby obliczyć ten kod PIN, musisz użyć wash (dołączonego do pakietu reaver) i nie masz go zainstalowanego. Skrypt będzie kontynuował atak bez jego włączania"
	arr["GERMAN",492]="Der Arcadyan-Algorithmus kann nicht berechnet werden. Obwohl Sie den bully-Angriff gewählt haben, müssen Sie zur Berechnung dieser PIN die Funktion wash verwenden (im Paket reaver enthalten), und Sie haben sie nicht installiert. Das Skript setzt den Angriff fort, ohne es einzuschließen"
	arr["TURKISH",492]="Arcadyan algoritması hesaplanamadı. Saldırı için zorlama seçeneğini seçmiş olmanıza rağmen, bu PIN'i hesaplamak için wash kullanmanız (reaver paketine dahil) ve onu yüklememeniz gerekir. Bu kullanılmadan devam edilecek"
	arr["ARABIC",492]="هذا ولم يكن مثبتًا لديك. سيستمر البرنامج في الهجوم دون تضمينه PIN لحساب رقم التعريف الشخصي (reaver الموجود في حزمة) wash للهجوم ، فأنت بحاجة إلى استخدام bully لى الرغم من أنك اخترت خيار .Arcadyan ا يمكن حساب خوارزمية"
	arr["CHINESE",492]="Arcadyan 算法无法计算。尽管您为攻击选择了 bully 选项，但您需要使用 wash (包含在 reaver 软件包中) 来计算该 PIN，而您没有安装它。该脚本将继续攻击而不包括它"

	arr["ENGLISH",493]="The Arcadyan algorithm PIN has already been calculated for this target (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). There is no need to calculate it again"
	arr["SPANISH",493]="El PIN del algoritmo Arcadyan ya fue calculado para este objetivo (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). No hace falta calcularlo de nuevo"
	arr["FRENCH",493]="Le PIN de l'algorithme Arcadyan a était déjà calculé pour cette cible (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Pas besoin de le calculer à nouveau"
	arr["CATALAN",493]="El PIN de l'algoritme Arcadyan ja va ser calculat per a aquest objectiu (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). No cal calcular-lo de nou"
	arr["PORTUGUESE",493]="O PIN com algoritmo Arcadyan já foi calculado para esta rede (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Não é necessário calculá-lo novamente"
	arr["RUSSIAN",493]="PIN с помощью алгоритма Arcadyan уже рассчитан для этой цели (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Нет необходимости вычислять его снова"
	arr["GREEK",493]="Ο αλγόριθμος Arcadyan PIN έχει ήδη υπολογιστεί για αυτό το δίκτυο (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Δεν χρειάζεται να υπολογιστεί ξανά"
	arr["ITALIAN",493]="Il PIN dell'algoritmo Arcadyan è già stato calcolato per questo obiettivo (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Non c'è bisogno di calcolarlo di nuovo"
	arr["POLISH",493]="PIN algorytm Arcadyan został już obliczony dla tego celu (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Nie musisz go ponownie obliczać"
	arr["GERMAN",493]="Die Arcadyan-Algorithmus-PIN wurde bereits für diesen Target berechnet (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Keine Notwendigkeit, es erneut zu berechnen"
	arr["TURKISH",493]="Arcadyan algoritması PIN'i zaten bu hedef için hesaplanmıştır (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}). Tekrar hesaplamaya gerek yok"
	arr["ARABIC",493]="ليست هناك حاجة لحسابه مرة أخرى .(\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color}) لهذا الهدف Arcadyan لخوارزمية PIN تم بالفعل حساب رقم التعريف الشخصي"
	arr["CHINESE",493]="已经为此目标计算了基于 Arcadyan 算法的 PIN (\${normal_color}\${wps_data_array[\${wps_bssid},'Arcadyan']}\${yellow_color})。无需重新计算"

	arr["ENGLISH",494]="14. Offline PIN generation using algorithms and database"
	arr["SPANISH",494]="14. Generación offline de PINs con algoritmos y base de datos"
	arr["FRENCH",494]="14. Génération offline de PINs avec les algorithmes et la base de données"
	arr["CATALAN",494]="14. Generació offline de PINs amb algoritmes i base de dades"
	arr["PORTUGUESE",494]="14. Gerar PINs offline com algoritmos e com o banco de dados"
	arr["RUSSIAN",494]="14. Офлайн генерация PIN-кода, используя алгоритмы и базу данных"
	arr["GREEK",494]="14. Offline δημιουργία PIN με χρήση δίαφορων αλγορίθμων και έτοιμης βάσης δεδομένων"
	arr["ITALIAN",494]="14. Generazione offline di PIN con algoritmi e database"
	arr["POLISH",494]="14. Generowanie offline kodów PIN z algorytmami i bazą danych"
	arr["GERMAN",494]="14. Offline Generierung von PINs mit Algorithmen und Datenbank"
	arr["TURKISH",494]="14. Algoritmaları ve veritabanını kullanarak çevrimdışı PIN üretimi"
	arr["ARABIC",494]="14. بدون اتصال باستخدام الخوارزميات وقاعدة البيانات PIN توليد"
	arr["CHINESE",494]="14. 使用算法和数据库离线生成 PIN"

	arr["ENGLISH",495]="Offline PIN generation menu"
	arr["SPANISH",495]="Menú de generación offline de PINs"
	arr["FRENCH",495]="Menu de génération de PIN offline"
	arr["CATALAN",495]="Menú de generació offline de PINs"
	arr["PORTUGUESE",495]="Menu de geração offline de PINs"
	arr["RUSSIAN",495]="Меню создания PIN-кода"
	arr["GREEK",495]="Μενού offline δημιουργίας PIN"
	arr["ITALIAN",495]="Menu di generazione offline dei PIN"
	arr["POLISH",495]="Menu generowania PIN offline"
	arr["GERMAN",495]="Menü zur Offline-Generierung von PINs"
	arr["TURKISH",495]="Çevrimdışı PIN oluşturma menüsü"
	arr["ARABIC",495]="بدون اتصال PIN قائمة إنشاء"
	arr["CHINESE",495]="离线 PIN 生成菜单"

	arr["ENGLISH",496]="5.  Search in PIN database"
	arr["SPANISH",496]="5.  Consultar en la base de datos de PINs"
	arr["FRENCH",496]="5.  Chercher dans la base de données PIN"
	arr["CATALAN",496]="5.  Consultar a la base de dades de PINs"
	arr["PORTUGUESE",496]="5.  Verificar PINs no banco de dados"
	arr["RUSSIAN",496]="5.  Поиск в базе данных PIN-кода"
	arr["GREEK",496]="5.  Αναζήτηση στη βάση δεδομένων PIN"
	arr["ITALIAN",496]="5.  Controllare il database dei PIN"
	arr["POLISH",496]="5.  Sprawdź bazę danych PIN"
	arr["GERMAN",496]="5.  Suchen Sie in der PIN-Datenbank"
	arr["TURKISH",496]="5.  PIN veritabanında ara"
	arr["ARABIC",496]="5.  PIN البحث في قاعدة بيانات"
	arr["CHINESE",496]="5.  在 PIN 数据库中搜索"

	arr["ENGLISH",497]="0.  Return to WPS attacks menu"
	arr["SPANISH",497]="0.  Volver al menú de ataques WPS"
	arr["FRENCH",497]="0.  Retour au menu d'attaques WPS"
	arr["CATALAN",497]="0.  Tornar al menú d'atacs WPS"
	arr["PORTUGUESE",497]="0.  Voltar ao menu de ataques WPS"
	arr["RUSSIAN",497]="0.  Вернуться в меню атак WPS"
	arr["GREEK",497]="0.  Επιστροφή στο μενού επιθέσεων WPS"
	arr["ITALIAN",497]="0.  Tornare al menú attacchi WPS"
	arr["POLISH",497]="0.  Wróć do menu Atak WPS"
	arr["GERMAN",497]="0.  Zum WPS-Angriffsmenü zurückkehren"
	arr["TURKISH",497]="0.  WPS saldırıları menüsüne dön"
	arr["ARABIC",497]="0.  WPS ارجع إلى قائمة هجمات"
	arr["CHINESE",497]="0.  返回 WPS 攻击菜单"

	arr["ENGLISH",498]="choose database or algorithm"
	arr["SPANISH",498]="escoge base de datos o algoritmo"
	arr["FRENCH",498]="choisissez la base de données ou l'algorithme"
	arr["CATALAN",498]="tria base de dades o algoritme"
	arr["PORTUGUESE",498]="escolha um algoritmo ou o banco de dados"
	arr["RUSSIAN",498]="выбрать базу данных или алгоритм"
	arr["GREEK",498]="επιλέξτε βάση δεδομένων ή αλγόριθμο"
	arr["ITALIAN",498]="scegliere database o algoritmo"
	arr["POLISH",498]="wybierz bazę danych lub algorytm"
	arr["GERMAN",498]="Wählen Sie eine Datenbank oder einen Algorithmus"
	arr["TURKISH",498]="veritabanı veya algoritma seç"
	arr["ARABIC",498]="اختيار قاعدة البيانات أو خوارزمية"
	arr["CHINESE",498]="请选择数据库或算法"

	arr["ENGLISH",499]="Showing matches in the PIN database..."
	arr["SPANISH",499]="Mostrando coincidencias de la base de datos de PINs..."
	arr["FRENCH",499]="Afficher les résultats de la base de données PIN..."
	arr["CATALAN",499]="Mostrant coincidències de la base de dades de PINs..."
	arr["PORTUGUESE",499]="Mostrando correspondências de PINs do banco de dados..."
	arr["RUSSIAN",499]="Отображение совпадений в базе данных PIN-кода..."
	arr["GREEK",499]="Εμφάνιση αντιστοιχιών στη βάση δεδομένων PIN..."
	arr["ITALIAN",499]="Mostrando le corrispondenze del database dei PIN..."
	arr["POLISH",499]="Wyświetlanie dopasowań z bazy danych PIN..."
	arr["GERMAN",499]="Übereinstimmungen der PIN-Datenbank werden angezeigt..."
	arr["TURKISH",499]="PIN veritabanında eşleşme gösteriliyor..."
	arr["ARABIC",499]="...PIN إظهارالتطابقات في قاعدة بيانات"
	arr["CHINESE",499]="显示 PIN 数据库中的匹配项..."

	arr["ENGLISH",500]="Showing calculated PIN using ComputePIN algorithm..."
	arr["SPANISH",500]="Mostrando PIN calculado con el algoritmo ComputePIN..."
	arr["FRENCH",500]="Affichage du PIN calculé avec l'algorithme ComputePIN..."
	arr["CATALAN",500]="Mostrant PIN calculat amb l'algoritme ComputePIN..."
	arr["PORTUGUESE",500]="Mostrando o PIN calculado usando o algoritmo ComputePIN..."
	arr["RUSSIAN",500]="Отображение PIN-кода, рассчитанного с использованием алгоритма ComputePIN..."
	arr["GREEK",500]="Εμφανίζεται το PIN που έχει υπολογιστεί χρησιμοποιώντας τον αλγόριθμο ComputePIN..."
	arr["ITALIAN",500]="Mostrando il PIN calcolato utilizzando l'algoritmo ComputePIN..."
	arr["POLISH",500]="Wyświetlanie kodu PIN obliczonego przy użyciu algorytmu ComputePIN..."
	arr["GERMAN",500]="Berechnete PIN mit dem ComputePIN-Algorithmus anzeigen..."
	arr["TURKISH",500]="ComputePIN algoritması kullanılarak hesaplanan PIN gösteriliyor..."
	arr["ARABIC",500]="...ComputePIN إظهاررقم التعريف الشخصي المحسوب باستخدام خوارزمية"
	arr["CHINESE",500]="显示使用 ComputePIN 算法计算的 PIN..."

	arr["ENGLISH",501]="Showing calculated PIN using EasyBox algorithm..."
	arr["SPANISH",501]="Mostrando PIN calculado con el algoritmo EasyBox..."
	arr["FRENCH",501]="Affichage du PIN calculé avec l'algorithme EasyBox..."
	arr["CATALAN",501]="Mostrant PIN calculat amb l'algoritme EasyBox..."
	arr["PORTUGUESE",501]="Mostrando o PIN calculado usando o algoritmo EasyBox..."
	arr["RUSSIAN",501]="Отображение PIN-кода, рассчитанного с использованием алгоритма EasyBox..."
	arr["GREEK",501]="Εμφανίζεται το PIN που έχει υπολογιστεί χρησιμοποιώντας τον αλγόριθμο EasyBox..."
	arr["ITALIAN",501]="Mostrando il PIN calcolato utilizzando l'algoritmo EasyBox..."
	arr["POLISH",501]="Wyświetlanie kodu PIN przy użyciu algorytmu EasyBox..."
	arr["GERMAN",501]="Angezeigte PIN wird mit dem EasyBox-Algorithmus berechnet..."
	arr["TURKISH",501]="EasyBox algoritması kullanılarak hesaplanan PIN gösteriliyor..."
	arr["ARABIC",501]="...EasyBox إظهاررقم التعريف الشخصي المحسوب باستخدام خوارزمية"
	arr["CHINESE",501]="显示使用 EasyBox 算法计算的 PIN..."

	arr["ENGLISH",502]="Showing calculated PIN using Arcadyan algorithm..."
	arr["SPANISH",502]="Mostrando PIN calculado con el algoritmo Arcadyan..."
	arr["FRENCH",502]="Affichage du PIN calculé avec de l'algorithme Arcadyan..."
	arr["CATALAN",502]="Mostrant PIN calculat amb l'algoritme Arcadyan..."
	arr["PORTUGUESE",502]="Mostrando o PIN calculado usando o algoritmo Arcadyan..."
	arr["RUSSIAN",502]="Отображение PIN-кода, рассчитанного с использованием алгоритма Arcadyan..."
	arr["GREEK",502]="Εμφανίζεται το PIN που έχει υπολογιστεί χρησιμοποιώντας τον αλγόριθμο Arcadyan..."
	arr["ITALIAN",502]="Mostrando il PIN calcolato utilizzando l'algoritmo Arcadyan..."
	arr["POLISH",502]="Wyświetlanie kodu PIN obliczonego przy użyciu algorytmu Arcadyan..."
	arr["GERMAN",502]="Berechnete PIN mit Arcadyan-Algorithmus anzeigen..."
	arr["TURKISH",502]="Arcadyan algoritması kullanılarak hesaplanan PIN gösteriliyor..."
	arr["ARABIC",502]="...Arcadyan إظهاررقم التعريف الشخصي المحسوب باستخدام خوارزمية"
	arr["CHINESE",502]="显示使用 Arcadyan 算法计算的 PIN..."

	arr["ENGLISH",503]="It's not necessary to perform the scan again to calculate the Arcadyan algorithm PIN. This has already been done in this session"
	arr["SPANISH",503]="No es necesario realizar de nuevo el escaneo para calcular el PIN del algoritmo Arcadyan. Ya se realizó anteriormente en esta sesión"
	arr["FRENCH",503]="Il n'est pas nécessaire d'effectuer de nouveau un scan pour calculer le PIN de l'algorithme Arcadyan. Déjà fait dans cette session"
	arr["CATALAN",503]="No cal realitzar de nou l'escaneig per calcular el PIN de l'algoritme Arcadyan. Ja es va realitzar anteriorment en aquesta sessió"
	arr["PORTUGUESE",503]="Não é necessário executar uma verificação novamente para calcular o PIN com algoritmo Arcadyan. Isso já foi feito nesta sessão"
	arr["RUSSIAN",503]="Нет необходимости снова выполнять сканирование, чтобы вычислить PIN-код алгоритмом Arcadyan. Это уже сделано ранее в ходе этой сессии"
	arr["GREEK",503]="Δεν είναι απαραίτητο να εκτελέσετε ξανά το scan για να υπολογίσετε το PIN χρησιμοποιώντας τον Arcadyan αλγόριθμο. Έχει ήδη πραγματοποιηθεί σε αυτή τη συνεδρία"
	arr["ITALIAN",503]="Non è necessario eseguire nuovamente la scansione per calcolare il PIN dell'algoritmo Arcadyan. È già stato fatto in precedenza in questa sessione"
	arr["POLISH",503]="Nie jest konieczne przeprowadzanie skanowania aby obliczyć PIN algorytmem Arcadyan. Już zrobiliśmy je wcześniej w tej sesji"
	arr["GERMAN",503]="Es ist nicht erforderlich, den Scan erneut durchzuführen, um die Arcadyan-Algorithmus-PIN zu berechnen. Es wurde zuvor in dieser Sitzung gemacht"
	arr["TURKISH",503]="Arcadyan algoritma PIN'ini hesaplamak için taramayı tekrar yapmak gerekli değildir. Bu zaten bu oturumda yapıldı"
	arr["ARABIC",503]="ليس من الضروري إجراء الفحص مرة أخرى لحساب PIN لخوارزمية Arcadyan. وقد تم بالفعل القيام بذلك في هذه الدورة"
	arr["CHINESE",503]="无需再次执行扫描即可计算 Arcadyan 算法 PIN。已经在本次会话中完成"

	arr["ENGLISH",504]="\${blue_color}This PIN calculation process is not entirely offline. A complete \"probe\" response is required from the target access point to obtain a necessary data. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",504]="\${blue_color}Este proceso de cálculo de PIN no es puramente offline. Hace falta una respuesta \"probe\" completa del punto de acceso objetivo para obtener un dato necesario. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",504]="\${blue_color}Ce processus de calcul du PIN n'est pas entièrement offline. Une réponse \"probe\" complète est requise part le point d'accès ciblés pour obtenir les données nécessaires. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",504]="\${blue_color}Aquest procés de càlcul de PIN no és purament offline. Cal una resposta \"probe\" completa del punt d'accés objectiu per obtenir una dada necessaria. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",504]="\${blue_color}Este processo de cálculo do PIN não é totalmente offline. É necessária uma resposta de \"probe\" completa do ponto de acesso alvo para obter os dados necessários. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",504]="\${blue_color}Этот процесс расчета PIN-кода не является чисто офлайн. От целевой точки доступа требуется полный запрос \"probe\" для получения необходимых данных. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",504]="\${blue_color}Αυτή η διαδικασία υπολογισμού PIN δεν είναι καθ' αυτοὺ offline. Απαιτείται ένα ολοκληρωμένο \"probe\" response από το σημείο πρόσβασης για να ληφθούν τα απαραίτητα δεδομένα. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",504]="\${blue_color}Questo processo di calcolo del PIN non è puramente offline. É richiesta una risposta completa \"probe\" dal punto di accesso obiettivo per ottenere i dati necessari. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",504]="\${blue_color}Ten proces obliczania kodu PIN nie jest wyłącznie offline. Wymagana jest pełna odpowiedź \"probe\" z docelowego punktu dostępu, aby uzyskać niezbędne dane. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",504]="\${blue_color}Dieser PIN-Berechnungsprozess ist nicht rein offline. Eine vollständige \"probe\"-Antwort vom Zielzugriffspunkt wird benötigt, um die erforderlichen Daten zu erhalten. \${green_color} Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",504]="\${blue_color}Bu PIN hesaplama işlemi tamamen çevrimdışı değildir. Gerekli bir veri elde etmek için hedef erişim noktasından eksiksiz bir \"probe\" yanıtı gerekir. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",504]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .كاملة من نقطة الوصول المستهدفة للحصول على البيانات الضرورية \"probe\" هذه ليست غيرمتصلة بالإنترنت بالكامل. مطلوب استجابة PIN عملية حساب رقم التعريف الشخصي\${normal_color}"
	arr["CHINESE",504]="\${blue_color}这个PIN计算过程并不完全是离线的。目标接入点需要一个完整的“探测”响应来获取必要的数据。\${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",505]="Do you want to enable \"DoS pursuit mode\"? \${blue_color}This will re-launch the attack if target AP change its channel countering \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["SPANISH",505]="¿Deseas activar el \"modo persecución DoS\"? \${blue_color}Esto relanzará el ataque si el AP objetivo cambia de canal contrarrestando el \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["FRENCH",505]="Voulez-vous activer le \"mode de poursuite DoS\"? \${blue_color}Cela relancera l'attaque si le AP cible change de canal en contrecarrant le \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["CATALAN",505]="¿Vols activar el \"mode persecució DoS\"? \${blue_color}Això rellançarà l'atac si l'AP objectiu canvia de canal contrarestant el \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",505]="Você deseja ativar o \"modo de perseguição\"? \${blue_color}Isso irá iniciar o ataque novamente se o alvo mudar de canal, evitando o \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["RUSSIAN",505]="Вы хотите включить \"режим преследования DoS\"? \${blue_color}Это мера противодействия \"channel hopping\" (автоматической смены канала ТД); атака будет перезапущена, если ТД изменит свой канал \${normal_color}\${visual_choice}"
	arr["GREEK",505]="Θέλετε να ενεργοποιήσετε to \"DoS pursuit mode\"; \${blue_color}Αυτό θα ξεκινήσει πάλι την επίθεση, εάν το σημείο πρόσβασης αλλάξει το κανάλι του \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["ITALIAN",505]="Vuoi attivare la modalità \"DoS pursuit mode\"? \${blue_color}Questo riprenderà l'attacco se l'AP obiettivo cambia i canali contrastando il \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["POLISH",505]="Czy chcesz uaktywnić \"tryb DoS pursuit\"? \${blue_color}To spowoduje ponowne uruchomienie ataku, jeśli docelowy punkt dostępu AP zmieni kanały \"channel hopping\" \${normal_color}\${visual_choice}"
	arr["GERMAN",505]="Möchten Sie den \"DoS pursuit mode\" aktivieren? \${blue_color}Dadurch wird der Angriff erneut gestartet, wenn der Ziel-AP den Kanal ändert, indem er dem \"channel hopping\" entgegenwirkt \${normal_color}\${visual_choice}"
	arr["TURKISH",505]="\"DoS pursuit mode\" özelliğini etkinleştirmek ister misiniz? \${blue_color}Bu, hedef AP'nin kanal sayma \"channel hopping\" \${normal_color}\${visual_choice} \${blue_color}kanalını değiştirmesi durumunda saldırıyı yeniden başlatır"
	arr["ARABIC",505]="\${normal_color}\${visual_choice}\${blue_color} \"channel hopping\" الهدف مواجها القناة AP سيؤدي هذا إلى إطلاق الهجوم مرة أخرى إذا غيّر \${green_color}؟\"DoS pursuit mode\"هل تريد تفعيل وضع\${normal_color}"
	arr["CHINESE",505]="您要启用“信道追踪模式”吗？\${blue_color}如果目标 AP 改变其工作信道，脚本也会自动追踪并重新发起攻击 \${normal_color}\${visual_choice}"

	arr["ENGLISH",506]="DoS attack with the \"DoS pursuit mode\" enabled will start when you press [Enter] on this window. To stop it you must press [Ctrl+C] or close attack window"
	arr["SPANISH",506]="El ataque DoS con el \"modo persecución DoS\" activado comenzará cuando pulse [Enter] en esta ventana. Para detenerlo deberá pulsar [Ctrl+C] o cerrar la ventana del ataque"
	arr["FRENCH",506]="L'attaque DoS avec le \"mode de poursuite DoS\" activation démarrera lorsque vous appuyez sur [Enter] dans cette fenêtre. Pour l'arrêter, vous devez appuyer sur [Ctrl+C] ou fermer la fenêtre d'attaque"
	arr["CATALAN",506]="L'atac DoS amb el \"mode persecució DoS\" activat començarà quan premeu [Enter] en aquesta finestra. Per aturar-lo haurà de prémer [Ctrl+C] o tancar la finestra de l'atac"
	arr["PORTUGUESE",506]="O ataque DoS com o \"modo de perseguição\" foi ativo e será iniciado quando você pressionar [Enter] nesta janela. Para parar, você deve pressionar [Ctrl+C] ou fechar a janela do ataque"
	arr["RUSSIAN",506]="DoS-атака с включенным \"режимом DoS преследования\" будет запущена когда вы в этом окне нажмёте [Enter]. Для её остановки нажмите [Ctrl+C] или закройте окно атаки"
	arr["GREEK",506]="Η επίθεση DoS με το \"DoS pursuit mode\" ενεργοποιημένο θα ξεκινήσει όταν πατήσετε [Enter] σε αυτό το παράθυρο. Για να το σταματήσετε πρέπει να πατήσετε [Ctrl+C] ή να κλείσετε το παράθυρο"
	arr["ITALIAN",506]="L'attacco DoS con la modalità \"DoS pursuit mode\" attivata inizierá quando si preme [Enter] in questa finestra. Per fermarlo bisogna premere [Ctrl+C] o chiudere la finestra di attacco"
	arr["POLISH",506]="Atak DoS z uruchomionym trybem \"DoS pursuit\" zostanie uruchomiony po naciśnięciu przycisku [Enter] w tym oknie. Aby go zatrzymać, musisz nacisnąć [Ctrl+C] lub zamknąć okno ataku"
	arr["GERMAN",506]="Der DoS-Angriff mit aktiviertem \"DoS pursuit mode\" wird gestartet, wenn Sie in diesen Fenster [Enter] drücken. Um es zu stoppen, müssen Sie [Ctrl+C] drücken oder das Angriffsfenster schließen"
	arr["TURKISH",506]="Bu pencerede [Enter] 'a bastığınızda, \"DoS takip modu\" etkin olan DoS saldırısı başlayacaktır. Durdurmak için [Ctrl+C] tuşuna basmalı veya saldırı penceresini kapatmalısınız"
	arr["ARABIC",506]="أو إغلاق نافذة الهجوم [Ctrl+C] في هذه النافذة. لإيقافه يجب الضغط على [Enter] عندما تضغط على \"DoS pursuit mode\" مع تفعيل وضع DoS سيبدأ هجوم"
	arr["CHINESE",506]="当您在此窗口中按下 [Enter] 时，启用“信道追踪模式”的 DoS 攻击将开始。要停止它，您必须按 [Ctrl+C] 或关闭攻击窗口"

	arr["ENGLISH",507]="Channel change detected. Reconfiguring attack (AP and DoS) as part of \"DoS pursuit mode\". Now on channel \${normal_color}\${channel}"
	arr["SPANISH",507]="Cambio de canal detectado. Reconfigurando ataque (AP y DoS) como parte del \"modo persecución DoS\". Ahora en el canal \${normal_color}\${channel}"
	arr["FRENCH",507]="Changement de canal détecté. Reconfiguration de l'attaque (AP et DoS) dans le cadre du \"mode de poursuite DoS\". Maintenant sur le canal \${normal_color}\${channel}"
	arr["CATALAN",507]="S'ha detectat un canvi de canal. S'està reconfigurant l'atac (AP i DoS) com a part del \"Mode de persecució DoS\". Ara al canal \${normal_color}\${channel}"
	arr["PORTUGUESE",507]="Mudança de canal detectada. Reconfigurando o ataque (AP e DoS) no \"modo de perseguição\". Agora no canal \${normal_color}\${channel}"
	arr["RUSSIAN",507]="Обнаружено изменение канала. Реконфигурация атаки (AP и DoS) \"режимом DoS преследования\". Сейчас на канале \${normal_color}\${channel}"
	arr["GREEK",507]="Εντοπίστηκε αλλαγή καναλιού. Επαναδιαμόρφωση επίθεσης (AP και DoS) ως μέρος της \"DoS pursuit mode\". Τώρα στο κανάλι \${normal_color}\${channel}"
	arr["ITALIAN",507]="Cambio di canale rilevato. Riconfigurando l'attacco (AP e DoS) come parte della \"DoS pursuit mode\". Ora sul canale \${normal_color}\${channel}"
	arr["POLISH",507]="Wykryto zmianę kanału. Rekonfiguracja ataku (AP i DoS) w ramach \"DoS pursuit\". Teraz na kanale \${normal_color}\${channel}"
	arr["GERMAN",507]="Kanalwechsel erkannt. Angriff (AP und DoS) als Teil des \"DoS pursuit mode\" rekonfiguriert. Jetzt auf Kanal \${normal_color}\${channel}"
	arr["TURKISH",507]="Kanal değişikliği algılandı. Saldırı (AP ve DoS) \"DoS takip modu\"nun bir parçası olarak yeniden şekillendiriliyor. Şimdi \${normal_color}\${channel} kanalında"
	arr["ARABIC",507]="\${normal_color}\${channel} \${yellow_color}انت الان علي القناة .\"DoS pursuit mode\" كجزء من (AP , DoS) تم اكتشاف تغير في القناة, وسيتم اعادة تكويت الهجوم \${normal_color}"
	arr["CHINESE",507]="检测到信道更改。已将攻击 (AP 和 DoS) 重新配置为“DoS 追踪模式”。当前信道 \${normal_color}\${channel}"

	arr["ENGLISH",508]="\"DoS pursuit mode\" can be unstable for this kind of DoS attack. If you are not obtaining an optimal result just select another kind of attack"
	arr["SPANISH",508]="El \"modo persecución DoS\" puede ser inestable para este tipo de ataque DoS. Si el resultado no es óptimo selecciona otro tipo de ataque"
	arr["FRENCH",508]="Le \"mode de poursuite DoS\" peut être instable pour ce type d'attaque DoS. Si le résultat n'est pas optimal, sélectionnez un autre type d'attaque"
	arr["CATALAN",508]="El \"mode persecució DoS\" pot ser inestable per a aquest tipus d'atac DoS. Si el resultat no és òptim selecciona un altre tipus d'atac"
	arr["PORTUGUESE",508]="O ataque DoS com o \"modo de perseguição\" pode ser instável. Se o resultado não for bom, selecione outro tipo de ataque"
	arr["RUSSIAN",508]="\"Режим DoS преследования\" может быть нестабильной для такой DoS-атаки. Если вы не получаете приемлемого результата, просто выберите другой тип атаки"
	arr["GREEK",508]="Το \"DoS pursuit mode\" μπορεί να είναι ασταθής για αυτό το είδος επίθεσης DoS. Εάν δεν δείτε σωστό αποτέλεσμα, επιλέξτε κάποιο άλλο είδος επίθεσης"
	arr["ITALIAN",508]="La modalitá \"DoS pursuit mode\" può essere instabile per questo tipo di attacco DoS. Se il risultato non è ottimale selezionare un altro tipo di attacco"
	arr["POLISH",508]="\"tryb DoS pursuit\" może być niestabilny dla tego typu ataków DoS. Jeśli wynik nie jest optymalny, wybierz inny rodzaj ataku"
	arr["GERMAN",508]="Der \"DoS pursuit mode\" kann für diese Art von DoS-Angriff instabil sein. Wenn das Ergebnis nicht optimal ist, wählen Sie eine andere Art von Angriff aus"
	arr["TURKISH",508]="\"DoS takip modu\" bu tür DoS saldırısı için kararsız olabilir. Optimal bir sonuç elde edemiyorsanız, başka bir saldırı seçin"
	arr["ARABIC",508]="إذا لم تحصل على نتيجة مثالية ، فما عليك سوى اختيار نوع هجوم آخر .DoS يمكن أن يكون غير مستقر لهذا النوع من هجمات \"DoS pursuit mode\" وضع"
	arr["CHINESE",508]="\"DoS 追踪模式\" 对于这种 DoS 攻击可能是不稳定的。如果您没有获得最佳结果，只需选择另一种攻击"

	arr["ENGLISH",509]="If you want to integrate \"DoS pursuit mode\" on an Evil Twin attack, another additional wifi interface in monitor mode will be needed to be able to perform it"
	arr["SPANISH",509]="Si se quiere integrar el \"modo persecución DoS\" en un ataque Evil Twin, será necesario tener otro interfaz wifi adicional en modo monitor para llevarlo a cabo"
	arr["FRENCH",509]="Si vous souhaitez intégrer le \"mode de poursuite DoS\" dans une attaque Evil Twin, il sera nécessaire d'avoir une autre interface wifi supplémentaire en mode moniteur pour l'effectuer"
	arr["CATALAN",509]="Si es vol integrar el \"mode persecució DoS\" en un atac Evil Twin, serà necessari tenir una altra interfície wifi addicional en mode monitor per fer-ho"
	arr["PORTUGUESE",509]="Se você quiser integrar o ataque DoS com o \"modo de perseguição\" em um ataque Evil Twin, será necessário ter uma interface wifi adicional no modo monitor"
	arr["RUSSIAN",509]="Если вы хотите интегрировать \"режим DoS преследования\" на атаку Evil Twin, то для выполнения этого потребуется еще один дополнительный интерфейс wifi в режиме монитора"
	arr["GREEK",509]="Εάν θέλετε να ενσωματώσετε το \"DoS pursuit mode\" σε μια επίθεση Evil Twin, θα χρειαστεί μια επιπλέον διεπαφή wifi σε κατάσταση παρακολούθησης για να εκτελεστεί σωστά"
	arr["ITALIAN",509]="Se si desidera integrare la modalitá \"DoS pursuit mode\" in un attacco Evil Twin, sarà necessario disporre di un'altra interfaccia wifi aggiuntiva in modalità monitor"
	arr["POLISH",509]="Jeśli chcesz zintegrować \"tryb DoS pursuit\" w ataku Evil Twin, konieczne będzie posiadanie innego dodatkowego interfejsu wifi w trybie monitorowania"
	arr["GERMAN",509]="Wenn Sie den \"DoS pursuit mode\" in einen Evil-Twin-Angriff integrieren wollen, müssen Sie im monitor-Modus noch eine zusätzliche WLAN-Interface zur Verfügung haben, um es auszuführen"
	arr["TURKISH",509]="Bir Şeytani İkiz saldırısında \"DoS takip modu\" nu entegre etmek isterseniz, bunu gerçekleştirmek için monitör modunda başka bir ek wifi arabirimine ihtiyaç duyulacaktır"
	arr["ARABIC",509]="لتتمكن من تنفيذها monitor mode إضافية في وضع wifi فستكون هناك حاجة إلى واجهة ،Evil Twin في هجوم \"DoS pursuit mode\" إذا كنت ترغب في دمج وضع"
	arr["CHINESE",509]="如果你想在邪恶双胞胎攻击上使用“DoS 追踪模式”，则需要另一个额外的监控模式的 wifi 接口才能执行它"

	arr["ENGLISH",510]="On this screen, it's supposed an additional wifi interface is chosen, but you don't have anyone at this moment"
	arr["SPANISH",510]="En esta pantalla, se supone que deberías elegir otro interfaz wifi adicional, pero no dispones de ninguno en este momento"
	arr["FRENCH",510]="Sur cet écran, vous pourriez choisir une interface wifi supplémentaire, mais vous n'en avez pas d'autre en ce moment"
	arr["CATALAN",510]="En aquesta pantalla, se suposa que hauries de triar un altre interfície wifi addicional, però no disposes de cap en aquest moment"
	arr["PORTUGUESE",510]="Nesta tela você deveria escolher uma interface wifi adicional, mas você não tem nenhuma neste momento"
	arr["RUSSIAN",510]="На этом экране предполагается, что будет выбран дополнительный интерфейс wifi, но в данный момент у вас нет других беспроводных интерфейсов"
	arr["GREEK",510]="Σε αυτήν την οθόνη, υποτίθεται ότι έχει επιλεγεί μια πρόσθετη διεπαφή wifi, αλλά δεν έχετε επιλέξει κάποια αυτήν τη στιγμή"
	arr["ITALIAN",510]="In questa schermata, dovresti scegliere un'altra interfaccia wifi addizionale, ma in questo momento non ne hai nessuna"
	arr["POLISH",510]="Na tym ekranie należy wybrać inny dodatkowy interfejs wifi, ale nie masz go w tym momencie"
	arr["GERMAN",510]="Auf diesem Bildschirm sollten Sie ein anderes zusätzliches WIFI-Interface auswählen, aber Sie haben keins zu diesem Zeitpunkt"
	arr["TURKISH",510]="Bu ekranda, ek bir wifi arayüzü seçildi, ancak şu anda hiç kimsenin yok"
	arr["ARABIC",510]="على هذه الشاشة ، من المفترض أن يتم اختيار واجهة wifi إضافية ، لكن ليس لديك أي واجهة في هذه اللحظة"
	arr["CHINESE",510]="在这个窗口中，应该选择一个额外的 wifi 接口，但此时还没有任何东西"

	arr["ENGLISH",511]="Select another wireless interface:"
	arr["SPANISH",511]="Selecciona otra interfaz inalámbrica:"
	arr["FRENCH",511]="Sélectionnez une autre interface sans fil:"
	arr["CATALAN",511]="Selecciona un altra interfície sense fils:"
	arr["PORTUGUESE",511]="Selecione outra interface sem fio:"
	arr["RUSSIAN",511]="Выберите дополнительный беспроводной интерфейс:"
	arr["GREEK",511]="Επιλέξτε άλλη μία ασύρματη διεπαφή:"
	arr["ITALIAN",511]="Seleziona un'altra interfaccia wireless:"
	arr["POLISH",511]="Wybierz inny interfejs bezprzewodowy:"
	arr["GERMAN",511]="Wählen Sie ein anderes drahtloses Interface:"
	arr["TURKISH",511]="Başka bir kablosuz arayüz seçin:"
	arr["ARABIC",511]=":اختيار واجهة لاسلكية أخرى"
	arr["CHINESE",511]="请选择另一个无线接口:"

	arr["ENGLISH",512]="\"DoS pursuit mode\" interface: \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["SPANISH",512]="Interfaz para \"modo persecución DoS\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["FRENCH",512]="Interface pour le \"mode de poursuite DoS\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["CATALAN",512]="Interfície per \"mode persecució DoS\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["PORTUGUESE",512]="Interface para o ataque DoS em \"modo de perseguição\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["RUSSIAN",512]="Интерфейс для \"режима DoS преследования\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["GREEK",512]="Διεπαφή για \"DoS pursuit mode\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["ITALIAN",512]="Interfaccia per la modalitá \"DoS pursuit mode\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["POLISH",512]="Interfejs dla \"tryb DoS pursuit\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["GERMAN",512]="Interface für \"DoS pursuit mode\": \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["TURKISH",512]="\"DoS pursuit mode\" arayüzü: \${pink_color}\${secondary_wifi_interface}\${normal_color}"
	arr["ARABIC",512]="\${pink_color}\${secondary_wifi_interface}\${blue_color} :\"DoS pursuit mode\" واجهة وضع\${normal_color}"
	arr["CHINESE",512]="\"DoS追踪模式\"接口: \${pink_color}\${secondary_wifi_interface}\${normal_color}"

	arr["ENGLISH",513]="Interface will be tried to be changed to monitor mode automatically"
	arr["SPANISH",513]="Se intentará cambiar la interfaz a modo monitor automáticamente"
	arr["FRENCH",513]="l'interface va essayer de changer en mode monitor automatiquement"
	arr["CATALAN",513]="S'intentarà canviar la interfície a mode monitor automàticament"
	arr["PORTUGUESE",513]="O script tentará mudar a interface para o modo monitor automaticamente"
	arr["RUSSIAN",513]="Будет сделана автоматическая попытка перевести интерфейс в режим монитора"
	arr["GREEK",513]="Γίνεται απόπειρα αλλαγής κατάστασης διεπαφής σε κατάσταση παρακολούθησης"
	arr["ITALIAN",513]="Si cercherà di cambiare automaticamente l'interfaccia alla modalità monitor"
	arr["POLISH",513]="Spowoduje to automatyczną zmianę interfejsu w tryb monitorowania"
	arr["GERMAN",513]="Es wird versucht, das Interface automatisch in den Monitor-Modus zu ändern"
	arr["TURKISH",513]="Arayüz otomatik olarak izleme modunu değiştirmeye çalışılacaktır"
	arr["ARABIC",513]="تلقائيًا monitor mode ستتم محاولة تغيير الواجهة إلى وضع"
	arr["CHINESE",513]="接口将尝试自动改为监听模式"

	arr["ENGLISH",514]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} selected. Mode: \${pink_color}\${ifacemode}\${blue_color}. Supported bands: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["SPANISH",514]="Interfaz \${pink_color}\${current_iface_on_messages}\${blue_color} seleccionada. Modo: \${pink_color}\${ifacemode}\${blue_color}. Bandas soportadas: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["FRENCH",514]="L'interface \${pink_color}\${current_iface_on_messages}\${blue_color} sélectionnée. Mode: \${pink_color}\${ifacemode}\${blue_color}. Bandes supportées: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["CATALAN",514]="Interfície \${pink_color}\${current_iface_on_messages}\${blue_color} seleccionada. Mode: \${pink_color}\${ifacemode}\${blue_color}. Bandes suportades: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["PORTUGUESE",514]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} selecionada. Modo: \${pink_color}\${ifacemode}\${blue_color}. Banda(s) suportada(s): \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["RUSSIAN",514]="Выбран интерфейс \${pink_color}\${current_iface_on_messages}\${blue_color}. Режим: \${pink_color}\${ifacemode}\${blue_color}. Поддерживаемые диапазоны: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["GREEK",514]="Η διεπαφή \${pink_color}\${current_iface_on_messages}\${blue_color} έχει επιλεχθεί. Κατάσταση: \${pink_color}\${ifacemode}\${blue_color}. Υποστηριζόμενες ζώνες: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["ITALIAN",514]="Interfaccia \${pink_color}\${current_iface_on_messages}\${blue_color} selezionata. Modalità: \${pink_color}\${ifacemode}\${blue_color}. Bande supportate: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["POLISH",514]="Wybrany został interfejs \${pink_color}\${current_iface_on_messages}\${blue_color}. Tryb: \${pink_color}\${ifacemode}\${blue_color}. Obsługiwane pasma: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["GERMAN",514]="Interface \${pink_color}\${current_iface_on_messages}\${blue_color} ausgewählt. Modus: \${pink_color}\${ifacemode}\${blue_color}. Unterstützte Bänder: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["TURKISH",514]="Arayüz \${pink_color}\${current_iface_on_messages}\${blue_color} seçildi. Mod: \${pink_color}\${ifacemode}\${blue_color}. Desteklenen bantlar: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"
	arr["ARABIC",514]="\${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${blue_color} :النطاقات المتحملة .\${pink_color}\${ifacemode}\${blue_color} :الوضع .\${pink_color}\${current_iface_on_messages}\${blue_color} الواجهة\${normal_color}"
	arr["CHINESE",514]="已选择接口 \${pink_color}\${current_iface_on_messages}\${blue_color}。当前工作模式: \${pink_color}\${ifacemode}\${blue_color}。支持的频率: \${pink_color}\${interfaces_band_info['main_wifi_interface','text']}\${normal_color}"

	arr["ENGLISH",515]="You have selected a 5Ghz band channel but your wifi card doesn't support 5Ghz or it is disabled. The operation can't be performed"
	arr["SPANISH",515]="Tienes un canal de la banda de 5Ghz seleccionado pero tu tarjeta wifi no soporta 5Ghz o está desactivado. La operación no se puede llevar a cabo"
	arr["FRENCH",515]="Vous avez sélectionné un canal 5Ghz mais votre carte wifi n'accepte pas 5Ghz ou est désactivée. L'opération ne peut pas être effectuée"
	arr["CATALAN",515]="Tens un canal de la banda de 5Ghz seleccionat però la teva targeta wifi no suporta 5Ghz o està desactivada. L'operació no es pot dur a terme"
	arr["PORTUGUESE",515]="Você selecionou um canal da banda de 5Ghz, mas sua interface wifi não suporta 5Ghz ou foi desativada. A operação não pode ser realizada"
	arr["RUSSIAN",515]="Вы выбрали канал на частотах 5Ghz, но ваша wifi карта не поддерживает 5Ghz, или этот диапазон отключён. Операция не может быть выполнена"
	arr["GREEK",515]="Έχετε επιλέξει κανάλι της ζώνης 5Ghz, αλλά η κάρτα wifi σας δεν υποστηρίζει 5Ghz ή είναι απενεργοποιημένη. Η λειτουργία δεν μπορεί να πραγματοποιηθεί"
	arr["ITALIAN",515]="Hai selezionato un canale della banda 5Ghz, ma la tua scheda wifi non supporta 5Ghz o è disattivato. L'operazione non può essere eseguita"
	arr["POLISH",515]="Masz wybrane pasmo 5Ghz, lecz Twoja karta wifi go nie obsługuje lub jest ono wyłączone. Operacja nie może być wykonana"
	arr["GERMAN",515]="Sie haben einen Kanal des 5Ghz-Bandes ausgewählt, aber Ihre WLAN-Karte unterstützt 5Ghz nicht oder sie ist deaktiviert. Die Operation kann nicht ausgeführt werden"
	arr["TURKISH",515]="5Ghz bant kanalı seçtiniz, ancak wifi kartınız 5Ghz'yi desteklemiyor veya devre dışı bırakılmış. İşlem gerçekleştirilemiyor"
	arr["ARABIC",515]="الخاصة بك لا تدعم 5 جيجاهرتز أو تم تعطيلها. لا يمكن إجراء العملية wifi لقد حددت قناة نطاق 5 جيجاهرتز ولكن بطاقة"
	arr["CHINESE",515]="您选择了 5Ghz 频段信道，但您的 wifi 网卡不支持 5Ghz 或已禁用。操作无法执行"

	arr["ENGLISH",516]="It is known that the software used in the 5Ghz band still presents some problems sometimes. For example airodump, that when scanning networks can show a value \"-1\" on channel depending on the card chipset and the driver. It is also known that Ralink chipsets sometimes are getting errors on high channels \""
	arr["SPANISH",516]="Es conocido que el software utilizado en la banda de 5Ghz aún presenta algunos problemas a veces. Como por ejemplo airodump, que al escanear redes puede mostrar un valor \"-1\" en el canal dependiendo del chipset de tu tarjeta y del driver. También es conocido que los chipsets Ralink a veces dan fallos en los canales altos \""
	arr["FRENCH",516]="Il est connu que les logiciels utilisés dans la bande 5Ghz présente toujours quelques problèmes. Comme par exemple airodump, lors du scan des réseaux, peut montrer une valeur \"-1\" dans le canal en fonction du chipset de votre carte et le pilote. Il est également connu que les chipsets Ralink donnent parfois des échecs dans les canaux élevés \""
	arr["CATALAN",516]="És conegut que el programari utilitzat en la banda de 5Ghz encara presenta alguns problemes de vegades. Com per exemple airodump, que al escanejar xarxes pot mostrar un valor \"-1\" al canal depenent del chipset de la targeta i del driver. També és conegut que els chipsets Ralink de vegades donen fallades en els canals alts \""
	arr["PORTUGUESE",516]="O software usado para a banda de 5Ghz ainda apresenta alguns problemas. Como por exemplo airodump, que ao escanear as redes pode mostrar um valor \"-1\" no canal dependendo do chipset da sua interface e do driver. Também se sabe que os chipsets Ralink às vezes apresentaram falhas em canais altos \""
	arr["RUSSIAN",516]="Известно, что программное обеспечение, используемое на частотах 5Ghz, все еще иногда вызывает некоторые проблемы. Например, airodump при сканировании сетей может отображать \"-1\" вместо значения канала, это зависит от чипсета вашей карты и драйвера. Известно также, что чипсеты Ralink иногда дают сбои в высоких каналах \""
	arr["GREEK",516]="Είναι γνωστό ότι το λογισμικό που χρησιμοποιείται για την 5Ghz ζώνη εξακολουθεί να παρουσιάζει κάποια προβλήματα κατά καιρούς. Όπως για παράδειγμα το airodump, μπορεί να εμφανίσει την τιμή \"-1\" στη θέση του καναλιού καθώς γίνεται σάρωση, ανάλογα με το chipset της κάρτας σας και του προγράμματος οδήγησης (driver). Είναι επίσης γνωστό ότι τα Ralink chipsets μερικές φορές αποτυγχάνουν σε υψηλά κανάλια \""
	arr["ITALIAN",516]="È noto che il software utilizzato dalla banda 5Ghz presenta ancora qualche problema. Come per esempio airodump, che durante la scansione delle reti può mostrare un valore \"-1\" nel canale a seconda del chipset della scheda di rete e del driver. È anche noto che i chipset Ralink a volte danno dei problemi nei canali alti \""
	arr["POLISH",516]="Powszechnie wiadomo, że oprogramowanie używane w paśmie 5Ghz wciąż ma pewne problemy. Na przykład airodump, który podczas skanowania sieci może pokazywać wartość \"-1\" w kanale w zależności od chipsetu karty i sterownika. Wiadomo również, że chipsety Ralink czasami zawodzą w wysokich kanałach \""
	arr["GERMAN",516]="Es ist bekannt, dass die Software, die im 5Ghz-Band verwendet wird, immer noch einige Probleme aufweist. Wie zum Beispiel airodump, dass beim Netzwerk-Scannen den Wert \"-1\" in den Kanal zeigt, abhängig von dem Chipset Ihrer Karte und des Treibers. Es ist auch bekannt, dass Ralink-Chipsätze manchmal Fehler in hohen Kanälen \""
	arr["TURKISH",516]="5Ghz bandında kullanılan yazılımın bazen bazı problemler yaşadığı bilinmektedir. Örneğin airodump, ağları tararken, kart yonga setine ve sürücüye bağlı olarak kanalda \"-1\" değeri gösterebilir. Ralink yonga kümelerinin bazen yüksek kanallarda hatalar aldıkları da bilinir. \""
	arr["ARABIC",516]="تتعرض أحيانًا لأخطاء في القنوات العالية Ralink ومن المعروف أيضًا أن شرائح .Driverعند فحص الشبكات يمكن أن تظهر قيمة \"-1\" على القناة اعتمادًا على مجموعة شرائح البطاقة و ، airodump ،من المعروف أن البرنامج المستخدم في نطاق 5 جيجا هرتز لا يزال يعرض بعض المشاكل في بعض الأحيان. على سبيل المثال \""
	arr["CHINESE",516]="众所周知，一些软件包在使用在 5Ghz 频段时仍然会出现一些问题。例如 airodump 在扫描网络时，根据不同的卡芯片组和驱动程序，有些时候可以在通道上显示值 \"-1\"。但 Ralink 芯片组有时会在较高频率的信道上出现错误\""

	arr["ENGLISH",517]="Set channel (2.4Ghz 1-14) or (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["SPANISH",517]="Selecciona un canal (2.4Ghz 1-14) o (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["FRENCH",517]="Sélectionnez un canal (2.4Ghz 1-14) ou (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["CATALAN",517]="Seleccioni un canal (2.4Ghz 1-14) o (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["PORTUGUESE",517]="Escolha um canal (2.4Ghz 1-14) ou (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["RUSSIAN",517]="Установите канал (2.4Ghz 1-14) или (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["GREEK",517]="Θέστε κανάλι (2.4Ghz 1-14) ή (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["ITALIAN",517]="Seleziona un canale (2.4Ghz 1-14) o (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["POLISH",517]="Wybierz kanał (2.4Ghz 1-14) lub (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["GERMAN",517]="Wählen Sie einen Kanal aus (2.4Ghz 1-14) oder (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["TURKISH",517]="Kanal seç (2.4Ghz 1-14) or (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"
	arr["ARABIC",517]="(2.4Ghz 1-14) أو (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112) :قم بتعيين القناة"
	arr["CHINESE",517]="设置信道 (2.4Ghz 1-14) 或 (5Ghz 36|38|40|44|46|48|52|54|56|60|62|64|100|102|104|108|110|112):"

	arr["ENGLISH",518]="After capturing credentials during an Enterprise network attack, remember that you can try to decrypt NTLM hashes using the \"Offline WPA/WPA2 decrypt menu\""
	arr["SPANISH",518]="Tras capturar unas credenciales en un ataque a una red Enterprise, recuerda que puedes intentar descifrar los hashes NTLM usando el \"Menú de descifrado WPA/WPA2 offline\""
	arr["FRENCH",518]="Après d'avoir capturé les identifiants de connexion dans une attaque réseau Enterprise, n'oubliez pas que vous pouvez essayer de déchiffrer les hasches NTLM en utilisant \"Menu crack WPA/WPA2 offline\""
	arr["CATALAN",518]="Després de capturar unes credencials en un atac a una xarxa Enterprise, recorda que pots intentar desxifrar els hashes NTLM usant el \"Menú per desxifrar WPA/WPA2 offline\""
	arr["PORTUGUESE",518]="Depois de capturar credenciais em um ataque de rede Enterprise, lembre-se de que você pode tentar descriptografar as hashes NTLM usando o \"Menu de descriptografia WPA/WPA2 offline\""
	arr["RUSSIAN",518]="После захвата учетных данных в сетевой атаке Enterprise помните, что вы можете попытаться расшифровать NTLM хеши с помощью \"Меню офлайн расшифровки WPA/WPA2\""
	arr["GREEK",518]="Αφού καταγράψετε τα certificates σε μια Enterprise επίθεση δικτύου, θυμηθείτε ότι μπορείτε να προσπαθήσετε να αποκρυπτογραφήσετε τα NTLM hashes χρησιμοποιώντας το \"Μενού offline αποκρυπτογράφησης WPA/WPA2\""
	arr["ITALIAN",518]="Dopo aver catturato le credenziali in un attacco contro una rete Enterprise, ricorda che puoi provare a decifrare gli hash NTLM utilizzando il \"Menù per decifrare WPA/WPA2 offline\""
	arr["POLISH",518]="Po przechwyceniu danych dostępowych w ataku na sieć Enterprise pamiętaj, że możesz spróbować złamać hash NTLM za pomocą \"Menu deszyfrowania WPA/WPA2 offline\""
	arr["GERMAN",518]="Erinneren Sie sich dran, dass nach dem Erfassen von Credentials bei einem Enterprise-Netzwerkangriff Sie NTLM-Hashes mit dem \"Offline WPA/WPA2-Entschlüsselungsmenü\" entschlüsseln können"
	arr["TURKISH",518]="Enterprise ağ saldırısında kimlik bilgilerini aldıktan sonra, \"Çevrimdışı WPA/WPA2 decrypt menüsü\" kullanarak NTLM karmalarını çözmeyi deneyebilirsiniz"
	arr["ARABIC",518]="\"Offline WPA/WPA2 decrypt menu\" باستخدام NTLM تذكر أنه يمكنك محاولة فك تشفير تجزئات ، Enterprise بعد الحصول على بيانات الاعتماد أثناء هجوم على شبكة"
	arr["CHINESE",518]="在企业级加密的网络攻击期间捕获凭据后，请记住您可以尝试使用“离线 WPA/WPA2 解密菜单”来解密 NTLM 哈希"

	arr["ENGLISH",519]="11. Turkish"
	arr["SPANISH",519]="11. Turco"
	arr["FRENCH",519]="11. Turc"
	arr["CATALAN",519]="11. Turc"
	arr["PORTUGUESE",519]="11. Turco"
	arr["RUSSIAN",519]="11. Турецкий"
	arr["GREEK",519]="11. Τουρκικά"
	arr["ITALIAN",519]="11. Turco"
	arr["POLISH",519]="11. Turecki"
	arr["GERMAN",519]="11. Türkisch"
	arr["TURKISH",519]="11. Türkçe"
	arr["ARABIC",519]="11. التركية"
	arr["CHINESE",519]="11. 土耳其语"

	arr["ENGLISH",520]="Enterprise Evil Twin deauth"
	arr["SPANISH",520]="Desautenticación para Evil Twin Enterprise"
	arr["FRENCH",520]="Dés-authentication pour Evil Twin Enterprise"
	arr["CATALAN",520]="Desautenticació per Evil Twin Enterprise"
	arr["PORTUGUESE",520]="Desautenticação para Evil Twin Enterprise"
	arr["RUSSIAN",520]="Деаутентификация для Enterprise Evil Twin"
	arr["GREEK",520]="Enterprise Evil Twin deauth"
	arr["ITALIAN",520]="Desautenticazione per Evil Twin Enterprise"
	arr["POLISH",520]="Deautentykacja dla Evil Twin Enterprise"
	arr["GERMAN",520]="Evil Twin Enterprise Deauthentifizierung"
	arr["TURKISH",520]="Enterprise Şeytani İkiz deauth"
	arr["ARABIC",520]="Evil Twin Enterprise إلغاء المصادقة لـ"
	arr["CHINESE",520]="企业级加密的邪恶双胞胎攻击死亡"

	arr["ENGLISH",521]="0.  Return to Enterprise attacks menu"
	arr["SPANISH",521]="0.  Volver al menú de ataques Enterprise"
	arr["FRENCH",521]="0.  Retour au menu d'attaques Enterprise"
	arr["CATALAN",521]="0.  Tornar al menú d'atacs Enterprise"
	arr["PORTUGUESE",521]="0.  Voltar ao menu de ataques Enterprise"
	arr["RUSSIAN",521]="0.  Вернуться в меню атак Enterprise"
	arr["GREEK",521]="0.  Επιστροφή στο μενού επιθέσεων Enterprise"
	arr["ITALIAN",521]="0.  Tornare al menu degli attacchi Enterprise"
	arr["POLISH",521]="0.  Wróć do menu ataków Enterprise"
	arr["GERMAN",521]="0.  Zurück zum Enterprise Angriffsmenü"
	arr["TURKISH",521]="0.  Enterprise Şeytani İkiz saldırı menüsüne geri dön"
	arr["ARABIC",521]="0.  Enterprise العودة إلى قائمة هجمات"
	arr["CHINESE",521]="0.  返回企业级加密攻击菜单"

	arr["ENGLISH",522]="Smooth mode Enterprise Evil Twin"
	arr["SPANISH",522]="Evil Twin Enterprise modo smooth"
	arr["FRENCH",522]="Evil Twin Enterprise mode silencieux"
	arr["CATALAN",522]="Evil Twin Enterprise mode smooth"
	arr["PORTUGUESE",522]="Evil Twin Enterprise (discreto)"
	arr["RUSSIAN",522]="Smooth режим Enterprise Evil Twin"
	arr["GREEK",522]="Smooth mode Enterprise Evil Twin"
	arr["ITALIAN",522]="Evil Twin Enterprise modalità smooth"
	arr["POLISH",522]="Enterprise Evil Twin w trybie smooth"
	arr["GERMAN",522]="Smooth-Modus Enterprise Evil Twin"
	arr["TURKISH",522]="Smooth mod Enterprise Şeytani İkiz"
	arr["ARABIC",522]="Smooth mode Enterprise Evil Twin وضع"
	arr["CHINESE",522]="平滑模式下针对企业级加密的邪恶双胞胎攻击"

	arr["ENGLISH",523]="Noisy mode Enterprise Evil Twin"
	arr["SPANISH",523]="Evil Twin Enterprise modo noisy"
	arr["FRENCH",523]="Evil Twin Enterprise mode bruyant"
	arr["CATALAN",523]="Evil Twin Enterprise mode noisy"
	arr["PORTUGUESE",523]="Evil Twin Enterprise (agressivo)"
	arr["RUSSIAN",523]="Noisy режим Enterprise Evil Twin"
	arr["GREEK",523]="Noisy mode Enterprise Evil Twin"
	arr["ITALIAN",523]="Evil Twin Enterprise modalità noisy"
	arr["POLISH",523]="Enterprise Evil Twin w trybie noisy"
	arr["GERMAN",523]="Noisy-Modus Enterprise Evil Twin"
	arr["TURKISH",523]="Noisy mod Enterprise Şeytani İkiz"
	arr["ARABIC",523]="Noisy mode Enterprise Evil Twin وضع"
	arr["CHINESE",523]="嘈杂模式下针对企业级加密的邪恶双胞胎攻击"

	arr["ENGLISH",524]="Enterprise Evil Twin attack has been started. Press [Enter] key on this window to stop it"
	arr["SPANISH",524]="El ataque Evil Twin Enterprise ha comenzado. Pulse la tecla [Enter] en esta ventana para pararlo"
	arr["FRENCH",524]="L'attaque Evil Twin Enterprise a commencé. Appuyez sur [Enter] pour arrêter"
	arr["CATALAN",524]="L'atac Evil Twin Enterprise ha començat. Prem [Enter] a aquesta finestra per aturar-lo"
	arr["PORTUGUESE",524]="Ataque Evil Twin Enterprise iniciado. Pressione a tecla [Enter] nesta janela para parar-lo"
	arr["RUSSIAN",524]="Атака Злой Двойник начата. Для её остановки клавишу [Enter] в этом окне"
	arr["GREEK",524]="Η επίθεση Enterprise Evil Twin ξεκίνησε. Πατήστε το κουμπί [Enter] σε αυτό το παράθυρο για να την σταματήσετε"
	arr["ITALIAN",524]="L'attacco Evil Twin Enterprise è iniziato. Premere il tasto [Enter] in questa finestra per fermarlo"
	arr["POLISH",524]="Rozpoczął się atak Evil Twin Enterprise. Naciśnij klawisz [Enter] w tym oknie, aby go zatrzymać"
	arr["GERMAN",524]="Der Evil-Twin-Enterprise-Angriff hat begonnen. Drücken Sie die [Enter]-Taste in diesem Fenster, um es zu stoppen"
	arr["TURKISH",524]="Enterprise Şeytani İkiz saldırısı başlatıldı. Durdurmak için bu pencerede [Enter] tuşlayınız"
	arr["ARABIC",524]="في هذه النافذة لإيقافه [Enter] اضغط على مفتاح .Enterprise Evil Twin بدأ هجوم"
	arr["CHINESE",524]="针对企业级加密的邪恶双胞胎攻击已经开始。在此窗口中按 [Enter] 键停止攻击"

	arr["ENGLISH",525]="If a hash or password is obtained during the Evil Twin Enterprise attack, you should decide where to save it. \${green_color} More than one file will be saved, type the path (directory) to store the file/s. If the directory does not exist, airgeddon will create it. Press [Enter] to accept the default proposal \${normal_color}[\${enterprise_potpath}]"
	arr["SPANISH",525]="Si se consigue capturar algún hash o contraseña durante el ataque Evil Twin Enterprise, hay que decidir donde guardarlo. \${green_color}Se guardarán varios ficheros, escribe la ruta (el directorio) donde escribiremos el/los fichero/s. Si en directorio no existe, airgeddon lo generará. Pulsa [Enter] para aceptar la ruta propuesta por defecto \${normal_color}[\${enterprise_potpath}]"
	arr["FRENCH",525]="Si on a succés en capturer un hash ou un mot de passe lors de l'attaque de Evil Twin Enterprise, vous devez décider de l'emplacement de sauvegarde. \${green_color}Plusieurs fichiers seront sauvegardés, écrivez le chemin (le répertoire) où nous écrirons le/s fichier/s. Si le répertoire n'existe pas, airgeddon le générera. Appuyez sur [Enter] pour accepter l'itinéraire proposé par défaut \${normal_color}[\${enterprise_potpath}]"
	arr["CATALAN",525]="Si s'aconsegueix capturar algun hash o contrasenya durant l'atac Evil Twin Enterprise, cal decidir on guardar-lo. \${green_color}Es guardaran diversos fitxers, escriu la ruta (directori) on escriurem el/s fitxer/s. Si en directori no existeix, airgeddon el generarà. Prem [Enter] per acceptar la ruta proposada per defecte \${normal_color}[\${enterprise_potpath}]"
	arr["PORTUGUESE",525]="Se você conseguir capturar uma hash ou senha durante o ataque Evil Twin Enterprise, terá que decidir onde salvá-lo. \${green_color} Vários arquivos serão salvos, escreva o caminho (diretório) onde iremos escrever o(s) arquivo(s). Se o diretório não existir o airgeddon irá criá-lo. Pressione [Enter] para aceitar o padrão \${normal_color}[\${enterprise_potpath}]"
	arr["RUSSIAN",525]="Если во время атаки Evil Twin Enterprise получен хеш или пароль, вы должны решить, где его сохранить. \${green_color}Будет сохранено более одного файла, введите путь (каталог) для хранения файла(ов). Если каталог не существует, airgeddon создаст его. Нажмите [Enter], чтобы принять предложение по умолчанию \${normal_color}[\${enterprise_potpath}]"
	arr["GREEK",525]="Εάν κατά τη διάρκεια της επίθεσης Enterprise Evil Twin προκύψει ένα hash ή ένας κωδικός πρόσβασης, θα πρέπει να αποφασίσετε πού να το αποθηκεύσετε. \${green_color}Θα αποθηκευτούν περισσότερα από ένα αρχεία, πληκτρολογήστε το path (κατάλογος) για την αποθήκευση των αρχείων. Εάν ο κατάλογος δεν υπάρχει, το airgeddon θα το δημιουργήσει. Πατήστε [Enter] για να αποδεχθείτε την προεπιλεγμένη επιλογή \${normal_color}[\${enterprise_potpath}]"
	arr["ITALIAN",525]="Se riesci a catturare un hash o una password durante l'attacco Evil Twin Enterprise, devi decidere dove salvarlo. \${green_color}Diversi file verranno salvati, scrivi il percorso (la directory) in cui i file saranno scritti. Se la directory non esiste, airgeddon la genererà. Premere [Enter] per accettare il percorso predefinito proposto \${normal_color}[\${enterprise_potpath}]"
	arr["POLISH",525]="Jeśli uda ci się zdobyć hash lub hasło podczas ataku Evil Twin Enterprise, musisz zdecydować gdzie je zapisać. \${green_color}Zostanie zapisany wiecej niż jeden plik, podaj ścieżkę (katalog) dla plik(ów). Jeśli katalog nie istnieje, airgeddon go utworzy. Naciśnij [Enter], aby zaakceptować domyślną proponowaną ścieżkę \${normal_color}[\${enterprise_potpath}]"
	arr["GERMAN",525]="Wenn Sie während des Evil Twin Enterprise Angriffs einen Hash oder ein Passwort erfassen, müssen Sie entscheiden, wo es gespeichert werden soll. \${green_color}Mehrere Dateien werden gespeichert. Geben Sie den Pfad (das Verzeichnis) ein, in dem wir die Datei(en) schreiben werden. Wenn das Verzeichnis nicht vorhanden ist, wird es von airgeddon erstellt. Bestätigen Sie mit [Enter], um die standardmäßig vorgeschlagene Route zu akzeptieren \${normal_color}[\${enterprise_potpath}]"
	arr["TURKISH",525]="Enterprise Şeytani İkiz saldırısı sırasında bir şifre yakalamayı başarabilirseniz, nereye kaydedeceğinize karar vermeniz gerekir. \${green_color}Birkaç dosya kaydedilecek, dosya (lar) ı yazacağımız yolu (dizin) yazacağız. Dizini yoksa, airgeddon onu üretecektir. Önerilen önerilen yolu kabul etmek için [Enter] tuşuna basın \${normal_color}[\${enterprise_potpath}]"
	arr["ARABIC",525]="\${normal_color}[\${enterprise_potpath}]\${green_color} لقبول الاقتراح [Enter] بإنشائه. اضغط على airgeddon فيجب أن تقرر مكان حفظها\${blue_color} .سيتم حفظ أكثر من ملف ، اكتب المسار (الدليل) لتخزين الملف/ الملفات. إذا كان الدليل غير موجود ، فسيقوم ،Evil Twin Enterprise إذا تم الحصول على تجزئة أو كلمة مرور أثناء هجوم\${normal_color}"
	arr["CHINESE",525]="如果在针对企业级加密的邪恶双胞胎攻击期间获得哈希或密码，您应该决定将其保存在何处。\${green_color} 可能会保存多个文件，请输入文件存放路径 (目录) 。如果该目录不存在，airgeddon 将创建它。或按 [Enter] 接受默认建议 \${normal_color}[\${enterprise_potpath}]"

	arr["ENGLISH",526]="Directory does not exist or you don't have permission to write"
	arr["SPANISH",526]="El directorio no existe o no tienes permisos de escritura"
	arr["FRENCH",526]="Le répertoire n'existe pas ou vous n'avez pas des pwrmis d'écriture"
	arr["CATALAN",526]="El directori no existeix o no tens permisos d'escriptura"
	arr["PORTUGUESE",526]="O diretório não existe ou você não tem permissão de escrita"
	arr["RUSSIAN",526]="Каталог не существует или у вас нет разрешения на запись"
	arr["GREEK",526]="Ο κατάλογος δεν υπάρχει ή δεν έχετε άδεια εγγραφής"
	arr["ITALIAN",526]="La directory non esiste o non hai i permessi di scrittura"
	arr["POLISH",526]="Katalog nie istnieje lub nie masz uprawnień do zapisu"
	arr["GERMAN",526]="Verzeichnis existiert nicht oder Sie haben keine Schreibberechtigung"
	arr["TURKISH",526]="Dizin mevcut değil veya yazma izniniz yok"
	arr["ARABIC",526]="الدليل غير موجود أو ليس لديك إذن بالكتابة"
	arr["CHINESE",526]="目录不存在或您没有写入权限"

	arr["ENGLISH",527]="WPA/WPA2/WPA3 and Enterprise filter enabled. It's not possible to filter Enterprise networks during the scan, the filter will be applied in network selection menu in which only Enterprise networks will be shown. When started, press [Ctrl+C] to stop..."
	arr["SPANISH",527]="Filtro WPA/WPA2/WPA3 y Enterprise activado. Durante el escaneo no es posible filtrar redes Enterprise, el filtro se aplicará en la pantalla de selección de red donde solo se mostrarán redes Enterprise. Una vez empezado, pulse [Ctrl+C] para pararlo..."
	arr["FRENCH",527]="Filtre WPA/WPA2/WPA3 et Enterprise activés. Pendant l'analyse, il n'est pas possible de filtrer les réseaux Enterprise. Le filtre sera appliqué dans l'écran de sélection du réseau où seuls les réseaux Enterprise seront affichés. Une fois commencé, appuyez sur [Ctrl+C] pour l'arrêter..."
	arr["CATALAN",527]="Filtre WPA/WPA2/WPA3 i Enterprise activat. Durant l'escaneig no és possible filtrar xarxes Enterprise, el filtre s'aplicarà a la pantalla de selecció de xarxa on només es mostraran xarxes Enterprise. Un cop començat, premeu [Ctrl+C] per aturar-lo..."
	arr["PORTUGUESE",527]="Filtros: WPA/WPA2/WPA3 e Enterprise ativos. Durante a verificação, não é possível filtrar redes Enterprise, o filtro será aplicado na tela de seleção de rede, onde apenas as redes Enterprise serão exibidas. Uma vez iniciado, pressione [Ctrl+C] para pará-lo..."
	arr["RUSSIAN",527]="WPA/WPA2/WPA3 и фильтр Enterprise включён. Во время сканирования невозможно фильтровать сети Enterprise, фильтр будет применяться в меню выбора сети, в котором будут показаны только сети Enterprise. После запуска для остановки нажмите [Ctrl+C]..."
	arr["GREEK",527]="Το WPA/WPA2/WPA3 και Enterprise φίλτρο είναι ενεργοποιημένο. Δεν είναι δυνατό να φιλτράρετε τα Enterprise δίκτυα κατά τη διάρκεια της σάρωσης, το φίλτρο θα εφαρμοστεί στο μενού επιλογής δικτύου στο οποίο θα εμφανίζονται μόνο τα Enterprise δίκτυα. Όταν ξεκινήσετε, πατήστε [Ctrl+C] για να σταματήσετε..."
	arr["ITALIAN",527]="Filtro WPA/WPA2/WPA3 e Enterprise attivato. Durante la scansione non è possibile filtrare le reti Enterprise, il filtro verrà applicato nella schermata di selezione della rete in cui verranno visualizzate solo le reti Enterprise. Una volta avviato, premi [Ctrl+C] per fermarlo..."
	arr["POLISH",527]="Włączone filtry WPA/WPA2/WPA3 i Enterprise. Nie można filtrować sieci Enterprise podczas skanowania, filtr zostanie zastosowany w menu wyboru sieci, w którym wyświetlane będą tylko sieci Enterprise. Naciśnij w trackie działania [Ctrl+C], aby zatrzymać..."
	arr["GERMAN",527]="WPA/WPA2/WPA3- und Enterprise-Filter aktiviert. Es ist nicht möglich, Enterprise-Netzwerke während des Scans zu filtern. Der Filter wird im Netzwerkauswahlmenü angewendet, in dem nur Enterprise-Netzwerke angezeigt werden. Einmal angefangem, drücken Sie [Ctrl+C], um zu stoppen..."
	arr["TURKISH",527]="WPA/WPA2/WPA3 ve Enterprise filtre etkinleştirildi. Tarama sırasında Enterprise ağları filtrelemek mümkün değildir, filtre yalnızca Enterprise ağların gösterileceği ağ seçim menüsünde uygulanacaktır. Başladığınızda, durdurmak için [Ctrl+C] tuşlarına basın..."
	arr["ARABIC",527]="...للإيقاف [Ctrl+C] عند البدء ، اضغط على .فقط Enterprise  أثناء الفحص ، سيتم تطبيق عامل التصفية في قائمة اختيار الشبكة حيث سيتم عرض شبكات Enterprise لا يمكن تصفية شبكات .Enterprise و WPA/WPA2/WPA3 تم تفعيل عامل تصفية "
	arr["CHINESE",527]="WPA/WPA2/WPA3 和企业级加密过滤器已启用。但是扫描期间无法过滤企业级加密的网络，过滤器将应用于网络选择菜单，其中仅显示企业级加密的网络。启动时，按 [Ctrl+C] 停止..."

	arr["ENGLISH",528]="It has been detected that you are running airgeddon inside a Docker container. During this attack hostapd-wpe is used to create a fake AP. This component often conflicts with network-manager. From inside the container, airgeddon can't handle it. If you have network-manager installed on your host machine, close it or kill the conflicting processes or you'll get an error. For more information, see the Docker section of the Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["SPANISH",528]="Se ha detectado que estás ejecutando airgeddon en un contenedor de Docker. En este ataque se utiliza hostapd-wpe para crear un falso AP. Este componente suele dar conflicto con network-manager. Desde el contenedor, airgeddon no puede gestionarlo. Si tienes network-manager instalado en tu máquina host, ciérralo o mata los procesos en conflicto u obtendrás un error. Para más información consulta la sección Docker del Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["FRENCH",528]="Il a été détecté qu'airgeddon a été lancé depuis un conteneur Docker. Cette attaque à besoin d'hostapd-wpe pour créer un Point d'Accès piège. Hostapd a tendance à entrer en conflit avec network-manager et airgeddon ne peut pas le gérer depuis le conteneur. Si network-manager est installé sur votre machine host, arrêtez ou tuez les processus conflictuels. Dans le cas contraire vous obtiendrez une erreur. Pour plus d'informations, consultez la section Docker de notre Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["CATALAN",528]="S'ha detectat que estàs executant airgeddon en un contenidor de Docker. En aquest atac s'utilitza hostapd-wpe per crear un fals AP. Aquest component sol donar conflicte amb network-manager. Des del contenidor, airgeddon no pot gestionar-lo. Si tens network-manager instal·lat a la teua màquina host, tanca'l o mata els processos en conflicte u obtindràs un error. Per a més informació consulta la secció Docker del Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["PORTUGUESE",528]="Detectamos que você está executando airgeddon em um contêiner Docker. Neste ataque é usado hostapd-wpe para criar um AP falso. Este componente tende a entrar em conflito com network-manager. A partir do contêiner o airgeddon não pode controlá-lo. Se você tem network-manager instalado em sua máquina host feche-o, mate os processos conflitantes ou você irá obter um erro. Para mais informações consulte a seção Docker Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["RUSSIAN",528]="Определено, что вы запускаете airgeddon внутри контейнера Docker. Во время этой атаки для создания поддельной AP используется hostapd-wpe. Этот компонент часто конфликтует с network-manager. Изнутри контейнера airgeddon не может справиться с этим. Если на вашем хост-компьютере установлен network-manager, закройте его или уберите конфликтующие процессы, иначе вы получите сообщение об ошибке. Для получения дополнительной информации см. раздел Docker в Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["GREEK",528]="Εντοπίστηκε πως τρέχετε το airgeddon μέσα σε Docker container. Κατά τη διάρκεια αυτής της επίθεσης χρησιμοποιείται το hostapd-wpe για να δημιουργήσει ψεύτικο AP. Η δημιουργία αυτού κάνει conflicts με τον network-manager. Το airgeddon δεν μπορεί να το χειριστεί μέσα από το container. Αν υπάρχει ο network-manager εγκατεστημένος στον host-υπολογιστή, κλείστε τον ή διακόψτε τις διεργασίες που κάνουν conflict αλλιώς θα υπάρξουν σφάλματα. Για περισσότερες πληροφορίες, ανατρέξτε στην ενότητα Docker του Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["ITALIAN",528]="È stato rilevato che si sta eseguendo airgeddon in un contenitore Docker. In questo attacco viene utilizzato hostapd-wpe per creare un falso AP. Questo componente tende a creare un conflitto con il network-manager. Dal contenitore, airgeddon non può gestirlo. Se si dispone di network-manager installato sul computer host, chiuderlo o uccidere i processi in conflitto o ci sará un errore. Per ulteriori informazioni consultare la sezione Docker della nostra Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["POLISH",528]="Wykryto, że używasz airgeddon w kontenerze Docker. W tym ataku hostapd-wpe służy do utworzenia fałszywego AP. Ten komponent często ma konflikt z network-manager. Z kontenera airgeddon nie może sobie z tym poradzić. Jeśli na komputerze hosta zainstalowano network-manager, zamknij lub zabij sprzeczne procesy lub otrzymasz błąd. Aby uzyskać więcej informacji, zobacz sekcję Docker Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["GERMAN",528]="Es wurde festgestellt, dass Sie airgeddon in einem Docker-Container ausführen. Bei diesem Angriff wird mit hostapd-wpe ein falscher AP erstellt. Diese Komponente steht normalerweise im Konflikt mit dem network-manager. Aus dem Container kann airgeddon das nicht schaffen. Wenn Sie den network-manager auf Ihrem Host-Computer installiert haben, schließen Sie ihn oder beenden Sie die Prozesse im Konflikt oder Sie erhalten einen Fehler. Weitere Informationen finden Sie im Abschnitt Docker des Wiki: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["TURKISH",528]="Bir Docker konteynırı içinde airgeddon çalıştırdığınız tespit edildi. Bu saldırı sırasında hostapd-wpe sahte bir AP oluşturmak için kullanılır. Bu bileşen genellikle ağ yöneticisi ile çakışır. Konteynırın içinden, hava hücresi bunu kaldıramaz. Ana makinenize ağ yöneticisi yüklüyse, kapat veya çakışan işlemleri durdurun veya bir hatayla karşılaşırsınız. Daha fazla bilgi için, Wiki'nin Docker bölümüne bakın: \${normal_color}\${urlgithub_wiki}/Docker"
	arr["ARABIC",528]="\${normal_color}\${urlgithub_wiki}/Docker\${pink_color} :في Docker التعامل معها. إذا كان لديك مدير شبكة مثبتًا على جهازك المضيف ، فقم بإغلاقه أو إنهاء العمليات المتضاربة أو ستحصل على خطأ. لمزيد من المعلومات ، راجع قسم airgeddon  مزيف. غالبًا ما يتعارض هذا المكون مع مدير الشبكة. من داخل الحاوية ، لا يستطيع AP لإنشاء hostapd-wpe خلال هذا الهجوم ، يتم استخدام .Docker داخل حاوية airgeddon تم الكشف عن أنك تقوم بتشغيل\${normal_color}"
	arr["CHINESE",528]="检测到您正在 Docker 容器内运行 airgeddon。在此攻击期间，hostapd-wpe 用于创建伪造的 AP。该组件经常与网络管理器冲突。从容器内部，airgeddon 无法处理它。如果您的主机上安装了网络管理器，请关闭它或终止冲突进程，否则您将收到错误消息。有关详细信息，请参阅 Wiki 的 Docker 部分: \${normal_color}\${urlgithub_wiki}/Docker"

	arr["ENGLISH",529]="It seems that nothing was captured during the Enterprise Evil Twin attack"
	arr["SPANISH",529]="Parece que no se ha capturado nada durante el ataque Evil Twin Enterprise"
	arr["FRENCH",529]="Il semble qu'on n'a rien capturé pendant l'attaque Evil Twin Enterprise"
	arr["CATALAN",529]="Sembla que no s'ha capturat res durant l'atac Evil Twin Enterprise"
	arr["PORTUGUESE",529]="Parece que nada foi capturado durante o ataque Evil Twin Enterprise"
	arr["RUSSIAN",529]="Судя по всему, ничего не было захвачено во время атаки Enterprise Evil Twin"
	arr["GREEK",529]="Φαίνεται ότι τίποτα δεν καταγράφηκε κατά τη διάρκεια της επίθεσης Enterprise Evil Twin"
	arr["ITALIAN",529]="Sembra che non sia stato catturato nulla durante l'attacco Evil Twin Enterprise"
	arr["POLISH",529]="Wygląda na to, że podczas ataku Evil Twin Enterprise nic nie zostało przechwycone"
	arr["GERMAN",529]="Es sieht so aus, als wäre nichts während des Evil Twin Enterprise Angriffs gefangen worden"
	arr["TURKISH",529]="Enterprise Şeytani İkiz saldırısı sırasında yakalanan hiçbir şey yok gibi görünüyor"
	arr["ARABIC",529]="Enterprise Evil Twin يبدو أنه لم يتم أسر أي شيء خلال هجوم"
	arr["CHINESE",529]="似乎在针对企业级加密的邪恶双胞胎攻击期间没有捕获任何东西"

	arr["ENGLISH",530]="Contratulations!! It seems you captured some hashes"
	arr["SPANISH",530]="Enhorabuena!! Parece que has capturado algún hash"
	arr["FRENCH",530]="Félicitations!! Il semble que vous ayez capturé des hashes"
	arr["CATALAN",530]="Enhorabona!! Sembla que has capturat algun hash"
	arr["PORTUGUESE",530]="Parabéns!! Parece que você capturou alguma hash"
	arr["RUSSIAN",530]="Поздравления!! Кажется, вы захватили хеши"
	arr["GREEK",530]="Συγχαρητήρια!! Φαίνεται ότι έχετε καταγράψει κάποιο hash"
	arr["ITALIAN",530]="Congratulazioni!! Sembra che tu abbia catturato qualche hash"
	arr["POLISH",530]="Gratulacje!! Wygląda na to, że przechwyciłeś hash"
	arr["GERMAN",530]="Herzlichen Glückwunsch!! Es scheint, dass Sie Hashes erfasst haben"
	arr["TURKISH",530]="Tebrikler!! Görünüşe göre bazı hashleri yakaladın"
	arr["ARABIC",530]="تهانينا!! يبدو أنك التقطت بعض التجزئات"
	arr["CHINESE",530]="恭喜！！看来你捕获了一些密码的哈希值"

	arr["ENGLISH",531]="Contratulations!! It seems you captured some plain text password/s"
	arr["SPANISH",531]="Enhorabuena!! Parece que has capturado alguna contraseña en texto plano"
	arr["FRENCH",531]="Félicitations!! Il semble que vous ayez capturé un mot de passe en texte brut"
	arr["CATALAN",531]="Enhorabona!! Sembla que has capturat alguna contrasenya en text pla"
	arr["PORTUGUESE",531]="Parabéns!! Parece que você capturou alguma senha em texto simples"
	arr["RUSSIAN",531]="Поздравления!! Кажется, что вы захватили пароль в текстовом виде"
	arr["GREEK",531]="Συγχαρητήρια!! Φαίνεται ότι έχετε καταγράψει κάποιο κωδικό πρόσβασης απλού κειμένου"
	arr["ITALIAN",531]="Congratulazioni!! Sembra che tu abbia catturato qualche password in chiaro"
	arr["POLISH",531]="Gratulacje!! Wygląda na to, że zdobyłeś hasło w postaci zwykłego tekstu"
	arr["GERMAN",531]="Herzlichen Glückwunsch!! Es scheint, dass Sie ein Passwort im Klartext erfasst haben"
	arr["TURKISH",531]="Tebrikler!! Text şifreleri yakaladınız gibi görünüyor"
	arr["ARABIC",531]="تهانينا!! يبدو أنك التقطت بعض كلمات المرور"
	arr["CHINESE",531]="恭喜！！您似乎捕获了一些纯文本密码"

	arr["ENGLISH",532]="Contratulations!! It seems you captured hashes and plain text passwords"
	arr["SPANISH",532]="Enhorabuena!! Parece que has capturado hashes y contraseñas en texto plano"
	arr["FRENCH",532]="Félicitations!! Il semble que vous ayez capturé des hashes et des mots de passe en texte brut"
	arr["CATALAN",532]="Enhorabona!! Sembla que has capturat hashes i contrasenyes en text pla"
	arr["PORTUGUESE",532]="Parabéns!! Parece que você capturou hashes e senhas em texto simples"
	arr["RUSSIAN",532]="Поздравления!! Кажется, что вы захватили хеши и пароли в текстовом виде"
	arr["GREEK",532]="Συγχαρητήρια!! Φαίνεται ότι έχετε καταγράψει τα hashes και τους κωδικούς πρόσβασης απλού κειμένου"
	arr["ITALIAN",532]="Congratulazioni!! Sembra che tu abbia catturato degli hash e delle passwords in chiaro"
	arr["POLISH",532]="Gratulacje!! Wygląda na to, że przechwyciłeś hashe i hasła w postaci zwykłego tekstu"
	arr["GERMAN",532]="Herzlichen Glückwunsch!! Es scheint, dass Sie Hashes und Passwörter im Klartext erfasst haben"
	arr["TURKISH",532]="Tebrikler!! Düz metinde karma ve şifreleri ele geçirmişsiniz gibi görünüyor"
	arr["ARABIC",532]="هانينا!! يبدو أنك التقطت تجزئات وكلمات مرور"
	arr["CHINESE",532]="恭喜！！您似乎捕获了哈希和纯文本密码"

	arr["ENGLISH",533]="The captured files were saved on directory [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["SPANISH",533]="Los ficheros capturados se han guardado en el directorio [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["FRENCH",533]="Les fichiers capturés ont été enregistrés dans le répertoire [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["CATALAN",533]="Els fitxers capturats s'han guardat al directori [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["PORTUGUESE",533]="Os arquivos capturados foram salvos no diretório [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["RUSSIAN",533]="Захваченные файлы были сохранены в каталоге [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["GREEK",533]="Τα αρχεία που έχουν ληφθεί αποθηκεύτηκαν στον κατάλογο [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["ITALIAN",533]="I file catturati sono stati salvati nella directory [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["POLISH",533]="Przechwycone pliki zostały zapisane w katalogu [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["GERMAN",533]="Die erfassten Dateien wurden im Verzeichnis [\${normal_color}\${enterprise_completepath}\${blue_color}] gespeichert \${normal_color}"
	arr["TURKISH",533]="Yakalanan dosyalar belirtilen dizine kaydedildi [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"
	arr["ARABIC",533]="[\${normal_color}\${enterprise_completepath}\${blue_color}] تم حفظ الملفات الملتقطة في الدليل\${normal_color}"
	arr["CHINESE",533]="捕获的文件保存在目录 [\${normal_color}\${enterprise_completepath}\${blue_color}]\${normal_color}"

	arr["ENGLISH",534]="1.  Personal"
	arr["SPANISH",534]="1.  Personal"
	arr["FRENCH",534]="1.  Personnel"
	arr["CATALAN",534]="1.  Personal"
	arr["PORTUGUESE",534]="1.  Personal"
	arr["RUSSIAN",534]="1.  Personal"
	arr["GREEK",534]="1.  Personal"
	arr["ITALIAN",534]="1.  Personal"
	arr["POLISH",534]="1.  Osobiste"
	arr["GERMAN",534]="1.  Persönlich"
	arr["TURKISH",534]="1.  Personal"
	arr["ARABIC",534]="1.  خاص"
	arr["CHINESE",534]="1.  个人级加密 (Personal)"

	arr["ENGLISH",535]="2.  Enterprise"
	arr["SPANISH",535]="2.  Enterprise"
	arr["FRENCH",535]="2.  Enterprise"
	arr["CATALAN",535]="2.  Enterprise"
	arr["PORTUGUESE",535]="2.  Enterprise"
	arr["RUSSIAN",535]="2.  Enterprise"
	arr["GREEK",535]="2.  Enterprise"
	arr["ITALIAN",535]="2.  Enterprise"
	arr["POLISH",535]="2.  Enterprise"
	arr["GERMAN",535]="2.  Enterprise"
	arr["TURKISH",535]="2.  Enterprise"
	arr["ARABIC",535]="2.  Enterprise"
	arr["CHINESE",535]="2.  企业级加密 (Enterprise)"

	arr["ENGLISH",536]="0.  Return to offline WPA/WPA2 decrypt menu"
	arr["SPANISH",536]="0.  Volver al menú de descifrado WPA/WPA2 offline"
	arr["FRENCH",536]="0.  Retourner au menu de décryptage hors ligne WPA/WPA2"
	arr["CATALAN",536]="0.  Tornar al menú per desxifrar WPA/WPA2 offline"
	arr["PORTUGUESE",536]="0.  Voltar ao menu de descriptografia WPA/WPA2 offline"
	arr["RUSSIAN",536]="0.  Вернуться в меню офлайн расшифровки WPA/WPA2"
	arr["GREEK",536]="0.  Επιστροφή στο μενού offline αποκρυπτογράφησης WPA/WPA2"
	arr["ITALIAN",536]="0.  Tornare al menù per decifrare WPA/WPA2 offline"
	arr["POLISH",536]="0.  Wróć do menu deszyfrowania WPA/WPA2 offline"
	arr["GERMAN",536]="0.  Zurück zum Offline-WPA/WPA2-Entschlüsselungsmenü"
	arr["TURKISH",536]="0.  Çevrimdışı WPA/WPA2 şifre çözme menüsüne dön"
	arr["ARABIC",536]="0.  دون اتصال WPA/WPA2 العودة إلى قائمة فك تشفير"
	arr["CHINESE",536]="0.  返回上一级菜单"

	arr["ENGLISH",537]="Do you want to try to decrypt captured stuff? \${blue_color}Asleap tool will be used. If you answer no \"n\" you'll can try to do it later using hashcat or john the ripper from the offline WPA/WPA2 decrypt menu \${normal_color}\${visual_choice}"
	arr["SPANISH",537]="¿Quieres intentar descifrar lo capturado? \${blue_color}Se utilizará la herramienta asleap. Si respondes no \"n\" podrás intentarlo más tarde utilizando hashcat o john the ripper desde el menú de descifrado offline WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["FRENCH",537]="Voulez-vous essayer de déchiffrer ce qui a été capturé? \${blue_color}L'outil asleap sera utilisé. Si vous ne répondez pas \"n\", vous pourrez l'essayer après avec hashcat ou john the ripper à partir du menu de décryptage hors ligne WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["CATALAN",537]="Vols intentar desxifrar el capturat? \${blue_color}S'utilitzarà l'eina asleap. Si respons no \"n\" podràs provar més tard utilitzant hashcat o john the ripper des del menú de desxifrat offline WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",537]="Você quer tentar decifrar o que foi capturado? \${blue_color}A ferramenta asleap será usada. Se você responder não \"n\" você pode tentar mais tarde usando o hashcat ou john the ripper no menu de descriptografia WPA/WPA2 offline \${normal_color}\${visual_choice}"
	arr["RUSSIAN",537]="Вы хотите попытаться расшифровать захваченные хеши? \${blue_color}Будет использован инструмент asleap. Если вы ответите нет \"n\", вы можете попытаться сделать это позже, используя hashcat или john the ripper из меню офлайн расшифровки WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["GREEK",537]="Θέλετε να προσπαθήσετε να αποκρυπτογραφήσετε τα περιεχόμενα; \${blue_color}Το εργαλείο asleap θα χρησιμοποιηθεί. Εάν απαντήσετε όχι \"n\", μπορείτε να προσπαθήσετε να το κάνετε αργότερα χρησιμοποιώντας hashcat ή john the ripper από το μενού αποκρυπτογράφησης WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["ITALIAN",537]="Vuoi provare a decifrare ciò che è stato catturato? \${blue_color}Verrà utilizzato il programma asleap. Se non rispondi a nessun \"n\" puoi provarci in seguito usando hashcat o john the ripper dal menu di decodifica offline WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["POLISH",537]="Czy chcesz spróbować rozszyfrować przechwycone dane? \${blue_color}Zostanie użyte narzędzie o nazwie asleap. Jeśli nie odpowiesz \"n\", możesz spróbować później za pomocą programu hashcat lub john the ripper z menu deszyfrowania offline WPA/WPA2 \${normal_color}\${visual_choice}"
	arr["GERMAN",537]="Möchten Sie versuchen, das Erfasste zu entschlüsseln? \${blue_color}Das Tool asleap wird verwendet. Wenn Sie nein \"n\" antworten, können Sie es später mit hashcat oder john the ripper vom Offline-Entschlüsselungsmenü WPA/WPA2 versuchen \${normal_color}\${visual_choice}"
	arr["TURKISH",537]="Yakalanan şeyleri decrypt(şifre çözme) etmek ister misin? \${blue_color}Asleap aracı kullanılacaktır. Eğer \"n\" yanıtı vermezseniz, daha sonra, çevrimdışı şifre çözme menüsü WPA/WPA2'den, hashcat veya john the ripper'ı kullanarak deneyebilirsiniz \${normal_color}\${visual_choice}"
	arr["ARABIC",537]="\${normal_color}\${visual_choice}\${blue_color} بدون اتصال WPA/WPA2 يمكنك محاولة القيام بذلك لاحقًا باستخدام التجزئة أو جون الممزق من قائمة فك تشفير \"n\" إذا أجبت بـ لا .Asleap سيتم استخدام أداة \${green_color}هل تريد محاولة فك تشفير الأشياء التي تم التقاطها؟"
	arr["CHINESE",537]="你想尝试解密捕获的东西吗？\${blue_color}将使用 asleap 工具。如果您回答否 \"n\"，您稍后可以尝试使用 hashcat 或 john the ripper 从离线 WPA/WPA2 解密菜单 \${normal_color}\${visual_choice}"

	arr["ENGLISH",538]="The password for the username \${normal_color}\${enterprise_username}\${blue_color} will be tried to be decrypted with asleap tool using challenge and response: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["SPANISH",538]="Se procederá a intentar descifrar con la herramienta asleap la contraseña del usuario \${normal_color}\${enterprise_username}\${blue_color} cuyo challenge y response son: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["FRENCH",538]="On va essayer de déchiffrer avec l'outil asleap le mot de passe de l'utilisateur \${normal_color}\${enterprise_username}\${blue_color} dont le défi et la réponse sont les suivants: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["CATALAN",538]="Es procedirà a intentar desxifrar amb l'eina asleap la contrasenya de l'usuari \${normal_color}\${enterprise_username}\${blue_color} el challenge i response són: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["PORTUGUESE",538]="Vamos tentar decifrar a senha do usuário \${normal_color}\${enterprise_username}\${blue_color} com a ferramenta asleap, o desafio e a resposta são: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["RUSSIAN",538]="Пароль для имени пользователя \${normal_color}\${enterprise_username}\${blue_color} будет подвергнут расшифровке с помощью asleap с использованием запроса и ответа: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["GREEK",538]="Ο κωδικός πρόσβασης για το όνομα χρήστη \${normal_color}\${enterprise_username}\${blue_color} θα δοκιμαστεί για να αποκρυπτογραφηθεί με το asleap χρησιμοποιώντας challenge και response: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["ITALIAN",538]="Si cercherá di decifrare la password dell'utente con il programma asleap  \${normal_color}\${enterprise_username}\${blue_color} i cui challange e reponse sono: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["POLISH",538]="Spróbujemy rozszyfrować za pomocą narzędzia asleap hasło użytkownika \${normal_color}\${enterprise_username}\${blue_color}, którego challenge i odpowiedzią są: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["GERMAN",538]="Wir werden versuchen, mit dem asleap-Tool das Passwort des Benutzers \${normal_color}\${enterprise_username}\${blue_color} zu entschlüsseln, dessen Challenge und Antwort lauten: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["TURKISH",538]="Asleap aracıyla, sorunu ve yanıtı olan kullanıcının \${normal_color}\${enterprise_username}\${blue_color} şifresini çözmeyi deneyeceğiz: \${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}"
	arr["ARABIC",538]="\${normal_color}\${enterprise_captured_challenges_responses[\${enterprise_username}]}\${blue_color} :استخدام أداة التحدي والاستجابة \${normal_color}\${enterprise_username}\${blue_color} ستتم محاولة فك تشفير كلمة مرور اسم المستخدم\${normal_color}"
	arr["CHINESE",538]="用户名 \${normal_color}\${enterprise_username}\${blue_color} 的密码将尝试使用挑战和响应使用 asleap 工具解密: \${normal_color}\${enterprise_captured_challenges_responses[\${企业用户名}]}"

	arr["ENGLISH",539]="Asleap trophy file generated successfully at [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["SPANISH",539]="Fichero de trofeo asleap generado con éxito en [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["FRENCH",539]="Le fichier trophée asleap a bien été crée dans [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["CATALAN",539]="Fitxer de trofeu asleap generat amb èxit a [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["PORTUGUESE",539]="Arquivo de troféu asleap gerado com sucesso [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["RUSSIAN",539]="Трофейный файл asleap был успешно сгенерирован в [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["GREEK",539]="Το asleap αρχείο τρόπαιο δημιουργήθηκε επιτυχώς [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["ITALIAN",539]="File di trofeo di asleap generato con successo [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["POLISH",539]="Plik trofeum asleap został pomyślnie wygenerowany w [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["GERMAN",539]="Trophäen-Datei-Asleap erfolgreich in [\${normal_color}\${path_to_asleap_trophy}\${blue_color}] generiert"
	arr["TURKISH",539]="Asleap trophy dosyası başarıyla şurada oluşturuldu [\${normal_color}\${path_to_asleap_trophy}\${blue_color}]"
	arr["ARABIC",539]="[\${normal_color}\${path_to_asleap_trophy}\${blue_color}] بنجاح في Asleap trophy تم إنشاء ملف"
	arr["CHINESE",539]="在 [\${normal_color}\${path_to_asleap_trophy}\${blue_color}] 成功生成 Asleap 解密文件"

	arr["ENGLISH",540]="It seems we failed... try it again using another dictionary or choose bruteforce/rule based attack from the offline WPA/WPA2 decrypt menu"
	arr["SPANISH",540]="Parece que no lo hemos conseguido... inténtalo de nuevo con otro diccionario o por fuerza bruta/ataque basado en reglas desde el menú de descifrado hors ligne WPA/WPA2"
	arr["FRENCH",540]="Il semble que nous n'ayons pas réussi... réessayez avec un autre dictionnaire ou par force brute/attaque basée sur les règles du menu de décryptage  WPA/WPA2"
	arr["CATALAN",540]="Sembla que no ho hem aconseguit... intenta-ho de nou amb un altre diccionari o per força bruta/atac basat en regles des del menú de desxifrat offline WPA/WPA2"
	arr["PORTUGUESE",540]="Parece que não conseguimos... Tente novamente usando outro dicionário ou fazendo um ataque de força bruta baseado em regras do menu de descriptografia WPA/WPA2 offline"
	arr["RUSSIAN",540]="Кажется, мы потерпели неудачу... повторите попытку с помощью другого словаря или выберите атаку, основанную на грубой силе/правилах, из меню офлайн расшифровки WPA/WPA2"
	arr["GREEK",540]="Φαίνεται ότι αποτύχαμε... Δοκιμάστε το ξανά χρησιμοποιώντας ένα άλλο λεξικό ή επιλέξτε τη βίαιη επίθεση/εξάρτηση βάσει κανόνων από το μενού αποκρυπτογράφησης WPA/WPA2 εκτός σύνδεσης"
	arr["ITALIAN",540]="Sembra che non ci siamo riusciti... riprova con un altro dizionario o con forza bruta/attacco basato su regole del menu di decodifica offline WPA/WPA2"
	arr["POLISH",540]="Wygląda na to, że się nie udało... spróbuj ponownie, używając innego słownika lub wybierz atak z użyciem brute force/reguły z menu odszyfrowania offline WPA/WPA2"
	arr["GERMAN",540]="Es scheint, dass wir es versäumt haben... versuchen Sie es erneut mit einem anderen Wörterbuch oder wählen Sie Brute-Force/Regel-basierte Angriffe aus dem Offline-WPA/WPA2-Entschlüsselungsmenü"
	arr["TURKISH",540]="Başarısız olduk gibi görünüyor... başka bir dictionary kullanarak tekrar deneyin ya da çevrimdışı WPA/WPA2 şifre çözme menüsünden bruteforce/rule tabanlı saldırı seçin"
	arr["ARABIC",540]="دون اتصال WPA/WPA2 حاول مرة أخرى باستخدام قاموس آخر أو اختر هجومًا قائمًا على القوة/القاعدة من قائمة فك تشفير...يبدو أننا فشلنا"
	arr["CHINESE",540]="看来我们失败了... 请使用另一个字典重试或从离线 WPA/WPA2 解密菜单中选择基于暴力/规则的攻击"

	arr["ENGLISH",541]="Do you want to retry asleap attack using another dictionary? \${normal_color}\${visual_choice}"
	arr["SPANISH",541]="¿Quieres intentar de nuevo el ataque con asleap utilizando otro diccionario? \${normal_color}\${visual_choice}"
	arr["FRENCH",541]="Voulez-vous réessayer l'attaque en utilisant un autre dictionnaire avec asleap? \${normal_color}\${visual_choice}"
	arr["CATALAN",541]="Vols provar de nou l'atac amb asleap utilitzant un altre diccionari? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",541]="Você quer tentar novamente o ataque asleap usando outro dicionário? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",541]="Вы хотите повторить атаку в asleap с другим словарём? \${normal_color}\${visual_choice}"
	arr["GREEK",541]="Θέλετε να επαναλάβετε την επίθεση asleap χρησιμοποιώντας κάποιο άλλο λεξικό; \${normal_color}\${visual_choice}"
	arr["ITALIAN",541]="Vuoi provare di nuovo l'attacco con asleap usando un altro dizionario? \${normal_color}\${visual_choice}"
	arr["POLISH",541]="Czy chcesz ponowić atak asleap z użyciem innego słownika? \${normal_color}\${visual_choice}"
	arr["GERMAN",541]="Möchten Sie den Asleap Angriff mit einem anderen Wörterbuch wiederholen? \${normal_color}\${visual_choice}"
	arr["TURKISH",541]="Başka bir dictionary kullanarak asleap saldırısını tekrar denemek ister misiniz? \${normal_color}\${visual_choice}"
	arr["ARABIC",541]="\${normal_color}\${visual_choice}\${green_color} باستخدام قاموس آخر؟ asleap هل تريد إعادة محاولة هجوم\${normal_color}"
	arr["CHINESE",541]="你想用另一本字典重试 asleap 攻击吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",542]="You captured hash only for one user. Autoselected"
	arr["SPANISH",542]="Sólo capturaste hash de un usuario. Se ha seleccionado automáticamente"
	arr["FRENCH",542]="Vous venez de capturer le hash d'un utilisateur. Il a été sélectionné automatiquement"
	arr["CATALAN",542]="Només vas capturar hash d'un usuari. S'ha seleccionat automàticament"
	arr["PORTUGUESE",542]="Você capturou apenas uma hash de usuário. Ela foi selecionada automaticamente"
	arr["RUSSIAN",542]="Вы захватили хеш только для одного пользователя. Выбран автоматически"
	arr["GREEK",542]="Καταγράψατε κάποιο hash μόνο για έναν χρήστη. Επιλέχθηκε αύτοματα"
	arr["ITALIAN",542]="Hai appena catturato l'hash di un utente. È stato selezionato automaticamente"
	arr["POLISH",542]="Przechwiciłeś hasz tylko dla jednego użytkownika. Wybrano automatycznie"
	arr["GERMAN",542]="Sie haben nur einen Hash für einen Benutzer erfasst. Dieser wird Automatisch ausgewählt"
	arr["TURKISH",542]="Sadece bir kullanıcı için hash yakaladınız. Otomatik olarak seçildi"
	arr["ARABIC",542]="لقد التقطت للتو تجزئة المستخدم. تم اختياره تلقائيًا"
	arr["CHINESE",542]="您仅为一个用户捕获了哈希。已自动选择"

	arr["ENGLISH",543]="Chosen option is invalid. Select one number shown in the menu"
	arr["SPANISH",543]="La opción elegida no es válida. Selecciona un número de los mostrados en el menú"
	arr["FRENCH",543]="L'option choisie n'est pas valide. Sélectionnez un numéro montré sur le menu"
	arr["CATALAN",543]="L'opció triada no és vàlida. Selecciona un nombre dels mostrats en el menú"
	arr["PORTUGUESE",543]="A opção escolhida não é válida. Selecione um número entre os mostrados no menu"
	arr["RUSSIAN",543]="Выбранная опция недействительна. Выберите один номер, показанный в меню"
	arr["GREEK",543]="Η επιλογή που έχετε επιλέξει δεν είναι έγκυρη. Επιλέξτε κάποιον αριθμό που εμφανίζεται στο μενού"
	arr["ITALIAN",543]="L'opzione scelta non è valida. Seleziona un numero tra quelli indicati nel menu"
	arr["POLISH",543]="Wybrana opcja jest nieprawidłowa. Wybierz numer wyświetlony w menu"
	arr["GERMAN",543]="Die gewählte Option ist ungültig. Wählen Sie eine Nummer aus dem Menü"
	arr["TURKISH",543]="Seçilen seçenek geçersiz. Menüde gösterilen bir sayıyı seçin"
	arr["ARABIC",543]="الخيار المختار غير صالح. حدد رقمًا واحدًا في القائمة"
	arr["CHINESE",543]="所选选项无效。选择菜单中显示的一个号码"

	arr["ENGLISH",544]="john the ripper CPU, non GPU attacks"
	arr["SPANISH",544]="ataques john the ripper CPU, no GPU"
	arr["FRENCH",544]="attaques john the ripper CPU, pas GPU"
	arr["CATALAN",544]="atacs john the ripper CPU, no GPU"
	arr["PORTUGUESE",544]="Ataques com john the ripper usando CPU, não GPU"
	arr["RUSSIAN",544]="Атаки john the ripper с использованием центрального процессора, без использования видеокарты"
	arr["GREEK",544]="επιθέσεις john the ripper CPU, όχι GPU"
	arr["ITALIAN",544]="attacchi john the ripper CPU, non GPU"
	arr["POLISH",544]="ataki john the ripper CPU, nie GPU"
	arr["GERMAN",544]="CPU-john the ripper-Angriffe, kein GPU-Angriff"
	arr["TURKISH",544]="john the ripper CPU, GPU olmayan saldırılar"
	arr["ARABIC",544]="GPU هجمات غير معتمدة على ،john the ripper CPU"
	arr["CHINESE",544]="john the ripper 仅使用 CPU 破解"

	arr["ENGLISH",545]="1.  (john the ripper) Dictionary attack against capture file"
	arr["SPANISH",545]="1.  (john the ripper) Ataque de diccionario sobre fichero de captura"
	arr["FRENCH",545]="1.  (john the ripper) Attaque de dictionnaire en utilisant le fichier de capture"
	arr["CATALAN",545]="1.  (john the ripper) Atac de diccionari sobre fitxer de captura"
	arr["PORTUGUESE",545]="1.  (john the ripper) Ataque com dicionário em um handshake"
	arr["RUSSIAN",545]="1.  (john the ripper) Атака по словарю в отношению захваченного файла"
	arr["GREEK",545]="1.  (john the ripper) Επίθεση με χρήση λεξικού σε αρχείο καταγραφής"
	arr["ITALIAN",545]="1.  (john the ripper) Attacco di dizionario sul file di cattura"
	arr["POLISH",545]="1.  (john the ripper) Atak słownikowy na plik przechwytywania"
	arr["GERMAN",545]="1.  (john the ripper) Wörterbuchangriff auf die Aufnahmedatei"
	arr["TURKISH",545]="1.  (john the ripper) Yakalama dosyasına karşı sözlük saldırısı"
	arr["ARABIC",545]="1.  هجوم القاموس على ملف الالتقاط (john the ripper)"
	arr["CHINESE",545]="1. (john the ripper)针对捕获文件的字典攻击"

	arr["ENGLISH",546]="2.  (john the ripper + crunch) Bruteforce attack against capture file"
	arr["SPANISH",546]="2.  (john the ripper + crunch) Ataque de fuerza bruta sobre fichero de captura"
	arr["FRENCH",546]="2.  (john the ripper + crunch) Attaque de force brute en utilisant le fichier de capture"
	arr["CATALAN",546]="2.  (john the ripper + crunch) Atac de força bruta sobre fitxer de captura"
	arr["PORTUGUESE",546]="2.  (john the ripper + crunch) Ataque de força bruta em um arquivo de captura"
	arr["RUSSIAN",546]="2.  (john the ripper + crunch) Атака грубой силы на файл захвата"
	arr["GREEK",546]="2.  (john the ripper + crunch) Επίθεση ωμής βίας σε αρχείο καταγραφής"
	arr["ITALIAN",546]="2.  (john the ripper + crunch) Attacco di forza bruta sul file di cattura"
	arr["POLISH",546]="2.  (john the ripper + crunch) Atak brute force na plik przechwytywania"
	arr["GERMAN",546]="2.  (john the ripper + crunch) Brute-Force-Angriff auf die Capture-Datei"
	arr["TURKISH",546]="2.  (john the ripper + crunch) Yakalama dosyasına karşı bruteforce saldırısı"
	arr["ARABIC",546]="2.  ضد ملف الالتقاط Bruteforce هجوم (john the ripper + crunch)"
	arr["CHINESE",546]="2. (john the ripper + crunch) 暴力破解捕获文件"

	arr["ENGLISH",547]="John the ripper trophy file generated successfully at [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["SPANISH",547]="Fichero de trofeo john the ripper generado con éxito en [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["FRENCH",547]="Le fichier trophée john the ripper a bien été crée dans [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["CATALAN",547]="Fitxer de trofeu john the ripper generat amb èxit a [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["PORTUGUESE",547]="Arquivo de troféu john the ripper gerado com sucesso [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["RUSSIAN",547]="Трофейный файл john the ripper был успешно сгенерирован в [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["GREEK",547]="Το john the ripper αρχείο τρόπαιο δημιουργήθηκε επιτυχώς [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["ITALIAN",547]="File di trofeo di john the ripper generato con successo [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["POLISH",547]="Plik trofeum john the ripper został pomyślnie wygenerowany w [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["GERMAN",547]="Trophäen-Datei-john the ripper erfolgreich in [\${normal_color}\${jtrpotenteredpath}\${blue_color}] generiert"
	arr["TURKISH",547]="John the ripper trophy dosyası başarıyla şurada oluşturuldu [\${normal_color}\${jtrpotenteredpath}\${blue_color}]"
	arr["ARABIC",547]="[\${normal_color}\${jtrpotenteredpath}\${blue_color}] بنجاح في John the ripper trophy تم إنشاء ملف"
	arr["CHINESE",547]="John the ripper 解密文件在 [\${normal_color}\${jtrpotenteredpath}\${blue_color}] 成功生成"

	arr["ENGLISH",548]="asleap CPU"
	arr["SPANISH",548]="asleap CPU"
	arr["FRENCH",548]="asleap CPU"
	arr["CATALAN",548]="asleap CPU"
	arr["PORTUGUESE",548]="asleap CPU"
	arr["RUSSIAN",548]="asleap CPU"
	arr["GREEK",548]="asleap CPU"
	arr["ITALIAN",548]="asleap CPU"
	arr["POLISH",548]="asleap CPU"
	arr["GERMAN",548]="asleap CPU"
	arr["TURKISH",548]="asleap CPU"
	arr["ARABIC",548]="asleap CPU"
	arr["CHINESE",548]="asleap CPU 破解"

	arr["ENGLISH",549]="6.  (asleap) Challenge/response dictionary attack"
	arr["SPANISH",549]="6.  (asleap) Ataque de diccionario challenge/response"
	arr["FRENCH",549]="6.  (asleap) Attaque du dictionnaire défi/réponse"
	arr["CATALAN",549]="6.  (asleap) Atac de diccionari challenge/response"
	arr["PORTUGUESE",549]="6.  (asleap) Ataque de desafio/resposta com dicionário"
	arr["RUSSIAN",549]="6.  (asleap) Атака по словарю на вызов/ответ"
	arr["GREEK",549]="6.  (asleap) Επίθεση challenge/response με τη χρήση λεξικού"
	arr["ITALIAN",549]="6.  (asleap) Attacco di dizionario challenge/response"
	arr["POLISH",549]="6.  (asleap) Atak słownikowey challenge/odpowiedź"
	arr["GERMAN",549]="6.  (asleap) Wörterbuch-Angriff: Herausforderung/Antwort"
	arr["TURKISH",549]="6.  (asleap) Challenge/response sözlük saldırısı"
	arr["ARABIC",549]="6.  (asleap) Challenge/response هجوم قاموس"
	arr["CHINESE",549]="6.  (asleap) 挑战/响应字典攻击"

	arr["ENGLISH",550]="3.  (hashcat) Dictionary attack against capture file"
	arr["SPANISH",550]="3.  (hashcat) Ataque de diccionario sobre fichero de captura"
	arr["FRENCH",550]="3.  (hashcat) Attaque de dictionnaire en utilisant le fichier de capture"
	arr["CATALAN",550]="3.  (hashcat) Atac de diccionari sobre fitxer de captura"
	arr["PORTUGUESE",550]="3.  (hashcat) Ataque com dicionário em um handshake"
	arr["RUSSIAN",550]="3.  (hashcat) Атака по словарю в отношению захваченного файла"
	arr["GREEK",550]="3.  (hashcat) Επίθεση με χρήση λεξικού σε αρχείο καταγραφής"
	arr["ITALIAN",550]="3.  (hashcat) Attacco di dizionario sul file di cattura"
	arr["POLISH",550]="3.  (hashcat) Atak słownikowy na plik przechwytywania"
	arr["GERMAN",550]="3.  (hashcat) Wörterbuchangriff auf die Aufnahmedatei"
	arr["TURKISH",550]="3.  (hashcat) Yakalama dosyasına karşı sözlük saldırısı"
	arr["ARABIC",550]="3.  هجوم القاموس على ملف الالتقاط (hashcat)"
	arr["CHINESE",550]="3.  (hashcat) 字典攻击捕获文件"

	arr["ENGLISH",551]="4.  (hashcat) Bruteforce attack against capture file"
	arr["SPANISH",551]="4.  (hashcat) Ataque de fuerza bruta sobre fichero de captura"
	arr["FRENCH",551]="4.  (hashcat) Attaque de force brute en utilisant le fichier de capture"
	arr["CATALAN",551]="4.  (hashcat) Atac de força bruta sobre fitxer de captura"
	arr["PORTUGUESE",551]="4.  (hashcat) Ataque de força bruta em um handshake"
	arr["RUSSIAN",551]="4.  (hashcat) Атака рукопожатия полным перебором"
	arr["GREEK",551]="4.  (hashcat) Επίθεση ωμής βίας σε αρχείο καταγραφής"
	arr["ITALIAN",551]="4.  (hashcat) Attacco di forza bruta sul file di cattura"
	arr["POLISH",551]="4.  (hashcat) Atak brute force na plik przechwytywania"
	arr["GERMAN",551]="4.  (hashcat) Brute-Force-Angriff auf die Capture-Datei"
	arr["TURKISH",551]="4.  (hashcat) Yakalama dosyasına karşı bruteforce saldırısı"
	arr["ARABIC",551]="4.  على ملف الالتقاط Bruteforce هجوم (hashcat)"
	arr["CHINESE",551]="4.  (hashcat) 暴力破解捕获文件"

	arr["ENGLISH",552]="5.  (hashcat) Rule based attack against capture file"
	arr["SPANISH",552]="5.  (hashcat) Ataque basado en reglas sobre fichero de captura"
	arr["FRENCH",552]="5.  (hashcat) Attaque fondé sur des règles en utilisant le fichier de capture"
	arr["CATALAN",552]="5.  (hashcat) Atac basat en regles sobre el fitxer de captura"
	arr["PORTUGUESE",552]="5.  (hashcat) Ataque baseado em regras em um arquivo handshake"
	arr["RUSSIAN",552]="5.  (hashcat) Атака на основе правила в отношении захваченного файла"
	arr["GREEK",552]="5.  (hashcat) Επίθεση κανόνων σε αρχείο καταγραφής"
	arr["ITALIAN",552]="5.  (hashcat) Attacco basato su regole contro il file di cattura"
	arr["POLISH",552]="5.  (hashcat) Atak bazujący na regułach na plik przechwytywania"
	arr["GERMAN",552]="5.  (hashcat) Regel-basierender Angriff gegen der Capture-Datei"
	arr["TURKISH",552]="5.  (hashcat) Yakalama dosyasına karşı kural tabanlı saldırı"
	arr["ARABIC",552]="5.  هجوم قائم على القواعد على ملف الالتقاط (hashcat)"
	arr["CHINESE",552]="5.  (hashcat) 针对捕获文件使用基于字典规则的攻击"

	arr["ENGLISH",553]="Type challenge (example: 00:11:22:33:44:55:66:77):"
	arr["SPANISH",553]="Escribe el challenge (ejemplo: 00:11:22:33:44:55:66:77):"
	arr["FRENCH",553]="Veuillez introduire le défi (exemple: 00:11:22:33:44:55:66:77):"
	arr["CATALAN",553]="Escriu el challenge (exemple: 00:11:22:33:44:55:66:77):"
	arr["PORTUGUESE",553]="Escreva o desafio (exemplo: 00:11:22:33:44:55:66:77):"
	arr["RUSSIAN",553]="Введите вызов (пример: 00:11:22:33:44:55:66:77):"
	arr["GREEK",553]="Πληκτρολογήστε το challenge (παράδειγμα: 00:11:22:33:44:55:66:77):"
	arr["ITALIAN",553]="Scrivi il challenge (esempio: 00:11:22:33:44:55:66:77):"
	arr["POLISH",553]="Wpisz challenge (przykład: 00:11:22:33:44:55:66:77):"
	arr["GERMAN",553]="Schreiben Sie den Challenge (Beispiel: 00:11:22:33:44:55:66:77):"
	arr["TURKISH",553]="Challenge tipi (example: 00:11:22:33:44:55:66:77):"
	arr["ARABIC",553]="اكتب التحدي (مثال: 00:11:22:33:44:55:66:77):"
	arr["CHINESE",553]="请输入挑战值 (例如: 00:11:22:33:44:55:66:77):"

	arr["ENGLISH",554]="Type response (example: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["SPANISH",554]="Escribe el response (ejemplo: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["FRENCH",554]="Veuillez introduire le réponse (exemple: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["CATALAN",554]="Escriu el response (exemple: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["PORTUGUESE",554]="Escreva a resposta (exemplo: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["RUSSIAN",554]="Введите ответ (пример: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["GREEK",554]="Πληκτρολογήστε το response (παράδειγμα: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["ITALIAN",554]="Scrivi il response (esempio: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["POLISH",554]="Wpisz odpowiedź (przykład: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["GERMAN",554]="Geben Sie die Antwort ein (Beispiel: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["TURKISH",554]="Yanıt tipi (example: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"
	arr["ARABIC",554]=":(00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17 :اكتب الرد (مثال"
	arr["CHINESE",554]="请输入响应值 (例如: 00:01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f:10:11:12:13:14:15:16:17):"

	arr["ENGLISH",555]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${asleap_potpath}]"
	arr["SPANISH",555]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${asleap_potpath}]"
	arr["FRENCH",555]="Entrez le chemin où vous voulez enregistrer le fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${asleap_potpath}]"
	arr["CATALAN",555]="Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${asleap_potpath}]"
	arr["PORTUGUESE",555]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${asleap_potpath}]"
	arr["RUSSIAN",555]="Напечатайте путь к сохранённому файлу или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${asleap_potpath}]"
	arr["GREEK",555]="Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${asleap_potpath}]"
	arr["ITALIAN",555]="Immettere il percorso dove memorizzare il file o premere [Enter] per accettare quello proposto di default \${normal_color}[\${asleap_potpath}]"
	arr["POLISH",555]="Wpisz ścieżkę, w której będziemy zapisywać plik lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${asleap_potpath}]"
	arr["GERMAN",555]="Geben Sie den Pfad ein, unter dem die Datei gespeichert werden soll, oder drücken Sie die [Enter]-Taste, um den Standardvorschlag zu akzeptieren \${normal_color}[\${asleap_potpath}]"
	arr["TURKISH",555]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın \${normal_color}[\${asleap_potpath}]"
	arr["ARABIC",555]="\${normal_color}[\${asleap_potpath}]\${green_color} لقبول الاقتراح [Enter] اكتب المسار لتخزين الملف أو اضغط على\${normal_color}"
	arr["CHINESE",555]="请输入文件存储的路径或按 [Enter] 接受默认建议 \${normal_color}[\${asleap_potpath}]"

	arr["ENGLISH",556]="4.  Enable basic colorization permanently"
	arr["SPANISH",556]="4.  Habilitar permanentemente la colorización básica"
	arr["FRENCH",556]="4.  Activer en permanence la colorisation basique"
	arr["CATALAN",556]="4.  Habilita permanentment la coloració bàsica"
	arr["PORTUGUESE",556]="4.  Ativar permanentemente as cores básicas"
	arr["RUSSIAN",556]="4.  Включить базовую окраску, в том числе после перезапуска"
	arr["GREEK",556]="4.  Ενεργοποιήστε μόνιμα τον βασικό χρωματισμό"
	arr["ITALIAN",556]="4.  Attivare permanentemente la colorazione basica"
	arr["POLISH",556]="4.  Włącz na stałe podstawowe kolorowanie"
	arr["GERMAN",556]="4.  Grundfärbung dauerhaft aktivieren"
	arr["TURKISH",556]="4.  Temel renklendirmeyi kalıcı olarak etkinleştir"
	arr["ARABIC",556]="4.  تفعيل التلوين الأساسي بشكل دائم"
	arr["CHINESE",556]="4.  永久启用基本着色"

	arr["ENGLISH",557]="4.  Disable basic colorization permanently"
	arr["SPANISH",557]="4.  Deshabilitar permanentemente la colorización básica"
	arr["FRENCH",557]="4.  Désactiver la colorisation basique de en permanence"
	arr["CATALAN",557]="4.  Deshabilita permanentment la coloració bàsica"
	arr["PORTUGUESE",557]="4.  Desativar permanentemente as cores básicas"
	arr["RUSSIAN",557]="4.  Отключить базовую окраску, в том числе после перезапуска"
	arr["GREEK",557]="4.  Απενεργοποιήστε μόνιμα τον βασικό χρωματισμό"
	arr["ITALIAN",557]="4.  Disattivare permanentemente la colorazione basica"
	arr["POLISH",557]="4.  Wyłącz na stałe podstawowe kolorowanie"
	arr["GERMAN",557]="4.  Grundfärbung dauerhaft deaktivieren"
	arr["TURKISH",557]="4.  Temel renklendirmeyi kalıcı olarak devre dışı bırak"
	arr["ARABIC",557]="4.  تعطيل التلوين الأساسي بشكل دائم"
	arr["CHINESE",557]="4.  永久禁用基本着色"

	arr["ENGLISH",558]="\${blue_color}Basic colorization is going to be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",558]="\${blue_color}Se va a desactivar la colorización básica. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",558]="\${blue_color}La colorisation basique va être désactivée. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",558]="\${blue_color}Es va a desactivar le coloració bàsica. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",558]="\${blue_color}As cores básicas serão desativas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",558]="\${blue_color}Базовая раскраска будет отключена. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",558]="\${blue_color}Ο βασικός χρωματισμός πρόκειται να απενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",558]="\${blue_color}La colorazione basica sará disattivata. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",558]="\${blue_color}Podstawowe kolorowanie zostanie wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",558]="\${blue_color}Die Grundfärbung wird deaktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",558]="\${blue_color}Temel renklendirme devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",558]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تعطيل التلوين الأساسي\${normal_color}"
	arr["CHINESE",558]="\${blue_color}基本着色将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",559]="\${blue_color}Basic colorization is going to be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",559]="\${blue_color}Se va a activar la colorización básica. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",559]="\${blue_color}La colorisation basique va être activée. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",559]="\${blue_color}Es va a activar la coloració bàsica. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",559]="\${blue_color}As cores básica serão ativas. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",559]="\${blue_color}Базовая раскраска будет включена. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",559]="\${blue_color}Ο βασικός χρωματισμός πρόκειται να ενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",559]="\${blue_color}La colorazione basica sará attivata. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",559]="\${blue_color}Podstawowe kolorowanie zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",559]="\${blue_color}Die Grundfärbung wird aktiviert. \${green_color}Wollen Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",559]="\${blue_color}Temel renklendirme etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",559]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل التلوين الأساسي\${normal_color}"
	arr["CHINESE",559]="\${blue_color}基本着色将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",560]="Basic colorization has been disabled"
	arr["SPANISH",560]="Se ha desactivado la colorización básica"
	arr["FRENCH",560]="Colorisation basique désactivée"
	arr["CATALAN",560]="S'ha desactivat la coloració bàsica"
	arr["PORTUGUESE",560]="As cores básicas foram desativas"
	arr["RUSSIAN",560]="Базовая раскраска отключена"
	arr["GREEK",560]="Ο βασικός χρωματισμός απενεργοποιήθηκε"
	arr["ITALIAN",560]="La colorazione basica è stata disattivata"
	arr["POLISH",560]="Podstawowe kolorowanie zostało wyłączone"
	arr["GERMAN",560]="Grundfärbung wurde deaktiviert"
	arr["TURKISH",560]="Temel renklendirme devre dışı bırakıldı"
	arr["ARABIC",560]="تم تعطيل التلوين الأساسي"
	arr["CHINESE",560]="基本着色已被禁用"

	arr["ENGLISH",561]="Basic colorization has been enabled"
	arr["SPANISH",561]="Se ha activado la colorización básica"
	arr["FRENCH",561]="Colorisation basique activée"
	arr["CATALAN",561]="S'ha activat la coloració bàsica"
	arr["PORTUGUESE",561]="As cores básicas foram ativas"
	arr["RUSSIAN",561]="Базовая раскраска включена"
	arr["GREEK",561]="Ο βασικός χρωματισμός ενεργοποιήθηκε"
	arr["ITALIAN",561]="La colorazione basica è stata attivata"
	arr["POLISH",561]="Podstawowe kolorowanie zostało wyłączone"
	arr["GERMAN",561]="Grundfärbung wurde aktiviert"
	arr["TURKISH",561]="Temel renklendirme etkinleştirildi"
	arr["ARABIC",561]="تم تفعيل التلوين الأساسي"
	arr["CHINESE",561]="基本着色已被启用"

	arr["ENGLISH",562]="This setting will have no effect until you enable basic colorization"
	arr["SPANISH",562]="Esta opción no tendrá efecto hasta que no habilites la colorización básica"
	arr["FRENCH",562]="Cette option n'aura effet jusqu'à vous activez la colorisation basique"
	arr["CATALAN",562]="Aquesta opció no tindrà efecte fins que no activis la coloració bàsica"
	arr["PORTUGUESE",562]="Esta opção não terá efeito até que você ative as cores básicas"
	arr["RUSSIAN",562]="Эта настройка не будет действовать, пока вы не включите базовую окраску"
	arr["GREEK",562]="Αυτή η επιλογή δεν θα τεθεί σε ισχύ μέχρι να ενεργοποιήσετε τον βασικό χρωματισμό"
	arr["ITALIAN",562]="Questa opzione non ha effetto finché non si attiva la colorazione basica"
	arr["POLISH",562]="Ta opcja nie będzię miała efektu, dopóki nie włączysz podstawowego kolorowania"
	arr["GERMAN",562]="Diese Option wird erst wirksam, wenn Sie die grundlegende Einfärbung aktivieren"
	arr["TURKISH",562]="Temel renklendirmeyi etkinleştirene kadar bu seçenek geçerli olmaz"
	arr["ARABIC",562]="لن يكون لهذا الإعداد أي تأثير حتى تقوم بتفعيل التلوين الأساسي"
	arr["CHINESE",562]="在您启用基本着色之前，此设置将无效"

	arr["ENGLISH",563]="Basic colorization: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",563]="Colorización básica: \${pink_color}Activada\${normal_color}"
	arr["FRENCH",563]="Colorisation de basique: \${pink_color}Activée\${normal_color}"
	arr["CATALAN",563]="Coloració bàsica: \${pink_color}Activada\${normal_color}"
	arr["PORTUGUESE",563]="Cores básicas: \${pink_color}Ativa\${normal_color}"
	arr["RUSSIAN",563]="Базовая раскраска: \${pink_color}Включена\${normal_color}"
	arr["GREEK",563]="Βασικός χρωματισμός: \${pink_color}Ενεργοποιημένος\${normal_color}"
	arr["ITALIAN",563]="Colorazione basica: \${pink_color}Attivata\${normal_color}"
	arr["POLISH",563]="Podstawowe kolorowanie: \${pink_color}Włączone\${normal_color}"
	arr["GERMAN",563]="Grundfärbung: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",563]="Temel renklendirme: \${pink_color}Etkin\${normal_color}"
	arr["ARABIC",563]="\${pink_color}مفعل\${blue_color} :التلوين الأساسي\${normal_color}"
	arr["CHINESE",563]="基本着色: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",564]="Basic colorization: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",564]="Colorización básica: \${pink_color}Desactivada\${normal_color}"
	arr["FRENCH",564]="Colorisation basique: \${pink_color}Désactivée\${normal_color}"
	arr["CATALAN",564]="Coloració bàsica: \${pink_color}Desactivada\${normal_color}"
	arr["PORTUGUESE",564]="Cores básicas: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",564]="Базовая раскраска: \${pink_color}Отключена\${normal_color}"
	arr["GREEK",564]="Βασικός χρωματισμός: \${pink_color}Απενεργοποιημένος\${normal_color}"
	arr["ITALIAN",564]="Colorazione basica: \${pink_color}Disattivata\${normal_color}"
	arr["POLISH",564]="Podstawowe kolorowanie: \${pink_color}Wyłączone\${normal_color}"
	arr["GERMAN",564]="Grundfärbung: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",564]="Temel renklendirme: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",564]="\${pink_color}معطل\${blue_color} :التلوين الأساسي\${normal_color}"
	arr["CHINESE",564]="基本着色: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",565]="3.  Disable skip intro permanently"
	arr["SPANISH",565]="3.  Deshabilitar permanentemente saltarse la intro"
	arr["FRENCH",565]="3.  Désactiver en permanence pour ignorer l'intro"
	arr["CATALAN",565]="3.  Deshabilitar permanentment ometre la intro"
	arr["PORTUGUESE",565]="3.  Ativar permanentemente a introdução"
	arr["RUSSIAN",565]="3.  Включить начальную заставку"
	arr["GREEK",565]="3.  Απενεργοποιήστε μόνιμα το εισαγωγικό μήνυμα"
	arr["ITALIAN",565]="3.  Disattiva permanentemente l'opzione skip intro"
	arr["POLISH",565]="3.  Trwale wyłącz pominięcie wprowadzenia"
	arr["GERMAN",565]="3.  Intro nicht überpsringen"
	arr["TURKISH",565]="3.  Giriş introsunu kalıcı olarak devredışı bırak"
	arr["ARABIC",565]="3.  تعطيل تخطي المقدمة بشكل دائم"
	arr["CHINESE",565]="3.  永久禁用跳过介绍"

	arr["ENGLISH",566]="3.  Enable skip intro permanently"
	arr["SPANISH",566]="3.  Habilitar permanentemente saltarse la intro"
	arr["FRENCH",566]="3.  Activer en permanence pour ignorer l'intro"
	arr["CATALAN",566]="3.  Habilitar permanentment ometre la intro"
	arr["PORTUGUESE",566]="3.  Desativar permanentemente a introdução"
	arr["RUSSIAN",566]="3.  Отключить начальную заставку"
	arr["GREEK",566]="3.  Ενεργοποιήστε μόνιμα το εισαγωγικό μήνυμα"
	arr["ITALIAN",566]="3.  Attivare permanentemente skip intro"
	arr["POLISH",566]="3.  Trwale włącz pominięcie wprowadzenia"
	arr["GERMAN",566]="3.  Intro überspringen"
	arr["TURKISH",566]="3.  Giriş introsunu kalıcı olarak etkinleştir"
	arr["ARABIC",566]="3.  تفعيل تخطي المقدمة بشكل دائم"
	arr["CHINESE",566]="3.  永久启用跳过介绍"

	arr["ENGLISH",567]="Skip intro: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",567]="Saltarse la intro: \${pink_color}Activado\${normal_color}"
	arr["FRENCH",567]="Ignorer l'intro: \${pink_color}Activée\${normal_color}"
	arr["CATALAN",567]="Ometre la introducció: \${pink_color}Activat\${normal_color}"
	arr["PORTUGUESE",567]="Introdução: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",567]="Пропустить начальную заставку: \${pink_color}Включено\${normal_color}"
	arr["GREEK",567]="Παράλειψη εισαγωγικού μηνύματος: \${pink_color}Ενεργοποιημένη\${normal_color}"
	arr["ITALIAN",567]="Skip intro: \${pink_color}Attivato\${normal_color}"
	arr["POLISH",567]="Pomiń wprowadzenie: \${pink_color}Aktywowane\${normal_color}"
	arr["GERMAN",567]="Intro überspringen: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",567]="Giriş introsunu geç: \${pink_color}Aktif\${normal_color}"
	arr["ARABIC",567]="\${pink_color}مفعل\${blue_color} :تخطي المقدمة\${normal_color}"
	arr["CHINESE",567]="跳过介绍: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",568]="Skip intro: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",568]="Saltarse la intro: \${pink_color}Desactivado\${normal_color}"
	arr["FRENCH",568]="Ignorer l'intro: \${pink_color}Désactivé\${normal_color}"
	arr["CATALAN",568]="Ometre la introducció: \${pink_color}Desactivat\${normal_color}"
	arr["PORTUGUESE",568]="Introdução: \${pink_color}Ativa\${normal_color}"
	arr["RUSSIAN",568]="Пропустить начальную заставку: \${pink_color}Выключено\${normal_color}"
	arr["GREEK",568]="Παράλειψη εισαγωγικού μηνύματος: \${pink_color}Απενεργοποιημένη\${normal_color}"
	arr["ITALIAN",568]="Skip intro: \${pink_color}Disattivato\${normal_color}"
	arr["POLISH",568]="Pomiń wprowadzenie: \${pink_color}Dezaktywowane\${normal_color}"
	arr["GERMAN",568]="Intro überspringen: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",568]="Giriş introsunu geç: \${pink_color}DeveDışı\${normal_color}"
	arr["ARABIC",568]="\${pink_color}معطل\${blue_color} :تخطي المقدمة\${normal_color}"
	arr["CHINESE",568]="跳过介绍: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",569]="\${blue_color}Skip intro is going to be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",569]="\${blue_color}Se va a desactivar saltarse la intro. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",569]="\${blue_color}L'intro va êtredesactivée. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",569]="\${blue_color}Es va a desactivar ometre la intro. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",569]="\${blue_color}A introdução será ativada. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",569]="\${blue_color}Будет отключён пропуск начальной заставки. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",569]="\${blue_color}Η παράλειψη του εισαγωγικού μηνύματος προκειται να απενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",569]="\${blue_color}Skip intro verrà disattivato. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",569]="\${blue_color}Pomijanie wprowadzenia zostanie wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",569]="\${blue_color}Die Intro wird nicht überprungen werden. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",569]="İntroyu geçme devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",569]="\${normal_color}\${visual_choice} \${green_color}هل تريد المتابعة؟\${blue_color} .سيتم تعطيل تخطي المقدمة\${normal_color}"
	arr["CHINESE",569]="\${blue_color}跳过介绍将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",570]="\${blue_color}Skip intro is going to be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",570]="\${blue_color}Se va a activar saltarse la intro. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",570]="\${blue_color}Il s'activera pour ignorer l'intro. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",570]="\${blue_color}Es va a activar ometre la intro. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",570]="\${blue_color}A introdução será desativa. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",570]="\${blue_color}Будет включён пропуск начальной заставки. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",570]="\${blue_color}Πρόκειται να ενεργοποιηθεί η παράλειψη του εισαγωγικού μηνύματος. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",570]="\${blue_color}Skip intro verrà attivato. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",570]="\${blue_color}Pomijanie wprowadzenia zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",570]="\${blue_color}Die Intro wird übersprungen werden. \${green_color} Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",570]="\${blue_color}İntroyu geçme etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",570]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل تخطي المقدمة"
	arr["CHINESE",570]="\${blue_color}跳过介绍将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",571]="Skip intro has been disabled"
	arr["SPANISH",571]="Se ha desactivado saltarse la intro"
	arr["FRENCH",571]="Ignorer l'intro a été désactivé"
	arr["CATALAN",571]="S'ha desactivat ometre la introducció"
	arr["PORTUGUESE",571]="A introdução foi ativada"
	arr["RUSSIAN",571]="Пропуск начальной заставки отключён"
	arr["GREEK",571]="Η παράλειψη του εισαγωγικού μηνύματος απενεργοποιήθηκε"
	arr["ITALIAN",571]="Skip intro è stato disattivato"
	arr["POLISH",571]="Pominięcie wprowadzenia zostało wyłączone"
	arr["GERMAN",571]="Intro überspringen wurde deaktiviert"
	arr["TURKISH",571]="İntroyu geçme devre dışı bırakıldı"
	arr["ARABIC",571]="سيتم تعطيل تخطي المقدمة"
	arr["CHINESE",571]="跳过介绍已被禁用"

	arr["ENGLISH",572]="Skip intro has been enabled"
	arr["SPANISH",572]="Se ha activado saltarse la intro"
	arr["FRENCH",572]="Ignorer l'intro a été activé"
	arr["CATALAN",572]="S'ha activat ometre la introducció"
	arr["PORTUGUESE",572]="A introdução de foi desativa"
	arr["RUSSIAN",572]="Пропуск начальной заставки включён"
	arr["GREEK",572]="Η παράλειψη του εισαγωγικού μηνύματος ενεργοποιήθηκε"
	arr["ITALIAN",572]="Skip intro è stato attivato"
	arr["POLISH",572]="Pominięcie wprowadzenia zostało włączone"
	arr["GERMAN",572]="Intro überspringen wurde aktiviert"
	arr["TURKISH",572]="İntroyu geçme etkinleştirildi"
	arr["ARABIC",572]="تم تفعيل تخطي المقدمة"
	arr["CHINESE",572]="跳过介绍已被启用"

	arr["ENGLISH",573]="7.  Disable silent checks permanently"
	arr["SPANISH",573]="7.  Deshabilitar permanentemente chequeos silenciosos"
	arr["FRENCH",573]="7.  Désactiver en permanence contrôles silencieux"
	arr["CATALAN",573]="7.  Deshabilitar permanentment revisions silencioses"
	arr["PORTUGUESE",573]="7.  Desativar permanentemente a verificação silenciosa"
	arr["RUSSIAN",573]="7.  Отключить тихие проверки"
	arr["GREEK",573]="7.  Απενεργοποιήστε μόνιμα τα silent checks"
	arr["ITALIAN",573]="7.  Disattivare permanentemente i controlli silenziosi"
	arr["POLISH",573]="7.  Trwale wyłącz ciche sprawdzanie"
	arr["GERMAN",573]="7.  Deaktivieren Sie die stillen Überprüfungen dauerhaft"
	arr["TURKISH",573]="7.  Sessiz kontrolleri kalıcı olarak devre dışı bırak"
	arr["ARABIC",573]="7.  تعطيل الضوابط الصامتة بشكل دائم"
	arr["CHINESE",573]="7.  永久禁用软件包静默检查"

	arr["ENGLISH",574]="7.  Enable silent checks permanently"
	arr["SPANISH",574]="7.  Habilitar permanentemente chequeos silenciosos"
	arr["FRENCH",574]="7.  Activer en permanence contrôles silencieux"
	arr["CATALAN",574]="7.  Habilitar permanentment revisions silencioses"
	arr["PORTUGUESE",574]="7.  Ativar permanentemente a verificação silenciosa"
	arr["RUSSIAN",574]="7.  Включить тихие проверки"
	arr["GREEK",574]="7.  Ενεργοποιήστε μόνιμα τα silent checks"
	arr["ITALIAN",574]="7.  Abilitare permanentemente i controlli silenziosi"
	arr["POLISH",574]="7.  Trwale włącz ciche sprawdzanie"
	arr["GERMAN",574]="7.  Stille Prüfungen dauerhaft aktivieren"
	arr["TURKISH",574]="7.  Sessiz kontrolleri kalıcı olarak etkinleştir"
	arr["ARABIC",574]="7.  تفعيل الضوابط الصامتة بشكل دائم"
	arr["CHINESE",574]="7.  永久启用软件包静默检查"

	arr["ENGLISH",575]="Silent checks: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",575]="Chequeos silenciosos: \${pink_color}Activados\${normal_color}"
	arr["FRENCH",575]="Contrôles silencieux: \${pink_color}Activé\${normal_color}"
	arr["CATALAN",575]="Revisions silencioses: \${pink_color}Activades\${normal_color}"
	arr["PORTUGUESE",575]="Verificação silenciosa: \${pink_color}Ativa\${normal_color}"
	arr["RUSSIAN",575]="Тихие проверки: \${pink_color}Включены\${normal_color}"
	arr["GREEK",575]="Silent checks: \${pink_color}Ενεργοποιημένα\${normal_color}"
	arr["ITALIAN",575]="Controlli silenziosi: \${pink_color}Attivati\${normal_color}"
	arr["POLISH",575]="Ciche sprawdzanie: \${pink_color}Aktywowane\${normal_color}"
	arr["GERMAN",575]="Stille Überprüfungen: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",575]="Sessiz kontroller: \${pink_color}Etkin\${normal_color}"
	arr["ARABIC",575]="\${pink_color}مفعل\${blue_color} :الضوابط الصامتة\${normal_color}"
	arr["CHINESE",575]="软件包静默检查: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",576]="Silent checks: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",576]="Chequeos silenciosos: \${pink_color}Desactivados\${normal_color}"
	arr["FRENCH",576]="Contrôles silencieux: \${pink_color}Désactivé\${normal_color}"
	arr["CATALAN",576]="Revisions silencioses: \${pink_color}Desactivades\${normal_color}"
	arr["PORTUGUESE",576]="Verificação silenciosa: \${pink_color}Desativa\${normal_color}"
	arr["RUSSIAN",576]="Тихие проверки: \${pink_color}Отключены\${normal_color}"
	arr["GREEK",576]="Silent checks: \${pink_color}Απενεργοποιημένα\${normal_color}"
	arr["ITALIAN",576]="Controlli silenziosi: \${pink_color}Disattivati\${normal_color}"
	arr["POLISH",576]="Ciche sprawdzanie: \${pink_color}Wyłączone\${normal_color}"
	arr["GERMAN",576]="Stille Überprüfungen: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",576]="Sessiz kontroller: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",576]="\${pink_color}معطلة\${blue_color} :الضوابط الصامتة\${normal_color}"
	arr["CHINESE",576]="软件包静默检查: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",577]="\${blue_color}Silent checks will be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",577]="\${blue_color}Se van a deshabilitar los chequeos silenciosos. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",577]="\${blue_color}Les contrôles silencieux seront désactivés. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",577]="\${blue_color}Es van a desactivar les revisions silencioses. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",577]="\${blue_color}A verificação silenciosa será desativa. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",577]="\${blue_color}Тихие проверки будут отключены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",577]="\${blue_color}Τα silent checks θα απενεργοποιηθούν. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",577]="\${blue_color}I controlli silenziosi saranno disattivati \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",577]="\${blue_color}Ciche sprawdzanie zostanie wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",577]="\${blue_color}Stille Überprüfungen werden deaktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",577]="Sessiz kontroller devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",577]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تعطيل الضوابط الصامتة\${normal_color}"
	arr["CHINESE",577]="软件包静默检查将被禁用。\${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",578]="\${blue_color}Silent checks will be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",578]="\${blue_color}Se van a habilitar los chequeos silenciosos. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",578]="\${blue_color}Les contrôles silencieux seront activés. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",578]="\${blue_color}Es van a habilitar les revisions silencioses. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",578]="\${blue_color}A verificação silenciosa será ativa. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",578]="\${blue_color}Тихие проверки будут включены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",578]="\${blue_color}Τα silent checks θα ενεργοποιηθούν. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",578]="\${blue_color}I controlli silenziosi saranno attivati \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",578]="\${blue_color}Ciche sprawdzanie zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",578]="\${blue_color}Stille Überprüfungen werden aktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",578]="Sessiz kontroller etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",578]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل الضوابط الصامتة\${normal_color}"
	arr["CHINESE",578]="\${blue_color}软件包静默检查将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",579]="Silent checks has been disabled"
	arr["SPANISH",579]="Se han desactivado los chequeos silenciosos"
	arr["FRENCH",579]="Les contrôles silencieux ont été désactivés"
	arr["CATALAN",579]="S'han desactivat les revisions silencioses"
	arr["PORTUGUESE",579]="A verificação silenciosa foi desativa"
	arr["RUSSIAN",579]="Тихие проверки отключены"
	arr["GREEK",579]="Τα silent checks έχουν απενεργοποιηθεί"
	arr["ITALIAN",579]="I controlli silenziosi sono stati disattivati"
	arr["POLISH",579]="Ciche sprawdzanie zostało wyłączone"
	arr["GERMAN",579]="Stille Überprüfungen wurden deaktiviert"
	arr["TURKISH",579]="Sessiz kontroller devre dışı bırakıldı"
	arr["ARABIC",579]="تم تعطيل الضوابط الصامتة"
	arr["CHINESE",579]="软件包静默检查已被禁用"

	arr["ENGLISH",580]="Silent checks has been enabled"
	arr["SPANISH",580]="Se han activado los chequeos silenciosos"
	arr["FRENCH",580]="Les contrôles silencieux ont été activés"
	arr["CATALAN",580]="S'han activat les revisions silencioses"
	arr["PORTUGUESE",580]="A verificação silenciosa foi ativa"
	arr["RUSSIAN",580]="Тихие проверки активированы"
	arr["GREEK",580]="Τα silent checks έχουν ενεργοποιηθεί"
	arr["ITALIAN",580]="I controlli silenziosi sono stati attivati"
	arr["POLISH",580]="Ciche sprawdzanie zostało włączone"
	arr["GERMAN",580]="Stille Überprüfungen wurden aktiviert"
	arr["TURKISH",580]="Sessiz kontroller etkinleştirildi"
	arr["ARABIC",580]="تم تفعيل الضوابط الصامتة"
	arr["CHINESE",580]="软件包静默检查已启用"

	arr["ENGLISH",581]="You launched airgedddon with silent checks enabled. Disable that setting in order to see what is the problem"
	arr["SPANISH",581]="Lanzaste airgeddon con los chequeos silenciosos activados. Deshabilita esa opción para ver cual es el problema"
	arr["FRENCH",581]="Vous avez lancé airgeddon avec les contrôles silencieux activés. Désactiver cette option pour voir quel est le problème"
	arr["CATALAN",581]="Vas llançar airgeddon amb les revisions silencioses activades. Deshabilita aquesta opció per veure quin és el problema"
	arr["PORTUGUESE",581]="Você executou o airgeddon com a verificação silenciosa ativa. Desative essa opção para ver qual é o problema"
	arr["RUSSIAN",581]="Вы запустили airgeddon с включенными тихими проверками. Отключите этот параметр, чтобы узнать, в чем проблема"
	arr["GREEK",581]="Ξεκινήσατε το airgeddon με ενεργοποιημένα τα silent checks. Απενεργοποιήστε αυτήν την επιλογή για να δείτε ποιό είναι ακρίβώς το πρόβλημα"
	arr["ITALIAN",581]="Hai lanciato airgeddon con i controlli silenziosi attivati. Disabilita questa opzione per vedere qual'è il problema"
	arr["POLISH",581]="Uruchomiłeś airgeddon z włączonym cichym sprawdzaniem. Wyłącz tę opcję, aby zobaczyć w czym jest problem"
	arr["GERMAN",581]="Sie haben airgeddon mit aktivierten Silent-Checks gestartet. Deaktivieren Sie diese Option, um das Problem zu sehen"
	arr["TURKISH",581]="Etkinleştirilmiş sessiz kontrollerle airgeddon'u başlattın. Sorunun ne olduğunu görmek için bu seçeneği devre dışı bırak"
	arr["ARABIC",581]="مع تفعيل الضوابط الصامتة. قم بتعطيل الإعداد لمعرفة ما هي المشكلة airgeddon تقوم بتشغيل"
	arr["CHINESE",581]="您在启用软件包静默检查的情况下启动了 airgedddon，但 airgedddon 发现所需要的软件包没有全部安装。禁用该设置以查看问题所在"

	arr["ENGLISH",582]="Print hints: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",582]="Mostrar consejos: \${pink_color}Activado\${normal_color}"
	arr["FRENCH",582]="Montrer des conseils: \${pink_color}Activé\${normal_color}"
	arr["CATALAN",582]="Mostra consells: \${pink_color}Activat\${normal_color}"
	arr["PORTUGUESE",582]="Mostrar conselhos: \${pink_color}Ativo\${normal_color}"
	arr["RUSSIAN",582]="Показать подсказки: \${pink_color}Включено\${normal_color}"
	arr["GREEK",582]="Εμφάνιση συμβουλών: \${pink_color}Ενεργοποιημένη\${normal_color}"
	arr["ITALIAN",582]="Mostra Consigli: \${pink_color}Attivato\${normal_color}"
	arr["POLISH",582]="Pokaż wskazówki: \${pink_color}Włączone\${normal_color}"
	arr["GERMAN",582]="Tipps anzeigen: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",582]="İpuçlarını göster: \${pink_color}Aktif\${normal_color}"
	arr["ARABIC",582]="\${pink_color}مفعل\${blue_color} :مشاهدة التلميحات\${normal_color}"
	arr["CHINESE",582]="打印提示: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",583]="Print hints: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",583]="Mostrar consejos: \${pink_color}Desactivados\${normal_color}"
	arr["FRENCH",583]="Montrer des Conseils: \${pink_color}Désactivé\${normal_color}"
	arr["CATALAN",583]="Mostra consells: \${pink_color}Desactivat\${normal_color}"
	arr["PORTUGUESE",583]="Mostrar conselhos: \${pink_color}Desativo\${normal_color}"
	arr["RUSSIAN",583]="Показать подсказки: \${pink_color}Отключено\${normal_color}"
	arr["GREEK",583]="Εμφάνιση συμβουλών: \${pink_color}Απενεργοποιημένη\${normal_color}"
	arr["ITALIAN",583]="Mostra Consigli: \${pink_color}Disattivato\${normal_color}"
	arr["POLISH",583]="Pokaż wskazówki: \${pink_color}Wyłączone\${normal_color}"
	arr["GERMAN",583]="Tipps anzeigen: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",583]="İpuçlarını göster: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",583]="\${pink_color}معطل\${blue_color} :مشاهدة التلميحات\${normal_color}"
	arr["CHINESE",583]="打印提示: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",584]="8.  Disable print hints permanently"
	arr["SPANISH",584]="8.  Deshabilitar mostrar consejos permanentemente"
	arr["FRENCH",584]="8.  Désactiver montrer des conseils en permanence"
	arr["CATALAN",584]="8.  Deshabilitar mostrar consells permanentment"
	arr["PORTUGUESE",584]="8.  Desativar permanentemente as dicas e conselhos"
	arr["RUSSIAN",584]="8.  Отключить показ советов"
	arr["GREEK",584]="8.  Απενεργοποιήστε μόνιμα την εμφάνιση συμβουλών"
	arr["ITALIAN",584]="8.  Disattivare mostrare i suggerimenti in modo permanente"
	arr["POLISH",584]="8.  Wyłącz wyświetlanie wskazówek na stałe"
	arr["GERMAN",584]="8.  Tipps anzeigen dauerhaft deaktivieren"
	arr["TURKISH",584]="8.  Gösteri ipuçlarını kalıcı olarak devre dışı bırak"
	arr["ARABIC",584]="8.  تعطيل إظهار التلميحات بشكل دائم"
	arr["CHINESE",584]="8.  永久禁用打印提示"

	arr["ENGLISH",585]="8.  Enable print hints permanently"
	arr["SPANISH",585]="8.  Habilitar mostrar consejos permanentemente"
	arr["FRENCH",585]="8.  Activer pour Montrer des conseils en permanence"
	arr["CATALAN",585]="8.  Habilitar mostrar consells permanentment"
	arr["PORTUGUESE",585]="8.  Ativar permanentemente as dicas e conselhos"
	arr["RUSSIAN",585]="8.  Включить подсказки"
	arr["GREEK",585]="8.  Ενεργοποιήστε μόνιμα την εμφάνιση συμβουλών"
	arr["ITALIAN",585]="8.  Attivare mostrare i consigli in modo permanente"
	arr["POLISH",585]="8.  Włącz wyświetlanie wskazówek na stałe"
	arr["GERMAN",585]="8.  Aktivieren Sie diese Option, um Tipps anzuzeigen"
	arr["TURKISH",585]="8.  İpuçlarını kalıcı olarak etkinleştir"
	arr["ARABIC",585]="8.  تفعيل إظهار التلميحات بشكل دائم"
	arr["CHINESE",585]="8.  永久启用打印提示"

	arr["ENGLISH",586]="\${blue_color}Print hints will be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",586]="\${blue_color}Se va a deshabilitar mostrar consejos. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",586]="\${blue_color}Montrer des conseils va êtredésactivé. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",586]="\${blue_color}Es va a desactivar mostrar consells. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",586]="\${blue_color}Os conselhos e as dicas serão desabilitados. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",586]="\${blue_color}Подсказки будут отключены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",586]="\${blue_color}Πρόκειται να απενεργοποιηθεί η εμφάνιση συμβουλών. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",586]="\${blue_color}Disattiva i consigli sullo spettacolo \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",586]="\${blue_color}Spowoduje to wyłączenie wyświetlania wskazówek. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",586]="\${blue_color}Der Show-Hinweis wird deaktiviert. \${green_color}Wollen Sie weitermachen? \${normal_color}\${visual_choice}"
	arr["TURKISH",586]="\${blue_color}İpuları devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",586]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تعطيل إظهار التلميحات\${normal_color}"
	arr["CHINESE",586]="\${blue_color}打印提示将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",587]="\${blue_color}Print hints will be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",587]="\${blue_color}Se va a habilitar mostrar consejos. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",587]="\${blue_color}Montrer des conseils va êtreactivé. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",587]="\${blue_color}Es va a habilitar mostrar consells. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",587]="\${blue_color}Os conselhos e as dicas serão habilitados. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",587]="\${blue_color}Подсказки будут включены. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",587]="\${blue_color}Πρόκειται να ενεργοποιηθεί η εμφάνιση συμβουλών. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",587]="\${blue_color}Mostrare i suggerimenti sará attivato \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",587]="\${blue_color}Wyświetlanie wskazówek zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",587]="\${blue_color}Tipps werden angezeigt. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",587]="\${blue_color}İpuçları etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",587]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل إظهار التلميحات\${normal_color}"
	arr["CHINESE",587]="\${blue_color}打印提示将被启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",588]="Print hints has been disabled"
	arr["SPANISH",588]="Se ha desactivado mostrar consejos"
	arr["FRENCH",588]="Montrer des conseils a été désactivés"
	arr["CATALAN",588]="S'ha desactivat mostrar consells"
	arr["PORTUGUESE",588]="Os conselhos e as dicas foram desativados"
	arr["RUSSIAN",588]="Подсказки отключены"
	arr["GREEK",588]="Η εμφάνιση συμβουλών απενεργοποιήθηκε"
	arr["ITALIAN",588]="Mostrare i suggerimenti è stato disattivato"
	arr["POLISH",588]="Wyświetlanie wskazówek zostało wyłączone"
	arr["GERMAN",588]="Hinweise wurden deaktiviert"
	arr["TURKISH",588]="İpuçları devre dışı bırakıldı"
	arr["ARABIC",588]="تم تعطيل إظهار التلميحات"
	arr["CHINESE",588]="打印提示已被禁用"

	arr["ENGLISH",589]="Print hints has been enabled"
	arr["SPANISH",589]="Se ha activado mostrar consejos"
	arr["FRENCH",589]="Montrer des conseils a été activé"
	arr["CATALAN",589]="S'ha activat mostrar consells"
	arr["PORTUGUESE",589]="Os conselhos e as dicas foram ativados"
	arr["RUSSIAN",589]="Подсказки включены"
	arr["GREEK",589]="Η εμφάνιση συμβουλών ενεργοποιήθηκε"
	arr["ITALIAN",589]="Mostrare i suggerimenti è stato attivato"
	arr["POLISH",589]="Wyświetlanie wskazówek zostało włączone"
	arr["GERMAN",589]="Hinweise wurden aktiviert"
	arr["TURKISH",589]="İpuçları etkinleştirildi"
	arr["ARABIC",589]="تم تفعيل إظهار التلميحات"
	arr["CHINESE",589]="打印提示已启用"

	arr["ENGLISH",590]="You can modify manually \${rc_path} file to change some options. You can also launch \"flags\" on the command line. More info at: \${normal_color}\${urlgithub_wiki}/Options"
	arr["SPANISH",590]="Puedes modificar manualmente el fichero \${rc_path} para modificar sus opciones. También puedes lanzar \"flags\" en la línea de comandos. Más información en: \${normal_color}\${urlgithub_wiki}/Options"
	arr["FRENCH",590]="Vous pouvez modifier manuellement le fichier \${rc_path} pour modifier ses options. Vous pouvez également écrire \"flags\" sur la ligne de commande. Plus d'information sur: \${normal_color}\${urlgithub_wiki}/Options"
	arr["CATALAN",590]="Pots modificar manualment el fitxer \${rc_path} per modificar les seves opcions. També pots llançar \"flags\" a la línia d'ordres. Més informació a: \${normal_color}\${urlgithub_wiki}/Options"
	arr["PORTUGUESE",590]="Você pode modificar manualmente o arquivo \${rc_path} para alterar suas opções ou usar argumentos ao executar airgeddon na linha de comando. Mais informações em: \${normal_color}\${urlgithub_wiki}/Options"
	arr["RUSSIAN",590]="Вы можете вручную изменить файл \${rc_path}, чтобы изменить его опции. Вы также можете указать \"flags\" в командной строке. Дополнительная информация об опциях: \${normal_color}\${urlgithub_wiki}/Options"
	arr["GREEK",590]="Μπορείτε να τροποποιήσετε χειροκίνητα το αρχείο \${rc_path} για να αλλάξετε τις επιλογές του. Μπορείτε επίσης να βάλετε \"flags\" στη γραμμή εντολών. Περισσότερες πληροφορίες στο: \${normal_color}\${urlgithub_wiki}/Options"
	arr["ITALIAN",590]="Puoi modificare manualmente il file \${rc_path} per modificarne le opzioni. Puoi anche lanciare \"flags\" sulla linea di comando. Maggiori informazioni su: \${normal_color}\${urlgithub_wiki}/Options"
	arr["POLISH",590]="Możesz ręcznie zmodyfikować plik \${rc_path} aby zmienić pewne opcje. Możesz także wpisać \"flags\" w linii poleceń. Więcej informacji: \${normal_color}\${urlgithub_wiki}/Options"
	arr["GERMAN",590]="Sie können die Datei \${rc_path}, manuell ändern, um die Optionen zu ändern. Sie können auch \"flags\" in die Befehlszeile werfen. Weitere Informationen dazu: \${normal_color}\${urlgithub_wiki}/Options"
	arr["TURKISH",590]="Seçenekleri değiştirmek için \${rc_path} dosyasını elle değiştirebilirsiniz. Komut satırında \"flags\" de ekleyebilirsiniz. Hakkında daha fazla bilgi: \${normal_color}\${urlgithub_wiki}/Options"
	arr["ARABIC",590]="\${normal_color}\${urlgithub_wiki}/Options \${pink_color}:في سطر الأوامر. مزيد من المعلومات على \"flags\" يدويًا لتغيير بعض الخيارات. يمكنك أيضًا تشغيل \${rc_path} يمكنك تعديل ملف\${normal_color}"
	arr["CHINESE",590]="您可以手动修改位于 \${rc_path} 的文件来更改一些选项。您还可以在命令行上启动 \"flags\"。更多信息请移步至: \${normal_color}\${urlgithub_wiki}/Options 查看。"

	arr["ENGLISH",591]="Changing these options \${rc_path} is modified as well and the changes are permanent"
	arr["SPANISH",591]="Cambiando estas opciones modificas el fichero \${rc_path} y los cambios son permanentes"
	arr["FRENCH",591]="La modification de ces options modifie le fichier \${rc_path} et les modifications sont permanentes"
	arr["CATALAN",591]="Canviant aquestes opcions modifiqueu el fitxer \${rc_path} i els canvis són permanents"
	arr["PORTUGUESE",591]="As modificações no arquivo \${rc_path} são permanentes"
	arr["RUSSIAN",591]="Изменение этих параметров меняет файл \${rc_path}, и эти настройки становятся постоянными"
	arr["GREEK",591]="Η αλλαγή αυτών των ρυθμίσεων τροποποιεί το αρχείο \${rc_path} και οι αλλαγές είναι μόνιμες"
	arr["ITALIAN",591]="La modifica di queste opzioni modifica il file \${rc_path} e le modifiche sono permanenti"
	arr["POLISH",591]="Zmiana tych opcji modyfikuje również plik \${rc_path}, a zmiany są trwałe"
	arr["GERMAN",591]="Durch das Ändern dieser Optionen wird die Datei \${rc_path} geändert, und die Änderungen sind dauerhaft"
	arr["TURKISH",591]="Bu seçenekleri değiştirmek, \${rc_path} dosyasını değiştirir ve değişiklikler kalıcıdır"
	arr["ARABIC",591]="تم تعديله أيضًا والتغييرات دائمة \${rc_path} تغيير هذه الخيارات"
	arr["CHINESE",591]="更改这些选项后，配置文件 \${rc_path} 也会被自动同步修改并保存"

	arr["ENGLISH",592]="9.  Disable 5Ghz permanently"
	arr["SPANISH",592]="9.  Deshabilitar 5Ghz permanentemente"
	arr["FRENCH",592]="9.  Désactiver 5Ghz en permanence"
	arr["CATALAN",592]="9.  Deshabilitar 5Ghz permanentment"
	arr["PORTUGUESE",592]="9.  Desativar permanentemente a banda de 5Ghz"
	arr["RUSSIAN",592]="9.  Отключить 5Ghz, в том числе для последующих запусков"
	arr["GREEK",592]="9.  Απενεργοποιήστε μόνιμα το 5Ghz"
	arr["ITALIAN",592]="9.  Disattivare permanentemente 5Ghz"
	arr["POLISH",592]="9.  Wyłącz na stałe 5Ghz"
	arr["GERMAN",592]="9.  5Ghz dauerhaft deaktivieren"
	arr["TURKISH",592]="9.  5Ghz'i kalıcı olarak devre dışı bırak"
	arr["ARABIC",592]="9.  تعطيل 5 جيجا هرتزبشكل دائم"
	arr["CHINESE",592]="9.  永久禁用 5Ghz"

	arr["ENGLISH",593]="9.  Enable 5Ghz permanently"
	arr["SPANISH",593]="9.  Habilitar 5Ghz permanentemente"
	arr["FRENCH",593]="9.  Activer 5Ghz en permanence"
	arr["CATALAN",593]="9.  Habilitar 5Ghz permanentment"
	arr["PORTUGUESE",593]="9.  Ativar permanentemente a banda de 5Ghz"
	arr["RUSSIAN",593]="9. Включить 5Ghz, в том числе для последующих запусков"
	arr["GREEK",593]="9.  Ενεργοποιήστε μόνιμα το 5Ghz"
	arr["ITALIAN",593]="9.  Attivare 5Ghz permanentemente"
	arr["POLISH",593]="9.  Włącz na stałe 5Ghz"
	arr["GERMAN",593]="9.  5Ghz dauerhaft aktivieren"
	arr["TURKISH",593]="9.  5Ghz'i kalıcı olarak etkinleştir"
	arr["ARABIC",593]="9.  تفعيل 5 جيجا هرتزبشكل دائم"
	arr["CHINESE",593]="9.  永久启用 5Ghz"

	arr["ENGLISH",594]="5Ghz: \${pink_color}Enabled\${normal_color}"
	arr["SPANISH",594]="5Ghz: \${pink_color}Activado\${normal_color}"
	arr["FRENCH",594]="5Ghz: \${pink_color}Activée\${normal_color}"
	arr["CATALAN",594]="5Ghz: \${pink_color}Activat\${normal_color}"
	arr["PORTUGUESE",594]="5Ghz: \${pink_color}Ativo\${normal_color}"
	arr["RUSSIAN",594]="5Ghz: \${pink_color}Включено\${normal_color}"
	arr["GREEK",594]="5Ghz: \${pink_color}Ενεργοποιημένο\${normal_color}"
	arr["ITALIAN",594]="5Ghz: \${pink_color}Attivato\${normal_color}"
	arr["POLISH",594]="5Ghz: \${pink_color}Włączony\${normal_color}"
	arr["GERMAN",594]="5Ghz: \${pink_color}Aktiviert\${normal_color}"
	arr["TURKISH",594]="5Ghz: \${pink_color}Aktif\${normal_color}"
	arr["ARABIC",594]="\${pink_color}مفعل\${blue_color} :5Ghz\${normal_color}"
	arr["CHINESE",594]="5Ghz: \${pink_color}启用\${normal_color}"

	arr["ENGLISH",595]="5Ghz: \${pink_color}Disabled\${normal_color}"
	arr["SPANISH",595]="5Ghz: \${pink_color}Desactivado\${normal_color}"
	arr["FRENCH",595]="5Ghz: \${pink_color}Désactivée\${normal_color}"
	arr["CATALAN",595]="5Ghz: \${pink_color}Desactivat\${normal_color}"
	arr["PORTUGUESE",595]="5Ghz: \${pink_color}Desativo\${normal_color}"
	arr["RUSSIAN",595]="5Ghz: \${pink_color}Отключено\${normal_color}"
	arr["GREEK",595]="5Ghz: \${pink_color}Απενεργοποιημένο\${normal_color}"
	arr["ITALIAN",595]="5Ghz: \${pink_color}Disattivato\${normal_color}"
	arr["POLISH",595]="5Ghz: \${pink_color}Dezaktywowane\${normal_color}"
	arr["GERMAN",595]="5Ghz: \${pink_color}Deaktiviert\${normal_color}"
	arr["TURKISH",595]="5Ghz: \${pink_color}DevreDışı\${normal_color}"
	arr["ARABIC",595]="\${pink_color}معطل\${blue_color} :5Ghz\${normal_color}"
	arr["CHINESE",595]="5Ghz: \${pink_color}禁用\${normal_color}"

	arr["ENGLISH",596]="\${blue_color}5Ghz will be disabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",596]="\${blue_color}Se va a deshabilitar 5Ghz. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",596]="\${blue_color}On va désactiver 5Ghz. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",596]="\${blue_color}Es va a desactivar 5Ghz. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",596]="\${blue_color}Isso desabilitará a banda de 5Ghz. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",596]="\${blue_color}5Ghz будет отключено. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",596]="\${blue_color}Το 5Ghz πρόκειται να απενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",596]="\${blue_color}5Ghz verrà disattivato. \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",596]="\${blue_color}5Ghz zostanie wyłączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",596]="\${blue_color}5Ghz wird deaktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",596]="\${blue_color}5Ghz devre dışı bırakılacak. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",596]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تعطيل 5 جيجا هرتز\${normal_color}"
	arr["CHINESE",596]="\${blue_color}5Ghz 将被禁用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",597]="\${blue_color}5Ghz will be enabled. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",597]="\${blue_color}Se va a habilitar 5Ghz. \${green_color}¿Deseas continuar? \${normal_color}\${visual_choice}"
	arr["FRENCH",597]="\${blue_color}On va permettre 5Ghz. \${green_color}Voulez-vous continuer? \${normal_color}\${visual_choice}"
	arr["CATALAN",597]="\${blue_color}Es va a habilitar 5Ghz. \${green_color}¿Vols continuar? \${normal_color}\${visual_choice}"
	arr["PORTUGUESE",597]="\${blue_color}Isso habilitará a banda de 5Ghz. \${green_color}Você deseja continuar? \${normal_color}\${visual_choice}"
	arr["RUSSIAN",597]="\${blue_color}5Ghz будет включено. \${green_color}Вы хотите продолжить? \${normal_color}\${visual_choice}"
	arr["GREEK",597]="\${blue_color}Το 5Ghz πρόκειται να ενεργοποιηθεί. \${green_color}Θέλετε να συνεχίσετε; \${normal_color}\${visual_choice}"
	arr["ITALIAN",597]="\${blue_color}5Ghz verrà attivato \${green_color}Vuoi continuare? \${normal_color}\${visual_choice}"
	arr["POLISH",597]="\${blue_color}5Ghz zostanie włączone. \${green_color}Czy chcesz kontynuować? \${normal_color}\${visual_choice}"
	arr["GERMAN",597]="\${blue_color}5Ghz wird aktiviert. \${green_color}Möchten Sie fortfahren? \${normal_color}\${visual_choice}"
	arr["TURKISH",597]="\${blue_color}5Ghz etkinleştirilecek. \${green_color}Devam etmek istiyor musunuz? \${normal_color}\${visual_choice}"
	arr["ARABIC",597]="\${normal_color}\${visual_choice}\${green_color} هل تريد المتابعة؟\${blue_color} .سيتم تفعيل 5 جيجا هرتز\${normal_color}"
	arr["CHINESE",597]="\${blue_color}5Ghz 将启用。 \${green_color}你想继续吗？\${normal_color}\${visual_choice}"

	arr["ENGLISH",598]="5Ghz has been disabled"
	arr["SPANISH",598]="Se ha desactivado 5Ghz"
	arr["FRENCH",598]="5Ghz a été désactivée"
	arr["CATALAN",598]="S'ha desactivat 5Ghz"
	arr["PORTUGUESE",598]="A banda de 5Ghz foi desativa"
	arr["RUSSIAN",598]="5Ghz отключено"
	arr["GREEK",598]="Το 5Ghz απενεργοποιήθηκε"
	arr["ITALIAN",598]="5Ghz è stato disattivato"
	arr["POLISH",598]="5Ghz zostało wyłączone"
	arr["GERMAN",598]="5Ghz wurde deaktiviert"
	arr["TURKISH",598]="5Ghz devre dışı bırakıldı"
	arr["ARABIC",598]="تم تعطيل 5 جيجا هرتز"
	arr["CHINESE",598]="5Ghz 已禁用"

	arr["ENGLISH",599]="5Ghz has been enabled"
	arr["SPANISH",599]="Se ha activado 5Ghz"
	arr["FRENCH",599]="5Ghz a été activée"
	arr["CATALAN",599]="S'ha activat 5Ghz"
	arr["PORTUGUESE",599]="A banda de 5Ghz foi ativa"
	arr["RUSSIAN",599]="5Ghz включено"
	arr["GREEK",599]="Το 5Ghz ενεργοποιήθηκε"
	arr["ITALIAN",599]="5Ghz è stato attivato"
	arr["POLISH",599]="5Ghz zostało włączone"
	arr["GERMAN",599]="5Ghz wurde aktiviert"
	arr["TURKISH",599]="5Ghz etkinleştirildi"
	arr["ARABIC",599]="تم تفعيل 5 جيجا هرتز"
	arr["CHINESE",599]="5Ghz 已启用"

	arr["ENGLISH",600]="You already have selected a capture file during this session [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["SPANISH",600]="Ya tienes seleccionado un fichero de captura en esta sesión [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["FRENCH",600]="Vous avez déjà sélectionné un fichier de capture pour cette session \${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["CATALAN",600]="Ja tens seleccionat un fitxer de captura en aquesta sessió [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["PORTUGUESE",600]="Você selecionou um arquivo de captura nesta sessão [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["RUSSIAN",600]="Вы уже выбрали файл захвата во время этой сессии [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["GREEK",600]="Έχετε ήδη επιλέξει αρχείο καταγραφής κατά τη διάρκεια της συνεδρίας [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["ITALIAN",600]="È stato selezionato un file di cattura in questa sessione [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["POLISH",600]="W tej sesji wybrano już plik przechwytywania [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["GERMAN",600]="Sie haben bereits eine Capture-Datei in dieser Sitzung ausgewählt [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["TURKISH",600]="Bu oturumda zaten bir yakalama dosyası seçtiniz [\${normal_color} \${hashcatenterpriseenteredpath}\${blue_color}]"
	arr["ARABIC",600]="[\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}] لقد قمت بتحديد ملف الالتقاط أثناء هذه الدورة"
	arr["CHINESE",600]="您已经在此会话期间选择了一个捕获文件 [\${normal_color}\${hashcatenterpriseenteredpath}\${blue_color}]"

	arr["ENGLISH",601]="Selected file has an invalid hashcat enterprise hashes format"
	arr["SPANISH",601]="El fichero seleccionado no tiene un formato válido de hashes enterprise para hashcat"
	arr["FRENCH",601]="Le fichier sélectionné n'a pas un format de hashes d'enterprise valide pour hashcat"
	arr["CATALAN",601]="El fitxer seleccionat no té un format vàlid de hash enterprise per hashcat"
	arr["PORTUGUESE",601]="O arquivo selecionado não possui um formato de hashes enterprise válidas para o hashcat"
	arr["RUSSIAN",601]="Выбранный файл имеет недопустимый формат хеша enterprise для hashcat"
	arr["GREEK",601]="Το επιλεγμένο αρχείο δεν έχει έγκυρο hashcat enterprise hash format"
	arr["ITALIAN",601]="Il file selezionato non ha un hash valido in formato enterprise per hashcat"
	arr["POLISH",601]="Wybrany plik ma nieprawidłowy format hash korporacyjnego dla hashcat"
	arr["GERMAN",601]="Die ausgewählte Datei hat kein gültiges Enterprise-Hashformat für hashcat"
	arr["TURKISH",601]="Seçilen dosya hashcat için geçerli bir enterprise hash biçimine sahip değil"
	arr["ARABIC",601]="Enterprise hashcat يحتوي الملف المحدد على تنسيق تجزئة غير صالح ل"
	arr["CHINESE",601]="所选文件的 hashcat 企业级加密的哈希格式无效"

	arr["ENGLISH",602]="Selected file has a valid hashcat enterprise hashes format"
	arr["SPANISH",602]="El fichero seleccionado tiene un formato válido de hashes enterprise para hashcat"
	arr["FRENCH",602]="Le fichier sélectionné a un format de hashes d'enterprise valide pour hashcat"
	arr["CATALAN",602]="El fitxer seleccionat té un format vàlid de hashes enterprise per hashcat"
	arr["PORTUGUESE",602]="O arquivo selecionado possui um formato de hashes enterprise válidas para o hashcat"
	arr["RUSSIAN",602]="Выбранный файл имеет правильный формат хеша enterprise для hashcat"
	arr["GREEK",602]="Το επιλεγμένο αρχείο έχει έγκυρο hashcat enterprise hash format"
	arr["ITALIAN",602]="Il file selezionato ha un hash valido in formato enterprise per hashcat"
	arr["POLISH",602]="Wybrany plik ma poprawny format hash korporacyjnego dla hashcat"
	arr["GERMAN",602]="Die ausgewählte Datei hat ein gültiges Enterprise-Hashformat für hashcat"
	arr["TURKISH",602]="Seçilen dosyanın geçerli bir hashcat enterprise karma biçimi var"
	arr["ARABIC",602]="Enterprise hashcat يحتوي الملف المحدد على تنسيق تجزئة صالح ل"
	arr["CHINESE",602]="所选文件具有有效的 hashcat 企业级加密的哈希格式"

	arr["ENGLISH",603]="Selected hashcat enterprise captured file: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["SPANISH",603]="Fichero de captura enterprise hashcat seleccionado: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["FRENCH",603]="Fichier de capture enterprise hashcat sélectionné: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["CATALAN",603]="Fitxer de captura enterprise hashcat seleccionat: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["PORTUGUESE",603]="Arquivo de captura enterprise para hashcat selecionado: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["RUSSIAN",603]="Выбранный файл захвата enterprise hashcat: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["GREEK",603]="Επιλεγμένο hashcat enterprise αρχείο καταγραφής: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["ITALIAN",603]="File di cattura enterprise hashcat selezionato: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["POLISH",603]="Wybrany plik przechwytywania hashcat enterprise: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["GERMAN",603]="Ausgewählte Enterprise-hashcat-Capture-Datei: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["TURKISH",603]="Seçilen hashcat enterprise dosyası: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"
	arr["ARABIC",603]="\${pink_color}\${hashcatenterpriseenteredpath}\${blue_color} :المحدد enterprise hashcat ملف التقاط\${normal_color}"
	arr["CHINESE",603]="已选择的 hashcat 企业级加密捕获文件: \${pink_color}\${hashcatenterpriseenteredpath}\${normal_color}"

	arr["ENGLISH",604]="Selected hashcat enterprise captured file: \${pink_color}None\${normal_color}"
	arr["SPANISH",604]="Fichero de captura enterprise hashcat seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",604]="Fichier de capture enterprise hashcat sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",604]="Fitxer de captura enterprise hashcat seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",604]="Arquivo de captura enterprise para hashcat selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",604]="Выбранный файл захвата enterprise hashcat: \${pink_color}Ещё не выбран\${normal_color}"
	arr["GREEK",604]="Επιλεγμένο hashcat enterprise αρχείο καταγραφής: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",604]="File di cattura enterprise hashcat selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",604]="Wybrany plik przechwytywania hashcat enterprise: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",604]="Ausgewählte Enterprise-hashcat-Capture-Datei: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",604]="Seçilen hashcat enterprise dosyası: \${pink_color}None\${normal_color}"
	arr["ARABIC",604]="\${pink_color}None\${blue_color} :المحدد enterprise hashcat ملف التقاط\${normal_color}"
	arr["CHINESE",604]="已选择的 hashcat 企业级加密的捕获文件: \${pink_color}None\${normal_color}"

	arr["ENGLISH",605]="Selected john the ripper enterprise captured file: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["SPANISH",605]="Fichero de captura enterprise john the ripper seleccionado: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["FRENCH",605]="Fichier de capture enterprise john the ripper sélectionné: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["CATALAN",605]="Fitxer de captura enterprise john the ripper seleccionat: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["PORTUGUESE",605]="Arquivo de captura enterprise para john the ripper selecionado: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["RUSSIAN",605]="Выбранный файл захвата enterprise john the ripper: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["GREEK",605]="Επιλεγμένο john the ripper enterprise αρχείο καταγραφής: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["ITALIAN",605]="File di cattura enterprise john the ripper selezionato: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["POLISH",605]="Wybrany plik przechwytywania john the ripper enterprise: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["GERMAN",605]="Ausgewählte Enterprise-john the ripper-Capture-Datei: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["TURKISH",605]="Seçilen john the ripper enterprise dosyası: \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"
	arr["ARABIC",605]="\${pink_color}\${jtrenterpriseenteredpath}\${blue_color} :الذي تم التقاطه John the Ripper Enterprise تم تحديد ملف\${normal_color}"
	arr["CHINESE",605]="已选择的企业级加密的捕获文件  \${pink_color}\${jtrenterpriseenteredpath}\${normal_color}"

	arr["ENGLISH",606]="Selected john the ripper enterprise captured file: \${pink_color}None\${normal_color}"
	arr["SPANISH",606]="Fichero de captura enterprise john the ripper seleccionado: \${pink_color}Ninguno\${normal_color}"
	arr["FRENCH",606]="Fichier de capture enterprise john the ripper sélectionné: \${pink_color}Aucun\${normal_color}"
	arr["CATALAN",606]="Fitxer de captura enterprise john the ripper seleccionat: \${pink_color}Ningú\${normal_color}"
	arr["PORTUGUESE",606]="Arquivo de captura enterprise para john the ripper selecionado: \${pink_color}Nenhum\${normal_color}"
	arr["RUSSIAN",606]="Выбранный файл захвата enterprise john the ripper: \${pink_color}Ещё не выбран\${normal_color}"
	arr["GREEK",606]="Επιλεγμένο john the ripper enterprise αρχείο καταγραφής: \${pink_color}Κανένα\${normal_color}"
	arr["ITALIAN",606]="File di cattura enterprise john the ripper selezionato: \${pink_color}Nessuno\${normal_color}"
	arr["POLISH",606]="Wybrany plik przechwytywania john the ripper enterprise: \${pink_color}Brak\${normal_color}"
	arr["GERMAN",606]="Ausgewählte Enterprise-john the ripper-Capture-Datei: \${pink_color}Keine\${normal_color}"
	arr["TURKISH",606]="Seçilen john the ripper enterprise dosyası: \${pink_color}None\${normal_color}"
	arr["ARABIC",606]="\${pink_color}None\${blue_color} :الذي تم التقاطه John the Ripper Enterprise تم تحديد ملف\${normal_color}"
	arr["CHINESE",606]="已选择的 John the Ripper 企业级加密的捕获文件: \${pink_color}None\${normal_color}"

	arr["ENGLISH",607]="Selected file has an invalid john the ripper enterprise hashes format"
	arr["SPANISH",607]="El fichero seleccionado no tiene un formato válido de hashes enterprise para john the ripper"
	arr["FRENCH",607]="Le fichier sélectionné n'a pas un format de hashes d'entreprise valide pour john the ripper"
	arr["CATALAN",607]="El fitxer seleccionat no té un format vàlid de hashes enterprise per john the ripper"
	arr["PORTUGUESE",607]="O arquivo selecionado não possui um formato de hashes enterprise válidas para o john the ripper"
	arr["RUSSIAN",607]="Выбранный файл имеет недопустимый формат хеша enterprise для john the ripper"
	arr["GREEK",607]="Το επιλεγμένο αρχείο δεν έχει έγκυρο john the ripper enterprise hash format"
	arr["ITALIAN",607]="Il file selezionato non ha un hash valido in formato enterprise per john the ripper"
	arr["POLISH",607]="Wybrany plik ma poprawny format hash korporacyjnego dla john the ripper"
	arr["GERMAN",607]="Die ausgewählte Datei hat kein gültiges Enterprise-Hashformat für john the ripper"
	arr["TURKISH",607]="Seçilen dosyanın geçersiz bir john the ripper enterprise hash biçimi var"
	arr["ARABIC",607]="غير صالح john the ripper enterprise يحتوي الملف المحدد على تنسيق تجزئات"
	arr["CHINESE",607]="所选文件的 john the ripper 企业级加密哈希格式无效"

	arr["ENGLISH",608]="Selected file has a valid john the ripper enterprise hashes format"
	arr["SPANISH",608]="El fichero seleccionado tiene un formato válido de hashes enterprise para john the ripper"
	arr["FRENCH",608]="Le fichier sélectionné a un format de hashes d’entreprise valide pour john the ripper"
	arr["CATALAN",608]="El fitxer seleccionat té un format vàlid de hashes enterprise per john the ripper"
	arr["PORTUGUESE",608]="O arquivo selecionado possui um formato de hashes enterprise válidas para o john the ripper"
	arr["RUSSIAN",608]="Выбранный файл имеет правильный формат хеша enterprise для john the ripper"
	arr["GREEK",608]="Το επιλεγμένο αρχείο έχει έγκυρο john the ripper enterprise hash format"
	arr["ITALIAN",608]="Il file selezionato ha un hash valido in formato enterprise per john the ripper"
	arr["POLISH",608]="Wybrany plik ma poprawny format hash korporacyjnego dla john the ripper"
	arr["GERMAN",608]="Die ausgewählte Datei hat ein gültiges Enterprise-Hashformat für john the ripper"
	arr["TURKISH",608]="Seçilen dosyanın geçerli bir john the ripper enterprise hash biçimi var"
	arr["ARABIC",608]="صالح john the ripper enterprise يحتوي الملف المحدد على تنسيق تجزئات"
	arr["CHINESE",608]="所选文件具有有效的 john the ripper 企业级加密的哈希格式"

	arr["ENGLISH",609]="You already have selected a capture file during this session [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["SPANISH",609]="Ya tienes seleccionado un fichero de captura en esta sesión [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["FRENCH",609]="Vous avez déjà sélectionné un fichier de capture pour cette session \${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["CATALAN",609]="Ja tens seleccionat un fitxer de captura en aquesta sessió [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["PORTUGUESE",609]="Você selecionou um arquivo de captura nesta sessão [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["RUSSIAN",609]="Вы уже выбрали файл захвата во время этой сессии [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["GREEK",609]="Έχετε ήδη επιλέξει κάποιο αρχείο καταγραφής κατά τη διάρκεια της συνεδρίας [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["ITALIAN",609]="È stato selezionato un file di cattura in questa sessione [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["POLISH",609]="W tej sesji wybrano już plik przechwytywania [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["GERMAN",609]="Sie haben bereits eine Capture-Datei in dieser Sitzung ausgewählt [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"
	arr["TURKISH",609]="Bu oturumda zaten bir yakalama dosyası seçtiniz [\${normal_color} \${jtrenterpriseenteredpath}\${blue_color}]"
	arr["ARABIC",609]="[\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}] لقد قمت بتحديد ملف الالتقاط أثناء هذه الدورة"
	arr["CHINESE",609]="您已经在此会话期间选择了一个捕获文件 [\${normal_color}\${jtrenterpriseenteredpath}\${blue_color}]"

	arr["ENGLISH",610]="Hashes obtained during an enterprise wifi network attack can be also decrypted using john the ripper tool. Dictionary or bruteforce attacks can be performed from airgeddon menus"
	arr["SPANISH",610]="También se puede usar john the ripper para descifrar los hashes obtenidos en un ataque a una red wifi enterprise. Ataques de diccionario o por fuerza bruta pueden ser usados desde los menús de airgeddon"
	arr["FRENCH",610]="Aussi c'est possible utiliser john the ripper pour déchiffrer les hashes obtenus lors d'une attaque contre un réseau wifi d'entreprise. Les attaques de dictionnaire ou la force brute peuvent être utilisées à partir des menus d'airgeddon"
	arr["CATALAN",610]="També es pot utilitzar john the ripper per desxifrar els hashes obtinguts en un atac a una xarxa wifi enterprise. Atacs de diccionari o per força bruta poden ser usats des dels menús de airgeddon"
	arr["PORTUGUESE",610]="Você também pode usar o john the ripper para descriptografar as hashes obtidas em um ataque a uma rede wifi enterprise. Ataques de dicionário ou força bruta, podem ser usados nos menus do airgeddon"
	arr["RUSSIAN",610]="Хэши, полученные во время атаки на корпоративную сеть wifi, также могут быть расшифрованы с помощью инструмента john the ripper. Атаки по словарю или грубой силой можно использовать из меню airgeddon"
	arr["GREEK",610]="Τα hashes που καταγράφηκαν κατά τη διάρκεια κάποιας επίθεσης enterprise wifi δικτύου μπορούν επίσης να αποκρυπτογραφηθούν χρησιμοποιώντας το εργαλείο john the ripper. Μπορεί να πραγματοποιηθεί επίθεση με λεξικό ή bruteforce επιλέγοντας κάποια από τα δύο το μενού του airgeddon"
	arr["ITALIAN",610]="È anche possibile utilizzare john the ripper per decifrare gli hash ottenuti in un attacco a una rete wifi enterprise. Gli attacchi di dizionario o forza bruta, possono essere utilizzati dai menu di airgeddon"
	arr["POLISH",610]="Możesz również użyć john the ripper aby złamać hasze uzyskane podczas ataku na firmową sieć wifi. Ataki słownikowe lub bruteforce mogą być wykonane z menu airgeddon"
	arr["GERMAN",610]="Sie können auch john the ripper verwenden, um die Hashes, die auf ein WLAN-Enterprise Netzwerk erhalten wurden, zu entschlüsseln. Wörterbuchangriffe oder Brute Force Angriffe können aus den Menüs von airgeddon verwendet werden"
	arr["TURKISH",610]="Bir kurumsal wifi ağına yapılan saldırıda elde edilen hash şifresini çözmek için john the ripper'i kullanabilirsiniz. Dictionary veya bruteforce saldırıları airgeddon menülerinden kullanılabilir"
	arr["ARABIC",610]="airgeddon من قوائم bruteforce يمكن تنفيذ هجمات القاموس أو .john the ripper باستخدام أداة enterprise wifi يمكن أيضًا فك تشفير التجزئة التي تم الحصول عليها أثناء هجوم على شبكة"
	arr["CHINESE",610]="在企业级加密的 wifi 网络攻击期间获得的哈希值也可以使用 john the ripper 工具解密。从 airgeddon 菜单执行字典或暴力攻击"

	arr["ENGLISH",611]="Type the path to store the file or press [Enter] to accept the default proposal \${normal_color}[\${jtr_potpath}]"
	arr["SPANISH",611]="Escribe la ruta donde guardaremos el fichero o pulsa [Enter] para aceptar la propuesta por defecto \${normal_color}[\${jtr_potpath}]"
	arr["FRENCH",611]="Entrez le chemin où vous voulez enregistrer le fichier ou bien appuyez sur [Enter] pour utiliser le chemin proposé \${normal_color}[\${jtr_potpath}]"
	arr["CATALAN",611]="Escriu la ruta on guardarem el fitxer o prem [Enter] per acceptar la proposta per defecte \${normal_color}[\${jtr_potpath}]"
	arr["PORTUGUESE",611]="Digite o caminho onde armazenar o arquivo ou pressione [Enter] para aceitar o padrão \${normal_color}[\${jtr_potpath}]"
	arr["RUSSIAN",611]="Напечатайте путь к сохранённому файлу или нажмите [Enter] для принятия предложения по умолчанию \${normal_color}[\${jtr_potpath}]"
	arr["GREEK",611]="Πληκτρολογήστε το μονοπάτι για την αποθήκευση του αρχείου ή πατήστε [Enter] για την προεπιλεγμένη επιλογή \${normal_color}[\${jtr_potpath}]"
	arr["ITALIAN",611]="Immettere il percorso dove memorizzare il file o premere [Enter] per accettare quello di default \${normal_color}[\${jtr_potpath}]"
	arr["POLISH",611]="Wpisz ścieżkę do zapisu pliku lub naciśnij [Enter], aby zaakceptować domyślną propozycję \${normal_color}[\${jtr_potpath}]"
	arr["GERMAN",611]="Geben Sie den Pfad ein wo die Datei gespeichert werden soll, oder drücken Sie die [Enter], um den Standardvorschlag zu akzeptieren \${normal_color}[\${jtr_potpath}]"
	arr["TURKISH",611]="Dosyayı depolamak için yolu yazın veya varsayılan teklifi kabul etmek için [Enter] tuşuna basın. \${normal_color}[\${jtr_potpath}]"
	arr["ARABIC",611]="\${normal_color}[\${jtr_potpath}]\${green_color} لقبول الاقتراح [Enter] اكتب المسار لتخزين الملف أو اضغط على\${normal_color}"
	arr["CHINESE",611]="请输入文件的存储路径或按 [Enter] 接受默认建议 \${normal_color}[\${jtr_potpath}]"

	arr["ENGLISH",612]="No enterprise networks found"
	arr["SPANISH",612]="No se encontraron redes enterprise"
	arr["FRENCH",612]="Aucun réseau enterprise détecté"
	arr["CATALAN",612]="No s'han trobat xarxes enterprise"
	arr["PORTUGUESE",612]="Nenhuma rede enterprise encontrada"
	arr["RUSSIAN",612]="Сети enterprise не найдены"
	arr["GREEK",612]="Δεν βρέθηκαν enterprise δίκτυα"
	arr["ITALIAN",612]="Nessuna rete enterprise trovata"
	arr["POLISH",612]="Nie znaleziono sieci enterprise"
	arr["GERMAN",612]="Keine Enterprise-Netzwerke gefunden"
	arr["TURKISH",612]="Herhangi enterprise bir ağ bulunamadı"
	arr["ARABIC",612]="Enterprise لم يتم العثور على شبكات"
	arr["CHINESE",612]="未找到企业级加密的无线网络"

	arr["ENGLISH",613]="Warning. Please check \${rc_path} file or command line flags. Invalid value on \${normal_color}\${error_var_name}\${yellow_color} variable. The default value \${normal_color}\${error_var_default_value}\${yellow_color} will be used"
	arr["SPANISH",613]="Atención. Por favor revisa el fichero \${rc_path}. El valor de la variable \${normal_color}\${error_var_name}\${yellow_color} no es válido. El valor por defecto \${normal_color}\${error_var_default_value}\${yellow_color} será usado"
	arr["FRENCH",613]="Attention. Veuillez vérifier le fichier \${rc_path} ou les flags sur ligne de commande. La variable \${normal_color}\${error_var_name}\${yellow_color} a une valeur non valide. La valeur par défaut \${normal_color}\${error_var_default_value}\${yellow_color} sera utilisée"
	arr["CATALAN",613]="Atencio. Comprova el fitxer de \${rc_path}. Valor no vàlid a la variable \${normal_color}\${error_var_name}\${yellow_color}. S'utilitzarà el valor predeterminat \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["PORTUGUESE",613]="Aviso: Por favor, verifique o arquivo \${rc_path} ou os argumentos na linha de comando. Valor inválido na variável \${normal_color}\${error_var_name}\${yellow_color}. O valor padrão \${normal_color}\${error_var_default_value}\${yellow_color} será usado"
	arr["RUSSIAN",613]="Предупреждение. Пожалуйста, проверьте файл \${rc_path} или флаги командной строки. Недопустимое значение переменной \${normal_color}\${error_var_name}\${yellow_color}. Будет использовано значение по умолчанию \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["GREEK",613]="Προειδοποίηση. Ελέγξτε το αρχείο \${rc_path} ή τα flags της γραμμής εντολών. Βρέθηκε μη έγκυρη τιμή για τη μεταβλητή \${normal_color}\${error_var_name}\${yellow_color}. Θα χρησιμοποιηθεί η προεπιλεγμένη τιμή \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["ITALIAN",613]="Attenzione. Controlla il file \${rc_path} o i flag della linea di comando. Il valore della variabile \${normal_color}\${error_var_name}\${yellow_color} non è valido. Verrà utilizzato il valore predefinito \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["POLISH",613]="Ostrzeżenie! Sprawdź plik \${rc_path} lub parametry linii poleceń. Niepoprawna wartość zmiennej \${normal_color}\${error_var_name}\${yellow_color}. Użyta zostanie wartość domyślna \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["GERMAN",613]="Achtung. Bitte überprüfen Sie \${rc_path}. Ungültiger Wert für die Variable \${normal_color}\${error_var_name}\${yellow_color}. \${normal_color}\${error_var_default_value}\${yellow_color} wird verwendet"
	arr["TURKISH",613]="Uyarı. Lütfen \${rc_path} dosyasını veya komut satırı bayraklarını kontrol edin. \${normal_color}\${error_var_name}\${yellow_color} değişkeninde geçersiz değer. \${normal_color}\${error_var_default_value}\${yellow_color} varsayılan değeri kullanılacak"
	arr["ARABIC",613]="\${normal_color}\${error_var_default_value}\${yellow_color} سيتم استخدام القيمة الافتراضية .\${normal_color}\${error_var_name}\${yellow_color} أو أعلام سطر الأوامر.هناك قيمة غير صالحة في متغير \${rc_path} تحذير. يرجى التحقق من ملف"
	arr["CHINESE",613]="警告。请检查 \${rc_path} 文件或命令行标志。 \${normal_color}\${error_var_name}\${yellow_color} 变量的值无效。将使用默认值 \${normal_color}\${error_var_default_value}\${yellow_color}"

	arr["ENGLISH",614]="Warning. Please check \${rc_path} file. Configuration variable \${normal_color}\${error_var_name}\${yellow_color} not found. The default value \${normal_color}\${error_var_default_value}\${yellow_color} will be used"
	arr["SPANISH",614]="Atención. Por favor revisa el fichero \${rc_path}. No se ha encontrado la variable \${normal_color}\${error_var_name}\${yellow_color}. El valor por defecto \${normal_color}\${error_var_default_value}\${yellow_color} será usado"
	arr["FRENCH",614]="Attention. Veuillez vérifier le fichier \${rc_path}. La variable de configuration \${normal_color}\${error_var_name}\${yellow_color} introuvable. \${normal_color}\${error_var_default_value}\${yellow_color} sera utilisé"
	arr["CATALAN",614]="Atencio. Si us plau, comprova el fitxer \${rc_path}. No s'ha trobat la variable de configuració \${normal_color}\${error_var_name}\${yellow_color}. S'utilitzarà \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["PORTUGUESE",614]="Aviso: Por favor, verifique o arquivo \${rc_path}. Variável de configuração \${normal_color}\${error_var_name}\${yellow_color} não encontrada. \${normal_color}\${error_var_default_value}\${yellow_color} será usado"
	arr["RUSSIAN",614]="Предупреждение. Пожалуйста, проверьте файл \${rc_path}. Конфигурационная переменная \${normal_color}\${error_var_name}\${yellow_color} не найдена. Будет использоваться значение по умолчанию \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["GREEK",614]="Προειδοποίηση. Ελέγξτε το αρχείο \${rc_path}. Η μεταβλητή για το configuration \${normal_color}\${error_var_name}\${yellow_color} δεν βρέθηκε. Θα χρησιμοποιηθεί η προεπιλεγμένη τιμή  \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["ITALIAN",614]="Attenzione. Per favore controlla il file \${rc_path}. La variabile di configurazione \${normal_color}\${error_var_name}\${yellow_color} non è stata trovata. Verrà utilizzado il valore predefinito \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["POLISH",614]="Uwaga! Sprawdź plik \${rc_path}. Nie znaleziono zmiennej \${normal_color}\${error_var_name}\${yellow_color}. Użyta zostanie wartość domyślna \${normal_color}\${error_var_default_value}\${yellow_color}"
	arr["GERMAN",614]="Achtung. Bitte überprüfen Sie die \${rc_path}-Datei. Die Konfigurationsvariable \${normal_color}\${error_var_name}\${yellow_color} wurde nicht gefunden. \${normal_color}\${error_var_default_value}\${yellow_color} wird verwendet"
	arr["TURKISH",614]="Uyarı! Lütfen \${rc_path} dosyasını kontrol edin. Yapılandırma değişkeni \${normal_color}\${error_var_name}\${yellow_color} bulunamadı. \${normal_color}\${error_var_default_value}\${yellow_color} varsayılan değeri kullanılmak istiyor"
	arr["ARABIC",614]="\${normal_color}\${error_var_default_value}\${yellow_color} غير موجود. سيتم استخدام القيمة الافتراضية \${normal_color}\${error_var_name}\${yellow_color} \${rc_path} تحذير. يرجى التحقق من ملف"
	arr["CHINESE",614]="警告。请检查 \${rc_path} 文件。未找到配置变量 \${normal_color}\${error_var_name}\${yellow_color}。将使用默认值 \${normal_color}\${error_var_default_value}\${yellow_color}"

	arr["ENGLISH",615]="There is an error in your configuration. Please check the \${rc_path} file. You have enabled the option to force the use of iptables instead of nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) but your system doesn't have iptables installed. Disable this option or install iptables to fix the problem"
	arr["SPANISH",615]="Hay un error en tu configuración. Por favor revisa el fichero \${rc_path}. Has activado la opción para forzar el uso de iptables en lugar de nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) pero tu sistema no tiene iptables instaladas. Deshabilita esta opción o instala iptables para solucionar el problema"
	arr["FRENCH",615]="Il y a une erreur dans votre configuration. Veuillez vérifier le fichier \${rc_path}. Vous avez activé l'option pour forcer l'utilisation de iptables à la place de nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) mais iptables n'est pas installé sur votre système. Désactivez cette option ou installez iptables pour résoudre le problème"
	arr["CATALAN",615]="Hi ha un error en la configuració. Si us plau comprova el fitxer \${rc_path}. Has activat l'opció per forçar l'ús d'iptables en lloc de nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) però el teu sistema no té iptables instal·lades. Deshabilita aquesta opció o instal·la iptables per solucionar el problema"
	arr["PORTUGUESE",615]="Existe um erro na sua configuração. Por favor, verifique o arquivo \${rc_path}. Você ativou a opção para forçar o uso de iptables em vez de nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}), mas seu sistema não possui o iptables instalado. Desabilite esta opção ou instale o iptables para resolver o problema"
	arr["RUSSIAN",615]="В вашей конфигурации имеется ошибка. Пожалуйста, проверьте файл \${rc_path}. Вы включили опцию принудительного использования iptables вместо nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}), но в вашей системе не установлены iptables. Отключите эту опцию или установите iptables, чтобы исправить проблему"
	arr["GREEK",615]="Υπάρχει ένα σφάλμα στο configuration σας. Ελέγξτε το αρχείο \${rc_path}. Έχετε ενεργοποιήσει την επιλογή που εξαναγκάζει τη χρήση του iptables αντί του nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) και το σύστημά σας δεν έχει το έχει εγκατεστημένο (iptables). Απενεργοποιήστε την επιλογή αυτή ή εγκαταστήστε το iptables για να επιλυθεί το πρόβλημα"
	arr["ITALIAN",615]="C'è un errore nella tua configurazione. Per favore controlla il file \${rc_path}. Hai attivato l'opzione per forzare l'uso di iptables invece di nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) ma il tuo sistema non ha iptables installato. Disabilita questa opzione o installa iptables per risolvere il problema"
	arr["POLISH",615]="Wystąpił błąd konfiguracji. Sprawdź plik \${rc_path}. Aktywowałeś opcję wymuszania użycia iptables zamiast nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}), ale twój system nie ma zainstalowanego iptables. Wyłącz tę opcję lub zainstaluj iptables, aby rozwiązać problem"
	arr["GERMAN",615]="Ein Fehler wurde in Ihren Einstellungen gefunden. Bitte überprüfen Sie die Datei \${rc_path}. Sie haben die Option aktiviert, um die Verwendung von iptables anstelle von nftables zu erzwingen (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}), aber auf Ihrem System sind iptables nicht installiert. Deaktivieren Sie diese Option oder installieren Sie iptables, um das Problem zu lösen"
	arr["TURKISH",615]="Yapılandırmanızda bir hata var. Lütfen \${rc_path} dosyasını kontrol edin. Nftables (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) yerine iptables kullanımını zorlama seçeneğini etkinleştirdiniz, ancak sisteminizde iptables kurulu değil. Bu seçeneği devre dışı bırakın veya sorunu çözmek için iptables yükleyin"
	arr["ARABIC",615]="لإصلاح المشكلة iptables مثبتًا. قم بتعطيل هذا الخيار أو قم بتثبيت iptables ولكن نظامك ليس به (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) nftables بدلاً من iptables لقد قمت بتفعيل خيار فرض استخدام .\${rc_path} هناك خطأ في التكوين الخاص بك. يرجى التحقق من ملف"
	arr["CHINESE",615]="您的配置有错误。请检查 \${rc_path} 文件。您启用了强制使用 iptables 而不是 nftables 的选项 (\${normal_color}AIRGEDDON_FORCE_IPTABLES\${red_color}) 但您的系统没有安装 iptables。禁用此选项或安装 iptables 以解决问题"

	arr["ENGLISH",616]="10. Change windows handling method to tmux"
	arr["SPANISH",616]="10. Cambiar el método de manejo de ventanas a tmux"
	arr["FRENCH",616]="10. Changer la méthode de gestion des fenêtres en tmux"
	arr["CATALAN",616]="10. Canviar el mètode de maneig de finestres a tmux"
	arr["PORTUGUESE",616]="10. Alterar gerenciador de janelas para tmux"
	arr["RUSSIAN",616]="10. Изменить метод управления окнами на tmux"
	arr["GREEK",616]="10. Αλλάξτε τη μέθοδο διαχείρισης παραθύρων σε tmux"
	arr["ITALIAN",616]="10. Cambiare il metodo di gestione delle finestre a tmux"
	arr["POLISH",616]="10. Zmień metodę zarządzania oknami na tmux"
	arr["GERMAN",616]="10. Ändern Sie die Fensterverwaltung zu tmux"
	arr["TURKISH",616]="10. Pencere yönetimi yöntemini tmux olarak değiştirin"
	arr["ARABIC",616]="10. tmux تغيير طريقة التعامل مع النوافذ إلى"
	arr["CHINESE",616]="10. 将窗口处理程序改为 tmux"

	arr["ENGLISH",617]="10. Change windows handling method to xterm"
	arr["SPANISH",617]="10. Cambiar el método de manejo de ventanas a xterm"
	arr["FRENCH",617]="10. Changer la méthode de gestion des fenêtres en xterm"
	arr["CATALAN",617]="10. Canviar el mètode de maneig de finestres a xterm"
	arr["PORTUGUESE",617]="Alterar gerenciador de janelas para xterm"
	arr["RUSSIAN",617]="10. Изменить метод управления окнами на xterm"
	arr["GREEK",617]="10. Αλλάξτε τη μέθοδο διαχείρισης παραθύρων σε xterm"
	arr["ITALIAN",617]="10. Cambiare il metodo di gestione delle finestre a xterm"
	arr["POLISH",617]="10. Zmień metodę zarządzania oknami na xterm"
	arr["GERMAN",617]="10. Ändern Sie die Fensterverwaltung zu xterm"
	arr["TURKISH",617]="10. Pencere yönetimi yöntemini xterm olarak değiştirin"
	arr["ARABIC",617]="10. xterm تغيير طريقة التعامل مع النوافذ إلى"
	arr["CHINESE",617]="10. 将窗口处理程序更改为 xterm"

	arr["ENGLISH",618]="Current windows handling: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["SPANISH",618]="Manejo de ventanas actual: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["FRENCH",618]="Gestion actuelle des fenêtres: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["CATALAN",618]="Maneig de finestres actual: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["PORTUGUESE",618]="Gerenciador de janelas atual: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["RUSSIAN",618]="Текущее управление окнами: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["GREEK",618]="Τρέχουσα διαχείριση παραθύρων: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["ITALIAN",618]="Gestione delle finestre attuale: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["POLISH",618]="Bieżące zarządzanie oknami: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["GERMAN",618]="Aktuelle Fensterverwaltung: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["TURKISH",618]="Mevcut pencere yönetimi: \${pink_color}xterm\${normal_color}\${reboot_required_text}"
	arr["ARABIC",618]="\${pink_color}xterm\${normal_color}\${reboot_required_text}\${blue_color} :إدارة النافذة الحالية\${normal_color}"
	arr["CHINESE",618]="当前窗口处理程序: \${pink_color}xterm\${normal_color}\${reboot_required_text}"

	arr["ENGLISH",619]="Current windows handling: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["SPANISH",619]="Manejo de ventanas actual: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["FRENCH",619]="Gestion actuelle des fenêtres: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["CATALAN",619]="Maneig de finestres actual: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["PORTUGUESE",619]="Gerenciador de janelas atual: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["RUSSIAN",619]="Текущее управление окнами: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["GREEK",619]="Τρέχουσα διαχείριση παραθύρων: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["ITALIAN",619]="Gestione delle finestre attuale: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["POLISH",619]="Bieżące zarządzanie oknami: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["GERMAN",619]="Aktuelle Fensterverwaltung: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["TURKISH",619]="Mevcut pencere yönetimi: \${pink_color}tmux\${normal_color}\${reboot_required_text}"
	arr["ARABIC",619]="\${pink_color}tmux\${normal_color}\${reboot_required_text}\${blue_color} :إدارة النافذة الحالية\${normal_color}"
	arr["CHINESE",619]="当前窗口处理程序: \${pink_color}tmux\${normal_color}\${reboot_required_text}"

	arr["ENGLISH",620]="The option has been modified in the configuration file. Restart the script in order to make the changes to take effect"
	arr["SPANISH",620]="Se ha modificado la opción en el fichero de configuración. Reinicia el script para que los cambios tengan efecto"
	arr["FRENCH",620]="On a changé l'option dans le fichier de configuration. Redémarrez le script pour que les modifications prennent effet"
	arr["CATALAN",620]="S'ha modificat l'opció en el fitxer de configuració. Reinicia el script perquè els canvis tinguin efecte"
	arr["PORTUGUESE",620]="O arquivo de configuração foi modificado. Reinicie o script para que as alterações entrem em vigor"
	arr["RUSSIAN",620]="Эта опция изменила параметр в файле конфигурации. Перезапустите данный скрипт для того, чтобы изменения вступили в силу"
	arr["GREEK",620]="Η επιλογή στο configuration file τροποποιήθηκε. Επανεκκινήστε το script για να τεθούν οι αλλαγές σε ισχύ"
	arr["ITALIAN",620]="É stata cambiata l'opzione nel file di configurazione. Riavviare lo script affinché le modifiche abbiano effetto"
	arr["POLISH",620]="Ta opcja wywołała zmianę w pliku konfiguracyjnym. Ponownie uruchom skrypt, aby zmiany odniosły skutek"
	arr["GERMAN",620]="Es änderte sich die Option in der Konfigurationsdatei. Starten Sie das Skript neu, damit die Änderungen wirksam werden"
	arr["TURKISH",620]="Yapılandırma dosyasında bu seçenek değiştirildi. Değişikliklerin etkili olması için script'i yeniden başlatın"
	arr["ARABIC",620]="تم تعديل الخيار في ملف التكوين. أعد تشغيل البرنامج لجعل التغييرات سارية المفعول"
	arr["CHINESE",620]="该选项已在配置文件中修改。重新启动脚本以使更改生效"

	arr["ENGLISH",621]="It's not possible to run airgeddon in the current tmux session. This session will be sent to background and a new tmux session will be created for launching airgeddon"
	arr["SPANISH",621]="No es posible ejecutar airgeddon en la sesión tmux actual. Esta sesión será enviada a segundo plano y se creará una nueva sesión tmux donde airgeddon será lanzado"
	arr["FRENCH",621]="Il n'est pas possible de lancer airgeddon dans la session de tmux en cours. Cette session sera envoyée à l’arrière-plan et une nouvelle session tmux sera crée pour lancer airgeddon"
	arr["CATALAN",621]="No és possible executar airgeddon en la sessió tmux actual. Aquesta sessió serà enviada a segon pla i es crearà una nova sessió tmux on airgeddon serà llançat"
	arr["PORTUGUESE",621]="Não é possível executar o airgeddon na sessão atual do tmux. Esta sessão será colocada em segundo plano e uma nova sessão do tmux será criada onde o airgeddon será executado"
	arr["RUSSIAN",621]="Невозможно запустить airgeddon в текущей сессии tmux. Этот сеанс будет отправлен в фоновый режим, и будет создан новый сеанс tmux для запуска airgeddon"
	arr["GREEK",621]="Δεν είναι δυνατό να εκτελέσετε airgeddon στην τρέχουσα συνεδρία tmux. Αυτή η συνεδρία θα στείλει στο παρασκήνιο και θα δημιουργηθεί μια νέα συνεδρία tmux για την εκκίνηση του airgeddon"
	arr["ITALIAN",621]="Non è possibile eseguire airgeddon nella sessione corrente di tmux. Questa sessione verrà mandata in background e verrà creata una nuova sessione tmux in cui verrà lanciato airgeddon"
	arr["POLISH",621]="Nie można uruchomić airgeddon w bieżącej sesji tmux. Ta sesja zostanie wysłana na drugi plan. Zostanie utworzona nowa sesja tmux, w której będzie uruchomiony airgeddon"
	arr["GERMAN",621]="Es ist nicht möglich, airgeddon in der aktuellen tmux-Sitzung auszuführen. Diese Sitzung wird in den Hintergrund gesendet und eine neue Sitzung wird erstellt, in der airgeddon gestartet wird"
	arr["TURKISH",621]="Mevcut tmux seansında airgeddon çalıştırmak mümkün değildir. Bu oturum arka plana gönderilecek ve airgeddon'un başlatılacağı yeni bir tmux oturumu oluşturulacak"
	arr["ARABIC",621]="airgeddon جديدة لإطلاق tmux الحالية. سيتم إرسال هذه الدورة إلى الخلفية وسيتم إنشاء دورة tmux في دورة airgeddon ليس من المفعل تشغيل"
	arr["CHINESE",621]="在当前 tmux 会话中无法运行 airgeddon。该会话将被发送到后台并创建一个新的 tmux 会话以启动 airgeddon"

	arr["ENGLISH",622]="13. (reaver) Null PIN attack"
	arr["SPANISH",622]="13. (reaver) Ataque de PIN nulo"
	arr["FRENCH",622]="13. (reaver) Attaque de PIN nul"
	arr["CATALAN",622]="13. (reaver) Atac de PIN nul"
	arr["PORTUGUESE",622]="13. (reaver) Ataque de PIN nulo"
	arr["RUSSIAN",622]="13. (reaver) Атака с нулевым PIN"
	arr["GREEK",622]="13. (reaver) Null PIN επίθεση"
	arr["ITALIAN",622]="13. (reaver) Attacco del PIN nullo"
	arr["POLISH",622]="13. (reaver) Atak null PIN"
	arr["GERMAN",622]="13. (reaver) Null-PIN-Angriff"
	arr["TURKISH",622]="13. (reaver) Null PIN saldırısı"
	arr["ARABIC",622]="13. Null PIN هجوم (reaver)"
	arr["CHINESE",622]="13. (reaver) 空密码攻击"

	arr["ENGLISH",623]="You have reaver installed (v\${reaver_version}). You meet the version requirement to perform null PIN integrated reaver attack (minimum version v\${minimum_reaver_nullpin_version}). Script can continue..."
	arr["SPANISH",623]="Tienes reaver instalado (v\${reaver_version}). Cumples con el requisito de versión para realizar el ataque de PIN nulo integrado con reaver (versión minima v\${minimum_reaver_nullpin_version}). El script puede continuar..."
	arr["FRENCH",623]="Reaver est installé (v\${reaver_version}). Cette version est compatible avec l'attaque par PIN nul (version minimale: \${minimum_reaver_nullpin_version}). Le script peut continuer..."
	arr["CATALAN",623]="Tens reaver instal·lat (v\${reaver_version}). Compleixes amb el requisit de versió per a realitzar l'atac de PIN nul integrat amb reaver (versió mínima v\${minimum_reaver_nullpin_version}). El script pot continuar..."
	arr["PORTUGUESE",623]="Você tem o reaver instalado (v\${reaver_version}). Você cumpre a exigência de versão para o ataque de PIN nulo com reaver (versão mínima v\${minimum_reaver_nullpin_version}). O script pode continuar..."
	arr["RUSSIAN",623]="У вас установлен reaver (v\${reaver_version}). Версия удовлетворяет требованиям для выполнения интегрированной в reaver атаки нулевого PIN (минимальная версия v\${minimum_reaver_nullpin_version}). Скрипт может продолжить работу..."
	arr["GREEK",623]="Έχετε εγκατεστημένο το reaver (v\${reaver_version}). Έχετε την απαραίτητη έκδοση reaver για την επίθεση null PIN με ενσωματωμένο reaver (ελάχιστη έκδοση v\${minimum_reaver_nullpin_version}). Το script μπορεί να συνεχίσει..."
	arr["ITALIAN",623]="È stato installato reaver (v\${reaver_version}). Soddisfi il requisito della versione per realizzare l'attacco del PIN nullo integrato in reaver (versione minima v\${minimum_reaver_nullpin_version}). Lo script può continuare..."
	arr["POLISH",623]="Masz zainstalowany reaver (v\${reaver_version}). Spełnia on wymagania dotyczące wersji, aby wykonać atak null PIN (wersja minimalna v\${minimum_reaver_nullpin_version}). Skrypt może kontynuować..."
	arr["GERMAN",623]="Reaver ist installiert (v\${reaver_version}). Sie erfüllen die Versionsvoraussetzung, um den Null-PIN-Angriff auszuführen, der mit Reaver integriert ist (min Version v\${minimum_reaver_nullpin_version}). Das Skript kann fortfahren..."
	arr["TURKISH",623]="Reaver sisteminizde kurulu (v\${reaver_version}). Null PIN entegre edilmiş reaver saldırısını gerçekleştirmek için sürüm gereksinimini karşılıyorsunuz (minimum sürüm v\${minimum_reaver_nullpin_version}). Script devam edebilir..."
	arr["ARABIC",623]="...البرنامج يمكن أن يستمر .(v\${minimum_reaver_nullpin_version}الحد الأدنى من الإصدار) Reaver PIN integrated reaver أنت تستوفي متطلبات الإصدار لتنفيذ هجوم .(v\${reaver_version}) لقد قمت بتثبيت"
	arr["CHINESE",623]="你已经安装了 reaver (v\${reaver_version})。您满足执行空 PIN 集成掠夺者攻击的版本要求 (最低版本 v\${minimum_reaver_nullpin_version}) 。脚本可以继续..."

	arr["ENGLISH",624]="You have reaver installed (v\${reaver_version}), but not required version. To perform null PIN integrated reaver attack you must have at least version v\${minimum_reaver_nullpin_version}"
	arr["SPANISH",624]="Tienes reaver instalado (v\${reaver_version}), aunque no la versión requerida. Para realizar el ataque de PIN nulo integrado con reaver has de tener al menos la versión v\${minimum_reaver_nullpin_version}"
	arr["FRENCH",624]="Reaver est installé (v\${reaver_version}) mais cette version n'est pas compatible avec l'attaque par PIN nul. Version minimale requise: v\${minimum_reaver_nullpin_version}"
	arr["CATALAN",624]="Tens reaver instal·lat (v\${reaver_version}), encara que no és la versió requerida. Per realitzar l'atac de PIN nul integrat amb reaver has de tenir almenys la versió v\${minimum_reaver_nullpin_version}"
	arr["PORTUGUESE",624]="Você tem o reaver instalado (v\${reaver_version}), mas não a versão necessária. Para fazer o ataque de PIN nulo com reaver você precisa ter pelo menos a versão v\${minimum_reaver_nullpin_version}"
	arr["RUSSIAN",624]="У вас установлен reaver (v\${reaver_version}), но не та версия, которая требуется. Для выполнения интегрированной в reaver атаки нулевого PIN у вас должна быть по крайней мере v\${minimum_reaver_nullpin_version}"
	arr["GREEK",624]="Έχετε εγκατεστημένο το reaver (v\${reaver_version}), αλλά όχι την απαιτούμενη έκδοση. Για να εκτελέσετε την επίθεση null PIN με ενσωματωμένο reaver θα πρέπει να έχετε τουλάχιστον την έκδοση v\${minimum_reaver_nullpin_version}"
	arr["ITALIAN",624]="È stato installato reaver (v\${reaver_version}), ma non la versione richiesta. Per realizzare l'attacco del PIN nullo integrato in reaver devi avere almeno la versione v\${minimum_reaver_nullpin_version}"
	arr["POLISH",624]="Masz zainstalowany reaver (v\${reaver_version}), ale zbyt niską wersję. Aby zrealizować atak null PIN zintegrowany z programem reaver musisz mieć co najmniej wersję v\${minimum_reaver_nullpin_version}"
	arr["GERMAN",624]="Reaver ist installiert (v\${reaver_version}), jedoch nicht die erforderliche Version. Um den Null-PIN-Angriff mit Reaver zu integrieren, müssen Sie mindestens die Version v\${minimum_reaver_nullpin_version} haben"
	arr["TURKISH",624]="Reaver sisteminizde kurulu (v\${reaver_version}), ancak sürüm uygun değil. Boş PIN entegre reaver saldırısını gerçekleştirmek için minimum sürüm olan \${minimum_reaver_nullpin_version} olmalıdır"
	arr["ARABIC",624]="v\${minimum_reaver_nullpin_version}يجب أن يكون لديك على الأقل الإصدار  ، PIN integrated reaver لكن ليس الإصدار المطلوب. لتنفيذ هجوم ، (v\${reaver_version}) لقد قمت بتثبيت"
	arr["CHINESE",624]="您已经安装了 reaver (v\${reaver_version})，但不是必需的版本。要执行空 PIN 集成掠夺者攻击，您必须至少具有版本 v\${minimum_reaver_nullpin_version}"

	arr["ENGLISH",625]="Null PIN attack is pretty fast and achieve the password almost instantly but only a few access points are vulnerable. Some of them are \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" and \"ZTE H298N\""
	arr["SPANISH",625]="El ataque de PIN nulo es muy rápido y consigue la contraseña instantáneamente pero solo unos pocos puntos de acceso son vulnerables. Algunos conocidos son \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" y \"ZTE H298N\""
	arr["FRENCH",625]="L'attaque de PIN nul est très rapide et il obtient le mot de passe instantanément, mais juste quelques points d'accès sont vulnérables. Certains sont \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" et \"ZTE H298N\""
	arr["CATALAN",625]="L'atac PIN nul és molt ràpid i aconsegueix la contrasenya instantàniament però només uns pocs punts d'accés són vulnerables. alguns són \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" i \"ZTE H298N\""
	arr["PORTUGUESE",625]="O ataque de PIN nulo é muito rápido e obtém a senha instantaneamente, mas apenas alguns pontos de acesso são vulneráveis. Alguns como: \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" e \"ZTE H298N\""
	arr["RUSSIAN",625]="Атака по нулевому PIN-коду очень быстрая и мгновенно получает пароль, но уязвимы только несколько точек доступа. Примеры некоторых из них: \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" и \"ZTE H298N\""
	arr["GREEK",625]="Η επίθεση null PIN είναι πολύ γρήγορη και παίρνει τον κωδικό άμεσα, αλλά μόνο λίγα σημεία πρόσβασης είναι ευάλωτα. Κάποια από αυτά είναι τα \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" και \"ZTE H298N\""
	arr["ITALIAN",625]="L'attacco del PIN nullo è molto veloce e ottiene la password all'istante, ma solo pochi punti di accesso sono vulnerabili. Alcuni conosciuti sono \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" e \"ZTE H298N\""
	arr["POLISH",625]="Atak null PIN jest bardzo szybki i natychmiast uzyskuje hasło. Niestety, tylko kilka punktów dostępu jest podatnych na ten atak. Niektóre z nich to \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" i \"ZTE H298N\""
	arr["GERMAN",625]="Der Null-PIN-Angriff ist sehr schnell und erhält das Kennwort sofort, aber nur wenige access points sind anfällig. Einige sind \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" und \"ZTE H298N\""
	arr["TURKISH",625]="Null PIN saldırısı çok hızlıdır ve şifreyi anında alır, ancak yalnızca birkaç erişim noktası korunmasızdır. Bazı \"Huawei HG658C\", \"ZTE H218N\", \"ZTE H108N\" ve \"ZTE H298N\""
	arr["ARABIC",625]="\"ZTE H298N\" و ، \"ZTE H108N\" ، \"ZTE H218N\" ، \"Huawei HG658C\" سريعًا جدًا ويحقق كلمة المرورعلى الفور تقريبًا ولكن فقط نقاط وصول قليلة معرضة للخطر. بعضها Null PIN يعد هجوم"
	arr["CHINESE",625]="空 PIN 攻击速度非常快，几乎可以立即获得密码，但只有少数的 AP 易受到这种攻击。例如“Huawei HG658C*”、“ZTE H218N*”、“ZTE H108N*”和“ZTE H298N*”"

	arr["ENGLISH",626]="Since airgeddon 9.20 version, tmux is supported and it can be used instead of xterm as windows handler. Script can be launched in a headless environment without a graphical X window system. It is recommended only for advanced users. Like any other option, it can be configured on the options menu, on the \${rc_path} options file or launched using \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} \"flag\" in the command line. More information about options customization at Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["SPANISH",626]="A partir de la versión 9.20 de airgeddon, tmux está soportado y se puede utilizar en lugar de xterm como gestor de ventanas. Se puede lanzar el script en un entorno sin un sistema gráfico de ventanas X. Solo se recomienda hacerlo para usuarios avanzados. Como cualquier otra opción, se puede configurar desde el menú de opciones, configurarlo en el fichero de opciones \${rc_path} o lanzarlo usando el \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} en la línea de comandos. Más información acerca de la personalización de opciones en el Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["FRENCH",626]="À partir de la version 9.20 d'airgeddon, tmux est supporté et peut être utilisé à la place de xterm en tant que gestionnaire de fenêtres. Vous pouvez lancer le script dans un environnement dépourvu de système graphique X Windows. Il est recommandé aux utilisateurs avancés. Comme toute autre option, elle peut être configurée à partir du menu d'options, dans le fichier d'options \${rc_path} ou le lancer à l'aide de \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} sur la ligne de commande. Plus d'informations sur la personnalisation des options dans le Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["CATALAN",626]="A partir de la versió 9.20 de airgeddon, tmux està suportat i es pot utilitzar en lloc de xterm com a gestor de finestres. Es pot llançar l'script en un entorn sense un sistema gràfic de finestres X. Només es recomana fer-ho per a usuaris avançats. Com qualsevol altra opció, es pot configurar des del menú d'opcions, configurar en el fitxer d'opcions \${rc_path} o llançar usant el \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} en la línia d'ordres. Més informació sobre la personalització d'opcions al Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["PORTUGUESE",626]="A partir da versão 9.20 do airgeddon, o tmux pode ser usado em vez do xterm como gerenciador de janelas. Você pode iniciar o script em um ambiente sem um sistema gráfico (X-Window). É recomendado apenas para usuários avançados. Como as demais opções, pode ser configurado a partir do menu, configurado no arquivo de opções \${rc_path} ou iniciado usando o \"parâmetro\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} na linha de comando. Mais informações sobre a customização de opções no Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["RUSSIAN",626]="Начиная с версии airgeddon 9.20, поддерживается tmux и он может использоваться вместо xterm в качестве обработчика окон. Скрипт может быть запущен в автономной среде без графической системы X Window. Рекомендуется только для опытных пользователей. Как и любой другой параметр, его можно настроить в меню параметров, в файле параметров \${rc_path} или запустить с помощью \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} \"flag\" в командной строке. Больше информации о настройке опций на Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["GREEK",626]="Από την έκδοση 9.20 του airgeddon, υποστηρίζεται το tmux και μπορεί να χρησιμοποιηθεί αντί του xterm ως χειριστής παραθύρων. Το script μπορεί να εκκινηθεί σε headless περιβάλλον χωρίς γραφικό σύστημα παραθύρου X. Συνιστάται μόνο για προχωρημένους χρήστες. Όπως και κάθε άλλη επιλογή, μπορεί να ρυθμιστεί στο μενού επιλογών, στο αρχείο επιλογών \${rc_path} ή να εκκινηθεί χρησιμοποιώντας το \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} στη γραμμή εντολών. Περισσότερες πληροφορίες σχετικά με την προσαρμογή των επιλογών στο Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["ITALIAN",626]="A partire dalla versione 9.20 di airgeddon, tmux è supportato e può essere usato al posto di xterm come gestore di finestre. È possibile avviare lo script in un ambiente senza un sistema grafico di finestre X. È consigliato solo per utenti esperti. Come qualsiasi altra opzione, può essere configurata dal menu delle opzioni, configurata nel file delle opzioni \${rc_path} o avviata utilizzando il \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} dalla linea di comando. Maggiori informazioni sulla personalizzazione delle opzioni nella Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["POLISH",626]="Począwszy od wersji 9.20 airgeddon, tmux jest obsługiwany i może być używany zamiast xterm jako menedżer okien. Skrypt można uruchomić w środowisku bez systemu graficznego X window. Zalecany jest tylko dla zaawansowanych użytkowników. Jak każdą inna opcję, można ją skonfigurować z menu, w pliku opcji \${rc_path} lub uruchomić za pomocą \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} w wierszu poleceń. Więcej informacji na temat dostosowywania opcji w Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["GERMAN",626]="Ab airgeddon Version 9.20 wird tmux unterstützt und kann anstelle von xterm als Fenstermanager verwendet werden. Sie können das Skript in einer Umgebung ohne Grafiksystem von X-Fenstern starten, es wird nur für fortgeschrittene Benutzer empfohlen. Wie jede andere Option kann sie über das Optionsmenü konfiguriert werden, in der Optionsdatei \${rc_path} konfiguriert oder mit dem \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} in der Befehlszeile gestartet werden. Weitere Informationen zur Anpassung der Optionen im Wiki: \${normal_color}\${urlgithub_wiki}/Options"
	arr["TURKISH",626]="airgeddon'un 9.20 sürümünden itibaren, tmux destekleniyor ve bir pencere yöneticisi olarak xterm yerine kullanılabilir. Senaryoyu X windows grafik sistemine sahip olmayan bir ortamda başlatabilirsiniz, sadece ileri düzey kullanıcılar için önerilir. Diğer seçeneklerde olduğu gibi, seçenekler menüsünden yapılandırılabilir, \${rc_path} seçenekler dosyasında yapılandırılabilir veya komut satırında \"flag\" \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} kullanılarak başlatılabilir. Wiki'deki seçeneklerin özelleştirilmesi hakkında daha fazla bilgi: \${normal_color}\${urlgithub_wiki}/Options"
	arr["ARABIC",626]="\${normal_color}\${urlgithub_wiki}/Options \${pink_color}:في سطر الأوامر. مزيد من المعلومات حول تخصيص الخيارات في \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} \"flag\" أو تشغيله باستخدام \${rc_path} ومن المستحسن إستخدامه من طرف للمستخدمين المتقدمين. مثل أي خيار آخر ، يمكن تهيئه من قائمة الخيارات ، في ملف الخيارات  .X Windows كمدير نوافذ. يمكنك تشغيل البرنامج النصي في بيئة بدون نظام رسومات xterm ويمكن استخدامه بدلاً من tmux يتم دعم ، airgeddon 9.20 من الإصدار\${normal_color}"
	arr["CHINESE",626]="从 airgeddon 9.20 版开始支持 tmux，可以使用它代替 xterm 作为窗口处理程序。脚本可以在没有图形 X11 界面系统的命令行界面中启动。仅建议高级用户使用。与任何其他选项一样，它可以在选项菜单上配置，在 \${rc_path} 选项文件中或在命令行中使用 \${normal_color}AIRGEDDON_WINDOWS_HANDLING\${pink_color} \"flag\" 启动。有关该脚本选项自定义的更多信息: \${normal_color}\${urlgithub_wiki}/Options"

	arr["ENGLISH",627]="certificates"
	arr["SPANISH",627]="certificados"
	arr["FRENCH",627]="certificats"
	arr["CATALAN",627]="certificats"
	arr["PORTUGUESE",627]="certificados"
	arr["RUSSIAN",627]="сертификаты"
	arr["GREEK",627]="πιστοποιητικά"
	arr["ITALIAN",627]="certificati"
	arr["POLISH",627]="certyfikaty"
	arr["GERMAN",627]="Zertifikate"
	arr["TURKISH",627]="sertifikalar"
	arr["ARABIC",627]="الشهادات"
	arr["CHINESE",627]="证书"

	arr["ENGLISH",628]="5.  Create custom certificates"
	arr["SPANISH",628]="5.  Crear certificados personalizados"
	arr["FRENCH",628]="5.  Créer des certificats personnalisés"
	arr["CATALAN",628]="5.  Crear certificats personalitzats"
	arr["PORTUGUESE",628]="5.  Criar certificados personalizados"
	arr["RUSSIAN",628]="5.  Создать пользовательские сертификаты"
	arr["GREEK",628]="5.  Δημιουργία προσαρμοσμένων πιστοποιητικών"
	arr["ITALIAN",628]="5.  Creare certificati personalizzati"
	arr["POLISH",628]="5.  Tworzenie niestandardowych certyfikatów"
	arr["GERMAN",628]="5.  Benutzerdefinierte Zertifikate erstellen"
	arr["TURKISH",628]="5.  Özel sertifika oluştur"
	arr["ARABIC",628]="5.  إنشاء شهادات مخصصة"
	arr["CHINESE",628]="5. 创建自定义证书"

	arr["ENGLISH",629]="Generating custom certificates, we will make our attack to an enterprise network more credible"
	arr["SPANISH",629]="Generando certificados personalizados, haremos más creíble nuestro ataque a una red enterprise"
	arr["FRENCH",629]="En générant des certificats personnalisés, notre attaque contre un réseau entreprise será plus crédible"
	arr["CATALAN",629]="Generant certificats personalitzats, farem més creïble el nostre atac a una xarxa enterprise"
	arr["PORTUGUESE",629]="Gerando certificados personalizados tornaremos o ataque a uma rede corporativa mais confiável"
	arr["RUSSIAN",629]="Создавая собственные сертификаты, мы сделаем нашу атаку на корпоративную сеть более надёжной"
	arr["GREEK",629]="Δημιουργώντας προσαρμοσμένα πιστοποιητικά, θα κάνουμε την επίθεσή μας σε ένα επιχειρηματικό δίκτυο πιο αξιόπιστη"
	arr["ITALIAN",629]="Generando certificati personalizzati, renderemo più credibile il nostro attacco a una rete enterprise"
	arr["POLISH",629]="Generując niestandardowe certyfikaty sprawimy, że nasz atak na sieć firmową stanie się bardziej wiarygodny"
	arr["GERMAN",629]="Indem wir benutzerdefinierte Zertifikate generieren, werden wir unseren Angriff auf ein Unternehmensnetzwerk glaubwürdiger machen"
	arr["TURKISH",629]="Özel sertifikalar üreterek, kurumsal bir ağa saldırımızı daha güvenilir hale getireceğiz"
	arr["ARABIC",629]="أكثر مصداقية enterprise عند إنشاء شهادات مخصصة ، سنجعل هجومنا على شبكة"
	arr["CHINESE",629]="生成自定义证书，我们将使我们对企业级加密的网络的攻击更加可信"

	arr["ENGLISH",630]="Enter two letter country code (US, ES, FR):"
	arr["SPANISH",630]="Introduce las dos letras del código de país (US, ES, FR):"
	arr["FRENCH",630]="Entrez les deux lettres du code de pays (US, ES, FR):"
	arr["CATALAN",630]="Introduïu el codi de país de dues lletres (US, ES, FR):"
	arr["PORTUGUESE",630]="Digite o código de duas letras do país (US, ES, FR):"
	arr["RUSSIAN",630]="Введите двухбуквенный код страны (US, ES, FR):"
	arr["GREEK",630]="Εισάγετε τον κωδικό χώρας δύο χαρακτήρων (US, ES, FR):"
	arr["ITALIAN",630]="Inserisci le due lettere del codice del paese (US, ES, FR):"
	arr["POLISH",630]="Wpisz dwuliterowy kod kraju (US, ES, FR):"
	arr["GERMAN",630]="Den zweistelligen Ländercode eingeben (US, ES, FR):"
	arr["TURKISH",630]="İki harfli ülke kodunu giriniz (US, ES, FR):"
	arr["ARABIC",630]=":(US, ES, FR) أدخل رمز البلد المكون من حرفين"
	arr["CHINESE",630]="请输入两个字母的国家代码 (如: US(美国), ES(西班牙), CN(中国)):"

	arr["ENGLISH",631]="Enter state or province (Madrid, New Jersey):"
	arr["SPANISH",631]="Introduce el estado o provincia (Madrid, New Jersey):"
	arr["FRENCH",631]="Entrez l'état ou la province (Madrid, New Jersey):"
	arr["CATALAN",631]="Introduïu l’estat o la província (Madrid, New Jersey):"
	arr["PORTUGUESE",631]="Digite o estado ou a província (Madrid, New Jersey):"
	arr["RUSSIAN",631]="Введите штат или провинцию (Madrid, New Jersey):"
	arr["GREEK",631]="Εισάγετε κράτος ή επαρχία (Madrid, New Jersey):"
	arr["ITALIAN",631]="Inserisci lo stato o la provincia (Madrid, New Jersey):"
	arr["POLISH",631]="Wpisz stan lub prowincję (Madrid, New Jersey):"
	arr["GERMAN",631]="Bundesstaat oder Provinz eingeben (Madrid, New Jersey):"
	arr["TURKISH",631]="Eyalet veya ilinizi giriniz (Madrid, New Jersey):"
	arr["ARABIC",631]=":أدخل الولاية أو المقاطعة (مدريد ، نيو جيرسي)"
	arr["CHINESE",631]="请输入州或省 (如: 马德里、新泽西州):"

	arr["ENGLISH",632]="Enter locale (Hong Kong, Dublin):"
	arr["SPANISH",632]="Introduce el lugar (Hong Kong, Dublin):"
	arr["FRENCH",632]="Entrez le lieu (Hong Kong, Dublin):"
	arr["CATALAN",632]="Introduïu el lloc (Hong Kong, Dublin):"
	arr["PORTUGUESE",632]="Digite a localidade (Hong Kong, Dublin):"
	arr["RUSSIAN",632]="Введите язык (Hong Kong, Dublin):"
	arr["GREEK",632]="Εισάγετε την τοποθεσία συμβάντος (Hong Kong, Dublin):"
	arr["ITALIAN",632]="Inserisci la localitá (Hong Kong, Dublin):"
	arr["POLISH",632]="Wpisz ustawienia regionalne (Hong Kong, Dublin):"
	arr["GERMAN",632]="Lokale eingeben (Hong Kong, Dublin):"
	arr["TURKISH",632]="Yerel ayarı girin (Hong Kong, Dublin):"
	arr["ARABIC",632]=":أدخل الموقع (هونج كونج ، دبلن)"
	arr["CHINESE",632]="请输入语言环境 (如: 香港、都柏林):"

	arr["ENGLISH",633]="Enter organization name (Evil Corp):"
	arr["SPANISH",633]="Introduce el nombre de la empresa (Evil Corp):"
	arr["FRENCH",633]="Entrez le nom de l'entreprise (Evil Corp):"
	arr["CATALAN",633]="Introduïu el nom de l'organització (Evil Corp):"
	arr["PORTUGUESE",633]="Digite o nome da organização (Evil Corp):"
	arr["RUSSIAN",633]="Введите название организации (Evil Corp):"
	arr["GREEK",633]="Εισάγετε το όνομα του οργανισμού (Evil Corp):"
	arr["ITALIAN",633]="Inserisci il nome dell'organizzazione (Evil Corp):"
	arr["POLISH",633]="Wpisz nazwę organizacji (Evil Corp):"
	arr["GERMAN",633]="Organisationsname eingeben (Evil Corp):"
	arr["TURKISH",633]="Kuruluş adını girin (Evil Corp):"
	arr["ARABIC",633]=":(Evil Corp) أدخل اسم المنظمة"
	arr["CHINESE",633]="请输入组织名称 (Evil Corp):"

	arr["ENGLISH",634]="Enter email (tyrellwellick@ecorp.com):"
	arr["SPANISH",634]="Introduce un correo electrónico (tyrellwellick@ecorp.com):"
	arr["FRENCH",634]="Entrez l'email (tyrellwellick@ecorp.com):"
	arr["CATALAN",634]="Introduïu el correu electrònic (tyrellwellick@ecorp.com):"
	arr["PORTUGUESE",634]="Digite o email (tyrellwellick@ecorp.com):"
	arr["RUSSIAN",634]="Введите адрес электронной почты (tyrellwellick@ecorp.com):"
	arr["GREEK",634]="Εισάγετε το email (tyrellwellick@ecorp.com):"
	arr["ITALIAN",634]="Inserisci l'email (tyrellwellick@ecorp.com):"
	arr["POLISH",634]="Wpisz adres e-mail (tyrellwellick@ecorp.com):"
	arr["GERMAN",634]="E-Mail eingeben (tyrellwellick@ecorp.com):"
	arr["TURKISH",634]="E-posta adresini girin (tyrellwellick@ecorp.com):"
	arr["ARABIC",634]=":(tyrellwellick@ecorp.com) أدخل البريد الإلكتروني"
	arr["CHINESE",634]="请输入电子邮件 (如: tyrellwellick@ecorp.com):"

	arr["ENGLISH",635]="Enter the \"common name\" (CN) for cert (ecorp.com):"
	arr["SPANISH",635]="Introduce el \"common name\" (CN) del certificado (ecorp.com):"
	arr["FRENCH",635]="Entrez le \"common name\" (CN) du certificat (ecorp.com):"
	arr["CATALAN",635]="Introduïu \"common name\" (CN) per cert (ecorp.com):"
	arr["PORTUGUESE",635]="Digite o \"common name\" (CN) para o certificado (ecorp.com):"
	arr["RUSSIAN",635]="Введите \"common name\" (CN) для сертификата (ecorp.com):"
	arr["GREEK",635]="Εισάγετε \"common name\" (CN) για cert (ecorp.com):"
	arr["ITALIAN",635]="Inserisci il \"common name\" (CN) del certificato (ecorp.com):"
	arr["POLISH",635]="Wpisz \"common name\" (CN) dla cert (ecorp.com):"
	arr["GERMAN",635]="Eingabe \"common name\" (CN) eingeben (ecorp.com):"
	arr["TURKISH",635]="Bir \"common name\" (CN) girin (ecorp.com):"
	arr["ARABIC",635]="(ecorp.com) للشهادة \"common name\" (CN) أدخل"
	arr["CHINESE",635]="请输入证书 (如: ecorp.com) 的“通用名称”(CN):"

	arr["ENGLISH",636]="There is an error in your configuration. Please check the \${rc_path} file. You have enabled the option to force the use of mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) but your system doesn't have mdk3 installed. Disable this option or install mdk3 to fix the problem"
	arr["SPANISH",636]="Hay un error en tu configuración. Por favor revisa el fichero \${rc_path}. Has activado la opción para forzar el uso de mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) pero tu sistema no tiene mdk3 instalado. Deshabilita esta opción o instala mdk3 para solucionar el problema"
	arr["FRENCH",636]="Il y a une erreur dans votre configuration. Veuillez vérifier le fichier \${rc_path}. Vous avez activé l'option pour forcer l'utilisation de mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) mais mdk3 n'est pas installé sur votre système. Désactivez cette option ou installez mdk3 pour résoudre le problème"
	arr["CATALAN",636]="Hi ha un error en la configuració. Si us plau comprova el fitxer \${rc_path}. Has activat l'opció per forçar l'ús d'mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) però el teu sistema no té mdk3 instal·lat. Deshabilita aquesta opció o instal·la mdk3 per solucionar el problema"
	arr["PORTUGUESE",636]="Existe um erro na sua configuração. Por favor, verifique o arquivo \${rc_path}. Você ativou a opção para forçar o uso de mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}), mas seu sistema não possui o mdk3 instalado. Desabilite esta opção ou instale o mdk3 para resolver o problema"
	arr["RUSSIAN",636]="В вашей конфигурации имеется ошибка. Пожалуйста, проверьте файл \${rc_path}. Вы включили опцию принудительного использования mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}), но в вашей системе не установлена mdk3. Отключите эту опцию или установите mdk3, чтобы исправить проблему"
	arr["GREEK",636]="Υπάρχει ένα σφάλμα στο configuration σας. Παρακαλώ ελέγξτε το αρχείο \${rc_path}. Έχετε ενεργοποιήσει την επιλογή που εξαναγκάζει τη χρήση του mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) αλλά το σύστημά σας δεν έχει το mdk3 εγκατεστημένο. Απενεργοποιήστε την επιλογή αυτή ή εγκαταστήστε το mdk3 για να επιλυθεί το πρόβλημα"
	arr["ITALIAN",636]="C'è un errore nella tua configurazione. Per favore controlla il file \${rc_path}. Hai attivato l'opzione per forzare l'uso di mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) ma il tuo sistema non ha mdk3 installato. Disabilita questa opzione o installa mdk3 per risolvere il problema"
	arr["POLISH",636]="Wystąpił błąd konfiguracji. Sprawdź plik \${rc_path}. Aktywowałeś opcję wymuszania użycia mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}), ale twój system nie ma zainstalowanego mdk3. Wyłącz tę opcję lub zainstaluj mdk3, aby rozwiązać problem"
	arr["GERMAN",636]="Ein Fehler wurde in Ihren Einstellungen gefunden. Bitte überprüfen Sie die Datei \${rc_path}. Sie haben die Option aktiviert, um die Verwendung von mdk3 zu erzwingen (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}), aber auf Ihrem System ist mdk3 nicht installiert. Deaktivieren Sie diese Option oder installieren Sie mdk3, um dieses Problem zu lösen"
	arr["TURKISH",636]="Yapılandırmanızda bir hata var. Lütfen \${rc_path} dosyasını kontrol edin. (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) mdk3 kullanımını zorlama seçeneğini etkinleştirdiniz, ancak sisteminizde mdk3 kurulu değil. Bu seçeneği devre dışı bırakın veya sorunu çözmek için mdk3 yükleyin"
	arr["ARABIC",636]="لإصلاح المشكلة mdk3 على نظامك. قم بتعطيل هذا الخيار أو قم بتثبيت mdk3 ولكن لم يتم تثبيت (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) mdk3 لقد قمت بتفعيل خيار فرض استخدام .\${rc_path} هناك خطأ في التكوين الخاص بك. يرجى التحقق من ملف"
	arr["CHINESE",636]="您的配置有错误。请检查 \${rc_path} 文件。您已启用强制使用 mdk3 (\${normal_color}AIRGEDDON_MDK_VERSION\${red_color}) 的选项，但您的系统未安装 mdk3。禁用此选项或安装 mdk3 以解决问题"

	arr["ENGLISH",637]="11. Set mdk version to mdk3"
	arr["SPANISH",637]="11. Cambiar versión mdk a mdk3"
	arr["FRENCH",637]="11. Changer la version de mdk en mdk3"
	arr["CATALAN",637]="11. Canviar versió mdk a mdk3"
	arr["PORTUGUESE",637]="11. Mudar a versão do mdk para o mdk3"
	arr["RUSSIAN",637]="11. Изменить версию mdk на mdk3"
	arr["GREEK",637]="11. Αλλάξτε την έκδοση mdk σε mdk3"
	arr["ITALIAN",637]="11. Cambiare la versione di mdk in mdk3"
	arr["POLISH",637]="11. Zmień wersję mdk na mdk3"
	arr["GERMAN",637]="11. Von mdk-Version zu mdk3 wechseln"
	arr["TURKISH",637]="11. mdk sürümünü mdk3 olarak değiştir"
	arr["ARABIC",637]="11. mdk3 على mdk قم بتعيين إصدار"
	arr["CHINESE",637]="11. 设置 mdk 版本为 mdk3"

	arr["ENGLISH",638]="11. Set mdk version to mdk4"
	arr["SPANISH",638]="11. Cambiar versión mdk a mdk4"
	arr["FRENCH",638]="11. Changer la version de mdk en mdk4"
	arr["CATALAN",638]="11. Canviar versió mdk a mdk4"
	arr["PORTUGUESE",638]="11. Mudar a versão do mdk para o mdk4"
	arr["RUSSIAN",638]="11. Изменить версию mdk на mdk4"
	arr["GREEK",638]="11. Αλλάξτε την έκδοση mdk σε mdk4"
	arr["ITALIAN",638]="11. Cambiare la versione di mdk in mdk4"
	arr["POLISH",638]="11. Zmień wersję mdk na mdk4"
	arr["GERMAN",638]="11. Von mdk-Version zu mdk4 wechseln"
	arr["TURKISH",638]="11. mdk sürümünü mdk4 olarak değiştirin"
	arr["ARABIC",638]="11. mdk4 على mdk قم بتعيين إصدار"
	arr["CHINESE",638]="11. 设置 mdk 版本为 mdk4"

	arr["ENGLISH",639]="\${blue_color}mdk version is going to be changed. \${green_color}Do you want to continue? \${normal_color}\${visual_choice}"
	arr["SPANISH",639]="\${blue_color}Se