/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.analysis;

public class PunctuationQueryHelper {
    public static String translate(String input) {
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            int c = input.codePointAt(i);
            if (escaped) {
                PunctuationQueryHelper.write(escaped, c, buffer);
                escaped = false;
                continue;
            }
            if (PunctuationQueryHelper.isEscapeChar(c)) {
                escaped = true;
                continue;
            }
            PunctuationQueryHelper.write(escaped, c, buffer);
        }
        if (escaped) {
            buffer.append(" \\ ");
        }
        return buffer.toString().trim().replace("  ", " ");
    }

    private static void write(boolean escaped, int c, StringBuilder buffer) {
        if (escaped && PunctuationQueryHelper.isOperator(c)) {
            PunctuationQueryHelper.append(escaped, true, c, buffer);
        } else if (PunctuationQueryHelper.isPunctuation(c) && !PunctuationQueryHelper.isOperator(c)) {
            PunctuationQueryHelper.append(escaped, true, c, buffer);
        } else {
            if (escaped) {
                buffer.append(" \\ ");
            }
            buffer.append(Character.toChars(c));
        }
    }

    private static void append(boolean escaped, boolean space, int c, StringBuilder buffer) {
        if (space) {
            buffer.append(' ');
        }
        if (escaped) {
            buffer.append('\\');
        }
        buffer.append(Character.toChars(c));
        if (space) {
            buffer.append(' ');
        }
    }

    private static boolean isEscapeChar(int c) {
        return c == 92;
    }

    private static boolean isPunctuation(int c) {
        return !Character.isLetterOrDigit(c) && !Character.isWhitespace(c);
    }

    private static boolean isOperator(int c) {
        return c == 43 || c == 45 || c == 33 || c == 40 || c == 41 || c == 58 || c == 94 || c == 91 || c == 93 || c == 34 || c == 123 || c == 125 || c == 126 || c == 42 || c == 63 || c == 124 || c == 38 || c == 47;
    }
}

