/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.utils.bean;

import com.pinkmatter.utils.bean.ObjectIntrospector;
import java.text.Format;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Templater {
    private final String _template;
    private ArrayList<FormatGroup> _groups;
    private String _placeholderString;
    private static final Pattern PATTERN = Pattern.compile("(\\{.+?\\})");

    public Templater(String template) {
        this(template, null);
    }

    public Templater(String template, Format format) {
        this._template = template;
        this.parse(format);
    }

    private void parse(Format format) {
        Matcher matcher = PATTERN.matcher(this._template);
        this._groups = new ArrayList();
        StringBuffer placeholderString = new StringBuffer();
        while (matcher.find()) {
            FormatGroup group = FormatGroup.parse(matcher.group());
            group.setFormat(format);
            this._groups.add(group);
            matcher.appendReplacement(placeholderString, "%s");
        }
        matcher.appendTail(placeholderString);
        this._placeholderString = placeholderString.toString();
    }

    public String format(Object obj) {
        Object[] formatted = new Object[this._groups.size()];
        int i = 0;
        for (FormatGroup group : this._groups) {
            Object value = group.getQuery().get(obj);
            formatted[i] = group.format(value);
            ++i;
        }
        return String.format(this._placeholderString, formatted);
    }

    private static class FormatGroup {
        private final String _formatString;
        private Format _format;
        private final String _default;
        private final ObjectIntrospector.Query _query;
        private static final Pattern PATTERN = Pattern.compile("\\{(.+?)(:(.*?))?(:(.*?))?\\}");

        public FormatGroup(ObjectIntrospector.Query var, String formatString, String defaultValue) {
            this._query = var;
            this._formatString = formatString;
            this._default = defaultValue;
        }

        public String getFormatString() {
            return this._formatString;
        }

        public Format getFormat() {
            return this._format;
        }

        public void setFormat(Format format) {
            this._format = format;
        }

        public String getDefault() {
            return this._default;
        }

        public ObjectIntrospector.Query getQuery() {
            return this._query;
        }

        public String format(Object value) {
            if (value == null) {
                return this._default;
            }
            if (this._format != null) {
                return this._format.format(value);
            }
            return String.format(Locale.US, this._formatString, value);
        }

        public static FormatGroup parse(String stringGroup) {
            Matcher matcher = PATTERN.matcher(stringGroup);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid group format - group must be enclosed in curly brackets and must contain a variable name.");
            }
            String formatString = matcher.group(3);
            if (formatString == null || formatString.trim().isEmpty()) {
                formatString = "%s";
            }
            ObjectIntrospector.Query var = ObjectIntrospector.Query.parse(matcher.group(1));
            return new FormatGroup(var, formatString, matcher.group(5));
        }
    }
}

