/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api.inheritance;

import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.MaltegoPartSpec;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.entity.api.inheritance.InheritanceCache;
import com.paterva.maltego.entity.api.inheritance.MultiInheritanceAdapter;
import com.paterva.maltego.entity.api.inheritance.RegistryInheritanceProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupCollection;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.GroupSet;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.ToolboxItemSpec;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class InheritanceHelper {
    private InheritanceHelper() {
    }

    public static <T extends TypeSpec> PropertyDescriptor getValueProperty(SpecRegistry<T> registry, TypedPropertyBag bag, boolean getFirstStringFallBack) {
        PropertyDescriptor valuePd = InheritanceHelper.getValueProperty(registry, bag.getTypeName());
        if (valuePd == null && (valuePd = bag.getValueProperty()) == null) {
            if (getFirstStringFallBack) {
                valuePd = InheritanceHelper.getFirstStringProperty(bag.getProperties());
            }
            if (valuePd == null) {
                valuePd = InheritanceHelper.createValueProperty(bag);
            }
        }
        return valuePd;
    }

    public static <T extends TypeSpec> Optional<PropertyDescriptor> getDisplayValueProperty(SpecRegistry<T> registry, TypedPropertyBag bag) {
        String dispExpr = InheritanceHelper.getDisplayValueExpression(registry, bag);
        return Optional.ofNullable(bag.getProperties().get(dispExpr));
    }

    public static <T extends TypeSpec> Optional<PropertyDescriptor> getDisplayValueProperty(SpecRegistry<T> registry, String typeName) {
        TypeSpec spec = registry.get(typeName);
        if (spec == null) {
            return Optional.empty();
        }
        return InheritanceHelper.getDisplayValueExpression(registry, typeName).map(dispExpr -> spec.getProperties().get(dispExpr));
    }

    public static <T extends TypeSpec> String getDisplayValueExpression(SpecRegistry<T> registry, TypedPropertyBag bag) {
        return bag.getDisplayValueExpression().map(Optional::of).orElseGet(() -> InheritanceHelper.getDisplayValueExpression(registry, bag.getTypeName())).orElseGet(() -> InheritanceHelper.getValueProperty(registry, bag, true).getName());
    }

    public static Optional<String> getImageExpression(EntityRegistry registry, MaltegoEntity entity) {
        return entity.getNonBlankImageExpression().map(Optional::of).orElseGet(() -> InheritanceHelper.getImageExpression(registry, entity.getTypeName()));
    }

    public static <T extends TypeSpec> Object getValue(SpecRegistry<T> registry, TypedPropertyBag bag) {
        return bag.getValue(InheritanceHelper.getValueProperty(registry, bag, true));
    }

    public static <T extends TypeSpec> String getDisplayString(SpecRegistry<T> registry, TypedPropertyBag bag) {
        String dispVal;
        String dispExpr = InheritanceHelper.getDisplayValueExpression(registry, bag);
        PropertyDescriptor property = bag.getProperties().get(dispExpr);
        if (property != null) {
            Object value = bag.getValue(property);
            dispVal = Converter.convertTo((Object)value, (Class)property.getType());
            if (dispVal == null) {
                dispVal = "";
            }
        } else {
            Evaluator.Replacement evaluator = new Evaluator.Replacement();
            dispVal = evaluator.evaluate(dispExpr, (DataSource)bag);
        }
        return dispVal;
    }

    public static Optional<Object> getImageKey(EntityRegistry registry, MaltegoEntity entity) {
        Object imgKey = null;
        Optional<String> imgExprOpt = InheritanceHelper.getImageExpression(registry, entity);
        if (imgExprOpt.isPresent()) {
            String imgExpr = imgExprOpt.get();
            PropertyDescriptor property = entity.getProperties().get(imgExpr);
            if (property != null) {
                imgKey = entity.getValue(property);
                if (imgKey instanceof String && StringUtils.isBlank((CharSequence)((String)imgKey))) {
                    imgKey = null;
                }
            } else {
                Evaluator.Replacement evaluator = new Evaluator.Replacement();
                imgKey = evaluator.evaluate(imgExpr, (DataSource)entity);
            }
        }
        if (imgKey instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)imgKey))) {
                imgKey = null;
            } else if (FastURL.isFastURL((String)((String)imgKey))) {
                imgKey = new FastURL((String)imgKey);
            }
        }
        return Optional.ofNullable(imgKey);
    }

    public static <T extends TypeSpec> void setValue(SpecRegistry<T> registry, TypedPropertyBag bag, Object value) {
        PropertyDescriptor pd = InheritanceHelper.getValueProperty(registry, bag, true);
        bag.setValue(pd, value);
    }

    public static <T extends TypeSpec> boolean isValueProperty(SpecRegistry<T> registry, TypedPropertyBag bag, PropertyDescriptor pd) {
        return InheritanceHelper.namesEqual(pd, InheritanceHelper.getValueProperty(registry, bag, true));
    }

    public static <T extends TypeSpec> boolean isDisplayValueProperty(SpecRegistry<T> registry, TypedPropertyBag bag, PropertyDescriptor pd) {
        if (pd == null) {
            return false;
        }
        String dispExpr = InheritanceHelper.getDisplayValueExpression(registry, bag);
        String propName = pd.getName();
        return Objects.equals(propName, dispExpr);
    }

    public static boolean isImageProperty(EntityRegistry registry, MaltegoEntity entity, PropertyDescriptor pd) {
        if (pd == null) {
            return false;
        }
        Optional<String> imgExprOpt = InheritanceHelper.getImageExpression(registry, entity);
        if (!imgExprOpt.isPresent()) {
            return false;
        }
        String imgExpr = imgExprOpt.get();
        String propName = pd.getName();
        return Objects.equals(propName, imgExpr);
    }

    public static <T extends TypeSpec> String getValueString(SpecRegistry<T> registry, TypedPropertyBag bag) {
        PropertyDescriptor pd = InheritanceHelper.getValueProperty(registry, bag, true);
        String value = null;
        if (pd != null) {
            value = Converter.convertTo((Object)bag.getValue(pd), (Class)pd.getType());
        }
        return value != null ? value : "";
    }

    public static <T extends TypeSpec, ID extends Guid> DisplayDescriptorCollection getAggregatedProperties(SpecRegistry<T> registry, GraphPart<ID> part) {
        return InheritanceHelper.getAggregatedProperties(registry, GraphStoreHelper.getPart(part).getTypeName());
    }

    public static <T extends TypeSpec> DisplayDescriptorCollection getAggregatedProperties(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
        LinkedHashSet properties = new LinkedHashSet();
        for (String specTypeName : inheritance) {
            TypeSpec spec = registry.get(specTypeName);
            if (spec == null) continue;
            properties.addAll(spec.getProperties());
        }
        return new DisplayDescriptorList(properties);
    }

    public static <T extends TypeSpec, ID extends Guid> GroupDefinitions getAggregatedPropertyGroups(SpecRegistry<T> registry, GraphPart<ID> part) {
        return InheritanceHelper.getAggregatedPropertyGroups(registry, GraphStoreHelper.getPart(part).getTypeName());
    }

    public static <T extends TypeSpec> GroupDefinitions getAggregatedPropertyGroups(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        ArrayList<String> inheritance = new ArrayList<String>(InheritanceHelper.getInheritanceList(registry, typeName));
        GroupSet groups = new GroupSet();
        GroupSet superGroups = new GroupSet();
        Collections.reverse(inheritance);
        for (String specTypeName : inheritance) {
            TypeSpec spec = registry.get(specTypeName);
            if (spec == null) continue;
            GroupDefinitions propertyGroups = spec.getPropertyGroups();
            for (Group group : propertyGroups.getTopLevelGroups()) {
                groups.add(group);
            }
            for (Group group : propertyGroups.getTopLevelSuperGroups()) {
                superGroups.add(group);
            }
        }
        return new GroupDefinitions((GroupCollection)groups, (GroupCollection)superGroups);
    }

    public static OverlayDescriptorSet superLoadOverlays(EntityRegistry registry, String typeName) {
        OverlayDescriptorSet overlays = new OverlayDescriptorSet();
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
        inheritance.stream().map(specName -> (MaltegoEntitySpec)registry.get((String)specName)).filter(Objects::nonNull).map(spec -> spec.getOverlaySet()).filter(Objects::nonNull).forEach(superOverlays -> overlays.addAll((Collection)superOverlays));
        return overlays;
    }

    public static <T extends TypeSpec> List<String> getInheritanceList(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        MultiInheritanceAdapter<String> mia = new MultiInheritanceAdapter<String>(new RegistryInheritanceProvider(registry));
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName, mia);
        return Collections.unmodifiableList(inheritance);
    }

    public static <T extends TypeSpec> List<String> getInheritedList(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        MultiInheritanceAdapter<String> mia = new MultiInheritanceAdapter<String>(new RegistryInheritanceProvider(registry));
        TreeMap<Integer, ArrayList<String>> typesMap = new TreeMap<Integer, ArrayList<String>>();
        for (TypeSpec typeSpec : registry.getAll()) {
            String typeSpecName = typeSpec.getTypeName();
            List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeSpecName, mia);
            if (!inheritance.contains(typeName)) continue;
            int depth = inheritance.size();
            ArrayList<String> inheritedTypes = (ArrayList<String>)typesMap.get(depth);
            if (inheritedTypes == null) {
                inheritedTypes = new ArrayList<String>();
                typesMap.put(depth, inheritedTypes);
            }
            inheritedTypes.add(typeSpecName);
        }
        ArrayList<String> sortedInheritedTypes = new ArrayList<String>();
        for (Map.Entry entry : typesMap.entrySet()) {
            List types = (List)entry.getValue();
            sortedInheritedTypes.addAll(types);
        }
        Collections.reverse(sortedInheritedTypes);
        return sortedInheritedTypes;
    }

    public static EntityConverter getConverter(EntityRegistry registry, MaltegoEntity entity, String text, PropertyDescriptor valuePd) {
        if (registry == null) {
            return null;
        }
        List<String> inherited = InheritanceHelper.getInheritanceList(registry, entity.getTypeName());
        EntityConverter converter = null;
        for (String specName : inherited) {
            EntityConverter c;
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(specName);
            if (spec == null || (c = spec.getConverter()) == null || !c.canConvertFrom(text, valuePd) || converter != null && c.getPriority() >= converter.getPriority()) continue;
            converter = c;
        }
        return converter;
    }

    public static <T extends TypeSpec> Collection<SpecActionDescriptor> getAggregatedActions(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
        HashMap<String, SpecActionDescriptor> actions = new HashMap<String, SpecActionDescriptor>();
        for (String specTypeName : inheritance) {
            MaltegoPartSpec partSpec;
            List<SpecActionDescriptor> specActions;
            TypeSpec spec = registry.get(specTypeName);
            if (!(spec instanceof MaltegoPartSpec) || (specActions = (partSpec = (MaltegoPartSpec)spec).getActions()) == null) continue;
            for (SpecActionDescriptor specAction : specActions) {
                if (actions.containsKey(specAction.getName())) continue;
                actions.put(specAction.getName(), specAction);
            }
        }
        return actions.values();
    }

    private static PropertyDescriptor getFirstStringProperty(PropertyDescriptorCollection pdc) {
        for (PropertyDescriptor pd : pdc) {
            if (!String.class.equals((Object)pd.getType())) continue;
            return pd;
        }
        return null;
    }

    public static <T extends TypeSpec> PropertyDescriptor getValueProperty(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        PropertyDescriptor valuePd = InheritanceCache.getValueProperty(registry, typeName);
        if (valuePd == null) {
            List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
            for (String inheritedSpecName : inheritance) {
                TypeSpec spec = registry.get(inheritedSpecName);
                if (!(spec instanceof ToolboxItemSpec) || (valuePd = ((ToolboxItemSpec)spec).getValueProperty()) == null) continue;
                InheritanceCache.setValueProperty(registry, typeName, valuePd);
                break;
            }
        }
        return valuePd;
    }

    public static <T extends TypeSpec> Optional<String> getDisplayValueExpression(SpecRegistry<T> registry, String typeName) {
        if (registry == null) {
            return null;
        }
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
        return inheritance.stream().map(inheritedSpecName -> registry.get(inheritedSpecName)).filter(Objects::nonNull).filter(spec -> spec instanceof ToolboxItemSpec).map(spec -> (ToolboxItemSpec)spec).map(ToolboxItemSpec::getDisplayValueExpression).filter(StringUtils::isNotBlank).findFirst();
    }

    public static Optional<String> getImageExpression(EntityRegistry registry, String typeName) {
        if (registry == null) {
            return null;
        }
        List<String> inheritance = InheritanceHelper.getInheritanceList(registry, typeName);
        return inheritance.stream().map(inheritedSpecName -> (MaltegoEntitySpec)registry.get((String)inheritedSpecName)).filter(Objects::nonNull).map(MaltegoEntitySpec::getImageExpression).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static PropertyDescriptor createValueProperty(TypedPropertyBag bag) {
        String propName = InheritanceHelper.getUniquePropertyName(bag.getProperties(), "properties.temp");
        DisplayDescriptor dd = new DisplayDescriptor(String.class, propName, "Temp");
        bag.addProperty((PropertyDescriptor)dd);
        bag.setValueProperty((PropertyDescriptor)dd);
        return dd;
    }

    private static String getUniquePropertyName(PropertyDescriptorCollection pdc, String proposedName) {
        ArrayList<String> propNames = new ArrayList<String>(pdc.size());
        for (PropertyDescriptor pd : pdc) {
            propNames.add(pd.getName());
        }
        return StringUtilities.createUniqueString(propNames, (String)proposedName);
    }

    private static boolean namesEqual(PropertyDescriptor pd1, PropertyDescriptor pd2) {
        if (pd1 != null && pd2 != null) {
            return pd1.getName().equals(pd2.getName());
        }
        return false;
    }

    private static <T extends TypeSpec> List<String> getInheritanceList(SpecRegistry<T> registry, String typeName, MultiInheritanceAdapter<String> mia) {
        List<String> inheritance = InheritanceCache.getInheritanceList(registry, typeName);
        if (inheritance == null) {
            inheritance = mia.getTopologicalInheritanceList(typeName);
            InheritanceCache.setInheritanceList(registry, typeName, inheritance);
        }
        return inheritance;
    }
}

