/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.impl;

import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

public class SimpleX509TrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOG = Logger.getLogger(SimpleX509TrustManager.class.getName());
    private X509ExtendedTrustManager _delegate;
    private boolean _allowAllCerts;
    private String _requireInCN;
    private boolean _attachCertAction = false;

    public SimpleX509TrustManager(X509ExtendedTrustManager delegate) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this(delegate, true, false);
    }

    public SimpleX509TrustManager(X509ExtendedTrustManager delegate, boolean trustAll, boolean attachCertAction) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        LOG.log(Level.FINE, "{0} New Trust Manager - trust all: {1}", new Object[]{this.getHash(), trustAll});
        this._allowAllCerts = trustAll;
        this._delegate = delegate;
        this._attachCertAction = attachCertAction;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this._delegate.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (!this._allowAllCerts) {
            boolean simpleCheckFailed = false;
            LOG.log(Level.FINE, "{0} Check server trusted: {1}", new Object[]{this.getHash(), authType});
            try {
                this._delegate.checkServerTrusted(chain, authType, socket);
                if (this._requireInCN != null && !CertificateUtils.checkSubject(chain, this._requireInCN)) {
                    LOG.log(Level.FINE, "{0} Invalid subject", new Object[]{this.getHash()});
                    simpleCheckFailed = true;
                    throw new CertificateException("Invalid subject, required: " + this._requireInCN);
                }
            }
            catch (CertificateException excep) {
                LOG.log(Level.FINE, "{0} Cert NOT trusted", new Object[]{this.getHash()});
                if (this._attachCertAction && simpleCheckFailed) {
                    excep = CertificateUtils.attachCertActionToException(CertificateTrustHandler.CertificateActions.BLOCK, excep);
                }
                throw excep;
            }
            LOG.log(Level.FINE, "{0} Cert trusted", new Object[]{this.getHash()});
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this._delegate.getAcceptedIssuers();
    }

    public boolean trustAllCerts() {
        return this._allowAllCerts;
    }

    public void setTrustAllCerts(boolean allowAllCerts) {
        this._allowAllCerts = allowAllCerts;
        LOG.log(Level.FINE, "{0} Trust all certs: {1}", new Object[]{this.getHash(), allowAllCerts});
    }

    public String getRequireInCN() {
        return this._requireInCN;
    }

    public void setRequireInCN(String requireInSubject) {
        this._requireInCN = requireInSubject;
        LOG.log(Level.FINE, "{0} Required in CN: {1}", new Object[]{this.getHash(), requireInSubject});
    }

    private String getHash() {
        return LOG.isLoggable(Level.FINE) ? Integer.toString(System.identityHashCode(this), 36).toUpperCase() : "";
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this._delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string, Socket socket) throws CertificateException {
        this._delegate.checkClientTrusted(xcs, string, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string, SSLEngine ssle) throws CertificateException {
        this._delegate.checkClientTrusted(xcs, string, ssle);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String string, SSLEngine ssle) throws CertificateException {
        this._delegate.checkServerTrusted(xcs, string, ssle);
    }
}

