/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.nodes.MergeEntitiesController;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class MergeAction
extends TopGraphEntitySelectionAction {
    private static final String PREF_MERGE_LINKS = "mergeActionMergeSimilarLinks";

    public MergeAction() {
        this.putValue("position", 400);
    }

    @Override
    protected void actionPerformed() {
        GraphID graphID = this.getTopGraphID();
        if (graphID == null) {
            return;
        }
        String user = GraphUser.getUser(graphID);
        Set<EntityID> modelEntityIDs = this.getSelectedModelEntities();
        MergeEntitiesController controller = new MergeEntitiesController(graphID, modelEntityIDs);
        EditDialogDescriptor dd = new EditDialogDescriptor("Select Primary Entity", (WizardDescriptor.Panel)controller);
        boolean mergeLinks = NbPreferences.forModule(MergeAction.class).getBoolean(PREF_MERGE_LINKS, true);
        dd.putProperty("mergeSimilarLinks", (Object)mergeLinks);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            try {
                MaltegoEntity primaryEntity = (MaltegoEntity)dd.getProperty("primaryEntity");
                mergeLinks = (Boolean)dd.getProperty("mergeSimilarLinks");
                NbPreferences.forModule(MergeAction.class).putBoolean(PREF_MERGE_LINKS, mergeLinks);
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                EntitiesDataQuery query = new EntitiesDataQuery();
                query.setIDs(modelEntityIDs);
                Collection modelEntities = dataReader.getEntities(query).values();
                modelEntities.remove(primaryEntity);
                int count = modelEntities.size() + 1;
                MaltegoEntity primaryEntityBefore = primaryEntity.createClone();
                MaltegoEntity primaryEntityAfter = primaryEntity.createClone();
                Set modelEntitiesToRemove = GraphStoreHelper.getIds(modelEntities);
                Set modelLinksToRemove = structureReader.getLinks(modelEntityIDs);
                HashMap<MaltegoLink, LinkEntityIDs> linksToAdd = new HashMap<MaltegoLink, LinkEntityIDs>();
                HashMap<MaltegoLink, MaltegoLink> linksToModify = new HashMap<MaltegoLink, MaltegoLink>();
                for (MaltegoEntity entity : modelEntities) {
                    PartMergeStrategy.PreferOriginal.merge((MaltegoPart)primaryEntityAfter, (MaltegoPart)entity);
                }
                Iterator itr = modelLinksToRemove.iterator();
                while (itr.hasNext()) {
                    LinkID linkID = (LinkID)itr.next();
                    MaltegoLink link = dataReader.getLink(linkID);
                    EntityID sourceID = structureReader.getSource(linkID);
                    EntityID targetID = structureReader.getTarget(linkID);
                    if (modelEntitiesToRemove.contains(sourceID)) {
                        sourceID = (EntityID)primaryEntity.getID();
                    }
                    if (modelEntitiesToRemove.contains(targetID)) {
                        targetID = (EntityID)primaryEntity.getID();
                    }
                    if (sourceID.equals((Object)targetID)) continue;
                    MaltegoLink matchLink = null;
                    if (mergeLinks) {
                        matchLink = this.getMatchedLink(graphStore, sourceID, targetID, link);
                        if (matchLink == null) {
                            matchLink = this.getMatchedLink(linksToAdd, sourceID, targetID, link);
                        }
                        if (matchLink != null) {
                            MaltegoLink linkToModifyAfter = null;
                            for (Map.Entry entry : linksToModify.entrySet()) {
                                MaltegoLink linkToModifyBefore = (MaltegoLink)entry.getKey();
                                if (!linkToModifyBefore.equals(matchLink)) continue;
                                matchLink = linkToModifyBefore;
                                linkToModifyAfter = (MaltegoLink)entry.getValue();
                                break;
                            }
                            if (linkToModifyAfter == null) {
                                linkToModifyAfter = matchLink.createClone();
                            }
                            PartMergeStrategy.PreferOriginal.merge((MaltegoPart)linkToModifyAfter, (MaltegoPart)link);
                            MaltegoLink matchLinkClone = matchLink.createClone();
                            if (!linkToModifyAfter.isCopy((MaltegoPart)matchLinkClone)) {
                                ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)linkToModifyAfter);
                            }
                            linksToModify.put(matchLinkClone, linkToModifyAfter);
                            itr.remove();
                        }
                    }
                    if (matchLink != null) continue;
                    linksToAdd.put(link.createCopy(), new LinkEntityIDs(sourceID, targetID));
                }
                if (!primaryEntityAfter.isCopy((MaltegoPart)primaryEntityBefore)) {
                    ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)primaryEntityAfter);
                }
                Map<MaltegoEntity, MaltegoEntity> entityToModify = Collections.singletonMap(primaryEntityBefore, primaryEntityAfter);
                SimilarStrings description = new SimilarStrings("%s " + count + " entities", "Merge", "Unmerge");
                GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
                batch.add(GraphTransactions.deleteEntitiesAndLinks(modelEntitiesToRemove, modelLinksToRemove));
                if (!linksToAdd.isEmpty()) {
                    batch.add(GraphTransactions.addEntitiesAndLinks(Collections.emptySet(), linksToAdd, Collections.emptyMap(), false, false));
                }
                batch.addAll(GraphTransactionHelper.createUpdateTransactions(entityToModify, linksToModify));
                GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
                GraphSelection.forGraph((GraphID)graphID).setSelectedModelEntities(Collections.singleton(primaryEntity.getID()));
                StatusDisplayer.getDefault().setStatusText(count + " entities merged");
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private MaltegoLink getMatchedLink(GraphStore graphStore, EntityID sourceID, EntityID targetID, MaltegoLink link) throws GraphStoreException {
        MaltegoLink matchLink = null;
        Collection<MaltegoLink> possibleMatchLinks = this.getBetweenLinks(graphStore, sourceID, targetID);
        for (MaltegoLink possibleMatchLink : possibleMatchLinks) {
            if (!this.isMatch(possibleMatchLink, link)) continue;
            matchLink = possibleMatchLink;
            break;
        }
        return matchLink;
    }

    private MaltegoLink getMatchedLink(Map<MaltegoLink, LinkEntityIDs> linksToAdd, EntityID sourceID, EntityID targetID, MaltegoLink link) {
        MaltegoLink matchLink = null;
        for (Map.Entry<MaltegoLink, LinkEntityIDs> entry : linksToAdd.entrySet()) {
            MaltegoLink linkToAdd = entry.getKey();
            LinkEntityIDs linkEntities = entry.getValue();
            boolean sameSource = linkEntities.getSourceID().equals((Object)sourceID);
            boolean sameTarget = linkEntities.getTargetID().equals((Object)targetID);
            if (!sameSource || !sameTarget || !this.isMatch(linkToAdd, link)) continue;
            matchLink = linkToAdd;
            break;
        }
        return matchLink;
    }

    private boolean isMatch(MaltegoLink dest, MaltegoLink src) {
        int match = MatchingRule.Default.getMatch((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)dest, (TypedPropertyBag)src);
        return -1 != match;
    }

    private Collection<MaltegoLink> getBetweenLinks(GraphStore graphStore, EntityID sourceID, EntityID targetID) throws GraphStoreException {
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        HashSet<EntityID> entities = new HashSet<EntityID>();
        entities.add(sourceID);
        entities.add(targetID);
        Set linksBetween = structureReader.getLinksBetween(entities);
        LinksDataQuery query = new LinksDataQuery();
        query.setIDs(linksBetween);
        return dataReader.getLinks(query).values();
    }

    public String getName() {
        return "Merge";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/Merge.png";
    }
}

