/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AddToPaletteAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        this.getNewDescriptors(this.getActivatedNodes());
    }

    protected boolean enable(Node[] nodes) {
        Node[] activated = this.getActivatedNodes();
        if (activated.length > 0) {
            return this.getNewDescriptors(activated).size() > 0;
        }
        return false;
    }

    protected void addToRegistry(Collection<MaltegoEntitySpec> specs) {
        EntityRegistry registry = EntityRegistry.getDefault();
        for (MaltegoEntitySpec spec : specs) {
            registry.put((TypeSpec)spec);
        }
    }

    protected Collection<MaltegoEntitySpec> getNewDescriptors(Node[] nodes) {
        EntityRegistry registry = EntityRegistry.getDefault();
        ArrayList<MaltegoEntitySpec> specs = new ArrayList<MaltegoEntitySpec>();
        for (Node node : nodes) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)node.getLookup().lookup(MaltegoEntitySpec.class);
            if (spec == null || registry.contains(spec.getTypeName())) continue;
            specs.add(spec);
        }
        return specs;
    }

    public String getName() {
        return "Add to palette";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

