/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details.links;

import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.util.List;

public class TabularTransformLinksTableModel
extends RowTableModel<TabularTransform> {
    public static final String[] COLUMNS = new String[]{"Generated Transforms"};
    private final TabularTransformSource transformSource;

    public TabularTransformLinksTableModel(TabularTransformSource transformSource) {
        super(COLUMNS, TabularTransformLinksTableModel.getTransforms(transformSource));
        this.transformSource = transformSource;
    }

    public Object getValueFor(TabularTransform transform, int column) {
        switch (column) {
            case 0: {
                return transform.getTransformDisplayName(this.transformSource);
            }
        }
        throw new IllegalArgumentException("No column for index: " + column);
    }

    public void removeRow(int index) {
        this.removeRows(new int[]{index});
    }

    public void removeRows(int[] indices) {
        List transforms = this.getRows(indices);
        this.remove(transforms);
    }

    private void remove(List<TabularTransform> transforms) {
        Args.notNull(transforms, (String)"transforms");
        TabularTransformSourceRepository.getInstance().update((Object)this.transformSource.removeTabularTransforms(transforms));
    }

    private static List<TabularTransform> getTransforms(TabularTransformSource transformSource) {
        Args.notNull((Object)transformSource, (String)"transformSource");
        return transformSource.getTabularTransforms();
    }
}

