/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.inputs;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.runner.api.TransformInputProvider;
import com.paterva.maltego.transform.runner.api.TransformServerMap;
import com.paterva.maltego.transform.runner.inputs.DisclaimerControl;
import com.paterva.maltego.transform.runner.inputs.DisclaimerResult;
import com.paterva.maltego.transform.runner.inputs.LatchedDataSource;
import com.paterva.maltego.transform.runner.inputs.TransformInputsForm;
import com.paterva.maltego.transform.runner.inputs.WebApiKeyHelper;
import com.paterva.maltego.tx.inputs.global.registry.DefaultGlobalTransformInputsRepository;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.HeaderControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class DefaultTransformInputProvider
extends TransformInputProvider {
    private final Map<String, Object> _factorySettings = new TreeMap<String, Object>();

    public DefaultTransformInputProvider() {
        this._factorySettings.put("showDescriptions", Boolean.TRUE);
        this._factorySettings.put("useRequiredFieldColor", Boolean.FALSE);
    }

    public Map<TransformDefinition, DataSource> getInputs(TransformServerMap transformServerMap) {
        Dialog d;
        Map txs = transformServerMap.getMap();
        HashSet transforms = new HashSet(txs.keySet());
        Map<TransformDefinition, DataSource> apiKeys = WebApiKeyHelper.getWebApiKeys(transforms);
        if (apiKeys == null) {
            return null;
        }
        if (txs.size() > transforms.size()) {
            HashSet<TransformDefinition> transformsToRemove = new HashSet<TransformDefinition>();
            for (TransformDefinition transform : txs.keySet()) {
                if (transforms.contains(transform)) continue;
                transformsToRemove.add(transform);
            }
            transformServerMap.removeTransforms(transformsToRemove);
        }
        DataSource globalInputs = GlobalTransformInputsRepository.getDefault().getData();
        HashMap<TransformDefinition, DataSource> datas = new HashMap<TransformDefinition, DataSource>(apiKeys.size());
        for (TransformDefinition transform : transforms) {
            DataSource data = apiKeys.get(transform);
            data = data == null ? globalInputs : new DataSources.Proxy(new DataSource[]{data, globalInputs});
            datas.put(transform, data);
        }
        final HashMap<TransformDefinition, DataSource> results = datas;
        final HashMap<TransformDefinition, DisclaimerResult> disclaimers = new HashMap<TransformDefinition, DisclaimerResult>();
        final TransformInputsForm form = this.createPopupControl(transforms, results, disclaimers);
        if (form == null) {
            return results;
        }
        Dimension size = form.getScrollPane().getPreferredSize();
        form.getScrollPane().setVerticalScrollBarPolicy(20);
        form.getScrollPane().setPreferredSize(new Dimension(size.width + form.getScrollPane().getVerticalScrollBar().getWidth(), Math.min(size.height, 500)));
        form.getScrollPane().getVerticalScrollBar().setUnitIncrement(16);
        JButton run = new JButton("Run!");
        run.setActionCommand("OK");
        JButton cancel = new JButton("Cancel");
        final Dialog[] holder = new Dialog[1];
        final boolean[] resultHolder = new boolean[1];
        DialogDescriptor dd = new DialogDescriptor((Object)form, "Required inputs", true, new Object[]{run, cancel}, (Object)run, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dialog dlg = holder[0];
                if ("OK".equals(e.getActionCommand())) {
                    if (DefaultTransformInputProvider.this.checkSettings(results, disclaimers)) {
                        DefaultTransformInputProvider.this.saveSettings(results, disclaimers, form.rememberSettings());
                        resultHolder[0] = true;
                        dlg.setVisible(false);
                    } else {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)DefaultTransformInputProvider.this.getFirstError(results, disclaimers), 2);
                        nd.setTitle("Input required");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                } else {
                    resultHolder[0] = false;
                    dlg.setVisible(false);
                }
            }
        });
        holder[0] = d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (resultHolder[0]) {
            return results;
        }
        return null;
    }

    private boolean checkSettings(Map<TransformDefinition, DataSource> results, Map<TransformDefinition, DisclaimerResult> disclaimers) {
        return this.getFirstError(results, disclaimers) == null;
    }

    private String getFirstError(Map<TransformDefinition, DataSource> results, Map<TransformDefinition, DisclaimerResult> disclaimers) {
        for (TransformDefinition def : results.keySet()) {
            DisclaimerResult accepted;
            DataSource settings = results.get(def);
            for (DisplayDescriptor prop : def.getPopupProperties(settings)) {
                Object value = settings.getValue((PropertyDescriptor)prop);
                if (prop.isNullable() || !StringUtilities.isNullString((Object)value)) continue;
                return "Transform '" + def.getDisplayName() + "' requires input for setting '" + prop.getDisplayName() + "'";
            }
            if (!this.needDisclaimer(def) || (accepted = disclaimers.get(def)) != null && accepted.isAccepted()) continue;
            return "Please accept the disclaimer for transform '" + def.getDisplayName() + "'";
        }
        return null;
    }

    private void saveSettings(Map<TransformDefinition, DataSource> results, Map<TransformDefinition, DisclaimerResult> disclaimers, boolean saveSettings) {
        for (TransformDefinition def : results.keySet()) {
            DisclaimerResult accepted;
            if (saveSettings) {
                DataSource settings = results.get(def);
                GlobalTransformInputsRepository repo = DefaultGlobalTransformInputsRepository.getDefault();
                for (DisplayDescriptor prop : def.getProperties()) {
                    def.setPopup((PropertyDescriptor)prop, Popup.No);
                    Object value = settings.getValue((PropertyDescriptor)prop);
                    if (value == null) continue;
                    def.setValue((PropertyDescriptor)prop, value);
                    GlobalTransformInput input = repo.get(prop.getName());
                    if (input == null) continue;
                    repo.getData().setValue((PropertyDescriptor)input.getDescriptor(), value);
                }
            }
            if ((accepted = disclaimers.get(def)) != null) {
                def.setDisclaimerAccepted(accepted.isAccepted());
            }
            if (!def.isDirty()) continue;
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            TransformRepository repository = registry.getRepository(def.getRepositoryName());
            repository.updateSettings(def);
        }
    }

    private TransformInputsForm createPopupControl(Collection<? extends TransformDefinition> transforms, Map<TransformDefinition, DataSource> results, Map<TransformDefinition, DisclaimerResult> disclaimers) {
        final TransformInputsForm form = new TransformInputsForm();
        boolean empty = true;
        Iterator<? extends TransformDefinition> iterator = transforms.iterator();
        while (iterator.hasNext()) {
            TransformDefinition def;
            Object dataSource = results.get(def = iterator.next());
            dataSource = dataSource != null ? new DataSources.Proxy(new DataSource[]{dataSource, def}) : def;
            DisplayDescriptorCollection popups = def.getPopupProperties(dataSource);
            if (popups.size() <= 0 && !this.needDisclaimer(def)) continue;
            dataSource = new LatchedDataSource((DataSource)dataSource);
            results.put(def, (DataSource)dataSource);
            empty = false;
            JXCollapsiblePane cp = new JXCollapsiblePane();
            cp.setLayout((LayoutManager)new BorderLayout());
            Action toggleAction = cp.getActionMap().get("toggle");
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            Color cpBg = laf.getColor("transform-manager-lowlight-bg");
            HeaderControl header = new HeaderControl(toggleAction, (Border)new MatteBorder(0, 0, 1, 0, cpBg), (HeaderControl.ActionCallback)null);
            toggleAction.putValue("Name", def.getDisplayName());
            toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon"));
            toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon"));
            if (popups.size() > 0) {
                Component content = this.createContentControl((DataSource)dataSource, popups);
                content.setBackground(laf.getColor("transform-manager-lowlight-bg"));
                cp.add(content, (Object)"North");
            }
            if (this.needDisclaimer(def)) {
                DisclaimerResult disclaimerResult = new DisclaimerResult(def.isDisclaimerAccepted());
                disclaimers.put(def, disclaimerResult);
                DisclaimerControl disclaimer = new DisclaimerControl(def.getDisclaimer(), disclaimerResult);
                disclaimer.setBackground(laf.getColor("transform-manager-lowlight-bg"));
                cp.add((Component)disclaimer, (Object)"South");
                final JScrollPane disclaimerScrollPane = disclaimer.getScrollPane();
                disclaimerScrollPane.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        int extent = disclaimerScrollPane.getVerticalScrollBar().getModel().getExtent();
                        if (disclaimerScrollPane.getVerticalScrollBar().getValue() + extent >= disclaimerScrollPane.getVerticalScrollBar().getMaximum() || disclaimerScrollPane.getVerticalScrollBar().getValue() <= disclaimerScrollPane.getVerticalScrollBar().getMinimum()) {
                            form.getContentPane().dispatchEvent(e);
                        }
                    }
                });
            }
            cp.getContentPane().setBackground(cpBg);
            EmptyBorder cpBorder = new EmptyBorder(0, 6, 6, 6);
            cp.setBorder((Border)cpBorder);
            form.getContentPane().add((Component)header);
            form.getContentPane().add((Component)cp);
        }
        if (empty) {
            return null;
        }
        return form;
    }

    private boolean needDisclaimer(TransformDefinition def) {
        return def.getDisclaimer() != null && !def.getDisclaimer().isEmpty() && !def.isDisclaimerAccepted();
    }

    private Component createContentControl(DataSource ds, DisplayDescriptorCollection popups) {
        Component component = ComponentFactories.form(this._factorySettings).createEditingComponent(ds, (DisplayDescriptorEnumeration)popups, null);
        return component;
    }
}

