/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.drawing;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.ActionRegistry;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineInputs;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.PropertyBag;
import com.paterva.maltego.automation.PropertySupport;
import com.paterva.maltego.automation.actions.AbstractFilter;
import com.paterva.maltego.automation.actions.ActionDocumentationProvider;
import com.paterva.maltego.automation.actions.ActionEntityProvider;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.GraphBuilder;
import java.util.Collection;
import java.util.Set;

public class DrawingActionRegistry
extends ActionRegistry {
    private final ActionEntityProvider _entityProvider;
    private final ActionDocumentationProvider _documentationProvider = new ActionDocumentationProvider();
    private boolean _ignoreInfoActions = true;
    private static final String INFO_ACTION_TYPE = "maltego.MachineInfoAction";
    private static final String GLOBAL_INPUT_TYPE = "maltego.MachineGlobalInput";
    private static final String PROP_NAME = "name";
    private static final String PROP_FULL_NAME = "action";

    public DrawingActionRegistry() {
        this._entityProvider = new ActionEntityProvider();
    }

    @Override
    public Action get(String name) {
        ActionRegistry registry = ActionRegistry.getDefault();
        Action delegate = registry.get(name);
        return new DrawAction(delegate);
    }

    public boolean isIgnoreInfoActions() {
        return this._ignoreInfoActions;
    }

    public void setIgnoreInfoActions(boolean ignoreInfoActions) {
        this._ignoreInfoActions = ignoreInfoActions;
    }

    private class DrawAction
    implements Action,
    PropertyBag {
        private final Action _delegate;

        public DrawAction(Action delegate) {
            this._delegate = delegate;
        }

        @Override
        public String getName() {
            return String.format("%s(%s)", this.getSimpleName(), this.getDelegateName());
        }

        @Override
        public String getSimpleName() {
            return "draw";
        }

        private String getDelegateName() {
            if (this._delegate == null) {
                return "unknown";
            }
            return this._delegate.toString();
        }

        private String getDelegateSimpleName() {
            if (this._delegate == null) {
                return "unknown";
            }
            return this._delegate.getSimpleName();
        }

        @Override
        public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
            try {
                String entityType = DrawingActionRegistry.this._entityProvider.getEntityType(this._delegate);
                if (entityType != null) {
                    if (DrawingActionRegistry.INFO_ACTION_TYPE.equals(entityType) && DrawingActionRegistry.this._ignoreInfoActions) {
                        cb.completed(payload);
                    } else {
                        cb.completed(Payloads.fromEntities(this.addActionEntity(ctx.getTargetGraphID(), entityType, payload)));
                    }
                } else {
                    cb.completed(Payloads.EMPTY);
                }
            }
            catch (TypeInstantiationException ex) {
                cb.failed("Could not create entity of type maltego.MachineAction", (Exception)((Object)ex));
            }
        }

        private MaltegoEntity addActionEntity(GraphID graphID, String entityType, Payload payload) throws TypeInstantiationException {
            GraphBuilder builder = new GraphBuilder(graphID);
            MaltegoEntity entity = builder.addEntity(entityType, this.getDelegateName());
            builder.setProperty(entity, DrawingActionRegistry.PROP_NAME, (Object)this.getDelegateSimpleName());
            builder.setProperty(entity, DrawingActionRegistry.PROP_FULL_NAME, (Object)this.getDelegateName());
            this.addProperties(builder, this._delegate, entity);
            Collection links = builder.connect(payload.getEntities(), entity);
            if (this.useWholeGraphAsInput()) {
                MaltegoEntity global = builder.addEntity(DrawingActionRegistry.GLOBAL_INPUT_TYPE, "Full Graph");
                builder.connect(global, entity);
                for (MaltegoLink link : links) {
                    link.setStyle(Integer.valueOf(1));
                }
            }
            return entity;
        }

        private boolean useWholeGraphAsInput() {
            if (this._delegate instanceof AbstractFilter) {
                AbstractFilter filter = (AbstractFilter)this._delegate;
                return filter.useWholeGraphAsInput();
            }
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public InitializationContext initialize(Payload initialPayload) {
            return InitializationContext.getEmpty();
        }

        @Override
        public MachineInput getInputDescriptor() {
            if (this._delegate != null) {
                return this._delegate.getInputDescriptor();
            }
            return MachineInputs.passThrough();
        }

        private void addProperties(GraphBuilder builder, Action delegate, MaltegoEntity entity) {
            PropertySupport ps;
            Set<String> names;
            if (delegate instanceof PropertySupport && (names = (ps = (PropertySupport)((Object)delegate)).getPropertyNames()) != null) {
                for (String property : names) {
                    Object value = ps.getProperty(property);
                    builder.setProperty(entity, property, value);
                }
            }
        }

        private PropertyBag getPropertyBag() {
            if (this._delegate instanceof PropertyBag) {
                return (PropertyBag)((Object)this._delegate);
            }
            return null;
        }

        @Override
        public Object getProperty(String name, Object defaultValue) {
            PropertyBag pb = this.getPropertyBag();
            if (pb == null) {
                return defaultValue;
            }
            return pb.getProperty(name, defaultValue);
        }

        @Override
        public void putProperty(String name, Object value) {
            PropertyBag pb = this.getPropertyBag();
            if (pb != null) {
                pb.putProperty(name, value);
            }
        }

        @Override
        public void setValue(Object value) {
            PropertyBag pb = this.getPropertyBag();
            if (pb != null) {
                pb.setValue(value);
            }
        }

        @Override
        public Object getValue() {
            PropertyBag pb = this.getPropertyBag();
            if (pb == null) {
                return null;
            }
            return pb.getValue();
        }
    }
}

