/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.pws.ServiceIconProvider;
import com.paterva.maltego.pws.imex.SelectableService;
import com.paterva.maltego.pws.imex.ServiceExistInfo;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class ServiceNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public ServiceNode(String serviceType, SelectableService service, ServiceExistInfo existInfo) {
        this(serviceType, service, new InstanceContent(), existInfo);
    }

    private ServiceNode(String serviceType, SelectableService service, InstanceContent content, ServiceExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, service);
        String displayName = service.getService().getName();
        if (existInfo != null && existInfo.exist(serviceType, service.getService())) {
            if (existInfo.isReadOnly(serviceType, service.getService())) {
                displayName = "<read-only> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        this.setShortDescription("");
        this.setSelectedNonRecursive(service.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableService service) {
        content.add((Object)service);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableService service = (SelectableService)this.getLookup().lookup(SelectableService.class);
            service.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        SelectableService service = (SelectableService)this.getLookup().lookup(SelectableService.class);
        return ServiceIconProvider.getIcon(service.getService()).getImage();
    }
}

