/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PartCache {
    private static final Logger LOG = Logger.getLogger(PartCache.class.getName());
    private final Map<String, Map<List<Object>, MaltegoEntity>> _entities = new HashMap<String, Map<List<Object>, MaltegoEntity>>();
    private int _foundEntities = 0;
    private int _notFoundEntities = 0;

    MaltegoEntity getEntityFromCache(TabularGraphEntity tableEntity, List<Object> rowValues) {
        List<Object> entityValues = this.getPartValues((PropertyToColumnMap)tableEntity, rowValues);
        Map<List<Object>, MaltegoEntity> entitiesForType = this._entities.get(tableEntity.getEntitySpecName());
        MaltegoEntity entity = null;
        if (entitiesForType != null) {
            entity = entitiesForType.get(entityValues);
        }
        if (entity != null) {
            ++this._foundEntities;
        } else {
            ++this._notFoundEntities;
        }
        LOG.log(Level.FINE, "Entities found: {0}, Not found: {1}", new Object[]{this._foundEntities, this._notFoundEntities});
        return entity;
    }

    void addEntity(TabularGraphEntity tableEntity, List<Object> rowValues, MaltegoEntity entity) {
        List<Object> entityValues = this.getPartValues((PropertyToColumnMap)tableEntity, rowValues);
        String specName = tableEntity.getEntitySpecName();
        Map<List<Object>, MaltegoEntity> entitiesForType = this._entities.get(specName);
        if (entitiesForType == null) {
            entitiesForType = new HashMap<List<Object>, MaltegoEntity>();
            this._entities.put(specName, entitiesForType);
        }
        entitiesForType.put(entityValues, entity);
    }

    private List<Object> getPartValues(PropertyToColumnMap map, List<Object> rowValues) {
        ArrayList<Object> partValues = new ArrayList<Object>();
        for (int column : map.getColumns()) {
            Object value = this.getValue(column, rowValues);
            partValues.add(value);
        }
        return partValues;
    }

    private Object getValue(int column, List<Object> rowValues) {
        Object value = null;
        if (column < rowValues.size()) {
            value = rowValues.get(column);
        }
        if (StringUtilities.isNullString(value)) {
            value = null;
        }
        return value;
    }
}

