/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.UnsafeRunnable;
import org.openide.util.Exceptions;

public class ExceptionUtilities {
    public static void catchAll(UnsafeRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String toDescriptiveOneLiner(Throwable t) {
        StackTraceElement[] stackTrace;
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName());
        sb.append(": ");
        sb.append(t.getMessage());
        for (StackTraceElement element : stackTrace = t.getStackTrace()) {
            if (element == null || element.getFileName() == null) continue;
            sb.append(" (");
            sb.append(element.getFileName());
            sb.append(":");
            int lineNumber = element.getLineNumber();
            sb.append(lineNumber >= 0 ? Integer.valueOf(lineNumber) : "<unknown>");
            sb.append(")");
            break;
        }
        return sb.toString();
    }
}

