/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static Color darker(Color color, int amount) {
        return ColorUtilities.brighter(color, -amount);
    }

    public static Color brighter(Color color, int amount) {
        return ColorUtilities.brighterTranslucent(color, amount, 255);
    }

    public static Color brighterTranslucent(Color color, int amount, int alpha) {
        int r = color.getRed() + amount;
        int b = color.getBlue() + amount;
        int g = color.getGreen() + amount;
        int a = alpha;
        if (a < 0) {
            a = 0;
        }
        if (a > 255) {
            a = 255;
        }
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        return new Color(r, g, b, a);
    }

    public static Color darkerTranslucent(Color color, int amount, int alpha) {
        return ColorUtilities.brighterTranslucent(color, -amount, alpha);
    }

    public static Color makeTranslucent(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color decode(String s) {
        if (s == null || s.isEmpty()) {
            return Color.black;
        }
        return Color.decode(s);
    }

    public static String encode(Color c) {
        char[] buf = new char[7];
        buf[0] = 35;
        String s = Integer.toHexString(c.getRed());
        if (s.length() == 1) {
            buf[1] = 48;
            buf[2] = s.charAt(0);
        } else {
            buf[1] = s.charAt(0);
            buf[2] = s.charAt(1);
        }
        s = Integer.toHexString(c.getGreen());
        if (s.length() == 1) {
            buf[3] = 48;
            buf[4] = s.charAt(0);
        } else {
            buf[3] = s.charAt(0);
            buf[4] = s.charAt(1);
        }
        s = Integer.toHexString(c.getBlue());
        if (s.length() == 1) {
            buf[5] = 48;
            buf[6] = s.charAt(0);
        } else {
            buf[5] = s.charAt(0);
            buf[6] = s.charAt(1);
        }
        return String.valueOf(buf);
    }

    public static Color invert(Color c) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbvals);
        int invertColor = Color.HSBtoRGB(1.0f - hsbvals[0], hsbvals[1], hsbvals[2]);
        return new Color(invertColor);
    }

    public static double getColorDistance(Color c1, Color c2) {
        int red1 = c1.getRed();
        int red2 = c2.getRed();
        int rmean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return Math.sqrt(((512 + rmean) * r * r >> 8) + 4 * g * g + ((767 - rmean) * b * b >> 8));
    }

    public static String getColorTone(Color color) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return ColorUtilities.getColorTone(hsb);
    }

    public static String getColorTone(int rgb) {
        float[] hsb = new float[3];
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        return ColorUtilities.getColorTone(hsb);
    }

    public static String getColorTone(float[] hsb) {
        float deg;
        String colorTone = (double)hsb[1] < 0.1 && (double)hsb[2] > 0.9 ? "nearlyWhite" : ((double)hsb[2] < 0.1 ? "nearlyBlack" : ((deg = hsb[0] * 360.0f) >= 0.0f && deg < 30.0f ? "red" : (deg >= 30.0f && deg < 90.0f ? "yellow" : (deg >= 90.0f && deg < 150.0f ? "green" : (deg >= 150.0f && deg < 210.0f ? "cyan" : (deg >= 210.0f && deg < 270.0f ? "blue" : (deg >= 270.0f && deg < 330.0f ? "magenta" : "red")))))));
        return colorTone;
    }

    public static Color getXorColor(Color c1, Color c2) {
        int[] c1Array = new int[3];
        int[] c2Array = new int[3];
        c1Array[0] = c1.getRed();
        c1Array[1] = c1.getGreen();
        c1Array[2] = c1.getBlue();
        c2Array[0] = c2.getRed();
        c2Array[1] = c2.getGreen();
        c2Array[2] = c2.getBlue();
        for (int i = 0; i < 3; ++i) {
            int n = i;
            c1Array[n] = c1Array[n] ^ c2Array[i];
        }
        return new Color(c1Array[0], c1Array[1], c1Array[2]);
    }

    public static Color getSelectionColor(Color bg, Color selectionColorDefault, Color selectionColorNew) {
        Color xorColor = ColorUtilities.getXorColor(bg, selectionColorDefault);
        String xorColorString = ColorUtilities.getColorTone(xorColor);
        if (!xorColorString.equalsIgnoreCase("blue")) {
            selectionColorNew = xorColor;
        }
        return selectionColorNew;
    }

    private static class XorContext
    implements CompositeContext {
        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int w = Math.min(src.getWidth(), dstIn.getWidth());
            int h = Math.min(src.getHeight(), dstIn.getHeight());
            int[] srcRgbaTest = new int[]{-50, -50, -50, -50};
            int[] dstRgbaTest = new int[]{-50, -50, -50, -50};
            int mSrc = src.getPixel(0, 0, srcRgbaTest)[3];
            int mDst = dstIn.getPixel(0, 0, dstRgbaTest)[3];
            mSrc = mSrc == -50 ? 3 : 4;
            mDst = mDst == -50 ? 3 : 4;
            int[] srcRgba = new int[4 * w];
            int[] dstRgba = new int[4 * w];
            for (int y = 0; y < h; ++y) {
                src.getPixels(0, y, w, 1, srcRgba);
                dstIn.getPixels(0, y, w, 1, dstRgba);
                for (int x = 0; x < w; ++x) {
                    int m1 = x * mSrc;
                    int m2 = x * mDst;
                    for (int i = 0; i < 3; ++i) {
                        int n = m2 + i;
                        dstRgba[n] = dstRgba[n] ^ srcRgba[m1 + i];
                    }
                }
                dstOut.setPixels(0, y, w, 1, dstRgba);
            }
        }

        @Override
        public void dispose() {
        }
    }

    public static class XorComposite
    implements Composite {
        public static XorComposite INSTANCE = new XorComposite();
        private final XorContext context = new XorContext();

        @Override
        public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
            return this.context;
        }
    }
}

