/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class JSTrimWhitespaceNode
extends JavaScriptBaseNode {
    private final ConditionProfile isFastNonWhitespace = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isFastWhitespace = ConditionProfile.createBinaryProfile();

    public static JSTrimWhitespaceNode create() {
        return JSTrimWhitespaceNodeGen.create();
    }

    public abstract String executeString(String var1);

    protected boolean startsOrEndsWithWhitespace(String string) {
        assert (string.length() > 0);
        return this.isWhiteSpace(string, 0) || this.isWhiteSpace(string, string.length() - 1);
    }

    @Specialization(guards={"string.length() == 0"})
    protected String doStringZero(String string) {
        return string;
    }

    @Specialization(guards={"string.length() > 0", "!startsOrEndsWithWhitespace(string)"})
    protected String doStringNoWhitespace(String string) {
        return string;
    }

    @Specialization(guards={"string.length() > 0", "startsOrEndsWithWhitespace(string)"})
    protected String doString(String string, @Cached(value="create()") BranchProfile needFirstBranch, @Cached(value="create()") BranchProfile needLastBranch, @Cached(value="createBinaryProfile()") ConditionProfile needSubstring) {
        int len = string.length();
        int firstIdx = 0;
        if (this.isWhiteSpace(string, 0)) {
            needFirstBranch.enter();
            firstIdx = JSRuntime.firstNonWhitespaceIndex(string, false);
        }
        int lastIdx = len - 1;
        if (this.isWhiteSpace(string, len - 1)) {
            needLastBranch.enter();
            lastIdx = JSRuntime.lastNonWhitespaceIndex(string, false);
        }
        if (needSubstring.profile(firstIdx > lastIdx)) {
            return "";
        }
        return Boundaries.substring(string, firstIdx, lastIdx + 1);
    }

    private boolean isWhiteSpace(String str, int index) {
        char c = str.charAt(index);
        if (this.isFastNonWhitespace.profile(' ' < c && c < '\u00a0')) {
            return false;
        }
        if (this.isFastWhitespace.profile(c == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            return true;
        }
        return JSRuntime.isWhiteSpace(str.charAt(index));
    }
}

