# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementVirtualNetworkPeeringsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_network_peerings_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_network_peerings.begin_delete(
                resource_group_name=resource_group.name,
                virtual_network_name="str",
                virtual_network_peering_name="str",
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_network_peerings_get(self, resource_group):
        response = await self.client.virtual_network_peerings.get(
            resource_group_name=resource_group.name,
            virtual_network_name="str",
            virtual_network_peering_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_network_peerings_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_network_peerings.begin_create_or_update(
                resource_group_name=resource_group.name,
                virtual_network_name="str",
                virtual_network_peering_name="str",
                virtual_network_peering_parameters={
                    "allowForwardedTraffic": bool,
                    "allowGatewayTransit": bool,
                    "allowVirtualNetworkAccess": bool,
                    "doNotVerifyRemoteGateways": bool,
                    "enableOnlyIPv6Peering": bool,
                    "etag": "str",
                    "id": "str",
                    "localAddressSpace": {
                        "addressPrefixes": ["str"],
                        "ipamPoolPrefixAllocations": [
                            {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                        ],
                    },
                    "localSubnetNames": ["str"],
                    "localVirtualNetworkAddressSpace": {
                        "addressPrefixes": ["str"],
                        "ipamPoolPrefixAllocations": [
                            {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                        ],
                    },
                    "name": "str",
                    "peerCompleteVnets": bool,
                    "peeringState": "str",
                    "peeringSyncLevel": "str",
                    "provisioningState": "str",
                    "remoteAddressSpace": {
                        "addressPrefixes": ["str"],
                        "ipamPoolPrefixAllocations": [
                            {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                        ],
                    },
                    "remoteBgpCommunities": {"virtualNetworkCommunity": "str", "regionalCommunity": "str"},
                    "remoteSubnetNames": ["str"],
                    "remoteVirtualNetwork": {"id": "str"},
                    "remoteVirtualNetworkAddressSpace": {
                        "addressPrefixes": ["str"],
                        "ipamPoolPrefixAllocations": [
                            {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                        ],
                    },
                    "remoteVirtualNetworkEncryption": {"enabled": bool, "enforcement": "str"},
                    "resourceGuid": "str",
                    "type": "str",
                    "useRemoteGateways": bool,
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_network_peerings_list(self, resource_group):
        response = self.client.virtual_network_peerings.list(
            resource_group_name=resource_group.name,
            virtual_network_name="str",
            api_version="2025-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
