#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <locale.h>

#include "configs.h"
#include "xvid4.h"

#include "main.h"

#define MOD_NAME PACKAGE

int read_config_file(xvid_transcode_module_t *mod, char *file, int read)
{
        int ret = 0;
	xvid_plugin_single_t *onepass = &mod->cfg_onepass;
	xvid_plugin_2pass2_t *pass2   = &mod->cfg_pass2;
	xvid_enc_create_t    *create  = &mod->cfg_create;
	xvid_enc_frame_t     *frame   = &mod->cfg_frame;

	struct config complete_config[] =
		{
			/* Section [features] */
			{"features", "Feature settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"quant_type", &mod->cfg_quant_method, CONF_TYPE_STRING, 0, 0, 0, NULL},
			{"motion", &mod->cfg_motion, CONF_TYPE_INT, CONF_RANGE, 0, 6, NULL},
			{"chromame", &mod->cfg_chromame, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"vhq", &mod->cfg_vhq, CONF_TYPE_INT, CONF_RANGE, 0, 4, NULL},
			{"max_bframes", &create->max_bframes, CONF_TYPE_INT, CONF_RANGE, 0, 20, NULL},
			{"bquant_ratio", &create->bquant_ratio, CONF_TYPE_INT, CONF_RANGE, 0, 200, NULL},
			{"bquant_offset", &create->bquant_offset, CONF_TYPE_INT, CONF_RANGE, 0, 200, NULL},
			{"bframe_threshold", &frame->bframe_threshold, CONF_TYPE_INT, CONF_RANGE, -255, 255, NULL},
			{"quarterpel", &mod->cfg_quarterpel, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"gmc", &mod->cfg_gmc, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"trellis", &mod->cfg_trellis, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"packed", &mod->cfg_packed, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"closed_gop", &mod->cfg_closed_gop, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"interlaced", &mod->cfg_interlaced, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"cartoon", &mod->cfg_cartoon, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"hqacpred", &mod->cfg_hqacpred, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"frame_drop_ratio", &create->frame_drop_ratio, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"stats", &mod->cfg_stats, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"greyscale", &mod->cfg_greyscale, CONF_TYPE_FLAG, 0, 0, 1, NULL},
			{"turbo", &mod->cfg_turbo, CONF_TYPE_FLAG, 0, 0, 1, NULL},

			/* section [quantizer] */
			{"quantizer", "Quantizer settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"min_iquant", &create->min_quant[0], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_iquant", &create->max_quant[0], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"min_pquant", &create->min_quant[1], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_pquant", &create->max_quant[1], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"min_bquant", &create->min_quant[2], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"max_bquant", &create->max_quant[2], CONF_TYPE_INT, CONF_RANGE, 1, 31, NULL},
			{"quant_intra_matrix", &mod->cfg_intra_matrix_file, CONF_TYPE_STRING, 0, 0, 100, NULL},
			{"quant_inter_matrix", &mod->cfg_inter_matrix_file, CONF_TYPE_STRING, 0, 0, 100, NULL},

			/* section [cbr] */
			{"cbr", "CBR settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"reaction_delay_factor", &onepass->reaction_delay_factor, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"averaging_period", &onepass->averaging_period, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"buffer", &onepass->buffer, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},

			/* section [cbr] */
			{"vbr", "VBR settings", CONF_TYPE_SECTION, 0, 0, 0, NULL},
			{"keyframe_boost", &pass2->keyframe_boost, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"overflow_control_strength", &pass2->overflow_control_strength, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"curve_compression_high", &pass2->curve_compression_high, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"curve_compression_low", &pass2->curve_compression_low, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"max_overflow_improvement", &pass2->max_overflow_improvement, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"max_overflow_degradation", &pass2->max_overflow_degradation, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"kfreduction", &pass2->kfreduction, CONF_TYPE_INT, CONF_RANGE, 0, 100, NULL},
			{"kfthreshold", &pass2->kfthreshold, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},
			{"container_frame_overhead", &pass2->container_frame_overhead, CONF_TYPE_INT, CONF_MIN, 0, 0, NULL},

			/* End of the config file */
			{NULL, 0, 0, 0, 0, 0, NULL}
		};

	/* Read the values */
	if (read) ret = module_read_config(NULL, MOD_NAME, file, complete_config);

	if (!read) ret = module_print_config_core((file)?file:"stderr", complete_config);

	/* Print the values */
	//if (ret) module_print_config("["MOD_NAME"] ", complete_config);

	return ret;
}

///////////
// Globals
///////////

GtkBuilder *builder; 

// Main window
GtkWidget *window1;

// Matrix window
GtkWidget *matrix_edit_dlg;


// xvid config struct
xvid_transcode_module_t xcfg;
xvid_transcode_module_t xcfg_sav;


int xvidcfg2window(void)
{
    int index=0;
    char buf[128], *s;
    GtkWidget *c;

    if (!strncmp(xcfg.cfg_quant_method,"h263",4)) index=0;
    if (!strncmp(xcfg.cfg_quant_method,"mpeg",4)) index=1;

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_type"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(c), index);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "motion"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(c),xcfg.cfg_motion);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "chromame"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_chromame);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "vhq"));
    gtk_combo_box_set_active(GTK_COMBO_BOX(c),xcfg.cfg_vhq);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_bframes"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_bframes);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bquant_ratio"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.bquant_ratio);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bquant_offset"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.bquant_offset);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bframe_threshold"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_frame.bframe_threshold);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "frame_drop_ratio"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.frame_drop_ratio);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quarterpel"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_quarterpel);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "gmc"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_gmc);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "trellis"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_trellis);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "packed"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_packed);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "closed_gop"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_closed_gop);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "interlaced"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_interlaced);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "cartoon"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_cartoon);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "hqacpred"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_hqacpred);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "greyscale"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_greyscale);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "turbo"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_turbo);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "stats"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c), xcfg.cfg_stats);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_iquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[0]);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_pquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[1]);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_bquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.min_quant[2]);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_iquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[0]);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_pquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[1]);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_bquant"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_create.max_quant[2]);

    ///  Do the matrix loading
    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_intra_matrix"));
    s = xcfg.cfg_intra_matrix_file;
    gtk_entry_set_text(GTK_ENTRY(c), (s && *s)?s:"");

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_inter_matrix"));
    s = xcfg.cfg_inter_matrix_file;
    gtk_entry_set_text(GTK_ENTRY(c), (s && *s)?s:"");

    c = GTK_WIDGET (gtk_builder_get_object (builder, "reaction_delay_factor"));
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.reaction_delay_factor);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "averaging_period"));
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.averaging_period);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "buffer"));
    snprintf(buf, 128, "%d", xcfg.cfg_onepass.buffer);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "keyframe_boost"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.keyframe_boost);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "curve_compression_low"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.curve_compression_low);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "curve_compression_high"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.curve_compression_high);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bitrate_payback_delay"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.overflow_control_strength);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_overflow_improvement"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.max_overflow_improvement);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_overflow_degradation"));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(c), (float)xcfg.cfg_pass2.max_overflow_degradation);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "kfreduction"));
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.kfreduction);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "kfthreshold"));
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.kfthreshold);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    c = GTK_WIDGET (gtk_builder_get_object (builder, "container_frame_overhead"));
    snprintf(buf, 128, "%d", xcfg.cfg_pass2.container_frame_overhead);
    gtk_entry_set_text(GTK_ENTRY(c), buf);

    return 0;
}

int window2xvidcfg(void)
{
    gint index;
    const char *s;
    GtkWidget *c;

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_type"));
    index = gtk_combo_box_get_active(GTK_COMBO_BOX(c));
    switch(index) {
	case 0: xcfg.cfg_quant_method = "h263"; break;
	case 1: xcfg.cfg_quant_method = "mpeg"; break;
    }

    c = GTK_WIDGET (gtk_builder_get_object (builder, "vhq"));
    xcfg.cfg_vhq = gtk_combo_box_get_active(GTK_COMBO_BOX(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "motion"));
    xcfg.cfg_motion = gtk_combo_box_get_active(GTK_COMBO_BOX(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "packed"));
    xcfg.cfg_packed = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "closed_gop"));
    xcfg.cfg_closed_gop = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "interlaced"));
    xcfg.cfg_interlaced = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quarterpel"));
    xcfg.cfg_quarterpel = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "gmc"));
    xcfg.cfg_gmc = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "trellis"));
    xcfg.cfg_trellis = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "cartoon"));
    xcfg.cfg_cartoon = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "hqacpred"));
    xcfg.cfg_hqacpred = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "greyscale"));
    xcfg.cfg_greyscale = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "turbo"));
    xcfg.cfg_turbo = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "chromame"));
    xcfg.cfg_chromame = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "stats"));
    xcfg.cfg_stats = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(c) );

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_bframes"));
    xcfg.cfg_create.max_bframes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_bframes"));
    xcfg.cfg_create.max_bframes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bquant_ratio"));
    xcfg.cfg_create.bquant_ratio = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bquant_offset"));
    xcfg.cfg_create.bquant_offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "frame_drop_ratio"));
    xcfg.cfg_create.frame_drop_ratio = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bframe_threshold"));
    xcfg.cfg_frame.bframe_threshold = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_iquant"));
    xcfg.cfg_create.min_quant[0] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_iquant"));
    xcfg.cfg_create.max_quant[0] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_pquant"));
    xcfg.cfg_create.min_quant[1] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_pquant"));
    xcfg.cfg_create.max_quant[1] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "min_bquant"));
    xcfg.cfg_create.min_quant[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_bquant"));
    xcfg.cfg_create.max_quant[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "reaction_delay_factor"));
    xcfg.cfg_onepass.reaction_delay_factor = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "averaging_period"));
    xcfg.cfg_onepass.averaging_period = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "buffer"));
    xcfg.cfg_onepass.buffer = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "keyframe_boost"));
    xcfg.cfg_pass2.keyframe_boost = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "curve_compression_high"));
    xcfg.cfg_pass2.curve_compression_high = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "bitrate_payback_delay"));
    xcfg.cfg_pass2.overflow_control_strength = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "curve_compression_low"));
    xcfg.cfg_pass2.curve_compression_low = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_overflow_improvement"));
    xcfg.cfg_pass2.max_overflow_improvement = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "max_overflow_degradation"));
    xcfg.cfg_pass2.max_overflow_degradation = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "kfreduction"));
    xcfg.cfg_pass2.kfreduction = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "kfthreshold"));
    xcfg.cfg_pass2.kfthreshold = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    c = GTK_WIDGET (gtk_builder_get_object (builder, "container_frame_overhead"));
    xcfg.cfg_pass2.container_frame_overhead = atoi (gtk_entry_get_text(GTK_ENTRY(c)));

    // matrix; memleak!
    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_intra_matrix"));
    s = gtk_entry_get_text(GTK_ENTRY(c));
    if (s && *s) {
	if (xcfg.cfg_intra_matrix_file) free(xcfg.cfg_intra_matrix_file);
	xcfg.cfg_intra_matrix_file = strdup(s);
    } else  {
	if (xcfg.cfg_intra_matrix_file) free(xcfg.cfg_intra_matrix_file);
	xcfg.cfg_intra_matrix_file = NULL;
    }

    c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_inter_matrix"));
    s = gtk_entry_get_text(GTK_ENTRY(c));
    if (s && *s) {
	if (xcfg.cfg_inter_matrix_file) free(xcfg.cfg_inter_matrix_file);
	xcfg.cfg_inter_matrix_file = strdup(s);
    } else  {
	if (xcfg.cfg_inter_matrix_file) free(xcfg.cfg_inter_matrix_file);
	xcfg.cfg_inter_matrix_file = NULL;
    }

    return 0;
}


int matrix2window(int *matrix)
{
    GtkWidget *c;
    char buf[128]; 
    char field[128];
    int i, j, x;

    x = 0;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = GTK_WIDGET (gtk_builder_get_object(builder, field));
	    sprintf(buf, "%d", matrix [x]);
	    gtk_entry_set_text(GTK_ENTRY(c), buf);
	    ++x;
	}
    }


    return 0;
}

int window2matrix(int *matrix)
{
    GtkWidget *c;

    char field[128];
    int i, j, x;

    x = 0;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = GTK_WIDGET (gtk_builder_get_object(builder, field));
	    matrix [x] = atoi (gtk_entry_get_text(GTK_ENTRY(c)));
	    ++x;
	}
    }

    return 0;
}


int read_matrix(int *matrix, const char *filename)
{
	int i;
	FILE *input;
	
	/* Open the matrix file */
	if((input = fopen(filename, "rb")) == NULL) {
		return(1);
	}

	/* Read the matrix */
	for(i=0; i<64; i++) {

		int value;

		/* If fscanf fails then get out of the loop */
		if(fscanf(input, "%d", &value) != 1) {
			fclose(input);
			return(2);
		}

		/* Clamp the value to safe range */
		value     = (value<  1)?1  :value;
		value     = (value>255)?255:value;
		matrix[i] = value;
	}

	/* Fills the rest with 1 */
	while(i<64) matrix[i++] = 1;

	/* We're done */
	fclose(input);

	return(0);
}

char *ifile;
char *ofile;

int main (int argc, char *argv[])
{
  int i=0;
  GtkWidget *c;
  const gchar *ui_filename = PACKAGE_DATA_DIR "/" PACKAGE "/xvid4conf2.ui";
  const gchar *ui_filename2 = "xvid4conf2.ui";

  setlocale (LC_ALL, "");
  gtk_init (&argc, &argv);

  for(i=1; i<argc; ++i) {
      if (   !strcmp("-h", argv[i]) ||
             !strcmp("--help", argv[i]) ||
             !strcmp("-?", argv[i]) ) {
	  fprintf(stderr, "xvid4conf [ outfile [ infile ] ]\n");
	  fprintf(stderr, "xvid4conf -v\n");
	  exit(0);
      }
  }

  switch (argc) {
    case 2:
      if (!strcmp("-v", argv[1])) {
        fprintf(stderr,"xvid4conf v%s\n",VERSION);
        exit(0);
      }
      ofile = argv[1];
      ifile = NULL;
      break;

    case 3:
      ofile = argv[1];
      ifile = argv[2];
      break;

    case 4:
      fprintf(stderr, "xvid4conf outfile infile\n");
      exit(1);
      break;

    case 1:
    default:
      ifile = ofile = NULL;
      break;
  }

  builder = gtk_builder_new();
  if( (gtk_builder_add_from_file (builder, ui_filename, NULL) == 0) &&
      (gtk_builder_add_from_file (builder, ui_filename2, NULL) == 0))
  {
	fprintf(stderr, "Error: can't open %s\n", ui_filename);
        fprintf(stderr, "Error: can't open %s\n", ui_filename2);
	fprintf(stderr, "Abording...\n");
	return 1;
  }

  window1 = GTK_WIDGET (gtk_builder_get_object(builder, "window1"));
  gtk_builder_connect_signals (builder, NULL);

  // fixup .. set menu default
  c = GTK_WIDGET (gtk_builder_get_object (builder, "quant_type"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(c),0);
  c = GTK_WIDGET (gtk_builder_get_object (builder, "motion"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(c),6);
  c = GTK_WIDGET (gtk_builder_get_object (builder, "vhq"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(c),1);

  if (ifile) {
    GtkEntry *t = GTK_ENTRY( gtk_builder_get_object(builder, "load_file_name_text"));
    int ret = read_config_file(&xcfg, ifile, 1);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read config from '%s': %s", ifile, "Error");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
 	xvidcfg2window();
	gtk_entry_set_text(t, ifile);
    }
  }

  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY(gtk_builder_get_object(builder, "save_file_name_text"));

    window2xvidcfg();

    ret = read_config_file(&xcfg, ofile, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", ofile);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
	gtk_entry_set_text(text, ofile);
    }
  }

  // default settings stored in window1
  window2xvidcfg();

  // save initial defaults
  memcpy(&xcfg_sav, &xcfg, sizeof(xcfg));

  gtk_widget_show(window1);

  gtk_main();
  return 0;
}

