static const char * source =
"static __constant sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;                                         \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void copyPlane_uint(__read_only image2d_t src, __write_only image2d_t dst, const float offset) {                                                            \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const uint input = read_imageui(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const float output = input;                                                                                                                             \n"
"    write_imagef(dst, (int2)(x, y), (float4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void copyPlane_float(__read_only image2d_t src, __write_only image2d_t dst, const float offset) {                                                           \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float input = read_imagef(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const float output = input + offset;                                                                                                                    \n"
"    write_imagef(dst, (int2)(x, y), (float4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void gaussianBlurV_uint(__read_only image2d_t src, __write_only image2d_t dst, __constant float * weights, const int radius, const float offset) {          \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    weights += radius;                                                                                                                                      \n"
"    float sum = 0.f;                                                                                                                                        \n"
"                                                                                                                                                            \n"
"    for (int i = -radius; i <= radius; i++) {                                                                                                               \n"
"        const uint input = read_imageui(src, sampler, (int2)(x, y + i)).x;                                                                                  \n"
"        sum += input * weights[i];                                                                                                                          \n"
"    }                                                                                                                                                       \n"
"                                                                                                                                                            \n"
"    write_imagef(dst, (int2)(x, y), (float4)sum);                                                                                                           \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void gaussianBlurV_float(__read_only image2d_t src, __write_only image2d_t dst, __constant float * weights, const int radius, const float offset) {         \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    weights += radius;                                                                                                                                      \n"
"    float sum = 0.f;                                                                                                                                        \n"
"                                                                                                                                                            \n"
"    for (int i = -radius; i <= radius; i++) {                                                                                                               \n"
"        const float input = read_imagef(src, sampler, (int2)(x, y + i)).x;                                                                                  \n"
"        sum += (input + offset) * weights[i];                                                                                                               \n"
"    }                                                                                                                                                       \n"
"                                                                                                                                                            \n"
"    write_imagef(dst, (int2)(x, y), (float4)sum);                                                                                                           \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void gaussianBlurH(__read_only image2d_t src, __write_only image2d_t dst, __constant float * weights, const int radius) {                                   \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    weights += radius;                                                                                                                                      \n"
"    float sum = 0.f;                                                                                                                                        \n"
"                                                                                                                                                            \n"
"    for (int i = -radius; i <= radius; i++) {                                                                                                               \n"
"        const float input = read_imagef(src, sampler, (int2)(x + i, y)).x;                                                                                  \n"
"        sum += input * weights[i];                                                                                                                          \n"
"    }                                                                                                                                                       \n"
"                                                                                                                                                            \n"
"    write_imagef(dst, (int2)(x, y), (float4)sum);                                                                                                           \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void detectEdge(__read_only image2d_t blur, __write_only image2d_t gradient, __write_only image2d_t direction) {                                            \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float topLeft = read_imagef(blur, sampler, (int2)(x - 1, y - 1)).x;                                                                               \n"
"    const float top = read_imagef(blur, sampler, (int2)(x, y - 1)).x;                                                                                       \n"
"    const float topRight = read_imagef(blur, sampler, (int2)(x + 1, y - 1)).x;                                                                              \n"
"    const float left = read_imagef(blur, sampler, (int2)(x - 1, y)).x;                                                                                      \n"
"    const float right = read_imagef(blur, sampler, (int2)(x + 1, y)).x;                                                                                     \n"
"    const float bottomLeft = read_imagef(blur, sampler, (int2)(x - 1, y + 1)).x;                                                                            \n"
"    const float bottom = read_imagef(blur, sampler, (int2)(x, y + 1)).x;                                                                                    \n"
"    const float bottomRight = read_imagef(blur, sampler, (int2)(x + 1, y + 1)).x;                                                                           \n"
"                                                                                                                                                            \n"
"    float gx, gy;                                                                                                                                           \n"
"                                                                                                                                                            \n"
"#if OP == 0                                                                                                                                                 \n"
"        gx = right - left;                                                                                                                                  \n"
"        gy = top - bottom;                                                                                                                                  \n"
"#elif OP == 1                                                                                                                                               \n"
"        gx = (topRight + right + bottomRight - topLeft - left - bottomLeft) * 0.5f;                                                                         \n"
"        gy = (topLeft + top + topRight - bottomLeft - bottom - bottomRight) * 0.5f;                                                                         \n"
"#elif OP == 2                                                                                                                                               \n"
"        gx = topRight + 2.f * right + bottomRight - topLeft - 2.f * left - bottomLeft;                                                                      \n"
"        gy = topLeft + 2.f * top + topRight - bottomLeft - 2.f * bottom - bottomRight;                                                                      \n"
"#else                                                                                                                                                       \n"
"        gx = 3.f * topRight + 10.f * right + 3.f * bottomRight - 3.f * topLeft - 10.f * left - 3.f * bottomLeft;                                            \n"
"        gy = 3.f * topLeft + 10.f * top + 3.f * topRight - 3.f * bottomLeft - 10.f * bottom - 3.f * bottomRight;                                            \n"
"#endif                                                                                                                                                      \n"
"                                                                                                                                                            \n"
"    const float g = native_sqrt(gx * gx + gy * gy);                                                                                                         \n"
"    write_imagef(gradient, (int2)(x, y), (float4)g);                                                                                                        \n"
"                                                                                                                                                            \n"
"#if MODE == 0                                                                                                                                               \n"
"        float dr = atan2(gy, gx);                                                                                                                           \n"
"        if (dr < 0.f)                                                                                                                                       \n"
"            dr += M_PI_F;                                                                                                                                   \n"
"                                                                                                                                                            \n"
"        uint bin = (uint)(dr * 4.f * M_1_PI_F + 0.5f);                                                                                                      \n"
"        if (bin >= 4)                                                                                                                                       \n"
"            bin = 0;                                                                                                                                        \n"
"        write_imageui(direction, (int2)(x, y), (uint4)bin);                                                                                                 \n"
"#endif                                                                                                                                                      \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void nonMaximumSuppression(__read_only image2d_t direction, __read_only image2d_t gradient, __global float * buffer) {                                      \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const int pos = mad24(get_image_width(direction), y, x);                                                                                                \n"
"                                                                                                                                                            \n"
"    const uint bin = read_imageui(direction, sampler, (int2)(x, y)).x;                                                                                      \n"
"    const float input = read_imagef(gradient, sampler, (int2)(x, y)).x;                                                                                     \n"
"    float output;                                                                                                                                           \n"
"                                                                                                                                                            \n"
"    if (bin == 0) {                                                                                                                                         \n"
"        const float right = read_imagef(gradient, sampler, (int2)(x + 1, y)).x;                                                                             \n"
"        const float left = read_imagef(gradient, sampler, (int2)(x - 1, y)).x;                                                                              \n"
"        output = select(-FLT_MAX, input, input >= max(right, left));                                                                                        \n"
"    } else if (bin == 1) {                                                                                                                                  \n"
"        const float topRight = read_imagef(gradient, sampler, (int2)(x + 1, y - 1)).x;                                                                      \n"
"        const float bottomLeft = read_imagef(gradient, sampler, (int2)(x - 1, y + 1)).x;                                                                    \n"
"        output = select(-FLT_MAX, input, input >= max(topRight, bottomLeft));                                                                               \n"
"    } else if (bin == 2) {                                                                                                                                  \n"
"        const float top = read_imagef(gradient, sampler, (int2)(x, y - 1)).x;                                                                               \n"
"        const float bottom = read_imagef(gradient, sampler, (int2)(x, y + 1)).x;                                                                            \n"
"        output = select(-FLT_MAX, input, input >= max(top, bottom));                                                                                        \n"
"    } else {                                                                                                                                                \n"
"        const float topLeft = read_imagef(gradient, sampler, (int2)(x - 1, y - 1)).x;                                                                       \n"
"        const float bottomRight = read_imagef(gradient, sampler, (int2)(x + 1, y + 1)).x;                                                                   \n"
"        output = select(-FLT_MAX, input, input >= max(topLeft, bottomRight));                                                                               \n"
"    }                                                                                                                                                       \n"
"                                                                                                                                                            \n"
"    buffer[pos] = output;                                                                                                                                   \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel __attribute__((reqd_work_group_size(8, 8, 1)))                                                                                                     \n"
"void hysteresis(__global float * srcp, __global uchar * found, const int width, const int height) {                                                         \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"    const int localId = mad24(8, (int)get_local_id(1), (int)get_local_id(0));                                                                               \n"
"                                                                                                                                                            \n"
"    if (x >= width || y >= height)                                                                                                                          \n"
"        return;                                                                                                                                             \n"
"                                                                                                                                                            \n"
"    const int pos = mad24(width, y, x);                                                                                                                     \n"
"                                                                                                                                                            \n"
"    __local int2 localCoordinates[512];                                                                                                                     \n"
"    __local int localCount;                                                                                                                                 \n"
"                                                                                                                                                            \n"
"    if (localId == 0)                                                                                                                                       \n"
"        localCount = 0;                                                                                                                                     \n"
"                                                                                                                                                            \n"
"    barrier(CLK_LOCAL_MEM_FENCE);                                                                                                                           \n"
"                                                                                                                                                            \n"
"    if (!found[pos] && srcp[pos] >= T_H) {                                                                                                                  \n"
"        srcp[pos] = FLT_MAX;                                                                                                                                \n"
"        found[pos] = UCHAR_MAX;                                                                                                                             \n"
"                                                                                                                                                            \n"
"        localCoordinates[atomic_inc(&localCount)] = (int2)(x, y);                                                                                           \n"
"    }                                                                                                                                                       \n"
"                                                                                                                                                            \n"
"    barrier(CLK_LOCAL_MEM_FENCE);                                                                                                                           \n"
"                                                                                                                                                            \n"
"    int2 privateCoordinates[64];                                                                                                                            \n"
"    int privateCount = 0;                                                                                                                                   \n"
"                                                                                                                                                            \n"
"    while (localCount != 0) {                                                                                                                               \n"
"        const int mod = localCount % 64;                                                                                                                    \n"
"        const uint pixelPerThread = localCount / 64 + select(0, 1, localId < mod);                                                                          \n"
"                                                                                                                                                            \n"
"        for (uint i = 0; i < pixelPerThread; i++) {                                                                                                         \n"
"            const int2 pos2 = localCoordinates[atomic_dec(&localCount) - 1];                                                                                \n"
"                                                                                                                                                            \n"
"            const int xxStart = max(pos2.x - 1, 0);                                                                                                         \n"
"            const int xxStop = min(pos2.x + 1, width - 1);                                                                                                  \n"
"            const int yyStart = max(pos2.y - 1, 0);                                                                                                         \n"
"            const int yyStop = min(pos2.y + 1, height - 1);                                                                                                 \n"
"                                                                                                                                                            \n"
"            for (int yy = yyStart; yy <= yyStop; yy++) {                                                                                                    \n"
"                for (int xx = xxStart; xx <= xxStop; xx++) {                                                                                                \n"
"                    const int pos3 = mad24(width, yy, xx);                                                                                                  \n"
"                                                                                                                                                            \n"
"                    if (!found[pos3] && srcp[pos3] >= T_L) {                                                                                                \n"
"                        srcp[pos3] = FLT_MAX;                                                                                                               \n"
"                        found[pos3] = UCHAR_MAX;                                                                                                            \n"
"                                                                                                                                                            \n"
"                        privateCoordinates[privateCount++] = (int2)(xx, yy);                                                                                \n"
"                    }                                                                                                                                       \n"
"                }                                                                                                                                           \n"
"            }                                                                                                                                               \n"
"        }                                                                                                                                                   \n"
"                                                                                                                                                            \n"
"        barrier(CLK_LOCAL_MEM_FENCE);                                                                                                                       \n"
"                                                                                                                                                            \n"
"        while (privateCount != 0)                                                                                                                           \n"
"            localCoordinates[atomic_inc(&localCount)] = privateCoordinates[--privateCount];                                                                 \n"
"                                                                                                                                                            \n"
"        barrier(CLK_LOCAL_MEM_FENCE);                                                                                                                       \n"
"    }                                                                                                                                                       \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void outputGB_uint(__read_only image2d_t src, __write_only image2d_t dst, const uint peak, const float offset) {                                            \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float input = read_imagef(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const uint output = min((uint)(input + 0.5f), peak);                                                                                                    \n"
"    write_imageui(dst, (int2)(x, y), (uint4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void outputGB_float(__read_only image2d_t src, __write_only image2d_t dst, const uint peak, const float offset) {                                           \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float input = read_imagef(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const float output = input - offset;                                                                                                                    \n"
"    write_imagef(dst, (int2)(x, y), (float4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void binarizeCE_uint(const __global float * src, __write_only image2d_t dst, const uint peak, const float lower, const float upper) {                       \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const int pos = mad24(get_image_width(dst), y, x);                                                                                                      \n"
"                                                                                                                                                            \n"
"    const float input = src[pos];                                                                                                                           \n"
"    const uint output = select(0U, peak, input == FLT_MAX);                                                                                                 \n"
"    write_imageui(dst, (int2)(x, y), (uint4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void binarizeCE_float(const __global float * src, __write_only image2d_t dst, const uint peak, const float lower, const float upper) {                      \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const int pos = mad24(get_image_width(dst), y, x);                                                                                                      \n"
"                                                                                                                                                            \n"
"    const float input = src[pos];                                                                                                                           \n"
"    const float output = select(lower, upper, input == FLT_MAX);                                                                                            \n"
"    write_imagef(dst, (int2)(x, y), (float4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void discretizeGM_uint(__read_only image2d_t src, __write_only image2d_t dst, const uint peak, const float offset) {                                        \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float input = read_imagef(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const uint output = min((uint)(input * MAGNITUDE + 0.5f), peak);                                                                                        \n"
"    write_imageui(dst, (int2)(x, y), (uint4)output);                                                                                                        \n"
"}                                                                                                                                                           \n"
"                                                                                                                                                            \n"
"__kernel                                                                                                                                                    \n"
"void discretizeGM_float(__read_only image2d_t src, __write_only image2d_t dst, const uint peak, const float offset) {                                       \n"
"    const int x = get_global_id(0);                                                                                                                         \n"
"    const int y = get_global_id(1);                                                                                                                         \n"
"                                                                                                                                                            \n"
"    const float input = read_imagef(src, sampler, (int2)(x, y)).x;                                                                                          \n"
"    const float output = input * MAGNITUDE - offset;                                                                                                        \n"
"    write_imagef(dst, (int2)(x, y), (float4)output);                                                                                                        \n"
"}                                                                                                                                                             ";