static const char * source =
"static __constant sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_NONE | CLK_FILTER_NEAREST;                                                                                          \n"
"                                                                                                                                                                                                    \n"
"__kernel __attribute__((reqd_work_group_size(LOCAL_WORK_SIZE_X, LOCAL_WORK_SIZE_Y, 1)))                                                                                                             \n"
"void calculateConnectionCosts_uint(__read_only image2d_t src, __global float * ccosts, const int width, const int height, const int _srcY) {                                                        \n"
"    const int x = get_global_id(0);                                                                                                                                                                 \n"
"    const int y = get_global_id(1);                                                                                                                                                                 \n"
"                                                                                                                                                                                                    \n"
"    const int srcX = 12 + x;                                                                                                                                                                        \n"
"    const int srcY = _srcY + 2 * y;                                                                                                                                                                 \n"
"                                                                                                                                                                                                    \n"
"    if (x >= width || srcY >= height)                                                                                                                                                               \n"
"        return;                                                                                                                                                                                     \n"
"                                                                                                                                                                                                    \n"
"    ccosts += mad24(TPITCH_VECTOR, x, MDIS_VECTOR) + y;                                                                                                                                             \n"
"                                                                                                                                                                                                    \n"
"    const int umax = min(min(x, width - 1 - x), MDIS);                                                                                                                                              \n"
"                                                                                                                                                                                                    \n"
"    #if COST3                                                                                                                                                                                       \n"
"        for (int u = -umax; u <= umax; u++) {                                                                                                                                                       \n"
"            const int u2 = u * 2;                                                                                                                                                                   \n"
"            int s0 = 0, s1 = -1, s2 = -1;                                                                                                                                                           \n"
"                                                                                                                                                                                                    \n"
"            for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                     \n"
"                s0 += abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY - 3)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY - 1)).x) +                                        \n"
"                      abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY + 1)).x) +                                        \n"
"                      abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY + 1)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY + 3)).x);                                         \n"
"                                                                                                                                                                                                    \n"
"            if ((u >= 0 && x >= u2) || (u <= 0 && x < width + u2)) {                                                                                                                                \n"
"                s1 = 0;                                                                                                                                                                             \n"
"                for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                 \n"
"                    s1 += abs_diff(read_imageui(src, sampler, (int2)(srcX + k, srcY - 3)).x, read_imageui(src, sampler, (int2)(srcX - u2 + k, srcY - 1)).x) +                                       \n"
"                          abs_diff(read_imageui(src, sampler, (int2)(srcX + k, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX - u2 + k, srcY + 1)).x) +                                       \n"
"                          abs_diff(read_imageui(src, sampler, (int2)(srcX + k, srcY + 1)).x, read_imageui(src, sampler, (int2)(srcX - u2 + k, srcY + 3)).x);                                        \n"
"            }                                                                                                                                                                                       \n"
"                                                                                                                                                                                                    \n"
"            if ((u <= 0 && x >= -u2) || (u >= 0 && x < width - u2)) {                                                                                                                               \n"
"                s2 = 0;                                                                                                                                                                             \n"
"                for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                 \n"
"                    s2 += abs_diff(read_imageui(src, sampler, (int2)(srcX + u2 + k, srcY - 3)).x, read_imageui(src, sampler, (int2)(srcX + k, srcY - 1)).x) +                                       \n"
"                          abs_diff(read_imageui(src, sampler, (int2)(srcX + u2 + k, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX + k, srcY + 1)).x) +                                       \n"
"                          abs_diff(read_imageui(src, sampler, (int2)(srcX + u2 + k, srcY + 1)).x, read_imageui(src, sampler, (int2)(srcX + k, srcY + 3)).x);                                        \n"
"            }                                                                                                                                                                                       \n"
"                                                                                                                                                                                                    \n"
"            s1 = select(select(s0, s2, s2 >= 0), s1, s1 >= 0);                                                                                                                                      \n"
"            s2 = select(select(s0, s1, s1 >= 0), s2, s2 >= 0);                                                                                                                                      \n"
"                                                                                                                                                                                                    \n"
"            const uint ip = rhadd(read_imageui(src, sampler, (int2)(srcX + u, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX - u, srcY + 1)).x); // should use cubic if ucubic=true           \n"
"            const int v = abs_diff(read_imageui(src, sampler, (int2)(srcX, srcY - 1)).x, ip) + abs_diff(read_imageui(src, sampler, (int2)(srcX, srcY + 1)).x, ip);                                  \n"
"            ccosts[u * VECTOR_SIZE] = ALPHA * (s0 + s1 + s2) + BETA * abs(u) + REMAINING_WEIGHT * v;                                                                                                \n"
"        }                                                                                                                                                                                           \n"
"    #else                                                                                                                                                                                           \n"
"        for (int u = -umax; u <= umax; u++) {                                                                                                                                                       \n"
"            int s = 0;                                                                                                                                                                              \n"
"                                                                                                                                                                                                    \n"
"            for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                     \n"
"                s += abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY - 3)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY - 1)).x) +                                         \n"
"                     abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY + 1)).x) +                                         \n"
"                     abs_diff(read_imageui(src, sampler, (int2)(srcX + u + k, srcY + 1)).x, read_imageui(src, sampler, (int2)(srcX - u + k, srcY + 3)).x);                                          \n"
"                                                                                                                                                                                                    \n"
"            const uint ip = rhadd(read_imageui(src, sampler, (int2)(srcX + u, srcY - 1)).x, read_imageui(src, sampler, (int2)(srcX - u, srcY + 1)).x); // should use cubic if ucubic=true           \n"
"            const int v = abs_diff(read_imageui(src, sampler, (int2)(srcX, srcY - 1)).x, ip) + abs_diff(read_imageui(src, sampler, (int2)(srcX, srcY + 1)).x, ip);                                  \n"
"            ccosts[u * VECTOR_SIZE] = ALPHA * s + BETA * abs(u) + REMAINING_WEIGHT * v;                                                                                                             \n"
"        }                                                                                                                                                                                           \n"
"    #endif                                                                                                                                                                                          \n"
"}                                                                                                                                                                                                   \n"
"                                                                                                                                                                                                    \n"
"__kernel __attribute__((reqd_work_group_size(LOCAL_WORK_SIZE_X, LOCAL_WORK_SIZE_Y, 1)))                                                                                                             \n"
"void calculateConnectionCosts_float(__read_only image2d_t src, __global float * ccosts, const int width, const int height, const int _srcY) {                                                       \n"
"    const int x = get_global_id(0);                                                                                                                                                                 \n"
"    const int y = get_global_id(1);                                                                                                                                                                 \n"
"                                                                                                                                                                                                    \n"
"    const int srcX = 12 + x;                                                                                                                                                                        \n"
"    const int srcY = _srcY + 2 * y;                                                                                                                                                                 \n"
"                                                                                                                                                                                                    \n"
"    if (x >= width || srcY >= height)                                                                                                                                                               \n"
"        return;                                                                                                                                                                                     \n"
"                                                                                                                                                                                                    \n"
"    ccosts += mad24(TPITCH_VECTOR, x, MDIS_VECTOR) + y;                                                                                                                                             \n"
"                                                                                                                                                                                                    \n"
"    const int umax = min(min(x, width - 1 - x), MDIS);                                                                                                                                              \n"
"                                                                                                                                                                                                    \n"
"    #if COST3                                                                                                                                                                                       \n"
"        for (int u = -umax; u <= umax; u++) {                                                                                                                                                       \n"
"            const int u2 = u * 2;                                                                                                                                                                   \n"
"            float s0 = 0.f, s1 = -FLT_MAX, s2 = -FLT_MAX;                                                                                                                                           \n"
"                                                                                                                                                                                                    \n"
"            for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                     \n"
"                s0 += fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY - 3)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY - 1)).x) +                                             \n"
"                      fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY - 1)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY + 1)).x) +                                             \n"
"                      fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY + 1)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY + 3)).x);                                              \n"
"                                                                                                                                                                                                    \n"
"            if ((u >= 0 && x >= u2) || (u <= 0 && x < width + u2)) {                                                                                                                                \n"
"                s1 = 0.f;                                                                                                                                                                           \n"
"                for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                 \n"
"                    s1 += fabs(read_imagef(src, sampler, (int2)(srcX + k, srcY - 3)).x - read_imagef(src, sampler, (int2)(srcX - u2 + k, srcY - 1)).x) +                                            \n"
"                          fabs(read_imagef(src, sampler, (int2)(srcX + k, srcY - 1)).x - read_imagef(src, sampler, (int2)(srcX - u2 + k, srcY + 1)).x) +                                            \n"
"                          fabs(read_imagef(src, sampler, (int2)(srcX + k, srcY + 1)).x - read_imagef(src, sampler, (int2)(srcX - u2 + k, srcY + 3)).x);                                             \n"
"            }                                                                                                                                                                                       \n"
"                                                                                                                                                                                                    \n"
"            if ((u <= 0 && x >= -u2) || (u >= 0 && x < width - u2)) {                                                                                                                               \n"
"                s2 = 0.f;                                                                                                                                                                           \n"
"                for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                 \n"
"                    s2 += fabs(read_imagef(src, sampler, (int2)(srcX + u2 + k, srcY - 3)).x - read_imagef(src, sampler, (int2)(srcX + k, srcY - 1)).x) +                                            \n"
"                          fabs(read_imagef(src, sampler, (int2)(srcX + u2 + k, srcY - 1)).x - read_imagef(src, sampler, (int2)(srcX + k, srcY + 1)).x) +                                            \n"
"                          fabs(read_imagef(src, sampler, (int2)(srcX + u2 + k, srcY + 1)).x - read_imagef(src, sampler, (int2)(srcX + k, srcY + 3)).x);                                             \n"
"            }                                                                                                                                                                                       \n"
"                                                                                                                                                                                                    \n"
"            s1 = select(select(s0, s2, s2 > -FLT_MAX), s1, s1 > -FLT_MAX);                                                                                                                          \n"
"            s2 = select(select(s0, s1, s1 > -FLT_MAX), s2, s2 > -FLT_MAX);                                                                                                                          \n"
"                                                                                                                                                                                                    \n"
"            const float ip = (read_imagef(src, sampler, (int2)(srcX + u, srcY - 1)).x + read_imagef(src, sampler, (int2)(srcX - u, srcY + 1)).x) * 0.5f; // should use cubic if ucubic=true         \n"
"            const float v = fabs(read_imagef(src, sampler, (int2)(srcX, srcY - 1)).x - ip) + fabs(read_imagef(src, sampler, (int2)(srcX, srcY + 1)).x - ip);                                        \n"
"            ccosts[u * VECTOR_SIZE] = ALPHA * (s0 + s1 + s2) + BETA * abs(u) + REMAINING_WEIGHT * v;                                                                                                \n"
"        }                                                                                                                                                                                           \n"
"    #else                                                                                                                                                                                           \n"
"        for (int u = -umax; u <= umax; u++) {                                                                                                                                                       \n"
"            float s = 0.f;                                                                                                                                                                          \n"
"                                                                                                                                                                                                    \n"
"            for (int k = -NRAD; k <= NRAD; k++)                                                                                                                                                     \n"
"                s += fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY - 3)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY - 1)).x) +                                              \n"
"                     fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY - 1)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY + 1)).x) +                                              \n"
"                     fabs(read_imagef(src, sampler, (int2)(srcX + u + k, srcY + 1)).x - read_imagef(src, sampler, (int2)(srcX - u + k, srcY + 3)).x);                                               \n"
"                                                                                                                                                                                                    \n"
"            const float ip = (read_imagef(src, sampler, (int2)(srcX + u, srcY - 1)).x + read_imagef(src, sampler, (int2)(srcX - u, srcY + 1)).x) * 0.5f; // should use cubic if ucubic=true         \n"
"            const float v = fabs(read_imagef(src, sampler, (int2)(srcX, srcY - 1)).x - ip) + fabs(read_imagef(src, sampler, (int2)(srcX, srcY + 1)).x - ip);                                        \n"
"            ccosts[u * VECTOR_SIZE] = ALPHA * s + BETA * abs(u) + REMAINING_WEIGHT * v;                                                                                                             \n"
"        }                                                                                                                                                                                           \n"
"    #endif                                                                                                                                                                                          \n"
"}                                                                                                                                                                                                     ";
