/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_tree_TreeLoader({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.tree.TreeLoader</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/TreeLoader.html#Ext-tree-TreeLoader' target='_blank'>TreeLoader.js</a></div></pre><div class='doc-contents'><p>A TreeLoader provides for lazy loading of an <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a>'s child\nnodes from a specified URL. The response must be a JavaScript Array definition\nwhose elements are node definition objects. e.g.:</p>\n\n<pre><code>    [{\n        id: 1,\n        text: 'A leaf Node',\n        leaf: true\n    },{\n        id: 2,\n        text: 'A folder Node',\n        children: [{\n            id: 3,\n            text: 'A child Node',\n            leaf: true\n        }]\n   }]\n</code></pre>\n\n\n<br><br>\n\n\n<p>A server request is sent, and child nodes are loaded only when a node is expanded.\nThe loading node's id is passed to the server under the parameter name \"node\" to\nenable the server to produce the correct child nodes.</p>\n\n<br><br>\n\n\n<p>To pass extra parameters, an event handler may be attached to the \"beforeload\"\nevent, and the parameters specified in the TreeLoader's baseParams property:</p>\n\n<pre><code>    myTreeLoader.on(\"beforeload\", function(treeLoader, node) {\n        this.baseParams.category = node.attributes.category;\n    }, this);\n</code></pre>\n\n\n<p>This would pass an HTTP parameter called \"category\" to the server containing\nthe value of the Node's \"category\" attribute.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-baseAttrs' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-baseAttrs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-baseAttrs' class='name expandable'>baseAttrs</a><span> : Object</span></div><div class='description'><div class='short'>(optional) An object containing attributes to be added to all nodes\ncreated by this loader. ...</div><div class='long'><p>(optional) An object containing attributes to be added to all nodes\ncreated by this loader. If the attributes sent by the server have an attribute in this object,\nthey take priority.</p>\n</div></div></div><div id='cfg-baseParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-baseParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-baseParams' class='name not-expandable'>baseParams</a><span> : Object</span></div><div class='description'><div class='short'><p>(optional) An object containing properties which\nspecify HTTP parameters to be passed to each request for child nodes.</p>\n</div><div class='long'><p>(optional) An object containing properties which\nspecify HTTP parameters to be passed to each request for child nodes.</p>\n</div></div></div><div id='cfg-clearOnLoad' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-clearOnLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-clearOnLoad' class='name expandable'>clearOnLoad</a><span> : Boolean</span></div><div class='description'><div class='short'>(optional) Default to true. ...</div><div class='long'><p>(optional) Default to true. Remove previously existing\nchild nodes before loading.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-dataUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-dataUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-dataUrl' class='name expandable'>dataUrl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The URL from which to request a Json string which\nspecifies an array of node definition objects representing the chil...</div><div class='long'><p>The URL from which to request a Json string which\nspecifies an array of node definition objects representing the child nodes\nto be loaded.</p>\n</div></div></div><div id='cfg-directFn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-directFn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-directFn' class='name not-expandable'>directFn</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'><p>Function to call when executing a request.</p>\n</div><div class='long'><p>Function to call when executing a request.</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-nodeParameter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-nodeParameter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-nodeParameter' class='name expandable'>nodeParameter</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the parameter sent to the server which contains\nthe identifier of the node. ...</div><div class='long'><p>The name of the parameter sent to the server which contains\nthe identifier of the node. Defaults to <tt>'node'</tt>.</p>\n<p>Defaults to: <code>'node'</code></p></div></div></div><div id='cfg-paramOrder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-paramOrder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-paramOrder' class='name expandable'>paramOrder</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Defaults to undefined. ...</div><div class='long'><p>Defaults to <tt>undefined</tt>. Only used when using directFn.\nSpecifies the params in the order in which they must be passed to the server-side Direct method\nas either (1) an Array of String values, or (2) a String of params delimited by either whitespace,\ncomma, or pipe. For example,\nany of the following would be acceptable:</p>\n\n<pre><code>nodeParameter: 'node',\nparamOrder: ['param1','param2','param3']\nparamOrder: 'node param1 param2 param3'\nparamOrder: 'param1,node,param2,param3'\nparamOrder: 'param1|param2|param|node'\n     </code></pre>\n\n</div></div></div><div id='cfg-paramsAsHash' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-paramsAsHash' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-paramsAsHash' class='name expandable'>paramsAsHash</a><span> : Boolean</span></div><div class='description'><div class='short'>Only used when using directFn. ...</div><div class='long'><p>Only used when using directFn.\nSend parameters as a collection of named arguments (defaults to <tt>false</tt>). Providing a\n<tt><a href=\"#!/api/Ext.tree.TreeLoader-cfg-paramOrder\" rel=\"Ext.tree.TreeLoader-cfg-paramOrder\" class=\"docClass\">paramOrder</a></tt> nullifies this configuration.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-preloadChildren' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-preloadChildren' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-preloadChildren' class='name not-expandable'>preloadChildren</a><span> : Boolean</span></div><div class='description'><div class='short'><p>If set to true, the loader recursively loads \"children\" attributes when doing the first load on nodes.</p>\n</div><div class='long'><p>If set to true, the loader recursively loads \"children\" attributes when doing the first load on nodes.</p>\n</div></div></div><div id='cfg-requestMethod' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-requestMethod' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-requestMethod' class='name not-expandable'>requestMethod</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The HTTP request method for loading data (defaults to the value of <a href=\"#!/api/Ext.Ajax-property-method\" rel=\"Ext.Ajax-property-method\" class=\"docClass\">Ext.Ajax.method</a>).</p>\n</div><div class='long'><p>The HTTP request method for loading data (defaults to the value of <a href=\"#!/api/Ext.Ajax-property-method\" rel=\"Ext.Ajax-property-method\" class=\"docClass\">Ext.Ajax.method</a>).</p>\n</div></div></div><div id='cfg-uiProviders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-uiProviders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-uiProviders' class='name expandable'>uiProviders</a><span> : Object</span></div><div class='description'><div class='short'>(optional) An object containing properties which\nspecify custom Ext.tree.TreeNodeUI implementations. ...</div><div class='long'><p>(optional) An object containing properties which\nspecify custom <a href=\"#!/api/Ext.tree.TreeNodeUI\" rel=\"Ext.tree.TreeNodeUI\" class=\"docClass\">Ext.tree.TreeNodeUI</a> implementations. If the optional\n<i>uiProvider</i> attribute of a returned child node is a string rather\nthan a reference to a TreeNodeUI implementation, then that string value\nis used as a property name in the uiProviders object.</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='cfg-url' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-cfg-url' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-cfg-url' class='name not-expandable'>url</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>Equivalent to <a href=\"#!/api/Ext.tree.TreeLoader-cfg-dataUrl\" rel=\"Ext.tree.TreeLoader-cfg-dataUrl\" class=\"docClass\">dataUrl</a>.</p>\n</div><div class='long'><p>Equivalent to <a href=\"#!/api/Ext.tree.TreeLoader-cfg-dataUrl\" rel=\"Ext.tree.TreeLoader-cfg-dataUrl\" class=\"docClass\">dataUrl</a>.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.tree.TreeLoader-method-constructor' class='name expandable'>Ext.tree.TreeLoader</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.tree.TreeLoader\" rel=\"Ext.tree.TreeLoader\" class=\"docClass\">Ext.tree.TreeLoader</a></div><div class='description'><div class='short'>Creates a new Treeloader. ...</div><div class='long'><p>Creates a new Treeloader.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>A config object containing config properties.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.tree.TreeLoader\" rel=\"Ext.tree.TreeLoader\" class=\"docClass\">Ext.tree.TreeLoader</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-createNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-method-createNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-method-createNode' class='name expandable'>createNode</a>( <span class='pre'>attr</span> )</div><div class='description'><div class='short'>Override this function for custom TreeNode node implementation, or to\nmodify the attributes at creation time. ...</div><div class='long'><p>Override this function for custom TreeNode node implementation, or to\nmodify the attributes at creation time.</p>\n\n\n<p>Example:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.tree.TreePanel\" rel=\"Ext.tree.TreePanel\" class=\"docClass\">Ext.tree.TreePanel</a>({\n    ...\n    loader: new <a href=\"#!/api/Ext.tree.TreeLoader\" rel=\"Ext.tree.TreeLoader\" class=\"docClass\">Ext.tree.TreeLoader</a>({\n        url: 'dataUrl',\n        createNode: function(attr) {\n//          Allow consolidation consignments to have\n//          consignments dropped into them.\n            if (attr.isConsolidation) {\n                attr.iconCls = 'x-consol',\n                attr.allowDrop = true;\n            }\n            return Ext.tree.TreeLoader.prototype.createNode.call(this, attr);\n        }\n    }),\n    ...\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attr</span> : Object<div class='sub-desc'><p>{Object} The attributes from which to create the new node.</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-method-load' class='name expandable'>load</a>( <span class='pre'>node, callback, scope</span> )</div><div class='description'><div class='short'>Load an Ext.tree.TreeNode from the URL specified in the constructor. ...</div><div class='long'><p>Load an <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a> from the URL specified in the constructor.\nThis is called automatically when a node is expanded, but may be used to reload\na node (or append new children if the <a href=\"#!/api/Ext.tree.TreeLoader-cfg-clearOnLoad\" rel=\"Ext.tree.TreeLoader-cfg-clearOnLoad\" class=\"docClass\">clearOnLoad</a> option is false.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Function to call after the node has been loaded. The\nfunction is passed the TreeNode which was requested to be loaded.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the callback is executed.\ndefaults to the loaded TreeNode.</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-beforeload' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-event-beforeload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-event-beforeload' class='name expandable'>beforeload</a>( <span class='pre'>This, node, callback</span> )</div><div class='description'><div class='short'>Fires before a network request is made to retrieve the Json text which specifies a node's children. ...</div><div class='long'><p>Fires before a network request is made to retrieve the Json text which specifies a node's children.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>This</span> : Object<div class='sub-desc'><p>TreeLoader object.</p>\n</div></li><li><span class='pre'>node</span> : Object<div class='sub-desc'><p>The <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a> object being loaded.</p>\n</div></li><li><span class='pre'>callback</span> : Object<div class='sub-desc'><p>The callback function specified in the <a href=\"#!/api/Ext.tree.TreeLoader-event-load\" rel=\"Ext.tree.TreeLoader-event-load\" class=\"docClass\">load</a> call.</p>\n</div></li></ul></div></div></div><div id='event-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-event-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-event-load' class='name expandable'>load</a>( <span class='pre'>This, node, response</span> )</div><div class='description'><div class='short'>Fires when the node has been successfuly loaded. ...</div><div class='long'><p>Fires when the node has been successfuly loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>This</span> : Object<div class='sub-desc'><p>TreeLoader object.</p>\n</div></li><li><span class='pre'>node</span> : Object<div class='sub-desc'><p>The <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a> object being loaded.</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The response object containing the data from the server.</p>\n</div></li></ul></div></div></div><div id='event-loadexception' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.tree.TreeLoader'>Ext.tree.TreeLoader</span><br/><a href='source/TreeLoader.html#Ext-tree-TreeLoader-event-loadexception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.tree.TreeLoader-event-loadexception' class='name expandable'>loadexception</a>( <span class='pre'>This, node, response</span> )</div><div class='description'><div class='short'>Fires if the network request failed. ...</div><div class='long'><p>Fires if the network request failed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>This</span> : Object<div class='sub-desc'><p>TreeLoader object.</p>\n</div></li><li><span class='pre'>node</span> : Object<div class='sub-desc'><p>The <a href=\"#!/api/Ext.tree.TreeNode\" rel=\"Ext.tree.TreeNode\" class=\"docClass\">Ext.tree.TreeNode</a> object being loaded.</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The response object containing the data from the server.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"TreeLoader.html#Ext-tree-TreeLoader","filename":"TreeLoader.js"}],"linenr":1,"members":{"property":[],"cfg":[{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"baseAttrs","id":"cfg-baseAttrs"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"baseParams","id":"cfg-baseParams"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"clearOnLoad","id":"cfg-clearOnLoad"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"dataUrl","id":"cfg-dataUrl"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"directFn","id":"cfg-directFn"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"nodeParameter","id":"cfg-nodeParameter"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"paramOrder","id":"cfg-paramOrder"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"paramsAsHash","id":"cfg-paramsAsHash"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"preloadChildren","id":"cfg-preloadChildren"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"requestMethod","id":"cfg-requestMethod"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"uiProviders","id":"cfg-uiProviders"},{"tagname":"cfg","owner":"Ext.tree.TreeLoader","meta":{},"name":"url","id":"cfg-url"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.tree.TreeLoader","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.tree.TreeLoader","meta":{},"name":"createNode","id":"method-createNode"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.tree.TreeLoader","meta":{},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.tree.TreeLoader","meta":{},"name":"beforeload","id":"event-beforeload"},{"tagname":"event","owner":"Ext.tree.TreeLoader","meta":{},"name":"load","id":"event-load"},{"tagname":"event","owner":"Ext.tree.TreeLoader","meta":{},"name":"loadexception","id":"event-loadexception"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.tree.TreeLoader","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.tree.TreeLoader","mixins":[],"mixedInto":[]});