//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t fx4_paramFeatureBias[16] = {
    159, 234, 88, -988, -1659, -81, -11, -70, 256, 9, 19, 171, 56, 208, 24, 47, 
};

static const int16_t fx4_paramFeatureWeights[400] = {
    -43, -14, 231, 34, 35, 57, -85, 68, 48, 29, -465, -527, -145, 31, -633, 96, 
    -87, -457, -105, -88, -50, -110, 42, -501, -294, -13, 984, 369, 198, 601, 1437, 392, 
    1030, -304, 91, 178, 31, 75, 341, 1428, -950, -147, 292, 828, -630, -474, -1808, 598, 
    -638, 201, -186, -4, 25, 37, -348, -58, 56, -0, -278, -1297, 121, 962, -1650, -566, 
    340, -71, -36, -0, -4, 9, 124, 476, -58, 28, -208, 327, 319, -173, 94, 15, 
    1, -449, -512, 187, -279, -234, 13, 110, 198, -36, 239, 917, 397, -546, 730, 344, 
    863, 1988, 304, -1025, 1050, 785, 335, 74, -2, -371, -1221, -1833, -1418, 530, -132, -228, 
    -3366, -82, -2075, -2964, 3176, 2427, -1484, -41, 2684, -44, -1269, -104, 2644, -804, 665, -560, 
    1324, -317, 594, -464, -157, -366, -171, 67, -333, 69, 783, 1576, -1838, -2114, 251, -319, 
    -1442, -204, 479, -212, 163, 12, -64, -880, 73, -287, 325, -118, -278, -58, 1513, -13, 
    -255, 1, 1491, 458, -63, 232, -740, 1570, 57, -311, 672, 107, -874, -86, 763, -561, 
    -19, -2166, -904, -2089, 1850, 682, -661, -4326, -1520, 3213, 1208, 291, 3148, -689, -1655, 396, 
    380, -90, 4371, 10962, 4691, 3335, 2806, 2372, 2504, 447, 1495, 146, -946, -90, -247, 317, 
    2975, -563, -4156, -502, 1549, -1858, -564, -1101, 512, -5060, -764, 5, -650, 1817, 1399, -1673, 
    1000, 641, 84, 449, -212, -78, 1125, 109, 435, 792, 440, -514, -220, -920, -569, 1814, 
    181, -396, -889, 23, -11, 101, -22, 726, -400, 97, 264, 1046, 607, 224, 46, -192, 
    247, -1714, 886, -90, -296, -1857, 144, -177, 948, 389, -1187, -752, -451, 143, 501, 210, 
    -589, 3330, -2924, 429, 93, -3366, -2035, 693, -4647, 2315, -2571, 85, -2375, 1480, 768, 400, 
    -1007, -54, 2806, -615, 437, -967, 1107, 118, -521, -728, -1375, 1234, 2322, 129, -385, 133, 
    -539, -159, -389, 50, -24, 227, -196, -203, -226, -110, 553, -166, -186, 598, 4, 33, 
    -319, 72, 315, -29, 3, -77, -40, -765, 30, -1, 164, -496, -201, -195, -203, -191, 
    -18, 285, -296, 28, -19, 501, 374, -417, 33, -297, 137, 1063, 3, 339, -86, 667, 
    -451, 240, 713, 357, 3, 111, 264, 142, 829, -107, 1703, -1389, 408, -949, -438, -973, 
    125, -223, -258, -92, -43, 178, -561, 713, -31, 163, -386, -707, -357, 171, -115, 19, 
    95, -91, -122, 5, -12, -61, 24, -115, 52, 5, 351, -328, 23, -472, -553, -168, 
};

static const int16_t fx4_paramModel1Bias[16] = {
    -469, 145, -1085, -1298, -234, 645, -271, 207, 318, -474, -1802, -253, -282, -301, -183, 84, 
};

static const int16_t fx4_paramModel1Weights[2304] = {
    -277, -1921, 1001, 1019, -2635, -87, -2963, 572, 2351, 3495, -285, 3358, 1982, -423, 187, -793, 
    772, 3127, -282, 1934, -4606, 1198, -2381, 198, -1239, -1211, -1130, -2345, 1872, -137, 20, 214, 
    69, -932, -1540, -3634, 2027, 200, 1572, -4295, 2089, 795, 3186, -1421, 100, -2047, 1318, -1932, 
    -838, 851, 1505, -1008, -1745, -3585, 405, 1243, -2475, 2468, 3249, -61, 949, -753, 3056, 386, 
    588, 136, -99, 490, -950, -1868, 2786, 273, -1119, -2775, 2947, -1189, -912, 391, -871, -698, 
    -2049, 627, -119, -1079, 3273, 615, 1030, -1518, 958, 1546, -274, 19, 1552, -861, -140, 97, 
    886, -753, -454, -2871, -1223, 2739, -971, 4228, 2200, 723, -1710, -3781, 195, -1356, -3517, 1227, 
    72, 7, -6887, -128, -4519, 493, 4794, -500, 259, -2154, 3096, -1422, -1414, 5045, -237, -72, 
    -2195, -1285, 1164, -2757, 1676, -558, -950, 1155, -4041, -138, -1410, -159, 2686, -989, -1433, 1124, 
    -2626, 2722, 559, 1470, -2270, -954, -257, -2112, -2745, -1016, -1749, -671, -670, -866, 1182, -2437, 
    -392, 10, 1313, -8226, 1490, -853, 417, -9675, 235, 119, 2717, -8136, -831, -99, 822, -1201, 
    484, -566, -15387, 1250, 2312, -1365, 7777, 348, 912, 1483, 3379, 879, 299, 618, -2007, 1007, 
    882, -599, -1562, -527, 912, 87, 2638, 2091, -2315, 101, -2748, -211, -563, -850, 1527, 2071, 
    3428, 634, -1506, 583, 1852, 425, 1146, -2074, 1749, 1446, -97, -2333, -3187, 3365, -2466, 325, 
    1959, -498, -485, 547, -1720, -298, -1961, -4957, 427, 1044, -761, 232, -295, 3693, -682, -218, 
    -2936, -366, -5925, -457, -1377, -1031, 3554, 1706, -2226, -73, -961, 98, -812, 456, -1917, 350, 
    1295, -409, 658, 814, 3875, -308, 518, 2082, -1302, -1773, 3201, -5798, -2335, -124, -267, 1722, 
    1497, -2325, -2206, -3055, 150, 700, -3525, -3742, 3857, 1255, 4484, 8948, -95, -1620, -827, 1823, 
    3659, 2174, 2020, -947, -610, -825, 131, -8669, -4793, -860, 1129, -2687, 2804, -5786, -978, -4980, 
    -512, -5133, -4136, 204, 3275, 833, 9046, -389, -1078, 3545, -3196, -2633, -837, -770, 780, -49, 
    182, 878, 709, -978, -2020, 776, 1750, 5605, 2453, 365, -1493, 973, 2848, -1079, 2170, -722, 
    564, -1425, 815, -1816, 1064, 2116, -3971, -2226, 1106, -376, -364, 1739, 3838, 252, -928, 1211, 
    -1540, 1415, 820, -1598, 2519, 1561, -2301, 1125, -297, -5768, 942, 41, 1329, 979, 2771, -4507, 
    -1864, 950, -1356, -126, -1445, -1277, 483, 1162, -2632, -1069, -3188, 26, 413, -492, 2594, -779, 
    1561, -1862, -792, 2217, -1109, -859, -5872, 6338, 933, 153, -2384, 2429, -1277, 2477, 3132, -2577, 
    3353, 746, 620, -4279, -456, 1429, -4940, 790, 4889, -2400, -126, 457, -241, 3514, -1103, 1091, 
    1559, -2275, -333, -1813, 3901, -1376, -762, 5476, -1261, -695, -2085, 3323, 1190, 2738, -831, 2535, 
    -3534, -335, -8011, -599, -363, 321, -4507, 60, 473, -790, 4780, -2522, -1955, 433, 216, 2541, 
    -993, 734, -338, -4661, 123, 814, 2107, 677, 762, -1389, -2755, 2119, 2747, 1232, 4037, -3153, 
    2123, -837, 3951, 1757, -226, 838, -1913, 3617, 3244, 1080, -1414, -6, 527, 349, 3406, -2045, 
    -2729, 1799, 436, 6305, 1340, -1288, 1980, -1391, 1616, -7359, -2431, 2345, -1853, -2399, 920, 2032, 
    -20, 5924, -1717, -1931, -2890, -2843, -838, 155, 1625, 5302, -991, -246, -1767, 5674, -230, 560, 
    -100, 580, 1700, 1235, -1979, -1098, 876, -3562, -1156, 1332, -1168, 3705, 345, -413, -420, 798, 
    436, -888, -843, -1147, 2535, -1907, 2150, -363, 539, -775, -172, -4564, 1625, 1804, 1545, 208, 
    1115, -2540, 869, -512, 3216, -1203, -4381, 2877, -426, 324, 202, -76, -2306, -1044, 38, 2860, 
    -1485, 1260, 852, 701, 1302, -734, -1572, 1021, 569, -1282, 216, 289, -728, 2672, 1777, -81, 
    -496, -14, -229, -842, 2241, -274, 2650, 519, 973, 1380, -1095, 6292, 385, 787, 779, 3870, 
    -779, 355, -813, -1406, 4141, -178, 1634, -4381, 2742, 1530, 268, -3081, -3525, 1310, -734, -2907, 
    251, 1322, -556, 1405, -3069, 6346, -2519, 4935, 16, 2396, 2320, -1027, 960, 1908, 544, 5189, 
    67, -1314, 222, -114, -3566, 4487, -1472, -1160, -255, -39, 626, -1511, 331, -2585, -1135, 568, 
    136, 1222, -671, 79, 3478, 1468, -1682, -2786, -469, 47, -517, -2319, 626, -1358, -2804, 916, 
    -3528, 2717, 1532, -3452, -1023, -3572, -1809, -919, 955, 63, 59, 2851, 957, -580, 183, 2366, 
    990, 2128, 164, -616, -823, -6833, 2094, 372, 73, -126, 1240, 143, 355, -1510, -168, -1333, 
    783, 2046, 1646, -436, -1082, -733, 1178, -539, 1128, -865, -5879, -172, 262, 968, -2431, -1333, 
    -1203, -41, 965, -567, -998, 10, -930, 655, 1317, 1375, 1529, -1810, -887, -171, 145, -2822, 
    -1204, 1200, 828, -1674, 258, -701, 1176, -2315, -2369, -2202, -206, -1513, 1699, -1670, 935, -440, 
    -1364, -843, 369, -3485, -1696, 1543, 1981, 70, -486, 4309, 1757, -462, 1327, 382, -2303, -518, 
    -1311, 2253, 951, 1100, -1773, -559, -2053, -1346, 1454, -5735, -176, 167, 989, -8931, 2338, -801, 
    -1575, 28, -3789, 1610, -3356, 2682, 3458, -630, 7655, -1022, 364, -1201, -858, -930, 1502, -181, 
    -173, 829, -893, 1047, 7531, 2009, 2158, 3634, 5583, -5288, 492, 1015, 634, 5132, -93, -613, 
    -100, 526, -3281, -1658, -2451, 2380, 1107, -2247, 411, -1474, 716, -1906, -255, 3802, 3359, -227, 
    -49, -8489, -9948, 1195, -1753, 3724, 5024, 295, 3482, -2975, -2825, -3841, -5051, -916, -1045, 1765, 
    -1298, -313, -300, 702, 1327, 895, -2078, -674, -71, 440, 2022, -4555, 1589, -1541, -1228, 698, 
    366, -2623, 191, 735, 3002, 229, -1963, -1066, 1865, -233, 2028, 2004, -696, -1672, 77, -3140, 
    -777, 1516, -201, -1309, 2949, -1480, -1381, -9167, -2983, 2971, -1839, -4213, -1269, -960, 3297, -358, 
    -2491, 150, 41, -867, 3558, 5566, 12911, 1929, 935, 1023, -138, -136, -1306, -1895, 4715, -507, 
    253, 985, 2179, 234, -3439, 567, 1030, 2388, 7694, 255, 2374, -1555, 2508, -88, -256, 508, 
    -4196, 1669, 136, 3647, -1621, 2763, 641, 2132, 499, -2119, 2221, 4208, 4130, -2090, -445, 1825, 
    -2076, 833, -1508, 5266, -1069, 557, -2268, -5771, -403, -2444, 165, 3695, 951, 372, -2139, -281, 
    939, 5642, 4281, 435, -206, 573, 1122, 506, 1591, -1834, -3636, -1428, 2650, -1327, -1184, -128, 
    3613, -3553, -2757, 342, -1457, -2621, -4165, -978, -4115, 557, -405, -359, -4083, 3631, 3814, -761, 
    -1615, 3539, 2062, -2397, 1078, 458, -1707, -2198, -1623, -2210, 127, 1288, 4379, -2498, 2322, 5635, 
    -351, -64, -3101, 6894, 2651, -812, -3961, 23, -706, 1973, -234, 6656, -2283, 521, -597, -1685, 
    1354, 1147, -909, -1861, -731, -889, -6915, 376, 194, -10160, 1167, 1065, -211, 2422, 4924, -1248, 
    838, 141, 2855, -7585, 4101, -5520, -452, 3662, -6031, -3448, -4353, 8135, -9236, -2204, -676, -1221, 
    -544, 3277, 5173, -3197, 543, -6530, -4414, -1435, -6309, 6409, -7614, -2841, -1358, 9891, -3876, -443, 
    -3317, -1910, -1396, -1112, 591, 2035, 1726, 588, 9605, -2874, -6010, 544, 6660, 5308, 313, -2434, 
    -1472, 5093, -2373, 6579, 4601, 4267, 6990, -7362, -4615, -4080, -1380, 6546, 4325, 174, -1222, 3029, 
    2337, 2261, -1106, -1948, -8418, 10483, 494, 2724, -2372, 580, -1992, -134, -5072, 4472, -2744, 2933, 
    3848, -605, 639, -682, -7379, 1315, -11014, -1012, -4414, 4054, -2939, -9120, -1962, 1661, -3708, -1876, 
    893, 178, 4561, 3707, 11620, 5699, -3739, -1746, 4638, -3967, 821, 1624, 939, 757, -4497, -10644, 
    4178, -623, 925, 211, 8059, -6370, 4619, 12673, 1149, 2325, 1423, 3465, 1182, -708, 10741, 883, 
    5183, 11124, 10817, -1740, -1739, -7041, -8123, 15972, 1629, -1259, 5098, 788, -6393, 474, 319, -1453, 
    -5690, 1706, -2222, 3579, 1949, -9845, -19345, 3381, -5705, 1444, -1586, -9651, 5936, 601, 0, 408, 
    -458, 10714, 1863, 5095, 14461, -2570, -174, 11291, 6639, -2517, -4586, -3070, -382, -1949, 4690, -1750, 
    -2238, -8462, 8186, 12074, -5579, -5584, -9666, -7028, -3647, -4367, -6755, 2890, 3427, 1071, -2054, -394, 
    560, 2919, -839, 2207, -1587, -3068, -725, -2323, -5146, -1589, 1547, -3136, 2397, -1029, -168, 4331, 
    -3772, -1433, -362, 6688, 2937, 628, 1091, -1275, 2501, 1924, 1612, 5129, -1131, 581, -1887, -6293, 
    2304, 4677, 8310, 6917, -5434, 1691, 1218, -2304, -1135, 1028, 487, 660, 3015, -4865, 2651, 353, 
    -4154, -7461, -5455, 3639, 4008, 7106, -725, -1742, 161, 5994, 1984, -216, 772, 1218, -328, 980, 
    -3744, 75, 1249, -1077, 509, 4182, 6043, -998, -300, -83, 449, -5721, 147, -1816, 1285, -9762, 
    1207, 4406, 1513, 255, -1995, 4372, 3400, 3123, -912, -2468, 7, 1996, -230, 4388, 1676, -2706, 
    -2575, -2740, 1193, 1636, -3982, 7892, -626, 3530, -281, 643, -2595, 5424, -2964, -704, 2147, 1582, 
    -41, 6937, 3405, -1233, -1066, 3002, -4332, 3033, 593, 2623, -730, 1012, -2606, 2255, -3295, -805, 
    178, 666, 437, -4197, -1843, 2775, 2508, -7772, -1437, 1146, 2339, -1086, 262, -1607, -82, -1803, 
    -1833, -2582, -264, -500, -5116, 228, -984, -2411, 1870, 2879, 2855, 1181, 4249, -1085, 4335, 4054, 
    -75, -3358, 512, -439, 1353, -2034, 1035, -5080, -4808, 2690, 563, -3366, -4763, -318, -1062, 2272, 
    1016, -15, 151, 164, 785, -1135, 43, 2947, 815, 1321, -484, -828, -1, -1287, -7369, -823, 
    -3174, -487, 5114, -4692, 5296, -860, -4137, 2918, 890, -493, -20, -1898, -130, -1578, -3114, -905, 
    2047, -815, 2265, 5346, -4735, -1329, -4284, -2802, -188, 903, 547, 33, -5149, 2897, -574, -3201, 
    -2959, 462, 1347, 6584, 1771, 400, -692, -727, 601, -93, -952, 928, -110, 1108, -304, 2512, 
    -824, 703, -143, -3068, -330, 1353, 2195, -1268, -3246, 6100, 445, 1940, -785, 1294, -34, 2195, 
    -1758, 1232, 2744, 1883, 260, 2766, 2327, -1538, 236, -1596, -871, -1030, -1322, 1880, 3079, -104, 
    -1591, -1617, -2480, -3192, 267, -278, -42, -2836, -5510, -1808, -830, 785, 993, 3211, -285, 1023, 
    1739, -4798, 563, -2747, 979, 1159, -640, 2319, -1250, 3309, -697, 1045, -4367, 463, 1182, -1387, 
    -1872, -2469, 1489, -381, 2299, 694, 2693, 1443, 1772, 1137, -4083, 68, 1401, 4407, 3519, 1388, 
    -757, 625, -2348, -1198, -4670, -132, 1155, 118, -3730, -412, -460, -1419, 1931, -381, 1576, 108, 
    -2565, 47, -1512, -2142, -2938, -292, -940, 158, -4977, 1318, 1155, 70, -754, -475, -608, -430, 
    1122, 1138, 243, 2399, 16, 1147, -196, -1481, -1271, 17, 445, -1157, 779, -683, 555, 613, 
    -2135, 4352, 4270, -689, 700, -4211, -2743, -943, 1737, -748, 641, 1224, 791, 1304, 3709, -2283, 
    -594, 1032, -1480, -908, 4374, 551, 1238, -1122, -2636, 863, 2074, -1791, 3274, 69, -1834, -460, 
    -2156, 664, 352, 464, -469, -963, 1069, -2611, -3705, 1881, 658, -264, -3219, -810, 1096, 2957, 
    50, -1142, -376, 43, 149, -663, 530, 923, -174, 1391, -2033, -1220, -752, -1580, 381, -1754, 
    2037, -64, -444, 904, 1745, -161, 6808, -526, -1291, 476, 1823, -17, 632, 1903, -1107, -46, 
    2108, -1599, 23, 796, -260, -467, -2572, 1363, -4266, -250, -905, 2086, -1464, -172, 650, 35, 
    345, -1314, -368, -328, -2274, -1111, -747, -4479, 1536, 885, -347, 2308, -7263, 1645, 76, -156, 
    755, -515, -1541, -5837, 1865, -2237, -3009, -5156, -197, -1711, 534, 2151, -728, -670, -813, -563, 
    1046, 2444, -3516, -2067, 3045, 2024, 3738, -653, -1996, -1634, -1029, 1573, -2286, -1323, -373, 377, 
    -3485, 2506, 4645, 11, -2749, 1095, -615, -348, 6369, -1980, 3347, -205, -3534, -2871, -2915, -1552, 
    2604, -409, -1307, -2223, -5522, 851, 377, -2778, 3847, 933, 395, 2767, -2272, -2109, 42, -1118, 
    1120, 556, 181, -4393, 1196, 955, -566, -2367, -2139, 1080, 2010, -4543, 380, -32, -474, 1967, 
    1681, 594, 1725, -651, 538, -1708, 8096, -687, -1470, -4821, -6819, 3, 89, 2396, -3410, 114, 
    1928, 1194, 508, 49, 1396, -2444, -2276, 1989, -1410, 343, 1323, 2271, -1564, -3368, -813, 3288, 
    6793, -2208, 1029, 2938, -5832, 390, 645, 150, 8990, -3464, 2179, -502, -1717, -819, -935, -316, 
    -2804, 988, 3889, 1655, -855, -2436, -363, -276, -952, 1618, 117, 2467, 1968, 1130, -794, -3119, 
    185, -1369, 1297, -3720, 647, 570, -4192, -1235, -1070, 2030, 2865, -2881, 3175, -2116, 2389, -3449, 
    2599, -728, -641, -131, 1701, -768, -2797, -312, 7857, -274, -354, -939, -4388, -1383, -868, 1135, 
    -6549, -336, 74, 661, -2386, -2008, -2074, 2505, -7181, -1518, -2580, -886, 1053, -755, -1499, 1854, 
    -1558, 362, 1890, 857, 2021, 3727, 4340, 2674, 1188, -3633, -2923, 5882, -169, 161, 3082, 3644, 
    -2812, 434, -1144, 847, -3150, -2996, -4116, 5630, -1316, -5419, -3498, 836, -2969, 1642, -83, -1030, 
    -108, 1455, 567, 3163, -1832, -597, -3758, 4391, 1795, -1682, 1131, 113, -637, 3238, 5247, 1406, 
    -4222, 3183, -2680, -1530, -7839, 1543, -4297, 2434, 4756, -2071, 1796, 541, 3569, -563, -749, -128, 
    3074, 1199, -246, -5308, 3110, 6040, -2114, 4565, -3249, -2111, -1213, 1545, 821, 3679, -472, -821, 
    1279, 2501, -2137, 2950, -280, -1426, -6285, -177, 2715, 1981, 3371, -4668, -4149, -1794, 3340, 396, 
    824, -2852, -1800, 3285, -405, -373, -1606, 4613, -4544, 1457, -707, -343, 4140, 1562, -142, -1866, 
    -9217, 2585, -1984, -393, -121, 1262, -2182, 2197, -3697, 3109, 2127, -7036, -3605, 3131, 105, 503, 
    641, -1569, -1881, -7109, 2214, 1700, 3559, 1685, 2572, -1844, -960, 2177, -589, -3132, -2538, -1557, 
    433, 738, 1121, 148, -2457, -2380, 1538, -99, -3518, 6709, -1678, 1695, -4784, -4752, -2281, 1361, 
    -1903, -38, 1364, 2072, 167, 510, -2270, 403, 5929, 548, 128, -400, 1723, -1989, 745, 2626, 
    -9668, -160, -965, 874, -6823, -1462, 348, -2296, -5995, 2997, -1292, 1192, 244, 648, 356, 1056, 
    3359, -447, 658, -579, 2977, 852, 436, 402, -169, 1152, 3918, -3747, 170, 1533, -1185, 712, 
    -498, -2670, 2216, -277, 973, -1763, 5, 502, -584, -1787, 1258, -936, 230, 229, -697, -1517, 
    -682, 1715, 671, -182, 5824, 990, 2163, -1115, -4041, 1486, 908, 2886, 1072, -493, 475, -251, 
    -5267, -370, -32, 463, -3567, -4123, -341, -1242, 4145, 870, -160, 1346, -745, -1112, -714, -1701, 
    325, 699, -1300, -594, -29, -2781, -1494, 1396, 947, 3244, 694, 2457, 2342, -673, -2513, 2065, 
    -612, -374, 1112, 1033, -3820, -1371, -1645, 1484, -776, -35, -1774, -151, 21, -2576, -2604, 506, 
    -3675, -2123, 438, -1593, -2804, 263, -847, 1181, -1713, 878, -4886, 818, 2129, -1723, -1311, -1481, 
    -5727, -1065, 1583, -2639, 645, -603, -149, -126, -1328, 482, -765, 4313, -687, -2500, 836, 3170, 
    2738, 7, -2304, 36, -62, 586, -2551, -287, 121, 4029, 1591, -1191, 127, -3399, 1337, -606, 
    2787, 1060, 1242, -3453, 554, -976, -42, -936, 1368, -2623, -27, 1331, 586, -1153, -356, -1781, 
    1101, -453, -187, 336, 3333, -313, 1825, 454, 1968, 2073, 3019, -3616, -6298, -1128, -1750, -2035, 
    7740, -294, 16, 720, -6359, -4236, -422, 317, 2712, -1563, -1264, 3429, 5576, -896, 317, 2365, 
    -799, 296, -1946, 1109, 1028, -1295, -2735, 449, -3861, -645, 4194, -2014, -1669, 365, 1615, 2764, 
    -173, 2407, 3529, 469, -575, -322, 183, -240, -2953, -1274, 1286, -126, -981, 264, -1497, -999, 
};

static const int16_t fx4_paramModel1Alpha[16] = {
    594, 4693, -939, 98, 349, 6108, -5382, 941, 6958, 3432, 4378, 201, 5903, -2599, 104, -5598, 
};

static const int16_t fx4_paramModel2Bias[16] = {
    917, -344, -796, 525, 734, -745, -1866, 2804, 1765, 149, 765, -573, 515, -356, -4974, -606, 
};

static const int16_t fx4_paramModel2Weights[2304] = {
    1276, -1966, 881, 2587, -1030, -2216, 219, -57, 1854, -857, 789, 2224, -1779, 737, 2204, -1273, 
    1790, -942, 2251, 519, -221, -1678, 1386, 341, 1353, 1261, -340, 2985, 472, 1079, -2565, -848, 
    2140, -2485, -582, -190, 2064, 2310, -316, 599, 726, -1605, -1742, -3075, -599, -1960, -4154, 2961, 
    3939, 1530, 1292, 1252, -683, -319, -102, -527, -227, 3010, 768, 2403, 671, -2489, 3401, -1581, 
    228, 439, -750, -4088, 1209, 195, 658, -1182, 1052, -1292, -1002, 489, -248, 465, 929, -944, 
    -560, 1783, 1871, -846, -567, -637, -899, 757, -316, -709, -280, -866, -46, -218, 966, 233, 
    -1501, -195, -1859, -1128, 1229, 290, -312, 849, -1267, 1409, -590, -1941, 775, -1261, -445, 1481, 
    -1444, 368, -1126, 1056, 1673, 324, 725, -990, 1468, -2015, -1514, -1654, -1150, 911, -1606, -2301, 
    2237, -3045, 23, 1015, -1144, 456, -659, -1507, 2477, 434, -966, -991, 1321, -482, -31, 1326, 
    -409, -1872, 959, -555, -110, -845, 257, -724, 311, -145, 223, -1010, 462, -267, 419, 212, 
    -55, 102, -245, 121, -768, 1619, 660, 1791, -359, 4562, -487, -1412, -83, 1695, 210, -882, 
    236, 1110, -2573, -942, -376, 100, 240, 1532, 1569, 1189, 396, 1637, -619, -539, 643, 291, 
    -472, 1839, -872, -1682, 2594, 874, -326, 1508, -232, -1064, -682, 168, 1494, -539, -723, -769, 
    -640, -1011, 1187, 992, 559, -2001, 3059, 3076, -315, -111, 252, 551, 555, -3086, 144, 788, 
    380, 1105, 1364, 526, 2109, -142, -1797, -1278, 208, 492, 1352, -1214, 484, -1408, -1797, -1287, 
    -2590, 961, -951, -39, -3014, -912, 961, -982, 810, -186, 1160, -1001, -1007, 628, 369, 1061, 
    608, 2716, 2038, -1677, 4634, 809, -3245, -1595, 4703, -3882, -315, 566, -4515, -164, 659, 501, 
    2792, 596, -454, 2320, -1587, -6460, 820, -608, 1662, -710, 737, 5830, -1100, 1199, -3168, 3087, 
    -2357, 90, 1976, 1904, 12, 710, 3161, -3749, 45, -386, 639, -2175, -719, -33, -2249, 544, 
    3323, 305, 4398, 3206, 2909, -6036, -11251, -3925, -4699, 4561, -677, 5, -3761, -1764, 461, 764, 
    2814, 255, -347, 1865, -7, 1370, -1367, -79, -3944, 607, -137, -916, -403, 115, -995, 722, 
    -2002, -5752, 3502, -5478, -2808, -3952, 2608, 1257, -369, 1347, -868, -3954, 153, 1687, 1030, 1023, 
    -2683, 3547, -6063, 4184, -114, 613, 1550, -1285, 1225, 1174, -4, -3311, 325, -1606, -113, -1895, 
    -1111, 852, -2545, -1626, -1917, -2597, -4684, -1327, -957, -1653, -1455, 402, 718, 1271, -304, -765, 
    2026, 51, -594, 908, 822, -814, -518, 463, 2030, -2804, 1879, 352, 287, -1041, 939, -985, 
    -61, -1397, -327, -569, 344, 2010, 1958, 600, 342, 523, 49, -739, 908, -2419, -1206, -1740, 
    1669, -1671, -3844, -1581, 1132, 1428, -94, -270, 574, 2397, -1339, -2534, -1096, 1722, -1203, 486, 
    -7027, 1288, -582, -2353, 4333, -1260, -931, 400, 1753, -566, 1670, -953, -1182, 1237, 472, -1745, 
    -3822, 489, -1244, -67, 2733, 916, -708, 134, 1448, -529, 954, 3764, -5621, -530, -1543, -1177, 
    1205, 3147, -2778, -1146, 335, -1537, 1228, 4270, 1372, -1371, -1304, -4195, 836, -3017, -536, -2977, 
    1368, -2755, -1327, -3811, -199, 909, -797, -1600, 1066, 153, -1503, -933, -624, 3132, -8437, -3094, 
    1246, -1653, 4639, 2749, -3428, -1691, 2524, -1283, 1799, -1959, 1177, 2079, 4782, 408, -10682, 2274, 
    1424, -2076, 39, -2942, 2224, -125, -318, -1374, 5545, -3052, -970, 1124, -2328, -989, 628, 537, 
    28, -3624, 2640, 2645, -1063, -998, -1820, -966, 227, -3305, 2072, 1874, -203, 1192, -2442, 1482, 
    -768, 360, 357, 180, -626, -846, -259, -1935, 209, -121, 830, 2743, -280, -224, 284, -462, 
    1471, -4202, 2102, 421, 3324, 3313, 998, 355, -1391, -883, -683, -658, 1399, 746, 301, 989, 
    2301, 425, -68, -870, 701, -1010, -717, -2371, -3434, 728, -246, -2147, -760, -1653, -885, 411, 
    -1477, -476, 2161, 44, 724, 955, -993, -1229, -224, 751, 830, -376, 585, -254, 1092, 150, 
    -1588, -1705, 4876, 1204, 152, -1743, -540, -174, -68, 413, 337, -163, 238, 848, -1014, -228, 
    1643, 279, 5, 525, 1497, 874, -505, 2303, -390, 124, 266, -182, -641, -128, -898, -1239, 
    1999, -159, -1130, 55, 578, 723, -204, 866, -73, 1804, -315, -428, 1408, -2316, 2020, -757, 
    11, 440, 23, -567, -172, -309, 1150, -398, -136, 852, -2147, 2154, -189, 164, -840, 3077, 
    715, 1710, -275, -872, -510, 1063, 38, 860, 99, 572, -648, 4152, 329, 1281, 3387, -2786, 
    -546, -1520, 228, 548, -1761, 1026, -1245, -1773, -869, -578, 902, 389, 3157, -1038, 2064, 435, 
    5223, 560, -1378, 659, 2542, 1574, -1297, 328, 55, -1389, 85, -3877, -3860, 1796, -398, -2897, 
    82, -820, 2836, -1451, -458, -3491, 147, 1694, -46, -4619, 330, 4566, -58, 822, -345, -1709, 
    -489, -1504, 423, 2693, 1386, 649, -2514, -871, 141, 2862, 851, 2252, 782, 2544, -4232, 166, 
    950, -70, -6272, -3137, -2956, -1277, 738, 543, -2362, 1002, 2055, 651, -2255, -1344, -754, -1154, 
    608, 1882, 1088, 1286, 537, 1829, 2757, 626, -3661, -289, -918, 1592, 5166, -2771, 1687, -3927, 
    -335, -2506, 368, 783, 373, 2116, 1064, 1937, -692, 1891, -2912, -138, 2976, -8691, 5965, -1440, 
    728, -5876, 2011, -175, -2776, 695, 1256, 609, -2881, -2867, 4520, -1072, 371, 899, 9938, 322, 
    -531, 2174, 2057, -62, -3539, 3200, 2349, -3085, 6946, -2965, -3093, -435, -1916, -2602, -9030, -1107, 
    -275, 633, -408, -2181, -840, -1178, 2734, 1311, -3204, 11, -1382, -630, 2173, -1138, -1582, -131, 
    -1596, 2451, 578, -1318, 225, -738, -1235, 922, -32, -2804, -10927, -11099, -762, -3683, 1833, 2972, 
    -3929, -2528, 2035, 413, 3941, -1386, -6512, 955, -3781, -5008, 893, 700, 770, 2043, -2646, -1491, 
    -2853, -520, -1789, -3682, 4340, 3448, 3812, 3550, -3634, 3485, -5280, -329, 677, 721, 239, -1670, 
    1737, 1865, -925, 2833, 280, 425, 1632, -1712, 838, -4142, -613, -44, 80, -763, -1057, 3, 
    -3248, -3408, 3845, -1, -208, -4047, -1354, -3201, -388, -1007, -585, -359, -368, -2295, 1193, -248, 
    -4087, -313, -2762, -552, -2510, 1510, -62, -1011, 1040, -3372, -1016, 18, 330, -3098, 125, -701, 
    2788, -241, -7812, 229, 1366, 3892, 54, 14, -2478, -622, -646, -1375, 487, -1768, 1857, -204, 
    871, -3227, -730, -400, 1565, 3392, -687, 514, 1432, -1334, -707, 1118, -608, 120, 1499, -1231, 
    -963, 448, -2940, 550, 636, -1798, 1628, 3183, 795, -121, 1521, -2388, -214, -2695, -1059, -4808, 
    2160, -665, -3693, -890, 191, -611, -2613, -770, 202, 2539, 208, -331, -3216, -5256, 729, 277, 
    -270, 963, -431, -411, 729, 547, 1057, 1316, -85, -12, -21, 540, -485, -2726, -9, 320, 
    -274, 103, -2835, 1743, -4720, 2000, 5087, 1842, -3328, 1108, -515, -2851, 2581, 343, 262, -7582, 
    -1584, -2314, 4486, 887, 2366, -3407, 4804, 1358, 975, 1208, 559, -4371, 1258, -2722, -4603, -4606, 
    -2546, 6699, 3764, 1426, -6674, 2304, 1445, -9290, 693, 1439, 2496, -927, -138, 1212, -5820, 1307, 
    -857, -4304, 2869, -881, -11378, -8421, 3033, -2171, 1479, 2165, -1859, 932, 1307, -2945, 231, 250, 
    4848, 997, -8400, 1607, -4445, -4195, 5382, 7706, -13759, 1728, -2898, 1189, 2554, -1629, -2261, -682, 
    -1640, 729, 7506, 1825, 7064, 1973, -1915, 91, -2441, 1303, -4146, -13033, 687, 5277, -613, -8, 
    920, -1081, 5110, 419, -1229, -3588, 2982, 3414, -1019, 496, -3886, 2054, 707, 2167, 2750, -2216, 
    -80, -819, 3010, -3859, -4112, -2236, 5336, 5913, 2052, -446, -10433, -2465, -3373, -5280, 4003, -1062, 
    -3663, 5014, 4318, -6144, -2018, -783, -66, -10, -3046, 3264, -1372, 2298, 6553, 5396, -1861, 2571, 
    9322, 8520, -5416, -3480, 1104, 6628, 1223, 4891, -1417, -2226, -6297, 2078, -722, -5048, 1534, -3302, 
    -1013, 1608, 663, -761, 1560, -2385, -2837, -4134, -739, 218, 1253, 484, -2350, -2490, 3535, -662, 
    4344, 3515, 9108, 2928, -7724, -2424, 1531, -1098, -1799, -198, 4729, -143, -2787, 3385, -154, -1587, 
    -7565, -2710, 1530, 2076, 3333, 3005, -1367, -2525, -1412, -1507, -1152, 2622, -7396, 3988, 2065, 976, 
    2155, -383, -4333, 1835, -79, -434, 2377, 2220, 3759, -5408, 647, -11056, -1849, -5942, -10079, -4609, 
    5288, 2427, 7528, -2323, 960, -659, -3415, 2820, 1182, -2656, -6160, 1497, -3053, -12031, -1708, -6, 
    -2240, 38, 1840, -2616, -1033, 1110, 1674, 3633, -1113, 924, -348, -2428, -1854, 3950, -4554, -1967, 
    4058, -746, 1346, 3200, -1578, -1246, 1472, 481, 3805, -1270, 378, -212, -1840, -1448, -184, 2325, 
    -988, -638, 5376, 5667, 353, 2836, 30, 27, 288, -3299, 3236, 4175, 602, 946, -2753, -997, 
    -915, 407, -1700, 1997, 574, 1696, 1798, -3212, -432, -1911, 802, 1268, -248, -2126, 2474, -470, 
    -1232, 560, -130, 401, 3784, -2137, -876, 804, 91, 3472, -3324, -828, 938, -1061, 1117, -622, 
    2091, -876, 591, -253, 336, -1903, -701, -1857, -2934, 723, -131, -1860, 1234, 389, 1468, -4482, 
    -1255, -705, 901, 996, 87, 386, 871, 187, -1149, 3605, -867, 1325, 908, -3762, 1311, 1148, 
    -357, -3458, 1872, 1284, -992, 2565, -885, 2791, 673, 2002, 455, 869, 63, 1201, -3579, -414, 
    117, 450, -6, -336, -33, -1371, -1029, -361, -10, -764, -1606, 78, -829, 1899, -331, -376, 
    -2706, -956, 449, -1357, -1069, 400, 568, -2130, -2359, -1598, 17, -1953, -803, 619, -5489, -7723, 
    -238, 790, 691, 1236, 399, 603, -825, 834, 1891, 2207, -3673, -464, -1986, -68, 3286, 2186, 
    816, -1693, 433, 1669, 1813, 1420, -1516, -3249, 1931, -849, 963, -2052, -2645, 1033, -315, -7239, 
    -846, 683, 2126, 328, 2886, -1304, 682, 1309, 1290, -567, 3499, 712, 649, -5737, -108, 3025, 
    4678, 3522, 1846, -2082, 2271, 2835, -1419, -583, 5599, 1291, -8038, -11705, -5927, -1420, -739, -1140, 
    -2665, -2752, 5440, 341, -402, -3252, 1636, -1322, -569, -5765, 2508, -3683, -984, 4731, 23, -4232, 
    -4048, 5374, -2514, 285, 1691, -2025, -1751, -493, -254, 6003, -6579, 8110, -2004, -3726, -1468, 2285, 
    2277, 122, -2485, -809, -4912, 541, 1072, 540, 9693, -8637, -4125, -2463, 1381, -161, -194, -813, 
    -723, 413, -910, 769, 620, -1100, -3798, 298, 441, -1651, 2172, 98, 191, -355, -2703, -15, 
    -259, 20, 2425, 2301, 2579, 3239, 412, -2050, -867, 465, -7253, 7016, 728, 2148, 2896, 2476, 
    -1632, -4543, -363, -290, 5035, 2397, -2895, -210, -1827, 1005, -38, -849, 4769, -928, -920, 77, 
    -1143, 18, 624, -1098, 603, 5195, 32, 1452, 1463, -4310, 585, 745, 444, 2006, -62, 456, 
    1829, 134, 799, -735, -2444, 2136, -2333, 1266, 96, -68, 965, -624, 2053, -1881, -1120, 330, 
    -503, 1128, 188, 2682, -796, -3495, 1073, 109, 190, -1049, -1845, -9578, -565, -1442, 2632, -767, 
    -1757, -4529, 1205, -250, 0, -385, -380, 293, -1484, -1005, 1148, -37, 1775, 4173, -1372, -915, 
    -320, 147, 137, 915, -2303, -715, -849, -1392, -846, -2058, 290, -788, 414, -981, -2504, 1326, 
    1752, 1622, 522, 704, 116, -554, 81, 122, 1719, 1831, 2028, 238, 534, -567, -344, 335, 
    -1625, -129, 839, 609, -1458, -1014, 340, -1456, -268, -779, 1066, 205, 629, 115, 828, -3675, 
    -3001, 423, 1020, 13, -2731, 4284, 704, -396, 482, -1828, 1764, 1697, -302, 1740, 1414, 781, 
    -50, -3308, -377, -600, -277, -1726, 280, -2549, -7, -1323, -1790, -312, -35, -79, 439, 23, 
    472, 71, 3347, -402, 1028, 2128, -914, 1634, 578, 769, 1157, 1096, 587, 43, 69, 118, 
    191, -1297, 1633, -56, -267, 65, 3190, -645, 566, -831, 91, 460, -399, -1269, -947, 197, 
    321, 1346, 367, -143, 1486, -1915, -958, 113, -860, -562, 1107, -344, -2201, -3037, 1108, -381, 
    2254, -1840, -2154, 289, -2745, -376, 2279, 237, -503, 975, 906, 264, 139, -1231, -106, -829, 
    55, -846, 2781, -759, -2248, 540, -757, -581, 1501, -2720, -824, -149, 317, -159, -260, -991, 
    -363, -2478, 1012, 2659, 3275, 1390, -5963, 691, -291, 1360, -970, -3934, 782, -873, -1079, -843, 
    438, -3113, 338, -18, -2028, -2487, -1178, 1323, 958, 1932, -360, -938, -279, -523, -2155, -871, 
    1585, 670, 2766, -1095, 1579, 3043, 3576, 2739, 2415, -1493, 381, -470, -330, 1276, 1502, -331, 
    1520, -394, -916, 60, 3996, 233, -1814, -2162, -1807, -1280, 2002, 45, 1453, 921, -830, 1061, 
    -1278, -1209, 1357, -53, -2849, -807, 2565, -38, -401, -576, -2032, -10011, 487, -502, -5314, -2244, 
    -1934, -1072, -509, 1659, 1113, -187, 2553, 617, 997, -1429, -138, -72, 1001, -9536, -4395, -600, 
    644, -629, 327, -901, 1208, 641, -3844, -4022, -2049, 1109, -777, -117, 1668, 1750, -3726, 1180, 
    -1267, -3596, -2767, 1654, -151, -324, 1599, 63, -248, 150, -2159, 1139, 5772, 1804, -212, 3489, 
    -308, 2096, -3140, 668, -2158, 677, -1607, 312, 1849, 971, -1153, -739, -1283, -6654, -3422, -7944, 
    -1648, 455, -463, -447, -637, 3794, 2685, 5259, -1027, -3665, 1992, -1571, -8865, 1305, -1637, -1194, 
    -1361, -2192, 803, 396, 2886, 2752, 184, -1397, -420, 393, 1801, -445, 2148, 155, -1308, 786, 
    4206, 840, 934, -498, -894, 1449, -1379, 194, 2390, 51, 2411, 2753, -595, -227, 974, -171, 
    899, -2301, -2670, 426, -560, 1763, 2367, 2550, 1288, -2534, -880, -13829, -1137, -2121, 1299, -282, 
    -3679, 667, 1368, -794, -30, -4873, 72, 122, -224, -13736, 34, -531, -358, -7368, 1076, 405, 
    -946, 671, 950, 1657, -3079, -672, 3340, 1176, -1661, 969, 1785, -707, -592, -1438, -214, -941, 
    -151, -916, 2026, -884, -499, -1022, -188, -1817, 335, -1107, 754, 65, -900, 292, 379, -535, 
    -514, 1171, 1471, 2897, 570, -1047, -562, 1964, -456, 956, -743, -4778, 387, 79, -1394, -267, 
    1605, -1458, 2879, 1170, 705, 6132, -844, -300, -847, -1051, 1049, -864, -784, -656, 432, -257, 
    -595, 258, 1066, -641, -645, -688, -113, -200, -259, 1207, 361, -274, -167, -114, 1271, -184, 
    -862, -597, 2086, 352, 1232, 645, 1978, -2092, -1487, 425, -484, -1105, 2718, -1857, 919, 1064, 
    -335, -216, 670, -269, -1126, -275, 1635, -778, 117, 1139, 161, 1608, -103, -865, 1212, 3772, 
    -270, 332, 706, -223, -746, -1324, 1557, 1076, 968, -746, -856, 494, -385, 3721, -560, -224, 
    -909, 324, 1235, 987, 98, 890, -1203, -732, 1664, 429, 329, 307, 698, -1499, -3269, 1346, 
    -73, -779, 822, -265, 537, 626, -1404, 1770, 248, -756, -138, -1735, 397, -941, 3852, -2651, 
    -408, -351, 1104, -812, -1144, -212, 1867, 2449, -863, 209, -792, 369, -2232, -110, 3195, 3463, 
    -413, -2940, 53, -273, -1354, 3757, 769, 898, -496, 1553, -616, -871, 823, 450, 5801, 1436, 
    -852, 433, -739, -772, -105, 140, 52, -817, 669, 1164, -149, -1180, -1338, 3089, -1, -1541, 
    -79, -1240, 1585, 1582, 4311, -1242, -345, 3128, -3992, 1291, -2058, -9806, -895, 130, -383, -55, 
    1145, 3360, 684, -514, -352, -1878, 1945, 5315, -3443, -3594, 2187, 7283, -243, 784, 559, 2888, 
    1452, -3041, 106, -1280, 155, -2922, 796, -688, -2463, -33, 130, 4063, -840, -2251, 1071, 1110, 
    -1400, -1449, 1426, 2691, -3176, -1225, 1268, -1001, 1235, -1741, 549, -2321, -508, 240, -382, 157, 
};

static const int16_t fx4_paramModel2Alpha[16] = {
    360, 37, -850, 2978, 6365, 193, -618, 149, 1510, 938, 994, -846, 695, -908, -438, -1193, 
};

static const int16_t fx4_paramModel3Bias[16] = {
    -3582, 1482, -1344, 359, -1972, -885, -440, -1236, -27, -960, 2184, 1728, 379, 1583, 396, 846, 
};

static const int16_t fx4_paramModel3Weights[2304] = {
    247, 521, -345, -835, 1400, -236, -576, -752, -933, -1861, 185, 1208, -423, 1527, 239, 20, 
    -19, -894, -106, 513, 851, 646, 232, 39, 996, -583, 1109, -809, 620, 1872, 755, 701, 
    -204, 115, -1181, 53, 1014, 735, -567, 924, -2179, 492, -16, -473, -1860, -1570, 2304, -1473, 
    -364, 1230, 418, -199, 1108, 464, -403, 2079, -1295, 1259, 1269, -1129, -987, -1628, -1090, -601, 
    123, 604, -1955, 383, 699, -605, -21, -207, 880, 213, 601, 161, -391, -71, -790, -1404, 
    105, -15, 1181, 195, -1055, 256, -268, -540, 604, 1213, -1661, 1572, -4295, -1580, 3647, -2186, 
    161, -1562, 653, 964, 491, 927, -1470, 917, -1496, -173, -292, -837, -835, -446, 125, -3648, 
    2921, -1801, 1220, -5637, -343, 1476, -4910, 1699, -849, -710, -503, -930, -952, -1857, -3253, -874, 
    -491, -597, 1911, -1112, 421, 760, -673, -512, -18, -130, -631, 379, 729, 1713, -2181, -567, 
    -151, 1096, 13, -779, -1911, 1364, 177, 55, -851, 1098, 226, -1083, -271, -339, -1876, -521, 
    803, -1735, 272, 3785, 1067, -705, -1821, -895, -2249, -913, 1626, 659, -1109, 1331, 3355, 465, 
    275, 73, -744, 2, 1841, 66, -2014, -811, -2234, 748, -261, -1574, 811, -505, -1515, -5764, 
    1063, 352, -480, 2093, -1828, 688, 922, 1865, 576, -60, 360, 420, -323, -958, 392, -1568, 
    483, 828, -1475, 1335, 801, -752, -166, 351, -762, 620, -440, 180, 107, 137, 897, -1329, 
    -356, -1690, -3461, -677, -1579, -765, -1018, 1304, 321, -5, -128, 1062, 2480, 2162, 1147, 63, 
    -440, -355, -636, 165, -3060, 477, 2130, -851, -252, 232, -771, 930, -634, 961, 1593, -1762, 
    -2008, 707, -647, -904, 1293, -330, 491, -3104, 2132, 266, 811, 1501, -264, 990, -300, -3085, 
    885, 927, -15, 600, 183, 60, -921, -713, -1728, -456, -784, 1879, 244, -3828, -1844, 1336, 
    -370, -42, 2017, 112, 1448, 2357, -2253, -230, -557, -1914, -4458, -984, 1105, -2542, -714, -1173, 
    -1057, 1929, 1760, -6324, 1818, -214, 1443, -3613, 4110, -762, 362, -8219, 375, -68, -494, -3199, 
    -1233, 1491, -958, 2343, 1037, 1440, -2699, 151, -1454, 3435, -2921, -1198, 965, -1200, 579, -245, 
    624, 5282, -1216, 1199, -2311, 142, -3404, 69, -1143, -6623, 2084, -1427, -2821, -4940, -359, 367, 
    -1850, 666, -452, 1465, -2003, 941, 1231, -283, 21, -233, 270, -3622, -693, -898, 863, -1525, 
    -3025, -2215, -1079, -503, -1937, 688, -2682, -8235, 116, 268, -1713, -13303, -805, -2812, -1330, -1463, 
    288, -4035, 2346, 1152, -2919, 313, 261, -751, -695, -820, -1020, 41, 248, 1722, -476, 2200, 
    -419, 1607, 77, 55, 2740, -924, 865, -703, -408, -1949, 1142, -650, -794, -754, -1911, 374, 
    -2679, -993, 985, 624, -217, 1076, 2366, 462, -2510, -541, 2906, -238, -637, -147, -596, -582, 
    542, 2040, 199, 9, -2393, -648, 543, 2920, -841, 1708, 577, -9650, 696, -956, -1227, -6917, 
    1101, 399, 728, 1941, -1349, -311, 303, 2031, -818, 2128, -1890, 664, -1278, -2471, 333, -2547, 
    -800, 1067, -1341, 394, 65, -808, 529, 805, 292, -720, -2924, 867, 223, -1011, 496, -578, 
    1427, 1070, -2287, -483, 2981, -966, -1452, 123, -2708, 819, -1847, -558, -551, 606, -496, 206, 
    -2864, 88, -131, -6316, -1905, 267, 2455, -4955, -1192, -2696, 137, -15468, 1181, 487, 1986, -5972, 
    -868, -203, 79, 535, -612, -982, 526, -839, -2504, -2015, 1355, -372, -1039, -157, -62, -628, 
    366, 727, 359, 99, -92, -886, -923, 313, 660, 377, 942, 764, 25, 1179, 748, -1126, 
    91, 96, -2276, 512, -876, 111, -2629, 312, -1013, -644, -2495, -350, 25, -568, -248, -118, 
    -1765, 603, 818, -451, 2700, -99, -440, -15, -2519, 218, 966, 531, 123, -149, -765, 319, 
    -365, 958, -116, -560, 1239, -819, 494, 577, -1931, 767, 1594, -95, 1376, 774, -442, -375, 
    -147, -4064, -1304, -388, 539, -2896, -128, 834, 966, -1638, -1297, -1800, 533, -1778, 805, -1806, 
    121, 420, -118, -560, -538, -267, 1642, 1859, -248, -538, -1192, -210, -456, -232, 1686, -1453, 
    1436, 519, -967, -304, -1959, 317, 866, -996, 1332, -436, -742, 1615, -1802, -743, -1074, -5620, 
    1036, -331, -1747, -1211, -1253, 1238, -1745, -1127, -180, -301, -1979, -557, -178, -703, -384, -360, 
    531, -2509, 1946, 156, -1001, 1684, -5, 9, -841, -2306, 338, -327, 543, -1011, 1018, -404, 
    947, 1213, 711, -1862, 190, -592, 2326, 685, -1089, -1245, 1993, 58, 783, 1186, 512, -90, 
    737, 1681, -1861, -9158, 997, 1166, 59, 1702, 249, 865, 1391, -262, 609, 47, -506, -2475, 
    824, -1030, 1066, 29, -1359, -571, -324, 1542, -986, 735, -286, -423, 220, -1989, 867, 1685, 
    117, -1009, -364, -73, -138, 2471, 125, 1019, -481, -4591, -1338, -55, 606, 280, -353, 709, 
    -350, 1671, -238, -774, -747, -218, -1383, -85, -484, 341, -1586, -808, 1637, -104, -1868, 863, 
    -1329, 473, -617, 1839, -1787, -532, 1908, 909, 1097, -113, 226, -1366, -911, 1143, 1959, 1278, 
    -2576, 475, -2857, -555, 1368, 176, 840, -243, 1594, -782, -989, 1786, 1043, -938, 1396, -1237, 
    -1738, -1431, 1416, -939, 800, -34, -1106, -1597, -366, 1048, -948, 183, 4657, 21, -3063, -1197, 
    -427, -979, 4105, 766, 12, -1524, -2351, -96, -2467, -2220, -19, -696, 90, 2373, 4645, -1227, 
    368, 507, 390, -288, 1643, -8, -2599, -522, -1951, 558, -606, 1421, 3764, 1252, -1533, 3037, 
    -1480, 2410, -237, -2636, 1529, -443, -3195, 1275, -524, 4, 1572, 184, 2295, -793, 1800, -1165, 
    -4193, -1374, 1371, -1116, -2931, -205, -408, 272, 116, 1219, -2632, 1248, -1999, 44, 2457, 150, 
    976, -2019, 135, 3129, 1268, -1211, -48, 79, 315, 1196, -1318, -1580, 98, 1258, 355, -2111, 
    -3099, -744, -4649, 708, 314, 1664, -7556, -277, 1130, -358, -4418, 717, -2058, -870, -3233, 317, 
    1781, 477, 1458, 125, 770, 137, 2467, -373, 470, -1815, -1215, 1441, 1419, 438, 399, 3, 
    -2819, 1113, 104, 1208, -1767, -15, -458, 1939, -152, 645, -588, -352, -742, 460, -14, -2682, 
    1052, 1459, 432, 1570, 2225, -744, -7174, -530, 491, 1003, 4283, 666, -657, 1964, -6464, 2613, 
    -2279, -294, 5179, 439, 846, -376, -2474, -638, -776, -739, -568, 2020, -2002, 1349, -1613, -548, 
    -94, 378, 450, 3313, -1819, 754, 869, 2688, -98, 843, 801, -345, -179, -1090, -372, -2442, 
    -1581, 1146, -1581, 3013, 918, 32, -397, -811, -3035, 970, 1473, -757, 570, 223, -833, 309, 
    594, 547, -6355, -1178, -2217, 83, -1226, -408, 827, 66, 407, 1559, 1081, 1467, -3116, -560, 
    -1167, 560, -233, 1581, 78, 723, -56, 1292, 369, -20, -13217, 799, 1041, -1043, -119, -646, 
    555, 3262, 3155, -483, -5996, 1657, -4901, -2979, 2853, -2580, -1269, -1487, 1868, -6111, 1408, 3725, 
    -2372, -2328, -561, -2635, 2014, 535, -1300, -833, -441, -1088, -940, -1383, -136, -2316, 1310, 3952, 
    -2229, -1323, -1569, -3894, 2980, -3963, -1565, 1125, -8707, -823, -832, -2095, 2635, 2079, -557, -1877, 
    -7328, -3053, 1657, -881, -2804, -1392, 5200, 1863, -1136, 1247, 2056, -701, 4206, 3025, 3399, 2839, 
    1229, -6427, -1355, 643, 1440, -1423, 5229, -2540, -1064, 1857, 3614, -1147, 2987, -1273, -2467, 827, 
    4537, 5623, -8283, -657, -607, 970, -20, -2686, -1296, -3338, 3217, 196, -3697, -2851, -874, 1418, 
    5075, -240, 2590, -208, 4718, 4310, 184, -2949, -3094, -356, -2419, -1797, -1301, -107, 79, -1847, 
    -2358, -7208, 538, 2293, -4099, 1536, -1592, 710, -2207, -2563, -3575, -1418, -619, -1350, 517, -1394, 
    1654, -3134, 1517, -3002, -329, -1369, 4352, -561, 286, 3473, -2055, -2886, 1204, -2350, -2881, -1533, 
    5096, -30, 1813, -3122, 3058, 304, 2920, 252, 2031, -1902, 2668, -5075, -257, -3921, 71, -1097, 
    -808, 3, 485, -4707, 1978, 2888, -2834, -569, 653, 995, 546, -6331, -3659, 3354, -7275, 369, 
    5376, 331, 3568, -583, -7719, -1186, 1264, -242, -2195, -2030, 1647, 5595, -1020, 4081, 1280, 1167, 
    612, -3054, 1042, 1289, -1684, -1585, 1602, 2716, 3903, -162, 2287, -3856, -16, 1289, -2277, -2534, 
    1713, -108, -959, 3, 173, -585, -1729, 2561, 331, -801, -2533, -2790, -512, -692, 810, -215, 
    -2208, 2897, -3566, 999, -2505, 1632, -2578, 3579, 1756, 1706, 2115, -6035, 3611, -1597, -6692, 739, 
    -1636, 718, 3415, 756, -496, 1204, 3364, -849, -6110, 4663, -3117, -1760, -1397, -4028, 1642, -1072, 
    -2410, -1015, -754, -1511, 794, -608, 1086, -357, 1048, -1356, -1478, -979, 224, -1200, -188, 700, 
    1435, 787, -1414, -1329, -766, -446, 307, 769, 698, -1191, -1529, 498, 117, -53, -90, 1212, 
    452, 131, 191, -4, -2323, 630, -2305, -356, -7313, -2822, 43, -1409, 1688, 587, 1047, 405, 
    -2017, 2237, 690, -1511, 1270, 549, -240, 305, -1873, -813, 1349, 2765, -46, -1370, -31, -1023, 
    2281, -806, -10, 2461, -550, -1970, -2574, -1220, -13010, -640, 2976, -604, 1443, -502, 1700, -970, 
    -329, -4021, 70, 2407, 1792, -2135, -661, -2364, 423, -1491, -371, 731, -83, -1724, 62, -997, 
    75, -2811, -1488, -1015, 3220, -1777, 3908, 1063, 831, -851, -879, -173, 1035, 135, 1560, -587, 
    2738, 1241, 764, -1426, -1118, -344, -1582, 794, -543, 2666, 1526, -208, -1005, -2312, -2830, -842, 
    -112, 869, 193, -25, -1685, -112, 1257, 574, -3032, 969, 1338, 1359, 1055, -259, -185, -139, 
    -1590, -1456, 879, -1361, -449, -836, -2086, 291, 615, -533, -540, 711, 27, 1048, 832, 1499, 
    1850, 907, -926, -1325, 3043, 1578, -839, 66, 310, -2985, -733, -1054, 259, -82, -1267, 1494, 
    -1512, -1468, -498, 1070, 3214, 297, -913, -2906, 1696, 1121, -1555, 3278, -670, -676, 1346, 934, 
    2130, -1623, 1768, 802, 809, -517, -1024, 1846, 2790, -790, 1816, 2845, 1320, 576, 1780, -153, 
    -285, -1223, -73, 1796, -240, 205, 1193, 2259, 1031, -6687, -3534, -2045, -422, 2730, -1528, 243, 
    65, 2202, -788, -777, -951, -1099, -556, 1105, -385, 336, -1834, -197, -499, 1825, -6940, -1042, 
    487, 179, -1923, 757, 68, 582, 996, -721, 1812, -713, 513, 2005, 1839, -3265, -177, 185, 
    -1108, 1168, 994, -528, -855, 602, 137, -964, -423, -804, 439, 210, -375, 162, -2005, 109, 
    -3324, 106, -213, 2402, -1242, 30, -320, -776, 450, 749, -90, -119, 1961, -417, -1330, -2156, 
    527, -3125, -1510, 89, -1137, -487, -783, 892, 823, -2074, 2188, 451, -200, 1911, 365, -2258, 
    -1541, 832, -609, -1033, 1335, 647, 658, 322, 61, 312, -83, 906, 863, 1439, 1194, 670, 
    -467, 1454, 1276, 480, -1638, -875, 739, -260, 130, -449, 108, -876, -761, -1600, 639, 145, 
    -3728, -655, -26, 1668, -1334, 940, 157, -1299, 546, 423, -675, -94, -4155, 217, 1399, -397, 
    -1812, -394, -1391, -1129, 2302, -221, -418, 452, 1118, -899, 465, 450, -979, 255, -279, -357, 
    -857, 259, 1391, -886, 696, -47, -1292, 577, 881, -169, -1988, -594, -433, -1330, -1310, 333, 
    734, 185, -167, 51, -382, 201, -291, -149, 888, 706, -250, 848, 288, -1261, 2376, 338, 
    -1262, 248, 201, 1691, 1037, -737, 39, 1556, 1707, -225, 327, -1540, -6199, 1384, 1519, -1320, 
    1111, 302, -849, 644, 788, 1507, 594, 175, 640, 1266, 1031, 551, 1920, -280, 2226, 265, 
    700, -222, -3657, 266, -1013, 305, -462, 507, -167, 813, 1645, 614, -1479, 635, -3736, -847, 
    1147, -300, -289, 1664, -1706, -50, -25, 765, 698, 557, 1003, -147, -774, -186, -31, -2426, 
    1479, -177, -2576, 726, 1749, -217, -164, 363, -3374, -444, 245, 1282, 116, -534, 1724, -797, 
    605, -950, 1627, -186, -1574, -2582, 3388, -308, 503, 1160, -597, 1346, -577, 1291, -4024, 1607, 
    -679, -81, -2374, 269, -1323, -151, 301, 91, 367, -626, -639, 911, 2276, 1048, -347, 453, 
    -2009, 1293, 5260, -1231, -152, 973, 1470, -2538, 1345, -2452, -200, 870, 1660, -1694, -1249, 1279, 
    -44, 27, -47, 1396, 1516, 73, 1839, -2374, -867, 711, -594, 3757, 900, 498, -467, -4000, 
    2792, 2657, -52, 716, -3138, -3662, 120, 150, 1929, -1047, 1096, 186, -512, 21, 1649, -548, 
    -3056, 324, 1223, -600, 1606, 866, 1878, 1151, -3052, -484, 1395, -46, -754, 230, 239, 712, 
    741, 1786, 1244, -1375, 1072, -549, -3296, -1122, -1061, -1001, -624, -136, 645, -840, -1426, 87, 
    2951, -726, -698, -1465, -385, 651, 136, -1090, -1785, -795, -21, 2687, -1257, -14, -713, -358, 
    -1519, 2524, -1642, 303, 679, 1185, 1675, 204, 2123, 158, 1278, -19, -308, 444, -160, -1162, 
    2478, 453, -1625, 606, 340, 108, 1686, 904, -259, 467, -645, -1629, -778, -1698, -1225, -414, 
    789, -462, -465, -978, -1291, -1131, 464, 89, 1860, 1580, 2447, -288, -7671, -612, 3695, -1404, 
    988, 615, -364, 874, -301, 1208, 2632, 2707, -1700, -695, -319, 263, -777, -3526, -907, -5007, 
    1106, 1532, -2009, -954, 3287, 1861, -2657, 656, -905, -607, 747, -1553, 2165, -5773, 5570, -1522, 
    1037, -1257, -5264, 646, 100, -53, 1550, -389, -199, 1842, -1755, 748, 7, -1435, -2195, -506, 
    -293, -546, -3141, 1691, -5534, -795, 168, 3244, 1245, -2053, -576, -2133, 1391, 552, 217, 2669, 
    9, 1055, -2460, 2585, 1491, 391, -325, 314, -1045, 1042, -942, 927, -167, 430, -1135, -525, 
    -2319, -648, -3643, -1478, 609, -2347, 550, 1170, 1962, 2737, -2763, -407, -5847, 1142, -7581, -676, 
    -2189, -795, -2315, 350, -5240, 861, 3246, -171, 254, -2703, -1965, 650, -138, 204, -5268, 228, 
    -1914, -201, -1161, -831, 2511, 342, 19, -1449, 3678, -732, 398, 112, 938, -53, 373, -1139, 
    1251, 702, -598, 590, -881, 291, 944, -2416, 614, -617, -91, 1997, 474, 338, -809, 35, 
    1660, -2711, -1078, 645, -2358, -1414, 1270, -250, -2494, -1090, -1, 152, -357, 1089, 1714, -312, 
    614, -280, 1352, -1286, 456, 520, 591, 683, 1964, 379, -42, -45, 8, -937, 731, 418, 
    2459, -478, 3202, 358, 2050, -190, 1065, -1280, -700, -1006, -2117, 156, 873, 297, -521, -1025, 
    96, 439, -483, -2829, -138, 137, 1077, -256, -71, 266, -41, 472, 34, -773, -136, 955, 
    212, 2447, 60, -419, -1069, 915, 61, -19, 225, -1620, 1697, -75, 78, 1452, 1825, 75, 
    -1350, -445, 963, 768, 564, -471, 380, 666, 490, -506, 297, -456, 1093, -1618, -101, -225, 
    1692, 1035, -142, 454, 110, -280, -27, -117, 1358, 1127, 985, 922, -2811, 47, 134, -2, 
    -199, -750, -1963, -703, -498, -968, 1155, 1696, 1834, 89, -727, -1603, 1053, 199, -734, -1380, 
    112, 1687, -1761, -1340, 1367, 2537, -964, -392, 764, -442, 833, 1488, 1314, -236, 2892, 1464, 
    -546, -916, -1186, 602, -1373, -328, 1254, 867, -1269, 761, 1132, 2215, 1472, 317, -1180, 38, 
    313, -985, 242, 1751, -706, -351, 87, 2807, 660, -98, 1700, 480, -2489, -233, -1660, -964, 
    154, -697, -75, 2153, 386, 479, 1478, 2999, 1214, -1075, -753, -1608, 1281, 1596, 1170, -3925, 
    -2068, 1845, -2056, -789, -1144, 142, -1639, 1392, 196, 254, -402, -156, 2338, -497, 2006, 960, 
    -1831, 149, 416, 772, -25, 799, 1871, -494, 409, -842, -144, -1181, -2516, -183, 358, 1321, 
};

static const int16_t fx4_paramModel3Alpha[16] = {
    -1532, 5233, 5028, -1078, 16, -896, 152, 350, 2088, 28, 671, 2330, -361, 4202, -63, 574, 
};

static const int16_t fx4_paramModel4Bias[16] = {
    -1519, -472, -1657, -381, -965, -233, -1680, 83, -1335, 160, -858, -436, 53, -695, -1086, -24, 
};

static const int16_t fx4_paramModel4Weights[2304] = {
    -3894, 1462, 736, 223, 665, 905, -318, -42, -10, -541, -20, 64, -2016, 751, -940, -1667, 
    -1928, 817, -1388, -815, 92, 590, 147, -1239, -517, 175, 238, 315, -1049, 215, 507, -424, 
    -917, -2372, -4612, -628, -186, -879, -821, -177, -126, 1420, -225, 183, -744, -863, -4315, -794, 
    -1449, -39, 252, -1710, -1171, -241, -627, -979, -15, -126, 271, -439, 9, -115, -962, -96, 
    -856, -633, -275, -112, -1129, -716, 333, -499, 861, -178, -94, -298, -4251, 487, 125, 337, 
    125, 650, -1049, 683, 849, 972, 1073, 1165, -143, -174, 941, 1090, 717, -1103, 199, -1469, 
    -170, 53, -2445, -7, 346, -2851, -1537, -2648, 866, 1828, 1039, -1164, 444, -743, -1673, -2961, 
    -358, -1249, -494, 451, 629, -712, -355, 497, 167, 750, -587, 820, 885, 641, -576, 142, 
    836, -107, -233, -63, 897, -1592, -208, -45, -913, 559, 747, 251, -2728, -191, 146, -693, 
    -1624, -974, 7, -1031, -866, -116, -25, -767, -2831, 285, -302, -103, 20, 147, -664, -304, 
    194, -139, 9, -886, 60, -3956, -2451, -1459, 190, -838, -1345, -1409, -387, -2516, -2433, -1981, 
    -145, -439, -378, -243, -144, 476, 368, -1047, -13, 691, 923, -995, -155, -569, -450, 45, 
    -1230, -356, 72, -419, -2931, -392, 16, -538, -2278, -251, 164, -527, 731, 320, 259, -297, 
    -12, -355, -175, -473, 233, 78, 559, -41, 943, 579, 111, 253, 258, 555, 66, 580, 
    -633, -3196, -287, -1946, 166, 1130, -2046, -553, 193, -1004, -1147, -3543, -296, -58, 1227, 1363, 
    -268, -271, 402, -27, 4, -1067, -665, 549, -227, -112, 378, 395, -50, -125, -369, -87, 
    -2576, 1474, 425, -976, 231, 1796, -1704, 1053, 1647, -1790, -42, -34, -2599, 2587, -827, 50, 
    -2197, 99, -35, -1084, 1832, 368, -125, -3213, -966, 919, -360, -101, 186, 406, -516, -2251, 
    -1430, 905, 927, -634, -676, -952, 366, -104, -484, -206, -3521, -871, 1160, -731, -861, 749, 
    151, -2403, -1358, -1943, 981, -120, -64, -3295, -693, -328, -822, -2677, 59, 376, -575, -1174, 
    1942, -1503, 676, -895, -413, 437, 352, 485, -842, 1881, -1503, 332, 596, -369, 564, -1565, 
    -383, 224, 2856, 1026, -56, 481, 703, -90, 44, 354, -446, 295, 226, -243, 890, -4999, 
    -2370, -1314, -6187, -463, 643, -995, -1709, 95, -1840, -1861, -1039, -29, -2234, -1010, 302, 249, 
    1828, -1576, -3017, -123, 321, 950, 358, 490, -2695, 253, 1127, -1997, 1406, -246, -115, -1010, 
    -488, 497, -375, 740, -6695, 42, -2124, -2385, -1783, -681, 335, -597, -2701, -4, 1195, 226, 
    -1832, -74, 318, -1415, -1810, -351, -437, -1851, -2894, 366, -430, -854, -217, -868, 498, -1446, 
    472, -656, 1022, 249, -2027, -1677, -4159, 670, -1573, -1287, -2427, 1023, 17, -329, -2161, 272, 
    882, 90, 83, -955, -1899, -663, -2563, -1057, 52, -1155, 32, -2261, 181, -415, -602, -980, 
    -872, -1605, 784, 60, 2152, -1210, -653, 954, -4354, -545, 120, -1555, 377, 355, -301, 546, 
    -1640, -529, -297, 1100, 669, 304, 82, -428, 1823, -14, 242, 434, 203, 172, 1223, -98, 
    1260, 283, -3248, 155, 469, 1183, 1501, -1485, 1477, -1328, -3538, -1191, 1358, -1141, -286, 214, 
    -1012, 195, 538, 92, 821, 631, -706, -948, 75, 784, -584, 1304, 538, 1184, 766, 462, 
    -2152, 95, -179, -568, -419, 635, -677, -637, 1399, -416, -257, -322, 414, 419, 220, -1124, 
    -836, -530, -949, -270, 817, 34, 133, -1383, 284, 581, -160, -454, -188, -553, -577, 473, 
    854, 359, -1344, -222, -393, 113, 1632, -397, -403, -1054, -2427, -514, 178, -460, -3105, 895, 
    -292, 812, 305, -79, 75, -930, 461, -691, -49, -403, -552, -974, -102, 494, -91, -194, 
    -840, 1835, 29, 605, 202, 557, 317, 400, -1337, 1061, -514, -650, -1687, -551, -438, -289, 
    235, -29, 1378, -921, 998, 551, 8, 827, 340, 490, -1212, -35, -69, 482, 695, -1384, 
    482, -2720, 1551, 1392, 66, -1145, 227, 685, 455, 426, -2488, -313, 288, -1084, -2723, 244, 
    1740, 484, 311, 461, 219, 500, 88, 441, 66, 667, 882, -364, -225, 76, 624, -372, 
    -589, -455, -316, 85, -1066, -520, -924, -291, -1284, -103, 291, -99, -1991, -962, 109, -568, 
    -1164, -618, -969, -517, -208, -573, 331, -48, -3525, 226, 378, -227, -898, -163, -1077, -1004, 
    -107, 564, 326, -580, 37, 764, 1104, 227, 750, 693, -664, -1062, -108, -704, -160, 465, 
    -202, 166, 142, -454, -109, -559, -114, -535, -929, -873, -559, -1721, -1662, -90, -351, -839, 
    -2205, -119, -494, 956, 1380, -1248, 116, -307, 1167, -2102, 857, 790, -442, 563, -44, -217, 
    335, 157, 1220, 781, -673, 380, -286, 329, 1186, 533, 848, 2283, 211, 182, -581, 390, 
    -1758, -1229, -4790, 1034, -228, 47, 623, -418, 1313, -1365, -8285, -2143, -315, 181, -1527, -231, 
    -375, 197, 856, -132, -1152, -150, -210, -230, 539, 1052, -128, 1885, -300, -197, -387, 527, 
    -3003, -1185, -3340, -434, -1228, -1580, 419, -503, -1531, 360, -404, 280, -2531, -1711, 234, -2046, 
    1160, -1730, -2668, -1562, -680, -1296, -238, -66, -311, -163, 1498, 130, -86, -215, 847, 488, 
    -786, -5541, -496, -1538, -1026, -1288, 1177, 34, -1276, 3689, -122, -2818, -1776, 888, 967, -5067, 
    194, 589, -618, -491, 318, 34, -8, 1318, 310, 82, -547, 238, -132, 1065, -909, -418, 
    961, -62, 468, 378, -9908, 3112, 489, 306, -761, 1245, -315, 3017, -105, 1084, -393, -861, 
    1440, 312, -454, -473, -408, 59, 866, -1273, 664, 810, 1102, 310, 1009, 976, 1095, 1550, 
    638, -3916, -652, -2784, 3727, -13965, -842, -4387, 3396, -9951, -620, -1638, -1559, -3345, -1442, -49, 
    597, -1454, 70, 243, -1408, -113, 502, 886, 2804, -780, 3988, -959, 225, -1562, 478, 278, 
    226, -770, -1249, -374, -1003, 607, -386, 247, 121, -404, -154, -359, 400, 839, 148, 22, 
    380, -1013, -13, -919, 732, -3106, 1342, -166, -1117, -737, 140, -1218, 137, 331, -1077, 1256, 
    480, -1217, 200, -888, 569, 178, 99, -4571, 18, -1631, 653, -855, 48, -5504, -612, -1769, 
    761, -669, -107, -576, 172, 970, -199, 1196, -150, 46, -215, -1335, 158, -924, -430, 757, 
    -2193, -596, -838, -805, 1903, 663, -1056, 1668, -685, 423, 56, 157, -1564, 1595, 806, 1548, 
    -283, 260, 699, 65, 1583, 1306, 935, 315, -71, 526, -80, 941, -809, 1209, 943, 480, 
    -2521, 422, 560, -2659, -866, -1734, -1925, -2389, -643, -1622, 62, -1785, -665, -10512, -640, 3651, 
    -1765, 490, -241, -224, 1651, -3072, -1946, -1564, 519, -727, -503, 290, 343, -67, 1293, -856, 
    -4495, -2353, -2799, -88, -21, -4150, 3538, -2290, 1838, -377, -1453, -1689, 3029, -3160, 839, 206, 
    472, -2620, 1518, -500, -6194, -5144, -1658, 2384, 412, -550, -3491, -4946, -512, -1203, -2090, 761, 
    -1962, 392, -19, 477, 2306, 608, -1453, -411, 903, -1558, -1694, -3678, 4421, 537, -2451, 438, 
    -2532, -2562, -2558, 329, -5027, 2847, 1376, 3990, -1689, 313, 249, 494, 1341, -123, 1036, -581, 
    529, 1471, -2031, -339, 2925, -3137, -785, 1122, -2017, -4035, 634, -2218, -8244, -2528, -1558, 1510, 
    789, 486, 3862, -4739, 961, 725, -1048, 938, -2717, -3337, -1734, -4009, 911, 68, -824, 3650, 
    -2655, 2986, -663, -1431, 5169, 1217, -4098, -1528, -7355, 934, -3950, -2333, 3017, -918, -985, -288, 
    -1259, -906, -2409, -1454, 480, 3074, 1056, 153, 1361, -133, -3123, -713, 590, 2425, -1387, 753, 
    -2288, -9923, -4412, -1424, -707, -180, -2086, -1084, -1715, -63, -660, -314, 2196, 1714, -387, 171, 
    -7, -196, 325, 397, 314, -3571, -2723, -1888, -766, -2204, -607, -1869, -189, 410, 6027, 3211, 
    1392, -526, 1815, 2427, -385, 976, -2771, 389, 99, 440, -1336, -837, -1838, -1050, -2216, -5759, 
    -915, 389, -887, 550, -887, -447, -224, 608, -842, -492, -451, -659, 1651, 930, 230, 1126, 
    2583, 1758, -348, 2568, -9784, 1570, 1329, -3630, -2829, 1994, 777, -207, 4885, 1287, 567, -1020, 
    -1230, -231, -1978, -996, -1989, -851, -2276, -2489, 251, 1268, 1447, 2982, -16, -389, 941, 976, 
    4129, 492, 22, -1605, 2278, -3409, 3491, 1718, 1120, 2251, -1295, 1812, 1976, 6260, 8822, -4024, 
    563, -411, 2514, 702, -2949, 4061, 3599, -216, 29, -1353, 603, 1244, 589, -484, -2010, -61, 
    -1968, -220, -319, -26, -2481, 20, 1085, 2121, 2428, 616, -642, 148, -5704, -499, 297, 1043, 
    -648, -563, -2088, 379, -1666, -1162, 2001, 1233, -46, -110, 695, 426, -1349, -345, 1868, 84, 
    478, 480, -3001, 2, -1118, -33, 1143, 972, -562, -448, 471, -1215, -2936, 1134, -3873, -124, 
    -814, 648, 1088, -252, 2038, -2488, -1531, 349, 999, -1728, -1653, 449, 1708, -327, -1424, 188, 
    -3650, -2583, 1163, -217, 154, -625, 1042, -1416, -3165, -640, -11, -1041, -1759, 517, -896, 9, 
    324, -91, 1511, 1764, -111, 667, 938, 252, -441, -989, -385, -950, 1190, -13, 227, 1301, 
    2895, -280, 1533, 729, -781, -168, -1860, -448, 776, -1024, -5497, 251, -1156, -465, 782, -1437, 
    566, 838, 1016, 444, 564, -526, -1008, 372, -1211, -570, 255, -695, -33, -1578, -1423, 635, 
    -1824, -359, -2231, 1207, -1192, 381, 122, 94, -162, 177, -1145, 14, 166, 200, -1567, 417, 
    415, -459, -522, -293, 173, -2127, 297, -431, -1616, -716, 621, -1345, 833, 771, -2548, -474, 
    112, 1204, 407, -460, 76, 550, -1321, 603, -304, -313, -3877, 657, 1718, 709, -10795, 540, 
    -1322, 665, 1451, 18, -489, -674, 243, 142, 910, -963, -252, -1705, 184, 995, 1569, -977, 
    -5131, 259, 122, 1853, -1343, 461, 214, 558, -3425, 995, 1367, -1350, -3985, 670, 308, -427, 
    50, -336, 2571, 988, -713, -52, 207, -1447, -475, 776, 19, 2473, 471, 419, -159, -686, 
    -2221, 279, -3590, 344, -260, 327, -609, 289, 978, -955, -10949, -1075, -604, 929, -8696, 775, 
    1099, -217, 161, 528, 876, -441, -343, -572, -1231, 1723, 1614, 1399, 613, 741, 48, -469, 
    -466, -135, 312, -535, -3, -645, -925, 85, 97, 248, 193, 44, -1496, 155, -1198, -332, 
    -246, -837, -1003, 319, 483, 420, -1012, -69, -176, -301, -239, 672, -426, 59, -416, -588, 
    -302, -1934, -194, -1822, 559, 1079, -198, 1166, -155, 289, 416, -469, -363, 1246, 105, 269, 
    -599, -196, -428, 415, 53, -290, 422, -641, 367, -15, -121, 649, -155, 238, -1059, 353, 
    30, 1036, -335, -728, -5955, -2610, 204, -1153, 630, -1068, 94, -373, 650, -838, 324, -766, 
    113, 463, -67, 730, 397, 729, 667, 2272, -147, 1195, -10, 432, -727, -42, -2, -1512, 
    -202, -741, 257, -636, 1178, -17162, 316, 1013, 827, 2051, -859, 828, -564, -1295, 161, 2432, 
    476, -974, -921, 76, -290, -1083, 207, 202, 207, 287, -98, -565, -978, 283, -324, 86, 
    1353, 799, -956, 692, 721, -327, 310, 45, 9, -849, -577, 120, -599, -653, -288, -466, 
    108, 284, -130, -90, -158, 405, 492, 762, 37, -605, -105, -969, 210, 181, -909, -192, 
    -177, 817, -220, -466, 126, -47, 60, 868, -146, -1145, -142, -1603, 402, -1903, 356, -3753, 
    -658, -1430, -2238, 213, 356, -168, -47, -413, -202, -1, 204, -110, -742, -568, 447, -168, 
    -1988, -1203, -166, 325, 1179, 399, 452, -132, -529, -478, 183, -87, -3199, -545, 175, -30, 
    -50, -187, 565, 758, 126, 696, 186, -120, 243, 400, -9, -239, 411, 1142, 740, 162, 
    -1342, -6038, 336, -6403, -1084, -312, -1200, 545, -242, 1638, -138, -641, 1334, -1348, 1876, 1811, 
    -1239, -755, 931, 128, -120, -1071, -673, 373, 51, -433, 378, -219, 1145, 708, 548, 959, 
    -959, 1052, 669, -159, -2269, -169, -2447, 506, 337, -78, -629, -130, -2867, 517, -462, -782, 
    -985, -850, 775, -172, 754, 427, 821, 164, -441, 338, -230, 985, -370, -1654, -757, -2246, 
    -295, -215, -676, -3330, -582, 288, 578, -2158, 159, 284, 56, 3063, 19, -35, 1321, -8276, 
    -164, -116, 997, 418, 38, 174, -499, -1058, 90, 293, -311, 162, -662, -980, 969, 812, 
    -1678, -539, 770, 730, -50, 1063, 1197, 648, -2545, -766, -2383, -670, -2468, -333, 1527, -821, 
    319, -391, 1688, 611, -898, 293, -1679, -162, 857, -701, -503, 537, -1076, 119, -83, -2206, 
    815, -850, 341, -4933, 3305, -2305, 2627, -21399, -1389, -1268, 320, -4167, 587, 391, 99, -3985, 
    616, -1, 1113, 634, 1188, 2265, 3934, 518, -998, 233, -1224, -16, 160, -359, 944, 850, 
    988, 2062, -140, 708, -1648, -846, 329, -799, -2163, -445, -1007, -459, 1340, -811, -264, 771, 
    -557, -997, 256, -2908, 578, -611, 187, 574, 338, 531, 33, -120, 812, 625, 888, -2790, 
    120, 243, 688, -3516, -233, -763, -572, -1361, -39, -723, 517, -2693, -680, -4, 816, 150, 
    703, 164, 1977, 802, -508, -115, -1247, -287, -494, -351, -215, -402, 412, -66, -524, -1720, 
    -3126, -1756, -957, 304, 2435, -256, -215, -820, -1406, 3, 682, -176, 6030, -1670, 255, 926, 
    763, 169, 265, 823, -1020, -1139, -1160, 147, 558, 698, 563, 53, 79, 1198, 2668, 3540, 
    186, -383, 105, 61, 1230, -516, -1522, 2080, 256, -1565, -27, -929, 1878, -419, 457, 3496, 
    -76, -196, 224, -653, -832, 1636, -756, 860, -677, -652, -385, -295, 2392, -1625, -629, 1261, 
    -2236, -47, 3, -664, -974, -890, -1472, -443, 418, -38, 221, 70, -2106, -385, -1778, -1123, 
    135, -293, -1187, 82, 501, -338, -329, -845, -425, 715, 401, 419, 433, -450, 16, -1203, 
    -90, -556, 107, -1944, -502, -113, -627, -906, 67, -123, -451, 139, -1194, -507, -3150, 1015, 
    -119, 122, -672, 260, -712, -618, -111, -461, -234, -366, 250, -18, 144, 118, -1851, -825, 
    -1479, 272, 62, 756, -204, 755, -307, 760, -250, -458, 75, -308, -2142, 263, 546, -3, 
    247, 906, 986, 716, 264, 373, 652, 237, 758, -243, -1333, -280, -395, 145, 1121, -523, 
    596, -17, 18, 1631, -804, -387, -1561, 659, 90, -243, 1174, -973, 379, -224, -2718, -267, 
    640, 797, -606, 33, 679, 260, -767, 355, -1078, 393, -55, -27, 979, 138, -434, 400, 
    419, 494, -89, -822, 194, -746, -393, 128, -201, -408, -1452, 377, -1950, -785, -97, -1539, 
    -807, -1210, -570, 1300, 307, -112, 153, 177, -111, -757, 628, -118, -54, 298, -1074, -728, 
    -307, -215, -64, 2012, 82, -171, -469, -232, 24, 103, -30, -1316, 148, 265, -3134, -5453, 
    -71, 361, -379, 976, -186, -284, -222, -338, 433, -377, -247, 58, -720, -126, -31, -254, 
    -2477, -91, 232, 141, -415, -56, -250, -30, -2398, 1636, 934, 380, -6266, -205, 178, 2445, 
    163, 115, -284, -683, 1, -226, 411, 636, 413, 708, 664, 500, 983, -489, 206, 1342, 
    -933, -685, -3162, -2528, -122, -46, -873, 774, -138, -2647, -6717, -318, -1700, 2773, 3765, 1675, 
    -1065, -36, 938, -624, 600, -205, -422, 992, 973, 966, 847, 371, 712, 27, -642, 1198, 
};

static const int16_t fx4_paramModel4Alpha[16] = {
    582, 1287, -88, 573, 109, -340, 951, 1288, 1736, 549, -635, -561, -215, 36, 221, 286, 
};

static const int16_t fx4_paramResidualBias[16] = {
    -394, -178, -535, 472, 219, 39, 15, -310, -284, 7, -437, -474, -227, -639, -481, -459, 
};

static const int16_t fx4_paramResidualWeights[256] = {
    2408, 1169, -933, 1177, -186, -104, -288, 119, 211, 143, -257, -423, -2871, -374, -799, 156, 
    3, 91, 750, 803, -74, 122, -24, -17, 68, -181, 129, 216, -70, 77, -548, 183, 
    1062, -38, 132, 2706, -951, -56, -955, -1091, 820, 71, 3464, 775, -8, -79, -103, 659, 
    1070, 2796, 3635, 4787, -454, 1650, -1809, -518, -138, -960, 782, 188, -6727, -20, -541, -317, 
    -430, -18, 146, 192, 1, 153, -296, 426, 2861, -271, -703, -46, -469, 97, 51, -153, 
    19, -38, -146, -800, -36, 141, -69, 649, 43, 3, 862, 501, 92, -99, 240, -341, 
    818, 46, 179, 639, -460, -52, 1502, -129, -28, 233, -456, 277, 789, 86, 1242, 2139, 
    -14, -886, 3553, -250, 173, 1017, -1649, -373, 473, -256, -444, 1838, 400, 474, 2088, -119, 
    1113, -120, -211, 6, 467, -986, 330, 379, -2956, 74, -1233, 762, -1940, -5, -1525, 833, 
    -29, -13, -1229, 2197, 116, 171, 478, -608, -38, 67, -886, -3116, 56, 238, 713, -885, 
    -9, -202, -314, -950, -70, 282, -246, 294, 649, -9, -2689, -3501, -430, -4, -2426, -376, 
    -344, -172, -359, -140, 546, 58, 541, -405, -987, -365, -3241, -1873, -832, -1154, 295, 630, 
    -871, 484, 2129, 181, 852, -268, -1508, -209, 658, 681, 776, -13, 102, -71, -5, -171, 
    -38, 5, 357, 38, 24, -53, 687, -1810, 0, -27, -237, -955, -115, 8, -64, -157, 
    135, -17, 315, -815, 23, 59, -198, 517, -276, -109, 10, 1114, -896, -83, -2418, -1543, 
    -233, -48, -770, 534, -152, 258, 32, 2703, 1698, 142, 179, -30, 73, 2356, 507, -221, 
};

static const int16_t fx4_paramResidualAlpha[16] = {
    413, 6508, 1566, 7408, 8189, 8192, 6140, 736, 5861, 8200, -184, -258, 1443, 129, -411, 242, 
};

static const int16_t fx4_paramSubConvolutionBias[16] = {
    977, 980, 977, 971, 953, 955, 956, 954, 931, 928, 936, 942, 912, 909, 916, 921, 
};

static const int16_t fx4_paramSubConvolutionWeights[2304] = {
    141, -101, -106, -49, 269, -57, -51, 43, 754, 234, -4, 34, 248, -88, -144, -82, 
    53, -38, -61, -48, 86, -87, -73, -21, 179, 61, 5, 54, -159, -189, -126, -62, 
    21, -9, -19, -17, 4, -74, -75, -55, -146, -113, -98, -91, -237, -172, -79, -26, 
    -15, -23, -9, -7, -28, -45, -44, -49, -59, -51, -57, -125, -137, -108, -62, -29, 
    -331, -220, -110, -14, 781, 67, -188, -237, -237, -67, 44, 84, -8, -82, -81, -49, 
    -343, -327, -216, -87, 522, 120, -35, -83, 7, -5, 3, 23, 82, 14, -60, -67, 
    -350, -345, -239, -109, 412, 170, 79, 52, 35, -14, -41, -47, 71, 45, -43, -70, 
    -250, -211, -119, -41, 287, 86, 12, 20, -13, -32, -57, -70, 34, 46, -10, -32, 
    -342, -58, 21, -19, -79, 74, 164, 196, -371, -161, -13, 25, 410, 213, -2, -73, 
    -21, 12, -9, -48, 78, -12, -61, -16, 134, 68, 27, 1, 162, 62, -21, -26, 
    235, 124, 45, -4, 136, 48, -63, -70, 140, 89, 44, 9, 13, -17, -14, 5, 
    212, 92, 15, -18, 114, 146, 70, 2, -12, 24, 40, 25, 23, 2, 3, 10, 
    622, 107, -97, -74, -35, -4, 8, 21, -13, -23, -17, -17, -146, 249, 187, 54, 
    111, -33, -30, -3, -92, -23, -2, 12, 24, 26, 22, 8, -85, 129, 142, 86, 
    -87, -89, -38, -4, -43, 6, 22, 11, 10, 16, 15, 14, -36, 62, 88, 66, 
    -42, -72, -53, -1, -27, 8, 17, 1, -3, 3, 10, 17, 7, 36, 43, 39, 
    378, -165, -378, 201, -198, 257, 616, 470, -386, -571, -141, 570, 489, 1002, 1179, 947, 
    90, -113, -167, 34, 98, 234, 294, 181, 53, -115, -182, 22, 32, 202, 246, 175, 
    -14, -30, -4, -2, 141, 105, 42, -23, 178, 151, -31, -106, -28, -6, -48, -89, 
    -20, 13, 47, 9, 85, 57, 14, -37, 118, 167, 94, 9, 56, 74, 15, -43, 
    103, 74, 74, 99, 405, 1134, 1228, 722, 261, 315, 131, 19, -263, -138, 193, 126, 
    542, 645, 616, 493, -630, -268, -181, -363, -146, -115, -62, 66, -121, -33, 57, 46, 
    603, 698, 633, 456, -986, -785, -698, -726, -186, -179, -139, -30, -47, 32, -4, -44, 
    367, 380, 299, 170, -675, -478, -395, -434, -77, -65, -94, -88, 1, 83, 40, -47, 
    -498, -771, -924, -716, 109, -427, -1020, -1532, -379, -560, -616, -551, -147, -34, 231, 426, 
    -182, -191, -229, -178, 395, 188, -43, -309, 317, 403, 399, 284, -164, -66, 85, 159, 
    25, 153, 204, 205, 439, 341, 266, 174, 188, 234, 259, 233, 6, 58, 69, 45, 
    58, 140, 192, 216, 317, 209, 160, 171, -88, -132, -97, -29, 129, 175, 151, 89, 
    -529, -270, 492, 919, 33, -6, -69, -78, 60, 139, 145, 55, 86, 327, 85, -536, 
    -172, 21, 261, 283, -90, -136, -163, -145, 57, 67, 61, 32, 77, 133, 70, -201, 
    -70, -4, -15, -60, -53, -62, -68, -60, 12, -3, -7, -12, 2, -22, 39, -18, 
    -49, -20, -31, -44, -39, -44, -46, -29, -7, -8, -8, -14, -23, -52, 21, 34, 
    -50, -84, -81, 157, -125, -95, -140, -228, 7, 38, 52, -96, 5, -101, -132, 69, 
    -33, -37, -26, 74, -85, -98, -23, 112, -40, -24, 4, 33, 3, -85, -163, -146, 
    -28, -16, 16, 58, 10, -33, 44, 212, -52, -46, -54, 11, -22, -73, -123, -149, 
    -24, -10, 20, 40, 104, 66, 81, 148, -64, -48, -42, 14, -40, -63, -74, -83, 
    -114, -233, -357, -461, -53, -34, 40, 490, -49, -67, -46, 127, 55, 59, 82, -48, 
    -175, -319, -410, -400, 26, 50, 59, 257, -4, 14, 1, 9, 76, 72, 52, -62, 
    -149, -267, -313, -252, 82, 89, 51, 102, 18, 45, 30, 10, 55, 51, 32, -47, 
    -72, -137, -142, -76, 47, 40, -8, -11, 30, 49, 34, 18, 28, 27, 18, -14, 
    -39, 7, 53, -40, -12, -2, -49, -153, -16, -19, -88, -241, 121, 116, 69, -20, 
    17, 60, 85, 71, -58, -30, -37, -111, -22, -3, 37, 118, 23, -10, -50, -99, 
    40, 80, 96, 121, -81, -63, -29, -37, 4, 15, 32, 81, -1, -21, 0, 6, 
    18, 47, 71, 87, -63, -55, -5, 53, 21, 29, 2, -44, -3, -6, 28, 78, 
    74, 94, -3, -287, -36, -36, 7, 16, -17, -35, -44, -1, -39, -39, -9, -14, 
    122, 110, -13, -180, -7, 5, 1, -59, -2, 4, 14, 50, -12, -24, -5, 18, 
    140, 113, -33, -168, -10, 9, -2, -46, 0, 7, 13, 38, 13, 0, -5, -1, 
    109, 98, -26, -147, -29, -21, -22, -44, 3, 6, 5, 16, 14, 7, 0, -6, 
    520, -147, -145, 9, 77, -89, -136, -156, -1151, -444, 66, 218, 588, -48, -228, -201, 
    537, -275, -194, 23, 234, -75, -119, -101, -828, -630, -146, 109, 1159, 157, -191, -182, 
    407, -316, -201, 20, 493, -64, -151, -97, 61, -411, -272, -27, 1306, 205, -181, -143, 
    267, -230, -165, -14, 611, -83, -212, -121, 805, 70, -106, 4, 833, -9, -273, -183, 
    111, 421, 383, 201, 258, -201, -323, -272, -867, -42, 276, 286, -394, -219, -28, 12, 
    189, 623, 563, 296, 561, -67, -258, -209, -1147, -125, 341, 375, -451, -247, 8, 69, 
    252, 679, 599, 292, 628, -149, -355, -263, -1067, -142, 324, 365, -329, -224, -4, 67, 
    255, 525, 434, 195, 330, -366, -490, -327, -615, -39, 256, 286, -119, -167, -62, -5, 
    770, -9, -194, -110, 389, -406, -578, -400, 62, 110, 92, 53, 70, -79, -86, -13, 
    719, 45, -145, -93, 73, -438, -457, -268, 252, 110, 11, -20, -186, -117, 108, 201, 
    78, -19, -40, -39, -188, -462, -354, -179, 193, 21, -35, -18, -570, -170, 88, 105, 
    -518, -147, 5, 5, -237, -491, -397, -239, -382, -185, -31, 37, 5, 97, 34, -43, 
    -751, -132, 49, -70, -364, -142, -13, 49, 349, 141, 20, -9, -359, 404, 262, -16, 
    43, 291, 30, -172, -258, -108, -10, 54, -54, 11, 19, 6, -365, 526, 261, -82, 
    942, 508, -79, -222, 324, 76, -17, 14, -237, -106, -25, 10, -264, 545, 258, -63, 
    1032, 327, -154, -162, 308, 73, -24, -4, -114, -91, -52, -20, -234, 398, 218, -8, 
    566, -544, -656, 796, 545, 127, -279, -524, 493, 523, -409, -1326, 1006, 1960, 2263, 1983, 
    826, -482, -758, 940, -472, -419, -346, -446, -38, 443, 417, -290, 2367, 3589, 3889, 3354, 
    896, -386, -810, 743, -1207, -558, 60, 134, -660, -254, 644, 872, 2922, 4183, 4511, 3881, 
    693, -318, -729, 401, -906, 106, 962, 919, -746, -801, 182, 1152, 2461, 3463, 3754, 3248, 
    4841, 4233, 4031, 4237, 1115, 805, 315, -356, 541, 292, -629, -1089, -902, -192, 866, 167, 
    3820, 3115, 3065, 3538, 380, 345, -49, -805, 897, 721, -436, -1274, -905, -342, 841, 180, 
    3400, 2772, 2841, 3453, -474, -83, -324, -1235, 769, 764, -255, -1084, -734, -359, 711, 268, 
    3825, 3406, 3512, 4006, -1995, -1410, -1544, -2454, 212, 325, -228, -627, -498, -277, 485, 324, 
    957, 1901, 2164, 1606, 1834, 918, -251, -1847, 25, -60, -79, 8, -278, 19, 313, 322, 
    294, 1137, 1528, 1264, 2150, 950, -585, -2472, 441, 490, 491, 456, 751, 925, 661, 137, 
    -778, -580, -399, -246, 2449, 1133, -599, -2586, 369, 483, 533, 451, 252, -140, -584, -779, 
    -1518, -1889, -1998, -1646, 2883, 1701, 98, -1744, -483, -677, -689, -577, -239, -477, -453, -199, 
    1063, 915, -313, -1172, -513, -694, -747, -667, 618, 719, 716, 591, 231, 713, -4, -1196, 
    900, 82, -847, -601, -762, -865, -724, -520, -143, -265, -272, -182, 194, 842, 12, -1430, 
    -98, -866, -582, 688, 365, 613, 726, 588, -413, -491, -467, -398, 131, 794, 120, -1253, 
    -940, -1051, 56, 1277, 652, 805, 761, 567, -94, -4, 24, -63, 98, 603, 158, -923, 
    -54, -119, -86, 298, 58, 367, 657, 701, 45, -63, -181, -89, -166, -390, -446, -88, 
    -67, -140, -109, 362, 22, 308, 434, 258, 92, -1, -190, -379, -190, -363, -260, 344, 
    -89, -159, -137, 354, -147, 43, 19, -297, 141, 119, -63, -497, -129, -245, -98, 540, 
    -77, -136, -124, 273, -263, -118, -124, -283, 133, 148, 64, -351, -76, -174, -114, 301, 
    187, 463, 641, 532, 113, 236, 305, 373, -177, -253, -72, 477, 98, 144, 200, -159, 
    277, 548, 627, 357, 121, 186, 223, 377, -211, -326, -89, 651, 56, 106, 212, -56, 
    226, 422, 417, 84, 37, 9, -19, 235, -207, -339, -141, 566, 23, 65, 180, 8, 
    106, 234, 221, -18, 55, -46, -199, 9, -145, -251, -154, 322, 38, 63, 135, -17, 
    -135, -190, 14, 560, 85, 96, 46, 38, 48, 67, 43, 32, -27, -85, -208, -327, 
    -48, -118, -54, 208, 103, 150, 93, 86, 5, 19, 59, 202, -74, -95, 50, 347, 
    9, -40, -56, -142, 108, 174, 100, 80, 15, -2, -6, 110, -89, -60, 118, 282, 
    1, -20, -50, -303, 111, 204, 195, 172, 25, -2, -122, -306, 60, 91, 119, 11, 
    -28, -184, -206, 285, -4, -1, -40, -215, -11, 22, 122, 327, -20, -1, -7, -61, 
    -35, -149, -43, 440, 41, 21, -117, -422, -21, -9, -24, -71, -34, -2, -14, -109, 
    47, 24, 69, 122, 53, 30, 74, 167, 12, -9, -109, -244, -43, -4, -1, -110, 
    123, 131, 26, -336, 0, -5, 136, 344, -16, -44, -100, -112, -51, -22, 2, -65, 
    -56, -9, -4, -29, -74, 4, 43, 57, 199, 79, 1, -27, -37, -71, -46, -24, 
    -20, -4, -5, -21, -6, 55, 66, 66, 220, 111, -8, -57, -83, -85, -35, -7, 
    104, -15, -31, -16, -8, 49, 63, 67, -65, 74, 30, -42, -64, -92, -38, -27, 
    309, -49, -78, -7, -90, -52, -6, 29, -660, -124, 94, 85, 252, -18, -66, -83, 
    -103, -128, -116, -68, 25, 102, 60, 4, -1, -17, -11, 18, 34, 19, -20, -0, 
    -225, -268, -221, -114, -50, 16, -3, -41, -2, -0, -21, -7, -1, -6, -44, -29, 
    -310, -328, -258, -113, -61, -40, -48, -41, -105, 51, 30, 18, -79, -42, -56, -41, 
    -395, -274, -165, -38, 91, 74, 53, 30, -433, 5, 113, 108, -229, -118, -50, -19, 
    -89, -55, -50, -38, -21, 89, 81, 12, 2, 16, 25, 17, -149, -126, -89, -58, 
    -180, -61, -11, -10, 94, 126, 85, 7, -20, -14, -2, 2, -1, -33, -19, 3, 
    -121, -36, 45, 47, 220, 76, -8, -32, -18, -14, -13, -8, 206, 107, 48, 29, 
    297, 30, 30, 55, 330, 20, -74, -32, 39, 72, 50, 22, 57, -52, -121, -121, 
    5, -69, -6, 68, 14, 32, 26, 4, 29, 28, 3, -18, 32, 21, 15, 11, 
    -7, -100, -30, 42, 19, 27, 9, -19, -118, -57, -35, -28, 40, 72, 63, 48, 
    -241, -191, -51, -35, 68, 50, 17, -26, -181, -86, -35, -8, -47, 120, 115, 59, 
    -562, -209, 33, -25, -21, 1, 16, 6, 216, 92, 22, 21, -206, 217, 175, 21, 
    20, 46, -11, -85, -109, -153, -177, -161, 146, 134, 170, 248, -229, -110, -70, -95, 
    41, 4, -41, -50, 77, -89, -186, -157, 175, 102, 65, 204, -440, -317, -242, -219, 
    129, -151, -182, 109, 403, 9, -252, -275, 229, 17, -347, -263, -397, -180, -85, -87, 
    326, -356, -417, 399, 508, -23, -411, -500, 418, 177, -689, -1009, 125, 635, 770, 615, 
    222, 224, 185, 127, 195, 173, 185, 239, -49, 14, 42, 50, -50, 8, 27, 54, 
    464, 466, 361, 218, 356, 284, 262, 271, -77, -11, 7, 67, -158, 37, 140, 71, 
    530, 471, 316, 150, 248, 103, 78, 86, 16, -12, -165, -134, -388, 15, 367, 115, 
    261, 58, -115, -193, -157, -396, -428, -339, 304, 118, -392, -566, -691, -83, 647, 154, 
    -291, -301, -246, -192, -47, -33, -49, -28, 23, 25, 17, 11, -41, -69, -92, -128, 
    -410, -489, -454, -350, -76, -77, -95, -104, 0, 20, 29, 10, 86, 102, 81, 23, 
    -8, -53, -92, -128, 91, 56, -15, -166, -77, -37, -6, -2, -71, 4, 134, 212, 
    908, 1222, 1209, 841, 590, 415, 105, -401, -134, -130, -97, -24, -634, -535, -225, 34, 
    -106, -81, -24, 55, -7, 7, 17, 27, 48, 90, 93, 66, 36, -14, 47, 42, 
    -284, -146, 12, 84, 19, 34, 30, 35, -170, -193, -187, -155, 25, -68, 6, -5, 
    -173, 218, 283, 3, 237, 266, 209, 131, -305, -420, -422, -316, 37, 11, -36, -202, 
    494, 924, 462, -324, 304, 299, 166, 10, 312, 347, 352, 311, 130, 323, -19, -616, 
    -13, 1, -6, -29, -88, -83, -101, -159, -90, -84, 49, 172, 35, -25, -83, -90, 
    -16, -1, -6, -11, -110, -84, -50, -96, -80, -116, -30, 155, 59, -29, -134, -164, 
    -28, -35, -26, 66, -85, -4, 136, 180, -37, -99, -67, 160, 30, -76, -184, -166, 
    -52, -98, -73, 184, -16, 118, 327, 400, -35, -94, -74, 198, -44, -175, -251, -47, 
    -48, -40, -12, 8, -51, -38, -6, -24, 35, 53, 34, -8, 31, 2, -3, -23, 
    -73, -58, -4, 33, -70, -41, 12, -5, 33, 79, 62, -6, 49, 35, 56, -44, 
    -46, -17, 46, 62, -41, -8, 11, -58, -3, 34, 31, 36, 88, 80, 114, -107, 
    17, 54, 91, 20, 6, 43, -15, -203, -74, -89, -35, 172, 124, 130, 162, -171, 
    -13, -51, -87, -181, -24, 6, 15, 12, 11, 7, -7, 6, 9, 14, -13, -21, 
    -9, -42, -95, -243, -8, 26, 31, 15, 11, 1, -26, -6, -3, 10, 22, 55, 
    -1, -3, 17, 6, 22, 50, 55, 50, 17, -2, -41, -43, -12, -8, -35, -75, 
    -30, -44, 101, 430, 32, 29, 54, 158, 35, 43, -5, -48, -20, -50, -203, -459, 
    27, 4, -12, 1, 25, 25, 13, -4, -11, -15, -13, 16, -18, -37, -22, 29, 
    26, 8, -39, -60, -4, 1, -1, -7, -9, -31, -82, -129, -30, -56, -24, 41, 
    33, 8, -96, -110, -40, -16, 37, 127, 2, -10, -67, -172, -20, -37, 4, 45, 
    40, -13, -114, 88, -35, -18, 73, 207, 15, 47, 103, 197, -22, -23, 5, 14, 
};

static const int16_t fx42_paramSubConvolutionBias[4] = {
    966, 965, 920, 929, 
};

static const int16_t fx42_paramSubConvolutionWeights[576] = {
    14, -66, -7, -13, 53, -26, -36, -56, 307, 22, -92, -93, -47, -104, -164, -49, 
    -305, -107, -289, -127, 372, -136, 239, 41, -76, 38, -6, -54, 1, -64, 49, -39, 
    -102, -14, 166, 9, 15, 71, 111, -15, -82, 10, 60, 30, 212, -30, 6, 1, 
    202, -51, -72, -24, -39, 10, -14, 13, 3, -1, 6, 14, 37, 117, 17, 59, 
    48, -77, -13, 12, 98, 390, 97, -1, -255, 67, 153, -9, 431, 637, 24, -41, 
    341, 320, 512, 390, 160, 352, -731, -563, 79, 38, -127, -88, -139, 105, 17, -14, 
    -410, -512, 94, 204, 66, -726, 327, 193, -54, -121, 51, 91, -103, 225, 92, 88, 
    -237, 489, -36, -38, -50, -114, -49, -51, 81, 73, -2, -10, 156, -145, -24, 19, 
    -51, 31, -19, 33, -101, -70, 37, 121, -5, -2, -53, -18, -45, -93, -49, -107, 
    -211, -407, -156, -196, -3, 212, 64, 34, -27, 23, 36, 23, 66, 6, 40, -2, 
    11, 42, 46, 94, -25, -88, -65, -4, -15, -43, 17, 18, 62, -25, -8, 28, 
    100, -121, 115, -94, -18, -9, -13, -29, -13, 5, 4, 18, -28, -3, 9, -3, 
    159, -77, 32, -90, 37, -128, 239, -145, -763, 62, 131, -100, 464, -200, 584, -195, 
    336, 361, 428, 380, 138, -266, 111, -359, -546, 319, -466, 308, -328, 15, -210, -1, 
    382, -136, -151, -18, -95, -426, -345, -292, 134, 34, -88, -12, -78, 52, -159, 46, 
    -137, -41, 702, -154, -218, 20, 195, -7, 112, 9, -137, -22, 52, 106, 111, 101, 
    92, 81, 221, -99, -55, -399, -641, 519, 355, -402, -615, 713, 2231, 2872, 3257, 3849, 
    4002, 3718, 3351, 3453, 661, -224, -991, -1389, 613, -857, 517, -549, -585, 513, -467, 447, 
    1072, 1640, -1191, -1072, 1463, -1289, 2042, -1208, 224, 219, -77, -71, 354, 358, -151, -504, 
    740, -733, -739, 360, -709, -664, 609, 660, 232, 213, -251, -226, 495, -655, 406, -474, 
    -95, 116, -115, 92, 189, 513, -121, -172, 18, -210, 135, -212, -277, -113, -156, 157, 
    369, 539, 247, 176, 164, 320, 14, 6, -242, 242, -236, 148, 101, 49, 47, 76, 
    -123, 182, -13, -138, 109, 66, 149, 137, 34, 84, 9, -81, -70, -34, 1, 133, 
    -99, 119, 81, -30, 14, -198, 19, 180, -5, 88, -14, -141, -14, -48, -30, -43, 
    -22, -15, 87, -33, -5, 58, -26, 38, 152, -23, -194, 42, -69, -28, 20, -54, 
    -181, -129, -326, -143, 23, 5, 16, -2, -5, -5, -121, 67, 12, -23, -117, -41, 
    -96, -27, 42, 44, 72, 46, 162, -37, -4, 10, 20, 13, -77, -41, 79, -41, 
    -43, 18, -301, -19, 23, 5, 25, 3, -29, -20, 10, -0, 41, 34, 21, 92, 
    28, -47, -13, -23, -68, -170, 224, -359, 139, 172, 210, -577, -274, -156, 46, 303, 
    344, 223, 330, 40, 252, 239, -51, -151, -31, 41, 106, -314, -41, 73, -287, 321, 
    -373, -310, 517, 458, -58, -69, 288, -119, 17, 17, -95, -32, 19, -29, -309, 39, 
    -154, 32, 366, 106, 13, 27, 276, 129, -56, -46, -16, -19, -5, 22, 125, -218, 
    -7, -13, -53, 38, -91, -101, 3, 261, -93, 87, -66, 54, 10, -118, -66, -162, 
    -55, 6, 2, 55, -50, -6, 0, -66, 50, 20, -33, 51, 29, -3, 105, -1, 
    -29, -151, -19, 138, 0, 18, 33, 79, 8, -8, 23, -34, 7, 11, -22, -193, 
    16, -27, 17, -58, 12, 0, -28, 111, -16, -52, 13, 15, -35, 6, -26, 17, 
};

