// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from sensorpush.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.datapush {

  public class LogRow : ICloneable {
    public object Clone() {
      LogRow copy = new LogRow();
      copy.timestamp = this.timestamp;
      copy.records = this.records;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["timestamp"] = this.timestamp.Ticks;
      json["records"] = new JsonArray(this.records.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static LogRow Decode(LightJson.JsonObject json, Agent agent) {
      LogRow inst = new LogRow();
      inst.timestamp = new System.DateTime(json["timestamp"]);
      inst.records = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_2_1_6.Record>(json["records"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.Logger_2_1_6.Record.Decode(_value, agent)));
      return inst;
    }

    public System.DateTime timestamp = new System.DateTime(0);
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_2_1_6.Record> records = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_2_1_6.Record>();
  }
}
