% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{sass_options}
\alias{sass_options}
\alias{sass_options_get}
\alias{sass_options_set}
\title{Compiler Options for Sass}
\usage{
sass_options(
  precision = 5,
  output_style = "expanded",
  indented_syntax = FALSE,
  include_path = "",
  source_comments = FALSE,
  indent_type = "space",
  indent_width = 2,
  linefeed = "lf",
  output_path = "",
  source_map_file = "",
  source_map_root = "",
  source_map_embed = FALSE,
  source_map_contents = FALSE,
  omit_source_map_url = FALSE
)

sass_options_get(...)

sass_options_set(...)
}
\arguments{
\item{precision}{Number of decimal places.}

\item{output_style}{Bracketing and formatting style of the CSS output.
Possible styles: \code{"nested"}, \code{"expanded"}, \code{"compact"}, and
\code{"compressed"}.}

\item{indented_syntax}{Enables the compiler to parse Sass Indented Syntax in
strings. Note that the compiler automatically overrides this option to
\code{TRUE} or \code{FALSE} for files with .sass and .scss file extensions
respectively.}

\item{include_path}{Vector of paths used to resolve \verb{@import}. Multiple
paths are possible using a character vector of paths.}

\item{source_comments}{Annotates CSS output with line and file comments from
Sass file for debugging.}

\item{indent_type}{Specifies the indent type as \code{"space"} or
\code{"tab"}.}

\item{indent_width}{Number of tabs or spaces used for indentation. Maximum
10.}

\item{linefeed}{Specifies how new lines should be delimited. Possible values:
\code{"lf"}, \code{"cr"}, \code{"lfcr"}, and \code{"crlf"}.}

\item{output_path}{Specifies the location of the output file. Note: this
option will not write the file on disk. It is only for internal reference
with the source map.}

\item{source_map_file}{Specifies the location for Sass to write the source
map.}

\item{source_map_root}{Value will be included as source root in the source
map information.}

\item{source_map_embed}{Embeds the source map as a data URI.}

\item{source_map_contents}{Includes the contents in the source map
information.}

\item{omit_source_map_url}{Disable the inclusion of source map information in
the output file. Note: must specify \code{output_path} when \code{TRUE}.}

\item{...}{arguments to \code{\link[=sass_options]{sass_options()}}. For \code{sass_options_set()}, the
following values are also acceptable:
\itemize{
\item \code{NULL}, clearing the global options.
\item Return value of \code{sass_options_get()}.
\item Return value of \code{sass_options_set()}.
}}
}
\value{
List of Sass compiler options to be used with \code{\link[=sass]{sass()}}. For
\code{sass_options_set()}, any previously set global options are returned.
}
\description{
Specify compiler \code{options} for \code{\link[=sass]{sass()}}. To customize options, either provide
\code{sass_options()} directly to a \code{\link[=sass]{sass()}} call or set options globally via
\code{sass_options_set()}. When \code{shiny::devmode()} is enabled,
\code{sass_options_get()} defaults \code{source_map_embed} and \code{source_map_contents} to
\code{TRUE}.
}
\examples{

x <- "foo { margin: 122px * .001; }"
sass(x)

# Provide options directly to sass()
sass(x, options = sass_options(precision = 1, output_style = "compact"))

# Or set some option(s) globally
old_options <- sass_options_set(precision = 1)
sass(x)

# Specify local options  while also respecting global options
sass(x, options = sass_options_get(output_style = "compact"))

# Restore original state
sass_options_set(old_options)

}
